(ns ^:no-doc com.dmo-t.ipaddress.impl.constants
  (:require
   [clojure.math :as math]))

(def IPv4-ALL-ONES  (long (dec (math/pow 2 32))))

(def IPv4-PRIVATE-NETWORKS
  ["0.0.0.0/8"
   "10.0.0.0/8"
   "127.0.0.0/28"
   "169.254.0.0/16"
   "172.16.0.0/12"
   "192.0.0.0/24"
   "192.0.0.70/31"
   "192.0.2.0/24"
   "192.168.0.0/16"
   "198.18.0.0/15"
   "198.51.100.0/24"
   "203.0.113.0/24"
   "240.0.0.0/4"
   "255.255.255.255/32"])

(def IPv4-PRIVATE-NETWORKS-EXCEPTIONS
  ["192.0.0.9/32" "192.0.0.10/32"])

(def IPv4-RESERVED-NETWORK "240.0.0.0/4")
(def IPv4-UNSPECIFIED-ADDRESS "0.0.0.0")
(def IPv4-LINK-LOCAL-NETWORK "169.254.0.0/16")
(def IPv4-LOOPBACK-NETWORK "127.0.0.0/8")
(def IPv4-MULTICAST-NETWORK "224.0.0.0/4")
(def IPv4-PUBLIC-NETWORK "100.64.0.0/10")

(def IPv6-ALL-ONES "FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF")

(def IPv6-LINK-LOCAL-NETWORK "fe80::/10")
(def IPv6-MULTICAST-NETWORK "ff00::/8")
(def IPv6-PRIVATE-NETWORKS ["::1/128" "::/128" "::ffff:0:0/96"
                            "64:ff9b:1::/48" "100::/64" "2001::/23" "2001:db8::/32"
                            "2002::/16" "3fff::/20" "fc00::/7" "fe80::/10"])

(def IPv6-PRIVATE-NETWORKS-EXCEPTIONS ["2001:1::1/128" "2001:1::2/128" "2001:3::/32" "2001:4:112::/48" "2001:20::/28" "2001:30::/28"])
(def IPv6-RESERVED-NETWORKS  ["::/8" "100::/8" "200::/7" "400::/6" "800::/5"
                              "1000::/4" "4000::/3" "6000::/3" "8000::/3"
                              "A000::/3" "C000::/3" "E000::/4" "F000::/5" "F800::/6" "FE00::/9"])

(def IPv6-SITE-LOCAL-NETWORK "fec0::/10")

(def MAX_BITS {4 32
               6 128})

(comment
  IPv6-ALL-ONES
  (MAX_BITS 4)
  :rcf)