(ns com.dmo-t.ipaddress.impl.constants
  (:require
   [clojure.math.numeric-tower :as math]))

(def IPv4-ALL-ONES  (dec (math/expt 2 32)))

(def IPV4-PRIVATE-NETWORKS
  ["0.0.0.0/8"
   "10.0.0.0/8"
   "127.0.0.0/28"
   "169.254.0.0/16"
   "172.16.0.0/12"
   "192.0.0.0/24"
   "192.0.0.70/31"
   "192.0.2.0/24"
   "192.168.0.0/16"
   "198.18.0.0/15"
   "198.51.100.0/24"
   "203.0.113.0/24"
   "240.0.0.0/4"
   "255.255.255.255/32"])

(def PRIVATE-NETWORKS-EXCEPTIONS
  ["192.0.0.9/32" "192.0.0.10/32"])

(def RESERVED-NETWORK "240.0.0.0/4")
(def UNSPECIFIED-ADDRESS "0.0.0.0")
(def LINK-LOCAL-NETWORK "169.254.0.0/16")
(def LOOPBACK-NETWORK "127.0.0.0/8")
(def MULTICAST-NETWORK "224.0.0.0/4")
(def PUBLIC-NETWORK "100.64.0.0/10")