(ns com.dmo-t.ipaddress.impl.helpers
  (:require
   [clojure.spec.alpha :as spec]
   [clojure.string :as str]
   [com.dmo-t.ipaddress.impl.constants :as constants]
   [com.dmo-t.ipaddress.specs :as isp]))


(defn ipv4addr-str->int
  [ip]
  {:pre [(spec/valid? ::isp/ipv4-address-spec ip)]}
  (reduce (fn [acc v]
            (+ (bit-shift-left acc 8)  v)) (->> (str/split ip #"\.")
                                                (map parse-long))))

(defn int->ipv4addr-str
  [l]
  {:pre [(int? l)  (spec/valid? ::isp/ipv4-address-spec l)]}
  (loop [result '() remaining l count 0]
    (if (= 4 count)
      (str/join "." result)
      (recur (conj result (bit-and remaining 2r11111111))
             (bit-shift-right remaining 8)
             (inc count)))))

(comment
  (-> (ipv4addr-str->int "255.255.255.0"))

  constants/IPv4-ALL-ONES
  :rcf)


(defn v4-prefixlen->int [bl]
  {:pre [(spec/valid? ::isp/ipv4-prefixlen-spec bl)]}
  (let [bl (if (string? bl) (parse-long bl)  bl)]
    (reduce (fn [acc n]
              (bit-clear acc n)) constants/IPv4-ALL-ONES (range 0  (- 32 bl)))))

(comment
  (ipv4addr-str->int "255.255.255.253")
  (-> (v4-prefixlen->int 31)
      int->ipv4addr-str)
  :rcf)


(comment
  (spec/valid? :ipaddress/netmask-str-spec "255.255.128.0")
  (spec/valid? :ipaddress/netmask-str-spec "255.255.128.1")

  :rcf)

(defn netmask->hostmask
  [netmask]
  (->
   (.to-int netmask)
   Long/toBinaryString
   (str/replace "1" "")
   (str/replace "0" "1")
   (Long/parseUnsignedLong 2)))


(comment
  (-> (ipv4addr-str->int "255.255.255.0")
      netmask->hostmask
      int->ipv4addr-str)
  :rcf)

(comment
  (Long/parseUnsignedLong "1111" 2)
  :rcf)