/*
 * Decompiled with CFR 0.152.
 */
package com.dkdhub.mqtt_broker;

import com.dkdhub.mqtt_broker.IBroker;
import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.interception.InterceptHandler;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedBroker
implements IBroker {
    final Server m_server;
    final IConfig m_config;
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedBroker.class);

    public AdvancedBroker(Properties properties) {
        LOG.info("Constructing MQTT Broker with configuration {}", (Object)properties);
        this.m_config = new MemoryConfig(properties);
        this.m_server = new Server();
        LOG.info("MQTT Broker instance created");
    }

    public void start() throws IOException {
        this.m_server.startServer(this.m_config);
        LOG.info("MQTT Broker started with no interceptors enabled");
    }

    @Override
    public void start(InterceptHandler interceptHandler) throws IOException {
        this.m_server.startServer(this.m_config);
        this.m_server.addInterceptHandler(interceptHandler);
        LOG.info("MQTT Broker started with interceptor ID {}", (Object)interceptHandler.getID());
    }

    public void start(List<? extends InterceptHandler> list) throws IOException {
        this.m_server.startServer(this.m_config, list);
        LOG.info("MQTT Broker started with interceptor IDs {}", (Object)Arrays.toString(list.stream().map(InterceptHandler::getID).toArray()));
    }

    @Override
    public void stop() {
        LOG.info("Stopping MQTT Broker");
        this.m_server.stopServer();
        LOG.info("MQTT Broker stopped");
    }

    @Override
    public void send(String string, String string2, byte[] byArray, MqttQoS mqttQoS, Boolean bl) {
        MqttPublishMessage mqttPublishMessage = MqttMessageBuilders.publish().topicName(string2).retained(bl.booleanValue()).qos(mqttQoS).payload(Unpooled.copiedBuffer((byte[])byArray)).build();
        LOG.debug("Sending message {} from {} to {} with {} and {}", new Object[]{new String(byArray), string, string2, mqttQoS, bl});
        this.m_server.internalPublish(mqttPublishMessage, string);
    }

    public List<Map<String, ? extends Serializable>> clients() {
        try {
            return this.m_server.listConnectedClients().parallelStream().map(clientDescriptor -> Map.of("id", clientDescriptor.getClientID(), "address", clientDescriptor.getAddress(), "port", clientDescriptor.getPort())).collect(Collectors.toUnmodifiableList());
        }
        catch (IllegalStateException illegalStateException) {
            LOG.warn(illegalStateException.getLocalizedMessage());
            return null;
        }
        catch (NullPointerException nullPointerException) {
            LOG.error(nullPointerException.getLocalizedMessage());
            return List.of();
        }
    }

    public boolean disconnect(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        LOG.debug("Will disconnect client {}, flush state: {}", (Object)string, (Object)bl);
        boolean bl2 = bl ? this.m_server.disconnectClient(string) : this.m_server.disconnectAndPurgeClientState(string);
        LOG.debug("Disconnect result: {}", (Object)bl2);
        return bl2;
    }
}

