/*
 * Decompiled with CFR 0.152.
 */
package com.dkdhub.mqtt_broker;

import com.dkdhub.mqtt_broker.IBroker;
import io.moquette.broker.Server;
import io.moquette.broker.config.ClasspathResourceLoader;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.IResourceLoader;
import io.moquette.broker.config.ResourceLoaderConfig;
import io.moquette.interception.InterceptHandler;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBroker
implements IBroker {
    final Server mqttBroker = new Server();
    final IConfig classPathConfig;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBroker.class);

    public SimpleBroker(String string) {
        ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader();
        this.classPathConfig = new ResourceLoaderConfig((IResourceLoader)classpathResourceLoader, string);
    }

    @Override
    public void start(InterceptHandler interceptHandler) throws IOException {
        this.mqttBroker.startServer(this.classPathConfig);
        this.mqttBroker.addInterceptHandler(interceptHandler);
        LOG.info("SimpleBroker started. Class Path config = {}.", (Object)this.classPathConfig);
    }

    @Override
    public void stop() {
        LOG.info("Stopping SimpleBroker");
        this.mqttBroker.stopServer();
        LOG.info("SimpleBroker stopped");
    }

    @Override
    public void send(String string, String string2, byte[] byArray, MqttQoS mqttQoS, Boolean bl) {
        MqttPublishMessage mqttPublishMessage = MqttMessageBuilders.publish().topicName(string2).retained(bl.booleanValue()).qos(mqttQoS).payload(Unpooled.copiedBuffer((byte[])byArray)).build();
        LOG.debug("Sending message {} from {} to {} with {} and {}", new Object[]{new String(byArray), string, string2, mqttQoS, bl});
        this.mqttBroker.internalPublish(mqttPublishMessage, string);
    }
}

