(defproject com.dentmetria/universe "0.1.0-SNAPSHOT"
  :description "Distributed atom."
  :url "http://dentmetria.com"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}

  :dependencies [[org.clojure/clojure "1.11.1"]
                 [com.impossibl.pgjdbc-ng/pgjdbc-ng "0.8.9"]
                 [com.github.seancorfield/next.jdbc "1.3.939"]
                 [com.github.seancorfield/honeysql "2.6.1126"]
                 [commons-io/commons-io "2.16.1"]
                 [com.taoensso/nippy "3.4.1"]]
  :repl-options {:init-ns dentmetria.universe}
  :aot [dentmetria.universe]

  :profiles {:dev  {:dependencies [[com.zaxxer/HikariCP "5.1.0"]]}
             :test {:dependencies [[com.zaxxer/HikariCP "5.1.0"]
                                   [io.zonky.test/embedded-postgres "2.0.6"]
                                   [io.zonky.test.postgres/embedded-postgres-binaries-darwin-amd64 "16.2.0"]
                                   [io.zonky.test.postgres/embedded-postgres-binaries-linux-amd64 "16.2.0"]
                                   [io.zonky.test.postgres/embedded-postgres-binaries-windows-amd64 "16.2.0"]]}}

  :deploy-repositories [["releases"  {:sign-releases false :url "https://clojars.org/repo"}]
                        ["snapshots" {:sign-releases false :url "https://clojars.org/repo"}]])
