// Compiled by ClojureScript 1.9.946 {}
goog.provide('sodium.core');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('re_frame.loggers');
goog.require('soda_ash.core');
goog.require('iron.re_utils');
goog.require('iron.utils');
goog.require('sodium.utils');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("sodium","size","sodium/size",352697062),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null,new cljs.core.Keyword(null,"tiny","tiny",1577883515),null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null,new cljs.core.Keyword(null,"tiny","tiny",1577883515),null], null), null));
/**
 * A bit hackish, but I think this is enough to get the useful value
 *   from any Semantic-UI-React element.
 */
sodium.core.value = (function sodium$core$value(_dom_event,data){
return cljs.core.js__GT_clj.call(null,(function (){var or__8782__auto__ = data.value;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return data.checked;
}
})());
});
/**
 * Return a function that will collect the value from a
 *   react-semantic-ui dom event and pass it to a re-frame event
 */
sodium.core.value__GT_event_fn = (function sodium$core$value__GT_event_fn(var_args){
var G__13969 = arguments.length;
switch (G__13969) {
case 1:
return sodium.core.value__GT_event_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sodium.core.value__GT_event_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sodium.core.value__GT_event_fn.cljs$core$IFn$_invoke$arity$1 = (function (event){
return sodium.core.value__GT_event_fn.call(null,event,cljs.core.PersistentArrayMap.EMPTY);
});

sodium.core.value__GT_event_fn.cljs$core$IFn$_invoke$arity$2 = (function (event,p__13970){
var map__13971 = p__13970;
var map__13971__$1 = ((((!((map__13971 == null)))?((((map__13971.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13971.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13971):map__13971);
var _GT_evt_params = map__13971__$1;
var default$ = cljs.core.get.call(null,map__13971__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var coercer = cljs.core.get.call(null,map__13971__$1,new cljs.core.Keyword(null,"coercer","coercer",1871193355));
return ((function (map__13971,map__13971__$1,_GT_evt_params,default$,coercer){
return (function (dom_event,data){
return iron.re_utils._GT_evt.call(null,event,sodium.core.value.call(null,dom_event,data),_GT_evt_params);
});
;})(map__13971,map__13971__$1,_GT_evt_params,default$,coercer))
});

sodium.core.value__GT_event_fn.cljs$lang$maxFixedArity = 2;

/**
 * Return a function that will collect the value from a
 *   react-semantic-ui dom event and pass it into an atom
 */
sodium.core.value__GT_atom_fn = (function sodium$core$value__GT_atom_fn(var_args){
var G__13975 = arguments.length;
switch (G__13975) {
case 1:
return sodium.core.value__GT_atom_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sodium.core.value__GT_atom_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sodium.core.value__GT_atom_fn.cljs$core$IFn$_invoke$arity$1 = (function (atom){
return sodium.core.value__GT_atom_fn.call(null,atom,cljs.core.PersistentArrayMap.EMPTY);
});

sodium.core.value__GT_atom_fn.cljs$core$IFn$_invoke$arity$2 = (function (atom,p__13976){
var map__13977 = p__13976;
var map__13977__$1 = ((((!((map__13977 == null)))?((((map__13977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13977.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13977):map__13977);
var default$ = cljs.core.get.call(null,map__13977__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var coercer = cljs.core.get.call(null,map__13977__$1,new cljs.core.Keyword(null,"coercer","coercer",1871193355),cljs.core.identity);
var assoc_path = cljs.core.get.call(null,map__13977__$1,new cljs.core.Keyword(null,"assoc-path","assoc-path",369211482));
return ((function (map__13977,map__13977__$1,default$,coercer,assoc_path){
return (function (dom_event,data){
var raw_value = sodium.core.value.call(null,dom_event,data);
var value = coercer.call(null,(cljs.core.truth_(iron.utils.negligible_QMARK_.call(null,raw_value))?default$:raw_value));
if(cljs.core.truth_(assoc_path)){
cljs.core.swap_BANG_.call(null,atom,cljs.core.assoc_in,assoc_path,value);
} else {
cljs.core.reset_BANG_.call(null,atom,value);
}

return null;
});
;})(map__13977,map__13977__$1,default$,coercer,assoc_path))
});

sodium.core.value__GT_atom_fn.cljs$lang$maxFixedArity = 2;

/**
 * Convert value and text info format suitable for a React list element
 *   for Dropdown or Select lists.
 */
sodium.core.list_option = (function sodium$core$list_option(value,text){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"key","key",-1516042587),value,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"text","text",-1790561697),text], null);
});
/**
 * Generate a list suitable for a Dropdown or Select list of options.
 *   Items is the raw list, while value-n and text-fn extract value and
 *   text from each element.
 */
sodium.core.dropdown_list = (function sodium$core$dropdown_list(items,value_fn,text_fn){
return cljs.core.mapv.call(null,(function (item){
return sodium.core.list_option.call(null,value_fn.call(null,item),text_fn.call(null,item));
}),items);
});
sodium.core.advertisement = (function sodium$core$advertisement(var_args){
var args__10068__auto__ = [];
var len__10061__auto___13985 = arguments.length;
var i__10062__auto___13986 = (0);
while(true){
if((i__10062__auto___13986 < len__10061__auto___13985)){
args__10068__auto__.push((arguments[i__10062__auto___13986]));

var G__13987 = (i__10062__auto___13986 + (1));
i__10062__auto___13986 = G__13987;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.advertisement.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.advertisement.cljs$core$IFn$_invoke$arity$variadic = (function (p__13982,body__10289__auto__){
var map__13983 = p__13982;
var map__13983__$1 = ((((!((map__13983 == null)))?((((map__13983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13983.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13983):map__13983);
var params__10288__auto__ = map__13983__$1;
var test = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"test","test",577538877));
var children = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var unit = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"unit","unit",375175175));
var as = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var centered_QMARK_ = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var id = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"unit","unit",375175175),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"test","test",577538877),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :unit :as :on-click :style :centered? :id :class-name :test})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Advertisement,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.advertisement.cljs$lang$maxFixedArity = (1);

sodium.core.advertisement.cljs$lang$applyTo = (function (seq13980){
var G__13981 = cljs.core.first.call(null,seq13980);
var seq13980__$1 = cljs.core.next.call(null,seq13980);
return sodium.core.advertisement.cljs$core$IFn$_invoke$arity$variadic(G__13981,seq13980__$1);
});

sodium.core.checkbox = (function sodium$core$checkbox(var_args){
var args__10068__auto__ = [];
var len__10061__auto___13993 = arguments.length;
var i__10062__auto___13994 = (0);
while(true){
if((i__10062__auto___13994 < len__10061__auto___13993)){
args__10068__auto__.push((arguments[i__10062__auto___13994]));

var G__13995 = (i__10062__auto___13994 + (1));
i__10062__auto___13994 = G__13995;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (p__13990,body__10289__auto__){
var map__13991 = p__13990;
var map__13991__$1 = ((((!((map__13991 == null)))?((((map__13991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13991.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13991):map__13991);
var params__10288__auto__ = map__13991__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var default_indeterminate_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"default-indeterminate?","default-indeterminate?",654011935));
var slider = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"slider","slider",-472668865));
var tab_index = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var indeterminate_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"indeterminate?","indeterminate?",-1382048766));
var checked_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
var key = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var radio = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"radio","radio",1323726374));
var value = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"value","value",305978217));
var name = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var as = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var type = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var toggle = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"toggle","toggle",1291842030));
var on_mouse_down = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470));
var on_click = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var label = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var fitted_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243));
var read_only_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"read-only?","read-only?",-770285386));
var class_name = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var default_checked_QMARK_ = cljs.core.get.call(null,map__13991__$1,new cljs.core.Keyword(null,"default-checked?","default-checked?",1949214712));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 24, [new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"indeterminate?","indeterminate?",-1382048766),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"checked?","checked?",2024809091),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"radio","radio",1323726374),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"toggle","toggle",1291842030),null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243),null,new cljs.core.Keyword(null,"read-only?","read-only?",-770285386),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"default-checked?","default-checked?",1949214712),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"slider","slider",-472668865),null,new cljs.core.Keyword(null,"default-indeterminate?","default-indeterminate?",654011935),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:tab-index :indeterminate? :children :checked? :key :radio :name :as :value :type :toggle :on-mouse-down :on-click :style :label :id :fitted? :read-only? :class-name :default-checked? :on-change :disabled? :slider :default-indeterminate?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Checkbox,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.checkbox.cljs$lang$maxFixedArity = (1);

sodium.core.checkbox.cljs$lang$applyTo = (function (seq13988){
var G__13989 = cljs.core.first.call(null,seq13988);
var seq13988__$1 = cljs.core.next.call(null,seq13988);
return sodium.core.checkbox.cljs$core$IFn$_invoke$arity$variadic(G__13989,seq13988__$1);
});

sodium.core.container = (function sodium$core$container(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14001 = arguments.length;
var i__10062__auto___14002 = (0);
while(true){
if((i__10062__auto___14002 < len__10061__auto___14001)){
args__10068__auto__.push((arguments[i__10062__auto___14002]));

var G__14003 = (i__10062__auto___14002 + (1));
i__10062__auto___14002 = G__14003;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.container.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.container.cljs$core$IFn$_invoke$arity$variadic = (function (p__13998,body__10289__auto__){
var map__13999 = p__13998;
var map__13999__$1 = ((((!((map__13999 == null)))?((((map__13999.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13999.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13999):map__13999);
var params__10288__auto__ = map__13999__$1;
var fluid_QMARK_ = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var text_QMARK_ = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"text?","text?",-934411583));
var children = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var text_align = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var as = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__13999__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"text?","text?",-934411583),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:text? :children :text-align :key :as :on-click :style :id :class-name :fluid?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Container,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.container.cljs$lang$maxFixedArity = (1);

sodium.core.container.cljs$lang$applyTo = (function (seq13996){
var G__13997 = cljs.core.first.call(null,seq13996);
var seq13996__$1 = cljs.core.next.call(null,seq13996);
return sodium.core.container.cljs$core$IFn$_invoke$arity$variadic(G__13997,seq13996__$1);
});

sodium.core.dropdown = (function sodium$core$dropdown(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14009 = arguments.length;
var i__10062__auto___14010 = (0);
while(true){
if((i__10062__auto___14010 < len__10061__auto___14009)){
args__10068__auto__.push((arguments[i__10062__auto___14010]));

var G__14011 = (i__10062__auto___14010 + (1));
i__10062__auto___14010 = G__14011;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.dropdown.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.dropdown.cljs$core$IFn$_invoke$arity$variadic = (function (p__14006,body__10289__auto__){
var map__14007 = p__14006;
var map__14007__$1 = ((((!((map__14007 == null)))?((((map__14007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14007.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14007):map__14007);
var params__10288__auto__ = map__14007__$1;
var on_search_change = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351));
var options = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"options","options",99638489));
var error_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var placehoder = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"placehoder","placehoder",1840553690));
var disabled_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var selection = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"selection","selection",975998651));
var trigger = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"trigger","trigger",103466139));
var on_change = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var addition_label = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"addition-label","addition-label",-856529348));
var button_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"button?","button?",-1099897092));
var on_open = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-open","on-open",-1391088163));
var scrolling_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499));
var test = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"test","test",577538877));
var open_on_focus_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"open-on-focus?","open-on-focus?",1405372990));
var fluid_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var default_selected_label = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"default-selected-label","default-selected-label",-1690769250));
var on_label_click = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-label-click","on-label-click",-706744384));
var on_add_item = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-add-item","on-add-item",-1647898400));
var close_on_blur_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"close-on-blur?","close-on-blur?",1411001664));
var selected_label = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"selected-label","selected-label",-902280703));
var tab_index = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var pointing = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"pointing","pointing",-1869969692));
var upward_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"upward?","upward?",1016884292));
var key = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var addition_position = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"addition-position","addition-position",-127742747));
var on_close = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-close","on-close",-761178394));
var allow_additions = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"allow-additions","allow-additions",437152424));
var on_focus = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624));
var floating_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"floating?","floating?",509059561));
var close_on_change_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"close-on-change?","close-on-change?",-530623799));
var value = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"value","value",305978217));
var loading_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var on_blur = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var search_input = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"search-input","search-input",-576916149));
var no_results_message = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660));
var icon = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var search = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"search","search",1564939822));
var header = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"header","header",119441134));
var on_mouse_down = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470));
var render_label = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"render-label","render-label",634900559));
var on_click = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var labeled_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"labeled?","labeled?",-92627440));
var style = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var item_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"item?","item?",1224206865));
var inline_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var compact_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var min_characters = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908));
var id = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var open_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"open?","open?",1238443125));
var multiple_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"multiple?","multiple?",-490002283));
var select_on_blur = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"select-on-blur","select-on-blur",500299062));
var simple_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"simple?","simple?",1381678616));
var default_open_QMARK_ = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144));
var class_name = cljs.core.get.call(null,map__14007__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 58, [new cljs.core.Keyword(null,"on-add-item","on-add-item",-1647898400),null,new cljs.core.Keyword(null,"close-on-blur?","close-on-blur?",1411001664),null,new cljs.core.Keyword(null,"on-label-click","on-label-click",-706744384),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"selected-label","selected-label",-902280703),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"upward?","upward?",1016884292),null,new cljs.core.Keyword(null,"pointing","pointing",-1869969692),null,new cljs.core.Keyword(null,"addition-position","addition-position",-127742747),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-close","on-close",-761178394),null,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624),null,new cljs.core.Keyword(null,"allow-additions","allow-additions",437152424),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"floating?","floating?",509059561),null,new cljs.core.Keyword(null,"close-on-change?","close-on-change?",-530623799),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"search-input","search-input",-576916149),null,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),null,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"search","search",1564939822),null,new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"render-label","render-label",634900559),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"labeled?","labeled?",-92627440),null,new cljs.core.Keyword(null,"item?","item?",1224206865),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"open?","open?",1238443125),null,new cljs.core.Keyword(null,"multiple?","multiple?",-490002283),null,new cljs.core.Keyword(null,"select-on-blur","select-on-blur",500299062),null,new cljs.core.Keyword(null,"simple?","simple?",1381678616),null,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351),null,new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"placehoder","placehoder",1840553690),null,new cljs.core.Keyword(null,"trigger","trigger",103466139),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"selection","selection",975998651),null,new cljs.core.Keyword(null,"addition-label","addition-label",-856529348),null,new cljs.core.Keyword(null,"button?","button?",-1099897092),null,new cljs.core.Keyword(null,"on-open","on-open",-1391088163),null,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499),null,new cljs.core.Keyword(null,"test","test",577538877),null,new cljs.core.Keyword(null,"default-selected-label","default-selected-label",-1690769250),null,new cljs.core.Keyword(null,"open-on-focus?","open-on-focus?",1405372990),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:on-add-item :close-on-blur? :on-label-click :tab-index :selected-label :children :upward? :pointing :addition-position :key :on-close :on-focus :allow-additions :loading? :as :floating? :close-on-change? :value :default-value :search-input :on-blur :no-results-message :basic? :icon :search :header :on-mouse-down :render-label :on-click :style :labeled? :item? :inline? :compact? :min-characters :id :open? :multiple? :select-on-blur :simple? :default-open? :class-name :on-search-change :options :error? :placehoder :trigger :on-change :disabled? :selection :addition-label :button? :on-open :scrolling? :test :default-selected-label :open-on-focus? :fluid?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Dropdown,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.dropdown.cljs$lang$maxFixedArity = (1);

sodium.core.dropdown.cljs$lang$applyTo = (function (seq14004){
var G__14005 = cljs.core.first.call(null,seq14004);
var seq14004__$1 = cljs.core.next.call(null,seq14004);
return sodium.core.dropdown.cljs$core$IFn$_invoke$arity$variadic(G__14005,seq14004__$1);
});

sodium.core.divider = (function sodium$core$divider(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14017 = arguments.length;
var i__10062__auto___14018 = (0);
while(true){
if((i__10062__auto___14018 < len__10061__auto___14017)){
args__10068__auto__.push((arguments[i__10062__auto___14018]));

var G__14019 = (i__10062__auto___14018 + (1));
i__10062__auto___14018 = G__14019;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.divider.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.divider.cljs$core$IFn$_invoke$arity$variadic = (function (p__14014,body__10289__auto__){
var map__14015 = p__14014;
var map__14015__$1 = ((((!((map__14015 == null)))?((((map__14015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14015.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14015):map__14015);
var params__10288__auto__ = map__14015__$1;
var inverted_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var horizontal_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var clearing_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270));
var id = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vertical_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444));
var hidden_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"hidden?","hidden?",1339691380));
var fitted_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243));
var class_name = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var section_QMARK_ = cljs.core.get.call(null,map__14015__$1,new cljs.core.Keyword(null,"section?","section?",-608017256));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270),null,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444),null,new cljs.core.Keyword(null,"hidden?","hidden?",1339691380),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243),null,new cljs.core.Keyword(null,"section?","section?",-608017256),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :horizontal? :children :key :as :on-click :style :clearing? :vertical? :hidden? :id :fitted? :section? :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Divider,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.divider.cljs$lang$maxFixedArity = (1);

sodium.core.divider.cljs$lang$applyTo = (function (seq14012){
var G__14013 = cljs.core.first.call(null,seq14012);
var seq14012__$1 = cljs.core.next.call(null,seq14012);
return sodium.core.divider.cljs$core$IFn$_invoke$arity$variadic(G__14013,seq14012__$1);
});

sodium.core.form = (function sodium$core$form(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14025 = arguments.length;
var i__10062__auto___14026 = (0);
while(true){
if((i__10062__auto___14026 < len__10061__auto___14025)){
args__10068__auto__.push((arguments[i__10062__auto___14026]));

var G__14027 = (i__10062__auto___14026 + (1));
i__10062__auto___14026 = G__14027;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.form.cljs$core$IFn$_invoke$arity$variadic = (function (p__14022,body__10289__auto__){
var map__14023 = p__14022;
var map__14023__$1 = ((((!((map__14023 == null)))?((((map__14023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14023.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14023):map__14023);
var params__10288__auto__ = map__14023__$1;
var error_QMARK_ = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var success_QMARK_ = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"success?","success?",-122854052));
var inverted_QMARK_ = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var loading_QMARK_ = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var reply_QMARK_ = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"reply?","reply?",126773098));
var warning_QMARK_ = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"warning?","warning?",-1789142517));
var on_click = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var widths = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"widths","widths",-1467327440));
var style = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var on_submit = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
var class_name = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__14023__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"reply?","reply?",126773098),null,new cljs.core.Keyword(null,"warning?","warning?",-1789142517),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"widths","widths",-1467327440),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"success?","success?",-122854052),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :children :key :loading? :as :reply? :warning? :on-click :size :widths :style :id :on-submit :action :class-name :error? :success?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Form,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.form.cljs$lang$maxFixedArity = (1);

sodium.core.form.cljs$lang$applyTo = (function (seq14020){
var G__14021 = cljs.core.first.call(null,seq14020);
var seq14020__$1 = cljs.core.next.call(null,seq14020);
return sodium.core.form.cljs$core$IFn$_invoke$arity$variadic(G__14021,seq14020__$1);
});

sodium.core.form_input = (function sodium$core$form_input(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14033 = arguments.length;
var i__10062__auto___14034 = (0);
while(true){
if((i__10062__auto___14034 < len__10061__auto___14033)){
args__10068__auto__.push((arguments[i__10062__auto___14034]));

var G__14035 = (i__10062__auto___14034 + (1));
i__10062__auto___14034 = G__14035;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.form_input.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.form_input.cljs$core$IFn$_invoke$arity$variadic = (function (p__14030,body__10289__auto__){
var map__14031 = p__14030;
var map__14031__$1 = ((((!((map__14031 == null)))?((((map__14031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14031.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14031):map__14031);
var params__10288__auto__ = map__14031__$1;
var input = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"input","input",556931961));
var action_position = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"action-position","action-position",-704217959));
var error_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var disabled_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var step = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var fluid_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var tab_index = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var key = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var placeholder = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var icon_position = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034));
var focus_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"focus?","focus?",-3018488));
var value = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var width = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var transparent_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548));
var type = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var list = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"list","list",765357683));
var loading = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"loading","loading",-737050189));
var label = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var class_name = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),null,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034),null,new cljs.core.Keyword(null,"focus?","focus?",-3018488),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"action-position","action-position",-704217959),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"step","step",1288888124),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :tab-index :required? :children :key :placeholder :icon-position :focus? :as :value :default-value :width :transparent? :type :icon :on-click :size :style :inline? :loading :list :label :id :control :action :class-name :action-position :error? :input :on-change :disabled? :step :fluid? :label-position})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.FormInput,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.form_input.cljs$lang$maxFixedArity = (1);

sodium.core.form_input.cljs$lang$applyTo = (function (seq14028){
var G__14029 = cljs.core.first.call(null,seq14028);
var seq14028__$1 = cljs.core.next.call(null,seq14028);
return sodium.core.form_input.cljs$core$IFn$_invoke$arity$variadic(G__14029,seq14028__$1);
});

sodium.core.form_group = (function sodium$core$form_group(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14041 = arguments.length;
var i__10062__auto___14042 = (0);
while(true){
if((i__10062__auto___14042 < len__10061__auto___14041)){
args__10068__auto__.push((arguments[i__10062__auto___14042]));

var G__14043 = (i__10062__auto___14042 + (1));
i__10062__auto___14042 = G__14043;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.form_group.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.form_group.cljs$core$IFn$_invoke$arity$variadic = (function (p__14038,body__10289__auto__){
var map__14039 = p__14038;
var map__14039__$1 = ((((!((map__14039 == null)))?((((map__14039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14039.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14039):map__14039);
var params__10288__auto__ = map__14039__$1;
var inline = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"inline","inline",1399884222));
var children = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var grouped = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"grouped","grouped",15624546));
var key = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var widths = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"widths","widths",-1467327440));
var style = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"grouped","grouped",15624546),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"widths","widths",-1467327440),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"inline","inline",1399884222),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:grouped :children :key :as :on-click :widths :style :id :class-name :inline})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.FormGroup,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.form_group.cljs$lang$maxFixedArity = (1);

sodium.core.form_group.cljs$lang$applyTo = (function (seq14036){
var G__14037 = cljs.core.first.call(null,seq14036);
var seq14036__$1 = cljs.core.next.call(null,seq14036);
return sodium.core.form_group.cljs$core$IFn$_invoke$arity$variadic(G__14037,seq14036__$1);
});

sodium.core.grid = (function sodium$core$grid(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14049 = arguments.length;
var i__10062__auto___14050 = (0);
while(true){
if((i__10062__auto___14050 < len__10061__auto___14049)){
args__10068__auto__.push((arguments[i__10062__auto___14050]));

var G__14051 = (i__10062__auto___14050 + (1));
i__10062__auto___14050 = G__14051;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.grid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.grid.cljs$core$IFn$_invoke$arity$variadic = (function (p__14046,body__10289__auto__){
var map__14047 = p__14046;
var map__14047__$1 = ((((!((map__14047 == null)))?((((map__14047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14047.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14047):map__14047);
var params__10288__auto__ = map__14047__$1;
var doubling_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"doubling?","doubling?",-2028386054));
var divided_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"divided?","divided?",-706929476));
var relaxed = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907));
var divided = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"divided","divided",727855229));
var reversed = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"reversed","reversed",-286659968));
var inverted_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var stretched_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910));
var stackable_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005));
var celled = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"celled","celled",-1969088093));
var key = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var text_align = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var vertical_align = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var columns = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"columns","columns",1998437288));
var as = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var centered_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var id = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var celled_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"celled?","celled?",-266703115));
var padded = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"padded","padded",1434297910));
var container_QMARK_ = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"container?","container?",-1563620041));
var class_name = cljs.core.get.call(null,map__14047__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 23, [new cljs.core.Keyword(null,"reversed","reversed",-286659968),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005),null,new cljs.core.Keyword(null,"celled","celled",-1969088093),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"columns","columns",1998437288),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"celled?","celled?",-266703115),null,new cljs.core.Keyword(null,"padded","padded",1434297910),null,new cljs.core.Keyword(null,"container?","container?",-1563620041),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"doubling?","doubling?",-2028386054),null,new cljs.core.Keyword(null,"divided?","divided?",-706929476),null,new cljs.core.Keyword(null,"divided","divided",727855229),null,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:reversed :inverted? :stretched? :children :stackable? :celled :text-align :vertical-align :key :columns :as :on-click :style :centered? :id :celled? :padded :container? :class-name :doubling? :divided? :divided :relaxed})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Grid,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.grid.cljs$lang$maxFixedArity = (1);

sodium.core.grid.cljs$lang$applyTo = (function (seq14044){
var G__14045 = cljs.core.first.call(null,seq14044);
var seq14044__$1 = cljs.core.next.call(null,seq14044);
return sodium.core.grid.cljs$core$IFn$_invoke$arity$variadic(G__14045,seq14044__$1);
});

sodium.core.grid_column = (function sodium$core$grid_column(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14057 = arguments.length;
var i__10062__auto___14058 = (0);
while(true){
if((i__10062__auto___14058 < len__10061__auto___14057)){
args__10068__auto__.push((arguments[i__10062__auto___14058]));

var G__14059 = (i__10062__auto___14058 + (1));
i__10062__auto___14058 = G__14059;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.grid_column.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.grid_column.cljs$core$IFn$_invoke$arity$variadic = (function (p__14054,body__10289__auto__){
var map__14055 = p__14054;
var map__14055__$1 = ((((!((map__14055 == null)))?((((map__14055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14055.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14055):map__14055);
var params__10288__auto__ = map__14055__$1;
var mobile = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"mobile","mobile",1403078170));
var wide_screen = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"wide-screen","wide-screen",-1538015237));
var large_screen = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"large-screen","large-screen",1669396892));
var tablet = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"tablet","tablet",-318585919));
var children = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var stretched_QMARK_ = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910));
var only = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var key = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var color = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var vertical_align = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var computer = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"computer","computer",-1035300443));
var as = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var width = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var on_click = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var floated = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14055__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Keyword(null,"tablet","tablet",-318585919),null,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"only","only",1907811652),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"computer","computer",-1035300443),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"mobile","mobile",1403078170),null,new cljs.core.Keyword(null,"wide-screen","wide-screen",-1538015237),null,new cljs.core.Keyword(null,"large-screen","large-screen",1669396892),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:tablet :stretched? :children :only :color :text-align :vertical-align :computer :key :as :width :on-click :style :floated :id :class-name :mobile :wide-screen :large-screen})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.GridColumn,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.grid_column.cljs$lang$maxFixedArity = (1);

sodium.core.grid_column.cljs$lang$applyTo = (function (seq14052){
var G__14053 = cljs.core.first.call(null,seq14052);
var seq14052__$1 = cljs.core.next.call(null,seq14052);
return sodium.core.grid_column.cljs$core$IFn$_invoke$arity$variadic(G__14053,seq14052__$1);
});

sodium.core.grid_row = (function sodium$core$grid_row(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14065 = arguments.length;
var i__10062__auto___14066 = (0);
while(true){
if((i__10062__auto___14066 < len__10061__auto___14065)){
args__10068__auto__.push((arguments[i__10062__auto___14066]));

var G__14067 = (i__10062__auto___14066 + (1));
i__10062__auto___14066 = G__14067;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.grid_row.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.grid_row.cljs$core$IFn$_invoke$arity$variadic = (function (p__14062,body__10289__auto__){
var map__14063 = p__14062;
var map__14063__$1 = ((((!((map__14063 == null)))?((((map__14063.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14063.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14063):map__14063);
var params__10288__auto__ = map__14063__$1;
var divided_QMARK_ = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"divided?","divided?",-706929476));
var reversed = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"reversed","reversed",-286659968));
var children = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var stretched_QMARK_ = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910));
var only = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var key = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var color = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var vertical_align = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var columns = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"columns","columns",1998437288));
var as = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var centered_QMARK_ = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var id = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14063__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [new cljs.core.Keyword(null,"reversed","reversed",-286659968),null,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"only","only",1907811652),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"columns","columns",1998437288),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"divided?","divided?",-706929476),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:reversed :stretched? :children :only :color :text-align :vertical-align :key :columns :as :on-click :style :centered? :id :class-name :divided?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.GridRow,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.grid_row.cljs$lang$maxFixedArity = (1);

sodium.core.grid_row.cljs$lang$applyTo = (function (seq14060){
var G__14061 = cljs.core.first.call(null,seq14060);
var seq14060__$1 = cljs.core.next.call(null,seq14060);
return sodium.core.grid_row.cljs$core$IFn$_invoke$arity$variadic(G__14061,seq14060__$1);
});

sodium.core.header = (function sodium$core$header(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14073 = arguments.length;
var i__10062__auto___14074 = (0);
while(true){
if((i__10062__auto___14074 < len__10061__auto___14073)){
args__10068__auto__.push((arguments[i__10062__auto___14074]));

var G__14075 = (i__10062__auto___14074 + (1));
i__10062__auto___14074 = G__14075;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.header.cljs$core$IFn$_invoke$arity$variadic = (function (p__14070,body__10289__auto__){
var map__14071 = p__14070;
var map__14071__$1 = ((((!((map__14071 == null)))?((((map__14071.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14071.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14071):map__14071);
var params__10288__auto__ = map__14071__$1;
var attached = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var subheader = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"subheader","subheader",-1028810273));
var inverted_QMARK_ = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var color = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var dividing_QMARK_ = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650));
var content = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var sub_QMARK_ = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"sub?","sub?",768712042));
var icon = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var block_QMARK_ = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"block?","block?",1102479923));
var floated = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image = cljs.core.get.call(null,map__14071__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"sub?","sub?",768712042),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"block?","block?",1102479923),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"image","image",-58725096),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"subheader","subheader",-1028810273),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :children :color :text-align :key :dividing? :content :as :sub? :icon :on-click :size :style :floated :block? :id :image :class-name :attached :subheader})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Header,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.header.cljs$lang$maxFixedArity = (1);

sodium.core.header.cljs$lang$applyTo = (function (seq14068){
var G__14069 = cljs.core.first.call(null,seq14068);
var seq14068__$1 = cljs.core.next.call(null,seq14068);
return sodium.core.header.cljs$core$IFn$_invoke$arity$variadic(G__14069,seq14068__$1);
});

sodium.core.image = (function sodium$core$image(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14081 = arguments.length;
var i__10062__auto___14082 = (0);
while(true){
if((i__10062__auto___14082 < len__10061__auto___14081)){
args__10068__auto__.push((arguments[i__10062__auto___14082]));

var G__14083 = (i__10062__auto___14082 + (1));
i__10062__auto___14082 = G__14083;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.image.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.image.cljs$core$IFn$_invoke$arity$variadic = (function (p__14078,body__10289__auto__){
var map__14079 = p__14078;
var map__14079__$1 = ((((!((map__14079 == null)))?((((map__14079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14079.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14079):map__14079);
var params__10288__auto__ = map__14079__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var wrapped = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"wrapped","wrapped",1775172701));
var height = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var href = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"href","href",-793805698));
var Fluid = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"Fluid","Fluid",1557436705));
var children = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var vertical_align = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var alt = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"alt","alt",-3214426));
var ui_QMARK_ = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"ui?","ui?",1139629609));
var avatar_QMARK_ = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"avatar?","avatar?",-195115191));
var as = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var width = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var spadced = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"spadced","spadced",-1180126901));
var bordered_QMARK_ = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"bordered?","bordered?",562358476));
var src = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var on_click = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var dimmer = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368));
var style = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var centered_QMARK_ = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var floated = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var label = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var shape = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"shape","shape",1190694006));
var class_name = cljs.core.get.call(null,map__14079__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"Fluid","Fluid",1557436705),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"alt","alt",-3214426),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"ui?","ui?",1139629609),null,new cljs.core.Keyword(null,"avatar?","avatar?",-195115191),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"spadced","spadced",-1180126901),null,new cljs.core.Keyword(null,"bordered?","bordered?",562358476),null,new cljs.core.Keyword(null,"src","src",-1651076051),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"shape","shape",1190694006),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"wrapped","wrapped",1775172701),null,new cljs.core.Keyword(null,"href","href",-793805698),null,new cljs.core.Keyword(null,"height","height",1025178622),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:Fluid :children :vertical-align :key :alt :as :ui? :avatar? :width :spadced :bordered? :src :on-click :size :style :dimmer :centered? :inline? :floated :label :id :shape :class-name :disabled? :wrapped :href :height})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Image,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.image.cljs$lang$maxFixedArity = (1);

sodium.core.image.cljs$lang$applyTo = (function (seq14076){
var G__14077 = cljs.core.first.call(null,seq14076);
var seq14076__$1 = cljs.core.next.call(null,seq14076);
return sodium.core.image.cljs$core$IFn$_invoke$arity$variadic(G__14077,seq14076__$1);
});

sodium.core.icon = (function sodium$core$icon(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14089 = arguments.length;
var i__10062__auto___14090 = (0);
while(true){
if((i__10062__auto___14090 < len__10061__auto___14089)){
args__10068__auto__.push((arguments[i__10062__auto___14090]));

var G__14091 = (i__10062__auto___14090 + (1));
i__10062__auto___14090 = G__14091;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.icon.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.icon.cljs$core$IFn$_invoke$arity$variadic = (function (p__14086,body__10289__auto__){
var map__14087 = p__14086;
var map__14087__$1 = ((((!((map__14087 == null)))?((((map__14087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14087.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14087):map__14087);
var params__10288__auto__ = map__14087__$1;
var flipped = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"flipped","flipped",567173306));
var disabled_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var inverted_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var rotated = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"rotated","rotated",1509433122));
var corner_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"corner?","corner?",-1091864636));
var key = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var name = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var loading_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var bordered_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"bordered?","bordered?",562358476));
var on_click = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var link_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"link?","link?",-1241171248));
var style = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var fitted_QMARK_ = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243));
var class_name = cljs.core.get.call(null,map__14087__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"rotated","rotated",1509433122),null,new cljs.core.Keyword(null,"corner?","corner?",-1091864636),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"bordered?","bordered?",562358476),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"link?","link?",-1241171248),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"flipped","flipped",567173306),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :children :rotated :corner? :color :key :circular? :name :loading? :as :bordered? :on-click :size :style :link? :id :fitted? :class-name :flipped :disabled?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Icon,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.icon.cljs$lang$maxFixedArity = (1);

sodium.core.icon.cljs$lang$applyTo = (function (seq14084){
var G__14085 = cljs.core.first.call(null,seq14084);
var seq14084__$1 = cljs.core.next.call(null,seq14084);
return sodium.core.icon.cljs$core$IFn$_invoke$arity$variadic(G__14085,seq14084__$1);
});

sodium.core.icon_group = (function sodium$core$icon_group(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14097 = arguments.length;
var i__10062__auto___14098 = (0);
while(true){
if((i__10062__auto___14098 < len__10061__auto___14097)){
args__10068__auto__.push((arguments[i__10062__auto___14098]));

var G__14099 = (i__10062__auto___14098 + (1));
i__10062__auto___14098 = G__14099;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.icon_group.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.icon_group.cljs$core$IFn$_invoke$arity$variadic = (function (p__14094,body__10289__auto__){
var map__14095 = p__14094;
var map__14095__$1 = ((((!((map__14095 == null)))?((((map__14095.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14095.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14095):map__14095);
var params__10288__auto__ = map__14095__$1;
var children = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14095__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :as :on-click :size :style :id :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.IconGroup,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.icon_group.cljs$lang$maxFixedArity = (1);

sodium.core.icon_group.cljs$lang$applyTo = (function (seq14092){
var G__14093 = cljs.core.first.call(null,seq14092);
var seq14092__$1 = cljs.core.next.call(null,seq14092);
return sodium.core.icon_group.cljs$core$IFn$_invoke$arity$variadic(G__14093,seq14092__$1);
});

sodium.core.input = (function sodium$core$input(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14105 = arguments.length;
var i__10062__auto___14106 = (0);
while(true){
if((i__10062__auto___14106 < len__10061__auto___14105)){
args__10068__auto__.push((arguments[i__10062__auto___14106]));

var G__14107 = (i__10062__auto___14106 + (1));
i__10062__auto___14106 = G__14107;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.input.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.input.cljs$core$IFn$_invoke$arity$variadic = (function (p__14102,body__10289__auto__){
var map__14103 = p__14102;
var map__14103__$1 = ((((!((map__14103 == null)))?((((map__14103.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14103.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14103):map__14103);
var params__10288__auto__ = map__14103__$1;
var input = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"input","input",556931961));
var action_position = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"action-position","action-position",-704217959));
var error_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var disabled_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var step = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var fluid_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var tab_index = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var key = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var placeholder = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var icon_position = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034));
var focus_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"focus?","focus?",-3018488));
var value = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var width = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var transparent_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548));
var type = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var list = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"list","list",765357683));
var loading = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"loading","loading",-737050189));
var label = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var class_name = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__14103__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),null,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034),null,new cljs.core.Keyword(null,"focus?","focus?",-3018488),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"action-position","action-position",-704217959),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"step","step",1288888124),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :tab-index :required? :children :key :placeholder :icon-position :focus? :as :value :default-value :width :transparent? :type :icon :on-click :size :style :inline? :loading :list :label :id :control :action :class-name :action-position :error? :input :on-change :disabled? :step :fluid? :label-position})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Input,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.input.cljs$lang$maxFixedArity = (1);

sodium.core.input.cljs$lang$applyTo = (function (seq14100){
var G__14101 = cljs.core.first.call(null,seq14100);
var seq14100__$1 = cljs.core.next.call(null,seq14100);
return sodium.core.input.cljs$core$IFn$_invoke$arity$variadic(G__14101,seq14100__$1);
});

sodium.core.label = (function sodium$core$label(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14113 = arguments.length;
var i__10062__auto___14114 = (0);
while(true){
if((i__10062__auto___14114 < len__10061__auto___14113)){
args__10068__auto__.push((arguments[i__10062__auto___14114]));

var G__14115 = (i__10062__auto___14114 + (1));
i__10062__auto___14114 = G__14115;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.label.cljs$core$IFn$_invoke$arity$variadic = (function (p__14110,body__10289__auto__){
var map__14111 = p__14110;
var map__14111__$1 = ((((!((map__14111 == null)))?((((map__14111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14111.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14111):map__14111);
var params__10288__auto__ = map__14111__$1;
var attached = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var tag_QMARK_ = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"tag?","tag?",1714008252));
var on_remove = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"on-remove","on-remove",-268656163));
var detail = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"detail","detail",-1545345025));
var ribbon = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"ribbon","ribbon",-737080896));
var active_QMARK_ = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var horizontal_QMARK_ = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var pointing = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"pointing","pointing",-1869969692));
var key = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var corner = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"corner","corner",1296717125));
var remove_icon = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"remove-icon","remove-icon",885625702));
var content = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"content","content",15833224));
var floating_QMARK_ = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"floating?","floating?",509059561));
var as = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var icon = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var empty = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"empty","empty",767870958));
var on_click = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image = cljs.core.get.call(null,map__14111__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 26, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"ribbon","ribbon",-737080896),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"pointing","pointing",-1869969692),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"corner","corner",1296717125),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"remove-icon","remove-icon",885625702),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"floating?","floating?",509059561),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"empty","empty",767870958),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"image","image",-58725096),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"tag?","tag?",1714008252),null,new cljs.core.Keyword(null,"on-remove","on-remove",-268656163),null,new cljs.core.Keyword(null,"detail","detail",-1545345025),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:active? :ribbon :horizontal? :children :pointing :color :corner :key :circular? :remove-icon :content :as :floating? :basic? :icon :empty :on-click :size :style :id :image :class-name :attached :tag? :on-remove :detail})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Label,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.label.cljs$lang$maxFixedArity = (1);

sodium.core.label.cljs$lang$applyTo = (function (seq14108){
var G__14109 = cljs.core.first.call(null,seq14108);
var seq14108__$1 = cljs.core.next.call(null,seq14108);
return sodium.core.label.cljs$core$IFn$_invoke$arity$variadic(G__14109,seq14108__$1);
});

sodium.core.list_na = (function sodium$core$list_na(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14121 = arguments.length;
var i__10062__auto___14122 = (0);
while(true){
if((i__10062__auto___14122 < len__10061__auto___14121)){
args__10068__auto__.push((arguments[i__10062__auto___14122]));

var G__14123 = (i__10062__auto___14122 + (1));
i__10062__auto___14122 = G__14123;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.list_na.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.list_na.cljs$core$IFn$_invoke$arity$variadic = (function (p__14118,body__10289__auto__){
var map__14119 = p__14118;
var map__14119__$1 = ((((!((map__14119 == null)))?((((map__14119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14119.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14119):map__14119);
var params__10288__auto__ = map__14119__$1;
var items = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var divided_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"divided?","divided?",-706929476));
var relaxed = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907));
var ordered_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"ordered?","ordered?",812162688));
var inverted_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var horizontal_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var bulleted_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"bulleted?","bulleted?",680239204));
var animated_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"animated?","animated?",-1143981820));
var key = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_item_click = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363));
var vertical_align = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var as = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var selection_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"selection?","selection?",804764555));
var on_click = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var link_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"link?","link?",-1241171248));
var style = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var floated = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var celled_QMARK_ = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"celled?","celled?",-266703115));
var class_name = cljs.core.get.call(null,map__14119__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"ordered?","ordered?",812162688),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"bulleted?","bulleted?",680239204),null,new cljs.core.Keyword(null,"animated?","animated?",-1143981820),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"selection?","selection?",804764555),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"link?","link?",-1241171248),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"celled?","celled?",-266703115),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"items","items",1031954938),null,new cljs.core.Keyword(null,"divided?","divided?",-706929476),null,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:ordered? :inverted? :horizontal? :children :bulleted? :animated? :vertical-align :key :on-item-click :as :selection? :on-click :size :style :link? :floated :id :celled? :class-name :items :divided? :relaxed})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ListSA,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.list_na.cljs$lang$maxFixedArity = (1);

sodium.core.list_na.cljs$lang$applyTo = (function (seq14116){
var G__14117 = cljs.core.first.call(null,seq14116);
var seq14116__$1 = cljs.core.next.call(null,seq14116);
return sodium.core.list_na.cljs$core$IFn$_invoke$arity$variadic(G__14117,seq14116__$1);
});

sodium.core.list_item = (function sodium$core$list_item(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14129 = arguments.length;
var i__10062__auto___14130 = (0);
while(true){
if((i__10062__auto___14130 < len__10061__auto___14129)){
args__10068__auto__.push((arguments[i__10062__auto___14130]));

var G__14131 = (i__10062__auto___14130 + (1));
i__10062__auto___14130 = G__14131;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.list_item.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.list_item.cljs$core$IFn$_invoke$arity$variadic = (function (p__14126,body__10289__auto__){
var map__14127 = p__14126;
var map__14127__$1 = ((((!((map__14127 == null)))?((((map__14127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14127.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14127):map__14127);
var params__10288__auto__ = map__14127__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var active_QMARK_ = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var description = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"description","description",-1428560544));
var children = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"content","content",15833224));
var value = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var icon = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var header = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"header","header",119441134));
var on_click = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image = cljs.core.get.call(null,map__14127__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"image","image",-58725096),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:active? :description :children :key :content :as :value :icon :header :on-click :style :id :image :class-name :disabled?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ListItem,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.list_item.cljs$lang$maxFixedArity = (1);

sodium.core.list_item.cljs$lang$applyTo = (function (seq14124){
var G__14125 = cljs.core.first.call(null,seq14124);
var seq14124__$1 = cljs.core.next.call(null,seq14124);
return sodium.core.list_item.cljs$core$IFn$_invoke$arity$variadic(G__14125,seq14124__$1);
});

sodium.core.menu = (function sodium$core$menu(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14137 = arguments.length;
var i__10062__auto___14138 = (0);
while(true){
if((i__10062__auto___14138 < len__10061__auto___14137)){
args__10068__auto__.push((arguments[i__10062__auto___14138]));

var G__14139 = (i__10062__auto___14138 + (1));
i__10062__auto___14138 = G__14139;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu.cljs$core$IFn$_invoke$arity$variadic = (function (p__14134,body__10289__auto__){
var map__14135 = p__14134;
var map__14135__$1 = ((((!((map__14135 == null)))?((((map__14135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14135.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14135):map__14135);
var params__10288__auto__ = map__14135__$1;
var items = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var fixed = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"fixed","fixed",-562004358));
var secondary_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var attached = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var fluid_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var inverted_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var active_index = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"active-index","active-index",864399296));
var text_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"text?","text?",-934411583));
var tabular_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"tabular?","tabular?",-1146013791));
var children = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var borderless_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"borderless?","borderless?",-732642494));
var stackable_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005));
var key = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_item_click = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363));
var color = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var as = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var icon = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var widths = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"widths","widths",-1467327440));
var pointing_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"pointing?","pointing?",2129239216));
var style = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var compact_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vertical_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444));
var pagination_QMARK_ = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"pagination?","pagination?",-1661715944));
var default_active_index = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"default-active-index","default-active-index",1260382968));
var class_name = cljs.core.get.call(null,map__14135__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 29, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"active-index","active-index",864399296),null,new cljs.core.Keyword(null,"text?","text?",-934411583),null,new cljs.core.Keyword(null,"tabular?","tabular?",-1146013791),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"borderless?","borderless?",-732642494),null,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"widths","widths",-1467327440),null,new cljs.core.Keyword(null,"pointing?","pointing?",2129239216),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"pagination?","pagination?",-1661715944),null,new cljs.core.Keyword(null,"default-active-index","default-active-index",1260382968),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"items","items",1031954938),null,new cljs.core.Keyword(null,"fixed","fixed",-562004358),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :active-index :text? :tabular? :children :borderless? :stackable? :color :key :on-item-click :as :icon :on-click :size :widths :pointing? :style :compact? :floated :vertical? :id :pagination? :default-active-index :class-name :items :fixed :secondary? :attached :fluid?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Menu,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.menu.cljs$lang$maxFixedArity = (1);

sodium.core.menu.cljs$lang$applyTo = (function (seq14132){
var G__14133 = cljs.core.first.call(null,seq14132);
var seq14132__$1 = cljs.core.next.call(null,seq14132);
return sodium.core.menu.cljs$core$IFn$_invoke$arity$variadic(G__14133,seq14132__$1);
});

sodium.core.menu_header = (function sodium$core$menu_header(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14145 = arguments.length;
var i__10062__auto___14146 = (0);
while(true){
if((i__10062__auto___14146 < len__10061__auto___14145)){
args__10068__auto__.push((arguments[i__10062__auto___14146]));

var G__14147 = (i__10062__auto___14146 + (1));
i__10062__auto___14146 = G__14147;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu_header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu_header.cljs$core$IFn$_invoke$arity$variadic = (function (p__14142,body__10289__auto__){
var map__14143 = p__14142;
var map__14143__$1 = ((((!((map__14143 == null)))?((((map__14143.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14143.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14143):map__14143);
var params__10288__auto__ = map__14143__$1;
var children = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14143__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :content :as :on-click :style :id :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.MenuHeader,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.menu_header.cljs$lang$maxFixedArity = (1);

sodium.core.menu_header.cljs$lang$applyTo = (function (seq14140){
var G__14141 = cljs.core.first.call(null,seq14140);
var seq14140__$1 = cljs.core.next.call(null,seq14140);
return sodium.core.menu_header.cljs$core$IFn$_invoke$arity$variadic(G__14141,seq14140__$1);
});

sodium.core.menu_item = (function sodium$core$menu_item(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14153 = arguments.length;
var i__10062__auto___14154 = (0);
while(true){
if((i__10062__auto___14154 < len__10061__auto___14153)){
args__10068__auto__.push((arguments[i__10062__auto___14154]));

var G__14155 = (i__10062__auto___14154 + (1));
i__10062__auto___14154 = G__14155;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu_item.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu_item.cljs$core$IFn$_invoke$arity$variadic = (function (p__14150,body__10289__auto__){
var map__14151 = p__14150;
var map__14151__$1 = ((((!((map__14151 == null)))?((((map__14151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14151.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14151):map__14151);
var params__10288__auto__ = map__14151__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var fitted = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"fitted","fitted",531153693));
var active_QMARK_ = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var children = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var index = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var color = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var content = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"content","content",15833224));
var name = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var as = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var header_QMARK_ = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"header?","header?",-106649173));
var icon = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var link_QMARK_ = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"link?","link?",-1241171248));
var style = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var position = cljs.core.get.call(null,map__14151__$1,new cljs.core.Keyword(null,"position","position",-2011731912));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"header?","header?",-106649173),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"link?","link?",-1241171248),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"position","position",-2011731912),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"fitted","fitted",531153693),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:active? :children :color :key :index :content :name :as :header? :icon :on-click :style :link? :id :position :class-name :disabled? :fitted})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.MenuItem,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.menu_item.cljs$lang$maxFixedArity = (1);

sodium.core.menu_item.cljs$lang$applyTo = (function (seq14148){
var G__14149 = cljs.core.first.call(null,seq14148);
var seq14148__$1 = cljs.core.next.call(null,seq14148);
return sodium.core.menu_item.cljs$core$IFn$_invoke$arity$variadic(G__14149,seq14148__$1);
});

sodium.core.menu_menu = (function sodium$core$menu_menu(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14161 = arguments.length;
var i__10062__auto___14162 = (0);
while(true){
if((i__10062__auto___14162 < len__10061__auto___14161)){
args__10068__auto__.push((arguments[i__10062__auto___14162]));

var G__14163 = (i__10062__auto___14162 + (1));
i__10062__auto___14162 = G__14163;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu_menu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu_menu.cljs$core$IFn$_invoke$arity$variadic = (function (p__14158,body__10289__auto__){
var map__14159 = p__14158;
var map__14159__$1 = ((((!((map__14159 == null)))?((((map__14159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14159.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14159):map__14159);
var params__10288__auto__ = map__14159__$1;
var children = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var position = cljs.core.get.call(null,map__14159__$1,new cljs.core.Keyword(null,"position","position",-2011731912));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"position","position",-2011731912),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :as :on-click :style :id :position :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.MenuMenu,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.menu_menu.cljs$lang$maxFixedArity = (1);

sodium.core.menu_menu.cljs$lang$applyTo = (function (seq14156){
var G__14157 = cljs.core.first.call(null,seq14156);
var seq14156__$1 = cljs.core.next.call(null,seq14156);
return sodium.core.menu_menu.cljs$core$IFn$_invoke$arity$variadic(G__14157,seq14156__$1);
});

sodium.core.modal = (function sodium$core$modal(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14169 = arguments.length;
var i__10062__auto___14170 = (0);
while(true){
if((i__10062__auto___14170 < len__10061__auto___14169)){
args__10068__auto__.push((arguments[i__10062__auto___14170]));

var G__14171 = (i__10062__auto___14170 + (1));
i__10062__auto___14170 = G__14171;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal.cljs$core$IFn$_invoke$arity$variadic = (function (p__14166,body__10289__auto__){
var map__14167 = p__14166;
var map__14167__$1 = ((((!((map__14167 == null)))?((((map__14167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14167.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14167):map__14167);
var params__10288__auto__ = map__14167__$1;
var mount_node = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"mount-node","mount-node",1448014937));
var on_open = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"on-open","on-open",-1391088163));
var close_on_dimmer_click_QMARK_ = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"close-on-dimmer-click?","close-on-dimmer-click?",-1661039169));
var on_mount = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840));
var close_on_document_click_QMARK_ = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"close-on-document-click?","close-on-document-click?",-948414079));
var children = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var on_action_click = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179));
var event_pool = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"event-pool","event-pool",302831908));
var key = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_close = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"on-close","on-close",-761178394));
var content = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var close_icon = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"close-icon","close-icon",-659435027));
var basic_QMARK_ = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var header = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"header","header",119441134));
var actions = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"actions","actions",-812656882));
var on_click = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var dimmer = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368));
var style = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var on_unmount = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269));
var open_QMARK_ = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"open?","open?",1238443125));
var default_open_QMARK_ = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144));
var class_name = cljs.core.get.call(null,map__14167__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840),null,new cljs.core.Keyword(null,"close-on-document-click?","close-on-document-click?",-948414079),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179),null,new cljs.core.Keyword(null,"event-pool","event-pool",302831908),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-close","on-close",-761178394),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"close-icon","close-icon",-659435027),null,new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"actions","actions",-812656882),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"open?","open?",1238443125),null,new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269),null,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"mount-node","mount-node",1448014937),null,new cljs.core.Keyword(null,"on-open","on-open",-1391088163),null,new cljs.core.Keyword(null,"close-on-dimmer-click?","close-on-dimmer-click?",-1661039169),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:on-mount :close-on-document-click? :children :on-action-click :event-pool :key :on-close :content :as :basic? :close-icon :header :actions :on-click :size :style :dimmer :id :open? :on-unmount :default-open? :class-name :mount-node :on-open :close-on-dimmer-click?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Modal,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.modal.cljs$lang$maxFixedArity = (1);

sodium.core.modal.cljs$lang$applyTo = (function (seq14164){
var G__14165 = cljs.core.first.call(null,seq14164);
var seq14164__$1 = cljs.core.next.call(null,seq14164);
return sodium.core.modal.cljs$core$IFn$_invoke$arity$variadic(G__14165,seq14164__$1);
});

sodium.core.modal_header = (function sodium$core$modal_header(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14177 = arguments.length;
var i__10062__auto___14178 = (0);
while(true){
if((i__10062__auto___14178 < len__10061__auto___14177)){
args__10068__auto__.push((arguments[i__10062__auto___14178]));

var G__14179 = (i__10062__auto___14178 + (1));
i__10062__auto___14178 = G__14179;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_header.cljs$core$IFn$_invoke$arity$variadic = (function (p__14174,body__10289__auto__){
var map__14175 = p__14174;
var map__14175__$1 = ((((!((map__14175 == null)))?((((map__14175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14175):map__14175);
var params__10288__auto__ = map__14175__$1;
var children = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14175__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :content :as :on-click :style :id :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalHeader,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.modal_header.cljs$lang$maxFixedArity = (1);

sodium.core.modal_header.cljs$lang$applyTo = (function (seq14172){
var G__14173 = cljs.core.first.call(null,seq14172);
var seq14172__$1 = cljs.core.next.call(null,seq14172);
return sodium.core.modal_header.cljs$core$IFn$_invoke$arity$variadic(G__14173,seq14172__$1);
});

sodium.core.modal_content = (function sodium$core$modal_content(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14185 = arguments.length;
var i__10062__auto___14186 = (0);
while(true){
if((i__10062__auto___14186 < len__10061__auto___14185)){
args__10068__auto__.push((arguments[i__10062__auto___14186]));

var G__14187 = (i__10062__auto___14186 + (1));
i__10062__auto___14186 = G__14187;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_content.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_content.cljs$core$IFn$_invoke$arity$variadic = (function (p__14182,body__10289__auto__){
var map__14183 = p__14182;
var map__14183__$1 = ((((!((map__14183 == null)))?((((map__14183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14183.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14183):map__14183);
var params__10288__auto__ = map__14183__$1;
var scrolling_QMARK_ = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499));
var children = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image_QMARK_ = cljs.core.get.call(null,map__14183__$1,new cljs.core.Keyword(null,"image?","image?",1951967096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"image?","image?",1951967096),null,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :content :as :on-click :style :id :class-name :image? :scrolling?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalContent,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.modal_content.cljs$lang$maxFixedArity = (1);

sodium.core.modal_content.cljs$lang$applyTo = (function (seq14180){
var G__14181 = cljs.core.first.call(null,seq14180);
var seq14180__$1 = cljs.core.next.call(null,seq14180);
return sodium.core.modal_content.cljs$core$IFn$_invoke$arity$variadic(G__14181,seq14180__$1);
});

sodium.core.modal_description = (function sodium$core$modal_description(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14193 = arguments.length;
var i__10062__auto___14194 = (0);
while(true){
if((i__10062__auto___14194 < len__10061__auto___14193)){
args__10068__auto__.push((arguments[i__10062__auto___14194]));

var G__14195 = (i__10062__auto___14194 + (1));
i__10062__auto___14194 = G__14195;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_description.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_description.cljs$core$IFn$_invoke$arity$variadic = (function (p__14190,body__10289__auto__){
var map__14191 = p__14190;
var map__14191__$1 = ((((!((map__14191 == null)))?((((map__14191.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14191.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14191):map__14191);
var params__10288__auto__ = map__14191__$1;
var children = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14191__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :key :as :on-click :style :id :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalDescription,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.modal_description.cljs$lang$maxFixedArity = (1);

sodium.core.modal_description.cljs$lang$applyTo = (function (seq14188){
var G__14189 = cljs.core.first.call(null,seq14188);
var seq14188__$1 = cljs.core.next.call(null,seq14188);
return sodium.core.modal_description.cljs$core$IFn$_invoke$arity$variadic(G__14189,seq14188__$1);
});

sodium.core.modal_actions = (function sodium$core$modal_actions(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14201 = arguments.length;
var i__10062__auto___14202 = (0);
while(true){
if((i__10062__auto___14202 < len__10061__auto___14201)){
args__10068__auto__.push((arguments[i__10062__auto___14202]));

var G__14203 = (i__10062__auto___14202 + (1));
i__10062__auto___14202 = G__14203;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_actions.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_actions.cljs$core$IFn$_invoke$arity$variadic = (function (p__14198,body__10289__auto__){
var map__14199 = p__14198;
var map__14199__$1 = ((((!((map__14199 == null)))?((((map__14199.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14199.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14199):map__14199);
var params__10288__auto__ = map__14199__$1;
var children = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var on_action_click = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179));
var key = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var actions = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"actions","actions",-812656882));
var on_click = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14199__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"actions","actions",-812656882),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:children :on-action-click :key :as :actions :on-click :style :id :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalActions,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.modal_actions.cljs$lang$maxFixedArity = (1);

sodium.core.modal_actions.cljs$lang$applyTo = (function (seq14196){
var G__14197 = cljs.core.first.call(null,seq14196);
var seq14196__$1 = cljs.core.next.call(null,seq14196);
return sodium.core.modal_actions.cljs$core$IFn$_invoke$arity$variadic(G__14197,seq14196__$1);
});

sodium.core.rail = (function sodium$core$rail(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14209 = arguments.length;
var i__10062__auto___14210 = (0);
while(true){
if((i__10062__auto___14210 < len__10061__auto___14209)){
args__10068__auto__.push((arguments[i__10062__auto___14210]));

var G__14211 = (i__10062__auto___14210 + (1));
i__10062__auto___14210 = G__14211;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.rail.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.rail.cljs$core$IFn$_invoke$arity$variadic = (function (p__14206,body__10289__auto__){
var map__14207 = p__14206;
var map__14207__$1 = ((((!((map__14207 == null)))?((((map__14207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14207.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14207):map__14207);
var params__10288__auto__ = map__14207__$1;
var attached_QMARK_ = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"attached?","attached?",548719296));
var children = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var dividing_QMARK_ = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650));
var as = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var close = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var on_click = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var internal_QMARK_ = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"internal?","internal?",-383058705));
var size = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var position = cljs.core.get.call(null,map__14207__$1,new cljs.core.Keyword(null,"position","position",-2011731912));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Keyword(null,"attached?","attached?",548719296),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"internal?","internal?",-383058705),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"position","position",-2011731912),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:attached? :children :key :dividing? :as :close :on-click :internal? :size :style :id :position :class-name})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Rail,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.rail.cljs$lang$maxFixedArity = (1);

sodium.core.rail.cljs$lang$applyTo = (function (seq14204){
var G__14205 = cljs.core.first.call(null,seq14204);
var seq14204__$1 = cljs.core.next.call(null,seq14204);
return sodium.core.rail.cljs$core$IFn$_invoke$arity$variadic(G__14205,seq14204__$1);
});

sodium.core.search = (function sodium$core$search(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14217 = arguments.length;
var i__10062__auto___14218 = (0);
while(true){
if((i__10062__auto___14218 < len__10061__auto___14217)){
args__10068__auto__.push((arguments[i__10062__auto___14218]));

var G__14219 = (i__10062__auto___14218 + (1));
i__10062__auto___14218 = G__14219;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.search.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.search.cljs$core$IFn$_invoke$arity$variadic = (function (p__14214,body__10289__auto__){
var map__14215 = p__14214;
var map__14215__$1 = ((((!((map__14215 == null)))?((((map__14215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14215.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14215):map__14215);
var params__10288__auto__ = map__14215__$1;
var input = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"input","input",556931961));
var on_search_change = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351));
var result_renderer = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"result-renderer","result-renderer",2139760218));
var category_renderer = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"category-renderer","category-renderer",277355995));
var category_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"category?","category?",1508694237));
var fluid_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var results = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
var children = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var select_first_result_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"select-first-result?","select-first-result?",-1374852926));
var key = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_focus = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624));
var value = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"value","value",305978217));
var loading_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var on_blur = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var no_results_description = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"no-results-description","no-results-description",-108447765));
var aligned = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"aligned","aligned",-1015148916));
var on_results_select = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-results-select","on-results-select",-1899813844));
var no_results_message = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660));
var icon = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_mouse_down = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470));
var on_click = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var on_selection_change = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"on-selection-change","on-selection-change",-1774232910));
var min_characters = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908));
var id = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var open_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"open?","open?",1238443125));
var show_no_results_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"show-no-results?","show-no-results?",768730806));
var default_open_QMARK_ = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144));
var class_name = cljs.core.get.call(null,map__14215__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 32, [new cljs.core.Keyword(null,"select-first-result?","select-first-result?",-1374852926),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),null,new cljs.core.Keyword(null,"no-results-description","no-results-description",-108447765),null,new cljs.core.Keyword(null,"on-results-select","on-results-select",-1899813844),null,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660),null,new cljs.core.Keyword(null,"aligned","aligned",-1015148916),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"on-selection-change","on-selection-change",-1774232910),null,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"open?","open?",1238443125),null,new cljs.core.Keyword(null,"show-no-results?","show-no-results?",768730806),null,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"result-renderer","result-renderer",2139760218),null,new cljs.core.Keyword(null,"category-renderer","category-renderer",277355995),null,new cljs.core.Keyword(null,"category?","category?",1508694237),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"results","results",-1134170113),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:select-first-result? :children :key :on-focus :loading? :as :value :default-value :on-blur :no-results-description :on-results-select :no-results-message :aligned :icon :on-mouse-down :on-click :size :style :on-selection-change :min-characters :id :open? :show-no-results? :default-open? :class-name :on-search-change :input :result-renderer :category-renderer :category? :fluid? :results})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Search,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.search.cljs$lang$maxFixedArity = (1);

sodium.core.search.cljs$lang$applyTo = (function (seq14212){
var G__14213 = cljs.core.first.call(null,seq14212);
var seq14212__$1 = cljs.core.next.call(null,seq14212);
return sodium.core.search.cljs$core$IFn$_invoke$arity$variadic(G__14213,seq14212__$1);
});

sodium.core.segment = (function sodium$core$segment(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14225 = arguments.length;
var i__10062__auto___14226 = (0);
while(true){
if((i__10062__auto___14226 < len__10061__auto___14225)){
args__10068__auto__.push((arguments[i__10062__auto___14226]));

var G__14227 = (i__10062__auto___14226 + (1));
i__10062__auto___14226 = G__14227;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.segment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.segment.cljs$core$IFn$_invoke$arity$variadic = (function (p__14222,body__10289__auto__){
var map__14223 = p__14222;
var map__14223__$1 = ((((!((map__14223 == null)))?((((map__14223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14223.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14223):map__14223);
var params__10288__auto__ = map__14223__$1;
var secondary_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var disabled_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var attached = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var stacked_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"stacked?","stacked?",784188446));
var inverted_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var raised_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"raised?","raised?",145778912));
var children = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var loading_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var piled_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"piled?","piled?",991468937));
var basic_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var tertiary_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"tertiary?","tertiary?",469980846));
var on_click = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var clearing_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270));
var compact_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vertical_QMARK_ = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444));
var padded = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"padded","padded",1434297910));
var class_name = cljs.core.get.call(null,map__14223__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 26, [new cljs.core.Keyword(null,"raised?","raised?",145778912),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"piled?","piled?",991468937),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"tertiary?","tertiary?",469980846),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"padded","padded",1434297910),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"stacked?","stacked?",784188446),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:raised? :inverted? :children :color :text-align :key :circular? :loading? :as :piled? :basic? :tertiary? :on-click :size :style :compact? :clearing? :floated :vertical? :id :padded :class-name :secondary? :disabled? :attached :stacked?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Segment,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.segment.cljs$lang$maxFixedArity = (1);

sodium.core.segment.cljs$lang$applyTo = (function (seq14220){
var G__14221 = cljs.core.first.call(null,seq14220);
var seq14220__$1 = cljs.core.next.call(null,seq14220);
return sodium.core.segment.cljs$core$IFn$_invoke$arity$variadic(G__14221,seq14220__$1);
});

sodium.core.segment_group = (function sodium$core$segment_group(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14233 = arguments.length;
var i__10062__auto___14234 = (0);
while(true){
if((i__10062__auto___14234 < len__10061__auto___14233)){
args__10068__auto__.push((arguments[i__10062__auto___14234]));

var G__14235 = (i__10062__auto___14234 + (1));
i__10062__auto___14234 = G__14235;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.segment_group.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.segment_group.cljs$core$IFn$_invoke$arity$variadic = (function (p__14230,body__10289__auto__){
var map__14231 = p__14230;
var map__14231__$1 = ((((!((map__14231 == null)))?((((map__14231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14231):map__14231);
var params__10288__auto__ = map__14231__$1;
var stacked_QMARK_ = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"stacked?","stacked?",784188446));
var raised_QMARK_ = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"raised?","raised?",145778912));
var horizontal_QMARK_ = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var piled_QMARK_ = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"piled?","piled?",991468937));
var on_click = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var compact_QMARK_ = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var id = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__14231__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Keyword(null,"raised?","raised?",145778912),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"piled?","piled?",991468937),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"stacked?","stacked?",784188446),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:raised? :horizontal? :children :key :as :piled? :on-click :size :style :compact? :id :class-name :stacked?})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.SegmentGroup,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.segment_group.cljs$lang$maxFixedArity = (1);

sodium.core.segment_group.cljs$lang$applyTo = (function (seq14228){
var G__14229 = cljs.core.first.call(null,seq14228);
var seq14228__$1 = cljs.core.next.call(null,seq14228);
return sodium.core.segment_group.cljs$core$IFn$_invoke$arity$variadic(G__14229,seq14228__$1);
});

sodium.core.text_area = (function sodium$core$text_area(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14241 = arguments.length;
var i__10062__auto___14242 = (0);
while(true){
if((i__10062__auto___14242 < len__10061__auto___14241)){
args__10068__auto__.push((arguments[i__10062__auto___14242]));

var G__14243 = (i__10062__auto___14242 + (1));
i__10062__auto___14242 = G__14243;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (p__14238,body__10289__auto__){
var map__14239 = p__14238;
var map__14239__$1 = ((((!((map__14239 == null)))?((((map__14239.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14239.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14239):map__14239);
var params__10288__auto__ = map__14239__$1;
var input = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"input","input",556931961));
var action_position = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"action-position","action-position",-704217959));
var error_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var disabled_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var step = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var fluid_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var tab_index = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var key = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var placeholder = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var icon_position = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034));
var focus_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"focus?","focus?",-3018488));
var value = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var width = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var transparent_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548));
var type = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var rows = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
var style = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var auto_height = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"auto-height","auto-height",-960519663));
var inline_QMARK_ = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var list = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"list","list",765357683));
var loading = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"loading","loading",-737050189));
var label = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var class_name = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__14239__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10288__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 36, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),null,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034),null,new cljs.core.Keyword(null,"focus?","focus?",-3018488),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"rows","rows",850049680),null,new cljs.core.Keyword(null,"auto-height","auto-height",-960519663),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"action-position","action-position",-704217959),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"step","step",1288888124),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10288__auto__) #{:inverted? :tab-index :required? :children :key :placeholder :icon-position :focus? :as :value :default-value :width :transparent? :type :icon :on-click :size :style :rows :auto-height :inline? :loading :list :label :id :control :action :class-name :action-position :error? :input :on-change :disabled? :step :fluid? :label-position})"));
}

return iron.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.TextArea,iron.utils.camelize_map_keys.call(null,params__10288__auto__)], null),body__10289__auto__);
});

sodium.core.text_area.cljs$lang$maxFixedArity = (1);

sodium.core.text_area.cljs$lang$applyTo = (function (seq14236){
var G__14237 = cljs.core.first.call(null,seq14236);
var seq14236__$1 = cljs.core.next.call(null,seq14236);
return sodium.core.text_area.cljs$core$IFn$_invoke$arity$variadic(G__14237,seq14236__$1);
});

sodium.core.form_button = (function sodium$core$form_button(p__14245){
var map__14246 = p__14245;
var map__14246__$1 = ((((!((map__14246 == null)))?((((map__14246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14246.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14246):map__14246);
var params = map__14246__$1;
var error_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var secondary_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var disabled_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var attached = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var primary_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"primary?","primary?",1845519164));
var toggle_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476));
var fluid_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var active_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var tab_index = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var negative_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"negative?","negative?",-1265997117));
var key = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var positive_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"positive?","positive?",-185306841));
var content = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"content","content",15833224));
var loading_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var animated = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"animated","animated",129318795));
var width = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var type = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var on_click = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var compact_QMARK_ = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var label = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var data_tooltip = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926));
var class_name = cljs.core.get.call(null,map__14246__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(iron.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","ifn?","cljs.core/ifn?",1573873861,null),cljs.core.ifn_QMARK_,null),new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (validate (s/nilable ifn?) (:on-click params))"));
}

if(cljs.core.truth_(iron.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_,null),new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (validate (s/nilable string?) (:data-tooltip params))"));
}

if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 37, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"negative?","negative?",-1265997117),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"positive?","positive?",-185306841),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"animated","animated",129318795),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476),null,new cljs.core.Keyword(null,"primary?","primary?",1845519164),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params) #{:active? :inverted? :tab-index :required? :children :negative? :color :key :circular? :positive? :content :loading? :as :width :animated :type :basic? :icon :on-click :size :style :inline? :compact? :floated :label :id :control :data-tooltip :class-name :error? :secondary? :disabled? :attached :toggle? :primary? :fluid? :label-position})"));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.FormButton,iron.utils.camelize_map_keys.call(null,cljs.core.update.call(null,params,new cljs.core.Keyword(null,"type","type",1174270348),((function (map__14246,map__14246__$1,params,error_QMARK_,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,required_QMARK_,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,width,type,icon,basic_QMARK_,on_click,size,style,inline_QMARK_,compact_QMARK_,floated,label,id,control,data_tooltip,class_name){
return (function (p1__14244_SHARP_){
var or__8782__auto__ = p1__14244_SHARP_;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return "button";
}
});})(map__14246,map__14246__$1,params,error_QMARK_,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,required_QMARK_,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,width,type,icon,basic_QMARK_,on_click,size,style,inline_QMARK_,compact_QMARK_,floated,label,id,control,data_tooltip,class_name))
),new cljs.core.Keyword(null,"exclude","exclude",-1230250334),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926)], null))], null);
});
sodium.core.button = (function sodium$core$button(p__14249){
var map__14250 = p__14249;
var map__14250__$1 = ((((!((map__14250 == null)))?((((map__14250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14250):map__14250);
var params = map__14250__$1;
var secondary_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var disabled_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var attached = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var primary_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"primary?","primary?",1845519164));
var toggle_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476));
var fluid_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var active_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var tab_index = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var negative_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"negative?","negative?",-1265997117));
var key = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var positive_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"positive?","positive?",-185306841));
var content = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"content","content",15833224));
var loading_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var animated = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"animated","animated",129318795));
var icon = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var on_click = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var compact_QMARK_ = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var label = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var data_tooltip = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926));
var class_name = cljs.core.get.call(null,map__14250__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(iron.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","ifn?","cljs.core/ifn?",1573873861,null),cljs.core.ifn_QMARK_,null),new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (validate (s/nilable ifn?) (:on-click params))"));
}

if(cljs.core.truth_(iron.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_,null),new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (validate (s/nilable string?) (:data-tooltip params))"));
}

if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 31, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"negative?","negative?",-1265997117),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"positive?","positive?",-185306841),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"animated","animated",129318795),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476),null,new cljs.core.Keyword(null,"primary?","primary?",1845519164),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params) #{:active? :inverted? :tab-index :children :negative? :color :key :circular? :positive? :content :loading? :as :animated :basic? :icon :on-click :size :style :compact? :floated :label :id :data-tooltip :class-name :secondary? :disabled? :attached :toggle? :primary? :fluid? :label-position})"));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Button,iron.utils.camelize_map_keys.call(null,cljs.core.update.call(null,params,new cljs.core.Keyword(null,"type","type",1174270348),((function (map__14250,map__14250__$1,params,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,icon,basic_QMARK_,on_click,size,style,compact_QMARK_,floated,label,id,data_tooltip,class_name){
return (function (p1__14248_SHARP_){
var or__8782__auto__ = p1__14248_SHARP_;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return "button";
}
});})(map__14250,map__14250__$1,params,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,icon,basic_QMARK_,on_click,size,style,compact_QMARK_,floated,label,id,data_tooltip,class_name))
),new cljs.core.Keyword(null,"exclude","exclude",-1230250334),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926)], null))], null);
});

//# sourceMappingURL=core.js.map
