// Compiled by ClojureScript 1.9.946 {}
goog.provide('sodium.utils');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
/**
 * Case-insensitive string compare
 */
sodium.utils.ci_compare = (function sodium$utils$ci_compare(s1,s2){
return cljs.core.compare.call(null,clojure.string.upper_case.call(null,s1),clojure.string.upper_case.call(null,s2));
});
/**
 * Case-insensitive string sort
 */
sodium.utils.ci_sort = (function sodium$utils$ci_sort(coll){
return cljs.core.sort_by.call(null,clojure.string.upper_case,coll);
});
/**
 * Case-insensitive string sort-by
 */
sodium.utils.ci_sort_by = (function sodium$utils$ci_sort_by(keyfn,coll){
return cljs.core.sort_by.call(null,cljs.core.comp.call(null,clojure.string.upper_case,keyfn),coll);
});
/**
 * Case-insensitive string inclusion test
 */
sodium.utils.ci_includes_QMARK_ = (function sodium$utils$ci_includes_QMARK_(s,substr){
return clojure.string.includes_QMARK_.call(null,clojure.string.upper_case.call(null,s),clojure.string.upper_case.call(null,substr));
});
/**
 * Like s/valid?, but show the error like s/assert. Useful for pre-conditions.
 */
sodium.utils.validate = (function sodium$utils$validate(spec,x){
var or__8782__auto__ = cljs.spec.alpha.valid_QMARK_.call(null,spec,x);
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return cljs.spec.alpha.explain.call(null,spec,x);
}
});
/**
 * Like concat, but return a vector.
 */
sodium.utils.vconcat = (function sodium$utils$vconcat(var_args){
var args__10068__auto__ = [];
var len__10061__auto___15965 = arguments.length;
var i__10062__auto___15966 = (0);
while(true){
if((i__10062__auto___15966 < len__10061__auto___15965)){
args__10068__auto__.push((arguments[i__10062__auto___15966]));

var G__15967 = (i__10062__auto___15966 + (1));
i__10062__auto___15966 = G__15967;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return sodium.utils.vconcat.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

sodium.utils.vconcat.cljs$core$IFn$_invoke$arity$variadic = (function (vecs){
return cljs.core.vec.call(null,cljs.core.apply.call(null,cljs.core.concat,vecs));
});

sodium.utils.vconcat.cljs$lang$maxFixedArity = (0);

sodium.utils.vconcat.cljs$lang$applyTo = (function (seq15964){
return sodium.utils.vconcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15964));
});

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("sodium.utils","event-vector","sodium.utils/event-vector",-1205574834),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"params","params",710516235)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)));
/**
 * Remove trailing '?' from predicate, to make suitable for JavaScript
 */
sodium.utils.unpredicate = (function sodium$utils$unpredicate(s){
if(clojure.string.ends_with_QMARK_.call(null,s,"?")){
return cljs.core.subs.call(null,s,(0),(cljs.core.count.call(null,s) - (1)));
} else {
return s;
}
});
/**
 * Convert a string from ClojureScript to JavaScript conventions.
 *   - Replace hyphens with camelCase
 *   - Remove trailing '?'
 */
sodium.utils.camelize_str = (function sodium$utils$camelize_str(s){
var vec__15968 = clojure.string.split.call(null,sodium.utils.unpredicate.call(null,s),"-");
var seq__15969 = cljs.core.seq.call(null,vec__15968);
var first__15970 = cljs.core.first.call(null,seq__15969);
var seq__15969__$1 = cljs.core.next.call(null,seq__15969);
var first_word = first__15970;
var more = seq__15969__$1;
if(more){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(first_word),cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,clojure.string.capitalize,more)))].join('');
} else {
return first_word;
}
});
/**
 * Convert a keyword from ClojureScript to JavaScript conventions.
 *   - Replace hyphens with camelCase
 *   - Remove trailing '?'
 *   - Preserve namespace
 */
sodium.utils.camelize_key = (function sodium$utils$camelize_key(k){
return cljs.core.keyword.call(null,cljs.core.namespace.call(null,k),sodium.utils.camelize_str.call(null,cljs.core.name.call(null,k)));
});
/**
 * Convert a map from ClojureScript to JavaScript conventions. Change the map
 *   keys, but leave the values alone.  For convenience, you can pass in a seq
 *   of keywords that must be excluded (left unchanged).
 */
sodium.utils.camelize_map_keys = (function sodium$utils$camelize_map_keys(var_args){
var args__10068__auto__ = [];
var len__10061__auto___15976 = arguments.length;
var i__10062__auto___15977 = (0);
while(true){
if((i__10062__auto___15977 < len__10061__auto___15976)){
args__10068__auto__.push((arguments[i__10062__auto___15977]));

var G__15978 = (i__10062__auto___15977 + (1));
i__10062__auto___15977 = G__15978;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.utils.camelize_map_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.utils.camelize_map_keys.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__15973){
var map__15974 = p__15973;
var map__15974__$1 = ((((!((map__15974 == null)))?((((map__15974.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15974.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15974):map__15974);
var exclude = cljs.core.get.call(null,map__15974__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
return cljs.core.reduce_kv.call(null,((function (map__15974,map__15974__$1,exclude){
return (function (m__$1,k,v){
return cljs.core.assoc.call(null,m__$1,(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([k]),exclude))?k:sodium.utils.camelize_key.call(null,k)),v);
});})(map__15974,map__15974__$1,exclude))
,cljs.core.PersistentArrayMap.EMPTY,m);
});

sodium.utils.camelize_map_keys.cljs$lang$maxFixedArity = (1);

sodium.utils.camelize_map_keys.cljs$lang$applyTo = (function (seq15971){
var G__15972 = cljs.core.first.call(null,seq15971);
var seq15971__$1 = cljs.core.next.call(null,seq15971);
return sodium.utils.camelize_map_keys.cljs$core$IFn$_invoke$arity$variadic(G__15972,seq15971__$1);
});

/**
 * Simple helper to show an error message in Clojure or ClojureScript
 */
sodium.utils.err = (function sodium$utils$err(var_args){
var args__10068__auto__ = [];
var len__10061__auto___15980 = arguments.length;
var i__10062__auto___15981 = (0);
while(true){
if((i__10062__auto___15981 < len__10061__auto___15980)){
args__10068__auto__.push((arguments[i__10062__auto___15981]));

var G__15982 = (i__10062__auto___15981 + (1));
i__10062__auto___15981 = G__15982;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return sodium.utils.err.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

sodium.utils.err.cljs$core$IFn$_invoke$arity$variadic = (function (strings){
return cljs.core.apply.call(null,console.error,strings);
});

sodium.utils.err.cljs$lang$maxFixedArity = (0);

sodium.utils.err.cljs$lang$applyTo = (function (seq15979){
return sodium.utils.err.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15979));
});

/**
 * Check that each of keys is present in universe.
 *   If not, check more carefully to report a useful warning to the console.
 *   [TODO] Note that this is not a 100% logical place for this function. It is
 *   ClojureScript runtime support for code generated by the defcontrol macro.
 */
sodium.utils.all_keys_valid_QMARK_ = (function sodium$utils$all_keys_valid_QMARK_(keys,universe){
if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.core.set_QMARK_,universe))){
} else {
throw (new Error("Assert failed: (validate set? universe)"));
}

if(cljs.core.truth_(clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,keys),cljs.core.set.call(null,universe)))){
return true;
} else {
return cljs.core.run_BANG_.call(null,(function (key){
if(cljs.core.contains_QMARK_.call(null,universe,key)){
return null;
} else {
return sodium.utils.err.call(null,"Keyword ",key," is invalid. Not in ",universe);
}
}),keys);
}
});

//# sourceMappingURL=utils.js.map
