// Compiled by ClojureScript 1.9.946 {}
goog.provide('sodium.extensions');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('re_frame.loggers');
goog.require('sodium.core');
goog.require('sodium.re_utils');
goog.require('sodium.utils');
sodium.extensions.header_maker = (function sodium$extensions$header_maker(title,size,dividing_QMARK_,sub_QMARK_){
if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"event","event",301435442)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.string_QMARK_,cljs.core.vector_QMARK_], null),null),title))){
} else {
throw (new Error("Assert failed: (utils/validate (s/or :string string? :event vector?) title)"));
}

if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.core.boolean_QMARK_,dividing_QMARK_))){
} else {
throw (new Error("Assert failed: (utils/validate boolean? dividing?)"));
}

if(cljs.core.truth_(sodium.utils.validate.call(null,new cljs.core.Keyword("sodium","size","sodium/size",352697062),size))){
} else {
throw (new Error("Assert failed: (utils/validate :sodium/size size)"));
}

return sodium.core.header.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"content","content",15833224),((cljs.core.vector_QMARK_.call(null,title))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sodium.re_utils._LT_sub.call(null,title))].join(''):title),new cljs.core.Keyword(null,"size","size",1098693007),size,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650),dividing_QMARK_,new cljs.core.Keyword(null,"sub?","sub?",768712042),sub_QMARK_], null));
});
/**
 * Large header. Title can be either a string or a subscription vector
 */
sodium.extensions.app_header = (function sodium$extensions$app_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"large","large",-196820544),true,false);
});
/**
 * Medium header. Title can be either a string or a subscription vector
 */
sodium.extensions.panel_header = (function sodium$extensions$panel_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"medium","medium",-1864319384),false,false);
});
/**
 * Small header. Title can be either a string or a subscription vector
 */
sodium.extensions.panel_subheader = (function sodium$extensions$panel_subheader(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"small","small",2133478704),false,false);
});
/**
 * Medium de-emphasized header. Title can be either a string or a subscription vector
 */
sodium.extensions.section_header = (function sodium$extensions$section_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"medium","medium",-1864319384),false,true);
});
/**
 * Small de-emphasized header. Title can be either a string or a subscription vector
 */
sodium.extensions.subsection_header = (function sodium$extensions$subsection_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"small","small",2133478704),false,true);
});
/**
 * Form field with a label and arbitrary content
 */
sodium.extensions.labelled_field = (function sodium$extensions$labelled_field(var_args){
var args__10068__auto__ = [];
var len__10061__auto___17129 = arguments.length;
var i__10062__auto___17130 = (0);
while(true){
if((i__10062__auto___17130 < len__10061__auto___17129)){
args__10068__auto__.push((arguments[i__10062__auto___17130]));

var G__17131 = (i__10062__auto___17130 + (1));
i__10062__auto___17130 = G__17131;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return sodium.extensions.labelled_field.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

sodium.extensions.labelled_field.cljs$core$IFn$_invoke$arity$variadic = (function (p__17126){
var map__17127 = p__17126;
var map__17127__$1 = ((((!((map__17127 == null)))?((((map__17127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17127.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17127):map__17127);
var label = cljs.core.get.call(null,map__17127__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var content = cljs.core.get.call(null,map__17127__$1,new cljs.core.Keyword(null,"content","content",15833224));
var field_key = cljs.core.get.call(null,map__17127__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var errors = cljs.core.get.call(null,map__17127__$1,new cljs.core.Keyword(null,"errors","errors",-908790718));
var inline_QMARK_ = cljs.core.get.call(null,map__17127__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var error = (function (){var and__8770__auto__ = field_key;
if(cljs.core.truth_(and__8770__auto__)){
return field_key.call(null,errors);
} else {
return and__8770__auto__;
}
})();
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.form_input,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"inline?","inline?",-1674483791),inline_QMARK_,new cljs.core.Keyword(null,"label","label",1718410804),label], null),content,(cljs.core.truth_(error)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.rail,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"position","position",-2011731912),"right",new cljs.core.Keyword(null,"attached?","attached?",548719296),true,new cljs.core.Keyword(null,"class-name","class-name",945142584),"errmsg"], null),error], null):null)], null);
});

sodium.extensions.labelled_field.cljs$lang$maxFixedArity = (0);

sodium.extensions.labelled_field.cljs$lang$applyTo = (function (seq17125){
return sodium.extensions.labelled_field.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17125));
});

re_frame.core.reg_sub.call(null,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332),(function (db,_){
return cljs.core.set.call(null,cljs.core.get.call(null,db,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332)));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332),(function (db,p__17132){
var vec__17133 = p__17132;
var _ = cljs.core.nth.call(null,vec__17133,(0),null);
var tags = cljs.core.nth.call(null,vec__17133,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332),cljs.core.set.call(null,tags));
}));
re_frame.core.reg_sub.call(null,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868),(function (db,_){
return cljs.core.set.call(null,cljs.core.get.call(null,db,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)));
}));
re_frame.core.reg_sub.call(null,new cljs.core.Keyword("sodium.extensions","class-of-tag","sodium.extensions/class-of-tag",-234755976),(function (db,p__17136){
var vec__17137 = p__17136;
var _ = cljs.core.nth.call(null,vec__17137,(0),null);
var tag = cljs.core.nth.call(null,vec__17137,(1),null);
return "tag";
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868),(function (db,p__17140){
var vec__17141 = p__17140;
var _ = cljs.core.nth.call(null,vec__17141,(0),null);
var tags = cljs.core.nth.call(null,vec__17141,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868),cljs.core.set.call(null,tags));
}));
/**
 * Draw one tag in a list of tags. See draw-tags
 */
sodium.extensions.draw_tag = (function sodium$extensions$draw_tag(p__17144,tag){
var map__17145 = p__17144;
var map__17145__$1 = ((((!((map__17145 == null)))?((((map__17145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17145.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17145):map__17145);
var selected_tags_sub = cljs.core.get.call(null,map__17145__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210));
var set_selected_tags_event = cljs.core.get.call(null,map__17145__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974));
var class_of_tag_sub = cljs.core.get.call(null,map__17145__$1,new cljs.core.Keyword(null,"class-of-tag-sub","class-of-tag-sub",1719088835));
var selected_class = cljs.core.get.call(null,map__17145__$1,new cljs.core.Keyword(null,"selected-class","selected-class",36062910));
var unselected_class = cljs.core.get.call(null,map__17145__$1,new cljs.core.Keyword(null,"unselected-class","unselected-class",-1415871608));
var selected_tags = sodium.re_utils._LT_sub.call(null,selected_tags_sub,cljs.core.PersistentHashSet.EMPTY);
var selected_QMARK_ = cljs.core.contains_QMARK_.call(null,selected_tags,tag);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.list_item,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),tag,new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (selected_tags,selected_QMARK_,map__17145,map__17145__$1,selected_tags_sub,set_selected_tags_event,class_of_tag_sub,selected_class,unselected_class){
return (function (){
return sodium.re_utils._GT_evt.call(null,cljs.core.conj.call(null,set_selected_tags_event,((selected_QMARK_)?cljs.core.disj:cljs.core.conj).call(null,selected_tags,tag)));
});})(selected_tags,selected_QMARK_,map__17145,map__17145__$1,selected_tags_sub,set_selected_tags_event,class_of_tag_sub,selected_class,unselected_class))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sodium.re_utils._LT_sub.call(null,cljs.core.conj.call(null,class_of_tag_sub,tag)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?selected_class:unselected_class))].join('')], null),tag], null)], null);
});
/**
 * Draw a list of tags. Formatting will depend on whether the tag is in the list of
 *   selected tags. Clicking on a tag will toggle it between selected and unselected.
 * 
 *   Options:
 *   - :selected-tags-sub       - Re-frame subscription that returns the set of selected tags
 *   - :set-selected-tags-event - Re-frame event that sets the set of selected tags
 *   - :class-of-tag-sub       - Re-frame subscription that returns the CSS class for a tag
 *   - :selected-class          - CSS class name for selected tags
 *   - :unselected-class        - CSS class name for unselected tags
 *   - :sort?                   - Should the list of tags be sorted
 * 
 *   - tags                     - Set or sequence of tags to display
 */
sodium.extensions.draw_tags = (function sodium$extensions$draw_tags(p__17147,tags){
var map__17148 = p__17147;
var map__17148__$1 = ((((!((map__17148 == null)))?((((map__17148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17148):map__17148);
var selected_tags_sub = cljs.core.get.call(null,map__17148__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var set_selected_tags_event = cljs.core.get.call(null,map__17148__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var class_of_tag_sub = cljs.core.get.call(null,map__17148__$1,new cljs.core.Keyword(null,"class-of-tag-sub","class-of-tag-sub",1719088835),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","class-of-tag","sodium.extensions/class-of-tag",-234755976)], null));
var selected_class = cljs.core.get.call(null,map__17148__$1,new cljs.core.Keyword(null,"selected-class","selected-class",36062910),"selected-tag");
var unselected_class = cljs.core.get.call(null,map__17148__$1,new cljs.core.Keyword(null,"unselected-class","unselected-class",-1415871608),"unselected-tag");
var sort_QMARK_ = cljs.core.get.call(null,map__17148__$1,new cljs.core.Keyword(null,"sort?","sort?",-567661924),true);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.list_na,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class-name","class-name",945142584),"tags",new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),true], null),cljs.core.doall.call(null,cljs.core.map.call(null,cljs.core.partial.call(null,sodium.extensions.draw_tag,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),selected_tags_sub,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),set_selected_tags_event,new cljs.core.Keyword(null,"class-of-tag-sub","class-of-tag-sub",1719088835),class_of_tag_sub,new cljs.core.Keyword(null,"selected-class","selected-class",36062910),selected_class,new cljs.core.Keyword(null,"unselected-class","unselected-class",-1415871608),unselected_class], null)),(cljs.core.truth_(sort_QMARK_)?sodium.utils.ci_sort.call(null,tags):tags)))], null);
});
/**
 * Component that lets the user add a tag (existing or new) to the set of selected tags.
 * 
 *   Options:
 *   - :all-tags-sub            - Re-frame subscription that returns the set of all tags
 *   - :selected-tags-sub       - Re-frame subscription that returns the set of selected tags
 *   - :set-selected-tags-event - Re-frame event that sets the set of selected tags
 *   - :partial-tag-text        - Atom to use to hold text of new tag before it is added. This
 *                             parameter is not often needed, but is important if something
 *                             outside us needs to watch our exact state. I use this, for
 *                             example, when I don't want to let a dialog close if the user
 *                             has started to create a new tag but has not yet saved it.   
 */
sodium.extensions.tag_adder = (function sodium$extensions$tag_adder(p__17150){
var map__17151 = p__17150;
var map__17151__$1 = ((((!((map__17151 == null)))?((((map__17151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17151.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17151):map__17151);
var all_tags_sub = cljs.core.get.call(null,map__17151__$1,new cljs.core.Keyword(null,"all-tags-sub","all-tags-sub",-522588948),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332)], null));
var selected_tags_sub = cljs.core.get.call(null,map__17151__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var set_selected_tags_event = cljs.core.get.call(null,map__17151__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var partial_tag_text = cljs.core.get.call(null,map__17151__$1,new cljs.core.Keyword(null,"partial-tag-text","partial-tag-text",-39027322),reagent.core.atom.call(null,""));
return ((function (map__17151,map__17151__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text){
return (function (){
var all_tags = sodium.re_utils._LT_sub.call(null,all_tags_sub);
var selected_tags = sodium.re_utils._LT_sub.call(null,selected_tags_sub,cljs.core.PersistentHashSet.EMPTY);
var available_tags = sodium.utils.ci_sort.call(null,clojure.set.difference.call(null,all_tags,selected_tags));
var list_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.call(null,"tags-"))].join('');
var input_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.call(null,"tags-input-"))].join('');
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.grid,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"container?","container?",-1563620041),true], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.grid_row,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.extensions.draw_tags,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),selected_tags_sub,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),set_selected_tags_event], null),selected_tags], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.grid_row,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"datalist","datalist",-1235043474)),(function (){var x__9736__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"id","id",-1388402092)),(function (){var x__9736__auto__ = list_id;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9736__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9736__auto__);
})(),(function (){var x__9736__auto__ = cljs.core.map.call(null,((function (all_tags,selected_tags,available_tags,list_id,input_id,map__17151,map__17151__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text){
return (function (tag){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),tag,new cljs.core.Keyword(null,"value","value",305978217),tag], null)], null);
});})(all_tags,selected_tags,available_tags,list_id,input_id,map__17151,map__17151__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text))
,available_tags);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9736__auto__);
})())))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.input,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"id","id",-1388402092),input_id,new cljs.core.Keyword(null,"list","list",765357683),list_id,new cljs.core.Keyword(null,"default-value","default-value",232220170),sodium.core._LT_atom.call(null,partial_tag_text,""),new cljs.core.Keyword(null,"on-change","on-change",-732046149),sodium.core._GT_atom.call(null,partial_tag_text),new cljs.core.Keyword(null,"action","action",-811238024),((cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,partial_tag_text)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"icon","icon",1679606541),"add",new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (all_tags,selected_tags,available_tags,list_id,input_id,map__17151,map__17151__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text){
return (function (){
var tag = cljs.core.conj.call(null,selected_tags,cljs.core.deref.call(null,partial_tag_text));
sodium.re_utils._GT_evt.call(null,cljs.core.conj.call(null,set_selected_tags_event,tag));

cljs.core.reset_BANG_.call(null,partial_tag_text,"");

return document.getElementById(input_id).value = "";
});})(all_tags,selected_tags,available_tags,list_id,input_id,map__17151,map__17151__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text))
], null)),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"add tag"], null)], null)], null)], null);
});
;})(map__17151,map__17151__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text))
});
/**
 * Component that lets the user select tags
 * 
 *   Options:
 *   - :all-tags-sub            - Re-frame subscription that returns the set of all tags
 *   - :selected-tags-sub       - Re-frame subscription that returns the set of selected tags
 *   - :set-selected-tags-event - Re-frame event that sets the set of selected tags
 */
sodium.extensions.tag_selector = (function sodium$extensions$tag_selector(p__17153){
var map__17154 = p__17153;
var map__17154__$1 = ((((!((map__17154 == null)))?((((map__17154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17154.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17154):map__17154);
var all_tags_sub = cljs.core.get.call(null,map__17154__$1,new cljs.core.Keyword(null,"all-tags-sub","all-tags-sub",-522588948),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332)], null));
var selected_tags_sub = cljs.core.get.call(null,map__17154__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var set_selected_tags_event = cljs.core.get.call(null,map__17154__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var available_tags = sodium.utils.ci_sort.call(null,sodium.re_utils._LT_sub.call(null,all_tags_sub));
var chosen_tags = sodium.utils.ci_sort.call(null,sodium.re_utils._LT_sub.call(null,selected_tags_sub,cljs.core.PersistentHashSet.EMPTY));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.dropdown,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"multiple?","multiple?",-490002283),true,new cljs.core.Keyword(null,"button?","button?",-1099897092),true,new cljs.core.Keyword(null,"value","value",305978217),chosen_tags,new cljs.core.Keyword(null,"on-change","on-change",-732046149),sodium.core._GT_event.call(null,set_selected_tags_event,cljs.core.PersistentHashSet.EMPTY,cljs.core.set),new cljs.core.Keyword(null,"options","options",99638489),sodium.core.dropdown_list.call(null,available_tags,cljs.core.identity,cljs.core.identity)], null)], null);
});
/**
 * Google advert component. See
 *   https://react.semantic-ui.com/views/advertisement and
 *   https://www.google.com/adsense.
 * 
 *   - unit, ad-client, ad-slot - Supplied by your Google ad campaign
 *   - test - Text to render instead of a real ad. You will typically supply
 *   this in your development builds.
 */
sodium.extensions.google_ad = (function sodium$extensions$google_ad(var_args){
var args__10068__auto__ = [];
var len__10061__auto___17163 = arguments.length;
var i__10062__auto___17164 = (0);
while(true){
if((i__10062__auto___17164 < len__10061__auto___17163)){
args__10068__auto__.push((arguments[i__10062__auto___17164]));

var G__17165 = (i__10062__auto___17164 + (1));
i__10062__auto___17164 = G__17165;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return sodium.extensions.google_ad.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

sodium.extensions.google_ad.cljs$core$IFn$_invoke$arity$variadic = (function (p__17157){
var map__17158 = p__17157;
var map__17158__$1 = ((((!((map__17158 == null)))?((((map__17158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17158.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17158):map__17158);
var unit = cljs.core.get.call(null,map__17158__$1,new cljs.core.Keyword(null,"unit","unit",375175175));
var ad_client = cljs.core.get.call(null,map__17158__$1,new cljs.core.Keyword(null,"ad-client","ad-client",541665022));
var ad_slot = cljs.core.get.call(null,map__17158__$1,new cljs.core.Keyword(null,"ad-slot","ad-slot",1817940310));
var test = cljs.core.get.call(null,map__17158__$1,new cljs.core.Keyword(null,"test","test",577538877));
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"google-ad",new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (map__17158,map__17158__$1,unit,ad_client,ad_slot,test){
return (function (){
if(cljs.core.truth_((function (){var and__8770__auto__ = window.adsbygoogle;
if(cljs.core.truth_(and__8770__auto__)){
return cljs.core.not.call(null,test);
} else {
return and__8770__auto__;
}
})())){
return window.adsbygoogle.push(cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
});})(map__17158,map__17158__$1,unit,ad_client,ad_slot,test))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (map__17158,map__17158__$1,unit,ad_client,ad_slot,test){
return (function() { 
var G__17166__delegate = function (p__17160){
var map__17161 = p__17160;
var map__17161__$1 = ((((!((map__17161 == null)))?((((map__17161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17161):map__17161);
var unit__$1 = cljs.core.get.call(null,map__17161__$1,new cljs.core.Keyword(null,"unit","unit",375175175));
var ad_client__$1 = cljs.core.get.call(null,map__17161__$1,new cljs.core.Keyword(null,"ad-client","ad-client",541665022));
var ad_slot__$1 = cljs.core.get.call(null,map__17161__$1,new cljs.core.Keyword(null,"ad-slot","ad-slot",1817940310));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.advertisement,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"unit","unit",375175175),unit__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703),true,new cljs.core.Keyword(null,"test","test",577538877),test], null),(cljs.core.truth_(test)?null:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ins","ins",-1021983570),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"class-name","class-name",945142584),"adsbygoogle",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"block"], null),new cljs.core.Keyword(null,"data-ad-format","data-ad-format",679441596),"auto",new cljs.core.Keyword(null,"data-ad-client","data-ad-client",2116702865),ad_client__$1,new cljs.core.Keyword(null,"data-ad-slot","data-ad-slot",-1374104396),ad_slot__$1], null)], null))], null);
};
var G__17166 = function (var_args){
var p__17160 = null;
if (arguments.length > 0) {
var G__17167__i = 0, G__17167__a = new Array(arguments.length -  0);
while (G__17167__i < G__17167__a.length) {G__17167__a[G__17167__i] = arguments[G__17167__i + 0]; ++G__17167__i;}
  p__17160 = new cljs.core.IndexedSeq(G__17167__a,0,null);
} 
return G__17166__delegate.call(this,p__17160);};
G__17166.cljs$lang$maxFixedArity = 0;
G__17166.cljs$lang$applyTo = (function (arglist__17168){
var p__17160 = cljs.core.seq(arglist__17168);
return G__17166__delegate(p__17160);
});
G__17166.cljs$core$IFn$_invoke$arity$variadic = G__17166__delegate;
return G__17166;
})()
;})(map__17158,map__17158__$1,unit,ad_client,ad_slot,test))
], null));
});

sodium.extensions.google_ad.cljs$lang$maxFixedArity = (0);

sodium.extensions.google_ad.cljs$lang$applyTo = (function (seq17156){
return sodium.extensions.google_ad.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17156));
});


//# sourceMappingURL=extensions.js.map
