// Compiled by ClojureScript 1.9.946 {}
goog.provide('iron.re_utils');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
goog.require('re_frame.core');
goog.require('iron.utils');
/**
 * Shorthand for simple 'layer 2` usage of re-sub
 */
iron.re_utils.sub2 = (function iron$re_utils$sub2(key,db_path){
return re_frame.core.reg_sub.call(null,key,(function (db,_){
return cljs.core.get_in.call(null,db,db_path);
}));
});
/**
 * Shorthand for re-frame dispatch to event.
 */
iron.re_utils._GT_evt = re_frame.core.dispatch;
/**
 * Shorthand for re-frame subscribe and deref.
 */
iron.re_utils._LT_sub = (function iron$re_utils$_LT_sub(var_args){
var G__11921 = arguments.length;
switch (G__11921) {
case 1:
return iron.re_utils._LT_sub.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return iron.re_utils._LT_sub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

iron.re_utils._LT_sub.cljs$core$IFn$_invoke$arity$1 = (function (subscription){
return cljs.core.deref.call(null,re_frame.core.subscribe.call(null,subscription));
});

iron.re_utils._LT_sub.cljs$core$IFn$_invoke$arity$2 = (function (subscription,default$){
var or__8782__auto__ = iron.re_utils._LT_sub.call(null,subscription);
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return default$;
}
});

iron.re_utils._LT_sub.cljs$lang$maxFixedArity = 2;

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("re-frame","vec-or-fn","re-frame/vec-or-fn",-1395135769),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"event-or-sub","event-or-sub",-336374219),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"event-or-sub","event-or-sub",-336374219),new cljs.core.Keyword(null,"function","function",-2127255473)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.core.fn_QMARK_], null),null));
iron.re_utils.vec__GT_fn = (function iron$re_utils$vec__GT_fn(vec_or_fn,key_fn){
if(cljs.core.truth_(iron.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("re-frame","vec-or-fn","re-frame/vec-or-fn",-1395135769),new cljs.core.Keyword("re-frame","vec-or-fn","re-frame/vec-or-fn",-1395135769),null),vec_or_fn))){
} else {
throw (new Error("Assert failed: (utils/validate (s/nilable :re-frame/vec-or-fn) vec-or-fn)"));
}

var _PERCENT_ = ((cljs.core.vector_QMARK_.call(null,vec_or_fn))?(function (p1__11923_SHARP_){
return key_fn.call(null,cljs.core.conj.call(null,vec_or_fn,p1__11923_SHARP_));
}):vec_or_fn);
if(cljs.core.fn_QMARK_){
} else {
throw (new Error("Assert failed: fn?"));
}

if(cljs.core.truth_(_PERCENT_)){
} else {
throw (new Error("Assert failed: %"));
}

return _PERCENT_;
});
/**
 * For contexts that want to pass an argument to a sink function: accept
 *   either a function or a re-frame event vector.
 *   If a vector is received, convert it to a function that dispatches to that
 *   event, with the parameter conj'd on to the end.
 */
iron.re_utils.event__GT_fn = (function iron$re_utils$event__GT_fn(event_or_fn){
return iron.re_utils.vec__GT_fn.call(null,event_or_fn,iron.re_utils._GT_evt);
});
iron.re_utils.sub__GT_fn = (function iron$re_utils$sub__GT_fn(sub_or_fn){
return iron.re_utils.vec__GT_fn.call(null,sub_or_fn,iron.re_utils._LT_sub);
});

//# sourceMappingURL=re_utils.js.map
