// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__15903 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__15904 = null;
var count__15905 = (0);
var i__15906 = (0);
while(true){
if((i__15906 < count__15905)){
var vec__15907 = cljs.core._nth.call(null,chunk__15904,i__15906);
var effect_key = cljs.core.nth.call(null,vec__15907,(0),null);
var effect_value = cljs.core.nth.call(null,vec__15907,(1),null);
var temp__5455__auto___15913 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___15913)){
var effect_fn_15914 = temp__5455__auto___15913;
effect_fn_15914.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__15915 = seq__15903;
var G__15916 = chunk__15904;
var G__15917 = count__15905;
var G__15918 = (i__15906 + (1));
seq__15903 = G__15915;
chunk__15904 = G__15916;
count__15905 = G__15917;
i__15906 = G__15918;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__15903);
if(temp__5457__auto__){
var seq__15903__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__15903__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__15903__$1);
var G__15919 = cljs.core.chunk_rest.call(null,seq__15903__$1);
var G__15920 = c__9713__auto__;
var G__15921 = cljs.core.count.call(null,c__9713__auto__);
var G__15922 = (0);
seq__15903 = G__15919;
chunk__15904 = G__15920;
count__15905 = G__15921;
i__15906 = G__15922;
continue;
} else {
var vec__15910 = cljs.core.first.call(null,seq__15903__$1);
var effect_key = cljs.core.nth.call(null,vec__15910,(0),null);
var effect_value = cljs.core.nth.call(null,vec__15910,(1),null);
var temp__5455__auto___15923 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___15923)){
var effect_fn_15924 = temp__5455__auto___15923;
effect_fn_15924.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__15925 = cljs.core.next.call(null,seq__15903__$1);
var G__15926 = null;
var G__15927 = (0);
var G__15928 = (0);
seq__15903 = G__15925;
chunk__15904 = G__15926;
count__15905 = G__15927;
i__15906 = G__15928;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__15929 = cljs.core.seq.call(null,value);
var chunk__15930 = null;
var count__15931 = (0);
var i__15932 = (0);
while(true){
if((i__15932 < count__15931)){
var map__15933 = cljs.core._nth.call(null,chunk__15930,i__15932);
var map__15933__$1 = ((((!((map__15933 == null)))?((((map__15933.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15933.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15933):map__15933);
var effect = map__15933__$1;
var ms = cljs.core.get.call(null,map__15933__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__15933__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__15929,chunk__15930,count__15931,i__15932,map__15933,map__15933__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__15929,chunk__15930,count__15931,i__15932,map__15933,map__15933__$1,effect,ms,dispatch))
,ms);
}

var G__15937 = seq__15929;
var G__15938 = chunk__15930;
var G__15939 = count__15931;
var G__15940 = (i__15932 + (1));
seq__15929 = G__15937;
chunk__15930 = G__15938;
count__15931 = G__15939;
i__15932 = G__15940;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__15929);
if(temp__5457__auto__){
var seq__15929__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__15929__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__15929__$1);
var G__15941 = cljs.core.chunk_rest.call(null,seq__15929__$1);
var G__15942 = c__9713__auto__;
var G__15943 = cljs.core.count.call(null,c__9713__auto__);
var G__15944 = (0);
seq__15929 = G__15941;
chunk__15930 = G__15942;
count__15931 = G__15943;
i__15932 = G__15944;
continue;
} else {
var map__15935 = cljs.core.first.call(null,seq__15929__$1);
var map__15935__$1 = ((((!((map__15935 == null)))?((((map__15935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15935.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15935):map__15935);
var effect = map__15935__$1;
var ms = cljs.core.get.call(null,map__15935__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__15935__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__15929,chunk__15930,count__15931,i__15932,map__15935,map__15935__$1,effect,ms,dispatch,seq__15929__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__15929,chunk__15930,count__15931,i__15932,map__15935,map__15935__$1,effect,ms,dispatch,seq__15929__$1,temp__5457__auto__))
,ms);
}

var G__15945 = cljs.core.next.call(null,seq__15929__$1);
var G__15946 = null;
var G__15947 = (0);
var G__15948 = (0);
seq__15929 = G__15945;
chunk__15930 = G__15946;
count__15931 = G__15947;
i__15932 = G__15948;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__15949 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__15950 = null;
var count__15951 = (0);
var i__15952 = (0);
while(true){
if((i__15952 < count__15951)){
var event = cljs.core._nth.call(null,chunk__15950,i__15952);
re_frame.router.dispatch.call(null,event);

var G__15953 = seq__15949;
var G__15954 = chunk__15950;
var G__15955 = count__15951;
var G__15956 = (i__15952 + (1));
seq__15949 = G__15953;
chunk__15950 = G__15954;
count__15951 = G__15955;
i__15952 = G__15956;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__15949);
if(temp__5457__auto__){
var seq__15949__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__15949__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__15949__$1);
var G__15957 = cljs.core.chunk_rest.call(null,seq__15949__$1);
var G__15958 = c__9713__auto__;
var G__15959 = cljs.core.count.call(null,c__9713__auto__);
var G__15960 = (0);
seq__15949 = G__15957;
chunk__15950 = G__15958;
count__15951 = G__15959;
i__15952 = G__15960;
continue;
} else {
var event = cljs.core.first.call(null,seq__15949__$1);
re_frame.router.dispatch.call(null,event);

var G__15961 = cljs.core.next.call(null,seq__15949__$1);
var G__15962 = null;
var G__15963 = (0);
var G__15964 = (0);
seq__15949 = G__15961;
chunk__15950 = G__15962;
count__15951 = G__15963;
i__15952 = G__15964;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__15965 = cljs.core.seq.call(null,value);
var chunk__15966 = null;
var count__15967 = (0);
var i__15968 = (0);
while(true){
if((i__15968 < count__15967)){
var event = cljs.core._nth.call(null,chunk__15966,i__15968);
clear_event.call(null,event);

var G__15969 = seq__15965;
var G__15970 = chunk__15966;
var G__15971 = count__15967;
var G__15972 = (i__15968 + (1));
seq__15965 = G__15969;
chunk__15966 = G__15970;
count__15967 = G__15971;
i__15968 = G__15972;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__15965);
if(temp__5457__auto__){
var seq__15965__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__15965__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__15965__$1);
var G__15973 = cljs.core.chunk_rest.call(null,seq__15965__$1);
var G__15974 = c__9713__auto__;
var G__15975 = cljs.core.count.call(null,c__9713__auto__);
var G__15976 = (0);
seq__15965 = G__15973;
chunk__15966 = G__15974;
count__15967 = G__15975;
i__15968 = G__15976;
continue;
} else {
var event = cljs.core.first.call(null,seq__15965__$1);
clear_event.call(null,event);

var G__15977 = cljs.core.next.call(null,seq__15965__$1);
var G__15978 = null;
var G__15979 = (0);
var G__15980 = (0);
seq__15965 = G__15977;
chunk__15966 = G__15978;
count__15967 = G__15979;
i__15968 = G__15980;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map
