goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35228 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35228(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35229 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35229(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__33541 = coll;
var G__33542 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__33541,G__33542) : shadow.dom.lazy_native_coll_seq.call(null,G__33541,G__33542));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__33609 = arguments.length;
switch (G__33609) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__33621 = arguments.length;
switch (G__33621) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__33632 = arguments.length;
switch (G__33632) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__33646 = arguments.length;
switch (G__33646) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33662 = arguments.length;
switch (G__33662) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33689 = arguments.length;
switch (G__33689) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33711){if((e33711 instanceof Object)){
var e = e33711;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33711;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33733 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33734 = null;
var count__33735 = (0);
var i__33736 = (0);
while(true){
if((i__33736 < count__33735)){
var el = chunk__33734.cljs$core$IIndexed$_nth$arity$2(null,i__33736);
var handler_35268__$1 = ((function (seq__33733,chunk__33734,count__33735,i__33736,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33733,chunk__33734,count__33735,i__33736,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35268__$1);


var G__35269 = seq__33733;
var G__35270 = chunk__33734;
var G__35271 = count__33735;
var G__35272 = (i__33736 + (1));
seq__33733 = G__35269;
chunk__33734 = G__35270;
count__33735 = G__35271;
i__33736 = G__35272;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33733);
if(temp__5804__auto__){
var seq__33733__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33733__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33733__$1);
var G__35273 = cljs.core.chunk_rest(seq__33733__$1);
var G__35274 = c__5568__auto__;
var G__35275 = cljs.core.count(c__5568__auto__);
var G__35276 = (0);
seq__33733 = G__35273;
chunk__33734 = G__35274;
count__33735 = G__35275;
i__33736 = G__35276;
continue;
} else {
var el = cljs.core.first(seq__33733__$1);
var handler_35277__$1 = ((function (seq__33733,chunk__33734,count__33735,i__33736,el,seq__33733__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33733,chunk__33734,count__33735,i__33736,el,seq__33733__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35277__$1);


var G__35278 = cljs.core.next(seq__33733__$1);
var G__35279 = null;
var G__35280 = (0);
var G__35281 = (0);
seq__33733 = G__35278;
chunk__33734 = G__35279;
count__33735 = G__35280;
i__33736 = G__35281;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33781 = arguments.length;
switch (G__33781) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33817 = cljs.core.seq(events);
var chunk__33818 = null;
var count__33819 = (0);
var i__33820 = (0);
while(true){
if((i__33820 < count__33819)){
var vec__33844 = chunk__33818.cljs$core$IIndexed$_nth$arity$2(null,i__33820);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33844,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33844,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35283 = seq__33817;
var G__35284 = chunk__33818;
var G__35285 = count__33819;
var G__35286 = (i__33820 + (1));
seq__33817 = G__35283;
chunk__33818 = G__35284;
count__33819 = G__35285;
i__33820 = G__35286;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33817);
if(temp__5804__auto__){
var seq__33817__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33817__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33817__$1);
var G__35287 = cljs.core.chunk_rest(seq__33817__$1);
var G__35288 = c__5568__auto__;
var G__35289 = cljs.core.count(c__5568__auto__);
var G__35290 = (0);
seq__33817 = G__35287;
chunk__33818 = G__35288;
count__33819 = G__35289;
i__33820 = G__35290;
continue;
} else {
var vec__33855 = cljs.core.first(seq__33817__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33855,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33855,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35291 = cljs.core.next(seq__33817__$1);
var G__35292 = null;
var G__35293 = (0);
var G__35294 = (0);
seq__33817 = G__35291;
chunk__33818 = G__35292;
count__33819 = G__35293;
i__33820 = G__35294;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__33867 = cljs.core.seq(styles);
var chunk__33869 = null;
var count__33870 = (0);
var i__33871 = (0);
while(true){
if((i__33871 < count__33870)){
var vec__33892 = chunk__33869.cljs$core$IIndexed$_nth$arity$2(null,i__33871);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33892,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33892,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35295 = seq__33867;
var G__35296 = chunk__33869;
var G__35297 = count__33870;
var G__35298 = (i__33871 + (1));
seq__33867 = G__35295;
chunk__33869 = G__35296;
count__33870 = G__35297;
i__33871 = G__35298;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33867);
if(temp__5804__auto__){
var seq__33867__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33867__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33867__$1);
var G__35299 = cljs.core.chunk_rest(seq__33867__$1);
var G__35300 = c__5568__auto__;
var G__35301 = cljs.core.count(c__5568__auto__);
var G__35302 = (0);
seq__33867 = G__35299;
chunk__33869 = G__35300;
count__33870 = G__35301;
i__33871 = G__35302;
continue;
} else {
var vec__33902 = cljs.core.first(seq__33867__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33902,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33902,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35303 = cljs.core.next(seq__33867__$1);
var G__35304 = null;
var G__35305 = (0);
var G__35306 = (0);
seq__33867 = G__35303;
chunk__33869 = G__35304;
count__33870 = G__35305;
i__33871 = G__35306;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__33926_35307 = key;
var G__33926_35308__$1 = (((G__33926_35307 instanceof cljs.core.Keyword))?G__33926_35307.fqn:null);
switch (G__33926_35308__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35311 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35311,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35311,"aria-");
}
})())){
el.setAttribute(ks_35311,value);
} else {
(el[ks_35311] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__33997){
var map__33999 = p__33997;
var map__33999__$1 = cljs.core.__destructure_map(map__33999);
var props = map__33999__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33999__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34000 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34000,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34000,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34000,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34013 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34013,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34013;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34028 = arguments.length;
switch (G__34028) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34042){
var vec__34045 = p__34042;
var seq__34046 = cljs.core.seq(vec__34045);
var first__34047 = cljs.core.first(seq__34046);
var seq__34046__$1 = cljs.core.next(seq__34046);
var nn = first__34047;
var first__34047__$1 = cljs.core.first(seq__34046__$1);
var seq__34046__$2 = cljs.core.next(seq__34046__$1);
var np = first__34047__$1;
var nc = seq__34046__$2;
var node = vec__34045;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34058 = nn;
var G__34059 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34058,G__34059) : create_fn.call(null,G__34058,G__34059));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34062 = nn;
var G__34063 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34062,G__34063) : create_fn.call(null,G__34062,G__34063));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34073 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34073,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34073,(1),null);
var seq__34080_35337 = cljs.core.seq(node_children);
var chunk__34081_35338 = null;
var count__34082_35339 = (0);
var i__34083_35340 = (0);
while(true){
if((i__34083_35340 < count__34082_35339)){
var child_struct_35341 = chunk__34081_35338.cljs$core$IIndexed$_nth$arity$2(null,i__34083_35340);
var children_35342 = shadow.dom.dom_node(child_struct_35341);
if(cljs.core.seq_QMARK_(children_35342)){
var seq__34153_35343 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35342));
var chunk__34155_35344 = null;
var count__34156_35345 = (0);
var i__34157_35346 = (0);
while(true){
if((i__34157_35346 < count__34156_35345)){
var child_35347 = chunk__34155_35344.cljs$core$IIndexed$_nth$arity$2(null,i__34157_35346);
if(cljs.core.truth_(child_35347)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35347);


var G__35348 = seq__34153_35343;
var G__35349 = chunk__34155_35344;
var G__35350 = count__34156_35345;
var G__35351 = (i__34157_35346 + (1));
seq__34153_35343 = G__35348;
chunk__34155_35344 = G__35349;
count__34156_35345 = G__35350;
i__34157_35346 = G__35351;
continue;
} else {
var G__35352 = seq__34153_35343;
var G__35353 = chunk__34155_35344;
var G__35354 = count__34156_35345;
var G__35355 = (i__34157_35346 + (1));
seq__34153_35343 = G__35352;
chunk__34155_35344 = G__35353;
count__34156_35345 = G__35354;
i__34157_35346 = G__35355;
continue;
}
} else {
var temp__5804__auto___35356 = cljs.core.seq(seq__34153_35343);
if(temp__5804__auto___35356){
var seq__34153_35357__$1 = temp__5804__auto___35356;
if(cljs.core.chunked_seq_QMARK_(seq__34153_35357__$1)){
var c__5568__auto___35359 = cljs.core.chunk_first(seq__34153_35357__$1);
var G__35361 = cljs.core.chunk_rest(seq__34153_35357__$1);
var G__35362 = c__5568__auto___35359;
var G__35363 = cljs.core.count(c__5568__auto___35359);
var G__35364 = (0);
seq__34153_35343 = G__35361;
chunk__34155_35344 = G__35362;
count__34156_35345 = G__35363;
i__34157_35346 = G__35364;
continue;
} else {
var child_35366 = cljs.core.first(seq__34153_35357__$1);
if(cljs.core.truth_(child_35366)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35366);


var G__35367 = cljs.core.next(seq__34153_35357__$1);
var G__35368 = null;
var G__35369 = (0);
var G__35370 = (0);
seq__34153_35343 = G__35367;
chunk__34155_35344 = G__35368;
count__34156_35345 = G__35369;
i__34157_35346 = G__35370;
continue;
} else {
var G__35372 = cljs.core.next(seq__34153_35357__$1);
var G__35373 = null;
var G__35374 = (0);
var G__35375 = (0);
seq__34153_35343 = G__35372;
chunk__34155_35344 = G__35373;
count__34156_35345 = G__35374;
i__34157_35346 = G__35375;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35342);
}


var G__35376 = seq__34080_35337;
var G__35377 = chunk__34081_35338;
var G__35378 = count__34082_35339;
var G__35379 = (i__34083_35340 + (1));
seq__34080_35337 = G__35376;
chunk__34081_35338 = G__35377;
count__34082_35339 = G__35378;
i__34083_35340 = G__35379;
continue;
} else {
var temp__5804__auto___35380 = cljs.core.seq(seq__34080_35337);
if(temp__5804__auto___35380){
var seq__34080_35381__$1 = temp__5804__auto___35380;
if(cljs.core.chunked_seq_QMARK_(seq__34080_35381__$1)){
var c__5568__auto___35382 = cljs.core.chunk_first(seq__34080_35381__$1);
var G__35383 = cljs.core.chunk_rest(seq__34080_35381__$1);
var G__35384 = c__5568__auto___35382;
var G__35385 = cljs.core.count(c__5568__auto___35382);
var G__35386 = (0);
seq__34080_35337 = G__35383;
chunk__34081_35338 = G__35384;
count__34082_35339 = G__35385;
i__34083_35340 = G__35386;
continue;
} else {
var child_struct_35387 = cljs.core.first(seq__34080_35381__$1);
var children_35388 = shadow.dom.dom_node(child_struct_35387);
if(cljs.core.seq_QMARK_(children_35388)){
var seq__34182_35389 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35388));
var chunk__34184_35390 = null;
var count__34185_35391 = (0);
var i__34186_35392 = (0);
while(true){
if((i__34186_35392 < count__34185_35391)){
var child_35393 = chunk__34184_35390.cljs$core$IIndexed$_nth$arity$2(null,i__34186_35392);
if(cljs.core.truth_(child_35393)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35393);


var G__35394 = seq__34182_35389;
var G__35395 = chunk__34184_35390;
var G__35396 = count__34185_35391;
var G__35397 = (i__34186_35392 + (1));
seq__34182_35389 = G__35394;
chunk__34184_35390 = G__35395;
count__34185_35391 = G__35396;
i__34186_35392 = G__35397;
continue;
} else {
var G__35398 = seq__34182_35389;
var G__35399 = chunk__34184_35390;
var G__35400 = count__34185_35391;
var G__35401 = (i__34186_35392 + (1));
seq__34182_35389 = G__35398;
chunk__34184_35390 = G__35399;
count__34185_35391 = G__35400;
i__34186_35392 = G__35401;
continue;
}
} else {
var temp__5804__auto___35402__$1 = cljs.core.seq(seq__34182_35389);
if(temp__5804__auto___35402__$1){
var seq__34182_35403__$1 = temp__5804__auto___35402__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34182_35403__$1)){
var c__5568__auto___35404 = cljs.core.chunk_first(seq__34182_35403__$1);
var G__35406 = cljs.core.chunk_rest(seq__34182_35403__$1);
var G__35407 = c__5568__auto___35404;
var G__35408 = cljs.core.count(c__5568__auto___35404);
var G__35409 = (0);
seq__34182_35389 = G__35406;
chunk__34184_35390 = G__35407;
count__34185_35391 = G__35408;
i__34186_35392 = G__35409;
continue;
} else {
var child_35410 = cljs.core.first(seq__34182_35403__$1);
if(cljs.core.truth_(child_35410)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35410);


var G__35411 = cljs.core.next(seq__34182_35403__$1);
var G__35412 = null;
var G__35413 = (0);
var G__35414 = (0);
seq__34182_35389 = G__35411;
chunk__34184_35390 = G__35412;
count__34185_35391 = G__35413;
i__34186_35392 = G__35414;
continue;
} else {
var G__35415 = cljs.core.next(seq__34182_35403__$1);
var G__35416 = null;
var G__35417 = (0);
var G__35418 = (0);
seq__34182_35389 = G__35415;
chunk__34184_35390 = G__35416;
count__34185_35391 = G__35417;
i__34186_35392 = G__35418;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35388);
}


var G__35419 = cljs.core.next(seq__34080_35381__$1);
var G__35420 = null;
var G__35421 = (0);
var G__35422 = (0);
seq__34080_35337 = G__35419;
chunk__34081_35338 = G__35420;
count__34082_35339 = G__35421;
i__34083_35340 = G__35422;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34210 = cljs.core.seq(node);
var chunk__34211 = null;
var count__34212 = (0);
var i__34213 = (0);
while(true){
if((i__34213 < count__34212)){
var n = chunk__34211.cljs$core$IIndexed$_nth$arity$2(null,i__34213);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35428 = seq__34210;
var G__35429 = chunk__34211;
var G__35430 = count__34212;
var G__35431 = (i__34213 + (1));
seq__34210 = G__35428;
chunk__34211 = G__35429;
count__34212 = G__35430;
i__34213 = G__35431;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34210);
if(temp__5804__auto__){
var seq__34210__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34210__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34210__$1);
var G__35432 = cljs.core.chunk_rest(seq__34210__$1);
var G__35433 = c__5568__auto__;
var G__35434 = cljs.core.count(c__5568__auto__);
var G__35435 = (0);
seq__34210 = G__35432;
chunk__34211 = G__35433;
count__34212 = G__35434;
i__34213 = G__35435;
continue;
} else {
var n = cljs.core.first(seq__34210__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35437 = cljs.core.next(seq__34210__$1);
var G__35438 = null;
var G__35439 = (0);
var G__35440 = (0);
seq__34210 = G__35437;
chunk__34211 = G__35438;
count__34212 = G__35439;
i__34213 = G__35440;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34234 = arguments.length;
switch (G__34234) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34247 = arguments.length;
switch (G__34247) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34262 = arguments.length;
switch (G__34262) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35458 = arguments.length;
var i__5770__auto___35459 = (0);
while(true){
if((i__5770__auto___35459 < len__5769__auto___35458)){
args__5775__auto__.push((arguments[i__5770__auto___35459]));

var G__35460 = (i__5770__auto___35459 + (1));
i__5770__auto___35459 = G__35460;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34299_35462 = cljs.core.seq(nodes);
var chunk__34300_35463 = null;
var count__34301_35464 = (0);
var i__34302_35465 = (0);
while(true){
if((i__34302_35465 < count__34301_35464)){
var node_35466 = chunk__34300_35463.cljs$core$IIndexed$_nth$arity$2(null,i__34302_35465);
fragment.appendChild(shadow.dom._to_dom(node_35466));


var G__35467 = seq__34299_35462;
var G__35468 = chunk__34300_35463;
var G__35469 = count__34301_35464;
var G__35470 = (i__34302_35465 + (1));
seq__34299_35462 = G__35467;
chunk__34300_35463 = G__35468;
count__34301_35464 = G__35469;
i__34302_35465 = G__35470;
continue;
} else {
var temp__5804__auto___35471 = cljs.core.seq(seq__34299_35462);
if(temp__5804__auto___35471){
var seq__34299_35472__$1 = temp__5804__auto___35471;
if(cljs.core.chunked_seq_QMARK_(seq__34299_35472__$1)){
var c__5568__auto___35473 = cljs.core.chunk_first(seq__34299_35472__$1);
var G__35474 = cljs.core.chunk_rest(seq__34299_35472__$1);
var G__35475 = c__5568__auto___35473;
var G__35476 = cljs.core.count(c__5568__auto___35473);
var G__35477 = (0);
seq__34299_35462 = G__35474;
chunk__34300_35463 = G__35475;
count__34301_35464 = G__35476;
i__34302_35465 = G__35477;
continue;
} else {
var node_35478 = cljs.core.first(seq__34299_35472__$1);
fragment.appendChild(shadow.dom._to_dom(node_35478));


var G__35479 = cljs.core.next(seq__34299_35472__$1);
var G__35480 = null;
var G__35481 = (0);
var G__35482 = (0);
seq__34299_35462 = G__35479;
chunk__34300_35463 = G__35480;
count__34301_35464 = G__35481;
i__34302_35465 = G__35482;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34291){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34291));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34327_35484 = cljs.core.seq(scripts);
var chunk__34328_35485 = null;
var count__34329_35486 = (0);
var i__34330_35487 = (0);
while(true){
if((i__34330_35487 < count__34329_35486)){
var vec__34373_35489 = chunk__34328_35485.cljs$core$IIndexed$_nth$arity$2(null,i__34330_35487);
var script_tag_35490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34373_35489,(0),null);
var script_body_35491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34373_35489,(1),null);
eval(script_body_35491);


var G__35492 = seq__34327_35484;
var G__35493 = chunk__34328_35485;
var G__35494 = count__34329_35486;
var G__35495 = (i__34330_35487 + (1));
seq__34327_35484 = G__35492;
chunk__34328_35485 = G__35493;
count__34329_35486 = G__35494;
i__34330_35487 = G__35495;
continue;
} else {
var temp__5804__auto___35496 = cljs.core.seq(seq__34327_35484);
if(temp__5804__auto___35496){
var seq__34327_35497__$1 = temp__5804__auto___35496;
if(cljs.core.chunked_seq_QMARK_(seq__34327_35497__$1)){
var c__5568__auto___35498 = cljs.core.chunk_first(seq__34327_35497__$1);
var G__35500 = cljs.core.chunk_rest(seq__34327_35497__$1);
var G__35501 = c__5568__auto___35498;
var G__35502 = cljs.core.count(c__5568__auto___35498);
var G__35503 = (0);
seq__34327_35484 = G__35500;
chunk__34328_35485 = G__35501;
count__34329_35486 = G__35502;
i__34330_35487 = G__35503;
continue;
} else {
var vec__34385_35504 = cljs.core.first(seq__34327_35497__$1);
var script_tag_35505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34385_35504,(0),null);
var script_body_35506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34385_35504,(1),null);
eval(script_body_35506);


var G__35512 = cljs.core.next(seq__34327_35497__$1);
var G__35513 = null;
var G__35514 = (0);
var G__35515 = (0);
seq__34327_35484 = G__35512;
chunk__34328_35485 = G__35513;
count__34329_35486 = G__35514;
i__34330_35487 = G__35515;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__34389){
var vec__34391 = p__34389;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34391,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34391,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__34425 = arguments.length;
switch (G__34425) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__34489 = cljs.core.seq(style_keys);
var chunk__34490 = null;
var count__34491 = (0);
var i__34492 = (0);
while(true){
if((i__34492 < count__34491)){
var it = chunk__34490.cljs$core$IIndexed$_nth$arity$2(null,i__34492);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35523 = seq__34489;
var G__35524 = chunk__34490;
var G__35525 = count__34491;
var G__35526 = (i__34492 + (1));
seq__34489 = G__35523;
chunk__34490 = G__35524;
count__34491 = G__35525;
i__34492 = G__35526;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34489);
if(temp__5804__auto__){
var seq__34489__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34489__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34489__$1);
var G__35527 = cljs.core.chunk_rest(seq__34489__$1);
var G__35528 = c__5568__auto__;
var G__35529 = cljs.core.count(c__5568__auto__);
var G__35530 = (0);
seq__34489 = G__35527;
chunk__34490 = G__35528;
count__34491 = G__35529;
i__34492 = G__35530;
continue;
} else {
var it = cljs.core.first(seq__34489__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35531 = cljs.core.next(seq__34489__$1);
var G__35532 = null;
var G__35533 = (0);
var G__35534 = (0);
seq__34489 = G__35531;
chunk__34490 = G__35532;
count__34491 = G__35533;
i__34492 = G__35534;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34501,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34516 = k34501;
var G__34516__$1 = (((G__34516 instanceof cljs.core.Keyword))?G__34516.fqn:null);
switch (G__34516__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34501,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34517){
var vec__34518 = p__34517;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34518,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34518,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34500){
var self__ = this;
var G__34500__$1 = this;
return (new cljs.core.RecordIter((0),G__34500__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34503,other34504){
var self__ = this;
var this34503__$1 = this;
return (((!((other34504 == null)))) && ((((this34503__$1.constructor === other34504.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34503__$1.x,other34504.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34503__$1.y,other34504.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34503__$1.__extmap,other34504.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34501){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34551 = k34501;
var G__34551__$1 = (((G__34551 instanceof cljs.core.Keyword))?G__34551.fqn:null);
switch (G__34551__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34501);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34500){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34553 = cljs.core.keyword_identical_QMARK_;
var expr__34554 = k__5352__auto__;
if(cljs.core.truth_((pred__34553.cljs$core$IFn$_invoke$arity$2 ? pred__34553.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__34554) : pred__34553.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__34554)))){
return (new shadow.dom.Coordinate(G__34500,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34553.cljs$core$IFn$_invoke$arity$2 ? pred__34553.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__34554) : pred__34553.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__34554)))){
return (new shadow.dom.Coordinate(self__.x,G__34500,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34500),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34500){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__34500,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__34511){
var extmap__5385__auto__ = (function (){var G__34573 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34511,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__34511)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34573);
} else {
return G__34573;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__34511),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__34511),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34582,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34603 = k34582;
var G__34603__$1 = (((G__34603 instanceof cljs.core.Keyword))?G__34603.fqn:null);
switch (G__34603__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34582,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34607){
var vec__34608 = p__34607;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34608,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34608,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34581){
var self__ = this;
var G__34581__$1 = this;
return (new cljs.core.RecordIter((0),G__34581__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34583,other34584){
var self__ = this;
var this34583__$1 = this;
return (((!((other34584 == null)))) && ((((this34583__$1.constructor === other34584.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34583__$1.w,other34584.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34583__$1.h,other34584.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34583__$1.__extmap,other34584.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34582){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34648 = k34582;
var G__34648__$1 = (((G__34648 instanceof cljs.core.Keyword))?G__34648.fqn:null);
switch (G__34648__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34582);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34581){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34652 = cljs.core.keyword_identical_QMARK_;
var expr__34653 = k__5352__auto__;
if(cljs.core.truth_((pred__34652.cljs$core$IFn$_invoke$arity$2 ? pred__34652.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__34653) : pred__34652.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__34653)))){
return (new shadow.dom.Size(G__34581,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34652.cljs$core$IFn$_invoke$arity$2 ? pred__34652.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__34653) : pred__34652.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__34653)))){
return (new shadow.dom.Size(self__.w,G__34581,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34581),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34581){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__34581,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__34592){
var extmap__5385__auto__ = (function (){var G__34685 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34592,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__34592)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34685);
} else {
return G__34685;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__34592),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__34592),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__35573 = (i + (1));
var G__35574 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35573;
ret = G__35574;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34746){
var vec__34753 = p__34746;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34753,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34753,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__34766 = arguments.length;
switch (G__34766) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35580 = ps;
var G__35581 = (i + (1));
el__$1 = G__35580;
i = G__35581;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__34908 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34908,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34908,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34908,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__34919_35582 = cljs.core.seq(props);
var chunk__34920_35583 = null;
var count__34921_35584 = (0);
var i__34922_35585 = (0);
while(true){
if((i__34922_35585 < count__34921_35584)){
var vec__34946_35586 = chunk__34920_35583.cljs$core$IIndexed$_nth$arity$2(null,i__34922_35585);
var k_35587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34946_35586,(0),null);
var v_35588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34946_35586,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_35587);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35587),v_35588);


var G__35589 = seq__34919_35582;
var G__35590 = chunk__34920_35583;
var G__35591 = count__34921_35584;
var G__35592 = (i__34922_35585 + (1));
seq__34919_35582 = G__35589;
chunk__34920_35583 = G__35590;
count__34921_35584 = G__35591;
i__34922_35585 = G__35592;
continue;
} else {
var temp__5804__auto___35593 = cljs.core.seq(seq__34919_35582);
if(temp__5804__auto___35593){
var seq__34919_35594__$1 = temp__5804__auto___35593;
if(cljs.core.chunked_seq_QMARK_(seq__34919_35594__$1)){
var c__5568__auto___35595 = cljs.core.chunk_first(seq__34919_35594__$1);
var G__35596 = cljs.core.chunk_rest(seq__34919_35594__$1);
var G__35597 = c__5568__auto___35595;
var G__35598 = cljs.core.count(c__5568__auto___35595);
var G__35599 = (0);
seq__34919_35582 = G__35596;
chunk__34920_35583 = G__35597;
count__34921_35584 = G__35598;
i__34922_35585 = G__35599;
continue;
} else {
var vec__34961_35600 = cljs.core.first(seq__34919_35594__$1);
var k_35601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34961_35600,(0),null);
var v_35602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34961_35600,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35601);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35601),v_35602);


var G__35607 = cljs.core.next(seq__34919_35594__$1);
var G__35608 = null;
var G__35609 = (0);
var G__35610 = (0);
seq__34919_35582 = G__35607;
chunk__34920_35583 = G__35608;
count__34921_35584 = G__35609;
i__34922_35585 = G__35610;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35001 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35001,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35001,(1),null);
var seq__35009_35613 = cljs.core.seq(node_children);
var chunk__35011_35614 = null;
var count__35012_35615 = (0);
var i__35013_35616 = (0);
while(true){
if((i__35013_35616 < count__35012_35615)){
var child_struct_35617 = chunk__35011_35614.cljs$core$IIndexed$_nth$arity$2(null,i__35013_35616);
if((!((child_struct_35617 == null)))){
if(typeof child_struct_35617 === 'string'){
var text_35622 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35622),child_struct_35617].join(''));
} else {
var children_35623 = shadow.dom.svg_node(child_struct_35617);
if(cljs.core.seq_QMARK_(children_35623)){
var seq__35137_35624 = cljs.core.seq(children_35623);
var chunk__35139_35625 = null;
var count__35140_35626 = (0);
var i__35141_35627 = (0);
while(true){
if((i__35141_35627 < count__35140_35626)){
var child_35630 = chunk__35139_35625.cljs$core$IIndexed$_nth$arity$2(null,i__35141_35627);
if(cljs.core.truth_(child_35630)){
node.appendChild(child_35630);


var G__35631 = seq__35137_35624;
var G__35632 = chunk__35139_35625;
var G__35633 = count__35140_35626;
var G__35634 = (i__35141_35627 + (1));
seq__35137_35624 = G__35631;
chunk__35139_35625 = G__35632;
count__35140_35626 = G__35633;
i__35141_35627 = G__35634;
continue;
} else {
var G__35635 = seq__35137_35624;
var G__35636 = chunk__35139_35625;
var G__35637 = count__35140_35626;
var G__35638 = (i__35141_35627 + (1));
seq__35137_35624 = G__35635;
chunk__35139_35625 = G__35636;
count__35140_35626 = G__35637;
i__35141_35627 = G__35638;
continue;
}
} else {
var temp__5804__auto___35639 = cljs.core.seq(seq__35137_35624);
if(temp__5804__auto___35639){
var seq__35137_35640__$1 = temp__5804__auto___35639;
if(cljs.core.chunked_seq_QMARK_(seq__35137_35640__$1)){
var c__5568__auto___35641 = cljs.core.chunk_first(seq__35137_35640__$1);
var G__35642 = cljs.core.chunk_rest(seq__35137_35640__$1);
var G__35643 = c__5568__auto___35641;
var G__35644 = cljs.core.count(c__5568__auto___35641);
var G__35645 = (0);
seq__35137_35624 = G__35642;
chunk__35139_35625 = G__35643;
count__35140_35626 = G__35644;
i__35141_35627 = G__35645;
continue;
} else {
var child_35646 = cljs.core.first(seq__35137_35640__$1);
if(cljs.core.truth_(child_35646)){
node.appendChild(child_35646);


var G__35648 = cljs.core.next(seq__35137_35640__$1);
var G__35649 = null;
var G__35650 = (0);
var G__35651 = (0);
seq__35137_35624 = G__35648;
chunk__35139_35625 = G__35649;
count__35140_35626 = G__35650;
i__35141_35627 = G__35651;
continue;
} else {
var G__35652 = cljs.core.next(seq__35137_35640__$1);
var G__35653 = null;
var G__35654 = (0);
var G__35655 = (0);
seq__35137_35624 = G__35652;
chunk__35139_35625 = G__35653;
count__35140_35626 = G__35654;
i__35141_35627 = G__35655;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35623);
}
}


var G__35657 = seq__35009_35613;
var G__35658 = chunk__35011_35614;
var G__35659 = count__35012_35615;
var G__35660 = (i__35013_35616 + (1));
seq__35009_35613 = G__35657;
chunk__35011_35614 = G__35658;
count__35012_35615 = G__35659;
i__35013_35616 = G__35660;
continue;
} else {
var G__35661 = seq__35009_35613;
var G__35662 = chunk__35011_35614;
var G__35663 = count__35012_35615;
var G__35664 = (i__35013_35616 + (1));
seq__35009_35613 = G__35661;
chunk__35011_35614 = G__35662;
count__35012_35615 = G__35663;
i__35013_35616 = G__35664;
continue;
}
} else {
var temp__5804__auto___35665 = cljs.core.seq(seq__35009_35613);
if(temp__5804__auto___35665){
var seq__35009_35666__$1 = temp__5804__auto___35665;
if(cljs.core.chunked_seq_QMARK_(seq__35009_35666__$1)){
var c__5568__auto___35667 = cljs.core.chunk_first(seq__35009_35666__$1);
var G__35668 = cljs.core.chunk_rest(seq__35009_35666__$1);
var G__35669 = c__5568__auto___35667;
var G__35670 = cljs.core.count(c__5568__auto___35667);
var G__35671 = (0);
seq__35009_35613 = G__35668;
chunk__35011_35614 = G__35669;
count__35012_35615 = G__35670;
i__35013_35616 = G__35671;
continue;
} else {
var child_struct_35672 = cljs.core.first(seq__35009_35666__$1);
if((!((child_struct_35672 == null)))){
if(typeof child_struct_35672 === 'string'){
var text_35673 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35673),child_struct_35672].join(''));
} else {
var children_35675 = shadow.dom.svg_node(child_struct_35672);
if(cljs.core.seq_QMARK_(children_35675)){
var seq__35155_35679 = cljs.core.seq(children_35675);
var chunk__35157_35680 = null;
var count__35158_35681 = (0);
var i__35159_35682 = (0);
while(true){
if((i__35159_35682 < count__35158_35681)){
var child_35683 = chunk__35157_35680.cljs$core$IIndexed$_nth$arity$2(null,i__35159_35682);
if(cljs.core.truth_(child_35683)){
node.appendChild(child_35683);


var G__35684 = seq__35155_35679;
var G__35685 = chunk__35157_35680;
var G__35686 = count__35158_35681;
var G__35687 = (i__35159_35682 + (1));
seq__35155_35679 = G__35684;
chunk__35157_35680 = G__35685;
count__35158_35681 = G__35686;
i__35159_35682 = G__35687;
continue;
} else {
var G__35688 = seq__35155_35679;
var G__35689 = chunk__35157_35680;
var G__35690 = count__35158_35681;
var G__35691 = (i__35159_35682 + (1));
seq__35155_35679 = G__35688;
chunk__35157_35680 = G__35689;
count__35158_35681 = G__35690;
i__35159_35682 = G__35691;
continue;
}
} else {
var temp__5804__auto___35692__$1 = cljs.core.seq(seq__35155_35679);
if(temp__5804__auto___35692__$1){
var seq__35155_35693__$1 = temp__5804__auto___35692__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35155_35693__$1)){
var c__5568__auto___35694 = cljs.core.chunk_first(seq__35155_35693__$1);
var G__35695 = cljs.core.chunk_rest(seq__35155_35693__$1);
var G__35696 = c__5568__auto___35694;
var G__35697 = cljs.core.count(c__5568__auto___35694);
var G__35698 = (0);
seq__35155_35679 = G__35695;
chunk__35157_35680 = G__35696;
count__35158_35681 = G__35697;
i__35159_35682 = G__35698;
continue;
} else {
var child_35699 = cljs.core.first(seq__35155_35693__$1);
if(cljs.core.truth_(child_35699)){
node.appendChild(child_35699);


var G__35700 = cljs.core.next(seq__35155_35693__$1);
var G__35701 = null;
var G__35702 = (0);
var G__35703 = (0);
seq__35155_35679 = G__35700;
chunk__35157_35680 = G__35701;
count__35158_35681 = G__35702;
i__35159_35682 = G__35703;
continue;
} else {
var G__35707 = cljs.core.next(seq__35155_35693__$1);
var G__35708 = null;
var G__35709 = (0);
var G__35710 = (0);
seq__35155_35679 = G__35707;
chunk__35157_35680 = G__35708;
count__35158_35681 = G__35709;
i__35159_35682 = G__35710;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35675);
}
}


var G__35711 = cljs.core.next(seq__35009_35666__$1);
var G__35712 = null;
var G__35713 = (0);
var G__35714 = (0);
seq__35009_35613 = G__35711;
chunk__35011_35614 = G__35712;
count__35012_35615 = G__35713;
i__35013_35616 = G__35714;
continue;
} else {
var G__35715 = cljs.core.next(seq__35009_35666__$1);
var G__35716 = null;
var G__35717 = (0);
var G__35718 = (0);
seq__35009_35613 = G__35715;
chunk__35011_35614 = G__35716;
count__35012_35615 = G__35717;
i__35013_35616 = G__35718;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35729 = arguments.length;
var i__5770__auto___35730 = (0);
while(true){
if((i__5770__auto___35730 < len__5769__auto___35729)){
args__5775__auto__.push((arguments[i__5770__auto___35730]));

var G__35731 = (i__5770__auto___35730 + (1));
i__5770__auto___35730 = G__35731;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35171){
var G__35172 = cljs.core.first(seq35171);
var seq35171__$1 = cljs.core.next(seq35171);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35172,seq35171__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35183 = arguments.length;
switch (G__35183) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30016__auto___35743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_35198){
var state_val_35199 = (state_35198[(1)]);
if((state_val_35199 === (1))){
var state_35198__$1 = state_35198;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35198__$1,(2),once_or_cleanup);
} else {
if((state_val_35199 === (2))){
var inst_35195 = (state_35198[(2)]);
var inst_35196 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35198__$1 = (function (){var statearr_35204 = state_35198;
(statearr_35204[(7)] = inst_35195);

return statearr_35204;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35198__$1,inst_35196);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__29719__auto__ = null;
var shadow$dom$state_machine__29719__auto____0 = (function (){
var statearr_35205 = [null,null,null,null,null,null,null,null];
(statearr_35205[(0)] = shadow$dom$state_machine__29719__auto__);

(statearr_35205[(1)] = (1));

return statearr_35205;
});
var shadow$dom$state_machine__29719__auto____1 = (function (state_35198){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_35198);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e35206){var ex__29723__auto__ = e35206;
var statearr_35207_35747 = state_35198;
(statearr_35207_35747[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_35198[(4)]))){
var statearr_35208_35748 = state_35198;
(statearr_35208_35748[(1)] = cljs.core.first((state_35198[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35753 = state_35198;
state_35198 = G__35753;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
shadow$dom$state_machine__29719__auto__ = function(state_35198){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__29719__auto____0.call(this);
case 1:
return shadow$dom$state_machine__29719__auto____1.call(this,state_35198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__29719__auto____0;
shadow$dom$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__29719__auto____1;
return shadow$dom$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_35213 = f__30017__auto__();
(statearr_35213[(6)] = c__30016__auto___35743);

return statearr_35213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
