goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39231__39232__auto__){
if((!((p1__39231__39232__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39231__39232__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39231__39232__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39231__39232__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39231__39232__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___51350 = schema.utils.use_fn_validation;
var output_schema50300_51351 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50301_51352 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker50302_51353 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50301_51352);
}),null));
var output_checker50303_51354 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50300_51351);
}),null));
var ret__40100__auto___51355 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__50304){
var validate__37763__auto__ = cljs.core.deref(ufv___51350);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51356 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50304], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50306_51359 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50307_51360 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__50308_51361 = input_schema50301_51352;
var G__50309_51362 = cljs.core.deref(input_checker50302_51353);
var G__50310_51363 = args__37764__auto___51356;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50306_51359,G__50307_51360,G__50308_51361,G__50309_51362,G__50310_51363) : schema.core.fn_validator.call(null,G__50306_51359,G__50307_51360,G__50308_51361,G__50309_51362,G__50310_51363));
} else {
var temp__5804__auto___51368 = (function (){var fexpr__50311 = cljs.core.deref(input_checker50302_51353);
return (fexpr__50311.cljs$core$IFn$_invoke$arity$1 ? fexpr__50311.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51356) : fexpr__50311.call(null,args__37764__auto___51356));
})();
if(cljs.core.truth_(temp__5804__auto___51368)){
var error__37765__auto___51372 = temp__5804__auto___51368;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51372], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50301_51352,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51356,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51372], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var json = G__50304;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

var edn_schema = deercreeklabs.lancaster.utils.avro_schema__GT_edn_schema.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.utils.json_schema__GT_avro_schema(json));
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"*name->serializer","*name->serializer",1301813518),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"edn-schema","edn-schema",477120255),edn_schema,new cljs.core.Keyword(null,"json-schema","json-schema",389191695),json,new cljs.core.Keyword(null,"name->edn-schema","name->edn-schema",-1518578869),deercreeklabs.lancaster.utils.make_name__GT_edn_schema(edn_schema)], null));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50312_51376 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50313_51377 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__50314_51378 = output_schema50300_51351;
var G__50315_51379 = cljs.core.deref(output_checker50303_51354);
var G__50316_51380 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50312_51376,G__50313_51377,G__50314_51378,G__50315_51379,G__50316_51380) : schema.core.fn_validator.call(null,G__50312_51376,G__50313_51377,G__50314_51378,G__50315_51379,G__50316_51380));
} else {
var temp__5804__auto___51384 = (function (){var fexpr__50317 = cljs.core.deref(output_checker50303_51354);
return (fexpr__50317.cljs$core$IFn$_invoke$arity$1 ? fexpr__50317.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50317.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51384)){
var error__37765__auto___51385 = temp__5804__auto___51384;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51385], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50300_51351,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51385], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema50300_51351,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50301_51352], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___51389 = schema.utils.use_fn_validation;
var output_schema50324_51390 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50325_51391 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema50330_51392 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker50326_51393 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50325_51391);
}),null));
var output_checker50327_51394 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50324_51390);
}),null));
var input_checker50331_51395 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50330_51392);
}),null));
var output_checker50332_51396 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50324_51390);
}),null));
var ret__40100__auto___51397 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__50343 = arguments.length;
switch (G__50343) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__50328,G__50329){
var validate__37763__auto__ = cljs.core.deref(ufv___51389);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51399 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50328,G__50329], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50346_51400 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50347_51401 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__50348_51402 = input_schema50325_51391;
var G__50349_51403 = cljs.core.deref(input_checker50326_51393);
var G__50350_51404 = args__37764__auto___51399;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50346_51400,G__50347_51401,G__50348_51402,G__50349_51403,G__50350_51404) : schema.core.fn_validator.call(null,G__50346_51400,G__50347_51401,G__50348_51402,G__50349_51403,G__50350_51404));
} else {
var temp__5804__auto___51405 = (function (){var fexpr__50352 = cljs.core.deref(input_checker50326_51393);
return (fexpr__50352.cljs$core$IFn$_invoke$arity$1 ? fexpr__50352.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51399) : fexpr__50352.call(null,args__37764__auto___51399));
})();
if(cljs.core.truth_(temp__5804__auto___51405)){
var error__37765__auto___51406 = temp__5804__auto___51405;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51406], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50325_51391,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51399,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51406], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var name_kw = G__50328;
var fields = G__50329;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50353_51409 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50354_51410 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__50355_51411 = output_schema50324_51390;
var G__50356_51412 = cljs.core.deref(output_checker50327_51394);
var G__50357_51413 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50353_51409,G__50354_51410,G__50355_51411,G__50356_51412,G__50357_51413) : schema.core.fn_validator.call(null,G__50353_51409,G__50354_51410,G__50355_51411,G__50356_51412,G__50357_51413));
} else {
var temp__5804__auto___51416 = (function (){var fexpr__50360 = cljs.core.deref(output_checker50327_51394);
return (fexpr__50360.cljs$core$IFn$_invoke$arity$1 ? fexpr__50360.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50360.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51416)){
var error__37765__auto___51417 = temp__5804__auto___51416;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51417], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50324_51390,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51417], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__50333,G__50334,G__50335){
var validate__37763__auto__ = cljs.core.deref(ufv___51389);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51418 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50333,G__50334,G__50335], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50364_51419 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50365_51420 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__50366_51421 = input_schema50330_51392;
var G__50367_51422 = cljs.core.deref(input_checker50331_51395);
var G__50368_51423 = args__37764__auto___51418;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50364_51419,G__50365_51420,G__50366_51421,G__50367_51422,G__50368_51423) : schema.core.fn_validator.call(null,G__50364_51419,G__50365_51420,G__50366_51421,G__50367_51422,G__50368_51423));
} else {
var temp__5804__auto___51430 = (function (){var fexpr__50370 = cljs.core.deref(input_checker50331_51395);
return (fexpr__50370.cljs$core$IFn$_invoke$arity$1 ? fexpr__50370.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51418) : fexpr__50370.call(null,args__37764__auto___51418));
})();
if(cljs.core.truth_(temp__5804__auto___51430)){
var error__37765__auto___51434 = temp__5804__auto___51430;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51434], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50330_51392,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51418,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51434], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var name_kw = G__50333;
var docstring = G__50334;
var fields = G__50335;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50373_51438 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50374_51439 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__50375_51440 = output_schema50324_51390;
var G__50376_51441 = cljs.core.deref(output_checker50332_51396);
var G__50377_51442 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50373_51438,G__50374_51439,G__50375_51440,G__50376_51441,G__50377_51442) : schema.core.fn_validator.call(null,G__50373_51438,G__50374_51439,G__50375_51440,G__50376_51441,G__50377_51442));
} else {
var temp__5804__auto___51443 = (function (){var fexpr__50379 = cljs.core.deref(output_checker50332_51396);
return (fexpr__50379.cljs$core$IFn$_invoke$arity$1 ? fexpr__50379.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50379.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51443)){
var error__37765__auto___51444 = temp__5804__auto___51443;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51444], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50324_51390,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51444], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema50324_51390,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50325_51391,input_schema50330_51392], null)));

var ufv___51446 = schema.utils.use_fn_validation;
var output_schema50383_51447 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50384_51448 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema50390_51449 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker50385_51450 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50384_51448);
}),null));
var output_checker50386_51451 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50383_51447);
}),null));
var input_checker50391_51452 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50390_51449);
}),null));
var output_checker50392_51453 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50383_51447);
}),null));
var ret__40100__auto___51455 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__50408 = arguments.length;
switch (G__50408) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__50387,G__50388){
var validate__37763__auto__ = cljs.core.deref(ufv___51446);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51459 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50387,G__50388], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50414_51460 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50415_51461 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__50416_51462 = input_schema50384_51448;
var G__50417_51463 = cljs.core.deref(input_checker50385_51450);
var G__50418_51464 = args__37764__auto___51459;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50414_51460,G__50415_51461,G__50416_51462,G__50417_51463,G__50418_51464) : schema.core.fn_validator.call(null,G__50414_51460,G__50415_51461,G__50416_51462,G__50417_51463,G__50418_51464));
} else {
var temp__5804__auto___51465 = (function (){var fexpr__50420 = cljs.core.deref(input_checker50385_51450);
return (fexpr__50420.cljs$core$IFn$_invoke$arity$1 ? fexpr__50420.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51459) : fexpr__50420.call(null,args__37764__auto___51459));
})();
if(cljs.core.truth_(temp__5804__auto___51465)){
var error__37765__auto___51466 = temp__5804__auto___51465;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51466], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50384_51448,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51459,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51466], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var name_kw = G__50387;
var symbol_keywords = G__50388;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50424_51468 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50425_51469 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__50426_51470 = output_schema50383_51447;
var G__50427_51471 = cljs.core.deref(output_checker50386_51451);
var G__50428_51472 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50424_51468,G__50425_51469,G__50426_51470,G__50427_51471,G__50428_51472) : schema.core.fn_validator.call(null,G__50424_51468,G__50425_51469,G__50426_51470,G__50427_51471,G__50428_51472));
} else {
var temp__5804__auto___51473 = (function (){var fexpr__50431 = cljs.core.deref(output_checker50386_51451);
return (fexpr__50431.cljs$core$IFn$_invoke$arity$1 ? fexpr__50431.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50431.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51473)){
var error__37765__auto___51475 = temp__5804__auto___51473;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51475], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50383_51447,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51475], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__50393,G__50394,G__50395){
var validate__37763__auto__ = cljs.core.deref(ufv___51446);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51477 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50393,G__50394,G__50395], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50438_51478 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50439_51479 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__50440_51480 = input_schema50390_51449;
var G__50441_51481 = cljs.core.deref(input_checker50391_51452);
var G__50442_51482 = args__37764__auto___51477;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50438_51478,G__50439_51479,G__50440_51480,G__50441_51481,G__50442_51482) : schema.core.fn_validator.call(null,G__50438_51478,G__50439_51479,G__50440_51480,G__50441_51481,G__50442_51482));
} else {
var temp__5804__auto___51483 = (function (){var fexpr__50443 = cljs.core.deref(input_checker50391_51452);
return (fexpr__50443.cljs$core$IFn$_invoke$arity$1 ? fexpr__50443.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51477) : fexpr__50443.call(null,args__37764__auto___51477));
})();
if(cljs.core.truth_(temp__5804__auto___51483)){
var error__37765__auto___51484 = temp__5804__auto___51483;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51484], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50390_51449,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51477,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51484], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var name_kw = G__50393;
var docstring = G__50394;
var symbol_keywords = G__50395;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50445_51487 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50446_51488 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__50447_51489 = output_schema50383_51447;
var G__50448_51490 = cljs.core.deref(output_checker50392_51453);
var G__50449_51491 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50445_51487,G__50446_51488,G__50447_51489,G__50448_51490,G__50449_51491) : schema.core.fn_validator.call(null,G__50445_51487,G__50446_51488,G__50447_51489,G__50448_51490,G__50449_51491));
} else {
var temp__5804__auto___51492 = (function (){var fexpr__50452 = cljs.core.deref(output_checker50392_51453);
return (fexpr__50452.cljs$core$IFn$_invoke$arity$1 ? fexpr__50452.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50452.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51492)){
var error__37765__auto___51493 = temp__5804__auto___51492;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51493], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50383_51447,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51493], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema50383_51447,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50384_51448,input_schema50390_51449], null)));

var ufv___51494 = schema.utils.use_fn_validation;
var output_schema50454_51495 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50456_51496 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker50457_51497 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50456_51496);
}),null));
var output_checker50458_51498 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50454_51495);
}),null));
var ret__40100__auto___51499 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__50459,G__50460){
var validate__37763__auto__ = cljs.core.deref(ufv___51494);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51501 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50459,G__50460], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50467_51502 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50468_51503 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__50469_51504 = input_schema50456_51496;
var G__50470_51505 = cljs.core.deref(input_checker50457_51497);
var G__50471_51506 = args__37764__auto___51501;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50467_51502,G__50468_51503,G__50469_51504,G__50470_51505,G__50471_51506) : schema.core.fn_validator.call(null,G__50467_51502,G__50468_51503,G__50469_51504,G__50470_51505,G__50471_51506));
} else {
var temp__5804__auto___51507 = (function (){var fexpr__50477 = cljs.core.deref(input_checker50457_51497);
return (fexpr__50477.cljs$core$IFn$_invoke$arity$1 ? fexpr__50477.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51501) : fexpr__50477.call(null,args__37764__auto___51501));
})();
if(cljs.core.truth_(temp__5804__auto___51507)){
var error__37765__auto___51508 = temp__5804__auto___51507;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51508], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50456_51496,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51501,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51508], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var name_kw = G__50459;
var size = G__50460;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50482_51509 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50483_51510 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__50484_51511 = output_schema50454_51495;
var G__50485_51512 = cljs.core.deref(output_checker50458_51498);
var G__50486_51513 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50482_51509,G__50483_51510,G__50484_51511,G__50485_51512,G__50486_51513) : schema.core.fn_validator.call(null,G__50482_51509,G__50483_51510,G__50484_51511,G__50485_51512,G__50486_51513));
} else {
var temp__5804__auto___51515 = (function (){var fexpr__50488 = cljs.core.deref(output_checker50458_51498);
return (fexpr__50488.cljs$core$IFn$_invoke$arity$1 ? fexpr__50488.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50488.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51515)){
var error__37765__auto___51516 = temp__5804__auto___51515;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51516], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50454_51495,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51516], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema50454_51495,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50456_51496], null)));

var ufv___51518 = schema.utils.use_fn_validation;
var output_schema50489_51519 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50490_51520 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker50491_51521 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50490_51520);
}),null));
var output_checker50492_51522 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50489_51519);
}),null));
var ret__40100__auto___51591 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__50493){
var validate__37763__auto__ = cljs.core.deref(ufv___51518);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51592 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50493], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50494_51593 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50495_51594 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__50496_51595 = input_schema50490_51520;
var G__50497_51596 = cljs.core.deref(input_checker50491_51521);
var G__50498_51597 = args__37764__auto___51592;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50494_51593,G__50495_51594,G__50496_51595,G__50497_51596,G__50498_51597) : schema.core.fn_validator.call(null,G__50494_51593,G__50495_51594,G__50496_51595,G__50497_51596,G__50498_51597));
} else {
var temp__5804__auto___51598 = (function (){var fexpr__50499 = cljs.core.deref(input_checker50491_51521);
return (fexpr__50499.cljs$core$IFn$_invoke$arity$1 ? fexpr__50499.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51592) : fexpr__50499.call(null,args__37764__auto___51592));
})();
if(cljs.core.truth_(temp__5804__auto___51598)){
var error__37765__auto___51599 = temp__5804__auto___51598;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51599], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50490_51520,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51592,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51599], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var items_schema = G__50493;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50501_51601 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50502_51602 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__50503_51603 = output_schema50489_51519;
var G__50504_51604 = cljs.core.deref(output_checker50492_51522);
var G__50505_51605 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50501_51601,G__50502_51602,G__50503_51603,G__50504_51604,G__50505_51605) : schema.core.fn_validator.call(null,G__50501_51601,G__50502_51602,G__50503_51603,G__50504_51604,G__50505_51605));
} else {
var temp__5804__auto___51606 = (function (){var fexpr__50509 = cljs.core.deref(output_checker50492_51522);
return (fexpr__50509.cljs$core$IFn$_invoke$arity$1 ? fexpr__50509.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50509.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51606)){
var error__37765__auto___51607 = temp__5804__auto___51606;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51607], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50489_51519,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51607], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema50489_51519,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50490_51520], null)));

var ufv___51612 = schema.utils.use_fn_validation;
var output_schema50512_51613 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50513_51614 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker50514_51615 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50513_51614);
}),null));
var output_checker50515_51616 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50512_51613);
}),null));
var ret__40100__auto___51617 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__50518){
var validate__37763__auto__ = cljs.core.deref(ufv___51612);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51618 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50518], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50520_51619 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50521_51620 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__50522_51621 = input_schema50513_51614;
var G__50523_51622 = cljs.core.deref(input_checker50514_51615);
var G__50524_51623 = args__37764__auto___51618;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50520_51619,G__50521_51620,G__50522_51621,G__50523_51622,G__50524_51623) : schema.core.fn_validator.call(null,G__50520_51619,G__50521_51620,G__50522_51621,G__50523_51622,G__50524_51623));
} else {
var temp__5804__auto___51624 = (function (){var fexpr__50525 = cljs.core.deref(input_checker50514_51615);
return (fexpr__50525.cljs$core$IFn$_invoke$arity$1 ? fexpr__50525.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51618) : fexpr__50525.call(null,args__37764__auto___51618));
})();
if(cljs.core.truth_(temp__5804__auto___51624)){
var error__37765__auto___51625 = temp__5804__auto___51624;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51625], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50513_51614,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51618,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51625], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var values_schema = G__50518;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50529_51630 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50530_51631 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__50531_51632 = output_schema50512_51613;
var G__50532_51633 = cljs.core.deref(output_checker50515_51616);
var G__50533_51634 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50529_51630,G__50530_51631,G__50531_51632,G__50532_51633,G__50533_51634) : schema.core.fn_validator.call(null,G__50529_51630,G__50530_51631,G__50531_51632,G__50532_51633,G__50533_51634));
} else {
var temp__5804__auto___51635 = (function (){var fexpr__50536 = cljs.core.deref(output_checker50515_51616);
return (fexpr__50536.cljs$core$IFn$_invoke$arity$1 ? fexpr__50536.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50536.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51635)){
var error__37765__auto___51636 = temp__5804__auto___51635;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51636], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50512_51613,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51636], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema50512_51613,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50513_51614], null)));

var ufv___51637 = schema.utils.use_fn_validation;
var output_schema50538_51638 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50539_51639 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker50540_51640 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50539_51639);
}),null));
var output_checker50541_51641 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50538_51638);
}),null));
var ret__40100__auto___51642 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__50542){
var validate__37763__auto__ = cljs.core.deref(ufv___51637);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51643 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50542], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50547_51644 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50548_51645 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__50549_51646 = input_schema50539_51639;
var G__50550_51647 = cljs.core.deref(input_checker50540_51640);
var G__50551_51648 = args__37764__auto___51643;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50547_51644,G__50548_51645,G__50549_51646,G__50550_51647,G__50551_51648) : schema.core.fn_validator.call(null,G__50547_51644,G__50548_51645,G__50549_51646,G__50550_51647,G__50551_51648));
} else {
var temp__5804__auto___51649 = (function (){var fexpr__50552 = cljs.core.deref(input_checker50540_51640);
return (fexpr__50552.cljs$core$IFn$_invoke$arity$1 ? fexpr__50552.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51643) : fexpr__50552.call(null,args__37764__auto___51643));
})();
if(cljs.core.truth_(temp__5804__auto___51649)){
var error__37765__auto___51650 = temp__5804__auto___51649;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51650], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50539_51639,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51643,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51650], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var member_schemas = G__50542;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50554_51651 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50555_51652 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__50556_51653 = output_schema50538_51638;
var G__50557_51654 = cljs.core.deref(output_checker50541_51641);
var G__50558_51655 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50554_51651,G__50555_51652,G__50556_51653,G__50557_51654,G__50558_51655) : schema.core.fn_validator.call(null,G__50554_51651,G__50555_51652,G__50556_51653,G__50557_51654,G__50558_51655));
} else {
var temp__5804__auto___51656 = (function (){var fexpr__50559 = cljs.core.deref(output_checker50541_51641);
return (fexpr__50559.cljs$core$IFn$_invoke$arity$1 ? fexpr__50559.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50559.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51656)){
var error__37765__auto___51657 = temp__5804__auto___51656;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51657], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50538_51638,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51657], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema50538_51638,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50539_51639], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___51659 = schema.utils.use_fn_validation;
var output_schema50562_51660 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50563_51661 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker50564_51662 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50563_51661);
}),null));
var output_checker50565_51663 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50562_51660);
}),null));
var ret__40100__auto___51664 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__50566){
var validate__37763__auto__ = cljs.core.deref(ufv___51659);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51665 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50566], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50570_51666 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50571_51667 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__50572_51668 = input_schema50563_51661;
var G__50573_51669 = cljs.core.deref(input_checker50564_51662);
var G__50574_51670 = args__37764__auto___51665;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50570_51666,G__50571_51667,G__50572_51668,G__50573_51669,G__50574_51670) : schema.core.fn_validator.call(null,G__50570_51666,G__50571_51667,G__50572_51668,G__50573_51669,G__50574_51670));
} else {
var temp__5804__auto___51672 = (function (){var fexpr__50576 = cljs.core.deref(input_checker50564_51662);
return (fexpr__50576.cljs$core$IFn$_invoke$arity$1 ? fexpr__50576.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51665) : fexpr__50576.call(null,args__37764__auto___51665));
})();
if(cljs.core.truth_(temp__5804__auto___51672)){
var error__37765__auto___51673 = temp__5804__auto___51672;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51673], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50563_51661,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51665,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51673], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50566;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50578_51677 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50579_51678 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__50580_51679 = output_schema50562_51660;
var G__50581_51680 = cljs.core.deref(output_checker50565_51663);
var G__50582_51681 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50578_51677,G__50579_51678,G__50580_51679,G__50581_51680,G__50582_51681) : schema.core.fn_validator.call(null,G__50578_51677,G__50579_51678,G__50580_51679,G__50581_51680,G__50582_51681));
} else {
var temp__5804__auto___51682 = (function (){var fexpr__50584 = cljs.core.deref(output_checker50565_51663);
return (fexpr__50584.cljs$core$IFn$_invoke$arity$1 ? fexpr__50584.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50584.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51682)){
var error__37765__auto___51683 = temp__5804__auto___51682;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51683], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50562_51660,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51683], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema50562_51660,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50563_51661], null)));

var ufv___51685 = schema.utils.use_fn_validation;
var output_schema50588_51686 = deercreeklabs.baracus.ByteArray;
var input_schema50589_51687 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker50590_51688 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50589_51687);
}),null));
var output_checker50591_51689 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50588_51686);
}),null));
var ret__40100__auto___51690 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__50592,G__50593){
var validate__37763__auto__ = cljs.core.deref(ufv___51685);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51691 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50592,G__50593], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50598_51692 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50599_51693 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__50600_51694 = input_schema50589_51687;
var G__50601_51695 = cljs.core.deref(input_checker50590_51688);
var G__50602_51696 = args__37764__auto___51691;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50598_51692,G__50599_51693,G__50600_51694,G__50601_51695,G__50602_51696) : schema.core.fn_validator.call(null,G__50598_51692,G__50599_51693,G__50600_51694,G__50601_51695,G__50602_51696));
} else {
var temp__5804__auto___51697 = (function (){var fexpr__50604 = cljs.core.deref(input_checker50590_51688);
return (fexpr__50604.cljs$core$IFn$_invoke$arity$1 ? fexpr__50604.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51691) : fexpr__50604.call(null,args__37764__auto___51691));
})();
if(cljs.core.truth_(temp__5804__auto___51697)){
var error__37765__auto___51698 = temp__5804__auto___51697;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51698], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50589_51687,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51691,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51698], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var writer_schema = G__50592;
var data = G__50593;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50607_51703 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50608_51704 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__50609_51705 = output_schema50588_51686;
var G__50610_51706 = cljs.core.deref(output_checker50591_51689);
var G__50611_51707 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50607_51703,G__50608_51704,G__50609_51705,G__50610_51706,G__50611_51707) : schema.core.fn_validator.call(null,G__50607_51703,G__50608_51704,G__50609_51705,G__50610_51706,G__50611_51707));
} else {
var temp__5804__auto___51708 = (function (){var fexpr__50615 = cljs.core.deref(output_checker50591_51689);
return (fexpr__50615.cljs$core$IFn$_invoke$arity$1 ? fexpr__50615.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50615.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51708)){
var error__37765__auto___51709 = temp__5804__auto___51708;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51709], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50588_51686,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51709], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema50588_51686,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50589_51687], null)));

var ufv___51710 = schema.utils.use_fn_validation;
var output_schema50617_51711 = schema.core.Any;
var input_schema50618_51712 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker50619_51713 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50618_51712);
}),null));
var output_checker50620_51714 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50617_51711);
}),null));
var ret__40100__auto___51715 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__50621,G__50622,G__50623){
var validate__37763__auto__ = cljs.core.deref(ufv___51710);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51716 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50621,G__50622,G__50623], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50629_51717 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50630_51718 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__50631_51719 = input_schema50618_51712;
var G__50632_51720 = cljs.core.deref(input_checker50619_51713);
var G__50633_51721 = args__37764__auto___51716;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50629_51717,G__50630_51718,G__50631_51719,G__50632_51720,G__50633_51721) : schema.core.fn_validator.call(null,G__50629_51717,G__50630_51718,G__50631_51719,G__50632_51720,G__50633_51721));
} else {
var temp__5804__auto___51722 = (function (){var fexpr__50635 = cljs.core.deref(input_checker50619_51713);
return (fexpr__50635.cljs$core$IFn$_invoke$arity$1 ? fexpr__50635.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51716) : fexpr__50635.call(null,args__37764__auto___51716));
})();
if(cljs.core.truth_(temp__5804__auto___51722)){
var error__37765__auto___51723 = temp__5804__auto___51722;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51723], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50618_51712,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51716,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51723], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var reader_schema = G__50621;
var writer_schema = G__50622;
var ba = G__50623;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50647_51734 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50648_51735 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__50649_51736 = output_schema50617_51711;
var G__50650_51737 = cljs.core.deref(output_checker50620_51714);
var G__50651_51738 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50647_51734,G__50648_51735,G__50649_51736,G__50650_51737,G__50651_51738) : schema.core.fn_validator.call(null,G__50647_51734,G__50648_51735,G__50649_51736,G__50650_51737,G__50651_51738));
} else {
var temp__5804__auto___51740 = (function (){var fexpr__50652 = cljs.core.deref(output_checker50620_51714);
return (fexpr__50652.cljs$core$IFn$_invoke$arity$1 ? fexpr__50652.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50652.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51740)){
var error__37765__auto___51741 = temp__5804__auto___51740;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51741], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50617_51711,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51741], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema50617_51711,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50618_51712], null)));

var ufv___51743 = schema.utils.use_fn_validation;
var output_schema50660_51744 = schema.core.Any;
var input_schema50664_51746 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker50665_51748 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50664_51746);
}),null));
var output_checker50666_51749 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50660_51744);
}),null));
var ret__40100__auto___51750 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__50667,G__50668){
var validate__37763__auto__ = cljs.core.deref(ufv___51743);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51751 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50667,G__50668], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50677_51752 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50678_51753 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__50679_51754 = input_schema50664_51746;
var G__50680_51755 = cljs.core.deref(input_checker50665_51748);
var G__50681_51756 = args__37764__auto___51751;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50677_51752,G__50678_51753,G__50679_51754,G__50680_51755,G__50681_51756) : schema.core.fn_validator.call(null,G__50677_51752,G__50678_51753,G__50679_51754,G__50680_51755,G__50681_51756));
} else {
var temp__5804__auto___51761 = (function (){var fexpr__50685 = cljs.core.deref(input_checker50665_51748);
return (fexpr__50685.cljs$core$IFn$_invoke$arity$1 ? fexpr__50685.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51751) : fexpr__50685.call(null,args__37764__auto___51751));
})();
if(cljs.core.truth_(temp__5804__auto___51761)){
var error__37765__auto___51763 = temp__5804__auto___51761;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51763], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50664_51746,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51751,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51763], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50667;
var ba = G__50668;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50688_51769 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50689_51770 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__50690_51771 = output_schema50660_51744;
var G__50691_51772 = cljs.core.deref(output_checker50666_51749);
var G__50692_51773 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50688_51769,G__50689_51770,G__50690_51771,G__50691_51772,G__50692_51773) : schema.core.fn_validator.call(null,G__50688_51769,G__50689_51770,G__50690_51771,G__50691_51772,G__50692_51773));
} else {
var temp__5804__auto___51776 = (function (){var fexpr__50695 = cljs.core.deref(output_checker50666_51749);
return (fexpr__50695.cljs$core$IFn$_invoke$arity$1 ? fexpr__50695.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50695.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51776)){
var error__37765__auto___51779 = temp__5804__auto___51776;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51779], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50660_51744,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51779], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema50660_51744,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50664_51746], null)));

var ufv___51780 = schema.utils.use_fn_validation;
var output_schema50699_51781 = schema.core.Any;
var input_schema50700_51782 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50701_51783 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50700_51782);
}),null));
var output_checker50702_51784 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50699_51781);
}),null));
var ret__40100__auto___51788 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__50703){
var validate__37763__auto__ = cljs.core.deref(ufv___51780);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51790 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50703], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50707_51792 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50708_51793 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__50709_51794 = input_schema50700_51782;
var G__50710_51795 = cljs.core.deref(input_checker50701_51783);
var G__50711_51796 = args__37764__auto___51790;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50707_51792,G__50708_51793,G__50709_51794,G__50710_51795,G__50711_51796) : schema.core.fn_validator.call(null,G__50707_51792,G__50708_51793,G__50709_51794,G__50710_51795,G__50711_51796));
} else {
var temp__5804__auto___51799 = (function (){var fexpr__50712 = cljs.core.deref(input_checker50701_51783);
return (fexpr__50712.cljs$core$IFn$_invoke$arity$1 ? fexpr__50712.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51790) : fexpr__50712.call(null,args__37764__auto___51790));
})();
if(cljs.core.truth_(temp__5804__auto___51799)){
var error__37765__auto___51800 = temp__5804__auto___51799;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51800], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50700_51782,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51790,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51800], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50703;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50715_51801 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50716_51802 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__50717_51803 = output_schema50699_51781;
var G__50718_51804 = cljs.core.deref(output_checker50702_51784);
var G__50719_51805 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50715_51801,G__50716_51802,G__50717_51803,G__50718_51804,G__50719_51805) : schema.core.fn_validator.call(null,G__50715_51801,G__50716_51802,G__50717_51803,G__50718_51804,G__50719_51805));
} else {
var temp__5804__auto___51806 = (function (){var fexpr__50722 = cljs.core.deref(output_checker50702_51784);
return (fexpr__50722.cljs$core$IFn$_invoke$arity$1 ? fexpr__50722.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50722.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51806)){
var error__37765__auto___51807 = temp__5804__auto___51806;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51807], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50699_51781,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51807], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema50699_51781,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50700_51782], null)));

var ufv___51808 = schema.utils.use_fn_validation;
var output_schema50724_51809 = deercreeklabs.lancaster.LancasterSchema;
var input_schema50725_51810 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker50726_51811 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50725_51810);
}),null));
var output_checker50727_51812 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50724_51809);
}),null));
var ret__40100__auto___51815 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__50728){
var validate__37763__auto__ = cljs.core.deref(ufv___51808);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51817 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50728], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50730_51818 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50731_51819 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__50732_51820 = input_schema50725_51810;
var G__50733_51821 = cljs.core.deref(input_checker50726_51811);
var G__50734_51822 = args__37764__auto___51817;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50730_51818,G__50731_51819,G__50732_51820,G__50733_51821,G__50734_51822) : schema.core.fn_validator.call(null,G__50730_51818,G__50731_51819,G__50732_51820,G__50733_51821,G__50734_51822));
} else {
var temp__5804__auto___51833 = (function (){var fexpr__50736 = cljs.core.deref(input_checker50726_51811);
return (fexpr__50736.cljs$core$IFn$_invoke$arity$1 ? fexpr__50736.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51817) : fexpr__50736.call(null,args__37764__auto___51817));
})();
if(cljs.core.truth_(temp__5804__auto___51833)){
var error__37765__auto___51834 = temp__5804__auto___51833;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51834], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50725_51810,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51817,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51834], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var edn = G__50728;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"*name->serializer","*name->serializer",1301813518),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"edn-schema","edn-schema",477120255),edn,new cljs.core.Keyword(null,"name->edn-schema","name->edn-schema",-1518578869),deercreeklabs.lancaster.utils.make_name__GT_edn_schema(edn)], null));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50738_51846 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50739_51847 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__50740_51848 = output_schema50724_51809;
var G__50741_51849 = cljs.core.deref(output_checker50727_51812);
var G__50742_51850 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50738_51846,G__50739_51847,G__50740_51848,G__50741_51849,G__50742_51850) : schema.core.fn_validator.call(null,G__50738_51846,G__50739_51847,G__50740_51848,G__50741_51849,G__50742_51850));
} else {
var temp__5804__auto___51852 = (function (){var fexpr__50743 = cljs.core.deref(output_checker50727_51812);
return (fexpr__50743.cljs$core$IFn$_invoke$arity$1 ? fexpr__50743.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50743.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51852)){
var error__37765__auto___51853 = temp__5804__auto___51852;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51853], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50724_51809,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51853], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema50724_51809,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50725_51810], null)));

var ufv___51854 = schema.utils.use_fn_validation;
var output_schema50756_51855 = schema.core.Str;
var input_schema50757_51856 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50758_51857 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50757_51856);
}),null));
var output_checker50759_51858 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50756_51855);
}),null));
var ret__40100__auto___51860 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__50760){
var validate__37763__auto__ = cljs.core.deref(ufv___51854);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51861 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50760], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50763_51862 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50764_51863 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__50765_51864 = input_schema50757_51856;
var G__50766_51865 = cljs.core.deref(input_checker50758_51857);
var G__50767_51866 = args__37764__auto___51861;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50763_51862,G__50764_51863,G__50765_51864,G__50766_51865,G__50767_51866) : schema.core.fn_validator.call(null,G__50763_51862,G__50764_51863,G__50765_51864,G__50766_51865,G__50767_51866));
} else {
var temp__5804__auto___51867 = (function (){var fexpr__50770 = cljs.core.deref(input_checker50758_51857);
return (fexpr__50770.cljs$core$IFn$_invoke$arity$1 ? fexpr__50770.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51861) : fexpr__50770.call(null,args__37764__auto___51861));
})();
if(cljs.core.truth_(temp__5804__auto___51867)){
var error__37765__auto___51868 = temp__5804__auto___51867;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51868], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50757_51856,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51861,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51868], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50760;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50772_51869 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50773_51870 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__50774_51871 = output_schema50756_51855;
var G__50775_51872 = cljs.core.deref(output_checker50759_51858);
var G__50776_51873 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50772_51869,G__50773_51870,G__50774_51871,G__50775_51872,G__50776_51873) : schema.core.fn_validator.call(null,G__50772_51869,G__50773_51870,G__50774_51871,G__50775_51872,G__50776_51873));
} else {
var temp__5804__auto___51876 = (function (){var fexpr__50777 = cljs.core.deref(output_checker50759_51858);
return (fexpr__50777.cljs$core$IFn$_invoke$arity$1 ? fexpr__50777.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50777.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51876)){
var error__37765__auto___51877 = temp__5804__auto___51876;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51877], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50756_51855,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51877], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema50756_51855,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50757_51856], null)));

var ufv___51881 = schema.utils.use_fn_validation;
var output_schema50782_51882 = schema.core.Keyword;
var input_schema50783_51883 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50784_51884 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50783_51883);
}),null));
var output_checker50785_51885 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50782_51882);
}),null));
var ret__40100__auto___51888 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__50786){
var validate__37763__auto__ = cljs.core.deref(ufv___51881);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51890 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50786], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50790_51891 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50792_51892 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__50793_51893 = input_schema50783_51883;
var G__50794_51894 = cljs.core.deref(input_checker50784_51884);
var G__50795_51895 = args__37764__auto___51890;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50790_51891,G__50792_51892,G__50793_51893,G__50794_51894,G__50795_51895) : schema.core.fn_validator.call(null,G__50790_51891,G__50792_51892,G__50793_51893,G__50794_51894,G__50795_51895));
} else {
var temp__5804__auto___51898 = (function (){var fexpr__50797 = cljs.core.deref(input_checker50784_51884);
return (fexpr__50797.cljs$core$IFn$_invoke$arity$1 ? fexpr__50797.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51890) : fexpr__50797.call(null,args__37764__auto___51890));
})();
if(cljs.core.truth_(temp__5804__auto___51898)){
var error__37765__auto___51899 = temp__5804__auto___51898;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51899], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50783_51883,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51890,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51899], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50786;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50801_51905 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50802_51906 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__50803_51907 = output_schema50782_51882;
var G__50804_51908 = cljs.core.deref(output_checker50785_51885);
var G__50805_51909 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50801_51905,G__50802_51906,G__50803_51907,G__50804_51908,G__50805_51909) : schema.core.fn_validator.call(null,G__50801_51905,G__50802_51906,G__50803_51907,G__50804_51908,G__50805_51909));
} else {
var temp__5804__auto___51910 = (function (){var fexpr__50810 = cljs.core.deref(output_checker50785_51885);
return (fexpr__50810.cljs$core$IFn$_invoke$arity$1 ? fexpr__50810.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50810.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51910)){
var error__37765__auto___51913 = temp__5804__auto___51910;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51913], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50782_51882,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51913], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema50782_51882,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50783_51883], null)));

var ufv___51915 = schema.utils.use_fn_validation;
var output_schema50814_51916 = schema.core.Str;
var input_schema50816_51917 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50817_51918 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50816_51917);
}),null));
var output_checker50818_51919 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50814_51916);
}),null));
var ret__40100__auto___51920 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__50819){
var validate__37763__auto__ = cljs.core.deref(ufv___51915);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___51922 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50819], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50825_51923 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50826_51924 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__50827_51925 = input_schema50816_51917;
var G__50828_51926 = cljs.core.deref(input_checker50817_51918);
var G__50829_51927 = args__37764__auto___51922;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50825_51923,G__50826_51924,G__50827_51925,G__50828_51926,G__50829_51927) : schema.core.fn_validator.call(null,G__50825_51923,G__50826_51924,G__50827_51925,G__50828_51926,G__50829_51927));
} else {
var temp__5804__auto___51931 = (function (){var fexpr__50832 = cljs.core.deref(input_checker50817_51918);
return (fexpr__50832.cljs$core$IFn$_invoke$arity$1 ? fexpr__50832.cljs$core$IFn$_invoke$arity$1(args__37764__auto___51922) : fexpr__50832.call(null,args__37764__auto___51922));
})();
if(cljs.core.truth_(temp__5804__auto___51931)){
var error__37765__auto___51932 = temp__5804__auto___51931;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___51932], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50816_51917,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___51922,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___51932], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50819;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50835_51953 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50836_51954 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__50837_51955 = output_schema50814_51916;
var G__50838_51956 = cljs.core.deref(output_checker50818_51919);
var G__50839_51957 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50835_51953,G__50836_51954,G__50837_51955,G__50838_51956,G__50839_51957) : schema.core.fn_validator.call(null,G__50835_51953,G__50836_51954,G__50837_51955,G__50838_51956,G__50839_51957));
} else {
var temp__5804__auto___51963 = (function (){var fexpr__50842 = cljs.core.deref(output_checker50818_51919);
return (fexpr__50842.cljs$core$IFn$_invoke$arity$1 ? fexpr__50842.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50842.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___51963)){
var error__37765__auto___52003 = temp__5804__auto___51963;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52003], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50814_51916,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52003], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema50814_51916,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50816_51917], null)));

var ufv___52007 = schema.utils.use_fn_validation;
var output_schema50846_52008 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema50847_52009 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50848_52010 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50847_52009);
}),null));
var output_checker50849_52011 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50846_52008);
}),null));
var ret__40100__auto___52012 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__50850){
var validate__37763__auto__ = cljs.core.deref(ufv___52007);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52013 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50850], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50855_52014 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50856_52015 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__50857_52016 = input_schema50847_52009;
var G__50858_52017 = cljs.core.deref(input_checker50848_52010);
var G__50859_52018 = args__37764__auto___52013;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50855_52014,G__50856_52015,G__50857_52016,G__50858_52017,G__50859_52018) : schema.core.fn_validator.call(null,G__50855_52014,G__50856_52015,G__50857_52016,G__50858_52017,G__50859_52018));
} else {
var temp__5804__auto___52019 = (function (){var fexpr__50860 = cljs.core.deref(input_checker50848_52010);
return (fexpr__50860.cljs$core$IFn$_invoke$arity$1 ? fexpr__50860.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52013) : fexpr__50860.call(null,args__37764__auto___52013));
})();
if(cljs.core.truth_(temp__5804__auto___52019)){
var error__37765__auto___52020 = temp__5804__auto___52019;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52020], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50847_52009,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52013,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52020], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50850;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50862_52024 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50863_52025 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__50864_52026 = output_schema50846_52008;
var G__50865_52027 = cljs.core.deref(output_checker50849_52011);
var G__50866_52028 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50862_52024,G__50863_52025,G__50864_52026,G__50865_52027,G__50866_52028) : schema.core.fn_validator.call(null,G__50862_52024,G__50863_52025,G__50864_52026,G__50865_52027,G__50866_52028));
} else {
var temp__5804__auto___52030 = (function (){var fexpr__50871 = cljs.core.deref(output_checker50849_52011);
return (fexpr__50871.cljs$core$IFn$_invoke$arity$1 ? fexpr__50871.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50871.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52030)){
var error__37765__auto___52031 = temp__5804__auto___52030;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52031], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50846_52008,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52031], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema50846_52008,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50847_52009], null)));

var ufv___52032 = schema.utils.use_fn_validation;
var output_schema50878_52033 = deercreeklabs.baracus.ByteArray;
var input_schema50880_52034 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50881_52035 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50880_52034);
}),null));
var output_checker50882_52036 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50878_52033);
}),null));
var ret__40100__auto___52037 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__50883){
var validate__37763__auto__ = cljs.core.deref(ufv___52032);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52038 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50883], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50894_52039 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50895_52040 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__50896_52041 = input_schema50880_52034;
var G__50897_52042 = cljs.core.deref(input_checker50881_52035);
var G__50898_52043 = args__37764__auto___52038;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50894_52039,G__50895_52040,G__50896_52041,G__50897_52042,G__50898_52043) : schema.core.fn_validator.call(null,G__50894_52039,G__50895_52040,G__50896_52041,G__50897_52042,G__50898_52043));
} else {
var temp__5804__auto___52045 = (function (){var fexpr__50899 = cljs.core.deref(input_checker50881_52035);
return (fexpr__50899.cljs$core$IFn$_invoke$arity$1 ? fexpr__50899.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52038) : fexpr__50899.call(null,args__37764__auto___52038));
})();
if(cljs.core.truth_(temp__5804__auto___52045)){
var error__37765__auto___52046 = temp__5804__auto___52045;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52046], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50880_52034,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52038,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52046], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50883;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50904_52050 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50905_52051 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__50906_52052 = output_schema50878_52033;
var G__50907_52053 = cljs.core.deref(output_checker50882_52036);
var G__50908_52054 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50904_52050,G__50905_52051,G__50906_52052,G__50907_52053,G__50908_52054) : schema.core.fn_validator.call(null,G__50904_52050,G__50905_52051,G__50906_52052,G__50907_52053,G__50908_52054));
} else {
var temp__5804__auto___52056 = (function (){var fexpr__50909 = cljs.core.deref(output_checker50882_52036);
return (fexpr__50909.cljs$core$IFn$_invoke$arity$1 ? fexpr__50909.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50909.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52056)){
var error__37765__auto___52057 = temp__5804__auto___52056;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52057], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50878_52033,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52057], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema50878_52033,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50880_52034], null)));

var ufv___52059 = schema.utils.use_fn_validation;
var output_schema50911_52060 = deercreeklabs.baracus.ByteArray;
var input_schema50912_52061 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50913_52062 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50912_52061);
}),null));
var output_checker50914_52063 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50911_52060);
}),null));
var ret__40100__auto___52064 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__50915){
var validate__37763__auto__ = cljs.core.deref(ufv___52059);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52067 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50915], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50922_52068 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50923_52069 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__50924_52070 = input_schema50912_52061;
var G__50925_52071 = cljs.core.deref(input_checker50913_52062);
var G__50926_52072 = args__37764__auto___52067;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50922_52068,G__50923_52069,G__50924_52070,G__50925_52071,G__50926_52072) : schema.core.fn_validator.call(null,G__50922_52068,G__50923_52069,G__50924_52070,G__50925_52071,G__50926_52072));
} else {
var temp__5804__auto___52075 = (function (){var fexpr__50927 = cljs.core.deref(input_checker50913_52062);
return (fexpr__50927.cljs$core$IFn$_invoke$arity$1 ? fexpr__50927.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52067) : fexpr__50927.call(null,args__37764__auto___52067));
})();
if(cljs.core.truth_(temp__5804__auto___52075)){
var error__37765__auto___52076 = temp__5804__auto___52075;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52076], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50912_52061,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52067,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52076], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__50915;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50932_52078 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50933_52079 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__50934_52080 = output_schema50911_52060;
var G__50935_52081 = cljs.core.deref(output_checker50914_52063);
var G__50936_52082 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50932_52078,G__50933_52079,G__50934_52080,G__50935_52081,G__50936_52082) : schema.core.fn_validator.call(null,G__50932_52078,G__50933_52079,G__50934_52080,G__50935_52081,G__50936_52082));
} else {
var temp__5804__auto___52083 = (function (){var fexpr__50938 = cljs.core.deref(output_checker50914_52063);
return (fexpr__50938.cljs$core$IFn$_invoke$arity$1 ? fexpr__50938.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50938.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52083)){
var error__37765__auto___52085 = temp__5804__auto___52083;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52085], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50911_52060,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52085], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema50911_52060,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50912_52061], null)));

var ufv___52089 = schema.utils.use_fn_validation;
var output_schema50940_52090 = schema.core.Bool;
var input_schema50941_52091 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker50942_52092 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50941_52091);
}),null));
var output_checker50943_52093 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50940_52090);
}),null));
var ret__40100__auto___52094 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__50945){
var validate__37763__auto__ = cljs.core.deref(ufv___52089);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52095 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50945], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50951_52096 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50952_52097 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__50953_52098 = input_schema50941_52091;
var G__50954_52099 = cljs.core.deref(input_checker50942_52092);
var G__50955_52100 = args__37764__auto___52095;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50951_52096,G__50952_52097,G__50953_52098,G__50954_52099,G__50955_52100) : schema.core.fn_validator.call(null,G__50951_52096,G__50952_52097,G__50953_52098,G__50954_52099,G__50955_52100));
} else {
var temp__5804__auto___52101 = (function (){var fexpr__50956 = cljs.core.deref(input_checker50942_52092);
return (fexpr__50956.cljs$core$IFn$_invoke$arity$1 ? fexpr__50956.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52095) : fexpr__50956.call(null,args__37764__auto___52095));
})();
if(cljs.core.truth_(temp__5804__auto___52101)){
var error__37765__auto___52102 = temp__5804__auto___52101;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52102], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50941_52091,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52095,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52102], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var arg = G__50945;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50963_52104 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__50964_52105 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__50965_52106 = output_schema50940_52090;
var G__50966_52107 = cljs.core.deref(output_checker50943_52093);
var G__50967_52108 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50963_52104,G__50964_52105,G__50965_52106,G__50966_52107,G__50967_52108) : schema.core.fn_validator.call(null,G__50963_52104,G__50964_52105,G__50965_52106,G__50966_52107,G__50967_52108));
} else {
var temp__5804__auto___52109 = (function (){var fexpr__50969 = cljs.core.deref(output_checker50943_52093);
return (fexpr__50969.cljs$core$IFn$_invoke$arity$1 ? fexpr__50969.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__50969.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52109)){
var error__37765__auto___52112 = temp__5804__auto___52109;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52112], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50940_52090,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52112], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema50940_52090,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50941_52091], null)));

var ufv___52115 = schema.utils.use_fn_validation;
var output_schema50974_52116 = schema.core.Bool;
var input_schema50975_52117 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker50976_52118 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema50975_52117);
}),null));
var output_checker50977_52119 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema50974_52116);
}),null));
var ret__40100__auto___52120 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__50978,G__50979){
var validate__37763__auto__ = cljs.core.deref(ufv___52115);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52121 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__50978,G__50979], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__50982_52122 = new cljs.core.Keyword(null,"input","input",556931961);
var G__50983_52123 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__50984_52124 = input_schema50975_52117;
var G__50985_52125 = cljs.core.deref(input_checker50976_52118);
var G__50986_52126 = args__37764__auto___52121;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__50982_52122,G__50983_52123,G__50984_52124,G__50985_52125,G__50986_52126) : schema.core.fn_validator.call(null,G__50982_52122,G__50983_52123,G__50984_52124,G__50985_52125,G__50986_52126));
} else {
var temp__5804__auto___52128 = (function (){var fexpr__50987 = cljs.core.deref(input_checker50976_52118);
return (fexpr__50987.cljs$core$IFn$_invoke$arity$1 ? fexpr__50987.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52121) : fexpr__50987.call(null,args__37764__auto___52121));
})();
if(cljs.core.truth_(temp__5804__auto___52128)){
var error__37765__auto___52129 = temp__5804__auto___52128;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52129], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema50975_52117,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52121,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52129], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var reader_schema = G__50978;
var writer_schema = G__50979;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51001_52135 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51002_52136 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__51003_52137 = output_schema50974_52116;
var G__51004_52138 = cljs.core.deref(output_checker50977_52119);
var G__51005_52139 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51001_52135,G__51002_52136,G__51003_52137,G__51004_52138,G__51005_52139) : schema.core.fn_validator.call(null,G__51001_52135,G__51002_52136,G__51003_52137,G__51004_52138,G__51005_52139));
} else {
var temp__5804__auto___52141 = (function (){var fexpr__51006 = cljs.core.deref(output_checker50977_52119);
return (fexpr__51006.cljs$core$IFn$_invoke$arity$1 ? fexpr__51006.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51006.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52141)){
var error__37765__auto___52142 = temp__5804__auto___52141;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52142], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema50974_52116,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52142], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema50974_52116,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema50975_52117], null)));

var ufv___52143 = schema.utils.use_fn_validation;
var output_schema51010_52144 = schema.core.Any;
var input_schema51013_52145 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker51014_52146 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51013_52145);
}),null));
var output_checker51015_52147 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51010_52144);
}),null));
var ret__40100__auto___52148 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__51016){
var validate__37763__auto__ = cljs.core.deref(ufv___52143);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52150 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51016], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51020_52152 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51021_52153 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__51022_52154 = input_schema51013_52145;
var G__51023_52155 = cljs.core.deref(input_checker51014_52146);
var G__51024_52156 = args__37764__auto___52150;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51020_52152,G__51021_52153,G__51022_52154,G__51023_52155,G__51024_52156) : schema.core.fn_validator.call(null,G__51020_52152,G__51021_52153,G__51022_52154,G__51023_52155,G__51024_52156));
} else {
var temp__5804__auto___52157 = (function (){var fexpr__51025 = cljs.core.deref(input_checker51014_52146);
return (fexpr__51025.cljs$core$IFn$_invoke$arity$1 ? fexpr__51025.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52150) : fexpr__51025.call(null,args__37764__auto___52150));
})();
if(cljs.core.truth_(temp__5804__auto___52157)){
var error__37765__auto___52159 = temp__5804__auto___52157;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52159], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51013_52145,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52150,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52159], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51016;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51032_52160 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51033_52161 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__51034_52162 = output_schema51010_52144;
var G__51035_52163 = cljs.core.deref(output_checker51015_52147);
var G__51036_52164 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51032_52160,G__51033_52161,G__51034_52162,G__51035_52163,G__51036_52164) : schema.core.fn_validator.call(null,G__51032_52160,G__51033_52161,G__51034_52162,G__51035_52163,G__51036_52164));
} else {
var temp__5804__auto___52166 = (function (){var fexpr__51037 = cljs.core.deref(output_checker51015_52147);
return (fexpr__51037.cljs$core$IFn$_invoke$arity$1 ? fexpr__51037.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51037.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52166)){
var error__37765__auto___52167 = temp__5804__auto___52166;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52167], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51010_52144,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52167], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema51010_52144,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51013_52145], null)));

var ufv___52170 = schema.utils.use_fn_validation;
var output_schema51043_52171 = schema.core.Any;
var input_schema51044_52172 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker51045_52173 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51044_52172);
}),null));
var output_checker51046_52174 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51043_52171);
}),null));
var ret__40100__auto___52177 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__51047){
var validate__37763__auto__ = cljs.core.deref(ufv___52170);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52178 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51047], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51053_52179 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51054_52180 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__51055_52181 = input_schema51044_52172;
var G__51056_52182 = cljs.core.deref(input_checker51045_52173);
var G__51057_52183 = args__37764__auto___52178;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51053_52179,G__51054_52180,G__51055_52181,G__51056_52182,G__51057_52183) : schema.core.fn_validator.call(null,G__51053_52179,G__51054_52180,G__51055_52181,G__51056_52182,G__51057_52183));
} else {
var temp__5804__auto___52185 = (function (){var fexpr__51060 = cljs.core.deref(input_checker51045_52173);
return (fexpr__51060.cljs$core$IFn$_invoke$arity$1 ? fexpr__51060.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52178) : fexpr__51060.call(null,args__37764__auto___52178));
})();
if(cljs.core.truth_(temp__5804__auto___52185)){
var error__37765__auto___52188 = temp__5804__auto___52185;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52188], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51044_52172,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52178,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52188], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51047;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51069_52190 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51070_52191 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__51071_52192 = output_schema51043_52171;
var G__51072_52193 = cljs.core.deref(output_checker51046_52174);
var G__51073_52194 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51069_52190,G__51070_52191,G__51071_52192,G__51072_52193,G__51073_52194) : schema.core.fn_validator.call(null,G__51069_52190,G__51070_52191,G__51071_52192,G__51072_52193,G__51073_52194));
} else {
var temp__5804__auto___52196 = (function (){var fexpr__51075 = cljs.core.deref(output_checker51046_52174);
return (fexpr__51075.cljs$core$IFn$_invoke$arity$1 ? fexpr__51075.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51075.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52196)){
var error__37765__auto___52197 = temp__5804__auto___52196;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52197], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51043_52171,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52197], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema51043_52171,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51044_52172], null)));

var ufv___52202 = schema.utils.use_fn_validation;
var output_schema51085_52203 = deercreeklabs.lancaster.LancasterSchema;
var input_schema51087_52204 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema51091_52205 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker51088_52206 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51087_52204);
}),null));
var output_checker51089_52207 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51085_52203);
}),null));
var input_checker51092_52208 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51091_52205);
}),null));
var output_checker51093_52209 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51085_52203);
}),null));
var ret__40100__auto___52211 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__51112 = arguments.length;
switch (G__51112) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__51090){
var validate__37763__auto__ = cljs.core.deref(ufv___52202);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52217 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51090], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51118_52218 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51119_52219 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__51120_52220 = input_schema51087_52204;
var G__51121_52221 = cljs.core.deref(input_checker51088_52206);
var G__51122_52222 = args__37764__auto___52217;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51118_52218,G__51119_52219,G__51120_52220,G__51121_52221,G__51122_52222) : schema.core.fn_validator.call(null,G__51118_52218,G__51119_52219,G__51120_52220,G__51121_52221,G__51122_52222));
} else {
var temp__5804__auto___52223 = (function (){var fexpr__51124 = cljs.core.deref(input_checker51088_52206);
return (fexpr__51124.cljs$core$IFn$_invoke$arity$1 ? fexpr__51124.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52217) : fexpr__51124.call(null,args__37764__auto___52217));
})();
if(cljs.core.truth_(temp__5804__auto___52223)){
var error__37765__auto___52224 = temp__5804__auto___52223;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52224], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51087_52204,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52217,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52224], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51090;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51127_52228 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51128_52229 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__51129_52230 = output_schema51085_52203;
var G__51130_52231 = cljs.core.deref(output_checker51089_52207);
var G__51131_52232 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51127_52228,G__51128_52229,G__51129_52230,G__51130_52231,G__51131_52232) : schema.core.fn_validator.call(null,G__51127_52228,G__51128_52229,G__51129_52230,G__51130_52231,G__51131_52232));
} else {
var temp__5804__auto___52233 = (function (){var fexpr__51135 = cljs.core.deref(output_checker51089_52207);
return (fexpr__51135.cljs$core$IFn$_invoke$arity$1 ? fexpr__51135.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51135.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52233)){
var error__37765__auto___52234 = temp__5804__auto___52233;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52234], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51085_52203,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52234], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__51094,G__51095){
var validate__37763__auto__ = cljs.core.deref(ufv___52202);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52239 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51094,G__51095], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51140_52240 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51141_52241 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__51142_52242 = input_schema51091_52205;
var G__51143_52243 = cljs.core.deref(input_checker51092_52208);
var G__51144_52244 = args__37764__auto___52239;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51140_52240,G__51141_52241,G__51142_52242,G__51143_52243,G__51144_52244) : schema.core.fn_validator.call(null,G__51140_52240,G__51141_52241,G__51142_52242,G__51143_52243,G__51144_52244));
} else {
var temp__5804__auto___52245 = (function (){var fexpr__51147 = cljs.core.deref(input_checker51092_52208);
return (fexpr__51147.cljs$core$IFn$_invoke$arity$1 ? fexpr__51147.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52239) : fexpr__51147.call(null,args__37764__auto___52239));
})();
if(cljs.core.truth_(temp__5804__auto___52245)){
var error__37765__auto___52247 = temp__5804__auto___52245;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52247], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51091_52205,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52239,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52247], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51094;
var field_kw_or_branch_i = G__51095;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51154_52250 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51155_52251 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__51156_52252 = output_schema51085_52203;
var G__51157_52253 = cljs.core.deref(output_checker51093_52209);
var G__51158_52254 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51154_52250,G__51155_52251,G__51156_52252,G__51157_52253,G__51158_52254) : schema.core.fn_validator.call(null,G__51154_52250,G__51155_52251,G__51156_52252,G__51157_52253,G__51158_52254));
} else {
var temp__5804__auto___52257 = (function (){var fexpr__51160 = cljs.core.deref(output_checker51093_52209);
return (fexpr__51160.cljs$core$IFn$_invoke$arity$1 ? fexpr__51160.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51160.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52257)){
var error__37765__auto___52258 = temp__5804__auto___52257;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52258], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51085_52203,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52258], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema51085_52203,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51087_52204,input_schema51091_52205], null)));

var ufv___52262 = schema.utils.use_fn_validation;
var output_schema51164_52263 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema51165_52264 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema51170_52265 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker51166_52266 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51165_52264);
}),null));
var output_checker51167_52267 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51164_52263);
}),null));
var input_checker51171_52268 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51170_52265);
}),null));
var output_checker51172_52269 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51164_52263);
}),null));
var ret__40100__auto___52274 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__51188 = arguments.length;
switch (G__51188) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__51168,G__51169){
var validate__37763__auto__ = cljs.core.deref(ufv___52262);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52279 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51168,G__51169], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51195_52280 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51196_52281 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__51197_52282 = input_schema51165_52264;
var G__51198_52283 = cljs.core.deref(input_checker51166_52266);
var G__51199_52284 = args__37764__auto___52279;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51195_52280,G__51196_52281,G__51197_52282,G__51198_52283,G__51199_52284) : schema.core.fn_validator.call(null,G__51195_52280,G__51196_52281,G__51197_52282,G__51198_52283,G__51199_52284));
} else {
var temp__5804__auto___52287 = (function (){var fexpr__51202 = cljs.core.deref(input_checker51166_52266);
return (fexpr__51202.cljs$core$IFn$_invoke$arity$1 ? fexpr__51202.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52279) : fexpr__51202.call(null,args__37764__auto___52279));
})();
if(cljs.core.truth_(temp__5804__auto___52287)){
var error__37765__auto___52288 = temp__5804__auto___52287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52288], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51165_52264,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52279,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52288], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51168;
var path = G__51169;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51205_52289 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51206_52290 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__51207_52291 = output_schema51164_52263;
var G__51208_52292 = cljs.core.deref(output_checker51167_52267);
var G__51209_52293 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51205_52289,G__51206_52290,G__51207_52291,G__51208_52292,G__51209_52293) : schema.core.fn_validator.call(null,G__51205_52289,G__51206_52290,G__51207_52291,G__51208_52292,G__51209_52293));
} else {
var temp__5804__auto___52299 = (function (){var fexpr__51211 = cljs.core.deref(output_checker51167_52267);
return (fexpr__51211.cljs$core$IFn$_invoke$arity$1 ? fexpr__51211.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51211.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52299)){
var error__37765__auto___52300 = temp__5804__auto___52299;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52300], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51164_52263,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52300], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__51173,G__51174,G__51175){
var validate__37763__auto__ = cljs.core.deref(ufv___52262);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52303 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51173,G__51174,G__51175], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51218_52304 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51219_52305 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__51220_52306 = input_schema51170_52265;
var G__51221_52307 = cljs.core.deref(input_checker51171_52268);
var G__51222_52308 = args__37764__auto___52303;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51218_52304,G__51219_52305,G__51220_52306,G__51221_52307,G__51222_52308) : schema.core.fn_validator.call(null,G__51218_52304,G__51219_52305,G__51220_52306,G__51221_52307,G__51222_52308));
} else {
var temp__5804__auto___52311 = (function (){var fexpr__51223 = cljs.core.deref(input_checker51171_52268);
return (fexpr__51223.cljs$core$IFn$_invoke$arity$1 ? fexpr__51223.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52303) : fexpr__51223.call(null,args__37764__auto___52303));
})();
if(cljs.core.truth_(temp__5804__auto___52311)){
var error__37765__auto___52313 = temp__5804__auto___52311;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52313], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51170_52265,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52303,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52313], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51173;
var path = G__51174;
var G__51226 = G__51175;
var map__51227 = G__51226;
var map__51227__$1 = cljs.core.__destructure_map(map__51227);
var opts = map__51227__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51227__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__51226__$1 = G__51226;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__51230 = G__51226__$1;
var map__51230__$1 = cljs.core.__destructure_map(map__51230);
var opts__$1 = map__51230__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51230__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51237_52318 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51238_52319 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__51239_52320 = output_schema51164_52263;
var G__51240_52321 = cljs.core.deref(output_checker51172_52269);
var G__51241_52322 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51237_52318,G__51238_52319,G__51239_52320,G__51240_52321,G__51241_52322) : schema.core.fn_validator.call(null,G__51237_52318,G__51238_52319,G__51239_52320,G__51240_52321,G__51241_52322));
} else {
var temp__5804__auto___52325 = (function (){var fexpr__51244 = cljs.core.deref(output_checker51172_52269);
return (fexpr__51244.cljs$core$IFn$_invoke$arity$1 ? fexpr__51244.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51244.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52325)){
var error__37765__auto___52328 = temp__5804__auto___52325;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52328], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51164_52263,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52328], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema51164_52263,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51165_52264,input_schema51170_52265], null)));

var ufv___52330 = schema.utils.use_fn_validation;
var output_schema51250_52331 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema51251_52332 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker51252_52333 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51251_52332);
}),null));
var output_checker51253_52334 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51250_52331);
}),null));
var ret__40100__auto___52338 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__51254){
var validate__37763__auto__ = cljs.core.deref(ufv___52330);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52339 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51254], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51260_52340 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51261_52341 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__51262_52342 = input_schema51251_52332;
var G__51263_52343 = cljs.core.deref(input_checker51252_52333);
var G__51264_52344 = args__37764__auto___52339;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51260_52340,G__51261_52341,G__51262_52342,G__51263_52343,G__51264_52344) : schema.core.fn_validator.call(null,G__51260_52340,G__51261_52341,G__51262_52342,G__51263_52343,G__51264_52344));
} else {
var temp__5804__auto___52346 = (function (){var fexpr__51265 = cljs.core.deref(input_checker51252_52333);
return (fexpr__51265.cljs$core$IFn$_invoke$arity$1 ? fexpr__51265.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52339) : fexpr__51265.call(null,args__37764__auto___52339));
})();
if(cljs.core.truth_(temp__5804__auto___52346)){
var error__37765__auto___52347 = temp__5804__auto___52346;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52347], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51251_52332,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52339,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52347], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var union_schema = G__51254;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51268_52348 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51269_52349 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__51270_52350 = output_schema51250_52331;
var G__51271_52351 = cljs.core.deref(output_checker51253_52334);
var G__51272_52352 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51268_52348,G__51269_52349,G__51270_52350,G__51271_52351,G__51272_52352) : schema.core.fn_validator.call(null,G__51268_52348,G__51269_52349,G__51270_52350,G__51271_52351,G__51272_52352));
} else {
var temp__5804__auto___52357 = (function (){var fexpr__51274 = cljs.core.deref(output_checker51253_52334);
return (fexpr__51274.cljs$core$IFn$_invoke$arity$1 ? fexpr__51274.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51274.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52357)){
var error__37765__auto___52358 = temp__5804__auto___52357;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52358], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51250_52331,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52358], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema51250_52331,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51251_52332], null)));

var ufv___52359 = schema.utils.use_fn_validation;
var output_schema51279_52360 = deercreeklabs.lancaster.LancasterSchema;
var input_schema51281_52361 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker51282_52362 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51281_52361);
}),null));
var output_checker51283_52363 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51279_52360);
}),null));
var ret__40100__auto___52365 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__51284,G__51285){
var validate__37763__auto__ = cljs.core.deref(ufv___52359);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52366 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51284,G__51285], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51287_52367 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51288_52368 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__51289_52369 = input_schema51281_52361;
var G__51290_52370 = cljs.core.deref(input_checker51282_52362);
var G__51291_52371 = args__37764__auto___52366;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51287_52367,G__51288_52368,G__51289_52369,G__51290_52370,G__51291_52371) : schema.core.fn_validator.call(null,G__51287_52367,G__51288_52368,G__51289_52369,G__51290_52370,G__51291_52371));
} else {
var temp__5804__auto___52372 = (function (){var fexpr__51295 = cljs.core.deref(input_checker51282_52362);
return (fexpr__51295.cljs$core$IFn$_invoke$arity$1 ? fexpr__51295.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52366) : fexpr__51295.call(null,args__37764__auto___52366));
})();
if(cljs.core.truth_(temp__5804__auto___52372)){
var error__37765__auto___52374 = temp__5804__auto___52372;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52374], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51281_52361,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52366,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52374], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var union_schema = G__51284;
var branch_index = G__51285;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51306_52378 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51307_52379 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__51308_52380 = output_schema51279_52360;
var G__51309_52381 = cljs.core.deref(output_checker51283_52363);
var G__51310_52382 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51306_52378,G__51307_52379,G__51308_52380,G__51309_52381,G__51310_52382) : schema.core.fn_validator.call(null,G__51306_52378,G__51307_52379,G__51308_52380,G__51309_52381,G__51310_52382));
} else {
var temp__5804__auto___52384 = (function (){var fexpr__51312 = cljs.core.deref(output_checker51283_52363);
return (fexpr__51312.cljs$core$IFn$_invoke$arity$1 ? fexpr__51312.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51312.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52384)){
var error__37765__auto___52385 = temp__5804__auto___52384;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52385], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51279_52360,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52385], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema51279_52360,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51281_52361], null)));

var ufv___52388 = schema.utils.use_fn_validation;
var output_schema51317_52389 = schema.core.Keyword;
var input_schema51318_52390 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker51319_52391 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema51318_52390);
}),null));
var output_checker51320_52392 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema51317_52389);
}),null));
var ret__40100__auto___52395 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__51321){
var validate__37763__auto__ = cljs.core.deref(ufv___52388);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___52396 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__51321], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51323_52397 = new cljs.core.Keyword(null,"input","input",556931961);
var G__51324_52398 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__51325_52399 = input_schema51318_52390;
var G__51326_52400 = cljs.core.deref(input_checker51319_52391);
var G__51327_52401 = args__37764__auto___52396;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51323_52397,G__51324_52398,G__51325_52399,G__51326_52400,G__51327_52401) : schema.core.fn_validator.call(null,G__51323_52397,G__51324_52398,G__51325_52399,G__51326_52400,G__51327_52401));
} else {
var temp__5804__auto___52403 = (function (){var fexpr__51329 = cljs.core.deref(input_checker51319_52391);
return (fexpr__51329.cljs$core$IFn$_invoke$arity$1 ? fexpr__51329.cljs$core$IFn$_invoke$arity$1(args__37764__auto___52396) : fexpr__51329.call(null,args__37764__auto___52396));
})();
if(cljs.core.truth_(temp__5804__auto___52403)){
var error__37765__auto___52404 = temp__5804__auto___52403;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52404], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema51318_52390,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___52396,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52404], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var schema__$1 = G__51321;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__51331_52409 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__51332_52410 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__51333_52411 = output_schema51317_52389;
var G__51334_52412 = cljs.core.deref(output_checker51320_52392);
var G__51335_52413 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__51331_52409,G__51332_52410,G__51333_52411,G__51334_52412,G__51335_52413) : schema.core.fn_validator.call(null,G__51331_52409,G__51332_52410,G__51333_52411,G__51334_52412,G__51335_52413));
} else {
var temp__5804__auto___52414 = (function (){var fexpr__51336 = cljs.core.deref(output_checker51320_52392);
return (fexpr__51336.cljs$core$IFn$_invoke$arity$1 ? fexpr__51336.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__51336.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___52414)){
var error__37765__auto___52415 = temp__5804__auto___52414;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___52415], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema51317_52389,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___52415], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema51317_52389,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema51318_52390], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
