goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30113 = (function (f,blockable,meta30114){
this.f = f;
this.blockable = blockable;
this.meta30114 = meta30114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30115,meta30114__$1){
var self__ = this;
var _30115__$1 = this;
return (new cljs.core.async.t_cljs$core$async30113(self__.f,self__.blockable,meta30114__$1));
}));

(cljs.core.async.t_cljs$core$async30113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30115){
var self__ = this;
var _30115__$1 = this;
return self__.meta30114;
}));

(cljs.core.async.t_cljs$core$async30113.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30113.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30113.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30113.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30114","meta30114",1472942630,null)], null);
}));

(cljs.core.async.t_cljs$core$async30113.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30113");

(cljs.core.async.t_cljs$core$async30113.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30113");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30113.
 */
cljs.core.async.__GT_t_cljs$core$async30113 = (function cljs$core$async$__GT_t_cljs$core$async30113(f,blockable,meta30114){
return (new cljs.core.async.t_cljs$core$async30113(f,blockable,meta30114));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30106 = arguments.length;
switch (G__30106) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async30113(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30147 = arguments.length;
switch (G__30147) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30164 = arguments.length;
switch (G__30164) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30189 = arguments.length;
switch (G__30189) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_33409 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33409) : fn1.call(null,val_33409));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33409) : fn1.call(null,val_33409));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30233 = arguments.length;
switch (G__30233) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___33411 = n;
var x_33412 = (0);
while(true){
if((x_33412 < n__5636__auto___33411)){
(a[x_33412] = x_33412);

var G__33417 = (x_33412 + (1));
x_33412 = G__33417;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30248 = (function (flag,meta30249){
this.flag = flag;
this.meta30249 = meta30249;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30248.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30250,meta30249__$1){
var self__ = this;
var _30250__$1 = this;
return (new cljs.core.async.t_cljs$core$async30248(self__.flag,meta30249__$1));
}));

(cljs.core.async.t_cljs$core$async30248.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30250){
var self__ = this;
var _30250__$1 = this;
return self__.meta30249;
}));

(cljs.core.async.t_cljs$core$async30248.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30248.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30248.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30248.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30248.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30249","meta30249",1043950803,null)], null);
}));

(cljs.core.async.t_cljs$core$async30248.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30248.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30248");

(cljs.core.async.t_cljs$core$async30248.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30248");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30248.
 */
cljs.core.async.__GT_t_cljs$core$async30248 = (function cljs$core$async$__GT_t_cljs$core$async30248(flag,meta30249){
return (new cljs.core.async.t_cljs$core$async30248(flag,meta30249));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async30248(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30265 = (function (flag,cb,meta30266){
this.flag = flag;
this.cb = cb;
this.meta30266 = meta30266;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30265.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30267,meta30266__$1){
var self__ = this;
var _30267__$1 = this;
return (new cljs.core.async.t_cljs$core$async30265(self__.flag,self__.cb,meta30266__$1));
}));

(cljs.core.async.t_cljs$core$async30265.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30267){
var self__ = this;
var _30267__$1 = this;
return self__.meta30266;
}));

(cljs.core.async.t_cljs$core$async30265.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30265.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30265.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30265.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30265.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30266","meta30266",-23461282,null)], null);
}));

(cljs.core.async.t_cljs$core$async30265.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30265.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30265");

(cljs.core.async.t_cljs$core$async30265.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30265");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30265.
 */
cljs.core.async.__GT_t_cljs$core$async30265 = (function cljs$core$async$__GT_t_cljs$core$async30265(flag,cb,meta30266){
return (new cljs.core.async.t_cljs$core$async30265(flag,cb,meta30266));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async30265(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30299_SHARP_){
var G__30319 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30299_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30319) : fret.call(null,G__30319));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30300_SHARP_){
var G__30325 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30300_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30325) : fret.call(null,G__30325));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33454 = (i + (1));
i = G__33454;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___33464 = arguments.length;
var i__5770__auto___33466 = (0);
while(true){
if((i__5770__auto___33466 < len__5769__auto___33464)){
args__5775__auto__.push((arguments[i__5770__auto___33466]));

var G__33468 = (i__5770__auto___33466 + (1));
i__5770__auto___33466 = G__33468;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30349){
var map__30350 = p__30349;
var map__30350__$1 = cljs.core.__destructure_map(map__30350);
var opts = map__30350__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30346){
var G__30347 = cljs.core.first(seq30346);
var seq30346__$1 = cljs.core.next(seq30346);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30347,seq30346__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30365 = arguments.length;
switch (G__30365) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30016__auto___33484 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_30467){
var state_val_30468 = (state_30467[(1)]);
if((state_val_30468 === (7))){
var inst_30455 = (state_30467[(2)]);
var state_30467__$1 = state_30467;
var statearr_30478_33486 = state_30467__$1;
(statearr_30478_33486[(2)] = inst_30455);

(statearr_30478_33486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (1))){
var state_30467__$1 = state_30467;
var statearr_30479_33488 = state_30467__$1;
(statearr_30479_33488[(2)] = null);

(statearr_30479_33488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (4))){
var inst_30429 = (state_30467[(7)]);
var inst_30429__$1 = (state_30467[(2)]);
var inst_30431 = (inst_30429__$1 == null);
var state_30467__$1 = (function (){var statearr_30481 = state_30467;
(statearr_30481[(7)] = inst_30429__$1);

return statearr_30481;
})();
if(cljs.core.truth_(inst_30431)){
var statearr_30484_33490 = state_30467__$1;
(statearr_30484_33490[(1)] = (5));

} else {
var statearr_30485_33491 = state_30467__$1;
(statearr_30485_33491[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (13))){
var state_30467__$1 = state_30467;
var statearr_30488_33492 = state_30467__$1;
(statearr_30488_33492[(2)] = null);

(statearr_30488_33492[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (6))){
var inst_30429 = (state_30467[(7)]);
var state_30467__$1 = state_30467;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30467__$1,(11),to,inst_30429);
} else {
if((state_val_30468 === (3))){
var inst_30457 = (state_30467[(2)]);
var state_30467__$1 = state_30467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30467__$1,inst_30457);
} else {
if((state_val_30468 === (12))){
var state_30467__$1 = state_30467;
var statearr_30494_33493 = state_30467__$1;
(statearr_30494_33493[(2)] = null);

(statearr_30494_33493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (2))){
var state_30467__$1 = state_30467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30467__$1,(4),from);
} else {
if((state_val_30468 === (11))){
var inst_30446 = (state_30467[(2)]);
var state_30467__$1 = state_30467;
if(cljs.core.truth_(inst_30446)){
var statearr_30496_33494 = state_30467__$1;
(statearr_30496_33494[(1)] = (12));

} else {
var statearr_30497_33495 = state_30467__$1;
(statearr_30497_33495[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (9))){
var state_30467__$1 = state_30467;
var statearr_30498_33497 = state_30467__$1;
(statearr_30498_33497[(2)] = null);

(statearr_30498_33497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (5))){
var state_30467__$1 = state_30467;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30507_33498 = state_30467__$1;
(statearr_30507_33498[(1)] = (8));

} else {
var statearr_30508_33509 = state_30467__$1;
(statearr_30508_33509[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (14))){
var inst_30453 = (state_30467[(2)]);
var state_30467__$1 = state_30467;
var statearr_30513_33510 = state_30467__$1;
(statearr_30513_33510[(2)] = inst_30453);

(statearr_30513_33510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (10))){
var inst_30443 = (state_30467[(2)]);
var state_30467__$1 = state_30467;
var statearr_30516_33511 = state_30467__$1;
(statearr_30516_33511[(2)] = inst_30443);

(statearr_30516_33511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30468 === (8))){
var inst_30437 = cljs.core.async.close_BANG_(to);
var state_30467__$1 = state_30467;
var statearr_30524_33512 = state_30467__$1;
(statearr_30524_33512[(2)] = inst_30437);

(statearr_30524_33512[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_30537 = [null,null,null,null,null,null,null,null];
(statearr_30537[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_30537[(1)] = (1));

return statearr_30537;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_30467){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_30467);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e30541){var ex__29723__auto__ = e30541;
var statearr_30542_33515 = state_30467;
(statearr_30542_33515[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_30467[(4)]))){
var statearr_30544_33516 = state_30467;
(statearr_30544_33516[(1)] = cljs.core.first((state_30467[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33519 = state_30467;
state_30467 = G__33519;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_30467){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_30467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_30551 = f__30017__auto__();
(statearr_30551[(6)] = c__30016__auto___33484);

return statearr_30551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__30573){
var vec__30574 = p__30573;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30574,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30574,(1),null);
var job = vec__30574;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30016__auto___33523 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_30581){
var state_val_30582 = (state_30581[(1)]);
if((state_val_30582 === (1))){
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30581__$1,(2),res,v);
} else {
if((state_val_30582 === (2))){
var inst_30578 = (state_30581[(2)]);
var inst_30579 = cljs.core.async.close_BANG_(res);
var state_30581__$1 = (function (){var statearr_30584 = state_30581;
(statearr_30584[(7)] = inst_30578);

return statearr_30584;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30581__$1,inst_30579);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0 = (function (){
var statearr_30585 = [null,null,null,null,null,null,null,null];
(statearr_30585[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__);

(statearr_30585[(1)] = (1));

return statearr_30585;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1 = (function (state_30581){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_30581);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e30586){var ex__29723__auto__ = e30586;
var statearr_30587_33528 = state_30581;
(statearr_30587_33528[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_30581[(4)]))){
var statearr_30588_33529 = state_30581;
(statearr_30588_33529[(1)] = cljs.core.first((state_30581[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33530 = state_30581;
state_30581 = G__33530;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = function(state_30581){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1.call(this,state_30581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_30589 = f__30017__auto__();
(statearr_30589[(6)] = c__30016__auto___33523);

return statearr_30589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__30591){
var vec__30592 = p__30591;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30592,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30592,(1),null);
var job = vec__30592;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___33534 = n;
var __33536 = (0);
while(true){
if((__33536 < n__5636__auto___33534)){
var G__30596_33537 = type;
var G__30596_33538__$1 = (((G__30596_33537 instanceof cljs.core.Keyword))?G__30596_33537.fqn:null);
switch (G__30596_33538__$1) {
case "compute":
var c__30016__auto___33540 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33536,c__30016__auto___33540,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async){
return (function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = ((function (__33536,c__30016__auto___33540,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async){
return (function (state_30609){
var state_val_30610 = (state_30609[(1)]);
if((state_val_30610 === (1))){
var state_30609__$1 = state_30609;
var statearr_30618_33543 = state_30609__$1;
(statearr_30618_33543[(2)] = null);

(statearr_30618_33543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30610 === (2))){
var state_30609__$1 = state_30609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30609__$1,(4),jobs);
} else {
if((state_val_30610 === (3))){
var inst_30607 = (state_30609[(2)]);
var state_30609__$1 = state_30609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30609__$1,inst_30607);
} else {
if((state_val_30610 === (4))){
var inst_30599 = (state_30609[(2)]);
var inst_30600 = process__$1(inst_30599);
var state_30609__$1 = state_30609;
if(cljs.core.truth_(inst_30600)){
var statearr_30636_33544 = state_30609__$1;
(statearr_30636_33544[(1)] = (5));

} else {
var statearr_30637_33545 = state_30609__$1;
(statearr_30637_33545[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30610 === (5))){
var state_30609__$1 = state_30609;
var statearr_30638_33547 = state_30609__$1;
(statearr_30638_33547[(2)] = null);

(statearr_30638_33547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30610 === (6))){
var state_30609__$1 = state_30609;
var statearr_30640_33552 = state_30609__$1;
(statearr_30640_33552[(2)] = null);

(statearr_30640_33552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30610 === (7))){
var inst_30605 = (state_30609[(2)]);
var state_30609__$1 = state_30609;
var statearr_30642_33553 = state_30609__$1;
(statearr_30642_33553[(2)] = inst_30605);

(statearr_30642_33553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33536,c__30016__auto___33540,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async))
;
return ((function (__33536,switch__29717__auto__,c__30016__auto___33540,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0 = (function (){
var statearr_30643 = [null,null,null,null,null,null,null];
(statearr_30643[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__);

(statearr_30643[(1)] = (1));

return statearr_30643;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1 = (function (state_30609){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_30609);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e30644){var ex__29723__auto__ = e30644;
var statearr_30645_33555 = state_30609;
(statearr_30645_33555[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_30609[(4)]))){
var statearr_30646_33558 = state_30609;
(statearr_30646_33558[(1)] = cljs.core.first((state_30609[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33559 = state_30609;
state_30609 = G__33559;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = function(state_30609){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1.call(this,state_30609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__;
})()
;})(__33536,switch__29717__auto__,c__30016__auto___33540,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async))
})();
var state__30018__auto__ = (function (){var statearr_30647 = f__30017__auto__();
(statearr_30647[(6)] = c__30016__auto___33540);

return statearr_30647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
});})(__33536,c__30016__auto___33540,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async))
);


break;
case "async":
var c__30016__auto___33560 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33536,c__30016__auto___33560,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async){
return (function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = ((function (__33536,c__30016__auto___33560,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async){
return (function (state_30663){
var state_val_30664 = (state_30663[(1)]);
if((state_val_30664 === (1))){
var state_30663__$1 = state_30663;
var statearr_30668_33561 = state_30663__$1;
(statearr_30668_33561[(2)] = null);

(statearr_30668_33561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30664 === (2))){
var state_30663__$1 = state_30663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30663__$1,(4),jobs);
} else {
if((state_val_30664 === (3))){
var inst_30661 = (state_30663[(2)]);
var state_30663__$1 = state_30663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30663__$1,inst_30661);
} else {
if((state_val_30664 === (4))){
var inst_30652 = (state_30663[(2)]);
var inst_30653 = async(inst_30652);
var state_30663__$1 = state_30663;
if(cljs.core.truth_(inst_30653)){
var statearr_30672_33566 = state_30663__$1;
(statearr_30672_33566[(1)] = (5));

} else {
var statearr_30674_33567 = state_30663__$1;
(statearr_30674_33567[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30664 === (5))){
var state_30663__$1 = state_30663;
var statearr_30675_33569 = state_30663__$1;
(statearr_30675_33569[(2)] = null);

(statearr_30675_33569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30664 === (6))){
var state_30663__$1 = state_30663;
var statearr_30676_33570 = state_30663__$1;
(statearr_30676_33570[(2)] = null);

(statearr_30676_33570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30664 === (7))){
var inst_30659 = (state_30663[(2)]);
var state_30663__$1 = state_30663;
var statearr_30677_33571 = state_30663__$1;
(statearr_30677_33571[(2)] = inst_30659);

(statearr_30677_33571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33536,c__30016__auto___33560,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async))
;
return ((function (__33536,switch__29717__auto__,c__30016__auto___33560,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0 = (function (){
var statearr_30681 = [null,null,null,null,null,null,null];
(statearr_30681[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__);

(statearr_30681[(1)] = (1));

return statearr_30681;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1 = (function (state_30663){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_30663);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e30684){var ex__29723__auto__ = e30684;
var statearr_30685_33572 = state_30663;
(statearr_30685_33572[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_30663[(4)]))){
var statearr_30686_33573 = state_30663;
(statearr_30686_33573[(1)] = cljs.core.first((state_30663[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33574 = state_30663;
state_30663 = G__33574;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = function(state_30663){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1.call(this,state_30663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__;
})()
;})(__33536,switch__29717__auto__,c__30016__auto___33560,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async))
})();
var state__30018__auto__ = (function (){var statearr_30689 = f__30017__auto__();
(statearr_30689[(6)] = c__30016__auto___33560);

return statearr_30689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
});})(__33536,c__30016__auto___33560,G__30596_33537,G__30596_33538__$1,n__5636__auto___33534,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30596_33538__$1)].join('')));

}

var G__33585 = (__33536 + (1));
__33536 = G__33585;
continue;
} else {
}
break;
}

var c__30016__auto___33589 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_30732){
var state_val_30733 = (state_30732[(1)]);
if((state_val_30733 === (7))){
var inst_30724 = (state_30732[(2)]);
var state_30732__$1 = state_30732;
var statearr_30751_33590 = state_30732__$1;
(statearr_30751_33590[(2)] = inst_30724);

(statearr_30751_33590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30733 === (1))){
var state_30732__$1 = state_30732;
var statearr_30753_33591 = state_30732__$1;
(statearr_30753_33591[(2)] = null);

(statearr_30753_33591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30733 === (4))){
var inst_30702 = (state_30732[(7)]);
var inst_30702__$1 = (state_30732[(2)]);
var inst_30703 = (inst_30702__$1 == null);
var state_30732__$1 = (function (){var statearr_30764 = state_30732;
(statearr_30764[(7)] = inst_30702__$1);

return statearr_30764;
})();
if(cljs.core.truth_(inst_30703)){
var statearr_30767_33592 = state_30732__$1;
(statearr_30767_33592[(1)] = (5));

} else {
var statearr_30770_33593 = state_30732__$1;
(statearr_30770_33593[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30733 === (6))){
var inst_30702 = (state_30732[(7)]);
var inst_30708 = (state_30732[(8)]);
var inst_30708__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_30713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30714 = [inst_30702,inst_30708__$1];
var inst_30715 = (new cljs.core.PersistentVector(null,2,(5),inst_30713,inst_30714,null));
var state_30732__$1 = (function (){var statearr_30778 = state_30732;
(statearr_30778[(8)] = inst_30708__$1);

return statearr_30778;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30732__$1,(8),jobs,inst_30715);
} else {
if((state_val_30733 === (3))){
var inst_30726 = (state_30732[(2)]);
var state_30732__$1 = state_30732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30732__$1,inst_30726);
} else {
if((state_val_30733 === (2))){
var state_30732__$1 = state_30732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30732__$1,(4),from);
} else {
if((state_val_30733 === (9))){
var inst_30721 = (state_30732[(2)]);
var state_30732__$1 = (function (){var statearr_30789 = state_30732;
(statearr_30789[(9)] = inst_30721);

return statearr_30789;
})();
var statearr_30791_33595 = state_30732__$1;
(statearr_30791_33595[(2)] = null);

(statearr_30791_33595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30733 === (5))){
var inst_30705 = cljs.core.async.close_BANG_(jobs);
var state_30732__$1 = state_30732;
var statearr_30795_33598 = state_30732__$1;
(statearr_30795_33598[(2)] = inst_30705);

(statearr_30795_33598[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30733 === (8))){
var inst_30708 = (state_30732[(8)]);
var inst_30717 = (state_30732[(2)]);
var state_30732__$1 = (function (){var statearr_30803 = state_30732;
(statearr_30803[(10)] = inst_30717);

return statearr_30803;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30732__$1,(9),results,inst_30708);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0 = (function (){
var statearr_30805 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30805[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__);

(statearr_30805[(1)] = (1));

return statearr_30805;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1 = (function (state_30732){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_30732);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e30814){var ex__29723__auto__ = e30814;
var statearr_30815_33599 = state_30732;
(statearr_30815_33599[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_30732[(4)]))){
var statearr_30818_33600 = state_30732;
(statearr_30818_33600[(1)] = cljs.core.first((state_30732[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33607 = state_30732;
state_30732 = G__33607;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = function(state_30732){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1.call(this,state_30732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_30826 = f__30017__auto__();
(statearr_30826[(6)] = c__30016__auto___33589);

return statearr_30826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


var c__30016__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_30877){
var state_val_30878 = (state_30877[(1)]);
if((state_val_30878 === (7))){
var inst_30873 = (state_30877[(2)]);
var state_30877__$1 = state_30877;
var statearr_30884_33610 = state_30877__$1;
(statearr_30884_33610[(2)] = inst_30873);

(statearr_30884_33610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (20))){
var state_30877__$1 = state_30877;
var statearr_30886_33611 = state_30877__$1;
(statearr_30886_33611[(2)] = null);

(statearr_30886_33611[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (1))){
var state_30877__$1 = state_30877;
var statearr_30890_33612 = state_30877__$1;
(statearr_30890_33612[(2)] = null);

(statearr_30890_33612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (4))){
var inst_30833 = (state_30877[(7)]);
var inst_30833__$1 = (state_30877[(2)]);
var inst_30836 = (inst_30833__$1 == null);
var state_30877__$1 = (function (){var statearr_30892 = state_30877;
(statearr_30892[(7)] = inst_30833__$1);

return statearr_30892;
})();
if(cljs.core.truth_(inst_30836)){
var statearr_30894_33613 = state_30877__$1;
(statearr_30894_33613[(1)] = (5));

} else {
var statearr_30896_33614 = state_30877__$1;
(statearr_30896_33614[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (15))){
var inst_30850 = (state_30877[(8)]);
var state_30877__$1 = state_30877;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30877__$1,(18),to,inst_30850);
} else {
if((state_val_30878 === (21))){
var inst_30868 = (state_30877[(2)]);
var state_30877__$1 = state_30877;
var statearr_30900_33615 = state_30877__$1;
(statearr_30900_33615[(2)] = inst_30868);

(statearr_30900_33615[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (13))){
var inst_30870 = (state_30877[(2)]);
var state_30877__$1 = (function (){var statearr_30901 = state_30877;
(statearr_30901[(9)] = inst_30870);

return statearr_30901;
})();
var statearr_30903_33616 = state_30877__$1;
(statearr_30903_33616[(2)] = null);

(statearr_30903_33616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (6))){
var inst_30833 = (state_30877[(7)]);
var state_30877__$1 = state_30877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30877__$1,(11),inst_30833);
} else {
if((state_val_30878 === (17))){
var inst_30863 = (state_30877[(2)]);
var state_30877__$1 = state_30877;
if(cljs.core.truth_(inst_30863)){
var statearr_30910_33618 = state_30877__$1;
(statearr_30910_33618[(1)] = (19));

} else {
var statearr_30911_33620 = state_30877__$1;
(statearr_30911_33620[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (3))){
var inst_30875 = (state_30877[(2)]);
var state_30877__$1 = state_30877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30877__$1,inst_30875);
} else {
if((state_val_30878 === (12))){
var inst_30846 = (state_30877[(10)]);
var state_30877__$1 = state_30877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30877__$1,(14),inst_30846);
} else {
if((state_val_30878 === (2))){
var state_30877__$1 = state_30877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30877__$1,(4),results);
} else {
if((state_val_30878 === (19))){
var state_30877__$1 = state_30877;
var statearr_30917_33623 = state_30877__$1;
(statearr_30917_33623[(2)] = null);

(statearr_30917_33623[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (11))){
var inst_30846 = (state_30877[(2)]);
var state_30877__$1 = (function (){var statearr_30919 = state_30877;
(statearr_30919[(10)] = inst_30846);

return statearr_30919;
})();
var statearr_30920_33624 = state_30877__$1;
(statearr_30920_33624[(2)] = null);

(statearr_30920_33624[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (9))){
var state_30877__$1 = state_30877;
var statearr_30923_33625 = state_30877__$1;
(statearr_30923_33625[(2)] = null);

(statearr_30923_33625[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (5))){
var state_30877__$1 = state_30877;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30925_33626 = state_30877__$1;
(statearr_30925_33626[(1)] = (8));

} else {
var statearr_30926_33627 = state_30877__$1;
(statearr_30926_33627[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (14))){
var inst_30850 = (state_30877[(8)]);
var inst_30853 = (state_30877[(11)]);
var inst_30850__$1 = (state_30877[(2)]);
var inst_30852 = (inst_30850__$1 == null);
var inst_30853__$1 = cljs.core.not(inst_30852);
var state_30877__$1 = (function (){var statearr_30930 = state_30877;
(statearr_30930[(8)] = inst_30850__$1);

(statearr_30930[(11)] = inst_30853__$1);

return statearr_30930;
})();
if(inst_30853__$1){
var statearr_30932_33628 = state_30877__$1;
(statearr_30932_33628[(1)] = (15));

} else {
var statearr_30933_33630 = state_30877__$1;
(statearr_30933_33630[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (16))){
var inst_30853 = (state_30877[(11)]);
var state_30877__$1 = state_30877;
var statearr_30935_33631 = state_30877__$1;
(statearr_30935_33631[(2)] = inst_30853);

(statearr_30935_33631[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (10))){
var inst_30843 = (state_30877[(2)]);
var state_30877__$1 = state_30877;
var statearr_30937_33634 = state_30877__$1;
(statearr_30937_33634[(2)] = inst_30843);

(statearr_30937_33634[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (18))){
var inst_30860 = (state_30877[(2)]);
var state_30877__$1 = state_30877;
var statearr_30938_33636 = state_30877__$1;
(statearr_30938_33636[(2)] = inst_30860);

(statearr_30938_33636[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30878 === (8))){
var inst_30840 = cljs.core.async.close_BANG_(to);
var state_30877__$1 = state_30877;
var statearr_30943_33637 = state_30877__$1;
(statearr_30943_33637[(2)] = inst_30840);

(statearr_30943_33637[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0 = (function (){
var statearr_30945 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30945[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__);

(statearr_30945[(1)] = (1));

return statearr_30945;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1 = (function (state_30877){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_30877);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e30946){var ex__29723__auto__ = e30946;
var statearr_30947_33638 = state_30877;
(statearr_30947_33638[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_30877[(4)]))){
var statearr_30948_33639 = state_30877;
(statearr_30948_33639[(1)] = cljs.core.first((state_30877[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33640 = state_30877;
state_30877 = G__33640;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__ = function(state_30877){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1.call(this,state_30877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29719__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_30954 = f__30017__auto__();
(statearr_30954[(6)] = c__30016__auto__);

return statearr_30954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

return c__30016__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__30965 = arguments.length;
switch (G__30965) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__30973 = arguments.length;
switch (G__30973) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__30990 = arguments.length;
switch (G__30990) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30016__auto___33650 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_31022){
var state_val_31023 = (state_31022[(1)]);
if((state_val_31023 === (7))){
var inst_31018 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
var statearr_31028_33658 = state_31022__$1;
(statearr_31028_33658[(2)] = inst_31018);

(statearr_31028_33658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (1))){
var state_31022__$1 = state_31022;
var statearr_31030_33660 = state_31022__$1;
(statearr_31030_33660[(2)] = null);

(statearr_31030_33660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (4))){
var inst_30997 = (state_31022[(7)]);
var inst_30997__$1 = (state_31022[(2)]);
var inst_30998 = (inst_30997__$1 == null);
var state_31022__$1 = (function (){var statearr_31037 = state_31022;
(statearr_31037[(7)] = inst_30997__$1);

return statearr_31037;
})();
if(cljs.core.truth_(inst_30998)){
var statearr_31040_33663 = state_31022__$1;
(statearr_31040_33663[(1)] = (5));

} else {
var statearr_31041_33664 = state_31022__$1;
(statearr_31041_33664[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (13))){
var state_31022__$1 = state_31022;
var statearr_31042_33665 = state_31022__$1;
(statearr_31042_33665[(2)] = null);

(statearr_31042_33665[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (6))){
var inst_30997 = (state_31022[(7)]);
var inst_31004 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30997) : p.call(null,inst_30997));
var state_31022__$1 = state_31022;
if(cljs.core.truth_(inst_31004)){
var statearr_31044_33666 = state_31022__$1;
(statearr_31044_33666[(1)] = (9));

} else {
var statearr_31046_33667 = state_31022__$1;
(statearr_31046_33667[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (3))){
var inst_31020 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31022__$1,inst_31020);
} else {
if((state_val_31023 === (12))){
var state_31022__$1 = state_31022;
var statearr_31050_33670 = state_31022__$1;
(statearr_31050_33670[(2)] = null);

(statearr_31050_33670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (2))){
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31022__$1,(4),ch);
} else {
if((state_val_31023 === (11))){
var inst_30997 = (state_31022[(7)]);
var inst_31008 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31022__$1,(8),inst_31008,inst_30997);
} else {
if((state_val_31023 === (9))){
var state_31022__$1 = state_31022;
var statearr_31051_33672 = state_31022__$1;
(statearr_31051_33672[(2)] = tc);

(statearr_31051_33672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (5))){
var inst_31001 = cljs.core.async.close_BANG_(tc);
var inst_31002 = cljs.core.async.close_BANG_(fc);
var state_31022__$1 = (function (){var statearr_31053 = state_31022;
(statearr_31053[(8)] = inst_31001);

return statearr_31053;
})();
var statearr_31054_33679 = state_31022__$1;
(statearr_31054_33679[(2)] = inst_31002);

(statearr_31054_33679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (14))){
var inst_31016 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
var statearr_31057_33680 = state_31022__$1;
(statearr_31057_33680[(2)] = inst_31016);

(statearr_31057_33680[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (10))){
var state_31022__$1 = state_31022;
var statearr_31060_33681 = state_31022__$1;
(statearr_31060_33681[(2)] = fc);

(statearr_31060_33681[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31023 === (8))){
var inst_31010 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
if(cljs.core.truth_(inst_31010)){
var statearr_31108_33682 = state_31022__$1;
(statearr_31108_33682[(1)] = (12));

} else {
var statearr_31109_33683 = state_31022__$1;
(statearr_31109_33683[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_31111 = [null,null,null,null,null,null,null,null,null];
(statearr_31111[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_31111[(1)] = (1));

return statearr_31111;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_31022){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_31022);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e31112){var ex__29723__auto__ = e31112;
var statearr_31113_33688 = state_31022;
(statearr_31113_33688[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_31022[(4)]))){
var statearr_31114_33690 = state_31022;
(statearr_31114_33690[(1)] = cljs.core.first((state_31022[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33691 = state_31022;
state_31022 = G__33691;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_31022){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_31022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_31116 = f__30017__auto__();
(statearr_31116[(6)] = c__30016__auto___33650);

return statearr_31116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30016__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_31151){
var state_val_31152 = (state_31151[(1)]);
if((state_val_31152 === (7))){
var inst_31145 = (state_31151[(2)]);
var state_31151__$1 = state_31151;
var statearr_31156_33701 = state_31151__$1;
(statearr_31156_33701[(2)] = inst_31145);

(statearr_31156_33701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (1))){
var inst_31126 = init;
var inst_31127 = inst_31126;
var state_31151__$1 = (function (){var statearr_31158 = state_31151;
(statearr_31158[(7)] = inst_31127);

return statearr_31158;
})();
var statearr_31160_33702 = state_31151__$1;
(statearr_31160_33702[(2)] = null);

(statearr_31160_33702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (4))){
var inst_31131 = (state_31151[(8)]);
var inst_31131__$1 = (state_31151[(2)]);
var inst_31132 = (inst_31131__$1 == null);
var state_31151__$1 = (function (){var statearr_31161 = state_31151;
(statearr_31161[(8)] = inst_31131__$1);

return statearr_31161;
})();
if(cljs.core.truth_(inst_31132)){
var statearr_31162_33703 = state_31151__$1;
(statearr_31162_33703[(1)] = (5));

} else {
var statearr_31163_33704 = state_31151__$1;
(statearr_31163_33704[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (6))){
var inst_31127 = (state_31151[(7)]);
var inst_31135 = (state_31151[(9)]);
var inst_31131 = (state_31151[(8)]);
var inst_31135__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31127,inst_31131) : f.call(null,inst_31127,inst_31131));
var inst_31137 = cljs.core.reduced_QMARK_(inst_31135__$1);
var state_31151__$1 = (function (){var statearr_31166 = state_31151;
(statearr_31166[(9)] = inst_31135__$1);

return statearr_31166;
})();
if(inst_31137){
var statearr_31169_33706 = state_31151__$1;
(statearr_31169_33706[(1)] = (8));

} else {
var statearr_31171_33707 = state_31151__$1;
(statearr_31171_33707[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (3))){
var inst_31147 = (state_31151[(2)]);
var state_31151__$1 = state_31151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31151__$1,inst_31147);
} else {
if((state_val_31152 === (2))){
var state_31151__$1 = state_31151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31151__$1,(4),ch);
} else {
if((state_val_31152 === (9))){
var inst_31135 = (state_31151[(9)]);
var inst_31127 = inst_31135;
var state_31151__$1 = (function (){var statearr_31172 = state_31151;
(statearr_31172[(7)] = inst_31127);

return statearr_31172;
})();
var statearr_31173_33710 = state_31151__$1;
(statearr_31173_33710[(2)] = null);

(statearr_31173_33710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (5))){
var inst_31127 = (state_31151[(7)]);
var state_31151__$1 = state_31151;
var statearr_31176_33712 = state_31151__$1;
(statearr_31176_33712[(2)] = inst_31127);

(statearr_31176_33712[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (10))){
var inst_31143 = (state_31151[(2)]);
var state_31151__$1 = state_31151;
var statearr_31177_33715 = state_31151__$1;
(statearr_31177_33715[(2)] = inst_31143);

(statearr_31177_33715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31152 === (8))){
var inst_31135 = (state_31151[(9)]);
var inst_31139 = cljs.core.deref(inst_31135);
var state_31151__$1 = state_31151;
var statearr_31180_33716 = state_31151__$1;
(statearr_31180_33716[(2)] = inst_31139);

(statearr_31180_33716[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__29719__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29719__auto____0 = (function (){
var statearr_31181 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31181[(0)] = cljs$core$async$reduce_$_state_machine__29719__auto__);

(statearr_31181[(1)] = (1));

return statearr_31181;
});
var cljs$core$async$reduce_$_state_machine__29719__auto____1 = (function (state_31151){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_31151);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e31182){var ex__29723__auto__ = e31182;
var statearr_31183_33718 = state_31151;
(statearr_31183_33718[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_31151[(4)]))){
var statearr_31184_33720 = state_31151;
(statearr_31184_33720[(1)] = cljs.core.first((state_31151[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33721 = state_31151;
state_31151 = G__33721;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29719__auto__ = function(state_31151){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29719__auto____1.call(this,state_31151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29719__auto____0;
cljs$core$async$reduce_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29719__auto____1;
return cljs$core$async$reduce_$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_31186 = f__30017__auto__();
(statearr_31186[(6)] = c__30016__auto__);

return statearr_31186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

return c__30016__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30016__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_31192){
var state_val_31193 = (state_31192[(1)]);
if((state_val_31193 === (1))){
var inst_31187 = cljs.core.async.reduce(f__$1,init,ch);
var state_31192__$1 = state_31192;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31192__$1,(2),inst_31187);
} else {
if((state_val_31193 === (2))){
var inst_31189 = (state_31192[(2)]);
var inst_31190 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31189) : f__$1.call(null,inst_31189));
var state_31192__$1 = state_31192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31192__$1,inst_31190);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__29719__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29719__auto____0 = (function (){
var statearr_31201 = [null,null,null,null,null,null,null];
(statearr_31201[(0)] = cljs$core$async$transduce_$_state_machine__29719__auto__);

(statearr_31201[(1)] = (1));

return statearr_31201;
});
var cljs$core$async$transduce_$_state_machine__29719__auto____1 = (function (state_31192){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_31192);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e31202){var ex__29723__auto__ = e31202;
var statearr_31203_33737 = state_31192;
(statearr_31203_33737[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_31192[(4)]))){
var statearr_31204_33739 = state_31192;
(statearr_31204_33739[(1)] = cljs.core.first((state_31192[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33741 = state_31192;
state_31192 = G__33741;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29719__auto__ = function(state_31192){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29719__auto____1.call(this,state_31192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29719__auto____0;
cljs$core$async$transduce_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29719__auto____1;
return cljs$core$async$transduce_$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_31205 = f__30017__auto__();
(statearr_31205[(6)] = c__30016__auto__);

return statearr_31205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

return c__30016__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31211 = arguments.length;
switch (G__31211) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30016__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_31241){
var state_val_31242 = (state_31241[(1)]);
if((state_val_31242 === (7))){
var inst_31222 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31243_33743 = state_31241__$1;
(statearr_31243_33743[(2)] = inst_31222);

(statearr_31243_33743[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (1))){
var inst_31215 = cljs.core.seq(coll);
var inst_31216 = inst_31215;
var state_31241__$1 = (function (){var statearr_31245 = state_31241;
(statearr_31245[(7)] = inst_31216);

return statearr_31245;
})();
var statearr_31246_33744 = state_31241__$1;
(statearr_31246_33744[(2)] = null);

(statearr_31246_33744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (4))){
var inst_31216 = (state_31241[(7)]);
var inst_31220 = cljs.core.first(inst_31216);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31241__$1,(7),ch,inst_31220);
} else {
if((state_val_31242 === (13))){
var inst_31234 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31248_33747 = state_31241__$1;
(statearr_31248_33747[(2)] = inst_31234);

(statearr_31248_33747[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (6))){
var inst_31225 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
if(cljs.core.truth_(inst_31225)){
var statearr_31250_33749 = state_31241__$1;
(statearr_31250_33749[(1)] = (8));

} else {
var statearr_31251_33750 = state_31241__$1;
(statearr_31251_33750[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (3))){
var inst_31238 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31241__$1,inst_31238);
} else {
if((state_val_31242 === (12))){
var state_31241__$1 = state_31241;
var statearr_31256_33754 = state_31241__$1;
(statearr_31256_33754[(2)] = null);

(statearr_31256_33754[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (2))){
var inst_31216 = (state_31241[(7)]);
var state_31241__$1 = state_31241;
if(cljs.core.truth_(inst_31216)){
var statearr_31258_33757 = state_31241__$1;
(statearr_31258_33757[(1)] = (4));

} else {
var statearr_31259_33758 = state_31241__$1;
(statearr_31259_33758[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (11))){
var inst_31231 = cljs.core.async.close_BANG_(ch);
var state_31241__$1 = state_31241;
var statearr_31260_33759 = state_31241__$1;
(statearr_31260_33759[(2)] = inst_31231);

(statearr_31260_33759[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (9))){
var state_31241__$1 = state_31241;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31262_33760 = state_31241__$1;
(statearr_31262_33760[(1)] = (11));

} else {
var statearr_31263_33762 = state_31241__$1;
(statearr_31263_33762[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (5))){
var inst_31216 = (state_31241[(7)]);
var state_31241__$1 = state_31241;
var statearr_31264_33763 = state_31241__$1;
(statearr_31264_33763[(2)] = inst_31216);

(statearr_31264_33763[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (10))){
var inst_31236 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31268_33767 = state_31241__$1;
(statearr_31268_33767[(2)] = inst_31236);

(statearr_31268_33767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (8))){
var inst_31216 = (state_31241[(7)]);
var inst_31227 = cljs.core.next(inst_31216);
var inst_31216__$1 = inst_31227;
var state_31241__$1 = (function (){var statearr_31269 = state_31241;
(statearr_31269[(7)] = inst_31216__$1);

return statearr_31269;
})();
var statearr_31270_33769 = state_31241__$1;
(statearr_31270_33769[(2)] = null);

(statearr_31270_33769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_31278 = [null,null,null,null,null,null,null,null];
(statearr_31278[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_31278[(1)] = (1));

return statearr_31278;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_31241){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_31241);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e31279){var ex__29723__auto__ = e31279;
var statearr_31280_33772 = state_31241;
(statearr_31280_33772[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_31241[(4)]))){
var statearr_31281_33773 = state_31241;
(statearr_31281_33773[(1)] = cljs.core.first((state_31241[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33777 = state_31241;
state_31241 = G__33777;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_31241){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_31241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_31282 = f__30017__auto__();
(statearr_31282[(6)] = c__30016__auto__);

return statearr_31282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

return c__30016__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31289 = arguments.length;
switch (G__31289) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33786 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33786(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33788 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33788(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33795 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33795(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33799 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33799(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31312 = (function (ch,cs,meta31313){
this.ch = ch;
this.cs = cs;
this.meta31313 = meta31313;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31314,meta31313__$1){
var self__ = this;
var _31314__$1 = this;
return (new cljs.core.async.t_cljs$core$async31312(self__.ch,self__.cs,meta31313__$1));
}));

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31314){
var self__ = this;
var _31314__$1 = this;
return self__.meta31313;
}));

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31312.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31312.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31313","meta31313",1791549257,null)], null);
}));

(cljs.core.async.t_cljs$core$async31312.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31312.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31312");

(cljs.core.async.t_cljs$core$async31312.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31312");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31312.
 */
cljs.core.async.__GT_t_cljs$core$async31312 = (function cljs$core$async$__GT_t_cljs$core$async31312(ch,cs,meta31313){
return (new cljs.core.async.t_cljs$core$async31312(ch,cs,meta31313));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async31312(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30016__auto___33821 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_31476){
var state_val_31477 = (state_31476[(1)]);
if((state_val_31477 === (7))){
var inst_31471 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31479_33829 = state_31476__$1;
(statearr_31479_33829[(2)] = inst_31471);

(statearr_31479_33829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (20))){
var inst_31366 = (state_31476[(7)]);
var inst_31379 = cljs.core.first(inst_31366);
var inst_31380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31379,(0),null);
var inst_31381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31379,(1),null);
var state_31476__$1 = (function (){var statearr_31482 = state_31476;
(statearr_31482[(8)] = inst_31380);

return statearr_31482;
})();
if(cljs.core.truth_(inst_31381)){
var statearr_31484_33833 = state_31476__$1;
(statearr_31484_33833[(1)] = (22));

} else {
var statearr_31485_33836 = state_31476__$1;
(statearr_31485_33836[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (27))){
var inst_31330 = (state_31476[(9)]);
var inst_31420 = (state_31476[(10)]);
var inst_31413 = (state_31476[(11)]);
var inst_31415 = (state_31476[(12)]);
var inst_31420__$1 = cljs.core._nth(inst_31413,inst_31415);
var inst_31422 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31420__$1,inst_31330,done);
var state_31476__$1 = (function (){var statearr_31487 = state_31476;
(statearr_31487[(10)] = inst_31420__$1);

return statearr_31487;
})();
if(cljs.core.truth_(inst_31422)){
var statearr_31488_33840 = state_31476__$1;
(statearr_31488_33840[(1)] = (30));

} else {
var statearr_31489_33841 = state_31476__$1;
(statearr_31489_33841[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (1))){
var state_31476__$1 = state_31476;
var statearr_31490_33843 = state_31476__$1;
(statearr_31490_33843[(2)] = null);

(statearr_31490_33843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (24))){
var inst_31366 = (state_31476[(7)]);
var inst_31386 = (state_31476[(2)]);
var inst_31388 = cljs.core.next(inst_31366);
var inst_31339 = inst_31388;
var inst_31340 = null;
var inst_31341 = (0);
var inst_31342 = (0);
var state_31476__$1 = (function (){var statearr_31491 = state_31476;
(statearr_31491[(13)] = inst_31339);

(statearr_31491[(14)] = inst_31341);

(statearr_31491[(15)] = inst_31340);

(statearr_31491[(16)] = inst_31342);

(statearr_31491[(17)] = inst_31386);

return statearr_31491;
})();
var statearr_31492_33848 = state_31476__$1;
(statearr_31492_33848[(2)] = null);

(statearr_31492_33848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (39))){
var state_31476__$1 = state_31476;
var statearr_31497_33853 = state_31476__$1;
(statearr_31497_33853[(2)] = null);

(statearr_31497_33853[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (4))){
var inst_31330 = (state_31476[(9)]);
var inst_31330__$1 = (state_31476[(2)]);
var inst_31331 = (inst_31330__$1 == null);
var state_31476__$1 = (function (){var statearr_31498 = state_31476;
(statearr_31498[(9)] = inst_31330__$1);

return statearr_31498;
})();
if(cljs.core.truth_(inst_31331)){
var statearr_31501_33858 = state_31476__$1;
(statearr_31501_33858[(1)] = (5));

} else {
var statearr_31502_33859 = state_31476__$1;
(statearr_31502_33859[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (15))){
var inst_31339 = (state_31476[(13)]);
var inst_31341 = (state_31476[(14)]);
var inst_31340 = (state_31476[(15)]);
var inst_31342 = (state_31476[(16)]);
var inst_31362 = (state_31476[(2)]);
var inst_31363 = (inst_31342 + (1));
var tmp31494 = inst_31339;
var tmp31495 = inst_31341;
var tmp31496 = inst_31340;
var inst_31339__$1 = tmp31494;
var inst_31340__$1 = tmp31496;
var inst_31341__$1 = tmp31495;
var inst_31342__$1 = inst_31363;
var state_31476__$1 = (function (){var statearr_31503 = state_31476;
(statearr_31503[(13)] = inst_31339__$1);

(statearr_31503[(14)] = inst_31341__$1);

(statearr_31503[(18)] = inst_31362);

(statearr_31503[(15)] = inst_31340__$1);

(statearr_31503[(16)] = inst_31342__$1);

return statearr_31503;
})();
var statearr_31504_33865 = state_31476__$1;
(statearr_31504_33865[(2)] = null);

(statearr_31504_33865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (21))){
var inst_31392 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31513_33872 = state_31476__$1;
(statearr_31513_33872[(2)] = inst_31392);

(statearr_31513_33872[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (31))){
var inst_31420 = (state_31476[(10)]);
var inst_31425 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31420);
var state_31476__$1 = state_31476;
var statearr_31514_33876 = state_31476__$1;
(statearr_31514_33876[(2)] = inst_31425);

(statearr_31514_33876[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (32))){
var inst_31414 = (state_31476[(19)]);
var inst_31413 = (state_31476[(11)]);
var inst_31412 = (state_31476[(20)]);
var inst_31415 = (state_31476[(12)]);
var inst_31427 = (state_31476[(2)]);
var inst_31428 = (inst_31415 + (1));
var tmp31507 = inst_31414;
var tmp31508 = inst_31413;
var tmp31509 = inst_31412;
var inst_31412__$1 = tmp31509;
var inst_31413__$1 = tmp31508;
var inst_31414__$1 = tmp31507;
var inst_31415__$1 = inst_31428;
var state_31476__$1 = (function (){var statearr_31515 = state_31476;
(statearr_31515[(19)] = inst_31414__$1);

(statearr_31515[(11)] = inst_31413__$1);

(statearr_31515[(20)] = inst_31412__$1);

(statearr_31515[(21)] = inst_31427);

(statearr_31515[(12)] = inst_31415__$1);

return statearr_31515;
})();
var statearr_31516_33878 = state_31476__$1;
(statearr_31516_33878[(2)] = null);

(statearr_31516_33878[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (40))){
var inst_31444 = (state_31476[(22)]);
var inst_31448 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31444);
var state_31476__$1 = state_31476;
var statearr_31518_33882 = state_31476__$1;
(statearr_31518_33882[(2)] = inst_31448);

(statearr_31518_33882[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (33))){
var inst_31431 = (state_31476[(23)]);
var inst_31433 = cljs.core.chunked_seq_QMARK_(inst_31431);
var state_31476__$1 = state_31476;
if(inst_31433){
var statearr_31520_33887 = state_31476__$1;
(statearr_31520_33887[(1)] = (36));

} else {
var statearr_31524_33890 = state_31476__$1;
(statearr_31524_33890[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (13))){
var inst_31356 = (state_31476[(24)]);
var inst_31359 = cljs.core.async.close_BANG_(inst_31356);
var state_31476__$1 = state_31476;
var statearr_31525_33891 = state_31476__$1;
(statearr_31525_33891[(2)] = inst_31359);

(statearr_31525_33891[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (22))){
var inst_31380 = (state_31476[(8)]);
var inst_31383 = cljs.core.async.close_BANG_(inst_31380);
var state_31476__$1 = state_31476;
var statearr_31526_33895 = state_31476__$1;
(statearr_31526_33895[(2)] = inst_31383);

(statearr_31526_33895[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (36))){
var inst_31431 = (state_31476[(23)]);
var inst_31435 = cljs.core.chunk_first(inst_31431);
var inst_31437 = cljs.core.chunk_rest(inst_31431);
var inst_31438 = cljs.core.count(inst_31435);
var inst_31412 = inst_31437;
var inst_31413 = inst_31435;
var inst_31414 = inst_31438;
var inst_31415 = (0);
var state_31476__$1 = (function (){var statearr_31530 = state_31476;
(statearr_31530[(19)] = inst_31414);

(statearr_31530[(11)] = inst_31413);

(statearr_31530[(20)] = inst_31412);

(statearr_31530[(12)] = inst_31415);

return statearr_31530;
})();
var statearr_31531_33899 = state_31476__$1;
(statearr_31531_33899[(2)] = null);

(statearr_31531_33899[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (41))){
var inst_31431 = (state_31476[(23)]);
var inst_31450 = (state_31476[(2)]);
var inst_31451 = cljs.core.next(inst_31431);
var inst_31412 = inst_31451;
var inst_31413 = null;
var inst_31414 = (0);
var inst_31415 = (0);
var state_31476__$1 = (function (){var statearr_31535 = state_31476;
(statearr_31535[(25)] = inst_31450);

(statearr_31535[(19)] = inst_31414);

(statearr_31535[(11)] = inst_31413);

(statearr_31535[(20)] = inst_31412);

(statearr_31535[(12)] = inst_31415);

return statearr_31535;
})();
var statearr_31536_33908 = state_31476__$1;
(statearr_31536_33908[(2)] = null);

(statearr_31536_33908[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (43))){
var state_31476__$1 = state_31476;
var statearr_31537_33911 = state_31476__$1;
(statearr_31537_33911[(2)] = null);

(statearr_31537_33911[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (29))){
var inst_31459 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31539_33912 = state_31476__$1;
(statearr_31539_33912[(2)] = inst_31459);

(statearr_31539_33912[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (44))){
var inst_31468 = (state_31476[(2)]);
var state_31476__$1 = (function (){var statearr_31541 = state_31476;
(statearr_31541[(26)] = inst_31468);

return statearr_31541;
})();
var statearr_31542_33915 = state_31476__$1;
(statearr_31542_33915[(2)] = null);

(statearr_31542_33915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (6))){
var inst_31403 = (state_31476[(27)]);
var inst_31402 = cljs.core.deref(cs);
var inst_31403__$1 = cljs.core.keys(inst_31402);
var inst_31404 = cljs.core.count(inst_31403__$1);
var inst_31405 = cljs.core.reset_BANG_(dctr,inst_31404);
var inst_31411 = cljs.core.seq(inst_31403__$1);
var inst_31412 = inst_31411;
var inst_31413 = null;
var inst_31414 = (0);
var inst_31415 = (0);
var state_31476__$1 = (function (){var statearr_31545 = state_31476;
(statearr_31545[(19)] = inst_31414);

(statearr_31545[(28)] = inst_31405);

(statearr_31545[(11)] = inst_31413);

(statearr_31545[(27)] = inst_31403__$1);

(statearr_31545[(20)] = inst_31412);

(statearr_31545[(12)] = inst_31415);

return statearr_31545;
})();
var statearr_31548_33921 = state_31476__$1;
(statearr_31548_33921[(2)] = null);

(statearr_31548_33921[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (28))){
var inst_31431 = (state_31476[(23)]);
var inst_31412 = (state_31476[(20)]);
var inst_31431__$1 = cljs.core.seq(inst_31412);
var state_31476__$1 = (function (){var statearr_31552 = state_31476;
(statearr_31552[(23)] = inst_31431__$1);

return statearr_31552;
})();
if(inst_31431__$1){
var statearr_31553_33927 = state_31476__$1;
(statearr_31553_33927[(1)] = (33));

} else {
var statearr_31554_33932 = state_31476__$1;
(statearr_31554_33932[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (25))){
var inst_31414 = (state_31476[(19)]);
var inst_31415 = (state_31476[(12)]);
var inst_31417 = (inst_31415 < inst_31414);
var inst_31418 = inst_31417;
var state_31476__$1 = state_31476;
if(cljs.core.truth_(inst_31418)){
var statearr_31555_33933 = state_31476__$1;
(statearr_31555_33933[(1)] = (27));

} else {
var statearr_31556_33934 = state_31476__$1;
(statearr_31556_33934[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (34))){
var state_31476__$1 = state_31476;
var statearr_31557_33935 = state_31476__$1;
(statearr_31557_33935[(2)] = null);

(statearr_31557_33935[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (17))){
var state_31476__$1 = state_31476;
var statearr_31558_33936 = state_31476__$1;
(statearr_31558_33936[(2)] = null);

(statearr_31558_33936[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (3))){
var inst_31473 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31476__$1,inst_31473);
} else {
if((state_val_31477 === (12))){
var inst_31397 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31559_33953 = state_31476__$1;
(statearr_31559_33953[(2)] = inst_31397);

(statearr_31559_33953[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (2))){
var state_31476__$1 = state_31476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31476__$1,(4),ch);
} else {
if((state_val_31477 === (23))){
var state_31476__$1 = state_31476;
var statearr_31564_33954 = state_31476__$1;
(statearr_31564_33954[(2)] = null);

(statearr_31564_33954[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (35))){
var inst_31457 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31565_33955 = state_31476__$1;
(statearr_31565_33955[(2)] = inst_31457);

(statearr_31565_33955[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (19))){
var inst_31366 = (state_31476[(7)]);
var inst_31370 = cljs.core.chunk_first(inst_31366);
var inst_31371 = cljs.core.chunk_rest(inst_31366);
var inst_31373 = cljs.core.count(inst_31370);
var inst_31339 = inst_31371;
var inst_31340 = inst_31370;
var inst_31341 = inst_31373;
var inst_31342 = (0);
var state_31476__$1 = (function (){var statearr_31567 = state_31476;
(statearr_31567[(13)] = inst_31339);

(statearr_31567[(14)] = inst_31341);

(statearr_31567[(15)] = inst_31340);

(statearr_31567[(16)] = inst_31342);

return statearr_31567;
})();
var statearr_31568_33959 = state_31476__$1;
(statearr_31568_33959[(2)] = null);

(statearr_31568_33959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (11))){
var inst_31339 = (state_31476[(13)]);
var inst_31366 = (state_31476[(7)]);
var inst_31366__$1 = cljs.core.seq(inst_31339);
var state_31476__$1 = (function (){var statearr_31569 = state_31476;
(statearr_31569[(7)] = inst_31366__$1);

return statearr_31569;
})();
if(inst_31366__$1){
var statearr_31570_33961 = state_31476__$1;
(statearr_31570_33961[(1)] = (16));

} else {
var statearr_31571_33962 = state_31476__$1;
(statearr_31571_33962[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (9))){
var inst_31399 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31574_33963 = state_31476__$1;
(statearr_31574_33963[(2)] = inst_31399);

(statearr_31574_33963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (5))){
var inst_31337 = cljs.core.deref(cs);
var inst_31338 = cljs.core.seq(inst_31337);
var inst_31339 = inst_31338;
var inst_31340 = null;
var inst_31341 = (0);
var inst_31342 = (0);
var state_31476__$1 = (function (){var statearr_31579 = state_31476;
(statearr_31579[(13)] = inst_31339);

(statearr_31579[(14)] = inst_31341);

(statearr_31579[(15)] = inst_31340);

(statearr_31579[(16)] = inst_31342);

return statearr_31579;
})();
var statearr_31581_33964 = state_31476__$1;
(statearr_31581_33964[(2)] = null);

(statearr_31581_33964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (14))){
var state_31476__$1 = state_31476;
var statearr_31582_33971 = state_31476__$1;
(statearr_31582_33971[(2)] = null);

(statearr_31582_33971[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (45))){
var inst_31465 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31583_33972 = state_31476__$1;
(statearr_31583_33972[(2)] = inst_31465);

(statearr_31583_33972[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (26))){
var inst_31403 = (state_31476[(27)]);
var inst_31461 = (state_31476[(2)]);
var inst_31462 = cljs.core.seq(inst_31403);
var state_31476__$1 = (function (){var statearr_31591 = state_31476;
(statearr_31591[(29)] = inst_31461);

return statearr_31591;
})();
if(inst_31462){
var statearr_31592_33976 = state_31476__$1;
(statearr_31592_33976[(1)] = (42));

} else {
var statearr_31593_33977 = state_31476__$1;
(statearr_31593_33977[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (16))){
var inst_31366 = (state_31476[(7)]);
var inst_31368 = cljs.core.chunked_seq_QMARK_(inst_31366);
var state_31476__$1 = state_31476;
if(inst_31368){
var statearr_31595_33979 = state_31476__$1;
(statearr_31595_33979[(1)] = (19));

} else {
var statearr_31596_33980 = state_31476__$1;
(statearr_31596_33980[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (38))){
var inst_31454 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31597_33981 = state_31476__$1;
(statearr_31597_33981[(2)] = inst_31454);

(statearr_31597_33981[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (30))){
var state_31476__$1 = state_31476;
var statearr_31598_33986 = state_31476__$1;
(statearr_31598_33986[(2)] = null);

(statearr_31598_33986[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (10))){
var inst_31340 = (state_31476[(15)]);
var inst_31342 = (state_31476[(16)]);
var inst_31355 = cljs.core._nth(inst_31340,inst_31342);
var inst_31356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31355,(0),null);
var inst_31357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31355,(1),null);
var state_31476__$1 = (function (){var statearr_31599 = state_31476;
(statearr_31599[(24)] = inst_31356);

return statearr_31599;
})();
if(cljs.core.truth_(inst_31357)){
var statearr_31600_33987 = state_31476__$1;
(statearr_31600_33987[(1)] = (13));

} else {
var statearr_31601_33988 = state_31476__$1;
(statearr_31601_33988[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (18))){
var inst_31395 = (state_31476[(2)]);
var state_31476__$1 = state_31476;
var statearr_31604_33989 = state_31476__$1;
(statearr_31604_33989[(2)] = inst_31395);

(statearr_31604_33989[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (42))){
var state_31476__$1 = state_31476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31476__$1,(45),dchan);
} else {
if((state_val_31477 === (37))){
var inst_31330 = (state_31476[(9)]);
var inst_31444 = (state_31476[(22)]);
var inst_31431 = (state_31476[(23)]);
var inst_31444__$1 = cljs.core.first(inst_31431);
var inst_31445 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31444__$1,inst_31330,done);
var state_31476__$1 = (function (){var statearr_31607 = state_31476;
(statearr_31607[(22)] = inst_31444__$1);

return statearr_31607;
})();
if(cljs.core.truth_(inst_31445)){
var statearr_31609_33996 = state_31476__$1;
(statearr_31609_33996[(1)] = (39));

} else {
var statearr_31612_33998 = state_31476__$1;
(statearr_31612_33998[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31477 === (8))){
var inst_31341 = (state_31476[(14)]);
var inst_31342 = (state_31476[(16)]);
var inst_31344 = (inst_31342 < inst_31341);
var inst_31345 = inst_31344;
var state_31476__$1 = state_31476;
if(cljs.core.truth_(inst_31345)){
var statearr_31614_34003 = state_31476__$1;
(statearr_31614_34003[(1)] = (10));

} else {
var statearr_31615_34004 = state_31476__$1;
(statearr_31615_34004[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__29719__auto__ = null;
var cljs$core$async$mult_$_state_machine__29719__auto____0 = (function (){
var statearr_31621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31621[(0)] = cljs$core$async$mult_$_state_machine__29719__auto__);

(statearr_31621[(1)] = (1));

return statearr_31621;
});
var cljs$core$async$mult_$_state_machine__29719__auto____1 = (function (state_31476){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_31476);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e31625){var ex__29723__auto__ = e31625;
var statearr_31626_34024 = state_31476;
(statearr_31626_34024[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_31476[(4)]))){
var statearr_31627_34025 = state_31476;
(statearr_31627_34025[(1)] = cljs.core.first((state_31476[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34026 = state_31476;
state_31476 = G__34026;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29719__auto__ = function(state_31476){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29719__auto____1.call(this,state_31476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29719__auto____0;
cljs$core$async$mult_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29719__auto____1;
return cljs$core$async$mult_$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_31628 = f__30017__auto__();
(statearr_31628[(6)] = c__30016__auto___33821);

return statearr_31628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31631 = arguments.length;
switch (G__31631) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_34034 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_34034(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_34037 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_34037(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_34041 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_34041(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_34049 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_34049(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_34064 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_34064(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34076 = arguments.length;
var i__5770__auto___34077 = (0);
while(true){
if((i__5770__auto___34077 < len__5769__auto___34076)){
args__5775__auto__.push((arguments[i__5770__auto___34077]));

var G__34078 = (i__5770__auto___34077 + (1));
i__5770__auto___34077 = G__34078;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31688){
var map__31689 = p__31688;
var map__31689__$1 = cljs.core.__destructure_map(map__31689);
var opts = map__31689__$1;
var statearr_31690_34086 = state;
(statearr_31690_34086[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_31692_34096 = state;
(statearr_31692_34096[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_31696_34097 = state;
(statearr_31696_34097[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31680){
var G__31681 = cljs.core.first(seq31680);
var seq31680__$1 = cljs.core.next(seq31680);
var G__31682 = cljs.core.first(seq31680__$1);
var seq31680__$2 = cljs.core.next(seq31680__$1);
var G__31683 = cljs.core.first(seq31680__$2);
var seq31680__$3 = cljs.core.next(seq31680__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31681,G__31682,G__31683,seq31680__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31719 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31720){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31720 = meta31720;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31721,meta31720__$1){
var self__ = this;
var _31721__$1 = this;
return (new cljs.core.async.t_cljs$core$async31719(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31720__$1));
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31721){
var self__ = this;
var _31721__$1 = this;
return self__.meta31720;
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31719.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31719.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31720","meta31720",-149265490,null)], null);
}));

(cljs.core.async.t_cljs$core$async31719.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31719.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31719");

(cljs.core.async.t_cljs$core$async31719.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31719");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31719.
 */
cljs.core.async.__GT_t_cljs$core$async31719 = (function cljs$core$async$__GT_t_cljs$core$async31719(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31720){
return (new cljs.core.async.t_cljs$core$async31719(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31720));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async31719(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__30016__auto___34136 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_31830){
var state_val_31831 = (state_31830[(1)]);
if((state_val_31831 === (7))){
var inst_31785 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
if(cljs.core.truth_(inst_31785)){
var statearr_31833_34137 = state_31830__$1;
(statearr_31833_34137[(1)] = (8));

} else {
var statearr_31834_34138 = state_31830__$1;
(statearr_31834_34138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (20))){
var inst_31777 = (state_31830[(7)]);
var state_31830__$1 = state_31830;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31830__$1,(23),out,inst_31777);
} else {
if((state_val_31831 === (1))){
var inst_31756 = calc_state();
var inst_31757 = cljs.core.__destructure_map(inst_31756);
var inst_31759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31757,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31757,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31757,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31762 = inst_31756;
var state_31830__$1 = (function (){var statearr_31838 = state_31830;
(statearr_31838[(8)] = inst_31761);

(statearr_31838[(9)] = inst_31760);

(statearr_31838[(10)] = inst_31759);

(statearr_31838[(11)] = inst_31762);

return statearr_31838;
})();
var statearr_31840_34139 = state_31830__$1;
(statearr_31840_34139[(2)] = null);

(statearr_31840_34139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (24))){
var inst_31765 = (state_31830[(12)]);
var inst_31762 = inst_31765;
var state_31830__$1 = (function (){var statearr_31844 = state_31830;
(statearr_31844[(11)] = inst_31762);

return statearr_31844;
})();
var statearr_31846_34140 = state_31830__$1;
(statearr_31846_34140[(2)] = null);

(statearr_31846_34140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (4))){
var inst_31777 = (state_31830[(7)]);
var inst_31780 = (state_31830[(13)]);
var inst_31775 = (state_31830[(2)]);
var inst_31777__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31775,(0),null);
var inst_31778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31775,(1),null);
var inst_31780__$1 = (inst_31777__$1 == null);
var state_31830__$1 = (function (){var statearr_31854 = state_31830;
(statearr_31854[(14)] = inst_31778);

(statearr_31854[(7)] = inst_31777__$1);

(statearr_31854[(13)] = inst_31780__$1);

return statearr_31854;
})();
if(cljs.core.truth_(inst_31780__$1)){
var statearr_31856_34141 = state_31830__$1;
(statearr_31856_34141[(1)] = (5));

} else {
var statearr_31857_34142 = state_31830__$1;
(statearr_31857_34142[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (15))){
var inst_31800 = (state_31830[(15)]);
var inst_31766 = (state_31830[(16)]);
var inst_31800__$1 = cljs.core.empty_QMARK_(inst_31766);
var state_31830__$1 = (function (){var statearr_31861 = state_31830;
(statearr_31861[(15)] = inst_31800__$1);

return statearr_31861;
})();
if(inst_31800__$1){
var statearr_31863_34146 = state_31830__$1;
(statearr_31863_34146[(1)] = (17));

} else {
var statearr_31864_34148 = state_31830__$1;
(statearr_31864_34148[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (21))){
var inst_31765 = (state_31830[(12)]);
var inst_31762 = inst_31765;
var state_31830__$1 = (function (){var statearr_31866 = state_31830;
(statearr_31866[(11)] = inst_31762);

return statearr_31866;
})();
var statearr_31867_34152 = state_31830__$1;
(statearr_31867_34152[(2)] = null);

(statearr_31867_34152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (13))){
var inst_31792 = (state_31830[(2)]);
var inst_31793 = calc_state();
var inst_31762 = inst_31793;
var state_31830__$1 = (function (){var statearr_31870 = state_31830;
(statearr_31870[(17)] = inst_31792);

(statearr_31870[(11)] = inst_31762);

return statearr_31870;
})();
var statearr_31872_34162 = state_31830__$1;
(statearr_31872_34162[(2)] = null);

(statearr_31872_34162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (22))){
var inst_31821 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
var statearr_31875_34163 = state_31830__$1;
(statearr_31875_34163[(2)] = inst_31821);

(statearr_31875_34163[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (6))){
var inst_31778 = (state_31830[(14)]);
var inst_31783 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31778,change);
var state_31830__$1 = state_31830;
var statearr_31878_34164 = state_31830__$1;
(statearr_31878_34164[(2)] = inst_31783);

(statearr_31878_34164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (25))){
var state_31830__$1 = state_31830;
var statearr_31881_34165 = state_31830__$1;
(statearr_31881_34165[(2)] = null);

(statearr_31881_34165[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (17))){
var inst_31778 = (state_31830[(14)]);
var inst_31767 = (state_31830[(18)]);
var inst_31803 = (inst_31767.cljs$core$IFn$_invoke$arity$1 ? inst_31767.cljs$core$IFn$_invoke$arity$1(inst_31778) : inst_31767.call(null,inst_31778));
var inst_31804 = cljs.core.not(inst_31803);
var state_31830__$1 = state_31830;
var statearr_31883_34166 = state_31830__$1;
(statearr_31883_34166[(2)] = inst_31804);

(statearr_31883_34166[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (3))){
var inst_31825 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31830__$1,inst_31825);
} else {
if((state_val_31831 === (12))){
var state_31830__$1 = state_31830;
var statearr_31886_34167 = state_31830__$1;
(statearr_31886_34167[(2)] = null);

(statearr_31886_34167[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (2))){
var inst_31762 = (state_31830[(11)]);
var inst_31765 = (state_31830[(12)]);
var inst_31765__$1 = cljs.core.__destructure_map(inst_31762);
var inst_31766 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31765__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31767 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31765__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31768 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31765__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31830__$1 = (function (){var statearr_31893 = state_31830;
(statearr_31893[(16)] = inst_31766);

(statearr_31893[(18)] = inst_31767);

(statearr_31893[(12)] = inst_31765__$1);

return statearr_31893;
})();
return cljs.core.async.ioc_alts_BANG_(state_31830__$1,(4),inst_31768);
} else {
if((state_val_31831 === (23))){
var inst_31812 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
if(cljs.core.truth_(inst_31812)){
var statearr_31896_34168 = state_31830__$1;
(statearr_31896_34168[(1)] = (24));

} else {
var statearr_31897_34169 = state_31830__$1;
(statearr_31897_34169[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (19))){
var inst_31807 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
var statearr_31900_34170 = state_31830__$1;
(statearr_31900_34170[(2)] = inst_31807);

(statearr_31900_34170[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (11))){
var inst_31778 = (state_31830[(14)]);
var inst_31789 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31778);
var state_31830__$1 = state_31830;
var statearr_31902_34171 = state_31830__$1;
(statearr_31902_34171[(2)] = inst_31789);

(statearr_31902_34171[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (9))){
var inst_31778 = (state_31830[(14)]);
var inst_31766 = (state_31830[(16)]);
var inst_31796 = (state_31830[(19)]);
var inst_31796__$1 = (inst_31766.cljs$core$IFn$_invoke$arity$1 ? inst_31766.cljs$core$IFn$_invoke$arity$1(inst_31778) : inst_31766.call(null,inst_31778));
var state_31830__$1 = (function (){var statearr_31904 = state_31830;
(statearr_31904[(19)] = inst_31796__$1);

return statearr_31904;
})();
if(cljs.core.truth_(inst_31796__$1)){
var statearr_31905_34172 = state_31830__$1;
(statearr_31905_34172[(1)] = (14));

} else {
var statearr_31906_34173 = state_31830__$1;
(statearr_31906_34173[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (5))){
var inst_31780 = (state_31830[(13)]);
var state_31830__$1 = state_31830;
var statearr_31910_34174 = state_31830__$1;
(statearr_31910_34174[(2)] = inst_31780);

(statearr_31910_34174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (14))){
var inst_31796 = (state_31830[(19)]);
var state_31830__$1 = state_31830;
var statearr_31911_34178 = state_31830__$1;
(statearr_31911_34178[(2)] = inst_31796);

(statearr_31911_34178[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (26))){
var inst_31817 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
var statearr_31913_34179 = state_31830__$1;
(statearr_31913_34179[(2)] = inst_31817);

(statearr_31913_34179[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (16))){
var inst_31809 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
if(cljs.core.truth_(inst_31809)){
var statearr_31915_34180 = state_31830__$1;
(statearr_31915_34180[(1)] = (20));

} else {
var statearr_31922_34181 = state_31830__$1;
(statearr_31922_34181[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (10))){
var inst_31823 = (state_31830[(2)]);
var state_31830__$1 = state_31830;
var statearr_31925_34188 = state_31830__$1;
(statearr_31925_34188[(2)] = inst_31823);

(statearr_31925_34188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (18))){
var inst_31800 = (state_31830[(15)]);
var state_31830__$1 = state_31830;
var statearr_31927_34189 = state_31830__$1;
(statearr_31927_34189[(2)] = inst_31800);

(statearr_31927_34189[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31831 === (8))){
var inst_31777 = (state_31830[(7)]);
var inst_31787 = (inst_31777 == null);
var state_31830__$1 = state_31830;
if(cljs.core.truth_(inst_31787)){
var statearr_31929_34190 = state_31830__$1;
(statearr_31929_34190[(1)] = (11));

} else {
var statearr_31930_34191 = state_31830__$1;
(statearr_31930_34191[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__29719__auto__ = null;
var cljs$core$async$mix_$_state_machine__29719__auto____0 = (function (){
var statearr_31934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31934[(0)] = cljs$core$async$mix_$_state_machine__29719__auto__);

(statearr_31934[(1)] = (1));

return statearr_31934;
});
var cljs$core$async$mix_$_state_machine__29719__auto____1 = (function (state_31830){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_31830);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e31936){var ex__29723__auto__ = e31936;
var statearr_31937_34195 = state_31830;
(statearr_31937_34195[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_31830[(4)]))){
var statearr_31938_34196 = state_31830;
(statearr_31938_34196[(1)] = cljs.core.first((state_31830[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34197 = state_31830;
state_31830 = G__34197;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29719__auto__ = function(state_31830){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29719__auto____1.call(this,state_31830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29719__auto____0;
cljs$core$async$mix_$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29719__auto____1;
return cljs$core$async$mix_$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_31946 = f__30017__auto__();
(statearr_31946[(6)] = c__30016__auto___34136);

return statearr_31946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_34198 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_34198(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_34202 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_34202(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_34203 = (function() {
var G__34204 = null;
var G__34204__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__34204__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__34204 = function(p,v){
switch(arguments.length){
case 1:
return G__34204__1.call(this,p);
case 2:
return G__34204__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34204.cljs$core$IFn$_invoke$arity$1 = G__34204__1;
G__34204.cljs$core$IFn$_invoke$arity$2 = G__34204__2;
return G__34204;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31969 = arguments.length;
switch (G__31969) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34203(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34203(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31975 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31976){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31976 = meta31976;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31977,meta31976__$1){
var self__ = this;
var _31977__$1 = this;
return (new cljs.core.async.t_cljs$core$async31975(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31976__$1));
}));

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31977){
var self__ = this;
var _31977__$1 = this;
return self__.meta31976;
}));

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async31975.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async31975.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31976","meta31976",-1990353333,null)], null);
}));

(cljs.core.async.t_cljs$core$async31975.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31975.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31975");

(cljs.core.async.t_cljs$core$async31975.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31975");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31975.
 */
cljs.core.async.__GT_t_cljs$core$async31975 = (function cljs$core$async$__GT_t_cljs$core$async31975(ch,topic_fn,buf_fn,mults,ensure_mult,meta31976){
return (new cljs.core.async.t_cljs$core$async31975(ch,topic_fn,buf_fn,mults,ensure_mult,meta31976));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31973 = arguments.length;
switch (G__31973) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__31971_SHARP_){
if(cljs.core.truth_((p1__31971_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31971_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31971_SHARP_.call(null,topic)))){
return p1__31971_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31971_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async31975(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__30016__auto___34216 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32082){
var state_val_32084 = (state_32082[(1)]);
if((state_val_32084 === (7))){
var inst_32077 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
var statearr_32090_34217 = state_32082__$1;
(statearr_32090_34217[(2)] = inst_32077);

(statearr_32090_34217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (20))){
var state_32082__$1 = state_32082;
var statearr_32092_34218 = state_32082__$1;
(statearr_32092_34218[(2)] = null);

(statearr_32092_34218[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (1))){
var state_32082__$1 = state_32082;
var statearr_32100_34222 = state_32082__$1;
(statearr_32100_34222[(2)] = null);

(statearr_32100_34222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (24))){
var inst_32057 = (state_32082[(7)]);
var inst_32069 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32057);
var state_32082__$1 = state_32082;
var statearr_32102_34223 = state_32082__$1;
(statearr_32102_34223[(2)] = inst_32069);

(statearr_32102_34223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (4))){
var inst_31997 = (state_32082[(8)]);
var inst_31997__$1 = (state_32082[(2)]);
var inst_31999 = (inst_31997__$1 == null);
var state_32082__$1 = (function (){var statearr_32103 = state_32082;
(statearr_32103[(8)] = inst_31997__$1);

return statearr_32103;
})();
if(cljs.core.truth_(inst_31999)){
var statearr_32104_34227 = state_32082__$1;
(statearr_32104_34227[(1)] = (5));

} else {
var statearr_32105_34228 = state_32082__$1;
(statearr_32105_34228[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (15))){
var inst_32051 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
var statearr_32107_34229 = state_32082__$1;
(statearr_32107_34229[(2)] = inst_32051);

(statearr_32107_34229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (21))){
var inst_32074 = (state_32082[(2)]);
var state_32082__$1 = (function (){var statearr_32110 = state_32082;
(statearr_32110[(9)] = inst_32074);

return statearr_32110;
})();
var statearr_32115_34230 = state_32082__$1;
(statearr_32115_34230[(2)] = null);

(statearr_32115_34230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (13))){
var inst_32027 = (state_32082[(10)]);
var inst_32033 = cljs.core.chunked_seq_QMARK_(inst_32027);
var state_32082__$1 = state_32082;
if(inst_32033){
var statearr_32119_34232 = state_32082__$1;
(statearr_32119_34232[(1)] = (16));

} else {
var statearr_32122_34233 = state_32082__$1;
(statearr_32122_34233[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (22))){
var inst_32066 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
if(cljs.core.truth_(inst_32066)){
var statearr_32123_34235 = state_32082__$1;
(statearr_32123_34235[(1)] = (23));

} else {
var statearr_32124_34236 = state_32082__$1;
(statearr_32124_34236[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (6))){
var inst_31997 = (state_32082[(8)]);
var inst_32057 = (state_32082[(7)]);
var inst_32059 = (state_32082[(11)]);
var inst_32057__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31997) : topic_fn.call(null,inst_31997));
var inst_32058 = cljs.core.deref(mults);
var inst_32059__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32058,inst_32057__$1);
var state_32082__$1 = (function (){var statearr_32132 = state_32082;
(statearr_32132[(7)] = inst_32057__$1);

(statearr_32132[(11)] = inst_32059__$1);

return statearr_32132;
})();
if(cljs.core.truth_(inst_32059__$1)){
var statearr_32133_34243 = state_32082__$1;
(statearr_32133_34243[(1)] = (19));

} else {
var statearr_32134_34244 = state_32082__$1;
(statearr_32134_34244[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (25))){
var inst_32071 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
var statearr_32139_34245 = state_32082__$1;
(statearr_32139_34245[(2)] = inst_32071);

(statearr_32139_34245[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (17))){
var inst_32027 = (state_32082[(10)]);
var inst_32042 = cljs.core.first(inst_32027);
var inst_32043 = cljs.core.async.muxch_STAR_(inst_32042);
var inst_32044 = cljs.core.async.close_BANG_(inst_32043);
var inst_32045 = cljs.core.next(inst_32027);
var inst_32009 = inst_32045;
var inst_32010 = null;
var inst_32011 = (0);
var inst_32013 = (0);
var state_32082__$1 = (function (){var statearr_32143 = state_32082;
(statearr_32143[(12)] = inst_32009);

(statearr_32143[(13)] = inst_32011);

(statearr_32143[(14)] = inst_32044);

(statearr_32143[(15)] = inst_32013);

(statearr_32143[(16)] = inst_32010);

return statearr_32143;
})();
var statearr_32146_34248 = state_32082__$1;
(statearr_32146_34248[(2)] = null);

(statearr_32146_34248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (3))){
var inst_32079 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32082__$1,inst_32079);
} else {
if((state_val_32084 === (12))){
var inst_32053 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
var statearr_32152_34249 = state_32082__$1;
(statearr_32152_34249[(2)] = inst_32053);

(statearr_32152_34249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (2))){
var state_32082__$1 = state_32082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32082__$1,(4),ch);
} else {
if((state_val_32084 === (23))){
var state_32082__$1 = state_32082;
var statearr_32156_34251 = state_32082__$1;
(statearr_32156_34251[(2)] = null);

(statearr_32156_34251[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (19))){
var inst_31997 = (state_32082[(8)]);
var inst_32059 = (state_32082[(11)]);
var inst_32064 = cljs.core.async.muxch_STAR_(inst_32059);
var state_32082__$1 = state_32082;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32082__$1,(22),inst_32064,inst_31997);
} else {
if((state_val_32084 === (11))){
var inst_32009 = (state_32082[(12)]);
var inst_32027 = (state_32082[(10)]);
var inst_32027__$1 = cljs.core.seq(inst_32009);
var state_32082__$1 = (function (){var statearr_32159 = state_32082;
(statearr_32159[(10)] = inst_32027__$1);

return statearr_32159;
})();
if(inst_32027__$1){
var statearr_32160_34252 = state_32082__$1;
(statearr_32160_34252[(1)] = (13));

} else {
var statearr_32161_34253 = state_32082__$1;
(statearr_32161_34253[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (9))){
var inst_32055 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
var statearr_32162_34256 = state_32082__$1;
(statearr_32162_34256[(2)] = inst_32055);

(statearr_32162_34256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (5))){
var inst_32006 = cljs.core.deref(mults);
var inst_32007 = cljs.core.vals(inst_32006);
var inst_32008 = cljs.core.seq(inst_32007);
var inst_32009 = inst_32008;
var inst_32010 = null;
var inst_32011 = (0);
var inst_32013 = (0);
var state_32082__$1 = (function (){var statearr_32169 = state_32082;
(statearr_32169[(12)] = inst_32009);

(statearr_32169[(13)] = inst_32011);

(statearr_32169[(15)] = inst_32013);

(statearr_32169[(16)] = inst_32010);

return statearr_32169;
})();
var statearr_32174_34257 = state_32082__$1;
(statearr_32174_34257[(2)] = null);

(statearr_32174_34257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (14))){
var state_32082__$1 = state_32082;
var statearr_32180_34258 = state_32082__$1;
(statearr_32180_34258[(2)] = null);

(statearr_32180_34258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (16))){
var inst_32027 = (state_32082[(10)]);
var inst_32037 = cljs.core.chunk_first(inst_32027);
var inst_32038 = cljs.core.chunk_rest(inst_32027);
var inst_32039 = cljs.core.count(inst_32037);
var inst_32009 = inst_32038;
var inst_32010 = inst_32037;
var inst_32011 = inst_32039;
var inst_32013 = (0);
var state_32082__$1 = (function (){var statearr_32187 = state_32082;
(statearr_32187[(12)] = inst_32009);

(statearr_32187[(13)] = inst_32011);

(statearr_32187[(15)] = inst_32013);

(statearr_32187[(16)] = inst_32010);

return statearr_32187;
})();
var statearr_32190_34259 = state_32082__$1;
(statearr_32190_34259[(2)] = null);

(statearr_32190_34259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (10))){
var inst_32009 = (state_32082[(12)]);
var inst_32011 = (state_32082[(13)]);
var inst_32013 = (state_32082[(15)]);
var inst_32010 = (state_32082[(16)]);
var inst_32019 = cljs.core._nth(inst_32010,inst_32013);
var inst_32020 = cljs.core.async.muxch_STAR_(inst_32019);
var inst_32021 = cljs.core.async.close_BANG_(inst_32020);
var inst_32022 = (inst_32013 + (1));
var tmp32176 = inst_32009;
var tmp32177 = inst_32011;
var tmp32178 = inst_32010;
var inst_32009__$1 = tmp32176;
var inst_32010__$1 = tmp32178;
var inst_32011__$1 = tmp32177;
var inst_32013__$1 = inst_32022;
var state_32082__$1 = (function (){var statearr_32202 = state_32082;
(statearr_32202[(12)] = inst_32009__$1);

(statearr_32202[(13)] = inst_32011__$1);

(statearr_32202[(17)] = inst_32021);

(statearr_32202[(15)] = inst_32013__$1);

(statearr_32202[(16)] = inst_32010__$1);

return statearr_32202;
})();
var statearr_32205_34264 = state_32082__$1;
(statearr_32205_34264[(2)] = null);

(statearr_32205_34264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (18))){
var inst_32048 = (state_32082[(2)]);
var state_32082__$1 = state_32082;
var statearr_32210_34266 = state_32082__$1;
(statearr_32210_34266[(2)] = inst_32048);

(statearr_32210_34266[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32084 === (8))){
var inst_32011 = (state_32082[(13)]);
var inst_32013 = (state_32082[(15)]);
var inst_32016 = (inst_32013 < inst_32011);
var inst_32017 = inst_32016;
var state_32082__$1 = state_32082;
if(cljs.core.truth_(inst_32017)){
var statearr_32218_34267 = state_32082__$1;
(statearr_32218_34267[(1)] = (10));

} else {
var statearr_32220_34268 = state_32082__$1;
(statearr_32220_34268[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_32224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32224[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_32224[(1)] = (1));

return statearr_32224;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_32082){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32082);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e32226){var ex__29723__auto__ = e32226;
var statearr_32227_34271 = state_32082;
(statearr_32227_34271[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32082[(4)]))){
var statearr_32228_34272 = state_32082;
(statearr_32228_34272[(1)] = cljs.core.first((state_32082[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34273 = state_32082;
state_32082 = G__34273;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_32082){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_32082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_32229 = f__30017__auto__();
(statearr_32229[(6)] = c__30016__auto___34216);

return statearr_32229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32233 = arguments.length;
switch (G__32233) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32246 = arguments.length;
switch (G__32246) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32251 = arguments.length;
switch (G__32251) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30016__auto___34288 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32308){
var state_val_32309 = (state_32308[(1)]);
if((state_val_32309 === (7))){
var state_32308__$1 = state_32308;
var statearr_32311_34290 = state_32308__$1;
(statearr_32311_34290[(2)] = null);

(statearr_32311_34290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (1))){
var state_32308__$1 = state_32308;
var statearr_32313_34293 = state_32308__$1;
(statearr_32313_34293[(2)] = null);

(statearr_32313_34293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (4))){
var inst_32260 = (state_32308[(7)]);
var inst_32261 = (state_32308[(8)]);
var inst_32263 = (inst_32261 < inst_32260);
var state_32308__$1 = state_32308;
if(cljs.core.truth_(inst_32263)){
var statearr_32317_34294 = state_32308__$1;
(statearr_32317_34294[(1)] = (6));

} else {
var statearr_32318_34295 = state_32308__$1;
(statearr_32318_34295[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (15))){
var inst_32290 = (state_32308[(9)]);
var inst_32295 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32290);
var state_32308__$1 = state_32308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32308__$1,(17),out,inst_32295);
} else {
if((state_val_32309 === (13))){
var inst_32290 = (state_32308[(9)]);
var inst_32290__$1 = (state_32308[(2)]);
var inst_32291 = cljs.core.some(cljs.core.nil_QMARK_,inst_32290__$1);
var state_32308__$1 = (function (){var statearr_32321 = state_32308;
(statearr_32321[(9)] = inst_32290__$1);

return statearr_32321;
})();
if(cljs.core.truth_(inst_32291)){
var statearr_32322_34296 = state_32308__$1;
(statearr_32322_34296[(1)] = (14));

} else {
var statearr_32324_34297 = state_32308__$1;
(statearr_32324_34297[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (6))){
var state_32308__$1 = state_32308;
var statearr_32326_34298 = state_32308__$1;
(statearr_32326_34298[(2)] = null);

(statearr_32326_34298[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (17))){
var inst_32297 = (state_32308[(2)]);
var state_32308__$1 = (function (){var statearr_32329 = state_32308;
(statearr_32329[(10)] = inst_32297);

return statearr_32329;
})();
var statearr_32330_34306 = state_32308__$1;
(statearr_32330_34306[(2)] = null);

(statearr_32330_34306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (3))){
var inst_32302 = (state_32308[(2)]);
var state_32308__$1 = state_32308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32308__$1,inst_32302);
} else {
if((state_val_32309 === (12))){
var _ = (function (){var statearr_32332 = state_32308;
(statearr_32332[(4)] = cljs.core.rest((state_32308[(4)])));

return statearr_32332;
})();
var state_32308__$1 = state_32308;
var ex32328 = (state_32308__$1[(2)]);
var statearr_32333_34309 = state_32308__$1;
(statearr_32333_34309[(5)] = ex32328);


if((ex32328 instanceof Object)){
var statearr_32334_34311 = state_32308__$1;
(statearr_32334_34311[(1)] = (11));

(statearr_32334_34311[(5)] = null);

} else {
throw ex32328;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (2))){
var inst_32259 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32260 = cnt;
var inst_32261 = (0);
var state_32308__$1 = (function (){var statearr_32335 = state_32308;
(statearr_32335[(7)] = inst_32260);

(statearr_32335[(11)] = inst_32259);

(statearr_32335[(8)] = inst_32261);

return statearr_32335;
})();
var statearr_32336_34312 = state_32308__$1;
(statearr_32336_34312[(2)] = null);

(statearr_32336_34312[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (11))){
var inst_32269 = (state_32308[(2)]);
var inst_32270 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32308__$1 = (function (){var statearr_32337 = state_32308;
(statearr_32337[(12)] = inst_32269);

return statearr_32337;
})();
var statearr_32338_34315 = state_32308__$1;
(statearr_32338_34315[(2)] = inst_32270);

(statearr_32338_34315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (9))){
var inst_32261 = (state_32308[(8)]);
var _ = (function (){var statearr_32347 = state_32308;
(statearr_32347[(4)] = cljs.core.cons((12),(state_32308[(4)])));

return statearr_32347;
})();
var inst_32276 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32261) : chs__$1.call(null,inst_32261));
var inst_32277 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32261) : done.call(null,inst_32261));
var inst_32278 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32276,inst_32277);
var ___$1 = (function (){var statearr_32348 = state_32308;
(statearr_32348[(4)] = cljs.core.rest((state_32308[(4)])));

return statearr_32348;
})();
var state_32308__$1 = state_32308;
var statearr_32353_34320 = state_32308__$1;
(statearr_32353_34320[(2)] = inst_32278);

(statearr_32353_34320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (5))){
var inst_32288 = (state_32308[(2)]);
var state_32308__$1 = (function (){var statearr_32354 = state_32308;
(statearr_32354[(13)] = inst_32288);

return statearr_32354;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32308__$1,(13),dchan);
} else {
if((state_val_32309 === (14))){
var inst_32293 = cljs.core.async.close_BANG_(out);
var state_32308__$1 = state_32308;
var statearr_32355_34321 = state_32308__$1;
(statearr_32355_34321[(2)] = inst_32293);

(statearr_32355_34321[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (16))){
var inst_32300 = (state_32308[(2)]);
var state_32308__$1 = state_32308;
var statearr_32360_34322 = state_32308__$1;
(statearr_32360_34322[(2)] = inst_32300);

(statearr_32360_34322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (10))){
var inst_32261 = (state_32308[(8)]);
var inst_32281 = (state_32308[(2)]);
var inst_32282 = (inst_32261 + (1));
var inst_32261__$1 = inst_32282;
var state_32308__$1 = (function (){var statearr_32361 = state_32308;
(statearr_32361[(14)] = inst_32281);

(statearr_32361[(8)] = inst_32261__$1);

return statearr_32361;
})();
var statearr_32362_34325 = state_32308__$1;
(statearr_32362_34325[(2)] = null);

(statearr_32362_34325[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32309 === (8))){
var inst_32286 = (state_32308[(2)]);
var state_32308__$1 = state_32308;
var statearr_32363_34326 = state_32308__$1;
(statearr_32363_34326[(2)] = inst_32286);

(statearr_32363_34326[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_32365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32365[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_32365[(1)] = (1));

return statearr_32365;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_32308){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32308);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e32366){var ex__29723__auto__ = e32366;
var statearr_32367_34337 = state_32308;
(statearr_32367_34337[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32308[(4)]))){
var statearr_32392_34338 = state_32308;
(statearr_32392_34338[(1)] = cljs.core.first((state_32308[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34339 = state_32308;
state_32308 = G__34339;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_32308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_32308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_32395 = f__30017__auto__();
(statearr_32395[(6)] = c__30016__auto___34288);

return statearr_32395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32400 = arguments.length;
switch (G__32400) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30016__auto___34366 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32471){
var state_val_32472 = (state_32471[(1)]);
if((state_val_32472 === (7))){
var inst_32443 = (state_32471[(7)]);
var inst_32445 = (state_32471[(8)]);
var inst_32443__$1 = (state_32471[(2)]);
var inst_32445__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32443__$1,(0),null);
var inst_32446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32443__$1,(1),null);
var inst_32447 = (inst_32445__$1 == null);
var state_32471__$1 = (function (){var statearr_32478 = state_32471;
(statearr_32478[(9)] = inst_32446);

(statearr_32478[(7)] = inst_32443__$1);

(statearr_32478[(8)] = inst_32445__$1);

return statearr_32478;
})();
if(cljs.core.truth_(inst_32447)){
var statearr_32480_34383 = state_32471__$1;
(statearr_32480_34383[(1)] = (8));

} else {
var statearr_32481_34384 = state_32471__$1;
(statearr_32481_34384[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (1))){
var inst_32428 = cljs.core.vec(chs);
var inst_32429 = inst_32428;
var state_32471__$1 = (function (){var statearr_32482 = state_32471;
(statearr_32482[(10)] = inst_32429);

return statearr_32482;
})();
var statearr_32483_34388 = state_32471__$1;
(statearr_32483_34388[(2)] = null);

(statearr_32483_34388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (4))){
var inst_32429 = (state_32471[(10)]);
var state_32471__$1 = state_32471;
return cljs.core.async.ioc_alts_BANG_(state_32471__$1,(7),inst_32429);
} else {
if((state_val_32472 === (6))){
var inst_32467 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
var statearr_32486_34390 = state_32471__$1;
(statearr_32486_34390[(2)] = inst_32467);

(statearr_32486_34390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (3))){
var inst_32469 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32471__$1,inst_32469);
} else {
if((state_val_32472 === (2))){
var inst_32429 = (state_32471[(10)]);
var inst_32432 = cljs.core.count(inst_32429);
var inst_32433 = (inst_32432 > (0));
var state_32471__$1 = state_32471;
if(cljs.core.truth_(inst_32433)){
var statearr_32491_34401 = state_32471__$1;
(statearr_32491_34401[(1)] = (4));

} else {
var statearr_32494_34402 = state_32471__$1;
(statearr_32494_34402[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (11))){
var inst_32429 = (state_32471[(10)]);
var inst_32460 = (state_32471[(2)]);
var tmp32487 = inst_32429;
var inst_32429__$1 = tmp32487;
var state_32471__$1 = (function (){var statearr_32496 = state_32471;
(statearr_32496[(11)] = inst_32460);

(statearr_32496[(10)] = inst_32429__$1);

return statearr_32496;
})();
var statearr_32497_34406 = state_32471__$1;
(statearr_32497_34406[(2)] = null);

(statearr_32497_34406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (9))){
var inst_32445 = (state_32471[(8)]);
var state_32471__$1 = state_32471;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32471__$1,(11),out,inst_32445);
} else {
if((state_val_32472 === (5))){
var inst_32465 = cljs.core.async.close_BANG_(out);
var state_32471__$1 = state_32471;
var statearr_32500_34413 = state_32471__$1;
(statearr_32500_34413[(2)] = inst_32465);

(statearr_32500_34413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (10))){
var inst_32463 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
var statearr_32502_34415 = state_32471__$1;
(statearr_32502_34415[(2)] = inst_32463);

(statearr_32502_34415[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32472 === (8))){
var inst_32446 = (state_32471[(9)]);
var inst_32443 = (state_32471[(7)]);
var inst_32445 = (state_32471[(8)]);
var inst_32429 = (state_32471[(10)]);
var inst_32453 = (function (){var cs = inst_32429;
var vec__32439 = inst_32443;
var v = inst_32445;
var c = inst_32446;
return (function (p1__32398_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32398_SHARP_);
});
})();
var inst_32454 = cljs.core.filterv(inst_32453,inst_32429);
var inst_32429__$1 = inst_32454;
var state_32471__$1 = (function (){var statearr_32505 = state_32471;
(statearr_32505[(10)] = inst_32429__$1);

return statearr_32505;
})();
var statearr_32506_34416 = state_32471__$1;
(statearr_32506_34416[(2)] = null);

(statearr_32506_34416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_32508 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32508[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_32508[(1)] = (1));

return statearr_32508;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_32471){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32471);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e32512){var ex__29723__auto__ = e32512;
var statearr_32513_34426 = state_32471;
(statearr_32513_34426[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32471[(4)]))){
var statearr_32514_34430 = state_32471;
(statearr_32514_34430[(1)] = cljs.core.first((state_32471[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34436 = state_32471;
state_32471 = G__34436;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_32471){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_32471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_32516 = f__30017__auto__();
(statearr_32516[(6)] = c__30016__auto___34366);

return statearr_32516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32523 = arguments.length;
switch (G__32523) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30016__auto___34455 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32552){
var state_val_32553 = (state_32552[(1)]);
if((state_val_32553 === (7))){
var inst_32534 = (state_32552[(7)]);
var inst_32534__$1 = (state_32552[(2)]);
var inst_32535 = (inst_32534__$1 == null);
var inst_32536 = cljs.core.not(inst_32535);
var state_32552__$1 = (function (){var statearr_32562 = state_32552;
(statearr_32562[(7)] = inst_32534__$1);

return statearr_32562;
})();
if(inst_32536){
var statearr_32563_34463 = state_32552__$1;
(statearr_32563_34463[(1)] = (8));

} else {
var statearr_32564_34465 = state_32552__$1;
(statearr_32564_34465[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (1))){
var inst_32529 = (0);
var state_32552__$1 = (function (){var statearr_32565 = state_32552;
(statearr_32565[(8)] = inst_32529);

return statearr_32565;
})();
var statearr_32566_34471 = state_32552__$1;
(statearr_32566_34471[(2)] = null);

(statearr_32566_34471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (4))){
var state_32552__$1 = state_32552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32552__$1,(7),ch);
} else {
if((state_val_32553 === (6))){
var inst_32547 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32567_34476 = state_32552__$1;
(statearr_32567_34476[(2)] = inst_32547);

(statearr_32567_34476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (3))){
var inst_32549 = (state_32552[(2)]);
var inst_32550 = cljs.core.async.close_BANG_(out);
var state_32552__$1 = (function (){var statearr_32569 = state_32552;
(statearr_32569[(9)] = inst_32549);

return statearr_32569;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32552__$1,inst_32550);
} else {
if((state_val_32553 === (2))){
var inst_32529 = (state_32552[(8)]);
var inst_32531 = (inst_32529 < n);
var state_32552__$1 = state_32552;
if(cljs.core.truth_(inst_32531)){
var statearr_32583_34478 = state_32552__$1;
(statearr_32583_34478[(1)] = (4));

} else {
var statearr_32584_34479 = state_32552__$1;
(statearr_32584_34479[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (11))){
var inst_32529 = (state_32552[(8)]);
var inst_32539 = (state_32552[(2)]);
var inst_32540 = (inst_32529 + (1));
var inst_32529__$1 = inst_32540;
var state_32552__$1 = (function (){var statearr_32595 = state_32552;
(statearr_32595[(10)] = inst_32539);

(statearr_32595[(8)] = inst_32529__$1);

return statearr_32595;
})();
var statearr_32596_34480 = state_32552__$1;
(statearr_32596_34480[(2)] = null);

(statearr_32596_34480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (9))){
var state_32552__$1 = state_32552;
var statearr_32597_34482 = state_32552__$1;
(statearr_32597_34482[(2)] = null);

(statearr_32597_34482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (5))){
var state_32552__$1 = state_32552;
var statearr_32600_34486 = state_32552__$1;
(statearr_32600_34486[(2)] = null);

(statearr_32600_34486[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (10))){
var inst_32544 = (state_32552[(2)]);
var state_32552__$1 = state_32552;
var statearr_32603_34488 = state_32552__$1;
(statearr_32603_34488[(2)] = inst_32544);

(statearr_32603_34488[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32553 === (8))){
var inst_32534 = (state_32552[(7)]);
var state_32552__$1 = state_32552;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32552__$1,(11),out,inst_32534);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_32613 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32613[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_32613[(1)] = (1));

return statearr_32613;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_32552){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32552);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e32617){var ex__29723__auto__ = e32617;
var statearr_32618_34493 = state_32552;
(statearr_32618_34493[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32552[(4)]))){
var statearr_32619_34494 = state_32552;
(statearr_32619_34494[(1)] = cljs.core.first((state_32552[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34495 = state_32552;
state_32552 = G__34495;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_32552){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_32552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_32623 = f__30017__auto__();
(statearr_32623[(6)] = c__30016__auto___34455);

return statearr_32623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32639 = (function (f,ch,meta32632,_,fn1,meta32640){
this.f = f;
this.ch = ch;
this.meta32632 = meta32632;
this._ = _;
this.fn1 = fn1;
this.meta32640 = meta32640;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32641,meta32640__$1){
var self__ = this;
var _32641__$1 = this;
return (new cljs.core.async.t_cljs$core$async32639(self__.f,self__.ch,self__.meta32632,self__._,self__.fn1,meta32640__$1));
}));

(cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32641){
var self__ = this;
var _32641__$1 = this;
return self__.meta32640;
}));

(cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__32628_SHARP_){
var G__32645 = (((p1__32628_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__32628_SHARP_) : self__.f.call(null,p1__32628_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32645) : f1.call(null,G__32645));
});
}));

(cljs.core.async.t_cljs$core$async32639.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32632","meta32632",155573223,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32631","cljs.core.async/t_cljs$core$async32631",1836747757,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32640","meta32640",384969228,null)], null);
}));

(cljs.core.async.t_cljs$core$async32639.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32639.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32639");

(cljs.core.async.t_cljs$core$async32639.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32639");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32639.
 */
cljs.core.async.__GT_t_cljs$core$async32639 = (function cljs$core$async$__GT_t_cljs$core$async32639(f,ch,meta32632,_,fn1,meta32640){
return (new cljs.core.async.t_cljs$core$async32639(f,ch,meta32632,_,fn1,meta32640));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32631 = (function (f,ch,meta32632){
this.f = f;
this.ch = ch;
this.meta32632 = meta32632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32633,meta32632__$1){
var self__ = this;
var _32633__$1 = this;
return (new cljs.core.async.t_cljs$core$async32631(self__.f,self__.ch,meta32632__$1));
}));

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32633){
var self__ = this;
var _32633__$1 = this;
return self__.meta32632;
}));

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async32639(self__.f,self__.ch,self__.meta32632,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32659 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32659) : self__.f.call(null,G__32659));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32631.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async32631.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32632","meta32632",155573223,null)], null);
}));

(cljs.core.async.t_cljs$core$async32631.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32631.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32631");

(cljs.core.async.t_cljs$core$async32631.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32631");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32631.
 */
cljs.core.async.__GT_t_cljs$core$async32631 = (function cljs$core$async$__GT_t_cljs$core$async32631(f,ch,meta32632){
return (new cljs.core.async.t_cljs$core$async32631(f,ch,meta32632));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async32631(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32666 = (function (f,ch,meta32667){
this.f = f;
this.ch = ch;
this.meta32667 = meta32667;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32668,meta32667__$1){
var self__ = this;
var _32668__$1 = this;
return (new cljs.core.async.t_cljs$core$async32666(self__.f,self__.ch,meta32667__$1));
}));

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32668){
var self__ = this;
var _32668__$1 = this;
return self__.meta32667;
}));

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32666.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async32666.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32667","meta32667",13013857,null)], null);
}));

(cljs.core.async.t_cljs$core$async32666.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32666.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32666");

(cljs.core.async.t_cljs$core$async32666.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32666");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32666.
 */
cljs.core.async.__GT_t_cljs$core$async32666 = (function cljs$core$async$__GT_t_cljs$core$async32666(f,ch,meta32667){
return (new cljs.core.async.t_cljs$core$async32666(f,ch,meta32667));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async32666(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32678 = (function (p,ch,meta32679){
this.p = p;
this.ch = ch;
this.meta32679 = meta32679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32680,meta32679__$1){
var self__ = this;
var _32680__$1 = this;
return (new cljs.core.async.t_cljs$core$async32678(self__.p,self__.ch,meta32679__$1));
}));

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32680){
var self__ = this;
var _32680__$1 = this;
return self__.meta32679;
}));

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32678.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32679","meta32679",-851779968,null)], null);
}));

(cljs.core.async.t_cljs$core$async32678.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32678.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32678");

(cljs.core.async.t_cljs$core$async32678.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32678");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32678.
 */
cljs.core.async.__GT_t_cljs$core$async32678 = (function cljs$core$async$__GT_t_cljs$core$async32678(p,ch,meta32679){
return (new cljs.core.async.t_cljs$core$async32678(p,ch,meta32679));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async32678(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32696 = arguments.length;
switch (G__32696) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30016__auto___34525 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32722){
var state_val_32723 = (state_32722[(1)]);
if((state_val_32723 === (7))){
var inst_32718 = (state_32722[(2)]);
var state_32722__$1 = state_32722;
var statearr_32726_34526 = state_32722__$1;
(statearr_32726_34526[(2)] = inst_32718);

(statearr_32726_34526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (1))){
var state_32722__$1 = state_32722;
var statearr_32728_34528 = state_32722__$1;
(statearr_32728_34528[(2)] = null);

(statearr_32728_34528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (4))){
var inst_32704 = (state_32722[(7)]);
var inst_32704__$1 = (state_32722[(2)]);
var inst_32705 = (inst_32704__$1 == null);
var state_32722__$1 = (function (){var statearr_32731 = state_32722;
(statearr_32731[(7)] = inst_32704__$1);

return statearr_32731;
})();
if(cljs.core.truth_(inst_32705)){
var statearr_32732_34529 = state_32722__$1;
(statearr_32732_34529[(1)] = (5));

} else {
var statearr_32733_34530 = state_32722__$1;
(statearr_32733_34530[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (6))){
var inst_32704 = (state_32722[(7)]);
var inst_32709 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32704) : p.call(null,inst_32704));
var state_32722__$1 = state_32722;
if(cljs.core.truth_(inst_32709)){
var statearr_32734_34531 = state_32722__$1;
(statearr_32734_34531[(1)] = (8));

} else {
var statearr_32735_34532 = state_32722__$1;
(statearr_32735_34532[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (3))){
var inst_32720 = (state_32722[(2)]);
var state_32722__$1 = state_32722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32722__$1,inst_32720);
} else {
if((state_val_32723 === (2))){
var state_32722__$1 = state_32722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32722__$1,(4),ch);
} else {
if((state_val_32723 === (11))){
var inst_32712 = (state_32722[(2)]);
var state_32722__$1 = state_32722;
var statearr_32738_34535 = state_32722__$1;
(statearr_32738_34535[(2)] = inst_32712);

(statearr_32738_34535[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (9))){
var state_32722__$1 = state_32722;
var statearr_32740_34536 = state_32722__$1;
(statearr_32740_34536[(2)] = null);

(statearr_32740_34536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (5))){
var inst_32707 = cljs.core.async.close_BANG_(out);
var state_32722__$1 = state_32722;
var statearr_32747_34538 = state_32722__$1;
(statearr_32747_34538[(2)] = inst_32707);

(statearr_32747_34538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (10))){
var inst_32715 = (state_32722[(2)]);
var state_32722__$1 = (function (){var statearr_32748 = state_32722;
(statearr_32748[(8)] = inst_32715);

return statearr_32748;
})();
var statearr_32749_34539 = state_32722__$1;
(statearr_32749_34539[(2)] = null);

(statearr_32749_34539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32723 === (8))){
var inst_32704 = (state_32722[(7)]);
var state_32722__$1 = state_32722;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32722__$1,(11),out,inst_32704);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_32750 = [null,null,null,null,null,null,null,null,null];
(statearr_32750[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_32750[(1)] = (1));

return statearr_32750;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_32722){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32722);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e32751){var ex__29723__auto__ = e32751;
var statearr_32752_34542 = state_32722;
(statearr_32752_34542[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32722[(4)]))){
var statearr_32753_34543 = state_32722;
(statearr_32753_34543[(1)] = cljs.core.first((state_32722[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34544 = state_32722;
state_32722 = G__34544;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_32722){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_32722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_32755 = f__30017__auto__();
(statearr_32755[(6)] = c__30016__auto___34525);

return statearr_32755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32758 = arguments.length;
switch (G__32758) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30016__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32845){
var state_val_32846 = (state_32845[(1)]);
if((state_val_32846 === (7))){
var inst_32841 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32847_34550 = state_32845__$1;
(statearr_32847_34550[(2)] = inst_32841);

(statearr_32847_34550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (20))){
var inst_32808 = (state_32845[(7)]);
var inst_32822 = (state_32845[(2)]);
var inst_32823 = cljs.core.next(inst_32808);
var inst_32790 = inst_32823;
var inst_32791 = null;
var inst_32792 = (0);
var inst_32793 = (0);
var state_32845__$1 = (function (){var statearr_32849 = state_32845;
(statearr_32849[(8)] = inst_32793);

(statearr_32849[(9)] = inst_32790);

(statearr_32849[(10)] = inst_32791);

(statearr_32849[(11)] = inst_32822);

(statearr_32849[(12)] = inst_32792);

return statearr_32849;
})();
var statearr_32850_34552 = state_32845__$1;
(statearr_32850_34552[(2)] = null);

(statearr_32850_34552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (1))){
var state_32845__$1 = state_32845;
var statearr_32851_34556 = state_32845__$1;
(statearr_32851_34556[(2)] = null);

(statearr_32851_34556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (4))){
var inst_32776 = (state_32845[(13)]);
var inst_32776__$1 = (state_32845[(2)]);
var inst_32777 = (inst_32776__$1 == null);
var state_32845__$1 = (function (){var statearr_32853 = state_32845;
(statearr_32853[(13)] = inst_32776__$1);

return statearr_32853;
})();
if(cljs.core.truth_(inst_32777)){
var statearr_32855_34557 = state_32845__$1;
(statearr_32855_34557[(1)] = (5));

} else {
var statearr_32856_34558 = state_32845__$1;
(statearr_32856_34558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (15))){
var state_32845__$1 = state_32845;
var statearr_32863_34560 = state_32845__$1;
(statearr_32863_34560[(2)] = null);

(statearr_32863_34560[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (21))){
var state_32845__$1 = state_32845;
var statearr_32864_34561 = state_32845__$1;
(statearr_32864_34561[(2)] = null);

(statearr_32864_34561[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (13))){
var inst_32793 = (state_32845[(8)]);
var inst_32790 = (state_32845[(9)]);
var inst_32791 = (state_32845[(10)]);
var inst_32792 = (state_32845[(12)]);
var inst_32801 = (state_32845[(2)]);
var inst_32802 = (inst_32793 + (1));
var tmp32860 = inst_32790;
var tmp32861 = inst_32791;
var tmp32862 = inst_32792;
var inst_32790__$1 = tmp32860;
var inst_32791__$1 = tmp32861;
var inst_32792__$1 = tmp32862;
var inst_32793__$1 = inst_32802;
var state_32845__$1 = (function (){var statearr_32867 = state_32845;
(statearr_32867[(8)] = inst_32793__$1);

(statearr_32867[(9)] = inst_32790__$1);

(statearr_32867[(10)] = inst_32791__$1);

(statearr_32867[(14)] = inst_32801);

(statearr_32867[(12)] = inst_32792__$1);

return statearr_32867;
})();
var statearr_32868_34571 = state_32845__$1;
(statearr_32868_34571[(2)] = null);

(statearr_32868_34571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (22))){
var state_32845__$1 = state_32845;
var statearr_32869_34572 = state_32845__$1;
(statearr_32869_34572[(2)] = null);

(statearr_32869_34572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (6))){
var inst_32776 = (state_32845[(13)]);
var inst_32788 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32776) : f.call(null,inst_32776));
var inst_32789 = cljs.core.seq(inst_32788);
var inst_32790 = inst_32789;
var inst_32791 = null;
var inst_32792 = (0);
var inst_32793 = (0);
var state_32845__$1 = (function (){var statearr_32871 = state_32845;
(statearr_32871[(8)] = inst_32793);

(statearr_32871[(9)] = inst_32790);

(statearr_32871[(10)] = inst_32791);

(statearr_32871[(12)] = inst_32792);

return statearr_32871;
})();
var statearr_32875_34575 = state_32845__$1;
(statearr_32875_34575[(2)] = null);

(statearr_32875_34575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (17))){
var inst_32808 = (state_32845[(7)]);
var inst_32812 = cljs.core.chunk_first(inst_32808);
var inst_32813 = cljs.core.chunk_rest(inst_32808);
var inst_32814 = cljs.core.count(inst_32812);
var inst_32790 = inst_32813;
var inst_32791 = inst_32812;
var inst_32792 = inst_32814;
var inst_32793 = (0);
var state_32845__$1 = (function (){var statearr_32876 = state_32845;
(statearr_32876[(8)] = inst_32793);

(statearr_32876[(9)] = inst_32790);

(statearr_32876[(10)] = inst_32791);

(statearr_32876[(12)] = inst_32792);

return statearr_32876;
})();
var statearr_32878_34577 = state_32845__$1;
(statearr_32878_34577[(2)] = null);

(statearr_32878_34577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (3))){
var inst_32843 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32845__$1,inst_32843);
} else {
if((state_val_32846 === (12))){
var inst_32831 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32887_34578 = state_32845__$1;
(statearr_32887_34578[(2)] = inst_32831);

(statearr_32887_34578[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (2))){
var state_32845__$1 = state_32845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32845__$1,(4),in$);
} else {
if((state_val_32846 === (23))){
var inst_32839 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32892_34579 = state_32845__$1;
(statearr_32892_34579[(2)] = inst_32839);

(statearr_32892_34579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (19))){
var inst_32826 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32893_34580 = state_32845__$1;
(statearr_32893_34580[(2)] = inst_32826);

(statearr_32893_34580[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (11))){
var inst_32790 = (state_32845[(9)]);
var inst_32808 = (state_32845[(7)]);
var inst_32808__$1 = cljs.core.seq(inst_32790);
var state_32845__$1 = (function (){var statearr_32894 = state_32845;
(statearr_32894[(7)] = inst_32808__$1);

return statearr_32894;
})();
if(inst_32808__$1){
var statearr_32895_34589 = state_32845__$1;
(statearr_32895_34589[(1)] = (14));

} else {
var statearr_32896_34591 = state_32845__$1;
(statearr_32896_34591[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (9))){
var inst_32833 = (state_32845[(2)]);
var inst_32834 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32845__$1 = (function (){var statearr_32897 = state_32845;
(statearr_32897[(15)] = inst_32833);

return statearr_32897;
})();
if(cljs.core.truth_(inst_32834)){
var statearr_32898_34597 = state_32845__$1;
(statearr_32898_34597[(1)] = (21));

} else {
var statearr_32899_34598 = state_32845__$1;
(statearr_32899_34598[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (5))){
var inst_32782 = cljs.core.async.close_BANG_(out);
var state_32845__$1 = state_32845;
var statearr_32901_34600 = state_32845__$1;
(statearr_32901_34600[(2)] = inst_32782);

(statearr_32901_34600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (14))){
var inst_32808 = (state_32845[(7)]);
var inst_32810 = cljs.core.chunked_seq_QMARK_(inst_32808);
var state_32845__$1 = state_32845;
if(inst_32810){
var statearr_32902_34601 = state_32845__$1;
(statearr_32902_34601[(1)] = (17));

} else {
var statearr_32903_34602 = state_32845__$1;
(statearr_32903_34602[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (16))){
var inst_32829 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32907_34605 = state_32845__$1;
(statearr_32907_34605[(2)] = inst_32829);

(statearr_32907_34605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32846 === (10))){
var inst_32793 = (state_32845[(8)]);
var inst_32791 = (state_32845[(10)]);
var inst_32798 = cljs.core._nth(inst_32791,inst_32793);
var state_32845__$1 = state_32845;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32845__$1,(13),out,inst_32798);
} else {
if((state_val_32846 === (18))){
var inst_32808 = (state_32845[(7)]);
var inst_32820 = cljs.core.first(inst_32808);
var state_32845__$1 = state_32845;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32845__$1,(20),out,inst_32820);
} else {
if((state_val_32846 === (8))){
var inst_32793 = (state_32845[(8)]);
var inst_32792 = (state_32845[(12)]);
var inst_32795 = (inst_32793 < inst_32792);
var inst_32796 = inst_32795;
var state_32845__$1 = state_32845;
if(cljs.core.truth_(inst_32796)){
var statearr_32908_34611 = state_32845__$1;
(statearr_32908_34611[(1)] = (10));

} else {
var statearr_32909_34612 = state_32845__$1;
(statearr_32909_34612[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29719__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29719__auto____0 = (function (){
var statearr_32910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32910[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29719__auto__);

(statearr_32910[(1)] = (1));

return statearr_32910;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29719__auto____1 = (function (state_32845){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32845);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e32911){var ex__29723__auto__ = e32911;
var statearr_32912_34620 = state_32845;
(statearr_32912_34620[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32845[(4)]))){
var statearr_32913_34621 = state_32845;
(statearr_32913_34621[(1)] = cljs.core.first((state_32845[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34623 = state_32845;
state_32845 = G__34623;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29719__auto__ = function(state_32845){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29719__auto____1.call(this,state_32845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29719__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29719__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_32914 = f__30017__auto__();
(statearr_32914[(6)] = c__30016__auto__);

return statearr_32914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));

return c__30016__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32919 = arguments.length;
switch (G__32919) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32923 = arguments.length;
switch (G__32923) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32930 = arguments.length;
switch (G__32930) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30016__auto___34630 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_32956){
var state_val_32957 = (state_32956[(1)]);
if((state_val_32957 === (7))){
var inst_32951 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
var statearr_32962_34631 = state_32956__$1;
(statearr_32962_34631[(2)] = inst_32951);

(statearr_32962_34631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (1))){
var inst_32933 = null;
var state_32956__$1 = (function (){var statearr_32963 = state_32956;
(statearr_32963[(7)] = inst_32933);

return statearr_32963;
})();
var statearr_32964_34632 = state_32956__$1;
(statearr_32964_34632[(2)] = null);

(statearr_32964_34632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (4))){
var inst_32936 = (state_32956[(8)]);
var inst_32936__$1 = (state_32956[(2)]);
var inst_32937 = (inst_32936__$1 == null);
var inst_32938 = cljs.core.not(inst_32937);
var state_32956__$1 = (function (){var statearr_32968 = state_32956;
(statearr_32968[(8)] = inst_32936__$1);

return statearr_32968;
})();
if(inst_32938){
var statearr_32972_34634 = state_32956__$1;
(statearr_32972_34634[(1)] = (5));

} else {
var statearr_32974_34635 = state_32956__$1;
(statearr_32974_34635[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (6))){
var state_32956__$1 = state_32956;
var statearr_32976_34636 = state_32956__$1;
(statearr_32976_34636[(2)] = null);

(statearr_32976_34636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (3))){
var inst_32953 = (state_32956[(2)]);
var inst_32954 = cljs.core.async.close_BANG_(out);
var state_32956__$1 = (function (){var statearr_32977 = state_32956;
(statearr_32977[(9)] = inst_32953);

return statearr_32977;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32956__$1,inst_32954);
} else {
if((state_val_32957 === (2))){
var state_32956__$1 = state_32956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32956__$1,(4),ch);
} else {
if((state_val_32957 === (11))){
var inst_32936 = (state_32956[(8)]);
var inst_32945 = (state_32956[(2)]);
var inst_32933 = inst_32936;
var state_32956__$1 = (function (){var statearr_32978 = state_32956;
(statearr_32978[(10)] = inst_32945);

(statearr_32978[(7)] = inst_32933);

return statearr_32978;
})();
var statearr_32979_34641 = state_32956__$1;
(statearr_32979_34641[(2)] = null);

(statearr_32979_34641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (9))){
var inst_32936 = (state_32956[(8)]);
var state_32956__$1 = state_32956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32956__$1,(11),out,inst_32936);
} else {
if((state_val_32957 === (5))){
var inst_32936 = (state_32956[(8)]);
var inst_32933 = (state_32956[(7)]);
var inst_32940 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32936,inst_32933);
var state_32956__$1 = state_32956;
if(inst_32940){
var statearr_32984_34642 = state_32956__$1;
(statearr_32984_34642[(1)] = (8));

} else {
var statearr_32985_34643 = state_32956__$1;
(statearr_32985_34643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (10))){
var inst_32948 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
var statearr_32986_34644 = state_32956__$1;
(statearr_32986_34644[(2)] = inst_32948);

(statearr_32986_34644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (8))){
var inst_32933 = (state_32956[(7)]);
var tmp32983 = inst_32933;
var inst_32933__$1 = tmp32983;
var state_32956__$1 = (function (){var statearr_32987 = state_32956;
(statearr_32987[(7)] = inst_32933__$1);

return statearr_32987;
})();
var statearr_32988_34645 = state_32956__$1;
(statearr_32988_34645[(2)] = null);

(statearr_32988_34645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_32995 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32995[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_32995[(1)] = (1));

return statearr_32995;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_32956){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_32956);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e33004){var ex__29723__auto__ = e33004;
var statearr_33005_34646 = state_32956;
(statearr_33005_34646[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_32956[(4)]))){
var statearr_33009_34647 = state_32956;
(statearr_33009_34647[(1)] = cljs.core.first((state_32956[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34649 = state_32956;
state_32956 = G__34649;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_32956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_32956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_33016 = f__30017__auto__();
(statearr_33016[(6)] = c__30016__auto___34630);

return statearr_33016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33038 = arguments.length;
switch (G__33038) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30016__auto___34656 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_33083){
var state_val_33084 = (state_33083[(1)]);
if((state_val_33084 === (7))){
var inst_33079 = (state_33083[(2)]);
var state_33083__$1 = state_33083;
var statearr_33091_34659 = state_33083__$1;
(statearr_33091_34659[(2)] = inst_33079);

(statearr_33091_34659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (1))){
var inst_33041 = (new Array(n));
var inst_33042 = inst_33041;
var inst_33043 = (0);
var state_33083__$1 = (function (){var statearr_33092 = state_33083;
(statearr_33092[(7)] = inst_33042);

(statearr_33092[(8)] = inst_33043);

return statearr_33092;
})();
var statearr_33093_34664 = state_33083__$1;
(statearr_33093_34664[(2)] = null);

(statearr_33093_34664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (4))){
var inst_33046 = (state_33083[(9)]);
var inst_33046__$1 = (state_33083[(2)]);
var inst_33050 = (inst_33046__$1 == null);
var inst_33051 = cljs.core.not(inst_33050);
var state_33083__$1 = (function (){var statearr_33094 = state_33083;
(statearr_33094[(9)] = inst_33046__$1);

return statearr_33094;
})();
if(inst_33051){
var statearr_33095_34666 = state_33083__$1;
(statearr_33095_34666[(1)] = (5));

} else {
var statearr_33096_34667 = state_33083__$1;
(statearr_33096_34667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (15))){
var inst_33073 = (state_33083[(2)]);
var state_33083__$1 = state_33083;
var statearr_33100_34668 = state_33083__$1;
(statearr_33100_34668[(2)] = inst_33073);

(statearr_33100_34668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (13))){
var state_33083__$1 = state_33083;
var statearr_33101_34669 = state_33083__$1;
(statearr_33101_34669[(2)] = null);

(statearr_33101_34669[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (6))){
var inst_33043 = (state_33083[(8)]);
var inst_33069 = (inst_33043 > (0));
var state_33083__$1 = state_33083;
if(cljs.core.truth_(inst_33069)){
var statearr_33102_34671 = state_33083__$1;
(statearr_33102_34671[(1)] = (12));

} else {
var statearr_33103_34672 = state_33083__$1;
(statearr_33103_34672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (3))){
var inst_33081 = (state_33083[(2)]);
var state_33083__$1 = state_33083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33083__$1,inst_33081);
} else {
if((state_val_33084 === (12))){
var inst_33042 = (state_33083[(7)]);
var inst_33071 = cljs.core.vec(inst_33042);
var state_33083__$1 = state_33083;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33083__$1,(15),out,inst_33071);
} else {
if((state_val_33084 === (2))){
var state_33083__$1 = state_33083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33083__$1,(4),ch);
} else {
if((state_val_33084 === (11))){
var inst_33063 = (state_33083[(2)]);
var inst_33064 = (new Array(n));
var inst_33042 = inst_33064;
var inst_33043 = (0);
var state_33083__$1 = (function (){var statearr_33105 = state_33083;
(statearr_33105[(7)] = inst_33042);

(statearr_33105[(10)] = inst_33063);

(statearr_33105[(8)] = inst_33043);

return statearr_33105;
})();
var statearr_33106_34679 = state_33083__$1;
(statearr_33106_34679[(2)] = null);

(statearr_33106_34679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (9))){
var inst_33042 = (state_33083[(7)]);
var inst_33061 = cljs.core.vec(inst_33042);
var state_33083__$1 = state_33083;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33083__$1,(11),out,inst_33061);
} else {
if((state_val_33084 === (5))){
var inst_33042 = (state_33083[(7)]);
var inst_33046 = (state_33083[(9)]);
var inst_33055 = (state_33083[(11)]);
var inst_33043 = (state_33083[(8)]);
var inst_33054 = (inst_33042[inst_33043] = inst_33046);
var inst_33055__$1 = (inst_33043 + (1));
var inst_33056 = (inst_33055__$1 < n);
var state_33083__$1 = (function (){var statearr_33107 = state_33083;
(statearr_33107[(11)] = inst_33055__$1);

(statearr_33107[(12)] = inst_33054);

return statearr_33107;
})();
if(cljs.core.truth_(inst_33056)){
var statearr_33108_34686 = state_33083__$1;
(statearr_33108_34686[(1)] = (8));

} else {
var statearr_33109_34687 = state_33083__$1;
(statearr_33109_34687[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (14))){
var inst_33076 = (state_33083[(2)]);
var inst_33077 = cljs.core.async.close_BANG_(out);
var state_33083__$1 = (function (){var statearr_33114 = state_33083;
(statearr_33114[(13)] = inst_33076);

return statearr_33114;
})();
var statearr_33115_34688 = state_33083__$1;
(statearr_33115_34688[(2)] = inst_33077);

(statearr_33115_34688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (10))){
var inst_33067 = (state_33083[(2)]);
var state_33083__$1 = state_33083;
var statearr_33116_34689 = state_33083__$1;
(statearr_33116_34689[(2)] = inst_33067);

(statearr_33116_34689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33084 === (8))){
var inst_33042 = (state_33083[(7)]);
var inst_33055 = (state_33083[(11)]);
var tmp33113 = inst_33042;
var inst_33042__$1 = tmp33113;
var inst_33043 = inst_33055;
var state_33083__$1 = (function (){var statearr_33117 = state_33083;
(statearr_33117[(7)] = inst_33042__$1);

(statearr_33117[(8)] = inst_33043);

return statearr_33117;
})();
var statearr_33121_34690 = state_33083__$1;
(statearr_33121_34690[(2)] = null);

(statearr_33121_34690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_33129 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33129[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_33129[(1)] = (1));

return statearr_33129;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_33083){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_33083);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e33138){var ex__29723__auto__ = e33138;
var statearr_33139_34699 = state_33083;
(statearr_33139_34699[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_33083[(4)]))){
var statearr_33147_34700 = state_33083;
(statearr_33147_34700[(1)] = cljs.core.first((state_33083[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34701 = state_33083;
state_33083 = G__34701;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_33083){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_33083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_33152 = f__30017__auto__();
(statearr_33152[(6)] = c__30016__auto___34656);

return statearr_33152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33169 = arguments.length;
switch (G__33169) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30016__auto___34714 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30017__auto__ = (function (){var switch__29717__auto__ = (function (state_33228){
var state_val_33232 = (state_33228[(1)]);
if((state_val_33232 === (7))){
var inst_33221 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
var statearr_33238_34720 = state_33228__$1;
(statearr_33238_34720[(2)] = inst_33221);

(statearr_33238_34720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (1))){
var inst_33173 = [];
var inst_33174 = inst_33173;
var inst_33175 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33228__$1 = (function (){var statearr_33239 = state_33228;
(statearr_33239[(7)] = inst_33174);

(statearr_33239[(8)] = inst_33175);

return statearr_33239;
})();
var statearr_33240_34721 = state_33228__$1;
(statearr_33240_34721[(2)] = null);

(statearr_33240_34721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (4))){
var inst_33182 = (state_33228[(9)]);
var inst_33182__$1 = (state_33228[(2)]);
var inst_33187 = (inst_33182__$1 == null);
var inst_33188 = cljs.core.not(inst_33187);
var state_33228__$1 = (function (){var statearr_33243 = state_33228;
(statearr_33243[(9)] = inst_33182__$1);

return statearr_33243;
})();
if(inst_33188){
var statearr_33245_34722 = state_33228__$1;
(statearr_33245_34722[(1)] = (5));

} else {
var statearr_33246_34727 = state_33228__$1;
(statearr_33246_34727[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (15))){
var inst_33174 = (state_33228[(7)]);
var inst_33213 = cljs.core.vec(inst_33174);
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33228__$1,(18),out,inst_33213);
} else {
if((state_val_33232 === (13))){
var inst_33208 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
var statearr_33250_34729 = state_33228__$1;
(statearr_33250_34729[(2)] = inst_33208);

(statearr_33250_34729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (6))){
var inst_33174 = (state_33228[(7)]);
var inst_33210 = inst_33174.length;
var inst_33211 = (inst_33210 > (0));
var state_33228__$1 = state_33228;
if(cljs.core.truth_(inst_33211)){
var statearr_33253_34730 = state_33228__$1;
(statearr_33253_34730[(1)] = (15));

} else {
var statearr_33256_34732 = state_33228__$1;
(statearr_33256_34732[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (17))){
var inst_33218 = (state_33228[(2)]);
var inst_33219 = cljs.core.async.close_BANG_(out);
var state_33228__$1 = (function (){var statearr_33258 = state_33228;
(statearr_33258[(10)] = inst_33218);

return statearr_33258;
})();
var statearr_33262_34745 = state_33228__$1;
(statearr_33262_34745[(2)] = inst_33219);

(statearr_33262_34745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (3))){
var inst_33223 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33228__$1,inst_33223);
} else {
if((state_val_33232 === (12))){
var inst_33174 = (state_33228[(7)]);
var inst_33201 = cljs.core.vec(inst_33174);
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33228__$1,(14),out,inst_33201);
} else {
if((state_val_33232 === (2))){
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33228__$1,(4),ch);
} else {
if((state_val_33232 === (11))){
var inst_33182 = (state_33228[(9)]);
var inst_33174 = (state_33228[(7)]);
var inst_33190 = (state_33228[(11)]);
var inst_33198 = inst_33174.push(inst_33182);
var tmp33265 = inst_33174;
var inst_33174__$1 = tmp33265;
var inst_33175 = inst_33190;
var state_33228__$1 = (function (){var statearr_33267 = state_33228;
(statearr_33267[(12)] = inst_33198);

(statearr_33267[(7)] = inst_33174__$1);

(statearr_33267[(8)] = inst_33175);

return statearr_33267;
})();
var statearr_33269_34756 = state_33228__$1;
(statearr_33269_34756[(2)] = null);

(statearr_33269_34756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (9))){
var inst_33175 = (state_33228[(8)]);
var inst_33194 = cljs.core.keyword_identical_QMARK_(inst_33175,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_33228__$1 = state_33228;
var statearr_33270_34757 = state_33228__$1;
(statearr_33270_34757[(2)] = inst_33194);

(statearr_33270_34757[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (5))){
var inst_33182 = (state_33228[(9)]);
var inst_33191 = (state_33228[(13)]);
var inst_33175 = (state_33228[(8)]);
var inst_33190 = (state_33228[(11)]);
var inst_33190__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33182) : f.call(null,inst_33182));
var inst_33191__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33190__$1,inst_33175);
var state_33228__$1 = (function (){var statearr_33276 = state_33228;
(statearr_33276[(13)] = inst_33191__$1);

(statearr_33276[(11)] = inst_33190__$1);

return statearr_33276;
})();
if(inst_33191__$1){
var statearr_33277_34765 = state_33228__$1;
(statearr_33277_34765[(1)] = (8));

} else {
var statearr_33278_34767 = state_33228__$1;
(statearr_33278_34767[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (14))){
var inst_33182 = (state_33228[(9)]);
var inst_33190 = (state_33228[(11)]);
var inst_33203 = (state_33228[(2)]);
var inst_33204 = [];
var inst_33205 = inst_33204.push(inst_33182);
var inst_33174 = inst_33204;
var inst_33175 = inst_33190;
var state_33228__$1 = (function (){var statearr_33281 = state_33228;
(statearr_33281[(14)] = inst_33205);

(statearr_33281[(15)] = inst_33203);

(statearr_33281[(7)] = inst_33174);

(statearr_33281[(8)] = inst_33175);

return statearr_33281;
})();
var statearr_33282_34768 = state_33228__$1;
(statearr_33282_34768[(2)] = null);

(statearr_33282_34768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (16))){
var state_33228__$1 = state_33228;
var statearr_33283_34773 = state_33228__$1;
(statearr_33283_34773[(2)] = null);

(statearr_33283_34773[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (10))){
var inst_33196 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
if(cljs.core.truth_(inst_33196)){
var statearr_33286_34787 = state_33228__$1;
(statearr_33286_34787[(1)] = (11));

} else {
var statearr_33289_34788 = state_33228__$1;
(statearr_33289_34788[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (18))){
var inst_33215 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
var statearr_33293_34789 = state_33228__$1;
(statearr_33293_34789[(2)] = inst_33215);

(statearr_33293_34789[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33232 === (8))){
var inst_33191 = (state_33228[(13)]);
var state_33228__$1 = state_33228;
var statearr_33294_34802 = state_33228__$1;
(statearr_33294_34802[(2)] = inst_33191);

(statearr_33294_34802[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29719__auto__ = null;
var cljs$core$async$state_machine__29719__auto____0 = (function (){
var statearr_33295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33295[(0)] = cljs$core$async$state_machine__29719__auto__);

(statearr_33295[(1)] = (1));

return statearr_33295;
});
var cljs$core$async$state_machine__29719__auto____1 = (function (state_33228){
while(true){
var ret_value__29720__auto__ = (function (){try{while(true){
var result__29721__auto__ = switch__29717__auto__(state_33228);
if(cljs.core.keyword_identical_QMARK_(result__29721__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29721__auto__;
}
break;
}
}catch (e33296){var ex__29723__auto__ = e33296;
var statearr_33297_34810 = state_33228;
(statearr_33297_34810[(2)] = ex__29723__auto__);


if(cljs.core.seq((state_33228[(4)]))){
var statearr_33298_34811 = state_33228;
(statearr_33298_34811[(1)] = cljs.core.first((state_33228[(4)])));

} else {
throw ex__29723__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29720__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34813 = state_33228;
state_33228 = G__34813;
continue;
} else {
return ret_value__29720__auto__;
}
break;
}
});
cljs$core$async$state_machine__29719__auto__ = function(state_33228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29719__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29719__auto____1.call(this,state_33228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29719__auto____0;
cljs$core$async$state_machine__29719__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29719__auto____1;
return cljs$core$async$state_machine__29719__auto__;
})()
})();
var state__30018__auto__ = (function (){var statearr_33302 = f__30017__auto__();
(statearr_33302[(6)] = c__30016__auto___34714);

return statearr_33302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30018__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
