goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41592 = schema.utils.use_fn_validation;
var output_schema41105_41593 = schema.core.Bool;
var input_schema41106_41594 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41107_41595 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41106_41594);
}),null));
var output_checker41108_41596 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41105_41593);
}),null));
var ret__40195__auto___41597 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41109){
var validate__37896__auto__ = cljs.core.deref(ufv___41592);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41598 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41109], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41110_41599 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41111_41600 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41112_41601 = input_schema41106_41594;
var G__41113_41602 = cljs.core.deref(input_checker41107_41595);
var G__41114_41603 = args__37897__auto___41598;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41110_41599,G__41111_41600,G__41112_41601,G__41113_41602,G__41114_41603) : schema.core.fn_validator.call(null,G__41110_41599,G__41111_41600,G__41112_41601,G__41113_41602,G__41114_41603));
} else {
var temp__5804__auto___41604 = (function (){var fexpr__41115 = cljs.core.deref(input_checker41107_41595);
return (fexpr__41115.cljs$core$IFn$_invoke$arity$1 ? fexpr__41115.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41598) : fexpr__41115.call(null,args__37897__auto___41598));
})();
if(cljs.core.truth_(temp__5804__auto___41604)){
var error__37898__auto___41605 = temp__5804__auto___41604;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41605], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41106_41594,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41598,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41605], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var arg = G__41109;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41116_41607 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41117_41608 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41118_41609 = output_schema41105_41593;
var G__41119_41610 = cljs.core.deref(output_checker41108_41596);
var G__41120_41611 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41116_41607,G__41117_41608,G__41118_41609,G__41119_41610,G__41120_41611) : schema.core.fn_validator.call(null,G__41116_41607,G__41117_41608,G__41118_41609,G__41119_41610,G__41120_41611));
} else {
var temp__5804__auto___41612 = (function (){var fexpr__41121 = cljs.core.deref(output_checker41108_41596);
return (fexpr__41121.cljs$core$IFn$_invoke$arity$1 ? fexpr__41121.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41121.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41612)){
var error__37898__auto___41613 = temp__5804__auto___41612;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41613], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41105_41593,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41613], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41105_41593,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41106_41594], null)));

var ufv___41616 = schema.utils.use_fn_validation;
var output_schema41122_41617 = deercreeklabs.baracus.ByteArray;
var input_schema41123_41618 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41127_41619 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41124_41620 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41123_41618);
}),null));
var output_checker41125_41621 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41122_41617);
}),null));
var input_checker41128_41622 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41127_41619);
}),null));
var output_checker41129_41623 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41122_41617);
}),null));
var ret__40195__auto___41625 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41133 = arguments.length;
switch (G__41133) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41126){
var validate__37896__auto__ = cljs.core.deref(ufv___41616);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41627 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41126], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41136_41628 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41137_41629 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41138_41630 = input_schema41123_41618;
var G__41139_41631 = cljs.core.deref(input_checker41124_41620);
var G__41140_41632 = args__37897__auto___41627;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41136_41628,G__41137_41629,G__41138_41630,G__41139_41631,G__41140_41632) : schema.core.fn_validator.call(null,G__41136_41628,G__41137_41629,G__41138_41630,G__41139_41631,G__41140_41632));
} else {
var temp__5804__auto___41633 = (function (){var fexpr__41141 = cljs.core.deref(input_checker41124_41620);
return (fexpr__41141.cljs$core$IFn$_invoke$arity$1 ? fexpr__41141.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41627) : fexpr__41141.call(null,args__37897__auto___41627));
})();
if(cljs.core.truth_(temp__5804__auto___41633)){
var error__37898__auto___41634 = temp__5804__auto___41633;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41634], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41123_41618,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41627,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41634], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var size_or_seq = G__41126;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41144_41635 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41145_41636 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41146_41637 = output_schema41122_41617;
var G__41147_41638 = cljs.core.deref(output_checker41125_41621);
var G__41148_41639 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41144_41635,G__41145_41636,G__41146_41637,G__41147_41638,G__41148_41639) : schema.core.fn_validator.call(null,G__41144_41635,G__41145_41636,G__41146_41637,G__41147_41638,G__41148_41639));
} else {
var temp__5804__auto___41640 = (function (){var fexpr__41149 = cljs.core.deref(output_checker41125_41621);
return (fexpr__41149.cljs$core$IFn$_invoke$arity$1 ? fexpr__41149.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41149.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41640)){
var error__37898__auto___41641 = temp__5804__auto___41640;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41641], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41122_41617,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41641], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41130,G__41131){
var validate__37896__auto__ = cljs.core.deref(ufv___41616);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41642 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41130,G__41131], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41150_41643 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41151_41644 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41152_41645 = input_schema41127_41619;
var G__41153_41646 = cljs.core.deref(input_checker41128_41622);
var G__41154_41647 = args__37897__auto___41642;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41150_41643,G__41151_41644,G__41152_41645,G__41153_41646,G__41154_41647) : schema.core.fn_validator.call(null,G__41150_41643,G__41151_41644,G__41152_41645,G__41153_41646,G__41154_41647));
} else {
var temp__5804__auto___41649 = (function (){var fexpr__41155 = cljs.core.deref(input_checker41128_41622);
return (fexpr__41155.cljs$core$IFn$_invoke$arity$1 ? fexpr__41155.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41642) : fexpr__41155.call(null,args__37897__auto___41642));
})();
if(cljs.core.truth_(temp__5804__auto___41649)){
var error__37898__auto___41651 = temp__5804__auto___41649;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41651], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41127_41619,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41642,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41651], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var size = G__41130;
var init_val_or_seq = G__41131;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41156_41652 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41157_41653 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41158_41654 = output_schema41122_41617;
var G__41159_41655 = cljs.core.deref(output_checker41129_41623);
var G__41160_41656 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41156_41652,G__41157_41653,G__41158_41654,G__41159_41655,G__41160_41656) : schema.core.fn_validator.call(null,G__41156_41652,G__41157_41653,G__41158_41654,G__41159_41655,G__41160_41656));
} else {
var temp__5804__auto___41658 = (function (){var fexpr__41161 = cljs.core.deref(output_checker41129_41623);
return (fexpr__41161.cljs$core$IFn$_invoke$arity$1 ? fexpr__41161.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41161.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41658)){
var error__37898__auto___41659 = temp__5804__auto___41658;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41659], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41122_41617,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41659], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41122_41617,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41123_41618,input_schema41127_41619], null)));

var ufv___41661 = schema.utils.use_fn_validation;
var output_schema41163_41662 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41164_41663 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41165_41664 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41164_41663);
}),null));
var output_checker41166_41665 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41163_41662);
}),null));
var ret__40195__auto___41666 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41167){
var validate__37896__auto__ = cljs.core.deref(ufv___41661);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41667 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41167], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41169_41668 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41170_41669 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41171_41670 = input_schema41164_41663;
var G__41172_41671 = cljs.core.deref(input_checker41165_41664);
var G__41173_41672 = args__37897__auto___41667;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41169_41668,G__41170_41669,G__41171_41670,G__41172_41671,G__41173_41672) : schema.core.fn_validator.call(null,G__41169_41668,G__41170_41669,G__41171_41670,G__41172_41671,G__41173_41672));
} else {
var temp__5804__auto___41673 = (function (){var fexpr__41174 = cljs.core.deref(input_checker41165_41664);
return (fexpr__41174.cljs$core$IFn$_invoke$arity$1 ? fexpr__41174.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41667) : fexpr__41174.call(null,args__37897__auto___41667));
})();
if(cljs.core.truth_(temp__5804__auto___41673)){
var error__37898__auto___41675 = temp__5804__auto___41673;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41675], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41164_41663,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41667,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41675], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var arrays = G__41167;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41175 = cljs.core.count(arrays__$1);
switch (G__41175) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41175,arrays__$1,validate__37896__auto__,ufv___41661,output_schema41163_41662,input_schema41164_41663,input_checker41165_41664,output_checker41166_41665){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41175,arrays__$1,validate__37896__auto__,ufv___41661,output_schema41163_41662,input_schema41164_41663,input_checker41165_41664,output_checker41166_41665))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41175,arrays__$1,validate__37896__auto__,ufv___41661,output_schema41163_41662,input_schema41164_41663,input_checker41165_41664,output_checker41166_41665){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41175,arrays__$1,validate__37896__auto__,ufv___41661,output_schema41163_41662,input_schema41164_41663,input_checker41165_41664,output_checker41166_41665))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41176_41680 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41177_41681 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41178_41682 = output_schema41163_41662;
var G__41179_41683 = cljs.core.deref(output_checker41166_41665);
var G__41180_41684 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41176_41680,G__41177_41681,G__41178_41682,G__41179_41683,G__41180_41684) : schema.core.fn_validator.call(null,G__41176_41680,G__41177_41681,G__41178_41682,G__41179_41683,G__41180_41684));
} else {
var temp__5804__auto___41685 = (function (){var fexpr__41182 = cljs.core.deref(output_checker41166_41665);
return (fexpr__41182.cljs$core$IFn$_invoke$arity$1 ? fexpr__41182.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41182.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41685)){
var error__37898__auto___41686 = temp__5804__auto___41685;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41686], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41163_41662,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41686], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41163_41662,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41164_41663], null)));

var ufv___41688 = schema.utils.use_fn_validation;
var output_schema41183_41689 = schema.core.Bool;
var input_schema41184_41690 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41185_41691 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41184_41690);
}),null));
var output_checker41186_41692 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41183_41689);
}),null));
var ret__40195__auto___41693 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41187,G__41188){
var validate__37896__auto__ = cljs.core.deref(ufv___41688);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41696 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41187,G__41188], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41190_41697 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41191_41698 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41192_41699 = input_schema41184_41690;
var G__41193_41700 = cljs.core.deref(input_checker41185_41691);
var G__41194_41701 = args__37897__auto___41696;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41190_41697,G__41191_41698,G__41192_41699,G__41193_41700,G__41194_41701) : schema.core.fn_validator.call(null,G__41190_41697,G__41191_41698,G__41192_41699,G__41193_41700,G__41194_41701));
} else {
var temp__5804__auto___41703 = (function (){var fexpr__41195 = cljs.core.deref(input_checker41185_41691);
return (fexpr__41195.cljs$core$IFn$_invoke$arity$1 ? fexpr__41195.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41696) : fexpr__41195.call(null,args__37897__auto___41696));
})();
if(cljs.core.truth_(temp__5804__auto___41703)){
var error__37898__auto___41705 = temp__5804__auto___41703;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41705], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41184_41690,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41696,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41705], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var a = G__41187;
var b = G__41188;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41709 = ((i + (1)) | (0));
i = G__41709;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41197_41710 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41198_41711 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41199_41712 = output_schema41183_41689;
var G__41200_41713 = cljs.core.deref(output_checker41186_41692);
var G__41201_41714 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41197_41710,G__41198_41711,G__41199_41712,G__41200_41713,G__41201_41714) : schema.core.fn_validator.call(null,G__41197_41710,G__41198_41711,G__41199_41712,G__41200_41713,G__41201_41714));
} else {
var temp__5804__auto___41715 = (function (){var fexpr__41202 = cljs.core.deref(output_checker41186_41692);
return (fexpr__41202.cljs$core$IFn$_invoke$arity$1 ? fexpr__41202.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41202.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41715)){
var error__37898__auto___41717 = temp__5804__auto___41715;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41717], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41183_41689,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41717], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41183_41689,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41184_41690], null)));

var ufv___41722 = schema.utils.use_fn_validation;
var output_schema41203_41723 = schema.core.Str;
var input_schema41204_41724 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41205_41725 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41204_41724);
}),null));
var output_checker41206_41726 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41203_41723);
}),null));
var ret__40195__auto___41727 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41207){
var validate__37896__auto__ = cljs.core.deref(ufv___41722);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41728 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41207], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41209_41729 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41210_41730 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41211_41731 = input_schema41204_41724;
var G__41212_41732 = cljs.core.deref(input_checker41205_41725);
var G__41213_41733 = args__37897__auto___41728;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41209_41729,G__41210_41730,G__41211_41731,G__41212_41732,G__41213_41733) : schema.core.fn_validator.call(null,G__41209_41729,G__41210_41730,G__41211_41731,G__41212_41732,G__41213_41733));
} else {
var temp__5804__auto___41734 = (function (){var fexpr__41214 = cljs.core.deref(input_checker41205_41725);
return (fexpr__41214.cljs$core$IFn$_invoke$arity$1 ? fexpr__41214.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41728) : fexpr__41214.call(null,args__37897__auto___41728));
})();
if(cljs.core.truth_(temp__5804__auto___41734)){
var error__37898__auto___41735 = temp__5804__auto___41734;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41735], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41204_41724,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41728,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41735], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41207;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41215_41737 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41216_41738 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41217_41739 = output_schema41203_41723;
var G__41218_41740 = cljs.core.deref(output_checker41206_41726);
var G__41219_41741 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41215_41737,G__41216_41738,G__41217_41739,G__41218_41740,G__41219_41741) : schema.core.fn_validator.call(null,G__41215_41737,G__41216_41738,G__41217_41739,G__41218_41740,G__41219_41741));
} else {
var temp__5804__auto___41742 = (function (){var fexpr__41220 = cljs.core.deref(output_checker41206_41726);
return (fexpr__41220.cljs$core$IFn$_invoke$arity$1 ? fexpr__41220.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41220.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41742)){
var error__37898__auto___41743 = temp__5804__auto___41742;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41743], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41203_41723,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41743], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41203_41723,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41204_41724], null)));

var ufv___41744 = schema.utils.use_fn_validation;
var output_schema41223_41745 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41224_41746 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41228_41747 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41233_41748 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41225_41749 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41224_41746);
}),null));
var output_checker41226_41750 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41223_41745);
}),null));
var input_checker41229_41751 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41228_41747);
}),null));
var output_checker41230_41752 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41223_41745);
}),null));
var input_checker41234_41753 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41233_41748);
}),null));
var output_checker41235_41754 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41223_41745);
}),null));
var ret__40195__auto___41760 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41241 = arguments.length;
switch (G__41241) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41227){
var validate__37896__auto__ = cljs.core.deref(ufv___41744);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41769 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41227], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41242_41770 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41243_41771 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41244_41772 = input_schema41224_41746;
var G__41245_41773 = cljs.core.deref(input_checker41225_41749);
var G__41246_41774 = args__37897__auto___41769;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41242_41770,G__41243_41771,G__41244_41772,G__41245_41773,G__41246_41774) : schema.core.fn_validator.call(null,G__41242_41770,G__41243_41771,G__41244_41772,G__41245_41773,G__41246_41774));
} else {
var temp__5804__auto___41776 = (function (){var fexpr__41250 = cljs.core.deref(input_checker41225_41749);
return (fexpr__41250.cljs$core$IFn$_invoke$arity$1 ? fexpr__41250.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41769) : fexpr__41250.call(null,args__37897__auto___41769));
})();
if(cljs.core.truth_(temp__5804__auto___41776)){
var error__37898__auto___41777 = temp__5804__auto___41776;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41777], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41224_41746,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41769,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41777], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41227;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41251_41779 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41252_41780 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41253_41781 = output_schema41223_41745;
var G__41254_41782 = cljs.core.deref(output_checker41226_41750);
var G__41255_41783 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41251_41779,G__41252_41780,G__41253_41781,G__41254_41782,G__41255_41783) : schema.core.fn_validator.call(null,G__41251_41779,G__41252_41780,G__41253_41781,G__41254_41782,G__41255_41783));
} else {
var temp__5804__auto___41785 = (function (){var fexpr__41257 = cljs.core.deref(output_checker41226_41750);
return (fexpr__41257.cljs$core$IFn$_invoke$arity$1 ? fexpr__41257.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41257.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41785)){
var error__37898__auto___41786 = temp__5804__auto___41785;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41786], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41223_41745,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41786], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41231,G__41232){
var validate__37896__auto__ = cljs.core.deref(ufv___41744);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41789 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41231,G__41232], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41258_41790 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41259_41791 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41260_41792 = input_schema41228_41747;
var G__41261_41793 = cljs.core.deref(input_checker41229_41751);
var G__41262_41794 = args__37897__auto___41789;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41258_41790,G__41259_41791,G__41260_41792,G__41261_41793,G__41262_41794) : schema.core.fn_validator.call(null,G__41258_41790,G__41259_41791,G__41260_41792,G__41261_41793,G__41262_41794));
} else {
var temp__5804__auto___41797 = (function (){var fexpr__41263 = cljs.core.deref(input_checker41229_41751);
return (fexpr__41263.cljs$core$IFn$_invoke$arity$1 ? fexpr__41263.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41789) : fexpr__41263.call(null,args__37897__auto___41789));
})();
if(cljs.core.truth_(temp__5804__auto___41797)){
var error__37898__auto___41799 = temp__5804__auto___41797;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41799], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41228_41747,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41789,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41799], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41231;
var start = G__41232;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41264_41803 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41265_41804 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41266_41805 = output_schema41223_41745;
var G__41267_41806 = cljs.core.deref(output_checker41230_41752);
var G__41268_41807 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41264_41803,G__41265_41804,G__41266_41805,G__41267_41806,G__41268_41807) : schema.core.fn_validator.call(null,G__41264_41803,G__41265_41804,G__41266_41805,G__41267_41806,G__41268_41807));
} else {
var temp__5804__auto___41808 = (function (){var fexpr__41269 = cljs.core.deref(output_checker41230_41752);
return (fexpr__41269.cljs$core$IFn$_invoke$arity$1 ? fexpr__41269.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41269.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41808)){
var error__37898__auto___41809 = temp__5804__auto___41808;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41809], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41223_41745,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41809], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41236,G__41237,G__41238){
var validate__37896__auto__ = cljs.core.deref(ufv___41744);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41811 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41236,G__41237,G__41238], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41271_41813 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41272_41814 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41273_41815 = input_schema41233_41748;
var G__41274_41816 = cljs.core.deref(input_checker41234_41753);
var G__41275_41817 = args__37897__auto___41811;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41271_41813,G__41272_41814,G__41273_41815,G__41274_41816,G__41275_41817) : schema.core.fn_validator.call(null,G__41271_41813,G__41272_41814,G__41273_41815,G__41274_41816,G__41275_41817));
} else {
var temp__5804__auto___41819 = (function (){var fexpr__41276 = cljs.core.deref(input_checker41234_41753);
return (fexpr__41276.cljs$core$IFn$_invoke$arity$1 ? fexpr__41276.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41811) : fexpr__41276.call(null,args__37897__auto___41811));
})();
if(cljs.core.truth_(temp__5804__auto___41819)){
var error__37898__auto___41820 = temp__5804__auto___41819;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41820], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41233_41748,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41811,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41820], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41236;
var start = G__41237;
var end = G__41238;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41277_41826 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41278_41827 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41279_41828 = output_schema41223_41745;
var G__41280_41829 = cljs.core.deref(output_checker41235_41754);
var G__41281_41830 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41277_41826,G__41278_41827,G__41279_41828,G__41280_41829,G__41281_41830) : schema.core.fn_validator.call(null,G__41277_41826,G__41278_41827,G__41279_41828,G__41280_41829,G__41281_41830));
} else {
var temp__5804__auto___41832 = (function (){var fexpr__41282 = cljs.core.deref(output_checker41235_41754);
return (fexpr__41282.cljs$core$IFn$_invoke$arity$1 ? fexpr__41282.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41282.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41832)){
var error__37898__auto___41833 = temp__5804__auto___41832;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41833], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41223_41745,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41833], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41223_41745,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41224_41746,input_schema41228_41747,input_schema41233_41748], null)));

var ufv___41835 = schema.utils.use_fn_validation;
var output_schema41284_41836 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41285_41837 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41286_41838 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41285_41837);
}),null));
var output_checker41287_41839 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41284_41836);
}),null));
var ret__40195__auto___41840 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41288){
var validate__37896__auto__ = cljs.core.deref(ufv___41835);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41842 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41288], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41290_41843 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41291_41844 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41292_41845 = input_schema41285_41837;
var G__41293_41846 = cljs.core.deref(input_checker41286_41838);
var G__41294_41847 = args__37897__auto___41842;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41290_41843,G__41291_41844,G__41292_41845,G__41293_41846,G__41294_41847) : schema.core.fn_validator.call(null,G__41290_41843,G__41291_41844,G__41292_41845,G__41293_41846,G__41294_41847));
} else {
var temp__5804__auto___41848 = (function (){var fexpr__41295 = cljs.core.deref(input_checker41286_41838);
return (fexpr__41295.cljs$core$IFn$_invoke$arity$1 ? fexpr__41295.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41842) : fexpr__41295.call(null,args__37897__auto___41842));
})();
if(cljs.core.truth_(temp__5804__auto___41848)){
var error__37898__auto___41849 = temp__5804__auto___41848;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41849], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41285_41837,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41842,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41849], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41288;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5636__auto___41855 = num;
var i_41856 = (0);
while(true){
if((i_41856 < n__5636__auto___41855)){
(new$[i_41856] = (ba[(last - i_41856)]));

var G__41857 = (i_41856 + (1));
i_41856 = G__41857;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41297_41858 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41298_41859 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41299_41860 = output_schema41284_41836;
var G__41300_41861 = cljs.core.deref(output_checker41287_41839);
var G__41301_41862 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41297_41858,G__41298_41859,G__41299_41860,G__41300_41861,G__41301_41862) : schema.core.fn_validator.call(null,G__41297_41858,G__41298_41859,G__41299_41860,G__41300_41861,G__41301_41862));
} else {
var temp__5804__auto___41863 = (function (){var fexpr__41302 = cljs.core.deref(output_checker41287_41839);
return (fexpr__41302.cljs$core$IFn$_invoke$arity$1 ? fexpr__41302.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41302.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41863)){
var error__37898__auto___41864 = temp__5804__auto___41863;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41864], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41284_41836,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41864], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41284_41836,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41285_41837], null)));

var ufv___41866 = schema.utils.use_fn_validation;
var output_schema41303_41867 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41304_41868 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41305_41869 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41304_41868);
}),null));
var output_checker41306_41870 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41303_41867);
}),null));
var ret__40195__auto___41872 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41307,G__41308){
var validate__37896__auto__ = cljs.core.deref(ufv___41866);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41873 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41307,G__41308], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41309_41874 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41310_41875 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41311_41876 = input_schema41304_41868;
var G__41312_41877 = cljs.core.deref(input_checker41305_41869);
var G__41313_41878 = args__37897__auto___41873;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41309_41874,G__41310_41875,G__41311_41876,G__41312_41877,G__41313_41878) : schema.core.fn_validator.call(null,G__41309_41874,G__41310_41875,G__41311_41876,G__41312_41877,G__41313_41878));
} else {
var temp__5804__auto___41879 = (function (){var fexpr__41314 = cljs.core.deref(input_checker41305_41869);
return (fexpr__41314.cljs$core$IFn$_invoke$arity$1 ? fexpr__41314.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41873) : fexpr__41314.call(null,args__37897__auto___41873));
})();
if(cljs.core.truth_(temp__5804__auto___41879)){
var error__37898__auto___41881 = temp__5804__auto___41879;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41881], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41304_41868,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41873,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41881], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41307;
var fragment_size = G__41308;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__41887 = (end_offset | (0));
var G__41888 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__41887;
output = G__41888;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41316_41889 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41317_41890 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41318_41891 = output_schema41303_41867;
var G__41319_41892 = cljs.core.deref(output_checker41306_41870);
var G__41320_41893 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41316_41889,G__41317_41890,G__41318_41891,G__41319_41892,G__41320_41893) : schema.core.fn_validator.call(null,G__41316_41889,G__41317_41890,G__41318_41891,G__41319_41892,G__41320_41893));
} else {
var temp__5804__auto___41895 = (function (){var fexpr__41321 = cljs.core.deref(output_checker41306_41870);
return (fexpr__41321.cljs$core$IFn$_invoke$arity$1 ? fexpr__41321.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41321.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41895)){
var error__37898__auto___41896 = temp__5804__auto___41895;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41896], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41303_41867,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41896], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41303_41867,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41304_41868], null)));

var ufv___41898 = schema.utils.use_fn_validation;
var output_schema41323_41899 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41324_41900 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41325_41901 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41324_41900);
}),null));
var output_checker41326_41902 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41323_41899);
}),null));
var ret__40195__auto___41904 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an variable-length zig-zag encoded byte array and reads an integer
 * from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41327){
var validate__37896__auto__ = cljs.core.deref(ufv___41898);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41905 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41327], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41328_41907 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41329_41908 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41330_41909 = input_schema41324_41900;
var G__41331_41910 = cljs.core.deref(input_checker41325_41901);
var G__41332_41911 = args__37897__auto___41905;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41328_41907,G__41329_41908,G__41330_41909,G__41331_41910,G__41332_41911) : schema.core.fn_validator.call(null,G__41328_41907,G__41329_41908,G__41330_41909,G__41331_41910,G__41332_41911));
} else {
var temp__5804__auto___41912 = (function (){var fexpr__41334 = cljs.core.deref(input_checker41325_41901);
return (fexpr__41334.cljs$core$IFn$_invoke$arity$1 ? fexpr__41334.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41905) : fexpr__41334.call(null,args__37897__auto___41905));
})();
if(cljs.core.truth_(temp__5804__auto___41912)){
var error__37898__auto___41915 = temp__5804__auto___41912;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41915], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41324_41900,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41905,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41915], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41327;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__41920 = (n + (1));
var G__41921 = (i__$1 | (0));
var G__41922 = (out__$1 | (0));
n = G__41920;
i = G__41921;
out = G__41922;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41335_41924 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41336_41925 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41337_41926 = output_schema41323_41899;
var G__41338_41927 = cljs.core.deref(output_checker41326_41902);
var G__41339_41928 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41335_41924,G__41336_41925,G__41337_41926,G__41338_41927,G__41339_41928) : schema.core.fn_validator.call(null,G__41335_41924,G__41336_41925,G__41337_41926,G__41338_41927,G__41339_41928));
} else {
var temp__5804__auto___41929 = (function (){var fexpr__41340 = cljs.core.deref(output_checker41326_41902);
return (fexpr__41340.cljs$core$IFn$_invoke$arity$1 ? fexpr__41340.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41340.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41929)){
var error__37898__auto___41930 = temp__5804__auto___41929;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41930], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41323_41899,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41930], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41323_41899,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41324_41900], null)));

var ufv___41931 = schema.utils.use_fn_validation;
var output_schema41342_41932 = deercreeklabs.baracus.ByteArray;
var input_schema41343_41933 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41344_41934 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41343_41933);
}),null));
var output_checker41345_41935 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41342_41932);
}),null));
var ret__40195__auto___41936 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Encodes an integer using variable length zig-zag coding.
 * Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41346){
var validate__37896__auto__ = cljs.core.deref(ufv___41931);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41937 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41346], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41347_41939 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41348_41940 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41349_41941 = input_schema41343_41933;
var G__41350_41942 = cljs.core.deref(input_checker41344_41934);
var G__41351_41943 = args__37897__auto___41937;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41347_41939,G__41348_41940,G__41349_41941,G__41350_41942,G__41351_41943) : schema.core.fn_validator.call(null,G__41347_41939,G__41348_41940,G__41349_41941,G__41350_41942,G__41351_41943));
} else {
var temp__5804__auto___41945 = (function (){var fexpr__41352 = cljs.core.deref(input_checker41344_41934);
return (fexpr__41352.cljs$core$IFn$_invoke$arity$1 ? fexpr__41352.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41937) : fexpr__41352.call(null,args__37897__auto___41937));
})();
if(cljs.core.truth_(temp__5804__auto___41945)){
var error__37898__auto___41946 = temp__5804__auto___41945;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41946], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41343_41933,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41937,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41946], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var i = G__41346;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__41950 = (n >>> (7));
var G__41951 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__41950;
out = G__41951;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41354_41953 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41355_41954 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41356_41955 = output_schema41342_41932;
var G__41357_41956 = cljs.core.deref(output_checker41345_41935);
var G__41358_41957 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41354_41953,G__41355_41954,G__41356_41955,G__41357_41956,G__41358_41957) : schema.core.fn_validator.call(null,G__41354_41953,G__41355_41954,G__41356_41955,G__41357_41956,G__41358_41957));
} else {
var temp__5804__auto___41958 = (function (){var fexpr__41359 = cljs.core.deref(output_checker41345_41935);
return (fexpr__41359.cljs$core$IFn$_invoke$arity$1 ? fexpr__41359.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41359.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41958)){
var error__37898__auto___41959 = temp__5804__auto___41958;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41959], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41342_41932,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41959], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41342_41932,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41343_41933], null)));

var ufv___41962 = schema.utils.use_fn_validation;
var output_schema41360_41963 = schema.core.maybe(schema.core.Str);
var input_schema41361_41964 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41362_41965 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41361_41964);
}),null));
var output_checker41363_41966 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41360_41963);
}),null));
var ret__40195__auto___41967 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41364){
var validate__37896__auto__ = cljs.core.deref(ufv___41962);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41968 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41364], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41366_41969 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41367_41970 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41368_41971 = input_schema41361_41964;
var G__41369_41972 = cljs.core.deref(input_checker41362_41965);
var G__41370_41973 = args__37897__auto___41968;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41366_41969,G__41367_41970,G__41368_41971,G__41369_41972,G__41370_41973) : schema.core.fn_validator.call(null,G__41366_41969,G__41367_41970,G__41368_41971,G__41369_41972,G__41370_41973));
} else {
var temp__5804__auto___41974 = (function (){var fexpr__41371 = cljs.core.deref(input_checker41362_41965);
return (fexpr__41371.cljs$core$IFn$_invoke$arity$1 ? fexpr__41371.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41968) : fexpr__41371.call(null,args__37897__auto___41968));
})();
if(cljs.core.truth_(temp__5804__auto___41974)){
var error__37898__auto___41975 = temp__5804__auto___41974;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41975], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41361_41964,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41968,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41975], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var b = G__41364;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41373_41976 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41374_41977 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41375_41978 = output_schema41360_41963;
var G__41376_41979 = cljs.core.deref(output_checker41363_41966);
var G__41377_41980 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41373_41976,G__41374_41977,G__41375_41978,G__41376_41979,G__41377_41980) : schema.core.fn_validator.call(null,G__41373_41976,G__41374_41977,G__41375_41978,G__41376_41979,G__41377_41980));
} else {
var temp__5804__auto___41981 = (function (){var fexpr__41378 = cljs.core.deref(output_checker41363_41966);
return (fexpr__41378.cljs$core$IFn$_invoke$arity$1 ? fexpr__41378.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41378.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41981)){
var error__37898__auto___41982 = temp__5804__auto___41981;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41982], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41360_41963,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41982], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41360_41963,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41361_41964], null)));

var ufv___41983 = schema.utils.use_fn_validation;
var output_schema41382_41984 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41383_41985 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41384_41986 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41383_41985);
}),null));
var output_checker41385_41987 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41382_41984);
}),null));
var ret__40195__auto___41988 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41386){
var validate__37896__auto__ = cljs.core.deref(ufv___41983);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___41991 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41386], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41388_41992 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41389_41993 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41390_41994 = input_schema41383_41985;
var G__41391_41995 = cljs.core.deref(input_checker41384_41986);
var G__41392_41996 = args__37897__auto___41991;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41388_41992,G__41389_41993,G__41390_41994,G__41391_41995,G__41392_41996) : schema.core.fn_validator.call(null,G__41388_41992,G__41389_41993,G__41390_41994,G__41391_41995,G__41392_41996));
} else {
var temp__5804__auto___41997 = (function (){var fexpr__41393 = cljs.core.deref(input_checker41384_41986);
return (fexpr__41393.cljs$core$IFn$_invoke$arity$1 ? fexpr__41393.cljs$core$IFn$_invoke$arity$1(args__37897__auto___41991) : fexpr__41393.call(null,args__37897__auto___41991));
})();
if(cljs.core.truth_(temp__5804__auto___41997)){
var error__37898__auto___41999 = temp__5804__auto___41997;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___41999], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41383_41985,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___41991,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___41999], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var s = G__41386;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41394_42003 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41395_42004 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41396_42005 = output_schema41382_41984;
var G__41397_42006 = cljs.core.deref(output_checker41385_41987);
var G__41398_42007 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41394_42003,G__41395_42004,G__41396_42005,G__41397_42006,G__41398_42007) : schema.core.fn_validator.call(null,G__41394_42003,G__41395_42004,G__41396_42005,G__41397_42006,G__41398_42007));
} else {
var temp__5804__auto___42008 = (function (){var fexpr__41403 = cljs.core.deref(output_checker41385_41987);
return (fexpr__41403.cljs$core$IFn$_invoke$arity$1 ? fexpr__41403.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41403.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42008)){
var error__37898__auto___42010 = temp__5804__auto___42008;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42010], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41382_41984,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42010], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41382_41984,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41383_41985], null)));

var ufv___42012 = schema.utils.use_fn_validation;
var output_schema41406_42013 = schema.core.maybe(schema.core.Str);
var input_schema41407_42014 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41408_42015 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41407_42014);
}),null));
var output_checker41409_42016 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41406_42013);
}),null));
var ret__40195__auto___42017 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41410){
var validate__37896__auto__ = cljs.core.deref(ufv___42012);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42018 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41410], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41412_42019 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41413_42020 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41414_42021 = input_schema41407_42014;
var G__41415_42022 = cljs.core.deref(input_checker41408_42015);
var G__41416_42023 = args__37897__auto___42018;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41412_42019,G__41413_42020,G__41414_42021,G__41415_42022,G__41416_42023) : schema.core.fn_validator.call(null,G__41412_42019,G__41413_42020,G__41414_42021,G__41415_42022,G__41416_42023));
} else {
var temp__5804__auto___42024 = (function (){var fexpr__41418 = cljs.core.deref(input_checker41408_42015);
return (fexpr__41418.cljs$core$IFn$_invoke$arity$1 ? fexpr__41418.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42018) : fexpr__41418.call(null,args__37897__auto___42018));
})();
if(cljs.core.truth_(temp__5804__auto___42024)){
var error__37898__auto___42025 = temp__5804__auto___42024;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42025], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41407_42014,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42018,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42025], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41410;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41419_42026 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41420_42027 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41421_42028 = output_schema41406_42013;
var G__41422_42029 = cljs.core.deref(output_checker41409_42016);
var G__41423_42030 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41419_42026,G__41420_42027,G__41421_42028,G__41422_42029,G__41423_42030) : schema.core.fn_validator.call(null,G__41419_42026,G__41420_42027,G__41421_42028,G__41422_42029,G__41423_42030));
} else {
var temp__5804__auto___42031 = (function (){var fexpr__41425 = cljs.core.deref(output_checker41409_42016);
return (fexpr__41425.cljs$core$IFn$_invoke$arity$1 ? fexpr__41425.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41425.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42031)){
var error__37898__auto___42032 = temp__5804__auto___42031;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42032], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41406_42013,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42032], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41406_42013,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41407_42014], null)));

var ufv___42033 = schema.utils.use_fn_validation;
var output_schema41426_42034 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41427_42035 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41428_42036 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41427_42035);
}),null));
var output_checker41429_42037 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41426_42034);
}),null));
var ret__40195__auto___42038 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41430){
var validate__37896__auto__ = cljs.core.deref(ufv___42033);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42039 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41430], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41432_42040 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41433_42041 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41434_42042 = input_schema41427_42035;
var G__41435_42043 = cljs.core.deref(input_checker41428_42036);
var G__41436_42044 = args__37897__auto___42039;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41432_42040,G__41433_42041,G__41434_42042,G__41435_42043,G__41436_42044) : schema.core.fn_validator.call(null,G__41432_42040,G__41433_42041,G__41434_42042,G__41435_42043,G__41436_42044));
} else {
var temp__5804__auto___42045 = (function (){var fexpr__41437 = cljs.core.deref(input_checker41428_42036);
return (fexpr__41437.cljs$core$IFn$_invoke$arity$1 ? fexpr__41437.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42039) : fexpr__41437.call(null,args__37897__auto___42039));
})();
if(cljs.core.truth_(temp__5804__auto___42045)){
var error__37898__auto___42046 = temp__5804__auto___42045;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42046], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41427_42035,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42039,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42046], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var s = G__41430;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41438_42048 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41439_42049 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41440_42050 = output_schema41426_42034;
var G__41441_42051 = cljs.core.deref(output_checker41429_42037);
var G__41442_42052 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41438_42048,G__41439_42049,G__41440_42050,G__41441_42051,G__41442_42052) : schema.core.fn_validator.call(null,G__41438_42048,G__41439_42049,G__41440_42050,G__41441_42051,G__41442_42052));
} else {
var temp__5804__auto___42055 = (function (){var fexpr__41444 = cljs.core.deref(output_checker41429_42037);
return (fexpr__41444.cljs$core$IFn$_invoke$arity$1 ? fexpr__41444.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41444.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42055)){
var error__37898__auto___42057 = temp__5804__auto___42055;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42057], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41426_42034,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42057], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41426_42034,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41427_42035], null)));

deercreeklabs.baracus.byte_array__GT_hex_str_STAR_ = (function deercreeklabs$baracus$byte_array__GT_hex_str_STAR_(p__41448){
var map__41449 = p__41448;
var map__41449__$1 = cljs.core.__destructure_map(map__41449);
var alphabet = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41449__$1,new cljs.core.Keyword(null,"alphabet","alphabet",788478088));
var ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41449__$1,new cljs.core.Keyword(null,"ba","ba",-960950298));
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var ca = (new Array(((2) * len)));
var n__5636__auto___42059 = len;
var i_42060 = (0);
while(true){
if((i_42060 < n__5636__auto___42059)){
var b_42062 = ((ba[i_42060]) & (255));
var j_42063 = ((2) * i_42060);
(ca[j_42063] = (function (){var G__41451 = (b_42062 >> (4));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41451) : alphabet.call(null,G__41451));
})());

(ca[(j_42063 + (1))] = (function (){var G__41452 = (b_42062 & (15));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41452) : alphabet.call(null,G__41452));
})());

var G__42067 = (i_42060 + (1));
i_42060 = G__42067;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
});
var ufv___42068 = schema.utils.use_fn_validation;
var output_schema41453_42069 = schema.core.maybe(schema.core.Str);
var input_schema41454_42070 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41455_42071 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41454_42070);
}),null));
var output_checker41456_42072 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41453_42069);
}),null));
var ret__40195__auto___42075 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41457){
var validate__37896__auto__ = cljs.core.deref(ufv___42068);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42076 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41457], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41459_42077 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41460_42078 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41461_42079 = input_schema41454_42070;
var G__41462_42080 = cljs.core.deref(input_checker41455_42071);
var G__41463_42081 = args__37897__auto___42076;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41459_42077,G__41460_42078,G__41461_42079,G__41462_42080,G__41463_42081) : schema.core.fn_validator.call(null,G__41459_42077,G__41460_42078,G__41461_42079,G__41462_42080,G__41463_42081));
} else {
var temp__5804__auto___42084 = (function (){var fexpr__41464 = cljs.core.deref(input_checker41455_42071);
return (fexpr__41464.cljs$core$IFn$_invoke$arity$1 ? fexpr__41464.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42076) : fexpr__41464.call(null,args__37897__auto___42076));
})();
if(cljs.core.truth_(temp__5804__auto___42084)){
var error__37898__auto___42085 = temp__5804__auto___42084;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42085], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41454_42070,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42076,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42085], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41457;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41465_42087 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41466_42088 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41467_42089 = output_schema41453_42069;
var G__41468_42090 = cljs.core.deref(output_checker41456_42072);
var G__41469_42091 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41465_42087,G__41466_42088,G__41467_42089,G__41468_42090,G__41469_42091) : schema.core.fn_validator.call(null,G__41465_42087,G__41466_42088,G__41467_42089,G__41468_42090,G__41469_42091));
} else {
var temp__5804__auto___42092 = (function (){var fexpr__41470 = cljs.core.deref(output_checker41456_42072);
return (fexpr__41470.cljs$core$IFn$_invoke$arity$1 ? fexpr__41470.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41470.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42092)){
var error__37898__auto___42093 = temp__5804__auto___42092;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42093], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41453_42069,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42093], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41453_42069,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41454_42070], null)));

var ufv___42094 = schema.utils.use_fn_validation;
var output_schema41472_42095 = schema.core.maybe(schema.core.Str);
var input_schema41473_42096 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41474_42097 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41473_42096);
}),null));
var output_checker41475_42098 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41472_42095);
}),null));
var ret__40195__auto___42099 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_upper_hex_str = (function deercreeklabs$baracus$byte_array__GT_upper_hex_str(G__41476){
var validate__37896__auto__ = cljs.core.deref(ufv___42094);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42100 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41476], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41478_42101 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41479_42102 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41480_42103 = input_schema41473_42096;
var G__41481_42104 = cljs.core.deref(input_checker41474_42097);
var G__41482_42105 = args__37897__auto___42100;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41478_42101,G__41479_42102,G__41480_42103,G__41481_42104,G__41482_42105) : schema.core.fn_validator.call(null,G__41478_42101,G__41479_42102,G__41480_42103,G__41481_42104,G__41482_42105));
} else {
var temp__5804__auto___42106 = (function (){var fexpr__41483 = cljs.core.deref(input_checker41474_42097);
return (fexpr__41483.cljs$core$IFn$_invoke$arity$1 ? fexpr__41483.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42100) : fexpr__41483.call(null,args__37897__auto___42100));
})();
if(cljs.core.truth_(temp__5804__auto___42106)){
var error__37898__auto___42107 = temp__5804__auto___42106;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42107], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41473_42096,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42100,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42107], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41476;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41484_42108 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41485_42109 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41486_42110 = output_schema41472_42095;
var G__41487_42111 = cljs.core.deref(output_checker41475_42098);
var G__41488_42112 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41484_42108,G__41485_42109,G__41486_42110,G__41487_42111,G__41488_42112) : schema.core.fn_validator.call(null,G__41484_42108,G__41485_42109,G__41486_42110,G__41487_42111,G__41488_42112));
} else {
var temp__5804__auto___42113 = (function (){var fexpr__41489 = cljs.core.deref(output_checker41475_42098);
return (fexpr__41489.cljs$core$IFn$_invoke$arity$1 ? fexpr__41489.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41489.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42113)){
var error__37898__auto___42114 = temp__5804__auto___42113;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42114], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41472_42095,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42114], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_upper_hex_str),schema.core.__GT_FnSchema(output_schema41472_42095,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41473_42096], null)));

var ufv___42115 = schema.utils.use_fn_validation;
var output_schema41490_42116 = schema.core.maybe(schema.core.Str);
var input_schema41492_42117 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41493_42118 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41492_42117);
}),null));
var output_checker41494_42119 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41490_42116);
}),null));
var ret__40195__auto___42120 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_b16_alpha_str = (function deercreeklabs$baracus$byte_array__GT_b16_alpha_str(G__41495){
var validate__37896__auto__ = cljs.core.deref(ufv___42115);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42121 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41495], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41496_42122 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41497_42123 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41498_42124 = input_schema41492_42117;
var G__41499_42125 = cljs.core.deref(input_checker41493_42118);
var G__41500_42126 = args__37897__auto___42121;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41496_42122,G__41497_42123,G__41498_42124,G__41499_42125,G__41500_42126) : schema.core.fn_validator.call(null,G__41496_42122,G__41497_42123,G__41498_42124,G__41499_42125,G__41500_42126));
} else {
var temp__5804__auto___42127 = (function (){var fexpr__41504 = cljs.core.deref(input_checker41493_42118);
return (fexpr__41504.cljs$core$IFn$_invoke$arity$1 ? fexpr__41504.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42121) : fexpr__41504.call(null,args__37897__auto___42121));
})();
if(cljs.core.truth_(temp__5804__auto___42127)){
var error__37898__auto___42128 = temp__5804__auto___42127;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42128], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41492_42117,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42121,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42128], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41495;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["a","b","c","d","c","e","f","g","h","i","j","k","l","m","n","o"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41505_42129 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41506_42130 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41507_42131 = output_schema41490_42116;
var G__41508_42132 = cljs.core.deref(output_checker41494_42119);
var G__41509_42133 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41505_42129,G__41506_42130,G__41507_42131,G__41508_42132,G__41509_42133) : schema.core.fn_validator.call(null,G__41505_42129,G__41506_42130,G__41507_42131,G__41508_42132,G__41509_42133));
} else {
var temp__5804__auto___42134 = (function (){var fexpr__41511 = cljs.core.deref(output_checker41494_42119);
return (fexpr__41511.cljs$core$IFn$_invoke$arity$1 ? fexpr__41511.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41511.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42134)){
var error__37898__auto___42135 = temp__5804__auto___42134;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42135], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41490_42116,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42135], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b16_alpha_str),schema.core.__GT_FnSchema(output_schema41490_42116,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41492_42117], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42136 = schema.utils.use_fn_validation;
var output_schema41513_42137 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41514_42138 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41515_42139 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41514_42138);
}),null));
var output_checker41516_42140 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41513_42137);
}),null));
var ret__40195__auto___42141 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41517){
var validate__37896__auto__ = cljs.core.deref(ufv___42136);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42142 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41517], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41518_42143 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41519_42144 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41520_42145 = input_schema41514_42138;
var G__41521_42146 = cljs.core.deref(input_checker41515_42139);
var G__41522_42147 = args__37897__auto___42142;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41518_42143,G__41519_42144,G__41520_42145,G__41521_42146,G__41522_42147) : schema.core.fn_validator.call(null,G__41518_42143,G__41519_42144,G__41520_42145,G__41521_42146,G__41522_42147));
} else {
var temp__5804__auto___42149 = (function (){var fexpr__41524 = cljs.core.deref(input_checker41515_42139);
return (fexpr__41524.cljs$core$IFn$_invoke$arity$1 ? fexpr__41524.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42142) : fexpr__41524.call(null,args__37897__auto___42142));
})();
if(cljs.core.truth_(temp__5804__auto___42149)){
var error__37898__auto___42150 = temp__5804__auto___42149;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42150], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41514_42138,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42142,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42150], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var s = G__41517;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5636__auto___42151 = ba_len;
var i_42152 = (0);
while(true){
if((i_42152 < n__5636__auto___42151)){
var j_42153 = ((2) * i_42152);
(ba[i_42152] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42153)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42153 + (1))))));

var G__42154 = (i_42152 + (1));
i_42152 = G__42154;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41525_42155 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41526_42156 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41527_42157 = output_schema41513_42137;
var G__41528_42158 = cljs.core.deref(output_checker41516_42140);
var G__41529_42159 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41525_42155,G__41526_42156,G__41527_42157,G__41528_42158,G__41529_42159) : schema.core.fn_validator.call(null,G__41525_42155,G__41526_42156,G__41527_42157,G__41528_42158,G__41529_42159));
} else {
var temp__5804__auto___42160 = (function (){var fexpr__41530 = cljs.core.deref(output_checker41516_42140);
return (fexpr__41530.cljs$core$IFn$_invoke$arity$1 ? fexpr__41530.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41530.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42160)){
var error__37898__auto___42161 = temp__5804__auto___42160;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42161], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41513_42137,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42161], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41513_42137,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41514_42138], null)));

var ufv___42163 = schema.utils.use_fn_validation;
var output_schema41532_42164 = deercreeklabs.baracus.ByteArray;
var input_schema41533_42165 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41534_42166 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41533_42165);
}),null));
var output_checker41535_42167 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41532_42164);
}),null));
var ret__40195__auto___42168 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41536){
var validate__37896__auto__ = cljs.core.deref(ufv___42163);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42169 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41536], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41538_42170 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41539_42171 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41540_42172 = input_schema41533_42165;
var G__41541_42173 = cljs.core.deref(input_checker41534_42166);
var G__41542_42174 = args__37897__auto___42169;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41538_42170,G__41539_42171,G__41540_42172,G__41541_42173,G__41542_42174) : schema.core.fn_validator.call(null,G__41538_42170,G__41539_42171,G__41540_42172,G__41541_42173,G__41542_42174));
} else {
var temp__5804__auto___42175 = (function (){var fexpr__41543 = cljs.core.deref(input_checker41534_42166);
return (fexpr__41543.cljs$core$IFn$_invoke$arity$1 ? fexpr__41543.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42169) : fexpr__41543.call(null,args__37897__auto___42169));
})();
if(cljs.core.truth_(temp__5804__auto___42175)){
var error__37898__auto___42176 = temp__5804__auto___42175;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42176], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41533_42165,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42169,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42176], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41536;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41544_42177 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41545_42178 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41546_42179 = output_schema41532_42164;
var G__41547_42180 = cljs.core.deref(output_checker41535_42167);
var G__41548_42181 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41544_42177,G__41545_42178,G__41546_42179,G__41547_42180,G__41548_42181) : schema.core.fn_validator.call(null,G__41544_42177,G__41545_42178,G__41546_42179,G__41547_42180,G__41548_42181));
} else {
var temp__5804__auto___42182 = (function (){var fexpr__41550 = cljs.core.deref(output_checker41535_42167);
return (fexpr__41550.cljs$core$IFn$_invoke$arity$1 ? fexpr__41550.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41550.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42182)){
var error__37898__auto___42183 = temp__5804__auto___42182;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42183], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41532_42164,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42183], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41532_42164,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41533_42165], null)));

var ufv___42184 = schema.utils.use_fn_validation;
var output_schema41551_42185 = deercreeklabs.baracus.ByteArray;
var input_schema41552_42186 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41553_42187 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41552_42186);
}),null));
var output_checker41554_42188 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41551_42185);
}),null));
var ret__40195__auto___42189 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41555){
var validate__37896__auto__ = cljs.core.deref(ufv___42184);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42190 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41555], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41557_42192 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41558_42193 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41559_42194 = input_schema41552_42186;
var G__41560_42195 = cljs.core.deref(input_checker41553_42187);
var G__41561_42196 = args__37897__auto___42190;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41557_42192,G__41558_42193,G__41559_42194,G__41560_42195,G__41561_42196) : schema.core.fn_validator.call(null,G__41557_42192,G__41558_42193,G__41559_42194,G__41560_42195,G__41561_42196));
} else {
var temp__5804__auto___42198 = (function (){var fexpr__41562 = cljs.core.deref(input_checker41553_42187);
return (fexpr__41562.cljs$core$IFn$_invoke$arity$1 ? fexpr__41562.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42190) : fexpr__41562.call(null,args__37897__auto___42190));
})();
if(cljs.core.truth_(temp__5804__auto___42198)){
var error__37898__auto___42200 = temp__5804__auto___42198;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42200], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41552_42186,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42190,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42200], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41555;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41563_42202 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41564_42203 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41565_42204 = output_schema41551_42185;
var G__41566_42205 = cljs.core.deref(output_checker41554_42188);
var G__41567_42206 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41563_42202,G__41564_42203,G__41565_42204,G__41566_42205,G__41567_42206) : schema.core.fn_validator.call(null,G__41563_42202,G__41564_42203,G__41565_42204,G__41566_42205,G__41567_42206));
} else {
var temp__5804__auto___42207 = (function (){var fexpr__41568 = cljs.core.deref(output_checker41554_42188);
return (fexpr__41568.cljs$core$IFn$_invoke$arity$1 ? fexpr__41568.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41568.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42207)){
var error__37898__auto___42208 = temp__5804__auto___42207;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42208], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41551_42185,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42208], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41551_42185,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41552_42186], null)));

var ufv___42209 = schema.utils.use_fn_validation;
var output_schema41570_42210 = deercreeklabs.baracus.ByteArray;
var input_schema41571_42211 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41572_42212 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41571_42211);
}),null));
var output_checker41573_42213 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41570_42210);
}),null));
var ret__40195__auto___42214 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41574){
var validate__37896__auto__ = cljs.core.deref(ufv___42209);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___42215 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41574], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41575_42216 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41576_42217 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41577_42218 = input_schema41571_42211;
var G__41578_42219 = cljs.core.deref(input_checker41572_42212);
var G__41579_42220 = args__37897__auto___42215;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41575_42216,G__41576_42217,G__41577_42218,G__41578_42219,G__41579_42220) : schema.core.fn_validator.call(null,G__41575_42216,G__41576_42217,G__41577_42218,G__41578_42219,G__41579_42220));
} else {
var temp__5804__auto___42221 = (function (){var fexpr__41580 = cljs.core.deref(input_checker41572_42212);
return (fexpr__41580.cljs$core$IFn$_invoke$arity$1 ? fexpr__41580.cljs$core$IFn$_invoke$arity$1(args__37897__auto___42215) : fexpr__41580.call(null,args__37897__auto___42215));
})();
if(cljs.core.truth_(temp__5804__auto___42221)){
var error__37898__auto___42222 = temp__5804__auto___42221;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42222], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41571_42211,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___42215,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42222], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var ba = G__41574;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41581_42223 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41582_42224 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41583_42225 = output_schema41570_42210;
var G__41584_42226 = cljs.core.deref(output_checker41573_42213);
var G__41585_42227 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41581_42223,G__41582_42224,G__41583_42225,G__41584_42226,G__41585_42227) : schema.core.fn_validator.call(null,G__41581_42223,G__41582_42224,G__41583_42225,G__41584_42226,G__41585_42227));
} else {
var temp__5804__auto___42228 = (function (){var fexpr__41587 = cljs.core.deref(output_checker41573_42213);
return (fexpr__41587.cljs$core$IFn$_invoke$arity$1 ? fexpr__41587.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__41587.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42228)){
var error__37898__auto___42230 = temp__5804__auto___42228;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___42230], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41570_42210,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___42230], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41570_42210,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41571_42211], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
