goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31074 = arguments.length;
switch (G__31074) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31080 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31080 = (function (f,blockable,meta31081){
this.f = f;
this.blockable = blockable;
this.meta31081 = meta31081;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31082,meta31081__$1){
var self__ = this;
var _31082__$1 = this;
return (new cljs.core.async.t_cljs$core$async31080(self__.f,self__.blockable,meta31081__$1));
}));

(cljs.core.async.t_cljs$core$async31080.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31082){
var self__ = this;
var _31082__$1 = this;
return self__.meta31081;
}));

(cljs.core.async.t_cljs$core$async31080.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31080.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31080.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async31080.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async31080.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31081","meta31081",-1790069471,null)], null);
}));

(cljs.core.async.t_cljs$core$async31080.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31080.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31080");

(cljs.core.async.t_cljs$core$async31080.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31080");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31080.
 */
cljs.core.async.__GT_t_cljs$core$async31080 = (function cljs$core$async$__GT_t_cljs$core$async31080(f__$1,blockable__$1,meta31081){
return (new cljs.core.async.t_cljs$core$async31080(f__$1,blockable__$1,meta31081));
});

}

return (new cljs.core.async.t_cljs$core$async31080(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31105 = arguments.length;
switch (G__31105) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31122 = arguments.length;
switch (G__31122) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31133 = arguments.length;
switch (G__31133) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34514 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34514) : fn1.call(null,val_34514));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34514) : fn1.call(null,val_34514));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31178 = arguments.length;
switch (G__31178) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___34530 = n;
var x_34531 = (0);
while(true){
if((x_34531 < n__5636__auto___34530)){
(a[x_34531] = x_34531);

var G__34532 = (x_34531 + (1));
x_34531 = G__34532;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31179 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31179 = (function (flag,meta31180){
this.flag = flag;
this.meta31180 = meta31180;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31179.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31181,meta31180__$1){
var self__ = this;
var _31181__$1 = this;
return (new cljs.core.async.t_cljs$core$async31179(self__.flag,meta31180__$1));
}));

(cljs.core.async.t_cljs$core$async31179.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31181){
var self__ = this;
var _31181__$1 = this;
return self__.meta31180;
}));

(cljs.core.async.t_cljs$core$async31179.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31179.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31179.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31179.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async31179.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31180","meta31180",-378171813,null)], null);
}));

(cljs.core.async.t_cljs$core$async31179.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31179.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31179");

(cljs.core.async.t_cljs$core$async31179.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31179");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31179.
 */
cljs.core.async.__GT_t_cljs$core$async31179 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31179(flag__$1,meta31180){
return (new cljs.core.async.t_cljs$core$async31179(flag__$1,meta31180));
});

}

return (new cljs.core.async.t_cljs$core$async31179(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31182 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31182 = (function (flag,cb,meta31183){
this.flag = flag;
this.cb = cb;
this.meta31183 = meta31183;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31182.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31184,meta31183__$1){
var self__ = this;
var _31184__$1 = this;
return (new cljs.core.async.t_cljs$core$async31182(self__.flag,self__.cb,meta31183__$1));
}));

(cljs.core.async.t_cljs$core$async31182.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31184){
var self__ = this;
var _31184__$1 = this;
return self__.meta31183;
}));

(cljs.core.async.t_cljs$core$async31182.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31182.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31182.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31182.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async31182.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31183","meta31183",1216510202,null)], null);
}));

(cljs.core.async.t_cljs$core$async31182.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31182.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31182");

(cljs.core.async.t_cljs$core$async31182.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31182");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31182.
 */
cljs.core.async.__GT_t_cljs$core$async31182 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31182(flag__$1,cb__$1,meta31183){
return (new cljs.core.async.t_cljs$core$async31182(flag__$1,cb__$1,meta31183));
});

}

return (new cljs.core.async.t_cljs$core$async31182(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31185_SHARP_){
var G__31200 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31185_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31200) : fret.call(null,G__31200));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31186_SHARP_){
var G__31202 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31186_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31202) : fret.call(null,G__31202));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34542 = (i + (1));
i = G__34542;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34549 = arguments.length;
var i__5770__auto___34550 = (0);
while(true){
if((i__5770__auto___34550 < len__5769__auto___34549)){
args__5775__auto__.push((arguments[i__5770__auto___34550]));

var G__34551 = (i__5770__auto___34550 + (1));
i__5770__auto___34550 = G__34551;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31209){
var map__31210 = p__31209;
var map__31210__$1 = cljs.core.__destructure_map(map__31210);
var opts = map__31210__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31206){
var G__31207 = cljs.core.first(seq31206);
var seq31206__$1 = cljs.core.next(seq31206);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31207,seq31206__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31280 = arguments.length;
switch (G__31280) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30974__auto___34555 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31318){
var state_val_31319 = (state_31318[(1)]);
if((state_val_31319 === (7))){
var inst_31305 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
var statearr_31343_34556 = state_31318__$1;
(statearr_31343_34556[(2)] = inst_31305);

(statearr_31343_34556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (1))){
var state_31318__$1 = state_31318;
var statearr_31344_34558 = state_31318__$1;
(statearr_31344_34558[(2)] = null);

(statearr_31344_34558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (4))){
var inst_31285 = (state_31318[(7)]);
var inst_31285__$1 = (state_31318[(2)]);
var inst_31286 = (inst_31285__$1 == null);
var state_31318__$1 = (function (){var statearr_31345 = state_31318;
(statearr_31345[(7)] = inst_31285__$1);

return statearr_31345;
})();
if(cljs.core.truth_(inst_31286)){
var statearr_31346_34562 = state_31318__$1;
(statearr_31346_34562[(1)] = (5));

} else {
var statearr_31347_34563 = state_31318__$1;
(statearr_31347_34563[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (13))){
var state_31318__$1 = state_31318;
var statearr_31348_34564 = state_31318__$1;
(statearr_31348_34564[(2)] = null);

(statearr_31348_34564[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (6))){
var inst_31285 = (state_31318[(7)]);
var state_31318__$1 = state_31318;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31318__$1,(11),to,inst_31285);
} else {
if((state_val_31319 === (3))){
var inst_31308 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31318__$1,inst_31308);
} else {
if((state_val_31319 === (12))){
var state_31318__$1 = state_31318;
var statearr_31351_34568 = state_31318__$1;
(statearr_31351_34568[(2)] = null);

(statearr_31351_34568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (2))){
var state_31318__$1 = state_31318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31318__$1,(4),from);
} else {
if((state_val_31319 === (11))){
var inst_31298 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
if(cljs.core.truth_(inst_31298)){
var statearr_31354_34569 = state_31318__$1;
(statearr_31354_34569[(1)] = (12));

} else {
var statearr_31359_34570 = state_31318__$1;
(statearr_31359_34570[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (9))){
var state_31318__$1 = state_31318;
var statearr_31360_34571 = state_31318__$1;
(statearr_31360_34571[(2)] = null);

(statearr_31360_34571[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (5))){
var state_31318__$1 = state_31318;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31361_34572 = state_31318__$1;
(statearr_31361_34572[(1)] = (8));

} else {
var statearr_31362_34573 = state_31318__$1;
(statearr_31362_34573[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (14))){
var inst_31303 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
var statearr_31363_34577 = state_31318__$1;
(statearr_31363_34577[(2)] = inst_31303);

(statearr_31363_34577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (10))){
var inst_31294 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
var statearr_31367_34579 = state_31318__$1;
(statearr_31367_34579[(2)] = inst_31294);

(statearr_31367_34579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (8))){
var inst_31289 = cljs.core.async.close_BANG_(to);
var state_31318__$1 = state_31318;
var statearr_31368_34580 = state_31318__$1;
(statearr_31368_34580[(2)] = inst_31289);

(statearr_31368_34580[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_31370 = [null,null,null,null,null,null,null,null];
(statearr_31370[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_31370[(1)] = (1));

return statearr_31370;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_31318){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31318);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31372){var ex__30606__auto__ = e31372;
var statearr_31373_34582 = state_31318;
(statearr_31373_34582[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31318[(4)]))){
var statearr_31374_34583 = state_31318;
(statearr_31374_34583[(1)] = cljs.core.first((state_31318[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34585 = state_31318;
state_31318 = G__34585;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_31318){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_31318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31379 = f__30975__auto__();
(statearr_31379[(6)] = c__30974__auto___34555);

return statearr_31379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__31390){
var vec__31391 = p__31390;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31391,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31391,(1),null);
var job = vec__31391;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30974__auto___34586 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31398){
var state_val_31399 = (state_31398[(1)]);
if((state_val_31399 === (1))){
var state_31398__$1 = state_31398;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31398__$1,(2),res,v);
} else {
if((state_val_31399 === (2))){
var inst_31395 = (state_31398[(2)]);
var inst_31396 = cljs.core.async.close_BANG_(res);
var state_31398__$1 = (function (){var statearr_31406 = state_31398;
(statearr_31406[(7)] = inst_31395);

return statearr_31406;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31398__$1,inst_31396);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0 = (function (){
var statearr_31408 = [null,null,null,null,null,null,null,null];
(statearr_31408[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__);

(statearr_31408[(1)] = (1));

return statearr_31408;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1 = (function (state_31398){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31398);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31409){var ex__30606__auto__ = e31409;
var statearr_31411_34591 = state_31398;
(statearr_31411_34591[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31398[(4)]))){
var statearr_31413_34592 = state_31398;
(statearr_31413_34592[(1)] = cljs.core.first((state_31398[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34593 = state_31398;
state_31398 = G__34593;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = function(state_31398){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1.call(this,state_31398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31415 = f__30975__auto__();
(statearr_31415[(6)] = c__30974__auto___34586);

return statearr_31415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31416){
var vec__31417 = p__31416;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31417,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31417,(1),null);
var job = vec__31417;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___34595 = n;
var __34597 = (0);
while(true){
if((__34597 < n__5636__auto___34595)){
var G__31420_34599 = type;
var G__31420_34600__$1 = (((G__31420_34599 instanceof cljs.core.Keyword))?G__31420_34599.fqn:null);
switch (G__31420_34600__$1) {
case "compute":
var c__30974__auto___34602 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34597,c__30974__auto___34602,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async){
return (function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = ((function (__34597,c__30974__auto___34602,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async){
return (function (state_31435){
var state_val_31436 = (state_31435[(1)]);
if((state_val_31436 === (1))){
var state_31435__$1 = state_31435;
var statearr_31439_34604 = state_31435__$1;
(statearr_31439_34604[(2)] = null);

(statearr_31439_34604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31436 === (2))){
var state_31435__$1 = state_31435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31435__$1,(4),jobs);
} else {
if((state_val_31436 === (3))){
var inst_31433 = (state_31435[(2)]);
var state_31435__$1 = state_31435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31435__$1,inst_31433);
} else {
if((state_val_31436 === (4))){
var inst_31425 = (state_31435[(2)]);
var inst_31426 = process__$1(inst_31425);
var state_31435__$1 = state_31435;
if(cljs.core.truth_(inst_31426)){
var statearr_31448_34620 = state_31435__$1;
(statearr_31448_34620[(1)] = (5));

} else {
var statearr_31450_34621 = state_31435__$1;
(statearr_31450_34621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31436 === (5))){
var state_31435__$1 = state_31435;
var statearr_31451_34622 = state_31435__$1;
(statearr_31451_34622[(2)] = null);

(statearr_31451_34622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31436 === (6))){
var state_31435__$1 = state_31435;
var statearr_31452_34623 = state_31435__$1;
(statearr_31452_34623[(2)] = null);

(statearr_31452_34623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31436 === (7))){
var inst_31431 = (state_31435[(2)]);
var state_31435__$1 = state_31435;
var statearr_31456_34624 = state_31435__$1;
(statearr_31456_34624[(2)] = inst_31431);

(statearr_31456_34624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34597,c__30974__auto___34602,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async))
;
return ((function (__34597,switch__30602__auto__,c__30974__auto___34602,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0 = (function (){
var statearr_31460 = [null,null,null,null,null,null,null];
(statearr_31460[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__);

(statearr_31460[(1)] = (1));

return statearr_31460;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1 = (function (state_31435){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31435);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31464){var ex__30606__auto__ = e31464;
var statearr_31465_34636 = state_31435;
(statearr_31465_34636[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31435[(4)]))){
var statearr_31466_34637 = state_31435;
(statearr_31466_34637[(1)] = cljs.core.first((state_31435[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34638 = state_31435;
state_31435 = G__34638;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = function(state_31435){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1.call(this,state_31435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__;
})()
;})(__34597,switch__30602__auto__,c__30974__auto___34602,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async))
})();
var state__30976__auto__ = (function (){var statearr_31470 = f__30975__auto__();
(statearr_31470[(6)] = c__30974__auto___34602);

return statearr_31470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
});})(__34597,c__30974__auto___34602,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async))
);


break;
case "async":
var c__30974__auto___34639 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34597,c__30974__auto___34639,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async){
return (function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = ((function (__34597,c__30974__auto___34639,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async){
return (function (state_31483){
var state_val_31484 = (state_31483[(1)]);
if((state_val_31484 === (1))){
var state_31483__$1 = state_31483;
var statearr_31485_34647 = state_31483__$1;
(statearr_31485_34647[(2)] = null);

(statearr_31485_34647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31484 === (2))){
var state_31483__$1 = state_31483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31483__$1,(4),jobs);
} else {
if((state_val_31484 === (3))){
var inst_31481 = (state_31483[(2)]);
var state_31483__$1 = state_31483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31483__$1,inst_31481);
} else {
if((state_val_31484 === (4))){
var inst_31473 = (state_31483[(2)]);
var inst_31474 = async(inst_31473);
var state_31483__$1 = state_31483;
if(cljs.core.truth_(inst_31474)){
var statearr_31486_34655 = state_31483__$1;
(statearr_31486_34655[(1)] = (5));

} else {
var statearr_31487_34660 = state_31483__$1;
(statearr_31487_34660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31484 === (5))){
var state_31483__$1 = state_31483;
var statearr_31494_34664 = state_31483__$1;
(statearr_31494_34664[(2)] = null);

(statearr_31494_34664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31484 === (6))){
var state_31483__$1 = state_31483;
var statearr_31495_34665 = state_31483__$1;
(statearr_31495_34665[(2)] = null);

(statearr_31495_34665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31484 === (7))){
var inst_31479 = (state_31483[(2)]);
var state_31483__$1 = state_31483;
var statearr_31500_34674 = state_31483__$1;
(statearr_31500_34674[(2)] = inst_31479);

(statearr_31500_34674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34597,c__30974__auto___34639,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async))
;
return ((function (__34597,switch__30602__auto__,c__30974__auto___34639,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0 = (function (){
var statearr_31502 = [null,null,null,null,null,null,null];
(statearr_31502[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__);

(statearr_31502[(1)] = (1));

return statearr_31502;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1 = (function (state_31483){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31483);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31503){var ex__30606__auto__ = e31503;
var statearr_31504_34697 = state_31483;
(statearr_31504_34697[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31483[(4)]))){
var statearr_31505_34705 = state_31483;
(statearr_31505_34705[(1)] = cljs.core.first((state_31483[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34710 = state_31483;
state_31483 = G__34710;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = function(state_31483){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1.call(this,state_31483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__;
})()
;})(__34597,switch__30602__auto__,c__30974__auto___34639,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async))
})();
var state__30976__auto__ = (function (){var statearr_31511 = f__30975__auto__();
(statearr_31511[(6)] = c__30974__auto___34639);

return statearr_31511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
});})(__34597,c__30974__auto___34639,G__31420_34599,G__31420_34600__$1,n__5636__auto___34595,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31420_34600__$1)].join('')));

}

var G__34712 = (__34597 + (1));
__34597 = G__34712;
continue;
} else {
}
break;
}

var c__30974__auto___34713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31552){
var state_val_31553 = (state_31552[(1)]);
if((state_val_31553 === (7))){
var inst_31546 = (state_31552[(2)]);
var state_31552__$1 = state_31552;
var statearr_31567_34714 = state_31552__$1;
(statearr_31567_34714[(2)] = inst_31546);

(statearr_31567_34714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31553 === (1))){
var state_31552__$1 = state_31552;
var statearr_31568_34715 = state_31552__$1;
(statearr_31568_34715[(2)] = null);

(statearr_31568_34715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31553 === (4))){
var inst_31523 = (state_31552[(7)]);
var inst_31523__$1 = (state_31552[(2)]);
var inst_31524 = (inst_31523__$1 == null);
var state_31552__$1 = (function (){var statearr_31569 = state_31552;
(statearr_31569[(7)] = inst_31523__$1);

return statearr_31569;
})();
if(cljs.core.truth_(inst_31524)){
var statearr_31570_34717 = state_31552__$1;
(statearr_31570_34717[(1)] = (5));

} else {
var statearr_31571_34718 = state_31552__$1;
(statearr_31571_34718[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31553 === (6))){
var inst_31528 = (state_31552[(8)]);
var inst_31523 = (state_31552[(7)]);
var inst_31528__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31538 = [inst_31523,inst_31528__$1];
var inst_31539 = (new cljs.core.PersistentVector(null,2,(5),inst_31537,inst_31538,null));
var state_31552__$1 = (function (){var statearr_31572 = state_31552;
(statearr_31572[(8)] = inst_31528__$1);

return statearr_31572;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31552__$1,(8),jobs,inst_31539);
} else {
if((state_val_31553 === (3))){
var inst_31548 = (state_31552[(2)]);
var state_31552__$1 = state_31552;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31552__$1,inst_31548);
} else {
if((state_val_31553 === (2))){
var state_31552__$1 = state_31552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31552__$1,(4),from);
} else {
if((state_val_31553 === (9))){
var inst_31543 = (state_31552[(2)]);
var state_31552__$1 = (function (){var statearr_31573 = state_31552;
(statearr_31573[(9)] = inst_31543);

return statearr_31573;
})();
var statearr_31574_34728 = state_31552__$1;
(statearr_31574_34728[(2)] = null);

(statearr_31574_34728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31553 === (5))){
var inst_31526 = cljs.core.async.close_BANG_(jobs);
var state_31552__$1 = state_31552;
var statearr_31575_34730 = state_31552__$1;
(statearr_31575_34730[(2)] = inst_31526);

(statearr_31575_34730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31553 === (8))){
var inst_31528 = (state_31552[(8)]);
var inst_31541 = (state_31552[(2)]);
var state_31552__$1 = (function (){var statearr_31576 = state_31552;
(statearr_31576[(10)] = inst_31541);

return statearr_31576;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31552__$1,(9),results,inst_31528);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0 = (function (){
var statearr_31577 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31577[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__);

(statearr_31577[(1)] = (1));

return statearr_31577;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1 = (function (state_31552){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31552);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31578){var ex__30606__auto__ = e31578;
var statearr_31579_34732 = state_31552;
(statearr_31579_34732[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31552[(4)]))){
var statearr_31580_34733 = state_31552;
(statearr_31580_34733[(1)] = cljs.core.first((state_31552[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34734 = state_31552;
state_31552 = G__34734;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = function(state_31552){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1.call(this,state_31552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31582 = f__30975__auto__();
(statearr_31582[(6)] = c__30974__auto___34713);

return statearr_31582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


var c__30974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31621){
var state_val_31622 = (state_31621[(1)]);
if((state_val_31622 === (7))){
var inst_31617 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
var statearr_31625_34738 = state_31621__$1;
(statearr_31625_34738[(2)] = inst_31617);

(statearr_31625_34738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (20))){
var state_31621__$1 = state_31621;
var statearr_31626_34741 = state_31621__$1;
(statearr_31626_34741[(2)] = null);

(statearr_31626_34741[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (1))){
var state_31621__$1 = state_31621;
var statearr_31627_34743 = state_31621__$1;
(statearr_31627_34743[(2)] = null);

(statearr_31627_34743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (4))){
var inst_31585 = (state_31621[(7)]);
var inst_31585__$1 = (state_31621[(2)]);
var inst_31586 = (inst_31585__$1 == null);
var state_31621__$1 = (function (){var statearr_31628 = state_31621;
(statearr_31628[(7)] = inst_31585__$1);

return statearr_31628;
})();
if(cljs.core.truth_(inst_31586)){
var statearr_31629_34747 = state_31621__$1;
(statearr_31629_34747[(1)] = (5));

} else {
var statearr_31630_34749 = state_31621__$1;
(statearr_31630_34749[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (15))){
var inst_31599 = (state_31621[(8)]);
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31621__$1,(18),to,inst_31599);
} else {
if((state_val_31622 === (21))){
var inst_31612 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
var statearr_31631_34751 = state_31621__$1;
(statearr_31631_34751[(2)] = inst_31612);

(statearr_31631_34751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (13))){
var inst_31614 = (state_31621[(2)]);
var state_31621__$1 = (function (){var statearr_31632 = state_31621;
(statearr_31632[(9)] = inst_31614);

return statearr_31632;
})();
var statearr_31633_34753 = state_31621__$1;
(statearr_31633_34753[(2)] = null);

(statearr_31633_34753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (6))){
var inst_31585 = (state_31621[(7)]);
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31621__$1,(11),inst_31585);
} else {
if((state_val_31622 === (17))){
var inst_31607 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
if(cljs.core.truth_(inst_31607)){
var statearr_31644_34755 = state_31621__$1;
(statearr_31644_34755[(1)] = (19));

} else {
var statearr_31645_34756 = state_31621__$1;
(statearr_31645_34756[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (3))){
var inst_31619 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31621__$1,inst_31619);
} else {
if((state_val_31622 === (12))){
var inst_31596 = (state_31621[(10)]);
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31621__$1,(14),inst_31596);
} else {
if((state_val_31622 === (2))){
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31621__$1,(4),results);
} else {
if((state_val_31622 === (19))){
var state_31621__$1 = state_31621;
var statearr_31659_34757 = state_31621__$1;
(statearr_31659_34757[(2)] = null);

(statearr_31659_34757[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (11))){
var inst_31596 = (state_31621[(2)]);
var state_31621__$1 = (function (){var statearr_31660 = state_31621;
(statearr_31660[(10)] = inst_31596);

return statearr_31660;
})();
var statearr_31661_34758 = state_31621__$1;
(statearr_31661_34758[(2)] = null);

(statearr_31661_34758[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (9))){
var state_31621__$1 = state_31621;
var statearr_31662_34759 = state_31621__$1;
(statearr_31662_34759[(2)] = null);

(statearr_31662_34759[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (5))){
var state_31621__$1 = state_31621;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31663_34760 = state_31621__$1;
(statearr_31663_34760[(1)] = (8));

} else {
var statearr_31664_34765 = state_31621__$1;
(statearr_31664_34765[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (14))){
var inst_31599 = (state_31621[(8)]);
var inst_31601 = (state_31621[(11)]);
var inst_31599__$1 = (state_31621[(2)]);
var inst_31600 = (inst_31599__$1 == null);
var inst_31601__$1 = cljs.core.not(inst_31600);
var state_31621__$1 = (function (){var statearr_31666 = state_31621;
(statearr_31666[(8)] = inst_31599__$1);

(statearr_31666[(11)] = inst_31601__$1);

return statearr_31666;
})();
if(inst_31601__$1){
var statearr_31676_34766 = state_31621__$1;
(statearr_31676_34766[(1)] = (15));

} else {
var statearr_31677_34767 = state_31621__$1;
(statearr_31677_34767[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (16))){
var inst_31601 = (state_31621[(11)]);
var state_31621__$1 = state_31621;
var statearr_31679_34768 = state_31621__$1;
(statearr_31679_34768[(2)] = inst_31601);

(statearr_31679_34768[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (10))){
var inst_31593 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
var statearr_31681_34770 = state_31621__$1;
(statearr_31681_34770[(2)] = inst_31593);

(statearr_31681_34770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (18))){
var inst_31604 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
var statearr_31682_34773 = state_31621__$1;
(statearr_31682_34773[(2)] = inst_31604);

(statearr_31682_34773[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31622 === (8))){
var inst_31590 = cljs.core.async.close_BANG_(to);
var state_31621__$1 = state_31621;
var statearr_31687_34774 = state_31621__$1;
(statearr_31687_34774[(2)] = inst_31590);

(statearr_31687_34774[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0 = (function (){
var statearr_31690 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31690[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__);

(statearr_31690[(1)] = (1));

return statearr_31690;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1 = (function (state_31621){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31621);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31692){var ex__30606__auto__ = e31692;
var statearr_31694_34776 = state_31621;
(statearr_31694_34776[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31621[(4)]))){
var statearr_31696_34777 = state_31621;
(statearr_31696_34777[(1)] = cljs.core.first((state_31621[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34778 = state_31621;
state_31621 = G__34778;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__ = function(state_31621){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1.call(this,state_31621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30603__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31705 = f__30975__auto__();
(statearr_31705[(6)] = c__30974__auto__);

return statearr_31705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

return c__30974__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31724 = arguments.length;
switch (G__31724) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31744 = arguments.length;
switch (G__31744) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31779 = arguments.length;
switch (G__31779) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30974__auto___34793 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31825){
var state_val_31826 = (state_31825[(1)]);
if((state_val_31826 === (7))){
var inst_31821 = (state_31825[(2)]);
var state_31825__$1 = state_31825;
var statearr_31829_34794 = state_31825__$1;
(statearr_31829_34794[(2)] = inst_31821);

(statearr_31829_34794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (1))){
var state_31825__$1 = state_31825;
var statearr_31830_34795 = state_31825__$1;
(statearr_31830_34795[(2)] = null);

(statearr_31830_34795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (4))){
var inst_31802 = (state_31825[(7)]);
var inst_31802__$1 = (state_31825[(2)]);
var inst_31803 = (inst_31802__$1 == null);
var state_31825__$1 = (function (){var statearr_31831 = state_31825;
(statearr_31831[(7)] = inst_31802__$1);

return statearr_31831;
})();
if(cljs.core.truth_(inst_31803)){
var statearr_31832_34796 = state_31825__$1;
(statearr_31832_34796[(1)] = (5));

} else {
var statearr_31833_34797 = state_31825__$1;
(statearr_31833_34797[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (13))){
var state_31825__$1 = state_31825;
var statearr_31834_34798 = state_31825__$1;
(statearr_31834_34798[(2)] = null);

(statearr_31834_34798[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (6))){
var inst_31802 = (state_31825[(7)]);
var inst_31808 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31802) : p.call(null,inst_31802));
var state_31825__$1 = state_31825;
if(cljs.core.truth_(inst_31808)){
var statearr_31835_34799 = state_31825__$1;
(statearr_31835_34799[(1)] = (9));

} else {
var statearr_31836_34800 = state_31825__$1;
(statearr_31836_34800[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (3))){
var inst_31823 = (state_31825[(2)]);
var state_31825__$1 = state_31825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31825__$1,inst_31823);
} else {
if((state_val_31826 === (12))){
var state_31825__$1 = state_31825;
var statearr_31845_34801 = state_31825__$1;
(statearr_31845_34801[(2)] = null);

(statearr_31845_34801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (2))){
var state_31825__$1 = state_31825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31825__$1,(4),ch);
} else {
if((state_val_31826 === (11))){
var inst_31802 = (state_31825[(7)]);
var inst_31812 = (state_31825[(2)]);
var state_31825__$1 = state_31825;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31825__$1,(8),inst_31812,inst_31802);
} else {
if((state_val_31826 === (9))){
var state_31825__$1 = state_31825;
var statearr_31859_34806 = state_31825__$1;
(statearr_31859_34806[(2)] = tc);

(statearr_31859_34806[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (5))){
var inst_31805 = cljs.core.async.close_BANG_(tc);
var inst_31806 = cljs.core.async.close_BANG_(fc);
var state_31825__$1 = (function (){var statearr_31860 = state_31825;
(statearr_31860[(8)] = inst_31805);

return statearr_31860;
})();
var statearr_31861_34810 = state_31825__$1;
(statearr_31861_34810[(2)] = inst_31806);

(statearr_31861_34810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (14))){
var inst_31819 = (state_31825[(2)]);
var state_31825__$1 = state_31825;
var statearr_31863_34812 = state_31825__$1;
(statearr_31863_34812[(2)] = inst_31819);

(statearr_31863_34812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (10))){
var state_31825__$1 = state_31825;
var statearr_31864_34813 = state_31825__$1;
(statearr_31864_34813[(2)] = fc);

(statearr_31864_34813[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31826 === (8))){
var inst_31814 = (state_31825[(2)]);
var state_31825__$1 = state_31825;
if(cljs.core.truth_(inst_31814)){
var statearr_31865_34814 = state_31825__$1;
(statearr_31865_34814[(1)] = (12));

} else {
var statearr_31866_34815 = state_31825__$1;
(statearr_31866_34815[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_31885 = [null,null,null,null,null,null,null,null,null];
(statearr_31885[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_31885[(1)] = (1));

return statearr_31885;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_31825){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31825);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31887){var ex__30606__auto__ = e31887;
var statearr_31888_34819 = state_31825;
(statearr_31888_34819[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31825[(4)]))){
var statearr_31889_34820 = state_31825;
(statearr_31889_34820[(1)] = cljs.core.first((state_31825[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34821 = state_31825;
state_31825 = G__34821;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_31825){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_31825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31892 = f__30975__auto__();
(statearr_31892[(6)] = c__30974__auto___34793);

return statearr_31892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31924){
var state_val_31925 = (state_31924[(1)]);
if((state_val_31925 === (7))){
var inst_31920 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31926_34825 = state_31924__$1;
(statearr_31926_34825[(2)] = inst_31920);

(statearr_31926_34825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (1))){
var inst_31896 = init;
var inst_31899 = inst_31896;
var state_31924__$1 = (function (){var statearr_31931 = state_31924;
(statearr_31931[(7)] = inst_31899);

return statearr_31931;
})();
var statearr_31932_34826 = state_31924__$1;
(statearr_31932_34826[(2)] = null);

(statearr_31932_34826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (4))){
var inst_31907 = (state_31924[(8)]);
var inst_31907__$1 = (state_31924[(2)]);
var inst_31908 = (inst_31907__$1 == null);
var state_31924__$1 = (function (){var statearr_31933 = state_31924;
(statearr_31933[(8)] = inst_31907__$1);

return statearr_31933;
})();
if(cljs.core.truth_(inst_31908)){
var statearr_31934_34831 = state_31924__$1;
(statearr_31934_34831[(1)] = (5));

} else {
var statearr_31935_34832 = state_31924__$1;
(statearr_31935_34832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (6))){
var inst_31907 = (state_31924[(8)]);
var inst_31899 = (state_31924[(7)]);
var inst_31911 = (state_31924[(9)]);
var inst_31911__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31899,inst_31907) : f.call(null,inst_31899,inst_31907));
var inst_31912 = cljs.core.reduced_QMARK_(inst_31911__$1);
var state_31924__$1 = (function (){var statearr_31936 = state_31924;
(statearr_31936[(9)] = inst_31911__$1);

return statearr_31936;
})();
if(inst_31912){
var statearr_31938_34834 = state_31924__$1;
(statearr_31938_34834[(1)] = (8));

} else {
var statearr_31939_34835 = state_31924__$1;
(statearr_31939_34835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (3))){
var inst_31922 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31924__$1,inst_31922);
} else {
if((state_val_31925 === (2))){
var state_31924__$1 = state_31924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31924__$1,(4),ch);
} else {
if((state_val_31925 === (9))){
var inst_31911 = (state_31924[(9)]);
var inst_31899 = inst_31911;
var state_31924__$1 = (function (){var statearr_31940 = state_31924;
(statearr_31940[(7)] = inst_31899);

return statearr_31940;
})();
var statearr_31945_34840 = state_31924__$1;
(statearr_31945_34840[(2)] = null);

(statearr_31945_34840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (5))){
var inst_31899 = (state_31924[(7)]);
var state_31924__$1 = state_31924;
var statearr_31950_34844 = state_31924__$1;
(statearr_31950_34844[(2)] = inst_31899);

(statearr_31950_34844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (10))){
var inst_31918 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31955_34845 = state_31924__$1;
(statearr_31955_34845[(2)] = inst_31918);

(statearr_31955_34845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (8))){
var inst_31911 = (state_31924[(9)]);
var inst_31914 = cljs.core.deref(inst_31911);
var state_31924__$1 = state_31924;
var statearr_31956_34846 = state_31924__$1;
(statearr_31956_34846[(2)] = inst_31914);

(statearr_31956_34846[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__30603__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30603__auto____0 = (function (){
var statearr_31962 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31962[(0)] = cljs$core$async$reduce_$_state_machine__30603__auto__);

(statearr_31962[(1)] = (1));

return statearr_31962;
});
var cljs$core$async$reduce_$_state_machine__30603__auto____1 = (function (state_31924){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31924);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31963){var ex__30606__auto__ = e31963;
var statearr_31965_34847 = state_31924;
(statearr_31965_34847[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31924[(4)]))){
var statearr_31966_34852 = state_31924;
(statearr_31966_34852[(1)] = cljs.core.first((state_31924[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34853 = state_31924;
state_31924 = G__34853;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30603__auto__ = function(state_31924){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30603__auto____1.call(this,state_31924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30603__auto____0;
cljs$core$async$reduce_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30603__auto____1;
return cljs$core$async$reduce_$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31968 = f__30975__auto__();
(statearr_31968[(6)] = c__30974__auto__);

return statearr_31968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

return c__30974__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_31975){
var state_val_31976 = (state_31975[(1)]);
if((state_val_31976 === (1))){
var inst_31970 = cljs.core.async.reduce(f__$1,init,ch);
var state_31975__$1 = state_31975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31975__$1,(2),inst_31970);
} else {
if((state_val_31976 === (2))){
var inst_31972 = (state_31975[(2)]);
var inst_31973 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31972) : f__$1.call(null,inst_31972));
var state_31975__$1 = state_31975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31975__$1,inst_31973);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__30603__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30603__auto____0 = (function (){
var statearr_31981 = [null,null,null,null,null,null,null];
(statearr_31981[(0)] = cljs$core$async$transduce_$_state_machine__30603__auto__);

(statearr_31981[(1)] = (1));

return statearr_31981;
});
var cljs$core$async$transduce_$_state_machine__30603__auto____1 = (function (state_31975){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_31975);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e31982){var ex__30606__auto__ = e31982;
var statearr_31983_34858 = state_31975;
(statearr_31983_34858[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_31975[(4)]))){
var statearr_31984_34859 = state_31975;
(statearr_31984_34859[(1)] = cljs.core.first((state_31975[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34860 = state_31975;
state_31975 = G__34860;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30603__auto__ = function(state_31975){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30603__auto____1.call(this,state_31975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30603__auto____0;
cljs$core$async$transduce_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30603__auto____1;
return cljs$core$async$transduce_$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_31985 = f__30975__auto__();
(statearr_31985[(6)] = c__30974__auto__);

return statearr_31985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

return c__30974__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31990 = arguments.length;
switch (G__31990) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_32027){
var state_val_32028 = (state_32027[(1)]);
if((state_val_32028 === (7))){
var inst_32003 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32031_34865 = state_32027__$1;
(statearr_32031_34865[(2)] = inst_32003);

(statearr_32031_34865[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (1))){
var inst_31996 = cljs.core.seq(coll);
var inst_31997 = inst_31996;
var state_32027__$1 = (function (){var statearr_32035 = state_32027;
(statearr_32035[(7)] = inst_31997);

return statearr_32035;
})();
var statearr_32036_34867 = state_32027__$1;
(statearr_32036_34867[(2)] = null);

(statearr_32036_34867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (4))){
var inst_31997 = (state_32027[(7)]);
var inst_32001 = cljs.core.first(inst_31997);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32027__$1,(7),ch,inst_32001);
} else {
if((state_val_32028 === (13))){
var inst_32020 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32042_34868 = state_32027__$1;
(statearr_32042_34868[(2)] = inst_32020);

(statearr_32042_34868[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (6))){
var inst_32007 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
if(cljs.core.truth_(inst_32007)){
var statearr_32043_34871 = state_32027__$1;
(statearr_32043_34871[(1)] = (8));

} else {
var statearr_32048_34872 = state_32027__$1;
(statearr_32048_34872[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (3))){
var inst_32024 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32027__$1,inst_32024);
} else {
if((state_val_32028 === (12))){
var state_32027__$1 = state_32027;
var statearr_32053_34873 = state_32027__$1;
(statearr_32053_34873[(2)] = null);

(statearr_32053_34873[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (2))){
var inst_31997 = (state_32027[(7)]);
var state_32027__$1 = state_32027;
if(cljs.core.truth_(inst_31997)){
var statearr_32058_34874 = state_32027__$1;
(statearr_32058_34874[(1)] = (4));

} else {
var statearr_32059_34875 = state_32027__$1;
(statearr_32059_34875[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (11))){
var inst_32016 = cljs.core.async.close_BANG_(ch);
var state_32027__$1 = state_32027;
var statearr_32060_34877 = state_32027__$1;
(statearr_32060_34877[(2)] = inst_32016);

(statearr_32060_34877[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (9))){
var state_32027__$1 = state_32027;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32061_34878 = state_32027__$1;
(statearr_32061_34878[(1)] = (11));

} else {
var statearr_32062_34879 = state_32027__$1;
(statearr_32062_34879[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (5))){
var inst_31997 = (state_32027[(7)]);
var state_32027__$1 = state_32027;
var statearr_32063_34880 = state_32027__$1;
(statearr_32063_34880[(2)] = inst_31997);

(statearr_32063_34880[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (10))){
var inst_32022 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32068_34882 = state_32027__$1;
(statearr_32068_34882[(2)] = inst_32022);

(statearr_32068_34882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (8))){
var inst_31997 = (state_32027[(7)]);
var inst_32012 = cljs.core.next(inst_31997);
var inst_31997__$1 = inst_32012;
var state_32027__$1 = (function (){var statearr_32071 = state_32027;
(statearr_32071[(7)] = inst_31997__$1);

return statearr_32071;
})();
var statearr_32072_34883 = state_32027__$1;
(statearr_32072_34883[(2)] = null);

(statearr_32072_34883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_32073 = [null,null,null,null,null,null,null,null];
(statearr_32073[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_32073[(1)] = (1));

return statearr_32073;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_32027){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_32027);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e32074){var ex__30606__auto__ = e32074;
var statearr_32075_34885 = state_32027;
(statearr_32075_34885[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_32027[(4)]))){
var statearr_32076_34886 = state_32027;
(statearr_32076_34886[(1)] = cljs.core.first((state_32027[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34887 = state_32027;
state_32027 = G__34887;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_32027){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_32027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_32078 = f__30975__auto__();
(statearr_32078[(6)] = c__30974__auto__);

return statearr_32078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

return c__30974__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32083 = arguments.length;
switch (G__32083) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34891 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34891(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34892 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34892(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34894 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34894(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34897 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34897(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32100 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32100 = (function (ch,cs,meta32101){
this.ch = ch;
this.cs = cs;
this.meta32101 = meta32101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32102,meta32101__$1){
var self__ = this;
var _32102__$1 = this;
return (new cljs.core.async.t_cljs$core$async32100(self__.ch,self__.cs,meta32101__$1));
}));

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32102){
var self__ = this;
var _32102__$1 = this;
return self__.meta32101;
}));

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async32100.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async32100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32101","meta32101",-1806764896,null)], null);
}));

(cljs.core.async.t_cljs$core$async32100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32100");

(cljs.core.async.t_cljs$core$async32100.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32100.
 */
cljs.core.async.__GT_t_cljs$core$async32100 = (function cljs$core$async$mult_$___GT_t_cljs$core$async32100(ch__$1,cs__$1,meta32101){
return (new cljs.core.async.t_cljs$core$async32100(ch__$1,cs__$1,meta32101));
});

}

return (new cljs.core.async.t_cljs$core$async32100(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30974__auto___34915 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_32274){
var state_val_32275 = (state_32274[(1)]);
if((state_val_32275 === (7))){
var inst_32269 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32277_34916 = state_32274__$1;
(statearr_32277_34916[(2)] = inst_32269);

(statearr_32277_34916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (20))){
var inst_32169 = (state_32274[(7)]);
var inst_32182 = cljs.core.first(inst_32169);
var inst_32183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32182,(0),null);
var inst_32184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32182,(1),null);
var state_32274__$1 = (function (){var statearr_32279 = state_32274;
(statearr_32279[(8)] = inst_32183);

return statearr_32279;
})();
if(cljs.core.truth_(inst_32184)){
var statearr_32280_34917 = state_32274__$1;
(statearr_32280_34917[(1)] = (22));

} else {
var statearr_32281_34918 = state_32274__$1;
(statearr_32281_34918[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (27))){
var inst_32214 = (state_32274[(9)]);
var inst_32212 = (state_32274[(10)]);
var inst_32223 = (state_32274[(11)]);
var inst_32132 = (state_32274[(12)]);
var inst_32223__$1 = cljs.core._nth(inst_32212,inst_32214);
var inst_32224 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32223__$1,inst_32132,done);
var state_32274__$1 = (function (){var statearr_32282 = state_32274;
(statearr_32282[(11)] = inst_32223__$1);

return statearr_32282;
})();
if(cljs.core.truth_(inst_32224)){
var statearr_32283_34923 = state_32274__$1;
(statearr_32283_34923[(1)] = (30));

} else {
var statearr_32284_34924 = state_32274__$1;
(statearr_32284_34924[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (1))){
var state_32274__$1 = state_32274;
var statearr_32285_34925 = state_32274__$1;
(statearr_32285_34925[(2)] = null);

(statearr_32285_34925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (24))){
var inst_32169 = (state_32274[(7)]);
var inst_32189 = (state_32274[(2)]);
var inst_32190 = cljs.core.next(inst_32169);
var inst_32141 = inst_32190;
var inst_32142 = null;
var inst_32143 = (0);
var inst_32144 = (0);
var state_32274__$1 = (function (){var statearr_32286 = state_32274;
(statearr_32286[(13)] = inst_32142);

(statearr_32286[(14)] = inst_32144);

(statearr_32286[(15)] = inst_32143);

(statearr_32286[(16)] = inst_32189);

(statearr_32286[(17)] = inst_32141);

return statearr_32286;
})();
var statearr_32287_34930 = state_32274__$1;
(statearr_32287_34930[(2)] = null);

(statearr_32287_34930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (39))){
var state_32274__$1 = state_32274;
var statearr_32294_34931 = state_32274__$1;
(statearr_32294_34931[(2)] = null);

(statearr_32294_34931[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (4))){
var inst_32132 = (state_32274[(12)]);
var inst_32132__$1 = (state_32274[(2)]);
var inst_32133 = (inst_32132__$1 == null);
var state_32274__$1 = (function (){var statearr_32296 = state_32274;
(statearr_32296[(12)] = inst_32132__$1);

return statearr_32296;
})();
if(cljs.core.truth_(inst_32133)){
var statearr_32297_34932 = state_32274__$1;
(statearr_32297_34932[(1)] = (5));

} else {
var statearr_32298_34933 = state_32274__$1;
(statearr_32298_34933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (15))){
var inst_32142 = (state_32274[(13)]);
var inst_32144 = (state_32274[(14)]);
var inst_32143 = (state_32274[(15)]);
var inst_32141 = (state_32274[(17)]);
var inst_32165 = (state_32274[(2)]);
var inst_32166 = (inst_32144 + (1));
var tmp32289 = inst_32142;
var tmp32290 = inst_32143;
var tmp32291 = inst_32141;
var inst_32141__$1 = tmp32291;
var inst_32142__$1 = tmp32289;
var inst_32143__$1 = tmp32290;
var inst_32144__$1 = inst_32166;
var state_32274__$1 = (function (){var statearr_32299 = state_32274;
(statearr_32299[(13)] = inst_32142__$1);

(statearr_32299[(14)] = inst_32144__$1);

(statearr_32299[(15)] = inst_32143__$1);

(statearr_32299[(17)] = inst_32141__$1);

(statearr_32299[(18)] = inst_32165);

return statearr_32299;
})();
var statearr_32303_34941 = state_32274__$1;
(statearr_32303_34941[(2)] = null);

(statearr_32303_34941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (21))){
var inst_32193 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32308_34948 = state_32274__$1;
(statearr_32308_34948[(2)] = inst_32193);

(statearr_32308_34948[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (31))){
var inst_32223 = (state_32274[(11)]);
var inst_32227 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32223);
var state_32274__$1 = state_32274;
var statearr_32311_34949 = state_32274__$1;
(statearr_32311_34949[(2)] = inst_32227);

(statearr_32311_34949[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (32))){
var inst_32214 = (state_32274[(9)]);
var inst_32212 = (state_32274[(10)]);
var inst_32213 = (state_32274[(19)]);
var inst_32211 = (state_32274[(20)]);
var inst_32229 = (state_32274[(2)]);
var inst_32230 = (inst_32214 + (1));
var tmp32305 = inst_32212;
var tmp32306 = inst_32213;
var tmp32307 = inst_32211;
var inst_32211__$1 = tmp32307;
var inst_32212__$1 = tmp32305;
var inst_32213__$1 = tmp32306;
var inst_32214__$1 = inst_32230;
var state_32274__$1 = (function (){var statearr_32312 = state_32274;
(statearr_32312[(9)] = inst_32214__$1);

(statearr_32312[(21)] = inst_32229);

(statearr_32312[(10)] = inst_32212__$1);

(statearr_32312[(19)] = inst_32213__$1);

(statearr_32312[(20)] = inst_32211__$1);

return statearr_32312;
})();
var statearr_32313_34950 = state_32274__$1;
(statearr_32313_34950[(2)] = null);

(statearr_32313_34950[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (40))){
var inst_32242 = (state_32274[(22)]);
var inst_32246 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32242);
var state_32274__$1 = state_32274;
var statearr_32317_34951 = state_32274__$1;
(statearr_32317_34951[(2)] = inst_32246);

(statearr_32317_34951[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (33))){
var inst_32233 = (state_32274[(23)]);
var inst_32235 = cljs.core.chunked_seq_QMARK_(inst_32233);
var state_32274__$1 = state_32274;
if(inst_32235){
var statearr_32318_34952 = state_32274__$1;
(statearr_32318_34952[(1)] = (36));

} else {
var statearr_32320_34953 = state_32274__$1;
(statearr_32320_34953[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (13))){
var inst_32159 = (state_32274[(24)]);
var inst_32162 = cljs.core.async.close_BANG_(inst_32159);
var state_32274__$1 = state_32274;
var statearr_32336_34954 = state_32274__$1;
(statearr_32336_34954[(2)] = inst_32162);

(statearr_32336_34954[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (22))){
var inst_32183 = (state_32274[(8)]);
var inst_32186 = cljs.core.async.close_BANG_(inst_32183);
var state_32274__$1 = state_32274;
var statearr_32340_34955 = state_32274__$1;
(statearr_32340_34955[(2)] = inst_32186);

(statearr_32340_34955[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (36))){
var inst_32233 = (state_32274[(23)]);
var inst_32237 = cljs.core.chunk_first(inst_32233);
var inst_32238 = cljs.core.chunk_rest(inst_32233);
var inst_32239 = cljs.core.count(inst_32237);
var inst_32211 = inst_32238;
var inst_32212 = inst_32237;
var inst_32213 = inst_32239;
var inst_32214 = (0);
var state_32274__$1 = (function (){var statearr_32341 = state_32274;
(statearr_32341[(9)] = inst_32214);

(statearr_32341[(10)] = inst_32212);

(statearr_32341[(19)] = inst_32213);

(statearr_32341[(20)] = inst_32211);

return statearr_32341;
})();
var statearr_32343_34957 = state_32274__$1;
(statearr_32343_34957[(2)] = null);

(statearr_32343_34957[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (41))){
var inst_32233 = (state_32274[(23)]);
var inst_32248 = (state_32274[(2)]);
var inst_32249 = cljs.core.next(inst_32233);
var inst_32211 = inst_32249;
var inst_32212 = null;
var inst_32213 = (0);
var inst_32214 = (0);
var state_32274__$1 = (function (){var statearr_32346 = state_32274;
(statearr_32346[(9)] = inst_32214);

(statearr_32346[(10)] = inst_32212);

(statearr_32346[(25)] = inst_32248);

(statearr_32346[(19)] = inst_32213);

(statearr_32346[(20)] = inst_32211);

return statearr_32346;
})();
var statearr_32349_34958 = state_32274__$1;
(statearr_32349_34958[(2)] = null);

(statearr_32349_34958[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (43))){
var state_32274__$1 = state_32274;
var statearr_32357_34959 = state_32274__$1;
(statearr_32357_34959[(2)] = null);

(statearr_32357_34959[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (29))){
var inst_32257 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32358_34960 = state_32274__$1;
(statearr_32358_34960[(2)] = inst_32257);

(statearr_32358_34960[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (44))){
var inst_32266 = (state_32274[(2)]);
var state_32274__$1 = (function (){var statearr_32363 = state_32274;
(statearr_32363[(26)] = inst_32266);

return statearr_32363;
})();
var statearr_32364_34968 = state_32274__$1;
(statearr_32364_34968[(2)] = null);

(statearr_32364_34968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (6))){
var inst_32203 = (state_32274[(27)]);
var inst_32202 = cljs.core.deref(cs);
var inst_32203__$1 = cljs.core.keys(inst_32202);
var inst_32204 = cljs.core.count(inst_32203__$1);
var inst_32205 = cljs.core.reset_BANG_(dctr,inst_32204);
var inst_32210 = cljs.core.seq(inst_32203__$1);
var inst_32211 = inst_32210;
var inst_32212 = null;
var inst_32213 = (0);
var inst_32214 = (0);
var state_32274__$1 = (function (){var statearr_32367 = state_32274;
(statearr_32367[(9)] = inst_32214);

(statearr_32367[(10)] = inst_32212);

(statearr_32367[(19)] = inst_32213);

(statearr_32367[(28)] = inst_32205);

(statearr_32367[(20)] = inst_32211);

(statearr_32367[(27)] = inst_32203__$1);

return statearr_32367;
})();
var statearr_32368_34969 = state_32274__$1;
(statearr_32368_34969[(2)] = null);

(statearr_32368_34969[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (28))){
var inst_32233 = (state_32274[(23)]);
var inst_32211 = (state_32274[(20)]);
var inst_32233__$1 = cljs.core.seq(inst_32211);
var state_32274__$1 = (function (){var statearr_32369 = state_32274;
(statearr_32369[(23)] = inst_32233__$1);

return statearr_32369;
})();
if(inst_32233__$1){
var statearr_32373_34972 = state_32274__$1;
(statearr_32373_34972[(1)] = (33));

} else {
var statearr_32374_34973 = state_32274__$1;
(statearr_32374_34973[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (25))){
var inst_32214 = (state_32274[(9)]);
var inst_32213 = (state_32274[(19)]);
var inst_32216 = (inst_32214 < inst_32213);
var inst_32217 = inst_32216;
var state_32274__$1 = state_32274;
if(cljs.core.truth_(inst_32217)){
var statearr_32377_34974 = state_32274__$1;
(statearr_32377_34974[(1)] = (27));

} else {
var statearr_32378_34975 = state_32274__$1;
(statearr_32378_34975[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (34))){
var state_32274__$1 = state_32274;
var statearr_32384_34976 = state_32274__$1;
(statearr_32384_34976[(2)] = null);

(statearr_32384_34976[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (17))){
var state_32274__$1 = state_32274;
var statearr_32389_34977 = state_32274__$1;
(statearr_32389_34977[(2)] = null);

(statearr_32389_34977[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (3))){
var inst_32271 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32274__$1,inst_32271);
} else {
if((state_val_32275 === (12))){
var inst_32198 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32392_34979 = state_32274__$1;
(statearr_32392_34979[(2)] = inst_32198);

(statearr_32392_34979[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (2))){
var state_32274__$1 = state_32274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32274__$1,(4),ch);
} else {
if((state_val_32275 === (23))){
var state_32274__$1 = state_32274;
var statearr_32395_34980 = state_32274__$1;
(statearr_32395_34980[(2)] = null);

(statearr_32395_34980[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (35))){
var inst_32255 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32396_34982 = state_32274__$1;
(statearr_32396_34982[(2)] = inst_32255);

(statearr_32396_34982[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (19))){
var inst_32169 = (state_32274[(7)]);
var inst_32173 = cljs.core.chunk_first(inst_32169);
var inst_32174 = cljs.core.chunk_rest(inst_32169);
var inst_32176 = cljs.core.count(inst_32173);
var inst_32141 = inst_32174;
var inst_32142 = inst_32173;
var inst_32143 = inst_32176;
var inst_32144 = (0);
var state_32274__$1 = (function (){var statearr_32404 = state_32274;
(statearr_32404[(13)] = inst_32142);

(statearr_32404[(14)] = inst_32144);

(statearr_32404[(15)] = inst_32143);

(statearr_32404[(17)] = inst_32141);

return statearr_32404;
})();
var statearr_32405_34989 = state_32274__$1;
(statearr_32405_34989[(2)] = null);

(statearr_32405_34989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (11))){
var inst_32169 = (state_32274[(7)]);
var inst_32141 = (state_32274[(17)]);
var inst_32169__$1 = cljs.core.seq(inst_32141);
var state_32274__$1 = (function (){var statearr_32409 = state_32274;
(statearr_32409[(7)] = inst_32169__$1);

return statearr_32409;
})();
if(inst_32169__$1){
var statearr_32410_34990 = state_32274__$1;
(statearr_32410_34990[(1)] = (16));

} else {
var statearr_32411_34991 = state_32274__$1;
(statearr_32411_34991[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (9))){
var inst_32200 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32412_34992 = state_32274__$1;
(statearr_32412_34992[(2)] = inst_32200);

(statearr_32412_34992[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (5))){
var inst_32139 = cljs.core.deref(cs);
var inst_32140 = cljs.core.seq(inst_32139);
var inst_32141 = inst_32140;
var inst_32142 = null;
var inst_32143 = (0);
var inst_32144 = (0);
var state_32274__$1 = (function (){var statearr_32413 = state_32274;
(statearr_32413[(13)] = inst_32142);

(statearr_32413[(14)] = inst_32144);

(statearr_32413[(15)] = inst_32143);

(statearr_32413[(17)] = inst_32141);

return statearr_32413;
})();
var statearr_32419_34993 = state_32274__$1;
(statearr_32419_34993[(2)] = null);

(statearr_32419_34993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (14))){
var state_32274__$1 = state_32274;
var statearr_32421_34994 = state_32274__$1;
(statearr_32421_34994[(2)] = null);

(statearr_32421_34994[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (45))){
var inst_32263 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32423_34995 = state_32274__$1;
(statearr_32423_34995[(2)] = inst_32263);

(statearr_32423_34995[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (26))){
var inst_32203 = (state_32274[(27)]);
var inst_32259 = (state_32274[(2)]);
var inst_32260 = cljs.core.seq(inst_32203);
var state_32274__$1 = (function (){var statearr_32427 = state_32274;
(statearr_32427[(29)] = inst_32259);

return statearr_32427;
})();
if(inst_32260){
var statearr_32428_34996 = state_32274__$1;
(statearr_32428_34996[(1)] = (42));

} else {
var statearr_32430_34997 = state_32274__$1;
(statearr_32430_34997[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (16))){
var inst_32169 = (state_32274[(7)]);
var inst_32171 = cljs.core.chunked_seq_QMARK_(inst_32169);
var state_32274__$1 = state_32274;
if(inst_32171){
var statearr_32433_34998 = state_32274__$1;
(statearr_32433_34998[(1)] = (19));

} else {
var statearr_32438_34999 = state_32274__$1;
(statearr_32438_34999[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (38))){
var inst_32252 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32441_35000 = state_32274__$1;
(statearr_32441_35000[(2)] = inst_32252);

(statearr_32441_35000[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (30))){
var state_32274__$1 = state_32274;
var statearr_32442_35001 = state_32274__$1;
(statearr_32442_35001[(2)] = null);

(statearr_32442_35001[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (10))){
var inst_32142 = (state_32274[(13)]);
var inst_32144 = (state_32274[(14)]);
var inst_32158 = cljs.core._nth(inst_32142,inst_32144);
var inst_32159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32158,(0),null);
var inst_32160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32158,(1),null);
var state_32274__$1 = (function (){var statearr_32447 = state_32274;
(statearr_32447[(24)] = inst_32159);

return statearr_32447;
})();
if(cljs.core.truth_(inst_32160)){
var statearr_32448_35004 = state_32274__$1;
(statearr_32448_35004[(1)] = (13));

} else {
var statearr_32449_35005 = state_32274__$1;
(statearr_32449_35005[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (18))){
var inst_32196 = (state_32274[(2)]);
var state_32274__$1 = state_32274;
var statearr_32451_35012 = state_32274__$1;
(statearr_32451_35012[(2)] = inst_32196);

(statearr_32451_35012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (42))){
var state_32274__$1 = state_32274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32274__$1,(45),dchan);
} else {
if((state_val_32275 === (37))){
var inst_32233 = (state_32274[(23)]);
var inst_32242 = (state_32274[(22)]);
var inst_32132 = (state_32274[(12)]);
var inst_32242__$1 = cljs.core.first(inst_32233);
var inst_32243 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32242__$1,inst_32132,done);
var state_32274__$1 = (function (){var statearr_32456 = state_32274;
(statearr_32456[(22)] = inst_32242__$1);

return statearr_32456;
})();
if(cljs.core.truth_(inst_32243)){
var statearr_32457_35013 = state_32274__$1;
(statearr_32457_35013[(1)] = (39));

} else {
var statearr_32459_35014 = state_32274__$1;
(statearr_32459_35014[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32275 === (8))){
var inst_32144 = (state_32274[(14)]);
var inst_32143 = (state_32274[(15)]);
var inst_32146 = (inst_32144 < inst_32143);
var inst_32147 = inst_32146;
var state_32274__$1 = state_32274;
if(cljs.core.truth_(inst_32147)){
var statearr_32470_35015 = state_32274__$1;
(statearr_32470_35015[(1)] = (10));

} else {
var statearr_32471_35016 = state_32274__$1;
(statearr_32471_35016[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__30603__auto__ = null;
var cljs$core$async$mult_$_state_machine__30603__auto____0 = (function (){
var statearr_32481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32481[(0)] = cljs$core$async$mult_$_state_machine__30603__auto__);

(statearr_32481[(1)] = (1));

return statearr_32481;
});
var cljs$core$async$mult_$_state_machine__30603__auto____1 = (function (state_32274){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_32274);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e32486){var ex__30606__auto__ = e32486;
var statearr_32487_35017 = state_32274;
(statearr_32487_35017[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_32274[(4)]))){
var statearr_32488_35018 = state_32274;
(statearr_32488_35018[(1)] = cljs.core.first((state_32274[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35019 = state_32274;
state_32274 = G__35019;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30603__auto__ = function(state_32274){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30603__auto____1.call(this,state_32274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30603__auto____0;
cljs$core$async$mult_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30603__auto____1;
return cljs$core$async$mult_$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_32491 = f__30975__auto__();
(statearr_32491[(6)] = c__30974__auto___34915);

return statearr_32491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32495 = arguments.length;
switch (G__32495) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_35021 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_35021(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_35022 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_35022(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_35023 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_35023(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_35024 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_35024(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_35028 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_35028(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35030 = arguments.length;
var i__5770__auto___35031 = (0);
while(true){
if((i__5770__auto___35031 < len__5769__auto___35030)){
args__5775__auto__.push((arguments[i__5770__auto___35031]));

var G__35032 = (i__5770__auto___35031 + (1));
i__5770__auto___35031 = G__35032;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32585){
var map__32586 = p__32585;
var map__32586__$1 = cljs.core.__destructure_map(map__32586);
var opts = map__32586__$1;
var statearr_32587_35037 = state;
(statearr_32587_35037[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32588_35038 = state;
(statearr_32588_35038[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32589_35039 = state;
(statearr_32589_35039[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32560){
var G__32561 = cljs.core.first(seq32560);
var seq32560__$1 = cljs.core.next(seq32560);
var G__32562 = cljs.core.first(seq32560__$1);
var seq32560__$2 = cljs.core.next(seq32560__$1);
var G__32563 = cljs.core.first(seq32560__$2);
var seq32560__$3 = cljs.core.next(seq32560__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32561,G__32562,G__32563,seq32560__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32598 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32598 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32599){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32599 = meta32599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32600,meta32599__$1){
var self__ = this;
var _32600__$1 = this;
return (new cljs.core.async.t_cljs$core$async32598(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32599__$1));
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32600){
var self__ = this;
var _32600__$1 = this;
return self__.meta32599;
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32598.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32598.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32599","meta32599",435384315,null)], null);
}));

(cljs.core.async.t_cljs$core$async32598.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32598.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32598");

(cljs.core.async.t_cljs$core$async32598.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32598");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32598.
 */
cljs.core.async.__GT_t_cljs$core$async32598 = (function cljs$core$async$mix_$___GT_t_cljs$core$async32598(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32599){
return (new cljs.core.async.t_cljs$core$async32598(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32599));
});

}

return (new cljs.core.async.t_cljs$core$async32598(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30974__auto___35062 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_32696){
var state_val_32697 = (state_32696[(1)]);
if((state_val_32697 === (7))){
var inst_32654 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
if(cljs.core.truth_(inst_32654)){
var statearr_32699_35067 = state_32696__$1;
(statearr_32699_35067[(1)] = (8));

} else {
var statearr_32701_35068 = state_32696__$1;
(statearr_32701_35068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (20))){
var inst_32647 = (state_32696[(7)]);
var state_32696__$1 = state_32696;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32696__$1,(23),out,inst_32647);
} else {
if((state_val_32697 === (1))){
var inst_32622 = calc_state();
var inst_32623 = cljs.core.__destructure_map(inst_32622);
var inst_32624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32623,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32623,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32626 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32623,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32627 = inst_32622;
var state_32696__$1 = (function (){var statearr_32704 = state_32696;
(statearr_32704[(8)] = inst_32627);

(statearr_32704[(9)] = inst_32626);

(statearr_32704[(10)] = inst_32624);

(statearr_32704[(11)] = inst_32625);

return statearr_32704;
})();
var statearr_32705_35070 = state_32696__$1;
(statearr_32705_35070[(2)] = null);

(statearr_32705_35070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (24))){
var inst_32634 = (state_32696[(12)]);
var inst_32627 = inst_32634;
var state_32696__$1 = (function (){var statearr_32706 = state_32696;
(statearr_32706[(8)] = inst_32627);

return statearr_32706;
})();
var statearr_32715_35074 = state_32696__$1;
(statearr_32715_35074[(2)] = null);

(statearr_32715_35074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (4))){
var inst_32647 = (state_32696[(7)]);
var inst_32649 = (state_32696[(13)]);
var inst_32646 = (state_32696[(2)]);
var inst_32647__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32646,(0),null);
var inst_32648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32646,(1),null);
var inst_32649__$1 = (inst_32647__$1 == null);
var state_32696__$1 = (function (){var statearr_32720 = state_32696;
(statearr_32720[(7)] = inst_32647__$1);

(statearr_32720[(13)] = inst_32649__$1);

(statearr_32720[(14)] = inst_32648);

return statearr_32720;
})();
if(cljs.core.truth_(inst_32649__$1)){
var statearr_32722_35082 = state_32696__$1;
(statearr_32722_35082[(1)] = (5));

} else {
var statearr_32723_35086 = state_32696__$1;
(statearr_32723_35086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (15))){
var inst_32639 = (state_32696[(15)]);
var inst_32669 = (state_32696[(16)]);
var inst_32669__$1 = cljs.core.empty_QMARK_(inst_32639);
var state_32696__$1 = (function (){var statearr_32724 = state_32696;
(statearr_32724[(16)] = inst_32669__$1);

return statearr_32724;
})();
if(inst_32669__$1){
var statearr_32725_35091 = state_32696__$1;
(statearr_32725_35091[(1)] = (17));

} else {
var statearr_32726_35092 = state_32696__$1;
(statearr_32726_35092[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (21))){
var inst_32634 = (state_32696[(12)]);
var inst_32627 = inst_32634;
var state_32696__$1 = (function (){var statearr_32728 = state_32696;
(statearr_32728[(8)] = inst_32627);

return statearr_32728;
})();
var statearr_32729_35093 = state_32696__$1;
(statearr_32729_35093[(2)] = null);

(statearr_32729_35093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (13))){
var inst_32661 = (state_32696[(2)]);
var inst_32662 = calc_state();
var inst_32627 = inst_32662;
var state_32696__$1 = (function (){var statearr_32730 = state_32696;
(statearr_32730[(8)] = inst_32627);

(statearr_32730[(17)] = inst_32661);

return statearr_32730;
})();
var statearr_32731_35094 = state_32696__$1;
(statearr_32731_35094[(2)] = null);

(statearr_32731_35094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (22))){
var inst_32690 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
var statearr_32732_35095 = state_32696__$1;
(statearr_32732_35095[(2)] = inst_32690);

(statearr_32732_35095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (6))){
var inst_32648 = (state_32696[(14)]);
var inst_32652 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32648,change);
var state_32696__$1 = state_32696;
var statearr_32733_35098 = state_32696__$1;
(statearr_32733_35098[(2)] = inst_32652);

(statearr_32733_35098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (25))){
var state_32696__$1 = state_32696;
var statearr_32734_35099 = state_32696__$1;
(statearr_32734_35099[(2)] = null);

(statearr_32734_35099[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (17))){
var inst_32648 = (state_32696[(14)]);
var inst_32640 = (state_32696[(18)]);
var inst_32671 = (inst_32640.cljs$core$IFn$_invoke$arity$1 ? inst_32640.cljs$core$IFn$_invoke$arity$1(inst_32648) : inst_32640.call(null,inst_32648));
var inst_32672 = cljs.core.not(inst_32671);
var state_32696__$1 = state_32696;
var statearr_32735_35100 = state_32696__$1;
(statearr_32735_35100[(2)] = inst_32672);

(statearr_32735_35100[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (3))){
var inst_32694 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32696__$1,inst_32694);
} else {
if((state_val_32697 === (12))){
var state_32696__$1 = state_32696;
var statearr_32743_35102 = state_32696__$1;
(statearr_32743_35102[(2)] = null);

(statearr_32743_35102[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (2))){
var inst_32627 = (state_32696[(8)]);
var inst_32634 = (state_32696[(12)]);
var inst_32634__$1 = cljs.core.__destructure_map(inst_32627);
var inst_32639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32634__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32634__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32641 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32634__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32696__$1 = (function (){var statearr_32744 = state_32696;
(statearr_32744[(15)] = inst_32639);

(statearr_32744[(12)] = inst_32634__$1);

(statearr_32744[(18)] = inst_32640);

return statearr_32744;
})();
return cljs.core.async.ioc_alts_BANG_(state_32696__$1,(4),inst_32641);
} else {
if((state_val_32697 === (23))){
var inst_32681 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
if(cljs.core.truth_(inst_32681)){
var statearr_32745_35104 = state_32696__$1;
(statearr_32745_35104[(1)] = (24));

} else {
var statearr_32747_35105 = state_32696__$1;
(statearr_32747_35105[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (19))){
var inst_32675 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
var statearr_32749_35106 = state_32696__$1;
(statearr_32749_35106[(2)] = inst_32675);

(statearr_32749_35106[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (11))){
var inst_32648 = (state_32696[(14)]);
var inst_32658 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32648);
var state_32696__$1 = state_32696;
var statearr_32750_35107 = state_32696__$1;
(statearr_32750_35107[(2)] = inst_32658);

(statearr_32750_35107[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (9))){
var inst_32639 = (state_32696[(15)]);
var inst_32666 = (state_32696[(19)]);
var inst_32648 = (state_32696[(14)]);
var inst_32666__$1 = (inst_32639.cljs$core$IFn$_invoke$arity$1 ? inst_32639.cljs$core$IFn$_invoke$arity$1(inst_32648) : inst_32639.call(null,inst_32648));
var state_32696__$1 = (function (){var statearr_32751 = state_32696;
(statearr_32751[(19)] = inst_32666__$1);

return statearr_32751;
})();
if(cljs.core.truth_(inst_32666__$1)){
var statearr_32753_35108 = state_32696__$1;
(statearr_32753_35108[(1)] = (14));

} else {
var statearr_32755_35109 = state_32696__$1;
(statearr_32755_35109[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (5))){
var inst_32649 = (state_32696[(13)]);
var state_32696__$1 = state_32696;
var statearr_32757_35110 = state_32696__$1;
(statearr_32757_35110[(2)] = inst_32649);

(statearr_32757_35110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (14))){
var inst_32666 = (state_32696[(19)]);
var state_32696__$1 = state_32696;
var statearr_32760_35111 = state_32696__$1;
(statearr_32760_35111[(2)] = inst_32666);

(statearr_32760_35111[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (26))){
var inst_32686 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
var statearr_32762_35112 = state_32696__$1;
(statearr_32762_35112[(2)] = inst_32686);

(statearr_32762_35112[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (16))){
var inst_32678 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
if(cljs.core.truth_(inst_32678)){
var statearr_32763_35113 = state_32696__$1;
(statearr_32763_35113[(1)] = (20));

} else {
var statearr_32764_35114 = state_32696__$1;
(statearr_32764_35114[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (10))){
var inst_32692 = (state_32696[(2)]);
var state_32696__$1 = state_32696;
var statearr_32765_35115 = state_32696__$1;
(statearr_32765_35115[(2)] = inst_32692);

(statearr_32765_35115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (18))){
var inst_32669 = (state_32696[(16)]);
var state_32696__$1 = state_32696;
var statearr_32766_35116 = state_32696__$1;
(statearr_32766_35116[(2)] = inst_32669);

(statearr_32766_35116[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32697 === (8))){
var inst_32647 = (state_32696[(7)]);
var inst_32656 = (inst_32647 == null);
var state_32696__$1 = state_32696;
if(cljs.core.truth_(inst_32656)){
var statearr_32767_35117 = state_32696__$1;
(statearr_32767_35117[(1)] = (11));

} else {
var statearr_32768_35118 = state_32696__$1;
(statearr_32768_35118[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__30603__auto__ = null;
var cljs$core$async$mix_$_state_machine__30603__auto____0 = (function (){
var statearr_32770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32770[(0)] = cljs$core$async$mix_$_state_machine__30603__auto__);

(statearr_32770[(1)] = (1));

return statearr_32770;
});
var cljs$core$async$mix_$_state_machine__30603__auto____1 = (function (state_32696){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_32696);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e32771){var ex__30606__auto__ = e32771;
var statearr_32772_35119 = state_32696;
(statearr_32772_35119[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_32696[(4)]))){
var statearr_32773_35120 = state_32696;
(statearr_32773_35120[(1)] = cljs.core.first((state_32696[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35121 = state_32696;
state_32696 = G__35121;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30603__auto__ = function(state_32696){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30603__auto____1.call(this,state_32696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30603__auto____0;
cljs$core$async$mix_$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30603__auto____1;
return cljs$core$async$mix_$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_32774 = f__30975__auto__();
(statearr_32774[(6)] = c__30974__auto___35062);

return statearr_32774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_35122 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_35122(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_35123 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_35123(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_35125 = (function() {
var G__35126 = null;
var G__35126__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__35126__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__35126 = function(p,v){
switch(arguments.length){
case 1:
return G__35126__1.call(this,p);
case 2:
return G__35126__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35126.cljs$core$IFn$_invoke$arity$1 = G__35126__1;
G__35126.cljs$core$IFn$_invoke$arity$2 = G__35126__2;
return G__35126;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32781 = arguments.length;
switch (G__32781) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35125(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35125(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32785 = arguments.length;
switch (G__32785) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32782_SHARP_){
if(cljs.core.truth_((p1__32782_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32782_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32782_SHARP_.call(null,topic)))){
return p1__32782_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32782_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32787 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32787 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32788){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32788 = meta32788;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32789,meta32788__$1){
var self__ = this;
var _32789__$1 = this;
return (new cljs.core.async.t_cljs$core$async32787(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32788__$1));
}));

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32789){
var self__ = this;
var _32789__$1 = this;
return self__.meta32788;
}));

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32787.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32787.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32788","meta32788",448234998,null)], null);
}));

(cljs.core.async.t_cljs$core$async32787.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32787.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32787");

(cljs.core.async.t_cljs$core$async32787.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32787");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32787.
 */
cljs.core.async.__GT_t_cljs$core$async32787 = (function cljs$core$async$__GT_t_cljs$core$async32787(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32788){
return (new cljs.core.async.t_cljs$core$async32787(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32788));
});

}

return (new cljs.core.async.t_cljs$core$async32787(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30974__auto___35147 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_32879){
var state_val_32880 = (state_32879[(1)]);
if((state_val_32880 === (7))){
var inst_32875 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
var statearr_32886_35149 = state_32879__$1;
(statearr_32886_35149[(2)] = inst_32875);

(statearr_32886_35149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (20))){
var state_32879__$1 = state_32879;
var statearr_32888_35152 = state_32879__$1;
(statearr_32888_35152[(2)] = null);

(statearr_32888_35152[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (1))){
var state_32879__$1 = state_32879;
var statearr_32890_35154 = state_32879__$1;
(statearr_32890_35154[(2)] = null);

(statearr_32890_35154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (24))){
var inst_32858 = (state_32879[(7)]);
var inst_32867 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32858);
var state_32879__$1 = state_32879;
var statearr_32891_35155 = state_32879__$1;
(statearr_32891_35155[(2)] = inst_32867);

(statearr_32891_35155[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (4))){
var inst_32807 = (state_32879[(8)]);
var inst_32807__$1 = (state_32879[(2)]);
var inst_32808 = (inst_32807__$1 == null);
var state_32879__$1 = (function (){var statearr_32892 = state_32879;
(statearr_32892[(8)] = inst_32807__$1);

return statearr_32892;
})();
if(cljs.core.truth_(inst_32808)){
var statearr_32893_35156 = state_32879__$1;
(statearr_32893_35156[(1)] = (5));

} else {
var statearr_32894_35157 = state_32879__$1;
(statearr_32894_35157[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (15))){
var inst_32852 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
var statearr_32896_35160 = state_32879__$1;
(statearr_32896_35160[(2)] = inst_32852);

(statearr_32896_35160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (21))){
var inst_32872 = (state_32879[(2)]);
var state_32879__$1 = (function (){var statearr_32898 = state_32879;
(statearr_32898[(9)] = inst_32872);

return statearr_32898;
})();
var statearr_32900_35162 = state_32879__$1;
(statearr_32900_35162[(2)] = null);

(statearr_32900_35162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (13))){
var inst_32833 = (state_32879[(10)]);
var inst_32836 = cljs.core.chunked_seq_QMARK_(inst_32833);
var state_32879__$1 = state_32879;
if(inst_32836){
var statearr_32901_35163 = state_32879__$1;
(statearr_32901_35163[(1)] = (16));

} else {
var statearr_32902_35165 = state_32879__$1;
(statearr_32902_35165[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (22))){
var inst_32864 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
if(cljs.core.truth_(inst_32864)){
var statearr_32905_35169 = state_32879__$1;
(statearr_32905_35169[(1)] = (23));

} else {
var statearr_32906_35170 = state_32879__$1;
(statearr_32906_35170[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (6))){
var inst_32807 = (state_32879[(8)]);
var inst_32860 = (state_32879[(11)]);
var inst_32858 = (state_32879[(7)]);
var inst_32858__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32807) : topic_fn.call(null,inst_32807));
var inst_32859 = cljs.core.deref(mults);
var inst_32860__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32859,inst_32858__$1);
var state_32879__$1 = (function (){var statearr_32913 = state_32879;
(statearr_32913[(11)] = inst_32860__$1);

(statearr_32913[(7)] = inst_32858__$1);

return statearr_32913;
})();
if(cljs.core.truth_(inst_32860__$1)){
var statearr_32914_35171 = state_32879__$1;
(statearr_32914_35171[(1)] = (19));

} else {
var statearr_32915_35172 = state_32879__$1;
(statearr_32915_35172[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (25))){
var inst_32869 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
var statearr_32920_35178 = state_32879__$1;
(statearr_32920_35178[(2)] = inst_32869);

(statearr_32920_35178[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (17))){
var inst_32833 = (state_32879[(10)]);
var inst_32843 = cljs.core.first(inst_32833);
var inst_32844 = cljs.core.async.muxch_STAR_(inst_32843);
var inst_32845 = cljs.core.async.close_BANG_(inst_32844);
var inst_32846 = cljs.core.next(inst_32833);
var inst_32817 = inst_32846;
var inst_32818 = null;
var inst_32819 = (0);
var inst_32820 = (0);
var state_32879__$1 = (function (){var statearr_32923 = state_32879;
(statearr_32923[(12)] = inst_32817);

(statearr_32923[(13)] = inst_32818);

(statearr_32923[(14)] = inst_32820);

(statearr_32923[(15)] = inst_32845);

(statearr_32923[(16)] = inst_32819);

return statearr_32923;
})();
var statearr_32925_35188 = state_32879__$1;
(statearr_32925_35188[(2)] = null);

(statearr_32925_35188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (3))){
var inst_32877 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32879__$1,inst_32877);
} else {
if((state_val_32880 === (12))){
var inst_32854 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
var statearr_32931_35189 = state_32879__$1;
(statearr_32931_35189[(2)] = inst_32854);

(statearr_32931_35189[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (2))){
var state_32879__$1 = state_32879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32879__$1,(4),ch);
} else {
if((state_val_32880 === (23))){
var state_32879__$1 = state_32879;
var statearr_32932_35190 = state_32879__$1;
(statearr_32932_35190[(2)] = null);

(statearr_32932_35190[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (19))){
var inst_32807 = (state_32879[(8)]);
var inst_32860 = (state_32879[(11)]);
var inst_32862 = cljs.core.async.muxch_STAR_(inst_32860);
var state_32879__$1 = state_32879;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32879__$1,(22),inst_32862,inst_32807);
} else {
if((state_val_32880 === (11))){
var inst_32817 = (state_32879[(12)]);
var inst_32833 = (state_32879[(10)]);
var inst_32833__$1 = cljs.core.seq(inst_32817);
var state_32879__$1 = (function (){var statearr_32933 = state_32879;
(statearr_32933[(10)] = inst_32833__$1);

return statearr_32933;
})();
if(inst_32833__$1){
var statearr_32934_35191 = state_32879__$1;
(statearr_32934_35191[(1)] = (13));

} else {
var statearr_32935_35192 = state_32879__$1;
(statearr_32935_35192[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (9))){
var inst_32856 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
var statearr_32936_35193 = state_32879__$1;
(statearr_32936_35193[(2)] = inst_32856);

(statearr_32936_35193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (5))){
var inst_32814 = cljs.core.deref(mults);
var inst_32815 = cljs.core.vals(inst_32814);
var inst_32816 = cljs.core.seq(inst_32815);
var inst_32817 = inst_32816;
var inst_32818 = null;
var inst_32819 = (0);
var inst_32820 = (0);
var state_32879__$1 = (function (){var statearr_32938 = state_32879;
(statearr_32938[(12)] = inst_32817);

(statearr_32938[(13)] = inst_32818);

(statearr_32938[(14)] = inst_32820);

(statearr_32938[(16)] = inst_32819);

return statearr_32938;
})();
var statearr_32939_35194 = state_32879__$1;
(statearr_32939_35194[(2)] = null);

(statearr_32939_35194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (14))){
var state_32879__$1 = state_32879;
var statearr_32943_35195 = state_32879__$1;
(statearr_32943_35195[(2)] = null);

(statearr_32943_35195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (16))){
var inst_32833 = (state_32879[(10)]);
var inst_32838 = cljs.core.chunk_first(inst_32833);
var inst_32839 = cljs.core.chunk_rest(inst_32833);
var inst_32840 = cljs.core.count(inst_32838);
var inst_32817 = inst_32839;
var inst_32818 = inst_32838;
var inst_32819 = inst_32840;
var inst_32820 = (0);
var state_32879__$1 = (function (){var statearr_32944 = state_32879;
(statearr_32944[(12)] = inst_32817);

(statearr_32944[(13)] = inst_32818);

(statearr_32944[(14)] = inst_32820);

(statearr_32944[(16)] = inst_32819);

return statearr_32944;
})();
var statearr_32945_35196 = state_32879__$1;
(statearr_32945_35196[(2)] = null);

(statearr_32945_35196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (10))){
var inst_32817 = (state_32879[(12)]);
var inst_32818 = (state_32879[(13)]);
var inst_32820 = (state_32879[(14)]);
var inst_32819 = (state_32879[(16)]);
var inst_32826 = cljs.core._nth(inst_32818,inst_32820);
var inst_32828 = cljs.core.async.muxch_STAR_(inst_32826);
var inst_32829 = cljs.core.async.close_BANG_(inst_32828);
var inst_32830 = (inst_32820 + (1));
var tmp32940 = inst_32817;
var tmp32941 = inst_32818;
var tmp32942 = inst_32819;
var inst_32817__$1 = tmp32940;
var inst_32818__$1 = tmp32941;
var inst_32819__$1 = tmp32942;
var inst_32820__$1 = inst_32830;
var state_32879__$1 = (function (){var statearr_32946 = state_32879;
(statearr_32946[(12)] = inst_32817__$1);

(statearr_32946[(13)] = inst_32818__$1);

(statearr_32946[(14)] = inst_32820__$1);

(statearr_32946[(16)] = inst_32819__$1);

(statearr_32946[(17)] = inst_32829);

return statearr_32946;
})();
var statearr_32948_35197 = state_32879__$1;
(statearr_32948_35197[(2)] = null);

(statearr_32948_35197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (18))){
var inst_32849 = (state_32879[(2)]);
var state_32879__$1 = state_32879;
var statearr_32950_35198 = state_32879__$1;
(statearr_32950_35198[(2)] = inst_32849);

(statearr_32950_35198[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32880 === (8))){
var inst_32820 = (state_32879[(14)]);
var inst_32819 = (state_32879[(16)]);
var inst_32822 = (inst_32820 < inst_32819);
var inst_32823 = inst_32822;
var state_32879__$1 = state_32879;
if(cljs.core.truth_(inst_32823)){
var statearr_32951_35201 = state_32879__$1;
(statearr_32951_35201[(1)] = (10));

} else {
var statearr_32952_35203 = state_32879__$1;
(statearr_32952_35203[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_32954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32954[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_32954[(1)] = (1));

return statearr_32954;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_32879){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_32879);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e32957){var ex__30606__auto__ = e32957;
var statearr_32958_35204 = state_32879;
(statearr_32958_35204[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_32879[(4)]))){
var statearr_32959_35205 = state_32879;
(statearr_32959_35205[(1)] = cljs.core.first((state_32879[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35206 = state_32879;
state_32879 = G__35206;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_32879){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_32879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_32960 = f__30975__auto__();
(statearr_32960[(6)] = c__30974__auto___35147);

return statearr_32960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32963 = arguments.length;
switch (G__32963) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32974 = arguments.length;
switch (G__32974) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32992 = arguments.length;
switch (G__32992) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30974__auto___35226 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_33098){
var state_val_33100 = (state_33098[(1)]);
if((state_val_33100 === (7))){
var state_33098__$1 = state_33098;
var statearr_33106_35228 = state_33098__$1;
(statearr_33106_35228[(2)] = null);

(statearr_33106_35228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (1))){
var state_33098__$1 = state_33098;
var statearr_33110_35232 = state_33098__$1;
(statearr_33110_35232[(2)] = null);

(statearr_33110_35232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (4))){
var inst_32997 = (state_33098[(7)]);
var inst_32998 = (state_33098[(8)]);
var inst_33000 = (inst_32998 < inst_32997);
var state_33098__$1 = state_33098;
if(cljs.core.truth_(inst_33000)){
var statearr_33113_35235 = state_33098__$1;
(statearr_33113_35235[(1)] = (6));

} else {
var statearr_33115_35236 = state_33098__$1;
(statearr_33115_35236[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (15))){
var inst_33078 = (state_33098[(9)]);
var inst_33085 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33078);
var state_33098__$1 = state_33098;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33098__$1,(17),out,inst_33085);
} else {
if((state_val_33100 === (13))){
var inst_33078 = (state_33098[(9)]);
var inst_33078__$1 = (state_33098[(2)]);
var inst_33080 = cljs.core.some(cljs.core.nil_QMARK_,inst_33078__$1);
var state_33098__$1 = (function (){var statearr_33154 = state_33098;
(statearr_33154[(9)] = inst_33078__$1);

return statearr_33154;
})();
if(cljs.core.truth_(inst_33080)){
var statearr_33160_35238 = state_33098__$1;
(statearr_33160_35238[(1)] = (14));

} else {
var statearr_33166_35239 = state_33098__$1;
(statearr_33166_35239[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (6))){
var state_33098__$1 = state_33098;
var statearr_33173_35241 = state_33098__$1;
(statearr_33173_35241[(2)] = null);

(statearr_33173_35241[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (17))){
var inst_33087 = (state_33098[(2)]);
var state_33098__$1 = (function (){var statearr_33196 = state_33098;
(statearr_33196[(10)] = inst_33087);

return statearr_33196;
})();
var statearr_33199_35242 = state_33098__$1;
(statearr_33199_35242[(2)] = null);

(statearr_33199_35242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (3))){
var inst_33094 = (state_33098[(2)]);
var state_33098__$1 = state_33098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33098__$1,inst_33094);
} else {
if((state_val_33100 === (12))){
var _ = (function (){var statearr_33200 = state_33098;
(statearr_33200[(4)] = cljs.core.rest((state_33098[(4)])));

return statearr_33200;
})();
var state_33098__$1 = state_33098;
var ex33191 = (state_33098__$1[(2)]);
var statearr_33204_35243 = state_33098__$1;
(statearr_33204_35243[(5)] = ex33191);


if((ex33191 instanceof Object)){
var statearr_33208_35244 = state_33098__$1;
(statearr_33208_35244[(1)] = (11));

(statearr_33208_35244[(5)] = null);

} else {
throw ex33191;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (2))){
var inst_32996 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32997 = cnt;
var inst_32998 = (0);
var state_33098__$1 = (function (){var statearr_33224 = state_33098;
(statearr_33224[(11)] = inst_32996);

(statearr_33224[(7)] = inst_32997);

(statearr_33224[(8)] = inst_32998);

return statearr_33224;
})();
var statearr_33239_35245 = state_33098__$1;
(statearr_33239_35245[(2)] = null);

(statearr_33239_35245[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (11))){
var inst_33043 = (state_33098[(2)]);
var inst_33049 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33098__$1 = (function (){var statearr_33244 = state_33098;
(statearr_33244[(12)] = inst_33043);

return statearr_33244;
})();
var statearr_33245_35255 = state_33098__$1;
(statearr_33245_35255[(2)] = inst_33049);

(statearr_33245_35255[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (9))){
var inst_32998 = (state_33098[(8)]);
var _ = (function (){var statearr_33248 = state_33098;
(statearr_33248[(4)] = cljs.core.cons((12),(state_33098[(4)])));

return statearr_33248;
})();
var inst_33062 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32998) : chs__$1.call(null,inst_32998));
var inst_33063 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32998) : done.call(null,inst_32998));
var inst_33064 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33062,inst_33063);
var ___$1 = (function (){var statearr_33249 = state_33098;
(statearr_33249[(4)] = cljs.core.rest((state_33098[(4)])));

return statearr_33249;
})();
var state_33098__$1 = state_33098;
var statearr_33253_35256 = state_33098__$1;
(statearr_33253_35256[(2)] = inst_33064);

(statearr_33253_35256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (5))){
var inst_33075 = (state_33098[(2)]);
var state_33098__$1 = (function (){var statearr_33254 = state_33098;
(statearr_33254[(13)] = inst_33075);

return statearr_33254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33098__$1,(13),dchan);
} else {
if((state_val_33100 === (14))){
var inst_33082 = cljs.core.async.close_BANG_(out);
var state_33098__$1 = state_33098;
var statearr_33256_35258 = state_33098__$1;
(statearr_33256_35258[(2)] = inst_33082);

(statearr_33256_35258[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (16))){
var inst_33090 = (state_33098[(2)]);
var state_33098__$1 = state_33098;
var statearr_33257_35259 = state_33098__$1;
(statearr_33257_35259[(2)] = inst_33090);

(statearr_33257_35259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (10))){
var inst_32998 = (state_33098[(8)]);
var inst_33067 = (state_33098[(2)]);
var inst_33069 = (inst_32998 + (1));
var inst_32998__$1 = inst_33069;
var state_33098__$1 = (function (){var statearr_33259 = state_33098;
(statearr_33259[(14)] = inst_33067);

(statearr_33259[(8)] = inst_32998__$1);

return statearr_33259;
})();
var statearr_33260_35260 = state_33098__$1;
(statearr_33260_35260[(2)] = null);

(statearr_33260_35260[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (8))){
var inst_33073 = (state_33098[(2)]);
var state_33098__$1 = state_33098;
var statearr_33263_35261 = state_33098__$1;
(statearr_33263_35261[(2)] = inst_33073);

(statearr_33263_35261[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_33265 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33265[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_33265[(1)] = (1));

return statearr_33265;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_33098){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_33098);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e33267){var ex__30606__auto__ = e33267;
var statearr_33268_35262 = state_33098;
(statearr_33268_35262[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_33098[(4)]))){
var statearr_33269_35263 = state_33098;
(statearr_33269_35263[(1)] = cljs.core.first((state_33098[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35264 = state_33098;
state_33098 = G__35264;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_33098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_33098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_33275 = f__30975__auto__();
(statearr_33275[(6)] = c__30974__auto___35226);

return statearr_33275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33285 = arguments.length;
switch (G__33285) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30974__auto___35268 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_33341){
var state_val_33342 = (state_33341[(1)]);
if((state_val_33342 === (7))){
var inst_33306 = (state_33341[(7)]);
var inst_33304 = (state_33341[(8)]);
var inst_33304__$1 = (state_33341[(2)]);
var inst_33306__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33304__$1,(0),null);
var inst_33308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33304__$1,(1),null);
var inst_33310 = (inst_33306__$1 == null);
var state_33341__$1 = (function (){var statearr_33348 = state_33341;
(statearr_33348[(9)] = inst_33308);

(statearr_33348[(7)] = inst_33306__$1);

(statearr_33348[(8)] = inst_33304__$1);

return statearr_33348;
})();
if(cljs.core.truth_(inst_33310)){
var statearr_33375_35270 = state_33341__$1;
(statearr_33375_35270[(1)] = (8));

} else {
var statearr_33381_35271 = state_33341__$1;
(statearr_33381_35271[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (1))){
var inst_33292 = cljs.core.vec(chs);
var inst_33293 = inst_33292;
var state_33341__$1 = (function (){var statearr_33382 = state_33341;
(statearr_33382[(10)] = inst_33293);

return statearr_33382;
})();
var statearr_33385_35272 = state_33341__$1;
(statearr_33385_35272[(2)] = null);

(statearr_33385_35272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (4))){
var inst_33293 = (state_33341[(10)]);
var state_33341__$1 = state_33341;
return cljs.core.async.ioc_alts_BANG_(state_33341__$1,(7),inst_33293);
} else {
if((state_val_33342 === (6))){
var inst_33326 = (state_33341[(2)]);
var state_33341__$1 = state_33341;
var statearr_33391_35273 = state_33341__$1;
(statearr_33391_35273[(2)] = inst_33326);

(statearr_33391_35273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (3))){
var inst_33328 = (state_33341[(2)]);
var state_33341__$1 = state_33341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33341__$1,inst_33328);
} else {
if((state_val_33342 === (2))){
var inst_33293 = (state_33341[(10)]);
var inst_33295 = cljs.core.count(inst_33293);
var inst_33296 = (inst_33295 > (0));
var state_33341__$1 = state_33341;
if(cljs.core.truth_(inst_33296)){
var statearr_33397_35276 = state_33341__$1;
(statearr_33397_35276[(1)] = (4));

} else {
var statearr_33398_35277 = state_33341__$1;
(statearr_33398_35277[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (11))){
var inst_33293 = (state_33341[(10)]);
var inst_33319 = (state_33341[(2)]);
var tmp33392 = inst_33293;
var inst_33293__$1 = tmp33392;
var state_33341__$1 = (function (){var statearr_33402 = state_33341;
(statearr_33402[(11)] = inst_33319);

(statearr_33402[(10)] = inst_33293__$1);

return statearr_33402;
})();
var statearr_33404_35278 = state_33341__$1;
(statearr_33404_35278[(2)] = null);

(statearr_33404_35278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (9))){
var inst_33306 = (state_33341[(7)]);
var state_33341__$1 = state_33341;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33341__$1,(11),out,inst_33306);
} else {
if((state_val_33342 === (5))){
var inst_33324 = cljs.core.async.close_BANG_(out);
var state_33341__$1 = state_33341;
var statearr_33414_35279 = state_33341__$1;
(statearr_33414_35279[(2)] = inst_33324);

(statearr_33414_35279[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (10))){
var inst_33322 = (state_33341[(2)]);
var state_33341__$1 = state_33341;
var statearr_33415_35280 = state_33341__$1;
(statearr_33415_35280[(2)] = inst_33322);

(statearr_33415_35280[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33342 === (8))){
var inst_33308 = (state_33341[(9)]);
var inst_33306 = (state_33341[(7)]);
var inst_33293 = (state_33341[(10)]);
var inst_33304 = (state_33341[(8)]);
var inst_33313 = (function (){var cs = inst_33293;
var vec__33299 = inst_33304;
var v = inst_33306;
var c = inst_33308;
return (function (p1__33280_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33280_SHARP_);
});
})();
var inst_33315 = cljs.core.filterv(inst_33313,inst_33293);
var inst_33293__$1 = inst_33315;
var state_33341__$1 = (function (){var statearr_33420 = state_33341;
(statearr_33420[(10)] = inst_33293__$1);

return statearr_33420;
})();
var statearr_33421_35281 = state_33341__$1;
(statearr_33421_35281[(2)] = null);

(statearr_33421_35281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_33426 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33426[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_33426[(1)] = (1));

return statearr_33426;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_33341){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_33341);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e33431){var ex__30606__auto__ = e33431;
var statearr_33433_35283 = state_33341;
(statearr_33433_35283[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_33341[(4)]))){
var statearr_33436_35285 = state_33341;
(statearr_33436_35285[(1)] = cljs.core.first((state_33341[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35286 = state_33341;
state_33341 = G__35286;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_33341){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_33341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_33444 = f__30975__auto__();
(statearr_33444[(6)] = c__30974__auto___35268);

return statearr_33444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33464 = arguments.length;
switch (G__33464) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30974__auto___35288 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_33523){
var state_val_33524 = (state_33523[(1)]);
if((state_val_33524 === (7))){
var inst_33497 = (state_33523[(7)]);
var inst_33497__$1 = (state_33523[(2)]);
var inst_33498 = (inst_33497__$1 == null);
var inst_33499 = cljs.core.not(inst_33498);
var state_33523__$1 = (function (){var statearr_33533 = state_33523;
(statearr_33533[(7)] = inst_33497__$1);

return statearr_33533;
})();
if(inst_33499){
var statearr_33535_35289 = state_33523__$1;
(statearr_33535_35289[(1)] = (8));

} else {
var statearr_33536_35290 = state_33523__$1;
(statearr_33536_35290[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (1))){
var inst_33487 = (0);
var state_33523__$1 = (function (){var statearr_33542 = state_33523;
(statearr_33542[(8)] = inst_33487);

return statearr_33542;
})();
var statearr_33546_35295 = state_33523__$1;
(statearr_33546_35295[(2)] = null);

(statearr_33546_35295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (4))){
var state_33523__$1 = state_33523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33523__$1,(7),ch);
} else {
if((state_val_33524 === (6))){
var inst_33512 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33556_35296 = state_33523__$1;
(statearr_33556_35296[(2)] = inst_33512);

(statearr_33556_35296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (3))){
var inst_33514 = (state_33523[(2)]);
var inst_33515 = cljs.core.async.close_BANG_(out);
var state_33523__$1 = (function (){var statearr_33557 = state_33523;
(statearr_33557[(9)] = inst_33514);

return statearr_33557;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33523__$1,inst_33515);
} else {
if((state_val_33524 === (2))){
var inst_33487 = (state_33523[(8)]);
var inst_33491 = (inst_33487 < n);
var state_33523__$1 = state_33523;
if(cljs.core.truth_(inst_33491)){
var statearr_33562_35297 = state_33523__$1;
(statearr_33562_35297[(1)] = (4));

} else {
var statearr_33563_35298 = state_33523__$1;
(statearr_33563_35298[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (11))){
var inst_33487 = (state_33523[(8)]);
var inst_33502 = (state_33523[(2)]);
var inst_33503 = (inst_33487 + (1));
var inst_33487__$1 = inst_33503;
var state_33523__$1 = (function (){var statearr_33568 = state_33523;
(statearr_33568[(8)] = inst_33487__$1);

(statearr_33568[(10)] = inst_33502);

return statearr_33568;
})();
var statearr_33569_35299 = state_33523__$1;
(statearr_33569_35299[(2)] = null);

(statearr_33569_35299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (9))){
var state_33523__$1 = state_33523;
var statearr_33571_35307 = state_33523__$1;
(statearr_33571_35307[(2)] = null);

(statearr_33571_35307[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (5))){
var state_33523__$1 = state_33523;
var statearr_33573_35308 = state_33523__$1;
(statearr_33573_35308[(2)] = null);

(statearr_33573_35308[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (10))){
var inst_33509 = (state_33523[(2)]);
var state_33523__$1 = state_33523;
var statearr_33576_35309 = state_33523__$1;
(statearr_33576_35309[(2)] = inst_33509);

(statearr_33576_35309[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33524 === (8))){
var inst_33497 = (state_33523[(7)]);
var state_33523__$1 = state_33523;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33523__$1,(11),out,inst_33497);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_33580 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33580[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_33580[(1)] = (1));

return statearr_33580;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_33523){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_33523);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e33583){var ex__30606__auto__ = e33583;
var statearr_33584_35313 = state_33523;
(statearr_33584_35313[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_33523[(4)]))){
var statearr_33585_35316 = state_33523;
(statearr_33585_35316[(1)] = cljs.core.first((state_33523[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35317 = state_33523;
state_33523 = G__35317;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_33523){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_33523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_33591 = f__30975__auto__();
(statearr_33591[(6)] = c__30974__auto___35288);

return statearr_33591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33595 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33595 = (function (f,ch,meta33596){
this.f = f;
this.ch = ch;
this.meta33596 = meta33596;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33597,meta33596__$1){
var self__ = this;
var _33597__$1 = this;
return (new cljs.core.async.t_cljs$core$async33595(self__.f,self__.ch,meta33596__$1));
}));

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33597){
var self__ = this;
var _33597__$1 = this;
return self__.meta33596;
}));

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33614 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33614 = (function (f,ch,meta33596,_,fn1,meta33615){
this.f = f;
this.ch = ch;
this.meta33596 = meta33596;
this._ = _;
this.fn1 = fn1;
this.meta33615 = meta33615;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33616,meta33615__$1){
var self__ = this;
var _33616__$1 = this;
return (new cljs.core.async.t_cljs$core$async33614(self__.f,self__.ch,self__.meta33596,self__._,self__.fn1,meta33615__$1));
}));

(cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33616){
var self__ = this;
var _33616__$1 = this;
return self__.meta33615;
}));

(cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33594_SHARP_){
var G__33629 = (((p1__33594_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33594_SHARP_) : self__.f.call(null,p1__33594_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33629) : f1.call(null,G__33629));
});
}));

(cljs.core.async.t_cljs$core$async33614.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33596","meta33596",-1120226720,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33595","cljs.core.async/t_cljs$core$async33595",60404930,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33615","meta33615",-1603099409,null)], null);
}));

(cljs.core.async.t_cljs$core$async33614.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33614.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33614");

(cljs.core.async.t_cljs$core$async33614.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33614");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33614.
 */
cljs.core.async.__GT_t_cljs$core$async33614 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33614(f__$1,ch__$1,meta33596__$1,___$2,fn1__$1,meta33615){
return (new cljs.core.async.t_cljs$core$async33614(f__$1,ch__$1,meta33596__$1,___$2,fn1__$1,meta33615));
});

}

return (new cljs.core.async.t_cljs$core$async33614(self__.f,self__.ch,self__.meta33596,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33636 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33636) : self__.f.call(null,G__33636));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33595.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33595.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33596","meta33596",-1120226720,null)], null);
}));

(cljs.core.async.t_cljs$core$async33595.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33595.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33595");

(cljs.core.async.t_cljs$core$async33595.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33595");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33595.
 */
cljs.core.async.__GT_t_cljs$core$async33595 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33595(f__$1,ch__$1,meta33596){
return (new cljs.core.async.t_cljs$core$async33595(f__$1,ch__$1,meta33596));
});

}

return (new cljs.core.async.t_cljs$core$async33595(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33648 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33648 = (function (f,ch,meta33649){
this.f = f;
this.ch = ch;
this.meta33649 = meta33649;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33650,meta33649__$1){
var self__ = this;
var _33650__$1 = this;
return (new cljs.core.async.t_cljs$core$async33648(self__.f,self__.ch,meta33649__$1));
}));

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33650){
var self__ = this;
var _33650__$1 = this;
return self__.meta33649;
}));

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33648.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33649","meta33649",637761193,null)], null);
}));

(cljs.core.async.t_cljs$core$async33648.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33648.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33648");

(cljs.core.async.t_cljs$core$async33648.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33648");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33648.
 */
cljs.core.async.__GT_t_cljs$core$async33648 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33648(f__$1,ch__$1,meta33649){
return (new cljs.core.async.t_cljs$core$async33648(f__$1,ch__$1,meta33649));
});

}

return (new cljs.core.async.t_cljs$core$async33648(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33687 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33687 = (function (p,ch,meta33688){
this.p = p;
this.ch = ch;
this.meta33688 = meta33688;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33689,meta33688__$1){
var self__ = this;
var _33689__$1 = this;
return (new cljs.core.async.t_cljs$core$async33687(self__.p,self__.ch,meta33688__$1));
}));

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33689){
var self__ = this;
var _33689__$1 = this;
return self__.meta33688;
}));

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33687.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33687.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33688","meta33688",965578810,null)], null);
}));

(cljs.core.async.t_cljs$core$async33687.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33687.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33687");

(cljs.core.async.t_cljs$core$async33687.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33687");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33687.
 */
cljs.core.async.__GT_t_cljs$core$async33687 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33687(p__$1,ch__$1,meta33688){
return (new cljs.core.async.t_cljs$core$async33687(p__$1,ch__$1,meta33688));
});

}

return (new cljs.core.async.t_cljs$core$async33687(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33696 = arguments.length;
switch (G__33696) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30974__auto___35354 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_33719){
var state_val_33720 = (state_33719[(1)]);
if((state_val_33720 === (7))){
var inst_33715 = (state_33719[(2)]);
var state_33719__$1 = state_33719;
var statearr_33724_35358 = state_33719__$1;
(statearr_33724_35358[(2)] = inst_33715);

(statearr_33724_35358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (1))){
var state_33719__$1 = state_33719;
var statearr_33725_35360 = state_33719__$1;
(statearr_33725_35360[(2)] = null);

(statearr_33725_35360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (4))){
var inst_33701 = (state_33719[(7)]);
var inst_33701__$1 = (state_33719[(2)]);
var inst_33702 = (inst_33701__$1 == null);
var state_33719__$1 = (function (){var statearr_33729 = state_33719;
(statearr_33729[(7)] = inst_33701__$1);

return statearr_33729;
})();
if(cljs.core.truth_(inst_33702)){
var statearr_33730_35361 = state_33719__$1;
(statearr_33730_35361[(1)] = (5));

} else {
var statearr_33731_35362 = state_33719__$1;
(statearr_33731_35362[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (6))){
var inst_33701 = (state_33719[(7)]);
var inst_33706 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33701) : p.call(null,inst_33701));
var state_33719__$1 = state_33719;
if(cljs.core.truth_(inst_33706)){
var statearr_33733_35366 = state_33719__$1;
(statearr_33733_35366[(1)] = (8));

} else {
var statearr_33734_35367 = state_33719__$1;
(statearr_33734_35367[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (3))){
var inst_33717 = (state_33719[(2)]);
var state_33719__$1 = state_33719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33719__$1,inst_33717);
} else {
if((state_val_33720 === (2))){
var state_33719__$1 = state_33719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33719__$1,(4),ch);
} else {
if((state_val_33720 === (11))){
var inst_33709 = (state_33719[(2)]);
var state_33719__$1 = state_33719;
var statearr_33738_35369 = state_33719__$1;
(statearr_33738_35369[(2)] = inst_33709);

(statearr_33738_35369[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (9))){
var state_33719__$1 = state_33719;
var statearr_33739_35370 = state_33719__$1;
(statearr_33739_35370[(2)] = null);

(statearr_33739_35370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (5))){
var inst_33704 = cljs.core.async.close_BANG_(out);
var state_33719__$1 = state_33719;
var statearr_33744_35371 = state_33719__$1;
(statearr_33744_35371[(2)] = inst_33704);

(statearr_33744_35371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (10))){
var inst_33712 = (state_33719[(2)]);
var state_33719__$1 = (function (){var statearr_33745 = state_33719;
(statearr_33745[(8)] = inst_33712);

return statearr_33745;
})();
var statearr_33746_35372 = state_33719__$1;
(statearr_33746_35372[(2)] = null);

(statearr_33746_35372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33720 === (8))){
var inst_33701 = (state_33719[(7)]);
var state_33719__$1 = state_33719;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33719__$1,(11),out,inst_33701);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_33750 = [null,null,null,null,null,null,null,null,null];
(statearr_33750[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_33750[(1)] = (1));

return statearr_33750;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_33719){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_33719);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e33752){var ex__30606__auto__ = e33752;
var statearr_33753_35373 = state_33719;
(statearr_33753_35373[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_33719[(4)]))){
var statearr_33755_35374 = state_33719;
(statearr_33755_35374[(1)] = cljs.core.first((state_33719[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35375 = state_33719;
state_33719 = G__35375;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_33719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_33719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_33756 = f__30975__auto__();
(statearr_33756[(6)] = c__30974__auto___35354);

return statearr_33756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33761 = arguments.length;
switch (G__33761) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_33829){
var state_val_33831 = (state_33829[(1)]);
if((state_val_33831 === (7))){
var inst_33824 = (state_33829[(2)]);
var state_33829__$1 = state_33829;
var statearr_33834_35385 = state_33829__$1;
(statearr_33834_35385[(2)] = inst_33824);

(statearr_33834_35385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (20))){
var inst_33794 = (state_33829[(7)]);
var inst_33805 = (state_33829[(2)]);
var inst_33806 = cljs.core.next(inst_33794);
var inst_33780 = inst_33806;
var inst_33781 = null;
var inst_33782 = (0);
var inst_33783 = (0);
var state_33829__$1 = (function (){var statearr_33835 = state_33829;
(statearr_33835[(8)] = inst_33782);

(statearr_33835[(9)] = inst_33780);

(statearr_33835[(10)] = inst_33805);

(statearr_33835[(11)] = inst_33783);

(statearr_33835[(12)] = inst_33781);

return statearr_33835;
})();
var statearr_33836_35386 = state_33829__$1;
(statearr_33836_35386[(2)] = null);

(statearr_33836_35386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (1))){
var state_33829__$1 = state_33829;
var statearr_33837_35387 = state_33829__$1;
(statearr_33837_35387[(2)] = null);

(statearr_33837_35387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (4))){
var inst_33769 = (state_33829[(13)]);
var inst_33769__$1 = (state_33829[(2)]);
var inst_33770 = (inst_33769__$1 == null);
var state_33829__$1 = (function (){var statearr_33838 = state_33829;
(statearr_33838[(13)] = inst_33769__$1);

return statearr_33838;
})();
if(cljs.core.truth_(inst_33770)){
var statearr_33840_35389 = state_33829__$1;
(statearr_33840_35389[(1)] = (5));

} else {
var statearr_33841_35390 = state_33829__$1;
(statearr_33841_35390[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (15))){
var state_33829__$1 = state_33829;
var statearr_33845_35391 = state_33829__$1;
(statearr_33845_35391[(2)] = null);

(statearr_33845_35391[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (21))){
var state_33829__$1 = state_33829;
var statearr_33846_35392 = state_33829__$1;
(statearr_33846_35392[(2)] = null);

(statearr_33846_35392[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (13))){
var inst_33782 = (state_33829[(8)]);
var inst_33780 = (state_33829[(9)]);
var inst_33783 = (state_33829[(11)]);
var inst_33781 = (state_33829[(12)]);
var inst_33790 = (state_33829[(2)]);
var inst_33791 = (inst_33783 + (1));
var tmp33842 = inst_33782;
var tmp33843 = inst_33780;
var tmp33844 = inst_33781;
var inst_33780__$1 = tmp33843;
var inst_33781__$1 = tmp33844;
var inst_33782__$1 = tmp33842;
var inst_33783__$1 = inst_33791;
var state_33829__$1 = (function (){var statearr_33848 = state_33829;
(statearr_33848[(8)] = inst_33782__$1);

(statearr_33848[(14)] = inst_33790);

(statearr_33848[(9)] = inst_33780__$1);

(statearr_33848[(11)] = inst_33783__$1);

(statearr_33848[(12)] = inst_33781__$1);

return statearr_33848;
})();
var statearr_33850_35393 = state_33829__$1;
(statearr_33850_35393[(2)] = null);

(statearr_33850_35393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (22))){
var state_33829__$1 = state_33829;
var statearr_33851_35394 = state_33829__$1;
(statearr_33851_35394[(2)] = null);

(statearr_33851_35394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (6))){
var inst_33769 = (state_33829[(13)]);
var inst_33778 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33769) : f.call(null,inst_33769));
var inst_33779 = cljs.core.seq(inst_33778);
var inst_33780 = inst_33779;
var inst_33781 = null;
var inst_33782 = (0);
var inst_33783 = (0);
var state_33829__$1 = (function (){var statearr_33853 = state_33829;
(statearr_33853[(8)] = inst_33782);

(statearr_33853[(9)] = inst_33780);

(statearr_33853[(11)] = inst_33783);

(statearr_33853[(12)] = inst_33781);

return statearr_33853;
})();
var statearr_33854_35397 = state_33829__$1;
(statearr_33854_35397[(2)] = null);

(statearr_33854_35397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (17))){
var inst_33794 = (state_33829[(7)]);
var inst_33798 = cljs.core.chunk_first(inst_33794);
var inst_33799 = cljs.core.chunk_rest(inst_33794);
var inst_33800 = cljs.core.count(inst_33798);
var inst_33780 = inst_33799;
var inst_33781 = inst_33798;
var inst_33782 = inst_33800;
var inst_33783 = (0);
var state_33829__$1 = (function (){var statearr_33856 = state_33829;
(statearr_33856[(8)] = inst_33782);

(statearr_33856[(9)] = inst_33780);

(statearr_33856[(11)] = inst_33783);

(statearr_33856[(12)] = inst_33781);

return statearr_33856;
})();
var statearr_33857_35399 = state_33829__$1;
(statearr_33857_35399[(2)] = null);

(statearr_33857_35399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (3))){
var inst_33826 = (state_33829[(2)]);
var state_33829__$1 = state_33829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33829__$1,inst_33826);
} else {
if((state_val_33831 === (12))){
var inst_33814 = (state_33829[(2)]);
var state_33829__$1 = state_33829;
var statearr_33858_35402 = state_33829__$1;
(statearr_33858_35402[(2)] = inst_33814);

(statearr_33858_35402[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (2))){
var state_33829__$1 = state_33829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33829__$1,(4),in$);
} else {
if((state_val_33831 === (23))){
var inst_33822 = (state_33829[(2)]);
var state_33829__$1 = state_33829;
var statearr_33859_35403 = state_33829__$1;
(statearr_33859_35403[(2)] = inst_33822);

(statearr_33859_35403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (19))){
var inst_33809 = (state_33829[(2)]);
var state_33829__$1 = state_33829;
var statearr_33860_35404 = state_33829__$1;
(statearr_33860_35404[(2)] = inst_33809);

(statearr_33860_35404[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (11))){
var inst_33780 = (state_33829[(9)]);
var inst_33794 = (state_33829[(7)]);
var inst_33794__$1 = cljs.core.seq(inst_33780);
var state_33829__$1 = (function (){var statearr_33862 = state_33829;
(statearr_33862[(7)] = inst_33794__$1);

return statearr_33862;
})();
if(inst_33794__$1){
var statearr_33863_35405 = state_33829__$1;
(statearr_33863_35405[(1)] = (14));

} else {
var statearr_33864_35406 = state_33829__$1;
(statearr_33864_35406[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (9))){
var inst_33816 = (state_33829[(2)]);
var inst_33817 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33829__$1 = (function (){var statearr_33866 = state_33829;
(statearr_33866[(15)] = inst_33816);

return statearr_33866;
})();
if(cljs.core.truth_(inst_33817)){
var statearr_33867_35407 = state_33829__$1;
(statearr_33867_35407[(1)] = (21));

} else {
var statearr_33868_35408 = state_33829__$1;
(statearr_33868_35408[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (5))){
var inst_33772 = cljs.core.async.close_BANG_(out);
var state_33829__$1 = state_33829;
var statearr_33869_35409 = state_33829__$1;
(statearr_33869_35409[(2)] = inst_33772);

(statearr_33869_35409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (14))){
var inst_33794 = (state_33829[(7)]);
var inst_33796 = cljs.core.chunked_seq_QMARK_(inst_33794);
var state_33829__$1 = state_33829;
if(inst_33796){
var statearr_33871_35411 = state_33829__$1;
(statearr_33871_35411[(1)] = (17));

} else {
var statearr_33872_35412 = state_33829__$1;
(statearr_33872_35412[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (16))){
var inst_33812 = (state_33829[(2)]);
var state_33829__$1 = state_33829;
var statearr_33878_35413 = state_33829__$1;
(statearr_33878_35413[(2)] = inst_33812);

(statearr_33878_35413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33831 === (10))){
var inst_33783 = (state_33829[(11)]);
var inst_33781 = (state_33829[(12)]);
var inst_33788 = cljs.core._nth(inst_33781,inst_33783);
var state_33829__$1 = state_33829;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33829__$1,(13),out,inst_33788);
} else {
if((state_val_33831 === (18))){
var inst_33794 = (state_33829[(7)]);
var inst_33803 = cljs.core.first(inst_33794);
var state_33829__$1 = state_33829;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33829__$1,(20),out,inst_33803);
} else {
if((state_val_33831 === (8))){
var inst_33782 = (state_33829[(8)]);
var inst_33783 = (state_33829[(11)]);
var inst_33785 = (inst_33783 < inst_33782);
var inst_33786 = inst_33785;
var state_33829__$1 = state_33829;
if(cljs.core.truth_(inst_33786)){
var statearr_33884_35415 = state_33829__$1;
(statearr_33884_35415[(1)] = (10));

} else {
var statearr_33885_35416 = state_33829__$1;
(statearr_33885_35416[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30603__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30603__auto____0 = (function (){
var statearr_33890 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33890[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30603__auto__);

(statearr_33890[(1)] = (1));

return statearr_33890;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30603__auto____1 = (function (state_33829){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_33829);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e33891){var ex__30606__auto__ = e33891;
var statearr_33892_35421 = state_33829;
(statearr_33892_35421[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_33829[(4)]))){
var statearr_33899_35422 = state_33829;
(statearr_33899_35422[(1)] = cljs.core.first((state_33829[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35423 = state_33829;
state_33829 = G__35423;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30603__auto__ = function(state_33829){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30603__auto____1.call(this,state_33829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30603__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30603__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_33900 = f__30975__auto__();
(statearr_33900[(6)] = c__30974__auto__);

return statearr_33900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

return c__30974__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33906 = arguments.length;
switch (G__33906) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33911 = arguments.length;
switch (G__33911) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33917 = arguments.length;
switch (G__33917) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30974__auto___35428 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_33946){
var state_val_33947 = (state_33946[(1)]);
if((state_val_33947 === (7))){
var inst_33941 = (state_33946[(2)]);
var state_33946__$1 = state_33946;
var statearr_33953_35433 = state_33946__$1;
(statearr_33953_35433[(2)] = inst_33941);

(statearr_33953_35433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (1))){
var inst_33922 = null;
var state_33946__$1 = (function (){var statearr_33954 = state_33946;
(statearr_33954[(7)] = inst_33922);

return statearr_33954;
})();
var statearr_33957_35434 = state_33946__$1;
(statearr_33957_35434[(2)] = null);

(statearr_33957_35434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (4))){
var inst_33925 = (state_33946[(8)]);
var inst_33925__$1 = (state_33946[(2)]);
var inst_33926 = (inst_33925__$1 == null);
var inst_33927 = cljs.core.not(inst_33926);
var state_33946__$1 = (function (){var statearr_33959 = state_33946;
(statearr_33959[(8)] = inst_33925__$1);

return statearr_33959;
})();
if(inst_33927){
var statearr_33960_35435 = state_33946__$1;
(statearr_33960_35435[(1)] = (5));

} else {
var statearr_33961_35436 = state_33946__$1;
(statearr_33961_35436[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (6))){
var state_33946__$1 = state_33946;
var statearr_33962_35437 = state_33946__$1;
(statearr_33962_35437[(2)] = null);

(statearr_33962_35437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (3))){
var inst_33943 = (state_33946[(2)]);
var inst_33944 = cljs.core.async.close_BANG_(out);
var state_33946__$1 = (function (){var statearr_33963 = state_33946;
(statearr_33963[(9)] = inst_33943);

return statearr_33963;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33946__$1,inst_33944);
} else {
if((state_val_33947 === (2))){
var state_33946__$1 = state_33946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33946__$1,(4),ch);
} else {
if((state_val_33947 === (11))){
var inst_33925 = (state_33946[(8)]);
var inst_33935 = (state_33946[(2)]);
var inst_33922 = inst_33925;
var state_33946__$1 = (function (){var statearr_33967 = state_33946;
(statearr_33967[(10)] = inst_33935);

(statearr_33967[(7)] = inst_33922);

return statearr_33967;
})();
var statearr_33968_35439 = state_33946__$1;
(statearr_33968_35439[(2)] = null);

(statearr_33968_35439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (9))){
var inst_33925 = (state_33946[(8)]);
var state_33946__$1 = state_33946;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33946__$1,(11),out,inst_33925);
} else {
if((state_val_33947 === (5))){
var inst_33922 = (state_33946[(7)]);
var inst_33925 = (state_33946[(8)]);
var inst_33929 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33925,inst_33922);
var state_33946__$1 = state_33946;
if(inst_33929){
var statearr_33982_35441 = state_33946__$1;
(statearr_33982_35441[(1)] = (8));

} else {
var statearr_33987_35442 = state_33946__$1;
(statearr_33987_35442[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (10))){
var inst_33938 = (state_33946[(2)]);
var state_33946__$1 = state_33946;
var statearr_33988_35443 = state_33946__$1;
(statearr_33988_35443[(2)] = inst_33938);

(statearr_33988_35443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33947 === (8))){
var inst_33922 = (state_33946[(7)]);
var tmp33974 = inst_33922;
var inst_33922__$1 = tmp33974;
var state_33946__$1 = (function (){var statearr_33998 = state_33946;
(statearr_33998[(7)] = inst_33922__$1);

return statearr_33998;
})();
var statearr_34000_35444 = state_33946__$1;
(statearr_34000_35444[(2)] = null);

(statearr_34000_35444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_34006 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34006[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_34006[(1)] = (1));

return statearr_34006;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_33946){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_33946);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e34008){var ex__30606__auto__ = e34008;
var statearr_34009_35451 = state_33946;
(statearr_34009_35451[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_33946[(4)]))){
var statearr_34010_35456 = state_33946;
(statearr_34010_35456[(1)] = cljs.core.first((state_33946[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35460 = state_33946;
state_33946 = G__35460;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_33946){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_33946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_34018 = f__30975__auto__();
(statearr_34018[(6)] = c__30974__auto___35428);

return statearr_34018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__34029 = arguments.length;
switch (G__34029) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30974__auto___35466 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_34078){
var state_val_34079 = (state_34078[(1)]);
if((state_val_34079 === (7))){
var inst_34073 = (state_34078[(2)]);
var state_34078__$1 = state_34078;
var statearr_34080_35467 = state_34078__$1;
(statearr_34080_35467[(2)] = inst_34073);

(statearr_34080_35467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (1))){
var inst_34033 = (new Array(n));
var inst_34034 = inst_34033;
var inst_34035 = (0);
var state_34078__$1 = (function (){var statearr_34081 = state_34078;
(statearr_34081[(7)] = inst_34035);

(statearr_34081[(8)] = inst_34034);

return statearr_34081;
})();
var statearr_34082_35468 = state_34078__$1;
(statearr_34082_35468[(2)] = null);

(statearr_34082_35468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (4))){
var inst_34038 = (state_34078[(9)]);
var inst_34038__$1 = (state_34078[(2)]);
var inst_34039 = (inst_34038__$1 == null);
var inst_34040 = cljs.core.not(inst_34039);
var state_34078__$1 = (function (){var statearr_34088 = state_34078;
(statearr_34088[(9)] = inst_34038__$1);

return statearr_34088;
})();
if(inst_34040){
var statearr_34094_35469 = state_34078__$1;
(statearr_34094_35469[(1)] = (5));

} else {
var statearr_34095_35470 = state_34078__$1;
(statearr_34095_35470[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (15))){
var inst_34067 = (state_34078[(2)]);
var state_34078__$1 = state_34078;
var statearr_34096_35471 = state_34078__$1;
(statearr_34096_35471[(2)] = inst_34067);

(statearr_34096_35471[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (13))){
var state_34078__$1 = state_34078;
var statearr_34099_35478 = state_34078__$1;
(statearr_34099_35478[(2)] = null);

(statearr_34099_35478[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (6))){
var inst_34035 = (state_34078[(7)]);
var inst_34060 = (inst_34035 > (0));
var state_34078__$1 = state_34078;
if(cljs.core.truth_(inst_34060)){
var statearr_34101_35479 = state_34078__$1;
(statearr_34101_35479[(1)] = (12));

} else {
var statearr_34102_35480 = state_34078__$1;
(statearr_34102_35480[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (3))){
var inst_34075 = (state_34078[(2)]);
var state_34078__$1 = state_34078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34078__$1,inst_34075);
} else {
if((state_val_34079 === (12))){
var inst_34034 = (state_34078[(8)]);
var inst_34065 = cljs.core.vec(inst_34034);
var state_34078__$1 = state_34078;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34078__$1,(15),out,inst_34065);
} else {
if((state_val_34079 === (2))){
var state_34078__$1 = state_34078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34078__$1,(4),ch);
} else {
if((state_val_34079 === (11))){
var inst_34051 = (state_34078[(2)]);
var inst_34052 = (new Array(n));
var inst_34034 = inst_34052;
var inst_34035 = (0);
var state_34078__$1 = (function (){var statearr_34115 = state_34078;
(statearr_34115[(7)] = inst_34035);

(statearr_34115[(8)] = inst_34034);

(statearr_34115[(10)] = inst_34051);

return statearr_34115;
})();
var statearr_34116_35487 = state_34078__$1;
(statearr_34116_35487[(2)] = null);

(statearr_34116_35487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (9))){
var inst_34034 = (state_34078[(8)]);
var inst_34049 = cljs.core.vec(inst_34034);
var state_34078__$1 = state_34078;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34078__$1,(11),out,inst_34049);
} else {
if((state_val_34079 === (5))){
var inst_34035 = (state_34078[(7)]);
var inst_34043 = (state_34078[(11)]);
var inst_34034 = (state_34078[(8)]);
var inst_34038 = (state_34078[(9)]);
var inst_34042 = (inst_34034[inst_34035] = inst_34038);
var inst_34043__$1 = (inst_34035 + (1));
var inst_34045 = (inst_34043__$1 < n);
var state_34078__$1 = (function (){var statearr_34121 = state_34078;
(statearr_34121[(11)] = inst_34043__$1);

(statearr_34121[(12)] = inst_34042);

return statearr_34121;
})();
if(cljs.core.truth_(inst_34045)){
var statearr_34122_35488 = state_34078__$1;
(statearr_34122_35488[(1)] = (8));

} else {
var statearr_34123_35489 = state_34078__$1;
(statearr_34123_35489[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (14))){
var inst_34070 = (state_34078[(2)]);
var inst_34071 = cljs.core.async.close_BANG_(out);
var state_34078__$1 = (function (){var statearr_34125 = state_34078;
(statearr_34125[(13)] = inst_34070);

return statearr_34125;
})();
var statearr_34129_35490 = state_34078__$1;
(statearr_34129_35490[(2)] = inst_34071);

(statearr_34129_35490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (10))){
var inst_34055 = (state_34078[(2)]);
var state_34078__$1 = state_34078;
var statearr_34132_35491 = state_34078__$1;
(statearr_34132_35491[(2)] = inst_34055);

(statearr_34132_35491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34079 === (8))){
var inst_34043 = (state_34078[(11)]);
var inst_34034 = (state_34078[(8)]);
var tmp34124 = inst_34034;
var inst_34034__$1 = tmp34124;
var inst_34035 = inst_34043;
var state_34078__$1 = (function (){var statearr_34133 = state_34078;
(statearr_34133[(7)] = inst_34035);

(statearr_34133[(8)] = inst_34034__$1);

return statearr_34133;
})();
var statearr_34134_35493 = state_34078__$1;
(statearr_34134_35493[(2)] = null);

(statearr_34134_35493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_34136 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34136[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_34136[(1)] = (1));

return statearr_34136;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_34078){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_34078);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e34138){var ex__30606__auto__ = e34138;
var statearr_34139_35495 = state_34078;
(statearr_34139_35495[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_34078[(4)]))){
var statearr_34140_35496 = state_34078;
(statearr_34140_35496[(1)] = cljs.core.first((state_34078[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35497 = state_34078;
state_34078 = G__35497;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_34078){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_34078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_34142 = f__30975__auto__();
(statearr_34142[(6)] = c__30974__auto___35466);

return statearr_34142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__34144 = arguments.length;
switch (G__34144) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30974__auto___35499 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_34205){
var state_val_34206 = (state_34205[(1)]);
if((state_val_34206 === (7))){
var inst_34200 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
var statearr_34215_35500 = state_34205__$1;
(statearr_34215_35500[(2)] = inst_34200);

(statearr_34215_35500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (1))){
var inst_34151 = [];
var inst_34152 = inst_34151;
var inst_34153 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34205__$1 = (function (){var statearr_34216 = state_34205;
(statearr_34216[(7)] = inst_34152);

(statearr_34216[(8)] = inst_34153);

return statearr_34216;
})();
var statearr_34217_35501 = state_34205__$1;
(statearr_34217_35501[(2)] = null);

(statearr_34217_35501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (4))){
var inst_34161 = (state_34205[(9)]);
var inst_34161__$1 = (state_34205[(2)]);
var inst_34162 = (inst_34161__$1 == null);
var inst_34163 = cljs.core.not(inst_34162);
var state_34205__$1 = (function (){var statearr_34221 = state_34205;
(statearr_34221[(9)] = inst_34161__$1);

return statearr_34221;
})();
if(inst_34163){
var statearr_34222_35507 = state_34205__$1;
(statearr_34222_35507[(1)] = (5));

} else {
var statearr_34223_35508 = state_34205__$1;
(statearr_34223_35508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (15))){
var inst_34152 = (state_34205[(7)]);
var inst_34192 = cljs.core.vec(inst_34152);
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34205__$1,(18),out,inst_34192);
} else {
if((state_val_34206 === (13))){
var inst_34187 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
var statearr_34227_35514 = state_34205__$1;
(statearr_34227_35514[(2)] = inst_34187);

(statearr_34227_35514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (6))){
var inst_34152 = (state_34205[(7)]);
var inst_34189 = inst_34152.length;
var inst_34190 = (inst_34189 > (0));
var state_34205__$1 = state_34205;
if(cljs.core.truth_(inst_34190)){
var statearr_34229_35515 = state_34205__$1;
(statearr_34229_35515[(1)] = (15));

} else {
var statearr_34231_35516 = state_34205__$1;
(statearr_34231_35516[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (17))){
var inst_34197 = (state_34205[(2)]);
var inst_34198 = cljs.core.async.close_BANG_(out);
var state_34205__$1 = (function (){var statearr_34235 = state_34205;
(statearr_34235[(10)] = inst_34197);

return statearr_34235;
})();
var statearr_34236_35517 = state_34205__$1;
(statearr_34236_35517[(2)] = inst_34198);

(statearr_34236_35517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (3))){
var inst_34202 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34205__$1,inst_34202);
} else {
if((state_val_34206 === (12))){
var inst_34152 = (state_34205[(7)]);
var inst_34180 = cljs.core.vec(inst_34152);
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34205__$1,(14),out,inst_34180);
} else {
if((state_val_34206 === (2))){
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34205__$1,(4),ch);
} else {
if((state_val_34206 === (11))){
var inst_34165 = (state_34205[(11)]);
var inst_34152 = (state_34205[(7)]);
var inst_34161 = (state_34205[(9)]);
var inst_34177 = inst_34152.push(inst_34161);
var tmp34240 = inst_34152;
var inst_34152__$1 = tmp34240;
var inst_34153 = inst_34165;
var state_34205__$1 = (function (){var statearr_34244 = state_34205;
(statearr_34244[(7)] = inst_34152__$1);

(statearr_34244[(8)] = inst_34153);

(statearr_34244[(12)] = inst_34177);

return statearr_34244;
})();
var statearr_34247_35518 = state_34205__$1;
(statearr_34247_35518[(2)] = null);

(statearr_34247_35518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (9))){
var inst_34153 = (state_34205[(8)]);
var inst_34173 = cljs.core.keyword_identical_QMARK_(inst_34153,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_34205__$1 = state_34205;
var statearr_34249_35520 = state_34205__$1;
(statearr_34249_35520[(2)] = inst_34173);

(statearr_34249_35520[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (5))){
var inst_34165 = (state_34205[(11)]);
var inst_34170 = (state_34205[(13)]);
var inst_34161 = (state_34205[(9)]);
var inst_34153 = (state_34205[(8)]);
var inst_34165__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34161) : f.call(null,inst_34161));
var inst_34170__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34165__$1,inst_34153);
var state_34205__$1 = (function (){var statearr_34250 = state_34205;
(statearr_34250[(11)] = inst_34165__$1);

(statearr_34250[(13)] = inst_34170__$1);

return statearr_34250;
})();
if(inst_34170__$1){
var statearr_34251_35522 = state_34205__$1;
(statearr_34251_35522[(1)] = (8));

} else {
var statearr_34331_35523 = state_34205__$1;
(statearr_34331_35523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (14))){
var inst_34165 = (state_34205[(11)]);
var inst_34161 = (state_34205[(9)]);
var inst_34182 = (state_34205[(2)]);
var inst_34183 = [];
var inst_34184 = inst_34183.push(inst_34161);
var inst_34152 = inst_34183;
var inst_34153 = inst_34165;
var state_34205__$1 = (function (){var statearr_34344 = state_34205;
(statearr_34344[(7)] = inst_34152);

(statearr_34344[(14)] = inst_34182);

(statearr_34344[(15)] = inst_34184);

(statearr_34344[(8)] = inst_34153);

return statearr_34344;
})();
var statearr_34347_35525 = state_34205__$1;
(statearr_34347_35525[(2)] = null);

(statearr_34347_35525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (16))){
var state_34205__$1 = state_34205;
var statearr_34349_35526 = state_34205__$1;
(statearr_34349_35526[(2)] = null);

(statearr_34349_35526[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (10))){
var inst_34175 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
if(cljs.core.truth_(inst_34175)){
var statearr_34352_35530 = state_34205__$1;
(statearr_34352_35530[(1)] = (11));

} else {
var statearr_34354_35531 = state_34205__$1;
(statearr_34354_35531[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (18))){
var inst_34194 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
var statearr_34357_35532 = state_34205__$1;
(statearr_34357_35532[(2)] = inst_34194);

(statearr_34357_35532[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (8))){
var inst_34170 = (state_34205[(13)]);
var state_34205__$1 = state_34205;
var statearr_34362_35538 = state_34205__$1;
(statearr_34362_35538[(2)] = inst_34170);

(statearr_34362_35538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30603__auto__ = null;
var cljs$core$async$state_machine__30603__auto____0 = (function (){
var statearr_34363 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34363[(0)] = cljs$core$async$state_machine__30603__auto__);

(statearr_34363[(1)] = (1));

return statearr_34363;
});
var cljs$core$async$state_machine__30603__auto____1 = (function (state_34205){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_34205);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e34369){var ex__30606__auto__ = e34369;
var statearr_34371_35539 = state_34205;
(statearr_34371_35539[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_34205[(4)]))){
var statearr_34373_35540 = state_34205;
(statearr_34373_35540[(1)] = cljs.core.first((state_34205[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35541 = state_34205;
state_34205 = G__35541;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
cljs$core$async$state_machine__30603__auto__ = function(state_34205){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30603__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30603__auto____1.call(this,state_34205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30603__auto____0;
cljs$core$async$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30603__auto____1;
return cljs$core$async$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_34383 = f__30975__auto__();
(statearr_34383[(6)] = c__30974__auto___35499);

return statearr_34383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
