goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__37988__37989__auto__){
if((!((p1__37988__37989__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__37988__37989__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__37988__37989__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__37988__37989__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__37988__37989__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___53881 = schema.utils.use_fn_validation;
var output_schema53303_53882 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53304_53883 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker53305_53884 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53304_53883);
}),null));
var output_checker53306_53885 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53303_53882);
}),null));
var ret__38856__auto___53887 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__53307){
var validate__36731__auto__ = cljs.core.deref(ufv___53881);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___53888 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53307], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53308_53889 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53309_53890 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53310_53891 = input_schema53304_53883;
var G__53311_53892 = cljs.core.deref(input_checker53305_53884);
var G__53312_53893 = args__36732__auto___53888;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53308_53889,G__53309_53890,G__53310_53891,G__53311_53892,G__53312_53893) : schema.core.fn_validator.call(null,G__53308_53889,G__53309_53890,G__53310_53891,G__53311_53892,G__53312_53893));
} else {
var temp__5804__auto___53895 = (function (){var fexpr__53313 = cljs.core.deref(input_checker53305_53884);
return (fexpr__53313.cljs$core$IFn$_invoke$arity$1 ? fexpr__53313.cljs$core$IFn$_invoke$arity$1(args__36732__auto___53888) : fexpr__53313.call(null,args__36732__auto___53888));
})();
if(cljs.core.truth_(temp__5804__auto___53895)){
var error__36733__auto___53897 = temp__5804__auto___53895;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___53897], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53304_53883,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___53888,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___53897], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var json = G__53307;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53314_53901 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53315_53902 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53316_53903 = output_schema53303_53882;
var G__53317_53904 = cljs.core.deref(output_checker53306_53885);
var G__53318_53905 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53314_53901,G__53315_53902,G__53316_53903,G__53317_53904,G__53318_53905) : schema.core.fn_validator.call(null,G__53314_53901,G__53315_53902,G__53316_53903,G__53317_53904,G__53318_53905));
} else {
var temp__5804__auto___53910 = (function (){var fexpr__53319 = cljs.core.deref(output_checker53306_53885);
return (fexpr__53319.cljs$core$IFn$_invoke$arity$1 ? fexpr__53319.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53319.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53910)){
var error__36733__auto___53911 = temp__5804__auto___53910;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___53911], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53303_53882,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___53911], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema53303_53882,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53304_53883], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___53927 = schema.utils.use_fn_validation;
var output_schema53320_53928 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53321_53929 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema53326_53930 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53322_53931 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53321_53929);
}),null));
var output_checker53323_53932 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53320_53928);
}),null));
var input_checker53327_53933 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53326_53930);
}),null));
var output_checker53328_53934 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53320_53928);
}),null));
var ret__38856__auto___53956 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__53333 = arguments.length;
switch (G__53333) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53324,G__53325){
var validate__36731__auto__ = cljs.core.deref(ufv___53927);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___53974 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53324,G__53325], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53334_53976 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53335_53977 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53336_53978 = input_schema53321_53929;
var G__53337_53979 = cljs.core.deref(input_checker53322_53931);
var G__53338_53980 = args__36732__auto___53974;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53334_53976,G__53335_53977,G__53336_53978,G__53337_53979,G__53338_53980) : schema.core.fn_validator.call(null,G__53334_53976,G__53335_53977,G__53336_53978,G__53337_53979,G__53338_53980));
} else {
var temp__5804__auto___53988 = (function (){var fexpr__53339 = cljs.core.deref(input_checker53322_53931);
return (fexpr__53339.cljs$core$IFn$_invoke$arity$1 ? fexpr__53339.cljs$core$IFn$_invoke$arity$1(args__36732__auto___53974) : fexpr__53339.call(null,args__36732__auto___53974));
})();
if(cljs.core.truth_(temp__5804__auto___53988)){
var error__36733__auto___53989 = temp__5804__auto___53988;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___53989], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53321_53929,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___53974,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___53989], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var name_kw = G__53324;
var fields = G__53325;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53340_53993 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53341_53994 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53342_53995 = output_schema53320_53928;
var G__53343_53996 = cljs.core.deref(output_checker53323_53932);
var G__53344_53997 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53340_53993,G__53341_53994,G__53342_53995,G__53343_53996,G__53344_53997) : schema.core.fn_validator.call(null,G__53340_53993,G__53341_53994,G__53342_53995,G__53343_53996,G__53344_53997));
} else {
var temp__5804__auto___53998 = (function (){var fexpr__53345 = cljs.core.deref(output_checker53323_53932);
return (fexpr__53345.cljs$core$IFn$_invoke$arity$1 ? fexpr__53345.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53345.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53998)){
var error__36733__auto___53999 = temp__5804__auto___53998;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___53999], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53320_53928,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___53999], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53329,G__53330,G__53331){
var validate__36731__auto__ = cljs.core.deref(ufv___53927);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54002 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53329,G__53330,G__53331], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53346_54003 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53347_54004 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53348_54005 = input_schema53326_53930;
var G__53349_54006 = cljs.core.deref(input_checker53327_53933);
var G__53350_54007 = args__36732__auto___54002;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53346_54003,G__53347_54004,G__53348_54005,G__53349_54006,G__53350_54007) : schema.core.fn_validator.call(null,G__53346_54003,G__53347_54004,G__53348_54005,G__53349_54006,G__53350_54007));
} else {
var temp__5804__auto___54010 = (function (){var fexpr__53351 = cljs.core.deref(input_checker53327_53933);
return (fexpr__53351.cljs$core$IFn$_invoke$arity$1 ? fexpr__53351.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54002) : fexpr__53351.call(null,args__36732__auto___54002));
})();
if(cljs.core.truth_(temp__5804__auto___54010)){
var error__36733__auto___54011 = temp__5804__auto___54010;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54011], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53326_53930,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54002,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54011], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var name_kw = G__53329;
var docstring = G__53330;
var fields = G__53331;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53352_54014 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53353_54015 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53354_54016 = output_schema53320_53928;
var G__53355_54017 = cljs.core.deref(output_checker53328_53934);
var G__53356_54018 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53352_54014,G__53353_54015,G__53354_54016,G__53355_54017,G__53356_54018) : schema.core.fn_validator.call(null,G__53352_54014,G__53353_54015,G__53354_54016,G__53355_54017,G__53356_54018));
} else {
var temp__5804__auto___54021 = (function (){var fexpr__53357 = cljs.core.deref(output_checker53328_53934);
return (fexpr__53357.cljs$core$IFn$_invoke$arity$1 ? fexpr__53357.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53357.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54021)){
var error__36733__auto___54022 = temp__5804__auto___54021;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54022], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53320_53928,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54022], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema53320_53928,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53321_53929,input_schema53326_53930], null)));

var ufv___54026 = schema.utils.use_fn_validation;
var output_schema53358_54027 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53359_54028 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema53364_54029 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53360_54030 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53359_54028);
}),null));
var output_checker53361_54031 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53358_54027);
}),null));
var input_checker53365_54032 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53364_54029);
}),null));
var output_checker53366_54033 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53358_54027);
}),null));
var ret__38856__auto___54038 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__53371 = arguments.length;
switch (G__53371) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53362,G__53363){
var validate__36731__auto__ = cljs.core.deref(ufv___54026);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54041 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53362,G__53363], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53372_54042 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53373_54043 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53374_54044 = input_schema53359_54028;
var G__53375_54045 = cljs.core.deref(input_checker53360_54030);
var G__53376_54046 = args__36732__auto___54041;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53372_54042,G__53373_54043,G__53374_54044,G__53375_54045,G__53376_54046) : schema.core.fn_validator.call(null,G__53372_54042,G__53373_54043,G__53374_54044,G__53375_54045,G__53376_54046));
} else {
var temp__5804__auto___54047 = (function (){var fexpr__53377 = cljs.core.deref(input_checker53360_54030);
return (fexpr__53377.cljs$core$IFn$_invoke$arity$1 ? fexpr__53377.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54041) : fexpr__53377.call(null,args__36732__auto___54041));
})();
if(cljs.core.truth_(temp__5804__auto___54047)){
var error__36733__auto___54048 = temp__5804__auto___54047;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54048], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53359_54028,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54041,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54048], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var name_kw = G__53362;
var symbol_keywords = G__53363;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53378_54053 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53379_54054 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53380_54055 = output_schema53358_54027;
var G__53381_54056 = cljs.core.deref(output_checker53361_54031);
var G__53382_54057 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53378_54053,G__53379_54054,G__53380_54055,G__53381_54056,G__53382_54057) : schema.core.fn_validator.call(null,G__53378_54053,G__53379_54054,G__53380_54055,G__53381_54056,G__53382_54057));
} else {
var temp__5804__auto___54059 = (function (){var fexpr__53383 = cljs.core.deref(output_checker53361_54031);
return (fexpr__53383.cljs$core$IFn$_invoke$arity$1 ? fexpr__53383.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53383.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54059)){
var error__36733__auto___54060 = temp__5804__auto___54059;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54060], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53358_54027,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54060], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53367,G__53368,G__53369){
var validate__36731__auto__ = cljs.core.deref(ufv___54026);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54062 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53367,G__53368,G__53369], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53384_54063 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53385_54064 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53386_54065 = input_schema53364_54029;
var G__53387_54066 = cljs.core.deref(input_checker53365_54032);
var G__53388_54067 = args__36732__auto___54062;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53384_54063,G__53385_54064,G__53386_54065,G__53387_54066,G__53388_54067) : schema.core.fn_validator.call(null,G__53384_54063,G__53385_54064,G__53386_54065,G__53387_54066,G__53388_54067));
} else {
var temp__5804__auto___54069 = (function (){var fexpr__53389 = cljs.core.deref(input_checker53365_54032);
return (fexpr__53389.cljs$core$IFn$_invoke$arity$1 ? fexpr__53389.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54062) : fexpr__53389.call(null,args__36732__auto___54062));
})();
if(cljs.core.truth_(temp__5804__auto___54069)){
var error__36733__auto___54070 = temp__5804__auto___54069;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54070], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53364_54029,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54062,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54070], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var name_kw = G__53367;
var docstring = G__53368;
var symbol_keywords = G__53369;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53390_54073 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53391_54074 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53392_54075 = output_schema53358_54027;
var G__53393_54076 = cljs.core.deref(output_checker53366_54033);
var G__53394_54077 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53390_54073,G__53391_54074,G__53392_54075,G__53393_54076,G__53394_54077) : schema.core.fn_validator.call(null,G__53390_54073,G__53391_54074,G__53392_54075,G__53393_54076,G__53394_54077));
} else {
var temp__5804__auto___54079 = (function (){var fexpr__53395 = cljs.core.deref(output_checker53366_54033);
return (fexpr__53395.cljs$core$IFn$_invoke$arity$1 ? fexpr__53395.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53395.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54079)){
var error__36733__auto___54080 = temp__5804__auto___54079;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54080], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53358_54027,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54080], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema53358_54027,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53359_54028,input_schema53364_54029], null)));

var ufv___54084 = schema.utils.use_fn_validation;
var output_schema53396_54085 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53397_54086 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53398_54087 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53397_54086);
}),null));
var output_checker53399_54088 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53396_54085);
}),null));
var ret__38856__auto___54089 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__53400,G__53401){
var validate__36731__auto__ = cljs.core.deref(ufv___54084);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54090 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53400,G__53401], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53402_54091 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53403_54092 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53404_54093 = input_schema53397_54086;
var G__53405_54094 = cljs.core.deref(input_checker53398_54087);
var G__53406_54095 = args__36732__auto___54090;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53402_54091,G__53403_54092,G__53404_54093,G__53405_54094,G__53406_54095) : schema.core.fn_validator.call(null,G__53402_54091,G__53403_54092,G__53404_54093,G__53405_54094,G__53406_54095));
} else {
var temp__5804__auto___54096 = (function (){var fexpr__53407 = cljs.core.deref(input_checker53398_54087);
return (fexpr__53407.cljs$core$IFn$_invoke$arity$1 ? fexpr__53407.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54090) : fexpr__53407.call(null,args__36732__auto___54090));
})();
if(cljs.core.truth_(temp__5804__auto___54096)){
var error__36733__auto___54097 = temp__5804__auto___54096;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54097], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53397_54086,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54090,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54097], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var name_kw = G__53400;
var size = G__53401;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53408_54099 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53409_54100 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53410_54101 = output_schema53396_54085;
var G__53411_54102 = cljs.core.deref(output_checker53399_54088);
var G__53412_54103 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53408_54099,G__53409_54100,G__53410_54101,G__53411_54102,G__53412_54103) : schema.core.fn_validator.call(null,G__53408_54099,G__53409_54100,G__53410_54101,G__53411_54102,G__53412_54103));
} else {
var temp__5804__auto___54104 = (function (){var fexpr__53413 = cljs.core.deref(output_checker53399_54088);
return (fexpr__53413.cljs$core$IFn$_invoke$arity$1 ? fexpr__53413.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53413.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54104)){
var error__36733__auto___54105 = temp__5804__auto___54104;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54105], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53396_54085,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54105], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema53396_54085,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53397_54086], null)));

var ufv___54107 = schema.utils.use_fn_validation;
var output_schema53414_54108 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53415_54109 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53416_54110 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53415_54109);
}),null));
var output_checker53417_54111 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53414_54108);
}),null));
var ret__38856__auto___54112 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__53418){
var validate__36731__auto__ = cljs.core.deref(ufv___54107);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54113 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53418], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53419_54114 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53420_54115 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53421_54116 = input_schema53415_54109;
var G__53422_54117 = cljs.core.deref(input_checker53416_54110);
var G__53423_54118 = args__36732__auto___54113;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53419_54114,G__53420_54115,G__53421_54116,G__53422_54117,G__53423_54118) : schema.core.fn_validator.call(null,G__53419_54114,G__53420_54115,G__53421_54116,G__53422_54117,G__53423_54118));
} else {
var temp__5804__auto___54119 = (function (){var fexpr__53424 = cljs.core.deref(input_checker53416_54110);
return (fexpr__53424.cljs$core$IFn$_invoke$arity$1 ? fexpr__53424.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54113) : fexpr__53424.call(null,args__36732__auto___54113));
})();
if(cljs.core.truth_(temp__5804__auto___54119)){
var error__36733__auto___54121 = temp__5804__auto___54119;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54121], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53415_54109,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54113,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54121], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var items_schema = G__53418;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53425_54122 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53426_54123 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53427_54124 = output_schema53414_54108;
var G__53428_54125 = cljs.core.deref(output_checker53417_54111);
var G__53429_54126 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53425_54122,G__53426_54123,G__53427_54124,G__53428_54125,G__53429_54126) : schema.core.fn_validator.call(null,G__53425_54122,G__53426_54123,G__53427_54124,G__53428_54125,G__53429_54126));
} else {
var temp__5804__auto___54127 = (function (){var fexpr__53430 = cljs.core.deref(output_checker53417_54111);
return (fexpr__53430.cljs$core$IFn$_invoke$arity$1 ? fexpr__53430.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53430.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54127)){
var error__36733__auto___54128 = temp__5804__auto___54127;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54128], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53414_54108,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54128], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema53414_54108,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53415_54109], null)));

var ufv___54133 = schema.utils.use_fn_validation;
var output_schema53431_54134 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53432_54135 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53433_54136 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53432_54135);
}),null));
var output_checker53434_54137 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53431_54134);
}),null));
var ret__38856__auto___54140 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__53435){
var validate__36731__auto__ = cljs.core.deref(ufv___54133);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54141 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53435], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53436_54142 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53437_54143 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53438_54144 = input_schema53432_54135;
var G__53439_54145 = cljs.core.deref(input_checker53433_54136);
var G__53440_54146 = args__36732__auto___54141;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53436_54142,G__53437_54143,G__53438_54144,G__53439_54145,G__53440_54146) : schema.core.fn_validator.call(null,G__53436_54142,G__53437_54143,G__53438_54144,G__53439_54145,G__53440_54146));
} else {
var temp__5804__auto___54147 = (function (){var fexpr__53441 = cljs.core.deref(input_checker53433_54136);
return (fexpr__53441.cljs$core$IFn$_invoke$arity$1 ? fexpr__53441.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54141) : fexpr__53441.call(null,args__36732__auto___54141));
})();
if(cljs.core.truth_(temp__5804__auto___54147)){
var error__36733__auto___54148 = temp__5804__auto___54147;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54148], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53432_54135,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54141,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54148], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var values_schema = G__53435;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53442_54149 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53443_54150 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53444_54151 = output_schema53431_54134;
var G__53445_54152 = cljs.core.deref(output_checker53434_54137);
var G__53446_54153 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53442_54149,G__53443_54150,G__53444_54151,G__53445_54152,G__53446_54153) : schema.core.fn_validator.call(null,G__53442_54149,G__53443_54150,G__53444_54151,G__53445_54152,G__53446_54153));
} else {
var temp__5804__auto___54154 = (function (){var fexpr__53447 = cljs.core.deref(output_checker53434_54137);
return (fexpr__53447.cljs$core$IFn$_invoke$arity$1 ? fexpr__53447.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53447.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54154)){
var error__36733__auto___54155 = temp__5804__auto___54154;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54155], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53431_54134,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54155], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema53431_54134,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53432_54135], null)));

var ufv___54158 = schema.utils.use_fn_validation;
var output_schema53448_54159 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53449_54160 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker53450_54161 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53449_54160);
}),null));
var output_checker53451_54162 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53448_54159);
}),null));
var ret__38856__auto___54163 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__53452){
var validate__36731__auto__ = cljs.core.deref(ufv___54158);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54164 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53452], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53453_54165 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53454_54166 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53455_54167 = input_schema53449_54160;
var G__53456_54168 = cljs.core.deref(input_checker53450_54161);
var G__53457_54169 = args__36732__auto___54164;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53453_54165,G__53454_54166,G__53455_54167,G__53456_54168,G__53457_54169) : schema.core.fn_validator.call(null,G__53453_54165,G__53454_54166,G__53455_54167,G__53456_54168,G__53457_54169));
} else {
var temp__5804__auto___54170 = (function (){var fexpr__53458 = cljs.core.deref(input_checker53450_54161);
return (fexpr__53458.cljs$core$IFn$_invoke$arity$1 ? fexpr__53458.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54164) : fexpr__53458.call(null,args__36732__auto___54164));
})();
if(cljs.core.truth_(temp__5804__auto___54170)){
var error__36733__auto___54171 = temp__5804__auto___54170;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54171], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53449_54160,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54164,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54171], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var member_schemas = G__53452;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53459_54172 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53460_54173 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53461_54174 = output_schema53448_54159;
var G__53462_54175 = cljs.core.deref(output_checker53451_54162);
var G__53463_54176 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53459_54172,G__53460_54173,G__53461_54174,G__53462_54175,G__53463_54176) : schema.core.fn_validator.call(null,G__53459_54172,G__53460_54173,G__53461_54174,G__53462_54175,G__53463_54176));
} else {
var temp__5804__auto___54178 = (function (){var fexpr__53464 = cljs.core.deref(output_checker53451_54162);
return (fexpr__53464.cljs$core$IFn$_invoke$arity$1 ? fexpr__53464.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53464.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54178)){
var error__36733__auto___54180 = temp__5804__auto___54178;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54180], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53448_54159,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54180], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema53448_54159,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53449_54160], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___54182 = schema.utils.use_fn_validation;
var output_schema53465_54183 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53466_54184 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53467_54185 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53466_54184);
}),null));
var output_checker53468_54186 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53465_54183);
}),null));
var ret__38856__auto___54187 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__53469){
var validate__36731__auto__ = cljs.core.deref(ufv___54182);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54188 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53469], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53470_54189 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53471_54190 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53472_54191 = input_schema53466_54184;
var G__53473_54192 = cljs.core.deref(input_checker53467_54185);
var G__53474_54193 = args__36732__auto___54188;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53470_54189,G__53471_54190,G__53472_54191,G__53473_54192,G__53474_54193) : schema.core.fn_validator.call(null,G__53470_54189,G__53471_54190,G__53472_54191,G__53473_54192,G__53474_54193));
} else {
var temp__5804__auto___54196 = (function (){var fexpr__53475 = cljs.core.deref(input_checker53467_54185);
return (fexpr__53475.cljs$core$IFn$_invoke$arity$1 ? fexpr__53475.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54188) : fexpr__53475.call(null,args__36732__auto___54188));
})();
if(cljs.core.truth_(temp__5804__auto___54196)){
var error__36733__auto___54198 = temp__5804__auto___54196;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54198], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53466_54184,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54188,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54198], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53469;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53476_54201 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53477_54202 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53478_54203 = output_schema53465_54183;
var G__53479_54204 = cljs.core.deref(output_checker53468_54186);
var G__53480_54205 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53476_54201,G__53477_54202,G__53478_54203,G__53479_54204,G__53480_54205) : schema.core.fn_validator.call(null,G__53476_54201,G__53477_54202,G__53478_54203,G__53479_54204,G__53480_54205));
} else {
var temp__5804__auto___54206 = (function (){var fexpr__53481 = cljs.core.deref(output_checker53468_54186);
return (fexpr__53481.cljs$core$IFn$_invoke$arity$1 ? fexpr__53481.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53481.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54206)){
var error__36733__auto___54207 = temp__5804__auto___54206;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54207], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53465_54183,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54207], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema53465_54183,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53466_54184], null)));

var ufv___54209 = schema.utils.use_fn_validation;
var output_schema53482_54210 = deercreeklabs.baracus.ByteArray;
var input_schema53483_54211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53484_54212 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53483_54211);
}),null));
var output_checker53485_54213 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53482_54210);
}),null));
var ret__38856__auto___54214 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__53486,G__53487){
var validate__36731__auto__ = cljs.core.deref(ufv___54209);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54215 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53486,G__53487], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53488_54216 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53489_54218 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53490_54219 = input_schema53483_54211;
var G__53491_54220 = cljs.core.deref(input_checker53484_54212);
var G__53492_54221 = args__36732__auto___54215;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53488_54216,G__53489_54218,G__53490_54219,G__53491_54220,G__53492_54221) : schema.core.fn_validator.call(null,G__53488_54216,G__53489_54218,G__53490_54219,G__53491_54220,G__53492_54221));
} else {
var temp__5804__auto___54223 = (function (){var fexpr__53493 = cljs.core.deref(input_checker53484_54212);
return (fexpr__53493.cljs$core$IFn$_invoke$arity$1 ? fexpr__53493.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54215) : fexpr__53493.call(null,args__36732__auto___54215));
})();
if(cljs.core.truth_(temp__5804__auto___54223)){
var error__36733__auto___54224 = temp__5804__auto___54223;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54224], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53483_54211,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54215,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54224], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var writer_schema = G__53486;
var data = G__53487;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53495_54229 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53496_54230 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53497_54231 = output_schema53482_54210;
var G__53498_54232 = cljs.core.deref(output_checker53485_54213);
var G__53499_54233 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53495_54229,G__53496_54230,G__53497_54231,G__53498_54232,G__53499_54233) : schema.core.fn_validator.call(null,G__53495_54229,G__53496_54230,G__53497_54231,G__53498_54232,G__53499_54233));
} else {
var temp__5804__auto___54234 = (function (){var fexpr__53500 = cljs.core.deref(output_checker53485_54213);
return (fexpr__53500.cljs$core$IFn$_invoke$arity$1 ? fexpr__53500.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53500.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54234)){
var error__36733__auto___54235 = temp__5804__auto___54234;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54235], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53482_54210,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54235], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema53482_54210,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53483_54211], null)));

var ufv___54237 = schema.utils.use_fn_validation;
var output_schema53501_54238 = schema.core.Any;
var input_schema53502_54239 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53503_54240 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53502_54239);
}),null));
var output_checker53504_54241 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53501_54238);
}),null));
var ret__38856__auto___54243 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__53505,G__53506,G__53507){
var validate__36731__auto__ = cljs.core.deref(ufv___54237);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54244 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53505,G__53506,G__53507], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53508_54245 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53509_54246 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53510_54247 = input_schema53502_54239;
var G__53511_54248 = cljs.core.deref(input_checker53503_54240);
var G__53512_54249 = args__36732__auto___54244;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53508_54245,G__53509_54246,G__53510_54247,G__53511_54248,G__53512_54249) : schema.core.fn_validator.call(null,G__53508_54245,G__53509_54246,G__53510_54247,G__53511_54248,G__53512_54249));
} else {
var temp__5804__auto___54250 = (function (){var fexpr__53513 = cljs.core.deref(input_checker53503_54240);
return (fexpr__53513.cljs$core$IFn$_invoke$arity$1 ? fexpr__53513.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54244) : fexpr__53513.call(null,args__36732__auto___54244));
})();
if(cljs.core.truth_(temp__5804__auto___54250)){
var error__36733__auto___54251 = temp__5804__auto___54250;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54251], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53502_54239,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54244,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54251], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var reader_schema = G__53505;
var writer_schema = G__53506;
var ba = G__53507;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53516_54256 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53517_54257 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53518_54258 = output_schema53501_54238;
var G__53519_54259 = cljs.core.deref(output_checker53504_54241);
var G__53520_54260 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53516_54256,G__53517_54257,G__53518_54258,G__53519_54259,G__53520_54260) : schema.core.fn_validator.call(null,G__53516_54256,G__53517_54257,G__53518_54258,G__53519_54259,G__53520_54260));
} else {
var temp__5804__auto___54265 = (function (){var fexpr__53521 = cljs.core.deref(output_checker53504_54241);
return (fexpr__53521.cljs$core$IFn$_invoke$arity$1 ? fexpr__53521.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53521.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54265)){
var error__36733__auto___54266 = temp__5804__auto___54265;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54266], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53501_54238,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54266], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema53501_54238,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53502_54239], null)));

var ufv___54267 = schema.utils.use_fn_validation;
var output_schema53522_54268 = schema.core.Any;
var input_schema53523_54269 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53524_54270 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53523_54269);
}),null));
var output_checker53525_54271 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53522_54268);
}),null));
var ret__38856__auto___54272 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__53526,G__53527){
var validate__36731__auto__ = cljs.core.deref(ufv___54267);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54273 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53526,G__53527], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53528_54274 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53529_54275 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53530_54276 = input_schema53523_54269;
var G__53531_54277 = cljs.core.deref(input_checker53524_54270);
var G__53532_54278 = args__36732__auto___54273;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53528_54274,G__53529_54275,G__53530_54276,G__53531_54277,G__53532_54278) : schema.core.fn_validator.call(null,G__53528_54274,G__53529_54275,G__53530_54276,G__53531_54277,G__53532_54278));
} else {
var temp__5804__auto___54279 = (function (){var fexpr__53533 = cljs.core.deref(input_checker53524_54270);
return (fexpr__53533.cljs$core$IFn$_invoke$arity$1 ? fexpr__53533.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54273) : fexpr__53533.call(null,args__36732__auto___54273));
})();
if(cljs.core.truth_(temp__5804__auto___54279)){
var error__36733__auto___54281 = temp__5804__auto___54279;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54281], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53523_54269,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54273,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54281], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53526;
var ba = G__53527;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53534_54282 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53535_54283 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53536_54284 = output_schema53522_54268;
var G__53537_54285 = cljs.core.deref(output_checker53525_54271);
var G__53538_54286 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53534_54282,G__53535_54283,G__53536_54284,G__53537_54285,G__53538_54286) : schema.core.fn_validator.call(null,G__53534_54282,G__53535_54283,G__53536_54284,G__53537_54285,G__53538_54286));
} else {
var temp__5804__auto___54287 = (function (){var fexpr__53539 = cljs.core.deref(output_checker53525_54271);
return (fexpr__53539.cljs$core$IFn$_invoke$arity$1 ? fexpr__53539.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53539.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54287)){
var error__36733__auto___54288 = temp__5804__auto___54287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54288], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53522_54268,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54288], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema53522_54268,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53523_54269], null)));

var ufv___54290 = schema.utils.use_fn_validation;
var output_schema53540_54291 = schema.core.Any;
var input_schema53541_54292 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53542_54293 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53541_54292);
}),null));
var output_checker53543_54294 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53540_54291);
}),null));
var ret__38856__auto___54296 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__53544){
var validate__36731__auto__ = cljs.core.deref(ufv___54290);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54298 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53544], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53545_54299 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53546_54300 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53547_54301 = input_schema53541_54292;
var G__53548_54302 = cljs.core.deref(input_checker53542_54293);
var G__53549_54303 = args__36732__auto___54298;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53545_54299,G__53546_54300,G__53547_54301,G__53548_54302,G__53549_54303) : schema.core.fn_validator.call(null,G__53545_54299,G__53546_54300,G__53547_54301,G__53548_54302,G__53549_54303));
} else {
var temp__5804__auto___54304 = (function (){var fexpr__53550 = cljs.core.deref(input_checker53542_54293);
return (fexpr__53550.cljs$core$IFn$_invoke$arity$1 ? fexpr__53550.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54298) : fexpr__53550.call(null,args__36732__auto___54298));
})();
if(cljs.core.truth_(temp__5804__auto___54304)){
var error__36733__auto___54305 = temp__5804__auto___54304;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54305], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53541_54292,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54298,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54305], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53544;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53551_54306 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53552_54307 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53553_54308 = output_schema53540_54291;
var G__53554_54309 = cljs.core.deref(output_checker53543_54294);
var G__53555_54310 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53551_54306,G__53552_54307,G__53553_54308,G__53554_54309,G__53555_54310) : schema.core.fn_validator.call(null,G__53551_54306,G__53552_54307,G__53553_54308,G__53554_54309,G__53555_54310));
} else {
var temp__5804__auto___54313 = (function (){var fexpr__53556 = cljs.core.deref(output_checker53543_54294);
return (fexpr__53556.cljs$core$IFn$_invoke$arity$1 ? fexpr__53556.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53556.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54313)){
var error__36733__auto___54314 = temp__5804__auto___54313;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54314], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53540_54291,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54314], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema53540_54291,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53541_54292], null)));

var ufv___54316 = schema.utils.use_fn_validation;
var output_schema53557_54317 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53558_54318 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53559_54319 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53558_54318);
}),null));
var output_checker53560_54320 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53557_54317);
}),null));
var ret__38856__auto___54324 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__53561){
var validate__36731__auto__ = cljs.core.deref(ufv___54316);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54325 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53561], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53562_54326 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53563_54327 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53564_54328 = input_schema53558_54318;
var G__53565_54329 = cljs.core.deref(input_checker53559_54319);
var G__53566_54330 = args__36732__auto___54325;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53562_54326,G__53563_54327,G__53564_54328,G__53565_54329,G__53566_54330) : schema.core.fn_validator.call(null,G__53562_54326,G__53563_54327,G__53564_54328,G__53565_54329,G__53566_54330));
} else {
var temp__5804__auto___54331 = (function (){var fexpr__53567 = cljs.core.deref(input_checker53559_54319);
return (fexpr__53567.cljs$core$IFn$_invoke$arity$1 ? fexpr__53567.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54325) : fexpr__53567.call(null,args__36732__auto___54325));
})();
if(cljs.core.truth_(temp__5804__auto___54331)){
var error__36733__auto___54332 = temp__5804__auto___54331;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54332], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53558_54318,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54325,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54332], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var edn = G__53561;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema(edn);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53568_54335 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53569_54336 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53570_54337 = output_schema53557_54317;
var G__53571_54338 = cljs.core.deref(output_checker53560_54320);
var G__53572_54339 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53568_54335,G__53569_54336,G__53570_54337,G__53571_54338,G__53572_54339) : schema.core.fn_validator.call(null,G__53568_54335,G__53569_54336,G__53570_54337,G__53571_54338,G__53572_54339));
} else {
var temp__5804__auto___54341 = (function (){var fexpr__53573 = cljs.core.deref(output_checker53560_54320);
return (fexpr__53573.cljs$core$IFn$_invoke$arity$1 ? fexpr__53573.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53573.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54341)){
var error__36733__auto___54342 = temp__5804__auto___54341;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54342], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53557_54317,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54342], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema53557_54317,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53558_54318], null)));

var ufv___54344 = schema.utils.use_fn_validation;
var output_schema53574_54345 = schema.core.Str;
var input_schema53575_54346 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53576_54347 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53575_54346);
}),null));
var output_checker53577_54348 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53574_54345);
}),null));
var ret__38856__auto___54350 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__53578){
var validate__36731__auto__ = cljs.core.deref(ufv___54344);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54351 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53578], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53579_54352 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53580_54353 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53581_54354 = input_schema53575_54346;
var G__53582_54355 = cljs.core.deref(input_checker53576_54347);
var G__53583_54356 = args__36732__auto___54351;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53579_54352,G__53580_54353,G__53581_54354,G__53582_54355,G__53583_54356) : schema.core.fn_validator.call(null,G__53579_54352,G__53580_54353,G__53581_54354,G__53582_54355,G__53583_54356));
} else {
var temp__5804__auto___54357 = (function (){var fexpr__53584 = cljs.core.deref(input_checker53576_54347);
return (fexpr__53584.cljs$core$IFn$_invoke$arity$1 ? fexpr__53584.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54351) : fexpr__53584.call(null,args__36732__auto___54351));
})();
if(cljs.core.truth_(temp__5804__auto___54357)){
var error__36733__auto___54358 = temp__5804__auto___54357;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54358], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53575_54346,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54351,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54358], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53578;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53585_54361 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53586_54362 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53587_54363 = output_schema53574_54345;
var G__53588_54364 = cljs.core.deref(output_checker53577_54348);
var G__53589_54365 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53585_54361,G__53586_54362,G__53587_54363,G__53588_54364,G__53589_54365) : schema.core.fn_validator.call(null,G__53585_54361,G__53586_54362,G__53587_54363,G__53588_54364,G__53589_54365));
} else {
var temp__5804__auto___54368 = (function (){var fexpr__53590 = cljs.core.deref(output_checker53577_54348);
return (fexpr__53590.cljs$core$IFn$_invoke$arity$1 ? fexpr__53590.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53590.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54368)){
var error__36733__auto___54369 = temp__5804__auto___54368;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54369], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53574_54345,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54369], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema53574_54345,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53575_54346], null)));

var ufv___54373 = schema.utils.use_fn_validation;
var output_schema53591_54374 = schema.core.Keyword;
var input_schema53592_54375 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53593_54376 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53592_54375);
}),null));
var output_checker53594_54377 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53591_54374);
}),null));
var ret__38856__auto___54378 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__53595){
var validate__36731__auto__ = cljs.core.deref(ufv___54373);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54379 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53595], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53596_54380 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53597_54381 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53598_54382 = input_schema53592_54375;
var G__53599_54383 = cljs.core.deref(input_checker53593_54376);
var G__53600_54384 = args__36732__auto___54379;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53596_54380,G__53597_54381,G__53598_54382,G__53599_54383,G__53600_54384) : schema.core.fn_validator.call(null,G__53596_54380,G__53597_54381,G__53598_54382,G__53599_54383,G__53600_54384));
} else {
var temp__5804__auto___54385 = (function (){var fexpr__53601 = cljs.core.deref(input_checker53593_54376);
return (fexpr__53601.cljs$core$IFn$_invoke$arity$1 ? fexpr__53601.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54379) : fexpr__53601.call(null,args__36732__auto___54379));
})();
if(cljs.core.truth_(temp__5804__auto___54385)){
var error__36733__auto___54386 = temp__5804__auto___54385;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54386], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53592_54375,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54379,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54386], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53595;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53602_54387 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53603_54388 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53604_54389 = output_schema53591_54374;
var G__53605_54390 = cljs.core.deref(output_checker53594_54377);
var G__53606_54391 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53602_54387,G__53603_54388,G__53604_54389,G__53605_54390,G__53606_54391) : schema.core.fn_validator.call(null,G__53602_54387,G__53603_54388,G__53604_54389,G__53605_54390,G__53606_54391));
} else {
var temp__5804__auto___54393 = (function (){var fexpr__53607 = cljs.core.deref(output_checker53594_54377);
return (fexpr__53607.cljs$core$IFn$_invoke$arity$1 ? fexpr__53607.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53607.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54393)){
var error__36733__auto___54394 = temp__5804__auto___54393;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54394], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53591_54374,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54394], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema53591_54374,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53592_54375], null)));

var ufv___54396 = schema.utils.use_fn_validation;
var output_schema53608_54397 = schema.core.Str;
var input_schema53609_54398 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53610_54399 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53609_54398);
}),null));
var output_checker53611_54400 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53608_54397);
}),null));
var ret__38856__auto___54403 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__53612){
var validate__36731__auto__ = cljs.core.deref(ufv___54396);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54404 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53612], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53613_54405 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53614_54406 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53615_54407 = input_schema53609_54398;
var G__53616_54408 = cljs.core.deref(input_checker53610_54399);
var G__53617_54409 = args__36732__auto___54404;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53613_54405,G__53614_54406,G__53615_54407,G__53616_54408,G__53617_54409) : schema.core.fn_validator.call(null,G__53613_54405,G__53614_54406,G__53615_54407,G__53616_54408,G__53617_54409));
} else {
var temp__5804__auto___54410 = (function (){var fexpr__53618 = cljs.core.deref(input_checker53610_54399);
return (fexpr__53618.cljs$core$IFn$_invoke$arity$1 ? fexpr__53618.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54404) : fexpr__53618.call(null,args__36732__auto___54404));
})();
if(cljs.core.truth_(temp__5804__auto___54410)){
var error__36733__auto___54411 = temp__5804__auto___54410;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54411], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53609_54398,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54404,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54411], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53612;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53619_54413 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53620_54414 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53621_54415 = output_schema53608_54397;
var G__53622_54416 = cljs.core.deref(output_checker53611_54400);
var G__53623_54417 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53619_54413,G__53620_54414,G__53621_54415,G__53622_54416,G__53623_54417) : schema.core.fn_validator.call(null,G__53619_54413,G__53620_54414,G__53621_54415,G__53622_54416,G__53623_54417));
} else {
var temp__5804__auto___54418 = (function (){var fexpr__53624 = cljs.core.deref(output_checker53611_54400);
return (fexpr__53624.cljs$core$IFn$_invoke$arity$1 ? fexpr__53624.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53624.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54418)){
var error__36733__auto___54419 = temp__5804__auto___54418;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54419], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53608_54397,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54419], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema53608_54397,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53609_54398], null)));

var ufv___54420 = schema.utils.use_fn_validation;
var output_schema53625_54421 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema53626_54422 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53627_54423 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53626_54422);
}),null));
var output_checker53628_54424 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53625_54421);
}),null));
var ret__38856__auto___54425 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__53629){
var validate__36731__auto__ = cljs.core.deref(ufv___54420);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54426 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53629], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53630_54427 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53631_54428 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53632_54429 = input_schema53626_54422;
var G__53633_54430 = cljs.core.deref(input_checker53627_54423);
var G__53634_54431 = args__36732__auto___54426;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53630_54427,G__53631_54428,G__53632_54429,G__53633_54430,G__53634_54431) : schema.core.fn_validator.call(null,G__53630_54427,G__53631_54428,G__53632_54429,G__53633_54430,G__53634_54431));
} else {
var temp__5804__auto___54432 = (function (){var fexpr__53635 = cljs.core.deref(input_checker53627_54423);
return (fexpr__53635.cljs$core$IFn$_invoke$arity$1 ? fexpr__53635.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54426) : fexpr__53635.call(null,args__36732__auto___54426));
})();
if(cljs.core.truth_(temp__5804__auto___54432)){
var error__36733__auto___54433 = temp__5804__auto___54432;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54433], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53626_54422,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54426,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54433], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53629;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53636_54435 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53637_54436 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53638_54437 = output_schema53625_54421;
var G__53639_54438 = cljs.core.deref(output_checker53628_54424);
var G__53640_54439 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53636_54435,G__53637_54436,G__53638_54437,G__53639_54438,G__53640_54439) : schema.core.fn_validator.call(null,G__53636_54435,G__53637_54436,G__53638_54437,G__53639_54438,G__53640_54439));
} else {
var temp__5804__auto___54440 = (function (){var fexpr__53641 = cljs.core.deref(output_checker53628_54424);
return (fexpr__53641.cljs$core$IFn$_invoke$arity$1 ? fexpr__53641.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53641.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54440)){
var error__36733__auto___54441 = temp__5804__auto___54440;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54441], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53625_54421,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54441], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema53625_54421,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53626_54422], null)));

var ufv___54443 = schema.utils.use_fn_validation;
var output_schema53642_54444 = deercreeklabs.baracus.ByteArray;
var input_schema53643_54445 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53644_54446 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53643_54445);
}),null));
var output_checker53645_54447 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53642_54444);
}),null));
var ret__38856__auto___54452 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__53646){
var validate__36731__auto__ = cljs.core.deref(ufv___54443);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54453 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53646], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53647_54454 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53648_54455 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53649_54456 = input_schema53643_54445;
var G__53650_54457 = cljs.core.deref(input_checker53644_54446);
var G__53651_54458 = args__36732__auto___54453;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53647_54454,G__53648_54455,G__53649_54456,G__53650_54457,G__53651_54458) : schema.core.fn_validator.call(null,G__53647_54454,G__53648_54455,G__53649_54456,G__53650_54457,G__53651_54458));
} else {
var temp__5804__auto___54459 = (function (){var fexpr__53652 = cljs.core.deref(input_checker53644_54446);
return (fexpr__53652.cljs$core$IFn$_invoke$arity$1 ? fexpr__53652.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54453) : fexpr__53652.call(null,args__36732__auto___54453));
})();
if(cljs.core.truth_(temp__5804__auto___54459)){
var error__36733__auto___54460 = temp__5804__auto___54459;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54460], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53643_54445,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54453,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54460], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53646;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53653_54461 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53654_54462 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53655_54463 = output_schema53642_54444;
var G__53656_54464 = cljs.core.deref(output_checker53645_54447);
var G__53657_54465 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53653_54461,G__53654_54462,G__53655_54463,G__53656_54464,G__53657_54465) : schema.core.fn_validator.call(null,G__53653_54461,G__53654_54462,G__53655_54463,G__53656_54464,G__53657_54465));
} else {
var temp__5804__auto___54466 = (function (){var fexpr__53658 = cljs.core.deref(output_checker53645_54447);
return (fexpr__53658.cljs$core$IFn$_invoke$arity$1 ? fexpr__53658.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53658.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54466)){
var error__36733__auto___54468 = temp__5804__auto___54466;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54468], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53642_54444,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54468], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema53642_54444,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53643_54445], null)));

var ufv___54469 = schema.utils.use_fn_validation;
var output_schema53659_54470 = deercreeklabs.baracus.ByteArray;
var input_schema53660_54471 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53661_54472 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53660_54471);
}),null));
var output_checker53662_54473 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53659_54470);
}),null));
var ret__38856__auto___54475 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__53663){
var validate__36731__auto__ = cljs.core.deref(ufv___54469);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54476 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53663], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53664_54477 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53665_54478 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53666_54479 = input_schema53660_54471;
var G__53667_54480 = cljs.core.deref(input_checker53661_54472);
var G__53668_54481 = args__36732__auto___54476;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53664_54477,G__53665_54478,G__53666_54479,G__53667_54480,G__53668_54481) : schema.core.fn_validator.call(null,G__53664_54477,G__53665_54478,G__53666_54479,G__53667_54480,G__53668_54481));
} else {
var temp__5804__auto___54483 = (function (){var fexpr__53669 = cljs.core.deref(input_checker53661_54472);
return (fexpr__53669.cljs$core$IFn$_invoke$arity$1 ? fexpr__53669.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54476) : fexpr__53669.call(null,args__36732__auto___54476));
})();
if(cljs.core.truth_(temp__5804__auto___54483)){
var error__36733__auto___54484 = temp__5804__auto___54483;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54484], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53660_54471,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54476,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54484], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53663;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53670_54485 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53671_54486 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53672_54487 = output_schema53659_54470;
var G__53673_54488 = cljs.core.deref(output_checker53662_54473);
var G__53674_54489 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53670_54485,G__53671_54486,G__53672_54487,G__53673_54488,G__53674_54489) : schema.core.fn_validator.call(null,G__53670_54485,G__53671_54486,G__53672_54487,G__53673_54488,G__53674_54489));
} else {
var temp__5804__auto___54490 = (function (){var fexpr__53675 = cljs.core.deref(output_checker53662_54473);
return (fexpr__53675.cljs$core$IFn$_invoke$arity$1 ? fexpr__53675.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53675.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54490)){
var error__36733__auto___54491 = temp__5804__auto___54490;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54491], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53659_54470,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54491], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema53659_54470,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53660_54471], null)));

var ufv___54492 = schema.utils.use_fn_validation;
var output_schema53676_54493 = schema.core.Bool;
var input_schema53677_54494 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53678_54495 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53677_54494);
}),null));
var output_checker53679_54496 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53676_54493);
}),null));
var ret__38856__auto___54499 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__53680){
var validate__36731__auto__ = cljs.core.deref(ufv___54492);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54500 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53680], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53681_54501 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53682_54502 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53683_54503 = input_schema53677_54494;
var G__53684_54504 = cljs.core.deref(input_checker53678_54495);
var G__53685_54505 = args__36732__auto___54500;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53681_54501,G__53682_54502,G__53683_54503,G__53684_54504,G__53685_54505) : schema.core.fn_validator.call(null,G__53681_54501,G__53682_54502,G__53683_54503,G__53684_54504,G__53685_54505));
} else {
var temp__5804__auto___54506 = (function (){var fexpr__53686 = cljs.core.deref(input_checker53678_54495);
return (fexpr__53686.cljs$core$IFn$_invoke$arity$1 ? fexpr__53686.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54500) : fexpr__53686.call(null,args__36732__auto___54500));
})();
if(cljs.core.truth_(temp__5804__auto___54506)){
var error__36733__auto___54507 = temp__5804__auto___54506;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54507], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53677_54494,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54500,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54507], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var arg = G__53680;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53688_54508 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53689_54509 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53690_54510 = output_schema53676_54493;
var G__53691_54511 = cljs.core.deref(output_checker53679_54496);
var G__53692_54512 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53688_54508,G__53689_54509,G__53690_54510,G__53691_54511,G__53692_54512) : schema.core.fn_validator.call(null,G__53688_54508,G__53689_54509,G__53690_54510,G__53691_54511,G__53692_54512));
} else {
var temp__5804__auto___54513 = (function (){var fexpr__53693 = cljs.core.deref(output_checker53679_54496);
return (fexpr__53693.cljs$core$IFn$_invoke$arity$1 ? fexpr__53693.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53693.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54513)){
var error__36733__auto___54514 = temp__5804__auto___54513;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54514], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53676_54493,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54514], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema53676_54493,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53677_54494], null)));

var ufv___54515 = schema.utils.use_fn_validation;
var output_schema53694_54516 = schema.core.Bool;
var input_schema53695_54517 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53696_54518 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53695_54517);
}),null));
var output_checker53697_54519 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53694_54516);
}),null));
var ret__38856__auto___54520 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__53698,G__53699){
var validate__36731__auto__ = cljs.core.deref(ufv___54515);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54521 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53698,G__53699], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53700_54522 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53701_54523 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53702_54524 = input_schema53695_54517;
var G__53703_54525 = cljs.core.deref(input_checker53696_54518);
var G__53704_54526 = args__36732__auto___54521;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53700_54522,G__53701_54523,G__53702_54524,G__53703_54525,G__53704_54526) : schema.core.fn_validator.call(null,G__53700_54522,G__53701_54523,G__53702_54524,G__53703_54525,G__53704_54526));
} else {
var temp__5804__auto___54527 = (function (){var fexpr__53705 = cljs.core.deref(input_checker53696_54518);
return (fexpr__53705.cljs$core$IFn$_invoke$arity$1 ? fexpr__53705.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54521) : fexpr__53705.call(null,args__36732__auto___54521));
})();
if(cljs.core.truth_(temp__5804__auto___54527)){
var error__36733__auto___54528 = temp__5804__auto___54527;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54528], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53695_54517,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54521,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54528], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var reader_schema = G__53698;
var writer_schema = G__53699;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53708_54529 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53709_54530 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53710_54531 = output_schema53694_54516;
var G__53711_54532 = cljs.core.deref(output_checker53697_54519);
var G__53712_54533 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53708_54529,G__53709_54530,G__53710_54531,G__53711_54532,G__53712_54533) : schema.core.fn_validator.call(null,G__53708_54529,G__53709_54530,G__53710_54531,G__53711_54532,G__53712_54533));
} else {
var temp__5804__auto___54534 = (function (){var fexpr__53713 = cljs.core.deref(output_checker53697_54519);
return (fexpr__53713.cljs$core$IFn$_invoke$arity$1 ? fexpr__53713.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53713.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54534)){
var error__36733__auto___54536 = temp__5804__auto___54534;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54536], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53694_54516,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54536], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema53694_54516,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53695_54517], null)));

var ufv___54538 = schema.utils.use_fn_validation;
var output_schema53714_54539 = schema.core.Any;
var input_schema53715_54540 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53716_54541 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53715_54540);
}),null));
var output_checker53717_54542 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53714_54539);
}),null));
var ret__38856__auto___54543 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__53718){
var validate__36731__auto__ = cljs.core.deref(ufv___54538);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54544 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53718], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53719_54545 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53720_54546 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53721_54547 = input_schema53715_54540;
var G__53722_54548 = cljs.core.deref(input_checker53716_54541);
var G__53723_54549 = args__36732__auto___54544;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53719_54545,G__53720_54546,G__53721_54547,G__53722_54548,G__53723_54549) : schema.core.fn_validator.call(null,G__53719_54545,G__53720_54546,G__53721_54547,G__53722_54548,G__53723_54549));
} else {
var temp__5804__auto___54550 = (function (){var fexpr__53724 = cljs.core.deref(input_checker53716_54541);
return (fexpr__53724.cljs$core$IFn$_invoke$arity$1 ? fexpr__53724.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54544) : fexpr__53724.call(null,args__36732__auto___54544));
})();
if(cljs.core.truth_(temp__5804__auto___54550)){
var error__36733__auto___54551 = temp__5804__auto___54550;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54551], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53715_54540,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54544,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54551], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53718;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53725_54552 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53726_54553 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53727_54554 = output_schema53714_54539;
var G__53728_54555 = cljs.core.deref(output_checker53717_54542);
var G__53729_54556 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53725_54552,G__53726_54553,G__53727_54554,G__53728_54555,G__53729_54556) : schema.core.fn_validator.call(null,G__53725_54552,G__53726_54553,G__53727_54554,G__53728_54555,G__53729_54556));
} else {
var temp__5804__auto___54557 = (function (){var fexpr__53730 = cljs.core.deref(output_checker53717_54542);
return (fexpr__53730.cljs$core$IFn$_invoke$arity$1 ? fexpr__53730.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53730.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54557)){
var error__36733__auto___54558 = temp__5804__auto___54557;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54558], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53714_54539,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54558], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema53714_54539,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53715_54540], null)));

var ufv___54562 = schema.utils.use_fn_validation;
var output_schema53731_54563 = schema.core.Any;
var input_schema53732_54564 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53733_54565 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53732_54564);
}),null));
var output_checker53734_54566 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53731_54563);
}),null));
var ret__38856__auto___54567 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__53735){
var validate__36731__auto__ = cljs.core.deref(ufv___54562);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54568 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53735], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53736_54569 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53737_54570 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53738_54571 = input_schema53732_54564;
var G__53739_54572 = cljs.core.deref(input_checker53733_54565);
var G__53740_54573 = args__36732__auto___54568;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53736_54569,G__53737_54570,G__53738_54571,G__53739_54572,G__53740_54573) : schema.core.fn_validator.call(null,G__53736_54569,G__53737_54570,G__53738_54571,G__53739_54572,G__53740_54573));
} else {
var temp__5804__auto___54574 = (function (){var fexpr__53741 = cljs.core.deref(input_checker53733_54565);
return (fexpr__53741.cljs$core$IFn$_invoke$arity$1 ? fexpr__53741.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54568) : fexpr__53741.call(null,args__36732__auto___54568));
})();
if(cljs.core.truth_(temp__5804__auto___54574)){
var error__36733__auto___54575 = temp__5804__auto___54574;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54575], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53732_54564,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54568,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54575], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53735;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53743_54576 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53744_54577 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53745_54578 = output_schema53731_54563;
var G__53746_54579 = cljs.core.deref(output_checker53734_54566);
var G__53747_54580 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53743_54576,G__53744_54577,G__53745_54578,G__53746_54579,G__53747_54580) : schema.core.fn_validator.call(null,G__53743_54576,G__53744_54577,G__53745_54578,G__53746_54579,G__53747_54580));
} else {
var temp__5804__auto___54581 = (function (){var fexpr__53748 = cljs.core.deref(output_checker53734_54566);
return (fexpr__53748.cljs$core$IFn$_invoke$arity$1 ? fexpr__53748.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53748.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54581)){
var error__36733__auto___54582 = temp__5804__auto___54581;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54582], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53731_54563,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54582], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema53731_54563,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53732_54564], null)));

var ufv___54583 = schema.utils.use_fn_validation;
var output_schema53750_54584 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema53751_54585 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker53752_54586 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53751_54585);
}),null));
var output_checker53753_54587 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53750_54584);
}),null));
var ret__38856__auto___54588 = /**
 * Inputs: [schema :- LancasterSchema path :- [s/Any]]
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(G__53754,G__53755){
var validate__36731__auto__ = cljs.core.deref(ufv___54583);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54589 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53754,G__53755], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53761_54590 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53762_54591 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53763_54592 = input_schema53751_54585;
var G__53764_54593 = cljs.core.deref(input_checker53752_54586);
var G__53765_54594 = args__36732__auto___54589;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53761_54590,G__53762_54591,G__53763_54592,G__53764_54593,G__53765_54594) : schema.core.fn_validator.call(null,G__53761_54590,G__53762_54591,G__53763_54592,G__53764_54593,G__53765_54594));
} else {
var temp__5804__auto___54595 = (function (){var fexpr__53766 = cljs.core.deref(input_checker53752_54586);
return (fexpr__53766.cljs$core$IFn$_invoke$arity$1 ? fexpr__53766.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54589) : fexpr__53766.call(null,args__36732__auto___54589));
})();
if(cljs.core.truth_(temp__5804__auto___54595)){
var error__36733__auto___54596 = temp__5804__auto___54595;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54596], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53751_54585,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54589,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54596], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53754;
var path = G__53755;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

if((path == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path], null));
}
}

return deercreeklabs.lancaster.sub.schema_at_path(schema__$1,path);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53775_54597 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53776_54598 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53777_54599 = output_schema53750_54584;
var G__53778_54600 = cljs.core.deref(output_checker53753_54587);
var G__53779_54601 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53775_54597,G__53776_54598,G__53777_54599,G__53778_54600,G__53779_54601) : schema.core.fn_validator.call(null,G__53775_54597,G__53776_54598,G__53777_54599,G__53778_54600,G__53779_54601));
} else {
var temp__5804__auto___54602 = (function (){var fexpr__53780 = cljs.core.deref(output_checker53753_54587);
return (fexpr__53780.cljs$core$IFn$_invoke$arity$1 ? fexpr__53780.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53780.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54602)){
var error__36733__auto___54603 = temp__5804__auto___54602;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54603], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53750_54584,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54603], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.__GT_FnSchema(output_schema53750_54584,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53751_54585], null)));

var ufv___54604 = schema.utils.use_fn_validation;
var output_schema53782_54605 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema53783_54606 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53784_54607 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53783_54606);
}),null));
var output_checker53785_54608 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53782_54605);
}),null));
var ret__38856__auto___54609 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__53786){
var validate__36731__auto__ = cljs.core.deref(ufv___54604);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54611 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53786], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53788_54613 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53789_54614 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__53790_54615 = input_schema53783_54606;
var G__53791_54616 = cljs.core.deref(input_checker53784_54607);
var G__53792_54617 = args__36732__auto___54611;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53788_54613,G__53789_54614,G__53790_54615,G__53791_54616,G__53792_54617) : schema.core.fn_validator.call(null,G__53788_54613,G__53789_54614,G__53790_54615,G__53791_54616,G__53792_54617));
} else {
var temp__5804__auto___54619 = (function (){var fexpr__53794 = cljs.core.deref(input_checker53784_54607);
return (fexpr__53794.cljs$core$IFn$_invoke$arity$1 ? fexpr__53794.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54611) : fexpr__53794.call(null,args__36732__auto___54611));
})();
if(cljs.core.truth_(temp__5804__auto___54619)){
var error__36733__auto___54621 = temp__5804__auto___54619;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54621], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53783_54606,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54611,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54621], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var union_schema = G__53786;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53796_54625 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53797_54626 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__53798_54627 = output_schema53782_54605;
var G__53799_54628 = cljs.core.deref(output_checker53785_54608);
var G__53800_54629 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53796_54625,G__53797_54626,G__53798_54627,G__53799_54628,G__53800_54629) : schema.core.fn_validator.call(null,G__53796_54625,G__53797_54626,G__53798_54627,G__53799_54628,G__53800_54629));
} else {
var temp__5804__auto___54633 = (function (){var fexpr__53802 = cljs.core.deref(output_checker53785_54608);
return (fexpr__53802.cljs$core$IFn$_invoke$arity$1 ? fexpr__53802.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53802.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54633)){
var error__36733__auto___54635 = temp__5804__auto___54633;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54635], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53782_54605,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54635], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema53782_54605,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53783_54606], null)));

var ufv___54638 = schema.utils.use_fn_validation;
var output_schema53804_54639 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53805_54640 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53806_54641 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53805_54640);
}),null));
var output_checker53807_54642 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53804_54639);
}),null));
var ret__38856__auto___54646 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__53809,G__53810){
var validate__36731__auto__ = cljs.core.deref(ufv___54638);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54648 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53809,G__53810], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53822_54649 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53823_54650 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__53824_54651 = input_schema53805_54640;
var G__53825_54652 = cljs.core.deref(input_checker53806_54641);
var G__53826_54653 = args__36732__auto___54648;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53822_54649,G__53823_54650,G__53824_54651,G__53825_54652,G__53826_54653) : schema.core.fn_validator.call(null,G__53822_54649,G__53823_54650,G__53824_54651,G__53825_54652,G__53826_54653));
} else {
var temp__5804__auto___54656 = (function (){var fexpr__53827 = cljs.core.deref(input_checker53806_54641);
return (fexpr__53827.cljs$core$IFn$_invoke$arity$1 ? fexpr__53827.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54648) : fexpr__53827.call(null,args__36732__auto___54648));
})();
if(cljs.core.truth_(temp__5804__auto___54656)){
var error__36733__auto___54659 = temp__5804__auto___54656;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54659], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53805_54640,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54648,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54659], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var union_schema = G__53809;
var branch_index = G__53810;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = branch_index;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53833_54661 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53834_54662 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__53835_54663 = output_schema53804_54639;
var G__53836_54664 = cljs.core.deref(output_checker53807_54642);
var G__53837_54665 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53833_54661,G__53834_54662,G__53835_54663,G__53836_54664,G__53837_54665) : schema.core.fn_validator.call(null,G__53833_54661,G__53834_54662,G__53835_54663,G__53836_54664,G__53837_54665));
} else {
var temp__5804__auto___54666 = (function (){var fexpr__53842 = cljs.core.deref(output_checker53807_54642);
return (fexpr__53842.cljs$core$IFn$_invoke$arity$1 ? fexpr__53842.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53842.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54666)){
var error__36733__auto___54669 = temp__5804__auto___54666;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54669], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53804_54639,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54669], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema53804_54639,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53805_54640], null)));

var ufv___54671 = schema.utils.use_fn_validation;
var output_schema53843_54672 = schema.core.Keyword;
var input_schema53844_54673 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53845_54674 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53844_54673);
}),null));
var output_checker53846_54675 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53843_54672);
}),null));
var ret__38856__auto___54676 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__53847){
var validate__36731__auto__ = cljs.core.deref(ufv___54671);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___54677 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53847], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53852_54678 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53853_54679 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__53854_54680 = input_schema53844_54673;
var G__53855_54681 = cljs.core.deref(input_checker53845_54674);
var G__53856_54682 = args__36732__auto___54677;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53852_54678,G__53853_54679,G__53854_54680,G__53855_54681,G__53856_54682) : schema.core.fn_validator.call(null,G__53852_54678,G__53853_54679,G__53854_54680,G__53855_54681,G__53856_54682));
} else {
var temp__5804__auto___54683 = (function (){var fexpr__53857 = cljs.core.deref(input_checker53845_54674);
return (fexpr__53857.cljs$core$IFn$_invoke$arity$1 ? fexpr__53857.cljs$core$IFn$_invoke$arity$1(args__36732__auto___54677) : fexpr__53857.call(null,args__36732__auto___54677));
})();
if(cljs.core.truth_(temp__5804__auto___54683)){
var error__36733__auto___54684 = temp__5804__auto___54683;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54684], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53844_54673,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___54677,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54684], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var schema__$1 = G__53847;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53860_54685 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53861_54686 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__53862_54687 = output_schema53843_54672;
var G__53863_54688 = cljs.core.deref(output_checker53846_54675);
var G__53864_54689 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53860_54685,G__53861_54686,G__53862_54687,G__53863_54688,G__53864_54689) : schema.core.fn_validator.call(null,G__53860_54685,G__53861_54686,G__53862_54687,G__53863_54688,G__53864_54689));
} else {
var temp__5804__auto___54690 = (function (){var fexpr__53866 = cljs.core.deref(output_checker53846_54675);
return (fexpr__53866.cljs$core$IFn$_invoke$arity$1 ? fexpr__53866.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__53866.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54690)){
var error__36733__auto___54691 = temp__5804__auto___54690;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___54691], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53843_54672,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___54691], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema53843_54672,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53844_54673], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
