goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__29380 = arguments.length;
switch (G__29380) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29385 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29385 = (function (f,blockable,meta29386){
this.f = f;
this.blockable = blockable;
this.meta29386 = meta29386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29387,meta29386__$1){
var self__ = this;
var _29387__$1 = this;
return (new cljs.core.async.t_cljs$core$async29385(self__.f,self__.blockable,meta29386__$1));
}));

(cljs.core.async.t_cljs$core$async29385.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29387){
var self__ = this;
var _29387__$1 = this;
return self__.meta29386;
}));

(cljs.core.async.t_cljs$core$async29385.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29385.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29385.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async29385.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async29385.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29386","meta29386",-1473388796,null)], null);
}));

(cljs.core.async.t_cljs$core$async29385.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29385.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29385");

(cljs.core.async.t_cljs$core$async29385.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async29385");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29385.
 */
cljs.core.async.__GT_t_cljs$core$async29385 = (function cljs$core$async$__GT_t_cljs$core$async29385(f__$1,blockable__$1,meta29386){
return (new cljs.core.async.t_cljs$core$async29385(f__$1,blockable__$1,meta29386));
});

}

return (new cljs.core.async.t_cljs$core$async29385(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__29421 = arguments.length;
switch (G__29421) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__29435 = arguments.length;
switch (G__29435) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__29453 = arguments.length;
switch (G__29453) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32917 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32917) : fn1.call(null,val_32917));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32917) : fn1.call(null,val_32917));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__29477 = arguments.length;
switch (G__29477) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___32919 = n;
var x_32920 = (0);
while(true){
if((x_32920 < n__4741__auto___32919)){
(a[x_32920] = x_32920);

var G__32925 = (x_32920 + (1));
x_32920 = G__32925;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29483 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29483 = (function (flag,meta29484){
this.flag = flag;
this.meta29484 = meta29484;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29483.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29485,meta29484__$1){
var self__ = this;
var _29485__$1 = this;
return (new cljs.core.async.t_cljs$core$async29483(self__.flag,meta29484__$1));
}));

(cljs.core.async.t_cljs$core$async29483.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29485){
var self__ = this;
var _29485__$1 = this;
return self__.meta29484;
}));

(cljs.core.async.t_cljs$core$async29483.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29483.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async29483.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29483.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async29483.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29484","meta29484",-1462655514,null)], null);
}));

(cljs.core.async.t_cljs$core$async29483.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29483.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29483");

(cljs.core.async.t_cljs$core$async29483.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async29483");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29483.
 */
cljs.core.async.__GT_t_cljs$core$async29483 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29483(flag__$1,meta29484){
return (new cljs.core.async.t_cljs$core$async29483(flag__$1,meta29484));
});

}

return (new cljs.core.async.t_cljs$core$async29483(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29493 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29493 = (function (flag,cb,meta29494){
this.flag = flag;
this.cb = cb;
this.meta29494 = meta29494;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29493.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29495,meta29494__$1){
var self__ = this;
var _29495__$1 = this;
return (new cljs.core.async.t_cljs$core$async29493(self__.flag,self__.cb,meta29494__$1));
}));

(cljs.core.async.t_cljs$core$async29493.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29495){
var self__ = this;
var _29495__$1 = this;
return self__.meta29494;
}));

(cljs.core.async.t_cljs$core$async29493.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29493.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async29493.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29493.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async29493.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29494","meta29494",1588480772,null)], null);
}));

(cljs.core.async.t_cljs$core$async29493.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29493.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29493");

(cljs.core.async.t_cljs$core$async29493.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async29493");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29493.
 */
cljs.core.async.__GT_t_cljs$core$async29493 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29493(flag__$1,cb__$1,meta29494){
return (new cljs.core.async.t_cljs$core$async29493(flag__$1,cb__$1,meta29494));
});

}

return (new cljs.core.async.t_cljs$core$async29493(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29497_SHARP_){
var G__29507 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29497_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29507) : fret.call(null,G__29507));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29498_SHARP_){
var G__29508 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29498_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29508) : fret.call(null,G__29508));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32940 = (i + (1));
i = G__32940;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___32945 = arguments.length;
var i__4865__auto___32948 = (0);
while(true){
if((i__4865__auto___32948 < len__4864__auto___32945)){
args__4870__auto__.push((arguments[i__4865__auto___32948]));

var G__32949 = (i__4865__auto___32948 + (1));
i__4865__auto___32948 = G__32949;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29519){
var map__29520 = p__29519;
var map__29520__$1 = cljs.core.__destructure_map(map__29520);
var opts = map__29520__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29516){
var G__29517 = cljs.core.first(seq29516);
var seq29516__$1 = cljs.core.next(seq29516);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29517,seq29516__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__29539 = arguments.length;
switch (G__29539) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29281__auto___32962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_29605){
var state_val_29607 = (state_29605[(1)]);
if((state_val_29607 === (7))){
var inst_29586 = (state_29605[(2)]);
var state_29605__$1 = state_29605;
var statearr_29630_32965 = state_29605__$1;
(statearr_29630_32965[(2)] = inst_29586);

(statearr_29630_32965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (1))){
var state_29605__$1 = state_29605;
var statearr_29631_32966 = state_29605__$1;
(statearr_29631_32966[(2)] = null);

(statearr_29631_32966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (4))){
var inst_29559 = (state_29605[(7)]);
var inst_29559__$1 = (state_29605[(2)]);
var inst_29566 = (inst_29559__$1 == null);
var state_29605__$1 = (function (){var statearr_29632 = state_29605;
(statearr_29632[(7)] = inst_29559__$1);

return statearr_29632;
})();
if(cljs.core.truth_(inst_29566)){
var statearr_29633_32967 = state_29605__$1;
(statearr_29633_32967[(1)] = (5));

} else {
var statearr_29634_32968 = state_29605__$1;
(statearr_29634_32968[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (13))){
var state_29605__$1 = state_29605;
var statearr_29635_32969 = state_29605__$1;
(statearr_29635_32969[(2)] = null);

(statearr_29635_32969[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (6))){
var inst_29559 = (state_29605[(7)]);
var state_29605__$1 = state_29605;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29605__$1,(11),to,inst_29559);
} else {
if((state_val_29607 === (3))){
var inst_29596 = (state_29605[(2)]);
var state_29605__$1 = state_29605;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29605__$1,inst_29596);
} else {
if((state_val_29607 === (12))){
var state_29605__$1 = state_29605;
var statearr_29637_32975 = state_29605__$1;
(statearr_29637_32975[(2)] = null);

(statearr_29637_32975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (2))){
var state_29605__$1 = state_29605;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29605__$1,(4),from);
} else {
if((state_val_29607 === (11))){
var inst_29579 = (state_29605[(2)]);
var state_29605__$1 = state_29605;
if(cljs.core.truth_(inst_29579)){
var statearr_29638_32976 = state_29605__$1;
(statearr_29638_32976[(1)] = (12));

} else {
var statearr_29639_32978 = state_29605__$1;
(statearr_29639_32978[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (9))){
var state_29605__$1 = state_29605;
var statearr_29640_32979 = state_29605__$1;
(statearr_29640_32979[(2)] = null);

(statearr_29640_32979[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (5))){
var state_29605__$1 = state_29605;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29641_32980 = state_29605__$1;
(statearr_29641_32980[(1)] = (8));

} else {
var statearr_29654_32981 = state_29605__$1;
(statearr_29654_32981[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (14))){
var inst_29584 = (state_29605[(2)]);
var state_29605__$1 = state_29605;
var statearr_29655_32983 = state_29605__$1;
(statearr_29655_32983[(2)] = inst_29584);

(statearr_29655_32983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (10))){
var inst_29576 = (state_29605[(2)]);
var state_29605__$1 = state_29605;
var statearr_29656_32984 = state_29605__$1;
(statearr_29656_32984[(2)] = inst_29576);

(statearr_29656_32984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29607 === (8))){
var inst_29569 = cljs.core.async.close_BANG_(to);
var state_29605__$1 = state_29605;
var statearr_29657_32985 = state_29605__$1;
(statearr_29657_32985[(2)] = inst_29569);

(statearr_29657_32985[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_29659 = [null,null,null,null,null,null,null,null];
(statearr_29659[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_29659[(1)] = (1));

return statearr_29659;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_29605){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_29605);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e29661){var ex__28981__auto__ = e29661;
var statearr_29662_32986 = state_29605;
(statearr_29662_32986[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_29605[(4)]))){
var statearr_29663_32991 = state_29605;
(statearr_29663_32991[(1)] = cljs.core.first((state_29605[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32992 = state_29605;
state_29605 = G__32992;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_29605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_29605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_29666 = f__29282__auto__();
(statearr_29666[(6)] = c__29281__auto___32962);

return statearr_29666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__29669){
var vec__29671 = p__29669;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29671,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29671,(1),null);
var job = vec__29671;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__29281__auto___32997 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_29680){
var state_val_29681 = (state_29680[(1)]);
if((state_val_29681 === (1))){
var state_29680__$1 = state_29680;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29680__$1,(2),res,v);
} else {
if((state_val_29681 === (2))){
var inst_29677 = (state_29680[(2)]);
var inst_29678 = cljs.core.async.close_BANG_(res);
var state_29680__$1 = (function (){var statearr_29692 = state_29680;
(statearr_29692[(7)] = inst_29677);

return statearr_29692;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29680__$1,inst_29678);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0 = (function (){
var statearr_29694 = [null,null,null,null,null,null,null,null];
(statearr_29694[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__);

(statearr_29694[(1)] = (1));

return statearr_29694;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1 = (function (state_29680){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_29680);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e29698){var ex__28981__auto__ = e29698;
var statearr_29699_32998 = state_29680;
(statearr_29699_32998[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_29680[(4)]))){
var statearr_29700_32999 = state_29680;
(statearr_29700_32999[(1)] = cljs.core.first((state_29680[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33001 = state_29680;
state_29680 = G__33001;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = function(state_29680){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1.call(this,state_29680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_29713 = f__29282__auto__();
(statearr_29713[(6)] = c__29281__auto___32997);

return statearr_29713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__29727){
var vec__29731 = p__29727;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29731,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29731,(1),null);
var job = vec__29731;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___33006 = n;
var __33007 = (0);
while(true){
if((__33007 < n__4741__auto___33006)){
var G__29740_33009 = type;
var G__29740_33010__$1 = (((G__29740_33009 instanceof cljs.core.Keyword))?G__29740_33009.fqn:null);
switch (G__29740_33010__$1) {
case "compute":
var c__29281__auto___33015 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33007,c__29281__auto___33015,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async){
return (function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = ((function (__33007,c__29281__auto___33015,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async){
return (function (state_29754){
var state_val_29755 = (state_29754[(1)]);
if((state_val_29755 === (1))){
var state_29754__$1 = state_29754;
var statearr_29759_33016 = state_29754__$1;
(statearr_29759_33016[(2)] = null);

(statearr_29759_33016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29755 === (2))){
var state_29754__$1 = state_29754;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29754__$1,(4),jobs);
} else {
if((state_val_29755 === (3))){
var inst_29752 = (state_29754[(2)]);
var state_29754__$1 = state_29754;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29754__$1,inst_29752);
} else {
if((state_val_29755 === (4))){
var inst_29744 = (state_29754[(2)]);
var inst_29745 = process(inst_29744);
var state_29754__$1 = state_29754;
if(cljs.core.truth_(inst_29745)){
var statearr_29763_33023 = state_29754__$1;
(statearr_29763_33023[(1)] = (5));

} else {
var statearr_29764_33024 = state_29754__$1;
(statearr_29764_33024[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29755 === (5))){
var state_29754__$1 = state_29754;
var statearr_29765_33025 = state_29754__$1;
(statearr_29765_33025[(2)] = null);

(statearr_29765_33025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29755 === (6))){
var state_29754__$1 = state_29754;
var statearr_29766_33026 = state_29754__$1;
(statearr_29766_33026[(2)] = null);

(statearr_29766_33026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29755 === (7))){
var inst_29750 = (state_29754[(2)]);
var state_29754__$1 = state_29754;
var statearr_29767_33030 = state_29754__$1;
(statearr_29767_33030[(2)] = inst_29750);

(statearr_29767_33030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33007,c__29281__auto___33015,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async))
;
return ((function (__33007,switch__28977__auto__,c__29281__auto___33015,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0 = (function (){
var statearr_29768 = [null,null,null,null,null,null,null];
(statearr_29768[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__);

(statearr_29768[(1)] = (1));

return statearr_29768;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1 = (function (state_29754){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_29754);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e29771){var ex__28981__auto__ = e29771;
var statearr_29772_33035 = state_29754;
(statearr_29772_33035[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_29754[(4)]))){
var statearr_29773_33037 = state_29754;
(statearr_29773_33037[(1)] = cljs.core.first((state_29754[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33038 = state_29754;
state_29754 = G__33038;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = function(state_29754){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1.call(this,state_29754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__;
})()
;})(__33007,switch__28977__auto__,c__29281__auto___33015,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async))
})();
var state__29283__auto__ = (function (){var statearr_29777 = f__29282__auto__();
(statearr_29777[(6)] = c__29281__auto___33015);

return statearr_29777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
});})(__33007,c__29281__auto___33015,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async))
);


break;
case "async":
var c__29281__auto___33040 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33007,c__29281__auto___33040,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async){
return (function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = ((function (__33007,c__29281__auto___33040,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async){
return (function (state_29792){
var state_val_29793 = (state_29792[(1)]);
if((state_val_29793 === (1))){
var state_29792__$1 = state_29792;
var statearr_29795_33042 = state_29792__$1;
(statearr_29795_33042[(2)] = null);

(statearr_29795_33042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29793 === (2))){
var state_29792__$1 = state_29792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29792__$1,(4),jobs);
} else {
if((state_val_29793 === (3))){
var inst_29790 = (state_29792[(2)]);
var state_29792__$1 = state_29792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29792__$1,inst_29790);
} else {
if((state_val_29793 === (4))){
var inst_29782 = (state_29792[(2)]);
var inst_29783 = async(inst_29782);
var state_29792__$1 = state_29792;
if(cljs.core.truth_(inst_29783)){
var statearr_29798_33046 = state_29792__$1;
(statearr_29798_33046[(1)] = (5));

} else {
var statearr_29799_33048 = state_29792__$1;
(statearr_29799_33048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29793 === (5))){
var state_29792__$1 = state_29792;
var statearr_29800_33049 = state_29792__$1;
(statearr_29800_33049[(2)] = null);

(statearr_29800_33049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29793 === (6))){
var state_29792__$1 = state_29792;
var statearr_29809_33050 = state_29792__$1;
(statearr_29809_33050[(2)] = null);

(statearr_29809_33050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29793 === (7))){
var inst_29788 = (state_29792[(2)]);
var state_29792__$1 = state_29792;
var statearr_29810_33051 = state_29792__$1;
(statearr_29810_33051[(2)] = inst_29788);

(statearr_29810_33051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33007,c__29281__auto___33040,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async))
;
return ((function (__33007,switch__28977__auto__,c__29281__auto___33040,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0 = (function (){
var statearr_29814 = [null,null,null,null,null,null,null];
(statearr_29814[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__);

(statearr_29814[(1)] = (1));

return statearr_29814;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1 = (function (state_29792){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_29792);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e29816){var ex__28981__auto__ = e29816;
var statearr_29817_33052 = state_29792;
(statearr_29817_33052[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_29792[(4)]))){
var statearr_29820_33053 = state_29792;
(statearr_29820_33053[(1)] = cljs.core.first((state_29792[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33055 = state_29792;
state_29792 = G__33055;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = function(state_29792){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1.call(this,state_29792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__;
})()
;})(__33007,switch__28977__auto__,c__29281__auto___33040,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async))
})();
var state__29283__auto__ = (function (){var statearr_29822 = f__29282__auto__();
(statearr_29822[(6)] = c__29281__auto___33040);

return statearr_29822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
});})(__33007,c__29281__auto___33040,G__29740_33009,G__29740_33010__$1,n__4741__auto___33006,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29740_33010__$1)].join('')));

}

var G__33057 = (__33007 + (1));
__33007 = G__33057;
continue;
} else {
}
break;
}

var c__29281__auto___33058 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_29855){
var state_val_29856 = (state_29855[(1)]);
if((state_val_29856 === (7))){
var inst_29850 = (state_29855[(2)]);
var state_29855__$1 = state_29855;
var statearr_29862_33059 = state_29855__$1;
(statearr_29862_33059[(2)] = inst_29850);

(statearr_29862_33059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29856 === (1))){
var state_29855__$1 = state_29855;
var statearr_29864_33068 = state_29855__$1;
(statearr_29864_33068[(2)] = null);

(statearr_29864_33068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29856 === (4))){
var inst_29826 = (state_29855[(7)]);
var inst_29826__$1 = (state_29855[(2)]);
var inst_29827 = (inst_29826__$1 == null);
var state_29855__$1 = (function (){var statearr_29866 = state_29855;
(statearr_29866[(7)] = inst_29826__$1);

return statearr_29866;
})();
if(cljs.core.truth_(inst_29827)){
var statearr_29868_33075 = state_29855__$1;
(statearr_29868_33075[(1)] = (5));

} else {
var statearr_29870_33076 = state_29855__$1;
(statearr_29870_33076[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29856 === (6))){
var inst_29831 = (state_29855[(8)]);
var inst_29826 = (state_29855[(7)]);
var inst_29831__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29842 = [inst_29826,inst_29831__$1];
var inst_29843 = (new cljs.core.PersistentVector(null,2,(5),inst_29841,inst_29842,null));
var state_29855__$1 = (function (){var statearr_29877 = state_29855;
(statearr_29877[(8)] = inst_29831__$1);

return statearr_29877;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29855__$1,(8),jobs,inst_29843);
} else {
if((state_val_29856 === (3))){
var inst_29853 = (state_29855[(2)]);
var state_29855__$1 = state_29855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29855__$1,inst_29853);
} else {
if((state_val_29856 === (2))){
var state_29855__$1 = state_29855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29855__$1,(4),from);
} else {
if((state_val_29856 === (9))){
var inst_29847 = (state_29855[(2)]);
var state_29855__$1 = (function (){var statearr_29897 = state_29855;
(statearr_29897[(9)] = inst_29847);

return statearr_29897;
})();
var statearr_29898_33086 = state_29855__$1;
(statearr_29898_33086[(2)] = null);

(statearr_29898_33086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29856 === (5))){
var inst_29829 = cljs.core.async.close_BANG_(jobs);
var state_29855__$1 = state_29855;
var statearr_29907_33087 = state_29855__$1;
(statearr_29907_33087[(2)] = inst_29829);

(statearr_29907_33087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29856 === (8))){
var inst_29831 = (state_29855[(8)]);
var inst_29845 = (state_29855[(2)]);
var state_29855__$1 = (function (){var statearr_29913 = state_29855;
(statearr_29913[(10)] = inst_29845);

return statearr_29913;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29855__$1,(9),results,inst_29831);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0 = (function (){
var statearr_29917 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29917[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__);

(statearr_29917[(1)] = (1));

return statearr_29917;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1 = (function (state_29855){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_29855);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e29929){var ex__28981__auto__ = e29929;
var statearr_29930_33105 = state_29855;
(statearr_29930_33105[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_29855[(4)]))){
var statearr_29933_33106 = state_29855;
(statearr_29933_33106[(1)] = cljs.core.first((state_29855[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33107 = state_29855;
state_29855 = G__33107;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = function(state_29855){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1.call(this,state_29855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_29940 = f__29282__auto__();
(statearr_29940[(6)] = c__29281__auto___33058);

return statearr_29940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


var c__29281__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_29994){
var state_val_29995 = (state_29994[(1)]);
if((state_val_29995 === (7))){
var inst_29989 = (state_29994[(2)]);
var state_29994__$1 = state_29994;
var statearr_30000_33115 = state_29994__$1;
(statearr_30000_33115[(2)] = inst_29989);

(statearr_30000_33115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (20))){
var state_29994__$1 = state_29994;
var statearr_30001_33116 = state_29994__$1;
(statearr_30001_33116[(2)] = null);

(statearr_30001_33116[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (1))){
var state_29994__$1 = state_29994;
var statearr_30019_33117 = state_29994__$1;
(statearr_30019_33117[(2)] = null);

(statearr_30019_33117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (4))){
var inst_29945 = (state_29994[(7)]);
var inst_29945__$1 = (state_29994[(2)]);
var inst_29946 = (inst_29945__$1 == null);
var state_29994__$1 = (function (){var statearr_30032 = state_29994;
(statearr_30032[(7)] = inst_29945__$1);

return statearr_30032;
})();
if(cljs.core.truth_(inst_29946)){
var statearr_30033_33118 = state_29994__$1;
(statearr_30033_33118[(1)] = (5));

} else {
var statearr_30034_33119 = state_29994__$1;
(statearr_30034_33119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (15))){
var inst_29958 = (state_29994[(8)]);
var state_29994__$1 = state_29994;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29994__$1,(18),to,inst_29958);
} else {
if((state_val_29995 === (21))){
var inst_29983 = (state_29994[(2)]);
var state_29994__$1 = state_29994;
var statearr_30043_33123 = state_29994__$1;
(statearr_30043_33123[(2)] = inst_29983);

(statearr_30043_33123[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (13))){
var inst_29985 = (state_29994[(2)]);
var state_29994__$1 = (function (){var statearr_30045 = state_29994;
(statearr_30045[(9)] = inst_29985);

return statearr_30045;
})();
var statearr_30046_33125 = state_29994__$1;
(statearr_30046_33125[(2)] = null);

(statearr_30046_33125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (6))){
var inst_29945 = (state_29994[(7)]);
var state_29994__$1 = state_29994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29994__$1,(11),inst_29945);
} else {
if((state_val_29995 === (17))){
var inst_29978 = (state_29994[(2)]);
var state_29994__$1 = state_29994;
if(cljs.core.truth_(inst_29978)){
var statearr_30050_33127 = state_29994__$1;
(statearr_30050_33127[(1)] = (19));

} else {
var statearr_30051_33128 = state_29994__$1;
(statearr_30051_33128[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (3))){
var inst_29991 = (state_29994[(2)]);
var state_29994__$1 = state_29994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29994__$1,inst_29991);
} else {
if((state_val_29995 === (12))){
var inst_29955 = (state_29994[(10)]);
var state_29994__$1 = state_29994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29994__$1,(14),inst_29955);
} else {
if((state_val_29995 === (2))){
var state_29994__$1 = state_29994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29994__$1,(4),results);
} else {
if((state_val_29995 === (19))){
var state_29994__$1 = state_29994;
var statearr_30059_33130 = state_29994__$1;
(statearr_30059_33130[(2)] = null);

(statearr_30059_33130[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (11))){
var inst_29955 = (state_29994[(2)]);
var state_29994__$1 = (function (){var statearr_30060 = state_29994;
(statearr_30060[(10)] = inst_29955);

return statearr_30060;
})();
var statearr_30061_33131 = state_29994__$1;
(statearr_30061_33131[(2)] = null);

(statearr_30061_33131[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (9))){
var state_29994__$1 = state_29994;
var statearr_30062_33133 = state_29994__$1;
(statearr_30062_33133[(2)] = null);

(statearr_30062_33133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (5))){
var state_29994__$1 = state_29994;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30063_33134 = state_29994__$1;
(statearr_30063_33134[(1)] = (8));

} else {
var statearr_30067_33135 = state_29994__$1;
(statearr_30067_33135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (14))){
var inst_29968 = (state_29994[(11)]);
var inst_29958 = (state_29994[(8)]);
var inst_29958__$1 = (state_29994[(2)]);
var inst_29967 = (inst_29958__$1 == null);
var inst_29968__$1 = cljs.core.not(inst_29967);
var state_29994__$1 = (function (){var statearr_30068 = state_29994;
(statearr_30068[(11)] = inst_29968__$1);

(statearr_30068[(8)] = inst_29958__$1);

return statearr_30068;
})();
if(inst_29968__$1){
var statearr_30073_33136 = state_29994__$1;
(statearr_30073_33136[(1)] = (15));

} else {
var statearr_30078_33137 = state_29994__$1;
(statearr_30078_33137[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (16))){
var inst_29968 = (state_29994[(11)]);
var state_29994__$1 = state_29994;
var statearr_30091_33138 = state_29994__$1;
(statearr_30091_33138[(2)] = inst_29968);

(statearr_30091_33138[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (10))){
var inst_29952 = (state_29994[(2)]);
var state_29994__$1 = state_29994;
var statearr_30106_33139 = state_29994__$1;
(statearr_30106_33139[(2)] = inst_29952);

(statearr_30106_33139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (18))){
var inst_29975 = (state_29994[(2)]);
var state_29994__$1 = state_29994;
var statearr_30107_33143 = state_29994__$1;
(statearr_30107_33143[(2)] = inst_29975);

(statearr_30107_33143[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29995 === (8))){
var inst_29949 = cljs.core.async.close_BANG_(to);
var state_29994__$1 = state_29994;
var statearr_30108_33148 = state_29994__$1;
(statearr_30108_33148[(2)] = inst_29949);

(statearr_30108_33148[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0 = (function (){
var statearr_30122 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30122[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__);

(statearr_30122[(1)] = (1));

return statearr_30122;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1 = (function (state_29994){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_29994);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e30130){var ex__28981__auto__ = e30130;
var statearr_30132_33149 = state_29994;
(statearr_30132_33149[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_29994[(4)]))){
var statearr_30137_33150 = state_29994;
(statearr_30137_33150[(1)] = cljs.core.first((state_29994[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33151 = state_29994;
state_29994 = G__33151;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__ = function(state_29994){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1.call(this,state_29994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_30149 = f__29282__auto__();
(statearr_30149[(6)] = c__29281__auto__);

return statearr_30149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

return c__29281__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__30168 = arguments.length;
switch (G__30168) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__30183 = arguments.length;
switch (G__30183) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__30210 = arguments.length;
switch (G__30210) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__29281__auto___33157 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_30265){
var state_val_30266 = (state_30265[(1)]);
if((state_val_30266 === (7))){
var inst_30261 = (state_30265[(2)]);
var state_30265__$1 = state_30265;
var statearr_30275_33158 = state_30265__$1;
(statearr_30275_33158[(2)] = inst_30261);

(statearr_30275_33158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (1))){
var state_30265__$1 = state_30265;
var statearr_30276_33159 = state_30265__$1;
(statearr_30276_33159[(2)] = null);

(statearr_30276_33159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (4))){
var inst_30226 = (state_30265[(7)]);
var inst_30226__$1 = (state_30265[(2)]);
var inst_30227 = (inst_30226__$1 == null);
var state_30265__$1 = (function (){var statearr_30277 = state_30265;
(statearr_30277[(7)] = inst_30226__$1);

return statearr_30277;
})();
if(cljs.core.truth_(inst_30227)){
var statearr_30280_33160 = state_30265__$1;
(statearr_30280_33160[(1)] = (5));

} else {
var statearr_30282_33161 = state_30265__$1;
(statearr_30282_33161[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (13))){
var state_30265__$1 = state_30265;
var statearr_30283_33162 = state_30265__$1;
(statearr_30283_33162[(2)] = null);

(statearr_30283_33162[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (6))){
var inst_30226 = (state_30265[(7)]);
var inst_30234 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30226) : p.call(null,inst_30226));
var state_30265__$1 = state_30265;
if(cljs.core.truth_(inst_30234)){
var statearr_30286_33171 = state_30265__$1;
(statearr_30286_33171[(1)] = (9));

} else {
var statearr_30287_33172 = state_30265__$1;
(statearr_30287_33172[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (3))){
var inst_30263 = (state_30265[(2)]);
var state_30265__$1 = state_30265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30265__$1,inst_30263);
} else {
if((state_val_30266 === (12))){
var state_30265__$1 = state_30265;
var statearr_30290_33173 = state_30265__$1;
(statearr_30290_33173[(2)] = null);

(statearr_30290_33173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (2))){
var state_30265__$1 = state_30265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30265__$1,(4),ch);
} else {
if((state_val_30266 === (11))){
var inst_30226 = (state_30265[(7)]);
var inst_30239 = (state_30265[(2)]);
var state_30265__$1 = state_30265;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30265__$1,(8),inst_30239,inst_30226);
} else {
if((state_val_30266 === (9))){
var state_30265__$1 = state_30265;
var statearr_30294_33174 = state_30265__$1;
(statearr_30294_33174[(2)] = tc);

(statearr_30294_33174[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (5))){
var inst_30229 = cljs.core.async.close_BANG_(tc);
var inst_30231 = cljs.core.async.close_BANG_(fc);
var state_30265__$1 = (function (){var statearr_30295 = state_30265;
(statearr_30295[(8)] = inst_30229);

return statearr_30295;
})();
var statearr_30297_33175 = state_30265__$1;
(statearr_30297_33175[(2)] = inst_30231);

(statearr_30297_33175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (14))){
var inst_30259 = (state_30265[(2)]);
var state_30265__$1 = state_30265;
var statearr_30298_33176 = state_30265__$1;
(statearr_30298_33176[(2)] = inst_30259);

(statearr_30298_33176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (10))){
var state_30265__$1 = state_30265;
var statearr_30301_33179 = state_30265__$1;
(statearr_30301_33179[(2)] = fc);

(statearr_30301_33179[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30266 === (8))){
var inst_30241 = (state_30265[(2)]);
var state_30265__$1 = state_30265;
if(cljs.core.truth_(inst_30241)){
var statearr_30304_33180 = state_30265__$1;
(statearr_30304_33180[(1)] = (12));

} else {
var statearr_30305_33181 = state_30265__$1;
(statearr_30305_33181[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_30306 = [null,null,null,null,null,null,null,null,null];
(statearr_30306[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_30306[(1)] = (1));

return statearr_30306;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_30265){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_30265);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e30308){var ex__28981__auto__ = e30308;
var statearr_30309_33182 = state_30265;
(statearr_30309_33182[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_30265[(4)]))){
var statearr_30310_33183 = state_30265;
(statearr_30310_33183[(1)] = cljs.core.first((state_30265[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33188 = state_30265;
state_30265 = G__33188;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_30265){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_30265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_30319 = f__29282__auto__();
(statearr_30319[(6)] = c__29281__auto___33157);

return statearr_30319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29281__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_30355){
var state_val_30356 = (state_30355[(1)]);
if((state_val_30356 === (7))){
var inst_30349 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
var statearr_30358_33196 = state_30355__$1;
(statearr_30358_33196[(2)] = inst_30349);

(statearr_30358_33196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (1))){
var inst_30325 = init;
var inst_30326 = inst_30325;
var state_30355__$1 = (function (){var statearr_30360 = state_30355;
(statearr_30360[(7)] = inst_30326);

return statearr_30360;
})();
var statearr_30361_33197 = state_30355__$1;
(statearr_30361_33197[(2)] = null);

(statearr_30361_33197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (4))){
var inst_30330 = (state_30355[(8)]);
var inst_30330__$1 = (state_30355[(2)]);
var inst_30331 = (inst_30330__$1 == null);
var state_30355__$1 = (function (){var statearr_30363 = state_30355;
(statearr_30363[(8)] = inst_30330__$1);

return statearr_30363;
})();
if(cljs.core.truth_(inst_30331)){
var statearr_30364_33205 = state_30355__$1;
(statearr_30364_33205[(1)] = (5));

} else {
var statearr_30369_33206 = state_30355__$1;
(statearr_30369_33206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (6))){
var inst_30326 = (state_30355[(7)]);
var inst_30337 = (state_30355[(9)]);
var inst_30330 = (state_30355[(8)]);
var inst_30337__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30326,inst_30330) : f.call(null,inst_30326,inst_30330));
var inst_30338 = cljs.core.reduced_QMARK_(inst_30337__$1);
var state_30355__$1 = (function (){var statearr_30374 = state_30355;
(statearr_30374[(9)] = inst_30337__$1);

return statearr_30374;
})();
if(inst_30338){
var statearr_30376_33212 = state_30355__$1;
(statearr_30376_33212[(1)] = (8));

} else {
var statearr_30377_33213 = state_30355__$1;
(statearr_30377_33213[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (3))){
var inst_30351 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30355__$1,inst_30351);
} else {
if((state_val_30356 === (2))){
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30355__$1,(4),ch);
} else {
if((state_val_30356 === (9))){
var inst_30337 = (state_30355[(9)]);
var inst_30326 = inst_30337;
var state_30355__$1 = (function (){var statearr_30381 = state_30355;
(statearr_30381[(7)] = inst_30326);

return statearr_30381;
})();
var statearr_30384_33216 = state_30355__$1;
(statearr_30384_33216[(2)] = null);

(statearr_30384_33216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (5))){
var inst_30326 = (state_30355[(7)]);
var state_30355__$1 = state_30355;
var statearr_30385_33220 = state_30355__$1;
(statearr_30385_33220[(2)] = inst_30326);

(statearr_30385_33220[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (10))){
var inst_30347 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
var statearr_30387_33221 = state_30355__$1;
(statearr_30387_33221[(2)] = inst_30347);

(statearr_30387_33221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (8))){
var inst_30337 = (state_30355[(9)]);
var inst_30343 = cljs.core.deref(inst_30337);
var state_30355__$1 = state_30355;
var statearr_30389_33222 = state_30355__$1;
(statearr_30389_33222[(2)] = inst_30343);

(statearr_30389_33222[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28978__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28978__auto____0 = (function (){
var statearr_30393 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30393[(0)] = cljs$core$async$reduce_$_state_machine__28978__auto__);

(statearr_30393[(1)] = (1));

return statearr_30393;
});
var cljs$core$async$reduce_$_state_machine__28978__auto____1 = (function (state_30355){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_30355);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e30396){var ex__28981__auto__ = e30396;
var statearr_30397_33235 = state_30355;
(statearr_30397_33235[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_30355[(4)]))){
var statearr_30398_33236 = state_30355;
(statearr_30398_33236[(1)] = cljs.core.first((state_30355[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33237 = state_30355;
state_30355 = G__33237;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28978__auto__ = function(state_30355){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28978__auto____1.call(this,state_30355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28978__auto____0;
cljs$core$async$reduce_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28978__auto____1;
return cljs$core$async$reduce_$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_30399 = f__29282__auto__();
(statearr_30399[(6)] = c__29281__auto__);

return statearr_30399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

return c__29281__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__29281__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_30414){
var state_val_30415 = (state_30414[(1)]);
if((state_val_30415 === (1))){
var inst_30409 = cljs.core.async.reduce(f__$1,init,ch);
var state_30414__$1 = state_30414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30414__$1,(2),inst_30409);
} else {
if((state_val_30415 === (2))){
var inst_30411 = (state_30414[(2)]);
var inst_30412 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_30411) : f__$1.call(null,inst_30411));
var state_30414__$1 = state_30414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30414__$1,inst_30412);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28978__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28978__auto____0 = (function (){
var statearr_30426 = [null,null,null,null,null,null,null];
(statearr_30426[(0)] = cljs$core$async$transduce_$_state_machine__28978__auto__);

(statearr_30426[(1)] = (1));

return statearr_30426;
});
var cljs$core$async$transduce_$_state_machine__28978__auto____1 = (function (state_30414){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_30414);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e30429){var ex__28981__auto__ = e30429;
var statearr_30430_33258 = state_30414;
(statearr_30430_33258[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_30414[(4)]))){
var statearr_30431_33262 = state_30414;
(statearr_30431_33262[(1)] = cljs.core.first((state_30414[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33265 = state_30414;
state_30414 = G__33265;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28978__auto__ = function(state_30414){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28978__auto____1.call(this,state_30414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28978__auto____0;
cljs$core$async$transduce_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28978__auto____1;
return cljs$core$async$transduce_$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_30439 = f__29282__auto__();
(statearr_30439[(6)] = c__29281__auto__);

return statearr_30439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

return c__29281__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__30441 = arguments.length;
switch (G__30441) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29281__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_30468){
var state_val_30469 = (state_30468[(1)]);
if((state_val_30469 === (7))){
var inst_30449 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30475_33273 = state_30468__$1;
(statearr_30475_33273[(2)] = inst_30449);

(statearr_30475_33273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (1))){
var inst_30442 = cljs.core.seq(coll);
var inst_30443 = inst_30442;
var state_30468__$1 = (function (){var statearr_30477 = state_30468;
(statearr_30477[(7)] = inst_30443);

return statearr_30477;
})();
var statearr_30478_33274 = state_30468__$1;
(statearr_30478_33274[(2)] = null);

(statearr_30478_33274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (4))){
var inst_30443 = (state_30468[(7)]);
var inst_30447 = cljs.core.first(inst_30443);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30468__$1,(7),ch,inst_30447);
} else {
if((state_val_30469 === (13))){
var inst_30461 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30480_33278 = state_30468__$1;
(statearr_30480_33278[(2)] = inst_30461);

(statearr_30480_33278[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (6))){
var inst_30452 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
if(cljs.core.truth_(inst_30452)){
var statearr_30482_33279 = state_30468__$1;
(statearr_30482_33279[(1)] = (8));

} else {
var statearr_30486_33280 = state_30468__$1;
(statearr_30486_33280[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (3))){
var inst_30465 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30468__$1,inst_30465);
} else {
if((state_val_30469 === (12))){
var state_30468__$1 = state_30468;
var statearr_30492_33284 = state_30468__$1;
(statearr_30492_33284[(2)] = null);

(statearr_30492_33284[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (2))){
var inst_30443 = (state_30468[(7)]);
var state_30468__$1 = state_30468;
if(cljs.core.truth_(inst_30443)){
var statearr_30495_33285 = state_30468__$1;
(statearr_30495_33285[(1)] = (4));

} else {
var statearr_30496_33286 = state_30468__$1;
(statearr_30496_33286[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (11))){
var inst_30458 = cljs.core.async.close_BANG_(ch);
var state_30468__$1 = state_30468;
var statearr_30499_33289 = state_30468__$1;
(statearr_30499_33289[(2)] = inst_30458);

(statearr_30499_33289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (9))){
var state_30468__$1 = state_30468;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30503_33290 = state_30468__$1;
(statearr_30503_33290[(1)] = (11));

} else {
var statearr_30504_33291 = state_30468__$1;
(statearr_30504_33291[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (5))){
var inst_30443 = (state_30468[(7)]);
var state_30468__$1 = state_30468;
var statearr_30508_33292 = state_30468__$1;
(statearr_30508_33292[(2)] = inst_30443);

(statearr_30508_33292[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (10))){
var inst_30463 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30509_33293 = state_30468__$1;
(statearr_30509_33293[(2)] = inst_30463);

(statearr_30509_33293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (8))){
var inst_30443 = (state_30468[(7)]);
var inst_30454 = cljs.core.next(inst_30443);
var inst_30443__$1 = inst_30454;
var state_30468__$1 = (function (){var statearr_30510 = state_30468;
(statearr_30510[(7)] = inst_30443__$1);

return statearr_30510;
})();
var statearr_30513_33294 = state_30468__$1;
(statearr_30513_33294[(2)] = null);

(statearr_30513_33294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_30514 = [null,null,null,null,null,null,null,null];
(statearr_30514[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_30514[(1)] = (1));

return statearr_30514;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_30468){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_30468);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e30519){var ex__28981__auto__ = e30519;
var statearr_30520_33296 = state_30468;
(statearr_30520_33296[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_30468[(4)]))){
var statearr_30521_33297 = state_30468;
(statearr_30521_33297[(1)] = cljs.core.first((state_30468[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33299 = state_30468;
state_30468 = G__33299;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_30468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_30468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_30523 = f__29282__auto__();
(statearr_30523[(6)] = c__29281__auto__);

return statearr_30523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

return c__29281__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__30531 = arguments.length;
switch (G__30531) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33302 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33302(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33303 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33303(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33305 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33305(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33308 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33308(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30598 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30598 = (function (ch,cs,meta30599){
this.ch = ch;
this.cs = cs;
this.meta30599 = meta30599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30600,meta30599__$1){
var self__ = this;
var _30600__$1 = this;
return (new cljs.core.async.t_cljs$core$async30598(self__.ch,self__.cs,meta30599__$1));
}));

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30600){
var self__ = this;
var _30600__$1 = this;
return self__.meta30599;
}));

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async30598.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async30598.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30599","meta30599",-1515161282,null)], null);
}));

(cljs.core.async.t_cljs$core$async30598.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30598.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30598");

(cljs.core.async.t_cljs$core$async30598.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async30598");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30598.
 */
cljs.core.async.__GT_t_cljs$core$async30598 = (function cljs$core$async$mult_$___GT_t_cljs$core$async30598(ch__$1,cs__$1,meta30599){
return (new cljs.core.async.t_cljs$core$async30598(ch__$1,cs__$1,meta30599));
});

}

return (new cljs.core.async.t_cljs$core$async30598(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__29281__auto___33326 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_30769){
var state_val_30770 = (state_30769[(1)]);
if((state_val_30770 === (7))){
var inst_30765 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30776_33331 = state_30769__$1;
(statearr_30776_33331[(2)] = inst_30765);

(statearr_30776_33331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (20))){
var inst_30655 = (state_30769[(7)]);
var inst_30669 = cljs.core.first(inst_30655);
var inst_30670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30669,(0),null);
var inst_30671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30669,(1),null);
var state_30769__$1 = (function (){var statearr_30779 = state_30769;
(statearr_30779[(8)] = inst_30670);

return statearr_30779;
})();
if(cljs.core.truth_(inst_30671)){
var statearr_30780_33333 = state_30769__$1;
(statearr_30780_33333[(1)] = (22));

} else {
var statearr_30781_33337 = state_30769__$1;
(statearr_30781_33337[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (27))){
var inst_30619 = (state_30769[(9)]);
var inst_30703 = (state_30769[(10)]);
var inst_30713 = (state_30769[(11)]);
var inst_30701 = (state_30769[(12)]);
var inst_30713__$1 = cljs.core._nth(inst_30701,inst_30703);
var inst_30714 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30713__$1,inst_30619,done);
var state_30769__$1 = (function (){var statearr_30782 = state_30769;
(statearr_30782[(11)] = inst_30713__$1);

return statearr_30782;
})();
if(cljs.core.truth_(inst_30714)){
var statearr_30783_33340 = state_30769__$1;
(statearr_30783_33340[(1)] = (30));

} else {
var statearr_30784_33341 = state_30769__$1;
(statearr_30784_33341[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (1))){
var state_30769__$1 = state_30769;
var statearr_30785_33347 = state_30769__$1;
(statearr_30785_33347[(2)] = null);

(statearr_30785_33347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (24))){
var inst_30655 = (state_30769[(7)]);
var inst_30676 = (state_30769[(2)]);
var inst_30677 = cljs.core.next(inst_30655);
var inst_30629 = inst_30677;
var inst_30630 = null;
var inst_30631 = (0);
var inst_30632 = (0);
var state_30769__$1 = (function (){var statearr_30788 = state_30769;
(statearr_30788[(13)] = inst_30632);

(statearr_30788[(14)] = inst_30630);

(statearr_30788[(15)] = inst_30676);

(statearr_30788[(16)] = inst_30629);

(statearr_30788[(17)] = inst_30631);

return statearr_30788;
})();
var statearr_30789_33374 = state_30769__$1;
(statearr_30789_33374[(2)] = null);

(statearr_30789_33374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (39))){
var state_30769__$1 = state_30769;
var statearr_30793_33375 = state_30769__$1;
(statearr_30793_33375[(2)] = null);

(statearr_30793_33375[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (4))){
var inst_30619 = (state_30769[(9)]);
var inst_30619__$1 = (state_30769[(2)]);
var inst_30620 = (inst_30619__$1 == null);
var state_30769__$1 = (function (){var statearr_30797 = state_30769;
(statearr_30797[(9)] = inst_30619__$1);

return statearr_30797;
})();
if(cljs.core.truth_(inst_30620)){
var statearr_30800_33377 = state_30769__$1;
(statearr_30800_33377[(1)] = (5));

} else {
var statearr_30801_33378 = state_30769__$1;
(statearr_30801_33378[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (15))){
var inst_30632 = (state_30769[(13)]);
var inst_30630 = (state_30769[(14)]);
var inst_30629 = (state_30769[(16)]);
var inst_30631 = (state_30769[(17)]);
var inst_30651 = (state_30769[(2)]);
var inst_30652 = (inst_30632 + (1));
var tmp30790 = inst_30630;
var tmp30791 = inst_30629;
var tmp30792 = inst_30631;
var inst_30629__$1 = tmp30791;
var inst_30630__$1 = tmp30790;
var inst_30631__$1 = tmp30792;
var inst_30632__$1 = inst_30652;
var state_30769__$1 = (function (){var statearr_30806 = state_30769;
(statearr_30806[(13)] = inst_30632__$1);

(statearr_30806[(18)] = inst_30651);

(statearr_30806[(14)] = inst_30630__$1);

(statearr_30806[(16)] = inst_30629__$1);

(statearr_30806[(17)] = inst_30631__$1);

return statearr_30806;
})();
var statearr_30807_33384 = state_30769__$1;
(statearr_30807_33384[(2)] = null);

(statearr_30807_33384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (21))){
var inst_30680 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30812_33390 = state_30769__$1;
(statearr_30812_33390[(2)] = inst_30680);

(statearr_30812_33390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (31))){
var inst_30713 = (state_30769[(11)]);
var inst_30718 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30713);
var state_30769__$1 = state_30769;
var statearr_30813_33391 = state_30769__$1;
(statearr_30813_33391[(2)] = inst_30718);

(statearr_30813_33391[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (32))){
var inst_30700 = (state_30769[(19)]);
var inst_30702 = (state_30769[(20)]);
var inst_30703 = (state_30769[(10)]);
var inst_30701 = (state_30769[(12)]);
var inst_30720 = (state_30769[(2)]);
var inst_30722 = (inst_30703 + (1));
var tmp30808 = inst_30700;
var tmp30809 = inst_30702;
var tmp30810 = inst_30701;
var inst_30700__$1 = tmp30808;
var inst_30701__$1 = tmp30810;
var inst_30702__$1 = tmp30809;
var inst_30703__$1 = inst_30722;
var state_30769__$1 = (function (){var statearr_30817 = state_30769;
(statearr_30817[(19)] = inst_30700__$1);

(statearr_30817[(20)] = inst_30702__$1);

(statearr_30817[(10)] = inst_30703__$1);

(statearr_30817[(21)] = inst_30720);

(statearr_30817[(12)] = inst_30701__$1);

return statearr_30817;
})();
var statearr_30818_33393 = state_30769__$1;
(statearr_30818_33393[(2)] = null);

(statearr_30818_33393[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (40))){
var inst_30734 = (state_30769[(22)]);
var inst_30742 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30734);
var state_30769__$1 = state_30769;
var statearr_30823_33394 = state_30769__$1;
(statearr_30823_33394[(2)] = inst_30742);

(statearr_30823_33394[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (33))){
var inst_30725 = (state_30769[(23)]);
var inst_30727 = cljs.core.chunked_seq_QMARK_(inst_30725);
var state_30769__$1 = state_30769;
if(inst_30727){
var statearr_30830_33399 = state_30769__$1;
(statearr_30830_33399[(1)] = (36));

} else {
var statearr_30831_33403 = state_30769__$1;
(statearr_30831_33403[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (13))){
var inst_30645 = (state_30769[(24)]);
var inst_30648 = cljs.core.async.close_BANG_(inst_30645);
var state_30769__$1 = state_30769;
var statearr_30832_33406 = state_30769__$1;
(statearr_30832_33406[(2)] = inst_30648);

(statearr_30832_33406[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (22))){
var inst_30670 = (state_30769[(8)]);
var inst_30673 = cljs.core.async.close_BANG_(inst_30670);
var state_30769__$1 = state_30769;
var statearr_30833_33408 = state_30769__$1;
(statearr_30833_33408[(2)] = inst_30673);

(statearr_30833_33408[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (36))){
var inst_30725 = (state_30769[(23)]);
var inst_30729 = cljs.core.chunk_first(inst_30725);
var inst_30730 = cljs.core.chunk_rest(inst_30725);
var inst_30731 = cljs.core.count(inst_30729);
var inst_30700 = inst_30730;
var inst_30701 = inst_30729;
var inst_30702 = inst_30731;
var inst_30703 = (0);
var state_30769__$1 = (function (){var statearr_30834 = state_30769;
(statearr_30834[(19)] = inst_30700);

(statearr_30834[(20)] = inst_30702);

(statearr_30834[(10)] = inst_30703);

(statearr_30834[(12)] = inst_30701);

return statearr_30834;
})();
var statearr_30835_33414 = state_30769__$1;
(statearr_30835_33414[(2)] = null);

(statearr_30835_33414[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (41))){
var inst_30725 = (state_30769[(23)]);
var inst_30744 = (state_30769[(2)]);
var inst_30745 = cljs.core.next(inst_30725);
var inst_30700 = inst_30745;
var inst_30701 = null;
var inst_30702 = (0);
var inst_30703 = (0);
var state_30769__$1 = (function (){var statearr_30836 = state_30769;
(statearr_30836[(19)] = inst_30700);

(statearr_30836[(20)] = inst_30702);

(statearr_30836[(25)] = inst_30744);

(statearr_30836[(10)] = inst_30703);

(statearr_30836[(12)] = inst_30701);

return statearr_30836;
})();
var statearr_30838_33417 = state_30769__$1;
(statearr_30838_33417[(2)] = null);

(statearr_30838_33417[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (43))){
var state_30769__$1 = state_30769;
var statearr_30840_33420 = state_30769__$1;
(statearr_30840_33420[(2)] = null);

(statearr_30840_33420[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (29))){
var inst_30753 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30841_33424 = state_30769__$1;
(statearr_30841_33424[(2)] = inst_30753);

(statearr_30841_33424[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (44))){
var inst_30762 = (state_30769[(2)]);
var state_30769__$1 = (function (){var statearr_30845 = state_30769;
(statearr_30845[(26)] = inst_30762);

return statearr_30845;
})();
var statearr_30846_33430 = state_30769__$1;
(statearr_30846_33430[(2)] = null);

(statearr_30846_33430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (6))){
var inst_30691 = (state_30769[(27)]);
var inst_30690 = cljs.core.deref(cs);
var inst_30691__$1 = cljs.core.keys(inst_30690);
var inst_30693 = cljs.core.count(inst_30691__$1);
var inst_30694 = cljs.core.reset_BANG_(dctr,inst_30693);
var inst_30699 = cljs.core.seq(inst_30691__$1);
var inst_30700 = inst_30699;
var inst_30701 = null;
var inst_30702 = (0);
var inst_30703 = (0);
var state_30769__$1 = (function (){var statearr_30847 = state_30769;
(statearr_30847[(28)] = inst_30694);

(statearr_30847[(19)] = inst_30700);

(statearr_30847[(27)] = inst_30691__$1);

(statearr_30847[(20)] = inst_30702);

(statearr_30847[(10)] = inst_30703);

(statearr_30847[(12)] = inst_30701);

return statearr_30847;
})();
var statearr_30848_33444 = state_30769__$1;
(statearr_30848_33444[(2)] = null);

(statearr_30848_33444[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (28))){
var inst_30700 = (state_30769[(19)]);
var inst_30725 = (state_30769[(23)]);
var inst_30725__$1 = cljs.core.seq(inst_30700);
var state_30769__$1 = (function (){var statearr_30850 = state_30769;
(statearr_30850[(23)] = inst_30725__$1);

return statearr_30850;
})();
if(inst_30725__$1){
var statearr_30851_33445 = state_30769__$1;
(statearr_30851_33445[(1)] = (33));

} else {
var statearr_30853_33446 = state_30769__$1;
(statearr_30853_33446[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (25))){
var inst_30702 = (state_30769[(20)]);
var inst_30703 = (state_30769[(10)]);
var inst_30706 = (inst_30703 < inst_30702);
var inst_30707 = inst_30706;
var state_30769__$1 = state_30769;
if(cljs.core.truth_(inst_30707)){
var statearr_30855_33447 = state_30769__$1;
(statearr_30855_33447[(1)] = (27));

} else {
var statearr_30856_33448 = state_30769__$1;
(statearr_30856_33448[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (34))){
var state_30769__$1 = state_30769;
var statearr_30857_33449 = state_30769__$1;
(statearr_30857_33449[(2)] = null);

(statearr_30857_33449[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (17))){
var state_30769__$1 = state_30769;
var statearr_30858_33450 = state_30769__$1;
(statearr_30858_33450[(2)] = null);

(statearr_30858_33450[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (3))){
var inst_30767 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30769__$1,inst_30767);
} else {
if((state_val_30770 === (12))){
var inst_30685 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30859_33451 = state_30769__$1;
(statearr_30859_33451[(2)] = inst_30685);

(statearr_30859_33451[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (2))){
var state_30769__$1 = state_30769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30769__$1,(4),ch);
} else {
if((state_val_30770 === (23))){
var state_30769__$1 = state_30769;
var statearr_30863_33452 = state_30769__$1;
(statearr_30863_33452[(2)] = null);

(statearr_30863_33452[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (35))){
var inst_30751 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30867_33453 = state_30769__$1;
(statearr_30867_33453[(2)] = inst_30751);

(statearr_30867_33453[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (19))){
var inst_30655 = (state_30769[(7)]);
var inst_30660 = cljs.core.chunk_first(inst_30655);
var inst_30661 = cljs.core.chunk_rest(inst_30655);
var inst_30663 = cljs.core.count(inst_30660);
var inst_30629 = inst_30661;
var inst_30630 = inst_30660;
var inst_30631 = inst_30663;
var inst_30632 = (0);
var state_30769__$1 = (function (){var statearr_30871 = state_30769;
(statearr_30871[(13)] = inst_30632);

(statearr_30871[(14)] = inst_30630);

(statearr_30871[(16)] = inst_30629);

(statearr_30871[(17)] = inst_30631);

return statearr_30871;
})();
var statearr_30872_33457 = state_30769__$1;
(statearr_30872_33457[(2)] = null);

(statearr_30872_33457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (11))){
var inst_30629 = (state_30769[(16)]);
var inst_30655 = (state_30769[(7)]);
var inst_30655__$1 = cljs.core.seq(inst_30629);
var state_30769__$1 = (function (){var statearr_30876 = state_30769;
(statearr_30876[(7)] = inst_30655__$1);

return statearr_30876;
})();
if(inst_30655__$1){
var statearr_30877_33468 = state_30769__$1;
(statearr_30877_33468[(1)] = (16));

} else {
var statearr_30880_33469 = state_30769__$1;
(statearr_30880_33469[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (9))){
var inst_30687 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30881_33476 = state_30769__$1;
(statearr_30881_33476[(2)] = inst_30687);

(statearr_30881_33476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (5))){
var inst_30627 = cljs.core.deref(cs);
var inst_30628 = cljs.core.seq(inst_30627);
var inst_30629 = inst_30628;
var inst_30630 = null;
var inst_30631 = (0);
var inst_30632 = (0);
var state_30769__$1 = (function (){var statearr_30882 = state_30769;
(statearr_30882[(13)] = inst_30632);

(statearr_30882[(14)] = inst_30630);

(statearr_30882[(16)] = inst_30629);

(statearr_30882[(17)] = inst_30631);

return statearr_30882;
})();
var statearr_30883_33490 = state_30769__$1;
(statearr_30883_33490[(2)] = null);

(statearr_30883_33490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (14))){
var state_30769__$1 = state_30769;
var statearr_30884_33491 = state_30769__$1;
(statearr_30884_33491[(2)] = null);

(statearr_30884_33491[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (45))){
var inst_30759 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30888_33492 = state_30769__$1;
(statearr_30888_33492[(2)] = inst_30759);

(statearr_30888_33492[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (26))){
var inst_30691 = (state_30769[(27)]);
var inst_30755 = (state_30769[(2)]);
var inst_30756 = cljs.core.seq(inst_30691);
var state_30769__$1 = (function (){var statearr_30892 = state_30769;
(statearr_30892[(29)] = inst_30755);

return statearr_30892;
})();
if(inst_30756){
var statearr_30893_33498 = state_30769__$1;
(statearr_30893_33498[(1)] = (42));

} else {
var statearr_30894_33503 = state_30769__$1;
(statearr_30894_33503[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (16))){
var inst_30655 = (state_30769[(7)]);
var inst_30658 = cljs.core.chunked_seq_QMARK_(inst_30655);
var state_30769__$1 = state_30769;
if(inst_30658){
var statearr_30895_33507 = state_30769__$1;
(statearr_30895_33507[(1)] = (19));

} else {
var statearr_30897_33508 = state_30769__$1;
(statearr_30897_33508[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (38))){
var inst_30748 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30898_33513 = state_30769__$1;
(statearr_30898_33513[(2)] = inst_30748);

(statearr_30898_33513[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (30))){
var state_30769__$1 = state_30769;
var statearr_30899_33521 = state_30769__$1;
(statearr_30899_33521[(2)] = null);

(statearr_30899_33521[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (10))){
var inst_30632 = (state_30769[(13)]);
var inst_30630 = (state_30769[(14)]);
var inst_30644 = cljs.core._nth(inst_30630,inst_30632);
var inst_30645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30644,(0),null);
var inst_30646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30644,(1),null);
var state_30769__$1 = (function (){var statearr_30902 = state_30769;
(statearr_30902[(24)] = inst_30645);

return statearr_30902;
})();
if(cljs.core.truth_(inst_30646)){
var statearr_30903_33529 = state_30769__$1;
(statearr_30903_33529[(1)] = (13));

} else {
var statearr_30904_33530 = state_30769__$1;
(statearr_30904_33530[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (18))){
var inst_30683 = (state_30769[(2)]);
var state_30769__$1 = state_30769;
var statearr_30910_33531 = state_30769__$1;
(statearr_30910_33531[(2)] = inst_30683);

(statearr_30910_33531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (42))){
var state_30769__$1 = state_30769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30769__$1,(45),dchan);
} else {
if((state_val_30770 === (37))){
var inst_30619 = (state_30769[(9)]);
var inst_30734 = (state_30769[(22)]);
var inst_30725 = (state_30769[(23)]);
var inst_30734__$1 = cljs.core.first(inst_30725);
var inst_30735 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30734__$1,inst_30619,done);
var state_30769__$1 = (function (){var statearr_30914 = state_30769;
(statearr_30914[(22)] = inst_30734__$1);

return statearr_30914;
})();
if(cljs.core.truth_(inst_30735)){
var statearr_30915_33537 = state_30769__$1;
(statearr_30915_33537[(1)] = (39));

} else {
var statearr_30916_33538 = state_30769__$1;
(statearr_30916_33538[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30770 === (8))){
var inst_30632 = (state_30769[(13)]);
var inst_30631 = (state_30769[(17)]);
var inst_30636 = (inst_30632 < inst_30631);
var inst_30637 = inst_30636;
var state_30769__$1 = state_30769;
if(cljs.core.truth_(inst_30637)){
var statearr_30917_33549 = state_30769__$1;
(statearr_30917_33549[(1)] = (10));

} else {
var statearr_30918_33550 = state_30769__$1;
(statearr_30918_33550[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28978__auto__ = null;
var cljs$core$async$mult_$_state_machine__28978__auto____0 = (function (){
var statearr_30922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30922[(0)] = cljs$core$async$mult_$_state_machine__28978__auto__);

(statearr_30922[(1)] = (1));

return statearr_30922;
});
var cljs$core$async$mult_$_state_machine__28978__auto____1 = (function (state_30769){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_30769);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e30927){var ex__28981__auto__ = e30927;
var statearr_30928_33564 = state_30769;
(statearr_30928_33564[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_30769[(4)]))){
var statearr_30929_33568 = state_30769;
(statearr_30929_33568[(1)] = cljs.core.first((state_30769[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33569 = state_30769;
state_30769 = G__33569;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28978__auto__ = function(state_30769){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28978__auto____1.call(this,state_30769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28978__auto____0;
cljs$core$async$mult_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28978__auto____1;
return cljs$core$async$mult_$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_30934 = f__29282__auto__();
(statearr_30934[(6)] = c__29281__auto___33326);

return statearr_30934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__30936 = arguments.length;
switch (G__30936) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_33573 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_33573(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_33575 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_33575(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_33576 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_33576(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_33587 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_33587(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_33592 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_33592(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___33605 = arguments.length;
var i__4865__auto___33606 = (0);
while(true){
if((i__4865__auto___33606 < len__4864__auto___33605)){
args__4870__auto__.push((arguments[i__4865__auto___33606]));

var G__33607 = (i__4865__auto___33606 + (1));
i__4865__auto___33606 = G__33607;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30994){
var map__30995 = p__30994;
var map__30995__$1 = cljs.core.__destructure_map(map__30995);
var opts = map__30995__$1;
var statearr_30997_33608 = state;
(statearr_30997_33608[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_30998_33609 = state;
(statearr_30998_33609[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_30999_33611 = state;
(statearr_30999_33611[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30988){
var G__30989 = cljs.core.first(seq30988);
var seq30988__$1 = cljs.core.next(seq30988);
var G__30990 = cljs.core.first(seq30988__$1);
var seq30988__$2 = cljs.core.next(seq30988__$1);
var G__30991 = cljs.core.first(seq30988__$2);
var seq30988__$3 = cljs.core.next(seq30988__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30989,G__30990,G__30991,seq30988__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31006 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31006 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31007){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31007 = meta31007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31008,meta31007__$1){
var self__ = this;
var _31008__$1 = this;
return (new cljs.core.async.t_cljs$core$async31006(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31007__$1));
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31008){
var self__ = this;
var _31008__$1 = this;
return self__.meta31007;
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31006.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31007","meta31007",-1833576629,null)], null);
}));

(cljs.core.async.t_cljs$core$async31006.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31006.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31006");

(cljs.core.async.t_cljs$core$async31006.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31006");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31006.
 */
cljs.core.async.__GT_t_cljs$core$async31006 = (function cljs$core$async$mix_$___GT_t_cljs$core$async31006(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31007){
return (new cljs.core.async.t_cljs$core$async31006(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31007));
});

}

return (new cljs.core.async.t_cljs$core$async31006(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29281__auto___33629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_31100){
var state_val_31101 = (state_31100[(1)]);
if((state_val_31101 === (7))){
var inst_31060 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
if(cljs.core.truth_(inst_31060)){
var statearr_31104_33630 = state_31100__$1;
(statearr_31104_33630[(1)] = (8));

} else {
var statearr_31106_33634 = state_31100__$1;
(statearr_31106_33634[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (20))){
var inst_31053 = (state_31100[(7)]);
var state_31100__$1 = state_31100;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31100__$1,(23),out,inst_31053);
} else {
if((state_val_31101 === (1))){
var inst_31036 = calc_state();
var inst_31037 = cljs.core.__destructure_map(inst_31036);
var inst_31038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31037,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31037,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31037,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31041 = inst_31036;
var state_31100__$1 = (function (){var statearr_31113 = state_31100;
(statearr_31113[(8)] = inst_31038);

(statearr_31113[(9)] = inst_31039);

(statearr_31113[(10)] = inst_31040);

(statearr_31113[(11)] = inst_31041);

return statearr_31113;
})();
var statearr_31114_33638 = state_31100__$1;
(statearr_31114_33638[(2)] = null);

(statearr_31114_33638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (24))){
var inst_31044 = (state_31100[(12)]);
var inst_31041 = inst_31044;
var state_31100__$1 = (function (){var statearr_31116 = state_31100;
(statearr_31116[(11)] = inst_31041);

return statearr_31116;
})();
var statearr_31117_33646 = state_31100__$1;
(statearr_31117_33646[(2)] = null);

(statearr_31117_33646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (4))){
var inst_31053 = (state_31100[(7)]);
var inst_31055 = (state_31100[(13)]);
var inst_31052 = (state_31100[(2)]);
var inst_31053__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31052,(0),null);
var inst_31054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31052,(1),null);
var inst_31055__$1 = (inst_31053__$1 == null);
var state_31100__$1 = (function (){var statearr_31121 = state_31100;
(statearr_31121[(7)] = inst_31053__$1);

(statearr_31121[(13)] = inst_31055__$1);

(statearr_31121[(14)] = inst_31054);

return statearr_31121;
})();
if(cljs.core.truth_(inst_31055__$1)){
var statearr_31122_33651 = state_31100__$1;
(statearr_31122_33651[(1)] = (5));

} else {
var statearr_31123_33652 = state_31100__$1;
(statearr_31123_33652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (15))){
var inst_31045 = (state_31100[(15)]);
var inst_31074 = (state_31100[(16)]);
var inst_31074__$1 = cljs.core.empty_QMARK_(inst_31045);
var state_31100__$1 = (function (){var statearr_31130 = state_31100;
(statearr_31130[(16)] = inst_31074__$1);

return statearr_31130;
})();
if(inst_31074__$1){
var statearr_31131_33660 = state_31100__$1;
(statearr_31131_33660[(1)] = (17));

} else {
var statearr_31132_33670 = state_31100__$1;
(statearr_31132_33670[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (21))){
var inst_31044 = (state_31100[(12)]);
var inst_31041 = inst_31044;
var state_31100__$1 = (function (){var statearr_31133 = state_31100;
(statearr_31133[(11)] = inst_31041);

return statearr_31133;
})();
var statearr_31134_33671 = state_31100__$1;
(statearr_31134_33671[(2)] = null);

(statearr_31134_33671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (13))){
var inst_31067 = (state_31100[(2)]);
var inst_31068 = calc_state();
var inst_31041 = inst_31068;
var state_31100__$1 = (function (){var statearr_31135 = state_31100;
(statearr_31135[(11)] = inst_31041);

(statearr_31135[(17)] = inst_31067);

return statearr_31135;
})();
var statearr_31136_33675 = state_31100__$1;
(statearr_31136_33675[(2)] = null);

(statearr_31136_33675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (22))){
var inst_31094 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31139_33676 = state_31100__$1;
(statearr_31139_33676[(2)] = inst_31094);

(statearr_31139_33676[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (6))){
var inst_31054 = (state_31100[(14)]);
var inst_31058 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31054,change);
var state_31100__$1 = state_31100;
var statearr_31140_33684 = state_31100__$1;
(statearr_31140_33684[(2)] = inst_31058);

(statearr_31140_33684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (25))){
var state_31100__$1 = state_31100;
var statearr_31141_33685 = state_31100__$1;
(statearr_31141_33685[(2)] = null);

(statearr_31141_33685[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (17))){
var inst_31046 = (state_31100[(18)]);
var inst_31054 = (state_31100[(14)]);
var inst_31076 = (inst_31046.cljs$core$IFn$_invoke$arity$1 ? inst_31046.cljs$core$IFn$_invoke$arity$1(inst_31054) : inst_31046.call(null,inst_31054));
var inst_31077 = cljs.core.not(inst_31076);
var state_31100__$1 = state_31100;
var statearr_31144_33690 = state_31100__$1;
(statearr_31144_33690[(2)] = inst_31077);

(statearr_31144_33690[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (3))){
var inst_31098 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31100__$1,inst_31098);
} else {
if((state_val_31101 === (12))){
var state_31100__$1 = state_31100;
var statearr_31145_33691 = state_31100__$1;
(statearr_31145_33691[(2)] = null);

(statearr_31145_33691[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (2))){
var inst_31044 = (state_31100[(12)]);
var inst_31041 = (state_31100[(11)]);
var inst_31044__$1 = cljs.core.__destructure_map(inst_31041);
var inst_31045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31044__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31044__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31044__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31100__$1 = (function (){var statearr_31150 = state_31100;
(statearr_31150[(18)] = inst_31046);

(statearr_31150[(12)] = inst_31044__$1);

(statearr_31150[(15)] = inst_31045);

return statearr_31150;
})();
return cljs.core.async.ioc_alts_BANG_(state_31100__$1,(4),inst_31047);
} else {
if((state_val_31101 === (23))){
var inst_31085 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
if(cljs.core.truth_(inst_31085)){
var statearr_31151_33695 = state_31100__$1;
(statearr_31151_33695[(1)] = (24));

} else {
var statearr_31153_33696 = state_31100__$1;
(statearr_31153_33696[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (19))){
var inst_31080 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31154_33697 = state_31100__$1;
(statearr_31154_33697[(2)] = inst_31080);

(statearr_31154_33697[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (11))){
var inst_31054 = (state_31100[(14)]);
var inst_31064 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31054);
var state_31100__$1 = state_31100;
var statearr_31156_33698 = state_31100__$1;
(statearr_31156_33698[(2)] = inst_31064);

(statearr_31156_33698[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (9))){
var inst_31045 = (state_31100[(15)]);
var inst_31071 = (state_31100[(19)]);
var inst_31054 = (state_31100[(14)]);
var inst_31071__$1 = (inst_31045.cljs$core$IFn$_invoke$arity$1 ? inst_31045.cljs$core$IFn$_invoke$arity$1(inst_31054) : inst_31045.call(null,inst_31054));
var state_31100__$1 = (function (){var statearr_31157 = state_31100;
(statearr_31157[(19)] = inst_31071__$1);

return statearr_31157;
})();
if(cljs.core.truth_(inst_31071__$1)){
var statearr_31158_33699 = state_31100__$1;
(statearr_31158_33699[(1)] = (14));

} else {
var statearr_31159_33700 = state_31100__$1;
(statearr_31159_33700[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (5))){
var inst_31055 = (state_31100[(13)]);
var state_31100__$1 = state_31100;
var statearr_31160_33701 = state_31100__$1;
(statearr_31160_33701[(2)] = inst_31055);

(statearr_31160_33701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (14))){
var inst_31071 = (state_31100[(19)]);
var state_31100__$1 = state_31100;
var statearr_31161_33702 = state_31100__$1;
(statearr_31161_33702[(2)] = inst_31071);

(statearr_31161_33702[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (26))){
var inst_31090 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31162_33703 = state_31100__$1;
(statearr_31162_33703[(2)] = inst_31090);

(statearr_31162_33703[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (16))){
var inst_31082 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
if(cljs.core.truth_(inst_31082)){
var statearr_31167_33704 = state_31100__$1;
(statearr_31167_33704[(1)] = (20));

} else {
var statearr_31168_33706 = state_31100__$1;
(statearr_31168_33706[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (10))){
var inst_31096 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31170_33707 = state_31100__$1;
(statearr_31170_33707[(2)] = inst_31096);

(statearr_31170_33707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (18))){
var inst_31074 = (state_31100[(16)]);
var state_31100__$1 = state_31100;
var statearr_31173_33709 = state_31100__$1;
(statearr_31173_33709[(2)] = inst_31074);

(statearr_31173_33709[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (8))){
var inst_31053 = (state_31100[(7)]);
var inst_31062 = (inst_31053 == null);
var state_31100__$1 = state_31100;
if(cljs.core.truth_(inst_31062)){
var statearr_31174_33710 = state_31100__$1;
(statearr_31174_33710[(1)] = (11));

} else {
var statearr_31175_33711 = state_31100__$1;
(statearr_31175_33711[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28978__auto__ = null;
var cljs$core$async$mix_$_state_machine__28978__auto____0 = (function (){
var statearr_31176 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31176[(0)] = cljs$core$async$mix_$_state_machine__28978__auto__);

(statearr_31176[(1)] = (1));

return statearr_31176;
});
var cljs$core$async$mix_$_state_machine__28978__auto____1 = (function (state_31100){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_31100);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e31177){var ex__28981__auto__ = e31177;
var statearr_31178_33712 = state_31100;
(statearr_31178_33712[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_31100[(4)]))){
var statearr_31179_33713 = state_31100;
(statearr_31179_33713[(1)] = cljs.core.first((state_31100[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33714 = state_31100;
state_31100 = G__33714;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28978__auto__ = function(state_31100){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28978__auto____1.call(this,state_31100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28978__auto____0;
cljs$core$async$mix_$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28978__auto____1;
return cljs$core$async$mix_$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_31184 = f__29282__auto__();
(statearr_31184[(6)] = c__29281__auto___33629);

return statearr_31184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_33715 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_33715(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_33716 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_33716(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_33718 = (function() {
var G__33719 = null;
var G__33719__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__33719__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__33719 = function(p,v){
switch(arguments.length){
case 1:
return G__33719__1.call(this,p);
case 2:
return G__33719__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33719.cljs$core$IFn$_invoke$arity$1 = G__33719__1;
G__33719.cljs$core$IFn$_invoke$arity$2 = G__33719__2;
return G__33719;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31204 = arguments.length;
switch (G__31204) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33718(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33718(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31214 = arguments.length;
switch (G__31214) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__31209_SHARP_){
if(cljs.core.truth_((p1__31209_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31209_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31209_SHARP_.call(null,topic)))){
return p1__31209_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31209_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31219 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31219 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31220){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31220 = meta31220;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31221,meta31220__$1){
var self__ = this;
var _31221__$1 = this;
return (new cljs.core.async.t_cljs$core$async31219(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31220__$1));
}));

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31221){
var self__ = this;
var _31221__$1 = this;
return self__.meta31220;
}));

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async31219.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async31219.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31220","meta31220",-881100511,null)], null);
}));

(cljs.core.async.t_cljs$core$async31219.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31219.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31219");

(cljs.core.async.t_cljs$core$async31219.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31219");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31219.
 */
cljs.core.async.__GT_t_cljs$core$async31219 = (function cljs$core$async$__GT_t_cljs$core$async31219(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31220){
return (new cljs.core.async.t_cljs$core$async31219(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31220));
});

}

return (new cljs.core.async.t_cljs$core$async31219(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29281__auto___33734 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_31321){
var state_val_31322 = (state_31321[(1)]);
if((state_val_31322 === (7))){
var inst_31314 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31333_33746 = state_31321__$1;
(statearr_31333_33746[(2)] = inst_31314);

(statearr_31333_33746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (20))){
var state_31321__$1 = state_31321;
var statearr_31334_33747 = state_31321__$1;
(statearr_31334_33747[(2)] = null);

(statearr_31334_33747[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (1))){
var state_31321__$1 = state_31321;
var statearr_31335_33748 = state_31321__$1;
(statearr_31335_33748[(2)] = null);

(statearr_31335_33748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (24))){
var inst_31294 = (state_31321[(7)]);
var inst_31305 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31294);
var state_31321__$1 = state_31321;
var statearr_31336_33750 = state_31321__$1;
(statearr_31336_33750[(2)] = inst_31305);

(statearr_31336_33750[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (4))){
var inst_31238 = (state_31321[(8)]);
var inst_31238__$1 = (state_31321[(2)]);
var inst_31239 = (inst_31238__$1 == null);
var state_31321__$1 = (function (){var statearr_31338 = state_31321;
(statearr_31338[(8)] = inst_31238__$1);

return statearr_31338;
})();
if(cljs.core.truth_(inst_31239)){
var statearr_31339_33751 = state_31321__$1;
(statearr_31339_33751[(1)] = (5));

} else {
var statearr_31342_33752 = state_31321__$1;
(statearr_31342_33752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (15))){
var inst_31288 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31344_33753 = state_31321__$1;
(statearr_31344_33753[(2)] = inst_31288);

(statearr_31344_33753[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (21))){
var inst_31310 = (state_31321[(2)]);
var state_31321__$1 = (function (){var statearr_31346 = state_31321;
(statearr_31346[(9)] = inst_31310);

return statearr_31346;
})();
var statearr_31347_33754 = state_31321__$1;
(statearr_31347_33754[(2)] = null);

(statearr_31347_33754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (13))){
var inst_31269 = (state_31321[(10)]);
var inst_31271 = cljs.core.chunked_seq_QMARK_(inst_31269);
var state_31321__$1 = state_31321;
if(inst_31271){
var statearr_31351_33760 = state_31321__$1;
(statearr_31351_33760[(1)] = (16));

} else {
var statearr_31353_33761 = state_31321__$1;
(statearr_31353_33761[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (22))){
var inst_31302 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
if(cljs.core.truth_(inst_31302)){
var statearr_31355_33762 = state_31321__$1;
(statearr_31355_33762[(1)] = (23));

} else {
var statearr_31358_33763 = state_31321__$1;
(statearr_31358_33763[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (6))){
var inst_31294 = (state_31321[(7)]);
var inst_31296 = (state_31321[(11)]);
var inst_31238 = (state_31321[(8)]);
var inst_31294__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31238) : topic_fn.call(null,inst_31238));
var inst_31295 = cljs.core.deref(mults);
var inst_31296__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31295,inst_31294__$1);
var state_31321__$1 = (function (){var statearr_31364 = state_31321;
(statearr_31364[(7)] = inst_31294__$1);

(statearr_31364[(11)] = inst_31296__$1);

return statearr_31364;
})();
if(cljs.core.truth_(inst_31296__$1)){
var statearr_31374_33764 = state_31321__$1;
(statearr_31374_33764[(1)] = (19));

} else {
var statearr_31375_33765 = state_31321__$1;
(statearr_31375_33765[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (25))){
var inst_31307 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31378_33766 = state_31321__$1;
(statearr_31378_33766[(2)] = inst_31307);

(statearr_31378_33766[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (17))){
var inst_31269 = (state_31321[(10)]);
var inst_31279 = cljs.core.first(inst_31269);
var inst_31280 = cljs.core.async.muxch_STAR_(inst_31279);
var inst_31281 = cljs.core.async.close_BANG_(inst_31280);
var inst_31282 = cljs.core.next(inst_31269);
var inst_31252 = inst_31282;
var inst_31253 = null;
var inst_31254 = (0);
var inst_31255 = (0);
var state_31321__$1 = (function (){var statearr_31383 = state_31321;
(statearr_31383[(12)] = inst_31255);

(statearr_31383[(13)] = inst_31281);

(statearr_31383[(14)] = inst_31254);

(statearr_31383[(15)] = inst_31253);

(statearr_31383[(16)] = inst_31252);

return statearr_31383;
})();
var statearr_31389_33767 = state_31321__$1;
(statearr_31389_33767[(2)] = null);

(statearr_31389_33767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (3))){
var inst_31316 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31321__$1,inst_31316);
} else {
if((state_val_31322 === (12))){
var inst_31290 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31395_33768 = state_31321__$1;
(statearr_31395_33768[(2)] = inst_31290);

(statearr_31395_33768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (2))){
var state_31321__$1 = state_31321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31321__$1,(4),ch);
} else {
if((state_val_31322 === (23))){
var state_31321__$1 = state_31321;
var statearr_31397_33769 = state_31321__$1;
(statearr_31397_33769[(2)] = null);

(statearr_31397_33769[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (19))){
var inst_31296 = (state_31321[(11)]);
var inst_31238 = (state_31321[(8)]);
var inst_31300 = cljs.core.async.muxch_STAR_(inst_31296);
var state_31321__$1 = state_31321;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31321__$1,(22),inst_31300,inst_31238);
} else {
if((state_val_31322 === (11))){
var inst_31269 = (state_31321[(10)]);
var inst_31252 = (state_31321[(16)]);
var inst_31269__$1 = cljs.core.seq(inst_31252);
var state_31321__$1 = (function (){var statearr_31402 = state_31321;
(statearr_31402[(10)] = inst_31269__$1);

return statearr_31402;
})();
if(inst_31269__$1){
var statearr_31403_33773 = state_31321__$1;
(statearr_31403_33773[(1)] = (13));

} else {
var statearr_31404_33778 = state_31321__$1;
(statearr_31404_33778[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (9))){
var inst_31292 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31406_33779 = state_31321__$1;
(statearr_31406_33779[(2)] = inst_31292);

(statearr_31406_33779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (5))){
var inst_31245 = cljs.core.deref(mults);
var inst_31246 = cljs.core.vals(inst_31245);
var inst_31247 = cljs.core.seq(inst_31246);
var inst_31252 = inst_31247;
var inst_31253 = null;
var inst_31254 = (0);
var inst_31255 = (0);
var state_31321__$1 = (function (){var statearr_31410 = state_31321;
(statearr_31410[(12)] = inst_31255);

(statearr_31410[(14)] = inst_31254);

(statearr_31410[(15)] = inst_31253);

(statearr_31410[(16)] = inst_31252);

return statearr_31410;
})();
var statearr_31411_33783 = state_31321__$1;
(statearr_31411_33783[(2)] = null);

(statearr_31411_33783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (14))){
var state_31321__$1 = state_31321;
var statearr_31416_33784 = state_31321__$1;
(statearr_31416_33784[(2)] = null);

(statearr_31416_33784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (16))){
var inst_31269 = (state_31321[(10)]);
var inst_31274 = cljs.core.chunk_first(inst_31269);
var inst_31275 = cljs.core.chunk_rest(inst_31269);
var inst_31276 = cljs.core.count(inst_31274);
var inst_31252 = inst_31275;
var inst_31253 = inst_31274;
var inst_31254 = inst_31276;
var inst_31255 = (0);
var state_31321__$1 = (function (){var statearr_31420 = state_31321;
(statearr_31420[(12)] = inst_31255);

(statearr_31420[(14)] = inst_31254);

(statearr_31420[(15)] = inst_31253);

(statearr_31420[(16)] = inst_31252);

return statearr_31420;
})();
var statearr_31422_33789 = state_31321__$1;
(statearr_31422_33789[(2)] = null);

(statearr_31422_33789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (10))){
var inst_31255 = (state_31321[(12)]);
var inst_31254 = (state_31321[(14)]);
var inst_31253 = (state_31321[(15)]);
var inst_31252 = (state_31321[(16)]);
var inst_31260 = cljs.core._nth(inst_31253,inst_31255);
var inst_31261 = cljs.core.async.muxch_STAR_(inst_31260);
var inst_31262 = cljs.core.async.close_BANG_(inst_31261);
var inst_31265 = (inst_31255 + (1));
var tmp31413 = inst_31254;
var tmp31414 = inst_31253;
var tmp31415 = inst_31252;
var inst_31252__$1 = tmp31415;
var inst_31253__$1 = tmp31414;
var inst_31254__$1 = tmp31413;
var inst_31255__$1 = inst_31265;
var state_31321__$1 = (function (){var statearr_31425 = state_31321;
(statearr_31425[(12)] = inst_31255__$1);

(statearr_31425[(14)] = inst_31254__$1);

(statearr_31425[(17)] = inst_31262);

(statearr_31425[(15)] = inst_31253__$1);

(statearr_31425[(16)] = inst_31252__$1);

return statearr_31425;
})();
var statearr_31428_33795 = state_31321__$1;
(statearr_31428_33795[(2)] = null);

(statearr_31428_33795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (18))){
var inst_31285 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31429_33796 = state_31321__$1;
(statearr_31429_33796[(2)] = inst_31285);

(statearr_31429_33796[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31322 === (8))){
var inst_31255 = (state_31321[(12)]);
var inst_31254 = (state_31321[(14)]);
var inst_31257 = (inst_31255 < inst_31254);
var inst_31258 = inst_31257;
var state_31321__$1 = state_31321;
if(cljs.core.truth_(inst_31258)){
var statearr_31432_33800 = state_31321__$1;
(statearr_31432_33800[(1)] = (10));

} else {
var statearr_31434_33801 = state_31321__$1;
(statearr_31434_33801[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_31440 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31440[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_31440[(1)] = (1));

return statearr_31440;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_31321){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_31321);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e31441){var ex__28981__auto__ = e31441;
var statearr_31442_33807 = state_31321;
(statearr_31442_33807[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_31321[(4)]))){
var statearr_31445_33808 = state_31321;
(statearr_31445_33808[(1)] = cljs.core.first((state_31321[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33810 = state_31321;
state_31321 = G__33810;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_31321){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_31321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_31448 = f__29282__auto__();
(statearr_31448[(6)] = c__29281__auto___33734);

return statearr_31448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__31463 = arguments.length;
switch (G__31463) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__31479 = arguments.length;
switch (G__31479) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__31514 = arguments.length;
switch (G__31514) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__29281__auto___33821 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_31589){
var state_val_31590 = (state_31589[(1)]);
if((state_val_31590 === (7))){
var state_31589__$1 = state_31589;
var statearr_31598_33829 = state_31589__$1;
(statearr_31598_33829[(2)] = null);

(statearr_31598_33829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (1))){
var state_31589__$1 = state_31589;
var statearr_31603_33830 = state_31589__$1;
(statearr_31603_33830[(2)] = null);

(statearr_31603_33830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (4))){
var inst_31535 = (state_31589[(7)]);
var inst_31536 = (state_31589[(8)]);
var inst_31539 = (inst_31536 < inst_31535);
var state_31589__$1 = state_31589;
if(cljs.core.truth_(inst_31539)){
var statearr_31610_33832 = state_31589__$1;
(statearr_31610_33832[(1)] = (6));

} else {
var statearr_31611_33833 = state_31589__$1;
(statearr_31611_33833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (15))){
var inst_31572 = (state_31589[(9)]);
var inst_31577 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31572);
var state_31589__$1 = state_31589;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31589__$1,(17),out,inst_31577);
} else {
if((state_val_31590 === (13))){
var inst_31572 = (state_31589[(9)]);
var inst_31572__$1 = (state_31589[(2)]);
var inst_31573 = cljs.core.some(cljs.core.nil_QMARK_,inst_31572__$1);
var state_31589__$1 = (function (){var statearr_31615 = state_31589;
(statearr_31615[(9)] = inst_31572__$1);

return statearr_31615;
})();
if(cljs.core.truth_(inst_31573)){
var statearr_31616_33835 = state_31589__$1;
(statearr_31616_33835[(1)] = (14));

} else {
var statearr_31619_33836 = state_31589__$1;
(statearr_31619_33836[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (6))){
var state_31589__$1 = state_31589;
var statearr_31625_33838 = state_31589__$1;
(statearr_31625_33838[(2)] = null);

(statearr_31625_33838[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (17))){
var inst_31579 = (state_31589[(2)]);
var state_31589__$1 = (function (){var statearr_31649 = state_31589;
(statearr_31649[(10)] = inst_31579);

return statearr_31649;
})();
var statearr_31651_33839 = state_31589__$1;
(statearr_31651_33839[(2)] = null);

(statearr_31651_33839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (3))){
var inst_31585 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31589__$1,inst_31585);
} else {
if((state_val_31590 === (12))){
var _ = (function (){var statearr_31655 = state_31589;
(statearr_31655[(4)] = cljs.core.rest((state_31589[(4)])));

return statearr_31655;
})();
var state_31589__$1 = state_31589;
var ex31642 = (state_31589__$1[(2)]);
var statearr_31658_33850 = state_31589__$1;
(statearr_31658_33850[(5)] = ex31642);


if((ex31642 instanceof Object)){
var statearr_31662_33851 = state_31589__$1;
(statearr_31662_33851[(1)] = (11));

(statearr_31662_33851[(5)] = null);

} else {
throw ex31642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (2))){
var inst_31534 = cljs.core.reset_BANG_(dctr,cnt);
var inst_31535 = cnt;
var inst_31536 = (0);
var state_31589__$1 = (function (){var statearr_31673 = state_31589;
(statearr_31673[(7)] = inst_31535);

(statearr_31673[(11)] = inst_31534);

(statearr_31673[(8)] = inst_31536);

return statearr_31673;
})();
var statearr_31674_33852 = state_31589__$1;
(statearr_31674_33852[(2)] = null);

(statearr_31674_33852[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (11))){
var inst_31550 = (state_31589[(2)]);
var inst_31551 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31589__$1 = (function (){var statearr_31677 = state_31589;
(statearr_31677[(12)] = inst_31550);

return statearr_31677;
})();
var statearr_31681_33853 = state_31589__$1;
(statearr_31681_33853[(2)] = inst_31551);

(statearr_31681_33853[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (9))){
var inst_31536 = (state_31589[(8)]);
var _ = (function (){var statearr_31683 = state_31589;
(statearr_31683[(4)] = cljs.core.cons((12),(state_31589[(4)])));

return statearr_31683;
})();
var inst_31558 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31536) : chs__$1.call(null,inst_31536));
var inst_31559 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31536) : done.call(null,inst_31536));
var inst_31560 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31558,inst_31559);
var ___$1 = (function (){var statearr_31686 = state_31589;
(statearr_31686[(4)] = cljs.core.rest((state_31589[(4)])));

return statearr_31686;
})();
var state_31589__$1 = state_31589;
var statearr_31688_33858 = state_31589__$1;
(statearr_31688_33858[(2)] = inst_31560);

(statearr_31688_33858[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (5))){
var inst_31570 = (state_31589[(2)]);
var state_31589__$1 = (function (){var statearr_31692 = state_31589;
(statearr_31692[(13)] = inst_31570);

return statearr_31692;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31589__$1,(13),dchan);
} else {
if((state_val_31590 === (14))){
var inst_31575 = cljs.core.async.close_BANG_(out);
var state_31589__$1 = state_31589;
var statearr_31696_33866 = state_31589__$1;
(statearr_31696_33866[(2)] = inst_31575);

(statearr_31696_33866[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (16))){
var inst_31583 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31704_33869 = state_31589__$1;
(statearr_31704_33869[(2)] = inst_31583);

(statearr_31704_33869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (10))){
var inst_31536 = (state_31589[(8)]);
var inst_31563 = (state_31589[(2)]);
var inst_31564 = (inst_31536 + (1));
var inst_31536__$1 = inst_31564;
var state_31589__$1 = (function (){var statearr_31706 = state_31589;
(statearr_31706[(14)] = inst_31563);

(statearr_31706[(8)] = inst_31536__$1);

return statearr_31706;
})();
var statearr_31707_33872 = state_31589__$1;
(statearr_31707_33872[(2)] = null);

(statearr_31707_33872[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (8))){
var inst_31568 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31711_33873 = state_31589__$1;
(statearr_31711_33873[(2)] = inst_31568);

(statearr_31711_33873[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_31714 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31714[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_31714[(1)] = (1));

return statearr_31714;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_31589){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_31589);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e31716){var ex__28981__auto__ = e31716;
var statearr_31719_33876 = state_31589;
(statearr_31719_33876[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_31589[(4)]))){
var statearr_31720_33877 = state_31589;
(statearr_31720_33877[(1)] = cljs.core.first((state_31589[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33878 = state_31589;
state_31589 = G__33878;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_31589){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_31589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_31730 = f__29282__auto__();
(statearr_31730[(6)] = c__29281__auto___33821);

return statearr_31730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__31740 = arguments.length;
switch (G__31740) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29281__auto___33882 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_31785){
var state_val_31786 = (state_31785[(1)]);
if((state_val_31786 === (7))){
var inst_31760 = (state_31785[(7)]);
var inst_31762 = (state_31785[(8)]);
var inst_31760__$1 = (state_31785[(2)]);
var inst_31762__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31760__$1,(0),null);
var inst_31764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31760__$1,(1),null);
var inst_31765 = (inst_31762__$1 == null);
var state_31785__$1 = (function (){var statearr_31792 = state_31785;
(statearr_31792[(7)] = inst_31760__$1);

(statearr_31792[(9)] = inst_31764);

(statearr_31792[(8)] = inst_31762__$1);

return statearr_31792;
})();
if(cljs.core.truth_(inst_31765)){
var statearr_31797_33889 = state_31785__$1;
(statearr_31797_33889[(1)] = (8));

} else {
var statearr_31799_33890 = state_31785__$1;
(statearr_31799_33890[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (1))){
var inst_31750 = cljs.core.vec(chs);
var inst_31751 = inst_31750;
var state_31785__$1 = (function (){var statearr_31801 = state_31785;
(statearr_31801[(10)] = inst_31751);

return statearr_31801;
})();
var statearr_31802_33893 = state_31785__$1;
(statearr_31802_33893[(2)] = null);

(statearr_31802_33893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (4))){
var inst_31751 = (state_31785[(10)]);
var state_31785__$1 = state_31785;
return cljs.core.async.ioc_alts_BANG_(state_31785__$1,(7),inst_31751);
} else {
if((state_val_31786 === (6))){
var inst_31780 = (state_31785[(2)]);
var state_31785__$1 = state_31785;
var statearr_31806_33898 = state_31785__$1;
(statearr_31806_33898[(2)] = inst_31780);

(statearr_31806_33898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (3))){
var inst_31782 = (state_31785[(2)]);
var state_31785__$1 = state_31785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31785__$1,inst_31782);
} else {
if((state_val_31786 === (2))){
var inst_31751 = (state_31785[(10)]);
var inst_31753 = cljs.core.count(inst_31751);
var inst_31754 = (inst_31753 > (0));
var state_31785__$1 = state_31785;
if(cljs.core.truth_(inst_31754)){
var statearr_31810_33901 = state_31785__$1;
(statearr_31810_33901[(1)] = (4));

} else {
var statearr_31812_33902 = state_31785__$1;
(statearr_31812_33902[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (11))){
var inst_31751 = (state_31785[(10)]);
var inst_31773 = (state_31785[(2)]);
var tmp31808 = inst_31751;
var inst_31751__$1 = tmp31808;
var state_31785__$1 = (function (){var statearr_31815 = state_31785;
(statearr_31815[(11)] = inst_31773);

(statearr_31815[(10)] = inst_31751__$1);

return statearr_31815;
})();
var statearr_31816_33907 = state_31785__$1;
(statearr_31816_33907[(2)] = null);

(statearr_31816_33907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (9))){
var inst_31762 = (state_31785[(8)]);
var state_31785__$1 = state_31785;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31785__$1,(11),out,inst_31762);
} else {
if((state_val_31786 === (5))){
var inst_31778 = cljs.core.async.close_BANG_(out);
var state_31785__$1 = state_31785;
var statearr_31826_33921 = state_31785__$1;
(statearr_31826_33921[(2)] = inst_31778);

(statearr_31826_33921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (10))){
var inst_31776 = (state_31785[(2)]);
var state_31785__$1 = state_31785;
var statearr_31827_33931 = state_31785__$1;
(statearr_31827_33931[(2)] = inst_31776);

(statearr_31827_33931[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31786 === (8))){
var inst_31760 = (state_31785[(7)]);
var inst_31764 = (state_31785[(9)]);
var inst_31751 = (state_31785[(10)]);
var inst_31762 = (state_31785[(8)]);
var inst_31768 = (function (){var cs = inst_31751;
var vec__31756 = inst_31760;
var v = inst_31762;
var c = inst_31764;
return (function (p1__31733_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31733_SHARP_);
});
})();
var inst_31769 = cljs.core.filterv(inst_31768,inst_31751);
var inst_31751__$1 = inst_31769;
var state_31785__$1 = (function (){var statearr_31828 = state_31785;
(statearr_31828[(10)] = inst_31751__$1);

return statearr_31828;
})();
var statearr_31829_33946 = state_31785__$1;
(statearr_31829_33946[(2)] = null);

(statearr_31829_33946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_31830 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31830[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_31830[(1)] = (1));

return statearr_31830;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_31785){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_31785);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e31831){var ex__28981__auto__ = e31831;
var statearr_31832_33959 = state_31785;
(statearr_31832_33959[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_31785[(4)]))){
var statearr_31833_33964 = state_31785;
(statearr_31833_33964[(1)] = cljs.core.first((state_31785[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33965 = state_31785;
state_31785 = G__33965;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_31785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_31785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_31839 = f__29282__auto__();
(statearr_31839[(6)] = c__29281__auto___33882);

return statearr_31839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__31843 = arguments.length;
switch (G__31843) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29281__auto___33969 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_31870){
var state_val_31871 = (state_31870[(1)]);
if((state_val_31871 === (7))){
var inst_31849 = (state_31870[(7)]);
var inst_31849__$1 = (state_31870[(2)]);
var inst_31850 = (inst_31849__$1 == null);
var inst_31851 = cljs.core.not(inst_31850);
var state_31870__$1 = (function (){var statearr_31874 = state_31870;
(statearr_31874[(7)] = inst_31849__$1);

return statearr_31874;
})();
if(inst_31851){
var statearr_31875_33979 = state_31870__$1;
(statearr_31875_33979[(1)] = (8));

} else {
var statearr_31876_33980 = state_31870__$1;
(statearr_31876_33980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (1))){
var inst_31844 = (0);
var state_31870__$1 = (function (){var statearr_31877 = state_31870;
(statearr_31877[(8)] = inst_31844);

return statearr_31877;
})();
var statearr_31878_33981 = state_31870__$1;
(statearr_31878_33981[(2)] = null);

(statearr_31878_33981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (4))){
var state_31870__$1 = state_31870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31870__$1,(7),ch);
} else {
if((state_val_31871 === (6))){
var inst_31864 = (state_31870[(2)]);
var state_31870__$1 = state_31870;
var statearr_31885_33989 = state_31870__$1;
(statearr_31885_33989[(2)] = inst_31864);

(statearr_31885_33989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (3))){
var inst_31866 = (state_31870[(2)]);
var inst_31867 = cljs.core.async.close_BANG_(out);
var state_31870__$1 = (function (){var statearr_31888 = state_31870;
(statearr_31888[(9)] = inst_31866);

return statearr_31888;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31870__$1,inst_31867);
} else {
if((state_val_31871 === (2))){
var inst_31844 = (state_31870[(8)]);
var inst_31846 = (inst_31844 < n);
var state_31870__$1 = state_31870;
if(cljs.core.truth_(inst_31846)){
var statearr_31893_33990 = state_31870__$1;
(statearr_31893_33990[(1)] = (4));

} else {
var statearr_31894_33991 = state_31870__$1;
(statearr_31894_33991[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (11))){
var inst_31844 = (state_31870[(8)]);
var inst_31855 = (state_31870[(2)]);
var inst_31857 = (inst_31844 + (1));
var inst_31844__$1 = inst_31857;
var state_31870__$1 = (function (){var statearr_31895 = state_31870;
(statearr_31895[(10)] = inst_31855);

(statearr_31895[(8)] = inst_31844__$1);

return statearr_31895;
})();
var statearr_31896_33995 = state_31870__$1;
(statearr_31896_33995[(2)] = null);

(statearr_31896_33995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (9))){
var state_31870__$1 = state_31870;
var statearr_31904_33997 = state_31870__$1;
(statearr_31904_33997[(2)] = null);

(statearr_31904_33997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (5))){
var state_31870__$1 = state_31870;
var statearr_31905_34000 = state_31870__$1;
(statearr_31905_34000[(2)] = null);

(statearr_31905_34000[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (10))){
var inst_31861 = (state_31870[(2)]);
var state_31870__$1 = state_31870;
var statearr_31910_34004 = state_31870__$1;
(statearr_31910_34004[(2)] = inst_31861);

(statearr_31910_34004[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (8))){
var inst_31849 = (state_31870[(7)]);
var state_31870__$1 = state_31870;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31870__$1,(11),out,inst_31849);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_31915 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31915[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_31915[(1)] = (1));

return statearr_31915;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_31870){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_31870);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e31920){var ex__28981__auto__ = e31920;
var statearr_31921_34010 = state_31870;
(statearr_31921_34010[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_31870[(4)]))){
var statearr_31922_34011 = state_31870;
(statearr_31922_34011[(1)] = cljs.core.first((state_31870[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34012 = state_31870;
state_31870 = G__34012;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_31870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_31870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_31927 = f__29282__auto__();
(statearr_31927[(6)] = c__29281__auto___33969);

return statearr_31927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31940 = (function (f,ch,meta31941){
this.f = f;
this.ch = ch;
this.meta31941 = meta31941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31942,meta31941__$1){
var self__ = this;
var _31942__$1 = this;
return (new cljs.core.async.t_cljs$core$async31940(self__.f,self__.ch,meta31941__$1));
}));

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31942){
var self__ = this;
var _31942__$1 = this;
return self__.meta31941;
}));

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31959 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31959 = (function (f,ch,meta31941,_,fn1,meta31960){
this.f = f;
this.ch = ch;
this.meta31941 = meta31941;
this._ = _;
this.fn1 = fn1;
this.meta31960 = meta31960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31961,meta31960__$1){
var self__ = this;
var _31961__$1 = this;
return (new cljs.core.async.t_cljs$core$async31959(self__.f,self__.ch,self__.meta31941,self__._,self__.fn1,meta31960__$1));
}));

(cljs.core.async.t_cljs$core$async31959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31961){
var self__ = this;
var _31961__$1 = this;
return self__.meta31960;
}));

(cljs.core.async.t_cljs$core$async31959.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31959.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async31959.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31959.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__31935_SHARP_){
var G__31967 = (((p1__31935_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31935_SHARP_) : self__.f.call(null,p1__31935_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31967) : f1.call(null,G__31967));
});
}));

(cljs.core.async.t_cljs$core$async31959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31941","meta31941",938893104,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async31940","cljs.core.async/t_cljs$core$async31940",-317112432,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31960","meta31960",1323344699,null)], null);
}));

(cljs.core.async.t_cljs$core$async31959.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31959.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31959");

(cljs.core.async.t_cljs$core$async31959.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31959");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31959.
 */
cljs.core.async.__GT_t_cljs$core$async31959 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31959(f__$1,ch__$1,meta31941__$1,___$2,fn1__$1,meta31960){
return (new cljs.core.async.t_cljs$core$async31959(f__$1,ch__$1,meta31941__$1,___$2,fn1__$1,meta31960));
});

}

return (new cljs.core.async.t_cljs$core$async31959(self__.f,self__.ch,self__.meta31941,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31976 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31976) : self__.f.call(null,G__31976));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31940.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async31940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31941","meta31941",938893104,null)], null);
}));

(cljs.core.async.t_cljs$core$async31940.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31940");

(cljs.core.async.t_cljs$core$async31940.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31940");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31940.
 */
cljs.core.async.__GT_t_cljs$core$async31940 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31940(f__$1,ch__$1,meta31941){
return (new cljs.core.async.t_cljs$core$async31940(f__$1,ch__$1,meta31941));
});

}

return (new cljs.core.async.t_cljs$core$async31940(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31989 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31989 = (function (f,ch,meta31990){
this.f = f;
this.ch = ch;
this.meta31990 = meta31990;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31991,meta31990__$1){
var self__ = this;
var _31991__$1 = this;
return (new cljs.core.async.t_cljs$core$async31989(self__.f,self__.ch,meta31990__$1));
}));

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31991){
var self__ = this;
var _31991__$1 = this;
return self__.meta31990;
}));

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31989.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async31989.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31990","meta31990",463485120,null)], null);
}));

(cljs.core.async.t_cljs$core$async31989.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31989.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31989");

(cljs.core.async.t_cljs$core$async31989.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31989");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31989.
 */
cljs.core.async.__GT_t_cljs$core$async31989 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31989(f__$1,ch__$1,meta31990){
return (new cljs.core.async.t_cljs$core$async31989(f__$1,ch__$1,meta31990));
});

}

return (new cljs.core.async.t_cljs$core$async31989(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32008 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32008 = (function (p,ch,meta32009){
this.p = p;
this.ch = ch;
this.meta32009 = meta32009;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32010,meta32009__$1){
var self__ = this;
var _32010__$1 = this;
return (new cljs.core.async.t_cljs$core$async32008(self__.p,self__.ch,meta32009__$1));
}));

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32010){
var self__ = this;
var _32010__$1 = this;
return self__.meta32009;
}));

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32008.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32008.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32009","meta32009",-309219596,null)], null);
}));

(cljs.core.async.t_cljs$core$async32008.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32008.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32008");

(cljs.core.async.t_cljs$core$async32008.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async32008");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32008.
 */
cljs.core.async.__GT_t_cljs$core$async32008 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32008(p__$1,ch__$1,meta32009){
return (new cljs.core.async.t_cljs$core$async32008(p__$1,ch__$1,meta32009));
});

}

return (new cljs.core.async.t_cljs$core$async32008(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32053 = arguments.length;
switch (G__32053) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29281__auto___34077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_32102){
var state_val_32105 = (state_32102[(1)]);
if((state_val_32105 === (7))){
var inst_32092 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
var statearr_32116_34081 = state_32102__$1;
(statearr_32116_34081[(2)] = inst_32092);

(statearr_32116_34081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (1))){
var state_32102__$1 = state_32102;
var statearr_32120_34082 = state_32102__$1;
(statearr_32120_34082[(2)] = null);

(statearr_32120_34082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (4))){
var inst_32076 = (state_32102[(7)]);
var inst_32076__$1 = (state_32102[(2)]);
var inst_32078 = (inst_32076__$1 == null);
var state_32102__$1 = (function (){var statearr_32123 = state_32102;
(statearr_32123[(7)] = inst_32076__$1);

return statearr_32123;
})();
if(cljs.core.truth_(inst_32078)){
var statearr_32124_34083 = state_32102__$1;
(statearr_32124_34083[(1)] = (5));

} else {
var statearr_32125_34084 = state_32102__$1;
(statearr_32125_34084[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (6))){
var inst_32076 = (state_32102[(7)]);
var inst_32083 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32076) : p.call(null,inst_32076));
var state_32102__$1 = state_32102;
if(cljs.core.truth_(inst_32083)){
var statearr_32134_34085 = state_32102__$1;
(statearr_32134_34085[(1)] = (8));

} else {
var statearr_32135_34092 = state_32102__$1;
(statearr_32135_34092[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (3))){
var inst_32100 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32102__$1,inst_32100);
} else {
if((state_val_32105 === (2))){
var state_32102__$1 = state_32102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32102__$1,(4),ch);
} else {
if((state_val_32105 === (11))){
var inst_32086 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
var statearr_32141_34093 = state_32102__$1;
(statearr_32141_34093[(2)] = inst_32086);

(statearr_32141_34093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (9))){
var state_32102__$1 = state_32102;
var statearr_32149_34097 = state_32102__$1;
(statearr_32149_34097[(2)] = null);

(statearr_32149_34097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (5))){
var inst_32081 = cljs.core.async.close_BANG_(out);
var state_32102__$1 = state_32102;
var statearr_32152_34103 = state_32102__$1;
(statearr_32152_34103[(2)] = inst_32081);

(statearr_32152_34103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (10))){
var inst_32089 = (state_32102[(2)]);
var state_32102__$1 = (function (){var statearr_32153 = state_32102;
(statearr_32153[(8)] = inst_32089);

return statearr_32153;
})();
var statearr_32155_34109 = state_32102__$1;
(statearr_32155_34109[(2)] = null);

(statearr_32155_34109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32105 === (8))){
var inst_32076 = (state_32102[(7)]);
var state_32102__$1 = state_32102;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32102__$1,(11),out,inst_32076);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_32158 = [null,null,null,null,null,null,null,null,null];
(statearr_32158[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_32158[(1)] = (1));

return statearr_32158;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_32102){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_32102);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e32160){var ex__28981__auto__ = e32160;
var statearr_32161_34119 = state_32102;
(statearr_32161_34119[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_32102[(4)]))){
var statearr_32163_34121 = state_32102;
(statearr_32163_34121[(1)] = cljs.core.first((state_32102[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34123 = state_32102;
state_32102 = G__34123;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_32102){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_32102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_32167 = f__29282__auto__();
(statearr_32167[(6)] = c__29281__auto___34077);

return statearr_32167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32178 = arguments.length;
switch (G__32178) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29281__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_32258){
var state_val_32259 = (state_32258[(1)]);
if((state_val_32259 === (7))){
var inst_32251 = (state_32258[(2)]);
var state_32258__$1 = state_32258;
var statearr_32262_34145 = state_32258__$1;
(statearr_32262_34145[(2)] = inst_32251);

(statearr_32262_34145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (20))){
var inst_32217 = (state_32258[(7)]);
var inst_32231 = (state_32258[(2)]);
var inst_32233 = cljs.core.next(inst_32217);
var inst_32200 = inst_32233;
var inst_32201 = null;
var inst_32202 = (0);
var inst_32203 = (0);
var state_32258__$1 = (function (){var statearr_32265 = state_32258;
(statearr_32265[(8)] = inst_32201);

(statearr_32265[(9)] = inst_32202);

(statearr_32265[(10)] = inst_32200);

(statearr_32265[(11)] = inst_32203);

(statearr_32265[(12)] = inst_32231);

return statearr_32265;
})();
var statearr_32267_34150 = state_32258__$1;
(statearr_32267_34150[(2)] = null);

(statearr_32267_34150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (1))){
var state_32258__$1 = state_32258;
var statearr_32269_34151 = state_32258__$1;
(statearr_32269_34151[(2)] = null);

(statearr_32269_34151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (4))){
var inst_32187 = (state_32258[(13)]);
var inst_32187__$1 = (state_32258[(2)]);
var inst_32188 = (inst_32187__$1 == null);
var state_32258__$1 = (function (){var statearr_32274 = state_32258;
(statearr_32274[(13)] = inst_32187__$1);

return statearr_32274;
})();
if(cljs.core.truth_(inst_32188)){
var statearr_32276_34160 = state_32258__$1;
(statearr_32276_34160[(1)] = (5));

} else {
var statearr_32277_34161 = state_32258__$1;
(statearr_32277_34161[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (15))){
var state_32258__$1 = state_32258;
var statearr_32281_34171 = state_32258__$1;
(statearr_32281_34171[(2)] = null);

(statearr_32281_34171[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (21))){
var state_32258__$1 = state_32258;
var statearr_32282_34173 = state_32258__$1;
(statearr_32282_34173[(2)] = null);

(statearr_32282_34173[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (13))){
var inst_32201 = (state_32258[(8)]);
var inst_32202 = (state_32258[(9)]);
var inst_32200 = (state_32258[(10)]);
var inst_32203 = (state_32258[(11)]);
var inst_32213 = (state_32258[(2)]);
var inst_32214 = (inst_32203 + (1));
var tmp32278 = inst_32201;
var tmp32279 = inst_32202;
var tmp32280 = inst_32200;
var inst_32200__$1 = tmp32280;
var inst_32201__$1 = tmp32278;
var inst_32202__$1 = tmp32279;
var inst_32203__$1 = inst_32214;
var state_32258__$1 = (function (){var statearr_32288 = state_32258;
(statearr_32288[(8)] = inst_32201__$1);

(statearr_32288[(14)] = inst_32213);

(statearr_32288[(9)] = inst_32202__$1);

(statearr_32288[(10)] = inst_32200__$1);

(statearr_32288[(11)] = inst_32203__$1);

return statearr_32288;
})();
var statearr_32291_34180 = state_32258__$1;
(statearr_32291_34180[(2)] = null);

(statearr_32291_34180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (22))){
var state_32258__$1 = state_32258;
var statearr_32298_34183 = state_32258__$1;
(statearr_32298_34183[(2)] = null);

(statearr_32298_34183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (6))){
var inst_32187 = (state_32258[(13)]);
var inst_32198 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32187) : f.call(null,inst_32187));
var inst_32199 = cljs.core.seq(inst_32198);
var inst_32200 = inst_32199;
var inst_32201 = null;
var inst_32202 = (0);
var inst_32203 = (0);
var state_32258__$1 = (function (){var statearr_32300 = state_32258;
(statearr_32300[(8)] = inst_32201);

(statearr_32300[(9)] = inst_32202);

(statearr_32300[(10)] = inst_32200);

(statearr_32300[(11)] = inst_32203);

return statearr_32300;
})();
var statearr_32301_34186 = state_32258__$1;
(statearr_32301_34186[(2)] = null);

(statearr_32301_34186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (17))){
var inst_32217 = (state_32258[(7)]);
var inst_32221 = cljs.core.chunk_first(inst_32217);
var inst_32224 = cljs.core.chunk_rest(inst_32217);
var inst_32225 = cljs.core.count(inst_32221);
var inst_32200 = inst_32224;
var inst_32201 = inst_32221;
var inst_32202 = inst_32225;
var inst_32203 = (0);
var state_32258__$1 = (function (){var statearr_32302 = state_32258;
(statearr_32302[(8)] = inst_32201);

(statearr_32302[(9)] = inst_32202);

(statearr_32302[(10)] = inst_32200);

(statearr_32302[(11)] = inst_32203);

return statearr_32302;
})();
var statearr_32303_34188 = state_32258__$1;
(statearr_32303_34188[(2)] = null);

(statearr_32303_34188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (3))){
var inst_32253 = (state_32258[(2)]);
var state_32258__$1 = state_32258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32258__$1,inst_32253);
} else {
if((state_val_32259 === (12))){
var inst_32241 = (state_32258[(2)]);
var state_32258__$1 = state_32258;
var statearr_32310_34194 = state_32258__$1;
(statearr_32310_34194[(2)] = inst_32241);

(statearr_32310_34194[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (2))){
var state_32258__$1 = state_32258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32258__$1,(4),in$);
} else {
if((state_val_32259 === (23))){
var inst_32249 = (state_32258[(2)]);
var state_32258__$1 = state_32258;
var statearr_32313_34198 = state_32258__$1;
(statearr_32313_34198[(2)] = inst_32249);

(statearr_32313_34198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (19))){
var inst_32236 = (state_32258[(2)]);
var state_32258__$1 = state_32258;
var statearr_32314_34200 = state_32258__$1;
(statearr_32314_34200[(2)] = inst_32236);

(statearr_32314_34200[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (11))){
var inst_32217 = (state_32258[(7)]);
var inst_32200 = (state_32258[(10)]);
var inst_32217__$1 = cljs.core.seq(inst_32200);
var state_32258__$1 = (function (){var statearr_32315 = state_32258;
(statearr_32315[(7)] = inst_32217__$1);

return statearr_32315;
})();
if(inst_32217__$1){
var statearr_32316_34205 = state_32258__$1;
(statearr_32316_34205[(1)] = (14));

} else {
var statearr_32317_34206 = state_32258__$1;
(statearr_32317_34206[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (9))){
var inst_32243 = (state_32258[(2)]);
var inst_32244 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32258__$1 = (function (){var statearr_32319 = state_32258;
(statearr_32319[(15)] = inst_32243);

return statearr_32319;
})();
if(cljs.core.truth_(inst_32244)){
var statearr_32320_34208 = state_32258__$1;
(statearr_32320_34208[(1)] = (21));

} else {
var statearr_32321_34209 = state_32258__$1;
(statearr_32321_34209[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (5))){
var inst_32190 = cljs.core.async.close_BANG_(out);
var state_32258__$1 = state_32258;
var statearr_32324_34213 = state_32258__$1;
(statearr_32324_34213[(2)] = inst_32190);

(statearr_32324_34213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (14))){
var inst_32217 = (state_32258[(7)]);
var inst_32219 = cljs.core.chunked_seq_QMARK_(inst_32217);
var state_32258__$1 = state_32258;
if(inst_32219){
var statearr_32328_34217 = state_32258__$1;
(statearr_32328_34217[(1)] = (17));

} else {
var statearr_32329_34219 = state_32258__$1;
(statearr_32329_34219[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (16))){
var inst_32239 = (state_32258[(2)]);
var state_32258__$1 = state_32258;
var statearr_32332_34220 = state_32258__$1;
(statearr_32332_34220[(2)] = inst_32239);

(statearr_32332_34220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32259 === (10))){
var inst_32201 = (state_32258[(8)]);
var inst_32203 = (state_32258[(11)]);
var inst_32211 = cljs.core._nth(inst_32201,inst_32203);
var state_32258__$1 = state_32258;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32258__$1,(13),out,inst_32211);
} else {
if((state_val_32259 === (18))){
var inst_32217 = (state_32258[(7)]);
var inst_32229 = cljs.core.first(inst_32217);
var state_32258__$1 = state_32258;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32258__$1,(20),out,inst_32229);
} else {
if((state_val_32259 === (8))){
var inst_32202 = (state_32258[(9)]);
var inst_32203 = (state_32258[(11)]);
var inst_32207 = (inst_32203 < inst_32202);
var inst_32208 = inst_32207;
var state_32258__$1 = state_32258;
if(cljs.core.truth_(inst_32208)){
var statearr_32339_34230 = state_32258__$1;
(statearr_32339_34230[(1)] = (10));

} else {
var statearr_32341_34233 = state_32258__$1;
(statearr_32341_34233[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28978__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28978__auto____0 = (function (){
var statearr_32350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32350[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28978__auto__);

(statearr_32350[(1)] = (1));

return statearr_32350;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28978__auto____1 = (function (state_32258){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_32258);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e32351){var ex__28981__auto__ = e32351;
var statearr_32352_34244 = state_32258;
(statearr_32352_34244[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_32258[(4)]))){
var statearr_32354_34246 = state_32258;
(statearr_32354_34246[(1)] = cljs.core.first((state_32258[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34248 = state_32258;
state_32258 = G__34248;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28978__auto__ = function(state_32258){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28978__auto____1.call(this,state_32258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28978__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28978__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_32357 = f__29282__auto__();
(statearr_32357[(6)] = c__29281__auto__);

return statearr_32357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

return c__29281__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32367 = arguments.length;
switch (G__32367) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32386 = arguments.length;
switch (G__32386) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32399 = arguments.length;
switch (G__32399) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29281__auto___34263 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_32437){
var state_val_32438 = (state_32437[(1)]);
if((state_val_32438 === (7))){
var inst_32432 = (state_32437[(2)]);
var state_32437__$1 = state_32437;
var statearr_32454_34267 = state_32437__$1;
(statearr_32454_34267[(2)] = inst_32432);

(statearr_32454_34267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (1))){
var inst_32408 = null;
var state_32437__$1 = (function (){var statearr_32455 = state_32437;
(statearr_32455[(7)] = inst_32408);

return statearr_32455;
})();
var statearr_32464_34270 = state_32437__$1;
(statearr_32464_34270[(2)] = null);

(statearr_32464_34270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (4))){
var inst_32415 = (state_32437[(8)]);
var inst_32415__$1 = (state_32437[(2)]);
var inst_32417 = (inst_32415__$1 == null);
var inst_32418 = cljs.core.not(inst_32417);
var state_32437__$1 = (function (){var statearr_32465 = state_32437;
(statearr_32465[(8)] = inst_32415__$1);

return statearr_32465;
})();
if(inst_32418){
var statearr_32466_34275 = state_32437__$1;
(statearr_32466_34275[(1)] = (5));

} else {
var statearr_32467_34278 = state_32437__$1;
(statearr_32467_34278[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (6))){
var state_32437__$1 = state_32437;
var statearr_32468_34279 = state_32437__$1;
(statearr_32468_34279[(2)] = null);

(statearr_32468_34279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (3))){
var inst_32434 = (state_32437[(2)]);
var inst_32435 = cljs.core.async.close_BANG_(out);
var state_32437__$1 = (function (){var statearr_32469 = state_32437;
(statearr_32469[(9)] = inst_32434);

return statearr_32469;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32437__$1,inst_32435);
} else {
if((state_val_32438 === (2))){
var state_32437__$1 = state_32437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32437__$1,(4),ch);
} else {
if((state_val_32438 === (11))){
var inst_32415 = (state_32437[(8)]);
var inst_32426 = (state_32437[(2)]);
var inst_32408 = inst_32415;
var state_32437__$1 = (function (){var statearr_32470 = state_32437;
(statearr_32470[(10)] = inst_32426);

(statearr_32470[(7)] = inst_32408);

return statearr_32470;
})();
var statearr_32478_34286 = state_32437__$1;
(statearr_32478_34286[(2)] = null);

(statearr_32478_34286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (9))){
var inst_32415 = (state_32437[(8)]);
var state_32437__$1 = state_32437;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32437__$1,(11),out,inst_32415);
} else {
if((state_val_32438 === (5))){
var inst_32415 = (state_32437[(8)]);
var inst_32408 = (state_32437[(7)]);
var inst_32420 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32415,inst_32408);
var state_32437__$1 = state_32437;
if(inst_32420){
var statearr_32494_34296 = state_32437__$1;
(statearr_32494_34296[(1)] = (8));

} else {
var statearr_32495_34297 = state_32437__$1;
(statearr_32495_34297[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (10))){
var inst_32429 = (state_32437[(2)]);
var state_32437__$1 = state_32437;
var statearr_32496_34298 = state_32437__$1;
(statearr_32496_34298[(2)] = inst_32429);

(statearr_32496_34298[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32438 === (8))){
var inst_32408 = (state_32437[(7)]);
var tmp32486 = inst_32408;
var inst_32408__$1 = tmp32486;
var state_32437__$1 = (function (){var statearr_32497 = state_32437;
(statearr_32497[(7)] = inst_32408__$1);

return statearr_32497;
})();
var statearr_32498_34299 = state_32437__$1;
(statearr_32498_34299[(2)] = null);

(statearr_32498_34299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_32499 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32499[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_32499[(1)] = (1));

return statearr_32499;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_32437){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_32437);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e32500){var ex__28981__auto__ = e32500;
var statearr_32501_34307 = state_32437;
(statearr_32501_34307[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_32437[(4)]))){
var statearr_32505_34308 = state_32437;
(statearr_32505_34308[(1)] = cljs.core.first((state_32437[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34311 = state_32437;
state_32437 = G__34311;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_32437){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_32437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_32510 = f__29282__auto__();
(statearr_32510[(6)] = c__29281__auto___34263);

return statearr_32510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32519 = arguments.length;
switch (G__32519) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29281__auto___34317 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_32584){
var state_val_32585 = (state_32584[(1)]);
if((state_val_32585 === (7))){
var inst_32580 = (state_32584[(2)]);
var state_32584__$1 = state_32584;
var statearr_32587_34319 = state_32584__$1;
(statearr_32587_34319[(2)] = inst_32580);

(statearr_32587_34319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (1))){
var inst_32528 = (new Array(n));
var inst_32529 = inst_32528;
var inst_32530 = (0);
var state_32584__$1 = (function (){var statearr_32588 = state_32584;
(statearr_32588[(7)] = inst_32530);

(statearr_32588[(8)] = inst_32529);

return statearr_32588;
})();
var statearr_32589_34322 = state_32584__$1;
(statearr_32589_34322[(2)] = null);

(statearr_32589_34322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (4))){
var inst_32538 = (state_32584[(9)]);
var inst_32538__$1 = (state_32584[(2)]);
var inst_32539 = (inst_32538__$1 == null);
var inst_32540 = cljs.core.not(inst_32539);
var state_32584__$1 = (function (){var statearr_32594 = state_32584;
(statearr_32594[(9)] = inst_32538__$1);

return statearr_32594;
})();
if(inst_32540){
var statearr_32600_34327 = state_32584__$1;
(statearr_32600_34327[(1)] = (5));

} else {
var statearr_32601_34328 = state_32584__$1;
(statearr_32601_34328[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (15))){
var inst_32574 = (state_32584[(2)]);
var state_32584__$1 = state_32584;
var statearr_32606_34329 = state_32584__$1;
(statearr_32606_34329[(2)] = inst_32574);

(statearr_32606_34329[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (13))){
var state_32584__$1 = state_32584;
var statearr_32611_34333 = state_32584__$1;
(statearr_32611_34333[(2)] = null);

(statearr_32611_34333[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (6))){
var inst_32530 = (state_32584[(7)]);
var inst_32570 = (inst_32530 > (0));
var state_32584__$1 = state_32584;
if(cljs.core.truth_(inst_32570)){
var statearr_32613_34341 = state_32584__$1;
(statearr_32613_34341[(1)] = (12));

} else {
var statearr_32614_34342 = state_32584__$1;
(statearr_32614_34342[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (3))){
var inst_32582 = (state_32584[(2)]);
var state_32584__$1 = state_32584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32584__$1,inst_32582);
} else {
if((state_val_32585 === (12))){
var inst_32529 = (state_32584[(8)]);
var inst_32572 = cljs.core.vec(inst_32529);
var state_32584__$1 = state_32584;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32584__$1,(15),out,inst_32572);
} else {
if((state_val_32585 === (2))){
var state_32584__$1 = state_32584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32584__$1,(4),ch);
} else {
if((state_val_32585 === (11))){
var inst_32561 = (state_32584[(2)]);
var inst_32565 = (new Array(n));
var inst_32529 = inst_32565;
var inst_32530 = (0);
var state_32584__$1 = (function (){var statearr_32632 = state_32584;
(statearr_32632[(7)] = inst_32530);

(statearr_32632[(10)] = inst_32561);

(statearr_32632[(8)] = inst_32529);

return statearr_32632;
})();
var statearr_32634_34350 = state_32584__$1;
(statearr_32634_34350[(2)] = null);

(statearr_32634_34350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (9))){
var inst_32529 = (state_32584[(8)]);
var inst_32559 = cljs.core.vec(inst_32529);
var state_32584__$1 = state_32584;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32584__$1,(11),out,inst_32559);
} else {
if((state_val_32585 === (5))){
var inst_32551 = (state_32584[(11)]);
var inst_32530 = (state_32584[(7)]);
var inst_32538 = (state_32584[(9)]);
var inst_32529 = (state_32584[(8)]);
var inst_32546 = (inst_32529[inst_32530] = inst_32538);
var inst_32551__$1 = (inst_32530 + (1));
var inst_32553 = (inst_32551__$1 < n);
var state_32584__$1 = (function (){var statearr_32635 = state_32584;
(statearr_32635[(11)] = inst_32551__$1);

(statearr_32635[(12)] = inst_32546);

return statearr_32635;
})();
if(cljs.core.truth_(inst_32553)){
var statearr_32636_34359 = state_32584__$1;
(statearr_32636_34359[(1)] = (8));

} else {
var statearr_32637_34360 = state_32584__$1;
(statearr_32637_34360[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (14))){
var inst_32577 = (state_32584[(2)]);
var inst_32578 = cljs.core.async.close_BANG_(out);
var state_32584__$1 = (function (){var statearr_32639 = state_32584;
(statearr_32639[(13)] = inst_32577);

return statearr_32639;
})();
var statearr_32641_34361 = state_32584__$1;
(statearr_32641_34361[(2)] = inst_32578);

(statearr_32641_34361[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (10))){
var inst_32568 = (state_32584[(2)]);
var state_32584__$1 = state_32584;
var statearr_32645_34371 = state_32584__$1;
(statearr_32645_34371[(2)] = inst_32568);

(statearr_32645_34371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32585 === (8))){
var inst_32551 = (state_32584[(11)]);
var inst_32529 = (state_32584[(8)]);
var tmp32638 = inst_32529;
var inst_32529__$1 = tmp32638;
var inst_32530 = inst_32551;
var state_32584__$1 = (function (){var statearr_32646 = state_32584;
(statearr_32646[(7)] = inst_32530);

(statearr_32646[(8)] = inst_32529__$1);

return statearr_32646;
})();
var statearr_32647_34372 = state_32584__$1;
(statearr_32647_34372[(2)] = null);

(statearr_32647_34372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_32654 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32654[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_32654[(1)] = (1));

return statearr_32654;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_32584){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_32584);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e32657){var ex__28981__auto__ = e32657;
var statearr_32660_34379 = state_32584;
(statearr_32660_34379[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_32584[(4)]))){
var statearr_32666_34384 = state_32584;
(statearr_32666_34384[(1)] = cljs.core.first((state_32584[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34387 = state_32584;
state_32584 = G__34387;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_32584){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_32584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_32668 = f__29282__auto__();
(statearr_32668[(6)] = c__29281__auto___34317);

return statearr_32668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32675 = arguments.length;
switch (G__32675) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__29281__auto___34395 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_32736){
var state_val_32737 = (state_32736[(1)]);
if((state_val_32737 === (7))){
var inst_32729 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
var statearr_32743_34400 = state_32736__$1;
(statearr_32743_34400[(2)] = inst_32729);

(statearr_32743_34400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (1))){
var inst_32685 = [];
var inst_32686 = inst_32685;
var inst_32687 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32736__$1 = (function (){var statearr_32746 = state_32736;
(statearr_32746[(7)] = inst_32686);

(statearr_32746[(8)] = inst_32687);

return statearr_32746;
})();
var statearr_32747_34401 = state_32736__$1;
(statearr_32747_34401[(2)] = null);

(statearr_32747_34401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (4))){
var inst_32691 = (state_32736[(9)]);
var inst_32691__$1 = (state_32736[(2)]);
var inst_32692 = (inst_32691__$1 == null);
var inst_32693 = cljs.core.not(inst_32692);
var state_32736__$1 = (function (){var statearr_32752 = state_32736;
(statearr_32752[(9)] = inst_32691__$1);

return statearr_32752;
})();
if(inst_32693){
var statearr_32754_34403 = state_32736__$1;
(statearr_32754_34403[(1)] = (5));

} else {
var statearr_32756_34404 = state_32736__$1;
(statearr_32756_34404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (15))){
var inst_32686 = (state_32736[(7)]);
var inst_32721 = cljs.core.vec(inst_32686);
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32736__$1,(18),out,inst_32721);
} else {
if((state_val_32737 === (13))){
var inst_32716 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
var statearr_32759_34407 = state_32736__$1;
(statearr_32759_34407[(2)] = inst_32716);

(statearr_32759_34407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (6))){
var inst_32686 = (state_32736[(7)]);
var inst_32718 = inst_32686.length;
var inst_32719 = (inst_32718 > (0));
var state_32736__$1 = state_32736;
if(cljs.core.truth_(inst_32719)){
var statearr_32763_34411 = state_32736__$1;
(statearr_32763_34411[(1)] = (15));

} else {
var statearr_32765_34412 = state_32736__$1;
(statearr_32765_34412[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (17))){
var inst_32726 = (state_32736[(2)]);
var inst_32727 = cljs.core.async.close_BANG_(out);
var state_32736__$1 = (function (){var statearr_32767 = state_32736;
(statearr_32767[(10)] = inst_32726);

return statearr_32767;
})();
var statearr_32768_34413 = state_32736__$1;
(statearr_32768_34413[(2)] = inst_32727);

(statearr_32768_34413[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (3))){
var inst_32731 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32736__$1,inst_32731);
} else {
if((state_val_32737 === (12))){
var inst_32686 = (state_32736[(7)]);
var inst_32708 = cljs.core.vec(inst_32686);
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32736__$1,(14),out,inst_32708);
} else {
if((state_val_32737 === (2))){
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32736__$1,(4),ch);
} else {
if((state_val_32737 === (11))){
var inst_32691 = (state_32736[(9)]);
var inst_32686 = (state_32736[(7)]);
var inst_32695 = (state_32736[(11)]);
var inst_32705 = inst_32686.push(inst_32691);
var tmp32771 = inst_32686;
var inst_32686__$1 = tmp32771;
var inst_32687 = inst_32695;
var state_32736__$1 = (function (){var statearr_32774 = state_32736;
(statearr_32774[(12)] = inst_32705);

(statearr_32774[(7)] = inst_32686__$1);

(statearr_32774[(8)] = inst_32687);

return statearr_32774;
})();
var statearr_32777_34414 = state_32736__$1;
(statearr_32777_34414[(2)] = null);

(statearr_32777_34414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (9))){
var inst_32687 = (state_32736[(8)]);
var inst_32701 = cljs.core.keyword_identical_QMARK_(inst_32687,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_32736__$1 = state_32736;
var statearr_32781_34415 = state_32736__$1;
(statearr_32781_34415[(2)] = inst_32701);

(statearr_32781_34415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (5))){
var inst_32691 = (state_32736[(9)]);
var inst_32695 = (state_32736[(11)]);
var inst_32687 = (state_32736[(8)]);
var inst_32698 = (state_32736[(13)]);
var inst_32695__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32691) : f.call(null,inst_32691));
var inst_32698__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32695__$1,inst_32687);
var state_32736__$1 = (function (){var statearr_32796 = state_32736;
(statearr_32796[(11)] = inst_32695__$1);

(statearr_32796[(13)] = inst_32698__$1);

return statearr_32796;
})();
if(inst_32698__$1){
var statearr_32798_34416 = state_32736__$1;
(statearr_32798_34416[(1)] = (8));

} else {
var statearr_32799_34417 = state_32736__$1;
(statearr_32799_34417[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (14))){
var inst_32691 = (state_32736[(9)]);
var inst_32695 = (state_32736[(11)]);
var inst_32710 = (state_32736[(2)]);
var inst_32711 = [];
var inst_32712 = inst_32711.push(inst_32691);
var inst_32686 = inst_32711;
var inst_32687 = inst_32695;
var state_32736__$1 = (function (){var statearr_32805 = state_32736;
(statearr_32805[(7)] = inst_32686);

(statearr_32805[(8)] = inst_32687);

(statearr_32805[(14)] = inst_32712);

(statearr_32805[(15)] = inst_32710);

return statearr_32805;
})();
var statearr_32806_34418 = state_32736__$1;
(statearr_32806_34418[(2)] = null);

(statearr_32806_34418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (16))){
var state_32736__$1 = state_32736;
var statearr_32807_34419 = state_32736__$1;
(statearr_32807_34419[(2)] = null);

(statearr_32807_34419[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (10))){
var inst_32703 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
if(cljs.core.truth_(inst_32703)){
var statearr_32808_34420 = state_32736__$1;
(statearr_32808_34420[(1)] = (11));

} else {
var statearr_32809_34421 = state_32736__$1;
(statearr_32809_34421[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (18))){
var inst_32723 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
var statearr_32810_34422 = state_32736__$1;
(statearr_32810_34422[(2)] = inst_32723);

(statearr_32810_34422[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32737 === (8))){
var inst_32698 = (state_32736[(13)]);
var state_32736__$1 = state_32736;
var statearr_32811_34423 = state_32736__$1;
(statearr_32811_34423[(2)] = inst_32698);

(statearr_32811_34423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28978__auto__ = null;
var cljs$core$async$state_machine__28978__auto____0 = (function (){
var statearr_32812 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32812[(0)] = cljs$core$async$state_machine__28978__auto__);

(statearr_32812[(1)] = (1));

return statearr_32812;
});
var cljs$core$async$state_machine__28978__auto____1 = (function (state_32736){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_32736);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e32813){var ex__28981__auto__ = e32813;
var statearr_32814_34425 = state_32736;
(statearr_32814_34425[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_32736[(4)]))){
var statearr_32815_34426 = state_32736;
(statearr_32815_34426[(1)] = cljs.core.first((state_32736[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34427 = state_32736;
state_32736 = G__34427;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
cljs$core$async$state_machine__28978__auto__ = function(state_32736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28978__auto____1.call(this,state_32736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28978__auto____0;
cljs$core$async$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28978__auto____1;
return cljs$core$async$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_32819 = f__29282__auto__();
(statearr_32819[(6)] = c__29281__auto___34395);

return statearr_32819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
