goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__56345){
var vec__56346 = p__56345;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56346,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56346,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__56349 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__56349__$1 = (((G__56349 instanceof cljs.core.Keyword))?G__56349.fqn:null);
switch (G__56349__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__56351 = (function (){
var seq__56352 = cljs.core.seq(vars__$1);
var chunk__56353 = null;
var count__56354 = (0);
var i__56355 = (0);
while(true){
if((i__56355 < count__56354)){
var v = chunk__56353.cljs$core$IIndexed$_nth$arity$2(null,i__56355);
var temp__5804__auto___56446 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56446)){
var t_56447 = temp__5804__auto___56446;
var G__56358_56448 = ((function (seq__56352,chunk__56353,count__56354,i__56355,t_56447,temp__5804__auto___56446,v,each_fixture_fn,G__56349,G__56349__$1,env,once_fixtures,each_fixtures,vec__56346,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56447)));
});})(seq__56352,chunk__56353,count__56354,i__56355,t_56447,temp__5804__auto___56446,v,each_fixture_fn,G__56349,G__56349__$1,env,once_fixtures,each_fixtures,vec__56346,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56358_56448) : each_fixture_fn.call(null,G__56358_56448));
} else {
}


var G__56453 = seq__56352;
var G__56454 = chunk__56353;
var G__56455 = count__56354;
var G__56456 = (i__56355 + (1));
seq__56352 = G__56453;
chunk__56353 = G__56454;
count__56354 = G__56455;
i__56355 = G__56456;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__56352);
if(temp__5804__auto__){
var seq__56352__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56352__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__56352__$1);
var G__56460 = cljs.core.chunk_rest(seq__56352__$1);
var G__56461 = c__5568__auto__;
var G__56462 = cljs.core.count(c__5568__auto__);
var G__56463 = (0);
seq__56352 = G__56460;
chunk__56353 = G__56461;
count__56354 = G__56462;
i__56355 = G__56463;
continue;
} else {
var v = cljs.core.first(seq__56352__$1);
var temp__5804__auto___56464__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56464__$1)){
var t_56465 = temp__5804__auto___56464__$1;
var G__56359_56466 = ((function (seq__56352,chunk__56353,count__56354,i__56355,t_56465,temp__5804__auto___56464__$1,v,seq__56352__$1,temp__5804__auto__,each_fixture_fn,G__56349,G__56349__$1,env,once_fixtures,each_fixtures,vec__56346,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56465)));
});})(seq__56352,chunk__56353,count__56354,i__56355,t_56465,temp__5804__auto___56464__$1,v,seq__56352__$1,temp__5804__auto__,each_fixture_fn,G__56349,G__56349__$1,env,once_fixtures,each_fixtures,vec__56346,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56359_56466) : each_fixture_fn.call(null,G__56359_56466));
} else {
}


var G__56468 = cljs.core.next(seq__56352__$1);
var G__56469 = null;
var G__56470 = (0);
var G__56471 = (0);
seq__56352 = G__56468;
chunk__56353 = G__56469;
count__56354 = G__56470;
i__56355 = G__56471;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__56350 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__56350.cljs$core$IFn$_invoke$arity$1 ? fexpr__56350.cljs$core$IFn$_invoke$arity$1(G__56351) : fexpr__56350.call(null,G__56351));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56349__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__56342_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56342_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__56364 = shadow.test.env.get_test_ns_info(ns);
var map__56364__$1 = cljs.core.__destructure_map(map__56364);
var test_ns = map__56364__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56364__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__56368,vars){
var map__56369 = p__56368;
var map__56369__$1 = cljs.core.__destructure_map(map__56369);
var env = map__56369__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56369__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__56370_56476 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__56372_56477 = null;
var count__56374_56478 = (0);
var i__56375_56479 = (0);
while(true){
if((i__56375_56479 < count__56374_56478)){
var vec__56405_56480 = chunk__56372_56477.cljs$core$IIndexed$_nth$arity$2(null,i__56375_56479);
var test_ns_56481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56405_56480,(0),null);
var ns_info_56482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56405_56480,(1),null);
var map__56409_56483 = ns_info_56482;
var map__56409_56484__$1 = cljs.core.__destructure_map(map__56409_56483);
var fixtures_56485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56409_56484__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56486 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56485);
if(cljs.core.truth_(temp__5804__auto___56486)){
var fix_56487 = temp__5804__auto___56486;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56481,fix_56487], 0));
} else {
}

var temp__5804__auto___56488 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56485);
if(cljs.core.truth_(temp__5804__auto___56488)){
var fix_56490 = temp__5804__auto___56488;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56481,fix_56490], 0));
} else {
}


var G__56491 = seq__56370_56476;
var G__56492 = chunk__56372_56477;
var G__56493 = count__56374_56478;
var G__56494 = (i__56375_56479 + (1));
seq__56370_56476 = G__56491;
chunk__56372_56477 = G__56492;
count__56374_56478 = G__56493;
i__56375_56479 = G__56494;
continue;
} else {
var temp__5804__auto___56495 = cljs.core.seq(seq__56370_56476);
if(temp__5804__auto___56495){
var seq__56370_56496__$1 = temp__5804__auto___56495;
if(cljs.core.chunked_seq_QMARK_(seq__56370_56496__$1)){
var c__5568__auto___56497 = cljs.core.chunk_first(seq__56370_56496__$1);
var G__56498 = cljs.core.chunk_rest(seq__56370_56496__$1);
var G__56499 = c__5568__auto___56497;
var G__56500 = cljs.core.count(c__5568__auto___56497);
var G__56501 = (0);
seq__56370_56476 = G__56498;
chunk__56372_56477 = G__56499;
count__56374_56478 = G__56500;
i__56375_56479 = G__56501;
continue;
} else {
var vec__56411_56502 = cljs.core.first(seq__56370_56496__$1);
var test_ns_56503 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56411_56502,(0),null);
var ns_info_56504 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56411_56502,(1),null);
var map__56414_56505 = ns_info_56504;
var map__56414_56506__$1 = cljs.core.__destructure_map(map__56414_56505);
var fixtures_56507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56414_56506__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56509__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56507);
if(cljs.core.truth_(temp__5804__auto___56509__$1)){
var fix_56511 = temp__5804__auto___56509__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56503,fix_56511], 0));
} else {
}

var temp__5804__auto___56513__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56507);
if(cljs.core.truth_(temp__5804__auto___56513__$1)){
var fix_56514 = temp__5804__auto___56513__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56503,fix_56514], 0));
} else {
}


var G__56517 = cljs.core.next(seq__56370_56496__$1);
var G__56518 = null;
var G__56519 = (0);
var G__56520 = (0);
seq__56370_56476 = G__56517;
chunk__56372_56477 = G__56518;
count__56374_56478 = G__56519;
i__56375_56479 = G__56520;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56367_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56367_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__56416 = cljs.test.get_current_env();
var map__56416__$1 = cljs.core.__destructure_map(map__56416);
var env = map__56416__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56416__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56416__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__56425 = arguments.length;
switch (G__56425) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__56428 = arguments.length;
switch (G__56428) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__56432 = shadow.test.env.get_test_ns_info(ns);
var map__56432__$1 = cljs.core.__destructure_map(map__56432);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56432__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__56435 = arguments.length;
switch (G__56435) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56433_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56433_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__56440 = arguments.length;
switch (G__56440) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56438_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56438_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
