goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35372 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35372(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35375 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35375(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34148 = coll;
var G__34149 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34148,G__34149) : shadow.dom.lazy_native_coll_seq.call(null,G__34148,G__34149));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34166 = arguments.length;
switch (G__34166) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34174 = arguments.length;
switch (G__34174) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34181 = arguments.length;
switch (G__34181) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34188 = arguments.length;
switch (G__34188) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34202 = arguments.length;
switch (G__34202) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34229 = arguments.length;
switch (G__34229) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34240){if((e34240 instanceof Object)){
var e = e34240;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34240;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34246 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34247 = null;
var count__34248 = (0);
var i__34249 = (0);
while(true){
if((i__34249 < count__34248)){
var el = chunk__34247.cljs$core$IIndexed$_nth$arity$2(null,i__34249);
var handler_35438__$1 = ((function (seq__34246,chunk__34247,count__34248,i__34249,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34246,chunk__34247,count__34248,i__34249,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35438__$1);


var G__35443 = seq__34246;
var G__35444 = chunk__34247;
var G__35445 = count__34248;
var G__35446 = (i__34249 + (1));
seq__34246 = G__35443;
chunk__34247 = G__35444;
count__34248 = G__35445;
i__34249 = G__35446;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34246);
if(temp__5804__auto__){
var seq__34246__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34246__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34246__$1);
var G__35448 = cljs.core.chunk_rest(seq__34246__$1);
var G__35449 = c__5568__auto__;
var G__35450 = cljs.core.count(c__5568__auto__);
var G__35451 = (0);
seq__34246 = G__35448;
chunk__34247 = G__35449;
count__34248 = G__35450;
i__34249 = G__35451;
continue;
} else {
var el = cljs.core.first(seq__34246__$1);
var handler_35452__$1 = ((function (seq__34246,chunk__34247,count__34248,i__34249,el,seq__34246__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34246,chunk__34247,count__34248,i__34249,el,seq__34246__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35452__$1);


var G__35455 = cljs.core.next(seq__34246__$1);
var G__35456 = null;
var G__35457 = (0);
var G__35458 = (0);
seq__34246 = G__35455;
chunk__34247 = G__35456;
count__34248 = G__35457;
i__34249 = G__35458;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34268 = arguments.length;
switch (G__34268) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34276 = cljs.core.seq(events);
var chunk__34277 = null;
var count__34278 = (0);
var i__34279 = (0);
while(true){
if((i__34279 < count__34278)){
var vec__34297 = chunk__34277.cljs$core$IIndexed$_nth$arity$2(null,i__34279);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34297,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34297,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35463 = seq__34276;
var G__35464 = chunk__34277;
var G__35465 = count__34278;
var G__35466 = (i__34279 + (1));
seq__34276 = G__35463;
chunk__34277 = G__35464;
count__34278 = G__35465;
i__34279 = G__35466;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34276);
if(temp__5804__auto__){
var seq__34276__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34276__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34276__$1);
var G__35467 = cljs.core.chunk_rest(seq__34276__$1);
var G__35468 = c__5568__auto__;
var G__35469 = cljs.core.count(c__5568__auto__);
var G__35470 = (0);
seq__34276 = G__35467;
chunk__34277 = G__35468;
count__34278 = G__35469;
i__34279 = G__35470;
continue;
} else {
var vec__34308 = cljs.core.first(seq__34276__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34308,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34308,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35472 = cljs.core.next(seq__34276__$1);
var G__35473 = null;
var G__35474 = (0);
var G__35475 = (0);
seq__34276 = G__35472;
chunk__34277 = G__35473;
count__34278 = G__35474;
i__34279 = G__35475;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34318 = cljs.core.seq(styles);
var chunk__34319 = null;
var count__34320 = (0);
var i__34321 = (0);
while(true){
if((i__34321 < count__34320)){
var vec__34333 = chunk__34319.cljs$core$IIndexed$_nth$arity$2(null,i__34321);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34333,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34333,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35477 = seq__34318;
var G__35478 = chunk__34319;
var G__35479 = count__34320;
var G__35480 = (i__34321 + (1));
seq__34318 = G__35477;
chunk__34319 = G__35478;
count__34320 = G__35479;
i__34321 = G__35480;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34318);
if(temp__5804__auto__){
var seq__34318__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34318__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34318__$1);
var G__35481 = cljs.core.chunk_rest(seq__34318__$1);
var G__35482 = c__5568__auto__;
var G__35483 = cljs.core.count(c__5568__auto__);
var G__35484 = (0);
seq__34318 = G__35481;
chunk__34319 = G__35482;
count__34320 = G__35483;
i__34321 = G__35484;
continue;
} else {
var vec__34352 = cljs.core.first(seq__34318__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34352,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34352,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35486 = cljs.core.next(seq__34318__$1);
var G__35487 = null;
var G__35488 = (0);
var G__35489 = (0);
seq__34318 = G__35486;
chunk__34319 = G__35487;
count__34320 = G__35488;
i__34321 = G__35489;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34367_35490 = key;
var G__34367_35491__$1 = (((G__34367_35490 instanceof cljs.core.Keyword))?G__34367_35490.fqn:null);
switch (G__34367_35491__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35521 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35521,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35521,"aria-");
}
})())){
el.setAttribute(ks_35521,value);
} else {
(el[ks_35521] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34409){
var map__34410 = p__34409;
var map__34410__$1 = cljs.core.__destructure_map(map__34410);
var props = map__34410__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34410__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34411 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34411,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34411,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34411,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34415 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34415,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34415;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34420 = arguments.length;
switch (G__34420) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34428){
var vec__34430 = p__34428;
var seq__34431 = cljs.core.seq(vec__34430);
var first__34432 = cljs.core.first(seq__34431);
var seq__34431__$1 = cljs.core.next(seq__34431);
var nn = first__34432;
var first__34432__$1 = cljs.core.first(seq__34431__$1);
var seq__34431__$2 = cljs.core.next(seq__34431__$1);
var np = first__34432__$1;
var nc = seq__34431__$2;
var node = vec__34430;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34436 = nn;
var G__34437 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34436,G__34437) : create_fn.call(null,G__34436,G__34437));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34438 = nn;
var G__34439 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34438,G__34439) : create_fn.call(null,G__34438,G__34439));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34453 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34453,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34453,(1),null);
var seq__34457_35621 = cljs.core.seq(node_children);
var chunk__34458_35622 = null;
var count__34459_35623 = (0);
var i__34460_35624 = (0);
while(true){
if((i__34460_35624 < count__34459_35623)){
var child_struct_35631 = chunk__34458_35622.cljs$core$IIndexed$_nth$arity$2(null,i__34460_35624);
var children_35633 = shadow.dom.dom_node(child_struct_35631);
if(cljs.core.seq_QMARK_(children_35633)){
var seq__34496_35635 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35633));
var chunk__34498_35636 = null;
var count__34499_35637 = (0);
var i__34500_35638 = (0);
while(true){
if((i__34500_35638 < count__34499_35637)){
var child_35653 = chunk__34498_35636.cljs$core$IIndexed$_nth$arity$2(null,i__34500_35638);
if(cljs.core.truth_(child_35653)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35653);


var G__35654 = seq__34496_35635;
var G__35655 = chunk__34498_35636;
var G__35656 = count__34499_35637;
var G__35657 = (i__34500_35638 + (1));
seq__34496_35635 = G__35654;
chunk__34498_35636 = G__35655;
count__34499_35637 = G__35656;
i__34500_35638 = G__35657;
continue;
} else {
var G__35661 = seq__34496_35635;
var G__35662 = chunk__34498_35636;
var G__35663 = count__34499_35637;
var G__35664 = (i__34500_35638 + (1));
seq__34496_35635 = G__35661;
chunk__34498_35636 = G__35662;
count__34499_35637 = G__35663;
i__34500_35638 = G__35664;
continue;
}
} else {
var temp__5804__auto___35665 = cljs.core.seq(seq__34496_35635);
if(temp__5804__auto___35665){
var seq__34496_35670__$1 = temp__5804__auto___35665;
if(cljs.core.chunked_seq_QMARK_(seq__34496_35670__$1)){
var c__5568__auto___35675 = cljs.core.chunk_first(seq__34496_35670__$1);
var G__35676 = cljs.core.chunk_rest(seq__34496_35670__$1);
var G__35677 = c__5568__auto___35675;
var G__35678 = cljs.core.count(c__5568__auto___35675);
var G__35679 = (0);
seq__34496_35635 = G__35676;
chunk__34498_35636 = G__35677;
count__34499_35637 = G__35678;
i__34500_35638 = G__35679;
continue;
} else {
var child_35694 = cljs.core.first(seq__34496_35670__$1);
if(cljs.core.truth_(child_35694)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35694);


var G__35695 = cljs.core.next(seq__34496_35670__$1);
var G__35696 = null;
var G__35697 = (0);
var G__35698 = (0);
seq__34496_35635 = G__35695;
chunk__34498_35636 = G__35696;
count__34499_35637 = G__35697;
i__34500_35638 = G__35698;
continue;
} else {
var G__35700 = cljs.core.next(seq__34496_35670__$1);
var G__35701 = null;
var G__35702 = (0);
var G__35703 = (0);
seq__34496_35635 = G__35700;
chunk__34498_35636 = G__35701;
count__34499_35637 = G__35702;
i__34500_35638 = G__35703;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35633);
}


var G__35706 = seq__34457_35621;
var G__35707 = chunk__34458_35622;
var G__35708 = count__34459_35623;
var G__35709 = (i__34460_35624 + (1));
seq__34457_35621 = G__35706;
chunk__34458_35622 = G__35707;
count__34459_35623 = G__35708;
i__34460_35624 = G__35709;
continue;
} else {
var temp__5804__auto___35710 = cljs.core.seq(seq__34457_35621);
if(temp__5804__auto___35710){
var seq__34457_35716__$1 = temp__5804__auto___35710;
if(cljs.core.chunked_seq_QMARK_(seq__34457_35716__$1)){
var c__5568__auto___35721 = cljs.core.chunk_first(seq__34457_35716__$1);
var G__35728 = cljs.core.chunk_rest(seq__34457_35716__$1);
var G__35729 = c__5568__auto___35721;
var G__35730 = cljs.core.count(c__5568__auto___35721);
var G__35731 = (0);
seq__34457_35621 = G__35728;
chunk__34458_35622 = G__35729;
count__34459_35623 = G__35730;
i__34460_35624 = G__35731;
continue;
} else {
var child_struct_35733 = cljs.core.first(seq__34457_35716__$1);
var children_35739 = shadow.dom.dom_node(child_struct_35733);
if(cljs.core.seq_QMARK_(children_35739)){
var seq__34523_35740 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35739));
var chunk__34525_35741 = null;
var count__34526_35742 = (0);
var i__34527_35743 = (0);
while(true){
if((i__34527_35743 < count__34526_35742)){
var child_35749 = chunk__34525_35741.cljs$core$IIndexed$_nth$arity$2(null,i__34527_35743);
if(cljs.core.truth_(child_35749)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35749);


var G__35756 = seq__34523_35740;
var G__35757 = chunk__34525_35741;
var G__35758 = count__34526_35742;
var G__35759 = (i__34527_35743 + (1));
seq__34523_35740 = G__35756;
chunk__34525_35741 = G__35757;
count__34526_35742 = G__35758;
i__34527_35743 = G__35759;
continue;
} else {
var G__35761 = seq__34523_35740;
var G__35762 = chunk__34525_35741;
var G__35763 = count__34526_35742;
var G__35764 = (i__34527_35743 + (1));
seq__34523_35740 = G__35761;
chunk__34525_35741 = G__35762;
count__34526_35742 = G__35763;
i__34527_35743 = G__35764;
continue;
}
} else {
var temp__5804__auto___35765__$1 = cljs.core.seq(seq__34523_35740);
if(temp__5804__auto___35765__$1){
var seq__34523_35766__$1 = temp__5804__auto___35765__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34523_35766__$1)){
var c__5568__auto___35768 = cljs.core.chunk_first(seq__34523_35766__$1);
var G__35769 = cljs.core.chunk_rest(seq__34523_35766__$1);
var G__35770 = c__5568__auto___35768;
var G__35771 = cljs.core.count(c__5568__auto___35768);
var G__35772 = (0);
seq__34523_35740 = G__35769;
chunk__34525_35741 = G__35770;
count__34526_35742 = G__35771;
i__34527_35743 = G__35772;
continue;
} else {
var child_35778 = cljs.core.first(seq__34523_35766__$1);
if(cljs.core.truth_(child_35778)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35778);


var G__35780 = cljs.core.next(seq__34523_35766__$1);
var G__35781 = null;
var G__35782 = (0);
var G__35783 = (0);
seq__34523_35740 = G__35780;
chunk__34525_35741 = G__35781;
count__34526_35742 = G__35782;
i__34527_35743 = G__35783;
continue;
} else {
var G__35788 = cljs.core.next(seq__34523_35766__$1);
var G__35789 = null;
var G__35790 = (0);
var G__35791 = (0);
seq__34523_35740 = G__35788;
chunk__34525_35741 = G__35789;
count__34526_35742 = G__35790;
i__34527_35743 = G__35791;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35739);
}


var G__35793 = cljs.core.next(seq__34457_35716__$1);
var G__35794 = null;
var G__35795 = (0);
var G__35796 = (0);
seq__34457_35621 = G__35793;
chunk__34458_35622 = G__35794;
count__34459_35623 = G__35795;
i__34460_35624 = G__35796;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34571 = cljs.core.seq(node);
var chunk__34572 = null;
var count__34573 = (0);
var i__34574 = (0);
while(true){
if((i__34574 < count__34573)){
var n = chunk__34572.cljs$core$IIndexed$_nth$arity$2(null,i__34574);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35815 = seq__34571;
var G__35816 = chunk__34572;
var G__35817 = count__34573;
var G__35818 = (i__34574 + (1));
seq__34571 = G__35815;
chunk__34572 = G__35816;
count__34573 = G__35817;
i__34574 = G__35818;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34571);
if(temp__5804__auto__){
var seq__34571__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34571__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34571__$1);
var G__35827 = cljs.core.chunk_rest(seq__34571__$1);
var G__35828 = c__5568__auto__;
var G__35829 = cljs.core.count(c__5568__auto__);
var G__35830 = (0);
seq__34571 = G__35827;
chunk__34572 = G__35828;
count__34573 = G__35829;
i__34574 = G__35830;
continue;
} else {
var n = cljs.core.first(seq__34571__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35838 = cljs.core.next(seq__34571__$1);
var G__35839 = null;
var G__35841 = (0);
var G__35842 = (0);
seq__34571 = G__35838;
chunk__34572 = G__35839;
count__34573 = G__35841;
i__34574 = G__35842;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34617 = arguments.length;
switch (G__34617) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34637 = arguments.length;
switch (G__34637) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34671 = arguments.length;
switch (G__34671) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35907 = arguments.length;
var i__5770__auto___35909 = (0);
while(true){
if((i__5770__auto___35909 < len__5769__auto___35907)){
args__5775__auto__.push((arguments[i__5770__auto___35909]));

var G__35914 = (i__5770__auto___35909 + (1));
i__5770__auto___35909 = G__35914;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34727_35923 = cljs.core.seq(nodes);
var chunk__34728_35924 = null;
var count__34729_35925 = (0);
var i__34730_35926 = (0);
while(true){
if((i__34730_35926 < count__34729_35925)){
var node_35927 = chunk__34728_35924.cljs$core$IIndexed$_nth$arity$2(null,i__34730_35926);
fragment.appendChild(shadow.dom._to_dom(node_35927));


var G__35932 = seq__34727_35923;
var G__35933 = chunk__34728_35924;
var G__35934 = count__34729_35925;
var G__35935 = (i__34730_35926 + (1));
seq__34727_35923 = G__35932;
chunk__34728_35924 = G__35933;
count__34729_35925 = G__35934;
i__34730_35926 = G__35935;
continue;
} else {
var temp__5804__auto___35936 = cljs.core.seq(seq__34727_35923);
if(temp__5804__auto___35936){
var seq__34727_35938__$1 = temp__5804__auto___35936;
if(cljs.core.chunked_seq_QMARK_(seq__34727_35938__$1)){
var c__5568__auto___35940 = cljs.core.chunk_first(seq__34727_35938__$1);
var G__35941 = cljs.core.chunk_rest(seq__34727_35938__$1);
var G__35942 = c__5568__auto___35940;
var G__35943 = cljs.core.count(c__5568__auto___35940);
var G__35944 = (0);
seq__34727_35923 = G__35941;
chunk__34728_35924 = G__35942;
count__34729_35925 = G__35943;
i__34730_35926 = G__35944;
continue;
} else {
var node_35951 = cljs.core.first(seq__34727_35938__$1);
fragment.appendChild(shadow.dom._to_dom(node_35951));


var G__35952 = cljs.core.next(seq__34727_35938__$1);
var G__35953 = null;
var G__35954 = (0);
var G__35955 = (0);
seq__34727_35923 = G__35952;
chunk__34728_35924 = G__35953;
count__34729_35925 = G__35954;
i__34730_35926 = G__35955;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34711){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34711));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34767_35960 = cljs.core.seq(scripts);
var chunk__34768_35961 = null;
var count__34769_35962 = (0);
var i__34770_35963 = (0);
while(true){
if((i__34770_35963 < count__34769_35962)){
var vec__34790_35966 = chunk__34768_35961.cljs$core$IIndexed$_nth$arity$2(null,i__34770_35963);
var script_tag_35967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34790_35966,(0),null);
var script_body_35968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34790_35966,(1),null);
eval(script_body_35968);


var G__35972 = seq__34767_35960;
var G__35973 = chunk__34768_35961;
var G__35974 = count__34769_35962;
var G__35975 = (i__34770_35963 + (1));
seq__34767_35960 = G__35972;
chunk__34768_35961 = G__35973;
count__34769_35962 = G__35974;
i__34770_35963 = G__35975;
continue;
} else {
var temp__5804__auto___35977 = cljs.core.seq(seq__34767_35960);
if(temp__5804__auto___35977){
var seq__34767_35978__$1 = temp__5804__auto___35977;
if(cljs.core.chunked_seq_QMARK_(seq__34767_35978__$1)){
var c__5568__auto___35979 = cljs.core.chunk_first(seq__34767_35978__$1);
var G__35980 = cljs.core.chunk_rest(seq__34767_35978__$1);
var G__35981 = c__5568__auto___35979;
var G__35982 = cljs.core.count(c__5568__auto___35979);
var G__35983 = (0);
seq__34767_35960 = G__35980;
chunk__34768_35961 = G__35981;
count__34769_35962 = G__35982;
i__34770_35963 = G__35983;
continue;
} else {
var vec__34801_35984 = cljs.core.first(seq__34767_35978__$1);
var script_tag_35985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34801_35984,(0),null);
var script_body_35986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34801_35984,(1),null);
eval(script_body_35986);


var G__35989 = cljs.core.next(seq__34767_35978__$1);
var G__35990 = null;
var G__35991 = (0);
var G__35992 = (0);
seq__34767_35960 = G__35989;
chunk__34768_35961 = G__35990;
count__34769_35962 = G__35991;
i__34770_35963 = G__35992;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__34808){
var vec__34809 = p__34808;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34809,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34809,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__34837 = arguments.length;
switch (G__34837) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__34881 = cljs.core.seq(style_keys);
var chunk__34882 = null;
var count__34883 = (0);
var i__34884 = (0);
while(true){
if((i__34884 < count__34883)){
var it = chunk__34882.cljs$core$IIndexed$_nth$arity$2(null,i__34884);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36018 = seq__34881;
var G__36019 = chunk__34882;
var G__36020 = count__34883;
var G__36021 = (i__34884 + (1));
seq__34881 = G__36018;
chunk__34882 = G__36019;
count__34883 = G__36020;
i__34884 = G__36021;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34881);
if(temp__5804__auto__){
var seq__34881__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34881__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34881__$1);
var G__36023 = cljs.core.chunk_rest(seq__34881__$1);
var G__36024 = c__5568__auto__;
var G__36025 = cljs.core.count(c__5568__auto__);
var G__36026 = (0);
seq__34881 = G__36023;
chunk__34882 = G__36024;
count__34883 = G__36025;
i__34884 = G__36026;
continue;
} else {
var it = cljs.core.first(seq__34881__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36032 = cljs.core.next(seq__34881__$1);
var G__36033 = null;
var G__36034 = (0);
var G__36035 = (0);
seq__34881 = G__36032;
chunk__34882 = G__36033;
count__34883 = G__36034;
i__34884 = G__36035;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34916,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34935 = k34916;
var G__34935__$1 = (((G__34935 instanceof cljs.core.Keyword))?G__34935.fqn:null);
switch (G__34935__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34916,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34941){
var vec__34947 = p__34941;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34947,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34947,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34915){
var self__ = this;
var G__34915__$1 = this;
return (new cljs.core.RecordIter((0),G__34915__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34917,other34918){
var self__ = this;
var this34917__$1 = this;
return (((!((other34918 == null)))) && ((((this34917__$1.constructor === other34918.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34917__$1.x,other34918.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34917__$1.y,other34918.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34917__$1.__extmap,other34918.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34916){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35013 = k34916;
var G__35013__$1 = (((G__35013 instanceof cljs.core.Keyword))?G__35013.fqn:null);
switch (G__35013__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34916);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34915){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35016 = cljs.core.keyword_identical_QMARK_;
var expr__35017 = k__5352__auto__;
if(cljs.core.truth_((pred__35016.cljs$core$IFn$_invoke$arity$2 ? pred__35016.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35017) : pred__35016.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35017)))){
return (new shadow.dom.Coordinate(G__34915,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35016.cljs$core$IFn$_invoke$arity$2 ? pred__35016.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35017) : pred__35016.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35017)))){
return (new shadow.dom.Coordinate(self__.x,G__34915,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34915),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34915){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__34915,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__34923){
var extmap__5385__auto__ = (function (){var G__35045 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34923,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__34923)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35045);
} else {
return G__35045;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__34923),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__34923),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35055,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35070 = k35055;
var G__35070__$1 = (((G__35070 instanceof cljs.core.Keyword))?G__35070.fqn:null);
switch (G__35070__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35055,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35072){
var vec__35074 = p__35072;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35074,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35074,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35054){
var self__ = this;
var G__35054__$1 = this;
return (new cljs.core.RecordIter((0),G__35054__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35057,other35058){
var self__ = this;
var this35057__$1 = this;
return (((!((other35058 == null)))) && ((((this35057__$1.constructor === other35058.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35057__$1.w,other35058.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35057__$1.h,other35058.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35057__$1.__extmap,other35058.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35055){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35090 = k35055;
var G__35090__$1 = (((G__35090 instanceof cljs.core.Keyword))?G__35090.fqn:null);
switch (G__35090__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35055);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35054){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35093 = cljs.core.keyword_identical_QMARK_;
var expr__35094 = k__5352__auto__;
if(cljs.core.truth_((pred__35093.cljs$core$IFn$_invoke$arity$2 ? pred__35093.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35094) : pred__35093.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35094)))){
return (new shadow.dom.Size(G__35054,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35093.cljs$core$IFn$_invoke$arity$2 ? pred__35093.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35094) : pred__35093.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35094)))){
return (new shadow.dom.Size(self__.w,G__35054,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35054),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35054){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35054,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35062){
var extmap__5385__auto__ = (function (){var G__35132 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35062,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35062)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35132);
} else {
return G__35132;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35062),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35062),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__36251 = (i + (1));
var G__36252 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__36251;
ret = G__36252;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35149){
var vec__35150 = p__35149;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35150,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35150,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35160 = arguments.length;
switch (G__35160) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__36257 = ps;
var G__36258 = (i + (1));
el__$1 = G__36257;
i = G__36258;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35181 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35181,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35181,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35181,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35185_36268 = cljs.core.seq(props);
var chunk__35186_36269 = null;
var count__35187_36270 = (0);
var i__35188_36271 = (0);
while(true){
if((i__35188_36271 < count__35187_36270)){
var vec__35207_36272 = chunk__35186_36269.cljs$core$IIndexed$_nth$arity$2(null,i__35188_36271);
var k_36273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35207_36272,(0),null);
var v_36274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35207_36272,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_36273);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36273),v_36274);


var G__36276 = seq__35185_36268;
var G__36277 = chunk__35186_36269;
var G__36278 = count__35187_36270;
var G__36279 = (i__35188_36271 + (1));
seq__35185_36268 = G__36276;
chunk__35186_36269 = G__36277;
count__35187_36270 = G__36278;
i__35188_36271 = G__36279;
continue;
} else {
var temp__5804__auto___36280 = cljs.core.seq(seq__35185_36268);
if(temp__5804__auto___36280){
var seq__35185_36281__$1 = temp__5804__auto___36280;
if(cljs.core.chunked_seq_QMARK_(seq__35185_36281__$1)){
var c__5568__auto___36282 = cljs.core.chunk_first(seq__35185_36281__$1);
var G__36283 = cljs.core.chunk_rest(seq__35185_36281__$1);
var G__36284 = c__5568__auto___36282;
var G__36285 = cljs.core.count(c__5568__auto___36282);
var G__36287 = (0);
seq__35185_36268 = G__36283;
chunk__35186_36269 = G__36284;
count__35187_36270 = G__36285;
i__35188_36271 = G__36287;
continue;
} else {
var vec__35218_36291 = cljs.core.first(seq__35185_36281__$1);
var k_36292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35218_36291,(0),null);
var v_36293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35218_36291,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_36292);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36292),v_36293);


var G__36295 = cljs.core.next(seq__35185_36281__$1);
var G__36296 = null;
var G__36297 = (0);
var G__36298 = (0);
seq__35185_36268 = G__36295;
chunk__35186_36269 = G__36296;
count__35187_36270 = G__36297;
i__35188_36271 = G__36298;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35228 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35228,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35228,(1),null);
var seq__35232_36300 = cljs.core.seq(node_children);
var chunk__35235_36301 = null;
var count__35236_36302 = (0);
var i__35237_36303 = (0);
while(true){
if((i__35237_36303 < count__35236_36302)){
var child_struct_36304 = chunk__35235_36301.cljs$core$IIndexed$_nth$arity$2(null,i__35237_36303);
if((!((child_struct_36304 == null)))){
if(typeof child_struct_36304 === 'string'){
var text_36305 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36305),child_struct_36304].join(''));
} else {
var children_36306 = shadow.dom.svg_node(child_struct_36304);
if(cljs.core.seq_QMARK_(children_36306)){
var seq__35286_36308 = cljs.core.seq(children_36306);
var chunk__35288_36309 = null;
var count__35289_36310 = (0);
var i__35290_36311 = (0);
while(true){
if((i__35290_36311 < count__35289_36310)){
var child_36312 = chunk__35288_36309.cljs$core$IIndexed$_nth$arity$2(null,i__35290_36311);
if(cljs.core.truth_(child_36312)){
node.appendChild(child_36312);


var G__36313 = seq__35286_36308;
var G__36314 = chunk__35288_36309;
var G__36315 = count__35289_36310;
var G__36316 = (i__35290_36311 + (1));
seq__35286_36308 = G__36313;
chunk__35288_36309 = G__36314;
count__35289_36310 = G__36315;
i__35290_36311 = G__36316;
continue;
} else {
var G__36317 = seq__35286_36308;
var G__36318 = chunk__35288_36309;
var G__36319 = count__35289_36310;
var G__36320 = (i__35290_36311 + (1));
seq__35286_36308 = G__36317;
chunk__35288_36309 = G__36318;
count__35289_36310 = G__36319;
i__35290_36311 = G__36320;
continue;
}
} else {
var temp__5804__auto___36321 = cljs.core.seq(seq__35286_36308);
if(temp__5804__auto___36321){
var seq__35286_36323__$1 = temp__5804__auto___36321;
if(cljs.core.chunked_seq_QMARK_(seq__35286_36323__$1)){
var c__5568__auto___36324 = cljs.core.chunk_first(seq__35286_36323__$1);
var G__36325 = cljs.core.chunk_rest(seq__35286_36323__$1);
var G__36326 = c__5568__auto___36324;
var G__36327 = cljs.core.count(c__5568__auto___36324);
var G__36328 = (0);
seq__35286_36308 = G__36325;
chunk__35288_36309 = G__36326;
count__35289_36310 = G__36327;
i__35290_36311 = G__36328;
continue;
} else {
var child_36329 = cljs.core.first(seq__35286_36323__$1);
if(cljs.core.truth_(child_36329)){
node.appendChild(child_36329);


var G__36330 = cljs.core.next(seq__35286_36323__$1);
var G__36331 = null;
var G__36332 = (0);
var G__36333 = (0);
seq__35286_36308 = G__36330;
chunk__35288_36309 = G__36331;
count__35289_36310 = G__36332;
i__35290_36311 = G__36333;
continue;
} else {
var G__36335 = cljs.core.next(seq__35286_36323__$1);
var G__36336 = null;
var G__36337 = (0);
var G__36338 = (0);
seq__35286_36308 = G__36335;
chunk__35288_36309 = G__36336;
count__35289_36310 = G__36337;
i__35290_36311 = G__36338;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36306);
}
}


var G__36340 = seq__35232_36300;
var G__36341 = chunk__35235_36301;
var G__36342 = count__35236_36302;
var G__36343 = (i__35237_36303 + (1));
seq__35232_36300 = G__36340;
chunk__35235_36301 = G__36341;
count__35236_36302 = G__36342;
i__35237_36303 = G__36343;
continue;
} else {
var G__36348 = seq__35232_36300;
var G__36349 = chunk__35235_36301;
var G__36350 = count__35236_36302;
var G__36351 = (i__35237_36303 + (1));
seq__35232_36300 = G__36348;
chunk__35235_36301 = G__36349;
count__35236_36302 = G__36350;
i__35237_36303 = G__36351;
continue;
}
} else {
var temp__5804__auto___36353 = cljs.core.seq(seq__35232_36300);
if(temp__5804__auto___36353){
var seq__35232_36354__$1 = temp__5804__auto___36353;
if(cljs.core.chunked_seq_QMARK_(seq__35232_36354__$1)){
var c__5568__auto___36355 = cljs.core.chunk_first(seq__35232_36354__$1);
var G__36356 = cljs.core.chunk_rest(seq__35232_36354__$1);
var G__36357 = c__5568__auto___36355;
var G__36358 = cljs.core.count(c__5568__auto___36355);
var G__36359 = (0);
seq__35232_36300 = G__36356;
chunk__35235_36301 = G__36357;
count__35236_36302 = G__36358;
i__35237_36303 = G__36359;
continue;
} else {
var child_struct_36360 = cljs.core.first(seq__35232_36354__$1);
if((!((child_struct_36360 == null)))){
if(typeof child_struct_36360 === 'string'){
var text_36361 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36361),child_struct_36360].join(''));
} else {
var children_36362 = shadow.dom.svg_node(child_struct_36360);
if(cljs.core.seq_QMARK_(children_36362)){
var seq__35300_36363 = cljs.core.seq(children_36362);
var chunk__35302_36364 = null;
var count__35303_36365 = (0);
var i__35304_36366 = (0);
while(true){
if((i__35304_36366 < count__35303_36365)){
var child_36370 = chunk__35302_36364.cljs$core$IIndexed$_nth$arity$2(null,i__35304_36366);
if(cljs.core.truth_(child_36370)){
node.appendChild(child_36370);


var G__36371 = seq__35300_36363;
var G__36372 = chunk__35302_36364;
var G__36373 = count__35303_36365;
var G__36374 = (i__35304_36366 + (1));
seq__35300_36363 = G__36371;
chunk__35302_36364 = G__36372;
count__35303_36365 = G__36373;
i__35304_36366 = G__36374;
continue;
} else {
var G__36375 = seq__35300_36363;
var G__36376 = chunk__35302_36364;
var G__36377 = count__35303_36365;
var G__36378 = (i__35304_36366 + (1));
seq__35300_36363 = G__36375;
chunk__35302_36364 = G__36376;
count__35303_36365 = G__36377;
i__35304_36366 = G__36378;
continue;
}
} else {
var temp__5804__auto___36379__$1 = cljs.core.seq(seq__35300_36363);
if(temp__5804__auto___36379__$1){
var seq__35300_36380__$1 = temp__5804__auto___36379__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35300_36380__$1)){
var c__5568__auto___36381 = cljs.core.chunk_first(seq__35300_36380__$1);
var G__36382 = cljs.core.chunk_rest(seq__35300_36380__$1);
var G__36383 = c__5568__auto___36381;
var G__36384 = cljs.core.count(c__5568__auto___36381);
var G__36385 = (0);
seq__35300_36363 = G__36382;
chunk__35302_36364 = G__36383;
count__35303_36365 = G__36384;
i__35304_36366 = G__36385;
continue;
} else {
var child_36386 = cljs.core.first(seq__35300_36380__$1);
if(cljs.core.truth_(child_36386)){
node.appendChild(child_36386);


var G__36387 = cljs.core.next(seq__35300_36380__$1);
var G__36388 = null;
var G__36389 = (0);
var G__36390 = (0);
seq__35300_36363 = G__36387;
chunk__35302_36364 = G__36388;
count__35303_36365 = G__36389;
i__35304_36366 = G__36390;
continue;
} else {
var G__36394 = cljs.core.next(seq__35300_36380__$1);
var G__36395 = null;
var G__36396 = (0);
var G__36397 = (0);
seq__35300_36363 = G__36394;
chunk__35302_36364 = G__36395;
count__35303_36365 = G__36396;
i__35304_36366 = G__36397;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36362);
}
}


var G__36398 = cljs.core.next(seq__35232_36354__$1);
var G__36399 = null;
var G__36400 = (0);
var G__36401 = (0);
seq__35232_36300 = G__36398;
chunk__35235_36301 = G__36399;
count__35236_36302 = G__36400;
i__35237_36303 = G__36401;
continue;
} else {
var G__36402 = cljs.core.next(seq__35232_36354__$1);
var G__36403 = null;
var G__36404 = (0);
var G__36405 = (0);
seq__35232_36300 = G__36402;
chunk__35235_36301 = G__36403;
count__35236_36302 = G__36404;
i__35237_36303 = G__36405;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36409 = arguments.length;
var i__5770__auto___36410 = (0);
while(true){
if((i__5770__auto___36410 < len__5769__auto___36409)){
args__5775__auto__.push((arguments[i__5770__auto___36410]));

var G__36413 = (i__5770__auto___36410 + (1));
i__5770__auto___36410 = G__36413;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35322){
var G__35323 = cljs.core.first(seq35322);
var seq35322__$1 = cljs.core.next(seq35322);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35323,seq35322__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35337 = arguments.length;
switch (G__35337) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30753__auto___36426 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_35348){
var state_val_35349 = (state_35348[(1)]);
if((state_val_35349 === (1))){
var state_35348__$1 = state_35348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35348__$1,(2),once_or_cleanup);
} else {
if((state_val_35349 === (2))){
var inst_35345 = (state_35348[(2)]);
var inst_35346 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35348__$1 = (function (){var statearr_35351 = state_35348;
(statearr_35351[(7)] = inst_35345);

return statearr_35351;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35348__$1,inst_35346);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__30547__auto__ = null;
var shadow$dom$state_machine__30547__auto____0 = (function (){
var statearr_35353 = [null,null,null,null,null,null,null,null];
(statearr_35353[(0)] = shadow$dom$state_machine__30547__auto__);

(statearr_35353[(1)] = (1));

return statearr_35353;
});
var shadow$dom$state_machine__30547__auto____1 = (function (state_35348){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_35348);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e35354){var ex__30550__auto__ = e35354;
var statearr_35355_36430 = state_35348;
(statearr_35355_36430[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_35348[(4)]))){
var statearr_35356_36431 = state_35348;
(statearr_35356_36431[(1)] = cljs.core.first((state_35348[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36432 = state_35348;
state_35348 = G__36432;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
shadow$dom$state_machine__30547__auto__ = function(state_35348){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__30547__auto____0.call(this);
case 1:
return shadow$dom$state_machine__30547__auto____1.call(this,state_35348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__30547__auto____0;
shadow$dom$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__30547__auto____1;
return shadow$dom$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_35359 = f__30754__auto__();
(statearr_35359[(6)] = c__30753__auto___36426);

return statearr_35359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
