goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39842__39843__auto__){
if((!((p1__39842__39843__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39842__39843__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39842__39843__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39842__39843__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39842__39843__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___54600 = schema.utils.use_fn_validation;
var output_schema53372_54601 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53373_54602 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker53374_54603 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53373_54602);
}),null));
var output_checker53375_54604 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53372_54601);
}),null));
var ret__40711__auto___54605 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__53380){
var validate__38094__auto__ = cljs.core.deref(ufv___54600);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54607 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53380], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53387_54608 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53388_54609 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53389_54610 = input_schema53373_54602;
var G__53390_54611 = cljs.core.deref(input_checker53374_54603);
var G__53391_54612 = args__38095__auto___54607;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53387_54608,G__53388_54609,G__53389_54610,G__53390_54611,G__53391_54612) : schema.core.fn_validator.call(null,G__53387_54608,G__53388_54609,G__53389_54610,G__53390_54611,G__53391_54612));
} else {
var temp__5804__auto___54614 = (function (){var fexpr__53392 = cljs.core.deref(input_checker53374_54603);
return (fexpr__53392.cljs$core$IFn$_invoke$arity$1 ? fexpr__53392.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54607) : fexpr__53392.call(null,args__38095__auto___54607));
})();
if(cljs.core.truth_(temp__5804__auto___54614)){
var error__38096__auto___54615 = temp__5804__auto___54614;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54615], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53373_54602,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54607,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54615], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var json = G__53380;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53395_54618 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53396_54619 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53397_54620 = output_schema53372_54601;
var G__53398_54621 = cljs.core.deref(output_checker53375_54604);
var G__53399_54622 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53395_54618,G__53396_54619,G__53397_54620,G__53398_54621,G__53399_54622) : schema.core.fn_validator.call(null,G__53395_54618,G__53396_54619,G__53397_54620,G__53398_54621,G__53399_54622));
} else {
var temp__5804__auto___54623 = (function (){var fexpr__53400 = cljs.core.deref(output_checker53375_54604);
return (fexpr__53400.cljs$core$IFn$_invoke$arity$1 ? fexpr__53400.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53400.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54623)){
var error__38096__auto___54624 = temp__5804__auto___54623;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54624], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53372_54601,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54624], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema53372_54601,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53373_54602], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___54628 = schema.utils.use_fn_validation;
var output_schema53404_54629 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53405_54630 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema53410_54631 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53406_54632 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53405_54630);
}),null));
var output_checker53407_54633 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53404_54629);
}),null));
var input_checker53411_54634 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53410_54631);
}),null));
var output_checker53412_54635 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53404_54629);
}),null));
var ret__40711__auto___54642 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__53419 = arguments.length;
switch (G__53419) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53408,G__53409){
var validate__38094__auto__ = cljs.core.deref(ufv___54628);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54646 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53408,G__53409], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53420_54647 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53421_54648 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53422_54649 = input_schema53405_54630;
var G__53423_54650 = cljs.core.deref(input_checker53406_54632);
var G__53424_54651 = args__38095__auto___54646;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53420_54647,G__53421_54648,G__53422_54649,G__53423_54650,G__53424_54651) : schema.core.fn_validator.call(null,G__53420_54647,G__53421_54648,G__53422_54649,G__53423_54650,G__53424_54651));
} else {
var temp__5804__auto___54653 = (function (){var fexpr__53425 = cljs.core.deref(input_checker53406_54632);
return (fexpr__53425.cljs$core$IFn$_invoke$arity$1 ? fexpr__53425.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54646) : fexpr__53425.call(null,args__38095__auto___54646));
})();
if(cljs.core.truth_(temp__5804__auto___54653)){
var error__38096__auto___54655 = temp__5804__auto___54653;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54655], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53405_54630,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54646,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54655], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var name_kw = G__53408;
var fields = G__53409;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53427_54656 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53428_54657 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53429_54658 = output_schema53404_54629;
var G__53430_54659 = cljs.core.deref(output_checker53407_54633);
var G__53431_54660 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53427_54656,G__53428_54657,G__53429_54658,G__53430_54659,G__53431_54660) : schema.core.fn_validator.call(null,G__53427_54656,G__53428_54657,G__53429_54658,G__53430_54659,G__53431_54660));
} else {
var temp__5804__auto___54661 = (function (){var fexpr__53432 = cljs.core.deref(output_checker53407_54633);
return (fexpr__53432.cljs$core$IFn$_invoke$arity$1 ? fexpr__53432.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53432.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54661)){
var error__38096__auto___54666 = temp__5804__auto___54661;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54666], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53404_54629,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54666], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53413,G__53414,G__53415){
var validate__38094__auto__ = cljs.core.deref(ufv___54628);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54668 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53413,G__53414,G__53415], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53434_54669 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53435_54670 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53436_54671 = input_schema53410_54631;
var G__53437_54672 = cljs.core.deref(input_checker53411_54634);
var G__53438_54673 = args__38095__auto___54668;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53434_54669,G__53435_54670,G__53436_54671,G__53437_54672,G__53438_54673) : schema.core.fn_validator.call(null,G__53434_54669,G__53435_54670,G__53436_54671,G__53437_54672,G__53438_54673));
} else {
var temp__5804__auto___54674 = (function (){var fexpr__53439 = cljs.core.deref(input_checker53411_54634);
return (fexpr__53439.cljs$core$IFn$_invoke$arity$1 ? fexpr__53439.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54668) : fexpr__53439.call(null,args__38095__auto___54668));
})();
if(cljs.core.truth_(temp__5804__auto___54674)){
var error__38096__auto___54676 = temp__5804__auto___54674;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54676], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53410_54631,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54668,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54676], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var name_kw = G__53413;
var docstring = G__53414;
var fields = G__53415;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53440_54680 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53441_54681 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53442_54682 = output_schema53404_54629;
var G__53443_54683 = cljs.core.deref(output_checker53412_54635);
var G__53444_54684 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53440_54680,G__53441_54681,G__53442_54682,G__53443_54683,G__53444_54684) : schema.core.fn_validator.call(null,G__53440_54680,G__53441_54681,G__53442_54682,G__53443_54683,G__53444_54684));
} else {
var temp__5804__auto___54688 = (function (){var fexpr__53445 = cljs.core.deref(output_checker53412_54635);
return (fexpr__53445.cljs$core$IFn$_invoke$arity$1 ? fexpr__53445.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53445.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54688)){
var error__38096__auto___54690 = temp__5804__auto___54688;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54690], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53404_54629,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54690], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema53404_54629,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53405_54630,input_schema53410_54631], null)));

var ufv___54696 = schema.utils.use_fn_validation;
var output_schema53448_54697 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53449_54698 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema53454_54699 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53450_54700 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53449_54698);
}),null));
var output_checker53451_54701 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53448_54697);
}),null));
var input_checker53455_54702 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53454_54699);
}),null));
var output_checker53456_54703 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53448_54697);
}),null));
var ret__40711__auto___54708 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__53471 = arguments.length;
switch (G__53471) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53452,G__53453){
var validate__38094__auto__ = cljs.core.deref(ufv___54696);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54715 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53452,G__53453], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53476_54716 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53477_54717 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53478_54718 = input_schema53449_54698;
var G__53479_54719 = cljs.core.deref(input_checker53450_54700);
var G__53480_54720 = args__38095__auto___54715;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53476_54716,G__53477_54717,G__53478_54718,G__53479_54719,G__53480_54720) : schema.core.fn_validator.call(null,G__53476_54716,G__53477_54717,G__53478_54718,G__53479_54719,G__53480_54720));
} else {
var temp__5804__auto___54722 = (function (){var fexpr__53481 = cljs.core.deref(input_checker53450_54700);
return (fexpr__53481.cljs$core$IFn$_invoke$arity$1 ? fexpr__53481.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54715) : fexpr__53481.call(null,args__38095__auto___54715));
})();
if(cljs.core.truth_(temp__5804__auto___54722)){
var error__38096__auto___54723 = temp__5804__auto___54722;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54723], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53449_54698,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54715,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54723], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var name_kw = G__53452;
var symbol_keywords = G__53453;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53482_54728 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53483_54729 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53484_54730 = output_schema53448_54697;
var G__53485_54731 = cljs.core.deref(output_checker53451_54701);
var G__53486_54732 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53482_54728,G__53483_54729,G__53484_54730,G__53485_54731,G__53486_54732) : schema.core.fn_validator.call(null,G__53482_54728,G__53483_54729,G__53484_54730,G__53485_54731,G__53486_54732));
} else {
var temp__5804__auto___54737 = (function (){var fexpr__53487 = cljs.core.deref(output_checker53451_54701);
return (fexpr__53487.cljs$core$IFn$_invoke$arity$1 ? fexpr__53487.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53487.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54737)){
var error__38096__auto___54740 = temp__5804__auto___54737;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54740], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53448_54697,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54740], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53457,G__53458,G__53459){
var validate__38094__auto__ = cljs.core.deref(ufv___54696);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54743 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53457,G__53458,G__53459], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53488_54744 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53489_54745 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53490_54746 = input_schema53454_54699;
var G__53491_54747 = cljs.core.deref(input_checker53455_54702);
var G__53492_54748 = args__38095__auto___54743;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53488_54744,G__53489_54745,G__53490_54746,G__53491_54747,G__53492_54748) : schema.core.fn_validator.call(null,G__53488_54744,G__53489_54745,G__53490_54746,G__53491_54747,G__53492_54748));
} else {
var temp__5804__auto___54750 = (function (){var fexpr__53497 = cljs.core.deref(input_checker53455_54702);
return (fexpr__53497.cljs$core$IFn$_invoke$arity$1 ? fexpr__53497.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54743) : fexpr__53497.call(null,args__38095__auto___54743));
})();
if(cljs.core.truth_(temp__5804__auto___54750)){
var error__38096__auto___54751 = temp__5804__auto___54750;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54751], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53454_54699,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54743,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54751], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var name_kw = G__53457;
var docstring = G__53458;
var symbol_keywords = G__53459;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53498_54753 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53499_54754 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53500_54755 = output_schema53448_54697;
var G__53501_54756 = cljs.core.deref(output_checker53456_54703);
var G__53502_54757 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53498_54753,G__53499_54754,G__53500_54755,G__53501_54756,G__53502_54757) : schema.core.fn_validator.call(null,G__53498_54753,G__53499_54754,G__53500_54755,G__53501_54756,G__53502_54757));
} else {
var temp__5804__auto___54762 = (function (){var fexpr__53503 = cljs.core.deref(output_checker53456_54703);
return (fexpr__53503.cljs$core$IFn$_invoke$arity$1 ? fexpr__53503.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53503.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54762)){
var error__38096__auto___54763 = temp__5804__auto___54762;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54763], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53448_54697,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54763], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema53448_54697,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53449_54698,input_schema53454_54699], null)));

var ufv___54764 = schema.utils.use_fn_validation;
var output_schema53504_54765 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53505_54766 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53506_54767 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53505_54766);
}),null));
var output_checker53507_54768 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53504_54765);
}),null));
var ret__40711__auto___54770 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__53508,G__53509){
var validate__38094__auto__ = cljs.core.deref(ufv___54764);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54771 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53508,G__53509], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53515_54772 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53516_54773 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53517_54774 = input_schema53505_54766;
var G__53518_54775 = cljs.core.deref(input_checker53506_54767);
var G__53519_54776 = args__38095__auto___54771;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53515_54772,G__53516_54773,G__53517_54774,G__53518_54775,G__53519_54776) : schema.core.fn_validator.call(null,G__53515_54772,G__53516_54773,G__53517_54774,G__53518_54775,G__53519_54776));
} else {
var temp__5804__auto___54782 = (function (){var fexpr__53520 = cljs.core.deref(input_checker53506_54767);
return (fexpr__53520.cljs$core$IFn$_invoke$arity$1 ? fexpr__53520.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54771) : fexpr__53520.call(null,args__38095__auto___54771));
})();
if(cljs.core.truth_(temp__5804__auto___54782)){
var error__38096__auto___54784 = temp__5804__auto___54782;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54784], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53505_54766,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54771,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54784], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var name_kw = G__53508;
var size = G__53509;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53529_54790 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53530_54791 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53531_54792 = output_schema53504_54765;
var G__53532_54793 = cljs.core.deref(output_checker53507_54768);
var G__53533_54794 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53529_54790,G__53530_54791,G__53531_54792,G__53532_54793,G__53533_54794) : schema.core.fn_validator.call(null,G__53529_54790,G__53530_54791,G__53531_54792,G__53532_54793,G__53533_54794));
} else {
var temp__5804__auto___54795 = (function (){var fexpr__53535 = cljs.core.deref(output_checker53507_54768);
return (fexpr__53535.cljs$core$IFn$_invoke$arity$1 ? fexpr__53535.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53535.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54795)){
var error__38096__auto___54796 = temp__5804__auto___54795;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54796], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53504_54765,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54796], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema53504_54765,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53505_54766], null)));

var ufv___54798 = schema.utils.use_fn_validation;
var output_schema53541_54799 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53542_54800 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53543_54801 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53542_54800);
}),null));
var output_checker53544_54802 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53541_54799);
}),null));
var ret__40711__auto___54811 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__53545){
var validate__38094__auto__ = cljs.core.deref(ufv___54798);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54812 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53545], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53551_54813 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53552_54814 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53553_54815 = input_schema53542_54800;
var G__53554_54816 = cljs.core.deref(input_checker53543_54801);
var G__53555_54817 = args__38095__auto___54812;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53551_54813,G__53552_54814,G__53553_54815,G__53554_54816,G__53555_54817) : schema.core.fn_validator.call(null,G__53551_54813,G__53552_54814,G__53553_54815,G__53554_54816,G__53555_54817));
} else {
var temp__5804__auto___54818 = (function (){var fexpr__53556 = cljs.core.deref(input_checker53543_54801);
return (fexpr__53556.cljs$core$IFn$_invoke$arity$1 ? fexpr__53556.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54812) : fexpr__53556.call(null,args__38095__auto___54812));
})();
if(cljs.core.truth_(temp__5804__auto___54818)){
var error__38096__auto___54819 = temp__5804__auto___54818;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54819], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53542_54800,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54812,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54819], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var items_schema = G__53545;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53562_54828 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53563_54829 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53564_54830 = output_schema53541_54799;
var G__53565_54831 = cljs.core.deref(output_checker53544_54802);
var G__53566_54832 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53562_54828,G__53563_54829,G__53564_54830,G__53565_54831,G__53566_54832) : schema.core.fn_validator.call(null,G__53562_54828,G__53563_54829,G__53564_54830,G__53565_54831,G__53566_54832));
} else {
var temp__5804__auto___54834 = (function (){var fexpr__53571 = cljs.core.deref(output_checker53544_54802);
return (fexpr__53571.cljs$core$IFn$_invoke$arity$1 ? fexpr__53571.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53571.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54834)){
var error__38096__auto___54835 = temp__5804__auto___54834;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54835], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53541_54799,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54835], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema53541_54799,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53542_54800], null)));

var ufv___54840 = schema.utils.use_fn_validation;
var output_schema53576_54841 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53579_54842 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53580_54843 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53579_54842);
}),null));
var output_checker53581_54844 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53576_54841);
}),null));
var ret__40711__auto___54846 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__53582){
var validate__38094__auto__ = cljs.core.deref(ufv___54840);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54847 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53582], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53592_54848 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53593_54849 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53594_54850 = input_schema53579_54842;
var G__53595_54851 = cljs.core.deref(input_checker53580_54843);
var G__53596_54852 = args__38095__auto___54847;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53592_54848,G__53593_54849,G__53594_54850,G__53595_54851,G__53596_54852) : schema.core.fn_validator.call(null,G__53592_54848,G__53593_54849,G__53594_54850,G__53595_54851,G__53596_54852));
} else {
var temp__5804__auto___54853 = (function (){var fexpr__53597 = cljs.core.deref(input_checker53580_54843);
return (fexpr__53597.cljs$core$IFn$_invoke$arity$1 ? fexpr__53597.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54847) : fexpr__53597.call(null,args__38095__auto___54847));
})();
if(cljs.core.truth_(temp__5804__auto___54853)){
var error__38096__auto___54854 = temp__5804__auto___54853;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54854], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53579_54842,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54847,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54854], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var values_schema = G__53582;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53605_54857 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53606_54858 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53607_54859 = output_schema53576_54841;
var G__53608_54860 = cljs.core.deref(output_checker53581_54844);
var G__53609_54861 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53605_54857,G__53606_54858,G__53607_54859,G__53608_54860,G__53609_54861) : schema.core.fn_validator.call(null,G__53605_54857,G__53606_54858,G__53607_54859,G__53608_54860,G__53609_54861));
} else {
var temp__5804__auto___54862 = (function (){var fexpr__53610 = cljs.core.deref(output_checker53581_54844);
return (fexpr__53610.cljs$core$IFn$_invoke$arity$1 ? fexpr__53610.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53610.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54862)){
var error__38096__auto___54863 = temp__5804__auto___54862;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53576_54841,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54863], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema53576_54841,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53579_54842], null)));

var ufv___54867 = schema.utils.use_fn_validation;
var output_schema53611_54868 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53612_54869 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker53613_54870 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53612_54869);
}),null));
var output_checker53614_54871 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53611_54868);
}),null));
var ret__40711__auto___54872 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__53615){
var validate__38094__auto__ = cljs.core.deref(ufv___54867);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54873 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53615], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53620_54874 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53621_54875 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53622_54876 = input_schema53612_54869;
var G__53623_54877 = cljs.core.deref(input_checker53613_54870);
var G__53624_54878 = args__38095__auto___54873;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53620_54874,G__53621_54875,G__53622_54876,G__53623_54877,G__53624_54878) : schema.core.fn_validator.call(null,G__53620_54874,G__53621_54875,G__53622_54876,G__53623_54877,G__53624_54878));
} else {
var temp__5804__auto___54880 = (function (){var fexpr__53625 = cljs.core.deref(input_checker53613_54870);
return (fexpr__53625.cljs$core$IFn$_invoke$arity$1 ? fexpr__53625.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54873) : fexpr__53625.call(null,args__38095__auto___54873));
})();
if(cljs.core.truth_(temp__5804__auto___54880)){
var error__38096__auto___54883 = temp__5804__auto___54880;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54883], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53612_54869,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54873,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54883], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var member_schemas = G__53615;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53630_54885 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53631_54886 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53632_54887 = output_schema53611_54868;
var G__53633_54888 = cljs.core.deref(output_checker53614_54871);
var G__53634_54889 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53630_54885,G__53631_54886,G__53632_54887,G__53633_54888,G__53634_54889) : schema.core.fn_validator.call(null,G__53630_54885,G__53631_54886,G__53632_54887,G__53633_54888,G__53634_54889));
} else {
var temp__5804__auto___54891 = (function (){var fexpr__53636 = cljs.core.deref(output_checker53614_54871);
return (fexpr__53636.cljs$core$IFn$_invoke$arity$1 ? fexpr__53636.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53636.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54891)){
var error__38096__auto___54892 = temp__5804__auto___54891;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54892], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53611_54868,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54892], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema53611_54868,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53612_54869], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___54893 = schema.utils.use_fn_validation;
var output_schema53647_54894 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53648_54895 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53649_54896 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53648_54895);
}),null));
var output_checker53650_54897 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53647_54894);
}),null));
var ret__40711__auto___54898 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__53651){
var validate__38094__auto__ = cljs.core.deref(ufv___54893);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54900 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53651], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53658_54901 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53659_54902 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53660_54903 = input_schema53648_54895;
var G__53661_54904 = cljs.core.deref(input_checker53649_54896);
var G__53662_54905 = args__38095__auto___54900;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53658_54901,G__53659_54902,G__53660_54903,G__53661_54904,G__53662_54905) : schema.core.fn_validator.call(null,G__53658_54901,G__53659_54902,G__53660_54903,G__53661_54904,G__53662_54905));
} else {
var temp__5804__auto___54906 = (function (){var fexpr__53667 = cljs.core.deref(input_checker53649_54896);
return (fexpr__53667.cljs$core$IFn$_invoke$arity$1 ? fexpr__53667.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54900) : fexpr__53667.call(null,args__38095__auto___54900));
})();
if(cljs.core.truth_(temp__5804__auto___54906)){
var error__38096__auto___54907 = temp__5804__auto___54906;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54907], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53648_54895,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54900,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54907], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__53651;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53676_54913 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53677_54914 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53678_54915 = output_schema53647_54894;
var G__53679_54916 = cljs.core.deref(output_checker53650_54897);
var G__53680_54917 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53676_54913,G__53677_54914,G__53678_54915,G__53679_54916,G__53680_54917) : schema.core.fn_validator.call(null,G__53676_54913,G__53677_54914,G__53678_54915,G__53679_54916,G__53680_54917));
} else {
var temp__5804__auto___54922 = (function (){var fexpr__53681 = cljs.core.deref(output_checker53650_54897);
return (fexpr__53681.cljs$core$IFn$_invoke$arity$1 ? fexpr__53681.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53681.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54922)){
var error__38096__auto___54926 = temp__5804__auto___54922;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54926], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53647_54894,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54926], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema53647_54894,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53648_54895], null)));

var ufv___54931 = schema.utils.use_fn_validation;
var output_schema53689_54932 = deercreeklabs.baracus.ByteArray;
var input_schema53690_54933 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53691_54934 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53690_54933);
}),null));
var output_checker53692_54936 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53689_54932);
}),null));
var ret__40711__auto___54940 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__53693,G__53694){
var validate__38094__auto__ = cljs.core.deref(ufv___54931);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54941 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53693,G__53694], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53695_54943 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53696_54944 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53697_54945 = input_schema53690_54933;
var G__53698_54946 = cljs.core.deref(input_checker53691_54934);
var G__53699_54947 = args__38095__auto___54941;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53695_54943,G__53696_54944,G__53697_54945,G__53698_54946,G__53699_54947) : schema.core.fn_validator.call(null,G__53695_54943,G__53696_54944,G__53697_54945,G__53698_54946,G__53699_54947));
} else {
var temp__5804__auto___54953 = (function (){var fexpr__53702 = cljs.core.deref(input_checker53691_54934);
return (fexpr__53702.cljs$core$IFn$_invoke$arity$1 ? fexpr__53702.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54941) : fexpr__53702.call(null,args__38095__auto___54941));
})();
if(cljs.core.truth_(temp__5804__auto___54953)){
var error__38096__auto___54954 = temp__5804__auto___54953;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54954], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53690_54933,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54941,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54954], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var writer_schema = G__53693;
var data = G__53694;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53729_54959 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53730_54960 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53731_54961 = output_schema53689_54932;
var G__53732_54962 = cljs.core.deref(output_checker53692_54936);
var G__53733_54963 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53729_54959,G__53730_54960,G__53731_54961,G__53732_54962,G__53733_54963) : schema.core.fn_validator.call(null,G__53729_54959,G__53730_54960,G__53731_54961,G__53732_54962,G__53733_54963));
} else {
var temp__5804__auto___54964 = (function (){var fexpr__53735 = cljs.core.deref(output_checker53692_54936);
return (fexpr__53735.cljs$core$IFn$_invoke$arity$1 ? fexpr__53735.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53735.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54964)){
var error__38096__auto___54965 = temp__5804__auto___54964;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54965], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53689_54932,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54965], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema53689_54932,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53690_54933], null)));

var ufv___54966 = schema.utils.use_fn_validation;
var output_schema53738_54967 = schema.core.Any;
var input_schema53739_54968 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53740_54969 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53739_54968);
}),null));
var output_checker53741_54970 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53738_54967);
}),null));
var ret__40711__auto___54972 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__53742,G__53743,G__53744){
var validate__38094__auto__ = cljs.core.deref(ufv___54966);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___54973 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53742,G__53743,G__53744], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53745_54978 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53746_54979 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53747_54980 = input_schema53739_54968;
var G__53748_54981 = cljs.core.deref(input_checker53740_54969);
var G__53749_54982 = args__38095__auto___54973;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53745_54978,G__53746_54979,G__53747_54980,G__53748_54981,G__53749_54982) : schema.core.fn_validator.call(null,G__53745_54978,G__53746_54979,G__53747_54980,G__53748_54981,G__53749_54982));
} else {
var temp__5804__auto___54987 = (function (){var fexpr__53750 = cljs.core.deref(input_checker53740_54969);
return (fexpr__53750.cljs$core$IFn$_invoke$arity$1 ? fexpr__53750.cljs$core$IFn$_invoke$arity$1(args__38095__auto___54973) : fexpr__53750.call(null,args__38095__auto___54973));
})();
if(cljs.core.truth_(temp__5804__auto___54987)){
var error__38096__auto___54994 = temp__5804__auto___54987;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___54994], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53739_54968,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___54973,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___54994], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var reader_schema = G__53742;
var writer_schema = G__53743;
var ba = G__53744;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53764_55015 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53765_55016 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53766_55017 = output_schema53738_54967;
var G__53767_55018 = cljs.core.deref(output_checker53741_54970);
var G__53768_55019 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53764_55015,G__53765_55016,G__53766_55017,G__53767_55018,G__53768_55019) : schema.core.fn_validator.call(null,G__53764_55015,G__53765_55016,G__53766_55017,G__53767_55018,G__53768_55019));
} else {
var temp__5804__auto___55020 = (function (){var fexpr__53773 = cljs.core.deref(output_checker53741_54970);
return (fexpr__53773.cljs$core$IFn$_invoke$arity$1 ? fexpr__53773.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53773.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55020)){
var error__38096__auto___55021 = temp__5804__auto___55020;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55021], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53738_54967,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55021], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema53738_54967,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53739_54968], null)));

var ufv___55024 = schema.utils.use_fn_validation;
var output_schema53780_55025 = schema.core.Any;
var input_schema53781_55026 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53782_55027 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53781_55026);
}),null));
var output_checker53783_55028 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53780_55025);
}),null));
var ret__40711__auto___55032 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__53784,G__53785){
var validate__38094__auto__ = cljs.core.deref(ufv___55024);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55033 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53784,G__53785], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53807_55034 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53808_55035 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53809_55036 = input_schema53781_55026;
var G__53810_55037 = cljs.core.deref(input_checker53782_55027);
var G__53811_55038 = args__38095__auto___55033;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53807_55034,G__53808_55035,G__53809_55036,G__53810_55037,G__53811_55038) : schema.core.fn_validator.call(null,G__53807_55034,G__53808_55035,G__53809_55036,G__53810_55037,G__53811_55038));
} else {
var temp__5804__auto___55040 = (function (){var fexpr__53817 = cljs.core.deref(input_checker53782_55027);
return (fexpr__53817.cljs$core$IFn$_invoke$arity$1 ? fexpr__53817.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55033) : fexpr__53817.call(null,args__38095__auto___55033));
})();
if(cljs.core.truth_(temp__5804__auto___55040)){
var error__38096__auto___55041 = temp__5804__auto___55040;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55041], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53781_55026,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55033,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55041], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__53784;
var ba = G__53785;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53821_55049 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53822_55050 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53823_55051 = output_schema53780_55025;
var G__53824_55052 = cljs.core.deref(output_checker53783_55028);
var G__53825_55053 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53821_55049,G__53822_55050,G__53823_55051,G__53824_55052,G__53825_55053) : schema.core.fn_validator.call(null,G__53821_55049,G__53822_55050,G__53823_55051,G__53824_55052,G__53825_55053));
} else {
var temp__5804__auto___55056 = (function (){var fexpr__53828 = cljs.core.deref(output_checker53783_55028);
return (fexpr__53828.cljs$core$IFn$_invoke$arity$1 ? fexpr__53828.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53828.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55056)){
var error__38096__auto___55058 = temp__5804__auto___55056;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55058], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53780_55025,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55058], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema53780_55025,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53781_55026], null)));

var ufv___55062 = schema.utils.use_fn_validation;
var output_schema53836_55063 = schema.core.Any;
var input_schema53838_55064 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53839_55065 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53838_55064);
}),null));
var output_checker53840_55066 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53836_55063);
}),null));
var ret__40711__auto___55067 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__53841){
var validate__38094__auto__ = cljs.core.deref(ufv___55062);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55068 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53841], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53871_55069 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53872_55070 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53873_55071 = input_schema53838_55064;
var G__53874_55072 = cljs.core.deref(input_checker53839_55065);
var G__53875_55073 = args__38095__auto___55068;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53871_55069,G__53872_55070,G__53873_55071,G__53874_55072,G__53875_55073) : schema.core.fn_validator.call(null,G__53871_55069,G__53872_55070,G__53873_55071,G__53874_55072,G__53875_55073));
} else {
var temp__5804__auto___55076 = (function (){var fexpr__53881 = cljs.core.deref(input_checker53839_55065);
return (fexpr__53881.cljs$core$IFn$_invoke$arity$1 ? fexpr__53881.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55068) : fexpr__53881.call(null,args__38095__auto___55068));
})();
if(cljs.core.truth_(temp__5804__auto___55076)){
var error__38096__auto___55082 = temp__5804__auto___55076;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55082], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53838_55064,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55068,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55082], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__53841;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53883_55090 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53884_55091 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53885_55092 = output_schema53836_55063;
var G__53886_55093 = cljs.core.deref(output_checker53840_55066);
var G__53887_55094 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53883_55090,G__53884_55091,G__53885_55092,G__53886_55093,G__53887_55094) : schema.core.fn_validator.call(null,G__53883_55090,G__53884_55091,G__53885_55092,G__53886_55093,G__53887_55094));
} else {
var temp__5804__auto___55096 = (function (){var fexpr__53890 = cljs.core.deref(output_checker53840_55066);
return (fexpr__53890.cljs$core$IFn$_invoke$arity$1 ? fexpr__53890.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53890.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55096)){
var error__38096__auto___55097 = temp__5804__auto___55096;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55097], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53836_55063,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55097], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema53836_55063,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53838_55064], null)));

var ufv___55099 = schema.utils.use_fn_validation;
var output_schema53896_55100 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53897_55101 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53898_55102 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53897_55101);
}),null));
var output_checker53899_55103 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53896_55100);
}),null));
var ret__40711__auto___55104 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__53901){
var validate__38094__auto__ = cljs.core.deref(ufv___55099);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55105 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53901], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53904_55106 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53905_55107 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53906_55108 = input_schema53897_55101;
var G__53907_55109 = cljs.core.deref(input_checker53898_55102);
var G__53908_55110 = args__38095__auto___55105;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53904_55106,G__53905_55107,G__53906_55108,G__53907_55109,G__53908_55110) : schema.core.fn_validator.call(null,G__53904_55106,G__53905_55107,G__53906_55108,G__53907_55109,G__53908_55110));
} else {
var temp__5804__auto___55113 = (function (){var fexpr__53912 = cljs.core.deref(input_checker53898_55102);
return (fexpr__53912.cljs$core$IFn$_invoke$arity$1 ? fexpr__53912.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55105) : fexpr__53912.call(null,args__38095__auto___55105));
})();
if(cljs.core.truth_(temp__5804__auto___55113)){
var error__38096__auto___55115 = temp__5804__auto___55113;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55115], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53897_55101,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55105,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55115], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var edn = G__53901;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53915_55117 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53916_55118 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53917_55119 = output_schema53896_55100;
var G__53918_55120 = cljs.core.deref(output_checker53899_55103);
var G__53919_55121 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53915_55117,G__53916_55118,G__53917_55119,G__53918_55120,G__53919_55121) : schema.core.fn_validator.call(null,G__53915_55117,G__53916_55118,G__53917_55119,G__53918_55120,G__53919_55121));
} else {
var temp__5804__auto___55127 = (function (){var fexpr__53920 = cljs.core.deref(output_checker53899_55103);
return (fexpr__53920.cljs$core$IFn$_invoke$arity$1 ? fexpr__53920.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53920.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55127)){
var error__38096__auto___55130 = temp__5804__auto___55127;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55130], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53896_55100,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55130], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema53896_55100,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53897_55101], null)));

var ufv___55134 = schema.utils.use_fn_validation;
var output_schema53923_55135 = schema.core.Str;
var input_schema53924_55136 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53925_55137 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53924_55136);
}),null));
var output_checker53926_55138 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53923_55135);
}),null));
var ret__40711__auto___55142 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__53927){
var validate__38094__auto__ = cljs.core.deref(ufv___55134);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55146 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53927], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53933_55147 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53934_55148 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53935_55149 = input_schema53924_55136;
var G__53936_55150 = cljs.core.deref(input_checker53925_55137);
var G__53937_55151 = args__38095__auto___55146;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53933_55147,G__53934_55148,G__53935_55149,G__53936_55150,G__53937_55151) : schema.core.fn_validator.call(null,G__53933_55147,G__53934_55148,G__53935_55149,G__53936_55150,G__53937_55151));
} else {
var temp__5804__auto___55153 = (function (){var fexpr__53938 = cljs.core.deref(input_checker53925_55137);
return (fexpr__53938.cljs$core$IFn$_invoke$arity$1 ? fexpr__53938.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55146) : fexpr__53938.call(null,args__38095__auto___55146));
})();
if(cljs.core.truth_(temp__5804__auto___55153)){
var error__38096__auto___55154 = temp__5804__auto___55153;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55154], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53924_55136,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55146,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55154], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__53927;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53941_55156 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53942_55157 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53943_55158 = output_schema53923_55135;
var G__53944_55159 = cljs.core.deref(output_checker53926_55138);
var G__53945_55160 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53941_55156,G__53942_55157,G__53943_55158,G__53944_55159,G__53945_55160) : schema.core.fn_validator.call(null,G__53941_55156,G__53942_55157,G__53943_55158,G__53944_55159,G__53945_55160));
} else {
var temp__5804__auto___55164 = (function (){var fexpr__53946 = cljs.core.deref(output_checker53926_55138);
return (fexpr__53946.cljs$core$IFn$_invoke$arity$1 ? fexpr__53946.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53946.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55164)){
var error__38096__auto___55166 = temp__5804__auto___55164;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55166], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53923_55135,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55166], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema53923_55135,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53924_55136], null)));

var ufv___55174 = schema.utils.use_fn_validation;
var output_schema53951_55175 = schema.core.Keyword;
var input_schema53952_55176 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53953_55178 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53952_55176);
}),null));
var output_checker53954_55179 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53951_55175);
}),null));
var ret__40711__auto___55180 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__53955){
var validate__38094__auto__ = cljs.core.deref(ufv___55174);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55181 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53955], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53959_55182 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53960_55183 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53961_55184 = input_schema53952_55176;
var G__53962_55185 = cljs.core.deref(input_checker53953_55178);
var G__53963_55186 = args__38095__auto___55181;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53959_55182,G__53960_55183,G__53961_55184,G__53962_55185,G__53963_55186) : schema.core.fn_validator.call(null,G__53959_55182,G__53960_55183,G__53961_55184,G__53962_55185,G__53963_55186));
} else {
var temp__5804__auto___55187 = (function (){var fexpr__53965 = cljs.core.deref(input_checker53953_55178);
return (fexpr__53965.cljs$core$IFn$_invoke$arity$1 ? fexpr__53965.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55181) : fexpr__53965.call(null,args__38095__auto___55181));
})();
if(cljs.core.truth_(temp__5804__auto___55187)){
var error__38096__auto___55188 = temp__5804__auto___55187;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55188], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53952_55176,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55181,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55188], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__53955;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53967_55195 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53968_55196 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53969_55197 = output_schema53951_55175;
var G__53970_55198 = cljs.core.deref(output_checker53954_55179);
var G__53971_55199 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53967_55195,G__53968_55196,G__53969_55197,G__53970_55198,G__53971_55199) : schema.core.fn_validator.call(null,G__53967_55195,G__53968_55196,G__53969_55197,G__53970_55198,G__53971_55199));
} else {
var temp__5804__auto___55200 = (function (){var fexpr__53975 = cljs.core.deref(output_checker53954_55179);
return (fexpr__53975.cljs$core$IFn$_invoke$arity$1 ? fexpr__53975.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__53975.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55200)){
var error__38096__auto___55201 = temp__5804__auto___55200;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55201], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53951_55175,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55201], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema53951_55175,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53952_55176], null)));

var ufv___55208 = schema.utils.use_fn_validation;
var output_schema53978_55209 = schema.core.Str;
var input_schema53979_55210 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53980_55211 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53979_55210);
}),null));
var output_checker53981_55212 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53978_55209);
}),null));
var ret__40711__auto___55213 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__53982){
var validate__38094__auto__ = cljs.core.deref(ufv___55208);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55214 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53982], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53986_55215 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53987_55216 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53988_55217 = input_schema53979_55210;
var G__53989_55218 = cljs.core.deref(input_checker53980_55211);
var G__53990_55219 = args__38095__auto___55214;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53986_55215,G__53987_55216,G__53988_55217,G__53989_55218,G__53990_55219) : schema.core.fn_validator.call(null,G__53986_55215,G__53987_55216,G__53988_55217,G__53989_55218,G__53990_55219));
} else {
var temp__5804__auto___55223 = (function (){var fexpr__53995 = cljs.core.deref(input_checker53980_55211);
return (fexpr__53995.cljs$core$IFn$_invoke$arity$1 ? fexpr__53995.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55214) : fexpr__53995.call(null,args__38095__auto___55214));
})();
if(cljs.core.truth_(temp__5804__auto___55223)){
var error__38096__auto___55224 = temp__5804__auto___55223;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55224], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53979_55210,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55214,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55224], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__53982;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53997_55228 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53998_55229 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53999_55230 = output_schema53978_55209;
var G__54000_55231 = cljs.core.deref(output_checker53981_55212);
var G__54001_55232 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53997_55228,G__53998_55229,G__53999_55230,G__54000_55231,G__54001_55232) : schema.core.fn_validator.call(null,G__53997_55228,G__53998_55229,G__53999_55230,G__54000_55231,G__54001_55232));
} else {
var temp__5804__auto___55233 = (function (){var fexpr__54004 = cljs.core.deref(output_checker53981_55212);
return (fexpr__54004.cljs$core$IFn$_invoke$arity$1 ? fexpr__54004.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54004.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55233)){
var error__38096__auto___55234 = temp__5804__auto___55233;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55234], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53978_55209,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55234], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema53978_55209,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53979_55210], null)));

var ufv___55235 = schema.utils.use_fn_validation;
var output_schema54010_55236 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema54011_55237 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54012_55238 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54011_55237);
}),null));
var output_checker54013_55239 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54010_55236);
}),null));
var ret__40711__auto___55240 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__54014){
var validate__38094__auto__ = cljs.core.deref(ufv___55235);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55242 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54014], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54018_55243 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54019_55244 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54020_55245 = input_schema54011_55237;
var G__54021_55246 = cljs.core.deref(input_checker54012_55238);
var G__54022_55247 = args__38095__auto___55242;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54018_55243,G__54019_55244,G__54020_55245,G__54021_55246,G__54022_55247) : schema.core.fn_validator.call(null,G__54018_55243,G__54019_55244,G__54020_55245,G__54021_55246,G__54022_55247));
} else {
var temp__5804__auto___55251 = (function (){var fexpr__54024 = cljs.core.deref(input_checker54012_55238);
return (fexpr__54024.cljs$core$IFn$_invoke$arity$1 ? fexpr__54024.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55242) : fexpr__54024.call(null,args__38095__auto___55242));
})();
if(cljs.core.truth_(temp__5804__auto___55251)){
var error__38096__auto___55252 = temp__5804__auto___55251;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55252], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54011_55237,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55242,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55252], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54014;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54026_55254 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54027_55255 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54028_55256 = output_schema54010_55236;
var G__54029_55257 = cljs.core.deref(output_checker54013_55239);
var G__54030_55258 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54026_55254,G__54027_55255,G__54028_55256,G__54029_55257,G__54030_55258) : schema.core.fn_validator.call(null,G__54026_55254,G__54027_55255,G__54028_55256,G__54029_55257,G__54030_55258));
} else {
var temp__5804__auto___55259 = (function (){var fexpr__54031 = cljs.core.deref(output_checker54013_55239);
return (fexpr__54031.cljs$core$IFn$_invoke$arity$1 ? fexpr__54031.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54031.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55259)){
var error__38096__auto___55260 = temp__5804__auto___55259;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55260], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54010_55236,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55260], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema54010_55236,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54011_55237], null)));

var ufv___55262 = schema.utils.use_fn_validation;
var output_schema54037_55263 = deercreeklabs.baracus.ByteArray;
var input_schema54038_55264 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54039_55265 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54038_55264);
}),null));
var output_checker54040_55266 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54037_55263);
}),null));
var ret__40711__auto___55268 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__54042){
var validate__38094__auto__ = cljs.core.deref(ufv___55262);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55271 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54042], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54047_55272 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54048_55273 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54049_55274 = input_schema54038_55264;
var G__54050_55275 = cljs.core.deref(input_checker54039_55265);
var G__54051_55276 = args__38095__auto___55271;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54047_55272,G__54048_55273,G__54049_55274,G__54050_55275,G__54051_55276) : schema.core.fn_validator.call(null,G__54047_55272,G__54048_55273,G__54049_55274,G__54050_55275,G__54051_55276));
} else {
var temp__5804__auto___55280 = (function (){var fexpr__54055 = cljs.core.deref(input_checker54039_55265);
return (fexpr__54055.cljs$core$IFn$_invoke$arity$1 ? fexpr__54055.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55271) : fexpr__54055.call(null,args__38095__auto___55271));
})();
if(cljs.core.truth_(temp__5804__auto___55280)){
var error__38096__auto___55281 = temp__5804__auto___55280;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55281], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54038_55264,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55271,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55281], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54042;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54058_55286 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54059_55287 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54060_55288 = output_schema54037_55263;
var G__54061_55289 = cljs.core.deref(output_checker54040_55266);
var G__54062_55290 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54058_55286,G__54059_55287,G__54060_55288,G__54061_55289,G__54062_55290) : schema.core.fn_validator.call(null,G__54058_55286,G__54059_55287,G__54060_55288,G__54061_55289,G__54062_55290));
} else {
var temp__5804__auto___55294 = (function (){var fexpr__54066 = cljs.core.deref(output_checker54040_55266);
return (fexpr__54066.cljs$core$IFn$_invoke$arity$1 ? fexpr__54066.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54066.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55294)){
var error__38096__auto___55295 = temp__5804__auto___55294;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55295], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54037_55263,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55295], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema54037_55263,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54038_55264], null)));

var ufv___55300 = schema.utils.use_fn_validation;
var output_schema54070_55301 = deercreeklabs.baracus.ByteArray;
var input_schema54071_55302 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54072_55303 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54071_55302);
}),null));
var output_checker54073_55304 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54070_55301);
}),null));
var ret__40711__auto___55308 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__54074){
var validate__38094__auto__ = cljs.core.deref(ufv___55300);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54074], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54082_55311 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54083_55312 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54084_55313 = input_schema54071_55302;
var G__54085_55314 = cljs.core.deref(input_checker54072_55303);
var G__54086_55315 = args__38095__auto___55310;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54082_55311,G__54083_55312,G__54084_55313,G__54085_55314,G__54086_55315) : schema.core.fn_validator.call(null,G__54082_55311,G__54083_55312,G__54084_55313,G__54085_55314,G__54086_55315));
} else {
var temp__5804__auto___55317 = (function (){var fexpr__54090 = cljs.core.deref(input_checker54072_55303);
return (fexpr__54090.cljs$core$IFn$_invoke$arity$1 ? fexpr__54090.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55310) : fexpr__54090.call(null,args__38095__auto___55310));
})();
if(cljs.core.truth_(temp__5804__auto___55317)){
var error__38096__auto___55318 = temp__5804__auto___55317;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55318], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54071_55302,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55310,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55318], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54074;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54092_55322 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54093_55323 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54094_55324 = output_schema54070_55301;
var G__54095_55325 = cljs.core.deref(output_checker54073_55304);
var G__54096_55326 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54092_55322,G__54093_55323,G__54094_55324,G__54095_55325,G__54096_55326) : schema.core.fn_validator.call(null,G__54092_55322,G__54093_55323,G__54094_55324,G__54095_55325,G__54096_55326));
} else {
var temp__5804__auto___55328 = (function (){var fexpr__54099 = cljs.core.deref(output_checker54073_55304);
return (fexpr__54099.cljs$core$IFn$_invoke$arity$1 ? fexpr__54099.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54099.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55328)){
var error__38096__auto___55330 = temp__5804__auto___55328;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55330], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54070_55301,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55330], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema54070_55301,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54071_55302], null)));

var ufv___55335 = schema.utils.use_fn_validation;
var output_schema54105_55336 = schema.core.Bool;
var input_schema54106_55337 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker54107_55338 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54106_55337);
}),null));
var output_checker54108_55339 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54105_55336);
}),null));
var ret__40711__auto___55343 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__54109){
var validate__38094__auto__ = cljs.core.deref(ufv___55335);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55344 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54109], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54117_55345 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54118_55346 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__54119_55347 = input_schema54106_55337;
var G__54120_55348 = cljs.core.deref(input_checker54107_55338);
var G__54121_55349 = args__38095__auto___55344;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54117_55345,G__54118_55346,G__54119_55347,G__54120_55348,G__54121_55349) : schema.core.fn_validator.call(null,G__54117_55345,G__54118_55346,G__54119_55347,G__54120_55348,G__54121_55349));
} else {
var temp__5804__auto___55352 = (function (){var fexpr__54122 = cljs.core.deref(input_checker54107_55338);
return (fexpr__54122.cljs$core$IFn$_invoke$arity$1 ? fexpr__54122.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55344) : fexpr__54122.call(null,args__38095__auto___55344));
})();
if(cljs.core.truth_(temp__5804__auto___55352)){
var error__38096__auto___55353 = temp__5804__auto___55352;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55353], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54106_55337,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55344,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55353], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var arg = G__54109;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54130_55360 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54131_55361 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__54132_55362 = output_schema54105_55336;
var G__54133_55363 = cljs.core.deref(output_checker54108_55339);
var G__54134_55364 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54130_55360,G__54131_55361,G__54132_55362,G__54133_55363,G__54134_55364) : schema.core.fn_validator.call(null,G__54130_55360,G__54131_55361,G__54132_55362,G__54133_55363,G__54134_55364));
} else {
var temp__5804__auto___55369 = (function (){var fexpr__54141 = cljs.core.deref(output_checker54108_55339);
return (fexpr__54141.cljs$core$IFn$_invoke$arity$1 ? fexpr__54141.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54141.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55369)){
var error__38096__auto___55371 = temp__5804__auto___55369;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55371], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54105_55336,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55371], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema54105_55336,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54106_55337], null)));

var ufv___55372 = schema.utils.use_fn_validation;
var output_schema54151_55373 = schema.core.Bool;
var input_schema54152_55374 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54153_55375 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54152_55374);
}),null));
var output_checker54154_55376 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54151_55373);
}),null));
var ret__40711__auto___55379 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__54155,G__54156){
var validate__38094__auto__ = cljs.core.deref(ufv___55372);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55382 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54155,G__54156], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54170_55383 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54171_55384 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__54172_55385 = input_schema54152_55374;
var G__54173_55386 = cljs.core.deref(input_checker54153_55375);
var G__54174_55387 = args__38095__auto___55382;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54170_55383,G__54171_55384,G__54172_55385,G__54173_55386,G__54174_55387) : schema.core.fn_validator.call(null,G__54170_55383,G__54171_55384,G__54172_55385,G__54173_55386,G__54174_55387));
} else {
var temp__5804__auto___55388 = (function (){var fexpr__54175 = cljs.core.deref(input_checker54153_55375);
return (fexpr__54175.cljs$core$IFn$_invoke$arity$1 ? fexpr__54175.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55382) : fexpr__54175.call(null,args__38095__auto___55382));
})();
if(cljs.core.truth_(temp__5804__auto___55388)){
var error__38096__auto___55389 = temp__5804__auto___55388;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55389], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54152_55374,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55382,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55389], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var reader_schema = G__54155;
var writer_schema = G__54156;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54183_55404 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54184_55405 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__54185_55406 = output_schema54151_55373;
var G__54186_55407 = cljs.core.deref(output_checker54154_55376);
var G__54187_55408 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54183_55404,G__54184_55405,G__54185_55406,G__54186_55407,G__54187_55408) : schema.core.fn_validator.call(null,G__54183_55404,G__54184_55405,G__54185_55406,G__54186_55407,G__54187_55408));
} else {
var temp__5804__auto___55416 = (function (){var fexpr__54189 = cljs.core.deref(output_checker54154_55376);
return (fexpr__54189.cljs$core$IFn$_invoke$arity$1 ? fexpr__54189.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54189.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55416)){
var error__38096__auto___55419 = temp__5804__auto___55416;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55419], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54151_55373,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55419], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema54151_55373,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54152_55374], null)));

var ufv___55423 = schema.utils.use_fn_validation;
var output_schema54193_55424 = schema.core.Any;
var input_schema54194_55425 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54195_55426 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54194_55425);
}),null));
var output_checker54196_55427 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54193_55424);
}),null));
var ret__40711__auto___55434 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__54197){
var validate__38094__auto__ = cljs.core.deref(ufv___55423);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55436 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54197], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54204_55437 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54205_55438 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__54206_55439 = input_schema54194_55425;
var G__54207_55440 = cljs.core.deref(input_checker54195_55426);
var G__54208_55441 = args__38095__auto___55436;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54204_55437,G__54205_55438,G__54206_55439,G__54207_55440,G__54208_55441) : schema.core.fn_validator.call(null,G__54204_55437,G__54205_55438,G__54206_55439,G__54207_55440,G__54208_55441));
} else {
var temp__5804__auto___55443 = (function (){var fexpr__54211 = cljs.core.deref(input_checker54195_55426);
return (fexpr__54211.cljs$core$IFn$_invoke$arity$1 ? fexpr__54211.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55436) : fexpr__54211.call(null,args__38095__auto___55436));
})();
if(cljs.core.truth_(temp__5804__auto___55443)){
var error__38096__auto___55447 = temp__5804__auto___55443;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55447], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54194_55425,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55436,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55447], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54197;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54214_55455 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54215_55456 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__54216_55457 = output_schema54193_55424;
var G__54217_55458 = cljs.core.deref(output_checker54196_55427);
var G__54218_55459 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54214_55455,G__54215_55456,G__54216_55457,G__54217_55458,G__54218_55459) : schema.core.fn_validator.call(null,G__54214_55455,G__54215_55456,G__54216_55457,G__54217_55458,G__54218_55459));
} else {
var temp__5804__auto___55460 = (function (){var fexpr__54219 = cljs.core.deref(output_checker54196_55427);
return (fexpr__54219.cljs$core$IFn$_invoke$arity$1 ? fexpr__54219.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54219.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55460)){
var error__38096__auto___55462 = temp__5804__auto___55460;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55462], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54193_55424,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55462], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema54193_55424,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54194_55425], null)));

var ufv___55466 = schema.utils.use_fn_validation;
var output_schema54226_55467 = schema.core.Any;
var input_schema54227_55468 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54228_55469 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54227_55468);
}),null));
var output_checker54229_55470 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54226_55467);
}),null));
var ret__40711__auto___55472 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__54231){
var validate__38094__auto__ = cljs.core.deref(ufv___55466);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55474 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54231], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54236_55476 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54237_55477 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__54238_55478 = input_schema54227_55468;
var G__54239_55479 = cljs.core.deref(input_checker54228_55469);
var G__54240_55480 = args__38095__auto___55474;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54236_55476,G__54237_55477,G__54238_55478,G__54239_55479,G__54240_55480) : schema.core.fn_validator.call(null,G__54236_55476,G__54237_55477,G__54238_55478,G__54239_55479,G__54240_55480));
} else {
var temp__5804__auto___55484 = (function (){var fexpr__54241 = cljs.core.deref(input_checker54228_55469);
return (fexpr__54241.cljs$core$IFn$_invoke$arity$1 ? fexpr__54241.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55474) : fexpr__54241.call(null,args__38095__auto___55474));
})();
if(cljs.core.truth_(temp__5804__auto___55484)){
var error__38096__auto___55485 = temp__5804__auto___55484;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55485], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54227_55468,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55474,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55485], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54231;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54247_55496 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54248_55497 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__54249_55498 = output_schema54226_55467;
var G__54250_55499 = cljs.core.deref(output_checker54229_55470);
var G__54251_55500 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54247_55496,G__54248_55497,G__54249_55498,G__54250_55499,G__54251_55500) : schema.core.fn_validator.call(null,G__54247_55496,G__54248_55497,G__54249_55498,G__54250_55499,G__54251_55500));
} else {
var temp__5804__auto___55501 = (function (){var fexpr__54253 = cljs.core.deref(output_checker54229_55470);
return (fexpr__54253.cljs$core$IFn$_invoke$arity$1 ? fexpr__54253.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54253.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55501)){
var error__38096__auto___55502 = temp__5804__auto___55501;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55502], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54226_55467,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55502], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema54226_55467,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54227_55468], null)));

var ufv___55511 = schema.utils.use_fn_validation;
var output_schema54254_55512 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54255_55513 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema54260_55514 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker54256_55515 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54255_55513);
}),null));
var output_checker54257_55516 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54254_55512);
}),null));
var input_checker54261_55517 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54260_55514);
}),null));
var output_checker54262_55518 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54254_55512);
}),null));
var ret__40711__auto___55520 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__54268 = arguments.length;
switch (G__54268) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__54258){
var validate__38094__auto__ = cljs.core.deref(ufv___55511);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55523 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54258], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54272_55525 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54273_55526 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54274_55527 = input_schema54255_55513;
var G__54275_55528 = cljs.core.deref(input_checker54256_55515);
var G__54276_55529 = args__38095__auto___55523;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54272_55525,G__54273_55526,G__54274_55527,G__54275_55528,G__54276_55529) : schema.core.fn_validator.call(null,G__54272_55525,G__54273_55526,G__54274_55527,G__54275_55528,G__54276_55529));
} else {
var temp__5804__auto___55533 = (function (){var fexpr__54280 = cljs.core.deref(input_checker54256_55515);
return (fexpr__54280.cljs$core$IFn$_invoke$arity$1 ? fexpr__54280.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55523) : fexpr__54280.call(null,args__38095__auto___55523));
})();
if(cljs.core.truth_(temp__5804__auto___55533)){
var error__38096__auto___55534 = temp__5804__auto___55533;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55534], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54255_55513,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55523,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55534], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54258;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54283_55545 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54284_55546 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54285_55547 = output_schema54254_55512;
var G__54286_55548 = cljs.core.deref(output_checker54257_55516);
var G__54287_55549 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54283_55545,G__54284_55546,G__54285_55547,G__54286_55548,G__54287_55549) : schema.core.fn_validator.call(null,G__54283_55545,G__54284_55546,G__54285_55547,G__54286_55548,G__54287_55549));
} else {
var temp__5804__auto___55550 = (function (){var fexpr__54289 = cljs.core.deref(output_checker54257_55516);
return (fexpr__54289.cljs$core$IFn$_invoke$arity$1 ? fexpr__54289.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54289.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55550)){
var error__38096__auto___55551 = temp__5804__auto___55550;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55551], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54254_55512,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55551], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__54263,G__54264){
var validate__38094__auto__ = cljs.core.deref(ufv___55511);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55556 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54263,G__54264], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54291_55557 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54292_55558 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54293_55559 = input_schema54260_55514;
var G__54294_55560 = cljs.core.deref(input_checker54261_55517);
var G__54295_55561 = args__38095__auto___55556;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54291_55557,G__54292_55558,G__54293_55559,G__54294_55560,G__54295_55561) : schema.core.fn_validator.call(null,G__54291_55557,G__54292_55558,G__54293_55559,G__54294_55560,G__54295_55561));
} else {
var temp__5804__auto___55565 = (function (){var fexpr__54297 = cljs.core.deref(input_checker54261_55517);
return (fexpr__54297.cljs$core$IFn$_invoke$arity$1 ? fexpr__54297.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55556) : fexpr__54297.call(null,args__38095__auto___55556));
})();
if(cljs.core.truth_(temp__5804__auto___55565)){
var error__38096__auto___55568 = temp__5804__auto___55565;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55568], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54260_55514,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55556,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55568], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54263;
var field_kw_or_branch_i = G__54264;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54301_55573 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54302_55574 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54303_55575 = output_schema54254_55512;
var G__54304_55576 = cljs.core.deref(output_checker54262_55518);
var G__54305_55577 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54301_55573,G__54302_55574,G__54303_55575,G__54304_55576,G__54305_55577) : schema.core.fn_validator.call(null,G__54301_55573,G__54302_55574,G__54303_55575,G__54304_55576,G__54305_55577));
} else {
var temp__5804__auto___55578 = (function (){var fexpr__54306 = cljs.core.deref(output_checker54262_55518);
return (fexpr__54306.cljs$core$IFn$_invoke$arity$1 ? fexpr__54306.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54306.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55578)){
var error__38096__auto___55581 = temp__5804__auto___55578;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55581], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54254_55512,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55581], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema54254_55512,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54255_55513,input_schema54260_55514], null)));

var ufv___55587 = schema.utils.use_fn_validation;
var output_schema54311_55588 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema54312_55589 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema54317_55590 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker54313_55591 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54312_55589);
}),null));
var output_checker54314_55592 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54311_55588);
}),null));
var input_checker54318_55593 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54317_55590);
}),null));
var output_checker54319_55594 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54311_55588);
}),null));
var ret__40711__auto___55603 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__54339 = arguments.length;
switch (G__54339) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__54315,G__54316){
var validate__38094__auto__ = cljs.core.deref(ufv___55587);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55607 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54315,G__54316], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54344_55608 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54345_55609 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54346_55610 = input_schema54312_55589;
var G__54347_55611 = cljs.core.deref(input_checker54313_55591);
var G__54348_55612 = args__38095__auto___55607;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54344_55608,G__54345_55609,G__54346_55610,G__54347_55611,G__54348_55612) : schema.core.fn_validator.call(null,G__54344_55608,G__54345_55609,G__54346_55610,G__54347_55611,G__54348_55612));
} else {
var temp__5804__auto___55617 = (function (){var fexpr__54353 = cljs.core.deref(input_checker54313_55591);
return (fexpr__54353.cljs$core$IFn$_invoke$arity$1 ? fexpr__54353.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55607) : fexpr__54353.call(null,args__38095__auto___55607));
})();
if(cljs.core.truth_(temp__5804__auto___55617)){
var error__38096__auto___55618 = temp__5804__auto___55617;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55618], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54312_55589,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55607,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55618], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54315;
var path = G__54316;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54354_55621 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54355_55622 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54356_55623 = output_schema54311_55588;
var G__54357_55624 = cljs.core.deref(output_checker54314_55592);
var G__54358_55625 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54354_55621,G__54355_55622,G__54356_55623,G__54357_55624,G__54358_55625) : schema.core.fn_validator.call(null,G__54354_55621,G__54355_55622,G__54356_55623,G__54357_55624,G__54358_55625));
} else {
var temp__5804__auto___55630 = (function (){var fexpr__54360 = cljs.core.deref(output_checker54314_55592);
return (fexpr__54360.cljs$core$IFn$_invoke$arity$1 ? fexpr__54360.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54360.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55630)){
var error__38096__auto___55632 = temp__5804__auto___55630;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55632], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54311_55588,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55632], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__54320,G__54321,G__54322){
var validate__38094__auto__ = cljs.core.deref(ufv___55587);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55637 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54320,G__54321,G__54322], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54366_55638 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54367_55639 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54368_55640 = input_schema54317_55590;
var G__54369_55641 = cljs.core.deref(input_checker54318_55593);
var G__54370_55642 = args__38095__auto___55637;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54366_55638,G__54367_55639,G__54368_55640,G__54369_55641,G__54370_55642) : schema.core.fn_validator.call(null,G__54366_55638,G__54367_55639,G__54368_55640,G__54369_55641,G__54370_55642));
} else {
var temp__5804__auto___55643 = (function (){var fexpr__54371 = cljs.core.deref(input_checker54318_55593);
return (fexpr__54371.cljs$core$IFn$_invoke$arity$1 ? fexpr__54371.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55637) : fexpr__54371.call(null,args__38095__auto___55637));
})();
if(cljs.core.truth_(temp__5804__auto___55643)){
var error__38096__auto___55644 = temp__5804__auto___55643;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55644], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54317_55590,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55637,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55644], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54320;
var path = G__54321;
var G__54374 = G__54322;
var map__54375 = G__54374;
var map__54375__$1 = cljs.core.__destructure_map(map__54375);
var opts = map__54375__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54375__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__54374__$1 = G__54374;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__54376 = G__54374__$1;
var map__54376__$1 = cljs.core.__destructure_map(map__54376);
var opts__$1 = map__54376__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54376__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54389_55656 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54390_55657 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54391_55658 = output_schema54311_55588;
var G__54392_55659 = cljs.core.deref(output_checker54319_55594);
var G__54393_55660 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54389_55656,G__54390_55657,G__54391_55658,G__54392_55659,G__54393_55660) : schema.core.fn_validator.call(null,G__54389_55656,G__54390_55657,G__54391_55658,G__54392_55659,G__54393_55660));
} else {
var temp__5804__auto___55662 = (function (){var fexpr__54397 = cljs.core.deref(output_checker54319_55594);
return (fexpr__54397.cljs$core$IFn$_invoke$arity$1 ? fexpr__54397.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54397.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55662)){
var error__38096__auto___55666 = temp__5804__auto___55662;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55666], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54311_55588,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55666], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema54311_55588,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54312_55589,input_schema54317_55590], null)));

var ufv___55677 = schema.utils.use_fn_validation;
var output_schema54404_55678 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema54405_55680 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54406_55681 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54405_55680);
}),null));
var output_checker54407_55682 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54404_55678);
}),null));
var ret__40711__auto___55686 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__54408){
var validate__38094__auto__ = cljs.core.deref(ufv___55677);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55689 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54408], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54417_55691 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54418_55692 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__54419_55693 = input_schema54405_55680;
var G__54420_55694 = cljs.core.deref(input_checker54406_55681);
var G__54421_55695 = args__38095__auto___55689;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54417_55691,G__54418_55692,G__54419_55693,G__54420_55694,G__54421_55695) : schema.core.fn_validator.call(null,G__54417_55691,G__54418_55692,G__54419_55693,G__54420_55694,G__54421_55695));
} else {
var temp__5804__auto___55697 = (function (){var fexpr__54429 = cljs.core.deref(input_checker54406_55681);
return (fexpr__54429.cljs$core$IFn$_invoke$arity$1 ? fexpr__54429.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55689) : fexpr__54429.call(null,args__38095__auto___55689));
})();
if(cljs.core.truth_(temp__5804__auto___55697)){
var error__38096__auto___55698 = temp__5804__auto___55697;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55698], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54405_55680,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55689,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55698], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var union_schema = G__54408;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54440_55700 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54441_55701 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__54442_55702 = output_schema54404_55678;
var G__54443_55703 = cljs.core.deref(output_checker54407_55682);
var G__54444_55704 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54440_55700,G__54441_55701,G__54442_55702,G__54443_55703,G__54444_55704) : schema.core.fn_validator.call(null,G__54440_55700,G__54441_55701,G__54442_55702,G__54443_55703,G__54444_55704));
} else {
var temp__5804__auto___55706 = (function (){var fexpr__54447 = cljs.core.deref(output_checker54407_55682);
return (fexpr__54447.cljs$core$IFn$_invoke$arity$1 ? fexpr__54447.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54447.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55706)){
var error__38096__auto___55708 = temp__5804__auto___55706;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55708], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54404_55678,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55708], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema54404_55678,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54405_55680], null)));

var ufv___55712 = schema.utils.use_fn_validation;
var output_schema54453_55713 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54454_55714 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54455_55715 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54454_55714);
}),null));
var output_checker54456_55716 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54453_55713);
}),null));
var ret__40711__auto___55721 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__54457,G__54458){
var validate__38094__auto__ = cljs.core.deref(ufv___55712);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55723 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54457,G__54458], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54467_55726 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54468_55727 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__54469_55728 = input_schema54454_55714;
var G__54470_55729 = cljs.core.deref(input_checker54455_55715);
var G__54471_55730 = args__38095__auto___55723;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54467_55726,G__54468_55727,G__54469_55728,G__54470_55729,G__54471_55730) : schema.core.fn_validator.call(null,G__54467_55726,G__54468_55727,G__54469_55728,G__54470_55729,G__54471_55730));
} else {
var temp__5804__auto___55732 = (function (){var fexpr__54472 = cljs.core.deref(input_checker54455_55715);
return (fexpr__54472.cljs$core$IFn$_invoke$arity$1 ? fexpr__54472.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55723) : fexpr__54472.call(null,args__38095__auto___55723));
})();
if(cljs.core.truth_(temp__5804__auto___55732)){
var error__38096__auto___55733 = temp__5804__auto___55732;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55733], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54454_55714,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55723,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55733], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var union_schema = G__54457;
var branch_index = G__54458;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54486_55737 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54487_55738 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__54488_55739 = output_schema54453_55713;
var G__54489_55740 = cljs.core.deref(output_checker54456_55716);
var G__54490_55741 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54486_55737,G__54487_55738,G__54488_55739,G__54489_55740,G__54490_55741) : schema.core.fn_validator.call(null,G__54486_55737,G__54487_55738,G__54488_55739,G__54489_55740,G__54490_55741));
} else {
var temp__5804__auto___55744 = (function (){var fexpr__54495 = cljs.core.deref(output_checker54456_55716);
return (fexpr__54495.cljs$core$IFn$_invoke$arity$1 ? fexpr__54495.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54495.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55744)){
var error__38096__auto___55746 = temp__5804__auto___55744;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55746], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54453_55713,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55746], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema54453_55713,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54454_55714], null)));

var ufv___55757 = schema.utils.use_fn_validation;
var output_schema54499_55758 = schema.core.Keyword;
var input_schema54500_55759 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54501_55760 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54500_55759);
}),null));
var output_checker54502_55761 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54499_55758);
}),null));
var ret__40711__auto___55763 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__54503){
var validate__38094__auto__ = cljs.core.deref(ufv___55757);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___55764 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54503], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54514_55765 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54515_55766 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__54516_55767 = input_schema54500_55759;
var G__54517_55768 = cljs.core.deref(input_checker54501_55760);
var G__54518_55769 = args__38095__auto___55764;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54514_55765,G__54515_55766,G__54516_55767,G__54517_55768,G__54518_55769) : schema.core.fn_validator.call(null,G__54514_55765,G__54515_55766,G__54516_55767,G__54517_55768,G__54518_55769));
} else {
var temp__5804__auto___55774 = (function (){var fexpr__54524 = cljs.core.deref(input_checker54501_55760);
return (fexpr__54524.cljs$core$IFn$_invoke$arity$1 ? fexpr__54524.cljs$core$IFn$_invoke$arity$1(args__38095__auto___55764) : fexpr__54524.call(null,args__38095__auto___55764));
})();
if(cljs.core.truth_(temp__5804__auto___55774)){
var error__38096__auto___55776 = temp__5804__auto___55774;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55776], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54500_55759,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___55764,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55776], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var schema__$1 = G__54503;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54536_55791 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54537_55792 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__54538_55793 = output_schema54499_55758;
var G__54539_55794 = cljs.core.deref(output_checker54502_55761);
var G__54540_55795 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54536_55791,G__54537_55792,G__54538_55793,G__54539_55794,G__54540_55795) : schema.core.fn_validator.call(null,G__54536_55791,G__54537_55792,G__54538_55793,G__54539_55794,G__54540_55795));
} else {
var temp__5804__auto___55797 = (function (){var fexpr__54543 = cljs.core.deref(output_checker54502_55761);
return (fexpr__54543.cljs$core$IFn$_invoke$arity$1 ? fexpr__54543.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__54543.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55797)){
var error__38096__auto___55798 = temp__5804__auto___55797;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___55798], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54499_55758,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___55798], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema54499_55758,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54500_55759], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
