goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41790 = schema.utils.use_fn_validation;
var output_schema41291_41791 = schema.core.Bool;
var input_schema41292_41792 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41293_41793 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41292_41792);
}),null));
var output_checker41294_41794 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41291_41791);
}),null));
var ret__40711__auto___41795 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41295){
var validate__38094__auto__ = cljs.core.deref(ufv___41790);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41796 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41295], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41299_41797 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41300_41798 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41301_41799 = input_schema41292_41792;
var G__41302_41800 = cljs.core.deref(input_checker41293_41793);
var G__41303_41801 = args__38095__auto___41796;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41299_41797,G__41300_41798,G__41301_41799,G__41302_41800,G__41303_41801) : schema.core.fn_validator.call(null,G__41299_41797,G__41300_41798,G__41301_41799,G__41302_41800,G__41303_41801));
} else {
var temp__5804__auto___41802 = (function (){var fexpr__41304 = cljs.core.deref(input_checker41293_41793);
return (fexpr__41304.cljs$core$IFn$_invoke$arity$1 ? fexpr__41304.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41796) : fexpr__41304.call(null,args__38095__auto___41796));
})();
if(cljs.core.truth_(temp__5804__auto___41802)){
var error__38096__auto___41803 = temp__5804__auto___41802;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41803], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41292_41792,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41796,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41803], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var arg = G__41295;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41306_41804 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41307_41805 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41308_41806 = output_schema41291_41791;
var G__41309_41807 = cljs.core.deref(output_checker41294_41794);
var G__41310_41808 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41306_41804,G__41307_41805,G__41308_41806,G__41309_41807,G__41310_41808) : schema.core.fn_validator.call(null,G__41306_41804,G__41307_41805,G__41308_41806,G__41309_41807,G__41310_41808));
} else {
var temp__5804__auto___41809 = (function (){var fexpr__41311 = cljs.core.deref(output_checker41294_41794);
return (fexpr__41311.cljs$core$IFn$_invoke$arity$1 ? fexpr__41311.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41311.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41809)){
var error__38096__auto___41810 = temp__5804__auto___41809;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41810], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41291_41791,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41810], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41291_41791,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41292_41792], null)));

var ufv___41811 = schema.utils.use_fn_validation;
var output_schema41313_41812 = deercreeklabs.baracus.ByteArray;
var input_schema41314_41813 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41318_41814 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41315_41815 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41314_41813);
}),null));
var output_checker41316_41816 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41313_41812);
}),null));
var input_checker41319_41817 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41318_41814);
}),null));
var output_checker41320_41818 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41313_41812);
}),null));
var ret__40711__auto___41819 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41327 = arguments.length;
switch (G__41327) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41317){
var validate__38094__auto__ = cljs.core.deref(ufv___41811);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41821 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41317], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41331_41822 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41332_41823 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41333_41824 = input_schema41314_41813;
var G__41334_41825 = cljs.core.deref(input_checker41315_41815);
var G__41335_41826 = args__38095__auto___41821;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41331_41822,G__41332_41823,G__41333_41824,G__41334_41825,G__41335_41826) : schema.core.fn_validator.call(null,G__41331_41822,G__41332_41823,G__41333_41824,G__41334_41825,G__41335_41826));
} else {
var temp__5804__auto___41827 = (function (){var fexpr__41336 = cljs.core.deref(input_checker41315_41815);
return (fexpr__41336.cljs$core$IFn$_invoke$arity$1 ? fexpr__41336.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41821) : fexpr__41336.call(null,args__38095__auto___41821));
})();
if(cljs.core.truth_(temp__5804__auto___41827)){
var error__38096__auto___41828 = temp__5804__auto___41827;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41828], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41314_41813,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41821,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41828], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var size_or_seq = G__41317;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41337_41829 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41338_41830 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41339_41831 = output_schema41313_41812;
var G__41340_41832 = cljs.core.deref(output_checker41316_41816);
var G__41341_41833 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41337_41829,G__41338_41830,G__41339_41831,G__41340_41832,G__41341_41833) : schema.core.fn_validator.call(null,G__41337_41829,G__41338_41830,G__41339_41831,G__41340_41832,G__41341_41833));
} else {
var temp__5804__auto___41834 = (function (){var fexpr__41343 = cljs.core.deref(output_checker41316_41816);
return (fexpr__41343.cljs$core$IFn$_invoke$arity$1 ? fexpr__41343.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41343.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41834)){
var error__38096__auto___41835 = temp__5804__auto___41834;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41835], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41313_41812,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41835], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41321,G__41322){
var validate__38094__auto__ = cljs.core.deref(ufv___41811);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41836 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41321,G__41322], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41344_41837 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41345_41838 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41346_41839 = input_schema41318_41814;
var G__41347_41840 = cljs.core.deref(input_checker41319_41817);
var G__41348_41841 = args__38095__auto___41836;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41344_41837,G__41345_41838,G__41346_41839,G__41347_41840,G__41348_41841) : schema.core.fn_validator.call(null,G__41344_41837,G__41345_41838,G__41346_41839,G__41347_41840,G__41348_41841));
} else {
var temp__5804__auto___41842 = (function (){var fexpr__41349 = cljs.core.deref(input_checker41319_41817);
return (fexpr__41349.cljs$core$IFn$_invoke$arity$1 ? fexpr__41349.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41836) : fexpr__41349.call(null,args__38095__auto___41836));
})();
if(cljs.core.truth_(temp__5804__auto___41842)){
var error__38096__auto___41843 = temp__5804__auto___41842;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41843], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41318_41814,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41836,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41843], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var size = G__41321;
var init_val_or_seq = G__41322;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41351_41844 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41352_41845 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41353_41846 = output_schema41313_41812;
var G__41354_41847 = cljs.core.deref(output_checker41320_41818);
var G__41355_41848 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41351_41844,G__41352_41845,G__41353_41846,G__41354_41847,G__41355_41848) : schema.core.fn_validator.call(null,G__41351_41844,G__41352_41845,G__41353_41846,G__41354_41847,G__41355_41848));
} else {
var temp__5804__auto___41849 = (function (){var fexpr__41356 = cljs.core.deref(output_checker41320_41818);
return (fexpr__41356.cljs$core$IFn$_invoke$arity$1 ? fexpr__41356.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41356.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41849)){
var error__38096__auto___41850 = temp__5804__auto___41849;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41850], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41313_41812,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41850], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41313_41812,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41314_41813,input_schema41318_41814], null)));

var ufv___41851 = schema.utils.use_fn_validation;
var output_schema41358_41852 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41359_41853 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41360_41854 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41359_41853);
}),null));
var output_checker41361_41855 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41358_41852);
}),null));
var ret__40711__auto___41856 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41362){
var validate__38094__auto__ = cljs.core.deref(ufv___41851);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41857 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41362], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41364_41858 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41365_41859 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41366_41860 = input_schema41359_41853;
var G__41367_41861 = cljs.core.deref(input_checker41360_41854);
var G__41368_41862 = args__38095__auto___41857;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41364_41858,G__41365_41859,G__41366_41860,G__41367_41861,G__41368_41862) : schema.core.fn_validator.call(null,G__41364_41858,G__41365_41859,G__41366_41860,G__41367_41861,G__41368_41862));
} else {
var temp__5804__auto___41863 = (function (){var fexpr__41369 = cljs.core.deref(input_checker41360_41854);
return (fexpr__41369.cljs$core$IFn$_invoke$arity$1 ? fexpr__41369.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41857) : fexpr__41369.call(null,args__38095__auto___41857));
})();
if(cljs.core.truth_(temp__5804__auto___41863)){
var error__38096__auto___41864 = temp__5804__auto___41863;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41864], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41359_41853,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41857,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41864], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var arrays = G__41362;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41370 = cljs.core.count(arrays__$1);
switch (G__41370) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41370,arrays__$1,validate__38094__auto__,ufv___41851,output_schema41358_41852,input_schema41359_41853,input_checker41360_41854,output_checker41361_41855){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41370,arrays__$1,validate__38094__auto__,ufv___41851,output_schema41358_41852,input_schema41359_41853,input_checker41360_41854,output_checker41361_41855))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41370,arrays__$1,validate__38094__auto__,ufv___41851,output_schema41358_41852,input_schema41359_41853,input_checker41360_41854,output_checker41361_41855){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41370,arrays__$1,validate__38094__auto__,ufv___41851,output_schema41358_41852,input_schema41359_41853,input_checker41360_41854,output_checker41361_41855))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41371_41866 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41372_41867 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41373_41868 = output_schema41358_41852;
var G__41374_41869 = cljs.core.deref(output_checker41361_41855);
var G__41375_41870 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41371_41866,G__41372_41867,G__41373_41868,G__41374_41869,G__41375_41870) : schema.core.fn_validator.call(null,G__41371_41866,G__41372_41867,G__41373_41868,G__41374_41869,G__41375_41870));
} else {
var temp__5804__auto___41871 = (function (){var fexpr__41376 = cljs.core.deref(output_checker41361_41855);
return (fexpr__41376.cljs$core$IFn$_invoke$arity$1 ? fexpr__41376.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41376.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41871)){
var error__38096__auto___41872 = temp__5804__auto___41871;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41872], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41358_41852,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41872], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41358_41852,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41359_41853], null)));

var ufv___41875 = schema.utils.use_fn_validation;
var output_schema41377_41876 = schema.core.Bool;
var input_schema41378_41877 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41379_41878 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41378_41877);
}),null));
var output_checker41380_41879 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41377_41876);
}),null));
var ret__40711__auto___41882 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41381,G__41382){
var validate__38094__auto__ = cljs.core.deref(ufv___41875);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41884 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41381,G__41382], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41384_41885 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41385_41886 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41386_41887 = input_schema41378_41877;
var G__41387_41888 = cljs.core.deref(input_checker41379_41878);
var G__41388_41889 = args__38095__auto___41884;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41384_41885,G__41385_41886,G__41386_41887,G__41387_41888,G__41388_41889) : schema.core.fn_validator.call(null,G__41384_41885,G__41385_41886,G__41386_41887,G__41387_41888,G__41388_41889));
} else {
var temp__5804__auto___41890 = (function (){var fexpr__41389 = cljs.core.deref(input_checker41379_41878);
return (fexpr__41389.cljs$core$IFn$_invoke$arity$1 ? fexpr__41389.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41884) : fexpr__41389.call(null,args__38095__auto___41884));
})();
if(cljs.core.truth_(temp__5804__auto___41890)){
var error__38096__auto___41892 = temp__5804__auto___41890;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41892], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41378_41877,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41884,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41892], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var a = G__41381;
var b = G__41382;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41893 = ((i + (1)) | (0));
i = G__41893;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41391_41894 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41392_41895 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41393_41896 = output_schema41377_41876;
var G__41394_41897 = cljs.core.deref(output_checker41380_41879);
var G__41395_41898 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41391_41894,G__41392_41895,G__41393_41896,G__41394_41897,G__41395_41898) : schema.core.fn_validator.call(null,G__41391_41894,G__41392_41895,G__41393_41896,G__41394_41897,G__41395_41898));
} else {
var temp__5804__auto___41899 = (function (){var fexpr__41396 = cljs.core.deref(output_checker41380_41879);
return (fexpr__41396.cljs$core$IFn$_invoke$arity$1 ? fexpr__41396.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41396.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41899)){
var error__38096__auto___41900 = temp__5804__auto___41899;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41900], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41377_41876,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41900], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41377_41876,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41378_41877], null)));

var ufv___41901 = schema.utils.use_fn_validation;
var output_schema41397_41902 = schema.core.Str;
var input_schema41398_41903 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41399_41904 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41398_41903);
}),null));
var output_checker41400_41905 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41397_41902);
}),null));
var ret__40711__auto___41906 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41401){
var validate__38094__auto__ = cljs.core.deref(ufv___41901);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41907 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41401], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41403_41908 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41404_41909 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41405_41910 = input_schema41398_41903;
var G__41406_41911 = cljs.core.deref(input_checker41399_41904);
var G__41407_41912 = args__38095__auto___41907;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41403_41908,G__41404_41909,G__41405_41910,G__41406_41911,G__41407_41912) : schema.core.fn_validator.call(null,G__41403_41908,G__41404_41909,G__41405_41910,G__41406_41911,G__41407_41912));
} else {
var temp__5804__auto___41915 = (function (){var fexpr__41408 = cljs.core.deref(input_checker41399_41904);
return (fexpr__41408.cljs$core$IFn$_invoke$arity$1 ? fexpr__41408.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41907) : fexpr__41408.call(null,args__38095__auto___41907));
})();
if(cljs.core.truth_(temp__5804__auto___41915)){
var error__38096__auto___41916 = temp__5804__auto___41915;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41916], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41398_41903,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41907,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41916], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41401;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41409_41920 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41410_41921 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41411_41922 = output_schema41397_41902;
var G__41412_41923 = cljs.core.deref(output_checker41400_41905);
var G__41413_41924 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41409_41920,G__41410_41921,G__41411_41922,G__41412_41923,G__41413_41924) : schema.core.fn_validator.call(null,G__41409_41920,G__41410_41921,G__41411_41922,G__41412_41923,G__41413_41924));
} else {
var temp__5804__auto___41926 = (function (){var fexpr__41415 = cljs.core.deref(output_checker41400_41905);
return (fexpr__41415.cljs$core$IFn$_invoke$arity$1 ? fexpr__41415.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41415.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41926)){
var error__38096__auto___41927 = temp__5804__auto___41926;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41927], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41397_41902,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41927], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41397_41902,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41398_41903], null)));

var ufv___41928 = schema.utils.use_fn_validation;
var output_schema41419_41929 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41420_41930 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41424_41931 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41430_41932 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41421_41933 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41420_41930);
}),null));
var output_checker41422_41934 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41419_41929);
}),null));
var input_checker41425_41935 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41424_41931);
}),null));
var output_checker41426_41936 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41419_41929);
}),null));
var input_checker41431_41937 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41430_41932);
}),null));
var output_checker41432_41938 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41419_41929);
}),null));
var ret__40711__auto___41943 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41440 = arguments.length;
switch (G__41440) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41423){
var validate__38094__auto__ = cljs.core.deref(ufv___41928);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41945 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41423], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41442_41946 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41443_41947 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41444_41948 = input_schema41420_41930;
var G__41445_41949 = cljs.core.deref(input_checker41421_41933);
var G__41446_41950 = args__38095__auto___41945;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41442_41946,G__41443_41947,G__41444_41948,G__41445_41949,G__41446_41950) : schema.core.fn_validator.call(null,G__41442_41946,G__41443_41947,G__41444_41948,G__41445_41949,G__41446_41950));
} else {
var temp__5804__auto___41951 = (function (){var fexpr__41447 = cljs.core.deref(input_checker41421_41933);
return (fexpr__41447.cljs$core$IFn$_invoke$arity$1 ? fexpr__41447.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41945) : fexpr__41447.call(null,args__38095__auto___41945));
})();
if(cljs.core.truth_(temp__5804__auto___41951)){
var error__38096__auto___41952 = temp__5804__auto___41951;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41952], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41420_41930,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41945,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41952], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41423;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41449_41954 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41450_41955 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41451_41956 = output_schema41419_41929;
var G__41452_41957 = cljs.core.deref(output_checker41422_41934);
var G__41453_41958 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41449_41954,G__41450_41955,G__41451_41956,G__41452_41957,G__41453_41958) : schema.core.fn_validator.call(null,G__41449_41954,G__41450_41955,G__41451_41956,G__41452_41957,G__41453_41958));
} else {
var temp__5804__auto___41963 = (function (){var fexpr__41454 = cljs.core.deref(output_checker41422_41934);
return (fexpr__41454.cljs$core$IFn$_invoke$arity$1 ? fexpr__41454.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41454.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41963)){
var error__38096__auto___41964 = temp__5804__auto___41963;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41964], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41419_41929,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41964], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41427,G__41428){
var validate__38094__auto__ = cljs.core.deref(ufv___41928);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41966 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41427,G__41428], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41455_41967 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41456_41968 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41457_41969 = input_schema41424_41931;
var G__41458_41970 = cljs.core.deref(input_checker41425_41935);
var G__41459_41971 = args__38095__auto___41966;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41455_41967,G__41456_41968,G__41457_41969,G__41458_41970,G__41459_41971) : schema.core.fn_validator.call(null,G__41455_41967,G__41456_41968,G__41457_41969,G__41458_41970,G__41459_41971));
} else {
var temp__5804__auto___41973 = (function (){var fexpr__41462 = cljs.core.deref(input_checker41425_41935);
return (fexpr__41462.cljs$core$IFn$_invoke$arity$1 ? fexpr__41462.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41966) : fexpr__41462.call(null,args__38095__auto___41966));
})();
if(cljs.core.truth_(temp__5804__auto___41973)){
var error__38096__auto___41974 = temp__5804__auto___41973;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41974], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41424_41931,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41966,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41974], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41427;
var start = G__41428;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41464_41976 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41465_41977 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41466_41978 = output_schema41419_41929;
var G__41467_41979 = cljs.core.deref(output_checker41426_41936);
var G__41468_41980 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41464_41976,G__41465_41977,G__41466_41978,G__41467_41979,G__41468_41980) : schema.core.fn_validator.call(null,G__41464_41976,G__41465_41977,G__41466_41978,G__41467_41979,G__41468_41980));
} else {
var temp__5804__auto___41985 = (function (){var fexpr__41469 = cljs.core.deref(output_checker41426_41936);
return (fexpr__41469.cljs$core$IFn$_invoke$arity$1 ? fexpr__41469.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41469.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41985)){
var error__38096__auto___41986 = temp__5804__auto___41985;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41986], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41419_41929,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41986], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41433,G__41434,G__41435){
var validate__38094__auto__ = cljs.core.deref(ufv___41928);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___41988 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41433,G__41434,G__41435], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41471_41989 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41472_41990 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41473_41991 = input_schema41430_41932;
var G__41474_41992 = cljs.core.deref(input_checker41431_41937);
var G__41475_41993 = args__38095__auto___41988;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41471_41989,G__41472_41990,G__41473_41991,G__41474_41992,G__41475_41993) : schema.core.fn_validator.call(null,G__41471_41989,G__41472_41990,G__41473_41991,G__41474_41992,G__41475_41993));
} else {
var temp__5804__auto___41995 = (function (){var fexpr__41476 = cljs.core.deref(input_checker41431_41937);
return (fexpr__41476.cljs$core$IFn$_invoke$arity$1 ? fexpr__41476.cljs$core$IFn$_invoke$arity$1(args__38095__auto___41988) : fexpr__41476.call(null,args__38095__auto___41988));
})();
if(cljs.core.truth_(temp__5804__auto___41995)){
var error__38096__auto___41996 = temp__5804__auto___41995;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___41996], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41430_41932,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___41988,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___41996], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41433;
var start = G__41434;
var end = G__41435;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41478_42002 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41479_42003 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41480_42004 = output_schema41419_41929;
var G__41481_42005 = cljs.core.deref(output_checker41432_41938);
var G__41482_42006 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41478_42002,G__41479_42003,G__41480_42004,G__41481_42005,G__41482_42006) : schema.core.fn_validator.call(null,G__41478_42002,G__41479_42003,G__41480_42004,G__41481_42005,G__41482_42006));
} else {
var temp__5804__auto___42007 = (function (){var fexpr__41483 = cljs.core.deref(output_checker41432_41938);
return (fexpr__41483.cljs$core$IFn$_invoke$arity$1 ? fexpr__41483.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41483.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42007)){
var error__38096__auto___42009 = temp__5804__auto___42007;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42009], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41419_41929,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42009], null));
} else {
}
}
} else {
}

return o__38098__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41419_41929,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41420_41930,input_schema41424_41931,input_schema41430_41932], null)));

var ufv___42011 = schema.utils.use_fn_validation;
var output_schema41485_42012 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41486_42013 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41487_42014 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41486_42013);
}),null));
var output_checker41488_42015 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41485_42012);
}),null));
var ret__40711__auto___42016 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41489){
var validate__38094__auto__ = cljs.core.deref(ufv___42011);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42017 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41489], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41491_42018 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41492_42019 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41493_42020 = input_schema41486_42013;
var G__41494_42021 = cljs.core.deref(input_checker41487_42014);
var G__41495_42022 = args__38095__auto___42017;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41491_42018,G__41492_42019,G__41493_42020,G__41494_42021,G__41495_42022) : schema.core.fn_validator.call(null,G__41491_42018,G__41492_42019,G__41493_42020,G__41494_42021,G__41495_42022));
} else {
var temp__5804__auto___42024 = (function (){var fexpr__41496 = cljs.core.deref(input_checker41487_42014);
return (fexpr__41496.cljs$core$IFn$_invoke$arity$1 ? fexpr__41496.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42017) : fexpr__41496.call(null,args__38095__auto___42017));
})();
if(cljs.core.truth_(temp__5804__auto___42024)){
var error__38096__auto___42025 = temp__5804__auto___42024;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42025], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41486_42013,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42017,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42025], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41489;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5636__auto___42026 = num;
var i_42027 = (0);
while(true){
if((i_42027 < n__5636__auto___42026)){
(new$[i_42027] = (ba[(last - i_42027)]));

var G__42028 = (i_42027 + (1));
i_42027 = G__42028;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41498_42029 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41499_42030 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41500_42031 = output_schema41485_42012;
var G__41501_42032 = cljs.core.deref(output_checker41488_42015);
var G__41502_42033 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41498_42029,G__41499_42030,G__41500_42031,G__41501_42032,G__41502_42033) : schema.core.fn_validator.call(null,G__41498_42029,G__41499_42030,G__41500_42031,G__41501_42032,G__41502_42033));
} else {
var temp__5804__auto___42034 = (function (){var fexpr__41503 = cljs.core.deref(output_checker41488_42015);
return (fexpr__41503.cljs$core$IFn$_invoke$arity$1 ? fexpr__41503.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41503.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42034)){
var error__38096__auto___42035 = temp__5804__auto___42034;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42035], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41485_42012,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42035], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41485_42012,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41486_42013], null)));

var ufv___42036 = schema.utils.use_fn_validation;
var output_schema41505_42037 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41506_42038 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41507_42039 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41506_42038);
}),null));
var output_checker41508_42040 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41505_42037);
}),null));
var ret__40711__auto___42041 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41509,G__41510){
var validate__38094__auto__ = cljs.core.deref(ufv___42036);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42042 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41509,G__41510], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41515_42043 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41516_42044 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41517_42045 = input_schema41506_42038;
var G__41518_42046 = cljs.core.deref(input_checker41507_42039);
var G__41519_42047 = args__38095__auto___42042;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41515_42043,G__41516_42044,G__41517_42045,G__41518_42046,G__41519_42047) : schema.core.fn_validator.call(null,G__41515_42043,G__41516_42044,G__41517_42045,G__41518_42046,G__41519_42047));
} else {
var temp__5804__auto___42048 = (function (){var fexpr__41520 = cljs.core.deref(input_checker41507_42039);
return (fexpr__41520.cljs$core$IFn$_invoke$arity$1 ? fexpr__41520.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42042) : fexpr__41520.call(null,args__38095__auto___42042));
})();
if(cljs.core.truth_(temp__5804__auto___42048)){
var error__38096__auto___42049 = temp__5804__auto___42048;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42049], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41506_42038,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42042,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42049], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41509;
var fragment_size = G__41510;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__42050 = (end_offset | (0));
var G__42051 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__42050;
output = G__42051;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41522_42052 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41523_42053 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41524_42054 = output_schema41505_42037;
var G__41525_42055 = cljs.core.deref(output_checker41508_42040);
var G__41526_42056 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41522_42052,G__41523_42053,G__41524_42054,G__41525_42055,G__41526_42056) : schema.core.fn_validator.call(null,G__41522_42052,G__41523_42053,G__41524_42054,G__41525_42055,G__41526_42056));
} else {
var temp__5804__auto___42057 = (function (){var fexpr__41527 = cljs.core.deref(output_checker41508_42040);
return (fexpr__41527.cljs$core$IFn$_invoke$arity$1 ? fexpr__41527.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41527.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42057)){
var error__38096__auto___42058 = temp__5804__auto___42057;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42058], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41505_42037,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42058], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41505_42037,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41506_42038], null)));

var ufv___42059 = schema.utils.use_fn_validation;
var output_schema41528_42060 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41529_42061 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41530_42062 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41529_42061);
}),null));
var output_checker41531_42063 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41528_42060);
}),null));
var ret__40711__auto___42064 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an variable-length zig-zag encoded byte array and reads an integer
 * from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41532){
var validate__38094__auto__ = cljs.core.deref(ufv___42059);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42067 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41532], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41535_42068 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41536_42069 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41537_42070 = input_schema41529_42061;
var G__41538_42071 = cljs.core.deref(input_checker41530_42062);
var G__41539_42072 = args__38095__auto___42067;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41535_42068,G__41536_42069,G__41537_42070,G__41538_42071,G__41539_42072) : schema.core.fn_validator.call(null,G__41535_42068,G__41536_42069,G__41537_42070,G__41538_42071,G__41539_42072));
} else {
var temp__5804__auto___42075 = (function (){var fexpr__41540 = cljs.core.deref(input_checker41530_42062);
return (fexpr__41540.cljs$core$IFn$_invoke$arity$1 ? fexpr__41540.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42067) : fexpr__41540.call(null,args__38095__auto___42067));
})();
if(cljs.core.truth_(temp__5804__auto___42075)){
var error__38096__auto___42076 = temp__5804__auto___42075;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42076], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41529_42061,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42067,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42076], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41532;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__42079 = (n + (1));
var G__42080 = (i__$1 | (0));
var G__42081 = (out__$1 | (0));
n = G__42079;
i = G__42080;
out = G__42081;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41542_42083 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41543_42084 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41544_42085 = output_schema41528_42060;
var G__41545_42086 = cljs.core.deref(output_checker41531_42063);
var G__41546_42087 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41542_42083,G__41543_42084,G__41544_42085,G__41545_42086,G__41546_42087) : schema.core.fn_validator.call(null,G__41542_42083,G__41543_42084,G__41544_42085,G__41545_42086,G__41546_42087));
} else {
var temp__5804__auto___42090 = (function (){var fexpr__41547 = cljs.core.deref(output_checker41531_42063);
return (fexpr__41547.cljs$core$IFn$_invoke$arity$1 ? fexpr__41547.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41547.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42090)){
var error__38096__auto___42091 = temp__5804__auto___42090;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42091], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41528_42060,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42091], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41528_42060,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41529_42061], null)));

var ufv___42095 = schema.utils.use_fn_validation;
var output_schema41551_42096 = deercreeklabs.baracus.ByteArray;
var input_schema41552_42097 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41553_42098 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41552_42097);
}),null));
var output_checker41554_42099 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41551_42096);
}),null));
var ret__40711__auto___42101 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Encodes an integer using variable length zig-zag coding.
 * Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41555){
var validate__38094__auto__ = cljs.core.deref(ufv___42095);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42102 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41555], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41557_42103 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41558_42104 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41559_42105 = input_schema41552_42097;
var G__41560_42106 = cljs.core.deref(input_checker41553_42098);
var G__41561_42107 = args__38095__auto___42102;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41557_42103,G__41558_42104,G__41559_42105,G__41560_42106,G__41561_42107) : schema.core.fn_validator.call(null,G__41557_42103,G__41558_42104,G__41559_42105,G__41560_42106,G__41561_42107));
} else {
var temp__5804__auto___42109 = (function (){var fexpr__41562 = cljs.core.deref(input_checker41553_42098);
return (fexpr__41562.cljs$core$IFn$_invoke$arity$1 ? fexpr__41562.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42102) : fexpr__41562.call(null,args__38095__auto___42102));
})();
if(cljs.core.truth_(temp__5804__auto___42109)){
var error__38096__auto___42110 = temp__5804__auto___42109;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42110], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41552_42097,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42102,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42110], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var i = G__41555;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__42111 = (n >>> (7));
var G__42112 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__42111;
out = G__42112;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41564_42113 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41565_42114 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41566_42115 = output_schema41551_42096;
var G__41567_42116 = cljs.core.deref(output_checker41554_42099);
var G__41568_42117 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41564_42113,G__41565_42114,G__41566_42115,G__41567_42116,G__41568_42117) : schema.core.fn_validator.call(null,G__41564_42113,G__41565_42114,G__41566_42115,G__41567_42116,G__41568_42117));
} else {
var temp__5804__auto___42118 = (function (){var fexpr__41569 = cljs.core.deref(output_checker41554_42099);
return (fexpr__41569.cljs$core$IFn$_invoke$arity$1 ? fexpr__41569.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41569.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42118)){
var error__38096__auto___42119 = temp__5804__auto___42118;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42119], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41551_42096,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42119], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41551_42096,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41552_42097], null)));

var ufv___42120 = schema.utils.use_fn_validation;
var output_schema41570_42121 = schema.core.maybe(schema.core.Str);
var input_schema41571_42122 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41572_42123 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41571_42122);
}),null));
var output_checker41573_42124 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41570_42121);
}),null));
var ret__40711__auto___42125 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41574){
var validate__38094__auto__ = cljs.core.deref(ufv___42120);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42126 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41574], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41576_42127 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41577_42128 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41578_42129 = input_schema41571_42122;
var G__41579_42130 = cljs.core.deref(input_checker41572_42123);
var G__41580_42131 = args__38095__auto___42126;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41576_42127,G__41577_42128,G__41578_42129,G__41579_42130,G__41580_42131) : schema.core.fn_validator.call(null,G__41576_42127,G__41577_42128,G__41578_42129,G__41579_42130,G__41580_42131));
} else {
var temp__5804__auto___42132 = (function (){var fexpr__41581 = cljs.core.deref(input_checker41572_42123);
return (fexpr__41581.cljs$core$IFn$_invoke$arity$1 ? fexpr__41581.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42126) : fexpr__41581.call(null,args__38095__auto___42126));
})();
if(cljs.core.truth_(temp__5804__auto___42132)){
var error__38096__auto___42133 = temp__5804__auto___42132;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42133], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41571_42122,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42126,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42133], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var b = G__41574;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41582_42134 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41583_42135 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41584_42136 = output_schema41570_42121;
var G__41585_42137 = cljs.core.deref(output_checker41573_42124);
var G__41586_42138 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41582_42134,G__41583_42135,G__41584_42136,G__41585_42137,G__41586_42138) : schema.core.fn_validator.call(null,G__41582_42134,G__41583_42135,G__41584_42136,G__41585_42137,G__41586_42138));
} else {
var temp__5804__auto___42139 = (function (){var fexpr__41588 = cljs.core.deref(output_checker41573_42124);
return (fexpr__41588.cljs$core$IFn$_invoke$arity$1 ? fexpr__41588.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41588.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42139)){
var error__38096__auto___42140 = temp__5804__auto___42139;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42140], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41570_42121,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42140], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41570_42121,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41571_42122], null)));

var ufv___42143 = schema.utils.use_fn_validation;
var output_schema41589_42144 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41590_42145 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41591_42146 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41590_42145);
}),null));
var output_checker41592_42147 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41589_42144);
}),null));
var ret__40711__auto___42150 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41593){
var validate__38094__auto__ = cljs.core.deref(ufv___42143);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42151 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41593], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41595_42152 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41596_42153 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41597_42154 = input_schema41590_42145;
var G__41598_42155 = cljs.core.deref(input_checker41591_42146);
var G__41599_42156 = args__38095__auto___42151;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41595_42152,G__41596_42153,G__41597_42154,G__41598_42155,G__41599_42156) : schema.core.fn_validator.call(null,G__41595_42152,G__41596_42153,G__41597_42154,G__41598_42155,G__41599_42156));
} else {
var temp__5804__auto___42158 = (function (){var fexpr__41601 = cljs.core.deref(input_checker41591_42146);
return (fexpr__41601.cljs$core$IFn$_invoke$arity$1 ? fexpr__41601.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42151) : fexpr__41601.call(null,args__38095__auto___42151));
})();
if(cljs.core.truth_(temp__5804__auto___42158)){
var error__38096__auto___42159 = temp__5804__auto___42158;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42159], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41590_42145,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42151,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42159], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var s = G__41593;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41602_42161 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41603_42162 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41604_42163 = output_schema41589_42144;
var G__41605_42164 = cljs.core.deref(output_checker41592_42147);
var G__41606_42165 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41602_42161,G__41603_42162,G__41604_42163,G__41605_42164,G__41606_42165) : schema.core.fn_validator.call(null,G__41602_42161,G__41603_42162,G__41604_42163,G__41605_42164,G__41606_42165));
} else {
var temp__5804__auto___42166 = (function (){var fexpr__41607 = cljs.core.deref(output_checker41592_42147);
return (fexpr__41607.cljs$core$IFn$_invoke$arity$1 ? fexpr__41607.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41607.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42166)){
var error__38096__auto___42168 = temp__5804__auto___42166;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42168], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41589_42144,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42168], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41589_42144,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41590_42145], null)));

var ufv___42169 = schema.utils.use_fn_validation;
var output_schema41609_42170 = schema.core.maybe(schema.core.Str);
var input_schema41610_42171 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41611_42172 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41610_42171);
}),null));
var output_checker41612_42173 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41609_42170);
}),null));
var ret__40711__auto___42176 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41613){
var validate__38094__auto__ = cljs.core.deref(ufv___42169);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42179 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41613], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41615_42180 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41616_42181 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41617_42182 = input_schema41610_42171;
var G__41618_42183 = cljs.core.deref(input_checker41611_42172);
var G__41619_42184 = args__38095__auto___42179;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41615_42180,G__41616_42181,G__41617_42182,G__41618_42183,G__41619_42184) : schema.core.fn_validator.call(null,G__41615_42180,G__41616_42181,G__41617_42182,G__41618_42183,G__41619_42184));
} else {
var temp__5804__auto___42185 = (function (){var fexpr__41620 = cljs.core.deref(input_checker41611_42172);
return (fexpr__41620.cljs$core$IFn$_invoke$arity$1 ? fexpr__41620.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42179) : fexpr__41620.call(null,args__38095__auto___42179));
})();
if(cljs.core.truth_(temp__5804__auto___42185)){
var error__38096__auto___42186 = temp__5804__auto___42185;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42186], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41610_42171,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42179,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42186], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41613;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41621_42189 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41622_42190 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41623_42191 = output_schema41609_42170;
var G__41624_42192 = cljs.core.deref(output_checker41612_42173);
var G__41625_42193 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41621_42189,G__41622_42190,G__41623_42191,G__41624_42192,G__41625_42193) : schema.core.fn_validator.call(null,G__41621_42189,G__41622_42190,G__41623_42191,G__41624_42192,G__41625_42193));
} else {
var temp__5804__auto___42194 = (function (){var fexpr__41626 = cljs.core.deref(output_checker41612_42173);
return (fexpr__41626.cljs$core$IFn$_invoke$arity$1 ? fexpr__41626.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41626.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42194)){
var error__38096__auto___42195 = temp__5804__auto___42194;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42195], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41609_42170,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42195], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41609_42170,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41610_42171], null)));

var ufv___42197 = schema.utils.use_fn_validation;
var output_schema41628_42198 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41629_42199 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41630_42200 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41629_42199);
}),null));
var output_checker41631_42201 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41628_42198);
}),null));
var ret__40711__auto___42202 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41632){
var validate__38094__auto__ = cljs.core.deref(ufv___42197);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42203 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41632], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41633_42204 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41634_42205 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41635_42206 = input_schema41629_42199;
var G__41636_42207 = cljs.core.deref(input_checker41630_42200);
var G__41637_42208 = args__38095__auto___42203;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41633_42204,G__41634_42205,G__41635_42206,G__41636_42207,G__41637_42208) : schema.core.fn_validator.call(null,G__41633_42204,G__41634_42205,G__41635_42206,G__41636_42207,G__41637_42208));
} else {
var temp__5804__auto___42209 = (function (){var fexpr__41638 = cljs.core.deref(input_checker41630_42200);
return (fexpr__41638.cljs$core$IFn$_invoke$arity$1 ? fexpr__41638.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42203) : fexpr__41638.call(null,args__38095__auto___42203));
})();
if(cljs.core.truth_(temp__5804__auto___42209)){
var error__38096__auto___42210 = temp__5804__auto___42209;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42210], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41629_42199,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42203,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42210], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var s = G__41632;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41640_42211 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41641_42212 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41642_42213 = output_schema41628_42198;
var G__41643_42214 = cljs.core.deref(output_checker41631_42201);
var G__41644_42215 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41640_42211,G__41641_42212,G__41642_42213,G__41643_42214,G__41644_42215) : schema.core.fn_validator.call(null,G__41640_42211,G__41641_42212,G__41642_42213,G__41643_42214,G__41644_42215));
} else {
var temp__5804__auto___42218 = (function (){var fexpr__41645 = cljs.core.deref(output_checker41631_42201);
return (fexpr__41645.cljs$core$IFn$_invoke$arity$1 ? fexpr__41645.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41645.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42218)){
var error__38096__auto___42219 = temp__5804__auto___42218;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42219], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41628_42198,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42219], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41628_42198,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41629_42199], null)));

deercreeklabs.baracus.byte_array__GT_hex_str_STAR_ = (function deercreeklabs$baracus$byte_array__GT_hex_str_STAR_(p__41646){
var map__41647 = p__41646;
var map__41647__$1 = cljs.core.__destructure_map(map__41647);
var alphabet = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41647__$1,new cljs.core.Keyword(null,"alphabet","alphabet",788478088));
var ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41647__$1,new cljs.core.Keyword(null,"ba","ba",-960950298));
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var ca = (new Array(((2) * len)));
var n__5636__auto___42221 = len;
var i_42222 = (0);
while(true){
if((i_42222 < n__5636__auto___42221)){
var b_42223 = ((ba[i_42222]) & (255));
var j_42224 = ((2) * i_42222);
(ca[j_42224] = (function (){var G__41649 = (b_42223 >> (4));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41649) : alphabet.call(null,G__41649));
})());

(ca[(j_42224 + (1))] = (function (){var G__41650 = (b_42223 & (15));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41650) : alphabet.call(null,G__41650));
})());

var G__42226 = (i_42222 + (1));
i_42222 = G__42226;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
});
var ufv___42227 = schema.utils.use_fn_validation;
var output_schema41653_42228 = schema.core.maybe(schema.core.Str);
var input_schema41654_42229 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41655_42230 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41654_42229);
}),null));
var output_checker41656_42231 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41653_42228);
}),null));
var ret__40711__auto___42234 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41657){
var validate__38094__auto__ = cljs.core.deref(ufv___42227);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42235 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41657], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41658_42236 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41659_42237 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41660_42238 = input_schema41654_42229;
var G__41661_42239 = cljs.core.deref(input_checker41655_42230);
var G__41662_42240 = args__38095__auto___42235;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41658_42236,G__41659_42237,G__41660_42238,G__41661_42239,G__41662_42240) : schema.core.fn_validator.call(null,G__41658_42236,G__41659_42237,G__41660_42238,G__41661_42239,G__41662_42240));
} else {
var temp__5804__auto___42241 = (function (){var fexpr__41664 = cljs.core.deref(input_checker41655_42230);
return (fexpr__41664.cljs$core$IFn$_invoke$arity$1 ? fexpr__41664.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42235) : fexpr__41664.call(null,args__38095__auto___42235));
})();
if(cljs.core.truth_(temp__5804__auto___42241)){
var error__38096__auto___42243 = temp__5804__auto___42241;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42243], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41654_42229,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42235,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42243], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41657;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41665_42245 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41666_42246 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41667_42247 = output_schema41653_42228;
var G__41668_42248 = cljs.core.deref(output_checker41656_42231);
var G__41669_42249 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41665_42245,G__41666_42246,G__41667_42247,G__41668_42248,G__41669_42249) : schema.core.fn_validator.call(null,G__41665_42245,G__41666_42246,G__41667_42247,G__41668_42248,G__41669_42249));
} else {
var temp__5804__auto___42250 = (function (){var fexpr__41671 = cljs.core.deref(output_checker41656_42231);
return (fexpr__41671.cljs$core$IFn$_invoke$arity$1 ? fexpr__41671.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41671.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42250)){
var error__38096__auto___42251 = temp__5804__auto___42250;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42251], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41653_42228,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42251], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41653_42228,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41654_42229], null)));

var ufv___42252 = schema.utils.use_fn_validation;
var output_schema41674_42253 = schema.core.maybe(schema.core.Str);
var input_schema41675_42254 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41676_42255 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41675_42254);
}),null));
var output_checker41677_42256 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41674_42253);
}),null));
var ret__40711__auto___42257 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_upper_hex_str = (function deercreeklabs$baracus$byte_array__GT_upper_hex_str(G__41678){
var validate__38094__auto__ = cljs.core.deref(ufv___42252);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42260 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41678], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41680_42261 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41681_42262 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41682_42263 = input_schema41675_42254;
var G__41683_42264 = cljs.core.deref(input_checker41676_42255);
var G__41684_42265 = args__38095__auto___42260;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41680_42261,G__41681_42262,G__41682_42263,G__41683_42264,G__41684_42265) : schema.core.fn_validator.call(null,G__41680_42261,G__41681_42262,G__41682_42263,G__41683_42264,G__41684_42265));
} else {
var temp__5804__auto___42266 = (function (){var fexpr__41685 = cljs.core.deref(input_checker41676_42255);
return (fexpr__41685.cljs$core$IFn$_invoke$arity$1 ? fexpr__41685.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42260) : fexpr__41685.call(null,args__38095__auto___42260));
})();
if(cljs.core.truth_(temp__5804__auto___42266)){
var error__38096__auto___42268 = temp__5804__auto___42266;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42268], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41675_42254,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42260,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42268], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41678;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41687_42272 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41688_42273 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41689_42274 = output_schema41674_42253;
var G__41690_42275 = cljs.core.deref(output_checker41677_42256);
var G__41691_42276 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41687_42272,G__41688_42273,G__41689_42274,G__41690_42275,G__41691_42276) : schema.core.fn_validator.call(null,G__41687_42272,G__41688_42273,G__41689_42274,G__41690_42275,G__41691_42276));
} else {
var temp__5804__auto___42279 = (function (){var fexpr__41692 = cljs.core.deref(output_checker41677_42256);
return (fexpr__41692.cljs$core$IFn$_invoke$arity$1 ? fexpr__41692.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41692.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42279)){
var error__38096__auto___42280 = temp__5804__auto___42279;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42280], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41674_42253,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42280], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_upper_hex_str),schema.core.__GT_FnSchema(output_schema41674_42253,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41675_42254], null)));

var ufv___42281 = schema.utils.use_fn_validation;
var output_schema41693_42282 = schema.core.maybe(schema.core.Str);
var input_schema41694_42283 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41695_42284 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41694_42283);
}),null));
var output_checker41696_42285 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41693_42282);
}),null));
var ret__40711__auto___42286 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_b16_alpha_str = (function deercreeklabs$baracus$byte_array__GT_b16_alpha_str(G__41697){
var validate__38094__auto__ = cljs.core.deref(ufv___42281);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42287 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41697], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41699_42288 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41700_42289 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41701_42290 = input_schema41694_42283;
var G__41702_42291 = cljs.core.deref(input_checker41695_42284);
var G__41703_42292 = args__38095__auto___42287;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41699_42288,G__41700_42289,G__41701_42290,G__41702_42291,G__41703_42292) : schema.core.fn_validator.call(null,G__41699_42288,G__41700_42289,G__41701_42290,G__41702_42291,G__41703_42292));
} else {
var temp__5804__auto___42293 = (function (){var fexpr__41704 = cljs.core.deref(input_checker41695_42284);
return (fexpr__41704.cljs$core$IFn$_invoke$arity$1 ? fexpr__41704.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42287) : fexpr__41704.call(null,args__38095__auto___42287));
})();
if(cljs.core.truth_(temp__5804__auto___42293)){
var error__38096__auto___42294 = temp__5804__auto___42293;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42294], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41694_42283,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42287,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42294], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41697;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["a","b","c","d","c","e","f","g","h","i","j","k","l","m","n","o"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41705_42295 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41706_42296 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41707_42297 = output_schema41693_42282;
var G__41708_42298 = cljs.core.deref(output_checker41696_42285);
var G__41709_42299 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41705_42295,G__41706_42296,G__41707_42297,G__41708_42298,G__41709_42299) : schema.core.fn_validator.call(null,G__41705_42295,G__41706_42296,G__41707_42297,G__41708_42298,G__41709_42299));
} else {
var temp__5804__auto___42300 = (function (){var fexpr__41711 = cljs.core.deref(output_checker41696_42285);
return (fexpr__41711.cljs$core$IFn$_invoke$arity$1 ? fexpr__41711.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41711.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42300)){
var error__38096__auto___42301 = temp__5804__auto___42300;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42301], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41693_42282,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42301], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b16_alpha_str),schema.core.__GT_FnSchema(output_schema41693_42282,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41694_42283], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42306 = schema.utils.use_fn_validation;
var output_schema41712_42307 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41713_42308 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41714_42309 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41713_42308);
}),null));
var output_checker41715_42310 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41712_42307);
}),null));
var ret__40711__auto___42311 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41716){
var validate__38094__auto__ = cljs.core.deref(ufv___42306);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42313 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41716], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41718_42314 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41719_42315 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41720_42316 = input_schema41713_42308;
var G__41721_42317 = cljs.core.deref(input_checker41714_42309);
var G__41722_42318 = args__38095__auto___42313;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41718_42314,G__41719_42315,G__41720_42316,G__41721_42317,G__41722_42318) : schema.core.fn_validator.call(null,G__41718_42314,G__41719_42315,G__41720_42316,G__41721_42317,G__41722_42318));
} else {
var temp__5804__auto___42321 = (function (){var fexpr__41723 = cljs.core.deref(input_checker41714_42309);
return (fexpr__41723.cljs$core$IFn$_invoke$arity$1 ? fexpr__41723.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42313) : fexpr__41723.call(null,args__38095__auto___42313));
})();
if(cljs.core.truth_(temp__5804__auto___42321)){
var error__38096__auto___42322 = temp__5804__auto___42321;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42322], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41713_42308,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42313,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42322], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var s = G__41716;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5636__auto___42324 = ba_len;
var i_42325 = (0);
while(true){
if((i_42325 < n__5636__auto___42324)){
var j_42326 = ((2) * i_42325);
(ba[i_42325] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42326)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42326 + (1))))));

var G__42327 = (i_42325 + (1));
i_42325 = G__42327;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41725_42328 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41726_42329 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41727_42330 = output_schema41712_42307;
var G__41728_42331 = cljs.core.deref(output_checker41715_42310);
var G__41729_42332 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41725_42328,G__41726_42329,G__41727_42330,G__41728_42331,G__41729_42332) : schema.core.fn_validator.call(null,G__41725_42328,G__41726_42329,G__41727_42330,G__41728_42331,G__41729_42332));
} else {
var temp__5804__auto___42333 = (function (){var fexpr__41730 = cljs.core.deref(output_checker41715_42310);
return (fexpr__41730.cljs$core$IFn$_invoke$arity$1 ? fexpr__41730.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41730.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42333)){
var error__38096__auto___42334 = temp__5804__auto___42333;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42334], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41712_42307,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42334], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41712_42307,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41713_42308], null)));

var ufv___42335 = schema.utils.use_fn_validation;
var output_schema41731_42336 = deercreeklabs.baracus.ByteArray;
var input_schema41732_42337 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41733_42338 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41732_42337);
}),null));
var output_checker41734_42339 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41731_42336);
}),null));
var ret__40711__auto___42340 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41735){
var validate__38094__auto__ = cljs.core.deref(ufv___42335);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42341 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41735], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41736_42342 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41737_42343 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41738_42344 = input_schema41732_42337;
var G__41739_42345 = cljs.core.deref(input_checker41733_42338);
var G__41740_42346 = args__38095__auto___42341;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41736_42342,G__41737_42343,G__41738_42344,G__41739_42345,G__41740_42346) : schema.core.fn_validator.call(null,G__41736_42342,G__41737_42343,G__41738_42344,G__41739_42345,G__41740_42346));
} else {
var temp__5804__auto___42347 = (function (){var fexpr__41743 = cljs.core.deref(input_checker41733_42338);
return (fexpr__41743.cljs$core$IFn$_invoke$arity$1 ? fexpr__41743.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42341) : fexpr__41743.call(null,args__38095__auto___42341));
})();
if(cljs.core.truth_(temp__5804__auto___42347)){
var error__38096__auto___42348 = temp__5804__auto___42347;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42348], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41732_42337,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42341,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42348], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41735;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41745_42350 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41746_42351 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41747_42352 = output_schema41731_42336;
var G__41748_42353 = cljs.core.deref(output_checker41734_42339);
var G__41749_42354 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41745_42350,G__41746_42351,G__41747_42352,G__41748_42353,G__41749_42354) : schema.core.fn_validator.call(null,G__41745_42350,G__41746_42351,G__41747_42352,G__41748_42353,G__41749_42354));
} else {
var temp__5804__auto___42355 = (function (){var fexpr__41750 = cljs.core.deref(output_checker41734_42339);
return (fexpr__41750.cljs$core$IFn$_invoke$arity$1 ? fexpr__41750.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41750.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42355)){
var error__38096__auto___42356 = temp__5804__auto___42355;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42356], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41731_42336,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42356], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41731_42336,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41732_42337], null)));

var ufv___42357 = schema.utils.use_fn_validation;
var output_schema41752_42358 = deercreeklabs.baracus.ByteArray;
var input_schema41753_42359 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41754_42360 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41753_42359);
}),null));
var output_checker41755_42361 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41752_42358);
}),null));
var ret__40711__auto___42362 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41756){
var validate__38094__auto__ = cljs.core.deref(ufv___42357);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42364 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41756], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41758_42365 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41759_42366 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41760_42367 = input_schema41753_42359;
var G__41761_42368 = cljs.core.deref(input_checker41754_42360);
var G__41762_42369 = args__38095__auto___42364;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41758_42365,G__41759_42366,G__41760_42367,G__41761_42368,G__41762_42369) : schema.core.fn_validator.call(null,G__41758_42365,G__41759_42366,G__41760_42367,G__41761_42368,G__41762_42369));
} else {
var temp__5804__auto___42370 = (function (){var fexpr__41763 = cljs.core.deref(input_checker41754_42360);
return (fexpr__41763.cljs$core$IFn$_invoke$arity$1 ? fexpr__41763.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42364) : fexpr__41763.call(null,args__38095__auto___42364));
})();
if(cljs.core.truth_(temp__5804__auto___42370)){
var error__38096__auto___42371 = temp__5804__auto___42370;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42371], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41753_42359,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42364,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42371], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41756;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41764_42372 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41765_42373 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41766_42374 = output_schema41752_42358;
var G__41767_42375 = cljs.core.deref(output_checker41755_42361);
var G__41768_42376 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41764_42372,G__41765_42373,G__41766_42374,G__41767_42375,G__41768_42376) : schema.core.fn_validator.call(null,G__41764_42372,G__41765_42373,G__41766_42374,G__41767_42375,G__41768_42376));
} else {
var temp__5804__auto___42377 = (function (){var fexpr__41770 = cljs.core.deref(output_checker41755_42361);
return (fexpr__41770.cljs$core$IFn$_invoke$arity$1 ? fexpr__41770.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41770.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42377)){
var error__38096__auto___42378 = temp__5804__auto___42377;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42378], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41752_42358,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42378], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41752_42358,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41753_42359], null)));

var ufv___42379 = schema.utils.use_fn_validation;
var output_schema41771_42380 = deercreeklabs.baracus.ByteArray;
var input_schema41772_42381 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41773_42382 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41772_42381);
}),null));
var output_checker41774_42383 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41771_42380);
}),null));
var ret__40711__auto___42384 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41775){
var validate__38094__auto__ = cljs.core.deref(ufv___42379);
if(cljs.core.truth_(validate__38094__auto__)){
var args__38095__auto___42385 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41775], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41776_42386 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41777_42387 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41778_42388 = input_schema41772_42381;
var G__41779_42389 = cljs.core.deref(input_checker41773_42382);
var G__41780_42390 = args__38095__auto___42385;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41776_42386,G__41777_42387,G__41778_42388,G__41779_42389,G__41780_42390) : schema.core.fn_validator.call(null,G__41776_42386,G__41777_42387,G__41778_42388,G__41779_42389,G__41780_42390));
} else {
var temp__5804__auto___42391 = (function (){var fexpr__41781 = cljs.core.deref(input_checker41773_42382);
return (fexpr__41781.cljs$core$IFn$_invoke$arity$1 ? fexpr__41781.cljs$core$IFn$_invoke$arity$1(args__38095__auto___42385) : fexpr__41781.call(null,args__38095__auto___42385));
})();
if(cljs.core.truth_(temp__5804__auto___42391)){
var error__38096__auto___42392 = temp__5804__auto___42391;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42392], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41772_42381,new cljs.core.Keyword(null,"value","value",305978217),args__38095__auto___42385,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42392], null));
} else {
}
}
} else {
}

var o__38098__auto__ = (function (){var ba = G__41775;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38094__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41783_42393 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41784_42394 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41785_42395 = output_schema41771_42380;
var G__41786_42396 = cljs.core.deref(output_checker41774_42383);
var G__41787_42397 = o__38098__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41783_42393,G__41784_42394,G__41785_42395,G__41786_42396,G__41787_42397) : schema.core.fn_validator.call(null,G__41783_42393,G__41784_42394,G__41785_42395,G__41786_42396,G__41787_42397));
} else {
var temp__5804__auto___42398 = (function (){var fexpr__41788 = cljs.core.deref(output_checker41774_42383);
return (fexpr__41788.cljs$core$IFn$_invoke$arity$1 ? fexpr__41788.cljs$core$IFn$_invoke$arity$1(o__38098__auto__) : fexpr__41788.call(null,o__38098__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42398)){
var error__38096__auto___42399 = temp__5804__auto___42398;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38096__auto___42399], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41771_42380,new cljs.core.Keyword(null,"value","value",305978217),o__38098__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38096__auto___42399], null));
} else {
}
}
} else {
}

return o__38098__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41771_42380,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41772_42381], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
