goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30833 = arguments.length;
switch (G__30833) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30861 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30861 = (function (f,blockable,meta30862){
this.f = f;
this.blockable = blockable;
this.meta30862 = meta30862;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30861.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30863,meta30862__$1){
var self__ = this;
var _30863__$1 = this;
return (new cljs.core.async.t_cljs$core$async30861(self__.f,self__.blockable,meta30862__$1));
}));

(cljs.core.async.t_cljs$core$async30861.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30863){
var self__ = this;
var _30863__$1 = this;
return self__.meta30862;
}));

(cljs.core.async.t_cljs$core$async30861.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30861.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30861.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30861.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30861.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30862","meta30862",2026382898,null)], null);
}));

(cljs.core.async.t_cljs$core$async30861.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30861.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30861");

(cljs.core.async.t_cljs$core$async30861.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30861");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30861.
 */
cljs.core.async.__GT_t_cljs$core$async30861 = (function cljs$core$async$__GT_t_cljs$core$async30861(f__$1,blockable__$1,meta30862){
return (new cljs.core.async.t_cljs$core$async30861(f__$1,blockable__$1,meta30862));
});

}

return (new cljs.core.async.t_cljs$core$async30861(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30902 = arguments.length;
switch (G__30902) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30912 = arguments.length;
switch (G__30912) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30921 = arguments.length;
switch (G__30921) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34056 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34056) : fn1.call(null,val_34056));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34056) : fn1.call(null,val_34056));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30934 = arguments.length;
switch (G__30934) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___34105 = n;
var x_34106 = (0);
while(true){
if((x_34106 < n__5636__auto___34105)){
(a[x_34106] = x_34106);

var G__34107 = (x_34106 + (1));
x_34106 = G__34107;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30957 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30957 = (function (flag,meta30958){
this.flag = flag;
this.meta30958 = meta30958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30959,meta30958__$1){
var self__ = this;
var _30959__$1 = this;
return (new cljs.core.async.t_cljs$core$async30957(self__.flag,meta30958__$1));
}));

(cljs.core.async.t_cljs$core$async30957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30959){
var self__ = this;
var _30959__$1 = this;
return self__.meta30958;
}));

(cljs.core.async.t_cljs$core$async30957.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30957.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30957.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30957.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30958","meta30958",851413125,null)], null);
}));

(cljs.core.async.t_cljs$core$async30957.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30957");

(cljs.core.async.t_cljs$core$async30957.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30957");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30957.
 */
cljs.core.async.__GT_t_cljs$core$async30957 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30957(flag__$1,meta30958){
return (new cljs.core.async.t_cljs$core$async30957(flag__$1,meta30958));
});

}

return (new cljs.core.async.t_cljs$core$async30957(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30971 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30971 = (function (flag,cb,meta30972){
this.flag = flag;
this.cb = cb;
this.meta30972 = meta30972;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30971.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30973,meta30972__$1){
var self__ = this;
var _30973__$1 = this;
return (new cljs.core.async.t_cljs$core$async30971(self__.flag,self__.cb,meta30972__$1));
}));

(cljs.core.async.t_cljs$core$async30971.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30973){
var self__ = this;
var _30973__$1 = this;
return self__.meta30972;
}));

(cljs.core.async.t_cljs$core$async30971.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30971.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30971.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30971.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30971.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30972","meta30972",-338355054,null)], null);
}));

(cljs.core.async.t_cljs$core$async30971.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30971.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30971");

(cljs.core.async.t_cljs$core$async30971.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30971");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30971.
 */
cljs.core.async.__GT_t_cljs$core$async30971 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30971(flag__$1,cb__$1,meta30972){
return (new cljs.core.async.t_cljs$core$async30971(flag__$1,cb__$1,meta30972));
});

}

return (new cljs.core.async.t_cljs$core$async30971(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30977_SHARP_){
var G__30981 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30977_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30981) : fret.call(null,G__30981));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30978_SHARP_){
var G__30986 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30978_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30986) : fret.call(null,G__30986));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34151 = (i + (1));
i = G__34151;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34152 = arguments.length;
var i__5770__auto___34153 = (0);
while(true){
if((i__5770__auto___34153 < len__5769__auto___34152)){
args__5775__auto__.push((arguments[i__5770__auto___34153]));

var G__34154 = (i__5770__auto___34153 + (1));
i__5770__auto___34153 = G__34154;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31000){
var map__31001 = p__31000;
var map__31001__$1 = cljs.core.__destructure_map(map__31001);
var opts = map__31001__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30993){
var G__30994 = cljs.core.first(seq30993);
var seq30993__$1 = cljs.core.next(seq30993);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30994,seq30993__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31008 = arguments.length;
switch (G__31008) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30753__auto___34163 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31049){
var state_val_31050 = (state_31049[(1)]);
if((state_val_31050 === (7))){
var inst_31038 = (state_31049[(2)]);
var state_31049__$1 = state_31049;
var statearr_31054_34164 = state_31049__$1;
(statearr_31054_34164[(2)] = inst_31038);

(statearr_31054_34164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (1))){
var state_31049__$1 = state_31049;
var statearr_31059_34167 = state_31049__$1;
(statearr_31059_34167[(2)] = null);

(statearr_31059_34167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (4))){
var inst_31019 = (state_31049[(7)]);
var inst_31019__$1 = (state_31049[(2)]);
var inst_31020 = (inst_31019__$1 == null);
var state_31049__$1 = (function (){var statearr_31060 = state_31049;
(statearr_31060[(7)] = inst_31019__$1);

return statearr_31060;
})();
if(cljs.core.truth_(inst_31020)){
var statearr_31061_34170 = state_31049__$1;
(statearr_31061_34170[(1)] = (5));

} else {
var statearr_31062_34171 = state_31049__$1;
(statearr_31062_34171[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (13))){
var state_31049__$1 = state_31049;
var statearr_31067_34172 = state_31049__$1;
(statearr_31067_34172[(2)] = null);

(statearr_31067_34172[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (6))){
var inst_31019 = (state_31049[(7)]);
var state_31049__$1 = state_31049;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31049__$1,(11),to,inst_31019);
} else {
if((state_val_31050 === (3))){
var inst_31042 = (state_31049[(2)]);
var state_31049__$1 = state_31049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31049__$1,inst_31042);
} else {
if((state_val_31050 === (12))){
var state_31049__$1 = state_31049;
var statearr_31078_34175 = state_31049__$1;
(statearr_31078_34175[(2)] = null);

(statearr_31078_34175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (2))){
var state_31049__$1 = state_31049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31049__$1,(4),from);
} else {
if((state_val_31050 === (11))){
var inst_31030 = (state_31049[(2)]);
var state_31049__$1 = state_31049;
if(cljs.core.truth_(inst_31030)){
var statearr_31079_34176 = state_31049__$1;
(statearr_31079_34176[(1)] = (12));

} else {
var statearr_31080_34177 = state_31049__$1;
(statearr_31080_34177[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (9))){
var state_31049__$1 = state_31049;
var statearr_31087_34178 = state_31049__$1;
(statearr_31087_34178[(2)] = null);

(statearr_31087_34178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (5))){
var state_31049__$1 = state_31049;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31092_34180 = state_31049__$1;
(statearr_31092_34180[(1)] = (8));

} else {
var statearr_31093_34182 = state_31049__$1;
(statearr_31093_34182[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (14))){
var inst_31036 = (state_31049[(2)]);
var state_31049__$1 = state_31049;
var statearr_31094_34183 = state_31049__$1;
(statearr_31094_34183[(2)] = inst_31036);

(statearr_31094_34183[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (10))){
var inst_31027 = (state_31049[(2)]);
var state_31049__$1 = state_31049;
var statearr_31095_34184 = state_31049__$1;
(statearr_31095_34184[(2)] = inst_31027);

(statearr_31095_34184[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31050 === (8))){
var inst_31024 = cljs.core.async.close_BANG_(to);
var state_31049__$1 = state_31049;
var statearr_31096_34185 = state_31049__$1;
(statearr_31096_34185[(2)] = inst_31024);

(statearr_31096_34185[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_31100 = [null,null,null,null,null,null,null,null];
(statearr_31100[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_31100[(1)] = (1));

return statearr_31100;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_31049){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31049);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31102){var ex__30550__auto__ = e31102;
var statearr_31103_34187 = state_31049;
(statearr_31103_34187[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31049[(4)]))){
var statearr_31104_34189 = state_31049;
(statearr_31104_34189[(1)] = cljs.core.first((state_31049[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34190 = state_31049;
state_31049 = G__34190;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_31049){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_31049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31105 = f__30754__auto__();
(statearr_31105[(6)] = c__30753__auto___34163);

return statearr_31105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__31119){
var vec__31120 = p__31119;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31120,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31120,(1),null);
var job = vec__31120;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30753__auto___34194 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31127){
var state_val_31128 = (state_31127[(1)]);
if((state_val_31128 === (1))){
var state_31127__$1 = state_31127;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31127__$1,(2),res,v);
} else {
if((state_val_31128 === (2))){
var inst_31124 = (state_31127[(2)]);
var inst_31125 = cljs.core.async.close_BANG_(res);
var state_31127__$1 = (function (){var statearr_31129 = state_31127;
(statearr_31129[(7)] = inst_31124);

return statearr_31129;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31127__$1,inst_31125);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0 = (function (){
var statearr_31130 = [null,null,null,null,null,null,null,null];
(statearr_31130[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__);

(statearr_31130[(1)] = (1));

return statearr_31130;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1 = (function (state_31127){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31127);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31131){var ex__30550__auto__ = e31131;
var statearr_31132_34208 = state_31127;
(statearr_31132_34208[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31127[(4)]))){
var statearr_31133_34209 = state_31127;
(statearr_31133_34209[(1)] = cljs.core.first((state_31127[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34214 = state_31127;
state_31127 = G__34214;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = function(state_31127){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1.call(this,state_31127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31137 = f__30754__auto__();
(statearr_31137[(6)] = c__30753__auto___34194);

return statearr_31137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31138){
var vec__31139 = p__31138;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31139,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31139,(1),null);
var job = vec__31139;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___34222 = n;
var __34223 = (0);
while(true){
if((__34223 < n__5636__auto___34222)){
var G__31142_34224 = type;
var G__31142_34225__$1 = (((G__31142_34224 instanceof cljs.core.Keyword))?G__31142_34224.fqn:null);
switch (G__31142_34225__$1) {
case "compute":
var c__30753__auto___34228 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34223,c__30753__auto___34228,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async){
return (function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = ((function (__34223,c__30753__auto___34228,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async){
return (function (state_31159){
var state_val_31160 = (state_31159[(1)]);
if((state_val_31160 === (1))){
var state_31159__$1 = state_31159;
var statearr_31165_34230 = state_31159__$1;
(statearr_31165_34230[(2)] = null);

(statearr_31165_34230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31160 === (2))){
var state_31159__$1 = state_31159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31159__$1,(4),jobs);
} else {
if((state_val_31160 === (3))){
var inst_31157 = (state_31159[(2)]);
var state_31159__$1 = state_31159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31159__$1,inst_31157);
} else {
if((state_val_31160 === (4))){
var inst_31148 = (state_31159[(2)]);
var inst_31150 = process__$1(inst_31148);
var state_31159__$1 = state_31159;
if(cljs.core.truth_(inst_31150)){
var statearr_31166_34235 = state_31159__$1;
(statearr_31166_34235[(1)] = (5));

} else {
var statearr_31168_34236 = state_31159__$1;
(statearr_31168_34236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31160 === (5))){
var state_31159__$1 = state_31159;
var statearr_31172_34237 = state_31159__$1;
(statearr_31172_34237[(2)] = null);

(statearr_31172_34237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31160 === (6))){
var state_31159__$1 = state_31159;
var statearr_31179_34238 = state_31159__$1;
(statearr_31179_34238[(2)] = null);

(statearr_31179_34238[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31160 === (7))){
var inst_31155 = (state_31159[(2)]);
var state_31159__$1 = state_31159;
var statearr_31180_34239 = state_31159__$1;
(statearr_31180_34239[(2)] = inst_31155);

(statearr_31180_34239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34223,c__30753__auto___34228,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async))
;
return ((function (__34223,switch__30546__auto__,c__30753__auto___34228,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0 = (function (){
var statearr_31182 = [null,null,null,null,null,null,null];
(statearr_31182[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__);

(statearr_31182[(1)] = (1));

return statearr_31182;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1 = (function (state_31159){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31159);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31184){var ex__30550__auto__ = e31184;
var statearr_31185_34241 = state_31159;
(statearr_31185_34241[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31159[(4)]))){
var statearr_31187_34242 = state_31159;
(statearr_31187_34242[(1)] = cljs.core.first((state_31159[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34243 = state_31159;
state_31159 = G__34243;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = function(state_31159){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1.call(this,state_31159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__;
})()
;})(__34223,switch__30546__auto__,c__30753__auto___34228,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async))
})();
var state__30755__auto__ = (function (){var statearr_31192 = f__30754__auto__();
(statearr_31192[(6)] = c__30753__auto___34228);

return statearr_31192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
});})(__34223,c__30753__auto___34228,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async))
);


break;
case "async":
var c__30753__auto___34244 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34223,c__30753__auto___34244,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async){
return (function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = ((function (__34223,c__30753__auto___34244,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async){
return (function (state_31212){
var state_val_31213 = (state_31212[(1)]);
if((state_val_31213 === (1))){
var state_31212__$1 = state_31212;
var statearr_31222_34245 = state_31212__$1;
(statearr_31222_34245[(2)] = null);

(statearr_31222_34245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (2))){
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31212__$1,(4),jobs);
} else {
if((state_val_31213 === (3))){
var inst_31209 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31212__$1,inst_31209);
} else {
if((state_val_31213 === (4))){
var inst_31199 = (state_31212[(2)]);
var inst_31202 = async(inst_31199);
var state_31212__$1 = state_31212;
if(cljs.core.truth_(inst_31202)){
var statearr_31227_34251 = state_31212__$1;
(statearr_31227_34251[(1)] = (5));

} else {
var statearr_31233_34252 = state_31212__$1;
(statearr_31233_34252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (5))){
var state_31212__$1 = state_31212;
var statearr_31234_34254 = state_31212__$1;
(statearr_31234_34254[(2)] = null);

(statearr_31234_34254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (6))){
var state_31212__$1 = state_31212;
var statearr_31237_34255 = state_31212__$1;
(statearr_31237_34255[(2)] = null);

(statearr_31237_34255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (7))){
var inst_31207 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31238_34256 = state_31212__$1;
(statearr_31238_34256[(2)] = inst_31207);

(statearr_31238_34256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34223,c__30753__auto___34244,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async))
;
return ((function (__34223,switch__30546__auto__,c__30753__auto___34244,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0 = (function (){
var statearr_31240 = [null,null,null,null,null,null,null];
(statearr_31240[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__);

(statearr_31240[(1)] = (1));

return statearr_31240;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1 = (function (state_31212){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31212);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31242){var ex__30550__auto__ = e31242;
var statearr_31243_34258 = state_31212;
(statearr_31243_34258[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31212[(4)]))){
var statearr_31246_34260 = state_31212;
(statearr_31246_34260[(1)] = cljs.core.first((state_31212[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34261 = state_31212;
state_31212 = G__34261;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = function(state_31212){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1.call(this,state_31212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__;
})()
;})(__34223,switch__30546__auto__,c__30753__auto___34244,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async))
})();
var state__30755__auto__ = (function (){var statearr_31249 = f__30754__auto__();
(statearr_31249[(6)] = c__30753__auto___34244);

return statearr_31249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
});})(__34223,c__30753__auto___34244,G__31142_34224,G__31142_34225__$1,n__5636__auto___34222,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31142_34225__$1)].join('')));

}

var G__34262 = (__34223 + (1));
__34223 = G__34262;
continue;
} else {
}
break;
}

var c__30753__auto___34264 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31285){
var state_val_31286 = (state_31285[(1)]);
if((state_val_31286 === (7))){
var inst_31281 = (state_31285[(2)]);
var state_31285__$1 = state_31285;
var statearr_31302_34266 = state_31285__$1;
(statearr_31302_34266[(2)] = inst_31281);

(statearr_31302_34266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31286 === (1))){
var state_31285__$1 = state_31285;
var statearr_31303_34269 = state_31285__$1;
(statearr_31303_34269[(2)] = null);

(statearr_31303_34269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31286 === (4))){
var inst_31260 = (state_31285[(7)]);
var inst_31260__$1 = (state_31285[(2)]);
var inst_31261 = (inst_31260__$1 == null);
var state_31285__$1 = (function (){var statearr_31305 = state_31285;
(statearr_31305[(7)] = inst_31260__$1);

return statearr_31305;
})();
if(cljs.core.truth_(inst_31261)){
var statearr_31306_34270 = state_31285__$1;
(statearr_31306_34270[(1)] = (5));

} else {
var statearr_31309_34272 = state_31285__$1;
(statearr_31309_34272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31286 === (6))){
var inst_31267 = (state_31285[(8)]);
var inst_31260 = (state_31285[(7)]);
var inst_31267__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31270 = [inst_31260,inst_31267__$1];
var inst_31272 = (new cljs.core.PersistentVector(null,2,(5),inst_31269,inst_31270,null));
var state_31285__$1 = (function (){var statearr_31312 = state_31285;
(statearr_31312[(8)] = inst_31267__$1);

return statearr_31312;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31285__$1,(8),jobs,inst_31272);
} else {
if((state_val_31286 === (3))){
var inst_31283 = (state_31285[(2)]);
var state_31285__$1 = state_31285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31285__$1,inst_31283);
} else {
if((state_val_31286 === (2))){
var state_31285__$1 = state_31285;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31285__$1,(4),from);
} else {
if((state_val_31286 === (9))){
var inst_31278 = (state_31285[(2)]);
var state_31285__$1 = (function (){var statearr_31318 = state_31285;
(statearr_31318[(9)] = inst_31278);

return statearr_31318;
})();
var statearr_31319_34274 = state_31285__$1;
(statearr_31319_34274[(2)] = null);

(statearr_31319_34274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31286 === (5))){
var inst_31263 = cljs.core.async.close_BANG_(jobs);
var state_31285__$1 = state_31285;
var statearr_31320_34275 = state_31285__$1;
(statearr_31320_34275[(2)] = inst_31263);

(statearr_31320_34275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31286 === (8))){
var inst_31267 = (state_31285[(8)]);
var inst_31274 = (state_31285[(2)]);
var state_31285__$1 = (function (){var statearr_31322 = state_31285;
(statearr_31322[(10)] = inst_31274);

return statearr_31322;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31285__$1,(9),results,inst_31267);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0 = (function (){
var statearr_31326 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31326[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__);

(statearr_31326[(1)] = (1));

return statearr_31326;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1 = (function (state_31285){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31285);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31327){var ex__30550__auto__ = e31327;
var statearr_31328_34283 = state_31285;
(statearr_31328_34283[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31285[(4)]))){
var statearr_31330_34284 = state_31285;
(statearr_31330_34284[(1)] = cljs.core.first((state_31285[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34286 = state_31285;
state_31285 = G__34286;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = function(state_31285){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1.call(this,state_31285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31331 = f__30754__auto__();
(statearr_31331[(6)] = c__30753__auto___34264);

return statearr_31331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


var c__30753__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31377){
var state_val_31378 = (state_31377[(1)]);
if((state_val_31378 === (7))){
var inst_31372 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
var statearr_31388_34294 = state_31377__$1;
(statearr_31388_34294[(2)] = inst_31372);

(statearr_31388_34294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (20))){
var state_31377__$1 = state_31377;
var statearr_31389_34301 = state_31377__$1;
(statearr_31389_34301[(2)] = null);

(statearr_31389_34301[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (1))){
var state_31377__$1 = state_31377;
var statearr_31395_34304 = state_31377__$1;
(statearr_31395_34304[(2)] = null);

(statearr_31395_34304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (4))){
var inst_31335 = (state_31377[(7)]);
var inst_31335__$1 = (state_31377[(2)]);
var inst_31338 = (inst_31335__$1 == null);
var state_31377__$1 = (function (){var statearr_31398 = state_31377;
(statearr_31398[(7)] = inst_31335__$1);

return statearr_31398;
})();
if(cljs.core.truth_(inst_31338)){
var statearr_31400_34307 = state_31377__$1;
(statearr_31400_34307[(1)] = (5));

} else {
var statearr_31403_34312 = state_31377__$1;
(statearr_31403_34312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (15))){
var inst_31354 = (state_31377[(8)]);
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31377__$1,(18),to,inst_31354);
} else {
if((state_val_31378 === (21))){
var inst_31367 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
var statearr_31404_34313 = state_31377__$1;
(statearr_31404_34313[(2)] = inst_31367);

(statearr_31404_34313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (13))){
var inst_31369 = (state_31377[(2)]);
var state_31377__$1 = (function (){var statearr_31406 = state_31377;
(statearr_31406[(9)] = inst_31369);

return statearr_31406;
})();
var statearr_31407_34317 = state_31377__$1;
(statearr_31407_34317[(2)] = null);

(statearr_31407_34317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (6))){
var inst_31335 = (state_31377[(7)]);
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31377__$1,(11),inst_31335);
} else {
if((state_val_31378 === (17))){
var inst_31362 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
if(cljs.core.truth_(inst_31362)){
var statearr_31409_34325 = state_31377__$1;
(statearr_31409_34325[(1)] = (19));

} else {
var statearr_31410_34326 = state_31377__$1;
(statearr_31410_34326[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (3))){
var inst_31374 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31377__$1,inst_31374);
} else {
if((state_val_31378 === (12))){
var inst_31351 = (state_31377[(10)]);
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31377__$1,(14),inst_31351);
} else {
if((state_val_31378 === (2))){
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31377__$1,(4),results);
} else {
if((state_val_31378 === (19))){
var state_31377__$1 = state_31377;
var statearr_31418_34330 = state_31377__$1;
(statearr_31418_34330[(2)] = null);

(statearr_31418_34330[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (11))){
var inst_31351 = (state_31377[(2)]);
var state_31377__$1 = (function (){var statearr_31421 = state_31377;
(statearr_31421[(10)] = inst_31351);

return statearr_31421;
})();
var statearr_31424_34331 = state_31377__$1;
(statearr_31424_34331[(2)] = null);

(statearr_31424_34331[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (9))){
var state_31377__$1 = state_31377;
var statearr_31426_34332 = state_31377__$1;
(statearr_31426_34332[(2)] = null);

(statearr_31426_34332[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (5))){
var state_31377__$1 = state_31377;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31427_34339 = state_31377__$1;
(statearr_31427_34339[(1)] = (8));

} else {
var statearr_31428_34340 = state_31377__$1;
(statearr_31428_34340[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (14))){
var inst_31354 = (state_31377[(8)]);
var inst_31356 = (state_31377[(11)]);
var inst_31354__$1 = (state_31377[(2)]);
var inst_31355 = (inst_31354__$1 == null);
var inst_31356__$1 = cljs.core.not(inst_31355);
var state_31377__$1 = (function (){var statearr_31430 = state_31377;
(statearr_31430[(8)] = inst_31354__$1);

(statearr_31430[(11)] = inst_31356__$1);

return statearr_31430;
})();
if(inst_31356__$1){
var statearr_31431_34351 = state_31377__$1;
(statearr_31431_34351[(1)] = (15));

} else {
var statearr_31432_34355 = state_31377__$1;
(statearr_31432_34355[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (16))){
var inst_31356 = (state_31377[(11)]);
var state_31377__$1 = state_31377;
var statearr_31438_34356 = state_31377__$1;
(statearr_31438_34356[(2)] = inst_31356);

(statearr_31438_34356[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (10))){
var inst_31347 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
var statearr_31441_34357 = state_31377__$1;
(statearr_31441_34357[(2)] = inst_31347);

(statearr_31441_34357[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (18))){
var inst_31359 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
var statearr_31442_34358 = state_31377__$1;
(statearr_31442_34358[(2)] = inst_31359);

(statearr_31442_34358[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31378 === (8))){
var inst_31344 = cljs.core.async.close_BANG_(to);
var state_31377__$1 = state_31377;
var statearr_31444_34363 = state_31377__$1;
(statearr_31444_34363[(2)] = inst_31344);

(statearr_31444_34363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0 = (function (){
var statearr_31446 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31446[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__);

(statearr_31446[(1)] = (1));

return statearr_31446;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1 = (function (state_31377){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31377);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31447){var ex__30550__auto__ = e31447;
var statearr_31448_34371 = state_31377;
(statearr_31448_34371[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31377[(4)]))){
var statearr_31449_34372 = state_31377;
(statearr_31449_34372[(1)] = cljs.core.first((state_31377[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34373 = state_31377;
state_31377 = G__34373;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__ = function(state_31377){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1.call(this,state_31377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30547__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31456 = f__30754__auto__();
(statearr_31456[(6)] = c__30753__auto__);

return statearr_31456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

return c__30753__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31472 = arguments.length;
switch (G__31472) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31493 = arguments.length;
switch (G__31493) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31503 = arguments.length;
switch (G__31503) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30753__auto___34399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31534){
var state_val_31535 = (state_31534[(1)]);
if((state_val_31535 === (7))){
var inst_31530 = (state_31534[(2)]);
var state_31534__$1 = state_31534;
var statearr_31539_34401 = state_31534__$1;
(statearr_31539_34401[(2)] = inst_31530);

(statearr_31539_34401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (1))){
var state_31534__$1 = state_31534;
var statearr_31541_34402 = state_31534__$1;
(statearr_31541_34402[(2)] = null);

(statearr_31541_34402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (4))){
var inst_31509 = (state_31534[(7)]);
var inst_31509__$1 = (state_31534[(2)]);
var inst_31510 = (inst_31509__$1 == null);
var state_31534__$1 = (function (){var statearr_31543 = state_31534;
(statearr_31543[(7)] = inst_31509__$1);

return statearr_31543;
})();
if(cljs.core.truth_(inst_31510)){
var statearr_31544_34403 = state_31534__$1;
(statearr_31544_34403[(1)] = (5));

} else {
var statearr_31545_34404 = state_31534__$1;
(statearr_31545_34404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (13))){
var state_31534__$1 = state_31534;
var statearr_31547_34405 = state_31534__$1;
(statearr_31547_34405[(2)] = null);

(statearr_31547_34405[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (6))){
var inst_31509 = (state_31534[(7)]);
var inst_31517 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31509) : p.call(null,inst_31509));
var state_31534__$1 = state_31534;
if(cljs.core.truth_(inst_31517)){
var statearr_31548_34406 = state_31534__$1;
(statearr_31548_34406[(1)] = (9));

} else {
var statearr_31549_34407 = state_31534__$1;
(statearr_31549_34407[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (3))){
var inst_31532 = (state_31534[(2)]);
var state_31534__$1 = state_31534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31534__$1,inst_31532);
} else {
if((state_val_31535 === (12))){
var state_31534__$1 = state_31534;
var statearr_31550_34408 = state_31534__$1;
(statearr_31550_34408[(2)] = null);

(statearr_31550_34408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (2))){
var state_31534__$1 = state_31534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31534__$1,(4),ch);
} else {
if((state_val_31535 === (11))){
var inst_31509 = (state_31534[(7)]);
var inst_31521 = (state_31534[(2)]);
var state_31534__$1 = state_31534;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31534__$1,(8),inst_31521,inst_31509);
} else {
if((state_val_31535 === (9))){
var state_31534__$1 = state_31534;
var statearr_31580_34414 = state_31534__$1;
(statearr_31580_34414[(2)] = tc);

(statearr_31580_34414[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (5))){
var inst_31514 = cljs.core.async.close_BANG_(tc);
var inst_31515 = cljs.core.async.close_BANG_(fc);
var state_31534__$1 = (function (){var statearr_31585 = state_31534;
(statearr_31585[(8)] = inst_31514);

return statearr_31585;
})();
var statearr_31586_34416 = state_31534__$1;
(statearr_31586_34416[(2)] = inst_31515);

(statearr_31586_34416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (14))){
var inst_31528 = (state_31534[(2)]);
var state_31534__$1 = state_31534;
var statearr_31587_34417 = state_31534__$1;
(statearr_31587_34417[(2)] = inst_31528);

(statearr_31587_34417[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (10))){
var state_31534__$1 = state_31534;
var statearr_31588_34419 = state_31534__$1;
(statearr_31588_34419[(2)] = fc);

(statearr_31588_34419[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31535 === (8))){
var inst_31523 = (state_31534[(2)]);
var state_31534__$1 = state_31534;
if(cljs.core.truth_(inst_31523)){
var statearr_31590_34421 = state_31534__$1;
(statearr_31590_34421[(1)] = (12));

} else {
var statearr_31592_34422 = state_31534__$1;
(statearr_31592_34422[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_31617 = [null,null,null,null,null,null,null,null,null];
(statearr_31617[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_31617[(1)] = (1));

return statearr_31617;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_31534){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31534);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31629){var ex__30550__auto__ = e31629;
var statearr_31634_34423 = state_31534;
(statearr_31634_34423[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31534[(4)]))){
var statearr_31635_34424 = state_31534;
(statearr_31635_34424[(1)] = cljs.core.first((state_31534[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34425 = state_31534;
state_31534 = G__34425;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_31534){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_31534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31641 = f__30754__auto__();
(statearr_31641[(6)] = c__30753__auto___34399);

return statearr_31641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30753__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31697){
var state_val_31698 = (state_31697[(1)]);
if((state_val_31698 === (7))){
var inst_31691 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31704_34426 = state_31697__$1;
(statearr_31704_34426[(2)] = inst_31691);

(statearr_31704_34426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (1))){
var inst_31666 = init;
var inst_31668 = inst_31666;
var state_31697__$1 = (function (){var statearr_31705 = state_31697;
(statearr_31705[(7)] = inst_31668);

return statearr_31705;
})();
var statearr_31706_34433 = state_31697__$1;
(statearr_31706_34433[(2)] = null);

(statearr_31706_34433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (4))){
var inst_31674 = (state_31697[(8)]);
var inst_31674__$1 = (state_31697[(2)]);
var inst_31675 = (inst_31674__$1 == null);
var state_31697__$1 = (function (){var statearr_31707 = state_31697;
(statearr_31707[(8)] = inst_31674__$1);

return statearr_31707;
})();
if(cljs.core.truth_(inst_31675)){
var statearr_31708_34434 = state_31697__$1;
(statearr_31708_34434[(1)] = (5));

} else {
var statearr_31709_34435 = state_31697__$1;
(statearr_31709_34435[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (6))){
var inst_31668 = (state_31697[(7)]);
var inst_31674 = (state_31697[(8)]);
var inst_31682 = (state_31697[(9)]);
var inst_31682__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31668,inst_31674) : f.call(null,inst_31668,inst_31674));
var inst_31683 = cljs.core.reduced_QMARK_(inst_31682__$1);
var state_31697__$1 = (function (){var statearr_31710 = state_31697;
(statearr_31710[(9)] = inst_31682__$1);

return statearr_31710;
})();
if(inst_31683){
var statearr_31711_34445 = state_31697__$1;
(statearr_31711_34445[(1)] = (8));

} else {
var statearr_31713_34452 = state_31697__$1;
(statearr_31713_34452[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (3))){
var inst_31693 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31697__$1,inst_31693);
} else {
if((state_val_31698 === (2))){
var state_31697__$1 = state_31697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31697__$1,(4),ch);
} else {
if((state_val_31698 === (9))){
var inst_31682 = (state_31697[(9)]);
var inst_31668 = inst_31682;
var state_31697__$1 = (function (){var statearr_31727 = state_31697;
(statearr_31727[(7)] = inst_31668);

return statearr_31727;
})();
var statearr_31728_34456 = state_31697__$1;
(statearr_31728_34456[(2)] = null);

(statearr_31728_34456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (5))){
var inst_31668 = (state_31697[(7)]);
var state_31697__$1 = state_31697;
var statearr_31729_34461 = state_31697__$1;
(statearr_31729_34461[(2)] = inst_31668);

(statearr_31729_34461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (10))){
var inst_31689 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31734_34470 = state_31697__$1;
(statearr_31734_34470[(2)] = inst_31689);

(statearr_31734_34470[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (8))){
var inst_31682 = (state_31697[(9)]);
var inst_31685 = cljs.core.deref(inst_31682);
var state_31697__$1 = state_31697;
var statearr_31735_34471 = state_31697__$1;
(statearr_31735_34471[(2)] = inst_31685);

(statearr_31735_34471[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__30547__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30547__auto____0 = (function (){
var statearr_31736 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31736[(0)] = cljs$core$async$reduce_$_state_machine__30547__auto__);

(statearr_31736[(1)] = (1));

return statearr_31736;
});
var cljs$core$async$reduce_$_state_machine__30547__auto____1 = (function (state_31697){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31697);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31737){var ex__30550__auto__ = e31737;
var statearr_31738_34474 = state_31697;
(statearr_31738_34474[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31697[(4)]))){
var statearr_31739_34475 = state_31697;
(statearr_31739_34475[(1)] = cljs.core.first((state_31697[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34476 = state_31697;
state_31697 = G__34476;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30547__auto__ = function(state_31697){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30547__auto____1.call(this,state_31697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30547__auto____0;
cljs$core$async$reduce_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30547__auto____1;
return cljs$core$async$reduce_$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31740 = f__30754__auto__();
(statearr_31740[(6)] = c__30753__auto__);

return statearr_31740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

return c__30753__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30753__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31750){
var state_val_31751 = (state_31750[(1)]);
if((state_val_31751 === (1))){
var inst_31745 = cljs.core.async.reduce(f__$1,init,ch);
var state_31750__$1 = state_31750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31750__$1,(2),inst_31745);
} else {
if((state_val_31751 === (2))){
var inst_31747 = (state_31750[(2)]);
var inst_31748 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31747) : f__$1.call(null,inst_31747));
var state_31750__$1 = state_31750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31750__$1,inst_31748);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__30547__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30547__auto____0 = (function (){
var statearr_31762 = [null,null,null,null,null,null,null];
(statearr_31762[(0)] = cljs$core$async$transduce_$_state_machine__30547__auto__);

(statearr_31762[(1)] = (1));

return statearr_31762;
});
var cljs$core$async$transduce_$_state_machine__30547__auto____1 = (function (state_31750){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31750);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31763){var ex__30550__auto__ = e31763;
var statearr_31764_34477 = state_31750;
(statearr_31764_34477[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31750[(4)]))){
var statearr_31765_34478 = state_31750;
(statearr_31765_34478[(1)] = cljs.core.first((state_31750[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34485 = state_31750;
state_31750 = G__34485;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30547__auto__ = function(state_31750){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30547__auto____1.call(this,state_31750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30547__auto____0;
cljs$core$async$transduce_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30547__auto____1;
return cljs$core$async$transduce_$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31770 = f__30754__auto__();
(statearr_31770[(6)] = c__30753__auto__);

return statearr_31770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

return c__30753__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31773 = arguments.length;
switch (G__31773) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30753__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_31831){
var state_val_31833 = (state_31831[(1)]);
if((state_val_31833 === (7))){
var inst_31793 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31836_34487 = state_31831__$1;
(statearr_31836_34487[(2)] = inst_31793);

(statearr_31836_34487[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (1))){
var inst_31787 = cljs.core.seq(coll);
var inst_31788 = inst_31787;
var state_31831__$1 = (function (){var statearr_31837 = state_31831;
(statearr_31837[(7)] = inst_31788);

return statearr_31837;
})();
var statearr_31838_34488 = state_31831__$1;
(statearr_31838_34488[(2)] = null);

(statearr_31838_34488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (4))){
var inst_31788 = (state_31831[(7)]);
var inst_31791 = cljs.core.first(inst_31788);
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31831__$1,(7),ch,inst_31791);
} else {
if((state_val_31833 === (13))){
var inst_31824 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31839_34491 = state_31831__$1;
(statearr_31839_34491[(2)] = inst_31824);

(statearr_31839_34491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (6))){
var inst_31815 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
if(cljs.core.truth_(inst_31815)){
var statearr_31844_34492 = state_31831__$1;
(statearr_31844_34492[(1)] = (8));

} else {
var statearr_31845_34493 = state_31831__$1;
(statearr_31845_34493[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (3))){
var inst_31828 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31831__$1,inst_31828);
} else {
if((state_val_31833 === (12))){
var state_31831__$1 = state_31831;
var statearr_31846_34495 = state_31831__$1;
(statearr_31846_34495[(2)] = null);

(statearr_31846_34495[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (2))){
var inst_31788 = (state_31831[(7)]);
var state_31831__$1 = state_31831;
if(cljs.core.truth_(inst_31788)){
var statearr_31847_34502 = state_31831__$1;
(statearr_31847_34502[(1)] = (4));

} else {
var statearr_31848_34503 = state_31831__$1;
(statearr_31848_34503[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (11))){
var inst_31821 = cljs.core.async.close_BANG_(ch);
var state_31831__$1 = state_31831;
var statearr_31850_34504 = state_31831__$1;
(statearr_31850_34504[(2)] = inst_31821);

(statearr_31850_34504[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (9))){
var state_31831__$1 = state_31831;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31851_34505 = state_31831__$1;
(statearr_31851_34505[(1)] = (11));

} else {
var statearr_31852_34506 = state_31831__$1;
(statearr_31852_34506[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (5))){
var inst_31788 = (state_31831[(7)]);
var state_31831__$1 = state_31831;
var statearr_31855_34507 = state_31831__$1;
(statearr_31855_34507[(2)] = inst_31788);

(statearr_31855_34507[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (10))){
var inst_31826 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31856_34508 = state_31831__$1;
(statearr_31856_34508[(2)] = inst_31826);

(statearr_31856_34508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31833 === (8))){
var inst_31788 = (state_31831[(7)]);
var inst_31817 = cljs.core.next(inst_31788);
var inst_31788__$1 = inst_31817;
var state_31831__$1 = (function (){var statearr_31859 = state_31831;
(statearr_31859[(7)] = inst_31788__$1);

return statearr_31859;
})();
var statearr_31860_34512 = state_31831__$1;
(statearr_31860_34512[(2)] = null);

(statearr_31860_34512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_31861 = [null,null,null,null,null,null,null,null];
(statearr_31861[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_31861[(1)] = (1));

return statearr_31861;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_31831){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_31831);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e31866){var ex__30550__auto__ = e31866;
var statearr_31867_34519 = state_31831;
(statearr_31867_34519[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_31831[(4)]))){
var statearr_31868_34520 = state_31831;
(statearr_31868_34520[(1)] = cljs.core.first((state_31831[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34521 = state_31831;
state_31831 = G__34521;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_31831){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_31831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_31875 = f__30754__auto__();
(statearr_31875[(6)] = c__30753__auto__);

return statearr_31875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

return c__30753__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31882 = arguments.length;
switch (G__31882) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34532 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34532(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34533 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34533(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34542 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34542(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34549 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34549(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31923 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31923 = (function (ch,cs,meta31924){
this.ch = ch;
this.cs = cs;
this.meta31924 = meta31924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31925,meta31924__$1){
var self__ = this;
var _31925__$1 = this;
return (new cljs.core.async.t_cljs$core$async31923(self__.ch,self__.cs,meta31924__$1));
}));

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31925){
var self__ = this;
var _31925__$1 = this;
return self__.meta31924;
}));

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31923.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31923.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31924","meta31924",-1875583225,null)], null);
}));

(cljs.core.async.t_cljs$core$async31923.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31923");

(cljs.core.async.t_cljs$core$async31923.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31923");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31923.
 */
cljs.core.async.__GT_t_cljs$core$async31923 = (function cljs$core$async$mult_$___GT_t_cljs$core$async31923(ch__$1,cs__$1,meta31924){
return (new cljs.core.async.t_cljs$core$async31923(ch__$1,cs__$1,meta31924));
});

}

return (new cljs.core.async.t_cljs$core$async31923(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30753__auto___34576 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_32094){
var state_val_32095 = (state_32094[(1)]);
if((state_val_32095 === (7))){
var inst_32089 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32100_34579 = state_32094__$1;
(statearr_32100_34579[(2)] = inst_32089);

(statearr_32100_34579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (20))){
var inst_31989 = (state_32094[(7)]);
var inst_32001 = cljs.core.first(inst_31989);
var inst_32002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32001,(0),null);
var inst_32003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32001,(1),null);
var state_32094__$1 = (function (){var statearr_32103 = state_32094;
(statearr_32103[(8)] = inst_32002);

return statearr_32103;
})();
if(cljs.core.truth_(inst_32003)){
var statearr_32106_34587 = state_32094__$1;
(statearr_32106_34587[(1)] = (22));

} else {
var statearr_32108_34588 = state_32094__$1;
(statearr_32108_34588[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (27))){
var inst_32033 = (state_32094[(9)]);
var inst_31957 = (state_32094[(10)]);
var inst_32039 = (state_32094[(11)]);
var inst_32031 = (state_32094[(12)]);
var inst_32039__$1 = cljs.core._nth(inst_32031,inst_32033);
var inst_32040 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32039__$1,inst_31957,done);
var state_32094__$1 = (function (){var statearr_32113 = state_32094;
(statearr_32113[(11)] = inst_32039__$1);

return statearr_32113;
})();
if(cljs.core.truth_(inst_32040)){
var statearr_32114_34594 = state_32094__$1;
(statearr_32114_34594[(1)] = (30));

} else {
var statearr_32117_34597 = state_32094__$1;
(statearr_32117_34597[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (1))){
var state_32094__$1 = state_32094;
var statearr_32118_34598 = state_32094__$1;
(statearr_32118_34598[(2)] = null);

(statearr_32118_34598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (24))){
var inst_31989 = (state_32094[(7)]);
var inst_32008 = (state_32094[(2)]);
var inst_32009 = cljs.core.next(inst_31989);
var inst_31966 = inst_32009;
var inst_31967 = null;
var inst_31968 = (0);
var inst_31969 = (0);
var state_32094__$1 = (function (){var statearr_32122 = state_32094;
(statearr_32122[(13)] = inst_31967);

(statearr_32122[(14)] = inst_31966);

(statearr_32122[(15)] = inst_31969);

(statearr_32122[(16)] = inst_31968);

(statearr_32122[(17)] = inst_32008);

return statearr_32122;
})();
var statearr_32123_34612 = state_32094__$1;
(statearr_32123_34612[(2)] = null);

(statearr_32123_34612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (39))){
var state_32094__$1 = state_32094;
var statearr_32133_34616 = state_32094__$1;
(statearr_32133_34616[(2)] = null);

(statearr_32133_34616[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (4))){
var inst_31957 = (state_32094[(10)]);
var inst_31957__$1 = (state_32094[(2)]);
var inst_31958 = (inst_31957__$1 == null);
var state_32094__$1 = (function (){var statearr_32136 = state_32094;
(statearr_32136[(10)] = inst_31957__$1);

return statearr_32136;
})();
if(cljs.core.truth_(inst_31958)){
var statearr_32137_34622 = state_32094__$1;
(statearr_32137_34622[(1)] = (5));

} else {
var statearr_32138_34624 = state_32094__$1;
(statearr_32138_34624[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (15))){
var inst_31967 = (state_32094[(13)]);
var inst_31966 = (state_32094[(14)]);
var inst_31969 = (state_32094[(15)]);
var inst_31968 = (state_32094[(16)]);
var inst_31985 = (state_32094[(2)]);
var inst_31986 = (inst_31969 + (1));
var tmp32124 = inst_31967;
var tmp32125 = inst_31966;
var tmp32126 = inst_31968;
var inst_31966__$1 = tmp32125;
var inst_31967__$1 = tmp32124;
var inst_31968__$1 = tmp32126;
var inst_31969__$1 = inst_31986;
var state_32094__$1 = (function (){var statearr_32142 = state_32094;
(statearr_32142[(13)] = inst_31967__$1);

(statearr_32142[(14)] = inst_31966__$1);

(statearr_32142[(15)] = inst_31969__$1);

(statearr_32142[(16)] = inst_31968__$1);

(statearr_32142[(18)] = inst_31985);

return statearr_32142;
})();
var statearr_32146_34638 = state_32094__$1;
(statearr_32146_34638[(2)] = null);

(statearr_32146_34638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (21))){
var inst_32012 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32151_34644 = state_32094__$1;
(statearr_32151_34644[(2)] = inst_32012);

(statearr_32151_34644[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (31))){
var inst_32039 = (state_32094[(11)]);
var inst_32043 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32039);
var state_32094__$1 = state_32094;
var statearr_32156_34646 = state_32094__$1;
(statearr_32156_34646[(2)] = inst_32043);

(statearr_32156_34646[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (32))){
var inst_32032 = (state_32094[(19)]);
var inst_32033 = (state_32094[(9)]);
var inst_32030 = (state_32094[(20)]);
var inst_32031 = (state_32094[(12)]);
var inst_32045 = (state_32094[(2)]);
var inst_32047 = (inst_32033 + (1));
var tmp32147 = inst_32032;
var tmp32148 = inst_32030;
var tmp32149 = inst_32031;
var inst_32030__$1 = tmp32148;
var inst_32031__$1 = tmp32149;
var inst_32032__$1 = tmp32147;
var inst_32033__$1 = inst_32047;
var state_32094__$1 = (function (){var statearr_32159 = state_32094;
(statearr_32159[(19)] = inst_32032__$1);

(statearr_32159[(9)] = inst_32033__$1);

(statearr_32159[(20)] = inst_32030__$1);

(statearr_32159[(12)] = inst_32031__$1);

(statearr_32159[(21)] = inst_32045);

return statearr_32159;
})();
var statearr_32163_34649 = state_32094__$1;
(statearr_32163_34649[(2)] = null);

(statearr_32163_34649[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (40))){
var inst_32061 = (state_32094[(22)]);
var inst_32065 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32061);
var state_32094__$1 = state_32094;
var statearr_32164_34653 = state_32094__$1;
(statearr_32164_34653[(2)] = inst_32065);

(statearr_32164_34653[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (33))){
var inst_32050 = (state_32094[(23)]);
var inst_32053 = cljs.core.chunked_seq_QMARK_(inst_32050);
var state_32094__$1 = state_32094;
if(inst_32053){
var statearr_32168_34659 = state_32094__$1;
(statearr_32168_34659[(1)] = (36));

} else {
var statearr_32169_34664 = state_32094__$1;
(statearr_32169_34664[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (13))){
var inst_31978 = (state_32094[(24)]);
var inst_31982 = cljs.core.async.close_BANG_(inst_31978);
var state_32094__$1 = state_32094;
var statearr_32171_34670 = state_32094__$1;
(statearr_32171_34670[(2)] = inst_31982);

(statearr_32171_34670[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (22))){
var inst_32002 = (state_32094[(8)]);
var inst_32005 = cljs.core.async.close_BANG_(inst_32002);
var state_32094__$1 = state_32094;
var statearr_32180_34672 = state_32094__$1;
(statearr_32180_34672[(2)] = inst_32005);

(statearr_32180_34672[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (36))){
var inst_32050 = (state_32094[(23)]);
var inst_32056 = cljs.core.chunk_first(inst_32050);
var inst_32057 = cljs.core.chunk_rest(inst_32050);
var inst_32058 = cljs.core.count(inst_32056);
var inst_32030 = inst_32057;
var inst_32031 = inst_32056;
var inst_32032 = inst_32058;
var inst_32033 = (0);
var state_32094__$1 = (function (){var statearr_32183 = state_32094;
(statearr_32183[(19)] = inst_32032);

(statearr_32183[(9)] = inst_32033);

(statearr_32183[(20)] = inst_32030);

(statearr_32183[(12)] = inst_32031);

return statearr_32183;
})();
var statearr_32184_34674 = state_32094__$1;
(statearr_32184_34674[(2)] = null);

(statearr_32184_34674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (41))){
var inst_32050 = (state_32094[(23)]);
var inst_32067 = (state_32094[(2)]);
var inst_32068 = cljs.core.next(inst_32050);
var inst_32030 = inst_32068;
var inst_32031 = null;
var inst_32032 = (0);
var inst_32033 = (0);
var state_32094__$1 = (function (){var statearr_32185 = state_32094;
(statearr_32185[(19)] = inst_32032);

(statearr_32185[(9)] = inst_32033);

(statearr_32185[(20)] = inst_32030);

(statearr_32185[(25)] = inst_32067);

(statearr_32185[(12)] = inst_32031);

return statearr_32185;
})();
var statearr_32186_34679 = state_32094__$1;
(statearr_32186_34679[(2)] = null);

(statearr_32186_34679[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (43))){
var state_32094__$1 = state_32094;
var statearr_32188_34686 = state_32094__$1;
(statearr_32188_34686[(2)] = null);

(statearr_32188_34686[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (29))){
var inst_32076 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32189_34689 = state_32094__$1;
(statearr_32189_34689[(2)] = inst_32076);

(statearr_32189_34689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (44))){
var inst_32086 = (state_32094[(2)]);
var state_32094__$1 = (function (){var statearr_32191 = state_32094;
(statearr_32191[(26)] = inst_32086);

return statearr_32191;
})();
var statearr_32192_34693 = state_32094__$1;
(statearr_32192_34693[(2)] = null);

(statearr_32192_34693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (6))){
var inst_32022 = (state_32094[(27)]);
var inst_32021 = cljs.core.deref(cs);
var inst_32022__$1 = cljs.core.keys(inst_32021);
var inst_32023 = cljs.core.count(inst_32022__$1);
var inst_32024 = cljs.core.reset_BANG_(dctr,inst_32023);
var inst_32029 = cljs.core.seq(inst_32022__$1);
var inst_32030 = inst_32029;
var inst_32031 = null;
var inst_32032 = (0);
var inst_32033 = (0);
var state_32094__$1 = (function (){var statearr_32194 = state_32094;
(statearr_32194[(28)] = inst_32024);

(statearr_32194[(19)] = inst_32032);

(statearr_32194[(9)] = inst_32033);

(statearr_32194[(20)] = inst_32030);

(statearr_32194[(27)] = inst_32022__$1);

(statearr_32194[(12)] = inst_32031);

return statearr_32194;
})();
var statearr_32195_34704 = state_32094__$1;
(statearr_32195_34704[(2)] = null);

(statearr_32195_34704[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (28))){
var inst_32050 = (state_32094[(23)]);
var inst_32030 = (state_32094[(20)]);
var inst_32050__$1 = cljs.core.seq(inst_32030);
var state_32094__$1 = (function (){var statearr_32196 = state_32094;
(statearr_32196[(23)] = inst_32050__$1);

return statearr_32196;
})();
if(inst_32050__$1){
var statearr_32199_34714 = state_32094__$1;
(statearr_32199_34714[(1)] = (33));

} else {
var statearr_32200_34725 = state_32094__$1;
(statearr_32200_34725[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (25))){
var inst_32032 = (state_32094[(19)]);
var inst_32033 = (state_32094[(9)]);
var inst_32036 = (inst_32033 < inst_32032);
var inst_32037 = inst_32036;
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32037)){
var statearr_32203_34726 = state_32094__$1;
(statearr_32203_34726[(1)] = (27));

} else {
var statearr_32204_34732 = state_32094__$1;
(statearr_32204_34732[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (34))){
var state_32094__$1 = state_32094;
var statearr_32205_34734 = state_32094__$1;
(statearr_32205_34734[(2)] = null);

(statearr_32205_34734[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (17))){
var state_32094__$1 = state_32094;
var statearr_32207_34740 = state_32094__$1;
(statearr_32207_34740[(2)] = null);

(statearr_32207_34740[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (3))){
var inst_32091 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32094__$1,inst_32091);
} else {
if((state_val_32095 === (12))){
var inst_32017 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32208_34743 = state_32094__$1;
(statearr_32208_34743[(2)] = inst_32017);

(statearr_32208_34743[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (2))){
var state_32094__$1 = state_32094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32094__$1,(4),ch);
} else {
if((state_val_32095 === (23))){
var state_32094__$1 = state_32094;
var statearr_32213_34746 = state_32094__$1;
(statearr_32213_34746[(2)] = null);

(statearr_32213_34746[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (35))){
var inst_32074 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32214_34754 = state_32094__$1;
(statearr_32214_34754[(2)] = inst_32074);

(statearr_32214_34754[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (19))){
var inst_31989 = (state_32094[(7)]);
var inst_31993 = cljs.core.chunk_first(inst_31989);
var inst_31994 = cljs.core.chunk_rest(inst_31989);
var inst_31995 = cljs.core.count(inst_31993);
var inst_31966 = inst_31994;
var inst_31967 = inst_31993;
var inst_31968 = inst_31995;
var inst_31969 = (0);
var state_32094__$1 = (function (){var statearr_32215 = state_32094;
(statearr_32215[(13)] = inst_31967);

(statearr_32215[(14)] = inst_31966);

(statearr_32215[(15)] = inst_31969);

(statearr_32215[(16)] = inst_31968);

return statearr_32215;
})();
var statearr_32216_34763 = state_32094__$1;
(statearr_32216_34763[(2)] = null);

(statearr_32216_34763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (11))){
var inst_31966 = (state_32094[(14)]);
var inst_31989 = (state_32094[(7)]);
var inst_31989__$1 = cljs.core.seq(inst_31966);
var state_32094__$1 = (function (){var statearr_32218 = state_32094;
(statearr_32218[(7)] = inst_31989__$1);

return statearr_32218;
})();
if(inst_31989__$1){
var statearr_32219_34776 = state_32094__$1;
(statearr_32219_34776[(1)] = (16));

} else {
var statearr_32220_34778 = state_32094__$1;
(statearr_32220_34778[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (9))){
var inst_32019 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32222_34783 = state_32094__$1;
(statearr_32222_34783[(2)] = inst_32019);

(statearr_32222_34783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (5))){
var inst_31964 = cljs.core.deref(cs);
var inst_31965 = cljs.core.seq(inst_31964);
var inst_31966 = inst_31965;
var inst_31967 = null;
var inst_31968 = (0);
var inst_31969 = (0);
var state_32094__$1 = (function (){var statearr_32224 = state_32094;
(statearr_32224[(13)] = inst_31967);

(statearr_32224[(14)] = inst_31966);

(statearr_32224[(15)] = inst_31969);

(statearr_32224[(16)] = inst_31968);

return statearr_32224;
})();
var statearr_32225_34789 = state_32094__$1;
(statearr_32225_34789[(2)] = null);

(statearr_32225_34789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (14))){
var state_32094__$1 = state_32094;
var statearr_32226_34793 = state_32094__$1;
(statearr_32226_34793[(2)] = null);

(statearr_32226_34793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (45))){
var inst_32083 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32227_34799 = state_32094__$1;
(statearr_32227_34799[(2)] = inst_32083);

(statearr_32227_34799[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (26))){
var inst_32022 = (state_32094[(27)]);
var inst_32078 = (state_32094[(2)]);
var inst_32079 = cljs.core.seq(inst_32022);
var state_32094__$1 = (function (){var statearr_32229 = state_32094;
(statearr_32229[(29)] = inst_32078);

return statearr_32229;
})();
if(inst_32079){
var statearr_32230_34806 = state_32094__$1;
(statearr_32230_34806[(1)] = (42));

} else {
var statearr_32231_34807 = state_32094__$1;
(statearr_32231_34807[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (16))){
var inst_31989 = (state_32094[(7)]);
var inst_31991 = cljs.core.chunked_seq_QMARK_(inst_31989);
var state_32094__$1 = state_32094;
if(inst_31991){
var statearr_32233_34813 = state_32094__$1;
(statearr_32233_34813[(1)] = (19));

} else {
var statearr_32235_34816 = state_32094__$1;
(statearr_32235_34816[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (38))){
var inst_32071 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32238_34817 = state_32094__$1;
(statearr_32238_34817[(2)] = inst_32071);

(statearr_32238_34817[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (30))){
var state_32094__$1 = state_32094;
var statearr_32239_34820 = state_32094__$1;
(statearr_32239_34820[(2)] = null);

(statearr_32239_34820[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (10))){
var inst_31967 = (state_32094[(13)]);
var inst_31969 = (state_32094[(15)]);
var inst_31977 = cljs.core._nth(inst_31967,inst_31969);
var inst_31978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31977,(0),null);
var inst_31979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31977,(1),null);
var state_32094__$1 = (function (){var statearr_32241 = state_32094;
(statearr_32241[(24)] = inst_31978);

return statearr_32241;
})();
if(cljs.core.truth_(inst_31979)){
var statearr_32242_34826 = state_32094__$1;
(statearr_32242_34826[(1)] = (13));

} else {
var statearr_32245_34832 = state_32094__$1;
(statearr_32245_34832[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (18))){
var inst_32015 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32248_34836 = state_32094__$1;
(statearr_32248_34836[(2)] = inst_32015);

(statearr_32248_34836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (42))){
var state_32094__$1 = state_32094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32094__$1,(45),dchan);
} else {
if((state_val_32095 === (37))){
var inst_32050 = (state_32094[(23)]);
var inst_31957 = (state_32094[(10)]);
var inst_32061 = (state_32094[(22)]);
var inst_32061__$1 = cljs.core.first(inst_32050);
var inst_32062 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32061__$1,inst_31957,done);
var state_32094__$1 = (function (){var statearr_32252 = state_32094;
(statearr_32252[(22)] = inst_32061__$1);

return statearr_32252;
})();
if(cljs.core.truth_(inst_32062)){
var statearr_32253_34845 = state_32094__$1;
(statearr_32253_34845[(1)] = (39));

} else {
var statearr_32254_34846 = state_32094__$1;
(statearr_32254_34846[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (8))){
var inst_31969 = (state_32094[(15)]);
var inst_31968 = (state_32094[(16)]);
var inst_31971 = (inst_31969 < inst_31968);
var inst_31972 = inst_31971;
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_31972)){
var statearr_32257_34850 = state_32094__$1;
(statearr_32257_34850[(1)] = (10));

} else {
var statearr_32259_34851 = state_32094__$1;
(statearr_32259_34851[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__30547__auto__ = null;
var cljs$core$async$mult_$_state_machine__30547__auto____0 = (function (){
var statearr_32262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32262[(0)] = cljs$core$async$mult_$_state_machine__30547__auto__);

(statearr_32262[(1)] = (1));

return statearr_32262;
});
var cljs$core$async$mult_$_state_machine__30547__auto____1 = (function (state_32094){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_32094);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e32264){var ex__30550__auto__ = e32264;
var statearr_32266_34866 = state_32094;
(statearr_32266_34866[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_32094[(4)]))){
var statearr_32267_34867 = state_32094;
(statearr_32267_34867[(1)] = cljs.core.first((state_32094[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34872 = state_32094;
state_32094 = G__34872;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30547__auto__ = function(state_32094){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30547__auto____1.call(this,state_32094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30547__auto____0;
cljs$core$async$mult_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30547__auto____1;
return cljs$core$async$mult_$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_32269 = f__30754__auto__();
(statearr_32269[(6)] = c__30753__auto___34576);

return statearr_32269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32276 = arguments.length;
switch (G__32276) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_34897 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_34897(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_34910 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_34910(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_34926 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_34926(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_34936 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_34936(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_34952 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_34952(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34969 = arguments.length;
var i__5770__auto___34970 = (0);
while(true){
if((i__5770__auto___34970 < len__5769__auto___34969)){
args__5775__auto__.push((arguments[i__5770__auto___34970]));

var G__34971 = (i__5770__auto___34970 + (1));
i__5770__auto___34970 = G__34971;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32340){
var map__32341 = p__32340;
var map__32341__$1 = cljs.core.__destructure_map(map__32341);
var opts = map__32341__$1;
var statearr_32342_34977 = state;
(statearr_32342_34977[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32343_34981 = state;
(statearr_32343_34981[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32344_34982 = state;
(statearr_32344_34982[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32334){
var G__32335 = cljs.core.first(seq32334);
var seq32334__$1 = cljs.core.next(seq32334);
var G__32336 = cljs.core.first(seq32334__$1);
var seq32334__$2 = cljs.core.next(seq32334__$1);
var G__32337 = cljs.core.first(seq32334__$2);
var seq32334__$3 = cljs.core.next(seq32334__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32335,G__32336,G__32337,seq32334__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32374 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32374 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32375){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32375 = meta32375;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32376,meta32375__$1){
var self__ = this;
var _32376__$1 = this;
return (new cljs.core.async.t_cljs$core$async32374(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32375__$1));
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32376){
var self__ = this;
var _32376__$1 = this;
return self__.meta32375;
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32374.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32374.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32375","meta32375",1869542201,null)], null);
}));

(cljs.core.async.t_cljs$core$async32374.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32374.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32374");

(cljs.core.async.t_cljs$core$async32374.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32374");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32374.
 */
cljs.core.async.__GT_t_cljs$core$async32374 = (function cljs$core$async$mix_$___GT_t_cljs$core$async32374(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32375){
return (new cljs.core.async.t_cljs$core$async32374(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32375));
});

}

return (new cljs.core.async.t_cljs$core$async32374(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30753__auto___35056 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_32497){
var state_val_32499 = (state_32497[(1)]);
if((state_val_32499 === (7))){
var inst_32449 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
if(cljs.core.truth_(inst_32449)){
var statearr_32504_35061 = state_32497__$1;
(statearr_32504_35061[(1)] = (8));

} else {
var statearr_32505_35063 = state_32497__$1;
(statearr_32505_35063[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (20))){
var inst_32440 = (state_32497[(7)]);
var state_32497__$1 = state_32497;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32497__$1,(23),out,inst_32440);
} else {
if((state_val_32499 === (1))){
var inst_32422 = calc_state();
var inst_32423 = cljs.core.__destructure_map(inst_32422);
var inst_32424 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32423,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32425 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32423,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32423,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32428 = inst_32422;
var state_32497__$1 = (function (){var statearr_32508 = state_32497;
(statearr_32508[(8)] = inst_32426);

(statearr_32508[(9)] = inst_32424);

(statearr_32508[(10)] = inst_32428);

(statearr_32508[(11)] = inst_32425);

return statearr_32508;
})();
var statearr_32510_35068 = state_32497__$1;
(statearr_32510_35068[(2)] = null);

(statearr_32510_35068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (24))){
var inst_32431 = (state_32497[(12)]);
var inst_32428 = inst_32431;
var state_32497__$1 = (function (){var statearr_32512 = state_32497;
(statearr_32512[(10)] = inst_32428);

return statearr_32512;
})();
var statearr_32514_35069 = state_32497__$1;
(statearr_32514_35069[(2)] = null);

(statearr_32514_35069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (4))){
var inst_32442 = (state_32497[(13)]);
var inst_32440 = (state_32497[(7)]);
var inst_32439 = (state_32497[(2)]);
var inst_32440__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32439,(0),null);
var inst_32441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32439,(1),null);
var inst_32442__$1 = (inst_32440__$1 == null);
var state_32497__$1 = (function (){var statearr_32516 = state_32497;
(statearr_32516[(13)] = inst_32442__$1);

(statearr_32516[(14)] = inst_32441);

(statearr_32516[(7)] = inst_32440__$1);

return statearr_32516;
})();
if(cljs.core.truth_(inst_32442__$1)){
var statearr_32518_35071 = state_32497__$1;
(statearr_32518_35071[(1)] = (5));

} else {
var statearr_32519_35073 = state_32497__$1;
(statearr_32519_35073[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (15))){
var inst_32432 = (state_32497[(15)]);
var inst_32469 = (state_32497[(16)]);
var inst_32469__$1 = cljs.core.empty_QMARK_(inst_32432);
var state_32497__$1 = (function (){var statearr_32524 = state_32497;
(statearr_32524[(16)] = inst_32469__$1);

return statearr_32524;
})();
if(inst_32469__$1){
var statearr_32527_35077 = state_32497__$1;
(statearr_32527_35077[(1)] = (17));

} else {
var statearr_32529_35078 = state_32497__$1;
(statearr_32529_35078[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (21))){
var inst_32431 = (state_32497[(12)]);
var inst_32428 = inst_32431;
var state_32497__$1 = (function (){var statearr_32531 = state_32497;
(statearr_32531[(10)] = inst_32428);

return statearr_32531;
})();
var statearr_32532_35080 = state_32497__$1;
(statearr_32532_35080[(2)] = null);

(statearr_32532_35080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (13))){
var inst_32457 = (state_32497[(2)]);
var inst_32458 = calc_state();
var inst_32428 = inst_32458;
var state_32497__$1 = (function (){var statearr_32535 = state_32497;
(statearr_32535[(10)] = inst_32428);

(statearr_32535[(17)] = inst_32457);

return statearr_32535;
})();
var statearr_32537_35082 = state_32497__$1;
(statearr_32537_35082[(2)] = null);

(statearr_32537_35082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (22))){
var inst_32491 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
var statearr_32541_35083 = state_32497__$1;
(statearr_32541_35083[(2)] = inst_32491);

(statearr_32541_35083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (6))){
var inst_32441 = (state_32497[(14)]);
var inst_32447 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32441,change);
var state_32497__$1 = state_32497;
var statearr_32544_35084 = state_32497__$1;
(statearr_32544_35084[(2)] = inst_32447);

(statearr_32544_35084[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (25))){
var state_32497__$1 = state_32497;
var statearr_32549_35085 = state_32497__$1;
(statearr_32549_35085[(2)] = null);

(statearr_32549_35085[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (17))){
var inst_32441 = (state_32497[(14)]);
var inst_32433 = (state_32497[(18)]);
var inst_32472 = (inst_32433.cljs$core$IFn$_invoke$arity$1 ? inst_32433.cljs$core$IFn$_invoke$arity$1(inst_32441) : inst_32433.call(null,inst_32441));
var inst_32473 = cljs.core.not(inst_32472);
var state_32497__$1 = state_32497;
var statearr_32558_35086 = state_32497__$1;
(statearr_32558_35086[(2)] = inst_32473);

(statearr_32558_35086[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (3))){
var inst_32495 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32497__$1,inst_32495);
} else {
if((state_val_32499 === (12))){
var state_32497__$1 = state_32497;
var statearr_32568_35087 = state_32497__$1;
(statearr_32568_35087[(2)] = null);

(statearr_32568_35087[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (2))){
var inst_32428 = (state_32497[(10)]);
var inst_32431 = (state_32497[(12)]);
var inst_32431__$1 = cljs.core.__destructure_map(inst_32428);
var inst_32432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32431__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32433 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32431__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32434 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32431__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32497__$1 = (function (){var statearr_32572 = state_32497;
(statearr_32572[(18)] = inst_32433);

(statearr_32572[(15)] = inst_32432);

(statearr_32572[(12)] = inst_32431__$1);

return statearr_32572;
})();
return cljs.core.async.ioc_alts_BANG_(state_32497__$1,(4),inst_32434);
} else {
if((state_val_32499 === (23))){
var inst_32482 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
if(cljs.core.truth_(inst_32482)){
var statearr_32580_35089 = state_32497__$1;
(statearr_32580_35089[(1)] = (24));

} else {
var statearr_32584_35091 = state_32497__$1;
(statearr_32584_35091[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (19))){
var inst_32476 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
var statearr_32586_35092 = state_32497__$1;
(statearr_32586_35092[(2)] = inst_32476);

(statearr_32586_35092[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (11))){
var inst_32441 = (state_32497[(14)]);
var inst_32454 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32441);
var state_32497__$1 = state_32497;
var statearr_32587_35101 = state_32497__$1;
(statearr_32587_35101[(2)] = inst_32454);

(statearr_32587_35101[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (9))){
var inst_32441 = (state_32497[(14)]);
var inst_32432 = (state_32497[(15)]);
var inst_32461 = (state_32497[(19)]);
var inst_32461__$1 = (inst_32432.cljs$core$IFn$_invoke$arity$1 ? inst_32432.cljs$core$IFn$_invoke$arity$1(inst_32441) : inst_32432.call(null,inst_32441));
var state_32497__$1 = (function (){var statearr_32589 = state_32497;
(statearr_32589[(19)] = inst_32461__$1);

return statearr_32589;
})();
if(cljs.core.truth_(inst_32461__$1)){
var statearr_32590_35114 = state_32497__$1;
(statearr_32590_35114[(1)] = (14));

} else {
var statearr_32591_35115 = state_32497__$1;
(statearr_32591_35115[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (5))){
var inst_32442 = (state_32497[(13)]);
var state_32497__$1 = state_32497;
var statearr_32592_35119 = state_32497__$1;
(statearr_32592_35119[(2)] = inst_32442);

(statearr_32592_35119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (14))){
var inst_32461 = (state_32497[(19)]);
var state_32497__$1 = state_32497;
var statearr_32596_35124 = state_32497__$1;
(statearr_32596_35124[(2)] = inst_32461);

(statearr_32596_35124[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (26))){
var inst_32487 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
var statearr_32600_35125 = state_32497__$1;
(statearr_32600_35125[(2)] = inst_32487);

(statearr_32600_35125[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (16))){
var inst_32478 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
if(cljs.core.truth_(inst_32478)){
var statearr_32603_35130 = state_32497__$1;
(statearr_32603_35130[(1)] = (20));

} else {
var statearr_32604_35131 = state_32497__$1;
(statearr_32604_35131[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (10))){
var inst_32493 = (state_32497[(2)]);
var state_32497__$1 = state_32497;
var statearr_32606_35133 = state_32497__$1;
(statearr_32606_35133[(2)] = inst_32493);

(statearr_32606_35133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (18))){
var inst_32469 = (state_32497[(16)]);
var state_32497__$1 = state_32497;
var statearr_32607_35137 = state_32497__$1;
(statearr_32607_35137[(2)] = inst_32469);

(statearr_32607_35137[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32499 === (8))){
var inst_32440 = (state_32497[(7)]);
var inst_32452 = (inst_32440 == null);
var state_32497__$1 = state_32497;
if(cljs.core.truth_(inst_32452)){
var statearr_32608_35138 = state_32497__$1;
(statearr_32608_35138[(1)] = (11));

} else {
var statearr_32609_35139 = state_32497__$1;
(statearr_32609_35139[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__30547__auto__ = null;
var cljs$core$async$mix_$_state_machine__30547__auto____0 = (function (){
var statearr_32612 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32612[(0)] = cljs$core$async$mix_$_state_machine__30547__auto__);

(statearr_32612[(1)] = (1));

return statearr_32612;
});
var cljs$core$async$mix_$_state_machine__30547__auto____1 = (function (state_32497){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_32497);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e32614){var ex__30550__auto__ = e32614;
var statearr_32616_35140 = state_32497;
(statearr_32616_35140[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_32497[(4)]))){
var statearr_32617_35141 = state_32497;
(statearr_32617_35141[(1)] = cljs.core.first((state_32497[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35142 = state_32497;
state_32497 = G__35142;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30547__auto__ = function(state_32497){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30547__auto____1.call(this,state_32497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30547__auto____0;
cljs$core$async$mix_$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30547__auto____1;
return cljs$core$async$mix_$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_32618 = f__30754__auto__();
(statearr_32618[(6)] = c__30753__auto___35056);

return statearr_32618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_35144 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_35144(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_35153 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_35153(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_35165 = (function() {
var G__35166 = null;
var G__35166__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__35166__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__35166 = function(p,v){
switch(arguments.length){
case 1:
return G__35166__1.call(this,p);
case 2:
return G__35166__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35166.cljs$core$IFn$_invoke$arity$1 = G__35166__1;
G__35166.cljs$core$IFn$_invoke$arity$2 = G__35166__2;
return G__35166;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32655 = arguments.length;
switch (G__32655) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35165(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35165(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32660 = arguments.length;
switch (G__32660) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32657_SHARP_){
if(cljs.core.truth_((p1__32657_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32657_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32657_SHARP_.call(null,topic)))){
return p1__32657_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32657_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32665 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32665 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32666){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32666 = meta32666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32667,meta32666__$1){
var self__ = this;
var _32667__$1 = this;
return (new cljs.core.async.t_cljs$core$async32665(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32666__$1));
}));

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32667){
var self__ = this;
var _32667__$1 = this;
return self__.meta32666;
}));

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32665.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32666","meta32666",1377074124,null)], null);
}));

(cljs.core.async.t_cljs$core$async32665.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32665");

(cljs.core.async.t_cljs$core$async32665.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32665");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32665.
 */
cljs.core.async.__GT_t_cljs$core$async32665 = (function cljs$core$async$__GT_t_cljs$core$async32665(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32666){
return (new cljs.core.async.t_cljs$core$async32665(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32666));
});

}

return (new cljs.core.async.t_cljs$core$async32665(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30753__auto___35189 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_32785){
var state_val_32786 = (state_32785[(1)]);
if((state_val_32786 === (7))){
var inst_32780 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
var statearr_32788_35193 = state_32785__$1;
(statearr_32788_35193[(2)] = inst_32780);

(statearr_32788_35193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (20))){
var state_32785__$1 = state_32785;
var statearr_32789_35195 = state_32785__$1;
(statearr_32789_35195[(2)] = null);

(statearr_32789_35195[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (1))){
var state_32785__$1 = state_32785;
var statearr_32792_35198 = state_32785__$1;
(statearr_32792_35198[(2)] = null);

(statearr_32792_35198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (24))){
var inst_32761 = (state_32785[(7)]);
var inst_32771 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32761);
var state_32785__$1 = state_32785;
var statearr_32794_35202 = state_32785__$1;
(statearr_32794_35202[(2)] = inst_32771);

(statearr_32794_35202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (4))){
var inst_32680 = (state_32785[(8)]);
var inst_32680__$1 = (state_32785[(2)]);
var inst_32681 = (inst_32680__$1 == null);
var state_32785__$1 = (function (){var statearr_32795 = state_32785;
(statearr_32795[(8)] = inst_32680__$1);

return statearr_32795;
})();
if(cljs.core.truth_(inst_32681)){
var statearr_32796_35210 = state_32785__$1;
(statearr_32796_35210[(1)] = (5));

} else {
var statearr_32797_35211 = state_32785__$1;
(statearr_32797_35211[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (15))){
var inst_32755 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
var statearr_32798_35212 = state_32785__$1;
(statearr_32798_35212[(2)] = inst_32755);

(statearr_32798_35212[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (21))){
var inst_32776 = (state_32785[(2)]);
var state_32785__$1 = (function (){var statearr_32799 = state_32785;
(statearr_32799[(9)] = inst_32776);

return statearr_32799;
})();
var statearr_32800_35217 = state_32785__$1;
(statearr_32800_35217[(2)] = null);

(statearr_32800_35217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (13))){
var inst_32704 = (state_32785[(10)]);
var inst_32706 = cljs.core.chunked_seq_QMARK_(inst_32704);
var state_32785__$1 = state_32785;
if(inst_32706){
var statearr_32802_35221 = state_32785__$1;
(statearr_32802_35221[(1)] = (16));

} else {
var statearr_32803_35222 = state_32785__$1;
(statearr_32803_35222[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (22))){
var inst_32767 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
if(cljs.core.truth_(inst_32767)){
var statearr_32804_35223 = state_32785__$1;
(statearr_32804_35223[(1)] = (23));

} else {
var statearr_32805_35224 = state_32785__$1;
(statearr_32805_35224[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (6))){
var inst_32761 = (state_32785[(7)]);
var inst_32763 = (state_32785[(11)]);
var inst_32680 = (state_32785[(8)]);
var inst_32761__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32680) : topic_fn.call(null,inst_32680));
var inst_32762 = cljs.core.deref(mults);
var inst_32763__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32762,inst_32761__$1);
var state_32785__$1 = (function (){var statearr_32810 = state_32785;
(statearr_32810[(7)] = inst_32761__$1);

(statearr_32810[(11)] = inst_32763__$1);

return statearr_32810;
})();
if(cljs.core.truth_(inst_32763__$1)){
var statearr_32812_35226 = state_32785__$1;
(statearr_32812_35226[(1)] = (19));

} else {
var statearr_32813_35227 = state_32785__$1;
(statearr_32813_35227[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (25))){
var inst_32773 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
var statearr_32815_35231 = state_32785__$1;
(statearr_32815_35231[(2)] = inst_32773);

(statearr_32815_35231[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (17))){
var inst_32704 = (state_32785[(10)]);
var inst_32714 = cljs.core.first(inst_32704);
var inst_32715 = cljs.core.async.muxch_STAR_(inst_32714);
var inst_32716 = cljs.core.async.close_BANG_(inst_32715);
var inst_32749 = cljs.core.next(inst_32704);
var inst_32690 = inst_32749;
var inst_32691 = null;
var inst_32692 = (0);
var inst_32693 = (0);
var state_32785__$1 = (function (){var statearr_32816 = state_32785;
(statearr_32816[(12)] = inst_32693);

(statearr_32816[(13)] = inst_32692);

(statearr_32816[(14)] = inst_32691);

(statearr_32816[(15)] = inst_32716);

(statearr_32816[(16)] = inst_32690);

return statearr_32816;
})();
var statearr_32817_35247 = state_32785__$1;
(statearr_32817_35247[(2)] = null);

(statearr_32817_35247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (3))){
var inst_32782 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32785__$1,inst_32782);
} else {
if((state_val_32786 === (12))){
var inst_32757 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
var statearr_32819_35248 = state_32785__$1;
(statearr_32819_35248[(2)] = inst_32757);

(statearr_32819_35248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (2))){
var state_32785__$1 = state_32785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32785__$1,(4),ch);
} else {
if((state_val_32786 === (23))){
var state_32785__$1 = state_32785;
var statearr_32821_35249 = state_32785__$1;
(statearr_32821_35249[(2)] = null);

(statearr_32821_35249[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (19))){
var inst_32763 = (state_32785[(11)]);
var inst_32680 = (state_32785[(8)]);
var inst_32765 = cljs.core.async.muxch_STAR_(inst_32763);
var state_32785__$1 = state_32785;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32785__$1,(22),inst_32765,inst_32680);
} else {
if((state_val_32786 === (11))){
var inst_32704 = (state_32785[(10)]);
var inst_32690 = (state_32785[(16)]);
var inst_32704__$1 = cljs.core.seq(inst_32690);
var state_32785__$1 = (function (){var statearr_32823 = state_32785;
(statearr_32823[(10)] = inst_32704__$1);

return statearr_32823;
})();
if(inst_32704__$1){
var statearr_32825_35252 = state_32785__$1;
(statearr_32825_35252[(1)] = (13));

} else {
var statearr_32826_35253 = state_32785__$1;
(statearr_32826_35253[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (9))){
var inst_32759 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
var statearr_32827_35256 = state_32785__$1;
(statearr_32827_35256[(2)] = inst_32759);

(statearr_32827_35256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (5))){
var inst_32687 = cljs.core.deref(mults);
var inst_32688 = cljs.core.vals(inst_32687);
var inst_32689 = cljs.core.seq(inst_32688);
var inst_32690 = inst_32689;
var inst_32691 = null;
var inst_32692 = (0);
var inst_32693 = (0);
var state_32785__$1 = (function (){var statearr_32831 = state_32785;
(statearr_32831[(12)] = inst_32693);

(statearr_32831[(13)] = inst_32692);

(statearr_32831[(14)] = inst_32691);

(statearr_32831[(16)] = inst_32690);

return statearr_32831;
})();
var statearr_32833_35257 = state_32785__$1;
(statearr_32833_35257[(2)] = null);

(statearr_32833_35257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (14))){
var state_32785__$1 = state_32785;
var statearr_32839_35261 = state_32785__$1;
(statearr_32839_35261[(2)] = null);

(statearr_32839_35261[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (16))){
var inst_32704 = (state_32785[(10)]);
var inst_32708 = cljs.core.chunk_first(inst_32704);
var inst_32709 = cljs.core.chunk_rest(inst_32704);
var inst_32711 = cljs.core.count(inst_32708);
var inst_32690 = inst_32709;
var inst_32691 = inst_32708;
var inst_32692 = inst_32711;
var inst_32693 = (0);
var state_32785__$1 = (function (){var statearr_32840 = state_32785;
(statearr_32840[(12)] = inst_32693);

(statearr_32840[(13)] = inst_32692);

(statearr_32840[(14)] = inst_32691);

(statearr_32840[(16)] = inst_32690);

return statearr_32840;
})();
var statearr_32847_35272 = state_32785__$1;
(statearr_32847_35272[(2)] = null);

(statearr_32847_35272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (10))){
var inst_32693 = (state_32785[(12)]);
var inst_32692 = (state_32785[(13)]);
var inst_32691 = (state_32785[(14)]);
var inst_32690 = (state_32785[(16)]);
var inst_32698 = cljs.core._nth(inst_32691,inst_32693);
var inst_32699 = cljs.core.async.muxch_STAR_(inst_32698);
var inst_32700 = cljs.core.async.close_BANG_(inst_32699);
var inst_32701 = (inst_32693 + (1));
var tmp32834 = inst_32692;
var tmp32835 = inst_32691;
var tmp32836 = inst_32690;
var inst_32690__$1 = tmp32836;
var inst_32691__$1 = tmp32835;
var inst_32692__$1 = tmp32834;
var inst_32693__$1 = inst_32701;
var state_32785__$1 = (function (){var statearr_32857 = state_32785;
(statearr_32857[(12)] = inst_32693__$1);

(statearr_32857[(17)] = inst_32700);

(statearr_32857[(13)] = inst_32692__$1);

(statearr_32857[(14)] = inst_32691__$1);

(statearr_32857[(16)] = inst_32690__$1);

return statearr_32857;
})();
var statearr_32863_35276 = state_32785__$1;
(statearr_32863_35276[(2)] = null);

(statearr_32863_35276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (18))){
var inst_32752 = (state_32785[(2)]);
var state_32785__$1 = state_32785;
var statearr_32864_35277 = state_32785__$1;
(statearr_32864_35277[(2)] = inst_32752);

(statearr_32864_35277[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32786 === (8))){
var inst_32693 = (state_32785[(12)]);
var inst_32692 = (state_32785[(13)]);
var inst_32695 = (inst_32693 < inst_32692);
var inst_32696 = inst_32695;
var state_32785__$1 = state_32785;
if(cljs.core.truth_(inst_32696)){
var statearr_32867_35278 = state_32785__$1;
(statearr_32867_35278[(1)] = (10));

} else {
var statearr_32868_35279 = state_32785__$1;
(statearr_32868_35279[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_32871 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32871[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_32871[(1)] = (1));

return statearr_32871;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_32785){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_32785);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e32872){var ex__30550__auto__ = e32872;
var statearr_32873_35283 = state_32785;
(statearr_32873_35283[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_32785[(4)]))){
var statearr_32874_35285 = state_32785;
(statearr_32874_35285[(1)] = cljs.core.first((state_32785[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35292 = state_32785;
state_32785 = G__35292;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_32785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_32785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_32876 = f__30754__auto__();
(statearr_32876[(6)] = c__30753__auto___35189);

return statearr_32876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32879 = arguments.length;
switch (G__32879) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32894 = arguments.length;
switch (G__32894) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32909 = arguments.length;
switch (G__32909) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30753__auto___35307 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_32968){
var state_val_32969 = (state_32968[(1)]);
if((state_val_32969 === (7))){
var state_32968__$1 = state_32968;
var statearr_32974_35308 = state_32968__$1;
(statearr_32974_35308[(2)] = null);

(statearr_32974_35308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (1))){
var state_32968__$1 = state_32968;
var statearr_32975_35309 = state_32968__$1;
(statearr_32975_35309[(2)] = null);

(statearr_32975_35309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (4))){
var inst_32921 = (state_32968[(7)]);
var inst_32923 = (state_32968[(8)]);
var inst_32925 = (inst_32923 < inst_32921);
var state_32968__$1 = state_32968;
if(cljs.core.truth_(inst_32925)){
var statearr_32977_35310 = state_32968__$1;
(statearr_32977_35310[(1)] = (6));

} else {
var statearr_32981_35311 = state_32968__$1;
(statearr_32981_35311[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (15))){
var inst_32953 = (state_32968[(9)]);
var inst_32958 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32953);
var state_32968__$1 = state_32968;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32968__$1,(17),out,inst_32958);
} else {
if((state_val_32969 === (13))){
var inst_32953 = (state_32968[(9)]);
var inst_32953__$1 = (state_32968[(2)]);
var inst_32954 = cljs.core.some(cljs.core.nil_QMARK_,inst_32953__$1);
var state_32968__$1 = (function (){var statearr_32986 = state_32968;
(statearr_32986[(9)] = inst_32953__$1);

return statearr_32986;
})();
if(cljs.core.truth_(inst_32954)){
var statearr_32987_35312 = state_32968__$1;
(statearr_32987_35312[(1)] = (14));

} else {
var statearr_32988_35313 = state_32968__$1;
(statearr_32988_35313[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (6))){
var state_32968__$1 = state_32968;
var statearr_32989_35315 = state_32968__$1;
(statearr_32989_35315[(2)] = null);

(statearr_32989_35315[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (17))){
var inst_32960 = (state_32968[(2)]);
var state_32968__$1 = (function (){var statearr_33004 = state_32968;
(statearr_33004[(10)] = inst_32960);

return statearr_33004;
})();
var statearr_33005_35317 = state_32968__$1;
(statearr_33005_35317[(2)] = null);

(statearr_33005_35317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (3))){
var inst_32966 = (state_32968[(2)]);
var state_32968__$1 = state_32968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32968__$1,inst_32966);
} else {
if((state_val_32969 === (12))){
var _ = (function (){var statearr_33009 = state_32968;
(statearr_33009[(4)] = cljs.core.rest((state_32968[(4)])));

return statearr_33009;
})();
var state_32968__$1 = state_32968;
var ex33002 = (state_32968__$1[(2)]);
var statearr_33010_35318 = state_32968__$1;
(statearr_33010_35318[(5)] = ex33002);


if((ex33002 instanceof Object)){
var statearr_33013_35319 = state_32968__$1;
(statearr_33013_35319[(1)] = (11));

(statearr_33013_35319[(5)] = null);

} else {
throw ex33002;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (2))){
var inst_32920 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32921 = cnt;
var inst_32923 = (0);
var state_32968__$1 = (function (){var statearr_33017 = state_32968;
(statearr_33017[(7)] = inst_32921);

(statearr_33017[(11)] = inst_32920);

(statearr_33017[(8)] = inst_32923);

return statearr_33017;
})();
var statearr_33019_35320 = state_32968__$1;
(statearr_33019_35320[(2)] = null);

(statearr_33019_35320[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (11))){
var inst_32930 = (state_32968[(2)]);
var inst_32932 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32968__$1 = (function (){var statearr_33022 = state_32968;
(statearr_33022[(12)] = inst_32930);

return statearr_33022;
})();
var statearr_33024_35321 = state_32968__$1;
(statearr_33024_35321[(2)] = inst_32932);

(statearr_33024_35321[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (9))){
var inst_32923 = (state_32968[(8)]);
var _ = (function (){var statearr_33026 = state_32968;
(statearr_33026[(4)] = cljs.core.cons((12),(state_32968[(4)])));

return statearr_33026;
})();
var inst_32939 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32923) : chs__$1.call(null,inst_32923));
var inst_32940 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32923) : done.call(null,inst_32923));
var inst_32941 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32939,inst_32940);
var ___$1 = (function (){var statearr_33029 = state_32968;
(statearr_33029[(4)] = cljs.core.rest((state_32968[(4)])));

return statearr_33029;
})();
var state_32968__$1 = state_32968;
var statearr_33030_35329 = state_32968__$1;
(statearr_33030_35329[(2)] = inst_32941);

(statearr_33030_35329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (5))){
var inst_32951 = (state_32968[(2)]);
var state_32968__$1 = (function (){var statearr_33032 = state_32968;
(statearr_33032[(13)] = inst_32951);

return statearr_33032;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32968__$1,(13),dchan);
} else {
if((state_val_32969 === (14))){
var inst_32956 = cljs.core.async.close_BANG_(out);
var state_32968__$1 = state_32968;
var statearr_33035_35334 = state_32968__$1;
(statearr_33035_35334[(2)] = inst_32956);

(statearr_33035_35334[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (16))){
var inst_32963 = (state_32968[(2)]);
var state_32968__$1 = state_32968;
var statearr_33036_35335 = state_32968__$1;
(statearr_33036_35335[(2)] = inst_32963);

(statearr_33036_35335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (10))){
var inst_32923 = (state_32968[(8)]);
var inst_32944 = (state_32968[(2)]);
var inst_32945 = (inst_32923 + (1));
var inst_32923__$1 = inst_32945;
var state_32968__$1 = (function (){var statearr_33038 = state_32968;
(statearr_33038[(14)] = inst_32944);

(statearr_33038[(8)] = inst_32923__$1);

return statearr_33038;
})();
var statearr_33039_35338 = state_32968__$1;
(statearr_33039_35338[(2)] = null);

(statearr_33039_35338[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32969 === (8))){
var inst_32949 = (state_32968[(2)]);
var state_32968__$1 = state_32968;
var statearr_33041_35340 = state_32968__$1;
(statearr_33041_35340[(2)] = inst_32949);

(statearr_33041_35340[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33044[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33044[(1)] = (1));

return statearr_33044;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_32968){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_32968);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33047){var ex__30550__auto__ = e33047;
var statearr_33049_35341 = state_32968;
(statearr_33049_35341[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_32968[(4)]))){
var statearr_33050_35342 = state_32968;
(statearr_33050_35342[(1)] = cljs.core.first((state_32968[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35343 = state_32968;
state_32968 = G__35343;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_32968){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_32968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33054 = f__30754__auto__();
(statearr_33054[(6)] = c__30753__auto___35307);

return statearr_33054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33058 = arguments.length;
switch (G__33058) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30753__auto___35352 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33105){
var state_val_33106 = (state_33105[(1)]);
if((state_val_33106 === (7))){
var inst_33080 = (state_33105[(7)]);
var inst_33079 = (state_33105[(8)]);
var inst_33079__$1 = (state_33105[(2)]);
var inst_33080__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33079__$1,(0),null);
var inst_33082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33079__$1,(1),null);
var inst_33084 = (inst_33080__$1 == null);
var state_33105__$1 = (function (){var statearr_33113 = state_33105;
(statearr_33113[(9)] = inst_33082);

(statearr_33113[(7)] = inst_33080__$1);

(statearr_33113[(8)] = inst_33079__$1);

return statearr_33113;
})();
if(cljs.core.truth_(inst_33084)){
var statearr_33115_35357 = state_33105__$1;
(statearr_33115_35357[(1)] = (8));

} else {
var statearr_33117_35358 = state_33105__$1;
(statearr_33117_35358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (1))){
var inst_33067 = cljs.core.vec(chs);
var inst_33068 = inst_33067;
var state_33105__$1 = (function (){var statearr_33121 = state_33105;
(statearr_33121[(10)] = inst_33068);

return statearr_33121;
})();
var statearr_33123_35361 = state_33105__$1;
(statearr_33123_35361[(2)] = null);

(statearr_33123_35361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (4))){
var inst_33068 = (state_33105[(10)]);
var state_33105__$1 = state_33105;
return cljs.core.async.ioc_alts_BANG_(state_33105__$1,(7),inst_33068);
} else {
if((state_val_33106 === (6))){
var inst_33099 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33126_35362 = state_33105__$1;
(statearr_33126_35362[(2)] = inst_33099);

(statearr_33126_35362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (3))){
var inst_33102 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33105__$1,inst_33102);
} else {
if((state_val_33106 === (2))){
var inst_33068 = (state_33105[(10)]);
var inst_33070 = cljs.core.count(inst_33068);
var inst_33071 = (inst_33070 > (0));
var state_33105__$1 = state_33105;
if(cljs.core.truth_(inst_33071)){
var statearr_33131_35364 = state_33105__$1;
(statearr_33131_35364[(1)] = (4));

} else {
var statearr_33133_35365 = state_33105__$1;
(statearr_33133_35365[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (11))){
var inst_33068 = (state_33105[(10)]);
var inst_33092 = (state_33105[(2)]);
var tmp33128 = inst_33068;
var inst_33068__$1 = tmp33128;
var state_33105__$1 = (function (){var statearr_33136 = state_33105;
(statearr_33136[(10)] = inst_33068__$1);

(statearr_33136[(11)] = inst_33092);

return statearr_33136;
})();
var statearr_33137_35366 = state_33105__$1;
(statearr_33137_35366[(2)] = null);

(statearr_33137_35366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (9))){
var inst_33080 = (state_33105[(7)]);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33105__$1,(11),out,inst_33080);
} else {
if((state_val_33106 === (5))){
var inst_33097 = cljs.core.async.close_BANG_(out);
var state_33105__$1 = state_33105;
var statearr_33151_35369 = state_33105__$1;
(statearr_33151_35369[(2)] = inst_33097);

(statearr_33151_35369[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (10))){
var inst_33095 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33157_35371 = state_33105__$1;
(statearr_33157_35371[(2)] = inst_33095);

(statearr_33157_35371[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33106 === (8))){
var inst_33068 = (state_33105[(10)]);
var inst_33082 = (state_33105[(9)]);
var inst_33080 = (state_33105[(7)]);
var inst_33079 = (state_33105[(8)]);
var inst_33087 = (function (){var cs = inst_33068;
var vec__33075 = inst_33079;
var v = inst_33080;
var c = inst_33082;
return (function (p1__33056_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33056_SHARP_);
});
})();
var inst_33088 = cljs.core.filterv(inst_33087,inst_33068);
var inst_33068__$1 = inst_33088;
var state_33105__$1 = (function (){var statearr_33166 = state_33105;
(statearr_33166[(10)] = inst_33068__$1);

return statearr_33166;
})();
var statearr_33167_35374 = state_33105__$1;
(statearr_33167_35374[(2)] = null);

(statearr_33167_35374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33175 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33175[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33175[(1)] = (1));

return statearr_33175;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_33105){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33105);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33181){var ex__30550__auto__ = e33181;
var statearr_33182_35377 = state_33105;
(statearr_33182_35377[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33105[(4)]))){
var statearr_33183_35378 = state_33105;
(statearr_33183_35378[(1)] = cljs.core.first((state_33105[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35379 = state_33105;
state_33105 = G__35379;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_33105){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_33105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33186 = f__30754__auto__();
(statearr_33186[(6)] = c__30753__auto___35352);

return statearr_33186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33198 = arguments.length;
switch (G__33198) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30753__auto___35382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33235){
var state_val_33236 = (state_33235[(1)]);
if((state_val_33236 === (7))){
var inst_33217 = (state_33235[(7)]);
var inst_33217__$1 = (state_33235[(2)]);
var inst_33218 = (inst_33217__$1 == null);
var inst_33219 = cljs.core.not(inst_33218);
var state_33235__$1 = (function (){var statearr_33244 = state_33235;
(statearr_33244[(7)] = inst_33217__$1);

return statearr_33244;
})();
if(inst_33219){
var statearr_33245_35384 = state_33235__$1;
(statearr_33245_35384[(1)] = (8));

} else {
var statearr_33246_35385 = state_33235__$1;
(statearr_33246_35385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (1))){
var inst_33211 = (0);
var state_33235__$1 = (function (){var statearr_33248 = state_33235;
(statearr_33248[(8)] = inst_33211);

return statearr_33248;
})();
var statearr_33250_35390 = state_33235__$1;
(statearr_33250_35390[(2)] = null);

(statearr_33250_35390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (4))){
var state_33235__$1 = state_33235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33235__$1,(7),ch);
} else {
if((state_val_33236 === (6))){
var inst_33230 = (state_33235[(2)]);
var state_33235__$1 = state_33235;
var statearr_33251_35392 = state_33235__$1;
(statearr_33251_35392[(2)] = inst_33230);

(statearr_33251_35392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (3))){
var inst_33232 = (state_33235[(2)]);
var inst_33233 = cljs.core.async.close_BANG_(out);
var state_33235__$1 = (function (){var statearr_33252 = state_33235;
(statearr_33252[(9)] = inst_33232);

return statearr_33252;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33235__$1,inst_33233);
} else {
if((state_val_33236 === (2))){
var inst_33211 = (state_33235[(8)]);
var inst_33213 = (inst_33211 < n);
var state_33235__$1 = state_33235;
if(cljs.core.truth_(inst_33213)){
var statearr_33256_35398 = state_33235__$1;
(statearr_33256_35398[(1)] = (4));

} else {
var statearr_33258_35399 = state_33235__$1;
(statearr_33258_35399[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (11))){
var inst_33211 = (state_33235[(8)]);
var inst_33222 = (state_33235[(2)]);
var inst_33223 = (inst_33211 + (1));
var inst_33211__$1 = inst_33223;
var state_33235__$1 = (function (){var statearr_33266 = state_33235;
(statearr_33266[(8)] = inst_33211__$1);

(statearr_33266[(10)] = inst_33222);

return statearr_33266;
})();
var statearr_33268_35401 = state_33235__$1;
(statearr_33268_35401[(2)] = null);

(statearr_33268_35401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (9))){
var state_33235__$1 = state_33235;
var statearr_33270_35402 = state_33235__$1;
(statearr_33270_35402[(2)] = null);

(statearr_33270_35402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (5))){
var state_33235__$1 = state_33235;
var statearr_33272_35404 = state_33235__$1;
(statearr_33272_35404[(2)] = null);

(statearr_33272_35404[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (10))){
var inst_33227 = (state_33235[(2)]);
var state_33235__$1 = state_33235;
var statearr_33273_35405 = state_33235__$1;
(statearr_33273_35405[(2)] = inst_33227);

(statearr_33273_35405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33236 === (8))){
var inst_33217 = (state_33235[(7)]);
var state_33235__$1 = state_33235;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33235__$1,(11),out,inst_33217);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33280 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33280[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33280[(1)] = (1));

return statearr_33280;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_33235){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33235);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33285){var ex__30550__auto__ = e33285;
var statearr_33286_35409 = state_33235;
(statearr_33286_35409[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33235[(4)]))){
var statearr_33288_35415 = state_33235;
(statearr_33288_35415[(1)] = cljs.core.first((state_33235[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35421 = state_33235;
state_33235 = G__35421;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_33235){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_33235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33290 = f__30754__auto__();
(statearr_33290[(6)] = c__30753__auto___35382);

return statearr_33290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33302 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33302 = (function (f,ch,meta33303){
this.f = f;
this.ch = ch;
this.meta33303 = meta33303;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33304,meta33303__$1){
var self__ = this;
var _33304__$1 = this;
return (new cljs.core.async.t_cljs$core$async33302(self__.f,self__.ch,meta33303__$1));
}));

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33304){
var self__ = this;
var _33304__$1 = this;
return self__.meta33303;
}));

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33324 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33324 = (function (f,ch,meta33303,_,fn1,meta33325){
this.f = f;
this.ch = ch;
this.meta33303 = meta33303;
this._ = _;
this.fn1 = fn1;
this.meta33325 = meta33325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33326,meta33325__$1){
var self__ = this;
var _33326__$1 = this;
return (new cljs.core.async.t_cljs$core$async33324(self__.f,self__.ch,self__.meta33303,self__._,self__.fn1,meta33325__$1));
}));

(cljs.core.async.t_cljs$core$async33324.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33326){
var self__ = this;
var _33326__$1 = this;
return self__.meta33325;
}));

(cljs.core.async.t_cljs$core$async33324.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33324.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33324.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33324.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33298_SHARP_){
var G__33355 = (((p1__33298_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33298_SHARP_) : self__.f.call(null,p1__33298_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33355) : f1.call(null,G__33355));
});
}));

(cljs.core.async.t_cljs$core$async33324.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33303","meta33303",674514860,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33302","cljs.core.async/t_cljs$core$async33302",1406984121,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33325","meta33325",2041438397,null)], null);
}));

(cljs.core.async.t_cljs$core$async33324.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33324.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33324");

(cljs.core.async.t_cljs$core$async33324.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33324");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33324.
 */
cljs.core.async.__GT_t_cljs$core$async33324 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33324(f__$1,ch__$1,meta33303__$1,___$2,fn1__$1,meta33325){
return (new cljs.core.async.t_cljs$core$async33324(f__$1,ch__$1,meta33303__$1,___$2,fn1__$1,meta33325));
});

}

return (new cljs.core.async.t_cljs$core$async33324(self__.f,self__.ch,self__.meta33303,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33365 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33365) : self__.f.call(null,G__33365));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33302.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33302.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33303","meta33303",674514860,null)], null);
}));

(cljs.core.async.t_cljs$core$async33302.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33302.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33302");

(cljs.core.async.t_cljs$core$async33302.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33302");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33302.
 */
cljs.core.async.__GT_t_cljs$core$async33302 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33302(f__$1,ch__$1,meta33303){
return (new cljs.core.async.t_cljs$core$async33302(f__$1,ch__$1,meta33303));
});

}

return (new cljs.core.async.t_cljs$core$async33302(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33374 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33374 = (function (f,ch,meta33375){
this.f = f;
this.ch = ch;
this.meta33375 = meta33375;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33376,meta33375__$1){
var self__ = this;
var _33376__$1 = this;
return (new cljs.core.async.t_cljs$core$async33374(self__.f,self__.ch,meta33375__$1));
}));

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33376){
var self__ = this;
var _33376__$1 = this;
return self__.meta33375;
}));

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33374.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33375","meta33375",152133417,null)], null);
}));

(cljs.core.async.t_cljs$core$async33374.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33374.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33374");

(cljs.core.async.t_cljs$core$async33374.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33374");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33374.
 */
cljs.core.async.__GT_t_cljs$core$async33374 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33374(f__$1,ch__$1,meta33375){
return (new cljs.core.async.t_cljs$core$async33374(f__$1,ch__$1,meta33375));
});

}

return (new cljs.core.async.t_cljs$core$async33374(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33390 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33390 = (function (p,ch,meta33391){
this.p = p;
this.ch = ch;
this.meta33391 = meta33391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33392,meta33391__$1){
var self__ = this;
var _33392__$1 = this;
return (new cljs.core.async.t_cljs$core$async33390(self__.p,self__.ch,meta33391__$1));
}));

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33392){
var self__ = this;
var _33392__$1 = this;
return self__.meta33391;
}));

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33390.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33390.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33391","meta33391",-1005958867,null)], null);
}));

(cljs.core.async.t_cljs$core$async33390.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33390");

(cljs.core.async.t_cljs$core$async33390.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33390");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33390.
 */
cljs.core.async.__GT_t_cljs$core$async33390 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33390(p__$1,ch__$1,meta33391){
return (new cljs.core.async.t_cljs$core$async33390(p__$1,ch__$1,meta33391));
});

}

return (new cljs.core.async.t_cljs$core$async33390(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33409 = arguments.length;
switch (G__33409) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30753__auto___35520 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33430){
var state_val_33431 = (state_33430[(1)]);
if((state_val_33431 === (7))){
var inst_33426 = (state_33430[(2)]);
var state_33430__$1 = state_33430;
var statearr_33432_35522 = state_33430__$1;
(statearr_33432_35522[(2)] = inst_33426);

(statearr_33432_35522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (1))){
var state_33430__$1 = state_33430;
var statearr_33440_35524 = state_33430__$1;
(statearr_33440_35524[(2)] = null);

(statearr_33440_35524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (4))){
var inst_33412 = (state_33430[(7)]);
var inst_33412__$1 = (state_33430[(2)]);
var inst_33413 = (inst_33412__$1 == null);
var state_33430__$1 = (function (){var statearr_33445 = state_33430;
(statearr_33445[(7)] = inst_33412__$1);

return statearr_33445;
})();
if(cljs.core.truth_(inst_33413)){
var statearr_33446_35537 = state_33430__$1;
(statearr_33446_35537[(1)] = (5));

} else {
var statearr_33447_35538 = state_33430__$1;
(statearr_33447_35538[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (6))){
var inst_33412 = (state_33430[(7)]);
var inst_33417 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33412) : p.call(null,inst_33412));
var state_33430__$1 = state_33430;
if(cljs.core.truth_(inst_33417)){
var statearr_33452_35542 = state_33430__$1;
(statearr_33452_35542[(1)] = (8));

} else {
var statearr_33453_35543 = state_33430__$1;
(statearr_33453_35543[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (3))){
var inst_33428 = (state_33430[(2)]);
var state_33430__$1 = state_33430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33430__$1,inst_33428);
} else {
if((state_val_33431 === (2))){
var state_33430__$1 = state_33430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33430__$1,(4),ch);
} else {
if((state_val_33431 === (11))){
var inst_33420 = (state_33430[(2)]);
var state_33430__$1 = state_33430;
var statearr_33454_35555 = state_33430__$1;
(statearr_33454_35555[(2)] = inst_33420);

(statearr_33454_35555[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (9))){
var state_33430__$1 = state_33430;
var statearr_33457_35562 = state_33430__$1;
(statearr_33457_35562[(2)] = null);

(statearr_33457_35562[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (5))){
var inst_33415 = cljs.core.async.close_BANG_(out);
var state_33430__$1 = state_33430;
var statearr_33458_35567 = state_33430__$1;
(statearr_33458_35567[(2)] = inst_33415);

(statearr_33458_35567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (10))){
var inst_33423 = (state_33430[(2)]);
var state_33430__$1 = (function (){var statearr_33459 = state_33430;
(statearr_33459[(8)] = inst_33423);

return statearr_33459;
})();
var statearr_33460_35571 = state_33430__$1;
(statearr_33460_35571[(2)] = null);

(statearr_33460_35571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33431 === (8))){
var inst_33412 = (state_33430[(7)]);
var state_33430__$1 = state_33430;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33430__$1,(11),out,inst_33412);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33465 = [null,null,null,null,null,null,null,null,null];
(statearr_33465[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33465[(1)] = (1));

return statearr_33465;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_33430){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33430);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33468){var ex__30550__auto__ = e33468;
var statearr_33469_35602 = state_33430;
(statearr_33469_35602[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33430[(4)]))){
var statearr_33470_35604 = state_33430;
(statearr_33470_35604[(1)] = cljs.core.first((state_33430[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35606 = state_33430;
state_33430 = G__35606;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_33430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_33430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33472 = f__30754__auto__();
(statearr_33472[(6)] = c__30753__auto___35520);

return statearr_33472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33479 = arguments.length;
switch (G__33479) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30753__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33554){
var state_val_33555 = (state_33554[(1)]);
if((state_val_33555 === (7))){
var inst_33549 = (state_33554[(2)]);
var state_33554__$1 = state_33554;
var statearr_33557_35620 = state_33554__$1;
(statearr_33557_35620[(2)] = inst_33549);

(statearr_33557_35620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (20))){
var inst_33515 = (state_33554[(7)]);
var inst_33530 = (state_33554[(2)]);
var inst_33531 = cljs.core.next(inst_33515);
var inst_33498 = inst_33531;
var inst_33499 = null;
var inst_33500 = (0);
var inst_33501 = (0);
var state_33554__$1 = (function (){var statearr_33563 = state_33554;
(statearr_33563[(8)] = inst_33500);

(statearr_33563[(9)] = inst_33530);

(statearr_33563[(10)] = inst_33499);

(statearr_33563[(11)] = inst_33498);

(statearr_33563[(12)] = inst_33501);

return statearr_33563;
})();
var statearr_33564_35648 = state_33554__$1;
(statearr_33564_35648[(2)] = null);

(statearr_33564_35648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (1))){
var state_33554__$1 = state_33554;
var statearr_33566_35658 = state_33554__$1;
(statearr_33566_35658[(2)] = null);

(statearr_33566_35658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (4))){
var inst_33486 = (state_33554[(13)]);
var inst_33486__$1 = (state_33554[(2)]);
var inst_33487 = (inst_33486__$1 == null);
var state_33554__$1 = (function (){var statearr_33571 = state_33554;
(statearr_33571[(13)] = inst_33486__$1);

return statearr_33571;
})();
if(cljs.core.truth_(inst_33487)){
var statearr_33572_35680 = state_33554__$1;
(statearr_33572_35680[(1)] = (5));

} else {
var statearr_33574_35689 = state_33554__$1;
(statearr_33574_35689[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (15))){
var state_33554__$1 = state_33554;
var statearr_33579_35699 = state_33554__$1;
(statearr_33579_35699[(2)] = null);

(statearr_33579_35699[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (21))){
var state_33554__$1 = state_33554;
var statearr_33580_35704 = state_33554__$1;
(statearr_33580_35704[(2)] = null);

(statearr_33580_35704[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (13))){
var inst_33500 = (state_33554[(8)]);
var inst_33499 = (state_33554[(10)]);
var inst_33498 = (state_33554[(11)]);
var inst_33501 = (state_33554[(12)]);
var inst_33509 = (state_33554[(2)]);
var inst_33512 = (inst_33501 + (1));
var tmp33576 = inst_33500;
var tmp33577 = inst_33499;
var tmp33578 = inst_33498;
var inst_33498__$1 = tmp33578;
var inst_33499__$1 = tmp33577;
var inst_33500__$1 = tmp33576;
var inst_33501__$1 = inst_33512;
var state_33554__$1 = (function (){var statearr_33582 = state_33554;
(statearr_33582[(8)] = inst_33500__$1);

(statearr_33582[(14)] = inst_33509);

(statearr_33582[(10)] = inst_33499__$1);

(statearr_33582[(11)] = inst_33498__$1);

(statearr_33582[(12)] = inst_33501__$1);

return statearr_33582;
})();
var statearr_33584_35748 = state_33554__$1;
(statearr_33584_35748[(2)] = null);

(statearr_33584_35748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (22))){
var state_33554__$1 = state_33554;
var statearr_33585_35760 = state_33554__$1;
(statearr_33585_35760[(2)] = null);

(statearr_33585_35760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (6))){
var inst_33486 = (state_33554[(13)]);
var inst_33496 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33486) : f.call(null,inst_33486));
var inst_33497 = cljs.core.seq(inst_33496);
var inst_33498 = inst_33497;
var inst_33499 = null;
var inst_33500 = (0);
var inst_33501 = (0);
var state_33554__$1 = (function (){var statearr_33591 = state_33554;
(statearr_33591[(8)] = inst_33500);

(statearr_33591[(10)] = inst_33499);

(statearr_33591[(11)] = inst_33498);

(statearr_33591[(12)] = inst_33501);

return statearr_33591;
})();
var statearr_33592_35779 = state_33554__$1;
(statearr_33592_35779[(2)] = null);

(statearr_33592_35779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (17))){
var inst_33515 = (state_33554[(7)]);
var inst_33523 = cljs.core.chunk_first(inst_33515);
var inst_33524 = cljs.core.chunk_rest(inst_33515);
var inst_33525 = cljs.core.count(inst_33523);
var inst_33498 = inst_33524;
var inst_33499 = inst_33523;
var inst_33500 = inst_33525;
var inst_33501 = (0);
var state_33554__$1 = (function (){var statearr_33596 = state_33554;
(statearr_33596[(8)] = inst_33500);

(statearr_33596[(10)] = inst_33499);

(statearr_33596[(11)] = inst_33498);

(statearr_33596[(12)] = inst_33501);

return statearr_33596;
})();
var statearr_33597_35797 = state_33554__$1;
(statearr_33597_35797[(2)] = null);

(statearr_33597_35797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (3))){
var inst_33551 = (state_33554[(2)]);
var state_33554__$1 = state_33554;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33554__$1,inst_33551);
} else {
if((state_val_33555 === (12))){
var inst_33539 = (state_33554[(2)]);
var state_33554__$1 = state_33554;
var statearr_33602_35799 = state_33554__$1;
(statearr_33602_35799[(2)] = inst_33539);

(statearr_33602_35799[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (2))){
var state_33554__$1 = state_33554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33554__$1,(4),in$);
} else {
if((state_val_33555 === (23))){
var inst_33547 = (state_33554[(2)]);
var state_33554__$1 = state_33554;
var statearr_33607_35803 = state_33554__$1;
(statearr_33607_35803[(2)] = inst_33547);

(statearr_33607_35803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (19))){
var inst_33534 = (state_33554[(2)]);
var state_33554__$1 = state_33554;
var statearr_33609_35807 = state_33554__$1;
(statearr_33609_35807[(2)] = inst_33534);

(statearr_33609_35807[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (11))){
var inst_33515 = (state_33554[(7)]);
var inst_33498 = (state_33554[(11)]);
var inst_33515__$1 = cljs.core.seq(inst_33498);
var state_33554__$1 = (function (){var statearr_33612 = state_33554;
(statearr_33612[(7)] = inst_33515__$1);

return statearr_33612;
})();
if(inst_33515__$1){
var statearr_33617_35821 = state_33554__$1;
(statearr_33617_35821[(1)] = (14));

} else {
var statearr_33618_35825 = state_33554__$1;
(statearr_33618_35825[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (9))){
var inst_33541 = (state_33554[(2)]);
var inst_33542 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33554__$1 = (function (){var statearr_33619 = state_33554;
(statearr_33619[(15)] = inst_33541);

return statearr_33619;
})();
if(cljs.core.truth_(inst_33542)){
var statearr_33621_35837 = state_33554__$1;
(statearr_33621_35837[(1)] = (21));

} else {
var statearr_33622_35843 = state_33554__$1;
(statearr_33622_35843[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (5))){
var inst_33489 = cljs.core.async.close_BANG_(out);
var state_33554__$1 = state_33554;
var statearr_33623_35849 = state_33554__$1;
(statearr_33623_35849[(2)] = inst_33489);

(statearr_33623_35849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (14))){
var inst_33515 = (state_33554[(7)]);
var inst_33519 = cljs.core.chunked_seq_QMARK_(inst_33515);
var state_33554__$1 = state_33554;
if(inst_33519){
var statearr_33625_35854 = state_33554__$1;
(statearr_33625_35854[(1)] = (17));

} else {
var statearr_33626_35855 = state_33554__$1;
(statearr_33626_35855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (16))){
var inst_33537 = (state_33554[(2)]);
var state_33554__$1 = state_33554;
var statearr_33629_35856 = state_33554__$1;
(statearr_33629_35856[(2)] = inst_33537);

(statearr_33629_35856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33555 === (10))){
var inst_33499 = (state_33554[(10)]);
var inst_33501 = (state_33554[(12)]);
var inst_33507 = cljs.core._nth(inst_33499,inst_33501);
var state_33554__$1 = state_33554;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33554__$1,(13),out,inst_33507);
} else {
if((state_val_33555 === (18))){
var inst_33515 = (state_33554[(7)]);
var inst_33528 = cljs.core.first(inst_33515);
var state_33554__$1 = state_33554;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33554__$1,(20),out,inst_33528);
} else {
if((state_val_33555 === (8))){
var inst_33500 = (state_33554[(8)]);
var inst_33501 = (state_33554[(12)]);
var inst_33504 = (inst_33501 < inst_33500);
var inst_33505 = inst_33504;
var state_33554__$1 = state_33554;
if(cljs.core.truth_(inst_33505)){
var statearr_33632_35872 = state_33554__$1;
(statearr_33632_35872[(1)] = (10));

} else {
var statearr_33633_35873 = state_33554__$1;
(statearr_33633_35873[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30547__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30547__auto____0 = (function (){
var statearr_33637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33637[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30547__auto__);

(statearr_33637[(1)] = (1));

return statearr_33637;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30547__auto____1 = (function (state_33554){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33554);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33638){var ex__30550__auto__ = e33638;
var statearr_33640_35889 = state_33554;
(statearr_33640_35889[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33554[(4)]))){
var statearr_33642_35897 = state_33554;
(statearr_33642_35897[(1)] = cljs.core.first((state_33554[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35898 = state_33554;
state_33554 = G__35898;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30547__auto__ = function(state_33554){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30547__auto____1.call(this,state_33554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30547__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30547__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33644 = f__30754__auto__();
(statearr_33644[(6)] = c__30753__auto__);

return statearr_33644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));

return c__30753__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33646 = arguments.length;
switch (G__33646) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33669 = arguments.length;
switch (G__33669) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33684 = arguments.length;
switch (G__33684) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30753__auto___35957 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33713){
var state_val_33714 = (state_33713[(1)]);
if((state_val_33714 === (7))){
var inst_33708 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33719_35964 = state_33713__$1;
(statearr_33719_35964[(2)] = inst_33708);

(statearr_33719_35964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (1))){
var inst_33688 = null;
var state_33713__$1 = (function (){var statearr_33720 = state_33713;
(statearr_33720[(7)] = inst_33688);

return statearr_33720;
})();
var statearr_33721_35976 = state_33713__$1;
(statearr_33721_35976[(2)] = null);

(statearr_33721_35976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (4))){
var inst_33691 = (state_33713[(8)]);
var inst_33691__$1 = (state_33713[(2)]);
var inst_33694 = (inst_33691__$1 == null);
var inst_33695 = cljs.core.not(inst_33694);
var state_33713__$1 = (function (){var statearr_33722 = state_33713;
(statearr_33722[(8)] = inst_33691__$1);

return statearr_33722;
})();
if(inst_33695){
var statearr_33723_35987 = state_33713__$1;
(statearr_33723_35987[(1)] = (5));

} else {
var statearr_33724_35988 = state_33713__$1;
(statearr_33724_35988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (6))){
var state_33713__$1 = state_33713;
var statearr_33725_35993 = state_33713__$1;
(statearr_33725_35993[(2)] = null);

(statearr_33725_35993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (3))){
var inst_33710 = (state_33713[(2)]);
var inst_33711 = cljs.core.async.close_BANG_(out);
var state_33713__$1 = (function (){var statearr_33726 = state_33713;
(statearr_33726[(9)] = inst_33710);

return statearr_33726;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33713__$1,inst_33711);
} else {
if((state_val_33714 === (2))){
var state_33713__$1 = state_33713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33713__$1,(4),ch);
} else {
if((state_val_33714 === (11))){
var inst_33691 = (state_33713[(8)]);
var inst_33702 = (state_33713[(2)]);
var inst_33688 = inst_33691;
var state_33713__$1 = (function (){var statearr_33727 = state_33713;
(statearr_33727[(7)] = inst_33688);

(statearr_33727[(10)] = inst_33702);

return statearr_33727;
})();
var statearr_33728_36002 = state_33713__$1;
(statearr_33728_36002[(2)] = null);

(statearr_33728_36002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (9))){
var inst_33691 = (state_33713[(8)]);
var state_33713__$1 = state_33713;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33713__$1,(11),out,inst_33691);
} else {
if((state_val_33714 === (5))){
var inst_33688 = (state_33713[(7)]);
var inst_33691 = (state_33713[(8)]);
var inst_33697 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33691,inst_33688);
var state_33713__$1 = state_33713;
if(inst_33697){
var statearr_33734_36004 = state_33713__$1;
(statearr_33734_36004[(1)] = (8));

} else {
var statearr_33735_36006 = state_33713__$1;
(statearr_33735_36006[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (10))){
var inst_33705 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33736_36008 = state_33713__$1;
(statearr_33736_36008[(2)] = inst_33705);

(statearr_33736_36008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (8))){
var inst_33688 = (state_33713[(7)]);
var tmp33729 = inst_33688;
var inst_33688__$1 = tmp33729;
var state_33713__$1 = (function (){var statearr_33737 = state_33713;
(statearr_33737[(7)] = inst_33688__$1);

return statearr_33737;
})();
var statearr_33740_36009 = state_33713__$1;
(statearr_33740_36009[(2)] = null);

(statearr_33740_36009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33741 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33741[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33741[(1)] = (1));

return statearr_33741;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_33713){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33713);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33743){var ex__30550__auto__ = e33743;
var statearr_33744_36017 = state_33713;
(statearr_33744_36017[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33713[(4)]))){
var statearr_33745_36022 = state_33713;
(statearr_33745_36022[(1)] = cljs.core.first((state_33713[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36030 = state_33713;
state_33713 = G__36030;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_33713){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_33713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33747 = f__30754__auto__();
(statearr_33747[(6)] = c__30753__auto___35957);

return statearr_33747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33749 = arguments.length;
switch (G__33749) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30753__auto___36068 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33801){
var state_val_33802 = (state_33801[(1)]);
if((state_val_33802 === (7))){
var inst_33797 = (state_33801[(2)]);
var state_33801__$1 = state_33801;
var statearr_33808_36078 = state_33801__$1;
(statearr_33808_36078[(2)] = inst_33797);

(statearr_33808_36078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (1))){
var inst_33760 = (new Array(n));
var inst_33763 = inst_33760;
var inst_33764 = (0);
var state_33801__$1 = (function (){var statearr_33809 = state_33801;
(statearr_33809[(7)] = inst_33763);

(statearr_33809[(8)] = inst_33764);

return statearr_33809;
})();
var statearr_33810_36083 = state_33801__$1;
(statearr_33810_36083[(2)] = null);

(statearr_33810_36083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (4))){
var inst_33767 = (state_33801[(9)]);
var inst_33767__$1 = (state_33801[(2)]);
var inst_33768 = (inst_33767__$1 == null);
var inst_33769 = cljs.core.not(inst_33768);
var state_33801__$1 = (function (){var statearr_33811 = state_33801;
(statearr_33811[(9)] = inst_33767__$1);

return statearr_33811;
})();
if(inst_33769){
var statearr_33812_36084 = state_33801__$1;
(statearr_33812_36084[(1)] = (5));

} else {
var statearr_33819_36085 = state_33801__$1;
(statearr_33819_36085[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (15))){
var inst_33791 = (state_33801[(2)]);
var state_33801__$1 = state_33801;
var statearr_33822_36087 = state_33801__$1;
(statearr_33822_36087[(2)] = inst_33791);

(statearr_33822_36087[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (13))){
var state_33801__$1 = state_33801;
var statearr_33823_36089 = state_33801__$1;
(statearr_33823_36089[(2)] = null);

(statearr_33823_36089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (6))){
var inst_33764 = (state_33801[(8)]);
var inst_33787 = (inst_33764 > (0));
var state_33801__$1 = state_33801;
if(cljs.core.truth_(inst_33787)){
var statearr_33830_36096 = state_33801__$1;
(statearr_33830_36096[(1)] = (12));

} else {
var statearr_33831_36097 = state_33801__$1;
(statearr_33831_36097[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (3))){
var inst_33799 = (state_33801[(2)]);
var state_33801__$1 = state_33801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33801__$1,inst_33799);
} else {
if((state_val_33802 === (12))){
var inst_33763 = (state_33801[(7)]);
var inst_33789 = cljs.core.vec(inst_33763);
var state_33801__$1 = state_33801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33801__$1,(15),out,inst_33789);
} else {
if((state_val_33802 === (2))){
var state_33801__$1 = state_33801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33801__$1,(4),ch);
} else {
if((state_val_33802 === (11))){
var inst_33780 = (state_33801[(2)]);
var inst_33781 = (new Array(n));
var inst_33763 = inst_33781;
var inst_33764 = (0);
var state_33801__$1 = (function (){var statearr_33832 = state_33801;
(statearr_33832[(7)] = inst_33763);

(statearr_33832[(10)] = inst_33780);

(statearr_33832[(8)] = inst_33764);

return statearr_33832;
})();
var statearr_33833_36106 = state_33801__$1;
(statearr_33833_36106[(2)] = null);

(statearr_33833_36106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (9))){
var inst_33763 = (state_33801[(7)]);
var inst_33778 = cljs.core.vec(inst_33763);
var state_33801__$1 = state_33801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33801__$1,(11),out,inst_33778);
} else {
if((state_val_33802 === (5))){
var inst_33763 = (state_33801[(7)]);
var inst_33767 = (state_33801[(9)]);
var inst_33772 = (state_33801[(11)]);
var inst_33764 = (state_33801[(8)]);
var inst_33771 = (inst_33763[inst_33764] = inst_33767);
var inst_33772__$1 = (inst_33764 + (1));
var inst_33773 = (inst_33772__$1 < n);
var state_33801__$1 = (function (){var statearr_33834 = state_33801;
(statearr_33834[(11)] = inst_33772__$1);

(statearr_33834[(12)] = inst_33771);

return statearr_33834;
})();
if(cljs.core.truth_(inst_33773)){
var statearr_33835_36107 = state_33801__$1;
(statearr_33835_36107[(1)] = (8));

} else {
var statearr_33838_36108 = state_33801__$1;
(statearr_33838_36108[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (14))){
var inst_33794 = (state_33801[(2)]);
var inst_33795 = cljs.core.async.close_BANG_(out);
var state_33801__$1 = (function (){var statearr_33843 = state_33801;
(statearr_33843[(13)] = inst_33794);

return statearr_33843;
})();
var statearr_33846_36110 = state_33801__$1;
(statearr_33846_36110[(2)] = inst_33795);

(statearr_33846_36110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (10))){
var inst_33784 = (state_33801[(2)]);
var state_33801__$1 = state_33801;
var statearr_33849_36111 = state_33801__$1;
(statearr_33849_36111[(2)] = inst_33784);

(statearr_33849_36111[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33802 === (8))){
var inst_33763 = (state_33801[(7)]);
var inst_33772 = (state_33801[(11)]);
var tmp33839 = inst_33763;
var inst_33763__$1 = tmp33839;
var inst_33764 = inst_33772;
var state_33801__$1 = (function (){var statearr_33854 = state_33801;
(statearr_33854[(7)] = inst_33763__$1);

(statearr_33854[(8)] = inst_33764);

return statearr_33854;
})();
var statearr_33855_36112 = state_33801__$1;
(statearr_33855_36112[(2)] = null);

(statearr_33855_36112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33858 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33858[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33858[(1)] = (1));

return statearr_33858;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_33801){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33801);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33868){var ex__30550__auto__ = e33868;
var statearr_33871_36120 = state_33801;
(statearr_33871_36120[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33801[(4)]))){
var statearr_33875_36122 = state_33801;
(statearr_33875_36122[(1)] = cljs.core.first((state_33801[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36123 = state_33801;
state_33801 = G__36123;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_33801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_33801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33878 = f__30754__auto__();
(statearr_33878[(6)] = c__30753__auto___36068);

return statearr_33878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33885 = arguments.length;
switch (G__33885) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30753__auto___36127 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30754__auto__ = (function (){var switch__30546__auto__ = (function (state_33938){
var state_val_33939 = (state_33938[(1)]);
if((state_val_33939 === (7))){
var inst_33934 = (state_33938[(2)]);
var state_33938__$1 = state_33938;
var statearr_33941_36128 = state_33938__$1;
(statearr_33941_36128[(2)] = inst_33934);

(statearr_33941_36128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (1))){
var inst_33890 = [];
var inst_33891 = inst_33890;
var inst_33892 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33938__$1 = (function (){var statearr_33946 = state_33938;
(statearr_33946[(7)] = inst_33892);

(statearr_33946[(8)] = inst_33891);

return statearr_33946;
})();
var statearr_33947_36130 = state_33938__$1;
(statearr_33947_36130[(2)] = null);

(statearr_33947_36130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (4))){
var inst_33895 = (state_33938[(9)]);
var inst_33895__$1 = (state_33938[(2)]);
var inst_33896 = (inst_33895__$1 == null);
var inst_33897 = cljs.core.not(inst_33896);
var state_33938__$1 = (function (){var statearr_33948 = state_33938;
(statearr_33948[(9)] = inst_33895__$1);

return statearr_33948;
})();
if(inst_33897){
var statearr_33950_36133 = state_33938__$1;
(statearr_33950_36133[(1)] = (5));

} else {
var statearr_33951_36134 = state_33938__$1;
(statearr_33951_36134[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (15))){
var inst_33891 = (state_33938[(8)]);
var inst_33926 = cljs.core.vec(inst_33891);
var state_33938__$1 = state_33938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33938__$1,(18),out,inst_33926);
} else {
if((state_val_33939 === (13))){
var inst_33917 = (state_33938[(2)]);
var state_33938__$1 = state_33938;
var statearr_33952_36136 = state_33938__$1;
(statearr_33952_36136[(2)] = inst_33917);

(statearr_33952_36136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (6))){
var inst_33891 = (state_33938[(8)]);
var inst_33920 = inst_33891.length;
var inst_33921 = (inst_33920 > (0));
var state_33938__$1 = state_33938;
if(cljs.core.truth_(inst_33921)){
var statearr_33953_36144 = state_33938__$1;
(statearr_33953_36144[(1)] = (15));

} else {
var statearr_33954_36149 = state_33938__$1;
(statearr_33954_36149[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (17))){
var inst_33931 = (state_33938[(2)]);
var inst_33932 = cljs.core.async.close_BANG_(out);
var state_33938__$1 = (function (){var statearr_33955 = state_33938;
(statearr_33955[(10)] = inst_33931);

return statearr_33955;
})();
var statearr_33956_36156 = state_33938__$1;
(statearr_33956_36156[(2)] = inst_33932);

(statearr_33956_36156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (3))){
var inst_33936 = (state_33938[(2)]);
var state_33938__$1 = state_33938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33938__$1,inst_33936);
} else {
if((state_val_33939 === (12))){
var inst_33891 = (state_33938[(8)]);
var inst_33910 = cljs.core.vec(inst_33891);
var state_33938__$1 = state_33938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33938__$1,(14),out,inst_33910);
} else {
if((state_val_33939 === (2))){
var state_33938__$1 = state_33938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33938__$1,(4),ch);
} else {
if((state_val_33939 === (11))){
var inst_33899 = (state_33938[(11)]);
var inst_33891 = (state_33938[(8)]);
var inst_33895 = (state_33938[(9)]);
var inst_33907 = inst_33891.push(inst_33895);
var tmp33957 = inst_33891;
var inst_33891__$1 = tmp33957;
var inst_33892 = inst_33899;
var state_33938__$1 = (function (){var statearr_33958 = state_33938;
(statearr_33958[(7)] = inst_33892);

(statearr_33958[(12)] = inst_33907);

(statearr_33958[(8)] = inst_33891__$1);

return statearr_33958;
})();
var statearr_33959_36160 = state_33938__$1;
(statearr_33959_36160[(2)] = null);

(statearr_33959_36160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (9))){
var inst_33892 = (state_33938[(7)]);
var inst_33903 = cljs.core.keyword_identical_QMARK_(inst_33892,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_33938__$1 = state_33938;
var statearr_33960_36167 = state_33938__$1;
(statearr_33960_36167[(2)] = inst_33903);

(statearr_33960_36167[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (5))){
var inst_33892 = (state_33938[(7)]);
var inst_33899 = (state_33938[(11)]);
var inst_33895 = (state_33938[(9)]);
var inst_33900 = (state_33938[(13)]);
var inst_33899__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33895) : f.call(null,inst_33895));
var inst_33900__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33899__$1,inst_33892);
var state_33938__$1 = (function (){var statearr_33963 = state_33938;
(statearr_33963[(11)] = inst_33899__$1);

(statearr_33963[(13)] = inst_33900__$1);

return statearr_33963;
})();
if(inst_33900__$1){
var statearr_33964_36172 = state_33938__$1;
(statearr_33964_36172[(1)] = (8));

} else {
var statearr_33965_36173 = state_33938__$1;
(statearr_33965_36173[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (14))){
var inst_33899 = (state_33938[(11)]);
var inst_33895 = (state_33938[(9)]);
var inst_33912 = (state_33938[(2)]);
var inst_33913 = [];
var inst_33914 = inst_33913.push(inst_33895);
var inst_33891 = inst_33913;
var inst_33892 = inst_33899;
var state_33938__$1 = (function (){var statearr_33966 = state_33938;
(statearr_33966[(7)] = inst_33892);

(statearr_33966[(14)] = inst_33914);

(statearr_33966[(8)] = inst_33891);

(statearr_33966[(15)] = inst_33912);

return statearr_33966;
})();
var statearr_33967_36176 = state_33938__$1;
(statearr_33967_36176[(2)] = null);

(statearr_33967_36176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (16))){
var state_33938__$1 = state_33938;
var statearr_33971_36180 = state_33938__$1;
(statearr_33971_36180[(2)] = null);

(statearr_33971_36180[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (10))){
var inst_33905 = (state_33938[(2)]);
var state_33938__$1 = state_33938;
if(cljs.core.truth_(inst_33905)){
var statearr_33972_36181 = state_33938__$1;
(statearr_33972_36181[(1)] = (11));

} else {
var statearr_33973_36182 = state_33938__$1;
(statearr_33973_36182[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (18))){
var inst_33928 = (state_33938[(2)]);
var state_33938__$1 = state_33938;
var statearr_33979_36191 = state_33938__$1;
(statearr_33979_36191[(2)] = inst_33928);

(statearr_33979_36191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33939 === (8))){
var inst_33900 = (state_33938[(13)]);
var state_33938__$1 = state_33938;
var statearr_33980_36192 = state_33938__$1;
(statearr_33980_36192[(2)] = inst_33900);

(statearr_33980_36192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30547__auto__ = null;
var cljs$core$async$state_machine__30547__auto____0 = (function (){
var statearr_33981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33981[(0)] = cljs$core$async$state_machine__30547__auto__);

(statearr_33981[(1)] = (1));

return statearr_33981;
});
var cljs$core$async$state_machine__30547__auto____1 = (function (state_33938){
while(true){
var ret_value__30548__auto__ = (function (){try{while(true){
var result__30549__auto__ = switch__30546__auto__(state_33938);
if(cljs.core.keyword_identical_QMARK_(result__30549__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30549__auto__;
}
break;
}
}catch (e33982){var ex__30550__auto__ = e33982;
var statearr_33983_36195 = state_33938;
(statearr_33983_36195[(2)] = ex__30550__auto__);


if(cljs.core.seq((state_33938[(4)]))){
var statearr_33984_36198 = state_33938;
(statearr_33984_36198[(1)] = cljs.core.first((state_33938[(4)])));

} else {
throw ex__30550__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30548__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36203 = state_33938;
state_33938 = G__36203;
continue;
} else {
return ret_value__30548__auto__;
}
break;
}
});
cljs$core$async$state_machine__30547__auto__ = function(state_33938){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30547__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30547__auto____1.call(this,state_33938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30547__auto____0;
cljs$core$async$state_machine__30547__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30547__auto____1;
return cljs$core$async$state_machine__30547__auto__;
})()
})();
var state__30755__auto__ = (function (){var statearr_33993 = f__30754__auto__();
(statearr_33993[(6)] = c__30753__auto___36127);

return statearr_33993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30755__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
