goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__56487){
var vec__56490 = p__56487;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56490,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56490,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__56523 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__56523__$1 = (((G__56523 instanceof cljs.core.Keyword))?G__56523.fqn:null);
switch (G__56523__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__56531 = (function (){
var seq__56532 = cljs.core.seq(vars__$1);
var chunk__56533 = null;
var count__56534 = (0);
var i__56535 = (0);
while(true){
if((i__56535 < count__56534)){
var v = chunk__56533.cljs$core$IIndexed$_nth$arity$2(null,i__56535);
var temp__5804__auto___56854 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56854)){
var t_56855 = temp__5804__auto___56854;
var G__56541_56856 = ((function (seq__56532,chunk__56533,count__56534,i__56535,t_56855,temp__5804__auto___56854,v,each_fixture_fn,G__56523,G__56523__$1,env,once_fixtures,each_fixtures,vec__56490,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56855)));
});})(seq__56532,chunk__56533,count__56534,i__56535,t_56855,temp__5804__auto___56854,v,each_fixture_fn,G__56523,G__56523__$1,env,once_fixtures,each_fixtures,vec__56490,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56541_56856) : each_fixture_fn.call(null,G__56541_56856));
} else {
}


var G__56858 = seq__56532;
var G__56859 = chunk__56533;
var G__56860 = count__56534;
var G__56861 = (i__56535 + (1));
seq__56532 = G__56858;
chunk__56533 = G__56859;
count__56534 = G__56860;
i__56535 = G__56861;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__56532);
if(temp__5804__auto__){
var seq__56532__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56532__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__56532__$1);
var G__56863 = cljs.core.chunk_rest(seq__56532__$1);
var G__56864 = c__5568__auto__;
var G__56865 = cljs.core.count(c__5568__auto__);
var G__56866 = (0);
seq__56532 = G__56863;
chunk__56533 = G__56864;
count__56534 = G__56865;
i__56535 = G__56866;
continue;
} else {
var v = cljs.core.first(seq__56532__$1);
var temp__5804__auto___56868__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56868__$1)){
var t_56869 = temp__5804__auto___56868__$1;
var G__56546_56870 = ((function (seq__56532,chunk__56533,count__56534,i__56535,t_56869,temp__5804__auto___56868__$1,v,seq__56532__$1,temp__5804__auto__,each_fixture_fn,G__56523,G__56523__$1,env,once_fixtures,each_fixtures,vec__56490,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56869)));
});})(seq__56532,chunk__56533,count__56534,i__56535,t_56869,temp__5804__auto___56868__$1,v,seq__56532__$1,temp__5804__auto__,each_fixture_fn,G__56523,G__56523__$1,env,once_fixtures,each_fixtures,vec__56490,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56546_56870) : each_fixture_fn.call(null,G__56546_56870));
} else {
}


var G__56871 = cljs.core.next(seq__56532__$1);
var G__56872 = null;
var G__56873 = (0);
var G__56874 = (0);
seq__56532 = G__56871;
chunk__56533 = G__56872;
count__56534 = G__56873;
i__56535 = G__56874;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__56530 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__56530.cljs$core$IFn$_invoke$arity$1 ? fexpr__56530.cljs$core$IFn$_invoke$arity$1(G__56531) : fexpr__56530.call(null,G__56531));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56523__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__56469_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56469_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__56556 = shadow.test.env.get_test_ns_info(ns);
var map__56556__$1 = cljs.core.__destructure_map(map__56556);
var test_ns = map__56556__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56556__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__56561,vars){
var map__56563 = p__56561;
var map__56563__$1 = cljs.core.__destructure_map(map__56563);
var env = map__56563__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56563__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__56568_56910 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__56570_56911 = null;
var count__56571_56912 = (0);
var i__56572_56913 = (0);
while(true){
if((i__56572_56913 < count__56571_56912)){
var vec__56596_56914 = chunk__56570_56911.cljs$core$IIndexed$_nth$arity$2(null,i__56572_56913);
var test_ns_56915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56596_56914,(0),null);
var ns_info_56916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56596_56914,(1),null);
var map__56599_56918 = ns_info_56916;
var map__56599_56919__$1 = cljs.core.__destructure_map(map__56599_56918);
var fixtures_56920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56599_56919__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56921 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56920);
if(cljs.core.truth_(temp__5804__auto___56921)){
var fix_56922 = temp__5804__auto___56921;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56915,fix_56922], 0));
} else {
}

var temp__5804__auto___56923 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56920);
if(cljs.core.truth_(temp__5804__auto___56923)){
var fix_56924 = temp__5804__auto___56923;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56915,fix_56924], 0));
} else {
}


var G__56925 = seq__56568_56910;
var G__56926 = chunk__56570_56911;
var G__56927 = count__56571_56912;
var G__56928 = (i__56572_56913 + (1));
seq__56568_56910 = G__56925;
chunk__56570_56911 = G__56926;
count__56571_56912 = G__56927;
i__56572_56913 = G__56928;
continue;
} else {
var temp__5804__auto___56929 = cljs.core.seq(seq__56568_56910);
if(temp__5804__auto___56929){
var seq__56568_56930__$1 = temp__5804__auto___56929;
if(cljs.core.chunked_seq_QMARK_(seq__56568_56930__$1)){
var c__5568__auto___56931 = cljs.core.chunk_first(seq__56568_56930__$1);
var G__56932 = cljs.core.chunk_rest(seq__56568_56930__$1);
var G__56933 = c__5568__auto___56931;
var G__56934 = cljs.core.count(c__5568__auto___56931);
var G__56935 = (0);
seq__56568_56910 = G__56932;
chunk__56570_56911 = G__56933;
count__56571_56912 = G__56934;
i__56572_56913 = G__56935;
continue;
} else {
var vec__56613_56936 = cljs.core.first(seq__56568_56930__$1);
var test_ns_56937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56613_56936,(0),null);
var ns_info_56938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56613_56936,(1),null);
var map__56616_56939 = ns_info_56938;
var map__56616_56940__$1 = cljs.core.__destructure_map(map__56616_56939);
var fixtures_56941 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56616_56940__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56943__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56941);
if(cljs.core.truth_(temp__5804__auto___56943__$1)){
var fix_56944 = temp__5804__auto___56943__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56937,fix_56944], 0));
} else {
}

var temp__5804__auto___56945__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56941);
if(cljs.core.truth_(temp__5804__auto___56945__$1)){
var fix_56946 = temp__5804__auto___56945__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56937,fix_56946], 0));
} else {
}


var G__56947 = cljs.core.next(seq__56568_56930__$1);
var G__56948 = null;
var G__56949 = (0);
var G__56950 = (0);
seq__56568_56910 = G__56947;
chunk__56570_56911 = G__56948;
count__56571_56912 = G__56949;
i__56572_56913 = G__56950;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56560_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56560_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__56635 = cljs.test.get_current_env();
var map__56635__$1 = cljs.core.__destructure_map(map__56635);
var env = map__56635__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56635__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56635__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__56748 = arguments.length;
switch (G__56748) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__56763 = arguments.length;
switch (G__56763) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__56772 = shadow.test.env.get_test_ns_info(ns);
var map__56772__$1 = cljs.core.__destructure_map(map__56772);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56772__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__56795 = arguments.length;
switch (G__56795) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56788_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56788_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__56851 = arguments.length;
switch (G__56851) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56848_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56848_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
