goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35683 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35683(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35684 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35684(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34742 = coll;
var G__34744 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34742,G__34744) : shadow.dom.lazy_native_coll_seq.call(null,G__34742,G__34744));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34808 = arguments.length;
switch (G__34808) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34813 = arguments.length;
switch (G__34813) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34822 = arguments.length;
switch (G__34822) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34832 = arguments.length;
switch (G__34832) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34842 = arguments.length;
switch (G__34842) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34851 = arguments.length;
switch (G__34851) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34854){if((e34854 instanceof Object)){
var e = e34854;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34854;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34871 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34872 = null;
var count__34873 = (0);
var i__34874 = (0);
while(true){
if((i__34874 < count__34873)){
var el = chunk__34872.cljs$core$IIndexed$_nth$arity$2(null,i__34874);
var handler_35691__$1 = ((function (seq__34871,chunk__34872,count__34873,i__34874,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34871,chunk__34872,count__34873,i__34874,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35691__$1);


var G__35692 = seq__34871;
var G__35693 = chunk__34872;
var G__35694 = count__34873;
var G__35695 = (i__34874 + (1));
seq__34871 = G__35692;
chunk__34872 = G__35693;
count__34873 = G__35694;
i__34874 = G__35695;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34871);
if(temp__5804__auto__){
var seq__34871__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34871__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34871__$1);
var G__35696 = cljs.core.chunk_rest(seq__34871__$1);
var G__35697 = c__5568__auto__;
var G__35698 = cljs.core.count(c__5568__auto__);
var G__35699 = (0);
seq__34871 = G__35696;
chunk__34872 = G__35697;
count__34873 = G__35698;
i__34874 = G__35699;
continue;
} else {
var el = cljs.core.first(seq__34871__$1);
var handler_35700__$1 = ((function (seq__34871,chunk__34872,count__34873,i__34874,el,seq__34871__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34871,chunk__34872,count__34873,i__34874,el,seq__34871__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35700__$1);


var G__35701 = cljs.core.next(seq__34871__$1);
var G__35702 = null;
var G__35703 = (0);
var G__35704 = (0);
seq__34871 = G__35701;
chunk__34872 = G__35702;
count__34873 = G__35703;
i__34874 = G__35704;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34891 = arguments.length;
switch (G__34891) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34900 = cljs.core.seq(events);
var chunk__34901 = null;
var count__34902 = (0);
var i__34903 = (0);
while(true){
if((i__34903 < count__34902)){
var vec__34915 = chunk__34901.cljs$core$IIndexed$_nth$arity$2(null,i__34903);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34915,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34915,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35710 = seq__34900;
var G__35711 = chunk__34901;
var G__35712 = count__34902;
var G__35713 = (i__34903 + (1));
seq__34900 = G__35710;
chunk__34901 = G__35711;
count__34902 = G__35712;
i__34903 = G__35713;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34900);
if(temp__5804__auto__){
var seq__34900__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34900__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34900__$1);
var G__35714 = cljs.core.chunk_rest(seq__34900__$1);
var G__35715 = c__5568__auto__;
var G__35716 = cljs.core.count(c__5568__auto__);
var G__35717 = (0);
seq__34900 = G__35714;
chunk__34901 = G__35715;
count__34902 = G__35716;
i__34903 = G__35717;
continue;
} else {
var vec__34923 = cljs.core.first(seq__34900__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34923,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34923,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35718 = cljs.core.next(seq__34900__$1);
var G__35719 = null;
var G__35720 = (0);
var G__35721 = (0);
seq__34900 = G__35718;
chunk__34901 = G__35719;
count__34902 = G__35720;
i__34903 = G__35721;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34929 = cljs.core.seq(styles);
var chunk__34930 = null;
var count__34931 = (0);
var i__34932 = (0);
while(true){
if((i__34932 < count__34931)){
var vec__34947 = chunk__34930.cljs$core$IIndexed$_nth$arity$2(null,i__34932);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34947,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34947,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35725 = seq__34929;
var G__35726 = chunk__34930;
var G__35727 = count__34931;
var G__35728 = (i__34932 + (1));
seq__34929 = G__35725;
chunk__34930 = G__35726;
count__34931 = G__35727;
i__34932 = G__35728;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34929);
if(temp__5804__auto__){
var seq__34929__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34929__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34929__$1);
var G__35729 = cljs.core.chunk_rest(seq__34929__$1);
var G__35730 = c__5568__auto__;
var G__35731 = cljs.core.count(c__5568__auto__);
var G__35732 = (0);
seq__34929 = G__35729;
chunk__34930 = G__35730;
count__34931 = G__35731;
i__34932 = G__35732;
continue;
} else {
var vec__34956 = cljs.core.first(seq__34929__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34956,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34956,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35733 = cljs.core.next(seq__34929__$1);
var G__35734 = null;
var G__35735 = (0);
var G__35736 = (0);
seq__34929 = G__35733;
chunk__34930 = G__35734;
count__34931 = G__35735;
i__34932 = G__35736;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34963_35737 = key;
var G__34963_35738__$1 = (((G__34963_35737 instanceof cljs.core.Keyword))?G__34963_35737.fqn:null);
switch (G__34963_35738__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35740 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35740,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35740,"aria-");
}
})())){
el.setAttribute(ks_35740,value);
} else {
(el[ks_35740] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34997){
var map__34998 = p__34997;
var map__34998__$1 = cljs.core.__destructure_map(map__34998);
var props = map__34998__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34998__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__35000 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35000,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35000,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35000,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__35005 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__35005,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__35005;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__35023 = arguments.length;
switch (G__35023) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__35036){
var vec__35038 = p__35036;
var seq__35039 = cljs.core.seq(vec__35038);
var first__35040 = cljs.core.first(seq__35039);
var seq__35039__$1 = cljs.core.next(seq__35039);
var nn = first__35040;
var first__35040__$1 = cljs.core.first(seq__35039__$1);
var seq__35039__$2 = cljs.core.next(seq__35039__$1);
var np = first__35040__$1;
var nc = seq__35039__$2;
var node = vec__35038;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35042 = nn;
var G__35043 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35042,G__35043) : create_fn.call(null,G__35042,G__35043));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35045 = nn;
var G__35046 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35045,G__35046) : create_fn.call(null,G__35045,G__35046));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__35050 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35050,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35050,(1),null);
var seq__35054_35743 = cljs.core.seq(node_children);
var chunk__35055_35744 = null;
var count__35056_35745 = (0);
var i__35057_35746 = (0);
while(true){
if((i__35057_35746 < count__35056_35745)){
var child_struct_35747 = chunk__35055_35744.cljs$core$IIndexed$_nth$arity$2(null,i__35057_35746);
var children_35748 = shadow.dom.dom_node(child_struct_35747);
if(cljs.core.seq_QMARK_(children_35748)){
var seq__35093_35749 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35748));
var chunk__35095_35750 = null;
var count__35096_35751 = (0);
var i__35097_35752 = (0);
while(true){
if((i__35097_35752 < count__35096_35751)){
var child_35753 = chunk__35095_35750.cljs$core$IIndexed$_nth$arity$2(null,i__35097_35752);
if(cljs.core.truth_(child_35753)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35753);


var G__35754 = seq__35093_35749;
var G__35755 = chunk__35095_35750;
var G__35756 = count__35096_35751;
var G__35757 = (i__35097_35752 + (1));
seq__35093_35749 = G__35754;
chunk__35095_35750 = G__35755;
count__35096_35751 = G__35756;
i__35097_35752 = G__35757;
continue;
} else {
var G__35758 = seq__35093_35749;
var G__35759 = chunk__35095_35750;
var G__35760 = count__35096_35751;
var G__35761 = (i__35097_35752 + (1));
seq__35093_35749 = G__35758;
chunk__35095_35750 = G__35759;
count__35096_35751 = G__35760;
i__35097_35752 = G__35761;
continue;
}
} else {
var temp__5804__auto___35762 = cljs.core.seq(seq__35093_35749);
if(temp__5804__auto___35762){
var seq__35093_35763__$1 = temp__5804__auto___35762;
if(cljs.core.chunked_seq_QMARK_(seq__35093_35763__$1)){
var c__5568__auto___35764 = cljs.core.chunk_first(seq__35093_35763__$1);
var G__35765 = cljs.core.chunk_rest(seq__35093_35763__$1);
var G__35766 = c__5568__auto___35764;
var G__35767 = cljs.core.count(c__5568__auto___35764);
var G__35768 = (0);
seq__35093_35749 = G__35765;
chunk__35095_35750 = G__35766;
count__35096_35751 = G__35767;
i__35097_35752 = G__35768;
continue;
} else {
var child_35769 = cljs.core.first(seq__35093_35763__$1);
if(cljs.core.truth_(child_35769)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35769);


var G__35773 = cljs.core.next(seq__35093_35763__$1);
var G__35774 = null;
var G__35775 = (0);
var G__35776 = (0);
seq__35093_35749 = G__35773;
chunk__35095_35750 = G__35774;
count__35096_35751 = G__35775;
i__35097_35752 = G__35776;
continue;
} else {
var G__35777 = cljs.core.next(seq__35093_35763__$1);
var G__35778 = null;
var G__35779 = (0);
var G__35780 = (0);
seq__35093_35749 = G__35777;
chunk__35095_35750 = G__35778;
count__35096_35751 = G__35779;
i__35097_35752 = G__35780;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35748);
}


var G__35781 = seq__35054_35743;
var G__35782 = chunk__35055_35744;
var G__35783 = count__35056_35745;
var G__35784 = (i__35057_35746 + (1));
seq__35054_35743 = G__35781;
chunk__35055_35744 = G__35782;
count__35056_35745 = G__35783;
i__35057_35746 = G__35784;
continue;
} else {
var temp__5804__auto___35785 = cljs.core.seq(seq__35054_35743);
if(temp__5804__auto___35785){
var seq__35054_35786__$1 = temp__5804__auto___35785;
if(cljs.core.chunked_seq_QMARK_(seq__35054_35786__$1)){
var c__5568__auto___35787 = cljs.core.chunk_first(seq__35054_35786__$1);
var G__35788 = cljs.core.chunk_rest(seq__35054_35786__$1);
var G__35789 = c__5568__auto___35787;
var G__35790 = cljs.core.count(c__5568__auto___35787);
var G__35791 = (0);
seq__35054_35743 = G__35788;
chunk__35055_35744 = G__35789;
count__35056_35745 = G__35790;
i__35057_35746 = G__35791;
continue;
} else {
var child_struct_35792 = cljs.core.first(seq__35054_35786__$1);
var children_35793 = shadow.dom.dom_node(child_struct_35792);
if(cljs.core.seq_QMARK_(children_35793)){
var seq__35122_35794 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35793));
var chunk__35124_35795 = null;
var count__35125_35796 = (0);
var i__35126_35797 = (0);
while(true){
if((i__35126_35797 < count__35125_35796)){
var child_35798 = chunk__35124_35795.cljs$core$IIndexed$_nth$arity$2(null,i__35126_35797);
if(cljs.core.truth_(child_35798)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35798);


var G__35799 = seq__35122_35794;
var G__35800 = chunk__35124_35795;
var G__35801 = count__35125_35796;
var G__35802 = (i__35126_35797 + (1));
seq__35122_35794 = G__35799;
chunk__35124_35795 = G__35800;
count__35125_35796 = G__35801;
i__35126_35797 = G__35802;
continue;
} else {
var G__35803 = seq__35122_35794;
var G__35804 = chunk__35124_35795;
var G__35805 = count__35125_35796;
var G__35806 = (i__35126_35797 + (1));
seq__35122_35794 = G__35803;
chunk__35124_35795 = G__35804;
count__35125_35796 = G__35805;
i__35126_35797 = G__35806;
continue;
}
} else {
var temp__5804__auto___35807__$1 = cljs.core.seq(seq__35122_35794);
if(temp__5804__auto___35807__$1){
var seq__35122_35808__$1 = temp__5804__auto___35807__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35122_35808__$1)){
var c__5568__auto___35809 = cljs.core.chunk_first(seq__35122_35808__$1);
var G__35810 = cljs.core.chunk_rest(seq__35122_35808__$1);
var G__35811 = c__5568__auto___35809;
var G__35812 = cljs.core.count(c__5568__auto___35809);
var G__35813 = (0);
seq__35122_35794 = G__35810;
chunk__35124_35795 = G__35811;
count__35125_35796 = G__35812;
i__35126_35797 = G__35813;
continue;
} else {
var child_35814 = cljs.core.first(seq__35122_35808__$1);
if(cljs.core.truth_(child_35814)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35814);


var G__35815 = cljs.core.next(seq__35122_35808__$1);
var G__35816 = null;
var G__35817 = (0);
var G__35818 = (0);
seq__35122_35794 = G__35815;
chunk__35124_35795 = G__35816;
count__35125_35796 = G__35817;
i__35126_35797 = G__35818;
continue;
} else {
var G__35819 = cljs.core.next(seq__35122_35808__$1);
var G__35820 = null;
var G__35821 = (0);
var G__35822 = (0);
seq__35122_35794 = G__35819;
chunk__35124_35795 = G__35820;
count__35125_35796 = G__35821;
i__35126_35797 = G__35822;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35793);
}


var G__35823 = cljs.core.next(seq__35054_35786__$1);
var G__35824 = null;
var G__35825 = (0);
var G__35826 = (0);
seq__35054_35743 = G__35823;
chunk__35055_35744 = G__35824;
count__35056_35745 = G__35825;
i__35057_35746 = G__35826;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__35144 = cljs.core.seq(node);
var chunk__35145 = null;
var count__35146 = (0);
var i__35147 = (0);
while(true){
if((i__35147 < count__35146)){
var n = chunk__35145.cljs$core$IIndexed$_nth$arity$2(null,i__35147);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35827 = seq__35144;
var G__35828 = chunk__35145;
var G__35829 = count__35146;
var G__35830 = (i__35147 + (1));
seq__35144 = G__35827;
chunk__35145 = G__35828;
count__35146 = G__35829;
i__35147 = G__35830;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__35144);
if(temp__5804__auto__){
var seq__35144__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35144__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__35144__$1);
var G__35831 = cljs.core.chunk_rest(seq__35144__$1);
var G__35832 = c__5568__auto__;
var G__35833 = cljs.core.count(c__5568__auto__);
var G__35834 = (0);
seq__35144 = G__35831;
chunk__35145 = G__35832;
count__35146 = G__35833;
i__35147 = G__35834;
continue;
} else {
var n = cljs.core.first(seq__35144__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35835 = cljs.core.next(seq__35144__$1);
var G__35836 = null;
var G__35837 = (0);
var G__35838 = (0);
seq__35144 = G__35835;
chunk__35145 = G__35836;
count__35146 = G__35837;
i__35147 = G__35838;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__35166 = arguments.length;
switch (G__35166) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__35168 = arguments.length;
switch (G__35168) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__35178 = arguments.length;
switch (G__35178) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35842 = arguments.length;
var i__5770__auto___35843 = (0);
while(true){
if((i__5770__auto___35843 < len__5769__auto___35842)){
args__5775__auto__.push((arguments[i__5770__auto___35843]));

var G__35844 = (i__5770__auto___35843 + (1));
i__5770__auto___35843 = G__35844;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__35217_35845 = cljs.core.seq(nodes);
var chunk__35218_35846 = null;
var count__35219_35847 = (0);
var i__35220_35848 = (0);
while(true){
if((i__35220_35848 < count__35219_35847)){
var node_35849 = chunk__35218_35846.cljs$core$IIndexed$_nth$arity$2(null,i__35220_35848);
fragment.appendChild(shadow.dom._to_dom(node_35849));


var G__35850 = seq__35217_35845;
var G__35851 = chunk__35218_35846;
var G__35852 = count__35219_35847;
var G__35853 = (i__35220_35848 + (1));
seq__35217_35845 = G__35850;
chunk__35218_35846 = G__35851;
count__35219_35847 = G__35852;
i__35220_35848 = G__35853;
continue;
} else {
var temp__5804__auto___35854 = cljs.core.seq(seq__35217_35845);
if(temp__5804__auto___35854){
var seq__35217_35858__$1 = temp__5804__auto___35854;
if(cljs.core.chunked_seq_QMARK_(seq__35217_35858__$1)){
var c__5568__auto___35859 = cljs.core.chunk_first(seq__35217_35858__$1);
var G__35860 = cljs.core.chunk_rest(seq__35217_35858__$1);
var G__35861 = c__5568__auto___35859;
var G__35862 = cljs.core.count(c__5568__auto___35859);
var G__35863 = (0);
seq__35217_35845 = G__35860;
chunk__35218_35846 = G__35861;
count__35219_35847 = G__35862;
i__35220_35848 = G__35863;
continue;
} else {
var node_35864 = cljs.core.first(seq__35217_35858__$1);
fragment.appendChild(shadow.dom._to_dom(node_35864));


var G__35865 = cljs.core.next(seq__35217_35858__$1);
var G__35866 = null;
var G__35867 = (0);
var G__35868 = (0);
seq__35217_35845 = G__35865;
chunk__35218_35846 = G__35866;
count__35219_35847 = G__35867;
i__35220_35848 = G__35868;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq35202){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35202));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__35246_35869 = cljs.core.seq(scripts);
var chunk__35247_35870 = null;
var count__35248_35871 = (0);
var i__35249_35872 = (0);
while(true){
if((i__35249_35872 < count__35248_35871)){
var vec__35265_35873 = chunk__35247_35870.cljs$core$IIndexed$_nth$arity$2(null,i__35249_35872);
var script_tag_35874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35265_35873,(0),null);
var script_body_35875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35265_35873,(1),null);
eval(script_body_35875);


var G__35876 = seq__35246_35869;
var G__35877 = chunk__35247_35870;
var G__35878 = count__35248_35871;
var G__35879 = (i__35249_35872 + (1));
seq__35246_35869 = G__35876;
chunk__35247_35870 = G__35877;
count__35248_35871 = G__35878;
i__35249_35872 = G__35879;
continue;
} else {
var temp__5804__auto___35880 = cljs.core.seq(seq__35246_35869);
if(temp__5804__auto___35880){
var seq__35246_35881__$1 = temp__5804__auto___35880;
if(cljs.core.chunked_seq_QMARK_(seq__35246_35881__$1)){
var c__5568__auto___35882 = cljs.core.chunk_first(seq__35246_35881__$1);
var G__35883 = cljs.core.chunk_rest(seq__35246_35881__$1);
var G__35884 = c__5568__auto___35882;
var G__35885 = cljs.core.count(c__5568__auto___35882);
var G__35886 = (0);
seq__35246_35869 = G__35883;
chunk__35247_35870 = G__35884;
count__35248_35871 = G__35885;
i__35249_35872 = G__35886;
continue;
} else {
var vec__35271_35887 = cljs.core.first(seq__35246_35881__$1);
var script_tag_35888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35271_35887,(0),null);
var script_body_35889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35271_35887,(1),null);
eval(script_body_35889);


var G__35890 = cljs.core.next(seq__35246_35881__$1);
var G__35891 = null;
var G__35892 = (0);
var G__35893 = (0);
seq__35246_35869 = G__35890;
chunk__35247_35870 = G__35891;
count__35248_35871 = G__35892;
i__35249_35872 = G__35893;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__35276){
var vec__35277 = p__35276;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35277,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35277,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35290 = arguments.length;
switch (G__35290) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35313 = cljs.core.seq(style_keys);
var chunk__35314 = null;
var count__35315 = (0);
var i__35316 = (0);
while(true){
if((i__35316 < count__35315)){
var it = chunk__35314.cljs$core$IIndexed$_nth$arity$2(null,i__35316);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35895 = seq__35313;
var G__35896 = chunk__35314;
var G__35897 = count__35315;
var G__35898 = (i__35316 + (1));
seq__35313 = G__35895;
chunk__35314 = G__35896;
count__35315 = G__35897;
i__35316 = G__35898;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__35313);
if(temp__5804__auto__){
var seq__35313__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35313__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__35313__$1);
var G__35899 = cljs.core.chunk_rest(seq__35313__$1);
var G__35900 = c__5568__auto__;
var G__35901 = cljs.core.count(c__5568__auto__);
var G__35902 = (0);
seq__35313 = G__35899;
chunk__35314 = G__35900;
count__35315 = G__35901;
i__35316 = G__35902;
continue;
} else {
var it = cljs.core.first(seq__35313__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35903 = cljs.core.next(seq__35313__$1);
var G__35904 = null;
var G__35905 = (0);
var G__35906 = (0);
seq__35313 = G__35903;
chunk__35314 = G__35904;
count__35315 = G__35905;
i__35316 = G__35906;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35325,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35334 = k35325;
var G__35334__$1 = (((G__35334 instanceof cljs.core.Keyword))?G__35334.fqn:null);
switch (G__35334__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35325,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35341){
var vec__35344 = p__35341;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35344,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35344,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35324){
var self__ = this;
var G__35324__$1 = this;
return (new cljs.core.RecordIter((0),G__35324__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35326,other35327){
var self__ = this;
var this35326__$1 = this;
return (((!((other35327 == null)))) && ((((this35326__$1.constructor === other35327.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35326__$1.x,other35327.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35326__$1.y,other35327.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35326__$1.__extmap,other35327.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35325){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35381 = k35325;
var G__35381__$1 = (((G__35381 instanceof cljs.core.Keyword))?G__35381.fqn:null);
switch (G__35381__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35325);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35324){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35389 = cljs.core.keyword_identical_QMARK_;
var expr__35390 = k__5352__auto__;
if(cljs.core.truth_((pred__35389.cljs$core$IFn$_invoke$arity$2 ? pred__35389.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35390) : pred__35389.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35390)))){
return (new shadow.dom.Coordinate(G__35324,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35389.cljs$core$IFn$_invoke$arity$2 ? pred__35389.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35390) : pred__35389.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35390)))){
return (new shadow.dom.Coordinate(self__.x,G__35324,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35324),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35324){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35324,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35330){
var extmap__5385__auto__ = (function (){var G__35402 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35330,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__35330)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35402);
} else {
return G__35402;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35330),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35330),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35422,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35438 = k35422;
var G__35438__$1 = (((G__35438 instanceof cljs.core.Keyword))?G__35438.fqn:null);
switch (G__35438__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35422,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35440){
var vec__35441 = p__35440;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35441,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35441,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35421){
var self__ = this;
var G__35421__$1 = this;
return (new cljs.core.RecordIter((0),G__35421__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35424,other35425){
var self__ = this;
var this35424__$1 = this;
return (((!((other35425 == null)))) && ((((this35424__$1.constructor === other35425.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35424__$1.w,other35425.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35424__$1.h,other35425.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35424__$1.__extmap,other35425.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35422){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35463 = k35422;
var G__35463__$1 = (((G__35463 instanceof cljs.core.Keyword))?G__35463.fqn:null);
switch (G__35463__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35422);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35421){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35467 = cljs.core.keyword_identical_QMARK_;
var expr__35468 = k__5352__auto__;
if(cljs.core.truth_((pred__35467.cljs$core$IFn$_invoke$arity$2 ? pred__35467.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35468) : pred__35467.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35468)))){
return (new shadow.dom.Size(G__35421,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35467.cljs$core$IFn$_invoke$arity$2 ? pred__35467.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35468) : pred__35467.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35468)))){
return (new shadow.dom.Size(self__.w,G__35421,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35421),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35421){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35421,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35428){
var extmap__5385__auto__ = (function (){var G__35483 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35428,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35428)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35483);
} else {
return G__35483;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35428),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35428),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__35923 = (i + (1));
var G__35924 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35923;
ret = G__35924;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35488){
var vec__35489 = p__35488;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35489,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35489,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35494 = arguments.length;
switch (G__35494) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35928 = ps;
var G__35929 = (i + (1));
el__$1 = G__35928;
i = G__35929;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35527 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35527,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35527,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35527,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35531_35934 = cljs.core.seq(props);
var chunk__35532_35935 = null;
var count__35533_35936 = (0);
var i__35534_35937 = (0);
while(true){
if((i__35534_35937 < count__35533_35936)){
var vec__35561_35938 = chunk__35532_35935.cljs$core$IIndexed$_nth$arity$2(null,i__35534_35937);
var k_35939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35561_35938,(0),null);
var v_35940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35561_35938,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_35939);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35939),v_35940);


var G__35941 = seq__35531_35934;
var G__35942 = chunk__35532_35935;
var G__35943 = count__35533_35936;
var G__35944 = (i__35534_35937 + (1));
seq__35531_35934 = G__35941;
chunk__35532_35935 = G__35942;
count__35533_35936 = G__35943;
i__35534_35937 = G__35944;
continue;
} else {
var temp__5804__auto___35945 = cljs.core.seq(seq__35531_35934);
if(temp__5804__auto___35945){
var seq__35531_35946__$1 = temp__5804__auto___35945;
if(cljs.core.chunked_seq_QMARK_(seq__35531_35946__$1)){
var c__5568__auto___35948 = cljs.core.chunk_first(seq__35531_35946__$1);
var G__35949 = cljs.core.chunk_rest(seq__35531_35946__$1);
var G__35950 = c__5568__auto___35948;
var G__35951 = cljs.core.count(c__5568__auto___35948);
var G__35952 = (0);
seq__35531_35934 = G__35949;
chunk__35532_35935 = G__35950;
count__35533_35936 = G__35951;
i__35534_35937 = G__35952;
continue;
} else {
var vec__35569_35953 = cljs.core.first(seq__35531_35946__$1);
var k_35954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35569_35953,(0),null);
var v_35955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35569_35953,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35954);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35954),v_35955);


var G__35956 = cljs.core.next(seq__35531_35946__$1);
var G__35957 = null;
var G__35958 = (0);
var G__35959 = (0);
seq__35531_35934 = G__35956;
chunk__35532_35935 = G__35957;
count__35533_35936 = G__35958;
i__35534_35937 = G__35959;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35584 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35584,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35584,(1),null);
var seq__35587_35971 = cljs.core.seq(node_children);
var chunk__35589_35972 = null;
var count__35590_35973 = (0);
var i__35591_35974 = (0);
while(true){
if((i__35591_35974 < count__35590_35973)){
var child_struct_35975 = chunk__35589_35972.cljs$core$IIndexed$_nth$arity$2(null,i__35591_35974);
if((!((child_struct_35975 == null)))){
if(typeof child_struct_35975 === 'string'){
var text_35976 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35976),child_struct_35975].join(''));
} else {
var children_35977 = shadow.dom.svg_node(child_struct_35975);
if(cljs.core.seq_QMARK_(children_35977)){
var seq__35629_35978 = cljs.core.seq(children_35977);
var chunk__35631_35979 = null;
var count__35632_35980 = (0);
var i__35633_35981 = (0);
while(true){
if((i__35633_35981 < count__35632_35980)){
var child_35984 = chunk__35631_35979.cljs$core$IIndexed$_nth$arity$2(null,i__35633_35981);
if(cljs.core.truth_(child_35984)){
node.appendChild(child_35984);


var G__35985 = seq__35629_35978;
var G__35986 = chunk__35631_35979;
var G__35987 = count__35632_35980;
var G__35988 = (i__35633_35981 + (1));
seq__35629_35978 = G__35985;
chunk__35631_35979 = G__35986;
count__35632_35980 = G__35987;
i__35633_35981 = G__35988;
continue;
} else {
var G__35989 = seq__35629_35978;
var G__35990 = chunk__35631_35979;
var G__35991 = count__35632_35980;
var G__35992 = (i__35633_35981 + (1));
seq__35629_35978 = G__35989;
chunk__35631_35979 = G__35990;
count__35632_35980 = G__35991;
i__35633_35981 = G__35992;
continue;
}
} else {
var temp__5804__auto___35993 = cljs.core.seq(seq__35629_35978);
if(temp__5804__auto___35993){
var seq__35629_35994__$1 = temp__5804__auto___35993;
if(cljs.core.chunked_seq_QMARK_(seq__35629_35994__$1)){
var c__5568__auto___35995 = cljs.core.chunk_first(seq__35629_35994__$1);
var G__35997 = cljs.core.chunk_rest(seq__35629_35994__$1);
var G__35998 = c__5568__auto___35995;
var G__35999 = cljs.core.count(c__5568__auto___35995);
var G__36000 = (0);
seq__35629_35978 = G__35997;
chunk__35631_35979 = G__35998;
count__35632_35980 = G__35999;
i__35633_35981 = G__36000;
continue;
} else {
var child_36001 = cljs.core.first(seq__35629_35994__$1);
if(cljs.core.truth_(child_36001)){
node.appendChild(child_36001);


var G__36002 = cljs.core.next(seq__35629_35994__$1);
var G__36003 = null;
var G__36004 = (0);
var G__36005 = (0);
seq__35629_35978 = G__36002;
chunk__35631_35979 = G__36003;
count__35632_35980 = G__36004;
i__35633_35981 = G__36005;
continue;
} else {
var G__36007 = cljs.core.next(seq__35629_35994__$1);
var G__36008 = null;
var G__36009 = (0);
var G__36010 = (0);
seq__35629_35978 = G__36007;
chunk__35631_35979 = G__36008;
count__35632_35980 = G__36009;
i__35633_35981 = G__36010;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35977);
}
}


var G__36011 = seq__35587_35971;
var G__36012 = chunk__35589_35972;
var G__36013 = count__35590_35973;
var G__36014 = (i__35591_35974 + (1));
seq__35587_35971 = G__36011;
chunk__35589_35972 = G__36012;
count__35590_35973 = G__36013;
i__35591_35974 = G__36014;
continue;
} else {
var G__36016 = seq__35587_35971;
var G__36017 = chunk__35589_35972;
var G__36018 = count__35590_35973;
var G__36019 = (i__35591_35974 + (1));
seq__35587_35971 = G__36016;
chunk__35589_35972 = G__36017;
count__35590_35973 = G__36018;
i__35591_35974 = G__36019;
continue;
}
} else {
var temp__5804__auto___36020 = cljs.core.seq(seq__35587_35971);
if(temp__5804__auto___36020){
var seq__35587_36021__$1 = temp__5804__auto___36020;
if(cljs.core.chunked_seq_QMARK_(seq__35587_36021__$1)){
var c__5568__auto___36022 = cljs.core.chunk_first(seq__35587_36021__$1);
var G__36023 = cljs.core.chunk_rest(seq__35587_36021__$1);
var G__36024 = c__5568__auto___36022;
var G__36025 = cljs.core.count(c__5568__auto___36022);
var G__36026 = (0);
seq__35587_35971 = G__36023;
chunk__35589_35972 = G__36024;
count__35590_35973 = G__36025;
i__35591_35974 = G__36026;
continue;
} else {
var child_struct_36027 = cljs.core.first(seq__35587_36021__$1);
if((!((child_struct_36027 == null)))){
if(typeof child_struct_36027 === 'string'){
var text_36028 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36028),child_struct_36027].join(''));
} else {
var children_36029 = shadow.dom.svg_node(child_struct_36027);
if(cljs.core.seq_QMARK_(children_36029)){
var seq__35645_36030 = cljs.core.seq(children_36029);
var chunk__35647_36031 = null;
var count__35648_36032 = (0);
var i__35649_36033 = (0);
while(true){
if((i__35649_36033 < count__35648_36032)){
var child_36038 = chunk__35647_36031.cljs$core$IIndexed$_nth$arity$2(null,i__35649_36033);
if(cljs.core.truth_(child_36038)){
node.appendChild(child_36038);


var G__36039 = seq__35645_36030;
var G__36040 = chunk__35647_36031;
var G__36041 = count__35648_36032;
var G__36042 = (i__35649_36033 + (1));
seq__35645_36030 = G__36039;
chunk__35647_36031 = G__36040;
count__35648_36032 = G__36041;
i__35649_36033 = G__36042;
continue;
} else {
var G__36043 = seq__35645_36030;
var G__36044 = chunk__35647_36031;
var G__36045 = count__35648_36032;
var G__36046 = (i__35649_36033 + (1));
seq__35645_36030 = G__36043;
chunk__35647_36031 = G__36044;
count__35648_36032 = G__36045;
i__35649_36033 = G__36046;
continue;
}
} else {
var temp__5804__auto___36051__$1 = cljs.core.seq(seq__35645_36030);
if(temp__5804__auto___36051__$1){
var seq__35645_36052__$1 = temp__5804__auto___36051__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35645_36052__$1)){
var c__5568__auto___36053 = cljs.core.chunk_first(seq__35645_36052__$1);
var G__36054 = cljs.core.chunk_rest(seq__35645_36052__$1);
var G__36055 = c__5568__auto___36053;
var G__36056 = cljs.core.count(c__5568__auto___36053);
var G__36057 = (0);
seq__35645_36030 = G__36054;
chunk__35647_36031 = G__36055;
count__35648_36032 = G__36056;
i__35649_36033 = G__36057;
continue;
} else {
var child_36058 = cljs.core.first(seq__35645_36052__$1);
if(cljs.core.truth_(child_36058)){
node.appendChild(child_36058);


var G__36059 = cljs.core.next(seq__35645_36052__$1);
var G__36060 = null;
var G__36061 = (0);
var G__36062 = (0);
seq__35645_36030 = G__36059;
chunk__35647_36031 = G__36060;
count__35648_36032 = G__36061;
i__35649_36033 = G__36062;
continue;
} else {
var G__36063 = cljs.core.next(seq__35645_36052__$1);
var G__36064 = null;
var G__36065 = (0);
var G__36066 = (0);
seq__35645_36030 = G__36063;
chunk__35647_36031 = G__36064;
count__35648_36032 = G__36065;
i__35649_36033 = G__36066;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36029);
}
}


var G__36067 = cljs.core.next(seq__35587_36021__$1);
var G__36068 = null;
var G__36069 = (0);
var G__36070 = (0);
seq__35587_35971 = G__36067;
chunk__35589_35972 = G__36068;
count__35590_35973 = G__36069;
i__35591_35974 = G__36070;
continue;
} else {
var G__36071 = cljs.core.next(seq__35587_36021__$1);
var G__36072 = null;
var G__36073 = (0);
var G__36074 = (0);
seq__35587_35971 = G__36071;
chunk__35589_35972 = G__36072;
count__35590_35973 = G__36073;
i__35591_35974 = G__36074;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36123 = arguments.length;
var i__5770__auto___36124 = (0);
while(true){
if((i__5770__auto___36124 < len__5769__auto___36123)){
args__5775__auto__.push((arguments[i__5770__auto___36124]));

var G__36125 = (i__5770__auto___36124 + (1));
i__5770__auto___36124 = G__36125;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35667){
var G__35668 = cljs.core.first(seq35667);
var seq35667__$1 = cljs.core.next(seq35667);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35668,seq35667__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35670 = arguments.length;
switch (G__35670) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__31231__auto___36169 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_35675){
var state_val_35676 = (state_35675[(1)]);
if((state_val_35676 === (1))){
var state_35675__$1 = state_35675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35675__$1,(2),once_or_cleanup);
} else {
if((state_val_35676 === (2))){
var inst_35672 = (state_35675[(2)]);
var inst_35673 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35675__$1 = (function (){var statearr_35677 = state_35675;
(statearr_35677[(7)] = inst_35672);

return statearr_35677;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35675__$1,inst_35673);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__30666__auto__ = null;
var shadow$dom$state_machine__30666__auto____0 = (function (){
var statearr_35678 = [null,null,null,null,null,null,null,null];
(statearr_35678[(0)] = shadow$dom$state_machine__30666__auto__);

(statearr_35678[(1)] = (1));

return statearr_35678;
});
var shadow$dom$state_machine__30666__auto____1 = (function (state_35675){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_35675);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e35679){var ex__30669__auto__ = e35679;
var statearr_35680_36177 = state_35675;
(statearr_35680_36177[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_35675[(4)]))){
var statearr_35681_36178 = state_35675;
(statearr_35681_36178[(1)] = cljs.core.first((state_35675[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36179 = state_35675;
state_35675 = G__36179;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
shadow$dom$state_machine__30666__auto__ = function(state_35675){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__30666__auto____0.call(this);
case 1:
return shadow$dom$state_machine__30666__auto____1.call(this,state_35675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__30666__auto____0;
shadow$dom$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__30666__auto____1;
return shadow$dom$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_35682 = f__31232__auto__();
(statearr_35682[(6)] = c__31231__auto___36169);

return statearr_35682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
