goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__29152__29153__auto__){
if((!((p1__29152__29153__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__29152__29153__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__29152__29153__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__29152__29153__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__29152__29153__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___41686 = schema.utils.use_fn_validation;
var output_schema41106_41687 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41107_41688 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker41108_41689 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41107_41688);
}),null));
var output_checker41109_41690 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41106_41687);
}),null));
var ret__30021__auto___41691 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__41110){
var validate__28234__auto__ = cljs.core.deref(ufv___41686);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41692 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41110], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41111_41693 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41112_41694 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__41113_41695 = input_schema41107_41688;
var G__41114_41696 = cljs.core.deref(input_checker41108_41689);
var G__41115_41697 = args__28235__auto___41692;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41111_41693,G__41112_41694,G__41113_41695,G__41114_41696,G__41115_41697) : schema.core.fn_validator.call(null,G__41111_41693,G__41112_41694,G__41113_41695,G__41114_41696,G__41115_41697));
} else {
var temp__5804__auto___41698 = (function (){var fexpr__41116 = cljs.core.deref(input_checker41108_41689);
return (fexpr__41116.cljs$core$IFn$_invoke$arity$1 ? fexpr__41116.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41692) : fexpr__41116.call(null,args__28235__auto___41692));
})();
if(cljs.core.truth_(temp__5804__auto___41698)){
var error__28236__auto___41699 = temp__5804__auto___41698;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41699], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41107_41688,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41692,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41699], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var json = G__41110;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41117_41700 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41118_41701 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__41119_41702 = output_schema41106_41687;
var G__41120_41703 = cljs.core.deref(output_checker41109_41690);
var G__41121_41704 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41117_41700,G__41118_41701,G__41119_41702,G__41120_41703,G__41121_41704) : schema.core.fn_validator.call(null,G__41117_41700,G__41118_41701,G__41119_41702,G__41120_41703,G__41121_41704));
} else {
var temp__5804__auto___41705 = (function (){var fexpr__41122 = cljs.core.deref(output_checker41109_41690);
return (fexpr__41122.cljs$core$IFn$_invoke$arity$1 ? fexpr__41122.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41122.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41705)){
var error__28236__auto___41706 = temp__5804__auto___41705;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41706], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41106_41687,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41706], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema41106_41687,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41107_41688], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___41707 = schema.utils.use_fn_validation;
var output_schema41123_41708 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41124_41709 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41129_41710 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41125_41711 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41124_41709);
}),null));
var output_checker41126_41712 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41123_41708);
}),null));
var input_checker41130_41713 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41129_41710);
}),null));
var output_checker41131_41714 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41123_41708);
}),null));
var ret__30021__auto___41715 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__41136 = arguments.length;
switch (G__41136) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__41127,G__41128){
var validate__28234__auto__ = cljs.core.deref(ufv___41707);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41717 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41127,G__41128], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41137_41718 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41138_41719 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__41139_41720 = input_schema41124_41709;
var G__41140_41721 = cljs.core.deref(input_checker41125_41711);
var G__41141_41722 = args__28235__auto___41717;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41137_41718,G__41138_41719,G__41139_41720,G__41140_41721,G__41141_41722) : schema.core.fn_validator.call(null,G__41137_41718,G__41138_41719,G__41139_41720,G__41140_41721,G__41141_41722));
} else {
var temp__5804__auto___41723 = (function (){var fexpr__41142 = cljs.core.deref(input_checker41125_41711);
return (fexpr__41142.cljs$core$IFn$_invoke$arity$1 ? fexpr__41142.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41717) : fexpr__41142.call(null,args__28235__auto___41717));
})();
if(cljs.core.truth_(temp__5804__auto___41723)){
var error__28236__auto___41724 = temp__5804__auto___41723;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41724], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41124_41709,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41717,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41724], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var name_kw = G__41127;
var fields = G__41128;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41143_41725 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41144_41726 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__41145_41727 = output_schema41123_41708;
var G__41146_41728 = cljs.core.deref(output_checker41126_41712);
var G__41147_41729 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41143_41725,G__41144_41726,G__41145_41727,G__41146_41728,G__41147_41729) : schema.core.fn_validator.call(null,G__41143_41725,G__41144_41726,G__41145_41727,G__41146_41728,G__41147_41729));
} else {
var temp__5804__auto___41730 = (function (){var fexpr__41148 = cljs.core.deref(output_checker41126_41712);
return (fexpr__41148.cljs$core$IFn$_invoke$arity$1 ? fexpr__41148.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41148.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41730)){
var error__28236__auto___41731 = temp__5804__auto___41730;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41731], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41123_41708,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41731], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__41132,G__41133,G__41134){
var validate__28234__auto__ = cljs.core.deref(ufv___41707);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41732 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41132,G__41133,G__41134], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41149_41733 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41150_41734 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__41151_41735 = input_schema41129_41710;
var G__41152_41736 = cljs.core.deref(input_checker41130_41713);
var G__41153_41737 = args__28235__auto___41732;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41149_41733,G__41150_41734,G__41151_41735,G__41152_41736,G__41153_41737) : schema.core.fn_validator.call(null,G__41149_41733,G__41150_41734,G__41151_41735,G__41152_41736,G__41153_41737));
} else {
var temp__5804__auto___41738 = (function (){var fexpr__41154 = cljs.core.deref(input_checker41130_41713);
return (fexpr__41154.cljs$core$IFn$_invoke$arity$1 ? fexpr__41154.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41732) : fexpr__41154.call(null,args__28235__auto___41732));
})();
if(cljs.core.truth_(temp__5804__auto___41738)){
var error__28236__auto___41739 = temp__5804__auto___41738;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41739], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41129_41710,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41732,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41739], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var name_kw = G__41132;
var docstring = G__41133;
var fields = G__41134;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41155_41740 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41156_41741 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__41157_41742 = output_schema41123_41708;
var G__41158_41743 = cljs.core.deref(output_checker41131_41714);
var G__41159_41744 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41155_41740,G__41156_41741,G__41157_41742,G__41158_41743,G__41159_41744) : schema.core.fn_validator.call(null,G__41155_41740,G__41156_41741,G__41157_41742,G__41158_41743,G__41159_41744));
} else {
var temp__5804__auto___41745 = (function (){var fexpr__41160 = cljs.core.deref(output_checker41131_41714);
return (fexpr__41160.cljs$core$IFn$_invoke$arity$1 ? fexpr__41160.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41160.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41745)){
var error__28236__auto___41746 = temp__5804__auto___41745;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41746], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41123_41708,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41746], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema41123_41708,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41124_41709,input_schema41129_41710], null)));

var ufv___41747 = schema.utils.use_fn_validation;
var output_schema41161_41748 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41162_41749 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema41167_41750 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker41163_41751 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41162_41749);
}),null));
var output_checker41164_41752 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41161_41748);
}),null));
var input_checker41168_41753 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41167_41750);
}),null));
var output_checker41169_41754 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41161_41748);
}),null));
var ret__30021__auto___41757 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__41174 = arguments.length;
switch (G__41174) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__41165,G__41166){
var validate__28234__auto__ = cljs.core.deref(ufv___41747);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41759 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41165,G__41166], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41175_41760 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41176_41761 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__41177_41762 = input_schema41162_41749;
var G__41178_41763 = cljs.core.deref(input_checker41163_41751);
var G__41179_41764 = args__28235__auto___41759;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41175_41760,G__41176_41761,G__41177_41762,G__41178_41763,G__41179_41764) : schema.core.fn_validator.call(null,G__41175_41760,G__41176_41761,G__41177_41762,G__41178_41763,G__41179_41764));
} else {
var temp__5804__auto___41765 = (function (){var fexpr__41180 = cljs.core.deref(input_checker41163_41751);
return (fexpr__41180.cljs$core$IFn$_invoke$arity$1 ? fexpr__41180.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41759) : fexpr__41180.call(null,args__28235__auto___41759));
})();
if(cljs.core.truth_(temp__5804__auto___41765)){
var error__28236__auto___41766 = temp__5804__auto___41765;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41766], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41162_41749,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41759,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41766], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var name_kw = G__41165;
var symbol_keywords = G__41166;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41181_41770 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41182_41771 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__41183_41772 = output_schema41161_41748;
var G__41184_41773 = cljs.core.deref(output_checker41164_41752);
var G__41185_41774 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41181_41770,G__41182_41771,G__41183_41772,G__41184_41773,G__41185_41774) : schema.core.fn_validator.call(null,G__41181_41770,G__41182_41771,G__41183_41772,G__41184_41773,G__41185_41774));
} else {
var temp__5804__auto___41776 = (function (){var fexpr__41186 = cljs.core.deref(output_checker41164_41752);
return (fexpr__41186.cljs$core$IFn$_invoke$arity$1 ? fexpr__41186.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41186.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41776)){
var error__28236__auto___41777 = temp__5804__auto___41776;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41777], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41161_41748,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41777], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__41170,G__41171,G__41172){
var validate__28234__auto__ = cljs.core.deref(ufv___41747);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41778 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41170,G__41171,G__41172], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41187_41779 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41188_41780 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__41189_41781 = input_schema41167_41750;
var G__41190_41782 = cljs.core.deref(input_checker41168_41753);
var G__41191_41783 = args__28235__auto___41778;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41187_41779,G__41188_41780,G__41189_41781,G__41190_41782,G__41191_41783) : schema.core.fn_validator.call(null,G__41187_41779,G__41188_41780,G__41189_41781,G__41190_41782,G__41191_41783));
} else {
var temp__5804__auto___41785 = (function (){var fexpr__41192 = cljs.core.deref(input_checker41168_41753);
return (fexpr__41192.cljs$core$IFn$_invoke$arity$1 ? fexpr__41192.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41778) : fexpr__41192.call(null,args__28235__auto___41778));
})();
if(cljs.core.truth_(temp__5804__auto___41785)){
var error__28236__auto___41787 = temp__5804__auto___41785;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41787], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41167_41750,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41778,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41787], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var name_kw = G__41170;
var docstring = G__41171;
var symbol_keywords = G__41172;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41193_41790 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41194_41791 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__41195_41792 = output_schema41161_41748;
var G__41196_41793 = cljs.core.deref(output_checker41169_41754);
var G__41197_41794 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41193_41790,G__41194_41791,G__41195_41792,G__41196_41793,G__41197_41794) : schema.core.fn_validator.call(null,G__41193_41790,G__41194_41791,G__41195_41792,G__41196_41793,G__41197_41794));
} else {
var temp__5804__auto___41795 = (function (){var fexpr__41198 = cljs.core.deref(output_checker41169_41754);
return (fexpr__41198.cljs$core$IFn$_invoke$arity$1 ? fexpr__41198.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41198.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41795)){
var error__28236__auto___41796 = temp__5804__auto___41795;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41796], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41161_41748,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41796], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema41161_41748,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41162_41749,input_schema41167_41750], null)));

var ufv___41800 = schema.utils.use_fn_validation;
var output_schema41199_41801 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41200_41802 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41201_41803 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41200_41802);
}),null));
var output_checker41202_41804 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41199_41801);
}),null));
var ret__30021__auto___41807 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__41203,G__41204){
var validate__28234__auto__ = cljs.core.deref(ufv___41800);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41808 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41203,G__41204], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41205_41809 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41206_41810 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__41207_41811 = input_schema41200_41802;
var G__41208_41812 = cljs.core.deref(input_checker41201_41803);
var G__41209_41813 = args__28235__auto___41808;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41205_41809,G__41206_41810,G__41207_41811,G__41208_41812,G__41209_41813) : schema.core.fn_validator.call(null,G__41205_41809,G__41206_41810,G__41207_41811,G__41208_41812,G__41209_41813));
} else {
var temp__5804__auto___41815 = (function (){var fexpr__41210 = cljs.core.deref(input_checker41201_41803);
return (fexpr__41210.cljs$core$IFn$_invoke$arity$1 ? fexpr__41210.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41808) : fexpr__41210.call(null,args__28235__auto___41808));
})();
if(cljs.core.truth_(temp__5804__auto___41815)){
var error__28236__auto___41816 = temp__5804__auto___41815;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41816], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41200_41802,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41808,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41816], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var name_kw = G__41203;
var size = G__41204;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41211_41819 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41212_41820 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__41213_41821 = output_schema41199_41801;
var G__41214_41822 = cljs.core.deref(output_checker41202_41804);
var G__41215_41823 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41211_41819,G__41212_41820,G__41213_41821,G__41214_41822,G__41215_41823) : schema.core.fn_validator.call(null,G__41211_41819,G__41212_41820,G__41213_41821,G__41214_41822,G__41215_41823));
} else {
var temp__5804__auto___41824 = (function (){var fexpr__41216 = cljs.core.deref(output_checker41202_41804);
return (fexpr__41216.cljs$core$IFn$_invoke$arity$1 ? fexpr__41216.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41216.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41824)){
var error__28236__auto___41825 = temp__5804__auto___41824;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41825], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41199_41801,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41825], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema41199_41801,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41200_41802], null)));

var ufv___41828 = schema.utils.use_fn_validation;
var output_schema41217_41829 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41218_41830 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker41219_41831 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41218_41830);
}),null));
var output_checker41220_41832 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41217_41829);
}),null));
var ret__30021__auto___41834 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__41221){
var validate__28234__auto__ = cljs.core.deref(ufv___41828);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41835 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41221], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41222_41836 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41223_41837 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__41224_41838 = input_schema41218_41830;
var G__41225_41839 = cljs.core.deref(input_checker41219_41831);
var G__41226_41840 = args__28235__auto___41835;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41222_41836,G__41223_41837,G__41224_41838,G__41225_41839,G__41226_41840) : schema.core.fn_validator.call(null,G__41222_41836,G__41223_41837,G__41224_41838,G__41225_41839,G__41226_41840));
} else {
var temp__5804__auto___41842 = (function (){var fexpr__41227 = cljs.core.deref(input_checker41219_41831);
return (fexpr__41227.cljs$core$IFn$_invoke$arity$1 ? fexpr__41227.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41835) : fexpr__41227.call(null,args__28235__auto___41835));
})();
if(cljs.core.truth_(temp__5804__auto___41842)){
var error__28236__auto___41843 = temp__5804__auto___41842;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41843], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41218_41830,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41835,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41843], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var items_schema = G__41221;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41228_41846 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41229_41847 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__41230_41848 = output_schema41217_41829;
var G__41231_41849 = cljs.core.deref(output_checker41220_41832);
var G__41232_41850 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41228_41846,G__41229_41847,G__41230_41848,G__41231_41849,G__41232_41850) : schema.core.fn_validator.call(null,G__41228_41846,G__41229_41847,G__41230_41848,G__41231_41849,G__41232_41850));
} else {
var temp__5804__auto___41852 = (function (){var fexpr__41233 = cljs.core.deref(output_checker41220_41832);
return (fexpr__41233.cljs$core$IFn$_invoke$arity$1 ? fexpr__41233.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41233.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41852)){
var error__28236__auto___41853 = temp__5804__auto___41852;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41853], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41217_41829,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41853], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema41217_41829,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41218_41830], null)));

var ufv___41855 = schema.utils.use_fn_validation;
var output_schema41234_41856 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41235_41857 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker41236_41858 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41235_41857);
}),null));
var output_checker41237_41859 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41234_41856);
}),null));
var ret__30021__auto___41864 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__41238){
var validate__28234__auto__ = cljs.core.deref(ufv___41855);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41865 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41238], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41239_41866 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41240_41867 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__41241_41868 = input_schema41235_41857;
var G__41242_41869 = cljs.core.deref(input_checker41236_41858);
var G__41243_41870 = args__28235__auto___41865;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41239_41866,G__41240_41867,G__41241_41868,G__41242_41869,G__41243_41870) : schema.core.fn_validator.call(null,G__41239_41866,G__41240_41867,G__41241_41868,G__41242_41869,G__41243_41870));
} else {
var temp__5804__auto___41872 = (function (){var fexpr__41244 = cljs.core.deref(input_checker41236_41858);
return (fexpr__41244.cljs$core$IFn$_invoke$arity$1 ? fexpr__41244.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41865) : fexpr__41244.call(null,args__28235__auto___41865));
})();
if(cljs.core.truth_(temp__5804__auto___41872)){
var error__28236__auto___41873 = temp__5804__auto___41872;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41873], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41235_41857,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41865,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41873], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var values_schema = G__41238;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41245_41878 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41246_41879 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__41247_41880 = output_schema41234_41856;
var G__41248_41881 = cljs.core.deref(output_checker41237_41859);
var G__41249_41882 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41245_41878,G__41246_41879,G__41247_41880,G__41248_41881,G__41249_41882) : schema.core.fn_validator.call(null,G__41245_41878,G__41246_41879,G__41247_41880,G__41248_41881,G__41249_41882));
} else {
var temp__5804__auto___41884 = (function (){var fexpr__41250 = cljs.core.deref(output_checker41237_41859);
return (fexpr__41250.cljs$core$IFn$_invoke$arity$1 ? fexpr__41250.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41250.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41884)){
var error__28236__auto___41885 = temp__5804__auto___41884;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41885], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41234_41856,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41885], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema41234_41856,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41235_41857], null)));

var ufv___41888 = schema.utils.use_fn_validation;
var output_schema41251_41889 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41252_41890 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker41253_41891 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41252_41890);
}),null));
var output_checker41254_41892 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41251_41889);
}),null));
var ret__30021__auto___41893 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__41255){
var validate__28234__auto__ = cljs.core.deref(ufv___41888);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41895 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41255], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41256_41896 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41257_41897 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__41258_41898 = input_schema41252_41890;
var G__41259_41899 = cljs.core.deref(input_checker41253_41891);
var G__41260_41900 = args__28235__auto___41895;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41256_41896,G__41257_41897,G__41258_41898,G__41259_41899,G__41260_41900) : schema.core.fn_validator.call(null,G__41256_41896,G__41257_41897,G__41258_41898,G__41259_41899,G__41260_41900));
} else {
var temp__5804__auto___41902 = (function (){var fexpr__41261 = cljs.core.deref(input_checker41253_41891);
return (fexpr__41261.cljs$core$IFn$_invoke$arity$1 ? fexpr__41261.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41895) : fexpr__41261.call(null,args__28235__auto___41895));
})();
if(cljs.core.truth_(temp__5804__auto___41902)){
var error__28236__auto___41903 = temp__5804__auto___41902;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41903], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41252_41890,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41895,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41903], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var member_schemas = G__41255;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41262_41905 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41263_41906 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__41264_41907 = output_schema41251_41889;
var G__41265_41908 = cljs.core.deref(output_checker41254_41892);
var G__41266_41909 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41262_41905,G__41263_41906,G__41264_41907,G__41265_41908,G__41266_41909) : schema.core.fn_validator.call(null,G__41262_41905,G__41263_41906,G__41264_41907,G__41265_41908,G__41266_41909));
} else {
var temp__5804__auto___41912 = (function (){var fexpr__41267 = cljs.core.deref(output_checker41254_41892);
return (fexpr__41267.cljs$core$IFn$_invoke$arity$1 ? fexpr__41267.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41267.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41912)){
var error__28236__auto___41914 = temp__5804__auto___41912;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41914], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41251_41889,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41914], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema41251_41889,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41252_41890], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___41915 = schema.utils.use_fn_validation;
var output_schema41268_41916 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41269_41917 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker41270_41918 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41269_41917);
}),null));
var output_checker41271_41919 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41268_41916);
}),null));
var ret__30021__auto___41921 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__41272){
var validate__28234__auto__ = cljs.core.deref(ufv___41915);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41922 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41272], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41273_41923 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41274_41924 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__41275_41925 = input_schema41269_41917;
var G__41276_41926 = cljs.core.deref(input_checker41270_41918);
var G__41277_41927 = args__28235__auto___41922;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41273_41923,G__41274_41924,G__41275_41925,G__41276_41926,G__41277_41927) : schema.core.fn_validator.call(null,G__41273_41923,G__41274_41924,G__41275_41925,G__41276_41926,G__41277_41927));
} else {
var temp__5804__auto___41928 = (function (){var fexpr__41278 = cljs.core.deref(input_checker41270_41918);
return (fexpr__41278.cljs$core$IFn$_invoke$arity$1 ? fexpr__41278.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41922) : fexpr__41278.call(null,args__28235__auto___41922));
})();
if(cljs.core.truth_(temp__5804__auto___41928)){
var error__28236__auto___41930 = temp__5804__auto___41928;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41930], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41269_41917,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41922,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41930], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41272;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41279_41931 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41280_41932 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__41281_41933 = output_schema41268_41916;
var G__41282_41934 = cljs.core.deref(output_checker41271_41919);
var G__41283_41935 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41279_41931,G__41280_41932,G__41281_41933,G__41282_41934,G__41283_41935) : schema.core.fn_validator.call(null,G__41279_41931,G__41280_41932,G__41281_41933,G__41282_41934,G__41283_41935));
} else {
var temp__5804__auto___41937 = (function (){var fexpr__41284 = cljs.core.deref(output_checker41271_41919);
return (fexpr__41284.cljs$core$IFn$_invoke$arity$1 ? fexpr__41284.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41284.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41937)){
var error__28236__auto___41938 = temp__5804__auto___41937;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41938], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41268_41916,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41938], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema41268_41916,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41269_41917], null)));

var ufv___41944 = schema.utils.use_fn_validation;
var output_schema41285_41945 = deercreeklabs.baracus.ByteArray;
var input_schema41286_41946 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41287_41947 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41286_41946);
}),null));
var output_checker41288_41948 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41285_41945);
}),null));
var ret__30021__auto___41950 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__41289,G__41290){
var validate__28234__auto__ = cljs.core.deref(ufv___41944);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41951 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41289,G__41290], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41291_41952 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41292_41953 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__41293_41954 = input_schema41286_41946;
var G__41294_41955 = cljs.core.deref(input_checker41287_41947);
var G__41295_41956 = args__28235__auto___41951;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41291_41952,G__41292_41953,G__41293_41954,G__41294_41955,G__41295_41956) : schema.core.fn_validator.call(null,G__41291_41952,G__41292_41953,G__41293_41954,G__41294_41955,G__41295_41956));
} else {
var temp__5804__auto___41957 = (function (){var fexpr__41296 = cljs.core.deref(input_checker41287_41947);
return (fexpr__41296.cljs$core$IFn$_invoke$arity$1 ? fexpr__41296.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41951) : fexpr__41296.call(null,args__28235__auto___41951));
})();
if(cljs.core.truth_(temp__5804__auto___41957)){
var error__28236__auto___41958 = temp__5804__auto___41957;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41958], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41286_41946,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41951,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41958], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var writer_schema = G__41289;
var data = G__41290;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41298_41961 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41299_41962 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__41300_41963 = output_schema41285_41945;
var G__41301_41964 = cljs.core.deref(output_checker41288_41948);
var G__41302_41965 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41298_41961,G__41299_41962,G__41300_41963,G__41301_41964,G__41302_41965) : schema.core.fn_validator.call(null,G__41298_41961,G__41299_41962,G__41300_41963,G__41301_41964,G__41302_41965));
} else {
var temp__5804__auto___41966 = (function (){var fexpr__41303 = cljs.core.deref(output_checker41288_41948);
return (fexpr__41303.cljs$core$IFn$_invoke$arity$1 ? fexpr__41303.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41303.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41966)){
var error__28236__auto___41967 = temp__5804__auto___41966;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41967], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41285_41945,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41967], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema41285_41945,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41286_41946], null)));

var ufv___41968 = schema.utils.use_fn_validation;
var output_schema41304_41969 = schema.core.Any;
var input_schema41305_41970 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker41306_41971 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41305_41970);
}),null));
var output_checker41307_41972 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41304_41969);
}),null));
var ret__30021__auto___41975 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__41308,G__41309,G__41310){
var validate__28234__auto__ = cljs.core.deref(ufv___41968);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___41977 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41308,G__41309,G__41310], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41311_41978 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41312_41979 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__41313_41980 = input_schema41305_41970;
var G__41314_41981 = cljs.core.deref(input_checker41306_41971);
var G__41315_41982 = args__28235__auto___41977;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41311_41978,G__41312_41979,G__41313_41980,G__41314_41981,G__41315_41982) : schema.core.fn_validator.call(null,G__41311_41978,G__41312_41979,G__41313_41980,G__41314_41981,G__41315_41982));
} else {
var temp__5804__auto___41983 = (function (){var fexpr__41316 = cljs.core.deref(input_checker41306_41971);
return (fexpr__41316.cljs$core$IFn$_invoke$arity$1 ? fexpr__41316.cljs$core$IFn$_invoke$arity$1(args__28235__auto___41977) : fexpr__41316.call(null,args__28235__auto___41977));
})();
if(cljs.core.truth_(temp__5804__auto___41983)){
var error__28236__auto___41985 = temp__5804__auto___41983;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41985], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41305_41970,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___41977,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41985], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var reader_schema = G__41308;
var writer_schema = G__41309;
var ba = G__41310;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41319_41991 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41320_41992 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__41321_41993 = output_schema41304_41969;
var G__41322_41994 = cljs.core.deref(output_checker41307_41972);
var G__41323_41995 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41319_41991,G__41320_41992,G__41321_41993,G__41322_41994,G__41323_41995) : schema.core.fn_validator.call(null,G__41319_41991,G__41320_41992,G__41321_41993,G__41322_41994,G__41323_41995));
} else {
var temp__5804__auto___41997 = (function (){var fexpr__41324 = cljs.core.deref(output_checker41307_41972);
return (fexpr__41324.cljs$core$IFn$_invoke$arity$1 ? fexpr__41324.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41324.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41997)){
var error__28236__auto___41999 = temp__5804__auto___41997;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___41999], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41304_41969,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___41999], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema41304_41969,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41305_41970], null)));

var ufv___42004 = schema.utils.use_fn_validation;
var output_schema41325_42005 = schema.core.Any;
var input_schema41326_42006 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker41327_42007 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41326_42006);
}),null));
var output_checker41328_42008 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41325_42005);
}),null));
var ret__30021__auto___42009 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__41329,G__41330){
var validate__28234__auto__ = cljs.core.deref(ufv___42004);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42010 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41329,G__41330], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41331_42012 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41332_42013 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__41333_42014 = input_schema41326_42006;
var G__41334_42015 = cljs.core.deref(input_checker41327_42007);
var G__41335_42016 = args__28235__auto___42010;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41331_42012,G__41332_42013,G__41333_42014,G__41334_42015,G__41335_42016) : schema.core.fn_validator.call(null,G__41331_42012,G__41332_42013,G__41333_42014,G__41334_42015,G__41335_42016));
} else {
var temp__5804__auto___42018 = (function (){var fexpr__41336 = cljs.core.deref(input_checker41327_42007);
return (fexpr__41336.cljs$core$IFn$_invoke$arity$1 ? fexpr__41336.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42010) : fexpr__41336.call(null,args__28235__auto___42010));
})();
if(cljs.core.truth_(temp__5804__auto___42018)){
var error__28236__auto___42019 = temp__5804__auto___42018;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42019], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41326_42006,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42010,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42019], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41329;
var ba = G__41330;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41337_42023 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41338_42024 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__41339_42025 = output_schema41325_42005;
var G__41340_42026 = cljs.core.deref(output_checker41328_42008);
var G__41341_42027 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41337_42023,G__41338_42024,G__41339_42025,G__41340_42026,G__41341_42027) : schema.core.fn_validator.call(null,G__41337_42023,G__41338_42024,G__41339_42025,G__41340_42026,G__41341_42027));
} else {
var temp__5804__auto___42029 = (function (){var fexpr__41342 = cljs.core.deref(output_checker41328_42008);
return (fexpr__41342.cljs$core$IFn$_invoke$arity$1 ? fexpr__41342.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41342.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42029)){
var error__28236__auto___42030 = temp__5804__auto___42029;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42030], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41325_42005,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42030], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema41325_42005,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41326_42006], null)));

var ufv___42032 = schema.utils.use_fn_validation;
var output_schema41343_42033 = schema.core.Any;
var input_schema41344_42034 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41345_42035 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41344_42034);
}),null));
var output_checker41346_42036 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41343_42033);
}),null));
var ret__30021__auto___42040 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__41347){
var validate__28234__auto__ = cljs.core.deref(ufv___42032);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42041 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41347], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41348_42042 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41349_42043 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__41350_42044 = input_schema41344_42034;
var G__41351_42045 = cljs.core.deref(input_checker41345_42035);
var G__41352_42046 = args__28235__auto___42041;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41348_42042,G__41349_42043,G__41350_42044,G__41351_42045,G__41352_42046) : schema.core.fn_validator.call(null,G__41348_42042,G__41349_42043,G__41350_42044,G__41351_42045,G__41352_42046));
} else {
var temp__5804__auto___42047 = (function (){var fexpr__41353 = cljs.core.deref(input_checker41345_42035);
return (fexpr__41353.cljs$core$IFn$_invoke$arity$1 ? fexpr__41353.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42041) : fexpr__41353.call(null,args__28235__auto___42041));
})();
if(cljs.core.truth_(temp__5804__auto___42047)){
var error__28236__auto___42048 = temp__5804__auto___42047;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42048], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41344_42034,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42041,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42048], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41347;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41354_42049 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41355_42050 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__41356_42051 = output_schema41343_42033;
var G__41357_42052 = cljs.core.deref(output_checker41346_42036);
var G__41358_42053 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41354_42049,G__41355_42050,G__41356_42051,G__41357_42052,G__41358_42053) : schema.core.fn_validator.call(null,G__41354_42049,G__41355_42050,G__41356_42051,G__41357_42052,G__41358_42053));
} else {
var temp__5804__auto___42054 = (function (){var fexpr__41359 = cljs.core.deref(output_checker41346_42036);
return (fexpr__41359.cljs$core$IFn$_invoke$arity$1 ? fexpr__41359.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41359.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42054)){
var error__28236__auto___42055 = temp__5804__auto___42054;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42055], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41343_42033,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42055], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema41343_42033,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41344_42034], null)));

var ufv___42056 = schema.utils.use_fn_validation;
var output_schema41360_42057 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41361_42058 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41362_42059 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41361_42058);
}),null));
var output_checker41363_42060 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41360_42057);
}),null));
var ret__30021__auto___42061 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__41364){
var validate__28234__auto__ = cljs.core.deref(ufv___42056);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42062 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41364], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41365_42063 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41366_42064 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__41367_42065 = input_schema41361_42058;
var G__41368_42066 = cljs.core.deref(input_checker41362_42059);
var G__41369_42067 = args__28235__auto___42062;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41365_42063,G__41366_42064,G__41367_42065,G__41368_42066,G__41369_42067) : schema.core.fn_validator.call(null,G__41365_42063,G__41366_42064,G__41367_42065,G__41368_42066,G__41369_42067));
} else {
var temp__5804__auto___42068 = (function (){var fexpr__41370 = cljs.core.deref(input_checker41362_42059);
return (fexpr__41370.cljs$core$IFn$_invoke$arity$1 ? fexpr__41370.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42062) : fexpr__41370.call(null,args__28235__auto___42062));
})();
if(cljs.core.truth_(temp__5804__auto___42068)){
var error__28236__auto___42069 = temp__5804__auto___42068;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42069], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41361_42058,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42062,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42069], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var edn = G__41364;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41371_42071 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41372_42072 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__41373_42073 = output_schema41360_42057;
var G__41374_42074 = cljs.core.deref(output_checker41363_42060);
var G__41375_42075 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41371_42071,G__41372_42072,G__41373_42073,G__41374_42074,G__41375_42075) : schema.core.fn_validator.call(null,G__41371_42071,G__41372_42072,G__41373_42073,G__41374_42074,G__41375_42075));
} else {
var temp__5804__auto___42076 = (function (){var fexpr__41376 = cljs.core.deref(output_checker41363_42060);
return (fexpr__41376.cljs$core$IFn$_invoke$arity$1 ? fexpr__41376.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41376.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42076)){
var error__28236__auto___42077 = temp__5804__auto___42076;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42077], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41360_42057,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42077], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema41360_42057,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41361_42058], null)));

var ufv___42079 = schema.utils.use_fn_validation;
var output_schema41377_42080 = schema.core.Str;
var input_schema41378_42081 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41379_42082 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41378_42081);
}),null));
var output_checker41380_42083 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41377_42080);
}),null));
var ret__30021__auto___42084 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__41381){
var validate__28234__auto__ = cljs.core.deref(ufv___42079);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42086 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41381], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41382_42088 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41383_42089 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__41384_42090 = input_schema41378_42081;
var G__41385_42091 = cljs.core.deref(input_checker41379_42082);
var G__41386_42092 = args__28235__auto___42086;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41382_42088,G__41383_42089,G__41384_42090,G__41385_42091,G__41386_42092) : schema.core.fn_validator.call(null,G__41382_42088,G__41383_42089,G__41384_42090,G__41385_42091,G__41386_42092));
} else {
var temp__5804__auto___42093 = (function (){var fexpr__41387 = cljs.core.deref(input_checker41379_42082);
return (fexpr__41387.cljs$core$IFn$_invoke$arity$1 ? fexpr__41387.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42086) : fexpr__41387.call(null,args__28235__auto___42086));
})();
if(cljs.core.truth_(temp__5804__auto___42093)){
var error__28236__auto___42094 = temp__5804__auto___42093;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42094], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41378_42081,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42086,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42094], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41381;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41388_42095 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41389_42096 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__41390_42097 = output_schema41377_42080;
var G__41391_42098 = cljs.core.deref(output_checker41380_42083);
var G__41392_42099 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41388_42095,G__41389_42096,G__41390_42097,G__41391_42098,G__41392_42099) : schema.core.fn_validator.call(null,G__41388_42095,G__41389_42096,G__41390_42097,G__41391_42098,G__41392_42099));
} else {
var temp__5804__auto___42102 = (function (){var fexpr__41393 = cljs.core.deref(output_checker41380_42083);
return (fexpr__41393.cljs$core$IFn$_invoke$arity$1 ? fexpr__41393.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41393.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42102)){
var error__28236__auto___42103 = temp__5804__auto___42102;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42103], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41377_42080,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42103], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema41377_42080,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41378_42081], null)));

var ufv___42108 = schema.utils.use_fn_validation;
var output_schema41394_42109 = schema.core.Keyword;
var input_schema41395_42110 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41396_42111 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41395_42110);
}),null));
var output_checker41397_42112 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41394_42109);
}),null));
var ret__30021__auto___42115 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__41398){
var validate__28234__auto__ = cljs.core.deref(ufv___42108);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42117 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41398], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41399_42118 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41400_42119 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__41401_42120 = input_schema41395_42110;
var G__41402_42121 = cljs.core.deref(input_checker41396_42111);
var G__41403_42122 = args__28235__auto___42117;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41399_42118,G__41400_42119,G__41401_42120,G__41402_42121,G__41403_42122) : schema.core.fn_validator.call(null,G__41399_42118,G__41400_42119,G__41401_42120,G__41402_42121,G__41403_42122));
} else {
var temp__5804__auto___42123 = (function (){var fexpr__41404 = cljs.core.deref(input_checker41396_42111);
return (fexpr__41404.cljs$core$IFn$_invoke$arity$1 ? fexpr__41404.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42117) : fexpr__41404.call(null,args__28235__auto___42117));
})();
if(cljs.core.truth_(temp__5804__auto___42123)){
var error__28236__auto___42125 = temp__5804__auto___42123;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42125], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41395_42110,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42117,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42125], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41398;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41405_42127 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41406_42128 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__41407_42129 = output_schema41394_42109;
var G__41408_42130 = cljs.core.deref(output_checker41397_42112);
var G__41409_42131 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41405_42127,G__41406_42128,G__41407_42129,G__41408_42130,G__41409_42131) : schema.core.fn_validator.call(null,G__41405_42127,G__41406_42128,G__41407_42129,G__41408_42130,G__41409_42131));
} else {
var temp__5804__auto___42133 = (function (){var fexpr__41410 = cljs.core.deref(output_checker41397_42112);
return (fexpr__41410.cljs$core$IFn$_invoke$arity$1 ? fexpr__41410.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41410.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42133)){
var error__28236__auto___42135 = temp__5804__auto___42133;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42135], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41394_42109,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42135], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema41394_42109,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41395_42110], null)));

var ufv___42139 = schema.utils.use_fn_validation;
var output_schema41411_42140 = schema.core.Str;
var input_schema41412_42141 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41413_42142 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41412_42141);
}),null));
var output_checker41414_42143 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41411_42140);
}),null));
var ret__30021__auto___42146 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__41415){
var validate__28234__auto__ = cljs.core.deref(ufv___42139);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42147 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41415], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41416_42148 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41417_42149 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__41418_42150 = input_schema41412_42141;
var G__41419_42151 = cljs.core.deref(input_checker41413_42142);
var G__41420_42152 = args__28235__auto___42147;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41416_42148,G__41417_42149,G__41418_42150,G__41419_42151,G__41420_42152) : schema.core.fn_validator.call(null,G__41416_42148,G__41417_42149,G__41418_42150,G__41419_42151,G__41420_42152));
} else {
var temp__5804__auto___42153 = (function (){var fexpr__41421 = cljs.core.deref(input_checker41413_42142);
return (fexpr__41421.cljs$core$IFn$_invoke$arity$1 ? fexpr__41421.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42147) : fexpr__41421.call(null,args__28235__auto___42147));
})();
if(cljs.core.truth_(temp__5804__auto___42153)){
var error__28236__auto___42154 = temp__5804__auto___42153;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42154], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41412_42141,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42147,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42154], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41415;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41422_42155 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41423_42156 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__41424_42157 = output_schema41411_42140;
var G__41425_42158 = cljs.core.deref(output_checker41414_42143);
var G__41426_42159 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41422_42155,G__41423_42156,G__41424_42157,G__41425_42158,G__41426_42159) : schema.core.fn_validator.call(null,G__41422_42155,G__41423_42156,G__41424_42157,G__41425_42158,G__41426_42159));
} else {
var temp__5804__auto___42161 = (function (){var fexpr__41427 = cljs.core.deref(output_checker41414_42143);
return (fexpr__41427.cljs$core$IFn$_invoke$arity$1 ? fexpr__41427.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41427.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42161)){
var error__28236__auto___42162 = temp__5804__auto___42161;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42162], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41411_42140,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42162], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema41411_42140,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41412_42141], null)));

var ufv___42164 = schema.utils.use_fn_validation;
var output_schema41428_42165 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema41429_42166 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41430_42167 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41429_42166);
}),null));
var output_checker41431_42168 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41428_42165);
}),null));
var ret__30021__auto___42171 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__41432){
var validate__28234__auto__ = cljs.core.deref(ufv___42164);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42172 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41432], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41433_42173 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41434_42174 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__41435_42175 = input_schema41429_42166;
var G__41436_42176 = cljs.core.deref(input_checker41430_42167);
var G__41437_42177 = args__28235__auto___42172;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41433_42173,G__41434_42174,G__41435_42175,G__41436_42176,G__41437_42177) : schema.core.fn_validator.call(null,G__41433_42173,G__41434_42174,G__41435_42175,G__41436_42176,G__41437_42177));
} else {
var temp__5804__auto___42178 = (function (){var fexpr__41438 = cljs.core.deref(input_checker41430_42167);
return (fexpr__41438.cljs$core$IFn$_invoke$arity$1 ? fexpr__41438.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42172) : fexpr__41438.call(null,args__28235__auto___42172));
})();
if(cljs.core.truth_(temp__5804__auto___42178)){
var error__28236__auto___42179 = temp__5804__auto___42178;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42179], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41429_42166,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42172,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42179], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41432;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41439_42181 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41440_42182 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__41441_42183 = output_schema41428_42165;
var G__41442_42184 = cljs.core.deref(output_checker41431_42168);
var G__41443_42185 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41439_42181,G__41440_42182,G__41441_42183,G__41442_42184,G__41443_42185) : schema.core.fn_validator.call(null,G__41439_42181,G__41440_42182,G__41441_42183,G__41442_42184,G__41443_42185));
} else {
var temp__5804__auto___42186 = (function (){var fexpr__41444 = cljs.core.deref(output_checker41431_42168);
return (fexpr__41444.cljs$core$IFn$_invoke$arity$1 ? fexpr__41444.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41444.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42186)){
var error__28236__auto___42187 = temp__5804__auto___42186;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42187], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41428_42165,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42187], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema41428_42165,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41429_42166], null)));

var ufv___42188 = schema.utils.use_fn_validation;
var output_schema41445_42189 = deercreeklabs.baracus.ByteArray;
var input_schema41446_42190 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41447_42191 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41446_42190);
}),null));
var output_checker41448_42192 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41445_42189);
}),null));
var ret__30021__auto___42193 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__41449){
var validate__28234__auto__ = cljs.core.deref(ufv___42188);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42194 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41449], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41450_42195 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41451_42196 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__41452_42197 = input_schema41446_42190;
var G__41453_42198 = cljs.core.deref(input_checker41447_42191);
var G__41454_42199 = args__28235__auto___42194;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41450_42195,G__41451_42196,G__41452_42197,G__41453_42198,G__41454_42199) : schema.core.fn_validator.call(null,G__41450_42195,G__41451_42196,G__41452_42197,G__41453_42198,G__41454_42199));
} else {
var temp__5804__auto___42200 = (function (){var fexpr__41455 = cljs.core.deref(input_checker41447_42191);
return (fexpr__41455.cljs$core$IFn$_invoke$arity$1 ? fexpr__41455.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42194) : fexpr__41455.call(null,args__28235__auto___42194));
})();
if(cljs.core.truth_(temp__5804__auto___42200)){
var error__28236__auto___42201 = temp__5804__auto___42200;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42201], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41446_42190,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42194,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42201], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41449;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41456_42202 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41457_42203 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__41458_42204 = output_schema41445_42189;
var G__41459_42205 = cljs.core.deref(output_checker41448_42192);
var G__41460_42206 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41456_42202,G__41457_42203,G__41458_42204,G__41459_42205,G__41460_42206) : schema.core.fn_validator.call(null,G__41456_42202,G__41457_42203,G__41458_42204,G__41459_42205,G__41460_42206));
} else {
var temp__5804__auto___42207 = (function (){var fexpr__41461 = cljs.core.deref(output_checker41448_42192);
return (fexpr__41461.cljs$core$IFn$_invoke$arity$1 ? fexpr__41461.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41461.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42207)){
var error__28236__auto___42208 = temp__5804__auto___42207;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42208], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41445_42189,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42208], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema41445_42189,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41446_42190], null)));

var ufv___42209 = schema.utils.use_fn_validation;
var output_schema41462_42210 = deercreeklabs.baracus.ByteArray;
var input_schema41463_42211 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41464_42212 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41463_42211);
}),null));
var output_checker41465_42213 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41462_42210);
}),null));
var ret__30021__auto___42214 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__41466){
var validate__28234__auto__ = cljs.core.deref(ufv___42209);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42215 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41466], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41467_42216 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41468_42217 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__41469_42218 = input_schema41463_42211;
var G__41470_42219 = cljs.core.deref(input_checker41464_42212);
var G__41471_42220 = args__28235__auto___42215;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41467_42216,G__41468_42217,G__41469_42218,G__41470_42219,G__41471_42220) : schema.core.fn_validator.call(null,G__41467_42216,G__41468_42217,G__41469_42218,G__41470_42219,G__41471_42220));
} else {
var temp__5804__auto___42221 = (function (){var fexpr__41472 = cljs.core.deref(input_checker41464_42212);
return (fexpr__41472.cljs$core$IFn$_invoke$arity$1 ? fexpr__41472.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42215) : fexpr__41472.call(null,args__28235__auto___42215));
})();
if(cljs.core.truth_(temp__5804__auto___42221)){
var error__28236__auto___42222 = temp__5804__auto___42221;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42222], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41463_42211,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42215,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42222], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41466;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41473_42223 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41474_42224 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__41475_42225 = output_schema41462_42210;
var G__41476_42226 = cljs.core.deref(output_checker41465_42213);
var G__41477_42227 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41473_42223,G__41474_42224,G__41475_42225,G__41476_42226,G__41477_42227) : schema.core.fn_validator.call(null,G__41473_42223,G__41474_42224,G__41475_42225,G__41476_42226,G__41477_42227));
} else {
var temp__5804__auto___42232 = (function (){var fexpr__41478 = cljs.core.deref(output_checker41465_42213);
return (fexpr__41478.cljs$core$IFn$_invoke$arity$1 ? fexpr__41478.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41478.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42232)){
var error__28236__auto___42233 = temp__5804__auto___42232;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42233], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41462_42210,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42233], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema41462_42210,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41463_42211], null)));

var ufv___42234 = schema.utils.use_fn_validation;
var output_schema41479_42235 = schema.core.Bool;
var input_schema41480_42236 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41481_42237 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41480_42236);
}),null));
var output_checker41482_42238 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41479_42235);
}),null));
var ret__30021__auto___42239 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__41483){
var validate__28234__auto__ = cljs.core.deref(ufv___42234);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42240 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41483], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41484_42241 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41485_42242 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__41486_42243 = input_schema41480_42236;
var G__41487_42244 = cljs.core.deref(input_checker41481_42237);
var G__41488_42245 = args__28235__auto___42240;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41484_42241,G__41485_42242,G__41486_42243,G__41487_42244,G__41488_42245) : schema.core.fn_validator.call(null,G__41484_42241,G__41485_42242,G__41486_42243,G__41487_42244,G__41488_42245));
} else {
var temp__5804__auto___42246 = (function (){var fexpr__41489 = cljs.core.deref(input_checker41481_42237);
return (fexpr__41489.cljs$core$IFn$_invoke$arity$1 ? fexpr__41489.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42240) : fexpr__41489.call(null,args__28235__auto___42240));
})();
if(cljs.core.truth_(temp__5804__auto___42246)){
var error__28236__auto___42247 = temp__5804__auto___42246;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42247], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41480_42236,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42240,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42247], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var arg = G__41483;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41491_42249 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41492_42250 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__41493_42251 = output_schema41479_42235;
var G__41494_42252 = cljs.core.deref(output_checker41482_42238);
var G__41495_42253 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41491_42249,G__41492_42250,G__41493_42251,G__41494_42252,G__41495_42253) : schema.core.fn_validator.call(null,G__41491_42249,G__41492_42250,G__41493_42251,G__41494_42252,G__41495_42253));
} else {
var temp__5804__auto___42254 = (function (){var fexpr__41496 = cljs.core.deref(output_checker41482_42238);
return (fexpr__41496.cljs$core$IFn$_invoke$arity$1 ? fexpr__41496.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41496.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42254)){
var error__28236__auto___42255 = temp__5804__auto___42254;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42255], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41479_42235,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42255], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema41479_42235,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41480_42236], null)));

var ufv___42257 = schema.utils.use_fn_validation;
var output_schema41497_42258 = schema.core.Bool;
var input_schema41498_42259 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41499_42260 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41498_42259);
}),null));
var output_checker41500_42261 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41497_42258);
}),null));
var ret__30021__auto___42262 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__41501,G__41502){
var validate__28234__auto__ = cljs.core.deref(ufv___42257);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42264 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41501,G__41502], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41503_42265 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41504_42266 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__41505_42267 = input_schema41498_42259;
var G__41506_42268 = cljs.core.deref(input_checker41499_42260);
var G__41507_42269 = args__28235__auto___42264;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41503_42265,G__41504_42266,G__41505_42267,G__41506_42268,G__41507_42269) : schema.core.fn_validator.call(null,G__41503_42265,G__41504_42266,G__41505_42267,G__41506_42268,G__41507_42269));
} else {
var temp__5804__auto___42270 = (function (){var fexpr__41508 = cljs.core.deref(input_checker41499_42260);
return (fexpr__41508.cljs$core$IFn$_invoke$arity$1 ? fexpr__41508.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42264) : fexpr__41508.call(null,args__28235__auto___42264));
})();
if(cljs.core.truth_(temp__5804__auto___42270)){
var error__28236__auto___42271 = temp__5804__auto___42270;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42271], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41498_42259,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42264,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42271], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var reader_schema = G__41501;
var writer_schema = G__41502;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41511_42273 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41512_42274 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__41513_42275 = output_schema41497_42258;
var G__41514_42276 = cljs.core.deref(output_checker41500_42261);
var G__41515_42277 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41511_42273,G__41512_42274,G__41513_42275,G__41514_42276,G__41515_42277) : schema.core.fn_validator.call(null,G__41511_42273,G__41512_42274,G__41513_42275,G__41514_42276,G__41515_42277));
} else {
var temp__5804__auto___42278 = (function (){var fexpr__41516 = cljs.core.deref(output_checker41500_42261);
return (fexpr__41516.cljs$core$IFn$_invoke$arity$1 ? fexpr__41516.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41516.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42278)){
var error__28236__auto___42279 = temp__5804__auto___42278;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42279], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41497_42258,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42279], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema41497_42258,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41498_42259], null)));

var ufv___42280 = schema.utils.use_fn_validation;
var output_schema41517_42281 = schema.core.Any;
var input_schema41518_42282 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41519_42283 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41518_42282);
}),null));
var output_checker41520_42284 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41517_42281);
}),null));
var ret__30021__auto___42287 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__41521){
var validate__28234__auto__ = cljs.core.deref(ufv___42280);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42288 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41521], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41522_42289 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41523_42290 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__41524_42291 = input_schema41518_42282;
var G__41525_42292 = cljs.core.deref(input_checker41519_42283);
var G__41526_42293 = args__28235__auto___42288;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41522_42289,G__41523_42290,G__41524_42291,G__41525_42292,G__41526_42293) : schema.core.fn_validator.call(null,G__41522_42289,G__41523_42290,G__41524_42291,G__41525_42292,G__41526_42293));
} else {
var temp__5804__auto___42295 = (function (){var fexpr__41527 = cljs.core.deref(input_checker41519_42283);
return (fexpr__41527.cljs$core$IFn$_invoke$arity$1 ? fexpr__41527.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42288) : fexpr__41527.call(null,args__28235__auto___42288));
})();
if(cljs.core.truth_(temp__5804__auto___42295)){
var error__28236__auto___42297 = temp__5804__auto___42295;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42297], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41518_42282,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42288,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42297], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41521;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41528_42300 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41529_42301 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__41530_42302 = output_schema41517_42281;
var G__41531_42303 = cljs.core.deref(output_checker41520_42284);
var G__41532_42304 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41528_42300,G__41529_42301,G__41530_42302,G__41531_42303,G__41532_42304) : schema.core.fn_validator.call(null,G__41528_42300,G__41529_42301,G__41530_42302,G__41531_42303,G__41532_42304));
} else {
var temp__5804__auto___42305 = (function (){var fexpr__41533 = cljs.core.deref(output_checker41520_42284);
return (fexpr__41533.cljs$core$IFn$_invoke$arity$1 ? fexpr__41533.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41533.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42305)){
var error__28236__auto___42306 = temp__5804__auto___42305;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42306], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41517_42281,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42306], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema41517_42281,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41518_42282], null)));

var ufv___42307 = schema.utils.use_fn_validation;
var output_schema41534_42308 = schema.core.Any;
var input_schema41535_42309 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41536_42311 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41535_42309);
}),null));
var output_checker41537_42312 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41534_42308);
}),null));
var ret__30021__auto___42315 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__41538){
var validate__28234__auto__ = cljs.core.deref(ufv___42307);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42317 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41538], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41539_42318 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41540_42319 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__41541_42320 = input_schema41535_42309;
var G__41542_42321 = cljs.core.deref(input_checker41536_42311);
var G__41543_42322 = args__28235__auto___42317;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41539_42318,G__41540_42319,G__41541_42320,G__41542_42321,G__41543_42322) : schema.core.fn_validator.call(null,G__41539_42318,G__41540_42319,G__41541_42320,G__41542_42321,G__41543_42322));
} else {
var temp__5804__auto___42323 = (function (){var fexpr__41544 = cljs.core.deref(input_checker41536_42311);
return (fexpr__41544.cljs$core$IFn$_invoke$arity$1 ? fexpr__41544.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42317) : fexpr__41544.call(null,args__28235__auto___42317));
})();
if(cljs.core.truth_(temp__5804__auto___42323)){
var error__28236__auto___42324 = temp__5804__auto___42323;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42324], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41535_42309,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42317,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42324], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41538;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41546_42326 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41547_42327 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__41548_42328 = output_schema41534_42308;
var G__41549_42329 = cljs.core.deref(output_checker41537_42312);
var G__41550_42330 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41546_42326,G__41547_42327,G__41548_42328,G__41549_42329,G__41550_42330) : schema.core.fn_validator.call(null,G__41546_42326,G__41547_42327,G__41548_42328,G__41549_42329,G__41550_42330));
} else {
var temp__5804__auto___42335 = (function (){var fexpr__41551 = cljs.core.deref(output_checker41537_42312);
return (fexpr__41551.cljs$core$IFn$_invoke$arity$1 ? fexpr__41551.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41551.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42335)){
var error__28236__auto___42336 = temp__5804__auto___42335;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42336], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41534_42308,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42336], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema41534_42308,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41535_42309], null)));

var ufv___42337 = schema.utils.use_fn_validation;
var output_schema41552_42338 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41553_42339 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema41557_42340 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker41554_42341 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41553_42339);
}),null));
var output_checker41555_42342 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41552_42338);
}),null));
var input_checker41558_42343 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41557_42340);
}),null));
var output_checker41559_42344 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41552_42338);
}),null));
var ret__30021__auto___42345 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__41563 = arguments.length;
switch (G__41563) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__41556){
var validate__28234__auto__ = cljs.core.deref(ufv___42337);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42347 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41556], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41564_42348 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41565_42349 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__41566_42350 = input_schema41553_42339;
var G__41567_42351 = cljs.core.deref(input_checker41554_42341);
var G__41568_42352 = args__28235__auto___42347;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41564_42348,G__41565_42349,G__41566_42350,G__41567_42351,G__41568_42352) : schema.core.fn_validator.call(null,G__41564_42348,G__41565_42349,G__41566_42350,G__41567_42351,G__41568_42352));
} else {
var temp__5804__auto___42353 = (function (){var fexpr__41569 = cljs.core.deref(input_checker41554_42341);
return (fexpr__41569.cljs$core$IFn$_invoke$arity$1 ? fexpr__41569.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42347) : fexpr__41569.call(null,args__28235__auto___42347));
})();
if(cljs.core.truth_(temp__5804__auto___42353)){
var error__28236__auto___42354 = temp__5804__auto___42353;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42354], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41553_42339,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42347,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42354], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41556;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41570_42358 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41571_42359 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__41572_42360 = output_schema41552_42338;
var G__41573_42361 = cljs.core.deref(output_checker41555_42342);
var G__41574_42362 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41570_42358,G__41571_42359,G__41572_42360,G__41573_42361,G__41574_42362) : schema.core.fn_validator.call(null,G__41570_42358,G__41571_42359,G__41572_42360,G__41573_42361,G__41574_42362));
} else {
var temp__5804__auto___42363 = (function (){var fexpr__41575 = cljs.core.deref(output_checker41555_42342);
return (fexpr__41575.cljs$core$IFn$_invoke$arity$1 ? fexpr__41575.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41575.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42363)){
var error__28236__auto___42364 = temp__5804__auto___42363;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42364], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41552_42338,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42364], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__41560,G__41561){
var validate__28234__auto__ = cljs.core.deref(ufv___42337);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42365 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41560,G__41561], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41576_42366 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41577_42367 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__41578_42368 = input_schema41557_42340;
var G__41579_42369 = cljs.core.deref(input_checker41558_42343);
var G__41580_42370 = args__28235__auto___42365;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41576_42366,G__41577_42367,G__41578_42368,G__41579_42369,G__41580_42370) : schema.core.fn_validator.call(null,G__41576_42366,G__41577_42367,G__41578_42368,G__41579_42369,G__41580_42370));
} else {
var temp__5804__auto___42371 = (function (){var fexpr__41581 = cljs.core.deref(input_checker41558_42343);
return (fexpr__41581.cljs$core$IFn$_invoke$arity$1 ? fexpr__41581.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42365) : fexpr__41581.call(null,args__28235__auto___42365));
})();
if(cljs.core.truth_(temp__5804__auto___42371)){
var error__28236__auto___42372 = temp__5804__auto___42371;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42372], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41557_42340,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42365,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42372], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41560;
var field_kw_or_branch_i = G__41561;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41582_42373 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41583_42374 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__41584_42375 = output_schema41552_42338;
var G__41585_42376 = cljs.core.deref(output_checker41559_42344);
var G__41586_42377 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41582_42373,G__41583_42374,G__41584_42375,G__41585_42376,G__41586_42377) : schema.core.fn_validator.call(null,G__41582_42373,G__41583_42374,G__41584_42375,G__41585_42376,G__41586_42377));
} else {
var temp__5804__auto___42378 = (function (){var fexpr__41587 = cljs.core.deref(output_checker41559_42344);
return (fexpr__41587.cljs$core$IFn$_invoke$arity$1 ? fexpr__41587.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41587.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42378)){
var error__28236__auto___42379 = temp__5804__auto___42378;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42379], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41552_42338,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42379], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema41552_42338,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41553_42339,input_schema41557_42340], null)));

var ufv___42380 = schema.utils.use_fn_validation;
var output_schema41588_42381 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema41589_42382 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema41594_42383 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker41590_42384 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41589_42382);
}),null));
var output_checker41591_42385 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41588_42381);
}),null));
var input_checker41595_42386 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41594_42383);
}),null));
var output_checker41596_42387 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41588_42381);
}),null));
var ret__30021__auto___42388 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__41601 = arguments.length;
switch (G__41601) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__41592,G__41593){
var validate__28234__auto__ = cljs.core.deref(ufv___42380);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42390 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41592,G__41593], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41602_42391 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41603_42392 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__41604_42393 = input_schema41589_42382;
var G__41605_42394 = cljs.core.deref(input_checker41590_42384);
var G__41606_42395 = args__28235__auto___42390;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41602_42391,G__41603_42392,G__41604_42393,G__41605_42394,G__41606_42395) : schema.core.fn_validator.call(null,G__41602_42391,G__41603_42392,G__41604_42393,G__41605_42394,G__41606_42395));
} else {
var temp__5804__auto___42396 = (function (){var fexpr__41607 = cljs.core.deref(input_checker41590_42384);
return (fexpr__41607.cljs$core$IFn$_invoke$arity$1 ? fexpr__41607.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42390) : fexpr__41607.call(null,args__28235__auto___42390));
})();
if(cljs.core.truth_(temp__5804__auto___42396)){
var error__28236__auto___42397 = temp__5804__auto___42396;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42397], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41589_42382,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42390,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42397], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41592;
var path = G__41593;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41608_42398 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41609_42399 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__41610_42400 = output_schema41588_42381;
var G__41611_42401 = cljs.core.deref(output_checker41591_42385);
var G__41612_42402 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41608_42398,G__41609_42399,G__41610_42400,G__41611_42401,G__41612_42402) : schema.core.fn_validator.call(null,G__41608_42398,G__41609_42399,G__41610_42400,G__41611_42401,G__41612_42402));
} else {
var temp__5804__auto___42403 = (function (){var fexpr__41613 = cljs.core.deref(output_checker41591_42385);
return (fexpr__41613.cljs$core$IFn$_invoke$arity$1 ? fexpr__41613.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41613.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42403)){
var error__28236__auto___42404 = temp__5804__auto___42403;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42404], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41588_42381,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42404], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__41597,G__41598,G__41599){
var validate__28234__auto__ = cljs.core.deref(ufv___42380);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42405 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41597,G__41598,G__41599], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41614_42406 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41615_42407 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__41616_42408 = input_schema41594_42383;
var G__41617_42409 = cljs.core.deref(input_checker41595_42386);
var G__41618_42410 = args__28235__auto___42405;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41614_42406,G__41615_42407,G__41616_42408,G__41617_42409,G__41618_42410) : schema.core.fn_validator.call(null,G__41614_42406,G__41615_42407,G__41616_42408,G__41617_42409,G__41618_42410));
} else {
var temp__5804__auto___42411 = (function (){var fexpr__41619 = cljs.core.deref(input_checker41595_42386);
return (fexpr__41619.cljs$core$IFn$_invoke$arity$1 ? fexpr__41619.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42405) : fexpr__41619.call(null,args__28235__auto___42405));
})();
if(cljs.core.truth_(temp__5804__auto___42411)){
var error__28236__auto___42412 = temp__5804__auto___42411;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42412], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41594_42383,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42405,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42412], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41597;
var path = G__41598;
var G__41621 = G__41599;
var map__41622 = G__41621;
var map__41622__$1 = cljs.core.__destructure_map(map__41622);
var opts = map__41622__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41622__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__41621__$1 = G__41621;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__41623 = G__41621__$1;
var map__41623__$1 = cljs.core.__destructure_map(map__41623);
var opts__$1 = map__41623__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41623__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41625_42413 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41626_42414 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__41627_42415 = output_schema41588_42381;
var G__41628_42416 = cljs.core.deref(output_checker41596_42387);
var G__41629_42417 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41625_42413,G__41626_42414,G__41627_42415,G__41628_42416,G__41629_42417) : schema.core.fn_validator.call(null,G__41625_42413,G__41626_42414,G__41627_42415,G__41628_42416,G__41629_42417));
} else {
var temp__5804__auto___42418 = (function (){var fexpr__41630 = cljs.core.deref(output_checker41596_42387);
return (fexpr__41630.cljs$core$IFn$_invoke$arity$1 ? fexpr__41630.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41630.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42418)){
var error__28236__auto___42419 = temp__5804__auto___42418;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42419], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41588_42381,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42419], null));
} else {
}
}
} else {
}

return o__28237__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema41588_42381,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41589_42382,input_schema41594_42383], null)));

var ufv___42420 = schema.utils.use_fn_validation;
var output_schema41631_42421 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema41632_42422 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41633_42423 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41632_42422);
}),null));
var output_checker41634_42424 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41631_42421);
}),null));
var ret__30021__auto___42425 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__41635){
var validate__28234__auto__ = cljs.core.deref(ufv___42420);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42426 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41635], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41636_42427 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41637_42428 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__41638_42429 = input_schema41632_42422;
var G__41639_42430 = cljs.core.deref(input_checker41633_42423);
var G__41640_42431 = args__28235__auto___42426;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41636_42427,G__41637_42428,G__41638_42429,G__41639_42430,G__41640_42431) : schema.core.fn_validator.call(null,G__41636_42427,G__41637_42428,G__41638_42429,G__41639_42430,G__41640_42431));
} else {
var temp__5804__auto___42432 = (function (){var fexpr__41641 = cljs.core.deref(input_checker41633_42423);
return (fexpr__41641.cljs$core$IFn$_invoke$arity$1 ? fexpr__41641.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42426) : fexpr__41641.call(null,args__28235__auto___42426));
})();
if(cljs.core.truth_(temp__5804__auto___42432)){
var error__28236__auto___42434 = temp__5804__auto___42432;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42434], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41632_42422,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42426,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42434], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var union_schema = G__41635;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41643_42440 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41644_42441 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__41645_42442 = output_schema41631_42421;
var G__41646_42443 = cljs.core.deref(output_checker41634_42424);
var G__41647_42444 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41643_42440,G__41644_42441,G__41645_42442,G__41646_42443,G__41647_42444) : schema.core.fn_validator.call(null,G__41643_42440,G__41644_42441,G__41645_42442,G__41646_42443,G__41647_42444));
} else {
var temp__5804__auto___42445 = (function (){var fexpr__41648 = cljs.core.deref(output_checker41634_42424);
return (fexpr__41648.cljs$core$IFn$_invoke$arity$1 ? fexpr__41648.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41648.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42445)){
var error__28236__auto___42446 = temp__5804__auto___42445;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42446], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41631_42421,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42446], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema41631_42421,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41632_42422], null)));

var ufv___42447 = schema.utils.use_fn_validation;
var output_schema41649_42448 = deercreeklabs.lancaster.LancasterSchema;
var input_schema41650_42449 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41651_42450 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41650_42449);
}),null));
var output_checker41652_42451 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41649_42448);
}),null));
var ret__30021__auto___42452 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__41653,G__41654){
var validate__28234__auto__ = cljs.core.deref(ufv___42447);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42454 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41653,G__41654], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41655_42455 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41656_42456 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__41657_42457 = input_schema41650_42449;
var G__41658_42458 = cljs.core.deref(input_checker41651_42450);
var G__41659_42459 = args__28235__auto___42454;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41655_42455,G__41656_42456,G__41657_42457,G__41658_42458,G__41659_42459) : schema.core.fn_validator.call(null,G__41655_42455,G__41656_42456,G__41657_42457,G__41658_42458,G__41659_42459));
} else {
var temp__5804__auto___42460 = (function (){var fexpr__41660 = cljs.core.deref(input_checker41651_42450);
return (fexpr__41660.cljs$core$IFn$_invoke$arity$1 ? fexpr__41660.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42454) : fexpr__41660.call(null,args__28235__auto___42454));
})();
if(cljs.core.truth_(temp__5804__auto___42460)){
var error__28236__auto___42461 = temp__5804__auto___42460;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42461], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41650_42449,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42454,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42461], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var union_schema = G__41653;
var branch_index = G__41654;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41662_42464 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41663_42465 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__41664_42466 = output_schema41649_42448;
var G__41665_42467 = cljs.core.deref(output_checker41652_42451);
var G__41666_42468 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41662_42464,G__41663_42465,G__41664_42466,G__41665_42467,G__41666_42468) : schema.core.fn_validator.call(null,G__41662_42464,G__41663_42465,G__41664_42466,G__41665_42467,G__41666_42468));
} else {
var temp__5804__auto___42469 = (function (){var fexpr__41667 = cljs.core.deref(output_checker41652_42451);
return (fexpr__41667.cljs$core$IFn$_invoke$arity$1 ? fexpr__41667.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41667.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42469)){
var error__28236__auto___42471 = temp__5804__auto___42469;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42471], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41649_42448,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42471], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema41649_42448,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41650_42449], null)));

var ufv___42472 = schema.utils.use_fn_validation;
var output_schema41668_42473 = schema.core.Keyword;
var input_schema41669_42474 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker41670_42475 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41669_42474);
}),null));
var output_checker41671_42476 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41668_42473);
}),null));
var ret__30021__auto___42477 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__41672){
var validate__28234__auto__ = cljs.core.deref(ufv___42472);
if(cljs.core.truth_(validate__28234__auto__)){
var args__28235__auto___42478 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41672], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41673_42479 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41674_42480 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__41675_42481 = input_schema41669_42474;
var G__41676_42482 = cljs.core.deref(input_checker41670_42475);
var G__41677_42483 = args__28235__auto___42478;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41673_42479,G__41674_42480,G__41675_42481,G__41676_42482,G__41677_42483) : schema.core.fn_validator.call(null,G__41673_42479,G__41674_42480,G__41675_42481,G__41676_42482,G__41677_42483));
} else {
var temp__5804__auto___42484 = (function (){var fexpr__41678 = cljs.core.deref(input_checker41670_42475);
return (fexpr__41678.cljs$core$IFn$_invoke$arity$1 ? fexpr__41678.cljs$core$IFn$_invoke$arity$1(args__28235__auto___42478) : fexpr__41678.call(null,args__28235__auto___42478));
})();
if(cljs.core.truth_(temp__5804__auto___42484)){
var error__28236__auto___42485 = temp__5804__auto___42484;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42485], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41669_42474,new cljs.core.Keyword(null,"value","value",305978217),args__28235__auto___42478,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42485], null));
} else {
}
}
} else {
}

var o__28237__auto__ = (function (){var schema__$1 = G__41672;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__28234__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41680_42486 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41681_42487 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__41682_42488 = output_schema41668_42473;
var G__41683_42489 = cljs.core.deref(output_checker41671_42476);
var G__41684_42490 = o__28237__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41680_42486,G__41681_42487,G__41682_42488,G__41683_42489,G__41684_42490) : schema.core.fn_validator.call(null,G__41680_42486,G__41681_42487,G__41682_42488,G__41683_42489,G__41684_42490));
} else {
var temp__5804__auto___42491 = (function (){var fexpr__41685 = cljs.core.deref(output_checker41671_42476);
return (fexpr__41685.cljs$core$IFn$_invoke$arity$1 ? fexpr__41685.cljs$core$IFn$_invoke$arity$1(o__28237__auto__) : fexpr__41685.call(null,o__28237__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42491)){
var error__28236__auto___42492 = temp__5804__auto___42491;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__28236__auto___42492], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41668_42473,new cljs.core.Keyword(null,"value","value",305978217),o__28237__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__28236__auto___42492], null));
} else {
}
}
} else {
}

return o__28237__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema41668_42473,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41669_42474], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
