goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__56113){
var vec__56114 = p__56113;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56114,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56114,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__56118 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__56118__$1 = (((G__56118 instanceof cljs.core.Keyword))?G__56118.fqn:null);
switch (G__56118__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__56122 = (function (){
var seq__56124 = cljs.core.seq(vars__$1);
var chunk__56125 = null;
var count__56126 = (0);
var i__56127 = (0);
while(true){
if((i__56127 < count__56126)){
var v = chunk__56125.cljs$core$IIndexed$_nth$arity$2(null,i__56127);
var temp__5804__auto___56244 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56244)){
var t_56245 = temp__5804__auto___56244;
var G__56137_56246 = ((function (seq__56124,chunk__56125,count__56126,i__56127,t_56245,temp__5804__auto___56244,v,each_fixture_fn,G__56118,G__56118__$1,env,once_fixtures,each_fixtures,vec__56114,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56245)));
});})(seq__56124,chunk__56125,count__56126,i__56127,t_56245,temp__5804__auto___56244,v,each_fixture_fn,G__56118,G__56118__$1,env,once_fixtures,each_fixtures,vec__56114,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56137_56246) : each_fixture_fn.call(null,G__56137_56246));
} else {
}


var G__56252 = seq__56124;
var G__56253 = chunk__56125;
var G__56254 = count__56126;
var G__56255 = (i__56127 + (1));
seq__56124 = G__56252;
chunk__56125 = G__56253;
count__56126 = G__56254;
i__56127 = G__56255;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__56124);
if(temp__5804__auto__){
var seq__56124__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56124__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__56124__$1);
var G__56259 = cljs.core.chunk_rest(seq__56124__$1);
var G__56260 = c__5568__auto__;
var G__56261 = cljs.core.count(c__5568__auto__);
var G__56262 = (0);
seq__56124 = G__56259;
chunk__56125 = G__56260;
count__56126 = G__56261;
i__56127 = G__56262;
continue;
} else {
var v = cljs.core.first(seq__56124__$1);
var temp__5804__auto___56264__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56264__$1)){
var t_56266 = temp__5804__auto___56264__$1;
var G__56138_56267 = ((function (seq__56124,chunk__56125,count__56126,i__56127,t_56266,temp__5804__auto___56264__$1,v,seq__56124__$1,temp__5804__auto__,each_fixture_fn,G__56118,G__56118__$1,env,once_fixtures,each_fixtures,vec__56114,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56266)));
});})(seq__56124,chunk__56125,count__56126,i__56127,t_56266,temp__5804__auto___56264__$1,v,seq__56124__$1,temp__5804__auto__,each_fixture_fn,G__56118,G__56118__$1,env,once_fixtures,each_fixtures,vec__56114,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56138_56267) : each_fixture_fn.call(null,G__56138_56267));
} else {
}


var G__56272 = cljs.core.next(seq__56124__$1);
var G__56273 = null;
var G__56274 = (0);
var G__56275 = (0);
seq__56124 = G__56272;
chunk__56125 = G__56273;
count__56126 = G__56274;
i__56127 = G__56275;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__56121 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__56121.cljs$core$IFn$_invoke$arity$1 ? fexpr__56121.cljs$core$IFn$_invoke$arity$1(G__56122) : fexpr__56121.call(null,G__56122));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56118__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__56110_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56110_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__56139 = shadow.test.env.get_test_ns_info(ns);
var map__56139__$1 = cljs.core.__destructure_map(map__56139);
var test_ns = map__56139__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56139__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__56141,vars){
var map__56142 = p__56141;
var map__56142__$1 = cljs.core.__destructure_map(map__56142);
var env = map__56142__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56142__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__56143_56287 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__56145_56288 = null;
var count__56146_56289 = (0);
var i__56147_56290 = (0);
while(true){
if((i__56147_56290 < count__56146_56289)){
var vec__56163_56291 = chunk__56145_56288.cljs$core$IIndexed$_nth$arity$2(null,i__56147_56290);
var test_ns_56292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56163_56291,(0),null);
var ns_info_56293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56163_56291,(1),null);
var map__56166_56294 = ns_info_56293;
var map__56166_56295__$1 = cljs.core.__destructure_map(map__56166_56294);
var fixtures_56296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56166_56295__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56297 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56296);
if(cljs.core.truth_(temp__5804__auto___56297)){
var fix_56298 = temp__5804__auto___56297;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56292,fix_56298], 0));
} else {
}

var temp__5804__auto___56300 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56296);
if(cljs.core.truth_(temp__5804__auto___56300)){
var fix_56301 = temp__5804__auto___56300;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56292,fix_56301], 0));
} else {
}


var G__56302 = seq__56143_56287;
var G__56303 = chunk__56145_56288;
var G__56304 = count__56146_56289;
var G__56305 = (i__56147_56290 + (1));
seq__56143_56287 = G__56302;
chunk__56145_56288 = G__56303;
count__56146_56289 = G__56304;
i__56147_56290 = G__56305;
continue;
} else {
var temp__5804__auto___56306 = cljs.core.seq(seq__56143_56287);
if(temp__5804__auto___56306){
var seq__56143_56307__$1 = temp__5804__auto___56306;
if(cljs.core.chunked_seq_QMARK_(seq__56143_56307__$1)){
var c__5568__auto___56308 = cljs.core.chunk_first(seq__56143_56307__$1);
var G__56309 = cljs.core.chunk_rest(seq__56143_56307__$1);
var G__56310 = c__5568__auto___56308;
var G__56311 = cljs.core.count(c__5568__auto___56308);
var G__56312 = (0);
seq__56143_56287 = G__56309;
chunk__56145_56288 = G__56310;
count__56146_56289 = G__56311;
i__56147_56290 = G__56312;
continue;
} else {
var vec__56167_56313 = cljs.core.first(seq__56143_56307__$1);
var test_ns_56314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56167_56313,(0),null);
var ns_info_56315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56167_56313,(1),null);
var map__56170_56316 = ns_info_56315;
var map__56170_56317__$1 = cljs.core.__destructure_map(map__56170_56316);
var fixtures_56318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56170_56317__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56320__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56318);
if(cljs.core.truth_(temp__5804__auto___56320__$1)){
var fix_56321 = temp__5804__auto___56320__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56314,fix_56321], 0));
} else {
}

var temp__5804__auto___56323__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56318);
if(cljs.core.truth_(temp__5804__auto___56323__$1)){
var fix_56324 = temp__5804__auto___56323__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56314,fix_56324], 0));
} else {
}


var G__56325 = cljs.core.next(seq__56143_56307__$1);
var G__56326 = null;
var G__56327 = (0);
var G__56328 = (0);
seq__56143_56287 = G__56325;
chunk__56145_56288 = G__56326;
count__56146_56289 = G__56327;
i__56147_56290 = G__56328;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56140_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56140_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__56192 = cljs.test.get_current_env();
var map__56192__$1 = cljs.core.__destructure_map(map__56192);
var env = map__56192__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56192__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56192__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__56194 = arguments.length;
switch (G__56194) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__56198 = arguments.length;
switch (G__56198) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__56199 = shadow.test.env.get_test_ns_info(ns);
var map__56199__$1 = cljs.core.__destructure_map(map__56199);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56199__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__56202 = arguments.length;
switch (G__56202) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56200_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56200_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__56215 = arguments.length;
switch (G__56215) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56210_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56210_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
