goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35538 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35538(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35540 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35540(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34261 = coll;
var G__34262 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34261,G__34262) : shadow.dom.lazy_native_coll_seq.call(null,G__34261,G__34262));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34306 = arguments.length;
switch (G__34306) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34334 = arguments.length;
switch (G__34334) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34361 = arguments.length;
switch (G__34361) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34383 = arguments.length;
switch (G__34383) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34410 = arguments.length;
switch (G__34410) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34422 = arguments.length;
switch (G__34422) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34439){if((e34439 instanceof Object)){
var e = e34439;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34439;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34447 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34448 = null;
var count__34449 = (0);
var i__34450 = (0);
while(true){
if((i__34450 < count__34449)){
var el = chunk__34448.cljs$core$IIndexed$_nth$arity$2(null,i__34450);
var handler_35597__$1 = ((function (seq__34447,chunk__34448,count__34449,i__34450,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34447,chunk__34448,count__34449,i__34450,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35597__$1);


var G__35599 = seq__34447;
var G__35600 = chunk__34448;
var G__35601 = count__34449;
var G__35602 = (i__34450 + (1));
seq__34447 = G__35599;
chunk__34448 = G__35600;
count__34449 = G__35601;
i__34450 = G__35602;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34447);
if(temp__5804__auto__){
var seq__34447__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34447__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34447__$1);
var G__35606 = cljs.core.chunk_rest(seq__34447__$1);
var G__35607 = c__5568__auto__;
var G__35608 = cljs.core.count(c__5568__auto__);
var G__35609 = (0);
seq__34447 = G__35606;
chunk__34448 = G__35607;
count__34449 = G__35608;
i__34450 = G__35609;
continue;
} else {
var el = cljs.core.first(seq__34447__$1);
var handler_35612__$1 = ((function (seq__34447,chunk__34448,count__34449,i__34450,el,seq__34447__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34447,chunk__34448,count__34449,i__34450,el,seq__34447__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35612__$1);


var G__35614 = cljs.core.next(seq__34447__$1);
var G__35615 = null;
var G__35616 = (0);
var G__35617 = (0);
seq__34447 = G__35614;
chunk__34448 = G__35615;
count__34449 = G__35616;
i__34450 = G__35617;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34479 = arguments.length;
switch (G__34479) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34504 = cljs.core.seq(events);
var chunk__34505 = null;
var count__34506 = (0);
var i__34507 = (0);
while(true){
if((i__34507 < count__34506)){
var vec__34529 = chunk__34505.cljs$core$IIndexed$_nth$arity$2(null,i__34507);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34529,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34529,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35623 = seq__34504;
var G__35624 = chunk__34505;
var G__35625 = count__34506;
var G__35626 = (i__34507 + (1));
seq__34504 = G__35623;
chunk__34505 = G__35624;
count__34506 = G__35625;
i__34507 = G__35626;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34504);
if(temp__5804__auto__){
var seq__34504__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34504__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34504__$1);
var G__35627 = cljs.core.chunk_rest(seq__34504__$1);
var G__35628 = c__5568__auto__;
var G__35629 = cljs.core.count(c__5568__auto__);
var G__35630 = (0);
seq__34504 = G__35627;
chunk__34505 = G__35628;
count__34506 = G__35629;
i__34507 = G__35630;
continue;
} else {
var vec__34538 = cljs.core.first(seq__34504__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34538,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34538,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35631 = cljs.core.next(seq__34504__$1);
var G__35632 = null;
var G__35633 = (0);
var G__35634 = (0);
seq__34504 = G__35631;
chunk__34505 = G__35632;
count__34506 = G__35633;
i__34507 = G__35634;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34547 = cljs.core.seq(styles);
var chunk__34548 = null;
var count__34549 = (0);
var i__34550 = (0);
while(true){
if((i__34550 < count__34549)){
var vec__34566 = chunk__34548.cljs$core$IIndexed$_nth$arity$2(null,i__34550);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34566,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34566,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35638 = seq__34547;
var G__35639 = chunk__34548;
var G__35640 = count__34549;
var G__35641 = (i__34550 + (1));
seq__34547 = G__35638;
chunk__34548 = G__35639;
count__34549 = G__35640;
i__34550 = G__35641;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34547);
if(temp__5804__auto__){
var seq__34547__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34547__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34547__$1);
var G__35643 = cljs.core.chunk_rest(seq__34547__$1);
var G__35644 = c__5568__auto__;
var G__35645 = cljs.core.count(c__5568__auto__);
var G__35646 = (0);
seq__34547 = G__35643;
chunk__34548 = G__35644;
count__34549 = G__35645;
i__34550 = G__35646;
continue;
} else {
var vec__34573 = cljs.core.first(seq__34547__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34573,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34573,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35648 = cljs.core.next(seq__34547__$1);
var G__35649 = null;
var G__35650 = (0);
var G__35651 = (0);
seq__34547 = G__35648;
chunk__34548 = G__35649;
count__34549 = G__35650;
i__34550 = G__35651;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34584_35652 = key;
var G__34584_35653__$1 = (((G__34584_35652 instanceof cljs.core.Keyword))?G__34584_35652.fqn:null);
switch (G__34584_35653__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35659 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35659,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35659,"aria-");
}
})())){
el.setAttribute(ks_35659,value);
} else {
(el[ks_35659] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34642){
var map__34644 = p__34642;
var map__34644__$1 = cljs.core.__destructure_map(map__34644);
var props = map__34644__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34644__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34648 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34648,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34648,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34648,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34655 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34655,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34655;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34669 = arguments.length;
switch (G__34669) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34686){
var vec__34688 = p__34686;
var seq__34689 = cljs.core.seq(vec__34688);
var first__34690 = cljs.core.first(seq__34689);
var seq__34689__$1 = cljs.core.next(seq__34689);
var nn = first__34690;
var first__34690__$1 = cljs.core.first(seq__34689__$1);
var seq__34689__$2 = cljs.core.next(seq__34689__$1);
var np = first__34690__$1;
var nc = seq__34689__$2;
var node = vec__34688;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34696 = nn;
var G__34697 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34696,G__34697) : create_fn.call(null,G__34696,G__34697));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34702 = nn;
var G__34703 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34702,G__34703) : create_fn.call(null,G__34702,G__34703));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34715 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34715,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34715,(1),null);
var seq__34719_35690 = cljs.core.seq(node_children);
var chunk__34720_35691 = null;
var count__34721_35692 = (0);
var i__34722_35693 = (0);
while(true){
if((i__34722_35693 < count__34721_35692)){
var child_struct_35697 = chunk__34720_35691.cljs$core$IIndexed$_nth$arity$2(null,i__34722_35693);
var children_35698 = shadow.dom.dom_node(child_struct_35697);
if(cljs.core.seq_QMARK_(children_35698)){
var seq__34801_35699 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35698));
var chunk__34803_35700 = null;
var count__34804_35701 = (0);
var i__34805_35702 = (0);
while(true){
if((i__34805_35702 < count__34804_35701)){
var child_35703 = chunk__34803_35700.cljs$core$IIndexed$_nth$arity$2(null,i__34805_35702);
if(cljs.core.truth_(child_35703)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35703);


var G__35704 = seq__34801_35699;
var G__35705 = chunk__34803_35700;
var G__35706 = count__34804_35701;
var G__35707 = (i__34805_35702 + (1));
seq__34801_35699 = G__35704;
chunk__34803_35700 = G__35705;
count__34804_35701 = G__35706;
i__34805_35702 = G__35707;
continue;
} else {
var G__35709 = seq__34801_35699;
var G__35710 = chunk__34803_35700;
var G__35711 = count__34804_35701;
var G__35712 = (i__34805_35702 + (1));
seq__34801_35699 = G__35709;
chunk__34803_35700 = G__35710;
count__34804_35701 = G__35711;
i__34805_35702 = G__35712;
continue;
}
} else {
var temp__5804__auto___35714 = cljs.core.seq(seq__34801_35699);
if(temp__5804__auto___35714){
var seq__34801_35715__$1 = temp__5804__auto___35714;
if(cljs.core.chunked_seq_QMARK_(seq__34801_35715__$1)){
var c__5568__auto___35717 = cljs.core.chunk_first(seq__34801_35715__$1);
var G__35718 = cljs.core.chunk_rest(seq__34801_35715__$1);
var G__35719 = c__5568__auto___35717;
var G__35720 = cljs.core.count(c__5568__auto___35717);
var G__35721 = (0);
seq__34801_35699 = G__35718;
chunk__34803_35700 = G__35719;
count__34804_35701 = G__35720;
i__34805_35702 = G__35721;
continue;
} else {
var child_35722 = cljs.core.first(seq__34801_35715__$1);
if(cljs.core.truth_(child_35722)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35722);


var G__35723 = cljs.core.next(seq__34801_35715__$1);
var G__35724 = null;
var G__35725 = (0);
var G__35726 = (0);
seq__34801_35699 = G__35723;
chunk__34803_35700 = G__35724;
count__34804_35701 = G__35725;
i__34805_35702 = G__35726;
continue;
} else {
var G__35727 = cljs.core.next(seq__34801_35715__$1);
var G__35728 = null;
var G__35729 = (0);
var G__35730 = (0);
seq__34801_35699 = G__35727;
chunk__34803_35700 = G__35728;
count__34804_35701 = G__35729;
i__34805_35702 = G__35730;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35698);
}


var G__35731 = seq__34719_35690;
var G__35732 = chunk__34720_35691;
var G__35733 = count__34721_35692;
var G__35734 = (i__34722_35693 + (1));
seq__34719_35690 = G__35731;
chunk__34720_35691 = G__35732;
count__34721_35692 = G__35733;
i__34722_35693 = G__35734;
continue;
} else {
var temp__5804__auto___35735 = cljs.core.seq(seq__34719_35690);
if(temp__5804__auto___35735){
var seq__34719_35736__$1 = temp__5804__auto___35735;
if(cljs.core.chunked_seq_QMARK_(seq__34719_35736__$1)){
var c__5568__auto___35737 = cljs.core.chunk_first(seq__34719_35736__$1);
var G__35742 = cljs.core.chunk_rest(seq__34719_35736__$1);
var G__35743 = c__5568__auto___35737;
var G__35744 = cljs.core.count(c__5568__auto___35737);
var G__35745 = (0);
seq__34719_35690 = G__35742;
chunk__34720_35691 = G__35743;
count__34721_35692 = G__35744;
i__34722_35693 = G__35745;
continue;
} else {
var child_struct_35746 = cljs.core.first(seq__34719_35736__$1);
var children_35747 = shadow.dom.dom_node(child_struct_35746);
if(cljs.core.seq_QMARK_(children_35747)){
var seq__34832_35748 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35747));
var chunk__34834_35749 = null;
var count__34835_35750 = (0);
var i__34836_35751 = (0);
while(true){
if((i__34836_35751 < count__34835_35750)){
var child_35752 = chunk__34834_35749.cljs$core$IIndexed$_nth$arity$2(null,i__34836_35751);
if(cljs.core.truth_(child_35752)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35752);


var G__35754 = seq__34832_35748;
var G__35755 = chunk__34834_35749;
var G__35756 = count__34835_35750;
var G__35757 = (i__34836_35751 + (1));
seq__34832_35748 = G__35754;
chunk__34834_35749 = G__35755;
count__34835_35750 = G__35756;
i__34836_35751 = G__35757;
continue;
} else {
var G__35758 = seq__34832_35748;
var G__35759 = chunk__34834_35749;
var G__35760 = count__34835_35750;
var G__35761 = (i__34836_35751 + (1));
seq__34832_35748 = G__35758;
chunk__34834_35749 = G__35759;
count__34835_35750 = G__35760;
i__34836_35751 = G__35761;
continue;
}
} else {
var temp__5804__auto___35766__$1 = cljs.core.seq(seq__34832_35748);
if(temp__5804__auto___35766__$1){
var seq__34832_35767__$1 = temp__5804__auto___35766__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34832_35767__$1)){
var c__5568__auto___35768 = cljs.core.chunk_first(seq__34832_35767__$1);
var G__35769 = cljs.core.chunk_rest(seq__34832_35767__$1);
var G__35770 = c__5568__auto___35768;
var G__35771 = cljs.core.count(c__5568__auto___35768);
var G__35772 = (0);
seq__34832_35748 = G__35769;
chunk__34834_35749 = G__35770;
count__34835_35750 = G__35771;
i__34836_35751 = G__35772;
continue;
} else {
var child_35773 = cljs.core.first(seq__34832_35767__$1);
if(cljs.core.truth_(child_35773)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35773);


var G__35774 = cljs.core.next(seq__34832_35767__$1);
var G__35775 = null;
var G__35776 = (0);
var G__35777 = (0);
seq__34832_35748 = G__35774;
chunk__34834_35749 = G__35775;
count__34835_35750 = G__35776;
i__34836_35751 = G__35777;
continue;
} else {
var G__35778 = cljs.core.next(seq__34832_35767__$1);
var G__35779 = null;
var G__35780 = (0);
var G__35781 = (0);
seq__34832_35748 = G__35778;
chunk__34834_35749 = G__35779;
count__34835_35750 = G__35780;
i__34836_35751 = G__35781;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35747);
}


var G__35782 = cljs.core.next(seq__34719_35736__$1);
var G__35783 = null;
var G__35784 = (0);
var G__35785 = (0);
seq__34719_35690 = G__35782;
chunk__34720_35691 = G__35783;
count__34721_35692 = G__35784;
i__34722_35693 = G__35785;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34875 = cljs.core.seq(node);
var chunk__34876 = null;
var count__34877 = (0);
var i__34878 = (0);
while(true){
if((i__34878 < count__34877)){
var n = chunk__34876.cljs$core$IIndexed$_nth$arity$2(null,i__34878);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35788 = seq__34875;
var G__35789 = chunk__34876;
var G__35790 = count__34877;
var G__35791 = (i__34878 + (1));
seq__34875 = G__35788;
chunk__34876 = G__35789;
count__34877 = G__35790;
i__34878 = G__35791;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34875);
if(temp__5804__auto__){
var seq__34875__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34875__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34875__$1);
var G__35793 = cljs.core.chunk_rest(seq__34875__$1);
var G__35794 = c__5568__auto__;
var G__35795 = cljs.core.count(c__5568__auto__);
var G__35796 = (0);
seq__34875 = G__35793;
chunk__34876 = G__35794;
count__34877 = G__35795;
i__34878 = G__35796;
continue;
} else {
var n = cljs.core.first(seq__34875__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35797 = cljs.core.next(seq__34875__$1);
var G__35798 = null;
var G__35799 = (0);
var G__35800 = (0);
seq__34875 = G__35797;
chunk__34876 = G__35798;
count__34877 = G__35799;
i__34878 = G__35800;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34900 = arguments.length;
switch (G__34900) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34906 = arguments.length;
switch (G__34906) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34949 = arguments.length;
switch (G__34949) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35811 = arguments.length;
var i__5770__auto___35812 = (0);
while(true){
if((i__5770__auto___35812 < len__5769__auto___35811)){
args__5775__auto__.push((arguments[i__5770__auto___35812]));

var G__35813 = (i__5770__auto___35812 + (1));
i__5770__auto___35812 = G__35813;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34976_35814 = cljs.core.seq(nodes);
var chunk__34977_35815 = null;
var count__34978_35816 = (0);
var i__34979_35817 = (0);
while(true){
if((i__34979_35817 < count__34978_35816)){
var node_35818 = chunk__34977_35815.cljs$core$IIndexed$_nth$arity$2(null,i__34979_35817);
fragment.appendChild(shadow.dom._to_dom(node_35818));


var G__35819 = seq__34976_35814;
var G__35820 = chunk__34977_35815;
var G__35821 = count__34978_35816;
var G__35822 = (i__34979_35817 + (1));
seq__34976_35814 = G__35819;
chunk__34977_35815 = G__35820;
count__34978_35816 = G__35821;
i__34979_35817 = G__35822;
continue;
} else {
var temp__5804__auto___35823 = cljs.core.seq(seq__34976_35814);
if(temp__5804__auto___35823){
var seq__34976_35824__$1 = temp__5804__auto___35823;
if(cljs.core.chunked_seq_QMARK_(seq__34976_35824__$1)){
var c__5568__auto___35825 = cljs.core.chunk_first(seq__34976_35824__$1);
var G__35826 = cljs.core.chunk_rest(seq__34976_35824__$1);
var G__35827 = c__5568__auto___35825;
var G__35828 = cljs.core.count(c__5568__auto___35825);
var G__35829 = (0);
seq__34976_35814 = G__35826;
chunk__34977_35815 = G__35827;
count__34978_35816 = G__35828;
i__34979_35817 = G__35829;
continue;
} else {
var node_35830 = cljs.core.first(seq__34976_35824__$1);
fragment.appendChild(shadow.dom._to_dom(node_35830));


var G__35831 = cljs.core.next(seq__34976_35824__$1);
var G__35832 = null;
var G__35833 = (0);
var G__35834 = (0);
seq__34976_35814 = G__35831;
chunk__34977_35815 = G__35832;
count__34978_35816 = G__35833;
i__34979_35817 = G__35834;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34969){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34969));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34994_35838 = cljs.core.seq(scripts);
var chunk__34995_35839 = null;
var count__34996_35840 = (0);
var i__34997_35841 = (0);
while(true){
if((i__34997_35841 < count__34996_35840)){
var vec__35016_35842 = chunk__34995_35839.cljs$core$IIndexed$_nth$arity$2(null,i__34997_35841);
var script_tag_35843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35016_35842,(0),null);
var script_body_35844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35016_35842,(1),null);
eval(script_body_35844);


var G__35845 = seq__34994_35838;
var G__35846 = chunk__34995_35839;
var G__35847 = count__34996_35840;
var G__35848 = (i__34997_35841 + (1));
seq__34994_35838 = G__35845;
chunk__34995_35839 = G__35846;
count__34996_35840 = G__35847;
i__34997_35841 = G__35848;
continue;
} else {
var temp__5804__auto___35849 = cljs.core.seq(seq__34994_35838);
if(temp__5804__auto___35849){
var seq__34994_35850__$1 = temp__5804__auto___35849;
if(cljs.core.chunked_seq_QMARK_(seq__34994_35850__$1)){
var c__5568__auto___35851 = cljs.core.chunk_first(seq__34994_35850__$1);
var G__35852 = cljs.core.chunk_rest(seq__34994_35850__$1);
var G__35853 = c__5568__auto___35851;
var G__35854 = cljs.core.count(c__5568__auto___35851);
var G__35855 = (0);
seq__34994_35838 = G__35852;
chunk__34995_35839 = G__35853;
count__34996_35840 = G__35854;
i__34997_35841 = G__35855;
continue;
} else {
var vec__35021_35856 = cljs.core.first(seq__34994_35850__$1);
var script_tag_35857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35021_35856,(0),null);
var script_body_35858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35021_35856,(1),null);
eval(script_body_35858);


var G__35859 = cljs.core.next(seq__34994_35850__$1);
var G__35860 = null;
var G__35861 = (0);
var G__35862 = (0);
seq__34994_35838 = G__35859;
chunk__34995_35839 = G__35860;
count__34996_35840 = G__35861;
i__34997_35841 = G__35862;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__35026){
var vec__35027 = p__35026;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35027,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35027,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35033 = arguments.length;
switch (G__35033) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35054 = cljs.core.seq(style_keys);
var chunk__35055 = null;
var count__35056 = (0);
var i__35057 = (0);
while(true){
if((i__35057 < count__35056)){
var it = chunk__35055.cljs$core$IIndexed$_nth$arity$2(null,i__35057);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35875 = seq__35054;
var G__35876 = chunk__35055;
var G__35877 = count__35056;
var G__35878 = (i__35057 + (1));
seq__35054 = G__35875;
chunk__35055 = G__35876;
count__35056 = G__35877;
i__35057 = G__35878;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__35054);
if(temp__5804__auto__){
var seq__35054__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35054__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__35054__$1);
var G__35879 = cljs.core.chunk_rest(seq__35054__$1);
var G__35880 = c__5568__auto__;
var G__35881 = cljs.core.count(c__5568__auto__);
var G__35882 = (0);
seq__35054 = G__35879;
chunk__35055 = G__35880;
count__35056 = G__35881;
i__35057 = G__35882;
continue;
} else {
var it = cljs.core.first(seq__35054__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35883 = cljs.core.next(seq__35054__$1);
var G__35884 = null;
var G__35885 = (0);
var G__35886 = (0);
seq__35054 = G__35883;
chunk__35055 = G__35884;
count__35056 = G__35885;
i__35057 = G__35886;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35059,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35064 = k35059;
var G__35064__$1 = (((G__35064 instanceof cljs.core.Keyword))?G__35064.fqn:null);
switch (G__35064__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35059,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35067){
var vec__35068 = p__35067;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35068,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35068,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35058){
var self__ = this;
var G__35058__$1 = this;
return (new cljs.core.RecordIter((0),G__35058__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35060,other35061){
var self__ = this;
var this35060__$1 = this;
return (((!((other35061 == null)))) && ((((this35060__$1.constructor === other35061.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35060__$1.x,other35061.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35060__$1.y,other35061.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35060__$1.__extmap,other35061.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35059){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35090 = k35059;
var G__35090__$1 = (((G__35090 instanceof cljs.core.Keyword))?G__35090.fqn:null);
switch (G__35090__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35059);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35058){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35096 = cljs.core.keyword_identical_QMARK_;
var expr__35097 = k__5352__auto__;
if(cljs.core.truth_((pred__35096.cljs$core$IFn$_invoke$arity$2 ? pred__35096.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35097) : pred__35096.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35097)))){
return (new shadow.dom.Coordinate(G__35058,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35096.cljs$core$IFn$_invoke$arity$2 ? pred__35096.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35097) : pred__35096.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35097)))){
return (new shadow.dom.Coordinate(self__.x,G__35058,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35058),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35058){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35058,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35062){
var extmap__5385__auto__ = (function (){var G__35113 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35062,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__35062)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35113);
} else {
return G__35113;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35062),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35062),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35148,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35167 = k35148;
var G__35167__$1 = (((G__35167 instanceof cljs.core.Keyword))?G__35167.fqn:null);
switch (G__35167__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35148,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35172){
var vec__35173 = p__35172;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35173,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35173,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35147){
var self__ = this;
var G__35147__$1 = this;
return (new cljs.core.RecordIter((0),G__35147__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35149,other35150){
var self__ = this;
var this35149__$1 = this;
return (((!((other35150 == null)))) && ((((this35149__$1.constructor === other35150.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35149__$1.w,other35150.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35149__$1.h,other35150.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35149__$1.__extmap,other35150.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35148){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35204 = k35148;
var G__35204__$1 = (((G__35204 instanceof cljs.core.Keyword))?G__35204.fqn:null);
switch (G__35204__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35148);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35147){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35205 = cljs.core.keyword_identical_QMARK_;
var expr__35206 = k__5352__auto__;
if(cljs.core.truth_((pred__35205.cljs$core$IFn$_invoke$arity$2 ? pred__35205.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35206) : pred__35205.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35206)))){
return (new shadow.dom.Size(G__35147,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35205.cljs$core$IFn$_invoke$arity$2 ? pred__35205.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35206) : pred__35205.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35206)))){
return (new shadow.dom.Size(self__.w,G__35147,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35147),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35147){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35147,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35156){
var extmap__5385__auto__ = (function (){var G__35211 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35156,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35156)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35211);
} else {
return G__35211;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35156),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35156),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__35913 = (i + (1));
var G__35914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35913;
ret = G__35914;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35248){
var vec__35250 = p__35248;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35250,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35250,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35257 = arguments.length;
switch (G__35257) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35918 = ps;
var G__35919 = (i + (1));
el__$1 = G__35918;
i = G__35919;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35291 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35291,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35291,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35291,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35296_35927 = cljs.core.seq(props);
var chunk__35297_35928 = null;
var count__35298_35929 = (0);
var i__35299_35930 = (0);
while(true){
if((i__35299_35930 < count__35298_35929)){
var vec__35313_35931 = chunk__35297_35928.cljs$core$IIndexed$_nth$arity$2(null,i__35299_35930);
var k_35932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35313_35931,(0),null);
var v_35933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35313_35931,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_35932);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35932),v_35933);


var G__35934 = seq__35296_35927;
var G__35935 = chunk__35297_35928;
var G__35936 = count__35298_35929;
var G__35937 = (i__35299_35930 + (1));
seq__35296_35927 = G__35934;
chunk__35297_35928 = G__35935;
count__35298_35929 = G__35936;
i__35299_35930 = G__35937;
continue;
} else {
var temp__5804__auto___35938 = cljs.core.seq(seq__35296_35927);
if(temp__5804__auto___35938){
var seq__35296_35939__$1 = temp__5804__auto___35938;
if(cljs.core.chunked_seq_QMARK_(seq__35296_35939__$1)){
var c__5568__auto___35940 = cljs.core.chunk_first(seq__35296_35939__$1);
var G__35941 = cljs.core.chunk_rest(seq__35296_35939__$1);
var G__35942 = c__5568__auto___35940;
var G__35943 = cljs.core.count(c__5568__auto___35940);
var G__35944 = (0);
seq__35296_35927 = G__35941;
chunk__35297_35928 = G__35942;
count__35298_35929 = G__35943;
i__35299_35930 = G__35944;
continue;
} else {
var vec__35319_35948 = cljs.core.first(seq__35296_35939__$1);
var k_35949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35319_35948,(0),null);
var v_35950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35319_35948,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35949);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35949),v_35950);


var G__35951 = cljs.core.next(seq__35296_35939__$1);
var G__35952 = null;
var G__35953 = (0);
var G__35954 = (0);
seq__35296_35927 = G__35951;
chunk__35297_35928 = G__35952;
count__35298_35929 = G__35953;
i__35299_35930 = G__35954;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35331 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35331,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35331,(1),null);
var seq__35335_35955 = cljs.core.seq(node_children);
var chunk__35338_35956 = null;
var count__35339_35957 = (0);
var i__35340_35958 = (0);
while(true){
if((i__35340_35958 < count__35339_35957)){
var child_struct_35959 = chunk__35338_35956.cljs$core$IIndexed$_nth$arity$2(null,i__35340_35958);
if((!((child_struct_35959 == null)))){
if(typeof child_struct_35959 === 'string'){
var text_35960 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35960),child_struct_35959].join(''));
} else {
var children_35961 = shadow.dom.svg_node(child_struct_35959);
if(cljs.core.seq_QMARK_(children_35961)){
var seq__35404_35962 = cljs.core.seq(children_35961);
var chunk__35406_35963 = null;
var count__35407_35964 = (0);
var i__35408_35965 = (0);
while(true){
if((i__35408_35965 < count__35407_35964)){
var child_35970 = chunk__35406_35963.cljs$core$IIndexed$_nth$arity$2(null,i__35408_35965);
if(cljs.core.truth_(child_35970)){
node.appendChild(child_35970);


var G__35971 = seq__35404_35962;
var G__35972 = chunk__35406_35963;
var G__35973 = count__35407_35964;
var G__35974 = (i__35408_35965 + (1));
seq__35404_35962 = G__35971;
chunk__35406_35963 = G__35972;
count__35407_35964 = G__35973;
i__35408_35965 = G__35974;
continue;
} else {
var G__35975 = seq__35404_35962;
var G__35976 = chunk__35406_35963;
var G__35977 = count__35407_35964;
var G__35978 = (i__35408_35965 + (1));
seq__35404_35962 = G__35975;
chunk__35406_35963 = G__35976;
count__35407_35964 = G__35977;
i__35408_35965 = G__35978;
continue;
}
} else {
var temp__5804__auto___35979 = cljs.core.seq(seq__35404_35962);
if(temp__5804__auto___35979){
var seq__35404_35983__$1 = temp__5804__auto___35979;
if(cljs.core.chunked_seq_QMARK_(seq__35404_35983__$1)){
var c__5568__auto___35984 = cljs.core.chunk_first(seq__35404_35983__$1);
var G__35985 = cljs.core.chunk_rest(seq__35404_35983__$1);
var G__35986 = c__5568__auto___35984;
var G__35987 = cljs.core.count(c__5568__auto___35984);
var G__35988 = (0);
seq__35404_35962 = G__35985;
chunk__35406_35963 = G__35986;
count__35407_35964 = G__35987;
i__35408_35965 = G__35988;
continue;
} else {
var child_35989 = cljs.core.first(seq__35404_35983__$1);
if(cljs.core.truth_(child_35989)){
node.appendChild(child_35989);


var G__35990 = cljs.core.next(seq__35404_35983__$1);
var G__35991 = null;
var G__35992 = (0);
var G__35993 = (0);
seq__35404_35962 = G__35990;
chunk__35406_35963 = G__35991;
count__35407_35964 = G__35992;
i__35408_35965 = G__35993;
continue;
} else {
var G__35994 = cljs.core.next(seq__35404_35983__$1);
var G__35995 = null;
var G__35996 = (0);
var G__35997 = (0);
seq__35404_35962 = G__35994;
chunk__35406_35963 = G__35995;
count__35407_35964 = G__35996;
i__35408_35965 = G__35997;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35961);
}
}


var G__35999 = seq__35335_35955;
var G__36000 = chunk__35338_35956;
var G__36001 = count__35339_35957;
var G__36002 = (i__35340_35958 + (1));
seq__35335_35955 = G__35999;
chunk__35338_35956 = G__36000;
count__35339_35957 = G__36001;
i__35340_35958 = G__36002;
continue;
} else {
var G__36006 = seq__35335_35955;
var G__36007 = chunk__35338_35956;
var G__36008 = count__35339_35957;
var G__36009 = (i__35340_35958 + (1));
seq__35335_35955 = G__36006;
chunk__35338_35956 = G__36007;
count__35339_35957 = G__36008;
i__35340_35958 = G__36009;
continue;
}
} else {
var temp__5804__auto___36010 = cljs.core.seq(seq__35335_35955);
if(temp__5804__auto___36010){
var seq__35335_36011__$1 = temp__5804__auto___36010;
if(cljs.core.chunked_seq_QMARK_(seq__35335_36011__$1)){
var c__5568__auto___36012 = cljs.core.chunk_first(seq__35335_36011__$1);
var G__36013 = cljs.core.chunk_rest(seq__35335_36011__$1);
var G__36014 = c__5568__auto___36012;
var G__36015 = cljs.core.count(c__5568__auto___36012);
var G__36016 = (0);
seq__35335_35955 = G__36013;
chunk__35338_35956 = G__36014;
count__35339_35957 = G__36015;
i__35340_35958 = G__36016;
continue;
} else {
var child_struct_36017 = cljs.core.first(seq__35335_36011__$1);
if((!((child_struct_36017 == null)))){
if(typeof child_struct_36017 === 'string'){
var text_36018 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36018),child_struct_36017].join(''));
} else {
var children_36019 = shadow.dom.svg_node(child_struct_36017);
if(cljs.core.seq_QMARK_(children_36019)){
var seq__35422_36020 = cljs.core.seq(children_36019);
var chunk__35424_36021 = null;
var count__35425_36022 = (0);
var i__35426_36023 = (0);
while(true){
if((i__35426_36023 < count__35425_36022)){
var child_36024 = chunk__35424_36021.cljs$core$IIndexed$_nth$arity$2(null,i__35426_36023);
if(cljs.core.truth_(child_36024)){
node.appendChild(child_36024);


var G__36025 = seq__35422_36020;
var G__36026 = chunk__35424_36021;
var G__36027 = count__35425_36022;
var G__36028 = (i__35426_36023 + (1));
seq__35422_36020 = G__36025;
chunk__35424_36021 = G__36026;
count__35425_36022 = G__36027;
i__35426_36023 = G__36028;
continue;
} else {
var G__36029 = seq__35422_36020;
var G__36030 = chunk__35424_36021;
var G__36031 = count__35425_36022;
var G__36033 = (i__35426_36023 + (1));
seq__35422_36020 = G__36029;
chunk__35424_36021 = G__36030;
count__35425_36022 = G__36031;
i__35426_36023 = G__36033;
continue;
}
} else {
var temp__5804__auto___36036__$1 = cljs.core.seq(seq__35422_36020);
if(temp__5804__auto___36036__$1){
var seq__35422_36037__$1 = temp__5804__auto___36036__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35422_36037__$1)){
var c__5568__auto___36038 = cljs.core.chunk_first(seq__35422_36037__$1);
var G__36039 = cljs.core.chunk_rest(seq__35422_36037__$1);
var G__36040 = c__5568__auto___36038;
var G__36041 = cljs.core.count(c__5568__auto___36038);
var G__36042 = (0);
seq__35422_36020 = G__36039;
chunk__35424_36021 = G__36040;
count__35425_36022 = G__36041;
i__35426_36023 = G__36042;
continue;
} else {
var child_36043 = cljs.core.first(seq__35422_36037__$1);
if(cljs.core.truth_(child_36043)){
node.appendChild(child_36043);


var G__36044 = cljs.core.next(seq__35422_36037__$1);
var G__36045 = null;
var G__36046 = (0);
var G__36047 = (0);
seq__35422_36020 = G__36044;
chunk__35424_36021 = G__36045;
count__35425_36022 = G__36046;
i__35426_36023 = G__36047;
continue;
} else {
var G__36048 = cljs.core.next(seq__35422_36037__$1);
var G__36049 = null;
var G__36050 = (0);
var G__36051 = (0);
seq__35422_36020 = G__36048;
chunk__35424_36021 = G__36049;
count__35425_36022 = G__36050;
i__35426_36023 = G__36051;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36019);
}
}


var G__36052 = cljs.core.next(seq__35335_36011__$1);
var G__36053 = null;
var G__36054 = (0);
var G__36055 = (0);
seq__35335_35955 = G__36052;
chunk__35338_35956 = G__36053;
count__35339_35957 = G__36054;
i__35340_35958 = G__36055;
continue;
} else {
var G__36056 = cljs.core.next(seq__35335_36011__$1);
var G__36057 = null;
var G__36058 = (0);
var G__36059 = (0);
seq__35335_35955 = G__36056;
chunk__35338_35956 = G__36057;
count__35339_35957 = G__36058;
i__35340_35958 = G__36059;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36060 = arguments.length;
var i__5770__auto___36061 = (0);
while(true){
if((i__5770__auto___36061 < len__5769__auto___36060)){
args__5775__auto__.push((arguments[i__5770__auto___36061]));

var G__36063 = (i__5770__auto___36061 + (1));
i__5770__auto___36061 = G__36063;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35441){
var G__35442 = cljs.core.first(seq35441);
var seq35441__$1 = cljs.core.next(seq35441);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35442,seq35441__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35454 = arguments.length;
switch (G__35454) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30937__auto___36068 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_35469){
var state_val_35470 = (state_35469[(1)]);
if((state_val_35470 === (1))){
var state_35469__$1 = state_35469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35469__$1,(2),once_or_cleanup);
} else {
if((state_val_35470 === (2))){
var inst_35466 = (state_35469[(2)]);
var inst_35467 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35469__$1 = (function (){var statearr_35473 = state_35469;
(statearr_35473[(7)] = inst_35466);

return statearr_35473;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35469__$1,inst_35467);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__30481__auto__ = null;
var shadow$dom$state_machine__30481__auto____0 = (function (){
var statearr_35479 = [null,null,null,null,null,null,null,null];
(statearr_35479[(0)] = shadow$dom$state_machine__30481__auto__);

(statearr_35479[(1)] = (1));

return statearr_35479;
});
var shadow$dom$state_machine__30481__auto____1 = (function (state_35469){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_35469);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e35480){var ex__30484__auto__ = e35480;
var statearr_35481_36069 = state_35469;
(statearr_35481_36069[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_35469[(4)]))){
var statearr_35482_36070 = state_35469;
(statearr_35482_36070[(1)] = cljs.core.first((state_35469[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36071 = state_35469;
state_35469 = G__36071;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
shadow$dom$state_machine__30481__auto__ = function(state_35469){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__30481__auto____0.call(this);
case 1:
return shadow$dom$state_machine__30481__auto____1.call(this,state_35469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__30481__auto____0;
shadow$dom$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__30481__auto____1;
return shadow$dom$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_35485 = f__30938__auto__();
(statearr_35485[(6)] = c__30937__auto___36068);

return statearr_35485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
