goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39760__39761__auto__){
if((!((p1__39760__39761__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39760__39761__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39760__39761__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39760__39761__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39760__39761__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___53888 = schema.utils.use_fn_validation;
var output_schema52941_53889 = deercreeklabs.lancaster.LancasterSchema;
var input_schema52942_53890 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker52943_53891 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52942_53890);
}),null));
var output_checker52944_53892 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52941_53889);
}),null));
var ret__40629__auto___53893 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__52945){
var validate__38023__auto__ = cljs.core.deref(ufv___53888);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___53894 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52945], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52958_53895 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52959_53896 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__52960_53897 = input_schema52942_53890;
var G__52961_53898 = cljs.core.deref(input_checker52943_53891);
var G__52962_53899 = args__38024__auto___53894;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52958_53895,G__52959_53896,G__52960_53897,G__52961_53898,G__52962_53899) : schema.core.fn_validator.call(null,G__52958_53895,G__52959_53896,G__52960_53897,G__52961_53898,G__52962_53899));
} else {
var temp__5804__auto___53900 = (function (){var fexpr__52967 = cljs.core.deref(input_checker52943_53891);
return (fexpr__52967.cljs$core$IFn$_invoke$arity$1 ? fexpr__52967.cljs$core$IFn$_invoke$arity$1(args__38024__auto___53894) : fexpr__52967.call(null,args__38024__auto___53894));
})();
if(cljs.core.truth_(temp__5804__auto___53900)){
var error__38025__auto___53901 = temp__5804__auto___53900;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53901], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52942_53890,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___53894,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53901], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var json = G__52945;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52972_53905 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52973_53906 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__52974_53907 = output_schema52941_53889;
var G__52975_53908 = cljs.core.deref(output_checker52944_53892);
var G__52976_53909 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52972_53905,G__52973_53906,G__52974_53907,G__52975_53908,G__52976_53909) : schema.core.fn_validator.call(null,G__52972_53905,G__52973_53906,G__52974_53907,G__52975_53908,G__52976_53909));
} else {
var temp__5804__auto___53912 = (function (){var fexpr__52978 = cljs.core.deref(output_checker52944_53892);
return (fexpr__52978.cljs$core$IFn$_invoke$arity$1 ? fexpr__52978.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__52978.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53912)){
var error__38025__auto___53913 = temp__5804__auto___53912;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53913], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52941_53889,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53913], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema52941_53889,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52942_53890], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___53914 = schema.utils.use_fn_validation;
var output_schema52985_53915 = deercreeklabs.lancaster.LancasterSchema;
var input_schema52986_53916 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema52991_53917 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker52987_53918 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52986_53916);
}),null));
var output_checker52988_53919 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52985_53915);
}),null));
var input_checker52992_53920 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52991_53917);
}),null));
var output_checker52993_53921 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52985_53915);
}),null));
var ret__40629__auto___53925 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__53003 = arguments.length;
switch (G__53003) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__52989,G__52990){
var validate__38023__auto__ = cljs.core.deref(ufv___53914);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___53931 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52989,G__52990], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53005_53932 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53006_53933 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53007_53934 = input_schema52986_53916;
var G__53008_53935 = cljs.core.deref(input_checker52987_53918);
var G__53009_53936 = args__38024__auto___53931;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53005_53932,G__53006_53933,G__53007_53934,G__53008_53935,G__53009_53936) : schema.core.fn_validator.call(null,G__53005_53932,G__53006_53933,G__53007_53934,G__53008_53935,G__53009_53936));
} else {
var temp__5804__auto___53940 = (function (){var fexpr__53010 = cljs.core.deref(input_checker52987_53918);
return (fexpr__53010.cljs$core$IFn$_invoke$arity$1 ? fexpr__53010.cljs$core$IFn$_invoke$arity$1(args__38024__auto___53931) : fexpr__53010.call(null,args__38024__auto___53931));
})();
if(cljs.core.truth_(temp__5804__auto___53940)){
var error__38025__auto___53941 = temp__5804__auto___53940;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53941], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52986_53916,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___53931,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53941], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var name_kw = G__52989;
var fields = G__52990;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53012_53945 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53013_53946 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53014_53947 = output_schema52985_53915;
var G__53015_53948 = cljs.core.deref(output_checker52988_53919);
var G__53016_53949 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53012_53945,G__53013_53946,G__53014_53947,G__53015_53948,G__53016_53949) : schema.core.fn_validator.call(null,G__53012_53945,G__53013_53946,G__53014_53947,G__53015_53948,G__53016_53949));
} else {
var temp__5804__auto___53950 = (function (){var fexpr__53017 = cljs.core.deref(output_checker52988_53919);
return (fexpr__53017.cljs$core$IFn$_invoke$arity$1 ? fexpr__53017.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53017.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53950)){
var error__38025__auto___53951 = temp__5804__auto___53950;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53951], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52985_53915,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53951], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__52994,G__52995,G__52996){
var validate__38023__auto__ = cljs.core.deref(ufv___53914);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___53959 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52994,G__52995,G__52996], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53021_53960 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53022_53961 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53023_53962 = input_schema52991_53917;
var G__53024_53963 = cljs.core.deref(input_checker52992_53920);
var G__53025_53964 = args__38024__auto___53959;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53021_53960,G__53022_53961,G__53023_53962,G__53024_53963,G__53025_53964) : schema.core.fn_validator.call(null,G__53021_53960,G__53022_53961,G__53023_53962,G__53024_53963,G__53025_53964));
} else {
var temp__5804__auto___53965 = (function (){var fexpr__53027 = cljs.core.deref(input_checker52992_53920);
return (fexpr__53027.cljs$core$IFn$_invoke$arity$1 ? fexpr__53027.cljs$core$IFn$_invoke$arity$1(args__38024__auto___53959) : fexpr__53027.call(null,args__38024__auto___53959));
})();
if(cljs.core.truth_(temp__5804__auto___53965)){
var error__38025__auto___53968 = temp__5804__auto___53965;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53968], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52991_53917,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___53959,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53968], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var name_kw = G__52994;
var docstring = G__52995;
var fields = G__52996;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53028_53969 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53029_53970 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53030_53971 = output_schema52985_53915;
var G__53031_53972 = cljs.core.deref(output_checker52993_53921);
var G__53032_53973 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53028_53969,G__53029_53970,G__53030_53971,G__53031_53972,G__53032_53973) : schema.core.fn_validator.call(null,G__53028_53969,G__53029_53970,G__53030_53971,G__53031_53972,G__53032_53973));
} else {
var temp__5804__auto___53974 = (function (){var fexpr__53034 = cljs.core.deref(output_checker52993_53921);
return (fexpr__53034.cljs$core$IFn$_invoke$arity$1 ? fexpr__53034.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53034.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53974)){
var error__38025__auto___53975 = temp__5804__auto___53974;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53975], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52985_53915,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53975], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema52985_53915,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52986_53916,input_schema52991_53917], null)));

var ufv___53976 = schema.utils.use_fn_validation;
var output_schema53044_53977 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53045_53978 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema53050_53979 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53046_53980 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53045_53978);
}),null));
var output_checker53047_53981 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53044_53977);
}),null));
var input_checker53051_53982 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53050_53979);
}),null));
var output_checker53052_53983 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53044_53977);
}),null));
var ret__40629__auto___53987 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__53067 = arguments.length;
switch (G__53067) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53048,G__53049){
var validate__38023__auto__ = cljs.core.deref(ufv___53976);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___53989 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53048,G__53049], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53068_53990 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53069_53991 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53070_53992 = input_schema53045_53978;
var G__53071_53993 = cljs.core.deref(input_checker53046_53980);
var G__53072_53994 = args__38024__auto___53989;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53068_53990,G__53069_53991,G__53070_53992,G__53071_53993,G__53072_53994) : schema.core.fn_validator.call(null,G__53068_53990,G__53069_53991,G__53070_53992,G__53071_53993,G__53072_53994));
} else {
var temp__5804__auto___53995 = (function (){var fexpr__53073 = cljs.core.deref(input_checker53046_53980);
return (fexpr__53073.cljs$core$IFn$_invoke$arity$1 ? fexpr__53073.cljs$core$IFn$_invoke$arity$1(args__38024__auto___53989) : fexpr__53073.call(null,args__38024__auto___53989));
})();
if(cljs.core.truth_(temp__5804__auto___53995)){
var error__38025__auto___53996 = temp__5804__auto___53995;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___53996], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53045_53978,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___53989,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___53996], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var name_kw = G__53048;
var symbol_keywords = G__53049;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53078_53997 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53079_53998 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53080_53999 = output_schema53044_53977;
var G__53081_54000 = cljs.core.deref(output_checker53047_53981);
var G__53082_54001 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53078_53997,G__53079_53998,G__53080_53999,G__53081_54000,G__53082_54001) : schema.core.fn_validator.call(null,G__53078_53997,G__53079_53998,G__53080_53999,G__53081_54000,G__53082_54001));
} else {
var temp__5804__auto___54002 = (function (){var fexpr__53084 = cljs.core.deref(output_checker53047_53981);
return (fexpr__53084.cljs$core$IFn$_invoke$arity$1 ? fexpr__53084.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53084.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54002)){
var error__38025__auto___54003 = temp__5804__auto___54002;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54003], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53044_53977,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54003], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53053,G__53054,G__53055){
var validate__38023__auto__ = cljs.core.deref(ufv___53976);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54006 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53053,G__53054,G__53055], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53086_54007 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53087_54008 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53088_54009 = input_schema53050_53979;
var G__53089_54010 = cljs.core.deref(input_checker53051_53982);
var G__53090_54011 = args__38024__auto___54006;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53086_54007,G__53087_54008,G__53088_54009,G__53089_54010,G__53090_54011) : schema.core.fn_validator.call(null,G__53086_54007,G__53087_54008,G__53088_54009,G__53089_54010,G__53090_54011));
} else {
var temp__5804__auto___54012 = (function (){var fexpr__53091 = cljs.core.deref(input_checker53051_53982);
return (fexpr__53091.cljs$core$IFn$_invoke$arity$1 ? fexpr__53091.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54006) : fexpr__53091.call(null,args__38024__auto___54006));
})();
if(cljs.core.truth_(temp__5804__auto___54012)){
var error__38025__auto___54013 = temp__5804__auto___54012;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54013], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53050_53979,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54006,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54013], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var name_kw = G__53053;
var docstring = G__53054;
var symbol_keywords = G__53055;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53096_54017 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53097_54018 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53098_54019 = output_schema53044_53977;
var G__53099_54020 = cljs.core.deref(output_checker53052_53983);
var G__53100_54021 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53096_54017,G__53097_54018,G__53098_54019,G__53099_54020,G__53100_54021) : schema.core.fn_validator.call(null,G__53096_54017,G__53097_54018,G__53098_54019,G__53099_54020,G__53100_54021));
} else {
var temp__5804__auto___54022 = (function (){var fexpr__53101 = cljs.core.deref(output_checker53052_53983);
return (fexpr__53101.cljs$core$IFn$_invoke$arity$1 ? fexpr__53101.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53101.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54022)){
var error__38025__auto___54023 = temp__5804__auto___54022;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54023], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53044_53977,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54023], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema53044_53977,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53045_53978,input_schema53050_53979], null)));

var ufv___54024 = schema.utils.use_fn_validation;
var output_schema53102_54025 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53103_54026 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53104_54027 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53103_54026);
}),null));
var output_checker53105_54028 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53102_54025);
}),null));
var ret__40629__auto___54029 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__53106,G__53107){
var validate__38023__auto__ = cljs.core.deref(ufv___54024);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54030 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53106,G__53107], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53113_54031 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53114_54032 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53115_54033 = input_schema53103_54026;
var G__53116_54034 = cljs.core.deref(input_checker53104_54027);
var G__53117_54035 = args__38024__auto___54030;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53113_54031,G__53114_54032,G__53115_54033,G__53116_54034,G__53117_54035) : schema.core.fn_validator.call(null,G__53113_54031,G__53114_54032,G__53115_54033,G__53116_54034,G__53117_54035));
} else {
var temp__5804__auto___54036 = (function (){var fexpr__53122 = cljs.core.deref(input_checker53104_54027);
return (fexpr__53122.cljs$core$IFn$_invoke$arity$1 ? fexpr__53122.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54030) : fexpr__53122.call(null,args__38024__auto___54030));
})();
if(cljs.core.truth_(temp__5804__auto___54036)){
var error__38025__auto___54037 = temp__5804__auto___54036;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54037], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53103_54026,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54030,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54037], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var name_kw = G__53106;
var size = G__53107;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53127_54038 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53128_54039 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53129_54040 = output_schema53102_54025;
var G__53130_54041 = cljs.core.deref(output_checker53105_54028);
var G__53131_54042 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53127_54038,G__53128_54039,G__53129_54040,G__53130_54041,G__53131_54042) : schema.core.fn_validator.call(null,G__53127_54038,G__53128_54039,G__53129_54040,G__53130_54041,G__53131_54042));
} else {
var temp__5804__auto___54043 = (function (){var fexpr__53132 = cljs.core.deref(output_checker53105_54028);
return (fexpr__53132.cljs$core$IFn$_invoke$arity$1 ? fexpr__53132.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53132.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54043)){
var error__38025__auto___54044 = temp__5804__auto___54043;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54044], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53102_54025,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54044], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema53102_54025,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53103_54026], null)));

var ufv___54045 = schema.utils.use_fn_validation;
var output_schema53133_54046 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53134_54047 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53135_54048 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53134_54047);
}),null));
var output_checker53136_54049 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53133_54046);
}),null));
var ret__40629__auto___54050 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__53137){
var validate__38023__auto__ = cljs.core.deref(ufv___54045);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54051 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53137], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53139_54052 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53140_54053 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53141_54054 = input_schema53134_54047;
var G__53142_54055 = cljs.core.deref(input_checker53135_54048);
var G__53143_54056 = args__38024__auto___54051;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53139_54052,G__53140_54053,G__53141_54054,G__53142_54055,G__53143_54056) : schema.core.fn_validator.call(null,G__53139_54052,G__53140_54053,G__53141_54054,G__53142_54055,G__53143_54056));
} else {
var temp__5804__auto___54057 = (function (){var fexpr__53144 = cljs.core.deref(input_checker53135_54048);
return (fexpr__53144.cljs$core$IFn$_invoke$arity$1 ? fexpr__53144.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54051) : fexpr__53144.call(null,args__38024__auto___54051));
})();
if(cljs.core.truth_(temp__5804__auto___54057)){
var error__38025__auto___54058 = temp__5804__auto___54057;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54058], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53134_54047,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54051,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54058], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var items_schema = G__53137;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53149_54059 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53150_54060 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53151_54061 = output_schema53133_54046;
var G__53152_54062 = cljs.core.deref(output_checker53136_54049);
var G__53153_54063 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53149_54059,G__53150_54060,G__53151_54061,G__53152_54062,G__53153_54063) : schema.core.fn_validator.call(null,G__53149_54059,G__53150_54060,G__53151_54061,G__53152_54062,G__53153_54063));
} else {
var temp__5804__auto___54064 = (function (){var fexpr__53154 = cljs.core.deref(output_checker53136_54049);
return (fexpr__53154.cljs$core$IFn$_invoke$arity$1 ? fexpr__53154.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53154.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54064)){
var error__38025__auto___54065 = temp__5804__auto___54064;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54065], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53133_54046,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54065], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema53133_54046,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53134_54047], null)));

var ufv___54066 = schema.utils.use_fn_validation;
var output_schema53156_54067 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53157_54068 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53158_54069 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53157_54068);
}),null));
var output_checker53159_54070 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53156_54067);
}),null));
var ret__40629__auto___54071 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__53160){
var validate__38023__auto__ = cljs.core.deref(ufv___54066);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54072 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53160], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53162_54073 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53163_54074 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53164_54075 = input_schema53157_54068;
var G__53165_54076 = cljs.core.deref(input_checker53158_54069);
var G__53166_54077 = args__38024__auto___54072;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53162_54073,G__53163_54074,G__53164_54075,G__53165_54076,G__53166_54077) : schema.core.fn_validator.call(null,G__53162_54073,G__53163_54074,G__53164_54075,G__53165_54076,G__53166_54077));
} else {
var temp__5804__auto___54078 = (function (){var fexpr__53170 = cljs.core.deref(input_checker53158_54069);
return (fexpr__53170.cljs$core$IFn$_invoke$arity$1 ? fexpr__53170.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54072) : fexpr__53170.call(null,args__38024__auto___54072));
})();
if(cljs.core.truth_(temp__5804__auto___54078)){
var error__38025__auto___54079 = temp__5804__auto___54078;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54079], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53157_54068,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54072,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54079], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var values_schema = G__53160;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53171_54080 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53172_54081 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53173_54082 = output_schema53156_54067;
var G__53174_54083 = cljs.core.deref(output_checker53159_54070);
var G__53175_54084 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53171_54080,G__53172_54081,G__53173_54082,G__53174_54083,G__53175_54084) : schema.core.fn_validator.call(null,G__53171_54080,G__53172_54081,G__53173_54082,G__53174_54083,G__53175_54084));
} else {
var temp__5804__auto___54085 = (function (){var fexpr__53176 = cljs.core.deref(output_checker53159_54070);
return (fexpr__53176.cljs$core$IFn$_invoke$arity$1 ? fexpr__53176.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53176.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54085)){
var error__38025__auto___54086 = temp__5804__auto___54085;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54086], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53156_54067,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54086], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema53156_54067,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53157_54068], null)));

var ufv___54087 = schema.utils.use_fn_validation;
var output_schema53177_54088 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53178_54089 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker53179_54090 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53178_54089);
}),null));
var output_checker53180_54091 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53177_54088);
}),null));
var ret__40629__auto___54092 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__53181){
var validate__38023__auto__ = cljs.core.deref(ufv___54087);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54093 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53181], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53189_54094 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53190_54095 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53191_54096 = input_schema53178_54089;
var G__53192_54097 = cljs.core.deref(input_checker53179_54090);
var G__53193_54098 = args__38024__auto___54093;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53189_54094,G__53190_54095,G__53191_54096,G__53192_54097,G__53193_54098) : schema.core.fn_validator.call(null,G__53189_54094,G__53190_54095,G__53191_54096,G__53192_54097,G__53193_54098));
} else {
var temp__5804__auto___54099 = (function (){var fexpr__53196 = cljs.core.deref(input_checker53179_54090);
return (fexpr__53196.cljs$core$IFn$_invoke$arity$1 ? fexpr__53196.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54093) : fexpr__53196.call(null,args__38024__auto___54093));
})();
if(cljs.core.truth_(temp__5804__auto___54099)){
var error__38025__auto___54100 = temp__5804__auto___54099;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54100], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53178_54089,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54093,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54100], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var member_schemas = G__53181;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53205_54101 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53206_54102 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53207_54103 = output_schema53177_54088;
var G__53208_54104 = cljs.core.deref(output_checker53180_54091);
var G__53209_54105 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53205_54101,G__53206_54102,G__53207_54103,G__53208_54104,G__53209_54105) : schema.core.fn_validator.call(null,G__53205_54101,G__53206_54102,G__53207_54103,G__53208_54104,G__53209_54105));
} else {
var temp__5804__auto___54106 = (function (){var fexpr__53210 = cljs.core.deref(output_checker53180_54091);
return (fexpr__53210.cljs$core$IFn$_invoke$arity$1 ? fexpr__53210.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53210.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54106)){
var error__38025__auto___54107 = temp__5804__auto___54106;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54107], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53177_54088,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54107], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema53177_54088,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53178_54089], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___54108 = schema.utils.use_fn_validation;
var output_schema53212_54109 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53213_54110 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53214_54111 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53213_54110);
}),null));
var output_checker53215_54112 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53212_54109);
}),null));
var ret__40629__auto___54113 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__53216){
var validate__38023__auto__ = cljs.core.deref(ufv___54108);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54114 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53216], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53228_54115 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53229_54116 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53230_54117 = input_schema53213_54110;
var G__53231_54118 = cljs.core.deref(input_checker53214_54111);
var G__53232_54119 = args__38024__auto___54114;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53228_54115,G__53229_54116,G__53230_54117,G__53231_54118,G__53232_54119) : schema.core.fn_validator.call(null,G__53228_54115,G__53229_54116,G__53230_54117,G__53231_54118,G__53232_54119));
} else {
var temp__5804__auto___54120 = (function (){var fexpr__53233 = cljs.core.deref(input_checker53214_54111);
return (fexpr__53233.cljs$core$IFn$_invoke$arity$1 ? fexpr__53233.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54114) : fexpr__53233.call(null,args__38024__auto___54114));
})();
if(cljs.core.truth_(temp__5804__auto___54120)){
var error__38025__auto___54121 = temp__5804__auto___54120;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54121], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53213_54110,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54114,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54121], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53216;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53241_54122 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53242_54123 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53243_54124 = output_schema53212_54109;
var G__53244_54125 = cljs.core.deref(output_checker53215_54112);
var G__53245_54126 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53241_54122,G__53242_54123,G__53243_54124,G__53244_54125,G__53245_54126) : schema.core.fn_validator.call(null,G__53241_54122,G__53242_54123,G__53243_54124,G__53244_54125,G__53245_54126));
} else {
var temp__5804__auto___54127 = (function (){var fexpr__53246 = cljs.core.deref(output_checker53215_54112);
return (fexpr__53246.cljs$core$IFn$_invoke$arity$1 ? fexpr__53246.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53246.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54127)){
var error__38025__auto___54128 = temp__5804__auto___54127;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54128], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53212_54109,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54128], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema53212_54109,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53213_54110], null)));

var ufv___54129 = schema.utils.use_fn_validation;
var output_schema53254_54130 = deercreeklabs.baracus.ByteArray;
var input_schema53255_54131 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53256_54132 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53255_54131);
}),null));
var output_checker53257_54133 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53254_54130);
}),null));
var ret__40629__auto___54134 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__53258,G__53259){
var validate__38023__auto__ = cljs.core.deref(ufv___54129);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54135 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53258,G__53259], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53260_54136 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53261_54137 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53262_54138 = input_schema53255_54131;
var G__53263_54139 = cljs.core.deref(input_checker53256_54132);
var G__53264_54140 = args__38024__auto___54135;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53260_54136,G__53261_54137,G__53262_54138,G__53263_54139,G__53264_54140) : schema.core.fn_validator.call(null,G__53260_54136,G__53261_54137,G__53262_54138,G__53263_54139,G__53264_54140));
} else {
var temp__5804__auto___54141 = (function (){var fexpr__53265 = cljs.core.deref(input_checker53256_54132);
return (fexpr__53265.cljs$core$IFn$_invoke$arity$1 ? fexpr__53265.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54135) : fexpr__53265.call(null,args__38024__auto___54135));
})();
if(cljs.core.truth_(temp__5804__auto___54141)){
var error__38025__auto___54142 = temp__5804__auto___54141;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54142], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53255_54131,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54135,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54142], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var writer_schema = G__53258;
var data = G__53259;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53273_54143 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53274_54144 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53275_54145 = output_schema53254_54130;
var G__53276_54146 = cljs.core.deref(output_checker53257_54133);
var G__53277_54147 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53273_54143,G__53274_54144,G__53275_54145,G__53276_54146,G__53277_54147) : schema.core.fn_validator.call(null,G__53273_54143,G__53274_54144,G__53275_54145,G__53276_54146,G__53277_54147));
} else {
var temp__5804__auto___54148 = (function (){var fexpr__53288 = cljs.core.deref(output_checker53257_54133);
return (fexpr__53288.cljs$core$IFn$_invoke$arity$1 ? fexpr__53288.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53288.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54148)){
var error__38025__auto___54149 = temp__5804__auto___54148;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54149], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53254_54130,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54149], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema53254_54130,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53255_54131], null)));

var ufv___54150 = schema.utils.use_fn_validation;
var output_schema53301_54151 = schema.core.Any;
var input_schema53302_54152 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53303_54153 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53302_54152);
}),null));
var output_checker53304_54154 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53301_54151);
}),null));
var ret__40629__auto___54155 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__53305,G__53306,G__53307){
var validate__38023__auto__ = cljs.core.deref(ufv___54150);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54156 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53305,G__53306,G__53307], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53310_54157 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53311_54158 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53312_54159 = input_schema53302_54152;
var G__53313_54160 = cljs.core.deref(input_checker53303_54153);
var G__53314_54161 = args__38024__auto___54156;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53310_54157,G__53311_54158,G__53312_54159,G__53313_54160,G__53314_54161) : schema.core.fn_validator.call(null,G__53310_54157,G__53311_54158,G__53312_54159,G__53313_54160,G__53314_54161));
} else {
var temp__5804__auto___54162 = (function (){var fexpr__53315 = cljs.core.deref(input_checker53303_54153);
return (fexpr__53315.cljs$core$IFn$_invoke$arity$1 ? fexpr__53315.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54156) : fexpr__53315.call(null,args__38024__auto___54156));
})();
if(cljs.core.truth_(temp__5804__auto___54162)){
var error__38025__auto___54164 = temp__5804__auto___54162;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54164], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53302_54152,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54156,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54164], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var reader_schema = G__53305;
var writer_schema = G__53306;
var ba = G__53307;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53327_54170 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53328_54171 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53329_54172 = output_schema53301_54151;
var G__53330_54173 = cljs.core.deref(output_checker53304_54154);
var G__53331_54174 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53327_54170,G__53328_54171,G__53329_54172,G__53330_54173,G__53331_54174) : schema.core.fn_validator.call(null,G__53327_54170,G__53328_54171,G__53329_54172,G__53330_54173,G__53331_54174));
} else {
var temp__5804__auto___54175 = (function (){var fexpr__53332 = cljs.core.deref(output_checker53304_54154);
return (fexpr__53332.cljs$core$IFn$_invoke$arity$1 ? fexpr__53332.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53332.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54175)){
var error__38025__auto___54176 = temp__5804__auto___54175;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54176], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53301_54151,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54176], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema53301_54151,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53302_54152], null)));

var ufv___54177 = schema.utils.use_fn_validation;
var output_schema53336_54178 = schema.core.Any;
var input_schema53337_54179 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53338_54180 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53337_54179);
}),null));
var output_checker53339_54181 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53336_54178);
}),null));
var ret__40629__auto___54183 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__53340,G__53341){
var validate__38023__auto__ = cljs.core.deref(ufv___54177);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54184 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53340,G__53341], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53345_54185 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53346_54186 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53347_54187 = input_schema53337_54179;
var G__53348_54188 = cljs.core.deref(input_checker53338_54180);
var G__53349_54189 = args__38024__auto___54184;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53345_54185,G__53346_54186,G__53347_54187,G__53348_54188,G__53349_54189) : schema.core.fn_validator.call(null,G__53345_54185,G__53346_54186,G__53347_54187,G__53348_54188,G__53349_54189));
} else {
var temp__5804__auto___54191 = (function (){var fexpr__53353 = cljs.core.deref(input_checker53338_54180);
return (fexpr__53353.cljs$core$IFn$_invoke$arity$1 ? fexpr__53353.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54184) : fexpr__53353.call(null,args__38024__auto___54184));
})();
if(cljs.core.truth_(temp__5804__auto___54191)){
var error__38025__auto___54195 = temp__5804__auto___54191;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54195], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53337_54179,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54184,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54195], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53340;
var ba = G__53341;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53360_54197 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53361_54198 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53362_54199 = output_schema53336_54178;
var G__53363_54200 = cljs.core.deref(output_checker53339_54181);
var G__53364_54201 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53360_54197,G__53361_54198,G__53362_54199,G__53363_54200,G__53364_54201) : schema.core.fn_validator.call(null,G__53360_54197,G__53361_54198,G__53362_54199,G__53363_54200,G__53364_54201));
} else {
var temp__5804__auto___54202 = (function (){var fexpr__53371 = cljs.core.deref(output_checker53339_54181);
return (fexpr__53371.cljs$core$IFn$_invoke$arity$1 ? fexpr__53371.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53371.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54202)){
var error__38025__auto___54203 = temp__5804__auto___54202;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54203], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53336_54178,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54203], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema53336_54178,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53337_54179], null)));

var ufv___54206 = schema.utils.use_fn_validation;
var output_schema53382_54207 = schema.core.Any;
var input_schema53383_54208 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53384_54209 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53383_54208);
}),null));
var output_checker53385_54210 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53382_54207);
}),null));
var ret__40629__auto___54211 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__53386){
var validate__38023__auto__ = cljs.core.deref(ufv___54206);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54212 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53386], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53392_54213 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53393_54214 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53394_54215 = input_schema53383_54208;
var G__53395_54216 = cljs.core.deref(input_checker53384_54209);
var G__53396_54217 = args__38024__auto___54212;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53392_54213,G__53393_54214,G__53394_54215,G__53395_54216,G__53396_54217) : schema.core.fn_validator.call(null,G__53392_54213,G__53393_54214,G__53394_54215,G__53395_54216,G__53396_54217));
} else {
var temp__5804__auto___54218 = (function (){var fexpr__53400 = cljs.core.deref(input_checker53384_54209);
return (fexpr__53400.cljs$core$IFn$_invoke$arity$1 ? fexpr__53400.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54212) : fexpr__53400.call(null,args__38024__auto___54212));
})();
if(cljs.core.truth_(temp__5804__auto___54218)){
var error__38025__auto___54219 = temp__5804__auto___54218;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54219], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53383_54208,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54212,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54219], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53386;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53402_54227 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53403_54228 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53404_54229 = output_schema53382_54207;
var G__53405_54230 = cljs.core.deref(output_checker53385_54210);
var G__53406_54231 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53402_54227,G__53403_54228,G__53404_54229,G__53405_54230,G__53406_54231) : schema.core.fn_validator.call(null,G__53402_54227,G__53403_54228,G__53404_54229,G__53405_54230,G__53406_54231));
} else {
var temp__5804__auto___54235 = (function (){var fexpr__53412 = cljs.core.deref(output_checker53385_54210);
return (fexpr__53412.cljs$core$IFn$_invoke$arity$1 ? fexpr__53412.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53412.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54235)){
var error__38025__auto___54237 = temp__5804__auto___54235;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54237], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53382_54207,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54237], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema53382_54207,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53383_54208], null)));

var ufv___54241 = schema.utils.use_fn_validation;
var output_schema53426_54242 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53428_54243 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53429_54244 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53428_54243);
}),null));
var output_checker53430_54245 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53426_54242);
}),null));
var ret__40629__auto___54248 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__53431){
var validate__38023__auto__ = cljs.core.deref(ufv___54241);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54249 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53431], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53450_54250 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53451_54251 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53452_54252 = input_schema53428_54243;
var G__53453_54253 = cljs.core.deref(input_checker53429_54244);
var G__53454_54254 = args__38024__auto___54249;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53450_54250,G__53451_54251,G__53452_54252,G__53453_54253,G__53454_54254) : schema.core.fn_validator.call(null,G__53450_54250,G__53451_54251,G__53452_54252,G__53453_54253,G__53454_54254));
} else {
var temp__5804__auto___54255 = (function (){var fexpr__53455 = cljs.core.deref(input_checker53429_54244);
return (fexpr__53455.cljs$core$IFn$_invoke$arity$1 ? fexpr__53455.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54249) : fexpr__53455.call(null,args__38024__auto___54249));
})();
if(cljs.core.truth_(temp__5804__auto___54255)){
var error__38025__auto___54256 = temp__5804__auto___54255;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54256], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53428_54243,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54249,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54256], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var edn = G__53431;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53456_54261 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53457_54262 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53458_54263 = output_schema53426_54242;
var G__53459_54264 = cljs.core.deref(output_checker53430_54245);
var G__53460_54265 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53456_54261,G__53457_54262,G__53458_54263,G__53459_54264,G__53460_54265) : schema.core.fn_validator.call(null,G__53456_54261,G__53457_54262,G__53458_54263,G__53459_54264,G__53460_54265));
} else {
var temp__5804__auto___54266 = (function (){var fexpr__53461 = cljs.core.deref(output_checker53430_54245);
return (fexpr__53461.cljs$core$IFn$_invoke$arity$1 ? fexpr__53461.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53461.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54266)){
var error__38025__auto___54267 = temp__5804__auto___54266;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54267], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53426_54242,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54267], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema53426_54242,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53428_54243], null)));

var ufv___54272 = schema.utils.use_fn_validation;
var output_schema53465_54273 = schema.core.Str;
var input_schema53466_54274 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53467_54275 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53466_54274);
}),null));
var output_checker53468_54276 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53465_54273);
}),null));
var ret__40629__auto___54277 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__53469){
var validate__38023__auto__ = cljs.core.deref(ufv___54272);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54278 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53469], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53470_54279 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53471_54280 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53472_54281 = input_schema53466_54274;
var G__53473_54282 = cljs.core.deref(input_checker53467_54275);
var G__53474_54283 = args__38024__auto___54278;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53470_54279,G__53471_54280,G__53472_54281,G__53473_54282,G__53474_54283) : schema.core.fn_validator.call(null,G__53470_54279,G__53471_54280,G__53472_54281,G__53473_54282,G__53474_54283));
} else {
var temp__5804__auto___54287 = (function (){var fexpr__53475 = cljs.core.deref(input_checker53467_54275);
return (fexpr__53475.cljs$core$IFn$_invoke$arity$1 ? fexpr__53475.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54278) : fexpr__53475.call(null,args__38024__auto___54278));
})();
if(cljs.core.truth_(temp__5804__auto___54287)){
var error__38025__auto___54289 = temp__5804__auto___54287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54289], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53466_54274,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54278,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54289], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53469;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53479_54290 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53480_54291 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53481_54292 = output_schema53465_54273;
var G__53482_54293 = cljs.core.deref(output_checker53468_54276);
var G__53483_54294 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53479_54290,G__53480_54291,G__53481_54292,G__53482_54293,G__53483_54294) : schema.core.fn_validator.call(null,G__53479_54290,G__53480_54291,G__53481_54292,G__53482_54293,G__53483_54294));
} else {
var temp__5804__auto___54296 = (function (){var fexpr__53484 = cljs.core.deref(output_checker53468_54276);
return (fexpr__53484.cljs$core$IFn$_invoke$arity$1 ? fexpr__53484.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53484.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54296)){
var error__38025__auto___54297 = temp__5804__auto___54296;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54297], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53465_54273,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54297], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema53465_54273,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53466_54274], null)));

var ufv___54298 = schema.utils.use_fn_validation;
var output_schema53485_54299 = schema.core.Keyword;
var input_schema53486_54300 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53487_54301 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53486_54300);
}),null));
var output_checker53488_54302 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53485_54299);
}),null));
var ret__40629__auto___54303 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__53489){
var validate__38023__auto__ = cljs.core.deref(ufv___54298);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54304 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53489], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53493_54305 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53494_54306 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53495_54307 = input_schema53486_54300;
var G__53496_54308 = cljs.core.deref(input_checker53487_54301);
var G__53497_54309 = args__38024__auto___54304;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53493_54305,G__53494_54306,G__53495_54307,G__53496_54308,G__53497_54309) : schema.core.fn_validator.call(null,G__53493_54305,G__53494_54306,G__53495_54307,G__53496_54308,G__53497_54309));
} else {
var temp__5804__auto___54310 = (function (){var fexpr__53498 = cljs.core.deref(input_checker53487_54301);
return (fexpr__53498.cljs$core$IFn$_invoke$arity$1 ? fexpr__53498.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54304) : fexpr__53498.call(null,args__38024__auto___54304));
})();
if(cljs.core.truth_(temp__5804__auto___54310)){
var error__38025__auto___54311 = temp__5804__auto___54310;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54311], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53486_54300,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54304,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54311], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53489;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53499_54313 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53500_54314 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53501_54315 = output_schema53485_54299;
var G__53502_54316 = cljs.core.deref(output_checker53488_54302);
var G__53503_54317 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53499_54313,G__53500_54314,G__53501_54315,G__53502_54316,G__53503_54317) : schema.core.fn_validator.call(null,G__53499_54313,G__53500_54314,G__53501_54315,G__53502_54316,G__53503_54317));
} else {
var temp__5804__auto___54318 = (function (){var fexpr__53504 = cljs.core.deref(output_checker53488_54302);
return (fexpr__53504.cljs$core$IFn$_invoke$arity$1 ? fexpr__53504.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53504.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54318)){
var error__38025__auto___54319 = temp__5804__auto___54318;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54319], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53485_54299,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54319], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema53485_54299,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53486_54300], null)));

var ufv___54320 = schema.utils.use_fn_validation;
var output_schema53509_54321 = schema.core.Str;
var input_schema53510_54322 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53511_54323 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53510_54322);
}),null));
var output_checker53512_54324 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53509_54321);
}),null));
var ret__40629__auto___54325 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__53513){
var validate__38023__auto__ = cljs.core.deref(ufv___54320);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54326 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53513], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53514_54327 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53515_54328 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53516_54329 = input_schema53510_54322;
var G__53517_54330 = cljs.core.deref(input_checker53511_54323);
var G__53518_54331 = args__38024__auto___54326;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53514_54327,G__53515_54328,G__53516_54329,G__53517_54330,G__53518_54331) : schema.core.fn_validator.call(null,G__53514_54327,G__53515_54328,G__53516_54329,G__53517_54330,G__53518_54331));
} else {
var temp__5804__auto___54332 = (function (){var fexpr__53519 = cljs.core.deref(input_checker53511_54323);
return (fexpr__53519.cljs$core$IFn$_invoke$arity$1 ? fexpr__53519.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54326) : fexpr__53519.call(null,args__38024__auto___54326));
})();
if(cljs.core.truth_(temp__5804__auto___54332)){
var error__38025__auto___54333 = temp__5804__auto___54332;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54333], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53510_54322,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54326,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54333], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53513;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53524_54334 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53525_54335 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53526_54336 = output_schema53509_54321;
var G__53527_54337 = cljs.core.deref(output_checker53512_54324);
var G__53528_54338 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53524_54334,G__53525_54335,G__53526_54336,G__53527_54337,G__53528_54338) : schema.core.fn_validator.call(null,G__53524_54334,G__53525_54335,G__53526_54336,G__53527_54337,G__53528_54338));
} else {
var temp__5804__auto___54339 = (function (){var fexpr__53529 = cljs.core.deref(output_checker53512_54324);
return (fexpr__53529.cljs$core$IFn$_invoke$arity$1 ? fexpr__53529.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53529.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54339)){
var error__38025__auto___54340 = temp__5804__auto___54339;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54340], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53509_54321,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54340], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema53509_54321,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53510_54322], null)));

var ufv___54342 = schema.utils.use_fn_validation;
var output_schema53530_54343 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema53531_54344 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53532_54345 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53531_54344);
}),null));
var output_checker53533_54346 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53530_54343);
}),null));
var ret__40629__auto___54348 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__53534){
var validate__38023__auto__ = cljs.core.deref(ufv___54342);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54349 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53534], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53538_54350 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53539_54351 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53540_54352 = input_schema53531_54344;
var G__53541_54353 = cljs.core.deref(input_checker53532_54345);
var G__53542_54354 = args__38024__auto___54349;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53538_54350,G__53539_54351,G__53540_54352,G__53541_54353,G__53542_54354) : schema.core.fn_validator.call(null,G__53538_54350,G__53539_54351,G__53540_54352,G__53541_54353,G__53542_54354));
} else {
var temp__5804__auto___54358 = (function (){var fexpr__53543 = cljs.core.deref(input_checker53532_54345);
return (fexpr__53543.cljs$core$IFn$_invoke$arity$1 ? fexpr__53543.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54349) : fexpr__53543.call(null,args__38024__auto___54349));
})();
if(cljs.core.truth_(temp__5804__auto___54358)){
var error__38025__auto___54360 = temp__5804__auto___54358;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54360], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53531_54344,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54349,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54360], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53534;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53544_54363 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53545_54364 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53546_54365 = output_schema53530_54343;
var G__53547_54366 = cljs.core.deref(output_checker53533_54346);
var G__53548_54367 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53544_54363,G__53545_54364,G__53546_54365,G__53547_54366,G__53548_54367) : schema.core.fn_validator.call(null,G__53544_54363,G__53545_54364,G__53546_54365,G__53547_54366,G__53548_54367));
} else {
var temp__5804__auto___54368 = (function (){var fexpr__53549 = cljs.core.deref(output_checker53533_54346);
return (fexpr__53549.cljs$core$IFn$_invoke$arity$1 ? fexpr__53549.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53549.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54368)){
var error__38025__auto___54369 = temp__5804__auto___54368;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54369], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53530_54343,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54369], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema53530_54343,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53531_54344], null)));

var ufv___54371 = schema.utils.use_fn_validation;
var output_schema53553_54372 = deercreeklabs.baracus.ByteArray;
var input_schema53554_54373 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53555_54374 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53554_54373);
}),null));
var output_checker53556_54375 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53553_54372);
}),null));
var ret__40629__auto___54376 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__53557){
var validate__38023__auto__ = cljs.core.deref(ufv___54371);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54377 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53557], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53558_54378 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53559_54379 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53560_54380 = input_schema53554_54373;
var G__53561_54381 = cljs.core.deref(input_checker53555_54374);
var G__53562_54382 = args__38024__auto___54377;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53558_54378,G__53559_54379,G__53560_54380,G__53561_54381,G__53562_54382) : schema.core.fn_validator.call(null,G__53558_54378,G__53559_54379,G__53560_54380,G__53561_54381,G__53562_54382));
} else {
var temp__5804__auto___54385 = (function (){var fexpr__53564 = cljs.core.deref(input_checker53555_54374);
return (fexpr__53564.cljs$core$IFn$_invoke$arity$1 ? fexpr__53564.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54377) : fexpr__53564.call(null,args__38024__auto___54377));
})();
if(cljs.core.truth_(temp__5804__auto___54385)){
var error__38025__auto___54386 = temp__5804__auto___54385;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54386], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53554_54373,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54377,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54386], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53557;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53567_54391 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53568_54392 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53569_54393 = output_schema53553_54372;
var G__53570_54394 = cljs.core.deref(output_checker53556_54375);
var G__53571_54395 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53567_54391,G__53568_54392,G__53569_54393,G__53570_54394,G__53571_54395) : schema.core.fn_validator.call(null,G__53567_54391,G__53568_54392,G__53569_54393,G__53570_54394,G__53571_54395));
} else {
var temp__5804__auto___54398 = (function (){var fexpr__53572 = cljs.core.deref(output_checker53556_54375);
return (fexpr__53572.cljs$core$IFn$_invoke$arity$1 ? fexpr__53572.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53572.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54398)){
var error__38025__auto___54399 = temp__5804__auto___54398;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54399], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53553_54372,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54399], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema53553_54372,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53554_54373], null)));

var ufv___54400 = schema.utils.use_fn_validation;
var output_schema53573_54401 = deercreeklabs.baracus.ByteArray;
var input_schema53574_54402 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53575_54403 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53574_54402);
}),null));
var output_checker53576_54404 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53573_54401);
}),null));
var ret__40629__auto___54405 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__53577){
var validate__38023__auto__ = cljs.core.deref(ufv___54400);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54406 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53577], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53581_54407 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53582_54408 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53583_54409 = input_schema53574_54402;
var G__53584_54410 = cljs.core.deref(input_checker53575_54403);
var G__53585_54411 = args__38024__auto___54406;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53581_54407,G__53582_54408,G__53583_54409,G__53584_54410,G__53585_54411) : schema.core.fn_validator.call(null,G__53581_54407,G__53582_54408,G__53583_54409,G__53584_54410,G__53585_54411));
} else {
var temp__5804__auto___54414 = (function (){var fexpr__53586 = cljs.core.deref(input_checker53575_54403);
return (fexpr__53586.cljs$core$IFn$_invoke$arity$1 ? fexpr__53586.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54406) : fexpr__53586.call(null,args__38024__auto___54406));
})();
if(cljs.core.truth_(temp__5804__auto___54414)){
var error__38025__auto___54417 = temp__5804__auto___54414;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54417], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53574_54402,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54406,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54417], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53577;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53587_54424 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53588_54425 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53589_54426 = output_schema53573_54401;
var G__53590_54427 = cljs.core.deref(output_checker53576_54404);
var G__53591_54428 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53587_54424,G__53588_54425,G__53589_54426,G__53590_54427,G__53591_54428) : schema.core.fn_validator.call(null,G__53587_54424,G__53588_54425,G__53589_54426,G__53590_54427,G__53591_54428));
} else {
var temp__5804__auto___54429 = (function (){var fexpr__53592 = cljs.core.deref(output_checker53576_54404);
return (fexpr__53592.cljs$core$IFn$_invoke$arity$1 ? fexpr__53592.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53592.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54429)){
var error__38025__auto___54431 = temp__5804__auto___54429;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54431], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53573_54401,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54431], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema53573_54401,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53574_54402], null)));

var ufv___54436 = schema.utils.use_fn_validation;
var output_schema53593_54437 = schema.core.Bool;
var input_schema53594_54438 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53595_54439 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53594_54438);
}),null));
var output_checker53596_54440 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53593_54437);
}),null));
var ret__40629__auto___54441 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__53597){
var validate__38023__auto__ = cljs.core.deref(ufv___54436);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54443 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53597], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53601_54444 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53602_54445 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53603_54446 = input_schema53594_54438;
var G__53604_54447 = cljs.core.deref(input_checker53595_54439);
var G__53605_54448 = args__38024__auto___54443;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53601_54444,G__53602_54445,G__53603_54446,G__53604_54447,G__53605_54448) : schema.core.fn_validator.call(null,G__53601_54444,G__53602_54445,G__53603_54446,G__53604_54447,G__53605_54448));
} else {
var temp__5804__auto___54450 = (function (){var fexpr__53606 = cljs.core.deref(input_checker53595_54439);
return (fexpr__53606.cljs$core$IFn$_invoke$arity$1 ? fexpr__53606.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54443) : fexpr__53606.call(null,args__38024__auto___54443));
})();
if(cljs.core.truth_(temp__5804__auto___54450)){
var error__38025__auto___54451 = temp__5804__auto___54450;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54451], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53594_54438,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54443,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54451], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var arg = G__53597;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53611_54456 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53612_54457 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53613_54458 = output_schema53593_54437;
var G__53614_54459 = cljs.core.deref(output_checker53596_54440);
var G__53615_54460 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53611_54456,G__53612_54457,G__53613_54458,G__53614_54459,G__53615_54460) : schema.core.fn_validator.call(null,G__53611_54456,G__53612_54457,G__53613_54458,G__53614_54459,G__53615_54460));
} else {
var temp__5804__auto___54461 = (function (){var fexpr__53616 = cljs.core.deref(output_checker53596_54440);
return (fexpr__53616.cljs$core$IFn$_invoke$arity$1 ? fexpr__53616.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53616.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54461)){
var error__38025__auto___54462 = temp__5804__auto___54461;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54462], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53593_54437,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54462], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema53593_54437,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53594_54438], null)));

var ufv___54468 = schema.utils.use_fn_validation;
var output_schema53617_54469 = schema.core.Bool;
var input_schema53618_54470 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53619_54471 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53618_54470);
}),null));
var output_checker53620_54472 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53617_54469);
}),null));
var ret__40629__auto___54474 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__53621,G__53622){
var validate__38023__auto__ = cljs.core.deref(ufv___54468);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54476 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53621,G__53622], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53623_54477 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53624_54478 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53625_54479 = input_schema53618_54470;
var G__53626_54480 = cljs.core.deref(input_checker53619_54471);
var G__53627_54481 = args__38024__auto___54476;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53623_54477,G__53624_54478,G__53625_54479,G__53626_54480,G__53627_54481) : schema.core.fn_validator.call(null,G__53623_54477,G__53624_54478,G__53625_54479,G__53626_54480,G__53627_54481));
} else {
var temp__5804__auto___54483 = (function (){var fexpr__53628 = cljs.core.deref(input_checker53619_54471);
return (fexpr__53628.cljs$core$IFn$_invoke$arity$1 ? fexpr__53628.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54476) : fexpr__53628.call(null,args__38024__auto___54476));
})();
if(cljs.core.truth_(temp__5804__auto___54483)){
var error__38025__auto___54485 = temp__5804__auto___54483;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54485], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53618_54470,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54476,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54485], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var reader_schema = G__53621;
var writer_schema = G__53622;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53636_54492 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53637_54493 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53638_54494 = output_schema53617_54469;
var G__53639_54495 = cljs.core.deref(output_checker53620_54472);
var G__53640_54496 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53636_54492,G__53637_54493,G__53638_54494,G__53639_54495,G__53640_54496) : schema.core.fn_validator.call(null,G__53636_54492,G__53637_54493,G__53638_54494,G__53639_54495,G__53640_54496));
} else {
var temp__5804__auto___54498 = (function (){var fexpr__53641 = cljs.core.deref(output_checker53620_54472);
return (fexpr__53641.cljs$core$IFn$_invoke$arity$1 ? fexpr__53641.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53641.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54498)){
var error__38025__auto___54500 = temp__5804__auto___54498;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54500], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53617_54469,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54500], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema53617_54469,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53618_54470], null)));

var ufv___54504 = schema.utils.use_fn_validation;
var output_schema53642_54505 = schema.core.Any;
var input_schema53643_54506 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53644_54507 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53643_54506);
}),null));
var output_checker53645_54508 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53642_54505);
}),null));
var ret__40629__auto___54510 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__53646){
var validate__38023__auto__ = cljs.core.deref(ufv___54504);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54512 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53646], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53647_54513 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53648_54514 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53649_54515 = input_schema53643_54506;
var G__53650_54516 = cljs.core.deref(input_checker53644_54507);
var G__53651_54517 = args__38024__auto___54512;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53647_54513,G__53648_54514,G__53649_54515,G__53650_54516,G__53651_54517) : schema.core.fn_validator.call(null,G__53647_54513,G__53648_54514,G__53649_54515,G__53650_54516,G__53651_54517));
} else {
var temp__5804__auto___54519 = (function (){var fexpr__53654 = cljs.core.deref(input_checker53644_54507);
return (fexpr__53654.cljs$core$IFn$_invoke$arity$1 ? fexpr__53654.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54512) : fexpr__53654.call(null,args__38024__auto___54512));
})();
if(cljs.core.truth_(temp__5804__auto___54519)){
var error__38025__auto___54520 = temp__5804__auto___54519;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54520], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53643_54506,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54512,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54520], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53646;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53655_54524 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53656_54525 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53657_54526 = output_schema53642_54505;
var G__53658_54527 = cljs.core.deref(output_checker53645_54508);
var G__53659_54528 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53655_54524,G__53656_54525,G__53657_54526,G__53658_54527,G__53659_54528) : schema.core.fn_validator.call(null,G__53655_54524,G__53656_54525,G__53657_54526,G__53658_54527,G__53659_54528));
} else {
var temp__5804__auto___54530 = (function (){var fexpr__53664 = cljs.core.deref(output_checker53645_54508);
return (fexpr__53664.cljs$core$IFn$_invoke$arity$1 ? fexpr__53664.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53664.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54530)){
var error__38025__auto___54532 = temp__5804__auto___54530;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54532], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53642_54505,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54532], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema53642_54505,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53643_54506], null)));

var ufv___54534 = schema.utils.use_fn_validation;
var output_schema53665_54535 = schema.core.Any;
var input_schema53666_54536 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53667_54537 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53666_54536);
}),null));
var output_checker53668_54538 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53665_54535);
}),null));
var ret__40629__auto___54540 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__53669){
var validate__38023__auto__ = cljs.core.deref(ufv___54534);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54541 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53669], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53672_54543 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53673_54544 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53674_54545 = input_schema53666_54536;
var G__53675_54546 = cljs.core.deref(input_checker53667_54537);
var G__53676_54547 = args__38024__auto___54541;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53672_54543,G__53673_54544,G__53674_54545,G__53675_54546,G__53676_54547) : schema.core.fn_validator.call(null,G__53672_54543,G__53673_54544,G__53674_54545,G__53675_54546,G__53676_54547));
} else {
var temp__5804__auto___54549 = (function (){var fexpr__53677 = cljs.core.deref(input_checker53667_54537);
return (fexpr__53677.cljs$core$IFn$_invoke$arity$1 ? fexpr__53677.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54541) : fexpr__53677.call(null,args__38024__auto___54541));
})();
if(cljs.core.truth_(temp__5804__auto___54549)){
var error__38025__auto___54550 = temp__5804__auto___54549;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54550], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53666_54536,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54541,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54550], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53669;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53681_54555 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53682_54556 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53683_54557 = output_schema53665_54535;
var G__53684_54558 = cljs.core.deref(output_checker53668_54538);
var G__53685_54559 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53681_54555,G__53682_54556,G__53683_54557,G__53684_54558,G__53685_54559) : schema.core.fn_validator.call(null,G__53681_54555,G__53682_54556,G__53683_54557,G__53684_54558,G__53685_54559));
} else {
var temp__5804__auto___54561 = (function (){var fexpr__53686 = cljs.core.deref(output_checker53668_54538);
return (fexpr__53686.cljs$core$IFn$_invoke$arity$1 ? fexpr__53686.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53686.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54561)){
var error__38025__auto___54562 = temp__5804__auto___54561;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54562], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53665_54535,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54562], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema53665_54535,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53666_54536], null)));

var ufv___54566 = schema.utils.use_fn_validation;
var output_schema53691_54567 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53692_54568 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema53696_54569 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker53693_54570 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53692_54568);
}),null));
var output_checker53694_54571 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53691_54567);
}),null));
var input_checker53697_54572 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53696_54569);
}),null));
var output_checker53698_54573 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53691_54567);
}),null));
var ret__40629__auto___54577 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__53707 = arguments.length;
switch (G__53707) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__53695){
var validate__38023__auto__ = cljs.core.deref(ufv___54566);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54581 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53695], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53708_54583 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53709_54584 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53710_54585 = input_schema53692_54568;
var G__53711_54586 = cljs.core.deref(input_checker53693_54570);
var G__53712_54587 = args__38024__auto___54581;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53708_54583,G__53709_54584,G__53710_54585,G__53711_54586,G__53712_54587) : schema.core.fn_validator.call(null,G__53708_54583,G__53709_54584,G__53710_54585,G__53711_54586,G__53712_54587));
} else {
var temp__5804__auto___54588 = (function (){var fexpr__53713 = cljs.core.deref(input_checker53693_54570);
return (fexpr__53713.cljs$core$IFn$_invoke$arity$1 ? fexpr__53713.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54581) : fexpr__53713.call(null,args__38024__auto___54581));
})();
if(cljs.core.truth_(temp__5804__auto___54588)){
var error__38025__auto___54589 = temp__5804__auto___54588;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54589], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53692_54568,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54581,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54589], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53695;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53714_54594 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53715_54595 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53716_54596 = output_schema53691_54567;
var G__53717_54597 = cljs.core.deref(output_checker53694_54571);
var G__53718_54598 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53714_54594,G__53715_54595,G__53716_54596,G__53717_54597,G__53718_54598) : schema.core.fn_validator.call(null,G__53714_54594,G__53715_54595,G__53716_54596,G__53717_54597,G__53718_54598));
} else {
var temp__5804__auto___54600 = (function (){var fexpr__53719 = cljs.core.deref(output_checker53694_54571);
return (fexpr__53719.cljs$core$IFn$_invoke$arity$1 ? fexpr__53719.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53719.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54600)){
var error__38025__auto___54601 = temp__5804__auto___54600;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54601], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53691_54567,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54601], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53699,G__53700){
var validate__38023__auto__ = cljs.core.deref(ufv___54566);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54610 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53699,G__53700], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53720_54611 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53721_54612 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53722_54613 = input_schema53696_54569;
var G__53723_54614 = cljs.core.deref(input_checker53697_54572);
var G__53724_54615 = args__38024__auto___54610;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53720_54611,G__53721_54612,G__53722_54613,G__53723_54614,G__53724_54615) : schema.core.fn_validator.call(null,G__53720_54611,G__53721_54612,G__53722_54613,G__53723_54614,G__53724_54615));
} else {
var temp__5804__auto___54620 = (function (){var fexpr__53725 = cljs.core.deref(input_checker53697_54572);
return (fexpr__53725.cljs$core$IFn$_invoke$arity$1 ? fexpr__53725.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54610) : fexpr__53725.call(null,args__38024__auto___54610));
})();
if(cljs.core.truth_(temp__5804__auto___54620)){
var error__38025__auto___54621 = temp__5804__auto___54620;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54621], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53696_54569,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54610,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54621], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53699;
var field_kw_or_branch_i = G__53700;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53726_54631 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53727_54632 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53728_54633 = output_schema53691_54567;
var G__53729_54634 = cljs.core.deref(output_checker53698_54573);
var G__53730_54635 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53726_54631,G__53727_54632,G__53728_54633,G__53729_54634,G__53730_54635) : schema.core.fn_validator.call(null,G__53726_54631,G__53727_54632,G__53728_54633,G__53729_54634,G__53730_54635));
} else {
var temp__5804__auto___54638 = (function (){var fexpr__53731 = cljs.core.deref(output_checker53698_54573);
return (fexpr__53731.cljs$core$IFn$_invoke$arity$1 ? fexpr__53731.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53731.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54638)){
var error__38025__auto___54641 = temp__5804__auto___54638;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54641], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53691_54567,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54641], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema53691_54567,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53692_54568,input_schema53696_54569], null)));

var ufv___54644 = schema.utils.use_fn_validation;
var output_schema53736_54646 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema53737_54647 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema53745_54648 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker53738_54649 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53737_54647);
}),null));
var output_checker53739_54650 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53736_54646);
}),null));
var input_checker53746_54651 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53745_54648);
}),null));
var output_checker53747_54652 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53736_54646);
}),null));
var ret__40629__auto___54655 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__53752 = arguments.length;
switch (G__53752) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__53743,G__53744){
var validate__38023__auto__ = cljs.core.deref(ufv___54644);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54659 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53743,G__53744], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53755_54660 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53756_54661 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53757_54662 = input_schema53737_54647;
var G__53758_54663 = cljs.core.deref(input_checker53738_54649);
var G__53759_54664 = args__38024__auto___54659;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53755_54660,G__53756_54661,G__53757_54662,G__53758_54663,G__53759_54664) : schema.core.fn_validator.call(null,G__53755_54660,G__53756_54661,G__53757_54662,G__53758_54663,G__53759_54664));
} else {
var temp__5804__auto___54666 = (function (){var fexpr__53760 = cljs.core.deref(input_checker53738_54649);
return (fexpr__53760.cljs$core$IFn$_invoke$arity$1 ? fexpr__53760.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54659) : fexpr__53760.call(null,args__38024__auto___54659));
})();
if(cljs.core.truth_(temp__5804__auto___54666)){
var error__38025__auto___54667 = temp__5804__auto___54666;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54667], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53737_54647,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54659,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54667], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53743;
var path = G__53744;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53765_54670 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53766_54671 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53767_54672 = output_schema53736_54646;
var G__53768_54673 = cljs.core.deref(output_checker53739_54650);
var G__53769_54674 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53765_54670,G__53766_54671,G__53767_54672,G__53768_54673,G__53769_54674) : schema.core.fn_validator.call(null,G__53765_54670,G__53766_54671,G__53767_54672,G__53768_54673,G__53769_54674));
} else {
var temp__5804__auto___54675 = (function (){var fexpr__53770 = cljs.core.deref(output_checker53739_54650);
return (fexpr__53770.cljs$core$IFn$_invoke$arity$1 ? fexpr__53770.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53770.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54675)){
var error__38025__auto___54676 = temp__5804__auto___54675;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54676], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53736_54646,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54676], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__53748,G__53749,G__53750){
var validate__38023__auto__ = cljs.core.deref(ufv___54644);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54680 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53748,G__53749,G__53750], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53771_54682 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53772_54684 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53773_54685 = input_schema53745_54648;
var G__53774_54686 = cljs.core.deref(input_checker53746_54651);
var G__53775_54687 = args__38024__auto___54680;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53771_54682,G__53772_54684,G__53773_54685,G__53774_54686,G__53775_54687) : schema.core.fn_validator.call(null,G__53771_54682,G__53772_54684,G__53773_54685,G__53774_54686,G__53775_54687));
} else {
var temp__5804__auto___54688 = (function (){var fexpr__53778 = cljs.core.deref(input_checker53746_54651);
return (fexpr__53778.cljs$core$IFn$_invoke$arity$1 ? fexpr__53778.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54680) : fexpr__53778.call(null,args__38024__auto___54680));
})();
if(cljs.core.truth_(temp__5804__auto___54688)){
var error__38025__auto___54690 = temp__5804__auto___54688;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54690], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53745_54648,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54680,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54690], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53748;
var path = G__53749;
var G__53780 = G__53750;
var map__53781 = G__53780;
var map__53781__$1 = cljs.core.__destructure_map(map__53781);
var opts = map__53781__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53781__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__53780__$1 = G__53780;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__53782 = G__53780__$1;
var map__53782__$1 = cljs.core.__destructure_map(map__53782);
var opts__$1 = map__53782__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53782__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53786_54698 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53787_54699 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53788_54700 = output_schema53736_54646;
var G__53789_54701 = cljs.core.deref(output_checker53747_54652);
var G__53790_54702 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53786_54698,G__53787_54699,G__53788_54700,G__53789_54701,G__53790_54702) : schema.core.fn_validator.call(null,G__53786_54698,G__53787_54699,G__53788_54700,G__53789_54701,G__53790_54702));
} else {
var temp__5804__auto___54704 = (function (){var fexpr__53791 = cljs.core.deref(output_checker53747_54652);
return (fexpr__53791.cljs$core$IFn$_invoke$arity$1 ? fexpr__53791.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53791.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54704)){
var error__38025__auto___54706 = temp__5804__auto___54704;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54706], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53736_54646,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54706], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema53736_54646,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53737_54647,input_schema53745_54648], null)));

var ufv___54708 = schema.utils.use_fn_validation;
var output_schema53794_54709 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema53795_54710 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53796_54711 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53795_54710);
}),null));
var output_checker53797_54712 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53794_54709);
}),null));
var ret__40629__auto___54713 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__53798){
var validate__38023__auto__ = cljs.core.deref(ufv___54708);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54715 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53798], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53801_54716 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53802_54717 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__53803_54718 = input_schema53795_54710;
var G__53804_54719 = cljs.core.deref(input_checker53796_54711);
var G__53805_54720 = args__38024__auto___54715;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53801_54716,G__53802_54717,G__53803_54718,G__53804_54719,G__53805_54720) : schema.core.fn_validator.call(null,G__53801_54716,G__53802_54717,G__53803_54718,G__53804_54719,G__53805_54720));
} else {
var temp__5804__auto___54724 = (function (){var fexpr__53806 = cljs.core.deref(input_checker53796_54711);
return (fexpr__53806.cljs$core$IFn$_invoke$arity$1 ? fexpr__53806.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54715) : fexpr__53806.call(null,args__38024__auto___54715));
})();
if(cljs.core.truth_(temp__5804__auto___54724)){
var error__38025__auto___54726 = temp__5804__auto___54724;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54726], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53795_54710,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54715,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54726], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var union_schema = G__53798;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53810_54730 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53811_54731 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__53812_54732 = output_schema53794_54709;
var G__53813_54734 = cljs.core.deref(output_checker53797_54712);
var G__53814_54735 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53810_54730,G__53811_54731,G__53812_54732,G__53813_54734,G__53814_54735) : schema.core.fn_validator.call(null,G__53810_54730,G__53811_54731,G__53812_54732,G__53813_54734,G__53814_54735));
} else {
var temp__5804__auto___54740 = (function (){var fexpr__53815 = cljs.core.deref(output_checker53797_54712);
return (fexpr__53815.cljs$core$IFn$_invoke$arity$1 ? fexpr__53815.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53815.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54740)){
var error__38025__auto___54741 = temp__5804__auto___54740;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54741], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53794_54709,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54741], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema53794_54709,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53795_54710], null)));

var ufv___54745 = schema.utils.use_fn_validation;
var output_schema53816_54746 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53817_54747 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53818_54748 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53817_54747);
}),null));
var output_checker53819_54749 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53816_54746);
}),null));
var ret__40629__auto___54750 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__53820,G__53821){
var validate__38023__auto__ = cljs.core.deref(ufv___54745);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54756 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53820,G__53821], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53824_54758 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53825_54759 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__53826_54760 = input_schema53817_54747;
var G__53827_54761 = cljs.core.deref(input_checker53818_54748);
var G__53828_54762 = args__38024__auto___54756;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53824_54758,G__53825_54759,G__53826_54760,G__53827_54761,G__53828_54762) : schema.core.fn_validator.call(null,G__53824_54758,G__53825_54759,G__53826_54760,G__53827_54761,G__53828_54762));
} else {
var temp__5804__auto___54764 = (function (){var fexpr__53829 = cljs.core.deref(input_checker53818_54748);
return (fexpr__53829.cljs$core$IFn$_invoke$arity$1 ? fexpr__53829.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54756) : fexpr__53829.call(null,args__38024__auto___54756));
})();
if(cljs.core.truth_(temp__5804__auto___54764)){
var error__38025__auto___54766 = temp__5804__auto___54764;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54766], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53817_54747,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54756,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54766], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var union_schema = G__53820;
var branch_index = G__53821;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53833_54768 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53834_54769 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__53835_54770 = output_schema53816_54746;
var G__53836_54771 = cljs.core.deref(output_checker53819_54749);
var G__53837_54772 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53833_54768,G__53834_54769,G__53835_54770,G__53836_54771,G__53837_54772) : schema.core.fn_validator.call(null,G__53833_54768,G__53834_54769,G__53835_54770,G__53836_54771,G__53837_54772));
} else {
var temp__5804__auto___54774 = (function (){var fexpr__53840 = cljs.core.deref(output_checker53819_54749);
return (fexpr__53840.cljs$core$IFn$_invoke$arity$1 ? fexpr__53840.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53840.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54774)){
var error__38025__auto___54776 = temp__5804__auto___54774;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54776], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53816_54746,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54776], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema53816_54746,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53817_54747], null)));

var ufv___54785 = schema.utils.use_fn_validation;
var output_schema53845_54786 = schema.core.Keyword;
var input_schema53846_54787 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53847_54788 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53846_54787);
}),null));
var output_checker53848_54789 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53845_54786);
}),null));
var ret__40629__auto___54791 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__53849){
var validate__38023__auto__ = cljs.core.deref(ufv___54785);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___54792 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53849], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53852_54794 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53853_54795 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__53854_54796 = input_schema53846_54787;
var G__53855_54797 = cljs.core.deref(input_checker53847_54788);
var G__53856_54798 = args__38024__auto___54792;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53852_54794,G__53853_54795,G__53854_54796,G__53855_54797,G__53856_54798) : schema.core.fn_validator.call(null,G__53852_54794,G__53853_54795,G__53854_54796,G__53855_54797,G__53856_54798));
} else {
var temp__5804__auto___54800 = (function (){var fexpr__53857 = cljs.core.deref(input_checker53847_54788);
return (fexpr__53857.cljs$core$IFn$_invoke$arity$1 ? fexpr__53857.cljs$core$IFn$_invoke$arity$1(args__38024__auto___54792) : fexpr__53857.call(null,args__38024__auto___54792));
})();
if(cljs.core.truth_(temp__5804__auto___54800)){
var error__38025__auto___54801 = temp__5804__auto___54800;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54801], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53846_54787,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___54792,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54801], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var schema__$1 = G__53849;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53863_54818 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53864_54819 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__53865_54820 = output_schema53845_54786;
var G__53866_54821 = cljs.core.deref(output_checker53848_54789);
var G__53867_54822 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53863_54818,G__53864_54819,G__53865_54820,G__53866_54821,G__53867_54822) : schema.core.fn_validator.call(null,G__53863_54818,G__53864_54819,G__53865_54820,G__53866_54821,G__53867_54822));
} else {
var temp__5804__auto___54825 = (function (){var fexpr__53868 = cljs.core.deref(output_checker53848_54789);
return (fexpr__53868.cljs$core$IFn$_invoke$arity$1 ? fexpr__53868.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__53868.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54825)){
var error__38025__auto___54826 = temp__5804__auto___54825;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___54826], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53845_54786,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___54826], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema53845_54786,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53846_54787], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
