goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__55533){
var vec__55536 = p__55533;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55536,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55536,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__55548 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__55548__$1 = (((G__55548 instanceof cljs.core.Keyword))?G__55548.fqn:null);
switch (G__55548__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__55557 = (function (){
var seq__55558 = cljs.core.seq(vars__$1);
var chunk__55559 = null;
var count__55560 = (0);
var i__55561 = (0);
while(true){
if((i__55561 < count__55560)){
var v = chunk__55559.cljs$core$IIndexed$_nth$arity$2(null,i__55561);
var temp__5804__auto___55804 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___55804)){
var t_55805 = temp__5804__auto___55804;
var G__55566_55806 = ((function (seq__55558,chunk__55559,count__55560,i__55561,t_55805,temp__5804__auto___55804,v,each_fixture_fn,G__55548,G__55548__$1,env,once_fixtures,each_fixtures,vec__55536,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_55805)));
});})(seq__55558,chunk__55559,count__55560,i__55561,t_55805,temp__5804__auto___55804,v,each_fixture_fn,G__55548,G__55548__$1,env,once_fixtures,each_fixtures,vec__55536,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__55566_55806) : each_fixture_fn.call(null,G__55566_55806));
} else {
}


var G__55808 = seq__55558;
var G__55809 = chunk__55559;
var G__55810 = count__55560;
var G__55811 = (i__55561 + (1));
seq__55558 = G__55808;
chunk__55559 = G__55809;
count__55560 = G__55810;
i__55561 = G__55811;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__55558);
if(temp__5804__auto__){
var seq__55558__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__55558__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__55558__$1);
var G__55812 = cljs.core.chunk_rest(seq__55558__$1);
var G__55813 = c__4679__auto__;
var G__55814 = cljs.core.count(c__4679__auto__);
var G__55815 = (0);
seq__55558 = G__55812;
chunk__55559 = G__55813;
count__55560 = G__55814;
i__55561 = G__55815;
continue;
} else {
var v = cljs.core.first(seq__55558__$1);
var temp__5804__auto___55816__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___55816__$1)){
var t_55817 = temp__5804__auto___55816__$1;
var G__55571_55818 = ((function (seq__55558,chunk__55559,count__55560,i__55561,t_55817,temp__5804__auto___55816__$1,v,seq__55558__$1,temp__5804__auto__,each_fixture_fn,G__55548,G__55548__$1,env,once_fixtures,each_fixtures,vec__55536,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_55817)));
});})(seq__55558,chunk__55559,count__55560,i__55561,t_55817,temp__5804__auto___55816__$1,v,seq__55558__$1,temp__5804__auto__,each_fixture_fn,G__55548,G__55548__$1,env,once_fixtures,each_fixtures,vec__55536,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__55571_55818) : each_fixture_fn.call(null,G__55571_55818));
} else {
}


var G__55819 = cljs.core.next(seq__55558__$1);
var G__55820 = null;
var G__55821 = (0);
var G__55822 = (0);
seq__55558 = G__55819;
chunk__55559 = G__55820;
count__55560 = G__55821;
i__55561 = G__55822;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__55556 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__55556.cljs$core$IFn$_invoke$arity$1 ? fexpr__55556.cljs$core$IFn$_invoke$arity$1(G__55557) : fexpr__55556.call(null,G__55557));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55548__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__55509_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__55509_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__55603 = shadow.test.env.get_test_ns_info(ns);
var map__55603__$1 = cljs.core.__destructure_map(map__55603);
var test_ns = map__55603__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55603__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__55624,vars){
var map__55629 = p__55624;
var map__55629__$1 = cljs.core.__destructure_map(map__55629);
var env = map__55629__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55629__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__55637_55824 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__55640_55825 = null;
var count__55641_55826 = (0);
var i__55642_55827 = (0);
while(true){
if((i__55642_55827 < count__55641_55826)){
var vec__55727_55828 = chunk__55640_55825.cljs$core$IIndexed$_nth$arity$2(null,i__55642_55827);
var test_ns_55829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55727_55828,(0),null);
var ns_info_55830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55727_55828,(1),null);
var map__55734_55831 = ns_info_55830;
var map__55734_55832__$1 = cljs.core.__destructure_map(map__55734_55831);
var fixtures_55833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55734_55832__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___55834 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_55833);
if(cljs.core.truth_(temp__5804__auto___55834)){
var fix_55835 = temp__5804__auto___55834;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_55829,fix_55835], 0));
} else {
}

var temp__5804__auto___55836 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_55833);
if(cljs.core.truth_(temp__5804__auto___55836)){
var fix_55838 = temp__5804__auto___55836;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_55829,fix_55838], 0));
} else {
}


var G__55839 = seq__55637_55824;
var G__55840 = chunk__55640_55825;
var G__55841 = count__55641_55826;
var G__55842 = (i__55642_55827 + (1));
seq__55637_55824 = G__55839;
chunk__55640_55825 = G__55840;
count__55641_55826 = G__55841;
i__55642_55827 = G__55842;
continue;
} else {
var temp__5804__auto___55843 = cljs.core.seq(seq__55637_55824);
if(temp__5804__auto___55843){
var seq__55637_55844__$1 = temp__5804__auto___55843;
if(cljs.core.chunked_seq_QMARK_(seq__55637_55844__$1)){
var c__4679__auto___55845 = cljs.core.chunk_first(seq__55637_55844__$1);
var G__55846 = cljs.core.chunk_rest(seq__55637_55844__$1);
var G__55847 = c__4679__auto___55845;
var G__55848 = cljs.core.count(c__4679__auto___55845);
var G__55849 = (0);
seq__55637_55824 = G__55846;
chunk__55640_55825 = G__55847;
count__55641_55826 = G__55848;
i__55642_55827 = G__55849;
continue;
} else {
var vec__55755_55850 = cljs.core.first(seq__55637_55844__$1);
var test_ns_55851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55755_55850,(0),null);
var ns_info_55852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55755_55850,(1),null);
var map__55761_55853 = ns_info_55852;
var map__55761_55854__$1 = cljs.core.__destructure_map(map__55761_55853);
var fixtures_55855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55761_55854__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___55856__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_55855);
if(cljs.core.truth_(temp__5804__auto___55856__$1)){
var fix_55857 = temp__5804__auto___55856__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_55851,fix_55857], 0));
} else {
}

var temp__5804__auto___55858__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_55855);
if(cljs.core.truth_(temp__5804__auto___55858__$1)){
var fix_55859 = temp__5804__auto___55858__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_55851,fix_55859], 0));
} else {
}


var G__55860 = cljs.core.next(seq__55637_55844__$1);
var G__55861 = null;
var G__55862 = (0);
var G__55863 = (0);
seq__55637_55824 = G__55860;
chunk__55640_55825 = G__55861;
count__55641_55826 = G__55862;
i__55642_55827 = G__55863;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__55610_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__55610_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__55778 = cljs.test.get_current_env();
var map__55778__$1 = cljs.core.__destructure_map(map__55778);
var env = map__55778__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55778__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55778__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__55782 = arguments.length;
switch (G__55782) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__55785 = arguments.length;
switch (G__55785) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__55787 = shadow.test.env.get_test_ns_info(ns);
var map__55787__$1 = cljs.core.__destructure_map(map__55787);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55787__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__55793 = arguments.length;
switch (G__55793) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__55789_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__55789_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__55798 = arguments.length;
switch (G__55798) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__55796_SHARP_){
var or__4253__auto__ = (re == null);
if(or__4253__auto__){
return or__4253__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__55796_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
