goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_34264 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_34264(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_34266 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_34266(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__32878 = coll;
var G__32879 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__32878,G__32879) : shadow.dom.lazy_native_coll_seq.call(null,G__32878,G__32879));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__32914 = arguments.length;
switch (G__32914) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__32932 = arguments.length;
switch (G__32932) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__32949 = arguments.length;
switch (G__32949) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__32990 = arguments.length;
switch (G__32990) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33039 = arguments.length;
switch (G__33039) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33050 = arguments.length;
switch (G__33050) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33058){if((e33058 instanceof Object)){
var e = e33058;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33058;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33066 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33067 = null;
var count__33068 = (0);
var i__33069 = (0);
while(true){
if((i__33069 < count__33068)){
var el = chunk__33067.cljs$core$IIndexed$_nth$arity$2(null,i__33069);
var handler_34281__$1 = ((function (seq__33066,chunk__33067,count__33068,i__33069,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33066,chunk__33067,count__33068,i__33069,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34281__$1);


var G__34282 = seq__33066;
var G__34283 = chunk__33067;
var G__34284 = count__33068;
var G__34285 = (i__33069 + (1));
seq__33066 = G__34282;
chunk__33067 = G__34283;
count__33068 = G__34284;
i__33069 = G__34285;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33066);
if(temp__5804__auto__){
var seq__33066__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33066__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33066__$1);
var G__34286 = cljs.core.chunk_rest(seq__33066__$1);
var G__34287 = c__4679__auto__;
var G__34288 = cljs.core.count(c__4679__auto__);
var G__34289 = (0);
seq__33066 = G__34286;
chunk__33067 = G__34287;
count__33068 = G__34288;
i__33069 = G__34289;
continue;
} else {
var el = cljs.core.first(seq__33066__$1);
var handler_34290__$1 = ((function (seq__33066,chunk__33067,count__33068,i__33069,el,seq__33066__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33066,chunk__33067,count__33068,i__33069,el,seq__33066__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34290__$1);


var G__34292 = cljs.core.next(seq__33066__$1);
var G__34293 = null;
var G__34294 = (0);
var G__34295 = (0);
seq__33066 = G__34292;
chunk__33067 = G__34293;
count__33068 = G__34294;
i__33069 = G__34295;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33083 = arguments.length;
switch (G__33083) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33092 = cljs.core.seq(events);
var chunk__33093 = null;
var count__33094 = (0);
var i__33095 = (0);
while(true){
if((i__33095 < count__33094)){
var vec__33109 = chunk__33093.cljs$core$IIndexed$_nth$arity$2(null,i__33095);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33109,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33109,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34298 = seq__33092;
var G__34299 = chunk__33093;
var G__34300 = count__33094;
var G__34301 = (i__33095 + (1));
seq__33092 = G__34298;
chunk__33093 = G__34299;
count__33094 = G__34300;
i__33095 = G__34301;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33092);
if(temp__5804__auto__){
var seq__33092__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33092__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33092__$1);
var G__34302 = cljs.core.chunk_rest(seq__33092__$1);
var G__34303 = c__4679__auto__;
var G__34304 = cljs.core.count(c__4679__auto__);
var G__34305 = (0);
seq__33092 = G__34302;
chunk__33093 = G__34303;
count__33094 = G__34304;
i__33095 = G__34305;
continue;
} else {
var vec__33115 = cljs.core.first(seq__33092__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33115,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33115,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34306 = cljs.core.next(seq__33092__$1);
var G__34307 = null;
var G__34308 = (0);
var G__34309 = (0);
seq__33092 = G__34306;
chunk__33093 = G__34307;
count__33094 = G__34308;
i__33095 = G__34309;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__33124 = cljs.core.seq(styles);
var chunk__33125 = null;
var count__33126 = (0);
var i__33127 = (0);
while(true){
if((i__33127 < count__33126)){
var vec__33145 = chunk__33125.cljs$core$IIndexed$_nth$arity$2(null,i__33127);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33145,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33145,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34310 = seq__33124;
var G__34311 = chunk__33125;
var G__34312 = count__33126;
var G__34313 = (i__33127 + (1));
seq__33124 = G__34310;
chunk__33125 = G__34311;
count__33126 = G__34312;
i__33127 = G__34313;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33124);
if(temp__5804__auto__){
var seq__33124__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33124__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33124__$1);
var G__34314 = cljs.core.chunk_rest(seq__33124__$1);
var G__34315 = c__4679__auto__;
var G__34316 = cljs.core.count(c__4679__auto__);
var G__34317 = (0);
seq__33124 = G__34314;
chunk__33125 = G__34315;
count__33126 = G__34316;
i__33127 = G__34317;
continue;
} else {
var vec__33152 = cljs.core.first(seq__33124__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33152,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33152,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34319 = cljs.core.next(seq__33124__$1);
var G__34320 = null;
var G__34321 = (0);
var G__34322 = (0);
seq__33124 = G__34319;
chunk__33125 = G__34320;
count__33126 = G__34321;
i__33127 = G__34322;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__33165_34323 = key;
var G__33165_34324__$1 = (((G__33165_34323 instanceof cljs.core.Keyword))?G__33165_34323.fqn:null);
switch (G__33165_34324__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_34327 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_34327,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_34327,"aria-");
}
})())){
el.setAttribute(ks_34327,value);
} else {
(el[ks_34327] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__33191){
var map__33192 = p__33191;
var map__33192__$1 = cljs.core.__destructure_map(map__33192);
var props = map__33192__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33192__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__33199 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33199,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33199,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33199,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__33202 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__33202,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__33202;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__33210 = arguments.length;
switch (G__33210) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__33223){
var vec__33227 = p__33223;
var seq__33228 = cljs.core.seq(vec__33227);
var first__33229 = cljs.core.first(seq__33228);
var seq__33228__$1 = cljs.core.next(seq__33228);
var nn = first__33229;
var first__33229__$1 = cljs.core.first(seq__33228__$1);
var seq__33228__$2 = cljs.core.next(seq__33228__$1);
var np = first__33229__$1;
var nc = seq__33228__$2;
var node = vec__33227;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33234 = nn;
var G__33235 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33234,G__33235) : create_fn.call(null,G__33234,G__33235));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33239 = nn;
var G__33240 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33239,G__33240) : create_fn.call(null,G__33239,G__33240));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__33249 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33249,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33249,(1),null);
var seq__33253_34349 = cljs.core.seq(node_children);
var chunk__33254_34350 = null;
var count__33255_34351 = (0);
var i__33256_34352 = (0);
while(true){
if((i__33256_34352 < count__33255_34351)){
var child_struct_34353 = chunk__33254_34350.cljs$core$IIndexed$_nth$arity$2(null,i__33256_34352);
var children_34354 = shadow.dom.dom_node(child_struct_34353);
if(cljs.core.seq_QMARK_(children_34354)){
var seq__33336_34355 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34354));
var chunk__33338_34356 = null;
var count__33339_34357 = (0);
var i__33340_34358 = (0);
while(true){
if((i__33340_34358 < count__33339_34357)){
var child_34359 = chunk__33338_34356.cljs$core$IIndexed$_nth$arity$2(null,i__33340_34358);
if(cljs.core.truth_(child_34359)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34359);


var G__34360 = seq__33336_34355;
var G__34361 = chunk__33338_34356;
var G__34362 = count__33339_34357;
var G__34363 = (i__33340_34358 + (1));
seq__33336_34355 = G__34360;
chunk__33338_34356 = G__34361;
count__33339_34357 = G__34362;
i__33340_34358 = G__34363;
continue;
} else {
var G__34364 = seq__33336_34355;
var G__34365 = chunk__33338_34356;
var G__34366 = count__33339_34357;
var G__34367 = (i__33340_34358 + (1));
seq__33336_34355 = G__34364;
chunk__33338_34356 = G__34365;
count__33339_34357 = G__34366;
i__33340_34358 = G__34367;
continue;
}
} else {
var temp__5804__auto___34368 = cljs.core.seq(seq__33336_34355);
if(temp__5804__auto___34368){
var seq__33336_34370__$1 = temp__5804__auto___34368;
if(cljs.core.chunked_seq_QMARK_(seq__33336_34370__$1)){
var c__4679__auto___34371 = cljs.core.chunk_first(seq__33336_34370__$1);
var G__34372 = cljs.core.chunk_rest(seq__33336_34370__$1);
var G__34373 = c__4679__auto___34371;
var G__34374 = cljs.core.count(c__4679__auto___34371);
var G__34375 = (0);
seq__33336_34355 = G__34372;
chunk__33338_34356 = G__34373;
count__33339_34357 = G__34374;
i__33340_34358 = G__34375;
continue;
} else {
var child_34376 = cljs.core.first(seq__33336_34370__$1);
if(cljs.core.truth_(child_34376)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34376);


var G__34377 = cljs.core.next(seq__33336_34370__$1);
var G__34378 = null;
var G__34379 = (0);
var G__34380 = (0);
seq__33336_34355 = G__34377;
chunk__33338_34356 = G__34378;
count__33339_34357 = G__34379;
i__33340_34358 = G__34380;
continue;
} else {
var G__34382 = cljs.core.next(seq__33336_34370__$1);
var G__34383 = null;
var G__34384 = (0);
var G__34385 = (0);
seq__33336_34355 = G__34382;
chunk__33338_34356 = G__34383;
count__33339_34357 = G__34384;
i__33340_34358 = G__34385;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34354);
}


var G__34387 = seq__33253_34349;
var G__34388 = chunk__33254_34350;
var G__34389 = count__33255_34351;
var G__34390 = (i__33256_34352 + (1));
seq__33253_34349 = G__34387;
chunk__33254_34350 = G__34388;
count__33255_34351 = G__34389;
i__33256_34352 = G__34390;
continue;
} else {
var temp__5804__auto___34392 = cljs.core.seq(seq__33253_34349);
if(temp__5804__auto___34392){
var seq__33253_34393__$1 = temp__5804__auto___34392;
if(cljs.core.chunked_seq_QMARK_(seq__33253_34393__$1)){
var c__4679__auto___34394 = cljs.core.chunk_first(seq__33253_34393__$1);
var G__34396 = cljs.core.chunk_rest(seq__33253_34393__$1);
var G__34397 = c__4679__auto___34394;
var G__34398 = cljs.core.count(c__4679__auto___34394);
var G__34399 = (0);
seq__33253_34349 = G__34396;
chunk__33254_34350 = G__34397;
count__33255_34351 = G__34398;
i__33256_34352 = G__34399;
continue;
} else {
var child_struct_34400 = cljs.core.first(seq__33253_34393__$1);
var children_34401 = shadow.dom.dom_node(child_struct_34400);
if(cljs.core.seq_QMARK_(children_34401)){
var seq__33360_34402 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34401));
var chunk__33362_34403 = null;
var count__33363_34404 = (0);
var i__33364_34405 = (0);
while(true){
if((i__33364_34405 < count__33363_34404)){
var child_34408 = chunk__33362_34403.cljs$core$IIndexed$_nth$arity$2(null,i__33364_34405);
if(cljs.core.truth_(child_34408)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34408);


var G__34409 = seq__33360_34402;
var G__34410 = chunk__33362_34403;
var G__34411 = count__33363_34404;
var G__34412 = (i__33364_34405 + (1));
seq__33360_34402 = G__34409;
chunk__33362_34403 = G__34410;
count__33363_34404 = G__34411;
i__33364_34405 = G__34412;
continue;
} else {
var G__34413 = seq__33360_34402;
var G__34414 = chunk__33362_34403;
var G__34415 = count__33363_34404;
var G__34416 = (i__33364_34405 + (1));
seq__33360_34402 = G__34413;
chunk__33362_34403 = G__34414;
count__33363_34404 = G__34415;
i__33364_34405 = G__34416;
continue;
}
} else {
var temp__5804__auto___34417__$1 = cljs.core.seq(seq__33360_34402);
if(temp__5804__auto___34417__$1){
var seq__33360_34418__$1 = temp__5804__auto___34417__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33360_34418__$1)){
var c__4679__auto___34419 = cljs.core.chunk_first(seq__33360_34418__$1);
var G__34420 = cljs.core.chunk_rest(seq__33360_34418__$1);
var G__34421 = c__4679__auto___34419;
var G__34422 = cljs.core.count(c__4679__auto___34419);
var G__34423 = (0);
seq__33360_34402 = G__34420;
chunk__33362_34403 = G__34421;
count__33363_34404 = G__34422;
i__33364_34405 = G__34423;
continue;
} else {
var child_34424 = cljs.core.first(seq__33360_34418__$1);
if(cljs.core.truth_(child_34424)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34424);


var G__34425 = cljs.core.next(seq__33360_34418__$1);
var G__34426 = null;
var G__34427 = (0);
var G__34428 = (0);
seq__33360_34402 = G__34425;
chunk__33362_34403 = G__34426;
count__33363_34404 = G__34427;
i__33364_34405 = G__34428;
continue;
} else {
var G__34430 = cljs.core.next(seq__33360_34418__$1);
var G__34431 = null;
var G__34432 = (0);
var G__34433 = (0);
seq__33360_34402 = G__34430;
chunk__33362_34403 = G__34431;
count__33363_34404 = G__34432;
i__33364_34405 = G__34433;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34401);
}


var G__34434 = cljs.core.next(seq__33253_34393__$1);
var G__34435 = null;
var G__34436 = (0);
var G__34437 = (0);
seq__33253_34349 = G__34434;
chunk__33254_34350 = G__34435;
count__33255_34351 = G__34436;
i__33256_34352 = G__34437;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__33425 = cljs.core.seq(node);
var chunk__33426 = null;
var count__33427 = (0);
var i__33428 = (0);
while(true){
if((i__33428 < count__33427)){
var n = chunk__33426.cljs$core$IIndexed$_nth$arity$2(null,i__33428);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34445 = seq__33425;
var G__34446 = chunk__33426;
var G__34447 = count__33427;
var G__34448 = (i__33428 + (1));
seq__33425 = G__34445;
chunk__33426 = G__34446;
count__33427 = G__34447;
i__33428 = G__34448;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33425);
if(temp__5804__auto__){
var seq__33425__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33425__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33425__$1);
var G__34452 = cljs.core.chunk_rest(seq__33425__$1);
var G__34453 = c__4679__auto__;
var G__34454 = cljs.core.count(c__4679__auto__);
var G__34455 = (0);
seq__33425 = G__34452;
chunk__33426 = G__34453;
count__33427 = G__34454;
i__33428 = G__34455;
continue;
} else {
var n = cljs.core.first(seq__33425__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34456 = cljs.core.next(seq__33425__$1);
var G__34457 = null;
var G__34458 = (0);
var G__34459 = (0);
seq__33425 = G__34456;
chunk__33426 = G__34457;
count__33427 = G__34458;
i__33428 = G__34459;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__33458 = arguments.length;
switch (G__33458) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__33469 = arguments.length;
switch (G__33469) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__33490 = arguments.length;
switch (G__33490) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___34543 = arguments.length;
var i__4865__auto___34545 = (0);
while(true){
if((i__4865__auto___34545 < len__4864__auto___34543)){
args__4870__auto__.push((arguments[i__4865__auto___34545]));

var G__34546 = (i__4865__auto___34545 + (1));
i__4865__auto___34545 = G__34546;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__33551_34550 = cljs.core.seq(nodes);
var chunk__33552_34551 = null;
var count__33553_34552 = (0);
var i__33554_34553 = (0);
while(true){
if((i__33554_34553 < count__33553_34552)){
var node_34554 = chunk__33552_34551.cljs$core$IIndexed$_nth$arity$2(null,i__33554_34553);
fragment.appendChild(shadow.dom._to_dom(node_34554));


var G__34559 = seq__33551_34550;
var G__34560 = chunk__33552_34551;
var G__34561 = count__33553_34552;
var G__34562 = (i__33554_34553 + (1));
seq__33551_34550 = G__34559;
chunk__33552_34551 = G__34560;
count__33553_34552 = G__34561;
i__33554_34553 = G__34562;
continue;
} else {
var temp__5804__auto___34563 = cljs.core.seq(seq__33551_34550);
if(temp__5804__auto___34563){
var seq__33551_34566__$1 = temp__5804__auto___34563;
if(cljs.core.chunked_seq_QMARK_(seq__33551_34566__$1)){
var c__4679__auto___34567 = cljs.core.chunk_first(seq__33551_34566__$1);
var G__34568 = cljs.core.chunk_rest(seq__33551_34566__$1);
var G__34569 = c__4679__auto___34567;
var G__34570 = cljs.core.count(c__4679__auto___34567);
var G__34571 = (0);
seq__33551_34550 = G__34568;
chunk__33552_34551 = G__34569;
count__33553_34552 = G__34570;
i__33554_34553 = G__34571;
continue;
} else {
var node_34572 = cljs.core.first(seq__33551_34566__$1);
fragment.appendChild(shadow.dom._to_dom(node_34572));


var G__34573 = cljs.core.next(seq__33551_34566__$1);
var G__34574 = null;
var G__34575 = (0);
var G__34576 = (0);
seq__33551_34550 = G__34573;
chunk__33552_34551 = G__34574;
count__33553_34552 = G__34575;
i__33554_34553 = G__34576;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq33533){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33533));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__33617_34581 = cljs.core.seq(scripts);
var chunk__33618_34582 = null;
var count__33619_34583 = (0);
var i__33620_34584 = (0);
while(true){
if((i__33620_34584 < count__33619_34583)){
var vec__33631_34585 = chunk__33618_34582.cljs$core$IIndexed$_nth$arity$2(null,i__33620_34584);
var script_tag_34586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33631_34585,(0),null);
var script_body_34587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33631_34585,(1),null);
eval(script_body_34587);


var G__34591 = seq__33617_34581;
var G__34592 = chunk__33618_34582;
var G__34593 = count__33619_34583;
var G__34594 = (i__33620_34584 + (1));
seq__33617_34581 = G__34591;
chunk__33618_34582 = G__34592;
count__33619_34583 = G__34593;
i__33620_34584 = G__34594;
continue;
} else {
var temp__5804__auto___34595 = cljs.core.seq(seq__33617_34581);
if(temp__5804__auto___34595){
var seq__33617_34596__$1 = temp__5804__auto___34595;
if(cljs.core.chunked_seq_QMARK_(seq__33617_34596__$1)){
var c__4679__auto___34597 = cljs.core.chunk_first(seq__33617_34596__$1);
var G__34598 = cljs.core.chunk_rest(seq__33617_34596__$1);
var G__34599 = c__4679__auto___34597;
var G__34600 = cljs.core.count(c__4679__auto___34597);
var G__34601 = (0);
seq__33617_34581 = G__34598;
chunk__33618_34582 = G__34599;
count__33619_34583 = G__34600;
i__33620_34584 = G__34601;
continue;
} else {
var vec__33641_34602 = cljs.core.first(seq__33617_34596__$1);
var script_tag_34603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33641_34602,(0),null);
var script_body_34604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33641_34602,(1),null);
eval(script_body_34604);


var G__34608 = cljs.core.next(seq__33617_34596__$1);
var G__34609 = null;
var G__34610 = (0);
var G__34611 = (0);
seq__33617_34581 = G__34608;
chunk__33618_34582 = G__34609;
count__33619_34583 = G__34610;
i__33620_34584 = G__34611;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__33644){
var vec__33645 = p__33644;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33645,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33645,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__33662 = arguments.length;
switch (G__33662) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__33755 = cljs.core.seq(style_keys);
var chunk__33756 = null;
var count__33757 = (0);
var i__33758 = (0);
while(true){
if((i__33758 < count__33757)){
var it = chunk__33756.cljs$core$IIndexed$_nth$arity$2(null,i__33758);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34616 = seq__33755;
var G__34617 = chunk__33756;
var G__34618 = count__33757;
var G__34619 = (i__33758 + (1));
seq__33755 = G__34616;
chunk__33756 = G__34617;
count__33757 = G__34618;
i__33758 = G__34619;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33755);
if(temp__5804__auto__){
var seq__33755__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33755__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33755__$1);
var G__34620 = cljs.core.chunk_rest(seq__33755__$1);
var G__34621 = c__4679__auto__;
var G__34622 = cljs.core.count(c__4679__auto__);
var G__34623 = (0);
seq__33755 = G__34620;
chunk__33756 = G__34621;
count__33757 = G__34622;
i__33758 = G__34623;
continue;
} else {
var it = cljs.core.first(seq__33755__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34624 = cljs.core.next(seq__33755__$1);
var G__34625 = null;
var G__34626 = (0);
var G__34627 = (0);
seq__33755 = G__34624;
chunk__33756 = G__34625;
count__33757 = G__34626;
i__33758 = G__34627;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k33831,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__33858 = k33831;
var G__33858__$1 = (((G__33858 instanceof cljs.core.Keyword))?G__33858.fqn:null);
switch (G__33858__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33831,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__33861){
var vec__33863 = p__33861;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33863,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33863,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33830){
var self__ = this;
var G__33830__$1 = this;
return (new cljs.core.RecordIter((0),G__33830__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33832,other33833){
var self__ = this;
var this33832__$1 = this;
return (((!((other33833 == null)))) && ((((this33832__$1.constructor === other33833.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33832__$1.x,other33833.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33832__$1.y,other33833.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33832__$1.__extmap,other33833.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k33831){
var self__ = this;
var this__4509__auto____$1 = this;
var G__33888 = k33831;
var G__33888__$1 = (((G__33888 instanceof cljs.core.Keyword))?G__33888.fqn:null);
switch (G__33888__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k33831);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__33830){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__33894 = cljs.core.keyword_identical_QMARK_;
var expr__33895 = k__4511__auto__;
if(cljs.core.truth_((pred__33894.cljs$core$IFn$_invoke$arity$2 ? pred__33894.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__33895) : pred__33894.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__33895)))){
return (new shadow.dom.Coordinate(G__33830,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__33894.cljs$core$IFn$_invoke$arity$2 ? pred__33894.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__33895) : pred__33894.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__33895)))){
return (new shadow.dom.Coordinate(self__.x,G__33830,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__33830),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__33830){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__33830,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__33848){
var extmap__4542__auto__ = (function (){var G__33900 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33848,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__33848)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__33900);
} else {
return G__33900;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__33848),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__33848),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k33904,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__33909 = k33904;
var G__33909__$1 = (((G__33909 instanceof cljs.core.Keyword))?G__33909.fqn:null);
switch (G__33909__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33904,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__33914){
var vec__33915 = p__33914;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33915,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33915,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33903){
var self__ = this;
var G__33903__$1 = this;
return (new cljs.core.RecordIter((0),G__33903__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33905,other33906){
var self__ = this;
var this33905__$1 = this;
return (((!((other33906 == null)))) && ((((this33905__$1.constructor === other33906.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33905__$1.w,other33906.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33905__$1.h,other33906.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33905__$1.__extmap,other33906.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k33904){
var self__ = this;
var this__4509__auto____$1 = this;
var G__33966 = k33904;
var G__33966__$1 = (((G__33966 instanceof cljs.core.Keyword))?G__33966.fqn:null);
switch (G__33966__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k33904);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__33903){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__33971 = cljs.core.keyword_identical_QMARK_;
var expr__33972 = k__4511__auto__;
if(cljs.core.truth_((pred__33971.cljs$core$IFn$_invoke$arity$2 ? pred__33971.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__33972) : pred__33971.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__33972)))){
return (new shadow.dom.Size(G__33903,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__33971.cljs$core$IFn$_invoke$arity$2 ? pred__33971.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__33972) : pred__33971.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__33972)))){
return (new shadow.dom.Size(self__.w,G__33903,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__33903),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__33903){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__33903,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__33907){
var extmap__4542__auto__ = (function (){var G__33974 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33907,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__33907)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__33974);
} else {
return G__33974;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__33907),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__33907),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__34658 = (i + (1));
var G__34659 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__34658;
ret = G__34659;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34027){
var vec__34028 = p__34027;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34028,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34028,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__34047 = arguments.length;
switch (G__34047) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__34674 = ps;
var G__34675 = (i + (1));
el__$1 = G__34674;
i = G__34675;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__34081 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34081,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34081,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34081,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__34084_34682 = cljs.core.seq(props);
var chunk__34085_34683 = null;
var count__34086_34684 = (0);
var i__34087_34685 = (0);
while(true){
if((i__34087_34685 < count__34086_34684)){
var vec__34098_34686 = chunk__34085_34683.cljs$core$IIndexed$_nth$arity$2(null,i__34087_34685);
var k_34687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34098_34686,(0),null);
var v_34688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34098_34686,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_34687);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34687),v_34688);


var G__34689 = seq__34084_34682;
var G__34690 = chunk__34085_34683;
var G__34691 = count__34086_34684;
var G__34692 = (i__34087_34685 + (1));
seq__34084_34682 = G__34689;
chunk__34085_34683 = G__34690;
count__34086_34684 = G__34691;
i__34087_34685 = G__34692;
continue;
} else {
var temp__5804__auto___34693 = cljs.core.seq(seq__34084_34682);
if(temp__5804__auto___34693){
var seq__34084_34694__$1 = temp__5804__auto___34693;
if(cljs.core.chunked_seq_QMARK_(seq__34084_34694__$1)){
var c__4679__auto___34695 = cljs.core.chunk_first(seq__34084_34694__$1);
var G__34696 = cljs.core.chunk_rest(seq__34084_34694__$1);
var G__34697 = c__4679__auto___34695;
var G__34698 = cljs.core.count(c__4679__auto___34695);
var G__34699 = (0);
seq__34084_34682 = G__34696;
chunk__34085_34683 = G__34697;
count__34086_34684 = G__34698;
i__34087_34685 = G__34699;
continue;
} else {
var vec__34101_34700 = cljs.core.first(seq__34084_34694__$1);
var k_34701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34101_34700,(0),null);
var v_34702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34101_34700,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_34701);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34701),v_34702);


var G__34705 = cljs.core.next(seq__34084_34694__$1);
var G__34706 = null;
var G__34707 = (0);
var G__34708 = (0);
seq__34084_34682 = G__34705;
chunk__34085_34683 = G__34706;
count__34086_34684 = G__34707;
i__34087_34685 = G__34708;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__34119 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34119,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34119,(1),null);
var seq__34122_34712 = cljs.core.seq(node_children);
var chunk__34124_34713 = null;
var count__34125_34714 = (0);
var i__34126_34715 = (0);
while(true){
if((i__34126_34715 < count__34125_34714)){
var child_struct_34716 = chunk__34124_34713.cljs$core$IIndexed$_nth$arity$2(null,i__34126_34715);
if((!((child_struct_34716 == null)))){
if(typeof child_struct_34716 === 'string'){
var text_34718 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_34718),child_struct_34716].join(''));
} else {
var children_34719 = shadow.dom.svg_node(child_struct_34716);
if(cljs.core.seq_QMARK_(children_34719)){
var seq__34144_34720 = cljs.core.seq(children_34719);
var chunk__34146_34721 = null;
var count__34147_34722 = (0);
var i__34148_34723 = (0);
while(true){
if((i__34148_34723 < count__34147_34722)){
var child_34725 = chunk__34146_34721.cljs$core$IIndexed$_nth$arity$2(null,i__34148_34723);
if(cljs.core.truth_(child_34725)){
node.appendChild(child_34725);


var G__34726 = seq__34144_34720;
var G__34727 = chunk__34146_34721;
var G__34728 = count__34147_34722;
var G__34729 = (i__34148_34723 + (1));
seq__34144_34720 = G__34726;
chunk__34146_34721 = G__34727;
count__34147_34722 = G__34728;
i__34148_34723 = G__34729;
continue;
} else {
var G__34730 = seq__34144_34720;
var G__34731 = chunk__34146_34721;
var G__34732 = count__34147_34722;
var G__34733 = (i__34148_34723 + (1));
seq__34144_34720 = G__34730;
chunk__34146_34721 = G__34731;
count__34147_34722 = G__34732;
i__34148_34723 = G__34733;
continue;
}
} else {
var temp__5804__auto___34734 = cljs.core.seq(seq__34144_34720);
if(temp__5804__auto___34734){
var seq__34144_34735__$1 = temp__5804__auto___34734;
if(cljs.core.chunked_seq_QMARK_(seq__34144_34735__$1)){
var c__4679__auto___34736 = cljs.core.chunk_first(seq__34144_34735__$1);
var G__34737 = cljs.core.chunk_rest(seq__34144_34735__$1);
var G__34738 = c__4679__auto___34736;
var G__34739 = cljs.core.count(c__4679__auto___34736);
var G__34740 = (0);
seq__34144_34720 = G__34737;
chunk__34146_34721 = G__34738;
count__34147_34722 = G__34739;
i__34148_34723 = G__34740;
continue;
} else {
var child_34745 = cljs.core.first(seq__34144_34735__$1);
if(cljs.core.truth_(child_34745)){
node.appendChild(child_34745);


var G__34746 = cljs.core.next(seq__34144_34735__$1);
var G__34747 = null;
var G__34748 = (0);
var G__34749 = (0);
seq__34144_34720 = G__34746;
chunk__34146_34721 = G__34747;
count__34147_34722 = G__34748;
i__34148_34723 = G__34749;
continue;
} else {
var G__34750 = cljs.core.next(seq__34144_34735__$1);
var G__34751 = null;
var G__34752 = (0);
var G__34753 = (0);
seq__34144_34720 = G__34750;
chunk__34146_34721 = G__34751;
count__34147_34722 = G__34752;
i__34148_34723 = G__34753;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_34719);
}
}


var G__34754 = seq__34122_34712;
var G__34755 = chunk__34124_34713;
var G__34756 = count__34125_34714;
var G__34757 = (i__34126_34715 + (1));
seq__34122_34712 = G__34754;
chunk__34124_34713 = G__34755;
count__34125_34714 = G__34756;
i__34126_34715 = G__34757;
continue;
} else {
var G__34758 = seq__34122_34712;
var G__34759 = chunk__34124_34713;
var G__34760 = count__34125_34714;
var G__34761 = (i__34126_34715 + (1));
seq__34122_34712 = G__34758;
chunk__34124_34713 = G__34759;
count__34125_34714 = G__34760;
i__34126_34715 = G__34761;
continue;
}
} else {
var temp__5804__auto___34762 = cljs.core.seq(seq__34122_34712);
if(temp__5804__auto___34762){
var seq__34122_34771__$1 = temp__5804__auto___34762;
if(cljs.core.chunked_seq_QMARK_(seq__34122_34771__$1)){
var c__4679__auto___34772 = cljs.core.chunk_first(seq__34122_34771__$1);
var G__34773 = cljs.core.chunk_rest(seq__34122_34771__$1);
var G__34774 = c__4679__auto___34772;
var G__34775 = cljs.core.count(c__4679__auto___34772);
var G__34776 = (0);
seq__34122_34712 = G__34773;
chunk__34124_34713 = G__34774;
count__34125_34714 = G__34775;
i__34126_34715 = G__34776;
continue;
} else {
var child_struct_34786 = cljs.core.first(seq__34122_34771__$1);
if((!((child_struct_34786 == null)))){
if(typeof child_struct_34786 === 'string'){
var text_34787 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_34787),child_struct_34786].join(''));
} else {
var children_34788 = shadow.dom.svg_node(child_struct_34786);
if(cljs.core.seq_QMARK_(children_34788)){
var seq__34158_34789 = cljs.core.seq(children_34788);
var chunk__34160_34790 = null;
var count__34161_34791 = (0);
var i__34162_34792 = (0);
while(true){
if((i__34162_34792 < count__34161_34791)){
var child_34796 = chunk__34160_34790.cljs$core$IIndexed$_nth$arity$2(null,i__34162_34792);
if(cljs.core.truth_(child_34796)){
node.appendChild(child_34796);


var G__34798 = seq__34158_34789;
var G__34799 = chunk__34160_34790;
var G__34800 = count__34161_34791;
var G__34801 = (i__34162_34792 + (1));
seq__34158_34789 = G__34798;
chunk__34160_34790 = G__34799;
count__34161_34791 = G__34800;
i__34162_34792 = G__34801;
continue;
} else {
var G__34802 = seq__34158_34789;
var G__34803 = chunk__34160_34790;
var G__34804 = count__34161_34791;
var G__34805 = (i__34162_34792 + (1));
seq__34158_34789 = G__34802;
chunk__34160_34790 = G__34803;
count__34161_34791 = G__34804;
i__34162_34792 = G__34805;
continue;
}
} else {
var temp__5804__auto___34806__$1 = cljs.core.seq(seq__34158_34789);
if(temp__5804__auto___34806__$1){
var seq__34158_34807__$1 = temp__5804__auto___34806__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34158_34807__$1)){
var c__4679__auto___34809 = cljs.core.chunk_first(seq__34158_34807__$1);
var G__34816 = cljs.core.chunk_rest(seq__34158_34807__$1);
var G__34817 = c__4679__auto___34809;
var G__34818 = cljs.core.count(c__4679__auto___34809);
var G__34819 = (0);
seq__34158_34789 = G__34816;
chunk__34160_34790 = G__34817;
count__34161_34791 = G__34818;
i__34162_34792 = G__34819;
continue;
} else {
var child_34820 = cljs.core.first(seq__34158_34807__$1);
if(cljs.core.truth_(child_34820)){
node.appendChild(child_34820);


var G__34821 = cljs.core.next(seq__34158_34807__$1);
var G__34822 = null;
var G__34823 = (0);
var G__34824 = (0);
seq__34158_34789 = G__34821;
chunk__34160_34790 = G__34822;
count__34161_34791 = G__34823;
i__34162_34792 = G__34824;
continue;
} else {
var G__34825 = cljs.core.next(seq__34158_34807__$1);
var G__34826 = null;
var G__34827 = (0);
var G__34828 = (0);
seq__34158_34789 = G__34825;
chunk__34160_34790 = G__34826;
count__34161_34791 = G__34827;
i__34162_34792 = G__34828;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_34788);
}
}


var G__34829 = cljs.core.next(seq__34122_34771__$1);
var G__34830 = null;
var G__34831 = (0);
var G__34832 = (0);
seq__34122_34712 = G__34829;
chunk__34124_34713 = G__34830;
count__34125_34714 = G__34831;
i__34126_34715 = G__34832;
continue;
} else {
var G__34833 = cljs.core.next(seq__34122_34771__$1);
var G__34834 = null;
var G__34835 = (0);
var G__34836 = (0);
seq__34122_34712 = G__34833;
chunk__34124_34713 = G__34834;
count__34125_34714 = G__34835;
i__34126_34715 = G__34836;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___34840 = arguments.length;
var i__4865__auto___34841 = (0);
while(true){
if((i__4865__auto___34841 < len__4864__auto___34840)){
args__4870__auto__.push((arguments[i__4865__auto___34841]));

var G__34842 = (i__4865__auto___34841 + (1));
i__4865__auto___34841 = G__34842;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq34187){
var G__34188 = cljs.core.first(seq34187);
var seq34187__$1 = cljs.core.next(seq34187);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34188,seq34187__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__34204 = arguments.length;
switch (G__34204) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__30024__auto___34854 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_34234){
var state_val_34235 = (state_34234[(1)]);
if((state_val_34235 === (1))){
var state_34234__$1 = state_34234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34234__$1,(2),once_or_cleanup);
} else {
if((state_val_34235 === (2))){
var inst_34231 = (state_34234[(2)]);
var inst_34232 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_34234__$1 = (function (){var statearr_34242 = state_34234;
(statearr_34242[(7)] = inst_34231);

return statearr_34242;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34234__$1,inst_34232);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__29726__auto__ = null;
var shadow$dom$state_machine__29726__auto____0 = (function (){
var statearr_34244 = [null,null,null,null,null,null,null,null];
(statearr_34244[(0)] = shadow$dom$state_machine__29726__auto__);

(statearr_34244[(1)] = (1));

return statearr_34244;
});
var shadow$dom$state_machine__29726__auto____1 = (function (state_34234){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_34234);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e34248){var ex__29729__auto__ = e34248;
var statearr_34249_34857 = state_34234;
(statearr_34249_34857[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_34234[(4)]))){
var statearr_34251_34858 = state_34234;
(statearr_34251_34858[(1)] = cljs.core.first((state_34234[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34860 = state_34234;
state_34234 = G__34860;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
shadow$dom$state_machine__29726__auto__ = function(state_34234){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__29726__auto____0.call(this);
case 1:
return shadow$dom$state_machine__29726__auto____1.call(this,state_34234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__29726__auto____0;
shadow$dom$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__29726__auto____1;
return shadow$dom$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_34252 = f__30025__auto__();
(statearr_34252[(6)] = c__30024__auto___34854);

return statearr_34252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
