goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__27846__27847__auto__){
if((!((p1__27846__27847__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__27846__27847__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__27846__27847__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__27846__27847__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__27846__27847__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___39847 = schema.utils.use_fn_validation;
var output_schema38911_39848 = deercreeklabs.lancaster.LancasterSchema;
var input_schema38912_39849 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker38913_39850 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema38912_39849);
}),null));
var output_checker38914_39851 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema38911_39848);
}),null));
var ret__28714__auto___39852 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__38915){
var validate__26976__auto__ = cljs.core.deref(ufv___39847);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___39854 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38915], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38916_39856 = new cljs.core.Keyword(null,"input","input",556931961);
var G__38917_39857 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__38918_39858 = input_schema38912_39849;
var G__38919_39859 = cljs.core.deref(input_checker38913_39850);
var G__38920_39860 = args__26977__auto___39854;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38916_39856,G__38917_39857,G__38918_39858,G__38919_39859,G__38920_39860) : schema.core.fn_validator.call(null,G__38916_39856,G__38917_39857,G__38918_39858,G__38919_39859,G__38920_39860));
} else {
var temp__5804__auto___39862 = (function (){var fexpr__38921 = cljs.core.deref(input_checker38913_39850);
return (fexpr__38921.cljs$core$IFn$_invoke$arity$1 ? fexpr__38921.cljs$core$IFn$_invoke$arity$1(args__26977__auto___39854) : fexpr__38921.call(null,args__26977__auto___39854));
})();
if(cljs.core.truth_(temp__5804__auto___39862)){
var error__26978__auto___39863 = temp__5804__auto___39862;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema38912_39849,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___39854,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39863], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var json = G__38915;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38922_39867 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__38923_39868 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__38924_39869 = output_schema38911_39848;
var G__38925_39870 = cljs.core.deref(output_checker38914_39851);
var G__38926_39871 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38922_39867,G__38923_39868,G__38924_39869,G__38925_39870,G__38926_39871) : schema.core.fn_validator.call(null,G__38922_39867,G__38923_39868,G__38924_39869,G__38925_39870,G__38926_39871));
} else {
var temp__5804__auto___39874 = (function (){var fexpr__38927 = cljs.core.deref(output_checker38914_39851);
return (fexpr__38927.cljs$core$IFn$_invoke$arity$1 ? fexpr__38927.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__38927.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___39874)){
var error__26978__auto___39875 = temp__5804__auto___39874;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39875], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema38911_39848,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39875], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema38911_39848,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38912_39849], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___39881 = schema.utils.use_fn_validation;
var output_schema38928_39882 = deercreeklabs.lancaster.LancasterSchema;
var input_schema38929_39883 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema38934_39884 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker38930_39885 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema38929_39883);
}),null));
var output_checker38931_39886 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema38928_39882);
}),null));
var input_checker38935_39887 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema38934_39884);
}),null));
var output_checker38936_39888 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema38928_39882);
}),null));
var ret__28714__auto___39892 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__38941 = arguments.length;
switch (G__38941) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__38932,G__38933){
var validate__26976__auto__ = cljs.core.deref(ufv___39881);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___39897 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38932,G__38933], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38942_39898 = new cljs.core.Keyword(null,"input","input",556931961);
var G__38943_39899 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__38944_39900 = input_schema38929_39883;
var G__38945_39901 = cljs.core.deref(input_checker38930_39885);
var G__38946_39902 = args__26977__auto___39897;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38942_39898,G__38943_39899,G__38944_39900,G__38945_39901,G__38946_39902) : schema.core.fn_validator.call(null,G__38942_39898,G__38943_39899,G__38944_39900,G__38945_39901,G__38946_39902));
} else {
var temp__5804__auto___39904 = (function (){var fexpr__38947 = cljs.core.deref(input_checker38930_39885);
return (fexpr__38947.cljs$core$IFn$_invoke$arity$1 ? fexpr__38947.cljs$core$IFn$_invoke$arity$1(args__26977__auto___39897) : fexpr__38947.call(null,args__26977__auto___39897));
})();
if(cljs.core.truth_(temp__5804__auto___39904)){
var error__26978__auto___39905 = temp__5804__auto___39904;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39905], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema38929_39883,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___39897,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39905], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var name_kw = G__38932;
var fields = G__38933;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38948_39910 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__38949_39911 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__38950_39912 = output_schema38928_39882;
var G__38951_39913 = cljs.core.deref(output_checker38931_39886);
var G__38952_39914 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38948_39910,G__38949_39911,G__38950_39912,G__38951_39913,G__38952_39914) : schema.core.fn_validator.call(null,G__38948_39910,G__38949_39911,G__38950_39912,G__38951_39913,G__38952_39914));
} else {
var temp__5804__auto___39917 = (function (){var fexpr__38953 = cljs.core.deref(output_checker38931_39886);
return (fexpr__38953.cljs$core$IFn$_invoke$arity$1 ? fexpr__38953.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__38953.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___39917)){
var error__26978__auto___39918 = temp__5804__auto___39917;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39918], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema38928_39882,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39918], null));
} else {
}
}
} else {
}

return o__26979__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__38937,G__38938,G__38939){
var validate__26976__auto__ = cljs.core.deref(ufv___39881);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___39925 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38937,G__38938,G__38939], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38954_39926 = new cljs.core.Keyword(null,"input","input",556931961);
var G__38955_39927 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__38956_39928 = input_schema38934_39884;
var G__38957_39929 = cljs.core.deref(input_checker38935_39887);
var G__38958_39930 = args__26977__auto___39925;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38954_39926,G__38955_39927,G__38956_39928,G__38957_39929,G__38958_39930) : schema.core.fn_validator.call(null,G__38954_39926,G__38955_39927,G__38956_39928,G__38957_39929,G__38958_39930));
} else {
var temp__5804__auto___39932 = (function (){var fexpr__38959 = cljs.core.deref(input_checker38935_39887);
return (fexpr__38959.cljs$core$IFn$_invoke$arity$1 ? fexpr__38959.cljs$core$IFn$_invoke$arity$1(args__26977__auto___39925) : fexpr__38959.call(null,args__26977__auto___39925));
})();
if(cljs.core.truth_(temp__5804__auto___39932)){
var error__26978__auto___39933 = temp__5804__auto___39932;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39933], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema38934_39884,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___39925,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39933], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var name_kw = G__38937;
var docstring = G__38938;
var fields = G__38939;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38960_39934 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__38961_39935 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__38962_39936 = output_schema38928_39882;
var G__38963_39937 = cljs.core.deref(output_checker38936_39888);
var G__38964_39938 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38960_39934,G__38961_39935,G__38962_39936,G__38963_39937,G__38964_39938) : schema.core.fn_validator.call(null,G__38960_39934,G__38961_39935,G__38962_39936,G__38963_39937,G__38964_39938));
} else {
var temp__5804__auto___39939 = (function (){var fexpr__38965 = cljs.core.deref(output_checker38936_39888);
return (fexpr__38965.cljs$core$IFn$_invoke$arity$1 ? fexpr__38965.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__38965.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___39939)){
var error__26978__auto___39940 = temp__5804__auto___39939;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39940], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema38928_39882,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39940], null));
} else {
}
}
} else {
}

return o__26979__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema38928_39882,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38929_39883,input_schema38934_39884], null)));

var ufv___39941 = schema.utils.use_fn_validation;
var output_schema38966_39942 = deercreeklabs.lancaster.LancasterSchema;
var input_schema38967_39943 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema38974_39944 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker38968_39945 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema38967_39943);
}),null));
var output_checker38969_39946 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema38966_39942);
}),null));
var input_checker38975_39947 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema38974_39944);
}),null));
var output_checker38976_39948 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema38966_39942);
}),null));
var ret__28714__auto___39949 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__38987 = arguments.length;
switch (G__38987) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__38971,G__38972){
var validate__26976__auto__ = cljs.core.deref(ufv___39941);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___39953 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38971,G__38972], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38988_39954 = new cljs.core.Keyword(null,"input","input",556931961);
var G__38989_39955 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__38990_39956 = input_schema38967_39943;
var G__38991_39957 = cljs.core.deref(input_checker38968_39945);
var G__38992_39958 = args__26977__auto___39953;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38988_39954,G__38989_39955,G__38990_39956,G__38991_39957,G__38992_39958) : schema.core.fn_validator.call(null,G__38988_39954,G__38989_39955,G__38990_39956,G__38991_39957,G__38992_39958));
} else {
var temp__5804__auto___39959 = (function (){var fexpr__38993 = cljs.core.deref(input_checker38968_39945);
return (fexpr__38993.cljs$core$IFn$_invoke$arity$1 ? fexpr__38993.cljs$core$IFn$_invoke$arity$1(args__26977__auto___39953) : fexpr__38993.call(null,args__26977__auto___39953));
})();
if(cljs.core.truth_(temp__5804__auto___39959)){
var error__26978__auto___39960 = temp__5804__auto___39959;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39960], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema38967_39943,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___39953,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39960], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var name_kw = G__38971;
var symbol_keywords = G__38972;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__38998_39961 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__38999_39962 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__39000_39963 = output_schema38966_39942;
var G__39001_39964 = cljs.core.deref(output_checker38969_39946);
var G__39002_39965 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__38998_39961,G__38999_39962,G__39000_39963,G__39001_39964,G__39002_39965) : schema.core.fn_validator.call(null,G__38998_39961,G__38999_39962,G__39000_39963,G__39001_39964,G__39002_39965));
} else {
var temp__5804__auto___39966 = (function (){var fexpr__39005 = cljs.core.deref(output_checker38969_39946);
return (fexpr__39005.cljs$core$IFn$_invoke$arity$1 ? fexpr__39005.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39005.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___39966)){
var error__26978__auto___39967 = temp__5804__auto___39966;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39967], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema38966_39942,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39967], null));
} else {
}
}
} else {
}

return o__26979__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__38977,G__38978,G__38979){
var validate__26976__auto__ = cljs.core.deref(ufv___39941);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___39968 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38977,G__38978,G__38979], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39008_39969 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39009_39970 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__39010_39971 = input_schema38974_39944;
var G__39011_39972 = cljs.core.deref(input_checker38975_39947);
var G__39012_39973 = args__26977__auto___39968;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39008_39969,G__39009_39970,G__39010_39971,G__39011_39972,G__39012_39973) : schema.core.fn_validator.call(null,G__39008_39969,G__39009_39970,G__39010_39971,G__39011_39972,G__39012_39973));
} else {
var temp__5804__auto___39974 = (function (){var fexpr__39013 = cljs.core.deref(input_checker38975_39947);
return (fexpr__39013.cljs$core$IFn$_invoke$arity$1 ? fexpr__39013.cljs$core$IFn$_invoke$arity$1(args__26977__auto___39968) : fexpr__39013.call(null,args__26977__auto___39968));
})();
if(cljs.core.truth_(temp__5804__auto___39974)){
var error__26978__auto___39975 = temp__5804__auto___39974;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39975], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema38974_39944,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___39968,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39975], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var name_kw = G__38977;
var docstring = G__38978;
var symbol_keywords = G__38979;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39014_39976 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39015_39977 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__39016_39978 = output_schema38966_39942;
var G__39017_39979 = cljs.core.deref(output_checker38976_39948);
var G__39018_39980 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39014_39976,G__39015_39977,G__39016_39978,G__39017_39979,G__39018_39980) : schema.core.fn_validator.call(null,G__39014_39976,G__39015_39977,G__39016_39978,G__39017_39979,G__39018_39980));
} else {
var temp__5804__auto___39981 = (function (){var fexpr__39019 = cljs.core.deref(output_checker38976_39948);
return (fexpr__39019.cljs$core$IFn$_invoke$arity$1 ? fexpr__39019.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39019.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___39981)){
var error__26978__auto___39982 = temp__5804__auto___39981;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39982], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema38966_39942,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39982], null));
} else {
}
}
} else {
}

return o__26979__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema38966_39942,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38967_39943,input_schema38974_39944], null)));

var ufv___39983 = schema.utils.use_fn_validation;
var output_schema39026_39984 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39027_39985 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker39028_39986 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39027_39985);
}),null));
var output_checker39029_39987 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39026_39984);
}),null));
var ret__28714__auto___39988 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__39031,G__39032){
var validate__26976__auto__ = cljs.core.deref(ufv___39983);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___39989 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39031,G__39032], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39038_39990 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39039_39991 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__39040_39992 = input_schema39027_39985;
var G__39041_39993 = cljs.core.deref(input_checker39028_39986);
var G__39042_39994 = args__26977__auto___39989;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39038_39990,G__39039_39991,G__39040_39992,G__39041_39993,G__39042_39994) : schema.core.fn_validator.call(null,G__39038_39990,G__39039_39991,G__39040_39992,G__39041_39993,G__39042_39994));
} else {
var temp__5804__auto___39995 = (function (){var fexpr__39043 = cljs.core.deref(input_checker39028_39986);
return (fexpr__39043.cljs$core$IFn$_invoke$arity$1 ? fexpr__39043.cljs$core$IFn$_invoke$arity$1(args__26977__auto___39989) : fexpr__39043.call(null,args__26977__auto___39989));
})();
if(cljs.core.truth_(temp__5804__auto___39995)){
var error__26978__auto___39996 = temp__5804__auto___39995;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___39996], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39027_39985,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___39989,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___39996], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var name_kw = G__39031;
var size = G__39032;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39045_39997 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39046_39998 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__39047_39999 = output_schema39026_39984;
var G__39048_40000 = cljs.core.deref(output_checker39029_39987);
var G__39049_40001 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39045_39997,G__39046_39998,G__39047_39999,G__39048_40000,G__39049_40001) : schema.core.fn_validator.call(null,G__39045_39997,G__39046_39998,G__39047_39999,G__39048_40000,G__39049_40001));
} else {
var temp__5804__auto___40002 = (function (){var fexpr__39050 = cljs.core.deref(output_checker39029_39987);
return (fexpr__39050.cljs$core$IFn$_invoke$arity$1 ? fexpr__39050.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39050.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40002)){
var error__26978__auto___40003 = temp__5804__auto___40002;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40003], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39026_39984,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40003], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema39026_39984,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39027_39985], null)));

var ufv___40007 = schema.utils.use_fn_validation;
var output_schema39056_40008 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39057_40009 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker39058_40010 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39057_40009);
}),null));
var output_checker39059_40011 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39056_40008);
}),null));
var ret__28714__auto___40015 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__39060){
var validate__26976__auto__ = cljs.core.deref(ufv___40007);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40016 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39060], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39066_40017 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39067_40018 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__39068_40019 = input_schema39057_40009;
var G__39069_40020 = cljs.core.deref(input_checker39058_40010);
var G__39070_40021 = args__26977__auto___40016;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39066_40017,G__39067_40018,G__39068_40019,G__39069_40020,G__39070_40021) : schema.core.fn_validator.call(null,G__39066_40017,G__39067_40018,G__39068_40019,G__39069_40020,G__39070_40021));
} else {
var temp__5804__auto___40022 = (function (){var fexpr__39071 = cljs.core.deref(input_checker39058_40010);
return (fexpr__39071.cljs$core$IFn$_invoke$arity$1 ? fexpr__39071.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40016) : fexpr__39071.call(null,args__26977__auto___40016));
})();
if(cljs.core.truth_(temp__5804__auto___40022)){
var error__26978__auto___40023 = temp__5804__auto___40022;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40023], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39057_40009,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40016,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40023], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var items_schema = G__39060;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39074_40027 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39075_40028 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__39076_40029 = output_schema39056_40008;
var G__39077_40030 = cljs.core.deref(output_checker39059_40011);
var G__39078_40031 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39074_40027,G__39075_40028,G__39076_40029,G__39077_40030,G__39078_40031) : schema.core.fn_validator.call(null,G__39074_40027,G__39075_40028,G__39076_40029,G__39077_40030,G__39078_40031));
} else {
var temp__5804__auto___40033 = (function (){var fexpr__39081 = cljs.core.deref(output_checker39059_40011);
return (fexpr__39081.cljs$core$IFn$_invoke$arity$1 ? fexpr__39081.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39081.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40033)){
var error__26978__auto___40034 = temp__5804__auto___40033;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40034], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39056_40008,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40034], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema39056_40008,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39057_40009], null)));

var ufv___40038 = schema.utils.use_fn_validation;
var output_schema39085_40039 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39086_40040 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker39087_40041 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39086_40040);
}),null));
var output_checker39088_40042 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39085_40039);
}),null));
var ret__28714__auto___40045 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__39089){
var validate__26976__auto__ = cljs.core.deref(ufv___40038);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40048 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39089], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39093_40049 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39094_40050 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__39095_40051 = input_schema39086_40040;
var G__39096_40052 = cljs.core.deref(input_checker39087_40041);
var G__39097_40053 = args__26977__auto___40048;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39093_40049,G__39094_40050,G__39095_40051,G__39096_40052,G__39097_40053) : schema.core.fn_validator.call(null,G__39093_40049,G__39094_40050,G__39095_40051,G__39096_40052,G__39097_40053));
} else {
var temp__5804__auto___40056 = (function (){var fexpr__39099 = cljs.core.deref(input_checker39087_40041);
return (fexpr__39099.cljs$core$IFn$_invoke$arity$1 ? fexpr__39099.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40048) : fexpr__39099.call(null,args__26977__auto___40048));
})();
if(cljs.core.truth_(temp__5804__auto___40056)){
var error__26978__auto___40057 = temp__5804__auto___40056;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40057], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39086_40040,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40048,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40057], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var values_schema = G__39089;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39102_40067 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39103_40068 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__39104_40069 = output_schema39085_40039;
var G__39105_40070 = cljs.core.deref(output_checker39088_40042);
var G__39106_40071 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39102_40067,G__39103_40068,G__39104_40069,G__39105_40070,G__39106_40071) : schema.core.fn_validator.call(null,G__39102_40067,G__39103_40068,G__39104_40069,G__39105_40070,G__39106_40071));
} else {
var temp__5804__auto___40072 = (function (){var fexpr__39108 = cljs.core.deref(output_checker39088_40042);
return (fexpr__39108.cljs$core$IFn$_invoke$arity$1 ? fexpr__39108.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39108.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40072)){
var error__26978__auto___40073 = temp__5804__auto___40072;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40073], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39085_40039,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40073], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema39085_40039,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39086_40040], null)));

var ufv___40074 = schema.utils.use_fn_validation;
var output_schema39111_40075 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39112_40076 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker39113_40077 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39112_40076);
}),null));
var output_checker39114_40078 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39111_40075);
}),null));
var ret__28714__auto___40079 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__39115){
var validate__26976__auto__ = cljs.core.deref(ufv___40074);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40080 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39115], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39119_40081 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39120_40082 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__39121_40083 = input_schema39112_40076;
var G__39122_40084 = cljs.core.deref(input_checker39113_40077);
var G__39123_40085 = args__26977__auto___40080;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39119_40081,G__39120_40082,G__39121_40083,G__39122_40084,G__39123_40085) : schema.core.fn_validator.call(null,G__39119_40081,G__39120_40082,G__39121_40083,G__39122_40084,G__39123_40085));
} else {
var temp__5804__auto___40086 = (function (){var fexpr__39125 = cljs.core.deref(input_checker39113_40077);
return (fexpr__39125.cljs$core$IFn$_invoke$arity$1 ? fexpr__39125.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40080) : fexpr__39125.call(null,args__26977__auto___40080));
})();
if(cljs.core.truth_(temp__5804__auto___40086)){
var error__26978__auto___40087 = temp__5804__auto___40086;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40087], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39112_40076,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40080,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40087], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var member_schemas = G__39115;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39127_40088 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39128_40089 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__39129_40090 = output_schema39111_40075;
var G__39130_40091 = cljs.core.deref(output_checker39114_40078);
var G__39131_40092 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39127_40088,G__39128_40089,G__39129_40090,G__39130_40091,G__39131_40092) : schema.core.fn_validator.call(null,G__39127_40088,G__39128_40089,G__39129_40090,G__39130_40091,G__39131_40092));
} else {
var temp__5804__auto___40094 = (function (){var fexpr__39133 = cljs.core.deref(output_checker39114_40078);
return (fexpr__39133.cljs$core$IFn$_invoke$arity$1 ? fexpr__39133.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39133.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40094)){
var error__26978__auto___40095 = temp__5804__auto___40094;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40095], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39111_40075,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40095], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema39111_40075,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39112_40076], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___40100 = schema.utils.use_fn_validation;
var output_schema39137_40101 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39138_40102 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker39139_40103 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39138_40102);
}),null));
var output_checker39140_40104 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39137_40101);
}),null));
var ret__28714__auto___40105 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__39141){
var validate__26976__auto__ = cljs.core.deref(ufv___40100);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40108 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39141], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39145_40110 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39146_40111 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__39147_40112 = input_schema39138_40102;
var G__39148_40113 = cljs.core.deref(input_checker39139_40103);
var G__39149_40114 = args__26977__auto___40108;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39145_40110,G__39146_40111,G__39147_40112,G__39148_40113,G__39149_40114) : schema.core.fn_validator.call(null,G__39145_40110,G__39146_40111,G__39147_40112,G__39148_40113,G__39149_40114));
} else {
var temp__5804__auto___40116 = (function (){var fexpr__39151 = cljs.core.deref(input_checker39139_40103);
return (fexpr__39151.cljs$core$IFn$_invoke$arity$1 ? fexpr__39151.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40108) : fexpr__39151.call(null,args__26977__auto___40108));
})();
if(cljs.core.truth_(temp__5804__auto___40116)){
var error__26978__auto___40119 = temp__5804__auto___40116;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40119], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39138_40102,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40108,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40119], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39141;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39153_40121 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39154_40122 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__39155_40123 = output_schema39137_40101;
var G__39156_40124 = cljs.core.deref(output_checker39140_40104);
var G__39157_40125 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39153_40121,G__39154_40122,G__39155_40123,G__39156_40124,G__39157_40125) : schema.core.fn_validator.call(null,G__39153_40121,G__39154_40122,G__39155_40123,G__39156_40124,G__39157_40125));
} else {
var temp__5804__auto___40127 = (function (){var fexpr__39159 = cljs.core.deref(output_checker39140_40104);
return (fexpr__39159.cljs$core$IFn$_invoke$arity$1 ? fexpr__39159.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39159.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40127)){
var error__26978__auto___40128 = temp__5804__auto___40127;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40128], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39137_40101,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40128], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema39137_40101,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39138_40102], null)));

var ufv___40130 = schema.utils.use_fn_validation;
var output_schema39163_40131 = deercreeklabs.baracus.ByteArray;
var input_schema39164_40132 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker39165_40133 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39164_40132);
}),null));
var output_checker39166_40134 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39163_40131);
}),null));
var ret__28714__auto___40140 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__39167,G__39168){
var validate__26976__auto__ = cljs.core.deref(ufv___40130);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40141 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39167,G__39168], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39173_40142 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39174_40143 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__39175_40144 = input_schema39164_40132;
var G__39176_40145 = cljs.core.deref(input_checker39165_40133);
var G__39177_40146 = args__26977__auto___40141;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39173_40142,G__39174_40143,G__39175_40144,G__39176_40145,G__39177_40146) : schema.core.fn_validator.call(null,G__39173_40142,G__39174_40143,G__39175_40144,G__39176_40145,G__39177_40146));
} else {
var temp__5804__auto___40148 = (function (){var fexpr__39178 = cljs.core.deref(input_checker39165_40133);
return (fexpr__39178.cljs$core$IFn$_invoke$arity$1 ? fexpr__39178.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40141) : fexpr__39178.call(null,args__26977__auto___40141));
})();
if(cljs.core.truth_(temp__5804__auto___40148)){
var error__26978__auto___40149 = temp__5804__auto___40148;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40149], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39164_40132,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40141,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40149], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var writer_schema = G__39167;
var data = G__39168;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39191_40155 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39192_40156 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__39193_40157 = output_schema39163_40131;
var G__39194_40158 = cljs.core.deref(output_checker39166_40134);
var G__39195_40159 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39191_40155,G__39192_40156,G__39193_40157,G__39194_40158,G__39195_40159) : schema.core.fn_validator.call(null,G__39191_40155,G__39192_40156,G__39193_40157,G__39194_40158,G__39195_40159));
} else {
var temp__5804__auto___40160 = (function (){var fexpr__39200 = cljs.core.deref(output_checker39166_40134);
return (fexpr__39200.cljs$core$IFn$_invoke$arity$1 ? fexpr__39200.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39200.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40160)){
var error__26978__auto___40162 = temp__5804__auto___40160;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40162], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39163_40131,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40162], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema39163_40131,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39164_40132], null)));

var ufv___40169 = schema.utils.use_fn_validation;
var output_schema39211_40170 = schema.core.Any;
var input_schema39212_40171 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker39213_40172 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39212_40171);
}),null));
var output_checker39214_40173 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39211_40170);
}),null));
var ret__28714__auto___40174 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__39215,G__39216,G__39217){
var validate__26976__auto__ = cljs.core.deref(ufv___40169);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40175 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39215,G__39216,G__39217], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39221_40176 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39222_40177 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__39223_40178 = input_schema39212_40171;
var G__39224_40179 = cljs.core.deref(input_checker39213_40172);
var G__39225_40180 = args__26977__auto___40175;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39221_40176,G__39222_40177,G__39223_40178,G__39224_40179,G__39225_40180) : schema.core.fn_validator.call(null,G__39221_40176,G__39222_40177,G__39223_40178,G__39224_40179,G__39225_40180));
} else {
var temp__5804__auto___40186 = (function (){var fexpr__39226 = cljs.core.deref(input_checker39213_40172);
return (fexpr__39226.cljs$core$IFn$_invoke$arity$1 ? fexpr__39226.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40175) : fexpr__39226.call(null,args__26977__auto___40175));
})();
if(cljs.core.truth_(temp__5804__auto___40186)){
var error__26978__auto___40187 = temp__5804__auto___40186;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40187], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39212_40171,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40175,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40187], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var reader_schema = G__39215;
var writer_schema = G__39216;
var ba = G__39217;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39239_40197 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39240_40198 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__39241_40199 = output_schema39211_40170;
var G__39242_40200 = cljs.core.deref(output_checker39214_40173);
var G__39243_40201 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39239_40197,G__39240_40198,G__39241_40199,G__39242_40200,G__39243_40201) : schema.core.fn_validator.call(null,G__39239_40197,G__39240_40198,G__39241_40199,G__39242_40200,G__39243_40201));
} else {
var temp__5804__auto___40206 = (function (){var fexpr__39244 = cljs.core.deref(output_checker39214_40173);
return (fexpr__39244.cljs$core$IFn$_invoke$arity$1 ? fexpr__39244.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39244.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40206)){
var error__26978__auto___40207 = temp__5804__auto___40206;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40207], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39211_40170,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40207], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema39211_40170,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39212_40171], null)));

var ufv___40209 = schema.utils.use_fn_validation;
var output_schema39249_40210 = schema.core.Any;
var input_schema39250_40211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker39251_40212 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39250_40211);
}),null));
var output_checker39252_40213 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39249_40210);
}),null));
var ret__28714__auto___40216 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__39253,G__39254){
var validate__26976__auto__ = cljs.core.deref(ufv___40209);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40219 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39253,G__39254], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39257_40220 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39258_40221 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__39259_40222 = input_schema39250_40211;
var G__39260_40223 = cljs.core.deref(input_checker39251_40212);
var G__39261_40224 = args__26977__auto___40219;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39257_40220,G__39258_40221,G__39259_40222,G__39260_40223,G__39261_40224) : schema.core.fn_validator.call(null,G__39257_40220,G__39258_40221,G__39259_40222,G__39260_40223,G__39261_40224));
} else {
var temp__5804__auto___40225 = (function (){var fexpr__39263 = cljs.core.deref(input_checker39251_40212);
return (fexpr__39263.cljs$core$IFn$_invoke$arity$1 ? fexpr__39263.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40219) : fexpr__39263.call(null,args__26977__auto___40219));
})();
if(cljs.core.truth_(temp__5804__auto___40225)){
var error__26978__auto___40226 = temp__5804__auto___40225;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40226], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39250_40211,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40219,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40226], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39253;
var ba = G__39254;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39266_40230 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39267_40231 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__39268_40232 = output_schema39249_40210;
var G__39269_40233 = cljs.core.deref(output_checker39252_40213);
var G__39270_40234 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39266_40230,G__39267_40231,G__39268_40232,G__39269_40233,G__39270_40234) : schema.core.fn_validator.call(null,G__39266_40230,G__39267_40231,G__39268_40232,G__39269_40233,G__39270_40234));
} else {
var temp__5804__auto___40237 = (function (){var fexpr__39272 = cljs.core.deref(output_checker39252_40213);
return (fexpr__39272.cljs$core$IFn$_invoke$arity$1 ? fexpr__39272.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39272.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40237)){
var error__26978__auto___40238 = temp__5804__auto___40237;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40238], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39249_40210,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40238], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema39249_40210,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39250_40211], null)));

var ufv___40242 = schema.utils.use_fn_validation;
var output_schema39276_40243 = schema.core.Any;
var input_schema39277_40244 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39278_40245 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39277_40244);
}),null));
var output_checker39279_40246 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39276_40243);
}),null));
var ret__28714__auto___40250 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__39280){
var validate__26976__auto__ = cljs.core.deref(ufv___40242);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40254 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39280], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39289_40256 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39290_40257 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__39291_40258 = input_schema39277_40244;
var G__39292_40259 = cljs.core.deref(input_checker39278_40245);
var G__39293_40260 = args__26977__auto___40254;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39289_40256,G__39290_40257,G__39291_40258,G__39292_40259,G__39293_40260) : schema.core.fn_validator.call(null,G__39289_40256,G__39290_40257,G__39291_40258,G__39292_40259,G__39293_40260));
} else {
var temp__5804__auto___40264 = (function (){var fexpr__39294 = cljs.core.deref(input_checker39278_40245);
return (fexpr__39294.cljs$core$IFn$_invoke$arity$1 ? fexpr__39294.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40254) : fexpr__39294.call(null,args__26977__auto___40254));
})();
if(cljs.core.truth_(temp__5804__auto___40264)){
var error__26978__auto___40265 = temp__5804__auto___40264;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40265], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39277_40244,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40254,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40265], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39280;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39296_40266 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39297_40267 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__39298_40268 = output_schema39276_40243;
var G__39299_40269 = cljs.core.deref(output_checker39279_40246);
var G__39300_40270 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39296_40266,G__39297_40267,G__39298_40268,G__39299_40269,G__39300_40270) : schema.core.fn_validator.call(null,G__39296_40266,G__39297_40267,G__39298_40268,G__39299_40269,G__39300_40270));
} else {
var temp__5804__auto___40272 = (function (){var fexpr__39302 = cljs.core.deref(output_checker39279_40246);
return (fexpr__39302.cljs$core$IFn$_invoke$arity$1 ? fexpr__39302.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39302.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40272)){
var error__26978__auto___40274 = temp__5804__auto___40272;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40274], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39276_40243,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40274], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema39276_40243,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39277_40244], null)));

var ufv___40275 = schema.utils.use_fn_validation;
var output_schema39309_40276 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39310_40277 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker39311_40278 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39310_40277);
}),null));
var output_checker39312_40279 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39309_40276);
}),null));
var ret__28714__auto___40280 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__39313){
var validate__26976__auto__ = cljs.core.deref(ufv___40275);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40281 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39313], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39318_40282 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39319_40283 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__39320_40284 = input_schema39310_40277;
var G__39321_40285 = cljs.core.deref(input_checker39311_40278);
var G__39322_40286 = args__26977__auto___40281;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39318_40282,G__39319_40283,G__39320_40284,G__39321_40285,G__39322_40286) : schema.core.fn_validator.call(null,G__39318_40282,G__39319_40283,G__39320_40284,G__39321_40285,G__39322_40286));
} else {
var temp__5804__auto___40287 = (function (){var fexpr__39327 = cljs.core.deref(input_checker39311_40278);
return (fexpr__39327.cljs$core$IFn$_invoke$arity$1 ? fexpr__39327.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40281) : fexpr__39327.call(null,args__26977__auto___40281));
})();
if(cljs.core.truth_(temp__5804__auto___40287)){
var error__26978__auto___40288 = temp__5804__auto___40287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40288], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39310_40277,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40281,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40288], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var edn = G__39313;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema(edn);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39334_40289 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39335_40290 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__39336_40291 = output_schema39309_40276;
var G__39337_40292 = cljs.core.deref(output_checker39312_40279);
var G__39338_40293 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39334_40289,G__39335_40290,G__39336_40291,G__39337_40292,G__39338_40293) : schema.core.fn_validator.call(null,G__39334_40289,G__39335_40290,G__39336_40291,G__39337_40292,G__39338_40293));
} else {
var temp__5804__auto___40294 = (function (){var fexpr__39340 = cljs.core.deref(output_checker39312_40279);
return (fexpr__39340.cljs$core$IFn$_invoke$arity$1 ? fexpr__39340.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39340.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40294)){
var error__26978__auto___40295 = temp__5804__auto___40294;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40295], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39309_40276,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40295], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema39309_40276,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39310_40277], null)));

var ufv___40303 = schema.utils.use_fn_validation;
var output_schema39344_40304 = schema.core.Str;
var input_schema39345_40305 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39346_40306 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39345_40305);
}),null));
var output_checker39347_40307 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39344_40304);
}),null));
var ret__28714__auto___40310 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__39348){
var validate__26976__auto__ = cljs.core.deref(ufv___40303);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40311 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39348], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39356_40312 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39357_40313 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__39358_40314 = input_schema39345_40305;
var G__39359_40315 = cljs.core.deref(input_checker39346_40306);
var G__39360_40316 = args__26977__auto___40311;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39356_40312,G__39357_40313,G__39358_40314,G__39359_40315,G__39360_40316) : schema.core.fn_validator.call(null,G__39356_40312,G__39357_40313,G__39358_40314,G__39359_40315,G__39360_40316));
} else {
var temp__5804__auto___40322 = (function (){var fexpr__39364 = cljs.core.deref(input_checker39346_40306);
return (fexpr__39364.cljs$core$IFn$_invoke$arity$1 ? fexpr__39364.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40311) : fexpr__39364.call(null,args__26977__auto___40311));
})();
if(cljs.core.truth_(temp__5804__auto___40322)){
var error__26978__auto___40323 = temp__5804__auto___40322;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40323], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39345_40305,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40311,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40323], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39348;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39365_40329 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39366_40330 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__39367_40331 = output_schema39344_40304;
var G__39368_40332 = cljs.core.deref(output_checker39347_40307);
var G__39369_40333 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39365_40329,G__39366_40330,G__39367_40331,G__39368_40332,G__39369_40333) : schema.core.fn_validator.call(null,G__39365_40329,G__39366_40330,G__39367_40331,G__39368_40332,G__39369_40333));
} else {
var temp__5804__auto___40334 = (function (){var fexpr__39371 = cljs.core.deref(output_checker39347_40307);
return (fexpr__39371.cljs$core$IFn$_invoke$arity$1 ? fexpr__39371.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39371.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40334)){
var error__26978__auto___40339 = temp__5804__auto___40334;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40339], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39344_40304,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40339], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema39344_40304,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39345_40305], null)));

var ufv___40345 = schema.utils.use_fn_validation;
var output_schema39375_40346 = schema.core.Keyword;
var input_schema39376_40347 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39377_40348 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39376_40347);
}),null));
var output_checker39378_40349 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39375_40346);
}),null));
var ret__28714__auto___40350 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__39379){
var validate__26976__auto__ = cljs.core.deref(ufv___40345);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40352 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39379], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39381_40353 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39382_40354 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__39383_40355 = input_schema39376_40347;
var G__39384_40356 = cljs.core.deref(input_checker39377_40348);
var G__39385_40357 = args__26977__auto___40352;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39381_40353,G__39382_40354,G__39383_40355,G__39384_40356,G__39385_40357) : schema.core.fn_validator.call(null,G__39381_40353,G__39382_40354,G__39383_40355,G__39384_40356,G__39385_40357));
} else {
var temp__5804__auto___40360 = (function (){var fexpr__39388 = cljs.core.deref(input_checker39377_40348);
return (fexpr__39388.cljs$core$IFn$_invoke$arity$1 ? fexpr__39388.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40352) : fexpr__39388.call(null,args__26977__auto___40352));
})();
if(cljs.core.truth_(temp__5804__auto___40360)){
var error__26978__auto___40361 = temp__5804__auto___40360;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40361], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39376_40347,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40352,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40361], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39379;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39391_40371 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39392_40372 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__39393_40373 = output_schema39375_40346;
var G__39394_40374 = cljs.core.deref(output_checker39378_40349);
var G__39395_40375 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39391_40371,G__39392_40372,G__39393_40373,G__39394_40374,G__39395_40375) : schema.core.fn_validator.call(null,G__39391_40371,G__39392_40372,G__39393_40373,G__39394_40374,G__39395_40375));
} else {
var temp__5804__auto___40377 = (function (){var fexpr__39398 = cljs.core.deref(output_checker39378_40349);
return (fexpr__39398.cljs$core$IFn$_invoke$arity$1 ? fexpr__39398.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39398.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40377)){
var error__26978__auto___40379 = temp__5804__auto___40377;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40379], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39375_40346,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40379], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema39375_40346,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39376_40347], null)));

var ufv___40381 = schema.utils.use_fn_validation;
var output_schema39401_40382 = schema.core.Str;
var input_schema39402_40383 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39403_40384 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39402_40383);
}),null));
var output_checker39404_40385 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39401_40382);
}),null));
var ret__28714__auto___40386 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__39405){
var validate__26976__auto__ = cljs.core.deref(ufv___40381);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40387 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39405], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39413_40388 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39414_40389 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__39415_40390 = input_schema39402_40383;
var G__39416_40391 = cljs.core.deref(input_checker39403_40384);
var G__39417_40392 = args__26977__auto___40387;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39413_40388,G__39414_40389,G__39415_40390,G__39416_40391,G__39417_40392) : schema.core.fn_validator.call(null,G__39413_40388,G__39414_40389,G__39415_40390,G__39416_40391,G__39417_40392));
} else {
var temp__5804__auto___40394 = (function (){var fexpr__39421 = cljs.core.deref(input_checker39403_40384);
return (fexpr__39421.cljs$core$IFn$_invoke$arity$1 ? fexpr__39421.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40387) : fexpr__39421.call(null,args__26977__auto___40387));
})();
if(cljs.core.truth_(temp__5804__auto___40394)){
var error__26978__auto___40395 = temp__5804__auto___40394;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40395], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39402_40383,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40387,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40395], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39405;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39423_40396 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39424_40397 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__39425_40398 = output_schema39401_40382;
var G__39426_40399 = cljs.core.deref(output_checker39404_40385);
var G__39427_40400 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39423_40396,G__39424_40397,G__39425_40398,G__39426_40399,G__39427_40400) : schema.core.fn_validator.call(null,G__39423_40396,G__39424_40397,G__39425_40398,G__39426_40399,G__39427_40400));
} else {
var temp__5804__auto___40405 = (function (){var fexpr__39428 = cljs.core.deref(output_checker39404_40385);
return (fexpr__39428.cljs$core$IFn$_invoke$arity$1 ? fexpr__39428.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39428.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40405)){
var error__26978__auto___40406 = temp__5804__auto___40405;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40406], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39401_40382,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40406], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema39401_40382,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39402_40383], null)));

var ufv___40411 = schema.utils.use_fn_validation;
var output_schema39436_40412 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema39437_40413 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39438_40414 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39437_40413);
}),null));
var output_checker39439_40415 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39436_40412);
}),null));
var ret__28714__auto___40417 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__39440){
var validate__26976__auto__ = cljs.core.deref(ufv___40411);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40419 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39440], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39447_40420 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39448_40421 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__39449_40422 = input_schema39437_40413;
var G__39450_40423 = cljs.core.deref(input_checker39438_40414);
var G__39451_40424 = args__26977__auto___40419;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39447_40420,G__39448_40421,G__39449_40422,G__39450_40423,G__39451_40424) : schema.core.fn_validator.call(null,G__39447_40420,G__39448_40421,G__39449_40422,G__39450_40423,G__39451_40424));
} else {
var temp__5804__auto___40425 = (function (){var fexpr__39455 = cljs.core.deref(input_checker39438_40414);
return (fexpr__39455.cljs$core$IFn$_invoke$arity$1 ? fexpr__39455.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40419) : fexpr__39455.call(null,args__26977__auto___40419));
})();
if(cljs.core.truth_(temp__5804__auto___40425)){
var error__26978__auto___40426 = temp__5804__auto___40425;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40426], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39437_40413,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40419,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40426], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39440;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39461_40428 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39462_40429 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__39463_40430 = output_schema39436_40412;
var G__39464_40431 = cljs.core.deref(output_checker39439_40415);
var G__39465_40432 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39461_40428,G__39462_40429,G__39463_40430,G__39464_40431,G__39465_40432) : schema.core.fn_validator.call(null,G__39461_40428,G__39462_40429,G__39463_40430,G__39464_40431,G__39465_40432));
} else {
var temp__5804__auto___40433 = (function (){var fexpr__39469 = cljs.core.deref(output_checker39439_40415);
return (fexpr__39469.cljs$core$IFn$_invoke$arity$1 ? fexpr__39469.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39469.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40433)){
var error__26978__auto___40434 = temp__5804__auto___40433;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40434], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39436_40412,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40434], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema39436_40412,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39437_40413], null)));

var ufv___40439 = schema.utils.use_fn_validation;
var output_schema39471_40440 = deercreeklabs.baracus.ByteArray;
var input_schema39472_40441 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39473_40442 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39472_40441);
}),null));
var output_checker39474_40443 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39471_40440);
}),null));
var ret__28714__auto___40444 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__39475){
var validate__26976__auto__ = cljs.core.deref(ufv___40439);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40445 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39475], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39481_40446 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39482_40447 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__39483_40448 = input_schema39472_40441;
var G__39484_40449 = cljs.core.deref(input_checker39473_40442);
var G__39485_40450 = args__26977__auto___40445;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39481_40446,G__39482_40447,G__39483_40448,G__39484_40449,G__39485_40450) : schema.core.fn_validator.call(null,G__39481_40446,G__39482_40447,G__39483_40448,G__39484_40449,G__39485_40450));
} else {
var temp__5804__auto___40452 = (function (){var fexpr__39487 = cljs.core.deref(input_checker39473_40442);
return (fexpr__39487.cljs$core$IFn$_invoke$arity$1 ? fexpr__39487.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40445) : fexpr__39487.call(null,args__26977__auto___40445));
})();
if(cljs.core.truth_(temp__5804__auto___40452)){
var error__26978__auto___40453 = temp__5804__auto___40452;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40453], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39472_40441,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40445,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40453], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39475;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39488_40458 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39489_40459 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__39490_40460 = output_schema39471_40440;
var G__39491_40461 = cljs.core.deref(output_checker39474_40443);
var G__39492_40462 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39488_40458,G__39489_40459,G__39490_40460,G__39491_40461,G__39492_40462) : schema.core.fn_validator.call(null,G__39488_40458,G__39489_40459,G__39490_40460,G__39491_40461,G__39492_40462));
} else {
var temp__5804__auto___40463 = (function (){var fexpr__39500 = cljs.core.deref(output_checker39474_40443);
return (fexpr__39500.cljs$core$IFn$_invoke$arity$1 ? fexpr__39500.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39500.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40463)){
var error__26978__auto___40465 = temp__5804__auto___40463;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40465], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39471_40440,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40465], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema39471_40440,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39472_40441], null)));

var ufv___40468 = schema.utils.use_fn_validation;
var output_schema39506_40469 = deercreeklabs.baracus.ByteArray;
var input_schema39507_40470 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39508_40471 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39507_40470);
}),null));
var output_checker39509_40472 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39506_40469);
}),null));
var ret__28714__auto___40475 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__39510){
var validate__26976__auto__ = cljs.core.deref(ufv___40468);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40476 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39510], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39515_40477 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39516_40478 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__39517_40479 = input_schema39507_40470;
var G__39518_40480 = cljs.core.deref(input_checker39508_40471);
var G__39519_40481 = args__26977__auto___40476;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39515_40477,G__39516_40478,G__39517_40479,G__39518_40480,G__39519_40481) : schema.core.fn_validator.call(null,G__39515_40477,G__39516_40478,G__39517_40479,G__39518_40480,G__39519_40481));
} else {
var temp__5804__auto___40483 = (function (){var fexpr__39525 = cljs.core.deref(input_checker39508_40471);
return (fexpr__39525.cljs$core$IFn$_invoke$arity$1 ? fexpr__39525.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40476) : fexpr__39525.call(null,args__26977__auto___40476));
})();
if(cljs.core.truth_(temp__5804__auto___40483)){
var error__26978__auto___40485 = temp__5804__auto___40483;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40485], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39507_40470,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40476,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40485], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39510;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39528_40490 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39529_40491 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__39530_40492 = output_schema39506_40469;
var G__39531_40493 = cljs.core.deref(output_checker39509_40472);
var G__39532_40494 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39528_40490,G__39529_40491,G__39530_40492,G__39531_40493,G__39532_40494) : schema.core.fn_validator.call(null,G__39528_40490,G__39529_40491,G__39530_40492,G__39531_40493,G__39532_40494));
} else {
var temp__5804__auto___40495 = (function (){var fexpr__39533 = cljs.core.deref(output_checker39509_40472);
return (fexpr__39533.cljs$core$IFn$_invoke$arity$1 ? fexpr__39533.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39533.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40495)){
var error__26978__auto___40496 = temp__5804__auto___40495;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40496], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39506_40469,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40496], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema39506_40469,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39507_40470], null)));

var ufv___40501 = schema.utils.use_fn_validation;
var output_schema39535_40502 = schema.core.Bool;
var input_schema39536_40503 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker39537_40504 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39536_40503);
}),null));
var output_checker39538_40505 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39535_40502);
}),null));
var ret__28714__auto___40506 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__39539){
var validate__26976__auto__ = cljs.core.deref(ufv___40501);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40508 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39539], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39545_40509 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39546_40510 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__39547_40511 = input_schema39536_40503;
var G__39548_40512 = cljs.core.deref(input_checker39537_40504);
var G__39549_40513 = args__26977__auto___40508;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39545_40509,G__39546_40510,G__39547_40511,G__39548_40512,G__39549_40513) : schema.core.fn_validator.call(null,G__39545_40509,G__39546_40510,G__39547_40511,G__39548_40512,G__39549_40513));
} else {
var temp__5804__auto___40516 = (function (){var fexpr__39551 = cljs.core.deref(input_checker39537_40504);
return (fexpr__39551.cljs$core$IFn$_invoke$arity$1 ? fexpr__39551.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40508) : fexpr__39551.call(null,args__26977__auto___40508));
})();
if(cljs.core.truth_(temp__5804__auto___40516)){
var error__26978__auto___40519 = temp__5804__auto___40516;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40519], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39536_40503,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40508,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40519], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var arg = G__39539;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39558_40525 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39559_40526 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__39560_40527 = output_schema39535_40502;
var G__39561_40528 = cljs.core.deref(output_checker39538_40505);
var G__39562_40529 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39558_40525,G__39559_40526,G__39560_40527,G__39561_40528,G__39562_40529) : schema.core.fn_validator.call(null,G__39558_40525,G__39559_40526,G__39560_40527,G__39561_40528,G__39562_40529));
} else {
var temp__5804__auto___40530 = (function (){var fexpr__39563 = cljs.core.deref(output_checker39538_40505);
return (fexpr__39563.cljs$core$IFn$_invoke$arity$1 ? fexpr__39563.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39563.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40530)){
var error__26978__auto___40532 = temp__5804__auto___40530;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40532], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39535_40502,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40532], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema39535_40502,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39536_40503], null)));

var ufv___40537 = schema.utils.use_fn_validation;
var output_schema39565_40538 = schema.core.Bool;
var input_schema39566_40539 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39567_40540 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39566_40539);
}),null));
var output_checker39568_40541 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39565_40538);
}),null));
var ret__28714__auto___40543 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__39569,G__39570){
var validate__26976__auto__ = cljs.core.deref(ufv___40537);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40544 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39569,G__39570], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39573_40547 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39574_40548 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__39575_40549 = input_schema39566_40539;
var G__39576_40550 = cljs.core.deref(input_checker39567_40540);
var G__39577_40551 = args__26977__auto___40544;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39573_40547,G__39574_40548,G__39575_40549,G__39576_40550,G__39577_40551) : schema.core.fn_validator.call(null,G__39573_40547,G__39574_40548,G__39575_40549,G__39576_40550,G__39577_40551));
} else {
var temp__5804__auto___40554 = (function (){var fexpr__39579 = cljs.core.deref(input_checker39567_40540);
return (fexpr__39579.cljs$core$IFn$_invoke$arity$1 ? fexpr__39579.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40544) : fexpr__39579.call(null,args__26977__auto___40544));
})();
if(cljs.core.truth_(temp__5804__auto___40554)){
var error__26978__auto___40555 = temp__5804__auto___40554;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40555], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39566_40539,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40544,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40555], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var reader_schema = G__39569;
var writer_schema = G__39570;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39588_40562 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39589_40563 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__39590_40564 = output_schema39565_40538;
var G__39591_40565 = cljs.core.deref(output_checker39568_40541);
var G__39592_40566 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39588_40562,G__39589_40563,G__39590_40564,G__39591_40565,G__39592_40566) : schema.core.fn_validator.call(null,G__39588_40562,G__39589_40563,G__39590_40564,G__39591_40565,G__39592_40566));
} else {
var temp__5804__auto___40569 = (function (){var fexpr__39593 = cljs.core.deref(output_checker39568_40541);
return (fexpr__39593.cljs$core$IFn$_invoke$arity$1 ? fexpr__39593.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39593.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40569)){
var error__26978__auto___40572 = temp__5804__auto___40569;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40572], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39565_40538,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40572], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema39565_40538,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39566_40539], null)));

var ufv___40576 = schema.utils.use_fn_validation;
var output_schema39598_40577 = schema.core.Any;
var input_schema39599_40578 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39600_40579 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39599_40578);
}),null));
var output_checker39601_40580 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39598_40577);
}),null));
var ret__28714__auto___40581 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__39602){
var validate__26976__auto__ = cljs.core.deref(ufv___40576);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40582 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39602], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39613_40583 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39614_40584 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__39615_40585 = input_schema39599_40578;
var G__39616_40586 = cljs.core.deref(input_checker39600_40579);
var G__39617_40587 = args__26977__auto___40582;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39613_40583,G__39614_40584,G__39615_40585,G__39616_40586,G__39617_40587) : schema.core.fn_validator.call(null,G__39613_40583,G__39614_40584,G__39615_40585,G__39616_40586,G__39617_40587));
} else {
var temp__5804__auto___40588 = (function (){var fexpr__39619 = cljs.core.deref(input_checker39600_40579);
return (fexpr__39619.cljs$core$IFn$_invoke$arity$1 ? fexpr__39619.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40582) : fexpr__39619.call(null,args__26977__auto___40582));
})();
if(cljs.core.truth_(temp__5804__auto___40588)){
var error__26978__auto___40590 = temp__5804__auto___40588;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40590], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39599_40578,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40582,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40590], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39602;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39624_40593 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39625_40594 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__39626_40595 = output_schema39598_40577;
var G__39627_40596 = cljs.core.deref(output_checker39601_40580);
var G__39628_40597 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39624_40593,G__39625_40594,G__39626_40595,G__39627_40596,G__39628_40597) : schema.core.fn_validator.call(null,G__39624_40593,G__39625_40594,G__39626_40595,G__39627_40596,G__39628_40597));
} else {
var temp__5804__auto___40601 = (function (){var fexpr__39631 = cljs.core.deref(output_checker39601_40580);
return (fexpr__39631.cljs$core$IFn$_invoke$arity$1 ? fexpr__39631.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39631.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40601)){
var error__26978__auto___40603 = temp__5804__auto___40601;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40603], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39598_40577,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40603], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema39598_40577,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39599_40578], null)));

var ufv___40605 = schema.utils.use_fn_validation;
var output_schema39637_40606 = schema.core.Any;
var input_schema39638_40607 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39639_40608 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39638_40607);
}),null));
var output_checker39640_40609 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39637_40606);
}),null));
var ret__28714__auto___40614 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__39641){
var validate__26976__auto__ = cljs.core.deref(ufv___40605);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40615 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39641], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39646_40616 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39647_40617 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__39648_40618 = input_schema39638_40607;
var G__39649_40619 = cljs.core.deref(input_checker39639_40608);
var G__39650_40620 = args__26977__auto___40615;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39646_40616,G__39647_40617,G__39648_40618,G__39649_40619,G__39650_40620) : schema.core.fn_validator.call(null,G__39646_40616,G__39647_40617,G__39648_40618,G__39649_40619,G__39650_40620));
} else {
var temp__5804__auto___40622 = (function (){var fexpr__39651 = cljs.core.deref(input_checker39639_40608);
return (fexpr__39651.cljs$core$IFn$_invoke$arity$1 ? fexpr__39651.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40615) : fexpr__39651.call(null,args__26977__auto___40615));
})();
if(cljs.core.truth_(temp__5804__auto___40622)){
var error__26978__auto___40623 = temp__5804__auto___40622;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40623], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39638_40607,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40615,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40623], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39641;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39661_40630 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39662_40631 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__39663_40632 = output_schema39637_40606;
var G__39664_40633 = cljs.core.deref(output_checker39640_40609);
var G__39665_40634 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39661_40630,G__39662_40631,G__39663_40632,G__39664_40633,G__39665_40634) : schema.core.fn_validator.call(null,G__39661_40630,G__39662_40631,G__39663_40632,G__39664_40633,G__39665_40634));
} else {
var temp__5804__auto___40638 = (function (){var fexpr__39670 = cljs.core.deref(output_checker39640_40609);
return (fexpr__39670.cljs$core$IFn$_invoke$arity$1 ? fexpr__39670.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39670.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40638)){
var error__26978__auto___40639 = temp__5804__auto___40638;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40639], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39637_40606,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40639], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema39637_40606,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39638_40607], null)));

var ufv___40643 = schema.utils.use_fn_validation;
var output_schema39677_40644 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema39678_40645 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker39679_40646 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39678_40645);
}),null));
var output_checker39680_40647 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39677_40644);
}),null));
var ret__28714__auto___40650 = /**
 * Inputs: [schema :- LancasterSchema path :- [s/Any]]
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(G__39681,G__39682){
var validate__26976__auto__ = cljs.core.deref(ufv___40643);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40652 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39681,G__39682], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39690_40653 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39691_40654 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__39692_40655 = input_schema39678_40645;
var G__39693_40656 = cljs.core.deref(input_checker39679_40646);
var G__39694_40657 = args__26977__auto___40652;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39690_40653,G__39691_40654,G__39692_40655,G__39693_40656,G__39694_40657) : schema.core.fn_validator.call(null,G__39690_40653,G__39691_40654,G__39692_40655,G__39693_40656,G__39694_40657));
} else {
var temp__5804__auto___40660 = (function (){var fexpr__39696 = cljs.core.deref(input_checker39679_40646);
return (fexpr__39696.cljs$core$IFn$_invoke$arity$1 ? fexpr__39696.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40652) : fexpr__39696.call(null,args__26977__auto___40652));
})();
if(cljs.core.truth_(temp__5804__auto___40660)){
var error__26978__auto___40662 = temp__5804__auto___40660;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40662], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39678_40645,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40652,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40662], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39681;
var path = G__39682;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

if((path == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path], null));
}
}

return deercreeklabs.lancaster.sub.schema_at_path(schema__$1,path);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39699_40670 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39700_40671 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__39701_40672 = output_schema39677_40644;
var G__39702_40673 = cljs.core.deref(output_checker39680_40647);
var G__39703_40674 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39699_40670,G__39700_40671,G__39701_40672,G__39702_40673,G__39703_40674) : schema.core.fn_validator.call(null,G__39699_40670,G__39700_40671,G__39701_40672,G__39702_40673,G__39703_40674));
} else {
var temp__5804__auto___40675 = (function (){var fexpr__39704 = cljs.core.deref(output_checker39680_40647);
return (fexpr__39704.cljs$core$IFn$_invoke$arity$1 ? fexpr__39704.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39704.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40675)){
var error__26978__auto___40677 = temp__5804__auto___40675;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40677], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39677_40644,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40677], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.__GT_FnSchema(output_schema39677_40644,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39678_40645], null)));

var ufv___40682 = schema.utils.use_fn_validation;
var output_schema39707_40683 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema39708_40684 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39709_40685 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39708_40684);
}),null));
var output_checker39710_40686 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39707_40683);
}),null));
var ret__28714__auto___40688 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__39711){
var validate__26976__auto__ = cljs.core.deref(ufv___40682);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40690 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39711], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39714_40691 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39715_40692 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__39716_40693 = input_schema39708_40684;
var G__39717_40694 = cljs.core.deref(input_checker39709_40685);
var G__39718_40695 = args__26977__auto___40690;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39714_40691,G__39715_40692,G__39716_40693,G__39717_40694,G__39718_40695) : schema.core.fn_validator.call(null,G__39714_40691,G__39715_40692,G__39716_40693,G__39717_40694,G__39718_40695));
} else {
var temp__5804__auto___40696 = (function (){var fexpr__39719 = cljs.core.deref(input_checker39709_40685);
return (fexpr__39719.cljs$core$IFn$_invoke$arity$1 ? fexpr__39719.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40690) : fexpr__39719.call(null,args__26977__auto___40690));
})();
if(cljs.core.truth_(temp__5804__auto___40696)){
var error__26978__auto___40699 = temp__5804__auto___40696;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40699], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39708_40684,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40690,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40699], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var union_schema = G__39711;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39722_40707 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39723_40708 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__39724_40709 = output_schema39707_40683;
var G__39725_40710 = cljs.core.deref(output_checker39710_40686);
var G__39726_40711 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39722_40707,G__39723_40708,G__39724_40709,G__39725_40710,G__39726_40711) : schema.core.fn_validator.call(null,G__39722_40707,G__39723_40708,G__39724_40709,G__39725_40710,G__39726_40711));
} else {
var temp__5804__auto___40712 = (function (){var fexpr__39732 = cljs.core.deref(output_checker39710_40686);
return (fexpr__39732.cljs$core$IFn$_invoke$arity$1 ? fexpr__39732.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39732.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40712)){
var error__26978__auto___40714 = temp__5804__auto___40712;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40714], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39707_40683,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40714], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema39707_40683,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39708_40684], null)));

var ufv___40719 = schema.utils.use_fn_validation;
var output_schema39740_40720 = deercreeklabs.lancaster.LancasterSchema;
var input_schema39741_40721 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker39742_40722 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39741_40721);
}),null));
var output_checker39743_40723 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39740_40720);
}),null));
var ret__28714__auto___40727 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__39744,G__39745){
var validate__26976__auto__ = cljs.core.deref(ufv___40719);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40730 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39744,G__39745], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39746_40731 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39747_40732 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__39748_40733 = input_schema39741_40721;
var G__39749_40734 = cljs.core.deref(input_checker39742_40722);
var G__39750_40735 = args__26977__auto___40730;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39746_40731,G__39747_40732,G__39748_40733,G__39749_40734,G__39750_40735) : schema.core.fn_validator.call(null,G__39746_40731,G__39747_40732,G__39748_40733,G__39749_40734,G__39750_40735));
} else {
var temp__5804__auto___40736 = (function (){var fexpr__39751 = cljs.core.deref(input_checker39742_40722);
return (fexpr__39751.cljs$core$IFn$_invoke$arity$1 ? fexpr__39751.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40730) : fexpr__39751.call(null,args__26977__auto___40730));
})();
if(cljs.core.truth_(temp__5804__auto___40736)){
var error__26978__auto___40738 = temp__5804__auto___40736;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40738], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39741_40721,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40730,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40738], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var union_schema = G__39744;
var branch_index = G__39745;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = branch_index;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39759_40741 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39760_40742 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__39761_40743 = output_schema39740_40720;
var G__39762_40744 = cljs.core.deref(output_checker39743_40723);
var G__39763_40745 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39759_40741,G__39760_40742,G__39761_40743,G__39762_40744,G__39763_40745) : schema.core.fn_validator.call(null,G__39759_40741,G__39760_40742,G__39761_40743,G__39762_40744,G__39763_40745));
} else {
var temp__5804__auto___40748 = (function (){var fexpr__39765 = cljs.core.deref(output_checker39743_40723);
return (fexpr__39765.cljs$core$IFn$_invoke$arity$1 ? fexpr__39765.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39765.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40748)){
var error__26978__auto___40749 = temp__5804__auto___40748;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40749], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39740_40720,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40749], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema39740_40720,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39741_40721], null)));

var ufv___40755 = schema.utils.use_fn_validation;
var output_schema39767_40756 = schema.core.Keyword;
var input_schema39768_40757 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker39769_40758 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39768_40757);
}),null));
var output_checker39770_40759 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39767_40756);
}),null));
var ret__28714__auto___40760 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__39771){
var validate__26976__auto__ = cljs.core.deref(ufv___40755);
if(cljs.core.truth_(validate__26976__auto__)){
var args__26977__auto___40761 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39771], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39776_40762 = new cljs.core.Keyword(null,"input","input",556931961);
var G__39777_40763 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__39778_40764 = input_schema39768_40757;
var G__39779_40765 = cljs.core.deref(input_checker39769_40758);
var G__39780_40766 = args__26977__auto___40761;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39776_40762,G__39777_40763,G__39778_40764,G__39779_40765,G__39780_40766) : schema.core.fn_validator.call(null,G__39776_40762,G__39777_40763,G__39778_40764,G__39779_40765,G__39780_40766));
} else {
var temp__5804__auto___40769 = (function (){var fexpr__39783 = cljs.core.deref(input_checker39769_40758);
return (fexpr__39783.cljs$core$IFn$_invoke$arity$1 ? fexpr__39783.cljs$core$IFn$_invoke$arity$1(args__26977__auto___40761) : fexpr__39783.call(null,args__26977__auto___40761));
})();
if(cljs.core.truth_(temp__5804__auto___40769)){
var error__26978__auto___40771 = temp__5804__auto___40769;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40771], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39768_40757,new cljs.core.Keyword(null,"value","value",305978217),args__26977__auto___40761,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40771], null));
} else {
}
}
} else {
}

var o__26979__auto__ = (function (){var schema__$1 = G__39771;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__26976__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__39794_40777 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__39795_40778 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__39796_40779 = output_schema39767_40756;
var G__39797_40780 = cljs.core.deref(output_checker39770_40759);
var G__39798_40781 = o__26979__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__39794_40777,G__39795_40778,G__39796_40779,G__39797_40780,G__39798_40781) : schema.core.fn_validator.call(null,G__39794_40777,G__39795_40778,G__39796_40779,G__39797_40780,G__39798_40781));
} else {
var temp__5804__auto___40782 = (function (){var fexpr__39800 = cljs.core.deref(output_checker39770_40759);
return (fexpr__39800.cljs$core$IFn$_invoke$arity$1 ? fexpr__39800.cljs$core$IFn$_invoke$arity$1(o__26979__auto__) : fexpr__39800.call(null,o__26979__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40782)){
var error__26978__auto___40783 = temp__5804__auto___40782;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__26978__auto___40783], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39767_40756,new cljs.core.Keyword(null,"value","value",305978217),o__26979__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26978__auto___40783], null));
} else {
}
}
} else {
}

return o__26979__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema39767_40756,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39768_40757], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
