goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___40438 = schema.utils.use_fn_validation;
var output_schema39986_40439 = schema.core.Bool;
var input_schema39987_40440 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker39988_40441 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema39987_40440);
}),null));
var output_checker39989_40442 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema39986_40439);
}),null));
var ret__39093__auto___40443 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__39990){
var validate__36936__auto__ = cljs.core.deref(ufv___40438);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40444 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__39990], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40000_40445 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40001_40446 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__40002_40447 = input_schema39987_40440;
var G__40003_40448 = cljs.core.deref(input_checker39988_40441);
var G__40004_40449 = args__36937__auto___40444;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40000_40445,G__40001_40446,G__40002_40447,G__40003_40448,G__40004_40449) : schema.core.fn_validator.call(null,G__40000_40445,G__40001_40446,G__40002_40447,G__40003_40448,G__40004_40449));
} else {
var temp__5804__auto___40450 = (function (){var fexpr__40005 = cljs.core.deref(input_checker39988_40441);
return (fexpr__40005.cljs$core$IFn$_invoke$arity$1 ? fexpr__40005.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40444) : fexpr__40005.call(null,args__36937__auto___40444));
})();
if(cljs.core.truth_(temp__5804__auto___40450)){
var error__36938__auto___40451 = temp__5804__auto___40450;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40451], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema39987_40440,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40444,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40451], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var arg = G__39990;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40007_40453 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40008_40454 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__40009_40455 = output_schema39986_40439;
var G__40010_40456 = cljs.core.deref(output_checker39989_40442);
var G__40011_40457 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40007_40453,G__40008_40454,G__40009_40455,G__40010_40456,G__40011_40457) : schema.core.fn_validator.call(null,G__40007_40453,G__40008_40454,G__40009_40455,G__40010_40456,G__40011_40457));
} else {
var temp__5804__auto___40458 = (function (){var fexpr__40014 = cljs.core.deref(output_checker39989_40442);
return (fexpr__40014.cljs$core$IFn$_invoke$arity$1 ? fexpr__40014.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40014.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40458)){
var error__36938__auto___40459 = temp__5804__auto___40458;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40459], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema39986_40439,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40459], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema39986_40439,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema39987_40440], null)));

var ufv___40460 = schema.utils.use_fn_validation;
var output_schema40015_40461 = deercreeklabs.baracus.ByteArray;
var input_schema40016_40462 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema40020_40463 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker40017_40464 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40016_40462);
}),null));
var output_checker40018_40465 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40015_40461);
}),null));
var input_checker40021_40466 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40020_40463);
}),null));
var output_checker40022_40467 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40015_40461);
}),null));
var ret__39093__auto___40468 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__40027 = arguments.length;
switch (G__40027) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__40019){
var validate__36936__auto__ = cljs.core.deref(ufv___40460);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40470 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40019], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40029_40471 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40030_40472 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40031_40473 = input_schema40016_40462;
var G__40032_40474 = cljs.core.deref(input_checker40017_40464);
var G__40033_40475 = args__36937__auto___40470;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40029_40471,G__40030_40472,G__40031_40473,G__40032_40474,G__40033_40475) : schema.core.fn_validator.call(null,G__40029_40471,G__40030_40472,G__40031_40473,G__40032_40474,G__40033_40475));
} else {
var temp__5804__auto___40476 = (function (){var fexpr__40034 = cljs.core.deref(input_checker40017_40464);
return (fexpr__40034.cljs$core$IFn$_invoke$arity$1 ? fexpr__40034.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40470) : fexpr__40034.call(null,args__36937__auto___40470));
})();
if(cljs.core.truth_(temp__5804__auto___40476)){
var error__36938__auto___40477 = temp__5804__auto___40476;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40477], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40016_40462,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40470,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40477], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var size_or_seq = G__40019;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40035_40478 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40036_40479 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40037_40480 = output_schema40015_40461;
var G__40038_40481 = cljs.core.deref(output_checker40018_40465);
var G__40039_40482 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40035_40478,G__40036_40479,G__40037_40480,G__40038_40481,G__40039_40482) : schema.core.fn_validator.call(null,G__40035_40478,G__40036_40479,G__40037_40480,G__40038_40481,G__40039_40482));
} else {
var temp__5804__auto___40483 = (function (){var fexpr__40040 = cljs.core.deref(output_checker40018_40465);
return (fexpr__40040.cljs$core$IFn$_invoke$arity$1 ? fexpr__40040.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40040.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40483)){
var error__36938__auto___40484 = temp__5804__auto___40483;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40484], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40015_40461,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40484], null));
} else {
}
}
} else {
}

return o__36939__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__40023,G__40024){
var validate__36936__auto__ = cljs.core.deref(ufv___40460);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40487 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40023,G__40024], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40041_40488 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40042_40489 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40043_40490 = input_schema40020_40463;
var G__40044_40491 = cljs.core.deref(input_checker40021_40466);
var G__40045_40492 = args__36937__auto___40487;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40041_40488,G__40042_40489,G__40043_40490,G__40044_40491,G__40045_40492) : schema.core.fn_validator.call(null,G__40041_40488,G__40042_40489,G__40043_40490,G__40044_40491,G__40045_40492));
} else {
var temp__5804__auto___40493 = (function (){var fexpr__40046 = cljs.core.deref(input_checker40021_40466);
return (fexpr__40046.cljs$core$IFn$_invoke$arity$1 ? fexpr__40046.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40487) : fexpr__40046.call(null,args__36937__auto___40487));
})();
if(cljs.core.truth_(temp__5804__auto___40493)){
var error__36938__auto___40494 = temp__5804__auto___40493;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40494], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40020_40463,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40487,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40494], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var size = G__40023;
var init_val_or_seq = G__40024;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40048_40496 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40049_40497 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40050_40498 = output_schema40015_40461;
var G__40051_40499 = cljs.core.deref(output_checker40022_40467);
var G__40052_40500 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40048_40496,G__40049_40497,G__40050_40498,G__40051_40499,G__40052_40500) : schema.core.fn_validator.call(null,G__40048_40496,G__40049_40497,G__40050_40498,G__40051_40499,G__40052_40500));
} else {
var temp__5804__auto___40501 = (function (){var fexpr__40053 = cljs.core.deref(output_checker40022_40467);
return (fexpr__40053.cljs$core$IFn$_invoke$arity$1 ? fexpr__40053.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40053.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40501)){
var error__36938__auto___40502 = temp__5804__auto___40501;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40502], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40015_40461,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40502], null));
} else {
}
}
} else {
}

return o__36939__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema40015_40461,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40016_40462,input_schema40020_40463], null)));

var ufv___40503 = schema.utils.use_fn_validation;
var output_schema40054_40504 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40055_40505 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker40056_40506 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40055_40505);
}),null));
var output_checker40057_40507 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40054_40504);
}),null));
var ret__39093__auto___40508 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__40058){
var validate__36936__auto__ = cljs.core.deref(ufv___40503);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40509 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40058], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40060_40510 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40061_40511 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__40062_40512 = input_schema40055_40505;
var G__40063_40513 = cljs.core.deref(input_checker40056_40506);
var G__40064_40514 = args__36937__auto___40509;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40060_40510,G__40061_40511,G__40062_40512,G__40063_40513,G__40064_40514) : schema.core.fn_validator.call(null,G__40060_40510,G__40061_40511,G__40062_40512,G__40063_40513,G__40064_40514));
} else {
var temp__5804__auto___40516 = (function (){var fexpr__40066 = cljs.core.deref(input_checker40056_40506);
return (fexpr__40066.cljs$core$IFn$_invoke$arity$1 ? fexpr__40066.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40509) : fexpr__40066.call(null,args__36937__auto___40509));
})();
if(cljs.core.truth_(temp__5804__auto___40516)){
var error__36938__auto___40517 = temp__5804__auto___40516;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40517], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40055_40505,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40509,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40517], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var arrays = G__40058;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__40067 = cljs.core.count(arrays__$1);
switch (G__40067) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__40067,arrays__$1,validate__36936__auto__,ufv___40503,output_schema40054_40504,input_schema40055_40505,input_checker40056_40506,output_checker40057_40507){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__40067,arrays__$1,validate__36936__auto__,ufv___40503,output_schema40054_40504,input_schema40055_40505,input_checker40056_40506,output_checker40057_40507))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__40067,arrays__$1,validate__36936__auto__,ufv___40503,output_schema40054_40504,input_schema40055_40505,input_checker40056_40506,output_checker40057_40507){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__40067,arrays__$1,validate__36936__auto__,ufv___40503,output_schema40054_40504,input_schema40055_40505,input_checker40056_40506,output_checker40057_40507))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40068_40520 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40069_40521 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__40070_40522 = output_schema40054_40504;
var G__40071_40523 = cljs.core.deref(output_checker40057_40507);
var G__40072_40524 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40068_40520,G__40069_40521,G__40070_40522,G__40071_40523,G__40072_40524) : schema.core.fn_validator.call(null,G__40068_40520,G__40069_40521,G__40070_40522,G__40071_40523,G__40072_40524));
} else {
var temp__5804__auto___40525 = (function (){var fexpr__40073 = cljs.core.deref(output_checker40057_40507);
return (fexpr__40073.cljs$core$IFn$_invoke$arity$1 ? fexpr__40073.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40073.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40525)){
var error__36938__auto___40526 = temp__5804__auto___40525;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40526], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40054_40504,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40526], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema40054_40504,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40055_40505], null)));

var ufv___40527 = schema.utils.use_fn_validation;
var output_schema40075_40528 = schema.core.Bool;
var input_schema40076_40529 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40077_40530 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40076_40529);
}),null));
var output_checker40078_40531 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40075_40528);
}),null));
var ret__39093__auto___40532 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__40079,G__40080){
var validate__36936__auto__ = cljs.core.deref(ufv___40527);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40533 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40079,G__40080], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40082_40534 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40083_40535 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__40084_40536 = input_schema40076_40529;
var G__40085_40537 = cljs.core.deref(input_checker40077_40530);
var G__40086_40538 = args__36937__auto___40533;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40082_40534,G__40083_40535,G__40084_40536,G__40085_40537,G__40086_40538) : schema.core.fn_validator.call(null,G__40082_40534,G__40083_40535,G__40084_40536,G__40085_40537,G__40086_40538));
} else {
var temp__5804__auto___40539 = (function (){var fexpr__40087 = cljs.core.deref(input_checker40077_40530);
return (fexpr__40087.cljs$core$IFn$_invoke$arity$1 ? fexpr__40087.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40533) : fexpr__40087.call(null,args__36937__auto___40533));
})();
if(cljs.core.truth_(temp__5804__auto___40539)){
var error__36938__auto___40540 = temp__5804__auto___40539;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40540], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40076_40529,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40533,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40540], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var a = G__40079;
var b = G__40080;
while(true){
var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__4251__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__40542 = ((i + (1)) | (0));
i = G__40542;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__4251__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40088_40543 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40089_40544 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__40090_40545 = output_schema40075_40528;
var G__40091_40546 = cljs.core.deref(output_checker40078_40531);
var G__40092_40547 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40088_40543,G__40089_40544,G__40090_40545,G__40091_40546,G__40092_40547) : schema.core.fn_validator.call(null,G__40088_40543,G__40089_40544,G__40090_40545,G__40091_40546,G__40092_40547));
} else {
var temp__5804__auto___40548 = (function (){var fexpr__40093 = cljs.core.deref(output_checker40078_40531);
return (fexpr__40093.cljs$core$IFn$_invoke$arity$1 ? fexpr__40093.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40093.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40548)){
var error__36938__auto___40549 = temp__5804__auto___40548;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40549], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40075_40528,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40549], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema40075_40528,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40076_40529], null)));

var ufv___40550 = schema.utils.use_fn_validation;
var output_schema40095_40551 = schema.core.Str;
var input_schema40096_40552 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40097_40553 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40096_40552);
}),null));
var output_checker40098_40554 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40095_40551);
}),null));
var ret__39093__auto___40555 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__40099){
var validate__36936__auto__ = cljs.core.deref(ufv___40550);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40556 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40099], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40103_40557 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40104_40558 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__40105_40559 = input_schema40096_40552;
var G__40106_40560 = cljs.core.deref(input_checker40097_40553);
var G__40107_40561 = args__36937__auto___40556;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40103_40557,G__40104_40558,G__40105_40559,G__40106_40560,G__40107_40561) : schema.core.fn_validator.call(null,G__40103_40557,G__40104_40558,G__40105_40559,G__40106_40560,G__40107_40561));
} else {
var temp__5804__auto___40562 = (function (){var fexpr__40109 = cljs.core.deref(input_checker40097_40553);
return (fexpr__40109.cljs$core$IFn$_invoke$arity$1 ? fexpr__40109.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40556) : fexpr__40109.call(null,args__36937__auto___40556));
})();
if(cljs.core.truth_(temp__5804__auto___40562)){
var error__36938__auto___40563 = temp__5804__auto___40562;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40563], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40096_40552,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40556,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40563], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40099;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40110_40564 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40111_40565 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__40112_40566 = output_schema40095_40551;
var G__40113_40567 = cljs.core.deref(output_checker40098_40554);
var G__40114_40568 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40110_40564,G__40111_40565,G__40112_40566,G__40113_40567,G__40114_40568) : schema.core.fn_validator.call(null,G__40110_40564,G__40111_40565,G__40112_40566,G__40113_40567,G__40114_40568));
} else {
var temp__5804__auto___40569 = (function (){var fexpr__40115 = cljs.core.deref(output_checker40098_40554);
return (fexpr__40115.cljs$core$IFn$_invoke$arity$1 ? fexpr__40115.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40115.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40569)){
var error__36938__auto___40570 = temp__5804__auto___40569;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40570], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40095_40551,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40570], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema40095_40551,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40096_40552], null)));

var ufv___40571 = schema.utils.use_fn_validation;
var output_schema40117_40572 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40118_40573 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema40122_40574 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema40127_40575 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker40119_40576 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40118_40573);
}),null));
var output_checker40120_40577 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40117_40572);
}),null));
var input_checker40123_40578 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40122_40574);
}),null));
var output_checker40124_40579 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40117_40572);
}),null));
var input_checker40128_40580 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40127_40575);
}),null));
var output_checker40129_40581 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40117_40572);
}),null));
var ret__39093__auto___40585 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__40135 = arguments.length;
switch (G__40135) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__40121){
var validate__36936__auto__ = cljs.core.deref(ufv___40571);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40588 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40121], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40140_40590 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40141_40591 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40142_40592 = input_schema40118_40573;
var G__40143_40593 = cljs.core.deref(input_checker40119_40576);
var G__40144_40594 = args__36937__auto___40588;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40140_40590,G__40141_40591,G__40142_40592,G__40143_40593,G__40144_40594) : schema.core.fn_validator.call(null,G__40140_40590,G__40141_40591,G__40142_40592,G__40143_40593,G__40144_40594));
} else {
var temp__5804__auto___40596 = (function (){var fexpr__40145 = cljs.core.deref(input_checker40119_40576);
return (fexpr__40145.cljs$core$IFn$_invoke$arity$1 ? fexpr__40145.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40588) : fexpr__40145.call(null,args__36937__auto___40588));
})();
if(cljs.core.truth_(temp__5804__auto___40596)){
var error__36938__auto___40597 = temp__5804__auto___40596;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40597], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40118_40573,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40588,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40597], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40121;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40147_40599 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40148_40600 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40149_40601 = output_schema40117_40572;
var G__40150_40602 = cljs.core.deref(output_checker40120_40577);
var G__40151_40603 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40147_40599,G__40148_40600,G__40149_40601,G__40150_40602,G__40151_40603) : schema.core.fn_validator.call(null,G__40147_40599,G__40148_40600,G__40149_40601,G__40150_40602,G__40151_40603));
} else {
var temp__5804__auto___40604 = (function (){var fexpr__40152 = cljs.core.deref(output_checker40120_40577);
return (fexpr__40152.cljs$core$IFn$_invoke$arity$1 ? fexpr__40152.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40152.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40604)){
var error__36938__auto___40605 = temp__5804__auto___40604;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40605], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40117_40572,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40605], null));
} else {
}
}
} else {
}

return o__36939__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__40125,G__40126){
var validate__36936__auto__ = cljs.core.deref(ufv___40571);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40607 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40125,G__40126], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40153_40608 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40154_40609 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40155_40610 = input_schema40122_40574;
var G__40156_40611 = cljs.core.deref(input_checker40123_40578);
var G__40157_40612 = args__36937__auto___40607;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40153_40608,G__40154_40609,G__40155_40610,G__40156_40611,G__40157_40612) : schema.core.fn_validator.call(null,G__40153_40608,G__40154_40609,G__40155_40610,G__40156_40611,G__40157_40612));
} else {
var temp__5804__auto___40615 = (function (){var fexpr__40158 = cljs.core.deref(input_checker40123_40578);
return (fexpr__40158.cljs$core$IFn$_invoke$arity$1 ? fexpr__40158.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40607) : fexpr__40158.call(null,args__36937__auto___40607));
})();
if(cljs.core.truth_(temp__5804__auto___40615)){
var error__36938__auto___40616 = temp__5804__auto___40615;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40616], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40122_40574,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40607,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40616], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40125;
var start = G__40126;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40161_40621 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40162_40622 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40163_40623 = output_schema40117_40572;
var G__40164_40624 = cljs.core.deref(output_checker40124_40579);
var G__40165_40625 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40161_40621,G__40162_40622,G__40163_40623,G__40164_40624,G__40165_40625) : schema.core.fn_validator.call(null,G__40161_40621,G__40162_40622,G__40163_40623,G__40164_40624,G__40165_40625));
} else {
var temp__5804__auto___40626 = (function (){var fexpr__40166 = cljs.core.deref(output_checker40124_40579);
return (fexpr__40166.cljs$core$IFn$_invoke$arity$1 ? fexpr__40166.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40166.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40626)){
var error__36938__auto___40627 = temp__5804__auto___40626;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40627], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40117_40572,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40627], null));
} else {
}
}
} else {
}

return o__36939__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__40130,G__40131,G__40132){
var validate__36936__auto__ = cljs.core.deref(ufv___40571);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40628 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40130,G__40131,G__40132], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40167_40630 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40168_40631 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40169_40632 = input_schema40127_40575;
var G__40170_40633 = cljs.core.deref(input_checker40128_40580);
var G__40171_40634 = args__36937__auto___40628;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40167_40630,G__40168_40631,G__40169_40632,G__40170_40633,G__40171_40634) : schema.core.fn_validator.call(null,G__40167_40630,G__40168_40631,G__40169_40632,G__40170_40633,G__40171_40634));
} else {
var temp__5804__auto___40638 = (function (){var fexpr__40173 = cljs.core.deref(input_checker40128_40580);
return (fexpr__40173.cljs$core$IFn$_invoke$arity$1 ? fexpr__40173.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40628) : fexpr__40173.call(null,args__36937__auto___40628));
})();
if(cljs.core.truth_(temp__5804__auto___40638)){
var error__36938__auto___40639 = temp__5804__auto___40638;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40639], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40127_40575,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40628,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40639], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40130;
var start = G__40131;
var end = G__40132;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4339__auto__ = end;
var y__4340__auto__ = cljs.core.count(ba);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40174_40640 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40175_40641 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40176_40642 = output_schema40117_40572;
var G__40177_40643 = cljs.core.deref(output_checker40129_40581);
var G__40178_40644 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40174_40640,G__40175_40641,G__40176_40642,G__40177_40643,G__40178_40644) : schema.core.fn_validator.call(null,G__40174_40640,G__40175_40641,G__40176_40642,G__40177_40643,G__40178_40644));
} else {
var temp__5804__auto___40646 = (function (){var fexpr__40180 = cljs.core.deref(output_checker40129_40581);
return (fexpr__40180.cljs$core$IFn$_invoke$arity$1 ? fexpr__40180.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40180.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40646)){
var error__36938__auto___40647 = temp__5804__auto___40646;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40647], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40117_40572,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40647], null));
} else {
}
}
} else {
}

return o__36939__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema40117_40572,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40118_40573,input_schema40122_40574,input_schema40127_40575], null)));

var ufv___40648 = schema.utils.use_fn_validation;
var output_schema40181_40649 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40182_40650 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40183_40651 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40182_40650);
}),null));
var output_checker40184_40652 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40181_40649);
}),null));
var ret__39093__auto___40655 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__40185){
var validate__36936__auto__ = cljs.core.deref(ufv___40648);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40658 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40185], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40190_40659 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40191_40660 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__40192_40661 = input_schema40182_40650;
var G__40193_40662 = cljs.core.deref(input_checker40183_40651);
var G__40194_40663 = args__36937__auto___40658;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40190_40659,G__40191_40660,G__40192_40661,G__40193_40662,G__40194_40663) : schema.core.fn_validator.call(null,G__40190_40659,G__40191_40660,G__40192_40661,G__40193_40662,G__40194_40663));
} else {
var temp__5804__auto___40664 = (function (){var fexpr__40195 = cljs.core.deref(input_checker40183_40651);
return (fexpr__40195.cljs$core$IFn$_invoke$arity$1 ? fexpr__40195.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40658) : fexpr__40195.call(null,args__36937__auto___40658));
})();
if(cljs.core.truth_(temp__5804__auto___40664)){
var error__36938__auto___40665 = temp__5804__auto___40664;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40665], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40182_40650,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40658,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40665], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40185;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4741__auto___40668 = num;
var i_40669 = (0);
while(true){
if((i_40669 < n__4741__auto___40668)){
(new$[i_40669] = (ba[(last - i_40669)]));

var G__40670 = (i_40669 + (1));
i_40669 = G__40670;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40197_40671 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40198_40672 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__40199_40673 = output_schema40181_40649;
var G__40200_40674 = cljs.core.deref(output_checker40184_40652);
var G__40201_40675 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40197_40671,G__40198_40672,G__40199_40673,G__40200_40674,G__40201_40675) : schema.core.fn_validator.call(null,G__40197_40671,G__40198_40672,G__40199_40673,G__40200_40674,G__40201_40675));
} else {
var temp__5804__auto___40677 = (function (){var fexpr__40202 = cljs.core.deref(output_checker40184_40652);
return (fexpr__40202.cljs$core$IFn$_invoke$arity$1 ? fexpr__40202.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40202.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40677)){
var error__36938__auto___40678 = temp__5804__auto___40677;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40678], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40181_40649,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40678], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema40181_40649,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40182_40650], null)));

var ufv___40681 = schema.utils.use_fn_validation;
var output_schema40204_40682 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema40206_40683 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker40207_40684 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40206_40683);
}),null));
var output_checker40208_40685 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40204_40682);
}),null));
var ret__39093__auto___40688 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__40209,G__40210){
var validate__36936__auto__ = cljs.core.deref(ufv___40681);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40689 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40209,G__40210], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40211_40690 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40212_40691 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__40213_40692 = input_schema40206_40683;
var G__40214_40693 = cljs.core.deref(input_checker40207_40684);
var G__40215_40694 = args__36937__auto___40689;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40211_40690,G__40212_40691,G__40213_40692,G__40214_40693,G__40215_40694) : schema.core.fn_validator.call(null,G__40211_40690,G__40212_40691,G__40213_40692,G__40214_40693,G__40215_40694));
} else {
var temp__5804__auto___40696 = (function (){var fexpr__40216 = cljs.core.deref(input_checker40207_40684);
return (fexpr__40216.cljs$core$IFn$_invoke$arity$1 ? fexpr__40216.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40689) : fexpr__40216.call(null,args__36937__auto___40689));
})();
if(cljs.core.truth_(temp__5804__auto___40696)){
var error__36938__auto___40697 = temp__5804__auto___40696;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40697], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40206_40683,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40689,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40697], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40209;
var fragment_size = G__40210;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__40700 = (end_offset | (0));
var G__40701 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__40700;
output = G__40701;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40217_40702 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40218_40703 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__40219_40704 = output_schema40204_40682;
var G__40220_40705 = cljs.core.deref(output_checker40208_40685);
var G__40221_40706 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40217_40702,G__40218_40703,G__40219_40704,G__40220_40705,G__40221_40706) : schema.core.fn_validator.call(null,G__40217_40702,G__40218_40703,G__40219_40704,G__40220_40705,G__40221_40706));
} else {
var temp__5804__auto___40709 = (function (){var fexpr__40222 = cljs.core.deref(output_checker40208_40685);
return (fexpr__40222.cljs$core$IFn$_invoke$arity$1 ? fexpr__40222.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40222.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40709)){
var error__36938__auto___40710 = temp__5804__auto___40709;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40710], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40204_40682,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40710], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema40204_40682,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40206_40683], null)));

var ufv___40714 = schema.utils.use_fn_validation;
var output_schema40223_40715 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema40224_40716 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40225_40717 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40224_40716);
}),null));
var output_checker40226_40718 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40223_40715);
}),null));
var ret__39093__auto___40720 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__40227){
var validate__36936__auto__ = cljs.core.deref(ufv___40714);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40721 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40227], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40229_40722 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40230_40723 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__40231_40724 = input_schema40224_40716;
var G__40232_40725 = cljs.core.deref(input_checker40225_40717);
var G__40233_40726 = args__36937__auto___40721;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40229_40722,G__40230_40723,G__40231_40724,G__40232_40725,G__40233_40726) : schema.core.fn_validator.call(null,G__40229_40722,G__40230_40723,G__40231_40724,G__40232_40725,G__40233_40726));
} else {
var temp__5804__auto___40728 = (function (){var fexpr__40234 = cljs.core.deref(input_checker40225_40717);
return (fexpr__40234.cljs$core$IFn$_invoke$arity$1 ? fexpr__40234.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40721) : fexpr__40234.call(null,args__36937__auto___40721));
})();
if(cljs.core.truth_(temp__5804__auto___40728)){
var error__36938__auto___40729 = temp__5804__auto___40728;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40729], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40224_40716,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40721,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40729], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40227;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__40743 = (n + (1));
var G__40744 = (i__$1 | (0));
var G__40745 = (out__$1 | (0));
n = G__40743;
i = G__40744;
out = G__40745;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40238_40747 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40239_40748 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__40240_40749 = output_schema40223_40715;
var G__40241_40750 = cljs.core.deref(output_checker40226_40718);
var G__40242_40751 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40238_40747,G__40239_40748,G__40240_40749,G__40241_40750,G__40242_40751) : schema.core.fn_validator.call(null,G__40238_40747,G__40239_40748,G__40240_40749,G__40241_40750,G__40242_40751));
} else {
var temp__5804__auto___40752 = (function (){var fexpr__40243 = cljs.core.deref(output_checker40226_40718);
return (fexpr__40243.cljs$core$IFn$_invoke$arity$1 ? fexpr__40243.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40243.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40752)){
var error__36938__auto___40753 = temp__5804__auto___40752;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40753], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40223_40715,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40753], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema40223_40715,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40224_40716], null)));

var ufv___40760 = schema.utils.use_fn_validation;
var output_schema40245_40761 = deercreeklabs.baracus.ByteArray;
var input_schema40246_40762 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker40247_40763 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40246_40762);
}),null));
var output_checker40248_40764 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40245_40761);
}),null));
var ret__39093__auto___40766 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__40249){
var validate__36936__auto__ = cljs.core.deref(ufv___40760);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40767 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40249], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40250_40768 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40251_40769 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__40252_40770 = input_schema40246_40762;
var G__40253_40771 = cljs.core.deref(input_checker40247_40763);
var G__40254_40772 = args__36937__auto___40767;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40250_40768,G__40251_40769,G__40252_40770,G__40253_40771,G__40254_40772) : schema.core.fn_validator.call(null,G__40250_40768,G__40251_40769,G__40252_40770,G__40253_40771,G__40254_40772));
} else {
var temp__5804__auto___40774 = (function (){var fexpr__40255 = cljs.core.deref(input_checker40247_40763);
return (fexpr__40255.cljs$core$IFn$_invoke$arity$1 ? fexpr__40255.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40767) : fexpr__40255.call(null,args__36937__auto___40767));
})();
if(cljs.core.truth_(temp__5804__auto___40774)){
var error__36938__auto___40776 = temp__5804__auto___40774;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40776], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40246_40762,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40767,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40776], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var i = G__40249;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__40780 = (n >>> (7));
var G__40781 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__40780;
out = G__40781;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40257_40782 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40258_40783 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__40259_40784 = output_schema40245_40761;
var G__40260_40785 = cljs.core.deref(output_checker40248_40764);
var G__40261_40786 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40257_40782,G__40258_40783,G__40259_40784,G__40260_40785,G__40261_40786) : schema.core.fn_validator.call(null,G__40257_40782,G__40258_40783,G__40259_40784,G__40260_40785,G__40261_40786));
} else {
var temp__5804__auto___40787 = (function (){var fexpr__40262 = cljs.core.deref(output_checker40248_40764);
return (fexpr__40262.cljs$core$IFn$_invoke$arity$1 ? fexpr__40262.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40262.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40787)){
var error__36938__auto___40788 = temp__5804__auto___40787;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40788], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40245_40761,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40788], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema40245_40761,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40246_40762], null)));

var ufv___40790 = schema.utils.use_fn_validation;
var output_schema40263_40791 = schema.core.maybe(schema.core.Str);
var input_schema40264_40792 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40265_40793 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40264_40792);
}),null));
var output_checker40266_40794 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40263_40791);
}),null));
var ret__39093__auto___40795 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__40267){
var validate__36936__auto__ = cljs.core.deref(ufv___40790);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40796 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40267], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40268_40797 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40269_40798 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__40270_40799 = input_schema40264_40792;
var G__40271_40800 = cljs.core.deref(input_checker40265_40793);
var G__40272_40801 = args__36937__auto___40796;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40268_40797,G__40269_40798,G__40270_40799,G__40271_40800,G__40272_40801) : schema.core.fn_validator.call(null,G__40268_40797,G__40269_40798,G__40270_40799,G__40271_40800,G__40272_40801));
} else {
var temp__5804__auto___40802 = (function (){var fexpr__40274 = cljs.core.deref(input_checker40265_40793);
return (fexpr__40274.cljs$core$IFn$_invoke$arity$1 ? fexpr__40274.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40796) : fexpr__40274.call(null,args__36937__auto___40796));
})();
if(cljs.core.truth_(temp__5804__auto___40802)){
var error__36938__auto___40803 = temp__5804__auto___40802;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40803], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40264_40792,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40796,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40803], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var b = G__40267;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40275_40805 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40276_40806 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__40277_40807 = output_schema40263_40791;
var G__40278_40808 = cljs.core.deref(output_checker40266_40794);
var G__40279_40809 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40275_40805,G__40276_40806,G__40277_40807,G__40278_40808,G__40279_40809) : schema.core.fn_validator.call(null,G__40275_40805,G__40276_40806,G__40277_40807,G__40278_40808,G__40279_40809));
} else {
var temp__5804__auto___40810 = (function (){var fexpr__40280 = cljs.core.deref(output_checker40266_40794);
return (fexpr__40280.cljs$core$IFn$_invoke$arity$1 ? fexpr__40280.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40280.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40810)){
var error__36938__auto___40811 = temp__5804__auto___40810;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40811], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40263_40791,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40811], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema40263_40791,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40264_40792], null)));

var ufv___40812 = schema.utils.use_fn_validation;
var output_schema40281_40813 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40282_40814 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker40283_40815 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40282_40814);
}),null));
var output_checker40284_40816 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40281_40813);
}),null));
var ret__39093__auto___40819 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__40285){
var validate__36936__auto__ = cljs.core.deref(ufv___40812);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40820 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40285], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40287_40821 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40288_40822 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40289_40823 = input_schema40282_40814;
var G__40290_40824 = cljs.core.deref(input_checker40283_40815);
var G__40291_40825 = args__36937__auto___40820;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40287_40821,G__40288_40822,G__40289_40823,G__40290_40824,G__40291_40825) : schema.core.fn_validator.call(null,G__40287_40821,G__40288_40822,G__40289_40823,G__40290_40824,G__40291_40825));
} else {
var temp__5804__auto___40827 = (function (){var fexpr__40293 = cljs.core.deref(input_checker40283_40815);
return (fexpr__40293.cljs$core$IFn$_invoke$arity$1 ? fexpr__40293.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40820) : fexpr__40293.call(null,args__36937__auto___40820));
})();
if(cljs.core.truth_(temp__5804__auto___40827)){
var error__36938__auto___40829 = temp__5804__auto___40827;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40829], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40282_40814,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40820,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40829], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var s = G__40285;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40294_40833 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40295_40834 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40296_40835 = output_schema40281_40813;
var G__40297_40836 = cljs.core.deref(output_checker40284_40816);
var G__40298_40837 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40294_40833,G__40295_40834,G__40296_40835,G__40297_40836,G__40298_40837) : schema.core.fn_validator.call(null,G__40294_40833,G__40295_40834,G__40296_40835,G__40297_40836,G__40298_40837));
} else {
var temp__5804__auto___40838 = (function (){var fexpr__40300 = cljs.core.deref(output_checker40284_40816);
return (fexpr__40300.cljs$core$IFn$_invoke$arity$1 ? fexpr__40300.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40300.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40838)){
var error__36938__auto___40840 = temp__5804__auto___40838;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40840], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40281_40813,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40840], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema40281_40813,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40282_40814], null)));

var ufv___40841 = schema.utils.use_fn_validation;
var output_schema40301_40842 = schema.core.maybe(schema.core.Str);
var input_schema40302_40843 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40303_40844 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40302_40843);
}),null));
var output_checker40304_40845 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40301_40842);
}),null));
var ret__39093__auto___40846 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__40305){
var validate__36936__auto__ = cljs.core.deref(ufv___40841);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40847 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40305], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40306_40848 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40307_40849 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40308_40850 = input_schema40302_40843;
var G__40309_40851 = cljs.core.deref(input_checker40303_40844);
var G__40310_40852 = args__36937__auto___40847;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40306_40848,G__40307_40849,G__40308_40850,G__40309_40851,G__40310_40852) : schema.core.fn_validator.call(null,G__40306_40848,G__40307_40849,G__40308_40850,G__40309_40851,G__40310_40852));
} else {
var temp__5804__auto___40853 = (function (){var fexpr__40312 = cljs.core.deref(input_checker40303_40844);
return (fexpr__40312.cljs$core$IFn$_invoke$arity$1 ? fexpr__40312.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40847) : fexpr__40312.call(null,args__36937__auto___40847));
})();
if(cljs.core.truth_(temp__5804__auto___40853)){
var error__36938__auto___40854 = temp__5804__auto___40853;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40854], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40302_40843,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40847,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40854], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40305;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40313_40855 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40314_40856 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40315_40857 = output_schema40301_40842;
var G__40316_40858 = cljs.core.deref(output_checker40304_40845);
var G__40317_40859 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40313_40855,G__40314_40856,G__40315_40857,G__40316_40858,G__40317_40859) : schema.core.fn_validator.call(null,G__40313_40855,G__40314_40856,G__40315_40857,G__40316_40858,G__40317_40859));
} else {
var temp__5804__auto___40862 = (function (){var fexpr__40318 = cljs.core.deref(output_checker40304_40845);
return (fexpr__40318.cljs$core$IFn$_invoke$arity$1 ? fexpr__40318.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40318.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40862)){
var error__36938__auto___40863 = temp__5804__auto___40862;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40301_40842,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40863], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema40301_40842,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40302_40843], null)));

var ufv___40870 = schema.utils.use_fn_validation;
var output_schema40319_40871 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40320_40872 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker40321_40873 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40320_40872);
}),null));
var output_checker40322_40874 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40319_40871);
}),null));
var ret__39093__auto___40875 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__40323){
var validate__36936__auto__ = cljs.core.deref(ufv___40870);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40876 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40323], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40325_40877 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40326_40878 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40327_40879 = input_schema40320_40872;
var G__40328_40880 = cljs.core.deref(input_checker40321_40873);
var G__40329_40881 = args__36937__auto___40876;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40325_40877,G__40326_40878,G__40327_40879,G__40328_40880,G__40329_40881) : schema.core.fn_validator.call(null,G__40325_40877,G__40326_40878,G__40327_40879,G__40328_40880,G__40329_40881));
} else {
var temp__5804__auto___40882 = (function (){var fexpr__40330 = cljs.core.deref(input_checker40321_40873);
return (fexpr__40330.cljs$core$IFn$_invoke$arity$1 ? fexpr__40330.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40876) : fexpr__40330.call(null,args__36937__auto___40876));
})();
if(cljs.core.truth_(temp__5804__auto___40882)){
var error__36938__auto___40887 = temp__5804__auto___40882;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40887], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40320_40872,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40876,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40887], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var s = G__40323;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40331_40888 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40332_40889 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40333_40890 = output_schema40319_40871;
var G__40334_40891 = cljs.core.deref(output_checker40322_40874);
var G__40335_40892 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40331_40888,G__40332_40889,G__40333_40890,G__40334_40891,G__40335_40892) : schema.core.fn_validator.call(null,G__40331_40888,G__40332_40889,G__40333_40890,G__40334_40891,G__40335_40892));
} else {
var temp__5804__auto___40893 = (function (){var fexpr__40336 = cljs.core.deref(output_checker40322_40874);
return (fexpr__40336.cljs$core$IFn$_invoke$arity$1 ? fexpr__40336.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40336.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40893)){
var error__36938__auto___40894 = temp__5804__auto___40893;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40894], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40319_40871,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40894], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema40319_40871,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40320_40872], null)));

var ufv___40898 = schema.utils.use_fn_validation;
var output_schema40338_40899 = schema.core.maybe(schema.core.Str);
var input_schema40339_40900 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40340_40901 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40339_40900);
}),null));
var output_checker40341_40902 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40338_40899);
}),null));
var ret__39093__auto___40903 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__40342){
var validate__36936__auto__ = cljs.core.deref(ufv___40898);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40904 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40342], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40344_40905 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40345_40906 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40346_40907 = input_schema40339_40900;
var G__40347_40908 = cljs.core.deref(input_checker40340_40901);
var G__40348_40909 = args__36937__auto___40904;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40344_40905,G__40345_40906,G__40346_40907,G__40347_40908,G__40348_40909) : schema.core.fn_validator.call(null,G__40344_40905,G__40345_40906,G__40346_40907,G__40347_40908,G__40348_40909));
} else {
var temp__5804__auto___40910 = (function (){var fexpr__40349 = cljs.core.deref(input_checker40340_40901);
return (fexpr__40349.cljs$core$IFn$_invoke$arity$1 ? fexpr__40349.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40904) : fexpr__40349.call(null,args__36937__auto___40904));
})();
if(cljs.core.truth_(temp__5804__auto___40910)){
var error__36938__auto___40911 = temp__5804__auto___40910;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40911], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40339_40900,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40904,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40911], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40342;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4741__auto___40913 = len;
var i_40914 = (0);
while(true){
if((i_40914 < n__4741__auto___40913)){
var b_40915 = ((ba[i_40914]) & (255));
var j_40916 = ((2) * i_40914);
(ca[j_40916] = (function (){var G__40351 = (b_40915 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__40351) : hex_chars.call(null,G__40351));
})());

(ca[(j_40916 + (1))] = (function (){var G__40352 = (b_40915 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__40352) : hex_chars.call(null,G__40352));
})());

var G__40917 = (i_40914 + (1));
i_40914 = G__40917;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40353_40918 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40354_40919 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40355_40920 = output_schema40338_40899;
var G__40356_40921 = cljs.core.deref(output_checker40341_40902);
var G__40357_40922 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40353_40918,G__40354_40919,G__40355_40920,G__40356_40921,G__40357_40922) : schema.core.fn_validator.call(null,G__40353_40918,G__40354_40919,G__40355_40920,G__40356_40921,G__40357_40922));
} else {
var temp__5804__auto___40923 = (function (){var fexpr__40358 = cljs.core.deref(output_checker40341_40902);
return (fexpr__40358.cljs$core$IFn$_invoke$arity$1 ? fexpr__40358.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40358.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40923)){
var error__36938__auto___40924 = temp__5804__auto___40923;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40924], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40338_40899,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40924], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema40338_40899,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40339_40900], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___40925 = schema.utils.use_fn_validation;
var output_schema40361_40926 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40362_40927 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker40363_40928 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40362_40927);
}),null));
var output_checker40364_40929 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40361_40926);
}),null));
var ret__39093__auto___40931 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__40365){
var validate__36936__auto__ = cljs.core.deref(ufv___40925);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40932 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40365], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40367_40933 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40368_40934 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40369_40935 = input_schema40362_40927;
var G__40370_40936 = cljs.core.deref(input_checker40363_40928);
var G__40371_40937 = args__36937__auto___40932;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40367_40933,G__40368_40934,G__40369_40935,G__40370_40936,G__40371_40937) : schema.core.fn_validator.call(null,G__40367_40933,G__40368_40934,G__40369_40935,G__40370_40936,G__40371_40937));
} else {
var temp__5804__auto___40938 = (function (){var fexpr__40372 = cljs.core.deref(input_checker40363_40928);
return (fexpr__40372.cljs$core$IFn$_invoke$arity$1 ? fexpr__40372.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40932) : fexpr__40372.call(null,args__36937__auto___40932));
})();
if(cljs.core.truth_(temp__5804__auto___40938)){
var error__36938__auto___40939 = temp__5804__auto___40938;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40939], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40362_40927,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40932,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40939], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var s = G__40365;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4741__auto___40941 = ba_len;
var i_40942 = (0);
while(true){
if((i_40942 < n__4741__auto___40941)){
var j_40943 = ((2) * i_40942);
(ba[i_40942] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_40943)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_40943 + (1))))));

var G__40944 = (i_40942 + (1));
i_40942 = G__40944;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40375_40945 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40376_40946 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40377_40947 = output_schema40361_40926;
var G__40378_40948 = cljs.core.deref(output_checker40364_40929);
var G__40379_40949 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40375_40945,G__40376_40946,G__40377_40947,G__40378_40948,G__40379_40949) : schema.core.fn_validator.call(null,G__40375_40945,G__40376_40946,G__40377_40947,G__40378_40948,G__40379_40949));
} else {
var temp__5804__auto___40950 = (function (){var fexpr__40381 = cljs.core.deref(output_checker40364_40929);
return (fexpr__40381.cljs$core$IFn$_invoke$arity$1 ? fexpr__40381.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40381.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40950)){
var error__36938__auto___40951 = temp__5804__auto___40950;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40951], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40361_40926,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40951], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema40361_40926,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40362_40927], null)));

var ufv___40952 = schema.utils.use_fn_validation;
var output_schema40382_40953 = deercreeklabs.baracus.ByteArray;
var input_schema40383_40954 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40384_40955 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40383_40954);
}),null));
var output_checker40385_40956 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40382_40953);
}),null));
var ret__39093__auto___40957 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__40386){
var validate__36936__auto__ = cljs.core.deref(ufv___40952);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40958 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40386], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40388_40959 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40389_40960 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40390_40961 = input_schema40383_40954;
var G__40391_40962 = cljs.core.deref(input_checker40384_40955);
var G__40392_40963 = args__36937__auto___40958;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40388_40959,G__40389_40960,G__40390_40961,G__40391_40962,G__40392_40963) : schema.core.fn_validator.call(null,G__40388_40959,G__40389_40960,G__40390_40961,G__40391_40962,G__40392_40963));
} else {
var temp__5804__auto___40964 = (function (){var fexpr__40393 = cljs.core.deref(input_checker40384_40955);
return (fexpr__40393.cljs$core$IFn$_invoke$arity$1 ? fexpr__40393.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40958) : fexpr__40393.call(null,args__36937__auto___40958));
})();
if(cljs.core.truth_(temp__5804__auto___40964)){
var error__36938__auto___40965 = temp__5804__auto___40964;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40965], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40383_40954,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40958,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40965], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40386;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40394_40966 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40395_40967 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40396_40968 = output_schema40382_40953;
var G__40397_40969 = cljs.core.deref(output_checker40385_40956);
var G__40398_40970 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40394_40966,G__40395_40967,G__40396_40968,G__40397_40969,G__40398_40970) : schema.core.fn_validator.call(null,G__40394_40966,G__40395_40967,G__40396_40968,G__40397_40969,G__40398_40970));
} else {
var temp__5804__auto___40971 = (function (){var fexpr__40400 = cljs.core.deref(output_checker40385_40956);
return (fexpr__40400.cljs$core$IFn$_invoke$arity$1 ? fexpr__40400.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40400.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40971)){
var error__36938__auto___40972 = temp__5804__auto___40971;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40972], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40382_40953,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40972], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema40382_40953,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40383_40954], null)));

var ufv___40973 = schema.utils.use_fn_validation;
var output_schema40401_40974 = deercreeklabs.baracus.ByteArray;
var input_schema40402_40975 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40403_40976 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40402_40975);
}),null));
var output_checker40404_40977 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40401_40974);
}),null));
var ret__39093__auto___40978 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__40405){
var validate__36936__auto__ = cljs.core.deref(ufv___40973);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___40979 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40405], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40406_40980 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40407_40981 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40408_40982 = input_schema40402_40975;
var G__40409_40983 = cljs.core.deref(input_checker40403_40976);
var G__40410_40984 = args__36937__auto___40979;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40406_40980,G__40407_40981,G__40408_40982,G__40409_40983,G__40410_40984) : schema.core.fn_validator.call(null,G__40406_40980,G__40407_40981,G__40408_40982,G__40409_40983,G__40410_40984));
} else {
var temp__5804__auto___40985 = (function (){var fexpr__40411 = cljs.core.deref(input_checker40403_40976);
return (fexpr__40411.cljs$core$IFn$_invoke$arity$1 ? fexpr__40411.cljs$core$IFn$_invoke$arity$1(args__36937__auto___40979) : fexpr__40411.call(null,args__36937__auto___40979));
})();
if(cljs.core.truth_(temp__5804__auto___40985)){
var error__36938__auto___40986 = temp__5804__auto___40985;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40986], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40402_40975,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___40979,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40986], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40405;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40413_40988 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40414_40989 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40415_40990 = output_schema40401_40974;
var G__40416_40991 = cljs.core.deref(output_checker40404_40977);
var G__40417_40992 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40413_40988,G__40414_40989,G__40415_40990,G__40416_40991,G__40417_40992) : schema.core.fn_validator.call(null,G__40413_40988,G__40414_40989,G__40415_40990,G__40416_40991,G__40417_40992));
} else {
var temp__5804__auto___40993 = (function (){var fexpr__40418 = cljs.core.deref(output_checker40404_40977);
return (fexpr__40418.cljs$core$IFn$_invoke$arity$1 ? fexpr__40418.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40418.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40993)){
var error__36938__auto___40994 = temp__5804__auto___40993;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___40994], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40401_40974,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___40994], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema40401_40974,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40402_40975], null)));

var ufv___40995 = schema.utils.use_fn_validation;
var output_schema40419_40996 = deercreeklabs.baracus.ByteArray;
var input_schema40420_40997 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40421_40998 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40420_40997);
}),null));
var output_checker40422_40999 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40419_40996);
}),null));
var ret__39093__auto___41000 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__40423){
var validate__36936__auto__ = cljs.core.deref(ufv___40995);
if(cljs.core.truth_(validate__36936__auto__)){
var args__36937__auto___41002 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40423], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40424_41003 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40425_41004 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40426_41005 = input_schema40420_40997;
var G__40427_41006 = cljs.core.deref(input_checker40421_40998);
var G__40428_41007 = args__36937__auto___41002;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40424_41003,G__40425_41004,G__40426_41005,G__40427_41006,G__40428_41007) : schema.core.fn_validator.call(null,G__40424_41003,G__40425_41004,G__40426_41005,G__40427_41006,G__40428_41007));
} else {
var temp__5804__auto___41008 = (function (){var fexpr__40429 = cljs.core.deref(input_checker40421_40998);
return (fexpr__40429.cljs$core$IFn$_invoke$arity$1 ? fexpr__40429.cljs$core$IFn$_invoke$arity$1(args__36937__auto___41002) : fexpr__40429.call(null,args__36937__auto___41002));
})();
if(cljs.core.truth_(temp__5804__auto___41008)){
var error__36938__auto___41009 = temp__5804__auto___41008;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___41009], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40420_40997,new cljs.core.Keyword(null,"value","value",305978217),args__36937__auto___41002,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___41009], null));
} else {
}
}
} else {
}

var o__36939__auto__ = (function (){var ba = G__40423;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__36936__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40431_41010 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40432_41011 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40433_41012 = output_schema40419_40996;
var G__40434_41013 = cljs.core.deref(output_checker40422_40999);
var G__40435_41014 = o__36939__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40431_41010,G__40432_41011,G__40433_41012,G__40434_41013,G__40435_41014) : schema.core.fn_validator.call(null,G__40431_41010,G__40432_41011,G__40433_41012,G__40434_41013,G__40435_41014));
} else {
var temp__5804__auto___41015 = (function (){var fexpr__40436 = cljs.core.deref(output_checker40422_40999);
return (fexpr__40436.cljs$core$IFn$_invoke$arity$1 ? fexpr__40436.cljs$core$IFn$_invoke$arity$1(o__36939__auto__) : fexpr__40436.call(null,o__36939__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41015)){
var error__36938__auto___41016 = temp__5804__auto___41015;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36938__auto___41016], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40419_40996,new cljs.core.Keyword(null,"value","value",305978217),o__36939__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36938__auto___41016], null));
} else {
}
}
} else {
}

return o__36939__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema40419_40996,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40420_40997], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
