goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30105 = arguments.length;
switch (G__30105) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30110 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30110 = (function (f,blockable,meta30111){
this.f = f;
this.blockable = blockable;
this.meta30111 = meta30111;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30110.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30112,meta30111__$1){
var self__ = this;
var _30112__$1 = this;
return (new cljs.core.async.t_cljs$core$async30110(self__.f,self__.blockable,meta30111__$1));
}));

(cljs.core.async.t_cljs$core$async30110.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30112){
var self__ = this;
var _30112__$1 = this;
return self__.meta30111;
}));

(cljs.core.async.t_cljs$core$async30110.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30110.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30110.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30110.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30110.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30111","meta30111",-1265160145,null)], null);
}));

(cljs.core.async.t_cljs$core$async30110.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30110.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30110");

(cljs.core.async.t_cljs$core$async30110.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async30110");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30110.
 */
cljs.core.async.__GT_t_cljs$core$async30110 = (function cljs$core$async$__GT_t_cljs$core$async30110(f__$1,blockable__$1,meta30111){
return (new cljs.core.async.t_cljs$core$async30110(f__$1,blockable__$1,meta30111));
});

}

return (new cljs.core.async.t_cljs$core$async30110(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30115 = arguments.length;
switch (G__30115) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30131 = arguments.length;
switch (G__30131) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30133 = arguments.length;
switch (G__30133) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32748 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32748) : fn1.call(null,val_32748));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32748) : fn1.call(null,val_32748));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30146 = arguments.length;
switch (G__30146) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___32752 = n;
var x_32753 = (0);
while(true){
if((x_32753 < n__4741__auto___32752)){
(a[x_32753] = x_32753);

var G__32754 = (x_32753 + (1));
x_32753 = G__32754;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30179 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30179 = (function (flag,meta30180){
this.flag = flag;
this.meta30180 = meta30180;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30179.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30181,meta30180__$1){
var self__ = this;
var _30181__$1 = this;
return (new cljs.core.async.t_cljs$core$async30179(self__.flag,meta30180__$1));
}));

(cljs.core.async.t_cljs$core$async30179.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30181){
var self__ = this;
var _30181__$1 = this;
return self__.meta30180;
}));

(cljs.core.async.t_cljs$core$async30179.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30179.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30179.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30179.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30179.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30180","meta30180",-888810185,null)], null);
}));

(cljs.core.async.t_cljs$core$async30179.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30179.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30179");

(cljs.core.async.t_cljs$core$async30179.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async30179");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30179.
 */
cljs.core.async.__GT_t_cljs$core$async30179 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30179(flag__$1,meta30180){
return (new cljs.core.async.t_cljs$core$async30179(flag__$1,meta30180));
});

}

return (new cljs.core.async.t_cljs$core$async30179(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30187 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30187 = (function (flag,cb,meta30188){
this.flag = flag;
this.cb = cb;
this.meta30188 = meta30188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30189,meta30188__$1){
var self__ = this;
var _30189__$1 = this;
return (new cljs.core.async.t_cljs$core$async30187(self__.flag,self__.cb,meta30188__$1));
}));

(cljs.core.async.t_cljs$core$async30187.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30189){
var self__ = this;
var _30189__$1 = this;
return self__.meta30188;
}));

(cljs.core.async.t_cljs$core$async30187.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30187.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30187.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30187.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30187.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30188","meta30188",1627293986,null)], null);
}));

(cljs.core.async.t_cljs$core$async30187.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30187");

(cljs.core.async.t_cljs$core$async30187.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async30187");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30187.
 */
cljs.core.async.__GT_t_cljs$core$async30187 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30187(flag__$1,cb__$1,meta30188){
return (new cljs.core.async.t_cljs$core$async30187(flag__$1,cb__$1,meta30188));
});

}

return (new cljs.core.async.t_cljs$core$async30187(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30192_SHARP_){
var G__30194 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30192_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30194) : fret.call(null,G__30194));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30193_SHARP_){
var G__30195 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30193_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30195) : fret.call(null,G__30195));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32803 = (i + (1));
i = G__32803;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___32805 = arguments.length;
var i__4865__auto___32807 = (0);
while(true){
if((i__4865__auto___32807 < len__4864__auto___32805)){
args__4870__auto__.push((arguments[i__4865__auto___32807]));

var G__32809 = (i__4865__auto___32807 + (1));
i__4865__auto___32807 = G__32809;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30202){
var map__30203 = p__30202;
var map__30203__$1 = cljs.core.__destructure_map(map__30203);
var opts = map__30203__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30197){
var G__30198 = cljs.core.first(seq30197);
var seq30197__$1 = cljs.core.next(seq30197);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30198,seq30197__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30205 = arguments.length;
switch (G__30205) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30024__auto___32824 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30244){
var state_val_30245 = (state_30244[(1)]);
if((state_val_30245 === (7))){
var inst_30238 = (state_30244[(2)]);
var state_30244__$1 = state_30244;
var statearr_30246_32825 = state_30244__$1;
(statearr_30246_32825[(2)] = inst_30238);

(statearr_30246_32825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (1))){
var state_30244__$1 = state_30244;
var statearr_30247_32829 = state_30244__$1;
(statearr_30247_32829[(2)] = null);

(statearr_30247_32829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (4))){
var inst_30218 = (state_30244[(7)]);
var inst_30218__$1 = (state_30244[(2)]);
var inst_30222 = (inst_30218__$1 == null);
var state_30244__$1 = (function (){var statearr_30248 = state_30244;
(statearr_30248[(7)] = inst_30218__$1);

return statearr_30248;
})();
if(cljs.core.truth_(inst_30222)){
var statearr_30253_32831 = state_30244__$1;
(statearr_30253_32831[(1)] = (5));

} else {
var statearr_30254_32832 = state_30244__$1;
(statearr_30254_32832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (13))){
var state_30244__$1 = state_30244;
var statearr_30255_32833 = state_30244__$1;
(statearr_30255_32833[(2)] = null);

(statearr_30255_32833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (6))){
var inst_30218 = (state_30244[(7)]);
var state_30244__$1 = state_30244;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30244__$1,(11),to,inst_30218);
} else {
if((state_val_30245 === (3))){
var inst_30240 = (state_30244[(2)]);
var state_30244__$1 = state_30244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30244__$1,inst_30240);
} else {
if((state_val_30245 === (12))){
var state_30244__$1 = state_30244;
var statearr_30257_32834 = state_30244__$1;
(statearr_30257_32834[(2)] = null);

(statearr_30257_32834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (2))){
var state_30244__$1 = state_30244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30244__$1,(4),from);
} else {
if((state_val_30245 === (11))){
var inst_30231 = (state_30244[(2)]);
var state_30244__$1 = state_30244;
if(cljs.core.truth_(inst_30231)){
var statearr_30258_32835 = state_30244__$1;
(statearr_30258_32835[(1)] = (12));

} else {
var statearr_30259_32836 = state_30244__$1;
(statearr_30259_32836[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (9))){
var state_30244__$1 = state_30244;
var statearr_30260_32837 = state_30244__$1;
(statearr_30260_32837[(2)] = null);

(statearr_30260_32837[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (5))){
var state_30244__$1 = state_30244;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30261_32838 = state_30244__$1;
(statearr_30261_32838[(1)] = (8));

} else {
var statearr_30262_32839 = state_30244__$1;
(statearr_30262_32839[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (14))){
var inst_30236 = (state_30244[(2)]);
var state_30244__$1 = state_30244;
var statearr_30263_32840 = state_30244__$1;
(statearr_30263_32840[(2)] = inst_30236);

(statearr_30263_32840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (10))){
var inst_30228 = (state_30244[(2)]);
var state_30244__$1 = state_30244;
var statearr_30264_32841 = state_30244__$1;
(statearr_30264_32841[(2)] = inst_30228);

(statearr_30264_32841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30245 === (8))){
var inst_30225 = cljs.core.async.close_BANG_(to);
var state_30244__$1 = state_30244;
var statearr_30269_32842 = state_30244__$1;
(statearr_30269_32842[(2)] = inst_30225);

(statearr_30269_32842[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_30270 = [null,null,null,null,null,null,null,null];
(statearr_30270[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_30270[(1)] = (1));

return statearr_30270;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_30244){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30244);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30271){var ex__29729__auto__ = e30271;
var statearr_30273_32844 = state_30244;
(statearr_30273_32844[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30244[(4)]))){
var statearr_30274_32845 = state_30244;
(statearr_30274_32845[(1)] = cljs.core.first((state_30244[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32846 = state_30244;
state_30244 = G__32846;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_30244){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_30244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30278 = f__30025__auto__();
(statearr_30278[(6)] = c__30024__auto___32824);

return statearr_30278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__30289){
var vec__30290 = p__30289;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30290,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30290,(1),null);
var job = vec__30290;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30024__auto___32848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30298){
var state_val_30299 = (state_30298[(1)]);
if((state_val_30299 === (1))){
var state_30298__$1 = state_30298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30298__$1,(2),res,v);
} else {
if((state_val_30299 === (2))){
var inst_30295 = (state_30298[(2)]);
var inst_30296 = cljs.core.async.close_BANG_(res);
var state_30298__$1 = (function (){var statearr_30302 = state_30298;
(statearr_30302[(7)] = inst_30295);

return statearr_30302;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30298__$1,inst_30296);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0 = (function (){
var statearr_30304 = [null,null,null,null,null,null,null,null];
(statearr_30304[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__);

(statearr_30304[(1)] = (1));

return statearr_30304;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1 = (function (state_30298){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30298);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30306){var ex__29729__auto__ = e30306;
var statearr_30307_32849 = state_30298;
(statearr_30307_32849[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30298[(4)]))){
var statearr_30308_32850 = state_30298;
(statearr_30308_32850[(1)] = cljs.core.first((state_30298[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32852 = state_30298;
state_30298 = G__32852;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = function(state_30298){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1.call(this,state_30298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30310 = f__30025__auto__();
(statearr_30310[(6)] = c__30024__auto___32848);

return statearr_30310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__30311){
var vec__30312 = p__30311;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30312,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30312,(1),null);
var job = vec__30312;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___32853 = n;
var __32854 = (0);
while(true){
if((__32854 < n__4741__auto___32853)){
var G__30315_32855 = type;
var G__30315_32856__$1 = (((G__30315_32855 instanceof cljs.core.Keyword))?G__30315_32855.fqn:null);
switch (G__30315_32856__$1) {
case "compute":
var c__30024__auto___32858 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32854,c__30024__auto___32858,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async){
return (function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = ((function (__32854,c__30024__auto___32858,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async){
return (function (state_30330){
var state_val_30331 = (state_30330[(1)]);
if((state_val_30331 === (1))){
var state_30330__$1 = state_30330;
var statearr_30332_32860 = state_30330__$1;
(statearr_30332_32860[(2)] = null);

(statearr_30332_32860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30331 === (2))){
var state_30330__$1 = state_30330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30330__$1,(4),jobs);
} else {
if((state_val_30331 === (3))){
var inst_30328 = (state_30330[(2)]);
var state_30330__$1 = state_30330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30330__$1,inst_30328);
} else {
if((state_val_30331 === (4))){
var inst_30320 = (state_30330[(2)]);
var inst_30321 = process(inst_30320);
var state_30330__$1 = state_30330;
if(cljs.core.truth_(inst_30321)){
var statearr_30333_32861 = state_30330__$1;
(statearr_30333_32861[(1)] = (5));

} else {
var statearr_30335_32862 = state_30330__$1;
(statearr_30335_32862[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30331 === (5))){
var state_30330__$1 = state_30330;
var statearr_30336_32863 = state_30330__$1;
(statearr_30336_32863[(2)] = null);

(statearr_30336_32863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30331 === (6))){
var state_30330__$1 = state_30330;
var statearr_30337_32864 = state_30330__$1;
(statearr_30337_32864[(2)] = null);

(statearr_30337_32864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30331 === (7))){
var inst_30326 = (state_30330[(2)]);
var state_30330__$1 = state_30330;
var statearr_30339_32866 = state_30330__$1;
(statearr_30339_32866[(2)] = inst_30326);

(statearr_30339_32866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32854,c__30024__auto___32858,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async))
;
return ((function (__32854,switch__29725__auto__,c__30024__auto___32858,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0 = (function (){
var statearr_30341 = [null,null,null,null,null,null,null];
(statearr_30341[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__);

(statearr_30341[(1)] = (1));

return statearr_30341;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1 = (function (state_30330){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30330);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30346){var ex__29729__auto__ = e30346;
var statearr_30347_32867 = state_30330;
(statearr_30347_32867[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30330[(4)]))){
var statearr_30351_32868 = state_30330;
(statearr_30351_32868[(1)] = cljs.core.first((state_30330[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32869 = state_30330;
state_30330 = G__32869;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = function(state_30330){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1.call(this,state_30330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__;
})()
;})(__32854,switch__29725__auto__,c__30024__auto___32858,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async))
})();
var state__30026__auto__ = (function (){var statearr_30352 = f__30025__auto__();
(statearr_30352[(6)] = c__30024__auto___32858);

return statearr_30352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
});})(__32854,c__30024__auto___32858,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async))
);


break;
case "async":
var c__30024__auto___32870 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32854,c__30024__auto___32870,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async){
return (function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = ((function (__32854,c__30024__auto___32870,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async){
return (function (state_30368){
var state_val_30369 = (state_30368[(1)]);
if((state_val_30369 === (1))){
var state_30368__$1 = state_30368;
var statearr_30379_32872 = state_30368__$1;
(statearr_30379_32872[(2)] = null);

(statearr_30379_32872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30369 === (2))){
var state_30368__$1 = state_30368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30368__$1,(4),jobs);
} else {
if((state_val_30369 === (3))){
var inst_30366 = (state_30368[(2)]);
var state_30368__$1 = state_30368;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30368__$1,inst_30366);
} else {
if((state_val_30369 === (4))){
var inst_30358 = (state_30368[(2)]);
var inst_30359 = async(inst_30358);
var state_30368__$1 = state_30368;
if(cljs.core.truth_(inst_30359)){
var statearr_30383_32873 = state_30368__$1;
(statearr_30383_32873[(1)] = (5));

} else {
var statearr_30384_32874 = state_30368__$1;
(statearr_30384_32874[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30369 === (5))){
var state_30368__$1 = state_30368;
var statearr_30385_32875 = state_30368__$1;
(statearr_30385_32875[(2)] = null);

(statearr_30385_32875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30369 === (6))){
var state_30368__$1 = state_30368;
var statearr_30386_32877 = state_30368__$1;
(statearr_30386_32877[(2)] = null);

(statearr_30386_32877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30369 === (7))){
var inst_30364 = (state_30368[(2)]);
var state_30368__$1 = state_30368;
var statearr_30387_32880 = state_30368__$1;
(statearr_30387_32880[(2)] = inst_30364);

(statearr_30387_32880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32854,c__30024__auto___32870,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async))
;
return ((function (__32854,switch__29725__auto__,c__30024__auto___32870,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0 = (function (){
var statearr_30388 = [null,null,null,null,null,null,null];
(statearr_30388[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__);

(statearr_30388[(1)] = (1));

return statearr_30388;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1 = (function (state_30368){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30368);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30389){var ex__29729__auto__ = e30389;
var statearr_30391_32893 = state_30368;
(statearr_30391_32893[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30368[(4)]))){
var statearr_30393_32895 = state_30368;
(statearr_30393_32895[(1)] = cljs.core.first((state_30368[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32898 = state_30368;
state_30368 = G__32898;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = function(state_30368){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1.call(this,state_30368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__;
})()
;})(__32854,switch__29725__auto__,c__30024__auto___32870,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async))
})();
var state__30026__auto__ = (function (){var statearr_30395 = f__30025__auto__();
(statearr_30395[(6)] = c__30024__auto___32870);

return statearr_30395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
});})(__32854,c__30024__auto___32870,G__30315_32855,G__30315_32856__$1,n__4741__auto___32853,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30315_32856__$1)].join('')));

}

var G__32899 = (__32854 + (1));
__32854 = G__32899;
continue;
} else {
}
break;
}

var c__30024__auto___32900 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30423){
var state_val_30424 = (state_30423[(1)]);
if((state_val_30424 === (7))){
var inst_30419 = (state_30423[(2)]);
var state_30423__$1 = state_30423;
var statearr_30427_32904 = state_30423__$1;
(statearr_30427_32904[(2)] = inst_30419);

(statearr_30427_32904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30424 === (1))){
var state_30423__$1 = state_30423;
var statearr_30434_32905 = state_30423__$1;
(statearr_30434_32905[(2)] = null);

(statearr_30434_32905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30424 === (4))){
var inst_30400 = (state_30423[(7)]);
var inst_30400__$1 = (state_30423[(2)]);
var inst_30401 = (inst_30400__$1 == null);
var state_30423__$1 = (function (){var statearr_30435 = state_30423;
(statearr_30435[(7)] = inst_30400__$1);

return statearr_30435;
})();
if(cljs.core.truth_(inst_30401)){
var statearr_30436_32910 = state_30423__$1;
(statearr_30436_32910[(1)] = (5));

} else {
var statearr_30437_32911 = state_30423__$1;
(statearr_30437_32911[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30424 === (6))){
var inst_30400 = (state_30423[(7)]);
var inst_30408 = (state_30423[(8)]);
var inst_30408__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_30410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30411 = [inst_30400,inst_30408__$1];
var inst_30412 = (new cljs.core.PersistentVector(null,2,(5),inst_30410,inst_30411,null));
var state_30423__$1 = (function (){var statearr_30438 = state_30423;
(statearr_30438[(8)] = inst_30408__$1);

return statearr_30438;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30423__$1,(8),jobs,inst_30412);
} else {
if((state_val_30424 === (3))){
var inst_30421 = (state_30423[(2)]);
var state_30423__$1 = state_30423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30423__$1,inst_30421);
} else {
if((state_val_30424 === (2))){
var state_30423__$1 = state_30423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30423__$1,(4),from);
} else {
if((state_val_30424 === (9))){
var inst_30416 = (state_30423[(2)]);
var state_30423__$1 = (function (){var statearr_30439 = state_30423;
(statearr_30439[(9)] = inst_30416);

return statearr_30439;
})();
var statearr_30440_32920 = state_30423__$1;
(statearr_30440_32920[(2)] = null);

(statearr_30440_32920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30424 === (5))){
var inst_30406 = cljs.core.async.close_BANG_(jobs);
var state_30423__$1 = state_30423;
var statearr_30441_32927 = state_30423__$1;
(statearr_30441_32927[(2)] = inst_30406);

(statearr_30441_32927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30424 === (8))){
var inst_30408 = (state_30423[(8)]);
var inst_30414 = (state_30423[(2)]);
var state_30423__$1 = (function (){var statearr_30442 = state_30423;
(statearr_30442[(10)] = inst_30414);

return statearr_30442;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30423__$1,(9),results,inst_30408);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0 = (function (){
var statearr_30444 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30444[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__);

(statearr_30444[(1)] = (1));

return statearr_30444;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1 = (function (state_30423){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30423);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30445){var ex__29729__auto__ = e30445;
var statearr_30446_32940 = state_30423;
(statearr_30446_32940[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30423[(4)]))){
var statearr_30447_32948 = state_30423;
(statearr_30447_32948[(1)] = cljs.core.first((state_30423[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32954 = state_30423;
state_30423 = G__32954;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = function(state_30423){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1.call(this,state_30423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30452 = f__30025__auto__();
(statearr_30452[(6)] = c__30024__auto___32900);

return statearr_30452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


var c__30024__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30491){
var state_val_30492 = (state_30491[(1)]);
if((state_val_30492 === (7))){
var inst_30487 = (state_30491[(2)]);
var state_30491__$1 = state_30491;
var statearr_30493_32966 = state_30491__$1;
(statearr_30493_32966[(2)] = inst_30487);

(statearr_30493_32966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (20))){
var state_30491__$1 = state_30491;
var statearr_30494_32975 = state_30491__$1;
(statearr_30494_32975[(2)] = null);

(statearr_30494_32975[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (1))){
var state_30491__$1 = state_30491;
var statearr_30499_32984 = state_30491__$1;
(statearr_30499_32984[(2)] = null);

(statearr_30499_32984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (4))){
var inst_30456 = (state_30491[(7)]);
var inst_30456__$1 = (state_30491[(2)]);
var inst_30457 = (inst_30456__$1 == null);
var state_30491__$1 = (function (){var statearr_30501 = state_30491;
(statearr_30501[(7)] = inst_30456__$1);

return statearr_30501;
})();
if(cljs.core.truth_(inst_30457)){
var statearr_30502_33009 = state_30491__$1;
(statearr_30502_33009[(1)] = (5));

} else {
var statearr_30503_33015 = state_30491__$1;
(statearr_30503_33015[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (15))){
var inst_30469 = (state_30491[(8)]);
var state_30491__$1 = state_30491;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30491__$1,(18),to,inst_30469);
} else {
if((state_val_30492 === (21))){
var inst_30482 = (state_30491[(2)]);
var state_30491__$1 = state_30491;
var statearr_30513_33026 = state_30491__$1;
(statearr_30513_33026[(2)] = inst_30482);

(statearr_30513_33026[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (13))){
var inst_30484 = (state_30491[(2)]);
var state_30491__$1 = (function (){var statearr_30518 = state_30491;
(statearr_30518[(9)] = inst_30484);

return statearr_30518;
})();
var statearr_30519_33033 = state_30491__$1;
(statearr_30519_33033[(2)] = null);

(statearr_30519_33033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (6))){
var inst_30456 = (state_30491[(7)]);
var state_30491__$1 = state_30491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30491__$1,(11),inst_30456);
} else {
if((state_val_30492 === (17))){
var inst_30477 = (state_30491[(2)]);
var state_30491__$1 = state_30491;
if(cljs.core.truth_(inst_30477)){
var statearr_30520_33034 = state_30491__$1;
(statearr_30520_33034[(1)] = (19));

} else {
var statearr_30521_33035 = state_30491__$1;
(statearr_30521_33035[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (3))){
var inst_30489 = (state_30491[(2)]);
var state_30491__$1 = state_30491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30491__$1,inst_30489);
} else {
if((state_val_30492 === (12))){
var inst_30466 = (state_30491[(10)]);
var state_30491__$1 = state_30491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30491__$1,(14),inst_30466);
} else {
if((state_val_30492 === (2))){
var state_30491__$1 = state_30491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30491__$1,(4),results);
} else {
if((state_val_30492 === (19))){
var state_30491__$1 = state_30491;
var statearr_30527_33041 = state_30491__$1;
(statearr_30527_33041[(2)] = null);

(statearr_30527_33041[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (11))){
var inst_30466 = (state_30491[(2)]);
var state_30491__$1 = (function (){var statearr_30528 = state_30491;
(statearr_30528[(10)] = inst_30466);

return statearr_30528;
})();
var statearr_30529_33042 = state_30491__$1;
(statearr_30529_33042[(2)] = null);

(statearr_30529_33042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (9))){
var state_30491__$1 = state_30491;
var statearr_30530_33044 = state_30491__$1;
(statearr_30530_33044[(2)] = null);

(statearr_30530_33044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (5))){
var state_30491__$1 = state_30491;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30531_33045 = state_30491__$1;
(statearr_30531_33045[(1)] = (8));

} else {
var statearr_30533_33046 = state_30491__$1;
(statearr_30533_33046[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (14))){
var inst_30471 = (state_30491[(11)]);
var inst_30469 = (state_30491[(8)]);
var inst_30469__$1 = (state_30491[(2)]);
var inst_30470 = (inst_30469__$1 == null);
var inst_30471__$1 = cljs.core.not(inst_30470);
var state_30491__$1 = (function (){var statearr_30535 = state_30491;
(statearr_30535[(11)] = inst_30471__$1);

(statearr_30535[(8)] = inst_30469__$1);

return statearr_30535;
})();
if(inst_30471__$1){
var statearr_30536_33047 = state_30491__$1;
(statearr_30536_33047[(1)] = (15));

} else {
var statearr_30537_33049 = state_30491__$1;
(statearr_30537_33049[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (16))){
var inst_30471 = (state_30491[(11)]);
var state_30491__$1 = state_30491;
var statearr_30538_33051 = state_30491__$1;
(statearr_30538_33051[(2)] = inst_30471);

(statearr_30538_33051[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (10))){
var inst_30463 = (state_30491[(2)]);
var state_30491__$1 = state_30491;
var statearr_30543_33052 = state_30491__$1;
(statearr_30543_33052[(2)] = inst_30463);

(statearr_30543_33052[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (18))){
var inst_30474 = (state_30491[(2)]);
var state_30491__$1 = state_30491;
var statearr_30546_33053 = state_30491__$1;
(statearr_30546_33053[(2)] = inst_30474);

(statearr_30546_33053[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30492 === (8))){
var inst_30460 = cljs.core.async.close_BANG_(to);
var state_30491__$1 = state_30491;
var statearr_30550_33054 = state_30491__$1;
(statearr_30550_33054[(2)] = inst_30460);

(statearr_30550_33054[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0 = (function (){
var statearr_30559 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30559[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__);

(statearr_30559[(1)] = (1));

return statearr_30559;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1 = (function (state_30491){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30491);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30566){var ex__29729__auto__ = e30566;
var statearr_30568_33060 = state_30491;
(statearr_30568_33060[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30491[(4)]))){
var statearr_30571_33061 = state_30491;
(statearr_30571_33061[(1)] = cljs.core.first((state_30491[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33065 = state_30491;
state_30491 = G__33065;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__ = function(state_30491){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1.call(this,state_30491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29726__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30582 = f__30025__auto__();
(statearr_30582[(6)] = c__30024__auto__);

return statearr_30582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

return c__30024__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__30587 = arguments.length;
switch (G__30587) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__30612 = arguments.length;
switch (G__30612) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__30620 = arguments.length;
switch (G__30620) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30024__auto___33084 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30654){
var state_val_30655 = (state_30654[(1)]);
if((state_val_30655 === (7))){
var inst_30650 = (state_30654[(2)]);
var state_30654__$1 = state_30654;
var statearr_30662_33086 = state_30654__$1;
(statearr_30662_33086[(2)] = inst_30650);

(statearr_30662_33086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (1))){
var state_30654__$1 = state_30654;
var statearr_30664_33087 = state_30654__$1;
(statearr_30664_33087[(2)] = null);

(statearr_30664_33087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (4))){
var inst_30625 = (state_30654[(7)]);
var inst_30625__$1 = (state_30654[(2)]);
var inst_30626 = (inst_30625__$1 == null);
var state_30654__$1 = (function (){var statearr_30665 = state_30654;
(statearr_30665[(7)] = inst_30625__$1);

return statearr_30665;
})();
if(cljs.core.truth_(inst_30626)){
var statearr_30666_33088 = state_30654__$1;
(statearr_30666_33088[(1)] = (5));

} else {
var statearr_30667_33089 = state_30654__$1;
(statearr_30667_33089[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (13))){
var state_30654__$1 = state_30654;
var statearr_30668_33091 = state_30654__$1;
(statearr_30668_33091[(2)] = null);

(statearr_30668_33091[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (6))){
var inst_30625 = (state_30654[(7)]);
var inst_30631 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30625) : p.call(null,inst_30625));
var state_30654__$1 = state_30654;
if(cljs.core.truth_(inst_30631)){
var statearr_30669_33099 = state_30654__$1;
(statearr_30669_33099[(1)] = (9));

} else {
var statearr_30670_33100 = state_30654__$1;
(statearr_30670_33100[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (3))){
var inst_30652 = (state_30654[(2)]);
var state_30654__$1 = state_30654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30654__$1,inst_30652);
} else {
if((state_val_30655 === (12))){
var state_30654__$1 = state_30654;
var statearr_30672_33101 = state_30654__$1;
(statearr_30672_33101[(2)] = null);

(statearr_30672_33101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (2))){
var state_30654__$1 = state_30654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30654__$1,(4),ch);
} else {
if((state_val_30655 === (11))){
var inst_30625 = (state_30654[(7)]);
var inst_30641 = (state_30654[(2)]);
var state_30654__$1 = state_30654;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30654__$1,(8),inst_30641,inst_30625);
} else {
if((state_val_30655 === (9))){
var state_30654__$1 = state_30654;
var statearr_30676_33108 = state_30654__$1;
(statearr_30676_33108[(2)] = tc);

(statearr_30676_33108[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (5))){
var inst_30628 = cljs.core.async.close_BANG_(tc);
var inst_30629 = cljs.core.async.close_BANG_(fc);
var state_30654__$1 = (function (){var statearr_30681 = state_30654;
(statearr_30681[(8)] = inst_30628);

return statearr_30681;
})();
var statearr_30682_33112 = state_30654__$1;
(statearr_30682_33112[(2)] = inst_30629);

(statearr_30682_33112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (14))){
var inst_30648 = (state_30654[(2)]);
var state_30654__$1 = state_30654;
var statearr_30687_33114 = state_30654__$1;
(statearr_30687_33114[(2)] = inst_30648);

(statearr_30687_33114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (10))){
var state_30654__$1 = state_30654;
var statearr_30698_33118 = state_30654__$1;
(statearr_30698_33118[(2)] = fc);

(statearr_30698_33118[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30655 === (8))){
var inst_30643 = (state_30654[(2)]);
var state_30654__$1 = state_30654;
if(cljs.core.truth_(inst_30643)){
var statearr_30702_33122 = state_30654__$1;
(statearr_30702_33122[(1)] = (12));

} else {
var statearr_30707_33123 = state_30654__$1;
(statearr_30707_33123[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_30713 = [null,null,null,null,null,null,null,null,null];
(statearr_30713[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_30713[(1)] = (1));

return statearr_30713;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_30654){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30654);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30714){var ex__29729__auto__ = e30714;
var statearr_30715_33132 = state_30654;
(statearr_30715_33132[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30654[(4)]))){
var statearr_30716_33133 = state_30654;
(statearr_30716_33133[(1)] = cljs.core.first((state_30654[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33138 = state_30654;
state_30654 = G__33138;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_30654){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_30654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30717 = f__30025__auto__();
(statearr_30717[(6)] = c__30024__auto___33084);

return statearr_30717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30024__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30764){
var state_val_30765 = (state_30764[(1)]);
if((state_val_30765 === (7))){
var inst_30756 = (state_30764[(2)]);
var state_30764__$1 = state_30764;
var statearr_30792_33144 = state_30764__$1;
(statearr_30792_33144[(2)] = inst_30756);

(statearr_30792_33144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (1))){
var inst_30739 = init;
var inst_30740 = inst_30739;
var state_30764__$1 = (function (){var statearr_30793 = state_30764;
(statearr_30793[(7)] = inst_30740);

return statearr_30793;
})();
var statearr_30798_33150 = state_30764__$1;
(statearr_30798_33150[(2)] = null);

(statearr_30798_33150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (4))){
var inst_30743 = (state_30764[(8)]);
var inst_30743__$1 = (state_30764[(2)]);
var inst_30744 = (inst_30743__$1 == null);
var state_30764__$1 = (function (){var statearr_30799 = state_30764;
(statearr_30799[(8)] = inst_30743__$1);

return statearr_30799;
})();
if(cljs.core.truth_(inst_30744)){
var statearr_30800_33155 = state_30764__$1;
(statearr_30800_33155[(1)] = (5));

} else {
var statearr_30801_33156 = state_30764__$1;
(statearr_30801_33156[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (6))){
var inst_30747 = (state_30764[(9)]);
var inst_30740 = (state_30764[(7)]);
var inst_30743 = (state_30764[(8)]);
var inst_30747__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30740,inst_30743) : f.call(null,inst_30740,inst_30743));
var inst_30748 = cljs.core.reduced_QMARK_(inst_30747__$1);
var state_30764__$1 = (function (){var statearr_30802 = state_30764;
(statearr_30802[(9)] = inst_30747__$1);

return statearr_30802;
})();
if(inst_30748){
var statearr_30803_33160 = state_30764__$1;
(statearr_30803_33160[(1)] = (8));

} else {
var statearr_30804_33163 = state_30764__$1;
(statearr_30804_33163[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (3))){
var inst_30758 = (state_30764[(2)]);
var state_30764__$1 = state_30764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30764__$1,inst_30758);
} else {
if((state_val_30765 === (2))){
var state_30764__$1 = state_30764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30764__$1,(4),ch);
} else {
if((state_val_30765 === (9))){
var inst_30747 = (state_30764[(9)]);
var inst_30740 = inst_30747;
var state_30764__$1 = (function (){var statearr_30810 = state_30764;
(statearr_30810[(7)] = inst_30740);

return statearr_30810;
})();
var statearr_30811_33167 = state_30764__$1;
(statearr_30811_33167[(2)] = null);

(statearr_30811_33167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (5))){
var inst_30740 = (state_30764[(7)]);
var state_30764__$1 = state_30764;
var statearr_30814_33168 = state_30764__$1;
(statearr_30814_33168[(2)] = inst_30740);

(statearr_30814_33168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (10))){
var inst_30754 = (state_30764[(2)]);
var state_30764__$1 = state_30764;
var statearr_30815_33171 = state_30764__$1;
(statearr_30815_33171[(2)] = inst_30754);

(statearr_30815_33171[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30765 === (8))){
var inst_30747 = (state_30764[(9)]);
var inst_30750 = cljs.core.deref(inst_30747);
var state_30764__$1 = state_30764;
var statearr_30816_33173 = state_30764__$1;
(statearr_30816_33173[(2)] = inst_30750);

(statearr_30816_33173[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__29726__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29726__auto____0 = (function (){
var statearr_30817 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30817[(0)] = cljs$core$async$reduce_$_state_machine__29726__auto__);

(statearr_30817[(1)] = (1));

return statearr_30817;
});
var cljs$core$async$reduce_$_state_machine__29726__auto____1 = (function (state_30764){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30764);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30818){var ex__29729__auto__ = e30818;
var statearr_30819_33175 = state_30764;
(statearr_30819_33175[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30764[(4)]))){
var statearr_30820_33176 = state_30764;
(statearr_30820_33176[(1)] = cljs.core.first((state_30764[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33180 = state_30764;
state_30764 = G__33180;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29726__auto__ = function(state_30764){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29726__auto____1.call(this,state_30764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29726__auto____0;
cljs$core$async$reduce_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29726__auto____1;
return cljs$core$async$reduce_$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30829 = f__30025__auto__();
(statearr_30829[(6)] = c__30024__auto__);

return statearr_30829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

return c__30024__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30024__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30844){
var state_val_30845 = (state_30844[(1)]);
if((state_val_30845 === (1))){
var inst_30838 = cljs.core.async.reduce(f__$1,init,ch);
var state_30844__$1 = state_30844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30844__$1,(2),inst_30838);
} else {
if((state_val_30845 === (2))){
var inst_30840 = (state_30844[(2)]);
var inst_30841 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_30840) : f__$1.call(null,inst_30840));
var state_30844__$1 = state_30844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30844__$1,inst_30841);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__29726__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29726__auto____0 = (function (){
var statearr_30857 = [null,null,null,null,null,null,null];
(statearr_30857[(0)] = cljs$core$async$transduce_$_state_machine__29726__auto__);

(statearr_30857[(1)] = (1));

return statearr_30857;
});
var cljs$core$async$transduce_$_state_machine__29726__auto____1 = (function (state_30844){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30844);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30858){var ex__29729__auto__ = e30858;
var statearr_30859_33185 = state_30844;
(statearr_30859_33185[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30844[(4)]))){
var statearr_30860_33186 = state_30844;
(statearr_30860_33186[(1)] = cljs.core.first((state_30844[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33188 = state_30844;
state_30844 = G__33188;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29726__auto__ = function(state_30844){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29726__auto____1.call(this,state_30844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29726__auto____0;
cljs$core$async$transduce_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29726__auto____1;
return cljs$core$async$transduce_$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30865 = f__30025__auto__();
(statearr_30865[(6)] = c__30024__auto__);

return statearr_30865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

return c__30024__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__30867 = arguments.length;
switch (G__30867) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30024__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_30896){
var state_val_30897 = (state_30896[(1)]);
if((state_val_30897 === (7))){
var inst_30874 = (state_30896[(2)]);
var state_30896__$1 = state_30896;
var statearr_30903_33204 = state_30896__$1;
(statearr_30903_33204[(2)] = inst_30874);

(statearr_30903_33204[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (1))){
var inst_30868 = cljs.core.seq(coll);
var inst_30869 = inst_30868;
var state_30896__$1 = (function (){var statearr_30904 = state_30896;
(statearr_30904[(7)] = inst_30869);

return statearr_30904;
})();
var statearr_30905_33212 = state_30896__$1;
(statearr_30905_33212[(2)] = null);

(statearr_30905_33212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (4))){
var inst_30869 = (state_30896[(7)]);
var inst_30872 = cljs.core.first(inst_30869);
var state_30896__$1 = state_30896;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30896__$1,(7),ch,inst_30872);
} else {
if((state_val_30897 === (13))){
var inst_30886 = (state_30896[(2)]);
var state_30896__$1 = state_30896;
var statearr_30906_33214 = state_30896__$1;
(statearr_30906_33214[(2)] = inst_30886);

(statearr_30906_33214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (6))){
var inst_30877 = (state_30896[(2)]);
var state_30896__$1 = state_30896;
if(cljs.core.truth_(inst_30877)){
var statearr_30907_33216 = state_30896__$1;
(statearr_30907_33216[(1)] = (8));

} else {
var statearr_30908_33217 = state_30896__$1;
(statearr_30908_33217[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (3))){
var inst_30890 = (state_30896[(2)]);
var state_30896__$1 = state_30896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30896__$1,inst_30890);
} else {
if((state_val_30897 === (12))){
var state_30896__$1 = state_30896;
var statearr_30909_33222 = state_30896__$1;
(statearr_30909_33222[(2)] = null);

(statearr_30909_33222[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (2))){
var inst_30869 = (state_30896[(7)]);
var state_30896__$1 = state_30896;
if(cljs.core.truth_(inst_30869)){
var statearr_30914_33230 = state_30896__$1;
(statearr_30914_33230[(1)] = (4));

} else {
var statearr_30915_33231 = state_30896__$1;
(statearr_30915_33231[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (11))){
var inst_30883 = cljs.core.async.close_BANG_(ch);
var state_30896__$1 = state_30896;
var statearr_30916_33233 = state_30896__$1;
(statearr_30916_33233[(2)] = inst_30883);

(statearr_30916_33233[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (9))){
var state_30896__$1 = state_30896;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30917_33237 = state_30896__$1;
(statearr_30917_33237[(1)] = (11));

} else {
var statearr_30918_33243 = state_30896__$1;
(statearr_30918_33243[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (5))){
var inst_30869 = (state_30896[(7)]);
var state_30896__$1 = state_30896;
var statearr_30919_33246 = state_30896__$1;
(statearr_30919_33246[(2)] = inst_30869);

(statearr_30919_33246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (10))){
var inst_30888 = (state_30896[(2)]);
var state_30896__$1 = state_30896;
var statearr_30923_33252 = state_30896__$1;
(statearr_30923_33252[(2)] = inst_30888);

(statearr_30923_33252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30897 === (8))){
var inst_30869 = (state_30896[(7)]);
var inst_30879 = cljs.core.next(inst_30869);
var inst_30869__$1 = inst_30879;
var state_30896__$1 = (function (){var statearr_30924 = state_30896;
(statearr_30924[(7)] = inst_30869__$1);

return statearr_30924;
})();
var statearr_30928_33258 = state_30896__$1;
(statearr_30928_33258[(2)] = null);

(statearr_30928_33258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_30929 = [null,null,null,null,null,null,null,null];
(statearr_30929[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_30929[(1)] = (1));

return statearr_30929;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_30896){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_30896);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e30930){var ex__29729__auto__ = e30930;
var statearr_30931_33276 = state_30896;
(statearr_30931_33276[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_30896[(4)]))){
var statearr_30932_33278 = state_30896;
(statearr_30932_33278[(1)] = cljs.core.first((state_30896[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33280 = state_30896;
state_30896 = G__33280;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_30896){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_30896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_30937 = f__30025__auto__();
(statearr_30937[(6)] = c__30024__auto__);

return statearr_30937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

return c__30024__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__30944 = arguments.length;
switch (G__30944) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33301 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33301(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33316 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33316(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33325 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33325(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33332 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33332(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30963 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30963 = (function (ch,cs,meta30964){
this.ch = ch;
this.cs = cs;
this.meta30964 = meta30964;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30965,meta30964__$1){
var self__ = this;
var _30965__$1 = this;
return (new cljs.core.async.t_cljs$core$async30963(self__.ch,self__.cs,meta30964__$1));
}));

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30965){
var self__ = this;
var _30965__$1 = this;
return self__.meta30964;
}));

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async30963.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async30963.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30964","meta30964",377372842,null)], null);
}));

(cljs.core.async.t_cljs$core$async30963.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30963.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30963");

(cljs.core.async.t_cljs$core$async30963.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async30963");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30963.
 */
cljs.core.async.__GT_t_cljs$core$async30963 = (function cljs$core$async$mult_$___GT_t_cljs$core$async30963(ch__$1,cs__$1,meta30964){
return (new cljs.core.async.t_cljs$core$async30963(ch__$1,cs__$1,meta30964));
});

}

return (new cljs.core.async.t_cljs$core$async30963(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30024__auto___33368 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_31112){
var state_val_31113 = (state_31112[(1)]);
if((state_val_31113 === (7))){
var inst_31108 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31114_33374 = state_31112__$1;
(statearr_31114_33374[(2)] = inst_31108);

(statearr_31114_33374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (20))){
var inst_31011 = (state_31112[(7)]);
var inst_31023 = cljs.core.first(inst_31011);
var inst_31024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31023,(0),null);
var inst_31025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31023,(1),null);
var state_31112__$1 = (function (){var statearr_31115 = state_31112;
(statearr_31115[(8)] = inst_31024);

return statearr_31115;
})();
if(cljs.core.truth_(inst_31025)){
var statearr_31116_33378 = state_31112__$1;
(statearr_31116_33378[(1)] = (22));

} else {
var statearr_31117_33379 = state_31112__$1;
(statearr_31117_33379[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (27))){
var inst_31060 = (state_31112[(9)]);
var inst_31053 = (state_31112[(10)]);
var inst_30980 = (state_31112[(11)]);
var inst_31055 = (state_31112[(12)]);
var inst_31060__$1 = cljs.core._nth(inst_31053,inst_31055);
var inst_31061 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31060__$1,inst_30980,done);
var state_31112__$1 = (function (){var statearr_31118 = state_31112;
(statearr_31118[(9)] = inst_31060__$1);

return statearr_31118;
})();
if(cljs.core.truth_(inst_31061)){
var statearr_31120_33383 = state_31112__$1;
(statearr_31120_33383[(1)] = (30));

} else {
var statearr_31122_33385 = state_31112__$1;
(statearr_31122_33385[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (1))){
var state_31112__$1 = state_31112;
var statearr_31124_33389 = state_31112__$1;
(statearr_31124_33389[(2)] = null);

(statearr_31124_33389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (24))){
var inst_31011 = (state_31112[(7)]);
var inst_31030 = (state_31112[(2)]);
var inst_31031 = cljs.core.next(inst_31011);
var inst_30989 = inst_31031;
var inst_30990 = null;
var inst_30991 = (0);
var inst_30992 = (0);
var state_31112__$1 = (function (){var statearr_31127 = state_31112;
(statearr_31127[(13)] = inst_30989);

(statearr_31127[(14)] = inst_30992);

(statearr_31127[(15)] = inst_30990);

(statearr_31127[(16)] = inst_31030);

(statearr_31127[(17)] = inst_30991);

return statearr_31127;
})();
var statearr_31128_33393 = state_31112__$1;
(statearr_31128_33393[(2)] = null);

(statearr_31128_33393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (39))){
var state_31112__$1 = state_31112;
var statearr_31132_33395 = state_31112__$1;
(statearr_31132_33395[(2)] = null);

(statearr_31132_33395[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (4))){
var inst_30980 = (state_31112[(11)]);
var inst_30980__$1 = (state_31112[(2)]);
var inst_30981 = (inst_30980__$1 == null);
var state_31112__$1 = (function (){var statearr_31133 = state_31112;
(statearr_31133[(11)] = inst_30980__$1);

return statearr_31133;
})();
if(cljs.core.truth_(inst_30981)){
var statearr_31134_33402 = state_31112__$1;
(statearr_31134_33402[(1)] = (5));

} else {
var statearr_31135_33403 = state_31112__$1;
(statearr_31135_33403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (15))){
var inst_30989 = (state_31112[(13)]);
var inst_30992 = (state_31112[(14)]);
var inst_30990 = (state_31112[(15)]);
var inst_30991 = (state_31112[(17)]);
var inst_31007 = (state_31112[(2)]);
var inst_31008 = (inst_30992 + (1));
var tmp31129 = inst_30989;
var tmp31130 = inst_30990;
var tmp31131 = inst_30991;
var inst_30989__$1 = tmp31129;
var inst_30990__$1 = tmp31130;
var inst_30991__$1 = tmp31131;
var inst_30992__$1 = inst_31008;
var state_31112__$1 = (function (){var statearr_31140 = state_31112;
(statearr_31140[(13)] = inst_30989__$1);

(statearr_31140[(14)] = inst_30992__$1);

(statearr_31140[(15)] = inst_30990__$1);

(statearr_31140[(18)] = inst_31007);

(statearr_31140[(17)] = inst_30991__$1);

return statearr_31140;
})();
var statearr_31141_33414 = state_31112__$1;
(statearr_31141_33414[(2)] = null);

(statearr_31141_33414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (21))){
var inst_31034 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31149_33416 = state_31112__$1;
(statearr_31149_33416[(2)] = inst_31034);

(statearr_31149_33416[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (31))){
var inst_31060 = (state_31112[(9)]);
var inst_31064 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31060);
var state_31112__$1 = state_31112;
var statearr_31150_33418 = state_31112__$1;
(statearr_31150_33418[(2)] = inst_31064);

(statearr_31150_33418[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (32))){
var inst_31053 = (state_31112[(10)]);
var inst_31052 = (state_31112[(19)]);
var inst_31055 = (state_31112[(12)]);
var inst_31054 = (state_31112[(20)]);
var inst_31066 = (state_31112[(2)]);
var inst_31067 = (inst_31055 + (1));
var tmp31146 = inst_31053;
var tmp31147 = inst_31052;
var tmp31148 = inst_31054;
var inst_31052__$1 = tmp31147;
var inst_31053__$1 = tmp31146;
var inst_31054__$1 = tmp31148;
var inst_31055__$1 = inst_31067;
var state_31112__$1 = (function (){var statearr_31154 = state_31112;
(statearr_31154[(10)] = inst_31053__$1);

(statearr_31154[(19)] = inst_31052__$1);

(statearr_31154[(21)] = inst_31066);

(statearr_31154[(12)] = inst_31055__$1);

(statearr_31154[(20)] = inst_31054__$1);

return statearr_31154;
})();
var statearr_31159_33424 = state_31112__$1;
(statearr_31159_33424[(2)] = null);

(statearr_31159_33424[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (40))){
var inst_31079 = (state_31112[(22)]);
var inst_31084 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31079);
var state_31112__$1 = state_31112;
var statearr_31160_33430 = state_31112__$1;
(statearr_31160_33430[(2)] = inst_31084);

(statearr_31160_33430[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (33))){
var inst_31070 = (state_31112[(23)]);
var inst_31072 = cljs.core.chunked_seq_QMARK_(inst_31070);
var state_31112__$1 = state_31112;
if(inst_31072){
var statearr_31162_33434 = state_31112__$1;
(statearr_31162_33434[(1)] = (36));

} else {
var statearr_31166_33436 = state_31112__$1;
(statearr_31166_33436[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (13))){
var inst_31001 = (state_31112[(24)]);
var inst_31004 = cljs.core.async.close_BANG_(inst_31001);
var state_31112__$1 = state_31112;
var statearr_31168_33438 = state_31112__$1;
(statearr_31168_33438[(2)] = inst_31004);

(statearr_31168_33438[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (22))){
var inst_31024 = (state_31112[(8)]);
var inst_31027 = cljs.core.async.close_BANG_(inst_31024);
var state_31112__$1 = state_31112;
var statearr_31172_33441 = state_31112__$1;
(statearr_31172_33441[(2)] = inst_31027);

(statearr_31172_33441[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (36))){
var inst_31070 = (state_31112[(23)]);
var inst_31074 = cljs.core.chunk_first(inst_31070);
var inst_31075 = cljs.core.chunk_rest(inst_31070);
var inst_31076 = cljs.core.count(inst_31074);
var inst_31052 = inst_31075;
var inst_31053 = inst_31074;
var inst_31054 = inst_31076;
var inst_31055 = (0);
var state_31112__$1 = (function (){var statearr_31173 = state_31112;
(statearr_31173[(10)] = inst_31053);

(statearr_31173[(19)] = inst_31052);

(statearr_31173[(12)] = inst_31055);

(statearr_31173[(20)] = inst_31054);

return statearr_31173;
})();
var statearr_31178_33450 = state_31112__$1;
(statearr_31178_33450[(2)] = null);

(statearr_31178_33450[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (41))){
var inst_31070 = (state_31112[(23)]);
var inst_31086 = (state_31112[(2)]);
var inst_31087 = cljs.core.next(inst_31070);
var inst_31052 = inst_31087;
var inst_31053 = null;
var inst_31054 = (0);
var inst_31055 = (0);
var state_31112__$1 = (function (){var statearr_31179 = state_31112;
(statearr_31179[(25)] = inst_31086);

(statearr_31179[(10)] = inst_31053);

(statearr_31179[(19)] = inst_31052);

(statearr_31179[(12)] = inst_31055);

(statearr_31179[(20)] = inst_31054);

return statearr_31179;
})();
var statearr_31180_33457 = state_31112__$1;
(statearr_31180_33457[(2)] = null);

(statearr_31180_33457[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (43))){
var state_31112__$1 = state_31112;
var statearr_31181_33462 = state_31112__$1;
(statearr_31181_33462[(2)] = null);

(statearr_31181_33462[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (29))){
var inst_31096 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31182_33464 = state_31112__$1;
(statearr_31182_33464[(2)] = inst_31096);

(statearr_31182_33464[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (44))){
var inst_31105 = (state_31112[(2)]);
var state_31112__$1 = (function (){var statearr_31183 = state_31112;
(statearr_31183[(26)] = inst_31105);

return statearr_31183;
})();
var statearr_31184_33466 = state_31112__$1;
(statearr_31184_33466[(2)] = null);

(statearr_31184_33466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (6))){
var inst_31044 = (state_31112[(27)]);
var inst_31043 = cljs.core.deref(cs);
var inst_31044__$1 = cljs.core.keys(inst_31043);
var inst_31045 = cljs.core.count(inst_31044__$1);
var inst_31046 = cljs.core.reset_BANG_(dctr,inst_31045);
var inst_31051 = cljs.core.seq(inst_31044__$1);
var inst_31052 = inst_31051;
var inst_31053 = null;
var inst_31054 = (0);
var inst_31055 = (0);
var state_31112__$1 = (function (){var statearr_31185 = state_31112;
(statearr_31185[(28)] = inst_31046);

(statearr_31185[(27)] = inst_31044__$1);

(statearr_31185[(10)] = inst_31053);

(statearr_31185[(19)] = inst_31052);

(statearr_31185[(12)] = inst_31055);

(statearr_31185[(20)] = inst_31054);

return statearr_31185;
})();
var statearr_31186_33473 = state_31112__$1;
(statearr_31186_33473[(2)] = null);

(statearr_31186_33473[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (28))){
var inst_31052 = (state_31112[(19)]);
var inst_31070 = (state_31112[(23)]);
var inst_31070__$1 = cljs.core.seq(inst_31052);
var state_31112__$1 = (function (){var statearr_31188 = state_31112;
(statearr_31188[(23)] = inst_31070__$1);

return statearr_31188;
})();
if(inst_31070__$1){
var statearr_31189_33478 = state_31112__$1;
(statearr_31189_33478[(1)] = (33));

} else {
var statearr_31190_33479 = state_31112__$1;
(statearr_31190_33479[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (25))){
var inst_31055 = (state_31112[(12)]);
var inst_31054 = (state_31112[(20)]);
var inst_31057 = (inst_31055 < inst_31054);
var inst_31058 = inst_31057;
var state_31112__$1 = state_31112;
if(cljs.core.truth_(inst_31058)){
var statearr_31191_33483 = state_31112__$1;
(statearr_31191_33483[(1)] = (27));

} else {
var statearr_31192_33484 = state_31112__$1;
(statearr_31192_33484[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (34))){
var state_31112__$1 = state_31112;
var statearr_31195_33485 = state_31112__$1;
(statearr_31195_33485[(2)] = null);

(statearr_31195_33485[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (17))){
var state_31112__$1 = state_31112;
var statearr_31196_33487 = state_31112__$1;
(statearr_31196_33487[(2)] = null);

(statearr_31196_33487[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (3))){
var inst_31110 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31112__$1,inst_31110);
} else {
if((state_val_31113 === (12))){
var inst_31039 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31198_33507 = state_31112__$1;
(statearr_31198_33507[(2)] = inst_31039);

(statearr_31198_33507[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (2))){
var state_31112__$1 = state_31112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31112__$1,(4),ch);
} else {
if((state_val_31113 === (23))){
var state_31112__$1 = state_31112;
var statearr_31200_33534 = state_31112__$1;
(statearr_31200_33534[(2)] = null);

(statearr_31200_33534[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (35))){
var inst_31093 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31201_33539 = state_31112__$1;
(statearr_31201_33539[(2)] = inst_31093);

(statearr_31201_33539[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (19))){
var inst_31011 = (state_31112[(7)]);
var inst_31015 = cljs.core.chunk_first(inst_31011);
var inst_31016 = cljs.core.chunk_rest(inst_31011);
var inst_31017 = cljs.core.count(inst_31015);
var inst_30989 = inst_31016;
var inst_30990 = inst_31015;
var inst_30991 = inst_31017;
var inst_30992 = (0);
var state_31112__$1 = (function (){var statearr_31202 = state_31112;
(statearr_31202[(13)] = inst_30989);

(statearr_31202[(14)] = inst_30992);

(statearr_31202[(15)] = inst_30990);

(statearr_31202[(17)] = inst_30991);

return statearr_31202;
})();
var statearr_31203_33556 = state_31112__$1;
(statearr_31203_33556[(2)] = null);

(statearr_31203_33556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (11))){
var inst_30989 = (state_31112[(13)]);
var inst_31011 = (state_31112[(7)]);
var inst_31011__$1 = cljs.core.seq(inst_30989);
var state_31112__$1 = (function (){var statearr_31204 = state_31112;
(statearr_31204[(7)] = inst_31011__$1);

return statearr_31204;
})();
if(inst_31011__$1){
var statearr_31205_33566 = state_31112__$1;
(statearr_31205_33566[(1)] = (16));

} else {
var statearr_31206_33570 = state_31112__$1;
(statearr_31206_33570[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (9))){
var inst_31041 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31207_33573 = state_31112__$1;
(statearr_31207_33573[(2)] = inst_31041);

(statearr_31207_33573[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (5))){
var inst_30987 = cljs.core.deref(cs);
var inst_30988 = cljs.core.seq(inst_30987);
var inst_30989 = inst_30988;
var inst_30990 = null;
var inst_30991 = (0);
var inst_30992 = (0);
var state_31112__$1 = (function (){var statearr_31208 = state_31112;
(statearr_31208[(13)] = inst_30989);

(statearr_31208[(14)] = inst_30992);

(statearr_31208[(15)] = inst_30990);

(statearr_31208[(17)] = inst_30991);

return statearr_31208;
})();
var statearr_31209_33607 = state_31112__$1;
(statearr_31209_33607[(2)] = null);

(statearr_31209_33607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (14))){
var state_31112__$1 = state_31112;
var statearr_31210_33613 = state_31112__$1;
(statearr_31210_33613[(2)] = null);

(statearr_31210_33613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (45))){
var inst_31102 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31211_33624 = state_31112__$1;
(statearr_31211_33624[(2)] = inst_31102);

(statearr_31211_33624[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (26))){
var inst_31044 = (state_31112[(27)]);
var inst_31098 = (state_31112[(2)]);
var inst_31099 = cljs.core.seq(inst_31044);
var state_31112__$1 = (function (){var statearr_31212 = state_31112;
(statearr_31212[(29)] = inst_31098);

return statearr_31212;
})();
if(inst_31099){
var statearr_31213_33635 = state_31112__$1;
(statearr_31213_33635[(1)] = (42));

} else {
var statearr_31214_33639 = state_31112__$1;
(statearr_31214_33639[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (16))){
var inst_31011 = (state_31112[(7)]);
var inst_31013 = cljs.core.chunked_seq_QMARK_(inst_31011);
var state_31112__$1 = state_31112;
if(inst_31013){
var statearr_31215_33648 = state_31112__$1;
(statearr_31215_33648[(1)] = (19));

} else {
var statearr_31216_33649 = state_31112__$1;
(statearr_31216_33649[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (38))){
var inst_31090 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31217_33650 = state_31112__$1;
(statearr_31217_33650[(2)] = inst_31090);

(statearr_31217_33650[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (30))){
var state_31112__$1 = state_31112;
var statearr_31218_33651 = state_31112__$1;
(statearr_31218_33651[(2)] = null);

(statearr_31218_33651[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (10))){
var inst_30992 = (state_31112[(14)]);
var inst_30990 = (state_31112[(15)]);
var inst_31000 = cljs.core._nth(inst_30990,inst_30992);
var inst_31001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31000,(0),null);
var inst_31002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31000,(1),null);
var state_31112__$1 = (function (){var statearr_31220 = state_31112;
(statearr_31220[(24)] = inst_31001);

return statearr_31220;
})();
if(cljs.core.truth_(inst_31002)){
var statearr_31221_33657 = state_31112__$1;
(statearr_31221_33657[(1)] = (13));

} else {
var statearr_31222_33659 = state_31112__$1;
(statearr_31222_33659[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (18))){
var inst_31037 = (state_31112[(2)]);
var state_31112__$1 = state_31112;
var statearr_31223_33663 = state_31112__$1;
(statearr_31223_33663[(2)] = inst_31037);

(statearr_31223_33663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (42))){
var state_31112__$1 = state_31112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31112__$1,(45),dchan);
} else {
if((state_val_31113 === (37))){
var inst_31079 = (state_31112[(22)]);
var inst_30980 = (state_31112[(11)]);
var inst_31070 = (state_31112[(23)]);
var inst_31079__$1 = cljs.core.first(inst_31070);
var inst_31081 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31079__$1,inst_30980,done);
var state_31112__$1 = (function (){var statearr_31224 = state_31112;
(statearr_31224[(22)] = inst_31079__$1);

return statearr_31224;
})();
if(cljs.core.truth_(inst_31081)){
var statearr_31225_33670 = state_31112__$1;
(statearr_31225_33670[(1)] = (39));

} else {
var statearr_31226_33674 = state_31112__$1;
(statearr_31226_33674[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31113 === (8))){
var inst_30992 = (state_31112[(14)]);
var inst_30991 = (state_31112[(17)]);
var inst_30994 = (inst_30992 < inst_30991);
var inst_30995 = inst_30994;
var state_31112__$1 = state_31112;
if(cljs.core.truth_(inst_30995)){
var statearr_31230_33677 = state_31112__$1;
(statearr_31230_33677[(1)] = (10));

} else {
var statearr_31231_33678 = state_31112__$1;
(statearr_31231_33678[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__29726__auto__ = null;
var cljs$core$async$mult_$_state_machine__29726__auto____0 = (function (){
var statearr_31235 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31235[(0)] = cljs$core$async$mult_$_state_machine__29726__auto__);

(statearr_31235[(1)] = (1));

return statearr_31235;
});
var cljs$core$async$mult_$_state_machine__29726__auto____1 = (function (state_31112){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_31112);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e31236){var ex__29729__auto__ = e31236;
var statearr_31237_33680 = state_31112;
(statearr_31237_33680[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_31112[(4)]))){
var statearr_31238_33682 = state_31112;
(statearr_31238_33682[(1)] = cljs.core.first((state_31112[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33683 = state_31112;
state_31112 = G__33683;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29726__auto__ = function(state_31112){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29726__auto____1.call(this,state_31112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29726__auto____0;
cljs$core$async$mult_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29726__auto____1;
return cljs$core$async$mult_$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_31239 = f__30025__auto__();
(statearr_31239[(6)] = c__30024__auto___33368);

return statearr_31239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31244 = arguments.length;
switch (G__31244) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_33687 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_33687(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_33689 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_33689(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_33691 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_33691(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_33692 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_33692(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_33695 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_33695(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___33696 = arguments.length;
var i__4865__auto___33697 = (0);
while(true){
if((i__4865__auto___33697 < len__4864__auto___33696)){
args__4870__auto__.push((arguments[i__4865__auto___33697]));

var G__33698 = (i__4865__auto___33697 + (1));
i__4865__auto___33697 = G__33698;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31277){
var map__31279 = p__31277;
var map__31279__$1 = cljs.core.__destructure_map(map__31279);
var opts = map__31279__$1;
var statearr_31280_33699 = state;
(statearr_31280_33699[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_31285_33701 = state;
(statearr_31285_33701[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_31286_33703 = state;
(statearr_31286_33703[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31270){
var G__31271 = cljs.core.first(seq31270);
var seq31270__$1 = cljs.core.next(seq31270);
var G__31272 = cljs.core.first(seq31270__$1);
var seq31270__$2 = cljs.core.next(seq31270__$1);
var G__31273 = cljs.core.first(seq31270__$2);
var seq31270__$3 = cljs.core.next(seq31270__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31271,G__31272,G__31273,seq31270__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31303 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31303 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31304){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31304 = meta31304;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31305,meta31304__$1){
var self__ = this;
var _31305__$1 = this;
return (new cljs.core.async.t_cljs$core$async31303(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31304__$1));
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31305){
var self__ = this;
var _31305__$1 = this;
return self__.meta31304;
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31303.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31303.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31304","meta31304",1846543818,null)], null);
}));

(cljs.core.async.t_cljs$core$async31303.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31303.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31303");

(cljs.core.async.t_cljs$core$async31303.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31303");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31303.
 */
cljs.core.async.__GT_t_cljs$core$async31303 = (function cljs$core$async$mix_$___GT_t_cljs$core$async31303(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31304){
return (new cljs.core.async.t_cljs$core$async31303(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31304));
});

}

return (new cljs.core.async.t_cljs$core$async31303(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30024__auto___33733 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_31396){
var state_val_31397 = (state_31396[(1)]);
if((state_val_31397 === (7))){
var inst_31351 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
if(cljs.core.truth_(inst_31351)){
var statearr_31400_33734 = state_31396__$1;
(statearr_31400_33734[(1)] = (8));

} else {
var statearr_31401_33737 = state_31396__$1;
(statearr_31401_33737[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (20))){
var inst_31344 = (state_31396[(7)]);
var state_31396__$1 = state_31396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31396__$1,(23),out,inst_31344);
} else {
if((state_val_31397 === (1))){
var inst_31324 = calc_state();
var inst_31325 = cljs.core.__destructure_map(inst_31324);
var inst_31326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31325,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31325,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31325,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31329 = inst_31324;
var state_31396__$1 = (function (){var statearr_31405 = state_31396;
(statearr_31405[(8)] = inst_31328);

(statearr_31405[(9)] = inst_31326);

(statearr_31405[(10)] = inst_31327);

(statearr_31405[(11)] = inst_31329);

return statearr_31405;
})();
var statearr_31406_33738 = state_31396__$1;
(statearr_31406_33738[(2)] = null);

(statearr_31406_33738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (24))){
var inst_31333 = (state_31396[(12)]);
var inst_31329 = inst_31333;
var state_31396__$1 = (function (){var statearr_31408 = state_31396;
(statearr_31408[(11)] = inst_31329);

return statearr_31408;
})();
var statearr_31409_33739 = state_31396__$1;
(statearr_31409_33739[(2)] = null);

(statearr_31409_33739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (4))){
var inst_31344 = (state_31396[(7)]);
var inst_31346 = (state_31396[(13)]);
var inst_31343 = (state_31396[(2)]);
var inst_31344__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31343,(0),null);
var inst_31345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31343,(1),null);
var inst_31346__$1 = (inst_31344__$1 == null);
var state_31396__$1 = (function (){var statearr_31410 = state_31396;
(statearr_31410[(14)] = inst_31345);

(statearr_31410[(7)] = inst_31344__$1);

(statearr_31410[(13)] = inst_31346__$1);

return statearr_31410;
})();
if(cljs.core.truth_(inst_31346__$1)){
var statearr_31411_33742 = state_31396__$1;
(statearr_31411_33742[(1)] = (5));

} else {
var statearr_31412_33747 = state_31396__$1;
(statearr_31412_33747[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (15))){
var inst_31334 = (state_31396[(15)]);
var inst_31367 = (state_31396[(16)]);
var inst_31367__$1 = cljs.core.empty_QMARK_(inst_31334);
var state_31396__$1 = (function (){var statearr_31413 = state_31396;
(statearr_31413[(16)] = inst_31367__$1);

return statearr_31413;
})();
if(inst_31367__$1){
var statearr_31414_33748 = state_31396__$1;
(statearr_31414_33748[(1)] = (17));

} else {
var statearr_31415_33749 = state_31396__$1;
(statearr_31415_33749[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (21))){
var inst_31333 = (state_31396[(12)]);
var inst_31329 = inst_31333;
var state_31396__$1 = (function (){var statearr_31416 = state_31396;
(statearr_31416[(11)] = inst_31329);

return statearr_31416;
})();
var statearr_31417_33750 = state_31396__$1;
(statearr_31417_33750[(2)] = null);

(statearr_31417_33750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (13))){
var inst_31358 = (state_31396[(2)]);
var inst_31361 = calc_state();
var inst_31329 = inst_31361;
var state_31396__$1 = (function (){var statearr_31418 = state_31396;
(statearr_31418[(11)] = inst_31329);

(statearr_31418[(17)] = inst_31358);

return statearr_31418;
})();
var statearr_31420_33759 = state_31396__$1;
(statearr_31420_33759[(2)] = null);

(statearr_31420_33759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (22))){
var inst_31388 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
var statearr_31421_33760 = state_31396__$1;
(statearr_31421_33760[(2)] = inst_31388);

(statearr_31421_33760[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (6))){
var inst_31345 = (state_31396[(14)]);
var inst_31349 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31345,change);
var state_31396__$1 = state_31396;
var statearr_31422_33762 = state_31396__$1;
(statearr_31422_33762[(2)] = inst_31349);

(statearr_31422_33762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (25))){
var state_31396__$1 = state_31396;
var statearr_31423_33763 = state_31396__$1;
(statearr_31423_33763[(2)] = null);

(statearr_31423_33763[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (17))){
var inst_31345 = (state_31396[(14)]);
var inst_31337 = (state_31396[(18)]);
var inst_31369 = (inst_31337.cljs$core$IFn$_invoke$arity$1 ? inst_31337.cljs$core$IFn$_invoke$arity$1(inst_31345) : inst_31337.call(null,inst_31345));
var inst_31370 = cljs.core.not(inst_31369);
var state_31396__$1 = state_31396;
var statearr_31424_33768 = state_31396__$1;
(statearr_31424_33768[(2)] = inst_31370);

(statearr_31424_33768[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (3))){
var inst_31392 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31396__$1,inst_31392);
} else {
if((state_val_31397 === (12))){
var state_31396__$1 = state_31396;
var statearr_31425_33771 = state_31396__$1;
(statearr_31425_33771[(2)] = null);

(statearr_31425_33771[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (2))){
var inst_31329 = (state_31396[(11)]);
var inst_31333 = (state_31396[(12)]);
var inst_31333__$1 = cljs.core.__destructure_map(inst_31329);
var inst_31334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31333__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31333__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31333__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31396__$1 = (function (){var statearr_31427 = state_31396;
(statearr_31427[(15)] = inst_31334);

(statearr_31427[(18)] = inst_31337);

(statearr_31427[(12)] = inst_31333__$1);

return statearr_31427;
})();
return cljs.core.async.ioc_alts_BANG_(state_31396__$1,(4),inst_31338);
} else {
if((state_val_31397 === (23))){
var inst_31379 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
if(cljs.core.truth_(inst_31379)){
var statearr_31430_33842 = state_31396__$1;
(statearr_31430_33842[(1)] = (24));

} else {
var statearr_31432_33843 = state_31396__$1;
(statearr_31432_33843[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (19))){
var inst_31373 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
var statearr_31433_33852 = state_31396__$1;
(statearr_31433_33852[(2)] = inst_31373);

(statearr_31433_33852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (11))){
var inst_31345 = (state_31396[(14)]);
var inst_31355 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31345);
var state_31396__$1 = state_31396;
var statearr_31434_33853 = state_31396__$1;
(statearr_31434_33853[(2)] = inst_31355);

(statearr_31434_33853[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (9))){
var inst_31345 = (state_31396[(14)]);
var inst_31334 = (state_31396[(15)]);
var inst_31364 = (state_31396[(19)]);
var inst_31364__$1 = (inst_31334.cljs$core$IFn$_invoke$arity$1 ? inst_31334.cljs$core$IFn$_invoke$arity$1(inst_31345) : inst_31334.call(null,inst_31345));
var state_31396__$1 = (function (){var statearr_31435 = state_31396;
(statearr_31435[(19)] = inst_31364__$1);

return statearr_31435;
})();
if(cljs.core.truth_(inst_31364__$1)){
var statearr_31436_33856 = state_31396__$1;
(statearr_31436_33856[(1)] = (14));

} else {
var statearr_31438_33857 = state_31396__$1;
(statearr_31438_33857[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (5))){
var inst_31346 = (state_31396[(13)]);
var state_31396__$1 = state_31396;
var statearr_31440_33859 = state_31396__$1;
(statearr_31440_33859[(2)] = inst_31346);

(statearr_31440_33859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (14))){
var inst_31364 = (state_31396[(19)]);
var state_31396__$1 = state_31396;
var statearr_31445_33860 = state_31396__$1;
(statearr_31445_33860[(2)] = inst_31364);

(statearr_31445_33860[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (26))){
var inst_31384 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
var statearr_31446_33862 = state_31396__$1;
(statearr_31446_33862[(2)] = inst_31384);

(statearr_31446_33862[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (16))){
var inst_31375 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
if(cljs.core.truth_(inst_31375)){
var statearr_31447_33867 = state_31396__$1;
(statearr_31447_33867[(1)] = (20));

} else {
var statearr_31448_33868 = state_31396__$1;
(statearr_31448_33868[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (10))){
var inst_31390 = (state_31396[(2)]);
var state_31396__$1 = state_31396;
var statearr_31449_33871 = state_31396__$1;
(statearr_31449_33871[(2)] = inst_31390);

(statearr_31449_33871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (18))){
var inst_31367 = (state_31396[(16)]);
var state_31396__$1 = state_31396;
var statearr_31450_33876 = state_31396__$1;
(statearr_31450_33876[(2)] = inst_31367);

(statearr_31450_33876[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31397 === (8))){
var inst_31344 = (state_31396[(7)]);
var inst_31353 = (inst_31344 == null);
var state_31396__$1 = state_31396;
if(cljs.core.truth_(inst_31353)){
var statearr_31451_33879 = state_31396__$1;
(statearr_31451_33879[(1)] = (11));

} else {
var statearr_31452_33880 = state_31396__$1;
(statearr_31452_33880[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__29726__auto__ = null;
var cljs$core$async$mix_$_state_machine__29726__auto____0 = (function (){
var statearr_31453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31453[(0)] = cljs$core$async$mix_$_state_machine__29726__auto__);

(statearr_31453[(1)] = (1));

return statearr_31453;
});
var cljs$core$async$mix_$_state_machine__29726__auto____1 = (function (state_31396){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_31396);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e31455){var ex__29729__auto__ = e31455;
var statearr_31457_33883 = state_31396;
(statearr_31457_33883[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_31396[(4)]))){
var statearr_31459_33884 = state_31396;
(statearr_31459_33884[(1)] = cljs.core.first((state_31396[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33885 = state_31396;
state_31396 = G__33885;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29726__auto__ = function(state_31396){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29726__auto____1.call(this,state_31396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29726__auto____0;
cljs$core$async$mix_$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29726__auto____1;
return cljs$core$async$mix_$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_31460 = f__30025__auto__();
(statearr_31460[(6)] = c__30024__auto___33733);

return statearr_31460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_33887 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_33887(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_33893 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_33893(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_33897 = (function() {
var G__33898 = null;
var G__33898__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__33898__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__33898 = function(p,v){
switch(arguments.length){
case 1:
return G__33898__1.call(this,p);
case 2:
return G__33898__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33898.cljs$core$IFn$_invoke$arity$1 = G__33898__1;
G__33898.cljs$core$IFn$_invoke$arity$2 = G__33898__2;
return G__33898;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31506 = arguments.length;
switch (G__31506) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33897(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33897(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31510 = arguments.length;
switch (G__31510) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__31508_SHARP_){
if(cljs.core.truth_((p1__31508_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31508_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31508_SHARP_.call(null,topic)))){
return p1__31508_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31508_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31514 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31514 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31515){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31515 = meta31515;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31516,meta31515__$1){
var self__ = this;
var _31516__$1 = this;
return (new cljs.core.async.t_cljs$core$async31514(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31515__$1));
}));

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31516){
var self__ = this;
var _31516__$1 = this;
return self__.meta31515;
}));

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async31514.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async31514.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31515","meta31515",301609692,null)], null);
}));

(cljs.core.async.t_cljs$core$async31514.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31514.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31514");

(cljs.core.async.t_cljs$core$async31514.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async31514");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31514.
 */
cljs.core.async.__GT_t_cljs$core$async31514 = (function cljs$core$async$__GT_t_cljs$core$async31514(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31515){
return (new cljs.core.async.t_cljs$core$async31514(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31515));
});

}

return (new cljs.core.async.t_cljs$core$async31514(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30024__auto___33922 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_31601){
var state_val_31602 = (state_31601[(1)]);
if((state_val_31602 === (7))){
var inst_31593 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31603_33927 = state_31601__$1;
(statearr_31603_33927[(2)] = inst_31593);

(statearr_31603_33927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (20))){
var state_31601__$1 = state_31601;
var statearr_31604_33928 = state_31601__$1;
(statearr_31604_33928[(2)] = null);

(statearr_31604_33928[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (1))){
var state_31601__$1 = state_31601;
var statearr_31606_33929 = state_31601__$1;
(statearr_31606_33929[(2)] = null);

(statearr_31606_33929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (24))){
var inst_31572 = (state_31601[(7)]);
var inst_31581 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31572);
var state_31601__$1 = state_31601;
var statearr_31607_33930 = state_31601__$1;
(statearr_31607_33930[(2)] = inst_31581);

(statearr_31607_33930[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (4))){
var inst_31520 = (state_31601[(8)]);
var inst_31520__$1 = (state_31601[(2)]);
var inst_31521 = (inst_31520__$1 == null);
var state_31601__$1 = (function (){var statearr_31608 = state_31601;
(statearr_31608[(8)] = inst_31520__$1);

return statearr_31608;
})();
if(cljs.core.truth_(inst_31521)){
var statearr_31609_33935 = state_31601__$1;
(statearr_31609_33935[(1)] = (5));

} else {
var statearr_31610_33936 = state_31601__$1;
(statearr_31610_33936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (15))){
var inst_31562 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31611_33937 = state_31601__$1;
(statearr_31611_33937[(2)] = inst_31562);

(statearr_31611_33937[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (21))){
var inst_31586 = (state_31601[(2)]);
var state_31601__$1 = (function (){var statearr_31612 = state_31601;
(statearr_31612[(9)] = inst_31586);

return statearr_31612;
})();
var statearr_31613_33940 = state_31601__$1;
(statearr_31613_33940[(2)] = null);

(statearr_31613_33940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (13))){
var inst_31544 = (state_31601[(10)]);
var inst_31546 = cljs.core.chunked_seq_QMARK_(inst_31544);
var state_31601__$1 = state_31601;
if(inst_31546){
var statearr_31614_33941 = state_31601__$1;
(statearr_31614_33941[(1)] = (16));

} else {
var statearr_31615_33943 = state_31601__$1;
(statearr_31615_33943[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (22))){
var inst_31578 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
if(cljs.core.truth_(inst_31578)){
var statearr_31622_33944 = state_31601__$1;
(statearr_31622_33944[(1)] = (23));

} else {
var statearr_31623_33945 = state_31601__$1;
(statearr_31623_33945[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (6))){
var inst_31572 = (state_31601[(7)]);
var inst_31520 = (state_31601[(8)]);
var inst_31574 = (state_31601[(11)]);
var inst_31572__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31520) : topic_fn.call(null,inst_31520));
var inst_31573 = cljs.core.deref(mults);
var inst_31574__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31573,inst_31572__$1);
var state_31601__$1 = (function (){var statearr_31624 = state_31601;
(statearr_31624[(7)] = inst_31572__$1);

(statearr_31624[(11)] = inst_31574__$1);

return statearr_31624;
})();
if(cljs.core.truth_(inst_31574__$1)){
var statearr_31625_33947 = state_31601__$1;
(statearr_31625_33947[(1)] = (19));

} else {
var statearr_31626_33948 = state_31601__$1;
(statearr_31626_33948[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (25))){
var inst_31583 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31627_33949 = state_31601__$1;
(statearr_31627_33949[(2)] = inst_31583);

(statearr_31627_33949[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (17))){
var inst_31544 = (state_31601[(10)]);
var inst_31553 = cljs.core.first(inst_31544);
var inst_31554 = cljs.core.async.muxch_STAR_(inst_31553);
var inst_31555 = cljs.core.async.close_BANG_(inst_31554);
var inst_31556 = cljs.core.next(inst_31544);
var inst_31530 = inst_31556;
var inst_31531 = null;
var inst_31532 = (0);
var inst_31533 = (0);
var state_31601__$1 = (function (){var statearr_31628 = state_31601;
(statearr_31628[(12)] = inst_31533);

(statearr_31628[(13)] = inst_31555);

(statearr_31628[(14)] = inst_31532);

(statearr_31628[(15)] = inst_31530);

(statearr_31628[(16)] = inst_31531);

return statearr_31628;
})();
var statearr_31629_33950 = state_31601__$1;
(statearr_31629_33950[(2)] = null);

(statearr_31629_33950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (3))){
var inst_31595 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31601__$1,inst_31595);
} else {
if((state_val_31602 === (12))){
var inst_31564 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31631_33951 = state_31601__$1;
(statearr_31631_33951[(2)] = inst_31564);

(statearr_31631_33951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (2))){
var state_31601__$1 = state_31601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31601__$1,(4),ch);
} else {
if((state_val_31602 === (23))){
var state_31601__$1 = state_31601;
var statearr_31636_33952 = state_31601__$1;
(statearr_31636_33952[(2)] = null);

(statearr_31636_33952[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (19))){
var inst_31520 = (state_31601[(8)]);
var inst_31574 = (state_31601[(11)]);
var inst_31576 = cljs.core.async.muxch_STAR_(inst_31574);
var state_31601__$1 = state_31601;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31601__$1,(22),inst_31576,inst_31520);
} else {
if((state_val_31602 === (11))){
var inst_31530 = (state_31601[(15)]);
var inst_31544 = (state_31601[(10)]);
var inst_31544__$1 = cljs.core.seq(inst_31530);
var state_31601__$1 = (function (){var statearr_31645 = state_31601;
(statearr_31645[(10)] = inst_31544__$1);

return statearr_31645;
})();
if(inst_31544__$1){
var statearr_31648_33955 = state_31601__$1;
(statearr_31648_33955[(1)] = (13));

} else {
var statearr_31649_33956 = state_31601__$1;
(statearr_31649_33956[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (9))){
var inst_31566 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31650_33957 = state_31601__$1;
(statearr_31650_33957[(2)] = inst_31566);

(statearr_31650_33957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (5))){
var inst_31527 = cljs.core.deref(mults);
var inst_31528 = cljs.core.vals(inst_31527);
var inst_31529 = cljs.core.seq(inst_31528);
var inst_31530 = inst_31529;
var inst_31531 = null;
var inst_31532 = (0);
var inst_31533 = (0);
var state_31601__$1 = (function (){var statearr_31651 = state_31601;
(statearr_31651[(12)] = inst_31533);

(statearr_31651[(14)] = inst_31532);

(statearr_31651[(15)] = inst_31530);

(statearr_31651[(16)] = inst_31531);

return statearr_31651;
})();
var statearr_31652_33958 = state_31601__$1;
(statearr_31652_33958[(2)] = null);

(statearr_31652_33958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (14))){
var state_31601__$1 = state_31601;
var statearr_31656_33959 = state_31601__$1;
(statearr_31656_33959[(2)] = null);

(statearr_31656_33959[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (16))){
var inst_31544 = (state_31601[(10)]);
var inst_31548 = cljs.core.chunk_first(inst_31544);
var inst_31549 = cljs.core.chunk_rest(inst_31544);
var inst_31550 = cljs.core.count(inst_31548);
var inst_31530 = inst_31549;
var inst_31531 = inst_31548;
var inst_31532 = inst_31550;
var inst_31533 = (0);
var state_31601__$1 = (function (){var statearr_31658 = state_31601;
(statearr_31658[(12)] = inst_31533);

(statearr_31658[(14)] = inst_31532);

(statearr_31658[(15)] = inst_31530);

(statearr_31658[(16)] = inst_31531);

return statearr_31658;
})();
var statearr_31659_33960 = state_31601__$1;
(statearr_31659_33960[(2)] = null);

(statearr_31659_33960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (10))){
var inst_31533 = (state_31601[(12)]);
var inst_31532 = (state_31601[(14)]);
var inst_31530 = (state_31601[(15)]);
var inst_31531 = (state_31601[(16)]);
var inst_31538 = cljs.core._nth(inst_31531,inst_31533);
var inst_31539 = cljs.core.async.muxch_STAR_(inst_31538);
var inst_31540 = cljs.core.async.close_BANG_(inst_31539);
var inst_31541 = (inst_31533 + (1));
var tmp31653 = inst_31532;
var tmp31654 = inst_31530;
var tmp31655 = inst_31531;
var inst_31530__$1 = tmp31654;
var inst_31531__$1 = tmp31655;
var inst_31532__$1 = tmp31653;
var inst_31533__$1 = inst_31541;
var state_31601__$1 = (function (){var statearr_31660 = state_31601;
(statearr_31660[(12)] = inst_31533__$1);

(statearr_31660[(17)] = inst_31540);

(statearr_31660[(14)] = inst_31532__$1);

(statearr_31660[(15)] = inst_31530__$1);

(statearr_31660[(16)] = inst_31531__$1);

return statearr_31660;
})();
var statearr_31661_33961 = state_31601__$1;
(statearr_31661_33961[(2)] = null);

(statearr_31661_33961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (18))){
var inst_31559 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31664_33962 = state_31601__$1;
(statearr_31664_33962[(2)] = inst_31559);

(statearr_31664_33962[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (8))){
var inst_31533 = (state_31601[(12)]);
var inst_31532 = (state_31601[(14)]);
var inst_31535 = (inst_31533 < inst_31532);
var inst_31536 = inst_31535;
var state_31601__$1 = state_31601;
if(cljs.core.truth_(inst_31536)){
var statearr_31666_33965 = state_31601__$1;
(statearr_31666_33965[(1)] = (10));

} else {
var statearr_31667_33967 = state_31601__$1;
(statearr_31667_33967[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_31668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31668[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_31668[(1)] = (1));

return statearr_31668;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_31601){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_31601);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e31669){var ex__29729__auto__ = e31669;
var statearr_31670_33975 = state_31601;
(statearr_31670_33975[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_31601[(4)]))){
var statearr_31671_33976 = state_31601;
(statearr_31671_33976[(1)] = cljs.core.first((state_31601[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33977 = state_31601;
state_31601 = G__33977;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_31601){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_31601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_31672 = f__30025__auto__();
(statearr_31672[(6)] = c__30024__auto___33922);

return statearr_31672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__31675 = arguments.length;
switch (G__31675) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__31691 = arguments.length;
switch (G__31691) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__31710 = arguments.length;
switch (G__31710) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30024__auto___33981 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_31764){
var state_val_31765 = (state_31764[(1)]);
if((state_val_31765 === (7))){
var state_31764__$1 = state_31764;
var statearr_31769_33982 = state_31764__$1;
(statearr_31769_33982[(2)] = null);

(statearr_31769_33982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (1))){
var state_31764__$1 = state_31764;
var statearr_31775_33983 = state_31764__$1;
(statearr_31775_33983[(2)] = null);

(statearr_31775_33983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (4))){
var inst_31720 = (state_31764[(7)]);
var inst_31719 = (state_31764[(8)]);
var inst_31722 = (inst_31720 < inst_31719);
var state_31764__$1 = state_31764;
if(cljs.core.truth_(inst_31722)){
var statearr_31776_33984 = state_31764__$1;
(statearr_31776_33984[(1)] = (6));

} else {
var statearr_31777_33985 = state_31764__$1;
(statearr_31777_33985[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (15))){
var inst_31750 = (state_31764[(9)]);
var inst_31755 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31750);
var state_31764__$1 = state_31764;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31764__$1,(17),out,inst_31755);
} else {
if((state_val_31765 === (13))){
var inst_31750 = (state_31764[(9)]);
var inst_31750__$1 = (state_31764[(2)]);
var inst_31751 = cljs.core.some(cljs.core.nil_QMARK_,inst_31750__$1);
var state_31764__$1 = (function (){var statearr_31781 = state_31764;
(statearr_31781[(9)] = inst_31750__$1);

return statearr_31781;
})();
if(cljs.core.truth_(inst_31751)){
var statearr_31782_33986 = state_31764__$1;
(statearr_31782_33986[(1)] = (14));

} else {
var statearr_31783_33989 = state_31764__$1;
(statearr_31783_33989[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (6))){
var state_31764__$1 = state_31764;
var statearr_31785_33992 = state_31764__$1;
(statearr_31785_33992[(2)] = null);

(statearr_31785_33992[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (17))){
var inst_31757 = (state_31764[(2)]);
var state_31764__$1 = (function (){var statearr_31800 = state_31764;
(statearr_31800[(10)] = inst_31757);

return statearr_31800;
})();
var statearr_31802_33994 = state_31764__$1;
(statearr_31802_33994[(2)] = null);

(statearr_31802_33994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (3))){
var inst_31762 = (state_31764[(2)]);
var state_31764__$1 = state_31764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31764__$1,inst_31762);
} else {
if((state_val_31765 === (12))){
var _ = (function (){var statearr_31812 = state_31764;
(statearr_31812[(4)] = cljs.core.rest((state_31764[(4)])));

return statearr_31812;
})();
var state_31764__$1 = state_31764;
var ex31796 = (state_31764__$1[(2)]);
var statearr_31818_33996 = state_31764__$1;
(statearr_31818_33996[(5)] = ex31796);


if((ex31796 instanceof Object)){
var statearr_31823_33998 = state_31764__$1;
(statearr_31823_33998[(1)] = (11));

(statearr_31823_33998[(5)] = null);

} else {
throw ex31796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (2))){
var inst_31718 = cljs.core.reset_BANG_(dctr,cnt);
var inst_31719 = cnt;
var inst_31720 = (0);
var state_31764__$1 = (function (){var statearr_31834 = state_31764;
(statearr_31834[(7)] = inst_31720);

(statearr_31834[(11)] = inst_31718);

(statearr_31834[(8)] = inst_31719);

return statearr_31834;
})();
var statearr_31840_33999 = state_31764__$1;
(statearr_31840_33999[(2)] = null);

(statearr_31840_33999[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (11))){
var inst_31727 = (state_31764[(2)]);
var inst_31729 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31764__$1 = (function (){var statearr_31845 = state_31764;
(statearr_31845[(12)] = inst_31727);

return statearr_31845;
})();
var statearr_31847_34000 = state_31764__$1;
(statearr_31847_34000[(2)] = inst_31729);

(statearr_31847_34000[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (9))){
var inst_31720 = (state_31764[(7)]);
var _ = (function (){var statearr_31850 = state_31764;
(statearr_31850[(4)] = cljs.core.cons((12),(state_31764[(4)])));

return statearr_31850;
})();
var inst_31735 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31720) : chs__$1.call(null,inst_31720));
var inst_31736 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31720) : done.call(null,inst_31720));
var inst_31737 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31735,inst_31736);
var ___$1 = (function (){var statearr_31855 = state_31764;
(statearr_31855[(4)] = cljs.core.rest((state_31764[(4)])));

return statearr_31855;
})();
var state_31764__$1 = state_31764;
var statearr_31862_34002 = state_31764__$1;
(statearr_31862_34002[(2)] = inst_31737);

(statearr_31862_34002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (5))){
var inst_31748 = (state_31764[(2)]);
var state_31764__$1 = (function (){var statearr_31863 = state_31764;
(statearr_31863[(13)] = inst_31748);

return statearr_31863;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31764__$1,(13),dchan);
} else {
if((state_val_31765 === (14))){
var inst_31753 = cljs.core.async.close_BANG_(out);
var state_31764__$1 = state_31764;
var statearr_31865_34007 = state_31764__$1;
(statearr_31865_34007[(2)] = inst_31753);

(statearr_31865_34007[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (16))){
var inst_31760 = (state_31764[(2)]);
var state_31764__$1 = state_31764;
var statearr_31866_34008 = state_31764__$1;
(statearr_31866_34008[(2)] = inst_31760);

(statearr_31866_34008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (10))){
var inst_31720 = (state_31764[(7)]);
var inst_31740 = (state_31764[(2)]);
var inst_31742 = (inst_31720 + (1));
var inst_31720__$1 = inst_31742;
var state_31764__$1 = (function (){var statearr_31869 = state_31764;
(statearr_31869[(7)] = inst_31720__$1);

(statearr_31869[(14)] = inst_31740);

return statearr_31869;
})();
var statearr_31870_34009 = state_31764__$1;
(statearr_31870_34009[(2)] = null);

(statearr_31870_34009[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31765 === (8))){
var inst_31746 = (state_31764[(2)]);
var state_31764__$1 = state_31764;
var statearr_31875_34010 = state_31764__$1;
(statearr_31875_34010[(2)] = inst_31746);

(statearr_31875_34010[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_31877 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31877[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_31877[(1)] = (1));

return statearr_31877;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_31764){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_31764);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e31884){var ex__29729__auto__ = e31884;
var statearr_31886_34011 = state_31764;
(statearr_31886_34011[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_31764[(4)]))){
var statearr_31895_34013 = state_31764;
(statearr_31895_34013[(1)] = cljs.core.first((state_31764[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34015 = state_31764;
state_31764 = G__34015;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_31764){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_31764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_31904 = f__30025__auto__();
(statearr_31904[(6)] = c__30024__auto___33981);

return statearr_31904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__31914 = arguments.length;
switch (G__31914) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30024__auto___34019 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_31953){
var state_val_31954 = (state_31953[(1)]);
if((state_val_31954 === (7))){
var inst_31926 = (state_31953[(7)]);
var inst_31925 = (state_31953[(8)]);
var inst_31925__$1 = (state_31953[(2)]);
var inst_31926__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31925__$1,(0),null);
var inst_31927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31925__$1,(1),null);
var inst_31928 = (inst_31926__$1 == null);
var state_31953__$1 = (function (){var statearr_31959 = state_31953;
(statearr_31959[(9)] = inst_31927);

(statearr_31959[(7)] = inst_31926__$1);

(statearr_31959[(8)] = inst_31925__$1);

return statearr_31959;
})();
if(cljs.core.truth_(inst_31928)){
var statearr_31960_34021 = state_31953__$1;
(statearr_31960_34021[(1)] = (8));

} else {
var statearr_31961_34025 = state_31953__$1;
(statearr_31961_34025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (1))){
var inst_31915 = cljs.core.vec(chs);
var inst_31916 = inst_31915;
var state_31953__$1 = (function (){var statearr_31962 = state_31953;
(statearr_31962[(10)] = inst_31916);

return statearr_31962;
})();
var statearr_31963_34026 = state_31953__$1;
(statearr_31963_34026[(2)] = null);

(statearr_31963_34026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (4))){
var inst_31916 = (state_31953[(10)]);
var state_31953__$1 = state_31953;
return cljs.core.async.ioc_alts_BANG_(state_31953__$1,(7),inst_31916);
} else {
if((state_val_31954 === (6))){
var inst_31949 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
var statearr_31964_34031 = state_31953__$1;
(statearr_31964_34031[(2)] = inst_31949);

(statearr_31964_34031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (3))){
var inst_31951 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31953__$1,inst_31951);
} else {
if((state_val_31954 === (2))){
var inst_31916 = (state_31953[(10)]);
var inst_31918 = cljs.core.count(inst_31916);
var inst_31919 = (inst_31918 > (0));
var state_31953__$1 = state_31953;
if(cljs.core.truth_(inst_31919)){
var statearr_31977_34036 = state_31953__$1;
(statearr_31977_34036[(1)] = (4));

} else {
var statearr_31978_34037 = state_31953__$1;
(statearr_31978_34037[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (11))){
var inst_31916 = (state_31953[(10)]);
var inst_31942 = (state_31953[(2)]);
var tmp31969 = inst_31916;
var inst_31916__$1 = tmp31969;
var state_31953__$1 = (function (){var statearr_31983 = state_31953;
(statearr_31983[(10)] = inst_31916__$1);

(statearr_31983[(11)] = inst_31942);

return statearr_31983;
})();
var statearr_31984_34039 = state_31953__$1;
(statearr_31984_34039[(2)] = null);

(statearr_31984_34039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (9))){
var inst_31926 = (state_31953[(7)]);
var state_31953__$1 = state_31953;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31953__$1,(11),out,inst_31926);
} else {
if((state_val_31954 === (5))){
var inst_31947 = cljs.core.async.close_BANG_(out);
var state_31953__$1 = state_31953;
var statearr_31989_34040 = state_31953__$1;
(statearr_31989_34040[(2)] = inst_31947);

(statearr_31989_34040[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (10))){
var inst_31945 = (state_31953[(2)]);
var state_31953__$1 = state_31953;
var statearr_31990_34041 = state_31953__$1;
(statearr_31990_34041[(2)] = inst_31945);

(statearr_31990_34041[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31954 === (8))){
var inst_31916 = (state_31953[(10)]);
var inst_31927 = (state_31953[(9)]);
var inst_31926 = (state_31953[(7)]);
var inst_31925 = (state_31953[(8)]);
var inst_31937 = (function (){var cs = inst_31916;
var vec__31921 = inst_31925;
var v = inst_31926;
var c = inst_31927;
return (function (p1__31908_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31908_SHARP_);
});
})();
var inst_31938 = cljs.core.filterv(inst_31937,inst_31916);
var inst_31916__$1 = inst_31938;
var state_31953__$1 = (function (){var statearr_31991 = state_31953;
(statearr_31991[(10)] = inst_31916__$1);

return statearr_31991;
})();
var statearr_31992_34042 = state_31953__$1;
(statearr_31992_34042[(2)] = null);

(statearr_31992_34042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_31993 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31993[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_31993[(1)] = (1));

return statearr_31993;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_31953){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_31953);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e31994){var ex__29729__auto__ = e31994;
var statearr_31995_34043 = state_31953;
(statearr_31995_34043[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_31953[(4)]))){
var statearr_31996_34045 = state_31953;
(statearr_31996_34045[(1)] = cljs.core.first((state_31953[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34046 = state_31953;
state_31953 = G__34046;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_31953){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_31953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_31998 = f__30025__auto__();
(statearr_31998[(6)] = c__30024__auto___34019);

return statearr_31998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32000 = arguments.length;
switch (G__32000) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30024__auto___34052 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_32025){
var state_val_32026 = (state_32025[(1)]);
if((state_val_32026 === (7))){
var inst_32007 = (state_32025[(7)]);
var inst_32007__$1 = (state_32025[(2)]);
var inst_32008 = (inst_32007__$1 == null);
var inst_32009 = cljs.core.not(inst_32008);
var state_32025__$1 = (function (){var statearr_32029 = state_32025;
(statearr_32029[(7)] = inst_32007__$1);

return statearr_32029;
})();
if(inst_32009){
var statearr_32031_34053 = state_32025__$1;
(statearr_32031_34053[(1)] = (8));

} else {
var statearr_32033_34054 = state_32025__$1;
(statearr_32033_34054[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (1))){
var inst_32002 = (0);
var state_32025__$1 = (function (){var statearr_32037 = state_32025;
(statearr_32037[(8)] = inst_32002);

return statearr_32037;
})();
var statearr_32038_34058 = state_32025__$1;
(statearr_32038_34058[(2)] = null);

(statearr_32038_34058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (4))){
var state_32025__$1 = state_32025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32025__$1,(7),ch);
} else {
if((state_val_32026 === (6))){
var inst_32020 = (state_32025[(2)]);
var state_32025__$1 = state_32025;
var statearr_32041_34059 = state_32025__$1;
(statearr_32041_34059[(2)] = inst_32020);

(statearr_32041_34059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (3))){
var inst_32022 = (state_32025[(2)]);
var inst_32023 = cljs.core.async.close_BANG_(out);
var state_32025__$1 = (function (){var statearr_32044 = state_32025;
(statearr_32044[(9)] = inst_32022);

return statearr_32044;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32025__$1,inst_32023);
} else {
if((state_val_32026 === (2))){
var inst_32002 = (state_32025[(8)]);
var inst_32004 = (inst_32002 < n);
var state_32025__$1 = state_32025;
if(cljs.core.truth_(inst_32004)){
var statearr_32048_34060 = state_32025__$1;
(statearr_32048_34060[(1)] = (4));

} else {
var statearr_32050_34061 = state_32025__$1;
(statearr_32050_34061[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (11))){
var inst_32002 = (state_32025[(8)]);
var inst_32012 = (state_32025[(2)]);
var inst_32013 = (inst_32002 + (1));
var inst_32002__$1 = inst_32013;
var state_32025__$1 = (function (){var statearr_32051 = state_32025;
(statearr_32051[(10)] = inst_32012);

(statearr_32051[(8)] = inst_32002__$1);

return statearr_32051;
})();
var statearr_32053_34062 = state_32025__$1;
(statearr_32053_34062[(2)] = null);

(statearr_32053_34062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (9))){
var state_32025__$1 = state_32025;
var statearr_32054_34063 = state_32025__$1;
(statearr_32054_34063[(2)] = null);

(statearr_32054_34063[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (5))){
var state_32025__$1 = state_32025;
var statearr_32055_34064 = state_32025__$1;
(statearr_32055_34064[(2)] = null);

(statearr_32055_34064[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (10))){
var inst_32017 = (state_32025[(2)]);
var state_32025__$1 = state_32025;
var statearr_32056_34065 = state_32025__$1;
(statearr_32056_34065[(2)] = inst_32017);

(statearr_32056_34065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32026 === (8))){
var inst_32007 = (state_32025[(7)]);
var state_32025__$1 = state_32025;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32025__$1,(11),out,inst_32007);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_32061 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32061[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_32061[(1)] = (1));

return statearr_32061;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_32025){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_32025);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e32063){var ex__29729__auto__ = e32063;
var statearr_32066_34066 = state_32025;
(statearr_32066_34066[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_32025[(4)]))){
var statearr_32067_34067 = state_32025;
(statearr_32067_34067[(1)] = cljs.core.first((state_32025[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34068 = state_32025;
state_32025 = G__34068;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_32025){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_32025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_32068 = f__30025__auto__();
(statearr_32068[(6)] = c__30024__auto___34052);

return statearr_32068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32071 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32071 = (function (f,ch,meta32072){
this.f = f;
this.ch = ch;
this.meta32072 = meta32072;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32073,meta32072__$1){
var self__ = this;
var _32073__$1 = this;
return (new cljs.core.async.t_cljs$core$async32071(self__.f,self__.ch,meta32072__$1));
}));

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32073){
var self__ = this;
var _32073__$1 = this;
return self__.meta32072;
}));

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32099 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32099 = (function (f,ch,meta32072,_,fn1,meta32100){
this.f = f;
this.ch = ch;
this.meta32072 = meta32072;
this._ = _;
this.fn1 = fn1;
this.meta32100 = meta32100;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32099.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32101,meta32100__$1){
var self__ = this;
var _32101__$1 = this;
return (new cljs.core.async.t_cljs$core$async32099(self__.f,self__.ch,self__.meta32072,self__._,self__.fn1,meta32100__$1));
}));

(cljs.core.async.t_cljs$core$async32099.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32101){
var self__ = this;
var _32101__$1 = this;
return self__.meta32100;
}));

(cljs.core.async.t_cljs$core$async32099.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32099.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async32099.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async32099.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__32069_SHARP_){
var G__32116 = (((p1__32069_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__32069_SHARP_) : self__.f.call(null,p1__32069_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32116) : f1.call(null,G__32116));
});
}));

(cljs.core.async.t_cljs$core$async32099.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32072","meta32072",1006913957,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32071","cljs.core.async/t_cljs$core$async32071",-1196320002,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32100","meta32100",-1391592515,null)], null);
}));

(cljs.core.async.t_cljs$core$async32099.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32099.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32099");

(cljs.core.async.t_cljs$core$async32099.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async32099");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32099.
 */
cljs.core.async.__GT_t_cljs$core$async32099 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32099(f__$1,ch__$1,meta32072__$1,___$2,fn1__$1,meta32100){
return (new cljs.core.async.t_cljs$core$async32099(f__$1,ch__$1,meta32072__$1,___$2,fn1__$1,meta32100));
});

}

return (new cljs.core.async.t_cljs$core$async32099(self__.f,self__.ch,self__.meta32072,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32117 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32117) : self__.f.call(null,G__32117));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32071.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async32071.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32072","meta32072",1006913957,null)], null);
}));

(cljs.core.async.t_cljs$core$async32071.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32071.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32071");

(cljs.core.async.t_cljs$core$async32071.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async32071");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32071.
 */
cljs.core.async.__GT_t_cljs$core$async32071 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32071(f__$1,ch__$1,meta32072){
return (new cljs.core.async.t_cljs$core$async32071(f__$1,ch__$1,meta32072));
});

}

return (new cljs.core.async.t_cljs$core$async32071(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32120 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32120 = (function (f,ch,meta32121){
this.f = f;
this.ch = ch;
this.meta32121 = meta32121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32122,meta32121__$1){
var self__ = this;
var _32122__$1 = this;
return (new cljs.core.async.t_cljs$core$async32120(self__.f,self__.ch,meta32121__$1));
}));

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32122){
var self__ = this;
var _32122__$1 = this;
return self__.meta32121;
}));

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32120.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async32120.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32121","meta32121",1423617552,null)], null);
}));

(cljs.core.async.t_cljs$core$async32120.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32120.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32120");

(cljs.core.async.t_cljs$core$async32120.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async32120");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32120.
 */
cljs.core.async.__GT_t_cljs$core$async32120 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32120(f__$1,ch__$1,meta32121){
return (new cljs.core.async.t_cljs$core$async32120(f__$1,ch__$1,meta32121));
});

}

return (new cljs.core.async.t_cljs$core$async32120(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32133 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32133 = (function (p,ch,meta32134){
this.p = p;
this.ch = ch;
this.meta32134 = meta32134;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32135,meta32134__$1){
var self__ = this;
var _32135__$1 = this;
return (new cljs.core.async.t_cljs$core$async32133(self__.p,self__.ch,meta32134__$1));
}));

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32135){
var self__ = this;
var _32135__$1 = this;
return self__.meta32134;
}));

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32133.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32133.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32134","meta32134",1139368785,null)], null);
}));

(cljs.core.async.t_cljs$core$async32133.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32133.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32133");

(cljs.core.async.t_cljs$core$async32133.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async32133");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32133.
 */
cljs.core.async.__GT_t_cljs$core$async32133 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32133(p__$1,ch__$1,meta32134){
return (new cljs.core.async.t_cljs$core$async32133(p__$1,ch__$1,meta32134));
});

}

return (new cljs.core.async.t_cljs$core$async32133(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32168 = arguments.length;
switch (G__32168) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30024__auto___34151 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_32197){
var state_val_32198 = (state_32197[(1)]);
if((state_val_32198 === (7))){
var inst_32192 = (state_32197[(2)]);
var state_32197__$1 = state_32197;
var statearr_32199_34152 = state_32197__$1;
(statearr_32199_34152[(2)] = inst_32192);

(statearr_32199_34152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (1))){
var state_32197__$1 = state_32197;
var statearr_32200_34153 = state_32197__$1;
(statearr_32200_34153[(2)] = null);

(statearr_32200_34153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (4))){
var inst_32176 = (state_32197[(7)]);
var inst_32176__$1 = (state_32197[(2)]);
var inst_32177 = (inst_32176__$1 == null);
var state_32197__$1 = (function (){var statearr_32201 = state_32197;
(statearr_32201[(7)] = inst_32176__$1);

return statearr_32201;
})();
if(cljs.core.truth_(inst_32177)){
var statearr_32202_34154 = state_32197__$1;
(statearr_32202_34154[(1)] = (5));

} else {
var statearr_32203_34155 = state_32197__$1;
(statearr_32203_34155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (6))){
var inst_32176 = (state_32197[(7)]);
var inst_32181 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32176) : p.call(null,inst_32176));
var state_32197__$1 = state_32197;
if(cljs.core.truth_(inst_32181)){
var statearr_32205_34156 = state_32197__$1;
(statearr_32205_34156[(1)] = (8));

} else {
var statearr_32206_34157 = state_32197__$1;
(statearr_32206_34157[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (3))){
var inst_32194 = (state_32197[(2)]);
var state_32197__$1 = state_32197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32197__$1,inst_32194);
} else {
if((state_val_32198 === (2))){
var state_32197__$1 = state_32197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32197__$1,(4),ch);
} else {
if((state_val_32198 === (11))){
var inst_32185 = (state_32197[(2)]);
var state_32197__$1 = state_32197;
var statearr_32210_34164 = state_32197__$1;
(statearr_32210_34164[(2)] = inst_32185);

(statearr_32210_34164[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (9))){
var state_32197__$1 = state_32197;
var statearr_32211_34165 = state_32197__$1;
(statearr_32211_34165[(2)] = null);

(statearr_32211_34165[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (5))){
var inst_32179 = cljs.core.async.close_BANG_(out);
var state_32197__$1 = state_32197;
var statearr_32212_34166 = state_32197__$1;
(statearr_32212_34166[(2)] = inst_32179);

(statearr_32212_34166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (10))){
var inst_32188 = (state_32197[(2)]);
var state_32197__$1 = (function (){var statearr_32213 = state_32197;
(statearr_32213[(8)] = inst_32188);

return statearr_32213;
})();
var statearr_32214_34167 = state_32197__$1;
(statearr_32214_34167[(2)] = null);

(statearr_32214_34167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32198 === (8))){
var inst_32176 = (state_32197[(7)]);
var state_32197__$1 = state_32197;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32197__$1,(11),out,inst_32176);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_32215 = [null,null,null,null,null,null,null,null,null];
(statearr_32215[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_32215[(1)] = (1));

return statearr_32215;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_32197){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_32197);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e32216){var ex__29729__auto__ = e32216;
var statearr_32217_34168 = state_32197;
(statearr_32217_34168[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_32197[(4)]))){
var statearr_32218_34169 = state_32197;
(statearr_32218_34169[(1)] = cljs.core.first((state_32197[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34170 = state_32197;
state_32197 = G__34170;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_32197){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_32197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_32226 = f__30025__auto__();
(statearr_32226[(6)] = c__30024__auto___34151);

return statearr_32226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32238 = arguments.length;
switch (G__32238) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30024__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_32307){
var state_val_32308 = (state_32307[(1)]);
if((state_val_32308 === (7))){
var inst_32303 = (state_32307[(2)]);
var state_32307__$1 = state_32307;
var statearr_32313_34180 = state_32307__$1;
(statearr_32313_34180[(2)] = inst_32303);

(statearr_32313_34180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (20))){
var inst_32267 = (state_32307[(7)]);
var inst_32283 = (state_32307[(2)]);
var inst_32284 = cljs.core.next(inst_32267);
var inst_32253 = inst_32284;
var inst_32254 = null;
var inst_32255 = (0);
var inst_32256 = (0);
var state_32307__$1 = (function (){var statearr_32314 = state_32307;
(statearr_32314[(8)] = inst_32253);

(statearr_32314[(9)] = inst_32283);

(statearr_32314[(10)] = inst_32255);

(statearr_32314[(11)] = inst_32256);

(statearr_32314[(12)] = inst_32254);

return statearr_32314;
})();
var statearr_32315_34189 = state_32307__$1;
(statearr_32315_34189[(2)] = null);

(statearr_32315_34189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (1))){
var state_32307__$1 = state_32307;
var statearr_32316_34190 = state_32307__$1;
(statearr_32316_34190[(2)] = null);

(statearr_32316_34190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (4))){
var inst_32242 = (state_32307[(13)]);
var inst_32242__$1 = (state_32307[(2)]);
var inst_32243 = (inst_32242__$1 == null);
var state_32307__$1 = (function (){var statearr_32318 = state_32307;
(statearr_32318[(13)] = inst_32242__$1);

return statearr_32318;
})();
if(cljs.core.truth_(inst_32243)){
var statearr_32319_34191 = state_32307__$1;
(statearr_32319_34191[(1)] = (5));

} else {
var statearr_32320_34192 = state_32307__$1;
(statearr_32320_34192[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (15))){
var state_32307__$1 = state_32307;
var statearr_32324_34193 = state_32307__$1;
(statearr_32324_34193[(2)] = null);

(statearr_32324_34193[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (21))){
var state_32307__$1 = state_32307;
var statearr_32327_34194 = state_32307__$1;
(statearr_32327_34194[(2)] = null);

(statearr_32327_34194[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (13))){
var inst_32253 = (state_32307[(8)]);
var inst_32255 = (state_32307[(10)]);
var inst_32256 = (state_32307[(11)]);
var inst_32254 = (state_32307[(12)]);
var inst_32263 = (state_32307[(2)]);
var inst_32264 = (inst_32256 + (1));
var tmp32321 = inst_32253;
var tmp32322 = inst_32255;
var tmp32323 = inst_32254;
var inst_32253__$1 = tmp32321;
var inst_32254__$1 = tmp32323;
var inst_32255__$1 = tmp32322;
var inst_32256__$1 = inst_32264;
var state_32307__$1 = (function (){var statearr_32331 = state_32307;
(statearr_32331[(8)] = inst_32253__$1);

(statearr_32331[(10)] = inst_32255__$1);

(statearr_32331[(14)] = inst_32263);

(statearr_32331[(11)] = inst_32256__$1);

(statearr_32331[(12)] = inst_32254__$1);

return statearr_32331;
})();
var statearr_32332_34201 = state_32307__$1;
(statearr_32332_34201[(2)] = null);

(statearr_32332_34201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (22))){
var state_32307__$1 = state_32307;
var statearr_32334_34203 = state_32307__$1;
(statearr_32334_34203[(2)] = null);

(statearr_32334_34203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (6))){
var inst_32242 = (state_32307[(13)]);
var inst_32251 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32242) : f.call(null,inst_32242));
var inst_32252 = cljs.core.seq(inst_32251);
var inst_32253 = inst_32252;
var inst_32254 = null;
var inst_32255 = (0);
var inst_32256 = (0);
var state_32307__$1 = (function (){var statearr_32338 = state_32307;
(statearr_32338[(8)] = inst_32253);

(statearr_32338[(10)] = inst_32255);

(statearr_32338[(11)] = inst_32256);

(statearr_32338[(12)] = inst_32254);

return statearr_32338;
})();
var statearr_32339_34205 = state_32307__$1;
(statearr_32339_34205[(2)] = null);

(statearr_32339_34205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (17))){
var inst_32267 = (state_32307[(7)]);
var inst_32272 = cljs.core.chunk_first(inst_32267);
var inst_32273 = cljs.core.chunk_rest(inst_32267);
var inst_32274 = cljs.core.count(inst_32272);
var inst_32253 = inst_32273;
var inst_32254 = inst_32272;
var inst_32255 = inst_32274;
var inst_32256 = (0);
var state_32307__$1 = (function (){var statearr_32340 = state_32307;
(statearr_32340[(8)] = inst_32253);

(statearr_32340[(10)] = inst_32255);

(statearr_32340[(11)] = inst_32256);

(statearr_32340[(12)] = inst_32254);

return statearr_32340;
})();
var statearr_32341_34214 = state_32307__$1;
(statearr_32341_34214[(2)] = null);

(statearr_32341_34214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (3))){
var inst_32305 = (state_32307[(2)]);
var state_32307__$1 = state_32307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32307__$1,inst_32305);
} else {
if((state_val_32308 === (12))){
var inst_32292 = (state_32307[(2)]);
var state_32307__$1 = state_32307;
var statearr_32347_34221 = state_32307__$1;
(statearr_32347_34221[(2)] = inst_32292);

(statearr_32347_34221[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (2))){
var state_32307__$1 = state_32307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32307__$1,(4),in$);
} else {
if((state_val_32308 === (23))){
var inst_32301 = (state_32307[(2)]);
var state_32307__$1 = state_32307;
var statearr_32352_34228 = state_32307__$1;
(statearr_32352_34228[(2)] = inst_32301);

(statearr_32352_34228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (19))){
var inst_32287 = (state_32307[(2)]);
var state_32307__$1 = state_32307;
var statearr_32353_34229 = state_32307__$1;
(statearr_32353_34229[(2)] = inst_32287);

(statearr_32353_34229[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (11))){
var inst_32253 = (state_32307[(8)]);
var inst_32267 = (state_32307[(7)]);
var inst_32267__$1 = cljs.core.seq(inst_32253);
var state_32307__$1 = (function (){var statearr_32354 = state_32307;
(statearr_32354[(7)] = inst_32267__$1);

return statearr_32354;
})();
if(inst_32267__$1){
var statearr_32355_34236 = state_32307__$1;
(statearr_32355_34236[(1)] = (14));

} else {
var statearr_32356_34237 = state_32307__$1;
(statearr_32356_34237[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (9))){
var inst_32294 = (state_32307[(2)]);
var inst_32296 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32307__$1 = (function (){var statearr_32358 = state_32307;
(statearr_32358[(15)] = inst_32294);

return statearr_32358;
})();
if(cljs.core.truth_(inst_32296)){
var statearr_32359_34240 = state_32307__$1;
(statearr_32359_34240[(1)] = (21));

} else {
var statearr_32360_34241 = state_32307__$1;
(statearr_32360_34241[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (5))){
var inst_32245 = cljs.core.async.close_BANG_(out);
var state_32307__$1 = state_32307;
var statearr_32363_34243 = state_32307__$1;
(statearr_32363_34243[(2)] = inst_32245);

(statearr_32363_34243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (14))){
var inst_32267 = (state_32307[(7)]);
var inst_32270 = cljs.core.chunked_seq_QMARK_(inst_32267);
var state_32307__$1 = state_32307;
if(inst_32270){
var statearr_32364_34246 = state_32307__$1;
(statearr_32364_34246[(1)] = (17));

} else {
var statearr_32365_34247 = state_32307__$1;
(statearr_32365_34247[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (16))){
var inst_32290 = (state_32307[(2)]);
var state_32307__$1 = state_32307;
var statearr_32366_34250 = state_32307__$1;
(statearr_32366_34250[(2)] = inst_32290);

(statearr_32366_34250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32308 === (10))){
var inst_32256 = (state_32307[(11)]);
var inst_32254 = (state_32307[(12)]);
var inst_32261 = cljs.core._nth(inst_32254,inst_32256);
var state_32307__$1 = state_32307;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32307__$1,(13),out,inst_32261);
} else {
if((state_val_32308 === (18))){
var inst_32267 = (state_32307[(7)]);
var inst_32281 = cljs.core.first(inst_32267);
var state_32307__$1 = state_32307;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32307__$1,(20),out,inst_32281);
} else {
if((state_val_32308 === (8))){
var inst_32255 = (state_32307[(10)]);
var inst_32256 = (state_32307[(11)]);
var inst_32258 = (inst_32256 < inst_32255);
var inst_32259 = inst_32258;
var state_32307__$1 = state_32307;
if(cljs.core.truth_(inst_32259)){
var statearr_32368_34253 = state_32307__$1;
(statearr_32368_34253[(1)] = (10));

} else {
var statearr_32369_34254 = state_32307__$1;
(statearr_32369_34254[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29726__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29726__auto____0 = (function (){
var statearr_32370 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32370[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29726__auto__);

(statearr_32370[(1)] = (1));

return statearr_32370;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29726__auto____1 = (function (state_32307){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_32307);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e32371){var ex__29729__auto__ = e32371;
var statearr_32372_34255 = state_32307;
(statearr_32372_34255[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_32307[(4)]))){
var statearr_32373_34256 = state_32307;
(statearr_32373_34256[(1)] = cljs.core.first((state_32307[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34257 = state_32307;
state_32307 = G__34257;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29726__auto__ = function(state_32307){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29726__auto____1.call(this,state_32307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29726__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29726__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_32375 = f__30025__auto__();
(statearr_32375[(6)] = c__30024__auto__);

return statearr_32375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));

return c__30024__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32377 = arguments.length;
switch (G__32377) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32381 = arguments.length;
switch (G__32381) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32384 = arguments.length;
switch (G__32384) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30024__auto___34265 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_32411){
var state_val_32412 = (state_32411[(1)]);
if((state_val_32412 === (7))){
var inst_32406 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32413_34267 = state_32411__$1;
(statearr_32413_34267[(2)] = inst_32406);

(statearr_32413_34267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (1))){
var inst_32387 = null;
var state_32411__$1 = (function (){var statearr_32414 = state_32411;
(statearr_32414[(7)] = inst_32387);

return statearr_32414;
})();
var statearr_32415_34268 = state_32411__$1;
(statearr_32415_34268[(2)] = null);

(statearr_32415_34268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (4))){
var inst_32390 = (state_32411[(8)]);
var inst_32390__$1 = (state_32411[(2)]);
var inst_32392 = (inst_32390__$1 == null);
var inst_32393 = cljs.core.not(inst_32392);
var state_32411__$1 = (function (){var statearr_32417 = state_32411;
(statearr_32417[(8)] = inst_32390__$1);

return statearr_32417;
})();
if(inst_32393){
var statearr_32418_34269 = state_32411__$1;
(statearr_32418_34269[(1)] = (5));

} else {
var statearr_32419_34270 = state_32411__$1;
(statearr_32419_34270[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (6))){
var state_32411__$1 = state_32411;
var statearr_32420_34271 = state_32411__$1;
(statearr_32420_34271[(2)] = null);

(statearr_32420_34271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (3))){
var inst_32408 = (state_32411[(2)]);
var inst_32409 = cljs.core.async.close_BANG_(out);
var state_32411__$1 = (function (){var statearr_32421 = state_32411;
(statearr_32421[(9)] = inst_32408);

return statearr_32421;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32411__$1,inst_32409);
} else {
if((state_val_32412 === (2))){
var state_32411__$1 = state_32411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32411__$1,(4),ch);
} else {
if((state_val_32412 === (11))){
var inst_32390 = (state_32411[(8)]);
var inst_32400 = (state_32411[(2)]);
var inst_32387 = inst_32390;
var state_32411__$1 = (function (){var statearr_32422 = state_32411;
(statearr_32422[(10)] = inst_32400);

(statearr_32422[(7)] = inst_32387);

return statearr_32422;
})();
var statearr_32431_34277 = state_32411__$1;
(statearr_32431_34277[(2)] = null);

(statearr_32431_34277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (9))){
var inst_32390 = (state_32411[(8)]);
var state_32411__$1 = state_32411;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32411__$1,(11),out,inst_32390);
} else {
if((state_val_32412 === (5))){
var inst_32387 = (state_32411[(7)]);
var inst_32390 = (state_32411[(8)]);
var inst_32395 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32390,inst_32387);
var state_32411__$1 = state_32411;
if(inst_32395){
var statearr_32464_34279 = state_32411__$1;
(statearr_32464_34279[(1)] = (8));

} else {
var statearr_32465_34280 = state_32411__$1;
(statearr_32465_34280[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (10))){
var inst_32403 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32466_34291 = state_32411__$1;
(statearr_32466_34291[(2)] = inst_32403);

(statearr_32466_34291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (8))){
var inst_32387 = (state_32411[(7)]);
var tmp32442 = inst_32387;
var inst_32387__$1 = tmp32442;
var state_32411__$1 = (function (){var statearr_32468 = state_32411;
(statearr_32468[(7)] = inst_32387__$1);

return statearr_32468;
})();
var statearr_32474_34297 = state_32411__$1;
(statearr_32474_34297[(2)] = null);

(statearr_32474_34297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_32475 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32475[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_32475[(1)] = (1));

return statearr_32475;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_32411){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_32411);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e32476){var ex__29729__auto__ = e32476;
var statearr_32477_34318 = state_32411;
(statearr_32477_34318[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_32411[(4)]))){
var statearr_32478_34325 = state_32411;
(statearr_32478_34325[(1)] = cljs.core.first((state_32411[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34328 = state_32411;
state_32411 = G__34328;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_32411){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_32411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_32479 = f__30025__auto__();
(statearr_32479[(6)] = c__30024__auto___34265);

return statearr_32479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32483 = arguments.length;
switch (G__32483) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30024__auto___34333 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_32524){
var state_val_32525 = (state_32524[(1)]);
if((state_val_32525 === (7))){
var inst_32520 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
var statearr_32528_34347 = state_32524__$1;
(statearr_32528_34347[(2)] = inst_32520);

(statearr_32528_34347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (1))){
var inst_32487 = (new Array(n));
var inst_32488 = inst_32487;
var inst_32489 = (0);
var state_32524__$1 = (function (){var statearr_32529 = state_32524;
(statearr_32529[(7)] = inst_32488);

(statearr_32529[(8)] = inst_32489);

return statearr_32529;
})();
var statearr_32530_34369 = state_32524__$1;
(statearr_32530_34369[(2)] = null);

(statearr_32530_34369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (4))){
var inst_32492 = (state_32524[(9)]);
var inst_32492__$1 = (state_32524[(2)]);
var inst_32493 = (inst_32492__$1 == null);
var inst_32494 = cljs.core.not(inst_32493);
var state_32524__$1 = (function (){var statearr_32533 = state_32524;
(statearr_32533[(9)] = inst_32492__$1);

return statearr_32533;
})();
if(inst_32494){
var statearr_32535_34381 = state_32524__$1;
(statearr_32535_34381[(1)] = (5));

} else {
var statearr_32537_34386 = state_32524__$1;
(statearr_32537_34386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (15))){
var inst_32514 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
var statearr_32538_34391 = state_32524__$1;
(statearr_32538_34391[(2)] = inst_32514);

(statearr_32538_34391[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (13))){
var state_32524__$1 = state_32524;
var statearr_32539_34395 = state_32524__$1;
(statearr_32539_34395[(2)] = null);

(statearr_32539_34395[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (6))){
var inst_32489 = (state_32524[(8)]);
var inst_32510 = (inst_32489 > (0));
var state_32524__$1 = state_32524;
if(cljs.core.truth_(inst_32510)){
var statearr_32540_34406 = state_32524__$1;
(statearr_32540_34406[(1)] = (12));

} else {
var statearr_32544_34407 = state_32524__$1;
(statearr_32544_34407[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (3))){
var inst_32522 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32524__$1,inst_32522);
} else {
if((state_val_32525 === (12))){
var inst_32488 = (state_32524[(7)]);
var inst_32512 = cljs.core.vec(inst_32488);
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32524__$1,(15),out,inst_32512);
} else {
if((state_val_32525 === (2))){
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32524__$1,(4),ch);
} else {
if((state_val_32525 === (11))){
var inst_32504 = (state_32524[(2)]);
var inst_32505 = (new Array(n));
var inst_32488 = inst_32505;
var inst_32489 = (0);
var state_32524__$1 = (function (){var statearr_32547 = state_32524;
(statearr_32547[(7)] = inst_32488);

(statearr_32547[(10)] = inst_32504);

(statearr_32547[(8)] = inst_32489);

return statearr_32547;
})();
var statearr_32548_34429 = state_32524__$1;
(statearr_32548_34429[(2)] = null);

(statearr_32548_34429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (9))){
var inst_32488 = (state_32524[(7)]);
var inst_32502 = cljs.core.vec(inst_32488);
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32524__$1,(11),out,inst_32502);
} else {
if((state_val_32525 === (5))){
var inst_32488 = (state_32524[(7)]);
var inst_32492 = (state_32524[(9)]);
var inst_32489 = (state_32524[(8)]);
var inst_32497 = (state_32524[(11)]);
var inst_32496 = (inst_32488[inst_32489] = inst_32492);
var inst_32497__$1 = (inst_32489 + (1));
var inst_32498 = (inst_32497__$1 < n);
var state_32524__$1 = (function (){var statearr_32552 = state_32524;
(statearr_32552[(12)] = inst_32496);

(statearr_32552[(11)] = inst_32497__$1);

return statearr_32552;
})();
if(cljs.core.truth_(inst_32498)){
var statearr_32553_34440 = state_32524__$1;
(statearr_32553_34440[(1)] = (8));

} else {
var statearr_32554_34441 = state_32524__$1;
(statearr_32554_34441[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (14))){
var inst_32517 = (state_32524[(2)]);
var inst_32518 = cljs.core.async.close_BANG_(out);
var state_32524__$1 = (function (){var statearr_32556 = state_32524;
(statearr_32556[(13)] = inst_32517);

return statearr_32556;
})();
var statearr_32557_34442 = state_32524__$1;
(statearr_32557_34442[(2)] = inst_32518);

(statearr_32557_34442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (10))){
var inst_32508 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
var statearr_32558_34443 = state_32524__$1;
(statearr_32558_34443[(2)] = inst_32508);

(statearr_32558_34443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (8))){
var inst_32488 = (state_32524[(7)]);
var inst_32497 = (state_32524[(11)]);
var tmp32555 = inst_32488;
var inst_32488__$1 = tmp32555;
var inst_32489 = inst_32497;
var state_32524__$1 = (function (){var statearr_32564 = state_32524;
(statearr_32564[(7)] = inst_32488__$1);

(statearr_32564[(8)] = inst_32489);

return statearr_32564;
})();
var statearr_32565_34449 = state_32524__$1;
(statearr_32565_34449[(2)] = null);

(statearr_32565_34449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_32566 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32566[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_32566[(1)] = (1));

return statearr_32566;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_32524){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_32524);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e32567){var ex__29729__auto__ = e32567;
var statearr_32568_34460 = state_32524;
(statearr_32568_34460[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_32524[(4)]))){
var statearr_32569_34462 = state_32524;
(statearr_32569_34462[(1)] = cljs.core.first((state_32524[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34465 = state_32524;
state_32524 = G__34465;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_32524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_32524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_32572 = f__30025__auto__();
(statearr_32572[(6)] = c__30024__auto___34333);

return statearr_32572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32578 = arguments.length;
switch (G__32578) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30024__auto___34470 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30025__auto__ = (function (){var switch__29725__auto__ = (function (state_32633){
var state_val_32634 = (state_32633[(1)]);
if((state_val_32634 === (7))){
var inst_32629 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32635_34471 = state_32633__$1;
(statearr_32635_34471[(2)] = inst_32629);

(statearr_32635_34471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (1))){
var inst_32584 = [];
var inst_32585 = inst_32584;
var inst_32586 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32633__$1 = (function (){var statearr_32637 = state_32633;
(statearr_32637[(7)] = inst_32586);

(statearr_32637[(8)] = inst_32585);

return statearr_32637;
})();
var statearr_32638_34473 = state_32633__$1;
(statearr_32638_34473[(2)] = null);

(statearr_32638_34473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (4))){
var inst_32589 = (state_32633[(9)]);
var inst_32589__$1 = (state_32633[(2)]);
var inst_32590 = (inst_32589__$1 == null);
var inst_32591 = cljs.core.not(inst_32590);
var state_32633__$1 = (function (){var statearr_32641 = state_32633;
(statearr_32641[(9)] = inst_32589__$1);

return statearr_32641;
})();
if(inst_32591){
var statearr_32644_34474 = state_32633__$1;
(statearr_32644_34474[(1)] = (5));

} else {
var statearr_32645_34475 = state_32633__$1;
(statearr_32645_34475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (15))){
var inst_32585 = (state_32633[(8)]);
var inst_32621 = cljs.core.vec(inst_32585);
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32633__$1,(18),out,inst_32621);
} else {
if((state_val_32634 === (13))){
var inst_32615 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32647_34476 = state_32633__$1;
(statearr_32647_34476[(2)] = inst_32615);

(statearr_32647_34476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (6))){
var inst_32585 = (state_32633[(8)]);
var inst_32618 = inst_32585.length;
var inst_32619 = (inst_32618 > (0));
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32619)){
var statearr_32648_34477 = state_32633__$1;
(statearr_32648_34477[(1)] = (15));

} else {
var statearr_32649_34478 = state_32633__$1;
(statearr_32649_34478[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (17))){
var inst_32626 = (state_32633[(2)]);
var inst_32627 = cljs.core.async.close_BANG_(out);
var state_32633__$1 = (function (){var statearr_32650 = state_32633;
(statearr_32650[(10)] = inst_32626);

return statearr_32650;
})();
var statearr_32651_34480 = state_32633__$1;
(statearr_32651_34480[(2)] = inst_32627);

(statearr_32651_34480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (3))){
var inst_32631 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32633__$1,inst_32631);
} else {
if((state_val_32634 === (12))){
var inst_32585 = (state_32633[(8)]);
var inst_32606 = cljs.core.vec(inst_32585);
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32633__$1,(14),out,inst_32606);
} else {
if((state_val_32634 === (2))){
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32633__$1,(4),ch);
} else {
if((state_val_32634 === (11))){
var inst_32594 = (state_32633[(11)]);
var inst_32585 = (state_32633[(8)]);
var inst_32589 = (state_32633[(9)]);
var inst_32603 = inst_32585.push(inst_32589);
var tmp32652 = inst_32585;
var inst_32585__$1 = tmp32652;
var inst_32586 = inst_32594;
var state_32633__$1 = (function (){var statearr_32654 = state_32633;
(statearr_32654[(7)] = inst_32586);

(statearr_32654[(12)] = inst_32603);

(statearr_32654[(8)] = inst_32585__$1);

return statearr_32654;
})();
var statearr_32656_34482 = state_32633__$1;
(statearr_32656_34482[(2)] = null);

(statearr_32656_34482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (9))){
var inst_32586 = (state_32633[(7)]);
var inst_32599 = cljs.core.keyword_identical_QMARK_(inst_32586,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_32633__$1 = state_32633;
var statearr_32660_34483 = state_32633__$1;
(statearr_32660_34483[(2)] = inst_32599);

(statearr_32660_34483[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (5))){
var inst_32586 = (state_32633[(7)]);
var inst_32596 = (state_32633[(13)]);
var inst_32594 = (state_32633[(11)]);
var inst_32589 = (state_32633[(9)]);
var inst_32594__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32589) : f.call(null,inst_32589));
var inst_32596__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32594__$1,inst_32586);
var state_32633__$1 = (function (){var statearr_32667 = state_32633;
(statearr_32667[(13)] = inst_32596__$1);

(statearr_32667[(11)] = inst_32594__$1);

return statearr_32667;
})();
if(inst_32596__$1){
var statearr_32668_34487 = state_32633__$1;
(statearr_32668_34487[(1)] = (8));

} else {
var statearr_32669_34488 = state_32633__$1;
(statearr_32669_34488[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (14))){
var inst_32594 = (state_32633[(11)]);
var inst_32589 = (state_32633[(9)]);
var inst_32608 = (state_32633[(2)]);
var inst_32611 = [];
var inst_32612 = inst_32611.push(inst_32589);
var inst_32585 = inst_32611;
var inst_32586 = inst_32594;
var state_32633__$1 = (function (){var statearr_32670 = state_32633;
(statearr_32670[(14)] = inst_32608);

(statearr_32670[(7)] = inst_32586);

(statearr_32670[(8)] = inst_32585);

(statearr_32670[(15)] = inst_32612);

return statearr_32670;
})();
var statearr_32675_34489 = state_32633__$1;
(statearr_32675_34489[(2)] = null);

(statearr_32675_34489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (16))){
var state_32633__$1 = state_32633;
var statearr_32677_34490 = state_32633__$1;
(statearr_32677_34490[(2)] = null);

(statearr_32677_34490[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (10))){
var inst_32601 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32601)){
var statearr_32679_34491 = state_32633__$1;
(statearr_32679_34491[(1)] = (11));

} else {
var statearr_32681_34492 = state_32633__$1;
(statearr_32681_34492[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (18))){
var inst_32623 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32682_34493 = state_32633__$1;
(statearr_32682_34493[(2)] = inst_32623);

(statearr_32682_34493[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32634 === (8))){
var inst_32596 = (state_32633[(13)]);
var state_32633__$1 = state_32633;
var statearr_32685_34494 = state_32633__$1;
(statearr_32685_34494[(2)] = inst_32596);

(statearr_32685_34494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29726__auto__ = null;
var cljs$core$async$state_machine__29726__auto____0 = (function (){
var statearr_32686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32686[(0)] = cljs$core$async$state_machine__29726__auto__);

(statearr_32686[(1)] = (1));

return statearr_32686;
});
var cljs$core$async$state_machine__29726__auto____1 = (function (state_32633){
while(true){
var ret_value__29727__auto__ = (function (){try{while(true){
var result__29728__auto__ = switch__29725__auto__(state_32633);
if(cljs.core.keyword_identical_QMARK_(result__29728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29728__auto__;
}
break;
}
}catch (e32688){var ex__29729__auto__ = e32688;
var statearr_32689_34505 = state_32633;
(statearr_32689_34505[(2)] = ex__29729__auto__);


if(cljs.core.seq((state_32633[(4)]))){
var statearr_32690_34506 = state_32633;
(statearr_32690_34506[(1)] = cljs.core.first((state_32633[(4)])));

} else {
throw ex__29729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34510 = state_32633;
state_32633 = G__34510;
continue;
} else {
return ret_value__29727__auto__;
}
break;
}
});
cljs$core$async$state_machine__29726__auto__ = function(state_32633){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29726__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29726__auto____1.call(this,state_32633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29726__auto____0;
cljs$core$async$state_machine__29726__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29726__auto____1;
return cljs$core$async$state_machine__29726__auto__;
})()
})();
var state__30026__auto__ = (function (){var statearr_32694 = f__30025__auto__();
(statearr_32694[(6)] = c__30024__auto___34470);

return statearr_32694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30026__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
