goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49947 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49947(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49948 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49948(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__48759 = coll;
var G__48760 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__48759,G__48760) : shadow.dom.lazy_native_coll_seq.call(null,G__48759,G__48760));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__48800 = arguments.length;
switch (G__48800) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__48812 = arguments.length;
switch (G__48812) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__48828 = arguments.length;
switch (G__48828) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__48843 = arguments.length;
switch (G__48843) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__48874 = arguments.length;
switch (G__48874) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__48890 = arguments.length;
switch (G__48890) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e48910){if((e48910 instanceof Object)){
var e = e48910;
return console.log("didnt support attachEvent",el,e);
} else {
throw e48910;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__48920 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__48921 = null;
var count__48922 = (0);
var i__48923 = (0);
while(true){
if((i__48923 < count__48922)){
var el = chunk__48921.cljs$core$IIndexed$_nth$arity$2(null,i__48923);
var handler_49963__$1 = ((function (seq__48920,chunk__48921,count__48922,i__48923,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48920,chunk__48921,count__48922,i__48923,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49963__$1);


var G__49964 = seq__48920;
var G__49965 = chunk__48921;
var G__49966 = count__48922;
var G__49967 = (i__48923 + (1));
seq__48920 = G__49964;
chunk__48921 = G__49965;
count__48922 = G__49966;
i__48923 = G__49967;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48920);
if(temp__5753__auto__){
var seq__48920__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48920__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__48920__$1);
var G__49968 = cljs.core.chunk_rest(seq__48920__$1);
var G__49969 = c__4679__auto__;
var G__49970 = cljs.core.count(c__4679__auto__);
var G__49971 = (0);
seq__48920 = G__49968;
chunk__48921 = G__49969;
count__48922 = G__49970;
i__48923 = G__49971;
continue;
} else {
var el = cljs.core.first(seq__48920__$1);
var handler_49972__$1 = ((function (seq__48920,chunk__48921,count__48922,i__48923,el,seq__48920__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48920,chunk__48921,count__48922,i__48923,el,seq__48920__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49972__$1);


var G__49973 = cljs.core.next(seq__48920__$1);
var G__49974 = null;
var G__49975 = (0);
var G__49976 = (0);
seq__48920 = G__49973;
chunk__48921 = G__49974;
count__48922 = G__49975;
i__48923 = G__49976;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__48948 = arguments.length;
switch (G__48948) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__48965 = cljs.core.seq(events);
var chunk__48966 = null;
var count__48967 = (0);
var i__48968 = (0);
while(true){
if((i__48968 < count__48967)){
var vec__48991 = chunk__48966.cljs$core$IIndexed$_nth$arity$2(null,i__48968);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48991,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48991,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49980 = seq__48965;
var G__49981 = chunk__48966;
var G__49982 = count__48967;
var G__49983 = (i__48968 + (1));
seq__48965 = G__49980;
chunk__48966 = G__49981;
count__48967 = G__49982;
i__48968 = G__49983;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48965);
if(temp__5753__auto__){
var seq__48965__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48965__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__48965__$1);
var G__49984 = cljs.core.chunk_rest(seq__48965__$1);
var G__49985 = c__4679__auto__;
var G__49986 = cljs.core.count(c__4679__auto__);
var G__49987 = (0);
seq__48965 = G__49984;
chunk__48966 = G__49985;
count__48967 = G__49986;
i__48968 = G__49987;
continue;
} else {
var vec__48997 = cljs.core.first(seq__48965__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48997,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48997,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49989 = cljs.core.next(seq__48965__$1);
var G__49990 = null;
var G__49991 = (0);
var G__49992 = (0);
seq__48965 = G__49989;
chunk__48966 = G__49990;
count__48967 = G__49991;
i__48968 = G__49992;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__49004 = cljs.core.seq(styles);
var chunk__49005 = null;
var count__49006 = (0);
var i__49007 = (0);
while(true){
if((i__49007 < count__49006)){
var vec__49017 = chunk__49005.cljs$core$IIndexed$_nth$arity$2(null,i__49007);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49017,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49017,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49994 = seq__49004;
var G__49995 = chunk__49005;
var G__49996 = count__49006;
var G__49997 = (i__49007 + (1));
seq__49004 = G__49994;
chunk__49005 = G__49995;
count__49006 = G__49996;
i__49007 = G__49997;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__49004);
if(temp__5753__auto__){
var seq__49004__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49004__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__49004__$1);
var G__50000 = cljs.core.chunk_rest(seq__49004__$1);
var G__50001 = c__4679__auto__;
var G__50002 = cljs.core.count(c__4679__auto__);
var G__50003 = (0);
seq__49004 = G__50000;
chunk__49005 = G__50001;
count__49006 = G__50002;
i__49007 = G__50003;
continue;
} else {
var vec__49020 = cljs.core.first(seq__49004__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49020,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49020,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50005 = cljs.core.next(seq__49004__$1);
var G__50006 = null;
var G__50007 = (0);
var G__50008 = (0);
seq__49004 = G__50005;
chunk__49005 = G__50006;
count__49006 = G__50007;
i__49007 = G__50008;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__49027_50010 = key;
var G__49027_50011__$1 = (((G__49027_50010 instanceof cljs.core.Keyword))?G__49027_50010.fqn:null);
switch (G__49027_50011__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_50013 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_50013,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_50013,"aria-");
}
})())){
el.setAttribute(ks_50013,value);
} else {
(el[ks_50013] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__49061){
var map__49063 = p__49061;
var map__49063__$1 = cljs.core.__destructure_map(map__49063);
var props = map__49063__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49063__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__49066 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49066,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49066,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49066,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__49071 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__49071,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__49071;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__49078 = arguments.length;
switch (G__49078) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__49088){
var vec__49091 = p__49088;
var seq__49092 = cljs.core.seq(vec__49091);
var first__49093 = cljs.core.first(seq__49092);
var seq__49092__$1 = cljs.core.next(seq__49092);
var nn = first__49093;
var first__49093__$1 = cljs.core.first(seq__49092__$1);
var seq__49092__$2 = cljs.core.next(seq__49092__$1);
var np = first__49093__$1;
var nc = seq__49092__$2;
var node = vec__49091;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49095 = nn;
var G__49096 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49095,G__49096) : create_fn.call(null,G__49095,G__49096));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49099 = nn;
var G__49100 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49099,G__49100) : create_fn.call(null,G__49099,G__49100));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__49107 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49107,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49107,(1),null);
var seq__49110_50027 = cljs.core.seq(node_children);
var chunk__49111_50028 = null;
var count__49112_50029 = (0);
var i__49113_50030 = (0);
while(true){
if((i__49113_50030 < count__49112_50029)){
var child_struct_50034 = chunk__49111_50028.cljs$core$IIndexed$_nth$arity$2(null,i__49113_50030);
var children_50035 = shadow.dom.dom_node(child_struct_50034);
if(cljs.core.seq_QMARK_(children_50035)){
var seq__49147_50036 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50035));
var chunk__49149_50037 = null;
var count__49150_50038 = (0);
var i__49151_50039 = (0);
while(true){
if((i__49151_50039 < count__49150_50038)){
var child_50040 = chunk__49149_50037.cljs$core$IIndexed$_nth$arity$2(null,i__49151_50039);
if(cljs.core.truth_(child_50040)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50040);


var G__50041 = seq__49147_50036;
var G__50042 = chunk__49149_50037;
var G__50043 = count__49150_50038;
var G__50044 = (i__49151_50039 + (1));
seq__49147_50036 = G__50041;
chunk__49149_50037 = G__50042;
count__49150_50038 = G__50043;
i__49151_50039 = G__50044;
continue;
} else {
var G__50045 = seq__49147_50036;
var G__50046 = chunk__49149_50037;
var G__50047 = count__49150_50038;
var G__50048 = (i__49151_50039 + (1));
seq__49147_50036 = G__50045;
chunk__49149_50037 = G__50046;
count__49150_50038 = G__50047;
i__49151_50039 = G__50048;
continue;
}
} else {
var temp__5753__auto___50049 = cljs.core.seq(seq__49147_50036);
if(temp__5753__auto___50049){
var seq__49147_50050__$1 = temp__5753__auto___50049;
if(cljs.core.chunked_seq_QMARK_(seq__49147_50050__$1)){
var c__4679__auto___50051 = cljs.core.chunk_first(seq__49147_50050__$1);
var G__50052 = cljs.core.chunk_rest(seq__49147_50050__$1);
var G__50053 = c__4679__auto___50051;
var G__50054 = cljs.core.count(c__4679__auto___50051);
var G__50055 = (0);
seq__49147_50036 = G__50052;
chunk__49149_50037 = G__50053;
count__49150_50038 = G__50054;
i__49151_50039 = G__50055;
continue;
} else {
var child_50057 = cljs.core.first(seq__49147_50050__$1);
if(cljs.core.truth_(child_50057)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50057);


var G__50058 = cljs.core.next(seq__49147_50050__$1);
var G__50059 = null;
var G__50060 = (0);
var G__50061 = (0);
seq__49147_50036 = G__50058;
chunk__49149_50037 = G__50059;
count__49150_50038 = G__50060;
i__49151_50039 = G__50061;
continue;
} else {
var G__50062 = cljs.core.next(seq__49147_50050__$1);
var G__50063 = null;
var G__50064 = (0);
var G__50065 = (0);
seq__49147_50036 = G__50062;
chunk__49149_50037 = G__50063;
count__49150_50038 = G__50064;
i__49151_50039 = G__50065;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50035);
}


var G__50066 = seq__49110_50027;
var G__50067 = chunk__49111_50028;
var G__50068 = count__49112_50029;
var G__50069 = (i__49113_50030 + (1));
seq__49110_50027 = G__50066;
chunk__49111_50028 = G__50067;
count__49112_50029 = G__50068;
i__49113_50030 = G__50069;
continue;
} else {
var temp__5753__auto___50070 = cljs.core.seq(seq__49110_50027);
if(temp__5753__auto___50070){
var seq__49110_50074__$1 = temp__5753__auto___50070;
if(cljs.core.chunked_seq_QMARK_(seq__49110_50074__$1)){
var c__4679__auto___50075 = cljs.core.chunk_first(seq__49110_50074__$1);
var G__50076 = cljs.core.chunk_rest(seq__49110_50074__$1);
var G__50077 = c__4679__auto___50075;
var G__50078 = cljs.core.count(c__4679__auto___50075);
var G__50079 = (0);
seq__49110_50027 = G__50076;
chunk__49111_50028 = G__50077;
count__49112_50029 = G__50078;
i__49113_50030 = G__50079;
continue;
} else {
var child_struct_50080 = cljs.core.first(seq__49110_50074__$1);
var children_50081 = shadow.dom.dom_node(child_struct_50080);
if(cljs.core.seq_QMARK_(children_50081)){
var seq__49158_50082 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50081));
var chunk__49160_50083 = null;
var count__49161_50084 = (0);
var i__49162_50085 = (0);
while(true){
if((i__49162_50085 < count__49161_50084)){
var child_50086 = chunk__49160_50083.cljs$core$IIndexed$_nth$arity$2(null,i__49162_50085);
if(cljs.core.truth_(child_50086)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50086);


var G__50087 = seq__49158_50082;
var G__50088 = chunk__49160_50083;
var G__50089 = count__49161_50084;
var G__50090 = (i__49162_50085 + (1));
seq__49158_50082 = G__50087;
chunk__49160_50083 = G__50088;
count__49161_50084 = G__50089;
i__49162_50085 = G__50090;
continue;
} else {
var G__50091 = seq__49158_50082;
var G__50092 = chunk__49160_50083;
var G__50093 = count__49161_50084;
var G__50094 = (i__49162_50085 + (1));
seq__49158_50082 = G__50091;
chunk__49160_50083 = G__50092;
count__49161_50084 = G__50093;
i__49162_50085 = G__50094;
continue;
}
} else {
var temp__5753__auto___50095__$1 = cljs.core.seq(seq__49158_50082);
if(temp__5753__auto___50095__$1){
var seq__49158_50096__$1 = temp__5753__auto___50095__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49158_50096__$1)){
var c__4679__auto___50098 = cljs.core.chunk_first(seq__49158_50096__$1);
var G__50099 = cljs.core.chunk_rest(seq__49158_50096__$1);
var G__50100 = c__4679__auto___50098;
var G__50101 = cljs.core.count(c__4679__auto___50098);
var G__50102 = (0);
seq__49158_50082 = G__50099;
chunk__49160_50083 = G__50100;
count__49161_50084 = G__50101;
i__49162_50085 = G__50102;
continue;
} else {
var child_50103 = cljs.core.first(seq__49158_50096__$1);
if(cljs.core.truth_(child_50103)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50103);


var G__50104 = cljs.core.next(seq__49158_50096__$1);
var G__50105 = null;
var G__50106 = (0);
var G__50107 = (0);
seq__49158_50082 = G__50104;
chunk__49160_50083 = G__50105;
count__49161_50084 = G__50106;
i__49162_50085 = G__50107;
continue;
} else {
var G__50108 = cljs.core.next(seq__49158_50096__$1);
var G__50109 = null;
var G__50110 = (0);
var G__50111 = (0);
seq__49158_50082 = G__50108;
chunk__49160_50083 = G__50109;
count__49161_50084 = G__50110;
i__49162_50085 = G__50111;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50081);
}


var G__50112 = cljs.core.next(seq__49110_50074__$1);
var G__50113 = null;
var G__50114 = (0);
var G__50115 = (0);
seq__49110_50027 = G__50112;
chunk__49111_50028 = G__50113;
count__49112_50029 = G__50114;
i__49113_50030 = G__50115;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__49203 = cljs.core.seq(node);
var chunk__49204 = null;
var count__49205 = (0);
var i__49206 = (0);
while(true){
if((i__49206 < count__49205)){
var n = chunk__49204.cljs$core$IIndexed$_nth$arity$2(null,i__49206);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50123 = seq__49203;
var G__50124 = chunk__49204;
var G__50125 = count__49205;
var G__50126 = (i__49206 + (1));
seq__49203 = G__50123;
chunk__49204 = G__50124;
count__49205 = G__50125;
i__49206 = G__50126;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__49203);
if(temp__5753__auto__){
var seq__49203__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49203__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__49203__$1);
var G__50128 = cljs.core.chunk_rest(seq__49203__$1);
var G__50129 = c__4679__auto__;
var G__50130 = cljs.core.count(c__4679__auto__);
var G__50131 = (0);
seq__49203 = G__50128;
chunk__49204 = G__50129;
count__49205 = G__50130;
i__49206 = G__50131;
continue;
} else {
var n = cljs.core.first(seq__49203__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50132 = cljs.core.next(seq__49203__$1);
var G__50133 = null;
var G__50134 = (0);
var G__50135 = (0);
seq__49203 = G__50132;
chunk__49204 = G__50133;
count__49205 = G__50134;
i__49206 = G__50135;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49216 = arguments.length;
switch (G__49216) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49220 = arguments.length;
switch (G__49220) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49239 = arguments.length;
switch (G__49239) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___50143 = arguments.length;
var i__4865__auto___50144 = (0);
while(true){
if((i__4865__auto___50144 < len__4864__auto___50143)){
args__4870__auto__.push((arguments[i__4865__auto___50144]));

var G__50146 = (i__4865__auto___50144 + (1));
i__4865__auto___50144 = G__50146;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49260_50148 = cljs.core.seq(nodes);
var chunk__49261_50149 = null;
var count__49262_50150 = (0);
var i__49263_50151 = (0);
while(true){
if((i__49263_50151 < count__49262_50150)){
var node_50152 = chunk__49261_50149.cljs$core$IIndexed$_nth$arity$2(null,i__49263_50151);
fragment.appendChild(shadow.dom._to_dom(node_50152));


var G__50153 = seq__49260_50148;
var G__50154 = chunk__49261_50149;
var G__50155 = count__49262_50150;
var G__50156 = (i__49263_50151 + (1));
seq__49260_50148 = G__50153;
chunk__49261_50149 = G__50154;
count__49262_50150 = G__50155;
i__49263_50151 = G__50156;
continue;
} else {
var temp__5753__auto___50157 = cljs.core.seq(seq__49260_50148);
if(temp__5753__auto___50157){
var seq__49260_50159__$1 = temp__5753__auto___50157;
if(cljs.core.chunked_seq_QMARK_(seq__49260_50159__$1)){
var c__4679__auto___50160 = cljs.core.chunk_first(seq__49260_50159__$1);
var G__50166 = cljs.core.chunk_rest(seq__49260_50159__$1);
var G__50167 = c__4679__auto___50160;
var G__50168 = cljs.core.count(c__4679__auto___50160);
var G__50169 = (0);
seq__49260_50148 = G__50166;
chunk__49261_50149 = G__50167;
count__49262_50150 = G__50168;
i__49263_50151 = G__50169;
continue;
} else {
var node_50170 = cljs.core.first(seq__49260_50159__$1);
fragment.appendChild(shadow.dom._to_dom(node_50170));


var G__50171 = cljs.core.next(seq__49260_50159__$1);
var G__50172 = null;
var G__50173 = (0);
var G__50174 = (0);
seq__49260_50148 = G__50171;
chunk__49261_50149 = G__50172;
count__49262_50150 = G__50173;
i__49263_50151 = G__50174;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49257){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49257));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49280_50177 = cljs.core.seq(scripts);
var chunk__49281_50178 = null;
var count__49282_50179 = (0);
var i__49283_50180 = (0);
while(true){
if((i__49283_50180 < count__49282_50179)){
var vec__49300_50181 = chunk__49281_50178.cljs$core$IIndexed$_nth$arity$2(null,i__49283_50180);
var script_tag_50182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49300_50181,(0),null);
var script_body_50183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49300_50181,(1),null);
eval(script_body_50183);


var G__50184 = seq__49280_50177;
var G__50186 = chunk__49281_50178;
var G__50187 = count__49282_50179;
var G__50188 = (i__49283_50180 + (1));
seq__49280_50177 = G__50184;
chunk__49281_50178 = G__50186;
count__49282_50179 = G__50187;
i__49283_50180 = G__50188;
continue;
} else {
var temp__5753__auto___50189 = cljs.core.seq(seq__49280_50177);
if(temp__5753__auto___50189){
var seq__49280_50191__$1 = temp__5753__auto___50189;
if(cljs.core.chunked_seq_QMARK_(seq__49280_50191__$1)){
var c__4679__auto___50192 = cljs.core.chunk_first(seq__49280_50191__$1);
var G__50193 = cljs.core.chunk_rest(seq__49280_50191__$1);
var G__50194 = c__4679__auto___50192;
var G__50195 = cljs.core.count(c__4679__auto___50192);
var G__50196 = (0);
seq__49280_50177 = G__50193;
chunk__49281_50178 = G__50194;
count__49282_50179 = G__50195;
i__49283_50180 = G__50196;
continue;
} else {
var vec__49306_50198 = cljs.core.first(seq__49280_50191__$1);
var script_tag_50199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49306_50198,(0),null);
var script_body_50200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49306_50198,(1),null);
eval(script_body_50200);


var G__50201 = cljs.core.next(seq__49280_50191__$1);
var G__50202 = null;
var G__50203 = (0);
var G__50204 = (0);
seq__49280_50177 = G__50201;
chunk__49281_50178 = G__50202;
count__49282_50179 = G__50203;
i__49283_50180 = G__50204;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49311){
var vec__49312 = p__49311;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49312,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49312,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49326 = arguments.length;
switch (G__49326) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49355 = cljs.core.seq(style_keys);
var chunk__49356 = null;
var count__49357 = (0);
var i__49358 = (0);
while(true){
if((i__49358 < count__49357)){
var it = chunk__49356.cljs$core$IIndexed$_nth$arity$2(null,i__49358);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50209 = seq__49355;
var G__50210 = chunk__49356;
var G__50211 = count__49357;
var G__50212 = (i__49358 + (1));
seq__49355 = G__50209;
chunk__49356 = G__50210;
count__49357 = G__50211;
i__49358 = G__50212;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__49355);
if(temp__5753__auto__){
var seq__49355__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49355__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__49355__$1);
var G__50213 = cljs.core.chunk_rest(seq__49355__$1);
var G__50214 = c__4679__auto__;
var G__50215 = cljs.core.count(c__4679__auto__);
var G__50216 = (0);
seq__49355 = G__50213;
chunk__49356 = G__50214;
count__49357 = G__50215;
i__49358 = G__50216;
continue;
} else {
var it = cljs.core.first(seq__49355__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50217 = cljs.core.next(seq__49355__$1);
var G__50218 = null;
var G__50219 = (0);
var G__50220 = (0);
seq__49355 = G__50217;
chunk__49356 = G__50218;
count__49357 = G__50219;
i__49358 = G__50220;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k49375,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__49385 = k49375;
var G__49385__$1 = (((G__49385 instanceof cljs.core.Keyword))?G__49385.fqn:null);
switch (G__49385__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49375,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__49391){
var vec__49392 = p__49391;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49392,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49392,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49374){
var self__ = this;
var G__49374__$1 = this;
return (new cljs.core.RecordIter((0),G__49374__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49376,other49377){
var self__ = this;
var this49376__$1 = this;
return (((!((other49377 == null)))) && ((((this49376__$1.constructor === other49377.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49376__$1.x,other49377.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49376__$1.y,other49377.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49376__$1.__extmap,other49377.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k49375){
var self__ = this;
var this__4509__auto____$1 = this;
var G__49435 = k49375;
var G__49435__$1 = (((G__49435 instanceof cljs.core.Keyword))?G__49435.fqn:null);
switch (G__49435__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49375);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__49374){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__49446 = cljs.core.keyword_identical_QMARK_;
var expr__49447 = k__4511__auto__;
if(cljs.core.truth_((pred__49446.cljs$core$IFn$_invoke$arity$2 ? pred__49446.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49447) : pred__49446.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__49447)))){
return (new shadow.dom.Coordinate(G__49374,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49446.cljs$core$IFn$_invoke$arity$2 ? pred__49446.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49447) : pred__49446.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__49447)))){
return (new shadow.dom.Coordinate(self__.x,G__49374,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__49374),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__49374){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49374,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49378){
var extmap__4542__auto__ = (function (){var G__49511 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49378,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49378)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49511);
} else {
return G__49511;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49378),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49378),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k49557,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__49573 = k49557;
var G__49573__$1 = (((G__49573 instanceof cljs.core.Keyword))?G__49573.fqn:null);
switch (G__49573__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49557,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__49581){
var vec__49582 = p__49581;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49582,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49582,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49556){
var self__ = this;
var G__49556__$1 = this;
return (new cljs.core.RecordIter((0),G__49556__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49558,other49559){
var self__ = this;
var this49558__$1 = this;
return (((!((other49559 == null)))) && ((((this49558__$1.constructor === other49559.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49558__$1.w,other49559.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49558__$1.h,other49559.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49558__$1.__extmap,other49559.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k49557){
var self__ = this;
var this__4509__auto____$1 = this;
var G__49626 = k49557;
var G__49626__$1 = (((G__49626 instanceof cljs.core.Keyword))?G__49626.fqn:null);
switch (G__49626__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49557);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__49556){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__49628 = cljs.core.keyword_identical_QMARK_;
var expr__49629 = k__4511__auto__;
if(cljs.core.truth_((pred__49628.cljs$core$IFn$_invoke$arity$2 ? pred__49628.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__49629) : pred__49628.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__49629)))){
return (new shadow.dom.Size(G__49556,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49628.cljs$core$IFn$_invoke$arity$2 ? pred__49628.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__49629) : pred__49628.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__49629)))){
return (new shadow.dom.Size(self__.w,G__49556,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__49556),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__49556){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49556,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49563){
var extmap__4542__auto__ = (function (){var G__49680 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49563,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49563)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49680);
} else {
return G__49680;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49563),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49563),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__50302 = (i + (1));
var G__50303 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50302;
ret = G__50303;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49779){
var vec__49780 = p__49779;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49780,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49780,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49793 = arguments.length;
switch (G__49793) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50311 = ps;
var G__50312 = (i + (1));
el__$1 = G__50311;
i = G__50312;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49808 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49808,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49808,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49808,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49814_50317 = cljs.core.seq(props);
var chunk__49815_50318 = null;
var count__49816_50319 = (0);
var i__49817_50320 = (0);
while(true){
if((i__49817_50320 < count__49816_50319)){
var vec__49831_50321 = chunk__49815_50318.cljs$core$IIndexed$_nth$arity$2(null,i__49817_50320);
var k_50322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49831_50321,(0),null);
var v_50323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49831_50321,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_50322);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50322),v_50323);


var G__50324 = seq__49814_50317;
var G__50325 = chunk__49815_50318;
var G__50326 = count__49816_50319;
var G__50327 = (i__49817_50320 + (1));
seq__49814_50317 = G__50324;
chunk__49815_50318 = G__50325;
count__49816_50319 = G__50326;
i__49817_50320 = G__50327;
continue;
} else {
var temp__5753__auto___50332 = cljs.core.seq(seq__49814_50317);
if(temp__5753__auto___50332){
var seq__49814_50333__$1 = temp__5753__auto___50332;
if(cljs.core.chunked_seq_QMARK_(seq__49814_50333__$1)){
var c__4679__auto___50334 = cljs.core.chunk_first(seq__49814_50333__$1);
var G__50335 = cljs.core.chunk_rest(seq__49814_50333__$1);
var G__50336 = c__4679__auto___50334;
var G__50337 = cljs.core.count(c__4679__auto___50334);
var G__50338 = (0);
seq__49814_50317 = G__50335;
chunk__49815_50318 = G__50336;
count__49816_50319 = G__50337;
i__49817_50320 = G__50338;
continue;
} else {
var vec__49834_50343 = cljs.core.first(seq__49814_50333__$1);
var k_50344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49834_50343,(0),null);
var v_50345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49834_50343,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_50344);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50344),v_50345);


var G__50350 = cljs.core.next(seq__49814_50333__$1);
var G__50351 = null;
var G__50352 = (0);
var G__50353 = (0);
seq__49814_50317 = G__50350;
chunk__49815_50318 = G__50351;
count__49816_50319 = G__50352;
i__49817_50320 = G__50353;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49838 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49838,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49838,(1),null);
var seq__49843_50354 = cljs.core.seq(node_children);
var chunk__49845_50355 = null;
var count__49846_50356 = (0);
var i__49847_50357 = (0);
while(true){
if((i__49847_50357 < count__49846_50356)){
var child_struct_50358 = chunk__49845_50355.cljs$core$IIndexed$_nth$arity$2(null,i__49847_50357);
if((!((child_struct_50358 == null)))){
if(typeof child_struct_50358 === 'string'){
var text_50359 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50359),child_struct_50358].join(''));
} else {
var children_50361 = shadow.dom.svg_node(child_struct_50358);
if(cljs.core.seq_QMARK_(children_50361)){
var seq__49870_50364 = cljs.core.seq(children_50361);
var chunk__49872_50365 = null;
var count__49873_50366 = (0);
var i__49874_50367 = (0);
while(true){
if((i__49874_50367 < count__49873_50366)){
var child_50368 = chunk__49872_50365.cljs$core$IIndexed$_nth$arity$2(null,i__49874_50367);
if(cljs.core.truth_(child_50368)){
node.appendChild(child_50368);


var G__50369 = seq__49870_50364;
var G__50370 = chunk__49872_50365;
var G__50371 = count__49873_50366;
var G__50372 = (i__49874_50367 + (1));
seq__49870_50364 = G__50369;
chunk__49872_50365 = G__50370;
count__49873_50366 = G__50371;
i__49874_50367 = G__50372;
continue;
} else {
var G__50373 = seq__49870_50364;
var G__50374 = chunk__49872_50365;
var G__50375 = count__49873_50366;
var G__50376 = (i__49874_50367 + (1));
seq__49870_50364 = G__50373;
chunk__49872_50365 = G__50374;
count__49873_50366 = G__50375;
i__49874_50367 = G__50376;
continue;
}
} else {
var temp__5753__auto___50377 = cljs.core.seq(seq__49870_50364);
if(temp__5753__auto___50377){
var seq__49870_50378__$1 = temp__5753__auto___50377;
if(cljs.core.chunked_seq_QMARK_(seq__49870_50378__$1)){
var c__4679__auto___50379 = cljs.core.chunk_first(seq__49870_50378__$1);
var G__50380 = cljs.core.chunk_rest(seq__49870_50378__$1);
var G__50381 = c__4679__auto___50379;
var G__50382 = cljs.core.count(c__4679__auto___50379);
var G__50383 = (0);
seq__49870_50364 = G__50380;
chunk__49872_50365 = G__50381;
count__49873_50366 = G__50382;
i__49874_50367 = G__50383;
continue;
} else {
var child_50384 = cljs.core.first(seq__49870_50378__$1);
if(cljs.core.truth_(child_50384)){
node.appendChild(child_50384);


var G__50385 = cljs.core.next(seq__49870_50378__$1);
var G__50386 = null;
var G__50387 = (0);
var G__50388 = (0);
seq__49870_50364 = G__50385;
chunk__49872_50365 = G__50386;
count__49873_50366 = G__50387;
i__49874_50367 = G__50388;
continue;
} else {
var G__50389 = cljs.core.next(seq__49870_50378__$1);
var G__50390 = null;
var G__50391 = (0);
var G__50392 = (0);
seq__49870_50364 = G__50389;
chunk__49872_50365 = G__50390;
count__49873_50366 = G__50391;
i__49874_50367 = G__50392;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50361);
}
}


var G__50393 = seq__49843_50354;
var G__50394 = chunk__49845_50355;
var G__50395 = count__49846_50356;
var G__50396 = (i__49847_50357 + (1));
seq__49843_50354 = G__50393;
chunk__49845_50355 = G__50394;
count__49846_50356 = G__50395;
i__49847_50357 = G__50396;
continue;
} else {
var G__50397 = seq__49843_50354;
var G__50398 = chunk__49845_50355;
var G__50399 = count__49846_50356;
var G__50400 = (i__49847_50357 + (1));
seq__49843_50354 = G__50397;
chunk__49845_50355 = G__50398;
count__49846_50356 = G__50399;
i__49847_50357 = G__50400;
continue;
}
} else {
var temp__5753__auto___50401 = cljs.core.seq(seq__49843_50354);
if(temp__5753__auto___50401){
var seq__49843_50402__$1 = temp__5753__auto___50401;
if(cljs.core.chunked_seq_QMARK_(seq__49843_50402__$1)){
var c__4679__auto___50403 = cljs.core.chunk_first(seq__49843_50402__$1);
var G__50404 = cljs.core.chunk_rest(seq__49843_50402__$1);
var G__50405 = c__4679__auto___50403;
var G__50406 = cljs.core.count(c__4679__auto___50403);
var G__50407 = (0);
seq__49843_50354 = G__50404;
chunk__49845_50355 = G__50405;
count__49846_50356 = G__50406;
i__49847_50357 = G__50407;
continue;
} else {
var child_struct_50408 = cljs.core.first(seq__49843_50402__$1);
if((!((child_struct_50408 == null)))){
if(typeof child_struct_50408 === 'string'){
var text_50409 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50409),child_struct_50408].join(''));
} else {
var children_50410 = shadow.dom.svg_node(child_struct_50408);
if(cljs.core.seq_QMARK_(children_50410)){
var seq__49889_50411 = cljs.core.seq(children_50410);
var chunk__49891_50412 = null;
var count__49892_50413 = (0);
var i__49893_50414 = (0);
while(true){
if((i__49893_50414 < count__49892_50413)){
var child_50415 = chunk__49891_50412.cljs$core$IIndexed$_nth$arity$2(null,i__49893_50414);
if(cljs.core.truth_(child_50415)){
node.appendChild(child_50415);


var G__50416 = seq__49889_50411;
var G__50417 = chunk__49891_50412;
var G__50418 = count__49892_50413;
var G__50419 = (i__49893_50414 + (1));
seq__49889_50411 = G__50416;
chunk__49891_50412 = G__50417;
count__49892_50413 = G__50418;
i__49893_50414 = G__50419;
continue;
} else {
var G__50420 = seq__49889_50411;
var G__50421 = chunk__49891_50412;
var G__50422 = count__49892_50413;
var G__50423 = (i__49893_50414 + (1));
seq__49889_50411 = G__50420;
chunk__49891_50412 = G__50421;
count__49892_50413 = G__50422;
i__49893_50414 = G__50423;
continue;
}
} else {
var temp__5753__auto___50425__$1 = cljs.core.seq(seq__49889_50411);
if(temp__5753__auto___50425__$1){
var seq__49889_50428__$1 = temp__5753__auto___50425__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49889_50428__$1)){
var c__4679__auto___50429 = cljs.core.chunk_first(seq__49889_50428__$1);
var G__50430 = cljs.core.chunk_rest(seq__49889_50428__$1);
var G__50431 = c__4679__auto___50429;
var G__50432 = cljs.core.count(c__4679__auto___50429);
var G__50433 = (0);
seq__49889_50411 = G__50430;
chunk__49891_50412 = G__50431;
count__49892_50413 = G__50432;
i__49893_50414 = G__50433;
continue;
} else {
var child_50434 = cljs.core.first(seq__49889_50428__$1);
if(cljs.core.truth_(child_50434)){
node.appendChild(child_50434);


var G__50435 = cljs.core.next(seq__49889_50428__$1);
var G__50436 = null;
var G__50437 = (0);
var G__50438 = (0);
seq__49889_50411 = G__50435;
chunk__49891_50412 = G__50436;
count__49892_50413 = G__50437;
i__49893_50414 = G__50438;
continue;
} else {
var G__50439 = cljs.core.next(seq__49889_50428__$1);
var G__50440 = null;
var G__50441 = (0);
var G__50442 = (0);
seq__49889_50411 = G__50439;
chunk__49891_50412 = G__50440;
count__49892_50413 = G__50441;
i__49893_50414 = G__50442;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50410);
}
}


var G__50443 = cljs.core.next(seq__49843_50402__$1);
var G__50444 = null;
var G__50445 = (0);
var G__50446 = (0);
seq__49843_50354 = G__50443;
chunk__49845_50355 = G__50444;
count__49846_50356 = G__50445;
i__49847_50357 = G__50446;
continue;
} else {
var G__50447 = cljs.core.next(seq__49843_50402__$1);
var G__50448 = null;
var G__50449 = (0);
var G__50450 = (0);
seq__49843_50354 = G__50447;
chunk__49845_50355 = G__50448;
count__49846_50356 = G__50449;
i__49847_50357 = G__50450;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___50451 = arguments.length;
var i__4865__auto___50452 = (0);
while(true){
if((i__4865__auto___50452 < len__4864__auto___50451)){
args__4870__auto__.push((arguments[i__4865__auto___50452]));

var G__50453 = (i__4865__auto___50452 + (1));
i__4865__auto___50452 = G__50453;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49906){
var G__49907 = cljs.core.first(seq49906);
var seq49906__$1 = cljs.core.next(seq49906);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49907,seq49906__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49916 = arguments.length;
switch (G__49916) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__44847__auto___50455 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_49925){
var state_val_49927 = (state_49925[(1)]);
if((state_val_49927 === (1))){
var state_49925__$1 = state_49925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49925__$1,(2),once_or_cleanup);
} else {
if((state_val_49927 === (2))){
var inst_49922 = (state_49925[(2)]);
var inst_49923 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49925__$1 = (function (){var statearr_49933 = state_49925;
(statearr_49933[(7)] = inst_49922);

return statearr_49933;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49925__$1,inst_49923);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__44113__auto__ = null;
var shadow$dom$state_machine__44113__auto____0 = (function (){
var statearr_49935 = [null,null,null,null,null,null,null,null];
(statearr_49935[(0)] = shadow$dom$state_machine__44113__auto__);

(statearr_49935[(1)] = (1));

return statearr_49935;
});
var shadow$dom$state_machine__44113__auto____1 = (function (state_49925){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_49925);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e49940){var ex__44116__auto__ = e49940;
var statearr_49941_50459 = state_49925;
(statearr_49941_50459[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_49925[(4)]))){
var statearr_49942_50460 = state_49925;
(statearr_49942_50460[(1)] = cljs.core.first((state_49925[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50461 = state_49925;
state_49925 = G__50461;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
shadow$dom$state_machine__44113__auto__ = function(state_49925){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__44113__auto____0.call(this);
case 1:
return shadow$dom$state_machine__44113__auto____1.call(this,state_49925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__44113__auto____0;
shadow$dom$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__44113__auto____1;
return shadow$dom$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_49943 = f__44848__auto__();
(statearr_49943[(6)] = c__44847__auto___50455);

return statearr_49943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
