goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__45010 = arguments.length;
switch (G__45010) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45013 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45013 = (function (f,blockable,meta45014){
this.f = f;
this.blockable = blockable;
this.meta45014 = meta45014;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45013.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45015,meta45014__$1){
var self__ = this;
var _45015__$1 = this;
return (new cljs.core.async.t_cljs$core$async45013(self__.f,self__.blockable,meta45014__$1));
}));

(cljs.core.async.t_cljs$core$async45013.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45015){
var self__ = this;
var _45015__$1 = this;
return self__.meta45014;
}));

(cljs.core.async.t_cljs$core$async45013.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45013.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45013.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async45013.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async45013.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta45014","meta45014",-368453020,null)], null);
}));

(cljs.core.async.t_cljs$core$async45013.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45013.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45013");

(cljs.core.async.t_cljs$core$async45013.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45013");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45013.
 */
cljs.core.async.__GT_t_cljs$core$async45013 = (function cljs$core$async$__GT_t_cljs$core$async45013(f__$1,blockable__$1,meta45014){
return (new cljs.core.async.t_cljs$core$async45013(f__$1,blockable__$1,meta45014));
});

}

return (new cljs.core.async.t_cljs$core$async45013(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__45043 = arguments.length;
switch (G__45043) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__45054 = arguments.length;
switch (G__45054) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__45067 = arguments.length;
switch (G__45067) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_48708 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48708) : fn1.call(null,val_48708));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48708) : fn1.call(null,val_48708));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__45070 = arguments.length;
switch (G__45070) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___48723 = n;
var x_48724 = (0);
while(true){
if((x_48724 < n__4741__auto___48723)){
(a[x_48724] = x_48724);

var G__48725 = (x_48724 + (1));
x_48724 = G__48725;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45087 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45087 = (function (flag,meta45088){
this.flag = flag;
this.meta45088 = meta45088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45089,meta45088__$1){
var self__ = this;
var _45089__$1 = this;
return (new cljs.core.async.t_cljs$core$async45087(self__.flag,meta45088__$1));
}));

(cljs.core.async.t_cljs$core$async45087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45089){
var self__ = this;
var _45089__$1 = this;
return self__.meta45088;
}));

(cljs.core.async.t_cljs$core$async45087.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45087.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45087.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45087.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async45087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta45088","meta45088",-1372526939,null)], null);
}));

(cljs.core.async.t_cljs$core$async45087.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45087.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45087");

(cljs.core.async.t_cljs$core$async45087.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45087");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45087.
 */
cljs.core.async.__GT_t_cljs$core$async45087 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async45087(flag__$1,meta45088){
return (new cljs.core.async.t_cljs$core$async45087(flag__$1,meta45088));
});

}

return (new cljs.core.async.t_cljs$core$async45087(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45130 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45130 = (function (flag,cb,meta45131){
this.flag = flag;
this.cb = cb;
this.meta45131 = meta45131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45132,meta45131__$1){
var self__ = this;
var _45132__$1 = this;
return (new cljs.core.async.t_cljs$core$async45130(self__.flag,self__.cb,meta45131__$1));
}));

(cljs.core.async.t_cljs$core$async45130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45132){
var self__ = this;
var _45132__$1 = this;
return self__.meta45131;
}));

(cljs.core.async.t_cljs$core$async45130.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45130.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45130.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45130.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async45130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta45131","meta45131",-2086828648,null)], null);
}));

(cljs.core.async.t_cljs$core$async45130.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45130");

(cljs.core.async.t_cljs$core$async45130.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45130");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45130.
 */
cljs.core.async.__GT_t_cljs$core$async45130 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async45130(flag__$1,cb__$1,meta45131){
return (new cljs.core.async.t_cljs$core$async45130(flag__$1,cb__$1,meta45131));
});

}

return (new cljs.core.async.t_cljs$core$async45130(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45169_SHARP_){
var G__45194 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45169_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45194) : fret.call(null,G__45194));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45170_SHARP_){
var G__45205 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45170_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45205) : fret.call(null,G__45205));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__48741 = (i + (1));
i = G__48741;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___48743 = arguments.length;
var i__4865__auto___48744 = (0);
while(true){
if((i__4865__auto___48744 < len__4864__auto___48743)){
args__4870__auto__.push((arguments[i__4865__auto___48744]));

var G__48745 = (i__4865__auto___48744 + (1));
i__4865__auto___48744 = G__48745;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__45243){
var map__45244 = p__45243;
var map__45244__$1 = cljs.core.__destructure_map(map__45244);
var opts = map__45244__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq45237){
var G__45238 = cljs.core.first(seq45237);
var seq45237__$1 = cljs.core.next(seq45237);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45238,seq45237__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__45258 = arguments.length;
switch (G__45258) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44847__auto___48748 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45357){
var state_val_45358 = (state_45357[(1)]);
if((state_val_45358 === (7))){
var inst_45349 = (state_45357[(2)]);
var state_45357__$1 = state_45357;
var statearr_45368_48749 = state_45357__$1;
(statearr_45368_48749[(2)] = inst_45349);

(statearr_45368_48749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (1))){
var state_45357__$1 = state_45357;
var statearr_45369_48750 = state_45357__$1;
(statearr_45369_48750[(2)] = null);

(statearr_45369_48750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (4))){
var inst_45316 = (state_45357[(7)]);
var inst_45316__$1 = (state_45357[(2)]);
var inst_45319 = (inst_45316__$1 == null);
var state_45357__$1 = (function (){var statearr_45370 = state_45357;
(statearr_45370[(7)] = inst_45316__$1);

return statearr_45370;
})();
if(cljs.core.truth_(inst_45319)){
var statearr_45371_48758 = state_45357__$1;
(statearr_45371_48758[(1)] = (5));

} else {
var statearr_45372_48761 = state_45357__$1;
(statearr_45372_48761[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (13))){
var state_45357__$1 = state_45357;
var statearr_45373_48762 = state_45357__$1;
(statearr_45373_48762[(2)] = null);

(statearr_45373_48762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (6))){
var inst_45316 = (state_45357[(7)]);
var state_45357__$1 = state_45357;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45357__$1,(11),to,inst_45316);
} else {
if((state_val_45358 === (3))){
var inst_45352 = (state_45357[(2)]);
var state_45357__$1 = state_45357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45357__$1,inst_45352);
} else {
if((state_val_45358 === (12))){
var state_45357__$1 = state_45357;
var statearr_45381_48763 = state_45357__$1;
(statearr_45381_48763[(2)] = null);

(statearr_45381_48763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (2))){
var state_45357__$1 = state_45357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45357__$1,(4),from);
} else {
if((state_val_45358 === (11))){
var inst_45341 = (state_45357[(2)]);
var state_45357__$1 = state_45357;
if(cljs.core.truth_(inst_45341)){
var statearr_45383_48764 = state_45357__$1;
(statearr_45383_48764[(1)] = (12));

} else {
var statearr_45384_48765 = state_45357__$1;
(statearr_45384_48765[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (9))){
var state_45357__$1 = state_45357;
var statearr_45387_48766 = state_45357__$1;
(statearr_45387_48766[(2)] = null);

(statearr_45387_48766[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (5))){
var state_45357__$1 = state_45357;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45389_48767 = state_45357__$1;
(statearr_45389_48767[(1)] = (8));

} else {
var statearr_45392_48768 = state_45357__$1;
(statearr_45392_48768[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (14))){
var inst_45347 = (state_45357[(2)]);
var state_45357__$1 = state_45357;
var statearr_45395_48770 = state_45357__$1;
(statearr_45395_48770[(2)] = inst_45347);

(statearr_45395_48770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (10))){
var inst_45338 = (state_45357[(2)]);
var state_45357__$1 = state_45357;
var statearr_45398_48771 = state_45357__$1;
(statearr_45398_48771[(2)] = inst_45338);

(statearr_45398_48771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45358 === (8))){
var inst_45329 = cljs.core.async.close_BANG_(to);
var state_45357__$1 = state_45357;
var statearr_45401_48772 = state_45357__$1;
(statearr_45401_48772[(2)] = inst_45329);

(statearr_45401_48772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_45411 = [null,null,null,null,null,null,null,null];
(statearr_45411[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_45411[(1)] = (1));

return statearr_45411;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_45357){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45357);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45414){var ex__44116__auto__ = e45414;
var statearr_45415_48773 = state_45357;
(statearr_45415_48773[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45357[(4)]))){
var statearr_45416_48774 = state_45357;
(statearr_45416_48774[(1)] = cljs.core.first((state_45357[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48775 = state_45357;
state_45357 = G__48775;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_45357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_45357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45417 = f__44848__auto__();
(statearr_45417[(6)] = c__44847__auto___48748);

return statearr_45417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__45428){
var vec__45429 = p__45428;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45429,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45429,(1),null);
var job = vec__45429;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44847__auto___48778 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45437){
var state_val_45438 = (state_45437[(1)]);
if((state_val_45438 === (1))){
var state_45437__$1 = state_45437;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45437__$1,(2),res,v);
} else {
if((state_val_45438 === (2))){
var inst_45434 = (state_45437[(2)]);
var inst_45435 = cljs.core.async.close_BANG_(res);
var state_45437__$1 = (function (){var statearr_45440 = state_45437;
(statearr_45440[(7)] = inst_45434);

return statearr_45440;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45437__$1,inst_45435);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0 = (function (){
var statearr_45443 = [null,null,null,null,null,null,null,null];
(statearr_45443[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__);

(statearr_45443[(1)] = (1));

return statearr_45443;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1 = (function (state_45437){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45437);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45445){var ex__44116__auto__ = e45445;
var statearr_45446_48781 = state_45437;
(statearr_45446_48781[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45437[(4)]))){
var statearr_45447_48782 = state_45437;
(statearr_45447_48782[(1)] = cljs.core.first((state_45437[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48783 = state_45437;
state_45437 = G__48783;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = function(state_45437){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1.call(this,state_45437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45454 = f__44848__auto__();
(statearr_45454[(6)] = c__44847__auto___48778);

return statearr_45454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__45459){
var vec__45460 = p__45459;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45460,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45460,(1),null);
var job = vec__45460;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___48785 = n;
var __48786 = (0);
while(true){
if((__48786 < n__4741__auto___48785)){
var G__45465_48787 = type;
var G__45465_48788__$1 = (((G__45465_48787 instanceof cljs.core.Keyword))?G__45465_48787.fqn:null);
switch (G__45465_48788__$1) {
case "compute":
var c__44847__auto___48790 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48786,c__44847__auto___48790,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async){
return (function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = ((function (__48786,c__44847__auto___48790,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async){
return (function (state_45478){
var state_val_45479 = (state_45478[(1)]);
if((state_val_45479 === (1))){
var state_45478__$1 = state_45478;
var statearr_45485_48792 = state_45478__$1;
(statearr_45485_48792[(2)] = null);

(statearr_45485_48792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45479 === (2))){
var state_45478__$1 = state_45478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45478__$1,(4),jobs);
} else {
if((state_val_45479 === (3))){
var inst_45476 = (state_45478[(2)]);
var state_45478__$1 = state_45478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45478__$1,inst_45476);
} else {
if((state_val_45479 === (4))){
var inst_45468 = (state_45478[(2)]);
var inst_45469 = process(inst_45468);
var state_45478__$1 = state_45478;
if(cljs.core.truth_(inst_45469)){
var statearr_45492_48794 = state_45478__$1;
(statearr_45492_48794[(1)] = (5));

} else {
var statearr_45495_48795 = state_45478__$1;
(statearr_45495_48795[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45479 === (5))){
var state_45478__$1 = state_45478;
var statearr_45497_48796 = state_45478__$1;
(statearr_45497_48796[(2)] = null);

(statearr_45497_48796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45479 === (6))){
var state_45478__$1 = state_45478;
var statearr_45498_48797 = state_45478__$1;
(statearr_45498_48797[(2)] = null);

(statearr_45498_48797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45479 === (7))){
var inst_45474 = (state_45478[(2)]);
var state_45478__$1 = state_45478;
var statearr_45500_48799 = state_45478__$1;
(statearr_45500_48799[(2)] = inst_45474);

(statearr_45500_48799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48786,c__44847__auto___48790,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async))
;
return ((function (__48786,switch__44112__auto__,c__44847__auto___48790,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0 = (function (){
var statearr_45502 = [null,null,null,null,null,null,null];
(statearr_45502[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__);

(statearr_45502[(1)] = (1));

return statearr_45502;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1 = (function (state_45478){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45478);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45503){var ex__44116__auto__ = e45503;
var statearr_45504_48801 = state_45478;
(statearr_45504_48801[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45478[(4)]))){
var statearr_45509_48802 = state_45478;
(statearr_45509_48802[(1)] = cljs.core.first((state_45478[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48803 = state_45478;
state_45478 = G__48803;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = function(state_45478){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1.call(this,state_45478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__;
})()
;})(__48786,switch__44112__auto__,c__44847__auto___48790,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async))
})();
var state__44849__auto__ = (function (){var statearr_45512 = f__44848__auto__();
(statearr_45512[(6)] = c__44847__auto___48790);

return statearr_45512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
});})(__48786,c__44847__auto___48790,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async))
);


break;
case "async":
var c__44847__auto___48804 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48786,c__44847__auto___48804,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async){
return (function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = ((function (__48786,c__44847__auto___48804,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async){
return (function (state_45530){
var state_val_45531 = (state_45530[(1)]);
if((state_val_45531 === (1))){
var state_45530__$1 = state_45530;
var statearr_45534_48805 = state_45530__$1;
(statearr_45534_48805[(2)] = null);

(statearr_45534_48805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (2))){
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45530__$1,(4),jobs);
} else {
if((state_val_45531 === (3))){
var inst_45528 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45530__$1,inst_45528);
} else {
if((state_val_45531 === (4))){
var inst_45516 = (state_45530[(2)]);
var inst_45517 = async(inst_45516);
var state_45530__$1 = state_45530;
if(cljs.core.truth_(inst_45517)){
var statearr_45535_48806 = state_45530__$1;
(statearr_45535_48806[(1)] = (5));

} else {
var statearr_45537_48807 = state_45530__$1;
(statearr_45537_48807[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (5))){
var state_45530__$1 = state_45530;
var statearr_45542_48808 = state_45530__$1;
(statearr_45542_48808[(2)] = null);

(statearr_45542_48808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (6))){
var state_45530__$1 = state_45530;
var statearr_45543_48810 = state_45530__$1;
(statearr_45543_48810[(2)] = null);

(statearr_45543_48810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45531 === (7))){
var inst_45526 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45544_48811 = state_45530__$1;
(statearr_45544_48811[(2)] = inst_45526);

(statearr_45544_48811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48786,c__44847__auto___48804,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async))
;
return ((function (__48786,switch__44112__auto__,c__44847__auto___48804,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0 = (function (){
var statearr_45545 = [null,null,null,null,null,null,null];
(statearr_45545[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__);

(statearr_45545[(1)] = (1));

return statearr_45545;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1 = (function (state_45530){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45530);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45546){var ex__44116__auto__ = e45546;
var statearr_45547_48817 = state_45530;
(statearr_45547_48817[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45530[(4)]))){
var statearr_45548_48818 = state_45530;
(statearr_45548_48818[(1)] = cljs.core.first((state_45530[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48819 = state_45530;
state_45530 = G__48819;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = function(state_45530){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1.call(this,state_45530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__;
})()
;})(__48786,switch__44112__auto__,c__44847__auto___48804,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async))
})();
var state__44849__auto__ = (function (){var statearr_45550 = f__44848__auto__();
(statearr_45550[(6)] = c__44847__auto___48804);

return statearr_45550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
});})(__48786,c__44847__auto___48804,G__45465_48787,G__45465_48788__$1,n__4741__auto___48785,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45465_48788__$1)].join('')));

}

var G__48820 = (__48786 + (1));
__48786 = G__48820;
continue;
} else {
}
break;
}

var c__44847__auto___48821 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45594){
var state_val_45595 = (state_45594[(1)]);
if((state_val_45595 === (7))){
var inst_45590 = (state_45594[(2)]);
var state_45594__$1 = state_45594;
var statearr_45597_48822 = state_45594__$1;
(statearr_45597_48822[(2)] = inst_45590);

(statearr_45597_48822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45595 === (1))){
var state_45594__$1 = state_45594;
var statearr_45599_48823 = state_45594__$1;
(statearr_45599_48823[(2)] = null);

(statearr_45599_48823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45595 === (4))){
var inst_45563 = (state_45594[(7)]);
var inst_45563__$1 = (state_45594[(2)]);
var inst_45568 = (inst_45563__$1 == null);
var state_45594__$1 = (function (){var statearr_45601 = state_45594;
(statearr_45601[(7)] = inst_45563__$1);

return statearr_45601;
})();
if(cljs.core.truth_(inst_45568)){
var statearr_45604_48824 = state_45594__$1;
(statearr_45604_48824[(1)] = (5));

} else {
var statearr_45605_48825 = state_45594__$1;
(statearr_45605_48825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45595 === (6))){
var inst_45563 = (state_45594[(7)]);
var inst_45572 = (state_45594[(8)]);
var inst_45572__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_45578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45580 = [inst_45563,inst_45572__$1];
var inst_45581 = (new cljs.core.PersistentVector(null,2,(5),inst_45578,inst_45580,null));
var state_45594__$1 = (function (){var statearr_45610 = state_45594;
(statearr_45610[(8)] = inst_45572__$1);

return statearr_45610;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45594__$1,(8),jobs,inst_45581);
} else {
if((state_val_45595 === (3))){
var inst_45592 = (state_45594[(2)]);
var state_45594__$1 = state_45594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45594__$1,inst_45592);
} else {
if((state_val_45595 === (2))){
var state_45594__$1 = state_45594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45594__$1,(4),from);
} else {
if((state_val_45595 === (9))){
var inst_45585 = (state_45594[(2)]);
var state_45594__$1 = (function (){var statearr_45617 = state_45594;
(statearr_45617[(9)] = inst_45585);

return statearr_45617;
})();
var statearr_45619_48829 = state_45594__$1;
(statearr_45619_48829[(2)] = null);

(statearr_45619_48829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45595 === (5))){
var inst_45570 = cljs.core.async.close_BANG_(jobs);
var state_45594__$1 = state_45594;
var statearr_45620_48830 = state_45594__$1;
(statearr_45620_48830[(2)] = inst_45570);

(statearr_45620_48830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45595 === (8))){
var inst_45572 = (state_45594[(8)]);
var inst_45583 = (state_45594[(2)]);
var state_45594__$1 = (function (){var statearr_45626 = state_45594;
(statearr_45626[(10)] = inst_45583);

return statearr_45626;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45594__$1,(9),results,inst_45572);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0 = (function (){
var statearr_45633 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45633[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__);

(statearr_45633[(1)] = (1));

return statearr_45633;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1 = (function (state_45594){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45594);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45639){var ex__44116__auto__ = e45639;
var statearr_45647_48831 = state_45594;
(statearr_45647_48831[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45594[(4)]))){
var statearr_45648_48832 = state_45594;
(statearr_45648_48832[(1)] = cljs.core.first((state_45594[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48839 = state_45594;
state_45594 = G__48839;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = function(state_45594){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1.call(this,state_45594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45653 = f__44848__auto__();
(statearr_45653[(6)] = c__44847__auto___48821);

return statearr_45653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


var c__44847__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45701){
var state_val_45702 = (state_45701[(1)]);
if((state_val_45702 === (7))){
var inst_45697 = (state_45701[(2)]);
var state_45701__$1 = state_45701;
var statearr_45710_48841 = state_45701__$1;
(statearr_45710_48841[(2)] = inst_45697);

(statearr_45710_48841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (20))){
var state_45701__$1 = state_45701;
var statearr_45712_48842 = state_45701__$1;
(statearr_45712_48842[(2)] = null);

(statearr_45712_48842[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (1))){
var state_45701__$1 = state_45701;
var statearr_45713_48844 = state_45701__$1;
(statearr_45713_48844[(2)] = null);

(statearr_45713_48844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (4))){
var inst_45657 = (state_45701[(7)]);
var inst_45657__$1 = (state_45701[(2)]);
var inst_45658 = (inst_45657__$1 == null);
var state_45701__$1 = (function (){var statearr_45714 = state_45701;
(statearr_45714[(7)] = inst_45657__$1);

return statearr_45714;
})();
if(cljs.core.truth_(inst_45658)){
var statearr_45715_48848 = state_45701__$1;
(statearr_45715_48848[(1)] = (5));

} else {
var statearr_45718_48849 = state_45701__$1;
(statearr_45718_48849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (15))){
var inst_45672 = (state_45701[(8)]);
var state_45701__$1 = state_45701;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45701__$1,(18),to,inst_45672);
} else {
if((state_val_45702 === (21))){
var inst_45692 = (state_45701[(2)]);
var state_45701__$1 = state_45701;
var statearr_45719_48850 = state_45701__$1;
(statearr_45719_48850[(2)] = inst_45692);

(statearr_45719_48850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (13))){
var inst_45694 = (state_45701[(2)]);
var state_45701__$1 = (function (){var statearr_45720 = state_45701;
(statearr_45720[(9)] = inst_45694);

return statearr_45720;
})();
var statearr_45722_48851 = state_45701__$1;
(statearr_45722_48851[(2)] = null);

(statearr_45722_48851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (6))){
var inst_45657 = (state_45701[(7)]);
var state_45701__$1 = state_45701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45701__$1,(11),inst_45657);
} else {
if((state_val_45702 === (17))){
var inst_45683 = (state_45701[(2)]);
var state_45701__$1 = state_45701;
if(cljs.core.truth_(inst_45683)){
var statearr_45724_48852 = state_45701__$1;
(statearr_45724_48852[(1)] = (19));

} else {
var statearr_45725_48853 = state_45701__$1;
(statearr_45725_48853[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (3))){
var inst_45699 = (state_45701[(2)]);
var state_45701__$1 = state_45701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45701__$1,inst_45699);
} else {
if((state_val_45702 === (12))){
var inst_45669 = (state_45701[(10)]);
var state_45701__$1 = state_45701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45701__$1,(14),inst_45669);
} else {
if((state_val_45702 === (2))){
var state_45701__$1 = state_45701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45701__$1,(4),results);
} else {
if((state_val_45702 === (19))){
var state_45701__$1 = state_45701;
var statearr_45735_48858 = state_45701__$1;
(statearr_45735_48858[(2)] = null);

(statearr_45735_48858[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (11))){
var inst_45669 = (state_45701[(2)]);
var state_45701__$1 = (function (){var statearr_45738 = state_45701;
(statearr_45738[(10)] = inst_45669);

return statearr_45738;
})();
var statearr_45739_48859 = state_45701__$1;
(statearr_45739_48859[(2)] = null);

(statearr_45739_48859[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (9))){
var state_45701__$1 = state_45701;
var statearr_45740_48860 = state_45701__$1;
(statearr_45740_48860[(2)] = null);

(statearr_45740_48860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (5))){
var state_45701__$1 = state_45701;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45746_48861 = state_45701__$1;
(statearr_45746_48861[(1)] = (8));

} else {
var statearr_45747_48862 = state_45701__$1;
(statearr_45747_48862[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (14))){
var inst_45677 = (state_45701[(11)]);
var inst_45672 = (state_45701[(8)]);
var inst_45672__$1 = (state_45701[(2)]);
var inst_45676 = (inst_45672__$1 == null);
var inst_45677__$1 = cljs.core.not(inst_45676);
var state_45701__$1 = (function (){var statearr_45748 = state_45701;
(statearr_45748[(11)] = inst_45677__$1);

(statearr_45748[(8)] = inst_45672__$1);

return statearr_45748;
})();
if(inst_45677__$1){
var statearr_45752_48863 = state_45701__$1;
(statearr_45752_48863[(1)] = (15));

} else {
var statearr_45753_48864 = state_45701__$1;
(statearr_45753_48864[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (16))){
var inst_45677 = (state_45701[(11)]);
var state_45701__$1 = state_45701;
var statearr_45754_48871 = state_45701__$1;
(statearr_45754_48871[(2)] = inst_45677);

(statearr_45754_48871[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (10))){
var inst_45664 = (state_45701[(2)]);
var state_45701__$1 = state_45701;
var statearr_45755_48873 = state_45701__$1;
(statearr_45755_48873[(2)] = inst_45664);

(statearr_45755_48873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (18))){
var inst_45680 = (state_45701[(2)]);
var state_45701__$1 = state_45701;
var statearr_45757_48875 = state_45701__$1;
(statearr_45757_48875[(2)] = inst_45680);

(statearr_45757_48875[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45702 === (8))){
var inst_45661 = cljs.core.async.close_BANG_(to);
var state_45701__$1 = state_45701;
var statearr_45760_48876 = state_45701__$1;
(statearr_45760_48876[(2)] = inst_45661);

(statearr_45760_48876[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0 = (function (){
var statearr_45761 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45761[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__);

(statearr_45761[(1)] = (1));

return statearr_45761;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1 = (function (state_45701){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45701);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45762){var ex__44116__auto__ = e45762;
var statearr_45763_48883 = state_45701;
(statearr_45763_48883[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45701[(4)]))){
var statearr_45764_48884 = state_45701;
(statearr_45764_48884[(1)] = cljs.core.first((state_45701[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48885 = state_45701;
state_45701 = G__48885;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__ = function(state_45701){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1.call(this,state_45701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45765 = f__44848__auto__();
(statearr_45765[(6)] = c__44847__auto__);

return statearr_45765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

return c__44847__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__45768 = arguments.length;
switch (G__45768) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__45776 = arguments.length;
switch (G__45776) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__45799 = arguments.length;
switch (G__45799) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44847__auto___48893 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45825){
var state_val_45826 = (state_45825[(1)]);
if((state_val_45826 === (7))){
var inst_45821 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
var statearr_45837_48894 = state_45825__$1;
(statearr_45837_48894[(2)] = inst_45821);

(statearr_45837_48894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (1))){
var state_45825__$1 = state_45825;
var statearr_45838_48895 = state_45825__$1;
(statearr_45838_48895[(2)] = null);

(statearr_45838_48895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (4))){
var inst_45802 = (state_45825[(7)]);
var inst_45802__$1 = (state_45825[(2)]);
var inst_45803 = (inst_45802__$1 == null);
var state_45825__$1 = (function (){var statearr_45839 = state_45825;
(statearr_45839[(7)] = inst_45802__$1);

return statearr_45839;
})();
if(cljs.core.truth_(inst_45803)){
var statearr_45840_48901 = state_45825__$1;
(statearr_45840_48901[(1)] = (5));

} else {
var statearr_45841_48902 = state_45825__$1;
(statearr_45841_48902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (13))){
var state_45825__$1 = state_45825;
var statearr_45842_48903 = state_45825__$1;
(statearr_45842_48903[(2)] = null);

(statearr_45842_48903[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (6))){
var inst_45802 = (state_45825[(7)]);
var inst_45808 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45802) : p.call(null,inst_45802));
var state_45825__$1 = state_45825;
if(cljs.core.truth_(inst_45808)){
var statearr_45843_48904 = state_45825__$1;
(statearr_45843_48904[(1)] = (9));

} else {
var statearr_45844_48911 = state_45825__$1;
(statearr_45844_48911[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (3))){
var inst_45823 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45825__$1,inst_45823);
} else {
if((state_val_45826 === (12))){
var state_45825__$1 = state_45825;
var statearr_45849_48912 = state_45825__$1;
(statearr_45849_48912[(2)] = null);

(statearr_45849_48912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (2))){
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45825__$1,(4),ch);
} else {
if((state_val_45826 === (11))){
var inst_45802 = (state_45825[(7)]);
var inst_45812 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45825__$1,(8),inst_45812,inst_45802);
} else {
if((state_val_45826 === (9))){
var state_45825__$1 = state_45825;
var statearr_45857_48913 = state_45825__$1;
(statearr_45857_48913[(2)] = tc);

(statearr_45857_48913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (5))){
var inst_45805 = cljs.core.async.close_BANG_(tc);
var inst_45806 = cljs.core.async.close_BANG_(fc);
var state_45825__$1 = (function (){var statearr_45858 = state_45825;
(statearr_45858[(8)] = inst_45805);

return statearr_45858;
})();
var statearr_45859_48914 = state_45825__$1;
(statearr_45859_48914[(2)] = inst_45806);

(statearr_45859_48914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (14))){
var inst_45819 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
var statearr_45860_48915 = state_45825__$1;
(statearr_45860_48915[(2)] = inst_45819);

(statearr_45860_48915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (10))){
var state_45825__$1 = state_45825;
var statearr_45861_48916 = state_45825__$1;
(statearr_45861_48916[(2)] = fc);

(statearr_45861_48916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (8))){
var inst_45814 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
if(cljs.core.truth_(inst_45814)){
var statearr_45862_48917 = state_45825__$1;
(statearr_45862_48917[(1)] = (12));

} else {
var statearr_45863_48918 = state_45825__$1;
(statearr_45863_48918[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_45865 = [null,null,null,null,null,null,null,null,null];
(statearr_45865[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_45865[(1)] = (1));

return statearr_45865;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_45825){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45825);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45866){var ex__44116__auto__ = e45866;
var statearr_45867_48924 = state_45825;
(statearr_45867_48924[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45825[(4)]))){
var statearr_45868_48925 = state_45825;
(statearr_45868_48925[(1)] = cljs.core.first((state_45825[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48926 = state_45825;
state_45825 = G__48926;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_45825){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_45825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45877 = f__44848__auto__();
(statearr_45877[(6)] = c__44847__auto___48893);

return statearr_45877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44847__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45910){
var state_val_45911 = (state_45910[(1)]);
if((state_val_45911 === (7))){
var inst_45906 = (state_45910[(2)]);
var state_45910__$1 = state_45910;
var statearr_45913_48928 = state_45910__$1;
(statearr_45913_48928[(2)] = inst_45906);

(statearr_45913_48928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (1))){
var inst_45883 = init;
var inst_45884 = inst_45883;
var state_45910__$1 = (function (){var statearr_45918 = state_45910;
(statearr_45918[(7)] = inst_45884);

return statearr_45918;
})();
var statearr_45919_48929 = state_45910__$1;
(statearr_45919_48929[(2)] = null);

(statearr_45919_48929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (4))){
var inst_45887 = (state_45910[(8)]);
var inst_45887__$1 = (state_45910[(2)]);
var inst_45888 = (inst_45887__$1 == null);
var state_45910__$1 = (function (){var statearr_45921 = state_45910;
(statearr_45921[(8)] = inst_45887__$1);

return statearr_45921;
})();
if(cljs.core.truth_(inst_45888)){
var statearr_45922_48930 = state_45910__$1;
(statearr_45922_48930[(1)] = (5));

} else {
var statearr_45923_48931 = state_45910__$1;
(statearr_45923_48931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (6))){
var inst_45892 = (state_45910[(9)]);
var inst_45887 = (state_45910[(8)]);
var inst_45884 = (state_45910[(7)]);
var inst_45892__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_45884,inst_45887) : f.call(null,inst_45884,inst_45887));
var inst_45893 = cljs.core.reduced_QMARK_(inst_45892__$1);
var state_45910__$1 = (function (){var statearr_45924 = state_45910;
(statearr_45924[(9)] = inst_45892__$1);

return statearr_45924;
})();
if(inst_45893){
var statearr_45925_48932 = state_45910__$1;
(statearr_45925_48932[(1)] = (8));

} else {
var statearr_45926_48938 = state_45910__$1;
(statearr_45926_48938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (3))){
var inst_45908 = (state_45910[(2)]);
var state_45910__$1 = state_45910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45910__$1,inst_45908);
} else {
if((state_val_45911 === (2))){
var state_45910__$1 = state_45910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45910__$1,(4),ch);
} else {
if((state_val_45911 === (9))){
var inst_45892 = (state_45910[(9)]);
var inst_45884 = inst_45892;
var state_45910__$1 = (function (){var statearr_45928 = state_45910;
(statearr_45928[(7)] = inst_45884);

return statearr_45928;
})();
var statearr_45929_48939 = state_45910__$1;
(statearr_45929_48939[(2)] = null);

(statearr_45929_48939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (5))){
var inst_45884 = (state_45910[(7)]);
var state_45910__$1 = state_45910;
var statearr_45933_48940 = state_45910__$1;
(statearr_45933_48940[(2)] = inst_45884);

(statearr_45933_48940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (10))){
var inst_45904 = (state_45910[(2)]);
var state_45910__$1 = state_45910;
var statearr_45934_48941 = state_45910__$1;
(statearr_45934_48941[(2)] = inst_45904);

(statearr_45934_48941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45911 === (8))){
var inst_45892 = (state_45910[(9)]);
var inst_45900 = cljs.core.deref(inst_45892);
var state_45910__$1 = state_45910;
var statearr_45937_48942 = state_45910__$1;
(statearr_45937_48942[(2)] = inst_45900);

(statearr_45937_48942[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__44113__auto__ = null;
var cljs$core$async$reduce_$_state_machine__44113__auto____0 = (function (){
var statearr_45940 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45940[(0)] = cljs$core$async$reduce_$_state_machine__44113__auto__);

(statearr_45940[(1)] = (1));

return statearr_45940;
});
var cljs$core$async$reduce_$_state_machine__44113__auto____1 = (function (state_45910){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45910);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45941){var ex__44116__auto__ = e45941;
var statearr_45942_48943 = state_45910;
(statearr_45942_48943[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45910[(4)]))){
var statearr_45943_48944 = state_45910;
(statearr_45943_48944[(1)] = cljs.core.first((state_45910[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48945 = state_45910;
state_45910 = G__48945;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__44113__auto__ = function(state_45910){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__44113__auto____1.call(this,state_45910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__44113__auto____0;
cljs$core$async$reduce_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__44113__auto____1;
return cljs$core$async$reduce_$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45949 = f__44848__auto__();
(statearr_45949[(6)] = c__44847__auto__);

return statearr_45949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

return c__44847__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44847__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_45956){
var state_val_45957 = (state_45956[(1)]);
if((state_val_45957 === (1))){
var inst_45951 = cljs.core.async.reduce(f__$1,init,ch);
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45956__$1,(2),inst_45951);
} else {
if((state_val_45957 === (2))){
var inst_45953 = (state_45956[(2)]);
var inst_45954 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45953) : f__$1.call(null,inst_45953));
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45956__$1,inst_45954);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__44113__auto__ = null;
var cljs$core$async$transduce_$_state_machine__44113__auto____0 = (function (){
var statearr_45967 = [null,null,null,null,null,null,null];
(statearr_45967[(0)] = cljs$core$async$transduce_$_state_machine__44113__auto__);

(statearr_45967[(1)] = (1));

return statearr_45967;
});
var cljs$core$async$transduce_$_state_machine__44113__auto____1 = (function (state_45956){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_45956);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e45969){var ex__44116__auto__ = e45969;
var statearr_45970_48947 = state_45956;
(statearr_45970_48947[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_45956[(4)]))){
var statearr_45971_48949 = state_45956;
(statearr_45971_48949[(1)] = cljs.core.first((state_45956[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48951 = state_45956;
state_45956 = G__48951;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__44113__auto__ = function(state_45956){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__44113__auto____1.call(this,state_45956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__44113__auto____0;
cljs$core$async$transduce_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__44113__auto____1;
return cljs$core$async$transduce_$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_45972 = f__44848__auto__();
(statearr_45972[(6)] = c__44847__auto__);

return statearr_45972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

return c__44847__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45976 = arguments.length;
switch (G__45976) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44847__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_46007){
var state_val_46008 = (state_46007[(1)]);
if((state_val_46008 === (7))){
var inst_45987 = (state_46007[(2)]);
var state_46007__$1 = state_46007;
var statearr_46009_48956 = state_46007__$1;
(statearr_46009_48956[(2)] = inst_45987);

(statearr_46009_48956[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (1))){
var inst_45981 = cljs.core.seq(coll);
var inst_45982 = inst_45981;
var state_46007__$1 = (function (){var statearr_46010 = state_46007;
(statearr_46010[(7)] = inst_45982);

return statearr_46010;
})();
var statearr_46012_48957 = state_46007__$1;
(statearr_46012_48957[(2)] = null);

(statearr_46012_48957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (4))){
var inst_45982 = (state_46007[(7)]);
var inst_45985 = cljs.core.first(inst_45982);
var state_46007__$1 = state_46007;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46007__$1,(7),ch,inst_45985);
} else {
if((state_val_46008 === (13))){
var inst_46001 = (state_46007[(2)]);
var state_46007__$1 = state_46007;
var statearr_46017_48958 = state_46007__$1;
(statearr_46017_48958[(2)] = inst_46001);

(statearr_46017_48958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (6))){
var inst_45991 = (state_46007[(2)]);
var state_46007__$1 = state_46007;
if(cljs.core.truth_(inst_45991)){
var statearr_46026_48959 = state_46007__$1;
(statearr_46026_48959[(1)] = (8));

} else {
var statearr_46027_48960 = state_46007__$1;
(statearr_46027_48960[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (3))){
var inst_46005 = (state_46007[(2)]);
var state_46007__$1 = state_46007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46007__$1,inst_46005);
} else {
if((state_val_46008 === (12))){
var state_46007__$1 = state_46007;
var statearr_46028_48969 = state_46007__$1;
(statearr_46028_48969[(2)] = null);

(statearr_46028_48969[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (2))){
var inst_45982 = (state_46007[(7)]);
var state_46007__$1 = state_46007;
if(cljs.core.truth_(inst_45982)){
var statearr_46030_48973 = state_46007__$1;
(statearr_46030_48973[(1)] = (4));

} else {
var statearr_46031_48974 = state_46007__$1;
(statearr_46031_48974[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (11))){
var inst_45998 = cljs.core.async.close_BANG_(ch);
var state_46007__$1 = state_46007;
var statearr_46033_48981 = state_46007__$1;
(statearr_46033_48981[(2)] = inst_45998);

(statearr_46033_48981[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (9))){
var state_46007__$1 = state_46007;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46034_48982 = state_46007__$1;
(statearr_46034_48982[(1)] = (11));

} else {
var statearr_46035_48983 = state_46007__$1;
(statearr_46035_48983[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (5))){
var inst_45982 = (state_46007[(7)]);
var state_46007__$1 = state_46007;
var statearr_46036_48984 = state_46007__$1;
(statearr_46036_48984[(2)] = inst_45982);

(statearr_46036_48984[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (10))){
var inst_46003 = (state_46007[(2)]);
var state_46007__$1 = state_46007;
var statearr_46037_48985 = state_46007__$1;
(statearr_46037_48985[(2)] = inst_46003);

(statearr_46037_48985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46008 === (8))){
var inst_45982 = (state_46007[(7)]);
var inst_45994 = cljs.core.next(inst_45982);
var inst_45982__$1 = inst_45994;
var state_46007__$1 = (function (){var statearr_46038 = state_46007;
(statearr_46038[(7)] = inst_45982__$1);

return statearr_46038;
})();
var statearr_46039_48989 = state_46007__$1;
(statearr_46039_48989[(2)] = null);

(statearr_46039_48989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_46044 = [null,null,null,null,null,null,null,null];
(statearr_46044[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_46044[(1)] = (1));

return statearr_46044;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_46007){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_46007);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e46046){var ex__44116__auto__ = e46046;
var statearr_46048_48990 = state_46007;
(statearr_46048_48990[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_46007[(4)]))){
var statearr_46051_48994 = state_46007;
(statearr_46051_48994[(1)] = cljs.core.first((state_46007[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48995 = state_46007;
state_46007 = G__48995;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_46007){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_46007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_46053 = f__44848__auto__();
(statearr_46053[(6)] = c__44847__auto__);

return statearr_46053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

return c__44847__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__46067 = arguments.length;
switch (G__46067) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_49003 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_49003(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_49008 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_49008(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_49012 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_49012(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_49016 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_49016(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46098 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46098 = (function (ch,cs,meta46099){
this.ch = ch;
this.cs = cs;
this.meta46099 = meta46099;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46100,meta46099__$1){
var self__ = this;
var _46100__$1 = this;
return (new cljs.core.async.t_cljs$core$async46098(self__.ch,self__.cs,meta46099__$1));
}));

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46100){
var self__ = this;
var _46100__$1 = this;
return self__.meta46099;
}));

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async46098.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async46098.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta46099","meta46099",-962235964,null)], null);
}));

(cljs.core.async.t_cljs$core$async46098.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46098.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46098");

(cljs.core.async.t_cljs$core$async46098.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46098");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46098.
 */
cljs.core.async.__GT_t_cljs$core$async46098 = (function cljs$core$async$mult_$___GT_t_cljs$core$async46098(ch__$1,cs__$1,meta46099){
return (new cljs.core.async.t_cljs$core$async46098(ch__$1,cs__$1,meta46099));
});

}

return (new cljs.core.async.t_cljs$core$async46098(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44847__auto___49023 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_46271){
var state_val_46273 = (state_46271[(1)]);
if((state_val_46273 === (7))){
var inst_46260 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46277_49024 = state_46271__$1;
(statearr_46277_49024[(2)] = inst_46260);

(statearr_46277_49024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (20))){
var inst_46143 = (state_46271[(7)]);
var inst_46157 = cljs.core.first(inst_46143);
var inst_46158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46157,(0),null);
var inst_46159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46157,(1),null);
var state_46271__$1 = (function (){var statearr_46281 = state_46271;
(statearr_46281[(8)] = inst_46158);

return statearr_46281;
})();
if(cljs.core.truth_(inst_46159)){
var statearr_46282_49025 = state_46271__$1;
(statearr_46282_49025[(1)] = (22));

} else {
var statearr_46283_49026 = state_46271__$1;
(statearr_46283_49026[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (27))){
var inst_46189 = (state_46271[(9)]);
var inst_46191 = (state_46271[(10)]);
var inst_46197 = (state_46271[(11)]);
var inst_46109 = (state_46271[(12)]);
var inst_46197__$1 = cljs.core._nth(inst_46189,inst_46191);
var inst_46199 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46197__$1,inst_46109,done);
var state_46271__$1 = (function (){var statearr_46289 = state_46271;
(statearr_46289[(11)] = inst_46197__$1);

return statearr_46289;
})();
if(cljs.core.truth_(inst_46199)){
var statearr_46292_49028 = state_46271__$1;
(statearr_46292_49028[(1)] = (30));

} else {
var statearr_46293_49029 = state_46271__$1;
(statearr_46293_49029[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (1))){
var state_46271__$1 = state_46271;
var statearr_46296_49030 = state_46271__$1;
(statearr_46296_49030[(2)] = null);

(statearr_46296_49030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (24))){
var inst_46143 = (state_46271[(7)]);
var inst_46165 = (state_46271[(2)]);
var inst_46167 = cljs.core.next(inst_46143);
var inst_46119 = inst_46167;
var inst_46120 = null;
var inst_46121 = (0);
var inst_46122 = (0);
var state_46271__$1 = (function (){var statearr_46299 = state_46271;
(statearr_46299[(13)] = inst_46119);

(statearr_46299[(14)] = inst_46120);

(statearr_46299[(15)] = inst_46121);

(statearr_46299[(16)] = inst_46165);

(statearr_46299[(17)] = inst_46122);

return statearr_46299;
})();
var statearr_46302_49031 = state_46271__$1;
(statearr_46302_49031[(2)] = null);

(statearr_46302_49031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (39))){
var state_46271__$1 = state_46271;
var statearr_46318_49032 = state_46271__$1;
(statearr_46318_49032[(2)] = null);

(statearr_46318_49032[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (4))){
var inst_46109 = (state_46271[(12)]);
var inst_46109__$1 = (state_46271[(2)]);
var inst_46111 = (inst_46109__$1 == null);
var state_46271__$1 = (function (){var statearr_46324 = state_46271;
(statearr_46324[(12)] = inst_46109__$1);

return statearr_46324;
})();
if(cljs.core.truth_(inst_46111)){
var statearr_46326_49033 = state_46271__$1;
(statearr_46326_49033[(1)] = (5));

} else {
var statearr_46328_49034 = state_46271__$1;
(statearr_46328_49034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (15))){
var inst_46119 = (state_46271[(13)]);
var inst_46120 = (state_46271[(14)]);
var inst_46121 = (state_46271[(15)]);
var inst_46122 = (state_46271[(17)]);
var inst_46139 = (state_46271[(2)]);
var inst_46140 = (inst_46122 + (1));
var tmp46308 = inst_46119;
var tmp46309 = inst_46120;
var tmp46310 = inst_46121;
var inst_46119__$1 = tmp46308;
var inst_46120__$1 = tmp46309;
var inst_46121__$1 = tmp46310;
var inst_46122__$1 = inst_46140;
var state_46271__$1 = (function (){var statearr_46332 = state_46271;
(statearr_46332[(13)] = inst_46119__$1);

(statearr_46332[(14)] = inst_46120__$1);

(statearr_46332[(15)] = inst_46121__$1);

(statearr_46332[(18)] = inst_46139);

(statearr_46332[(17)] = inst_46122__$1);

return statearr_46332;
})();
var statearr_46333_49036 = state_46271__$1;
(statearr_46333_49036[(2)] = null);

(statearr_46333_49036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (21))){
var inst_46170 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46339_49037 = state_46271__$1;
(statearr_46339_49037[(2)] = inst_46170);

(statearr_46339_49037[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (31))){
var inst_46197 = (state_46271[(11)]);
var inst_46204 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46197);
var state_46271__$1 = state_46271;
var statearr_46340_49038 = state_46271__$1;
(statearr_46340_49038[(2)] = inst_46204);

(statearr_46340_49038[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (32))){
var inst_46189 = (state_46271[(9)]);
var inst_46191 = (state_46271[(10)]);
var inst_46188 = (state_46271[(19)]);
var inst_46190 = (state_46271[(20)]);
var inst_46206 = (state_46271[(2)]);
var inst_46207 = (inst_46191 + (1));
var tmp46335 = inst_46189;
var tmp46336 = inst_46188;
var tmp46337 = inst_46190;
var inst_46188__$1 = tmp46336;
var inst_46189__$1 = tmp46335;
var inst_46190__$1 = tmp46337;
var inst_46191__$1 = inst_46207;
var state_46271__$1 = (function (){var statearr_46342 = state_46271;
(statearr_46342[(9)] = inst_46189__$1);

(statearr_46342[(10)] = inst_46191__$1);

(statearr_46342[(21)] = inst_46206);

(statearr_46342[(19)] = inst_46188__$1);

(statearr_46342[(20)] = inst_46190__$1);

return statearr_46342;
})();
var statearr_46347_49039 = state_46271__$1;
(statearr_46347_49039[(2)] = null);

(statearr_46347_49039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (40))){
var inst_46220 = (state_46271[(22)]);
var inst_46224 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46220);
var state_46271__$1 = state_46271;
var statearr_46356_49040 = state_46271__$1;
(statearr_46356_49040[(2)] = inst_46224);

(statearr_46356_49040[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (33))){
var inst_46210 = (state_46271[(23)]);
var inst_46212 = cljs.core.chunked_seq_QMARK_(inst_46210);
var state_46271__$1 = state_46271;
if(inst_46212){
var statearr_46361_49041 = state_46271__$1;
(statearr_46361_49041[(1)] = (36));

} else {
var statearr_46363_49042 = state_46271__$1;
(statearr_46363_49042[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (13))){
var inst_46132 = (state_46271[(24)]);
var inst_46136 = cljs.core.async.close_BANG_(inst_46132);
var state_46271__$1 = state_46271;
var statearr_46368_49043 = state_46271__$1;
(statearr_46368_49043[(2)] = inst_46136);

(statearr_46368_49043[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (22))){
var inst_46158 = (state_46271[(8)]);
var inst_46161 = cljs.core.async.close_BANG_(inst_46158);
var state_46271__$1 = state_46271;
var statearr_46376_49047 = state_46271__$1;
(statearr_46376_49047[(2)] = inst_46161);

(statearr_46376_49047[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (36))){
var inst_46210 = (state_46271[(23)]);
var inst_46215 = cljs.core.chunk_first(inst_46210);
var inst_46216 = cljs.core.chunk_rest(inst_46210);
var inst_46217 = cljs.core.count(inst_46215);
var inst_46188 = inst_46216;
var inst_46189 = inst_46215;
var inst_46190 = inst_46217;
var inst_46191 = (0);
var state_46271__$1 = (function (){var statearr_46381 = state_46271;
(statearr_46381[(9)] = inst_46189);

(statearr_46381[(10)] = inst_46191);

(statearr_46381[(19)] = inst_46188);

(statearr_46381[(20)] = inst_46190);

return statearr_46381;
})();
var statearr_46385_49048 = state_46271__$1;
(statearr_46385_49048[(2)] = null);

(statearr_46385_49048[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (41))){
var inst_46210 = (state_46271[(23)]);
var inst_46226 = (state_46271[(2)]);
var inst_46228 = cljs.core.next(inst_46210);
var inst_46188 = inst_46228;
var inst_46189 = null;
var inst_46190 = (0);
var inst_46191 = (0);
var state_46271__$1 = (function (){var statearr_46386 = state_46271;
(statearr_46386[(9)] = inst_46189);

(statearr_46386[(10)] = inst_46191);

(statearr_46386[(25)] = inst_46226);

(statearr_46386[(19)] = inst_46188);

(statearr_46386[(20)] = inst_46190);

return statearr_46386;
})();
var statearr_46393_49049 = state_46271__$1;
(statearr_46393_49049[(2)] = null);

(statearr_46393_49049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (43))){
var state_46271__$1 = state_46271;
var statearr_46397_49050 = state_46271__$1;
(statearr_46397_49050[(2)] = null);

(statearr_46397_49050[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (29))){
var inst_46237 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46405_49051 = state_46271__$1;
(statearr_46405_49051[(2)] = inst_46237);

(statearr_46405_49051[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (44))){
var inst_46251 = (state_46271[(2)]);
var state_46271__$1 = (function (){var statearr_46408 = state_46271;
(statearr_46408[(26)] = inst_46251);

return statearr_46408;
})();
var statearr_46410_49052 = state_46271__$1;
(statearr_46410_49052[(2)] = null);

(statearr_46410_49052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (6))){
var inst_46180 = (state_46271[(27)]);
var inst_46179 = cljs.core.deref(cs);
var inst_46180__$1 = cljs.core.keys(inst_46179);
var inst_46181 = cljs.core.count(inst_46180__$1);
var inst_46182 = cljs.core.reset_BANG_(dctr,inst_46181);
var inst_46187 = cljs.core.seq(inst_46180__$1);
var inst_46188 = inst_46187;
var inst_46189 = null;
var inst_46190 = (0);
var inst_46191 = (0);
var state_46271__$1 = (function (){var statearr_46416 = state_46271;
(statearr_46416[(28)] = inst_46182);

(statearr_46416[(9)] = inst_46189);

(statearr_46416[(10)] = inst_46191);

(statearr_46416[(27)] = inst_46180__$1);

(statearr_46416[(19)] = inst_46188);

(statearr_46416[(20)] = inst_46190);

return statearr_46416;
})();
var statearr_46419_49056 = state_46271__$1;
(statearr_46419_49056[(2)] = null);

(statearr_46419_49056[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (28))){
var inst_46210 = (state_46271[(23)]);
var inst_46188 = (state_46271[(19)]);
var inst_46210__$1 = cljs.core.seq(inst_46188);
var state_46271__$1 = (function (){var statearr_46429 = state_46271;
(statearr_46429[(23)] = inst_46210__$1);

return statearr_46429;
})();
if(inst_46210__$1){
var statearr_46432_49057 = state_46271__$1;
(statearr_46432_49057[(1)] = (33));

} else {
var statearr_46433_49058 = state_46271__$1;
(statearr_46433_49058[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (25))){
var inst_46191 = (state_46271[(10)]);
var inst_46190 = (state_46271[(20)]);
var inst_46193 = (inst_46191 < inst_46190);
var inst_46194 = inst_46193;
var state_46271__$1 = state_46271;
if(cljs.core.truth_(inst_46194)){
var statearr_46443_49059 = state_46271__$1;
(statearr_46443_49059[(1)] = (27));

} else {
var statearr_46444_49060 = state_46271__$1;
(statearr_46444_49060[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (34))){
var state_46271__$1 = state_46271;
var statearr_46445_49062 = state_46271__$1;
(statearr_46445_49062[(2)] = null);

(statearr_46445_49062[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (17))){
var state_46271__$1 = state_46271;
var statearr_46448_49064 = state_46271__$1;
(statearr_46448_49064[(2)] = null);

(statearr_46448_49064[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (3))){
var inst_46262 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46271__$1,inst_46262);
} else {
if((state_val_46273 === (12))){
var inst_46175 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46454_49065 = state_46271__$1;
(statearr_46454_49065[(2)] = inst_46175);

(statearr_46454_49065[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (2))){
var state_46271__$1 = state_46271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46271__$1,(4),ch);
} else {
if((state_val_46273 === (23))){
var state_46271__$1 = state_46271;
var statearr_46458_49069 = state_46271__$1;
(statearr_46458_49069[(2)] = null);

(statearr_46458_49069[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (35))){
var inst_46235 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46470_49070 = state_46271__$1;
(statearr_46470_49070[(2)] = inst_46235);

(statearr_46470_49070[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (19))){
var inst_46143 = (state_46271[(7)]);
var inst_46149 = cljs.core.chunk_first(inst_46143);
var inst_46150 = cljs.core.chunk_rest(inst_46143);
var inst_46151 = cljs.core.count(inst_46149);
var inst_46119 = inst_46150;
var inst_46120 = inst_46149;
var inst_46121 = inst_46151;
var inst_46122 = (0);
var state_46271__$1 = (function (){var statearr_46479 = state_46271;
(statearr_46479[(13)] = inst_46119);

(statearr_46479[(14)] = inst_46120);

(statearr_46479[(15)] = inst_46121);

(statearr_46479[(17)] = inst_46122);

return statearr_46479;
})();
var statearr_46482_49072 = state_46271__$1;
(statearr_46482_49072[(2)] = null);

(statearr_46482_49072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (11))){
var inst_46143 = (state_46271[(7)]);
var inst_46119 = (state_46271[(13)]);
var inst_46143__$1 = cljs.core.seq(inst_46119);
var state_46271__$1 = (function (){var statearr_46485 = state_46271;
(statearr_46485[(7)] = inst_46143__$1);

return statearr_46485;
})();
if(inst_46143__$1){
var statearr_46488_49073 = state_46271__$1;
(statearr_46488_49073[(1)] = (16));

} else {
var statearr_46491_49074 = state_46271__$1;
(statearr_46491_49074[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (9))){
var inst_46177 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46493_49075 = state_46271__$1;
(statearr_46493_49075[(2)] = inst_46177);

(statearr_46493_49075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (5))){
var inst_46117 = cljs.core.deref(cs);
var inst_46118 = cljs.core.seq(inst_46117);
var inst_46119 = inst_46118;
var inst_46120 = null;
var inst_46121 = (0);
var inst_46122 = (0);
var state_46271__$1 = (function (){var statearr_46498 = state_46271;
(statearr_46498[(13)] = inst_46119);

(statearr_46498[(14)] = inst_46120);

(statearr_46498[(15)] = inst_46121);

(statearr_46498[(17)] = inst_46122);

return statearr_46498;
})();
var statearr_46502_49077 = state_46271__$1;
(statearr_46502_49077[(2)] = null);

(statearr_46502_49077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (14))){
var state_46271__$1 = state_46271;
var statearr_46507_49079 = state_46271__$1;
(statearr_46507_49079[(2)] = null);

(statearr_46507_49079[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (45))){
var inst_46245 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46511_49080 = state_46271__$1;
(statearr_46511_49080[(2)] = inst_46245);

(statearr_46511_49080[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (26))){
var inst_46180 = (state_46271[(27)]);
var inst_46239 = (state_46271[(2)]);
var inst_46240 = cljs.core.seq(inst_46180);
var state_46271__$1 = (function (){var statearr_46519 = state_46271;
(statearr_46519[(29)] = inst_46239);

return statearr_46519;
})();
if(inst_46240){
var statearr_46520_49081 = state_46271__$1;
(statearr_46520_49081[(1)] = (42));

} else {
var statearr_46521_49082 = state_46271__$1;
(statearr_46521_49082[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (16))){
var inst_46143 = (state_46271[(7)]);
var inst_46146 = cljs.core.chunked_seq_QMARK_(inst_46143);
var state_46271__$1 = state_46271;
if(inst_46146){
var statearr_46527_49083 = state_46271__$1;
(statearr_46527_49083[(1)] = (19));

} else {
var statearr_46529_49084 = state_46271__$1;
(statearr_46529_49084[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (38))){
var inst_46231 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46533_49086 = state_46271__$1;
(statearr_46533_49086[(2)] = inst_46231);

(statearr_46533_49086[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (30))){
var state_46271__$1 = state_46271;
var statearr_46537_49087 = state_46271__$1;
(statearr_46537_49087[(2)] = null);

(statearr_46537_49087[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (10))){
var inst_46120 = (state_46271[(14)]);
var inst_46122 = (state_46271[(17)]);
var inst_46131 = cljs.core._nth(inst_46120,inst_46122);
var inst_46132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46131,(0),null);
var inst_46133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46131,(1),null);
var state_46271__$1 = (function (){var statearr_46541 = state_46271;
(statearr_46541[(24)] = inst_46132);

return statearr_46541;
})();
if(cljs.core.truth_(inst_46133)){
var statearr_46544_49089 = state_46271__$1;
(statearr_46544_49089[(1)] = (13));

} else {
var statearr_46547_49090 = state_46271__$1;
(statearr_46547_49090[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (18))){
var inst_46173 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46551_49094 = state_46271__$1;
(statearr_46551_49094[(2)] = inst_46173);

(statearr_46551_49094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (42))){
var state_46271__$1 = state_46271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46271__$1,(45),dchan);
} else {
if((state_val_46273 === (37))){
var inst_46220 = (state_46271[(22)]);
var inst_46109 = (state_46271[(12)]);
var inst_46210 = (state_46271[(23)]);
var inst_46220__$1 = cljs.core.first(inst_46210);
var inst_46221 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46220__$1,inst_46109,done);
var state_46271__$1 = (function (){var statearr_46557 = state_46271;
(statearr_46557[(22)] = inst_46220__$1);

return statearr_46557;
})();
if(cljs.core.truth_(inst_46221)){
var statearr_46561_49097 = state_46271__$1;
(statearr_46561_49097[(1)] = (39));

} else {
var statearr_46565_49098 = state_46271__$1;
(statearr_46565_49098[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46273 === (8))){
var inst_46121 = (state_46271[(15)]);
var inst_46122 = (state_46271[(17)]);
var inst_46125 = (inst_46122 < inst_46121);
var inst_46126 = inst_46125;
var state_46271__$1 = state_46271;
if(cljs.core.truth_(inst_46126)){
var statearr_46570_49101 = state_46271__$1;
(statearr_46570_49101[(1)] = (10));

} else {
var statearr_46573_49102 = state_46271__$1;
(statearr_46573_49102[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__44113__auto__ = null;
var cljs$core$async$mult_$_state_machine__44113__auto____0 = (function (){
var statearr_46599 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46599[(0)] = cljs$core$async$mult_$_state_machine__44113__auto__);

(statearr_46599[(1)] = (1));

return statearr_46599;
});
var cljs$core$async$mult_$_state_machine__44113__auto____1 = (function (state_46271){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_46271);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e46601){var ex__44116__auto__ = e46601;
var statearr_46602_49114 = state_46271;
(statearr_46602_49114[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_46271[(4)]))){
var statearr_46606_49115 = state_46271;
(statearr_46606_49115[(1)] = cljs.core.first((state_46271[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49116 = state_46271;
state_46271 = G__49116;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__44113__auto__ = function(state_46271){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__44113__auto____1.call(this,state_46271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__44113__auto____0;
cljs$core$async$mult_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__44113__auto____1;
return cljs$core$async$mult_$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_46610 = f__44848__auto__();
(statearr_46610[(6)] = c__44847__auto___49023);

return statearr_46610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__46627 = arguments.length;
switch (G__46627) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49128 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49128(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49129 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49129(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49130 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49130(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49131 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49131(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49132 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49132(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___49133 = arguments.length;
var i__4865__auto___49134 = (0);
while(true){
if((i__4865__auto___49134 < len__4864__auto___49133)){
args__4870__auto__.push((arguments[i__4865__auto___49134]));

var G__49141 = (i__4865__auto___49134 + (1));
i__4865__auto___49134 = G__49141;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__46744){
var map__46746 = p__46744;
var map__46746__$1 = cljs.core.__destructure_map(map__46746);
var opts = map__46746__$1;
var statearr_46753_49143 = state;
(statearr_46753_49143[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_46755_49145 = state;
(statearr_46755_49145[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_46761_49146 = state;
(statearr_46761_49146[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq46726){
var G__46728 = cljs.core.first(seq46726);
var seq46726__$1 = cljs.core.next(seq46726);
var G__46729 = cljs.core.first(seq46726__$1);
var seq46726__$2 = cljs.core.next(seq46726__$1);
var G__46730 = cljs.core.first(seq46726__$2);
var seq46726__$3 = cljs.core.next(seq46726__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46728,G__46729,G__46730,seq46726__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46800 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46800 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta46801){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta46801 = meta46801;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46802,meta46801__$1){
var self__ = this;
var _46802__$1 = this;
return (new cljs.core.async.t_cljs$core$async46800(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta46801__$1));
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46802){
var self__ = this;
var _46802__$1 = this;
return self__.meta46801;
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46800.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46800.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta46801","meta46801",-1818877561,null)], null);
}));

(cljs.core.async.t_cljs$core$async46800.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46800.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46800");

(cljs.core.async.t_cljs$core$async46800.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46800");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46800.
 */
cljs.core.async.__GT_t_cljs$core$async46800 = (function cljs$core$async$mix_$___GT_t_cljs$core$async46800(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46801){
return (new cljs.core.async.t_cljs$core$async46800(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46801));
});

}

return (new cljs.core.async.t_cljs$core$async46800(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44847__auto___49153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_46942){
var state_val_46943 = (state_46942[(1)]);
if((state_val_46943 === (7))){
var inst_46898 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
if(cljs.core.truth_(inst_46898)){
var statearr_46946_49154 = state_46942__$1;
(statearr_46946_49154[(1)] = (8));

} else {
var statearr_46950_49155 = state_46942__$1;
(statearr_46950_49155[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (20))){
var inst_46891 = (state_46942[(7)]);
var state_46942__$1 = state_46942;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46942__$1,(23),out,inst_46891);
} else {
if((state_val_46943 === (1))){
var inst_46872 = calc_state();
var inst_46873 = cljs.core.__destructure_map(inst_46872);
var inst_46874 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46873,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46875 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46873,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46873,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46879 = inst_46872;
var state_46942__$1 = (function (){var statearr_46955 = state_46942;
(statearr_46955[(8)] = inst_46875);

(statearr_46955[(9)] = inst_46877);

(statearr_46955[(10)] = inst_46879);

(statearr_46955[(11)] = inst_46874);

return statearr_46955;
})();
var statearr_46956_49156 = state_46942__$1;
(statearr_46956_49156[(2)] = null);

(statearr_46956_49156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (24))){
var inst_46882 = (state_46942[(12)]);
var inst_46879 = inst_46882;
var state_46942__$1 = (function (){var statearr_46959 = state_46942;
(statearr_46959[(10)] = inst_46879);

return statearr_46959;
})();
var statearr_46962_49157 = state_46942__$1;
(statearr_46962_49157[(2)] = null);

(statearr_46962_49157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (4))){
var inst_46893 = (state_46942[(13)]);
var inst_46891 = (state_46942[(7)]);
var inst_46890 = (state_46942[(2)]);
var inst_46891__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46890,(0),null);
var inst_46892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46890,(1),null);
var inst_46893__$1 = (inst_46891__$1 == null);
var state_46942__$1 = (function (){var statearr_46965 = state_46942;
(statearr_46965[(14)] = inst_46892);

(statearr_46965[(13)] = inst_46893__$1);

(statearr_46965[(7)] = inst_46891__$1);

return statearr_46965;
})();
if(cljs.core.truth_(inst_46893__$1)){
var statearr_46966_49164 = state_46942__$1;
(statearr_46966_49164[(1)] = (5));

} else {
var statearr_46967_49165 = state_46942__$1;
(statearr_46967_49165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (15))){
var inst_46883 = (state_46942[(15)]);
var inst_46913 = (state_46942[(16)]);
var inst_46913__$1 = cljs.core.empty_QMARK_(inst_46883);
var state_46942__$1 = (function (){var statearr_46971 = state_46942;
(statearr_46971[(16)] = inst_46913__$1);

return statearr_46971;
})();
if(inst_46913__$1){
var statearr_46973_49166 = state_46942__$1;
(statearr_46973_49166[(1)] = (17));

} else {
var statearr_46974_49167 = state_46942__$1;
(statearr_46974_49167[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (21))){
var inst_46882 = (state_46942[(12)]);
var inst_46879 = inst_46882;
var state_46942__$1 = (function (){var statearr_46976 = state_46942;
(statearr_46976[(10)] = inst_46879);

return statearr_46976;
})();
var statearr_46978_49168 = state_46942__$1;
(statearr_46978_49168[(2)] = null);

(statearr_46978_49168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (13))){
var inst_46905 = (state_46942[(2)]);
var inst_46906 = calc_state();
var inst_46879 = inst_46906;
var state_46942__$1 = (function (){var statearr_46980 = state_46942;
(statearr_46980[(17)] = inst_46905);

(statearr_46980[(10)] = inst_46879);

return statearr_46980;
})();
var statearr_46982_49169 = state_46942__$1;
(statearr_46982_49169[(2)] = null);

(statearr_46982_49169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (22))){
var inst_46934 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
var statearr_46984_49170 = state_46942__$1;
(statearr_46984_49170[(2)] = inst_46934);

(statearr_46984_49170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (6))){
var inst_46892 = (state_46942[(14)]);
var inst_46896 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46892,change);
var state_46942__$1 = state_46942;
var statearr_46994_49171 = state_46942__$1;
(statearr_46994_49171[(2)] = inst_46896);

(statearr_46994_49171[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (25))){
var state_46942__$1 = state_46942;
var statearr_46997_49172 = state_46942__$1;
(statearr_46997_49172[(2)] = null);

(statearr_46997_49172[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (17))){
var inst_46892 = (state_46942[(14)]);
var inst_46884 = (state_46942[(18)]);
var inst_46916 = (inst_46884.cljs$core$IFn$_invoke$arity$1 ? inst_46884.cljs$core$IFn$_invoke$arity$1(inst_46892) : inst_46884.call(null,inst_46892));
var inst_46917 = cljs.core.not(inst_46916);
var state_46942__$1 = state_46942;
var statearr_47003_49173 = state_46942__$1;
(statearr_47003_49173[(2)] = inst_46917);

(statearr_47003_49173[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (3))){
var inst_46938 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46942__$1,inst_46938);
} else {
if((state_val_46943 === (12))){
var state_46942__$1 = state_46942;
var statearr_47007_49174 = state_46942__$1;
(statearr_47007_49174[(2)] = null);

(statearr_47007_49174[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (2))){
var inst_46882 = (state_46942[(12)]);
var inst_46879 = (state_46942[(10)]);
var inst_46882__$1 = cljs.core.__destructure_map(inst_46879);
var inst_46883 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46882__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46884 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46882__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46885 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46882__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46942__$1 = (function (){var statearr_47008 = state_46942;
(statearr_47008[(12)] = inst_46882__$1);

(statearr_47008[(15)] = inst_46883);

(statearr_47008[(18)] = inst_46884);

return statearr_47008;
})();
return cljs.core.async.ioc_alts_BANG_(state_46942__$1,(4),inst_46885);
} else {
if((state_val_46943 === (23))){
var inst_46925 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
if(cljs.core.truth_(inst_46925)){
var statearr_47009_49179 = state_46942__$1;
(statearr_47009_49179[(1)] = (24));

} else {
var statearr_47010_49180 = state_46942__$1;
(statearr_47010_49180[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (19))){
var inst_46920 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
var statearr_47011_49181 = state_46942__$1;
(statearr_47011_49181[(2)] = inst_46920);

(statearr_47011_49181[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (11))){
var inst_46892 = (state_46942[(14)]);
var inst_46902 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46892);
var state_46942__$1 = state_46942;
var statearr_47018_49182 = state_46942__$1;
(statearr_47018_49182[(2)] = inst_46902);

(statearr_47018_49182[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (9))){
var inst_46892 = (state_46942[(14)]);
var inst_46910 = (state_46942[(19)]);
var inst_46883 = (state_46942[(15)]);
var inst_46910__$1 = (inst_46883.cljs$core$IFn$_invoke$arity$1 ? inst_46883.cljs$core$IFn$_invoke$arity$1(inst_46892) : inst_46883.call(null,inst_46892));
var state_46942__$1 = (function (){var statearr_47024 = state_46942;
(statearr_47024[(19)] = inst_46910__$1);

return statearr_47024;
})();
if(cljs.core.truth_(inst_46910__$1)){
var statearr_47025_49186 = state_46942__$1;
(statearr_47025_49186[(1)] = (14));

} else {
var statearr_47026_49187 = state_46942__$1;
(statearr_47026_49187[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (5))){
var inst_46893 = (state_46942[(13)]);
var state_46942__$1 = state_46942;
var statearr_47027_49188 = state_46942__$1;
(statearr_47027_49188[(2)] = inst_46893);

(statearr_47027_49188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (14))){
var inst_46910 = (state_46942[(19)]);
var state_46942__$1 = state_46942;
var statearr_47028_49189 = state_46942__$1;
(statearr_47028_49189[(2)] = inst_46910);

(statearr_47028_49189[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (26))){
var inst_46930 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
var statearr_47031_49190 = state_46942__$1;
(statearr_47031_49190[(2)] = inst_46930);

(statearr_47031_49190[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (16))){
var inst_46922 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
if(cljs.core.truth_(inst_46922)){
var statearr_47033_49191 = state_46942__$1;
(statearr_47033_49191[(1)] = (20));

} else {
var statearr_47034_49192 = state_46942__$1;
(statearr_47034_49192[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (10))){
var inst_46936 = (state_46942[(2)]);
var state_46942__$1 = state_46942;
var statearr_47035_49193 = state_46942__$1;
(statearr_47035_49193[(2)] = inst_46936);

(statearr_47035_49193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (18))){
var inst_46913 = (state_46942[(16)]);
var state_46942__$1 = state_46942;
var statearr_47040_49194 = state_46942__$1;
(statearr_47040_49194[(2)] = inst_46913);

(statearr_47040_49194[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46943 === (8))){
var inst_46891 = (state_46942[(7)]);
var inst_46900 = (inst_46891 == null);
var state_46942__$1 = state_46942;
if(cljs.core.truth_(inst_46900)){
var statearr_47044_49195 = state_46942__$1;
(statearr_47044_49195[(1)] = (11));

} else {
var statearr_47045_49196 = state_46942__$1;
(statearr_47045_49196[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__44113__auto__ = null;
var cljs$core$async$mix_$_state_machine__44113__auto____0 = (function (){
var statearr_47048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47048[(0)] = cljs$core$async$mix_$_state_machine__44113__auto__);

(statearr_47048[(1)] = (1));

return statearr_47048;
});
var cljs$core$async$mix_$_state_machine__44113__auto____1 = (function (state_46942){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_46942);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e47050){var ex__44116__auto__ = e47050;
var statearr_47051_49197 = state_46942;
(statearr_47051_49197[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_46942[(4)]))){
var statearr_47055_49198 = state_46942;
(statearr_47055_49198[(1)] = cljs.core.first((state_46942[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49199 = state_46942;
state_46942 = G__49199;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__44113__auto__ = function(state_46942){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__44113__auto____1.call(this,state_46942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__44113__auto____0;
cljs$core$async$mix_$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__44113__auto____1;
return cljs$core$async$mix_$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_47057 = f__44848__auto__();
(statearr_47057[(6)] = c__44847__auto___49153);

return statearr_47057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49200 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49200(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49202 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49202(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49208 = (function() {
var G__49209 = null;
var G__49209__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49209__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49209 = function(p,v){
switch(arguments.length){
case 1:
return G__49209__1.call(this,p);
case 2:
return G__49209__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49209.cljs$core$IFn$_invoke$arity$1 = G__49209__1;
G__49209.cljs$core$IFn$_invoke$arity$2 = G__49209__2;
return G__49209;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__47126 = arguments.length;
switch (G__47126) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49208(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49208(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__47142 = arguments.length;
switch (G__47142) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__47138_SHARP_){
if(cljs.core.truth_((p1__47138_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47138_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__47138_SHARP_.call(null,topic)))){
return p1__47138_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__47138_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47152 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47152 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta47153){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta47153 = meta47153;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47154,meta47153__$1){
var self__ = this;
var _47154__$1 = this;
return (new cljs.core.async.t_cljs$core$async47152(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta47153__$1));
}));

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47154){
var self__ = this;
var _47154__$1 = this;
return self__.meta47153;
}));

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async47152.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async47152.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta47153","meta47153",-577576693,null)], null);
}));

(cljs.core.async.t_cljs$core$async47152.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47152.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47152");

(cljs.core.async.t_cljs$core$async47152.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47152");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47152.
 */
cljs.core.async.__GT_t_cljs$core$async47152 = (function cljs$core$async$__GT_t_cljs$core$async47152(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47153){
return (new cljs.core.async.t_cljs$core$async47152(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47153));
});

}

return (new cljs.core.async.t_cljs$core$async47152(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44847__auto___49217 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_47275){
var state_val_47276 = (state_47275[(1)]);
if((state_val_47276 === (7))){
var inst_47270 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
var statearr_47286_49219 = state_47275__$1;
(statearr_47286_49219[(2)] = inst_47270);

(statearr_47286_49219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (20))){
var state_47275__$1 = state_47275;
var statearr_47288_49221 = state_47275__$1;
(statearr_47288_49221[(2)] = null);

(statearr_47288_49221[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (1))){
var state_47275__$1 = state_47275;
var statearr_47290_49222 = state_47275__$1;
(statearr_47290_49222[(2)] = null);

(statearr_47290_49222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (24))){
var inst_47249 = (state_47275[(7)]);
var inst_47261 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_47249);
var state_47275__$1 = state_47275;
var statearr_47292_49223 = state_47275__$1;
(statearr_47292_49223[(2)] = inst_47261);

(statearr_47292_49223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (4))){
var inst_47195 = (state_47275[(8)]);
var inst_47195__$1 = (state_47275[(2)]);
var inst_47196 = (inst_47195__$1 == null);
var state_47275__$1 = (function (){var statearr_47294 = state_47275;
(statearr_47294[(8)] = inst_47195__$1);

return statearr_47294;
})();
if(cljs.core.truth_(inst_47196)){
var statearr_47296_49224 = state_47275__$1;
(statearr_47296_49224[(1)] = (5));

} else {
var statearr_47299_49225 = state_47275__$1;
(statearr_47299_49225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (15))){
var inst_47242 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
var statearr_47301_49226 = state_47275__$1;
(statearr_47301_49226[(2)] = inst_47242);

(statearr_47301_49226[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (21))){
var inst_47267 = (state_47275[(2)]);
var state_47275__$1 = (function (){var statearr_47303 = state_47275;
(statearr_47303[(9)] = inst_47267);

return statearr_47303;
})();
var statearr_47304_49227 = state_47275__$1;
(statearr_47304_49227[(2)] = null);

(statearr_47304_49227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (13))){
var inst_47223 = (state_47275[(10)]);
var inst_47226 = cljs.core.chunked_seq_QMARK_(inst_47223);
var state_47275__$1 = state_47275;
if(inst_47226){
var statearr_47305_49228 = state_47275__$1;
(statearr_47305_49228[(1)] = (16));

} else {
var statearr_47307_49229 = state_47275__$1;
(statearr_47307_49229[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (22))){
var inst_47258 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
if(cljs.core.truth_(inst_47258)){
var statearr_47310_49230 = state_47275__$1;
(statearr_47310_49230[(1)] = (23));

} else {
var statearr_47311_49231 = state_47275__$1;
(statearr_47311_49231[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (6))){
var inst_47251 = (state_47275[(11)]);
var inst_47195 = (state_47275[(8)]);
var inst_47249 = (state_47275[(7)]);
var inst_47249__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_47195) : topic_fn.call(null,inst_47195));
var inst_47250 = cljs.core.deref(mults);
var inst_47251__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47250,inst_47249__$1);
var state_47275__$1 = (function (){var statearr_47317 = state_47275;
(statearr_47317[(11)] = inst_47251__$1);

(statearr_47317[(7)] = inst_47249__$1);

return statearr_47317;
})();
if(cljs.core.truth_(inst_47251__$1)){
var statearr_47318_49232 = state_47275__$1;
(statearr_47318_49232[(1)] = (19));

} else {
var statearr_47320_49233 = state_47275__$1;
(statearr_47320_49233[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (25))){
var inst_47263 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
var statearr_47321_49234 = state_47275__$1;
(statearr_47321_49234[(2)] = inst_47263);

(statearr_47321_49234[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (17))){
var inst_47223 = (state_47275[(10)]);
var inst_47233 = cljs.core.first(inst_47223);
var inst_47234 = cljs.core.async.muxch_STAR_(inst_47233);
var inst_47235 = cljs.core.async.close_BANG_(inst_47234);
var inst_47236 = cljs.core.next(inst_47223);
var inst_47205 = inst_47236;
var inst_47206 = null;
var inst_47207 = (0);
var inst_47208 = (0);
var state_47275__$1 = (function (){var statearr_47327 = state_47275;
(statearr_47327[(12)] = inst_47208);

(statearr_47327[(13)] = inst_47235);

(statearr_47327[(14)] = inst_47207);

(statearr_47327[(15)] = inst_47205);

(statearr_47327[(16)] = inst_47206);

return statearr_47327;
})();
var statearr_47328_49235 = state_47275__$1;
(statearr_47328_49235[(2)] = null);

(statearr_47328_49235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (3))){
var inst_47272 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47275__$1,inst_47272);
} else {
if((state_val_47276 === (12))){
var inst_47244 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
var statearr_47330_49236 = state_47275__$1;
(statearr_47330_49236[(2)] = inst_47244);

(statearr_47330_49236[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (2))){
var state_47275__$1 = state_47275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47275__$1,(4),ch);
} else {
if((state_val_47276 === (23))){
var state_47275__$1 = state_47275;
var statearr_47334_49237 = state_47275__$1;
(statearr_47334_49237[(2)] = null);

(statearr_47334_49237[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (19))){
var inst_47251 = (state_47275[(11)]);
var inst_47195 = (state_47275[(8)]);
var inst_47255 = cljs.core.async.muxch_STAR_(inst_47251);
var state_47275__$1 = state_47275;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47275__$1,(22),inst_47255,inst_47195);
} else {
if((state_val_47276 === (11))){
var inst_47205 = (state_47275[(15)]);
var inst_47223 = (state_47275[(10)]);
var inst_47223__$1 = cljs.core.seq(inst_47205);
var state_47275__$1 = (function (){var statearr_47336 = state_47275;
(statearr_47336[(10)] = inst_47223__$1);

return statearr_47336;
})();
if(inst_47223__$1){
var statearr_47337_49240 = state_47275__$1;
(statearr_47337_49240[(1)] = (13));

} else {
var statearr_47338_49241 = state_47275__$1;
(statearr_47338_49241[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (9))){
var inst_47246 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
var statearr_47339_49242 = state_47275__$1;
(statearr_47339_49242[(2)] = inst_47246);

(statearr_47339_49242[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (5))){
var inst_47202 = cljs.core.deref(mults);
var inst_47203 = cljs.core.vals(inst_47202);
var inst_47204 = cljs.core.seq(inst_47203);
var inst_47205 = inst_47204;
var inst_47206 = null;
var inst_47207 = (0);
var inst_47208 = (0);
var state_47275__$1 = (function (){var statearr_47340 = state_47275;
(statearr_47340[(12)] = inst_47208);

(statearr_47340[(14)] = inst_47207);

(statearr_47340[(15)] = inst_47205);

(statearr_47340[(16)] = inst_47206);

return statearr_47340;
})();
var statearr_47341_49243 = state_47275__$1;
(statearr_47341_49243[(2)] = null);

(statearr_47341_49243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (14))){
var state_47275__$1 = state_47275;
var statearr_47345_49244 = state_47275__$1;
(statearr_47345_49244[(2)] = null);

(statearr_47345_49244[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (16))){
var inst_47223 = (state_47275[(10)]);
var inst_47228 = cljs.core.chunk_first(inst_47223);
var inst_47229 = cljs.core.chunk_rest(inst_47223);
var inst_47230 = cljs.core.count(inst_47228);
var inst_47205 = inst_47229;
var inst_47206 = inst_47228;
var inst_47207 = inst_47230;
var inst_47208 = (0);
var state_47275__$1 = (function (){var statearr_47354 = state_47275;
(statearr_47354[(12)] = inst_47208);

(statearr_47354[(14)] = inst_47207);

(statearr_47354[(15)] = inst_47205);

(statearr_47354[(16)] = inst_47206);

return statearr_47354;
})();
var statearr_47357_49247 = state_47275__$1;
(statearr_47357_49247[(2)] = null);

(statearr_47357_49247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (10))){
var inst_47208 = (state_47275[(12)]);
var inst_47207 = (state_47275[(14)]);
var inst_47205 = (state_47275[(15)]);
var inst_47206 = (state_47275[(16)]);
var inst_47213 = cljs.core._nth(inst_47206,inst_47208);
var inst_47215 = cljs.core.async.muxch_STAR_(inst_47213);
var inst_47216 = cljs.core.async.close_BANG_(inst_47215);
var inst_47217 = (inst_47208 + (1));
var tmp47342 = inst_47207;
var tmp47343 = inst_47205;
var tmp47344 = inst_47206;
var inst_47205__$1 = tmp47343;
var inst_47206__$1 = tmp47344;
var inst_47207__$1 = tmp47342;
var inst_47208__$1 = inst_47217;
var state_47275__$1 = (function (){var statearr_47375 = state_47275;
(statearr_47375[(12)] = inst_47208__$1);

(statearr_47375[(14)] = inst_47207__$1);

(statearr_47375[(15)] = inst_47205__$1);

(statearr_47375[(16)] = inst_47206__$1);

(statearr_47375[(17)] = inst_47216);

return statearr_47375;
})();
var statearr_47380_49249 = state_47275__$1;
(statearr_47380_49249[(2)] = null);

(statearr_47380_49249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (18))){
var inst_47239 = (state_47275[(2)]);
var state_47275__$1 = state_47275;
var statearr_47382_49250 = state_47275__$1;
(statearr_47382_49250[(2)] = inst_47239);

(statearr_47382_49250[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47276 === (8))){
var inst_47208 = (state_47275[(12)]);
var inst_47207 = (state_47275[(14)]);
var inst_47210 = (inst_47208 < inst_47207);
var inst_47211 = inst_47210;
var state_47275__$1 = state_47275;
if(cljs.core.truth_(inst_47211)){
var statearr_47384_49251 = state_47275__$1;
(statearr_47384_49251[(1)] = (10));

} else {
var statearr_47385_49252 = state_47275__$1;
(statearr_47385_49252[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_47389 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47389[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_47389[(1)] = (1));

return statearr_47389;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_47275){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_47275);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e47390){var ex__44116__auto__ = e47390;
var statearr_47391_49253 = state_47275;
(statearr_47391_49253[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_47275[(4)]))){
var statearr_47392_49254 = state_47275;
(statearr_47392_49254[(1)] = cljs.core.first((state_47275[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49255 = state_47275;
state_47275 = G__49255;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_47275){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_47275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_47395 = f__44848__auto__();
(statearr_47395[(6)] = c__44847__auto___49217);

return statearr_47395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__47406 = arguments.length;
switch (G__47406) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__47431 = arguments.length;
switch (G__47431) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__47448 = arguments.length;
switch (G__47448) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__44847__auto___49264 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_47533){
var state_val_47534 = (state_47533[(1)]);
if((state_val_47534 === (7))){
var state_47533__$1 = state_47533;
var statearr_47535_49265 = state_47533__$1;
(statearr_47535_49265[(2)] = null);

(statearr_47535_49265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (1))){
var state_47533__$1 = state_47533;
var statearr_47536_49266 = state_47533__$1;
(statearr_47536_49266[(2)] = null);

(statearr_47536_49266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (4))){
var inst_47476 = (state_47533[(7)]);
var inst_47475 = (state_47533[(8)]);
var inst_47478 = (inst_47476 < inst_47475);
var state_47533__$1 = state_47533;
if(cljs.core.truth_(inst_47478)){
var statearr_47537_49267 = state_47533__$1;
(statearr_47537_49267[(1)] = (6));

} else {
var statearr_47538_49268 = state_47533__$1;
(statearr_47538_49268[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (15))){
var inst_47519 = (state_47533[(9)]);
var inst_47524 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_47519);
var state_47533__$1 = state_47533;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47533__$1,(17),out,inst_47524);
} else {
if((state_val_47534 === (13))){
var inst_47519 = (state_47533[(9)]);
var inst_47519__$1 = (state_47533[(2)]);
var inst_47520 = cljs.core.some(cljs.core.nil_QMARK_,inst_47519__$1);
var state_47533__$1 = (function (){var statearr_47552 = state_47533;
(statearr_47552[(9)] = inst_47519__$1);

return statearr_47552;
})();
if(cljs.core.truth_(inst_47520)){
var statearr_47559_49269 = state_47533__$1;
(statearr_47559_49269[(1)] = (14));

} else {
var statearr_47560_49270 = state_47533__$1;
(statearr_47560_49270[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (6))){
var state_47533__$1 = state_47533;
var statearr_47561_49271 = state_47533__$1;
(statearr_47561_49271[(2)] = null);

(statearr_47561_49271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (17))){
var inst_47526 = (state_47533[(2)]);
var state_47533__$1 = (function (){var statearr_47578 = state_47533;
(statearr_47578[(10)] = inst_47526);

return statearr_47578;
})();
var statearr_47582_49272 = state_47533__$1;
(statearr_47582_49272[(2)] = null);

(statearr_47582_49272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (3))){
var inst_47531 = (state_47533[(2)]);
var state_47533__$1 = state_47533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47533__$1,inst_47531);
} else {
if((state_val_47534 === (12))){
var _ = (function (){var statearr_47611 = state_47533;
(statearr_47611[(4)] = cljs.core.rest((state_47533[(4)])));

return statearr_47611;
})();
var state_47533__$1 = state_47533;
var ex47577 = (state_47533__$1[(2)]);
var statearr_47612_49273 = state_47533__$1;
(statearr_47612_49273[(5)] = ex47577);


if((ex47577 instanceof Object)){
var statearr_47613_49274 = state_47533__$1;
(statearr_47613_49274[(1)] = (11));

(statearr_47613_49274[(5)] = null);

} else {
throw ex47577;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (2))){
var inst_47474 = cljs.core.reset_BANG_(dctr,cnt);
var inst_47475 = cnt;
var inst_47476 = (0);
var state_47533__$1 = (function (){var statearr_47623 = state_47533;
(statearr_47623[(7)] = inst_47476);

(statearr_47623[(11)] = inst_47474);

(statearr_47623[(8)] = inst_47475);

return statearr_47623;
})();
var statearr_47625_49279 = state_47533__$1;
(statearr_47625_49279[(2)] = null);

(statearr_47625_49279[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (11))){
var inst_47494 = (state_47533[(2)]);
var inst_47495 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_47533__$1 = (function (){var statearr_47626 = state_47533;
(statearr_47626[(12)] = inst_47494);

return statearr_47626;
})();
var statearr_47627_49284 = state_47533__$1;
(statearr_47627_49284[(2)] = inst_47495);

(statearr_47627_49284[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (9))){
var inst_47476 = (state_47533[(7)]);
var _ = (function (){var statearr_47628 = state_47533;
(statearr_47628[(4)] = cljs.core.cons((12),(state_47533[(4)])));

return statearr_47628;
})();
var inst_47502 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_47476) : chs__$1.call(null,inst_47476));
var inst_47503 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_47476) : done.call(null,inst_47476));
var inst_47504 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_47502,inst_47503);
var ___$1 = (function (){var statearr_47629 = state_47533;
(statearr_47629[(4)] = cljs.core.rest((state_47533[(4)])));

return statearr_47629;
})();
var state_47533__$1 = state_47533;
var statearr_47630_49292 = state_47533__$1;
(statearr_47630_49292[(2)] = inst_47504);

(statearr_47630_49292[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (5))){
var inst_47514 = (state_47533[(2)]);
var state_47533__$1 = (function (){var statearr_47631 = state_47533;
(statearr_47631[(13)] = inst_47514);

return statearr_47631;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47533__$1,(13),dchan);
} else {
if((state_val_47534 === (14))){
var inst_47522 = cljs.core.async.close_BANG_(out);
var state_47533__$1 = state_47533;
var statearr_47633_49293 = state_47533__$1;
(statearr_47633_49293[(2)] = inst_47522);

(statearr_47633_49293[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (16))){
var inst_47529 = (state_47533[(2)]);
var state_47533__$1 = state_47533;
var statearr_47637_49294 = state_47533__$1;
(statearr_47637_49294[(2)] = inst_47529);

(statearr_47637_49294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (10))){
var inst_47476 = (state_47533[(7)]);
var inst_47507 = (state_47533[(2)]);
var inst_47508 = (inst_47476 + (1));
var inst_47476__$1 = inst_47508;
var state_47533__$1 = (function (){var statearr_47640 = state_47533;
(statearr_47640[(7)] = inst_47476__$1);

(statearr_47640[(14)] = inst_47507);

return statearr_47640;
})();
var statearr_47642_49298 = state_47533__$1;
(statearr_47642_49298[(2)] = null);

(statearr_47642_49298[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47534 === (8))){
var inst_47512 = (state_47533[(2)]);
var state_47533__$1 = state_47533;
var statearr_47645_49299 = state_47533__$1;
(statearr_47645_49299[(2)] = inst_47512);

(statearr_47645_49299[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_47647 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47647[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_47647[(1)] = (1));

return statearr_47647;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_47533){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_47533);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e47650){var ex__44116__auto__ = e47650;
var statearr_47651_49303 = state_47533;
(statearr_47651_49303[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_47533[(4)]))){
var statearr_47652_49304 = state_47533;
(statearr_47652_49304[(1)] = cljs.core.first((state_47533[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49305 = state_47533;
state_47533 = G__49305;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_47533){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_47533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_47653 = f__44848__auto__();
(statearr_47653[(6)] = c__44847__auto___49264);

return statearr_47653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__47656 = arguments.length;
switch (G__47656) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44847__auto___49310 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_47701){
var state_val_47703 = (state_47701[(1)]);
if((state_val_47703 === (7))){
var inst_47676 = (state_47701[(7)]);
var inst_47677 = (state_47701[(8)]);
var inst_47676__$1 = (state_47701[(2)]);
var inst_47677__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47676__$1,(0),null);
var inst_47678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47676__$1,(1),null);
var inst_47679 = (inst_47677__$1 == null);
var state_47701__$1 = (function (){var statearr_47709 = state_47701;
(statearr_47709[(9)] = inst_47678);

(statearr_47709[(7)] = inst_47676__$1);

(statearr_47709[(8)] = inst_47677__$1);

return statearr_47709;
})();
if(cljs.core.truth_(inst_47679)){
var statearr_47713_49315 = state_47701__$1;
(statearr_47713_49315[(1)] = (8));

} else {
var statearr_47715_49316 = state_47701__$1;
(statearr_47715_49316[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (1))){
var inst_47664 = cljs.core.vec(chs);
var inst_47665 = inst_47664;
var state_47701__$1 = (function (){var statearr_47719 = state_47701;
(statearr_47719[(10)] = inst_47665);

return statearr_47719;
})();
var statearr_47720_49317 = state_47701__$1;
(statearr_47720_49317[(2)] = null);

(statearr_47720_49317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (4))){
var inst_47665 = (state_47701[(10)]);
var state_47701__$1 = state_47701;
return cljs.core.async.ioc_alts_BANG_(state_47701__$1,(7),inst_47665);
} else {
if((state_val_47703 === (6))){
var inst_47697 = (state_47701[(2)]);
var state_47701__$1 = state_47701;
var statearr_47723_49318 = state_47701__$1;
(statearr_47723_49318[(2)] = inst_47697);

(statearr_47723_49318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (3))){
var inst_47699 = (state_47701[(2)]);
var state_47701__$1 = state_47701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47701__$1,inst_47699);
} else {
if((state_val_47703 === (2))){
var inst_47665 = (state_47701[(10)]);
var inst_47667 = cljs.core.count(inst_47665);
var inst_47668 = (inst_47667 > (0));
var state_47701__$1 = state_47701;
if(cljs.core.truth_(inst_47668)){
var statearr_47725_49319 = state_47701__$1;
(statearr_47725_49319[(1)] = (4));

} else {
var statearr_47726_49320 = state_47701__$1;
(statearr_47726_49320[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (11))){
var inst_47665 = (state_47701[(10)]);
var inst_47690 = (state_47701[(2)]);
var tmp47724 = inst_47665;
var inst_47665__$1 = tmp47724;
var state_47701__$1 = (function (){var statearr_47730 = state_47701;
(statearr_47730[(10)] = inst_47665__$1);

(statearr_47730[(11)] = inst_47690);

return statearr_47730;
})();
var statearr_47731_49321 = state_47701__$1;
(statearr_47731_49321[(2)] = null);

(statearr_47731_49321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (9))){
var inst_47677 = (state_47701[(8)]);
var state_47701__$1 = state_47701;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47701__$1,(11),out,inst_47677);
} else {
if((state_val_47703 === (5))){
var inst_47695 = cljs.core.async.close_BANG_(out);
var state_47701__$1 = state_47701;
var statearr_47743_49322 = state_47701__$1;
(statearr_47743_49322[(2)] = inst_47695);

(statearr_47743_49322[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (10))){
var inst_47693 = (state_47701[(2)]);
var state_47701__$1 = state_47701;
var statearr_47744_49323 = state_47701__$1;
(statearr_47744_49323[(2)] = inst_47693);

(statearr_47744_49323[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47703 === (8))){
var inst_47665 = (state_47701[(10)]);
var inst_47678 = (state_47701[(9)]);
var inst_47676 = (state_47701[(7)]);
var inst_47677 = (state_47701[(8)]);
var inst_47685 = (function (){var cs = inst_47665;
var vec__47672 = inst_47676;
var v = inst_47677;
var c = inst_47678;
return (function (p1__47654_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__47654_SHARP_);
});
})();
var inst_47686 = cljs.core.filterv(inst_47685,inst_47665);
var inst_47665__$1 = inst_47686;
var state_47701__$1 = (function (){var statearr_47748 = state_47701;
(statearr_47748[(10)] = inst_47665__$1);

return statearr_47748;
})();
var statearr_47753_49324 = state_47701__$1;
(statearr_47753_49324[(2)] = null);

(statearr_47753_49324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_47774 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47774[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_47774[(1)] = (1));

return statearr_47774;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_47701){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_47701);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e47790){var ex__44116__auto__ = e47790;
var statearr_47793_49327 = state_47701;
(statearr_47793_49327[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_47701[(4)]))){
var statearr_47804_49328 = state_47701;
(statearr_47804_49328[(1)] = cljs.core.first((state_47701[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49329 = state_47701;
state_47701 = G__49329;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_47701){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_47701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_47808 = f__44848__auto__();
(statearr_47808[(6)] = c__44847__auto___49310);

return statearr_47808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__47819 = arguments.length;
switch (G__47819) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44847__auto___49333 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_47852){
var state_val_47853 = (state_47852[(1)]);
if((state_val_47853 === (7))){
var inst_47834 = (state_47852[(7)]);
var inst_47834__$1 = (state_47852[(2)]);
var inst_47835 = (inst_47834__$1 == null);
var inst_47836 = cljs.core.not(inst_47835);
var state_47852__$1 = (function (){var statearr_47866 = state_47852;
(statearr_47866[(7)] = inst_47834__$1);

return statearr_47866;
})();
if(inst_47836){
var statearr_47867_49334 = state_47852__$1;
(statearr_47867_49334[(1)] = (8));

} else {
var statearr_47868_49335 = state_47852__$1;
(statearr_47868_49335[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (1))){
var inst_47828 = (0);
var state_47852__$1 = (function (){var statearr_47870 = state_47852;
(statearr_47870[(8)] = inst_47828);

return statearr_47870;
})();
var statearr_47875_49336 = state_47852__$1;
(statearr_47875_49336[(2)] = null);

(statearr_47875_49336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (4))){
var state_47852__$1 = state_47852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47852__$1,(7),ch);
} else {
if((state_val_47853 === (6))){
var inst_47847 = (state_47852[(2)]);
var state_47852__$1 = state_47852;
var statearr_47880_49341 = state_47852__$1;
(statearr_47880_49341[(2)] = inst_47847);

(statearr_47880_49341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (3))){
var inst_47849 = (state_47852[(2)]);
var inst_47850 = cljs.core.async.close_BANG_(out);
var state_47852__$1 = (function (){var statearr_47884 = state_47852;
(statearr_47884[(9)] = inst_47849);

return statearr_47884;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47852__$1,inst_47850);
} else {
if((state_val_47853 === (2))){
var inst_47828 = (state_47852[(8)]);
var inst_47831 = (inst_47828 < n);
var state_47852__$1 = state_47852;
if(cljs.core.truth_(inst_47831)){
var statearr_47886_49342 = state_47852__$1;
(statearr_47886_49342[(1)] = (4));

} else {
var statearr_47888_49343 = state_47852__$1;
(statearr_47888_49343[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (11))){
var inst_47828 = (state_47852[(8)]);
var inst_47839 = (state_47852[(2)]);
var inst_47840 = (inst_47828 + (1));
var inst_47828__$1 = inst_47840;
var state_47852__$1 = (function (){var statearr_47893 = state_47852;
(statearr_47893[(8)] = inst_47828__$1);

(statearr_47893[(10)] = inst_47839);

return statearr_47893;
})();
var statearr_47894_49345 = state_47852__$1;
(statearr_47894_49345[(2)] = null);

(statearr_47894_49345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (9))){
var state_47852__$1 = state_47852;
var statearr_47896_49346 = state_47852__$1;
(statearr_47896_49346[(2)] = null);

(statearr_47896_49346[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (5))){
var state_47852__$1 = state_47852;
var statearr_47897_49347 = state_47852__$1;
(statearr_47897_49347[(2)] = null);

(statearr_47897_49347[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (10))){
var inst_47844 = (state_47852[(2)]);
var state_47852__$1 = state_47852;
var statearr_47898_49349 = state_47852__$1;
(statearr_47898_49349[(2)] = inst_47844);

(statearr_47898_49349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (8))){
var inst_47834 = (state_47852[(7)]);
var state_47852__$1 = state_47852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47852__$1,(11),out,inst_47834);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_47899 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47899[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_47899[(1)] = (1));

return statearr_47899;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_47852){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_47852);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e47900){var ex__44116__auto__ = e47900;
var statearr_47901_49351 = state_47852;
(statearr_47901_49351[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_47852[(4)]))){
var statearr_47902_49352 = state_47852;
(statearr_47902_49352[(1)] = cljs.core.first((state_47852[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49353 = state_47852;
state_47852 = G__49353;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_47852){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_47852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_47904 = f__44848__auto__();
(statearr_47904[(6)] = c__44847__auto___49333);

return statearr_47904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47908 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47908 = (function (f,ch,meta47909){
this.f = f;
this.ch = ch;
this.meta47909 = meta47909;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47910,meta47909__$1){
var self__ = this;
var _47910__$1 = this;
return (new cljs.core.async.t_cljs$core$async47908(self__.f,self__.ch,meta47909__$1));
}));

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47910){
var self__ = this;
var _47910__$1 = this;
return self__.meta47909;
}));

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47916 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47916 = (function (f,ch,meta47909,_,fn1,meta47917){
this.f = f;
this.ch = ch;
this.meta47909 = meta47909;
this._ = _;
this.fn1 = fn1;
this.meta47917 = meta47917;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47916.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47918,meta47917__$1){
var self__ = this;
var _47918__$1 = this;
return (new cljs.core.async.t_cljs$core$async47916(self__.f,self__.ch,self__.meta47909,self__._,self__.fn1,meta47917__$1));
}));

(cljs.core.async.t_cljs$core$async47916.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47918){
var self__ = this;
var _47918__$1 = this;
return self__.meta47917;
}));

(cljs.core.async.t_cljs$core$async47916.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47916.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47916.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47916.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47907_SHARP_){
var G__47930 = (((p1__47907_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47907_SHARP_) : self__.f.call(null,p1__47907_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47930) : f1.call(null,G__47930));
});
}));

(cljs.core.async.t_cljs$core$async47916.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47909","meta47909",1290057016,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47908","cljs.core.async/t_cljs$core$async47908",-1502206278,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47917","meta47917",-1526790139,null)], null);
}));

(cljs.core.async.t_cljs$core$async47916.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47916.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47916");

(cljs.core.async.t_cljs$core$async47916.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47916");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47916.
 */
cljs.core.async.__GT_t_cljs$core$async47916 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47916(f__$1,ch__$1,meta47909__$1,___$2,fn1__$1,meta47917){
return (new cljs.core.async.t_cljs$core$async47916(f__$1,ch__$1,meta47909__$1,___$2,fn1__$1,meta47917));
});

}

return (new cljs.core.async.t_cljs$core$async47916(self__.f,self__.ch,self__.meta47909,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47934 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47934) : self__.f.call(null,G__47934));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47908.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47908.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47909","meta47909",1290057016,null)], null);
}));

(cljs.core.async.t_cljs$core$async47908.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47908.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47908");

(cljs.core.async.t_cljs$core$async47908.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47908");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47908.
 */
cljs.core.async.__GT_t_cljs$core$async47908 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47908(f__$1,ch__$1,meta47909){
return (new cljs.core.async.t_cljs$core$async47908(f__$1,ch__$1,meta47909));
});

}

return (new cljs.core.async.t_cljs$core$async47908(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47940 = (function (f,ch,meta47941){
this.f = f;
this.ch = ch;
this.meta47941 = meta47941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47942,meta47941__$1){
var self__ = this;
var _47942__$1 = this;
return (new cljs.core.async.t_cljs$core$async47940(self__.f,self__.ch,meta47941__$1));
}));

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47942){
var self__ = this;
var _47942__$1 = this;
return self__.meta47941;
}));

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47940.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47941","meta47941",1328846793,null)], null);
}));

(cljs.core.async.t_cljs$core$async47940.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47940");

(cljs.core.async.t_cljs$core$async47940.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47940");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47940.
 */
cljs.core.async.__GT_t_cljs$core$async47940 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47940(f__$1,ch__$1,meta47941){
return (new cljs.core.async.t_cljs$core$async47940(f__$1,ch__$1,meta47941));
});

}

return (new cljs.core.async.t_cljs$core$async47940(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47945 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47945 = (function (p,ch,meta47946){
this.p = p;
this.ch = ch;
this.meta47946 = meta47946;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47947,meta47946__$1){
var self__ = this;
var _47947__$1 = this;
return (new cljs.core.async.t_cljs$core$async47945(self__.p,self__.ch,meta47946__$1));
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47947){
var self__ = this;
var _47947__$1 = this;
return self__.meta47946;
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47945.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47946","meta47946",-389089895,null)], null);
}));

(cljs.core.async.t_cljs$core$async47945.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47945.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47945");

(cljs.core.async.t_cljs$core$async47945.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47945");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47945.
 */
cljs.core.async.__GT_t_cljs$core$async47945 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47945(p__$1,ch__$1,meta47946){
return (new cljs.core.async.t_cljs$core$async47945(p__$1,ch__$1,meta47946));
});

}

return (new cljs.core.async.t_cljs$core$async47945(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__47956 = arguments.length;
switch (G__47956) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44847__auto___49401 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_47977){
var state_val_47978 = (state_47977[(1)]);
if((state_val_47978 === (7))){
var inst_47973 = (state_47977[(2)]);
var state_47977__$1 = state_47977;
var statearr_47980_49402 = state_47977__$1;
(statearr_47980_49402[(2)] = inst_47973);

(statearr_47980_49402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (1))){
var state_47977__$1 = state_47977;
var statearr_47981_49404 = state_47977__$1;
(statearr_47981_49404[(2)] = null);

(statearr_47981_49404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (4))){
var inst_47959 = (state_47977[(7)]);
var inst_47959__$1 = (state_47977[(2)]);
var inst_47960 = (inst_47959__$1 == null);
var state_47977__$1 = (function (){var statearr_47982 = state_47977;
(statearr_47982[(7)] = inst_47959__$1);

return statearr_47982;
})();
if(cljs.core.truth_(inst_47960)){
var statearr_47983_49405 = state_47977__$1;
(statearr_47983_49405[(1)] = (5));

} else {
var statearr_47984_49406 = state_47977__$1;
(statearr_47984_49406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (6))){
var inst_47959 = (state_47977[(7)]);
var inst_47964 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47959) : p.call(null,inst_47959));
var state_47977__$1 = state_47977;
if(cljs.core.truth_(inst_47964)){
var statearr_47985_49407 = state_47977__$1;
(statearr_47985_49407[(1)] = (8));

} else {
var statearr_47986_49408 = state_47977__$1;
(statearr_47986_49408[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (3))){
var inst_47975 = (state_47977[(2)]);
var state_47977__$1 = state_47977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47977__$1,inst_47975);
} else {
if((state_val_47978 === (2))){
var state_47977__$1 = state_47977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47977__$1,(4),ch);
} else {
if((state_val_47978 === (11))){
var inst_47967 = (state_47977[(2)]);
var state_47977__$1 = state_47977;
var statearr_47987_49409 = state_47977__$1;
(statearr_47987_49409[(2)] = inst_47967);

(statearr_47987_49409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (9))){
var state_47977__$1 = state_47977;
var statearr_47988_49410 = state_47977__$1;
(statearr_47988_49410[(2)] = null);

(statearr_47988_49410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (5))){
var inst_47962 = cljs.core.async.close_BANG_(out);
var state_47977__$1 = state_47977;
var statearr_47997_49411 = state_47977__$1;
(statearr_47997_49411[(2)] = inst_47962);

(statearr_47997_49411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (10))){
var inst_47970 = (state_47977[(2)]);
var state_47977__$1 = (function (){var statearr_48004 = state_47977;
(statearr_48004[(8)] = inst_47970);

return statearr_48004;
})();
var statearr_48005_49412 = state_47977__$1;
(statearr_48005_49412[(2)] = null);

(statearr_48005_49412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47978 === (8))){
var inst_47959 = (state_47977[(7)]);
var state_47977__$1 = state_47977;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47977__$1,(11),out,inst_47959);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_48012 = [null,null,null,null,null,null,null,null,null];
(statearr_48012[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_48012[(1)] = (1));

return statearr_48012;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_47977){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_47977);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e48013){var ex__44116__auto__ = e48013;
var statearr_48014_49413 = state_47977;
(statearr_48014_49413[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_47977[(4)]))){
var statearr_48015_49414 = state_47977;
(statearr_48015_49414[(1)] = cljs.core.first((state_47977[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49415 = state_47977;
state_47977 = G__49415;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_47977){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_47977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_48030 = f__44848__auto__();
(statearr_48030[(6)] = c__44847__auto___49401);

return statearr_48030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48038 = arguments.length;
switch (G__48038) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44847__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_48108){
var state_val_48109 = (state_48108[(1)]);
if((state_val_48109 === (7))){
var inst_48104 = (state_48108[(2)]);
var state_48108__$1 = state_48108;
var statearr_48116_49434 = state_48108__$1;
(statearr_48116_49434[(2)] = inst_48104);

(statearr_48116_49434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (20))){
var inst_48071 = (state_48108[(7)]);
var inst_48085 = (state_48108[(2)]);
var inst_48086 = cljs.core.next(inst_48071);
var inst_48057 = inst_48086;
var inst_48058 = null;
var inst_48059 = (0);
var inst_48060 = (0);
var state_48108__$1 = (function (){var statearr_48119 = state_48108;
(statearr_48119[(8)] = inst_48057);

(statearr_48119[(9)] = inst_48058);

(statearr_48119[(10)] = inst_48085);

(statearr_48119[(11)] = inst_48059);

(statearr_48119[(12)] = inst_48060);

return statearr_48119;
})();
var statearr_48124_49436 = state_48108__$1;
(statearr_48124_49436[(2)] = null);

(statearr_48124_49436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (1))){
var state_48108__$1 = state_48108;
var statearr_48127_49437 = state_48108__$1;
(statearr_48127_49437[(2)] = null);

(statearr_48127_49437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (4))){
var inst_48045 = (state_48108[(13)]);
var inst_48045__$1 = (state_48108[(2)]);
var inst_48046 = (inst_48045__$1 == null);
var state_48108__$1 = (function (){var statearr_48130 = state_48108;
(statearr_48130[(13)] = inst_48045__$1);

return statearr_48130;
})();
if(cljs.core.truth_(inst_48046)){
var statearr_48131_49445 = state_48108__$1;
(statearr_48131_49445[(1)] = (5));

} else {
var statearr_48133_49449 = state_48108__$1;
(statearr_48133_49449[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (15))){
var state_48108__$1 = state_48108;
var statearr_48139_49450 = state_48108__$1;
(statearr_48139_49450[(2)] = null);

(statearr_48139_49450[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (21))){
var state_48108__$1 = state_48108;
var statearr_48140_49451 = state_48108__$1;
(statearr_48140_49451[(2)] = null);

(statearr_48140_49451[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (13))){
var inst_48057 = (state_48108[(8)]);
var inst_48058 = (state_48108[(9)]);
var inst_48059 = (state_48108[(11)]);
var inst_48060 = (state_48108[(12)]);
var inst_48067 = (state_48108[(2)]);
var inst_48068 = (inst_48060 + (1));
var tmp48136 = inst_48057;
var tmp48137 = inst_48058;
var tmp48138 = inst_48059;
var inst_48057__$1 = tmp48136;
var inst_48058__$1 = tmp48137;
var inst_48059__$1 = tmp48138;
var inst_48060__$1 = inst_48068;
var state_48108__$1 = (function (){var statearr_48147 = state_48108;
(statearr_48147[(8)] = inst_48057__$1);

(statearr_48147[(14)] = inst_48067);

(statearr_48147[(9)] = inst_48058__$1);

(statearr_48147[(11)] = inst_48059__$1);

(statearr_48147[(12)] = inst_48060__$1);

return statearr_48147;
})();
var statearr_48152_49463 = state_48108__$1;
(statearr_48152_49463[(2)] = null);

(statearr_48152_49463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (22))){
var state_48108__$1 = state_48108;
var statearr_48156_49467 = state_48108__$1;
(statearr_48156_49467[(2)] = null);

(statearr_48156_49467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (6))){
var inst_48045 = (state_48108[(13)]);
var inst_48055 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48045) : f.call(null,inst_48045));
var inst_48056 = cljs.core.seq(inst_48055);
var inst_48057 = inst_48056;
var inst_48058 = null;
var inst_48059 = (0);
var inst_48060 = (0);
var state_48108__$1 = (function (){var statearr_48160 = state_48108;
(statearr_48160[(8)] = inst_48057);

(statearr_48160[(9)] = inst_48058);

(statearr_48160[(11)] = inst_48059);

(statearr_48160[(12)] = inst_48060);

return statearr_48160;
})();
var statearr_48165_49468 = state_48108__$1;
(statearr_48165_49468[(2)] = null);

(statearr_48165_49468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (17))){
var inst_48071 = (state_48108[(7)]);
var inst_48075 = cljs.core.chunk_first(inst_48071);
var inst_48076 = cljs.core.chunk_rest(inst_48071);
var inst_48077 = cljs.core.count(inst_48075);
var inst_48057 = inst_48076;
var inst_48058 = inst_48075;
var inst_48059 = inst_48077;
var inst_48060 = (0);
var state_48108__$1 = (function (){var statearr_48166 = state_48108;
(statearr_48166[(8)] = inst_48057);

(statearr_48166[(9)] = inst_48058);

(statearr_48166[(11)] = inst_48059);

(statearr_48166[(12)] = inst_48060);

return statearr_48166;
})();
var statearr_48169_49484 = state_48108__$1;
(statearr_48169_49484[(2)] = null);

(statearr_48169_49484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (3))){
var inst_48106 = (state_48108[(2)]);
var state_48108__$1 = state_48108;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48108__$1,inst_48106);
} else {
if((state_val_48109 === (12))){
var inst_48094 = (state_48108[(2)]);
var state_48108__$1 = state_48108;
var statearr_48174_49494 = state_48108__$1;
(statearr_48174_49494[(2)] = inst_48094);

(statearr_48174_49494[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (2))){
var state_48108__$1 = state_48108;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48108__$1,(4),in$);
} else {
if((state_val_48109 === (23))){
var inst_48102 = (state_48108[(2)]);
var state_48108__$1 = state_48108;
var statearr_48179_49495 = state_48108__$1;
(statearr_48179_49495[(2)] = inst_48102);

(statearr_48179_49495[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (19))){
var inst_48089 = (state_48108[(2)]);
var state_48108__$1 = state_48108;
var statearr_48182_49500 = state_48108__$1;
(statearr_48182_49500[(2)] = inst_48089);

(statearr_48182_49500[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (11))){
var inst_48071 = (state_48108[(7)]);
var inst_48057 = (state_48108[(8)]);
var inst_48071__$1 = cljs.core.seq(inst_48057);
var state_48108__$1 = (function (){var statearr_48188 = state_48108;
(statearr_48188[(7)] = inst_48071__$1);

return statearr_48188;
})();
if(inst_48071__$1){
var statearr_48191_49506 = state_48108__$1;
(statearr_48191_49506[(1)] = (14));

} else {
var statearr_48195_49507 = state_48108__$1;
(statearr_48195_49507[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (9))){
var inst_48096 = (state_48108[(2)]);
var inst_48097 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48108__$1 = (function (){var statearr_48204 = state_48108;
(statearr_48204[(15)] = inst_48096);

return statearr_48204;
})();
if(cljs.core.truth_(inst_48097)){
var statearr_48207_49508 = state_48108__$1;
(statearr_48207_49508[(1)] = (21));

} else {
var statearr_48211_49509 = state_48108__$1;
(statearr_48211_49509[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (5))){
var inst_48049 = cljs.core.async.close_BANG_(out);
var state_48108__$1 = state_48108;
var statearr_48224_49510 = state_48108__$1;
(statearr_48224_49510[(2)] = inst_48049);

(statearr_48224_49510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (14))){
var inst_48071 = (state_48108[(7)]);
var inst_48073 = cljs.core.chunked_seq_QMARK_(inst_48071);
var state_48108__$1 = state_48108;
if(inst_48073){
var statearr_48238_49516 = state_48108__$1;
(statearr_48238_49516[(1)] = (17));

} else {
var statearr_48239_49517 = state_48108__$1;
(statearr_48239_49517[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (16))){
var inst_48092 = (state_48108[(2)]);
var state_48108__$1 = state_48108;
var statearr_48243_49525 = state_48108__$1;
(statearr_48243_49525[(2)] = inst_48092);

(statearr_48243_49525[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48109 === (10))){
var inst_48058 = (state_48108[(9)]);
var inst_48060 = (state_48108[(12)]);
var inst_48065 = cljs.core._nth(inst_48058,inst_48060);
var state_48108__$1 = state_48108;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48108__$1,(13),out,inst_48065);
} else {
if((state_val_48109 === (18))){
var inst_48071 = (state_48108[(7)]);
var inst_48083 = cljs.core.first(inst_48071);
var state_48108__$1 = state_48108;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48108__$1,(20),out,inst_48083);
} else {
if((state_val_48109 === (8))){
var inst_48059 = (state_48108[(11)]);
var inst_48060 = (state_48108[(12)]);
var inst_48062 = (inst_48060 < inst_48059);
var inst_48063 = inst_48062;
var state_48108__$1 = state_48108;
if(cljs.core.truth_(inst_48063)){
var statearr_48248_49537 = state_48108__$1;
(statearr_48248_49537[(1)] = (10));

} else {
var statearr_48251_49542 = state_48108__$1;
(statearr_48251_49542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__44113__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__44113__auto____0 = (function (){
var statearr_48258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48258[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__44113__auto__);

(statearr_48258[(1)] = (1));

return statearr_48258;
});
var cljs$core$async$mapcat_STAR__$_state_machine__44113__auto____1 = (function (state_48108){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_48108);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e48262){var ex__44116__auto__ = e48262;
var statearr_48264_49545 = state_48108;
(statearr_48264_49545[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_48108[(4)]))){
var statearr_48265_49551 = state_48108;
(statearr_48265_49551[(1)] = cljs.core.first((state_48108[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49552 = state_48108;
state_48108 = G__49552;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__44113__auto__ = function(state_48108){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__44113__auto____1.call(this,state_48108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__44113__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__44113__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_48266 = f__44848__auto__();
(statearr_48266[(6)] = c__44847__auto__);

return statearr_48266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));

return c__44847__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48273 = arguments.length;
switch (G__48273) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__48289 = arguments.length;
switch (G__48289) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__48311 = arguments.length;
switch (G__48311) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44847__auto___49570 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_48348){
var state_val_48349 = (state_48348[(1)]);
if((state_val_48349 === (7))){
var inst_48342 = (state_48348[(2)]);
var state_48348__$1 = state_48348;
var statearr_48352_49571 = state_48348__$1;
(statearr_48352_49571[(2)] = inst_48342);

(statearr_48352_49571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (1))){
var inst_48321 = null;
var state_48348__$1 = (function (){var statearr_48357 = state_48348;
(statearr_48357[(7)] = inst_48321);

return statearr_48357;
})();
var statearr_48360_49572 = state_48348__$1;
(statearr_48360_49572[(2)] = null);

(statearr_48360_49572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (4))){
var inst_48325 = (state_48348[(8)]);
var inst_48325__$1 = (state_48348[(2)]);
var inst_48326 = (inst_48325__$1 == null);
var inst_48328 = cljs.core.not(inst_48326);
var state_48348__$1 = (function (){var statearr_48365 = state_48348;
(statearr_48365[(8)] = inst_48325__$1);

return statearr_48365;
})();
if(inst_48328){
var statearr_48366_49574 = state_48348__$1;
(statearr_48366_49574[(1)] = (5));

} else {
var statearr_48369_49575 = state_48348__$1;
(statearr_48369_49575[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (6))){
var state_48348__$1 = state_48348;
var statearr_48370_49579 = state_48348__$1;
(statearr_48370_49579[(2)] = null);

(statearr_48370_49579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (3))){
var inst_48344 = (state_48348[(2)]);
var inst_48345 = cljs.core.async.close_BANG_(out);
var state_48348__$1 = (function (){var statearr_48376 = state_48348;
(statearr_48376[(9)] = inst_48344);

return statearr_48376;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48348__$1,inst_48345);
} else {
if((state_val_48349 === (2))){
var state_48348__$1 = state_48348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48348__$1,(4),ch);
} else {
if((state_val_48349 === (11))){
var inst_48325 = (state_48348[(8)]);
var inst_48336 = (state_48348[(2)]);
var inst_48321 = inst_48325;
var state_48348__$1 = (function (){var statearr_48383 = state_48348;
(statearr_48383[(7)] = inst_48321);

(statearr_48383[(10)] = inst_48336);

return statearr_48383;
})();
var statearr_48386_49586 = state_48348__$1;
(statearr_48386_49586[(2)] = null);

(statearr_48386_49586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (9))){
var inst_48325 = (state_48348[(8)]);
var state_48348__$1 = state_48348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48348__$1,(11),out,inst_48325);
} else {
if((state_val_48349 === (5))){
var inst_48325 = (state_48348[(8)]);
var inst_48321 = (state_48348[(7)]);
var inst_48331 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48325,inst_48321);
var state_48348__$1 = state_48348;
if(inst_48331){
var statearr_48401_49587 = state_48348__$1;
(statearr_48401_49587[(1)] = (8));

} else {
var statearr_48404_49588 = state_48348__$1;
(statearr_48404_49588[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (10))){
var inst_48339 = (state_48348[(2)]);
var state_48348__$1 = state_48348;
var statearr_48409_49590 = state_48348__$1;
(statearr_48409_49590[(2)] = inst_48339);

(statearr_48409_49590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48349 === (8))){
var inst_48321 = (state_48348[(7)]);
var tmp48393 = inst_48321;
var inst_48321__$1 = tmp48393;
var state_48348__$1 = (function (){var statearr_48411 = state_48348;
(statearr_48411[(7)] = inst_48321__$1);

return statearr_48411;
})();
var statearr_48416_49591 = state_48348__$1;
(statearr_48416_49591[(2)] = null);

(statearr_48416_49591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_48423 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48423[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_48423[(1)] = (1));

return statearr_48423;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_48348){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_48348);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e48424){var ex__44116__auto__ = e48424;
var statearr_48425_49593 = state_48348;
(statearr_48425_49593[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_48348[(4)]))){
var statearr_48426_49595 = state_48348;
(statearr_48426_49595[(1)] = cljs.core.first((state_48348[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49596 = state_48348;
state_48348 = G__49596;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_48348){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_48348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_48437 = f__44848__auto__();
(statearr_48437[(6)] = c__44847__auto___49570);

return statearr_48437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__48454 = arguments.length;
switch (G__48454) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44847__auto___49600 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_48502){
var state_val_48503 = (state_48502[(1)]);
if((state_val_48503 === (7))){
var inst_48498 = (state_48502[(2)]);
var state_48502__$1 = state_48502;
var statearr_48506_49601 = state_48502__$1;
(statearr_48506_49601[(2)] = inst_48498);

(statearr_48506_49601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (1))){
var inst_48462 = (new Array(n));
var inst_48463 = inst_48462;
var inst_48464 = (0);
var state_48502__$1 = (function (){var statearr_48507 = state_48502;
(statearr_48507[(7)] = inst_48464);

(statearr_48507[(8)] = inst_48463);

return statearr_48507;
})();
var statearr_48512_49605 = state_48502__$1;
(statearr_48512_49605[(2)] = null);

(statearr_48512_49605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (4))){
var inst_48467 = (state_48502[(9)]);
var inst_48467__$1 = (state_48502[(2)]);
var inst_48468 = (inst_48467__$1 == null);
var inst_48469 = cljs.core.not(inst_48468);
var state_48502__$1 = (function (){var statearr_48521 = state_48502;
(statearr_48521[(9)] = inst_48467__$1);

return statearr_48521;
})();
if(inst_48469){
var statearr_48522_49606 = state_48502__$1;
(statearr_48522_49606[(1)] = (5));

} else {
var statearr_48523_49607 = state_48502__$1;
(statearr_48523_49607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (15))){
var inst_48492 = (state_48502[(2)]);
var state_48502__$1 = state_48502;
var statearr_48531_49608 = state_48502__$1;
(statearr_48531_49608[(2)] = inst_48492);

(statearr_48531_49608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (13))){
var state_48502__$1 = state_48502;
var statearr_48535_49609 = state_48502__$1;
(statearr_48535_49609[(2)] = null);

(statearr_48535_49609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (6))){
var inst_48464 = (state_48502[(7)]);
var inst_48488 = (inst_48464 > (0));
var state_48502__$1 = state_48502;
if(cljs.core.truth_(inst_48488)){
var statearr_48543_49610 = state_48502__$1;
(statearr_48543_49610[(1)] = (12));

} else {
var statearr_48544_49611 = state_48502__$1;
(statearr_48544_49611[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (3))){
var inst_48500 = (state_48502[(2)]);
var state_48502__$1 = state_48502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48502__$1,inst_48500);
} else {
if((state_val_48503 === (12))){
var inst_48463 = (state_48502[(8)]);
var inst_48490 = cljs.core.vec(inst_48463);
var state_48502__$1 = state_48502;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48502__$1,(15),out,inst_48490);
} else {
if((state_val_48503 === (2))){
var state_48502__$1 = state_48502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48502__$1,(4),ch);
} else {
if((state_val_48503 === (11))){
var inst_48482 = (state_48502[(2)]);
var inst_48483 = (new Array(n));
var inst_48463 = inst_48483;
var inst_48464 = (0);
var state_48502__$1 = (function (){var statearr_48547 = state_48502;
(statearr_48547[(7)] = inst_48464);

(statearr_48547[(8)] = inst_48463);

(statearr_48547[(10)] = inst_48482);

return statearr_48547;
})();
var statearr_48548_49613 = state_48502__$1;
(statearr_48548_49613[(2)] = null);

(statearr_48548_49613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (9))){
var inst_48463 = (state_48502[(8)]);
var inst_48480 = cljs.core.vec(inst_48463);
var state_48502__$1 = state_48502;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48502__$1,(11),out,inst_48480);
} else {
if((state_val_48503 === (5))){
var inst_48464 = (state_48502[(7)]);
var inst_48467 = (state_48502[(9)]);
var inst_48472 = (state_48502[(11)]);
var inst_48463 = (state_48502[(8)]);
var inst_48471 = (inst_48463[inst_48464] = inst_48467);
var inst_48472__$1 = (inst_48464 + (1));
var inst_48473 = (inst_48472__$1 < n);
var state_48502__$1 = (function (){var statearr_48549 = state_48502;
(statearr_48549[(11)] = inst_48472__$1);

(statearr_48549[(12)] = inst_48471);

return statearr_48549;
})();
if(cljs.core.truth_(inst_48473)){
var statearr_48550_49618 = state_48502__$1;
(statearr_48550_49618[(1)] = (8));

} else {
var statearr_48551_49619 = state_48502__$1;
(statearr_48551_49619[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (14))){
var inst_48495 = (state_48502[(2)]);
var inst_48496 = cljs.core.async.close_BANG_(out);
var state_48502__$1 = (function (){var statearr_48553 = state_48502;
(statearr_48553[(13)] = inst_48495);

return statearr_48553;
})();
var statearr_48554_49624 = state_48502__$1;
(statearr_48554_49624[(2)] = inst_48496);

(statearr_48554_49624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (10))){
var inst_48486 = (state_48502[(2)]);
var state_48502__$1 = state_48502;
var statearr_48555_49625 = state_48502__$1;
(statearr_48555_49625[(2)] = inst_48486);

(statearr_48555_49625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48503 === (8))){
var inst_48472 = (state_48502[(11)]);
var inst_48463 = (state_48502[(8)]);
var tmp48552 = inst_48463;
var inst_48463__$1 = tmp48552;
var inst_48464 = inst_48472;
var state_48502__$1 = (function (){var statearr_48556 = state_48502;
(statearr_48556[(7)] = inst_48464);

(statearr_48556[(8)] = inst_48463__$1);

return statearr_48556;
})();
var statearr_48557_49627 = state_48502__$1;
(statearr_48557_49627[(2)] = null);

(statearr_48557_49627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_48558 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48558[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_48558[(1)] = (1));

return statearr_48558;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_48502){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_48502);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e48559){var ex__44116__auto__ = e48559;
var statearr_48560_49631 = state_48502;
(statearr_48560_49631[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_48502[(4)]))){
var statearr_48561_49632 = state_48502;
(statearr_48561_49632[(1)] = cljs.core.first((state_48502[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49633 = state_48502;
state_48502 = G__49633;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_48502){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_48502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_48562 = f__44848__auto__();
(statearr_48562[(6)] = c__44847__auto___49600);

return statearr_48562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48564 = arguments.length;
switch (G__48564) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44847__auto___49654 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44848__auto__ = (function (){var switch__44112__auto__ = (function (state_48611){
var state_val_48612 = (state_48611[(1)]);
if((state_val_48612 === (7))){
var inst_48607 = (state_48611[(2)]);
var state_48611__$1 = state_48611;
var statearr_48624_49657 = state_48611__$1;
(statearr_48624_49657[(2)] = inst_48607);

(statearr_48624_49657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (1))){
var inst_48565 = [];
var inst_48566 = inst_48565;
var inst_48567 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48611__$1 = (function (){var statearr_48625 = state_48611;
(statearr_48625[(7)] = inst_48567);

(statearr_48625[(8)] = inst_48566);

return statearr_48625;
})();
var statearr_48626_49664 = state_48611__$1;
(statearr_48626_49664[(2)] = null);

(statearr_48626_49664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (4))){
var inst_48570 = (state_48611[(9)]);
var inst_48570__$1 = (state_48611[(2)]);
var inst_48571 = (inst_48570__$1 == null);
var inst_48572 = cljs.core.not(inst_48571);
var state_48611__$1 = (function (){var statearr_48627 = state_48611;
(statearr_48627[(9)] = inst_48570__$1);

return statearr_48627;
})();
if(inst_48572){
var statearr_48629_49669 = state_48611__$1;
(statearr_48629_49669[(1)] = (5));

} else {
var statearr_48630_49670 = state_48611__$1;
(statearr_48630_49670[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (15))){
var inst_48566 = (state_48611[(8)]);
var inst_48599 = cljs.core.vec(inst_48566);
var state_48611__$1 = state_48611;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48611__$1,(18),out,inst_48599);
} else {
if((state_val_48612 === (13))){
var inst_48594 = (state_48611[(2)]);
var state_48611__$1 = state_48611;
var statearr_48631_49671 = state_48611__$1;
(statearr_48631_49671[(2)] = inst_48594);

(statearr_48631_49671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (6))){
var inst_48566 = (state_48611[(8)]);
var inst_48596 = inst_48566.length;
var inst_48597 = (inst_48596 > (0));
var state_48611__$1 = state_48611;
if(cljs.core.truth_(inst_48597)){
var statearr_48633_49672 = state_48611__$1;
(statearr_48633_49672[(1)] = (15));

} else {
var statearr_48634_49673 = state_48611__$1;
(statearr_48634_49673[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (17))){
var inst_48604 = (state_48611[(2)]);
var inst_48605 = cljs.core.async.close_BANG_(out);
var state_48611__$1 = (function (){var statearr_48635 = state_48611;
(statearr_48635[(10)] = inst_48604);

return statearr_48635;
})();
var statearr_48636_49679 = state_48611__$1;
(statearr_48636_49679[(2)] = inst_48605);

(statearr_48636_49679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (3))){
var inst_48609 = (state_48611[(2)]);
var state_48611__$1 = state_48611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48611__$1,inst_48609);
} else {
if((state_val_48612 === (12))){
var inst_48566 = (state_48611[(8)]);
var inst_48587 = cljs.core.vec(inst_48566);
var state_48611__$1 = state_48611;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48611__$1,(14),out,inst_48587);
} else {
if((state_val_48612 === (2))){
var state_48611__$1 = state_48611;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48611__$1,(4),ch);
} else {
if((state_val_48612 === (11))){
var inst_48575 = (state_48611[(11)]);
var inst_48566 = (state_48611[(8)]);
var inst_48570 = (state_48611[(9)]);
var inst_48584 = inst_48566.push(inst_48570);
var tmp48637 = inst_48566;
var inst_48566__$1 = tmp48637;
var inst_48567 = inst_48575;
var state_48611__$1 = (function (){var statearr_48638 = state_48611;
(statearr_48638[(7)] = inst_48567);

(statearr_48638[(8)] = inst_48566__$1);

(statearr_48638[(12)] = inst_48584);

return statearr_48638;
})();
var statearr_48639_49681 = state_48611__$1;
(statearr_48639_49681[(2)] = null);

(statearr_48639_49681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (9))){
var inst_48567 = (state_48611[(7)]);
var inst_48580 = cljs.core.keyword_identical_QMARK_(inst_48567,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_48611__$1 = state_48611;
var statearr_48640_49682 = state_48611__$1;
(statearr_48640_49682[(2)] = inst_48580);

(statearr_48640_49682[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (5))){
var inst_48575 = (state_48611[(11)]);
var inst_48567 = (state_48611[(7)]);
var inst_48577 = (state_48611[(13)]);
var inst_48570 = (state_48611[(9)]);
var inst_48575__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48570) : f.call(null,inst_48570));
var inst_48577__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48575__$1,inst_48567);
var state_48611__$1 = (function (){var statearr_48641 = state_48611;
(statearr_48641[(11)] = inst_48575__$1);

(statearr_48641[(13)] = inst_48577__$1);

return statearr_48641;
})();
if(inst_48577__$1){
var statearr_48642_49683 = state_48611__$1;
(statearr_48642_49683[(1)] = (8));

} else {
var statearr_48643_49684 = state_48611__$1;
(statearr_48643_49684[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (14))){
var inst_48575 = (state_48611[(11)]);
var inst_48570 = (state_48611[(9)]);
var inst_48589 = (state_48611[(2)]);
var inst_48590 = [];
var inst_48591 = inst_48590.push(inst_48570);
var inst_48566 = inst_48590;
var inst_48567 = inst_48575;
var state_48611__$1 = (function (){var statearr_48644 = state_48611;
(statearr_48644[(7)] = inst_48567);

(statearr_48644[(14)] = inst_48589);

(statearr_48644[(15)] = inst_48591);

(statearr_48644[(8)] = inst_48566);

return statearr_48644;
})();
var statearr_48645_49685 = state_48611__$1;
(statearr_48645_49685[(2)] = null);

(statearr_48645_49685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (16))){
var state_48611__$1 = state_48611;
var statearr_48646_49686 = state_48611__$1;
(statearr_48646_49686[(2)] = null);

(statearr_48646_49686[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (10))){
var inst_48582 = (state_48611[(2)]);
var state_48611__$1 = state_48611;
if(cljs.core.truth_(inst_48582)){
var statearr_48647_49687 = state_48611__$1;
(statearr_48647_49687[(1)] = (11));

} else {
var statearr_48648_49692 = state_48611__$1;
(statearr_48648_49692[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (18))){
var inst_48601 = (state_48611[(2)]);
var state_48611__$1 = state_48611;
var statearr_48649_49694 = state_48611__$1;
(statearr_48649_49694[(2)] = inst_48601);

(statearr_48649_49694[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48612 === (8))){
var inst_48577 = (state_48611[(13)]);
var state_48611__$1 = state_48611;
var statearr_48650_49700 = state_48611__$1;
(statearr_48650_49700[(2)] = inst_48577);

(statearr_48650_49700[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44113__auto__ = null;
var cljs$core$async$state_machine__44113__auto____0 = (function (){
var statearr_48651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48651[(0)] = cljs$core$async$state_machine__44113__auto__);

(statearr_48651[(1)] = (1));

return statearr_48651;
});
var cljs$core$async$state_machine__44113__auto____1 = (function (state_48611){
while(true){
var ret_value__44114__auto__ = (function (){try{while(true){
var result__44115__auto__ = switch__44112__auto__(state_48611);
if(cljs.core.keyword_identical_QMARK_(result__44115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44115__auto__;
}
break;
}
}catch (e48654){var ex__44116__auto__ = e48654;
var statearr_48655_49713 = state_48611;
(statearr_48655_49713[(2)] = ex__44116__auto__);


if(cljs.core.seq((state_48611[(4)]))){
var statearr_48656_49714 = state_48611;
(statearr_48656_49714[(1)] = cljs.core.first((state_48611[(4)])));

} else {
throw ex__44116__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49715 = state_48611;
state_48611 = G__49715;
continue;
} else {
return ret_value__44114__auto__;
}
break;
}
});
cljs$core$async$state_machine__44113__auto__ = function(state_48611){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44113__auto____1.call(this,state_48611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44113__auto____0;
cljs$core$async$state_machine__44113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44113__auto____1;
return cljs$core$async$state_machine__44113__auto__;
})()
})();
var state__44849__auto__ = (function (){var statearr_48658 = f__44848__auto__();
(statearr_48658[(6)] = c__44847__auto___49654);

return statearr_48658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44849__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
