goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__78424){
var vec__78425 = p__78424;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78425,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78425,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__78429 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__78429__$1 = (((G__78429 instanceof cljs.core.Keyword))?G__78429.fqn:null);
switch (G__78429__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__78432 = (function (){
var seq__78433 = cljs.core.seq(vars__$1);
var chunk__78434 = null;
var count__78435 = (0);
var i__78436 = (0);
while(true){
if((i__78436 < count__78435)){
var v = chunk__78434.cljs$core$IIndexed$_nth$arity$2(null,i__78436);
var temp__5753__auto___78608 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___78608)){
var t_78609 = temp__5753__auto___78608;
var G__78456_78610 = ((function (seq__78433,chunk__78434,count__78435,i__78436,t_78609,temp__5753__auto___78608,v,each_fixture_fn,G__78429,G__78429__$1,env,once_fixtures,each_fixtures,vec__78425,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_78609)));
});})(seq__78433,chunk__78434,count__78435,i__78436,t_78609,temp__5753__auto___78608,v,each_fixture_fn,G__78429,G__78429__$1,env,once_fixtures,each_fixtures,vec__78425,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__78456_78610) : each_fixture_fn.call(null,G__78456_78610));
} else {
}


var G__78613 = seq__78433;
var G__78614 = chunk__78434;
var G__78615 = count__78435;
var G__78616 = (i__78436 + (1));
seq__78433 = G__78613;
chunk__78434 = G__78614;
count__78435 = G__78615;
i__78436 = G__78616;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__78433);
if(temp__5753__auto__){
var seq__78433__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__78433__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__78433__$1);
var G__78622 = cljs.core.chunk_rest(seq__78433__$1);
var G__78623 = c__4679__auto__;
var G__78624 = cljs.core.count(c__4679__auto__);
var G__78625 = (0);
seq__78433 = G__78622;
chunk__78434 = G__78623;
count__78435 = G__78624;
i__78436 = G__78625;
continue;
} else {
var v = cljs.core.first(seq__78433__$1);
var temp__5753__auto___78626__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___78626__$1)){
var t_78627 = temp__5753__auto___78626__$1;
var G__78457_78628 = ((function (seq__78433,chunk__78434,count__78435,i__78436,t_78627,temp__5753__auto___78626__$1,v,seq__78433__$1,temp__5753__auto__,each_fixture_fn,G__78429,G__78429__$1,env,once_fixtures,each_fixtures,vec__78425,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_78627)));
});})(seq__78433,chunk__78434,count__78435,i__78436,t_78627,temp__5753__auto___78626__$1,v,seq__78433__$1,temp__5753__auto__,each_fixture_fn,G__78429,G__78429__$1,env,once_fixtures,each_fixtures,vec__78425,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__78457_78628) : each_fixture_fn.call(null,G__78457_78628));
} else {
}


var G__78629 = cljs.core.next(seq__78433__$1);
var G__78630 = null;
var G__78631 = (0);
var G__78632 = (0);
seq__78433 = G__78629;
chunk__78434 = G__78630;
count__78435 = G__78631;
i__78436 = G__78632;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__78431 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__78431.cljs$core$IFn$_invoke$arity$1 ? fexpr__78431.cljs$core$IFn$_invoke$arity$1(G__78432) : fexpr__78431.call(null,G__78432));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__78429__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__78417_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__78417_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__78470 = shadow.test.env.get_test_ns_info(ns);
var map__78470__$1 = cljs.core.__destructure_map(map__78470);
var test_ns = map__78470__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78470__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__78478,vars){
var map__78480 = p__78478;
var map__78480__$1 = cljs.core.__destructure_map(map__78480);
var env = map__78480__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78480__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__78481_78641 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__78483_78642 = null;
var count__78484_78643 = (0);
var i__78485_78644 = (0);
while(true){
if((i__78485_78644 < count__78484_78643)){
var vec__78515_78645 = chunk__78483_78642.cljs$core$IIndexed$_nth$arity$2(null,i__78485_78644);
var test_ns_78646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78515_78645,(0),null);
var ns_info_78647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78515_78645,(1),null);
var map__78518_78648 = ns_info_78647;
var map__78518_78649__$1 = cljs.core.__destructure_map(map__78518_78648);
var fixtures_78650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78518_78649__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___78651 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_78650);
if(cljs.core.truth_(temp__5753__auto___78651)){
var fix_78652 = temp__5753__auto___78651;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_78646,fix_78652], 0));
} else {
}

var temp__5753__auto___78653 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_78650);
if(cljs.core.truth_(temp__5753__auto___78653)){
var fix_78654 = temp__5753__auto___78653;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_78646,fix_78654], 0));
} else {
}


var G__78655 = seq__78481_78641;
var G__78656 = chunk__78483_78642;
var G__78657 = count__78484_78643;
var G__78658 = (i__78485_78644 + (1));
seq__78481_78641 = G__78655;
chunk__78483_78642 = G__78656;
count__78484_78643 = G__78657;
i__78485_78644 = G__78658;
continue;
} else {
var temp__5753__auto___78664 = cljs.core.seq(seq__78481_78641);
if(temp__5753__auto___78664){
var seq__78481_78665__$1 = temp__5753__auto___78664;
if(cljs.core.chunked_seq_QMARK_(seq__78481_78665__$1)){
var c__4679__auto___78666 = cljs.core.chunk_first(seq__78481_78665__$1);
var G__78667 = cljs.core.chunk_rest(seq__78481_78665__$1);
var G__78668 = c__4679__auto___78666;
var G__78669 = cljs.core.count(c__4679__auto___78666);
var G__78670 = (0);
seq__78481_78641 = G__78667;
chunk__78483_78642 = G__78668;
count__78484_78643 = G__78669;
i__78485_78644 = G__78670;
continue;
} else {
var vec__78527_78671 = cljs.core.first(seq__78481_78665__$1);
var test_ns_78672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78527_78671,(0),null);
var ns_info_78673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78527_78671,(1),null);
var map__78531_78675 = ns_info_78673;
var map__78531_78676__$1 = cljs.core.__destructure_map(map__78531_78675);
var fixtures_78677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78531_78676__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___78678__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_78677);
if(cljs.core.truth_(temp__5753__auto___78678__$1)){
var fix_78679 = temp__5753__auto___78678__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_78672,fix_78679], 0));
} else {
}

var temp__5753__auto___78680__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_78677);
if(cljs.core.truth_(temp__5753__auto___78680__$1)){
var fix_78681 = temp__5753__auto___78680__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_78672,fix_78681], 0));
} else {
}


var G__78682 = cljs.core.next(seq__78481_78665__$1);
var G__78683 = null;
var G__78684 = (0);
var G__78685 = (0);
seq__78481_78641 = G__78682;
chunk__78483_78642 = G__78683;
count__78484_78643 = G__78684;
i__78485_78644 = G__78685;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__78477_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__78477_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__78545 = cljs.test.get_current_env();
var map__78545__$1 = cljs.core.__destructure_map(map__78545);
var env = map__78545__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78545__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78545__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__78552 = arguments.length;
switch (G__78552) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__78561 = arguments.length;
switch (G__78561) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__78568 = shadow.test.env.get_test_ns_info(ns);
var map__78568__$1 = cljs.core.__destructure_map(map__78568);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78568__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__78571 = arguments.length;
switch (G__78571) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__78569_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__78569_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__78592 = arguments.length;
switch (G__78592) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__78585_SHARP_){
var or__4253__auto__ = (re == null);
if(or__4253__auto__){
return or__4253__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__78585_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
