goog.provide('deercreeklabs.talk2.utils');
goog.scope(function(){
  deercreeklabs.talk2.utils.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.talk2.utils.max_ws_payload_len = (2147483647);
deercreeklabs.talk2.utils.ws_key_constant = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
deercreeklabs.talk2.utils.four_zeros_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0)], null));
deercreeklabs.talk2.utils.pprint = (function deercreeklabs$talk2$utils$pprint(x){
return cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(x);
});
deercreeklabs.talk2.utils.pprint_str = (function deercreeklabs$talk2$utils$pprint_str(x){
var sb__4795__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__56604_56629 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__56605_56630 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__56606_56631 = true;
var _STAR_print_fn_STAR__temp_val__56607_56632 = (function (x__4796__auto__){
return sb__4795__auto__.append(x__4796__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__56606_56631);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__56607_56632);

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(x);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__56605_56630);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__56604_56629);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4795__auto__);
});
deercreeklabs.talk2.utils.int_pow = (function deercreeklabs$talk2$utils$int_pow(base,exp){
return (Math.pow(base,exp) | (0));
});
deercreeklabs.talk2.utils.str__GT_int = (function deercreeklabs$talk2$utils$str__GT_int(s){
if(cljs.core.seq(s)){
return parseInt(s);
} else {
return null;
}
});
deercreeklabs.talk2.utils.ex_msg = (function deercreeklabs$talk2$utils$ex_msg(e){
return e.message;
});
deercreeklabs.talk2.utils.ex_stacktrace = (function deercreeklabs$talk2$utils$ex_stacktrace(e){
return e.stack;
});
deercreeklabs.talk2.utils.ex_msg_and_stacktrace = (function deercreeklabs$talk2$utils$ex_msg_and_stacktrace(e){
var data = cljs.core.ex_data(e);
var lines = (function (){var G__56608 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["\nException:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.talk2.utils.ex_msg(e))].join('')], null);
var G__56608__$1 = (cljs.core.truth_(data)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__56608,["\nex-data:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data(e))].join('')):G__56608);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__56608__$1,["\nStacktrace:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.talk2.utils.ex_stacktrace(e))].join(''));

})();
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",lines);
});
deercreeklabs.talk2.utils.current_time_ms = (function deercreeklabs$talk2$utils$current_time_ms(){
return deercreeklabs.talk2.utils.goog$module$goog$math$Long.fromNumber((new Date()).getTime());
});
deercreeklabs.talk2.utils.round_int = (function deercreeklabs$talk2$utils$round_int(n){
return (Math.round(n) | (0));
});
deercreeklabs.talk2.utils.floor_int = (function deercreeklabs$talk2$utils$floor_int(n){
return (Math.floor(n) | (0));
});
deercreeklabs.talk2.utils.jvm_QMARK_ = (function deercreeklabs$talk2$utils$jvm_QMARK_(){
return false;
});
deercreeklabs.talk2.utils.browser_QMARK_ = (function deercreeklabs$talk2$utils$browser_QMARK_(){
return (typeof navigator !== 'undefined');
});
deercreeklabs.talk2.utils.node_QMARK_ = (function deercreeklabs$talk2$utils$node_QMARK_(){
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("nodejs",cljs.core._STAR_target_STAR_));
});
deercreeklabs.talk2.utils.secure_random_byte_array = (function deercreeklabs$talk2$utils$secure_random_byte_array(num_bytes){
if(deercreeklabs.talk2.utils.node_QMARK_()){
return (new Int8Array(crypto.randomBytes(num_bytes)));
} else {
if(deercreeklabs.talk2.utils.browser_QMARK_()){
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num_bytes);
window.crypto.getRandomValues(ba);

return ba;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unsupported environment",cljs.core.PersistentArrayMap.EMPTY);

}
}
});
deercreeklabs.talk2.utils.random_byte_array = (function deercreeklabs$talk2$utils$random_byte_array(num_bytes){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (i){
return cljs.core.rand_int((255));
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(num_bytes)));
});
deercreeklabs.talk2.utils.ws_key__GT_ws_accept_key = (function deercreeklabs$talk2$utils$ws_key__GT_ws_accept_key(ws_key){
return deercreeklabs.baracus.byte_array__GT_b64(deercreeklabs.baracus.sha1(deercreeklabs.baracus.utf8__GT_byte_array([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ws_key),deercreeklabs.talk2.utils.ws_key_constant].join(''))));
});
deercreeklabs.talk2.utils.code__GT_byte_array = (function deercreeklabs$talk2$utils$code__GT_byte_array(code){
var hi = ((code >>> (8)) & (255));
var lo = (code & (255));
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hi,lo], null));
});
deercreeklabs.talk2.utils.byte_array__GT_code = (function deercreeklabs$talk2$utils$byte_array__GT_code(ba){
var hi = (ba[(0)]);
var lo = (ba[(1)]);
return ((((255) & hi) << (8)) | ((255) & lo));
});
deercreeklabs.talk2.utils.add_header = (function deercreeklabs$talk2$utils$add_header(headers,line){
var vec__56610 = clojure.string.split.cljs$core$IFn$_invoke$arity$3(line,/:/,(2));
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56610,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56610,(1),null);
var kw_k = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.lower_case(clojure.string.trim(k)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(headers,kw_k,(function (existing_v){
var trimmed_v = clojure.string.trim(v);
if(cljs.core.empty_QMARK_(existing_v)){
return trimmed_v;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(existing_v),", ",trimmed_v].join('');
}
}));
});
deercreeklabs.talk2.utils.byte_array__GT_http_info = (function deercreeklabs$talk2$utils$byte_array__GT_http_info(ba){
var bv = cljs.core.vec(ba);
var len = cljs.core.count(bv);
var ba_len = cljs.core.count(ba);
var i = (0);
var complete_QMARK_ = false;
var headers = cljs.core.PersistentArrayMap.EMPTY;
var first_line = null;
var unprocessed_bytes = cljs.core.PersistentVector.EMPTY;
while(true){
if((i >= len)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"complete?","complete?",-892991879),complete_QMARK_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"first-line","first-line",285094849),first_line,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(unprocessed_bytes)], null);
} else {
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(bv,i);
var ni = (i + (1));
var nb = (((ni < len))?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(bv,ni):null);
var eol_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((13),b)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((10),nb)));
var new_unprocessed_bytes = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(unprocessed_bytes,b);
var line = (cljs.core.truth_(complete_QMARK_)?null:clojure.string.trim(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.char$,unprocessed_bytes))));
if((!(eol_QMARK_))){
var G__56633 = ni;
var G__56634 = complete_QMARK_;
var G__56635 = headers;
var G__56636 = first_line;
var G__56637 = new_unprocessed_bytes;
i = G__56633;
complete_QMARK_ = G__56634;
headers = G__56635;
first_line = G__56636;
unprocessed_bytes = G__56637;
continue;
} else {
if(cljs.core.not(first_line)){
var G__56638 = (ni + (1));
var G__56639 = complete_QMARK_;
var G__56640 = headers;
var G__56641 = line;
var G__56642 = cljs.core.PersistentVector.EMPTY;
i = G__56638;
complete_QMARK_ = G__56639;
headers = G__56640;
first_line = G__56641;
unprocessed_bytes = G__56642;
continue;
} else {
if(cljs.core.seq(line)){
var new_headers = deercreeklabs.talk2.utils.add_header(headers,line);
var G__56643 = (ni + (1));
var G__56644 = complete_QMARK_;
var G__56645 = new_headers;
var G__56646 = first_line;
var G__56647 = cljs.core.PersistentVector.EMPTY;
i = G__56643;
complete_QMARK_ = G__56644;
headers = G__56645;
first_line = G__56646;
unprocessed_bytes = G__56647;
continue;
} else {
var G__56648 = (ni + (1));
var G__56649 = true;
var G__56650 = headers;
var G__56651 = first_line;
var G__56652 = cljs.core.PersistentVector.EMPTY;
i = G__56648;
complete_QMARK_ = G__56649;
headers = G__56650;
first_line = G__56651;
unprocessed_bytes = G__56652;
continue;

}
}
}
}
break;
}
});
/**
 * Mutates the ba arg in place to avoid allocation costs, which are significant
 * with large payloads.
 */
deercreeklabs.talk2.utils.mask_ws_payload_BANG_ = (function deercreeklabs$talk2$utils$mask_ws_payload_BANG_(key_ba,ba){
var n__4741__auto__ = cljs.core.count(ba);
var i = (0);
while(true){
if((i < n__4741__auto__)){
(ba[i] = ((key_ba[cljs.core.rem(i,(4))]) ^ (ba[i])));

var G__56653 = (i + (1));
i = G__56653;
continue;
} else {
return null;
}
break;
}
});
deercreeklabs.talk2.utils.throw_too_large_payload = (function deercreeklabs$talk2$utils$throw_too_large_payload(payload_len){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Payload too large (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(payload_len)," bytes). ","Max payload size is ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.talk2.utils.max_ws_payload_len)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"payload-len","payload-len",425828640),payload_len,new cljs.core.Keyword(null,"max-ws-payload-len","max-ws-payload-len",-947019636),deercreeklabs.talk2.utils.max_ws_payload_len], null));
});
deercreeklabs.talk2.utils.byte_array__GT_int = (function deercreeklabs$talk2$utils$byte_array__GT_int(ba){
var n = cljs.core.count(ba);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,i){
return ((((ba[i]) & (255)) << ((8) * ((n - (1)) - i))) | acc);
}),(0),cljs.core.range.cljs$core$IFn$_invoke$arity$1(n));
});
deercreeklabs.talk2.utils.int__GT_byte_array = (function deercreeklabs$talk2$utils$int__GT_byte_array(x){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,i){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,((x >>> ((8) * ((3) - i))) & (255)));
}),cljs.core.PersistentVector.EMPTY,cljs.core.range.cljs$core$IFn$_invoke$arity$1((4))));
});
/**
 * https://datatracker.ietf.org/doc/html/rfc6455#section-5.2
 */
deercreeklabs.talk2.utils.frame_header_map__GT_byte_array = (function deercreeklabs$talk2$utils$frame_header_map__GT_byte_array(p__56613){
var map__56614 = p__56613;
var map__56614__$1 = cljs.core.__destructure_map(map__56614);
var fin_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56614__$1,new cljs.core.Keyword(null,"fin?","fin?",-288046239));
var masking_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56614__$1,new cljs.core.Keyword(null,"masking-key","masking-key",574922792));
var opcode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56614__$1,new cljs.core.Keyword(null,"opcode","opcode",-1329442167));
var payload_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56614__$1,new cljs.core.Keyword(null,"payload-len","payload-len",425828640));
if(cljs.core.truth_((function (){var fexpr__56615 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [(0),null,(1),null,(2),null,(9),null,(10),null,(8),null], null), null);
return (fexpr__56615.cljs$core$IFn$_invoke$arity$1 ? fexpr__56615.cljs$core$IFn$_invoke$arity$1(opcode) : fexpr__56615.call(null,opcode));
})())){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid opcode: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(opcode),"."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode], null));
}

var vec__56616 = (((payload_len <= (125)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [payload_len,null], null):(((payload_len <= (65535)))?(function (){var hb = (((65280) & payload_len) >>> (8));
var lb = ((255) & payload_len);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(126),deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hb,lb], null))], null);
})():(((payload_len <= deercreeklabs.talk2.utils.max_ws_payload_len))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(127),deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.talk2.utils.four_zeros_ba,deercreeklabs.talk2.utils.int__GT_byte_array(payload_len)], null))], null):deercreeklabs.talk2.utils.throw_too_large_payload(payload_len)
)));
var l0 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56616,(0),null);
var l1_ba = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56616,(1),null);
var b0 = ((cljs.core.truth_(fin_QMARK_)?(128):(0)) | opcode);
var b1 = ((cljs.core.truth_(masking_key)?(128):(0)) | l0);
return deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [b0,b1], null)),l1_ba,masking_key], null));
});
deercreeklabs.talk2.utils.frame_info__GT_byte_array = (function deercreeklabs$talk2$utils$frame_info__GT_byte_array(m){
var map__56619 = m;
var map__56619__$1 = cljs.core.__destructure_map(map__56619);
var payload_ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56619__$1,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459));
var masking_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56619__$1,new cljs.core.Keyword(null,"masking-key","masking-key",574922792));
var header_ba = deercreeklabs.talk2.utils.frame_header_map__GT_byte_array(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"payload-len","payload-len",425828640),cljs.core.count(payload_ba)));
var payload_ba_STAR_ = ((cljs.core.not(payload_ba))?null:((cljs.core.not(masking_key))?payload_ba:(function (){
deercreeklabs.talk2.utils.mask_ws_payload_BANG_(masking_key,payload_ba);

return payload_ba;
})()

));
return deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [header_ba,payload_ba_STAR_], null));
});
deercreeklabs.talk2.utils.get_payload_start = (function deercreeklabs$talk2$utils$get_payload_start(masked_QMARK_,short_payload_len){
var G__56620 = (function (){var G__56621 = short_payload_len;
switch (G__56621) {
case (126):
return (4);

break;
case (127):
return (10);

break;
default:
return (2);

}
})();
if(cljs.core.truth_(masked_QMARK_)){
return (G__56620 + (4));
} else {
return G__56620;
}
});
deercreeklabs.talk2.utils.get_long_payload_len = (function deercreeklabs$talk2$utils$get_long_payload_len(ba,short_payload_len){
var G__56622 = short_payload_len;
switch (G__56622) {
case (126):
return deercreeklabs.talk2.utils.byte_array__GT_int(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(2),(4)));

break;
case (127):
if(((((ba[(2)]) === (0))) && (((((ba[(3)]) === (0))) && (((((ba[(4)]) === (0))) && (((ba[(5)]) === (0))))))))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Payload length is greater than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.talk2.utils.max_ws_payload_len),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"max-ws-payload-len","max-ws-payload-len",-947019636),deercreeklabs.talk2.utils.max_ws_payload_len], null));
}

return deercreeklabs.talk2.utils.byte_array__GT_int(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(6),(10)));

break;
default:
return short_payload_len;

}
});
deercreeklabs.talk2.utils.byte_array__GT_frame_header_map = (function deercreeklabs$talk2$utils$byte_array__GT_frame_header_map(ba){

new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ba], null);

var ba_len = cljs.core.count(ba);
if((ba_len < (2))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224),false,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba], null);
} else {
var b0 = (ba[(0)]);
var b1 = (ba[(1)]);
var fin_QMARK_ = ((b0 & (1 << (7))) != 0);
var opcode = (b0 & (15));
var masked_QMARK_ = ((b1 & (1 << (7))) != 0);
var short_payload_len = (b1 & (127));
var payload_start = deercreeklabs.talk2.utils.get_payload_start(masked_QMARK_,short_payload_len);
if((ba_len < payload_start)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224),false,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),false,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba], null);
} else {
var payload_len = deercreeklabs.talk2.utils.get_long_payload_len(ba,short_payload_len);
var _ = (((payload_len > deercreeklabs.talk2.utils.max_ws_payload_len))?deercreeklabs.talk2.utils.throw_too_large_payload(payload_len):null);
var payload_end = (payload_start + payload_len);
var masking_key_start = (payload_start - (4));
var masking_key = ((masked_QMARK_)?deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,masking_key_start,payload_start):null);
var complete_header_QMARK_ = true;
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224),complete_header_QMARK_,new cljs.core.Keyword(null,"fin?","fin?",-288046239),fin_QMARK_,new cljs.core.Keyword(null,"masking-key","masking-key",574922792),masking_key,new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode,new cljs.core.Keyword(null,"payload-end","payload-end",-1127661697),payload_end,new cljs.core.Keyword(null,"payload-len","payload-len",425828640),payload_len,new cljs.core.Keyword(null,"payload-start","payload-start",536273380),payload_start], null);
}
}
});
deercreeklabs.talk2.utils.byte_array__GT_frame_info = (function deercreeklabs$talk2$utils$byte_array__GT_frame_info(ba){
var ba_len = cljs.core.count(ba);
var header_map = deercreeklabs.talk2.utils.byte_array__GT_frame_header_map(ba);
var map__56623 = header_map;
var map__56623__$1 = cljs.core.__destructure_map(map__56623);
var complete_header_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56623__$1,new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224));
var masking_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56623__$1,new cljs.core.Keyword(null,"masking-key","masking-key",574922792));
var payload_start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56623__$1,new cljs.core.Keyword(null,"payload-start","payload-start",536273380));
var payload_end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56623__$1,new cljs.core.Keyword(null,"payload-end","payload-end",-1127661697));
var m = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(header_map,new cljs.core.Keyword(null,"payload-len","payload-len",425828640),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"payload-start","payload-start",536273380),new cljs.core.Keyword(null,"payload-end","payload-end",-1127661697)], 0));
if(cljs.core.not(complete_header_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),false),new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba);
} else {
if((ba_len < payload_end)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),false),new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,payload_start));
} else {
var payload = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,payload_start,payload_end);
if(cljs.core.truth_(masking_key)){
deercreeklabs.talk2.utils.mask_ws_payload_BANG_(masking_key,payload);
} else {
}

var G__56624 = m;
var G__56624__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__56624,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),true)
;
var G__56624__$2 = (((cljs.core.count(payload) > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__56624__$1,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459),payload):G__56624__$1);
if((ba_len > payload_end)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__56624__$2,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,payload_end));
} else {
return G__56624__$2;
}

}
}
});
deercreeklabs.talk2.utils.process_frame_BANG_ = (function deercreeklabs$talk2$utils$process_frame_BANG_(frame_info,continuation_ba,continuation_opcode,on_close_frame,on_message,on_ping,on_pong){
var map__56625 = frame_info;
var map__56625__$1 = cljs.core.__destructure_map(map__56625);
var fin_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56625__$1,new cljs.core.Keyword(null,"fin?","fin?",-288046239));
var opcode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56625__$1,new cljs.core.Keyword(null,"opcode","opcode",-1329442167));
var payload_ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56625__$1,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459));
var control_frame_QMARK_ = ((opcode & (1 << (7))) != 0);
var data_ba = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),opcode))?deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [continuation_ba,payload_ba], null)):null);
var G__56626_56676 = (opcode | (0));
switch (G__56626_56676) {
case (0):
if(cljs.core.truth_(fin_QMARK_)){
var data_56678 = (function (){var G__56627 = data_ba;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),continuation_opcode)){
return deercreeklabs.baracus.byte_array__GT_utf8(G__56627);
} else {
return G__56627;
}
})();
(on_message.cljs$core$IFn$_invoke$arity$1 ? on_message.cljs$core$IFn$_invoke$arity$1(data_56678) : on_message.call(null,data_56678));
} else {
}

break;
case (1):
if(cljs.core.truth_(fin_QMARK_)){
var G__56628_56679 = deercreeklabs.baracus.byte_array__GT_utf8(payload_ba);
(on_message.cljs$core$IFn$_invoke$arity$1 ? on_message.cljs$core$IFn$_invoke$arity$1(G__56628_56679) : on_message.call(null,G__56628_56679));
} else {
}

break;
case (2):
if(cljs.core.truth_(fin_QMARK_)){
(on_message.cljs$core$IFn$_invoke$arity$1 ? on_message.cljs$core$IFn$_invoke$arity$1(payload_ba) : on_message.call(null,payload_ba));
} else {
}

break;
case (8):
(on_close_frame.cljs$core$IFn$_invoke$arity$0 ? on_close_frame.cljs$core$IFn$_invoke$arity$0() : on_close_frame.call(null));

break;
case (9):
(on_ping.cljs$core$IFn$_invoke$arity$1 ? on_ping.cljs$core$IFn$_invoke$arity$1(payload_ba) : on_ping.call(null,payload_ba));

break;
case (10):
(on_pong.cljs$core$IFn$_invoke$arity$1 ? on_pong.cljs$core$IFn$_invoke$arity$1(payload_ba) : on_pong.call(null,payload_ba));

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad opcode: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(opcode),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode], null));

}

if(cljs.core.truth_((function (){var or__4253__auto__ = fin_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return control_frame_QMARK_;
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),null,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),null], null);
} else {
if(((opcode | (0)) === (0))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),data_ba,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),continuation_opcode], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),payload_ba,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),opcode], null);

}
}
});
deercreeklabs.talk2.utils.data__GT_frame_byte_arrays = (function deercreeklabs$talk2$utils$data__GT_frame_byte_arrays(msg_type,data,mask_QMARK_,max_payload_len){
var ba = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),msg_type))?deercreeklabs.baracus.utf8__GT_byte_array(data):data);
var payload_bas = (function (){var or__4253__auto__ = deercreeklabs.baracus.byte_array__GT_fragments(ba,max_payload_len);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null);
}
})();
var last_i = ((cljs.core.count(payload_bas) - (1)) | (0));
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,payload_ba){
var fin_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((i | (0)),last_i);
var masking_key = (cljs.core.truth_(mask_QMARK_)?deercreeklabs.talk2.utils.secure_random_byte_array((4)):null);
var opcode = (((i > (0)))?(0):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),msg_type))?(1):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"binary","binary",-1802232288),msg_type))?(2):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"close","close",1835149582),msg_type))?(8):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ping","ping",-1670114784),msg_type))?(9):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"pong","pong",-172484958),msg_type))?(10):null))))));
var frame_info = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fin?","fin?",-288046239),fin_QMARK_,new cljs.core.Keyword(null,"masking-key","masking-key",574922792),masking_key,new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459),payload_ba], null);
return deercreeklabs.talk2.utils.frame_info__GT_byte_array(frame_info);
}),payload_bas);
});
deercreeklabs.talk2.utils.get_msg_type = (function deercreeklabs$talk2$utils$get_msg_type(data){
if(typeof data === 'string'){
return new cljs.core.Keyword(null,"text","text",-1790561697);
} else {
if(cljs.core.truth_(deercreeklabs.baracus.byte_array_QMARK_(data))){
return new cljs.core.Keyword(null,"binary","binary",-1802232288);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad data type passed to `send!`. ","Data must be a string or byte array."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null));

}
}
});

//# sourceMappingURL=deercreeklabs.talk2.utils.js.map
