goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___76031 = schema.utils.use_fn_validation;
var output_schema75583_76032 = schema.core.Bool;
var input_schema75584_76033 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker75585_76034 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75584_76033);
}),null));
var output_checker75586_76035 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75583_76032);
}),null));
var ret__47899__auto___76036 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__75587){
var validate__42950__auto__ = cljs.core.deref(ufv___76031);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76037 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75587], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75590_76038 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75591_76039 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__75592_76040 = input_schema75584_76033;
var G__75593_76041 = cljs.core.deref(input_checker75585_76034);
var G__75594_76042 = args__42951__auto___76037;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75590_76038,G__75591_76039,G__75592_76040,G__75593_76041,G__75594_76042) : schema.core.fn_validator.call(null,G__75590_76038,G__75591_76039,G__75592_76040,G__75593_76041,G__75594_76042));
} else {
var temp__5753__auto___76043 = (function (){var fexpr__75597 = cljs.core.deref(input_checker75585_76034);
return (fexpr__75597.cljs$core$IFn$_invoke$arity$1 ? fexpr__75597.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76037) : fexpr__75597.call(null,args__42951__auto___76037));
})();
if(cljs.core.truth_(temp__5753__auto___76043)){
var error__42952__auto___76044 = temp__5753__auto___76043;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76044], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75584_76033,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76037,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76044], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var arg = G__75587;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75598_76046 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75599_76047 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__75600_76048 = output_schema75583_76032;
var G__75601_76049 = cljs.core.deref(output_checker75586_76035);
var G__75602_76050 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75598_76046,G__75599_76047,G__75600_76048,G__75601_76049,G__75602_76050) : schema.core.fn_validator.call(null,G__75598_76046,G__75599_76047,G__75600_76048,G__75601_76049,G__75602_76050));
} else {
var temp__5753__auto___76051 = (function (){var fexpr__75603 = cljs.core.deref(output_checker75586_76035);
return (fexpr__75603.cljs$core$IFn$_invoke$arity$1 ? fexpr__75603.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75603.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76051)){
var error__42952__auto___76052 = temp__5753__auto___76051;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76052], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75583_76032,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76052], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema75583_76032,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75584_76033], null)));

var ufv___76053 = schema.utils.use_fn_validation;
var output_schema75605_76054 = deercreeklabs.baracus.ByteArray;
var input_schema75606_76055 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema75610_76056 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker75607_76057 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75606_76055);
}),null));
var output_checker75608_76058 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75605_76054);
}),null));
var input_checker75611_76059 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75610_76056);
}),null));
var output_checker75612_76060 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75605_76054);
}),null));
var ret__47899__auto___76063 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__75617 = arguments.length;
switch (G__75617) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__75609){
var validate__42950__auto__ = cljs.core.deref(ufv___76053);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76065 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75609], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75618_76066 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75619_76067 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__75620_76068 = input_schema75606_76055;
var G__75621_76069 = cljs.core.deref(input_checker75607_76057);
var G__75622_76070 = args__42951__auto___76065;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75618_76066,G__75619_76067,G__75620_76068,G__75621_76069,G__75622_76070) : schema.core.fn_validator.call(null,G__75618_76066,G__75619_76067,G__75620_76068,G__75621_76069,G__75622_76070));
} else {
var temp__5753__auto___76071 = (function (){var fexpr__75623 = cljs.core.deref(input_checker75607_76057);
return (fexpr__75623.cljs$core$IFn$_invoke$arity$1 ? fexpr__75623.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76065) : fexpr__75623.call(null,args__42951__auto___76065));
})();
if(cljs.core.truth_(temp__5753__auto___76071)){
var error__42952__auto___76072 = temp__5753__auto___76071;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76072], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75606_76055,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76065,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76072], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var size_or_seq = G__75609;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75625_76073 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75626_76074 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__75627_76075 = output_schema75605_76054;
var G__75628_76076 = cljs.core.deref(output_checker75608_76058);
var G__75629_76077 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75625_76073,G__75626_76074,G__75627_76075,G__75628_76076,G__75629_76077) : schema.core.fn_validator.call(null,G__75625_76073,G__75626_76074,G__75627_76075,G__75628_76076,G__75629_76077));
} else {
var temp__5753__auto___76078 = (function (){var fexpr__75630 = cljs.core.deref(output_checker75608_76058);
return (fexpr__75630.cljs$core$IFn$_invoke$arity$1 ? fexpr__75630.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75630.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76078)){
var error__42952__auto___76079 = temp__5753__auto___76078;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76079], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75605_76054,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76079], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__75613,G__75614){
var validate__42950__auto__ = cljs.core.deref(ufv___76053);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76081 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75613,G__75614], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75631_76082 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75632_76083 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__75633_76084 = input_schema75610_76056;
var G__75634_76085 = cljs.core.deref(input_checker75611_76059);
var G__75635_76086 = args__42951__auto___76081;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75631_76082,G__75632_76083,G__75633_76084,G__75634_76085,G__75635_76086) : schema.core.fn_validator.call(null,G__75631_76082,G__75632_76083,G__75633_76084,G__75634_76085,G__75635_76086));
} else {
var temp__5753__auto___76087 = (function (){var fexpr__75636 = cljs.core.deref(input_checker75611_76059);
return (fexpr__75636.cljs$core$IFn$_invoke$arity$1 ? fexpr__75636.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76081) : fexpr__75636.call(null,args__42951__auto___76081));
})();
if(cljs.core.truth_(temp__5753__auto___76087)){
var error__42952__auto___76088 = temp__5753__auto___76087;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76088], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75610_76056,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76081,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76088], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var size = G__75613;
var init_val_or_seq = G__75614;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75638_76089 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75639_76090 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__75640_76091 = output_schema75605_76054;
var G__75641_76092 = cljs.core.deref(output_checker75612_76060);
var G__75642_76093 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75638_76089,G__75639_76090,G__75640_76091,G__75641_76092,G__75642_76093) : schema.core.fn_validator.call(null,G__75638_76089,G__75639_76090,G__75640_76091,G__75641_76092,G__75642_76093));
} else {
var temp__5753__auto___76096 = (function (){var fexpr__75643 = cljs.core.deref(output_checker75612_76060);
return (fexpr__75643.cljs$core$IFn$_invoke$arity$1 ? fexpr__75643.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75643.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76096)){
var error__42952__auto___76097 = temp__5753__auto___76096;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76097], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75605_76054,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76097], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema75605_76054,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75606_76055,input_schema75610_76056], null)));

var ufv___76100 = schema.utils.use_fn_validation;
var output_schema75644_76101 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema75645_76102 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker75646_76103 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75645_76102);
}),null));
var output_checker75647_76104 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75644_76101);
}),null));
var ret__47899__auto___76106 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__75648){
var validate__42950__auto__ = cljs.core.deref(ufv___76100);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76107 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75648], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75650_76108 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75651_76109 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__75652_76110 = input_schema75645_76102;
var G__75653_76111 = cljs.core.deref(input_checker75646_76103);
var G__75654_76112 = args__42951__auto___76107;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75650_76108,G__75651_76109,G__75652_76110,G__75653_76111,G__75654_76112) : schema.core.fn_validator.call(null,G__75650_76108,G__75651_76109,G__75652_76110,G__75653_76111,G__75654_76112));
} else {
var temp__5753__auto___76113 = (function (){var fexpr__75655 = cljs.core.deref(input_checker75646_76103);
return (fexpr__75655.cljs$core$IFn$_invoke$arity$1 ? fexpr__75655.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76107) : fexpr__75655.call(null,args__42951__auto___76107));
})();
if(cljs.core.truth_(temp__5753__auto___76113)){
var error__42952__auto___76114 = temp__5753__auto___76113;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76114], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75645_76102,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76107,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76114], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var arrays = G__75648;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__75657 = cljs.core.count(arrays__$1);
switch (G__75657) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__75657,arrays__$1,validate__42950__auto__,ufv___76100,output_schema75644_76101,input_schema75645_76102,input_checker75646_76103,output_checker75647_76104){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__75657,arrays__$1,validate__42950__auto__,ufv___76100,output_schema75644_76101,input_schema75645_76102,input_checker75646_76103,output_checker75647_76104))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__75657,arrays__$1,validate__42950__auto__,ufv___76100,output_schema75644_76101,input_schema75645_76102,input_checker75646_76103,output_checker75647_76104){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__75657,arrays__$1,validate__42950__auto__,ufv___76100,output_schema75644_76101,input_schema75645_76102,input_checker75646_76103,output_checker75647_76104))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75658_76117 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75659_76118 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__75660_76119 = output_schema75644_76101;
var G__75661_76120 = cljs.core.deref(output_checker75647_76104);
var G__75662_76121 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75658_76117,G__75659_76118,G__75660_76119,G__75661_76120,G__75662_76121) : schema.core.fn_validator.call(null,G__75658_76117,G__75659_76118,G__75660_76119,G__75661_76120,G__75662_76121));
} else {
var temp__5753__auto___76122 = (function (){var fexpr__75663 = cljs.core.deref(output_checker75647_76104);
return (fexpr__75663.cljs$core$IFn$_invoke$arity$1 ? fexpr__75663.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75663.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76122)){
var error__42952__auto___76123 = temp__5753__auto___76122;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76123], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75644_76101,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76123], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema75644_76101,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75645_76102], null)));

var ufv___76125 = schema.utils.use_fn_validation;
var output_schema75665_76126 = schema.core.Bool;
var input_schema75666_76127 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker75667_76128 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75666_76127);
}),null));
var output_checker75668_76129 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75665_76126);
}),null));
var ret__47899__auto___76130 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__75669,G__75670){
var validate__42950__auto__ = cljs.core.deref(ufv___76125);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76131 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75669,G__75670], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75672_76132 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75673_76133 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__75674_76134 = input_schema75666_76127;
var G__75675_76135 = cljs.core.deref(input_checker75667_76128);
var G__75676_76136 = args__42951__auto___76131;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75672_76132,G__75673_76133,G__75674_76134,G__75675_76135,G__75676_76136) : schema.core.fn_validator.call(null,G__75672_76132,G__75673_76133,G__75674_76134,G__75675_76135,G__75676_76136));
} else {
var temp__5753__auto___76137 = (function (){var fexpr__75677 = cljs.core.deref(input_checker75667_76128);
return (fexpr__75677.cljs$core$IFn$_invoke$arity$1 ? fexpr__75677.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76131) : fexpr__75677.call(null,args__42951__auto___76131));
})();
if(cljs.core.truth_(temp__5753__auto___76137)){
var error__42952__auto___76138 = temp__5753__auto___76137;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76138], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75666_76127,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76131,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76138], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var a = G__75669;
var b = G__75670;
while(true){
var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__4251__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__76140 = ((i + (1)) | (0));
i = G__76140;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__4251__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75679_76141 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75680_76142 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__75681_76143 = output_schema75665_76126;
var G__75682_76144 = cljs.core.deref(output_checker75668_76129);
var G__75683_76145 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75679_76141,G__75680_76142,G__75681_76143,G__75682_76144,G__75683_76145) : schema.core.fn_validator.call(null,G__75679_76141,G__75680_76142,G__75681_76143,G__75682_76144,G__75683_76145));
} else {
var temp__5753__auto___76146 = (function (){var fexpr__75684 = cljs.core.deref(output_checker75668_76129);
return (fexpr__75684.cljs$core$IFn$_invoke$arity$1 ? fexpr__75684.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75684.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76146)){
var error__42952__auto___76147 = temp__5753__auto___76146;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76147], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75665_76126,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76147], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema75665_76126,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75666_76127], null)));

var ufv___76148 = schema.utils.use_fn_validation;
var output_schema75685_76149 = schema.core.Str;
var input_schema75686_76150 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker75687_76151 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75686_76150);
}),null));
var output_checker75688_76152 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75685_76149);
}),null));
var ret__47899__auto___76153 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__75689){
var validate__42950__auto__ = cljs.core.deref(ufv___76148);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76154 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75689], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75694_76155 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75695_76156 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__75696_76157 = input_schema75686_76150;
var G__75697_76158 = cljs.core.deref(input_checker75687_76151);
var G__75698_76159 = args__42951__auto___76154;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75694_76155,G__75695_76156,G__75696_76157,G__75697_76158,G__75698_76159) : schema.core.fn_validator.call(null,G__75694_76155,G__75695_76156,G__75696_76157,G__75697_76158,G__75698_76159));
} else {
var temp__5753__auto___76160 = (function (){var fexpr__75699 = cljs.core.deref(input_checker75687_76151);
return (fexpr__75699.cljs$core$IFn$_invoke$arity$1 ? fexpr__75699.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76154) : fexpr__75699.call(null,args__42951__auto___76154));
})();
if(cljs.core.truth_(temp__5753__auto___76160)){
var error__42952__auto___76161 = temp__5753__auto___76160;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76161], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75686_76150,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76154,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76161], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75689;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75700_76163 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75701_76164 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__75702_76165 = output_schema75685_76149;
var G__75703_76166 = cljs.core.deref(output_checker75688_76152);
var G__75704_76167 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75700_76163,G__75701_76164,G__75702_76165,G__75703_76166,G__75704_76167) : schema.core.fn_validator.call(null,G__75700_76163,G__75701_76164,G__75702_76165,G__75703_76166,G__75704_76167));
} else {
var temp__5753__auto___76168 = (function (){var fexpr__75705 = cljs.core.deref(output_checker75688_76152);
return (fexpr__75705.cljs$core$IFn$_invoke$arity$1 ? fexpr__75705.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75705.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76168)){
var error__42952__auto___76169 = temp__5753__auto___76168;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76169], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75685_76149,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76169], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema75685_76149,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75686_76150], null)));

var ufv___76170 = schema.utils.use_fn_validation;
var output_schema75707_76171 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema75708_76172 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema75712_76173 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema75717_76174 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker75709_76175 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75708_76172);
}),null));
var output_checker75710_76176 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75707_76171);
}),null));
var input_checker75713_76177 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75712_76173);
}),null));
var output_checker75714_76178 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75707_76171);
}),null));
var input_checker75718_76179 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75717_76174);
}),null));
var output_checker75719_76180 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75707_76171);
}),null));
var ret__47899__auto___76181 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__75726 = arguments.length;
switch (G__75726) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__75711){
var validate__42950__auto__ = cljs.core.deref(ufv___76170);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76183 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75711], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75727_76185 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75728_76186 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__75729_76187 = input_schema75708_76172;
var G__75730_76188 = cljs.core.deref(input_checker75709_76175);
var G__75731_76189 = args__42951__auto___76183;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75727_76185,G__75728_76186,G__75729_76187,G__75730_76188,G__75731_76189) : schema.core.fn_validator.call(null,G__75727_76185,G__75728_76186,G__75729_76187,G__75730_76188,G__75731_76189));
} else {
var temp__5753__auto___76190 = (function (){var fexpr__75732 = cljs.core.deref(input_checker75709_76175);
return (fexpr__75732.cljs$core$IFn$_invoke$arity$1 ? fexpr__75732.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76183) : fexpr__75732.call(null,args__42951__auto___76183));
})();
if(cljs.core.truth_(temp__5753__auto___76190)){
var error__42952__auto___76191 = temp__5753__auto___76190;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76191], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75708_76172,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76183,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76191], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75711;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75734_76192 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75735_76193 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__75736_76194 = output_schema75707_76171;
var G__75737_76195 = cljs.core.deref(output_checker75710_76176);
var G__75738_76196 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75734_76192,G__75735_76193,G__75736_76194,G__75737_76195,G__75738_76196) : schema.core.fn_validator.call(null,G__75734_76192,G__75735_76193,G__75736_76194,G__75737_76195,G__75738_76196));
} else {
var temp__5753__auto___76197 = (function (){var fexpr__75739 = cljs.core.deref(output_checker75710_76176);
return (fexpr__75739.cljs$core$IFn$_invoke$arity$1 ? fexpr__75739.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75739.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76197)){
var error__42952__auto___76198 = temp__5753__auto___76197;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76198], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75707_76171,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76198], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__75715,G__75716){
var validate__42950__auto__ = cljs.core.deref(ufv___76170);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76200 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75715,G__75716], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75740_76201 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75741_76202 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__75742_76203 = input_schema75712_76173;
var G__75743_76204 = cljs.core.deref(input_checker75713_76177);
var G__75744_76205 = args__42951__auto___76200;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75740_76201,G__75741_76202,G__75742_76203,G__75743_76204,G__75744_76205) : schema.core.fn_validator.call(null,G__75740_76201,G__75741_76202,G__75742_76203,G__75743_76204,G__75744_76205));
} else {
var temp__5753__auto___76206 = (function (){var fexpr__75745 = cljs.core.deref(input_checker75713_76177);
return (fexpr__75745.cljs$core$IFn$_invoke$arity$1 ? fexpr__75745.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76200) : fexpr__75745.call(null,args__42951__auto___76200));
})();
if(cljs.core.truth_(temp__5753__auto___76206)){
var error__42952__auto___76207 = temp__5753__auto___76206;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76207], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75712_76173,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76200,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76207], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75715;
var start = G__75716;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75746_76208 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75747_76209 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__75748_76210 = output_schema75707_76171;
var G__75749_76211 = cljs.core.deref(output_checker75714_76178);
var G__75750_76212 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75746_76208,G__75747_76209,G__75748_76210,G__75749_76211,G__75750_76212) : schema.core.fn_validator.call(null,G__75746_76208,G__75747_76209,G__75748_76210,G__75749_76211,G__75750_76212));
} else {
var temp__5753__auto___76213 = (function (){var fexpr__75751 = cljs.core.deref(output_checker75714_76178);
return (fexpr__75751.cljs$core$IFn$_invoke$arity$1 ? fexpr__75751.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75751.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76213)){
var error__42952__auto___76214 = temp__5753__auto___76213;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76214], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75707_76171,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76214], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__75720,G__75721,G__75722){
var validate__42950__auto__ = cljs.core.deref(ufv___76170);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76215 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75720,G__75721,G__75722], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75752_76216 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75753_76217 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__75754_76218 = input_schema75717_76174;
var G__75755_76219 = cljs.core.deref(input_checker75718_76179);
var G__75756_76220 = args__42951__auto___76215;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75752_76216,G__75753_76217,G__75754_76218,G__75755_76219,G__75756_76220) : schema.core.fn_validator.call(null,G__75752_76216,G__75753_76217,G__75754_76218,G__75755_76219,G__75756_76220));
} else {
var temp__5753__auto___76221 = (function (){var fexpr__75758 = cljs.core.deref(input_checker75718_76179);
return (fexpr__75758.cljs$core$IFn$_invoke$arity$1 ? fexpr__75758.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76215) : fexpr__75758.call(null,args__42951__auto___76215));
})();
if(cljs.core.truth_(temp__5753__auto___76221)){
var error__42952__auto___76222 = temp__5753__auto___76221;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76222], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75717_76174,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76215,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76222], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75720;
var start = G__75721;
var end = G__75722;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4339__auto__ = end;
var y__4340__auto__ = cljs.core.count(ba);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75759_76223 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75760_76224 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__75761_76225 = output_schema75707_76171;
var G__75762_76226 = cljs.core.deref(output_checker75719_76180);
var G__75763_76227 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75759_76223,G__75760_76224,G__75761_76225,G__75762_76226,G__75763_76227) : schema.core.fn_validator.call(null,G__75759_76223,G__75760_76224,G__75761_76225,G__75762_76226,G__75763_76227));
} else {
var temp__5753__auto___76228 = (function (){var fexpr__75764 = cljs.core.deref(output_checker75719_76180);
return (fexpr__75764.cljs$core$IFn$_invoke$arity$1 ? fexpr__75764.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75764.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76228)){
var error__42952__auto___76230 = temp__5753__auto___76228;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76230], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75707_76171,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76230], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema75707_76171,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75708_76172,input_schema75712_76173,input_schema75717_76174], null)));

var ufv___76233 = schema.utils.use_fn_validation;
var output_schema75766_76234 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema75767_76235 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker75768_76236 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75767_76235);
}),null));
var output_checker75769_76237 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75766_76234);
}),null));
var ret__47899__auto___76238 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__75770){
var validate__42950__auto__ = cljs.core.deref(ufv___76233);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76239 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75770], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75771_76240 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75772_76241 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__75773_76242 = input_schema75767_76235;
var G__75774_76243 = cljs.core.deref(input_checker75768_76236);
var G__75775_76244 = args__42951__auto___76239;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75771_76240,G__75772_76241,G__75773_76242,G__75774_76243,G__75775_76244) : schema.core.fn_validator.call(null,G__75771_76240,G__75772_76241,G__75773_76242,G__75774_76243,G__75775_76244));
} else {
var temp__5753__auto___76245 = (function (){var fexpr__75776 = cljs.core.deref(input_checker75768_76236);
return (fexpr__75776.cljs$core$IFn$_invoke$arity$1 ? fexpr__75776.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76239) : fexpr__75776.call(null,args__42951__auto___76239));
})();
if(cljs.core.truth_(temp__5753__auto___76245)){
var error__42952__auto___76246 = temp__5753__auto___76245;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76246], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75767_76235,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76239,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76246], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75770;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4741__auto___76248 = num;
var i_76249 = (0);
while(true){
if((i_76249 < n__4741__auto___76248)){
(new$[i_76249] = (ba[(last - i_76249)]));

var G__76250 = (i_76249 + (1));
i_76249 = G__76250;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75778_76251 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75779_76252 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__75780_76253 = output_schema75766_76234;
var G__75781_76254 = cljs.core.deref(output_checker75769_76237);
var G__75782_76255 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75778_76251,G__75779_76252,G__75780_76253,G__75781_76254,G__75782_76255) : schema.core.fn_validator.call(null,G__75778_76251,G__75779_76252,G__75780_76253,G__75781_76254,G__75782_76255));
} else {
var temp__5753__auto___76256 = (function (){var fexpr__75783 = cljs.core.deref(output_checker75769_76237);
return (fexpr__75783.cljs$core$IFn$_invoke$arity$1 ? fexpr__75783.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75783.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76256)){
var error__42952__auto___76257 = temp__5753__auto___76256;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76257], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75766_76234,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76257], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema75766_76234,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75767_76235], null)));

var ufv___76259 = schema.utils.use_fn_validation;
var output_schema75785_76260 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema75786_76261 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker75787_76262 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75786_76261);
}),null));
var output_checker75788_76263 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75785_76260);
}),null));
var ret__47899__auto___76264 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__75789,G__75790){
var validate__42950__auto__ = cljs.core.deref(ufv___76259);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76265 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75789,G__75790], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75791_76266 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75792_76267 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__75793_76268 = input_schema75786_76261;
var G__75794_76269 = cljs.core.deref(input_checker75787_76262);
var G__75795_76270 = args__42951__auto___76265;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75791_76266,G__75792_76267,G__75793_76268,G__75794_76269,G__75795_76270) : schema.core.fn_validator.call(null,G__75791_76266,G__75792_76267,G__75793_76268,G__75794_76269,G__75795_76270));
} else {
var temp__5753__auto___76271 = (function (){var fexpr__75796 = cljs.core.deref(input_checker75787_76262);
return (fexpr__75796.cljs$core$IFn$_invoke$arity$1 ? fexpr__75796.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76265) : fexpr__75796.call(null,args__42951__auto___76265));
})();
if(cljs.core.truth_(temp__5753__auto___76271)){
var error__42952__auto___76272 = temp__5753__auto___76271;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76272], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75786_76261,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76265,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76272], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75789;
var fragment_size = G__75790;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__76273 = (end_offset | (0));
var G__76274 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__76273;
output = G__76274;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75798_76275 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75799_76276 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__75800_76277 = output_schema75785_76260;
var G__75801_76278 = cljs.core.deref(output_checker75788_76263);
var G__75802_76279 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75798_76275,G__75799_76276,G__75800_76277,G__75801_76278,G__75802_76279) : schema.core.fn_validator.call(null,G__75798_76275,G__75799_76276,G__75800_76277,G__75801_76278,G__75802_76279));
} else {
var temp__5753__auto___76281 = (function (){var fexpr__75803 = cljs.core.deref(output_checker75788_76263);
return (fexpr__75803.cljs$core$IFn$_invoke$arity$1 ? fexpr__75803.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75803.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76281)){
var error__42952__auto___76282 = temp__5753__auto___76281;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76282], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75785_76260,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76282], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema75785_76260,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75786_76261], null)));

var ufv___76283 = schema.utils.use_fn_validation;
var output_schema75805_76284 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema75806_76285 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker75807_76286 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75806_76285);
}),null));
var output_checker75808_76287 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75805_76284);
}),null));
var ret__47899__auto___76288 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__75809){
var validate__42950__auto__ = cljs.core.deref(ufv___76283);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76289 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75809], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75811_76290 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75812_76291 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__75813_76292 = input_schema75806_76285;
var G__75814_76293 = cljs.core.deref(input_checker75807_76286);
var G__75815_76294 = args__42951__auto___76289;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75811_76290,G__75812_76291,G__75813_76292,G__75814_76293,G__75815_76294) : schema.core.fn_validator.call(null,G__75811_76290,G__75812_76291,G__75813_76292,G__75814_76293,G__75815_76294));
} else {
var temp__5753__auto___76295 = (function (){var fexpr__75817 = cljs.core.deref(input_checker75807_76286);
return (fexpr__75817.cljs$core$IFn$_invoke$arity$1 ? fexpr__75817.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76289) : fexpr__75817.call(null,args__42951__auto___76289));
})();
if(cljs.core.truth_(temp__5753__auto___76295)){
var error__42952__auto___76296 = temp__5753__auto___76295;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76296], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75806_76285,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76289,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76296], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75809;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__76297 = (n + (1));
var G__76298 = (i__$1 | (0));
var G__76299 = (out__$1 | (0));
n = G__76297;
i = G__76298;
out = G__76299;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75821_76300 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75822_76301 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__75823_76302 = output_schema75805_76284;
var G__75824_76303 = cljs.core.deref(output_checker75808_76287);
var G__75825_76304 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75821_76300,G__75822_76301,G__75823_76302,G__75824_76303,G__75825_76304) : schema.core.fn_validator.call(null,G__75821_76300,G__75822_76301,G__75823_76302,G__75824_76303,G__75825_76304));
} else {
var temp__5753__auto___76305 = (function (){var fexpr__75826 = cljs.core.deref(output_checker75808_76287);
return (fexpr__75826.cljs$core$IFn$_invoke$arity$1 ? fexpr__75826.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75826.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76305)){
var error__42952__auto___76306 = temp__5753__auto___76305;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76306], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75805_76284,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76306], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema75805_76284,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75806_76285], null)));

var ufv___76308 = schema.utils.use_fn_validation;
var output_schema75827_76309 = deercreeklabs.baracus.ByteArray;
var input_schema75828_76310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker75829_76311 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75828_76310);
}),null));
var output_checker75830_76312 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75827_76309);
}),null));
var ret__47899__auto___76313 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__75831){
var validate__42950__auto__ = cljs.core.deref(ufv___76308);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76314 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75831], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75833_76315 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75834_76316 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__75835_76317 = input_schema75828_76310;
var G__75836_76318 = cljs.core.deref(input_checker75829_76311);
var G__75837_76319 = args__42951__auto___76314;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75833_76315,G__75834_76316,G__75835_76317,G__75836_76318,G__75837_76319) : schema.core.fn_validator.call(null,G__75833_76315,G__75834_76316,G__75835_76317,G__75836_76318,G__75837_76319));
} else {
var temp__5753__auto___76320 = (function (){var fexpr__75838 = cljs.core.deref(input_checker75829_76311);
return (fexpr__75838.cljs$core$IFn$_invoke$arity$1 ? fexpr__75838.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76314) : fexpr__75838.call(null,args__42951__auto___76314));
})();
if(cljs.core.truth_(temp__5753__auto___76320)){
var error__42952__auto___76321 = temp__5753__auto___76320;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76321], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75828_76310,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76314,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76321], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var i = G__75831;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__76322 = (n >>> (7));
var G__76323 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__76322;
out = G__76323;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75840_76324 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75841_76325 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__75842_76326 = output_schema75827_76309;
var G__75843_76327 = cljs.core.deref(output_checker75830_76312);
var G__75844_76328 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75840_76324,G__75841_76325,G__75842_76326,G__75843_76327,G__75844_76328) : schema.core.fn_validator.call(null,G__75840_76324,G__75841_76325,G__75842_76326,G__75843_76327,G__75844_76328));
} else {
var temp__5753__auto___76329 = (function (){var fexpr__75845 = cljs.core.deref(output_checker75830_76312);
return (fexpr__75845.cljs$core$IFn$_invoke$arity$1 ? fexpr__75845.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75845.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76329)){
var error__42952__auto___76331 = temp__5753__auto___76329;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76331], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75827_76309,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76331], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema75827_76309,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75828_76310], null)));

var ufv___76332 = schema.utils.use_fn_validation;
var output_schema75849_76333 = schema.core.maybe(schema.core.Str);
var input_schema75850_76334 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker75851_76335 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75850_76334);
}),null));
var output_checker75852_76336 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75849_76333);
}),null));
var ret__47899__auto___76337 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__75853){
var validate__42950__auto__ = cljs.core.deref(ufv___76332);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76338 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75853], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75856_76339 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75857_76340 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__75858_76341 = input_schema75850_76334;
var G__75859_76342 = cljs.core.deref(input_checker75851_76335);
var G__75860_76343 = args__42951__auto___76338;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75856_76339,G__75857_76340,G__75858_76341,G__75859_76342,G__75860_76343) : schema.core.fn_validator.call(null,G__75856_76339,G__75857_76340,G__75858_76341,G__75859_76342,G__75860_76343));
} else {
var temp__5753__auto___76344 = (function (){var fexpr__75861 = cljs.core.deref(input_checker75851_76335);
return (fexpr__75861.cljs$core$IFn$_invoke$arity$1 ? fexpr__75861.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76338) : fexpr__75861.call(null,args__42951__auto___76338));
})();
if(cljs.core.truth_(temp__5753__auto___76344)){
var error__42952__auto___76345 = temp__5753__auto___76344;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76345], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75850_76334,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76338,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76345], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var b = G__75853;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75862_76346 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75863_76347 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__75864_76348 = output_schema75849_76333;
var G__75865_76349 = cljs.core.deref(output_checker75852_76336);
var G__75866_76350 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75862_76346,G__75863_76347,G__75864_76348,G__75865_76349,G__75866_76350) : schema.core.fn_validator.call(null,G__75862_76346,G__75863_76347,G__75864_76348,G__75865_76349,G__75866_76350));
} else {
var temp__5753__auto___76351 = (function (){var fexpr__75868 = cljs.core.deref(output_checker75852_76336);
return (fexpr__75868.cljs$core$IFn$_invoke$arity$1 ? fexpr__75868.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75868.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76351)){
var error__42952__auto___76352 = temp__5753__auto___76351;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76352], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75849_76333,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76352], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema75849_76333,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75850_76334], null)));

var ufv___76353 = schema.utils.use_fn_validation;
var output_schema75870_76354 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema75871_76355 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker75872_76356 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75871_76355);
}),null));
var output_checker75873_76357 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75870_76354);
}),null));
var ret__47899__auto___76358 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__75874){
var validate__42950__auto__ = cljs.core.deref(ufv___76353);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76359 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75874], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75875_76360 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75876_76361 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__75877_76362 = input_schema75871_76355;
var G__75878_76363 = cljs.core.deref(input_checker75872_76356);
var G__75879_76364 = args__42951__auto___76359;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75875_76360,G__75876_76361,G__75877_76362,G__75878_76363,G__75879_76364) : schema.core.fn_validator.call(null,G__75875_76360,G__75876_76361,G__75877_76362,G__75878_76363,G__75879_76364));
} else {
var temp__5753__auto___76365 = (function (){var fexpr__75880 = cljs.core.deref(input_checker75872_76356);
return (fexpr__75880.cljs$core$IFn$_invoke$arity$1 ? fexpr__75880.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76359) : fexpr__75880.call(null,args__42951__auto___76359));
})();
if(cljs.core.truth_(temp__5753__auto___76365)){
var error__42952__auto___76366 = temp__5753__auto___76365;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76366], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75871_76355,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76359,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76366], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var s = G__75874;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75882_76367 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75883_76368 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__75884_76369 = output_schema75870_76354;
var G__75885_76370 = cljs.core.deref(output_checker75873_76357);
var G__75886_76371 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75882_76367,G__75883_76368,G__75884_76369,G__75885_76370,G__75886_76371) : schema.core.fn_validator.call(null,G__75882_76367,G__75883_76368,G__75884_76369,G__75885_76370,G__75886_76371));
} else {
var temp__5753__auto___76372 = (function (){var fexpr__75887 = cljs.core.deref(output_checker75873_76357);
return (fexpr__75887.cljs$core$IFn$_invoke$arity$1 ? fexpr__75887.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75887.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76372)){
var error__42952__auto___76373 = temp__5753__auto___76372;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76373], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75870_76354,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76373], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema75870_76354,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75871_76355], null)));

var ufv___76374 = schema.utils.use_fn_validation;
var output_schema75889_76375 = schema.core.maybe(schema.core.Str);
var input_schema75890_76376 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker75891_76377 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75890_76376);
}),null));
var output_checker75892_76378 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75889_76375);
}),null));
var ret__47899__auto___76379 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__75893){
var validate__42950__auto__ = cljs.core.deref(ufv___76374);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76380 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75893], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75897_76381 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75898_76382 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__75899_76383 = input_schema75890_76376;
var G__75900_76384 = cljs.core.deref(input_checker75891_76377);
var G__75901_76385 = args__42951__auto___76380;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75897_76381,G__75898_76382,G__75899_76383,G__75900_76384,G__75901_76385) : schema.core.fn_validator.call(null,G__75897_76381,G__75898_76382,G__75899_76383,G__75900_76384,G__75901_76385));
} else {
var temp__5753__auto___76386 = (function (){var fexpr__75902 = cljs.core.deref(input_checker75891_76377);
return (fexpr__75902.cljs$core$IFn$_invoke$arity$1 ? fexpr__75902.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76380) : fexpr__75902.call(null,args__42951__auto___76380));
})();
if(cljs.core.truth_(temp__5753__auto___76386)){
var error__42952__auto___76387 = temp__5753__auto___76386;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76387], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75890_76376,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76380,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76387], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75893;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75904_76388 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75905_76389 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__75906_76390 = output_schema75889_76375;
var G__75907_76391 = cljs.core.deref(output_checker75892_76378);
var G__75908_76392 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75904_76388,G__75905_76389,G__75906_76390,G__75907_76391,G__75908_76392) : schema.core.fn_validator.call(null,G__75904_76388,G__75905_76389,G__75906_76390,G__75907_76391,G__75908_76392));
} else {
var temp__5753__auto___76393 = (function (){var fexpr__75909 = cljs.core.deref(output_checker75892_76378);
return (fexpr__75909.cljs$core$IFn$_invoke$arity$1 ? fexpr__75909.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75909.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76393)){
var error__42952__auto___76394 = temp__5753__auto___76393;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76394], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75889_76375,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76394], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema75889_76375,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75890_76376], null)));

var ufv___76395 = schema.utils.use_fn_validation;
var output_schema75910_76396 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema75911_76397 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker75912_76398 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75911_76397);
}),null));
var output_checker75913_76399 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75910_76396);
}),null));
var ret__47899__auto___76400 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__75914){
var validate__42950__auto__ = cljs.core.deref(ufv___76395);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76401 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75914], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75916_76402 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75917_76403 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__75918_76404 = input_schema75911_76397;
var G__75919_76405 = cljs.core.deref(input_checker75912_76398);
var G__75920_76406 = args__42951__auto___76401;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75916_76402,G__75917_76403,G__75918_76404,G__75919_76405,G__75920_76406) : schema.core.fn_validator.call(null,G__75916_76402,G__75917_76403,G__75918_76404,G__75919_76405,G__75920_76406));
} else {
var temp__5753__auto___76407 = (function (){var fexpr__75921 = cljs.core.deref(input_checker75912_76398);
return (fexpr__75921.cljs$core$IFn$_invoke$arity$1 ? fexpr__75921.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76401) : fexpr__75921.call(null,args__42951__auto___76401));
})();
if(cljs.core.truth_(temp__5753__auto___76407)){
var error__42952__auto___76408 = temp__5753__auto___76407;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76408], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75911_76397,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76401,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76408], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var s = G__75914;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75922_76409 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75923_76410 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__75924_76411 = output_schema75910_76396;
var G__75925_76412 = cljs.core.deref(output_checker75913_76399);
var G__75926_76413 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75922_76409,G__75923_76410,G__75924_76411,G__75925_76412,G__75926_76413) : schema.core.fn_validator.call(null,G__75922_76409,G__75923_76410,G__75924_76411,G__75925_76412,G__75926_76413));
} else {
var temp__5753__auto___76414 = (function (){var fexpr__75927 = cljs.core.deref(output_checker75913_76399);
return (fexpr__75927.cljs$core$IFn$_invoke$arity$1 ? fexpr__75927.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75927.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76414)){
var error__42952__auto___76419 = temp__5753__auto___76414;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76419], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75910_76396,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76419], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema75910_76396,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75911_76397], null)));

var ufv___76420 = schema.utils.use_fn_validation;
var output_schema75929_76421 = schema.core.maybe(schema.core.Str);
var input_schema75930_76422 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker75931_76423 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75930_76422);
}),null));
var output_checker75932_76424 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75929_76421);
}),null));
var ret__47899__auto___76425 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__75933){
var validate__42950__auto__ = cljs.core.deref(ufv___76420);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76426 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75933], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75935_76427 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75936_76428 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__75937_76429 = input_schema75930_76422;
var G__75938_76430 = cljs.core.deref(input_checker75931_76423);
var G__75939_76431 = args__42951__auto___76426;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75935_76427,G__75936_76428,G__75937_76429,G__75938_76430,G__75939_76431) : schema.core.fn_validator.call(null,G__75935_76427,G__75936_76428,G__75937_76429,G__75938_76430,G__75939_76431));
} else {
var temp__5753__auto___76432 = (function (){var fexpr__75940 = cljs.core.deref(input_checker75931_76423);
return (fexpr__75940.cljs$core$IFn$_invoke$arity$1 ? fexpr__75940.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76426) : fexpr__75940.call(null,args__42951__auto___76426));
})();
if(cljs.core.truth_(temp__5753__auto___76432)){
var error__42952__auto___76434 = temp__5753__auto___76432;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76434], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75930_76422,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76426,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76434], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75933;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4741__auto___76439 = len;
var i_76440 = (0);
while(true){
if((i_76440 < n__4741__auto___76439)){
var b_76441 = ((ba[i_76440]) & (255));
var j_76442 = ((2) * i_76440);
(ca[j_76442] = (function (){var G__75941 = (b_76441 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__75941) : hex_chars.call(null,G__75941));
})());

(ca[(j_76442 + (1))] = (function (){var G__75943 = (b_76441 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__75943) : hex_chars.call(null,G__75943));
})());

var G__76443 = (i_76440 + (1));
i_76440 = G__76443;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75944_76444 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75945_76445 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__75946_76446 = output_schema75929_76421;
var G__75947_76447 = cljs.core.deref(output_checker75932_76424);
var G__75948_76448 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75944_76444,G__75945_76445,G__75946_76446,G__75947_76447,G__75948_76448) : schema.core.fn_validator.call(null,G__75944_76444,G__75945_76445,G__75946_76446,G__75947_76447,G__75948_76448));
} else {
var temp__5753__auto___76449 = (function (){var fexpr__75949 = cljs.core.deref(output_checker75932_76424);
return (fexpr__75949.cljs$core$IFn$_invoke$arity$1 ? fexpr__75949.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75949.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76449)){
var error__42952__auto___76455 = temp__5753__auto___76449;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76455], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75929_76421,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76455], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema75929_76421,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75930_76422], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___76462 = schema.utils.use_fn_validation;
var output_schema75953_76463 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema75954_76464 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker75955_76465 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75954_76464);
}),null));
var output_checker75956_76466 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75953_76463);
}),null));
var ret__47899__auto___76468 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__75957){
var validate__42950__auto__ = cljs.core.deref(ufv___76462);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76469 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75957], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75959_76470 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75960_76471 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__75961_76472 = input_schema75954_76464;
var G__75962_76473 = cljs.core.deref(input_checker75955_76465);
var G__75963_76474 = args__42951__auto___76469;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75959_76470,G__75960_76471,G__75961_76472,G__75962_76473,G__75963_76474) : schema.core.fn_validator.call(null,G__75959_76470,G__75960_76471,G__75961_76472,G__75962_76473,G__75963_76474));
} else {
var temp__5753__auto___76475 = (function (){var fexpr__75964 = cljs.core.deref(input_checker75955_76465);
return (fexpr__75964.cljs$core$IFn$_invoke$arity$1 ? fexpr__75964.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76469) : fexpr__75964.call(null,args__42951__auto___76469));
})();
if(cljs.core.truth_(temp__5753__auto___76475)){
var error__42952__auto___76476 = temp__5753__auto___76475;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76476], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75954_76464,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76469,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76476], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var s = G__75957;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4741__auto___76482 = ba_len;
var i_76483 = (0);
while(true){
if((i_76483 < n__4741__auto___76482)){
var j_76484 = ((2) * i_76483);
(ba[i_76483] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_76484)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_76484 + (1))))));

var G__76485 = (i_76483 + (1));
i_76483 = G__76485;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75966_76486 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75967_76487 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__75968_76488 = output_schema75953_76463;
var G__75969_76489 = cljs.core.deref(output_checker75956_76466);
var G__75970_76490 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75966_76486,G__75967_76487,G__75968_76488,G__75969_76489,G__75970_76490) : schema.core.fn_validator.call(null,G__75966_76486,G__75967_76487,G__75968_76488,G__75969_76489,G__75970_76490));
} else {
var temp__5753__auto___76491 = (function (){var fexpr__75971 = cljs.core.deref(output_checker75956_76466);
return (fexpr__75971.cljs$core$IFn$_invoke$arity$1 ? fexpr__75971.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75971.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76491)){
var error__42952__auto___76497 = temp__5753__auto___76491;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76497], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75953_76463,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76497], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema75953_76463,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75954_76464], null)));

var ufv___76499 = schema.utils.use_fn_validation;
var output_schema75972_76500 = deercreeklabs.baracus.ByteArray;
var input_schema75973_76501 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker75974_76502 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75973_76501);
}),null));
var output_checker75975_76503 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75972_76500);
}),null));
var ret__47899__auto___76509 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__75976){
var validate__42950__auto__ = cljs.core.deref(ufv___76499);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76510 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75976], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75978_76511 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75979_76512 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__75980_76513 = input_schema75973_76501;
var G__75981_76514 = cljs.core.deref(input_checker75974_76502);
var G__75982_76515 = args__42951__auto___76510;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75978_76511,G__75979_76512,G__75980_76513,G__75981_76514,G__75982_76515) : schema.core.fn_validator.call(null,G__75978_76511,G__75979_76512,G__75980_76513,G__75981_76514,G__75982_76515));
} else {
var temp__5753__auto___76517 = (function (){var fexpr__75983 = cljs.core.deref(input_checker75974_76502);
return (fexpr__75983.cljs$core$IFn$_invoke$arity$1 ? fexpr__75983.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76510) : fexpr__75983.call(null,args__42951__auto___76510));
})();
if(cljs.core.truth_(temp__5753__auto___76517)){
var error__42952__auto___76518 = temp__5753__auto___76517;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76518], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75973_76501,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76510,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76518], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75976;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75985_76524 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__75986_76525 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__75987_76526 = output_schema75972_76500;
var G__75988_76527 = cljs.core.deref(output_checker75975_76503);
var G__75989_76528 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75985_76524,G__75986_76525,G__75987_76526,G__75988_76527,G__75989_76528) : schema.core.fn_validator.call(null,G__75985_76524,G__75986_76525,G__75987_76526,G__75988_76527,G__75989_76528));
} else {
var temp__5753__auto___76529 = (function (){var fexpr__75990 = cljs.core.deref(output_checker75975_76503);
return (fexpr__75990.cljs$core$IFn$_invoke$arity$1 ? fexpr__75990.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__75990.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76529)){
var error__42952__auto___76530 = temp__5753__auto___76529;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76530], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75972_76500,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76530], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema75972_76500,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75973_76501], null)));

var ufv___76531 = schema.utils.use_fn_validation;
var output_schema75992_76532 = deercreeklabs.baracus.ByteArray;
var input_schema75993_76533 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker75994_76534 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema75993_76533);
}),null));
var output_checker75995_76535 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema75992_76532);
}),null));
var ret__47899__auto___76536 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__75996){
var validate__42950__auto__ = cljs.core.deref(ufv___76531);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76537 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__75996], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__75998_76543 = new cljs.core.Keyword(null,"input","input",556931961);
var G__75999_76544 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__76000_76545 = input_schema75993_76533;
var G__76001_76546 = cljs.core.deref(input_checker75994_76534);
var G__76002_76547 = args__42951__auto___76537;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__75998_76543,G__75999_76544,G__76000_76545,G__76001_76546,G__76002_76547) : schema.core.fn_validator.call(null,G__75998_76543,G__75999_76544,G__76000_76545,G__76001_76546,G__76002_76547));
} else {
var temp__5753__auto___76548 = (function (){var fexpr__76003 = cljs.core.deref(input_checker75994_76534);
return (fexpr__76003.cljs$core$IFn$_invoke$arity$1 ? fexpr__76003.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76537) : fexpr__76003.call(null,args__42951__auto___76537));
})();
if(cljs.core.truth_(temp__5753__auto___76548)){
var error__42952__auto___76550 = temp__5753__auto___76548;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76550], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema75993_76533,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76537,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76550], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__75996;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__76004_76551 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__76005_76552 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__76006_76553 = output_schema75992_76532;
var G__76007_76554 = cljs.core.deref(output_checker75995_76535);
var G__76008_76555 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__76004_76551,G__76005_76552,G__76006_76553,G__76007_76554,G__76008_76555) : schema.core.fn_validator.call(null,G__76004_76551,G__76005_76552,G__76006_76553,G__76007_76554,G__76008_76555));
} else {
var temp__5753__auto___76561 = (function (){var fexpr__76009 = cljs.core.deref(output_checker75995_76535);
return (fexpr__76009.cljs$core$IFn$_invoke$arity$1 ? fexpr__76009.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__76009.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76561)){
var error__42952__auto___76562 = temp__5753__auto___76561;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76562], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema75992_76532,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76562], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema75992_76532,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema75993_76533], null)));

var ufv___76564 = schema.utils.use_fn_validation;
var output_schema76011_76565 = deercreeklabs.baracus.ByteArray;
var input_schema76012_76566 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker76013_76567 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema76012_76566);
}),null));
var output_checker76014_76568 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema76011_76565);
}),null));
var ret__47899__auto___76569 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__76015){
var validate__42950__auto__ = cljs.core.deref(ufv___76564);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___76570 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__76015], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__76016_76571 = new cljs.core.Keyword(null,"input","input",556931961);
var G__76017_76572 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__76018_76573 = input_schema76012_76566;
var G__76019_76574 = cljs.core.deref(input_checker76013_76567);
var G__76020_76575 = args__42951__auto___76570;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__76016_76571,G__76017_76572,G__76018_76573,G__76019_76574,G__76020_76575) : schema.core.fn_validator.call(null,G__76016_76571,G__76017_76572,G__76018_76573,G__76019_76574,G__76020_76575));
} else {
var temp__5753__auto___76580 = (function (){var fexpr__76022 = cljs.core.deref(input_checker76013_76567);
return (fexpr__76022.cljs$core$IFn$_invoke$arity$1 ? fexpr__76022.cljs$core$IFn$_invoke$arity$1(args__42951__auto___76570) : fexpr__76022.call(null,args__42951__auto___76570));
})();
if(cljs.core.truth_(temp__5753__auto___76580)){
var error__42952__auto___76581 = temp__5753__auto___76580;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76581], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema76012_76566,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___76570,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76581], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var ba = G__76015;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__76023_76582 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__76024_76583 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__76025_76584 = output_schema76011_76565;
var G__76026_76585 = cljs.core.deref(output_checker76014_76568);
var G__76027_76586 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__76023_76582,G__76024_76583,G__76025_76584,G__76026_76585,G__76027_76586) : schema.core.fn_validator.call(null,G__76023_76582,G__76024_76583,G__76025_76584,G__76026_76585,G__76027_76586));
} else {
var temp__5753__auto___76587 = (function (){var fexpr__76028 = cljs.core.deref(output_checker76014_76568);
return (fexpr__76028.cljs$core$IFn$_invoke$arity$1 ? fexpr__76028.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__76028.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___76587)){
var error__42952__auto___76593 = temp__5753__auto___76587;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___76593], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema76011_76565,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___76593], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema76011_76565,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema76012_76566], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
