(ns sandpit
  (:require [com.rpl.specter :as spec]
            [kafkian
             [admin :as ka]
             [consumer :as kc]
             [utility-belt :as belt]
             [producer :as kp]]))

(comment


  (def zk-utils  (ka/zk-utils "localhost:2181"))
  (ka/create-topic zk-utils "topic-a")
  (ka/create-topic zk-utils "topic-b" :partitions 3)
  (ka/create-topic zk-utils "topic-c" :partitions 2 :replication-factor 2)
  (ka/create-topic zk-utils "topic-compact" :topic-config {"cleanup.policy" "compact"} )
  (ka/topic-exists? zk-utils "topic-a")
  (ka/delete-topic zk-utils "topic-b")
  (ka/delete-topic zk-utils "topic-unknown")



  (def producer-config {"bootstrap.servers" "localhost:9092"})
  (def prod (kp/producer producer-config (kp/string-serializer) (kp/string-serializer)))

  (kp/partitions prod "topic-a")
  (kp/partitions prod "topic-unknown")

  (defn the-count [prod topic amount]
    (for [num (range 1 (inc amount))]
      (->> (kp/record topic (str "The Count says " num " at "  (java.util.Date.)))
           (kp/send prod)
           (.get))))

  (kp/send prod (kp/record "topic-unknown" "Otra vez y Otra vez. Que pasa!!!") #(println "sent to ->" %))

  (the-count prod "topic-a" 5)
  (the-count prod "topic-b" 15)
  (the-count prod "topic-c" 20)

  (kp/metrics prod)
  (kp/close prod)



  (def consumer-config {"bootstrap.servers" "localhost:9092"
                        "group.id" "consumer-pipe"
                        "auto.offset.reset" "earliest"
                        "enable.auto.commit" "false"
                        "auto.commit.interval.ms" "1000"})

  (def consumer (kc/consumer consumer-config (kc/string-deserializer) (kc/string-deserializer)))

  (def consumer2 (kc/consumer consumer-config (kc/string-deserializer) (kc/string-deserializer)))

  (def consumer3 (kc/consumer consumer-config (kc/string-deserializer) (kc/string-deserializer)))
  (def consumer4 (kc/consumer consumer-config (kc/string-deserializer) (kc/string-deserializer)))


  (kc/subscribe consumer "topic-a")
  (kc/subscribe consumer "topic-b")
  (kc/subscribe consumer "topic-c")
  (kc/subscribe consumer ["topic-a" "topic-b"])
  (kc/subscribe consumer ["topic-a" "topic-b"] :assigned-callback (fn [p] (println "ASSIGNED:" p))
                                               :revoked-callback (fn [p] (println "REVOKED:" p)))
  (kc/subscribe consumer #".+-topic")
  (kc/subscribe consumer [{:topic "topic-a" :partitions #{0}}
                          {:topic "topic-b" :partitions #{0 1}}
                          {:topic "topic-unknown" :partitions #{0}}])

  (kc/messages consumer)
  (kc/messages consumer2)
  (kc/messages consumer :timeout 1500)


  (kc/subscriptions consumer)
  (kc/subscriptions consumer2)
  (kc/subscriptions consumer3)
  (kc/subscriptions consumer4)
  (kc/unsubscribe consumer)
  (kc/unsubscribe consumer2)
  (kc/unsubscribe consumer3)
  (kc/unsubscribe consumer4)

  (.subscription consumer)
  (map kafkian.data/to-clojure (.assignment consumer))

  (def metrics-map (kafkian.data/metrics->map (.metrics consumer)))

  (distinct (map :group metrics-map))
  (distinct (map :name metrics-map))
  (distinct (map :tags metrics-map))
  (filter #(= "consumer-fetch-manager-metrics" (:group %)) metrics-map)
  (filter #(= "node-3" (get-in % [:tags "node-id"]) ) metrics-map)
  (filter #(= {"client-id" "consumer-2"} (:tags %)) metrics-map)
  (filter #(= "consumer-2" (get-in % [:tags "client-id"])) metrics-map)

  (belt/metrics-lens metrics-map)
  (belt/metrics-lens metrics-map :group :ONLY)
  (belt/metrics-lens metrics-map :name :ONLY)
  (belt/metrics-lens metrics-map :tags :ONLY)
  (belt/metrics-lens metrics-map :group "consumer-node-metrics")
  (belt/metrics-lens metrics-map :group "consumer-node-metrics" :name "request-size-avg")
  (belt/metrics-lens metrics-map :group "consumer-node-metrics" :name "request-size-avg" :tags {"client-id" "consumer-1" "node-id" "node-1"})
  (belt/metrics-lens metrics-map :group "consumer-metrics" :name "request-size-avg" :tags {"client-id" "consumer-18"})
  ;; The arguments/keywords will always be processed internally in the order :group :name :tags
  (belt/metrics-lens metrics-map :tags {"client-id" "consumer-1" "node-id" "node-1"} :name "request-size-avg" :group "consumer-node-metrics")
  (belt/metrics-lens metrics-map :group "consumer-node-metrics" :name :ONLY)
  (belt/metrics-lens metrics-map :group "consumer-metrics" :name :ONLY)
  (belt/metrics-lens metrics-map :group "consumer-node-metrics" :name "request-size-avg" :tags :ONLY)
  (belt/metrics-lens metrics-map :group "consumer-metrics" :name "request-size-avg" :tags :ONLY)
  ;;The first ONLY it encounters is where the lens stops
  (belt/metrics-lens metrics-map :group "consumer-node-metrics" :name :ONLY :tags {"client-id" "consumer-1" "node-id" "node-1"})
  ;;The above will only return all the metric names for the metric group \"consumer-node-metrics\",
  ;;the tags key/argument will be ignored.

  (belt/metrics-lens metrics-map :name "request-size-avg" :tags {"client-id" "consumer-2", "node-id" "node-3"})

  (require '[com.rpl.specter :as spec])
  (spec/select [(spec/keypath {:group "consumer-node-metrics"}) (spec/keypath {:name "request-size-avg"}) (spec/keypath {:tags {"client-id" "consumer-2", "node-id" "node-3"}})] metrics-map)

  (spec/select [(spec/keypath {:group "consumer-node-metrics"}) spec/VAL (spec/keypath {:name "request-size-avg"}) (spec/keypath {:tags {"client-id" "consumer-2", "node-id" "node-3"}})] metrics-map)

  (spec/select [spec/ALL (spec/collect-one spec/FIRST) (spec/view second) (spec/collect-one spec/ALL spec/FIRST #(= % {:name "request-size-avg"})) (spec/keypath {:name "request-size-avg"})  (spec/collect-one spec/ALL spec/FIRST #(= % {:tags {"client-id" "consumer-2", "node-id" "node-3"}})) (spec/keypath {:tags {"client-id" "consumer-2", "node-id" "node-3"}})] metrics-map)


  (spec/select [spec/ALL (spec/collect-one spec/FIRST) (spec/view second) (spec/collect-one spec/ALL spec/FIRST #(= % {:name "request-size-avg"})) (spec/keypath {:name "request-size-avg"})  (spec/collect spec/ALL spec/FIRST) (spec/collect spec/ALL (spec/view second)) spec/ALL (spec/view second)] metrics-map)


  (spec/select [spec/ALL (spec/view second) (spec/keypath {:name "request-size-avg"}) spec/ALL (spec/view second)] metrics-map)

  (belt/metrics-lens metrics-map :group "consumer-node-metrics" :name "request-size-avg" :tags {"client-id" "consumer-2" "node-id" "node-3"})
  (clojure.pprint/pp)


  (clojure.pprint/pp)

  (.close consumer)
  (.close consumer2)
  (.close consumer3)
  (.close consumer4)

  (def es
    (doto (java.util.concurrent.Executors/newFixedThreadPool 4)
      (.submit (reify Runnable
                 (run [_] (while true (Thread/sleep 2000) (println "consumer1 consummed ->" (kc/messages consumer))))))
      (.submit (reify Runnable
                 (run [_] (while true (Thread/sleep 2000) (println "consumer2 consummed ->" (kc/messages consumer2))))))
      (.submit (reify Runnable
                 (run [_] (while true (Thread/sleep 2000) (println "consumer3 consummed ->" (kc/messages consumer3))))))
      (.submit (reify Runnable
                 (run [_] (while true (Thread/sleep 2000) (println "consumer4 consummed ->" (kc/messages consumer4))))))
      ))

  (.shutdown es)
  (.shutdownNow es)



  (kc/last-committed-offset consumer {:topic "topic-c" :partition 0})

  (kc/commit-async consumer)
  (kc/commit-async consumer (fn [offsets exception]
                              (if exception
                                (println "Commits failed for " offsets " Exception->" exception)
                                (println "Commits passed for " offsets))))

  (kc/commit-sync consumer)
  (kc/commit-sync consumer {{:topic "topic-a" :partition 0} {:offset 0 :metadata "reset"}})
  (kc/commit-sync consumer {{:topic "topic-b", :partition 0} {:offset 0, :metadata "whoa meta"},
                            {:topic "topic-b", :partition 1} {:offset 0, :metadata "whoa"},
                            {:topic "topic-b", :partition 2} {:offset 0, :metadata "wow"}})

  (kc/list-all-topics consumer)

  (kc/list-all-partitions consumer "topic-a")
  (kc/list-all-partitions consumer "topic-b")

  (kc/pause consumer '({:topic "development" :partition 0}
                       {:topic "development" :partition 1}))

  (kc/resume consumer '({:topic "development" :partition 0}
                        {:topic "development" :partition 1}))

  (kc/seek consumer "topic-a" 0 :beginning)
  (kc/seek consumer "development" 0 60)
  (kc/seek consumer '({:topic "topic-a" :partition 0}
                      {:topic "topic-a" :partition 1}
                      {:topic "topic-a" :partition 2}) :beginning)
  (kc/seek consumer '({:topic "topic-a" :partition 0}
                      {:topic "topic-a" :partition 1}
                      {:topic "topic-a" :partition 2}) :end)
  (kc/seek consumer '({:topic "topic-a" :partition 0}
                      {:topic "topic-a" :partition 1}
                      {:topic "topic-a" :partition 2}) 60)


  ;;maybe browse should create a temporary internal consumer
  ;;(with a group.id not likely to clash like they do with kafka command line tools)
  ;;get messages with this consumer then close it when done (with-open)
  ;;Also provide :messages/:amount :timeout arguments
  ;;Also this function should live in a namespace called utilities/utility-belt
  (belt/browse "topic-b")
  (belt/browse ["topic-a" "topic-b" "topic-c"])
  (belt/browse #"topic-.*")
  (belt/browse [{:topic "topic-a" :partitions #{0}}])
  (belt/browse [{:topic "topic-a" :partitions #{0} :offset :beginning}])
  (belt/browse [{:topic "topic-b" :partitions #{0 1 2} :offset :beginning}])
  (belt/browse [{:topic "topic-a" :partitions #{0} :offset :beginning}
                {:topic "topic-b" :partitions #{0 1 2} :offset :beginning}
                {:topic "topic-c" :partitions #{0 1} :offset :beginning}])
  (belt/browse [{:topic "topic-a" :partitions #{0} :offset :beginning :max-msgs 5}])
  (belt/browse [{:topic "topic-b" :partitions #{0} :offset :beginning :max-msgs 5}
                {:topic "topic-b" :partitions #{1} :offset :beginning :max-msgs 5}
                {:topic "topic-b" :partitions #{2} :offset :beginning :max-msgs 5}])
  (belt/browse [{:topic "topic-c" :partitions #{0} :offset 5 :max-msgs 3}
                {:topic "topic-c" :partitions #{1} :offset 5 :max-msgs 3}])
  (belt/browse [{:topic "topic-a" :partitions #{0} :offset :beginning :max-msgs 5}
                {:topic "topic-b" :partitions #{0 1 2} :offset :beginning :max-msgs 5}
                {:topic "topic-c" :partitions #{0 1} :offset 8}])
  (belt/browse [{:topic "topic-a" :partitions #{0} :offset :beginning :max-msgs 5}
                {:topic "topic-b" :partitions #{0} :offset :beginning :max-msgs 5}
                {:topic "topic-b" :partitions #{1} :offset :beginning :max-msgs 5}
                {:topic "topic-b" :partitions #{2} :offset :beginning :max-msgs 5}
                {:topic "topic-c" :partitions #{0} :offset 8}
                {:topic "topic-c" :partitions #{1} :offset 8}])

                                        ; => {\"topic-a\" [map of messages]}
                                        ;     \"topic-b\" {2 [map of messages]}

  ;; =>{:messages []
  ;;    "topic-a" []
  ;;    "topic-b" []
  ;;    {:topic "topic-a" :partition 0} []
  ;;    {:topic "topic-a" :partition 1} []
  ;;    {:topic "topic-a" :partition 2} []
  ;;    {:topic "topic-b" :partition 0} []
  ;;    {:topic "topic-b" :partition 1} []}

  (clojure.pprint/pp)
  (System/getProperty "java.io.tmpdir")

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  (def m-data {{:group "consumer-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-1"}} {:description "des" :value 87}}}
               {:group "consumer-node-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-2"}} {:description "des" :value 187}
                                                                             {:tags {"client-id" "consumer-2" "node-id" "node-3"}} {:description "des" :value 287}}
                                                 {:name "request-size"} {{:tags {"client-id" "consumer-2"}} {:description "des" :value 387}
                                                                         {:tags {"client-id" "consumer-2" "node-id" "node-3"}} {:description "des" :value 487}}}})

  (metrics-lens m-data :group :ONLY)
  ;; => ["consumer-metrics" "consumer-node-metrics"]

  (metrics-lens m-data :name :ONLY)
  ;; => ["request-size-avg" "request-size"]

  (metrics-lens m-data :tags :ONLY)
  ;; => [{"client-id" "consumer-1"} {"client-id" "consumer-2"} {"client-id" "consumer-2" "node-id" "node-3"}]

  (metrics-lens m-data :group "consumer-metrics" :name :ONLY)
  ;; => ["request-size-avg"]

  (metrics-lens m-data :group "vrddee" :name :ONLY)
  ;; => []

  (metrics-lens m-data :group "consumer-metrics" :name :ONLY :tags :ONLY)
  ;; => ["request-size-avg"]

  (metrics-lens m-data)

  (metrics-lens m-data :group :ANY :name :ANY :tags :ANY)

  (metrics-lens m-data :group :ANY :name "request-size-avg")
  ;; => {{:group "consumer-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-1"}} {:description "des" :value 87}}}
  ;;     {:group "consumer-node-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-2"}} {:description "des" :value 87}
  ;;                                                                   {:tags {"client-id" "consumer-2" "node-id" "node-3"}} {:description "des" :value 87}}}}

  (metrics-lens m-data :group :ANY :name "request-size-avg" :tags :ANY)
  ;; => {{:group "consumer-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-1"}} {:description "des" :value 87}}}
  ;;     {:group "consumer-node-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-2"}} {:description "des" :value 87}
  ;;                                                                   {:tags {"client-id" "consumer-2" "node-id" "node-3"}} {:description "des" :value 87}}}}


  (metrics-lens m-data :group "consumer-node-metrics" :name "request-size-avg" :tags :ANY)
  ;; => {{:group "consumer-node-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-2"}} {:description "des" :value 87}
  ;;                                                                   {:tags {"client-id" "consumer-2" "node-id" "node-3"}} {:description "des" :value 87}}}}

  (metrics-lens m-data :group "consumer-node-metrics" :name "request-size-avg" :tags {"client-id" "consumer-2"})
  ;; => {{:group "consumer-node-metrics"} {{:name "request-size-avg"} {{:tags {"client-id" "consumer-2"}} {:description "des" :value 87}}}}

  (metrics-lens m-data :group "dfefefefes" :name "request-size-avg" :tags {"client-id" "consumer-2"})
  ;; => nil

  (metrics-lens m-data :group "consumer-node-metrics" :name "request-size-avg" :tags {"fefefeklj" "dfefefe"})
  ;; => {}



  (defn extract-map-keys [m-data map-pattern]
    (loop [pattern map-pattern
           result m-data]
      (if (empty? pattern)
        result
        (let [[k v] (first pattern)
              comp-key {k v}]
          (cond
            (= :ONLY v) (reduce #(apply conj %1 (vals %2)) [] (distinct (if (sequential? result)
                                                                          (mapcat keys result)
                                                                          (keys result))))

            (= :ANY v) (recur (rest pattern) (if (sequential? result)
                                               (mapcat vals result)
                                               (vals result)))

            :else (recur (rest pattern) (if (sequential? result)
                                          (mapcat #(get % comp-key) result)
                                          (get result comp-key))))))))

  (defn match-key-map [key-map map-set]
    (let [[k v] (first key-map)
          filter-fn (if (= :ANY v)
                      #(= k (key (first %)))
                      #(= key-map %))]
      (seq (filter filter-fn map-set))))

  (defn match-map-pattern [m-data map-pattern]
    (let [level-keys [{:group :ANY} {:name :ANY} {:tags :ANY}]
          match-keys (mapv #(apply hash-map %) map-pattern)]
      (clojure.walk/postwalk (fn [x]
                               (if (and (map? x) (every? map? (keys x)))
                                 (let [keys-set (into #{} (keys x))
                                       matched-levels (mapcat #(match-key-map % keys-set) level-keys)
                                       matched-keys (mapcat #(match-key-map % keys-set) match-keys)
                                       matched-levels? (seq matched-levels)
                                       matched-keys? (seq matched-keys)]
                                   (if (or matched-levels? matched-keys?)
                                     (if matched-keys?
                                       (let [k-with-vals (filter #(seq (get x %)) matched-keys)]
                                         (apply dissoc x (apply disj keys-set k-with-vals)))
                                       nil)
                                     x))
                                 x))
                             m-data)))

  (defn metrics-lens [m-data & {:keys [group name tags]
                                :or {group :ANY
                                     name :ANY
                                     tags :ANY}}]
    (let [lens-args {:group group :name name :tags tags} ;; ensure entries are in the righ order
          ]
      (if (some #(= :ONLY %) (vals lens-args))
        (extract-map-keys m-data lens-args)
        (match-map-pattern m-data lens-args))))

  (clojure.pprint/pprint m-data)
  (clojure.pprint/pp)

  )
