(ns sandpit
  (:require [kafkian.producer :as kp]
            [kafkian.consumer :as kc]
            [kafkian.admin :as ka]))


(comment


  (def zk-utils  (ka/zk-utils "localhost:2181"))
  (ka/create-topic zk-utils "first-topic")
  (ka/create-topic zk-utils "second-topic" :topic-config {"cleanup.policy" "compact"} )
  (ka/topic-exists? zk-utils "first-topic")
  (ka/delete-topic zk-utils "second-topic")




  (def producer-config {"bootstrap.servers" "localhost:9092"})

  (def prod (kp/producer producer-config (kp/string-serializer) (kp/string-serializer)))



  (kp/partitions prod "development")
  (kp/send prod (kp/record "development" "Meh Meh Meh"))

  (def counter (atom 0))
  @counter
  (->> (kp/record "topic-b" (str "Counter-"(swap! counter inc) " "  (java.util.Date.)))
       (kp/send prod)
       (.get))



  (kp/close prod)


  (def consumer-config {"bootstrap.servers" "localhost:9092"
                        "group.id" "hose-pipe"
                        "auto.offset.reset" "earliest"
                        "enable.auto.commit" "false"
                        "auto.commit.interval.ms" "1000"})

  (with-open [c (kc/consumer consumer-config (kc/string-deserializer) (kc/string-deserializer))]
    (kc/subscribe-to-topics c "topic-a")
    (take 5 (kc/messages c)))


  (def consumer (kc/consumer consumer-config (kc/string-deserializer) (kc/string-deserializer)))

  (count *1)

  (kc/messages consumer)
  (kc/messages consumer :timeout 1500)
  (kc/messages consumer :topic "topic-a")
  (kc/messages consumer :topic "topic-b")
  (kc/messages consumer :topic ["topic-a" "topic-b"])
  (kc/messages consumer :topic #"topic.+")
  (kc/messages consumer :topic "topic-a" :partition 2)
  (kc/messages consumer :topic #"topic." :partition 2)
  (kc/messages consumer :topic "topic-a" :partition 2 :timeout 3000)
  (kc/messages consumer :topic "topic-a" :partition 2 :offset 63)
  (kc/messages consumer :topic "topic-b" :partition 2 :offset :beginning)
  (kc/messages consumer :topic "topic-a" :partition 2 :offset :end)
  (kc/messages consumer :topic "topic-a" :partition 2 :offset :end :timeout 1500)

  (kc/messages consumer :topic #"topic.+" :partition 2)

  (kc/subscribe-to-topics consumer "topic-b" :assigned-callback (fn [p] (println "ASSIGNED:")(doall p))
                          :revoked-callback (fn [p] (println "REVOKED:" (doall p))))
  (kc/subscribe-to-topics consumer "dev")
  (kc/subscribe-to-topics consumer ["d" "dewef"])
  (kc/subscribe-to-topics consumer #"dev.+")


  (kc/subscribed-topics consumer)
  (kc/subscribed-partitions consumer)
  (kc/unsubscribe consumer)

  (.close consumer)

  (def messages  (mapcat identity  (take-while seq (repeatedly #(kc/messages consumer)))))
  (count messages)
  messages
  (clojure.pprint/pprint messages)

  (kc/messages consumer)

  (kc/subscribe-to-partitions consumer {:topic "development" :partition 2}
                              {:topic "development" :partition 1}
                              {:topic "development" :partition 0})

  (kc/last-committed-offset consumer {:topic "development" :partition 0})

  (kc/commit-async consumer)
  (kc/commit-async consumer (fn [offsets exception]
                              (if exception
                                (println "Commits failed for " offsets " Exception->" exception)
                                (println "Commits passed for " offsets))))

  (kc/commit-sync consumer)
  (kc/commit-sync consumer {{:topic "topic-b", :partition 0} {:offset 0, :metadata "whoa meta"},
                            {:topic "topic-b", :partition 1} {:offset 0, :metadata "whoa"},
                            {:topic "topic-b", :partition 2} {:offset 0, :metadata "wow"}})

  (kc/list-all-topics consumer)

  (kc/list-all-partitions consumer "topic-a")

  (kc/pause consumer '({:topic "development" :partition 0}
                       {:topic "development" :partition 1}))

  (kc/resume consumer '({:topic "development" :partition 0}
                        {:topic "development" :partition 1}))

  (kc/seek consumer "development" 0 :beginning)
  (kc/seek consumer "development" 0 60)
  (kc/seek consumer '({:topic "topic-a" :partition 0}
                      {:topic "topic-a" :partition 1}
                      {:topic "topic-a" :partition 2}) :beginning)
  (kc/seek consumer '({:topic "topic-a" :partition 0}
                      {:topic "topic-a" :partition 1}
                      {:topic "topic-a" :partition 2}) :end)
  (kc/seek consumer '({:topic "topic-a" :partition 0}
                      {:topic "topic-a" :partition 1}
                      {:topic "topic-a" :partition 2}) 60)



  (def map-entry  (first  (.entrySet (kc/metrics consumer))))
  (def key-metric-name (.getKey map-entry))
  (def value-metric (.getValue map-entry))
  key-metric-name
  value-metric
  (defn metric-name->clojure [mn]
    {:name (.name mn)
     :description (.description mn)
     :group (.group mn)
     :tags (reduce #(assoc %1 (.getKey %2) (.getValue %2)) {}  (.entrySet (.tags  mn)))})

  (defn metric->clojure [m]
    {:metric-name (metric-name->clojure (.metricName m))
     :value (.value m)})

  (defn metrics->clojure [m]
    (let [metrics-entry-set (.entrySet m)
          reduce-fn (fn [m map-entry]
                      (let [k (.getKey map-entry)
                            v (.getValue map-entry)]
                        (assoc m (metric-name->clojure k) (metric->clojure v))))]
      (reduce reduce-fn {} metrics-entry-set)))

  (defn metrics2->clojure [m]
    (let [metric-values (.values m)
          reduce-fn (fn [v value]
                      (conj v (metric->clojure value)))]
      (reduce reduce-fn [] metric-values)))

  (defn metrics3->clojure [m]
    (let [metrics-entry-set (.entrySet m)
          reduce-fn (fn [m map-entry]
                      (let [k (.getKey map-entry)
                            v (.getValue map-entry)]
                        (assoc m (metric-name->clojure k) (.value v))))]
      (reduce reduce-fn {} metrics-entry-set)))

  (defn metrics4->clojure [m]
    (let [metrics-entry-set (.entrySet m)
          reduce-fn (fn [m map-entry]
                      (let [k (.getKey map-entry)
                            v (.getValue map-entry)]
                        (assoc m (metric-name->clojure k) (.value v))))]
      (reduce reduce-fn {} metrics-entry-set)))

  (metric-name->clojure key-metric-name)
  (metric->clojure value-metric)
  (metrics3->clojure (kc/metrics consumer))

  (clojure.pprint/pprint *1)



  (.close consumer)



  (kc/convert-O (doto (java.util.HashMap.)
                  (.put (org.apache.kafka.common.TopicPartition. "dev" 1) (org.apache.kafka.clients.consumer.OffsetAndMetadata. 234 "rubbish"))
                  (.put (org.apache.kafka.common.TopicPartition. "test" 77) (org.apache.kafka.clients.consumer.OffsetAndMetadata. 34 "extra rubbish"))
                  (.put (org.apache.kafka.common.TopicPartition. "dev" 7) (org.apache.kafka.clients.consumer.OffsetAndMetadata. 23 "rubbish"))
                  (.put (org.apache.kafka.common.TopicPartition. "prod" 4) (org.apache.kafka.clients.consumer.OffsetAndMetadata. 24 "mega rubbish"))))


  (def tp-om   {{:topic "test", :partition 77}
                {:offset 34, :metadata "extra rubbish"},
                {:topic "prod", :partition 4} {:offset 24, :metadata "mega rubbish"},
                {:topic "dev", :partition 1} {:offset 234, :metadata "rubbish"},
                {:topic "dev", :partition 7} {:offset 23, :metadata "rubbish"}})
  (tp-om {:topic "test", :partition 77} )

  (def one (clj-kafka.data/clojure->tp-om-map tp-om))
  (def two (clj-kafka.data/clojure->tp-om-map tp-om))
  (= one two)
  (clj-kafka.data/clojure->tp-om-map tp-om)

  (clj-kafka.data/str-pi-map->clojure )

  (clojure.pprint/pprint *1)

  (vector {:one 1})






  (defn a-symbol []
    (let [fefe (inc 3)]
      (println "f")))

  (list 1 2 3) (vector 1)

  one two three four
  (if r
    (when s
      (let [o (inc 8)]
        f)))

  (hihiiiihhh)

  (one two)

  )
