/*
 * Decompiled with CFR 0.152.
 */
package org.fressian;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.fressian.CachedObject;
import org.fressian.StreamingWriter;
import org.fressian.Writer;
import org.fressian.handlers.ILookup;
import org.fressian.handlers.IWriteHandlerLookup;
import org.fressian.handlers.WriteHandler;
import org.fressian.handlers.WriteHandlerLookup;
import org.fressian.impl.Fns;
import org.fressian.impl.Handlers;
import org.fressian.impl.InterleavedIndexHopMap;
import org.fressian.impl.RawOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FressianWriter
implements StreamingWriter,
Writer,
Closeable {
    private OutputStream out;
    private RawOutput rawOut;
    private InterleavedIndexHopMap priorityCache;
    private InterleavedIndexHopMap structCache;
    private byte[] stringBuffer;
    IWriteHandlerLookup writeHandlerLookup;

    public FressianWriter(OutputStream out) {
        this(out, Handlers.defaultWriteHandlers());
    }

    public FressianWriter(OutputStream out, ILookup<Class, Map<String, WriteHandler>> userHandlers) {
        this.writeHandlerLookup = new WriteHandlerLookup(userHandlers);
        this.clearCaches();
        this.out = out;
        this.rawOut = new RawOutput(this.out);
    }

    @Override
    public Writer writeNull() throws IOException {
        this.writeCode(247);
        return this;
    }

    @Override
    public Writer writeBoolean(boolean b) throws IOException {
        if (b) {
            this.writeCode(245);
        } else {
            this.writeCode(246);
        }
        return this;
    }

    @Override
    public Writer writeBoolean(Object o) throws IOException {
        if (o == null) {
            this.writeNull();
            return this;
        }
        this.writeBoolean((Boolean)o);
        return this;
    }

    @Override
    public Writer writeInt(long i) throws IOException {
        this.internalWriteInt(i);
        return this;
    }

    @Override
    public Writer writeInt(Object o) throws IOException {
        if (o == null) {
            this.writeNull();
            return this;
        }
        this.writeInt(((Number)o).longValue());
        return this;
    }

    @Override
    public Writer writeDouble(double d) throws IOException {
        if (d == 0.0) {
            this.writeCode(251);
        } else if (d == 1.0) {
            this.writeCode(252);
        } else {
            this.writeCode(250);
            this.rawOut.writeRawDouble(d);
        }
        return this;
    }

    @Override
    public Writer writeDouble(Object o) throws IOException {
        this.writeDouble(((Number)o).doubleValue());
        return this;
    }

    @Override
    public Writer writeFloat(float f) throws IOException {
        this.writeCode(249);
        this.rawOut.writeRawFloat(f);
        return this;
    }

    @Override
    public Writer writeFloat(Object o) throws IOException {
        this.writeFloat(((Number)o).floatValue());
        return this;
    }

    @Override
    public Writer writeString(Object o) throws IOException {
        if (o == null) {
            this.writeNull();
            return this;
        }
        CharSequence s = (CharSequence)o;
        int stringPos = 0;
        int bufPos = 0;
        int maxBufNeeded = Math.min(s.length() * 3, 65536);
        if (this.stringBuffer == null || this.stringBuffer.length < maxBufNeeded) {
            this.stringBuffer = new byte[maxBufNeeded];
        }
        do {
            int[] temp = Fns.bufferStringChunkUTF8(s, stringPos, this.stringBuffer);
            stringPos = temp[0];
            bufPos = temp[1];
            if (bufPos < 8) {
                this.rawOut.writeRawByte(218 + bufPos);
            } else if (stringPos == s.length()) {
                this.writeCode(227);
                this.writeCount(bufPos);
            } else {
                this.writeCode(226);
                this.writeCount(bufPos);
            }
            this.rawOut.writeRawBytes(this.stringBuffer, 0, bufPos);
        } while (stringPos < s.length());
        return this;
    }

    private void writeIterator(int length, Iterator it) throws IOException {
        if (length < 8) {
            this.rawOut.writeRawByte(228 + length);
        } else {
            this.writeCode(236);
            this.writeCount(length);
        }
        while (it.hasNext()) {
            this.writeObject(it.next());
        }
    }

    @Override
    public Writer writeList(Object o) throws IOException {
        if (o == null) {
            this.writeNull();
            return this;
        }
        if (o.getClass().isArray()) {
            return this.writeList(Arrays.asList(o));
        }
        Collection c = (Collection)o;
        this.writeIterator(c.size(), c.iterator());
        return this;
    }

    @Override
    public Writer writeBytes(byte[] b) throws IOException {
        if (b == null) {
            this.writeNull();
            return this;
        }
        return this.writeBytes(b, 0, b.length);
    }

    @Override
    public Writer writeBytes(byte[] b, int offset, int length) throws IOException {
        if (length < 8) {
            this.rawOut.writeRawByte(208 + length);
            this.rawOut.writeRawBytes(b, offset, length);
        } else {
            while (length > 65535) {
                this.writeCode(216);
                this.writeCount(65535);
                this.rawOut.writeRawBytes(b, offset, 65535);
                offset += 65535;
                length -= 65535;
            }
            this.writeCode(217);
            this.writeCount(length);
            this.rawOut.writeRawBytes(b, offset, length);
        }
        return this;
    }

    @Override
    public void writeFooterFor(ByteBuffer bb) throws IOException {
        byte[] bytes;
        if (this.rawOut.getBytesWritten() != 0) {
            throw new IllegalStateException("writeFooterFor can only be called at a footer boundary.");
        }
        ByteBuffer source = bb.duplicate();
        if (source.hasArray()) {
            bytes = source.array();
        } else {
            bytes = new byte[source.remaining()];
            source.get(bytes);
        }
        this.rawOut.getChecksum().update(bytes, 0, source.remaining());
        this.internalWriteFooter(source.remaining());
    }

    @Override
    public Writer writeFooter() throws IOException {
        this.internalWriteFooter(this.rawOut.getBytesWritten());
        this.clearCaches();
        return this;
    }

    private void internalWriteFooter(int length) throws IOException {
        this.rawOut.writeRawInt32(-808464433);
        this.rawOut.writeRawInt32(length);
        this.rawOut.writeRawInt32((int)this.rawOut.getChecksum().getValue());
        this.rawOut.reset();
    }

    private void clearCaches() {
        if (this.priorityCache != null && !this.priorityCache.isEmpty()) {
            this.priorityCache.clear();
        }
        if (this.structCache != null && !this.structCache.isEmpty()) {
            this.structCache.clear();
        }
    }

    @Override
    public Writer resetCaches() throws IOException {
        this.writeCode(254);
        this.clearCaches();
        return this;
    }

    public InterleavedIndexHopMap getPriorityCache() {
        if (this.priorityCache == null) {
            this.priorityCache = new InterleavedIndexHopMap(16);
        }
        return this.priorityCache;
    }

    public InterleavedIndexHopMap getStructCache() {
        if (this.structCache == null) {
            this.structCache = new InterleavedIndexHopMap(16);
        }
        return this.structCache;
    }

    @Override
    public Writer writeTag(Object tag, int componentCount) throws IOException {
        Integer shortcutCode = Handlers.tagToCode.get(tag);
        if (shortcutCode != null) {
            this.writeCode(shortcutCode);
        } else {
            int index2 = this.getStructCache().oldIndex(tag);
            if (index2 == -1) {
                this.writeCode(239);
                this.writeObject(tag);
                this.writeInt(componentCount);
            } else if (index2 < 16) {
                this.writeCode(160 + index2);
            } else {
                this.writeCode(240);
                this.writeInt(index2);
            }
        }
        return this;
    }

    public Writer writeExt(Object tag, Object ... fields) throws IOException {
        this.writeTag(tag, fields.length);
        for (int n = 0; n < fields.length; ++n) {
            this.writeObject(fields[n]);
        }
        return this;
    }

    public void writeCount(int count) throws IOException {
        this.writeInt(count);
    }

    private int bitSwitch(long l) {
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return Long.numberOfLeadingZeros(l);
    }

    private void internalWriteInt(long i) throws IOException {
        switch (this.bitSwitch(i)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.writeCode(248);
                this.rawOut.writeRawInt64(i);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.rawOut.writeRawByte((int)(126L + (i >> 48)));
                this.rawOut.writeRawInt48(i);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                this.rawOut.writeRawByte((int)(122L + (i >> 40)));
                this.rawOut.writeRawInt40(i);
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.rawOut.writeRawByte((int)(118L + (i >> 32)));
                this.rawOut.writeRawInt32((int)i);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.rawOut.writeRawByte((int)(114L + (i >> 24)));
                this.rawOut.writeRawInt24((int)i);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                this.rawOut.writeRawByte((int)(104L + (i >> 16)));
                this.rawOut.writeRawInt16((int)i);
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.rawOut.writeRawByte((int)(80L + (i >> 8)));
                this.rawOut.writeRawByte((int)i);
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                if (i < -1L) {
                    this.rawOut.writeRawByte((int)(80L + (i >> 8)));
                }
                this.rawOut.writeRawByte((int)i);
                break;
            }
            default: {
                throw new Error("more than 64 bits in a long!");
            }
        }
    }

    private boolean shouldSkipCache(Object o) {
        if (o == null || o instanceof Boolean) {
            return true;
        }
        if (o instanceof Integer || o instanceof Short || o instanceof Long) {
            switch (this.bitSwitch(((Number)o).longValue())) {
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    return true;
                }
            }
            return false;
        }
        if (o instanceof String) {
            return ((String)o).length() == 0;
        }
        if (o instanceof Double) {
            double d = (Double)o;
            return d == 0.0 || d == 1.0;
        }
        return false;
    }

    private void doWrite(String tag, Object o, WriteHandler w, boolean cache2) throws IOException {
        if (cache2) {
            if (this.shouldSkipCache(o)) {
                this.doWrite(tag, o, w, false);
            } else {
                int index2 = this.getPriorityCache().oldIndex(o);
                if (index2 == -1) {
                    this.writeCode(205);
                    this.doWrite(tag, o, w, false);
                } else if (index2 < 32) {
                    this.writeCode(128 + index2);
                } else {
                    this.writeCode(204);
                    this.writeInt(index2);
                }
            }
        } else {
            w.write(this, o);
        }
    }

    @Override
    public Writer writeAs(String tag, Object o, boolean cache2) throws IOException {
        if (o instanceof CachedObject) {
            o = CachedObject.unwrap(o);
            cache2 = true;
        }
        WriteHandler w = this.writeHandlerLookup.requireWriteHandler(tag, o);
        this.doWrite(tag, o, w, cache2);
        return this;
    }

    @Override
    public Writer writeAs(String tag, Object o) throws IOException {
        return this.writeAs(tag, o, false);
    }

    @Override
    public Writer writeObject(Object o, boolean cache2) throws IOException {
        return this.writeAs(null, o, cache2);
    }

    @Override
    public Writer writeObject(Object o) throws IOException {
        return this.writeAs(null, o);
    }

    public void writeCode(int code) throws IOException {
        this.rawOut.writeRawByte(code);
    }

    @Override
    public void close() throws IOException {
        this.rawOut.close();
    }

    @Override
    public Writer beginClosedList() throws IOException {
        this.writeCode(237);
        return this;
    }

    @Override
    public Writer endList() throws IOException {
        this.writeCode(253);
        return this;
    }

    @Override
    public Writer beginOpenList() throws IOException {
        if (0 != this.rawOut.getBytesWritten()) {
            throw new IllegalStateException("openList must be called from the top level, outside any footer context.");
        }
        this.writeCode(238);
        this.rawOut.reset();
        return this;
    }
}

