/*
 * Decompiled with CFR 0.152.
 */
package datomic;

import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.RT;
import clojure.lang.Var;

public final class rest$index
extends AFunction {
    public static final Var const__0 = RT.var((String)"ring.util.response", (String)"response");

    public Object invoke(Object req) {
        return ((IFn)const__0.getRawRoot()).invoke((Object)"<html>\n<h1 id='datomic_rest_api'>Datomic REST API</h1>\n\n<hr />\n\n<p><strong>Note: This API is ALPHA and subject to change as we get feedback from early users.</strong></p>\n\n<hr />\n\n<h2 id='the_rest_service'>The REST service</h2>\n\n<p>A Datomic peer can be run as a standalone HTTP service using the <code>bin/rest</code> command:</p>\n\n<pre><code>bin/rest port [alias uri]+\n</code></pre>\n\n<p>The URIs are as described in the <a href='http://docs.datomic.com/clojure/index.html#datomic.api/connect'>documentation for connect</a>, with the database name elided, e.g. <code>datomic:mem://</code> or <code>datomic:ddb://dynamodb-table/?aws_access_key_id=XXX&amp;aws_secret_key=YYY</code>. Clients of the REST API will use the supplied storage aliases to talk about the storages, and will be unaware of the connection and location details. </p>\n\n<p>In all documentation below, <code>storage</code> means a storage alias.</p>\n\n<h2 id='the_http_api'>The HTTP API</h2>\n\n<h3 id='general_considerations'>General Considerations</h3>\n\n<p>All data is passed and returned as <a href='http://clojure.org/reader'>Clojure data literals</a>, a subset of which is <a href='http://docs.datomic.com/data-structure-literals.html'>used by Datomic</a>. This includes not only request and response bodies, but also query params, which should be sent as URI-encoded literals.</p>\n\n<p>The semantics of the operations correspond to those of the <a href='http://docs.datomic.com/javadoc/index.html'>Java API</a> and <a href='http://docs.datomic.com/clojure/index.html'>Clojure API</a>.</p>\n\n<p>In lieu of a Connection object, the API uses <code>storage/dbname</code> path segments in the URIs. In lieu of Database objects the API uses database <em>descriptors</em>, which are maps with the following keys:</p>\n\n<pre><code>:db/alias - 'storage/dbname'\n:basis-t - t (optional)\n:as-of - t, tx or instant (optional)\n:since -  t, tx or instant (optional)\n:history - true (optional)\n</code></pre>\n\n<p>Datoms are passed as maps with <code>:e</code>, <code>:a</code>, <code>:v</code>, <code>:tx</code> and <code>:added</code> keys.</p>\n\n<p>URI documentation convention (fixed components are <strong>bold</strong>):</p>\n\n<p><strong>HTTP-METHOD</strong> /<strong>fixed-component</strong>/variable/components</p>\n\n<h2 id='resources'>Resources</h2>\n\n<p><strong>PUT</strong> /<strong>db</strong>/storage/dbname</p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/create-database'>Creates a database</a>. </p>\n\n<p>Returns:</p>\n\n<p>201 if created.</p>\n\n<p>200 if already exists.</p>\n\n<hr />\n\n<p><strong>GET</strong> /<strong>db</strong>/storage/dbname</p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/db'>Get the current database info</a>.</p>\n\n<p>Returns: </p>\n\n<p>200 - a database descriptor, with <code>:db/alias</code> and <code>:basis-t</code> keys</p>\n\n<p>404 - not found</p>\n\n<hr />\n\n<p><strong>POST</strong> /<strong>db</strong>/storage/dbname</p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/transact'>Transact against a database</a>.</p>\n\n<p>The request body should be <a href='http://docs.datomic.com/transactions.html'>transaction data</a>.</p>\n\n<p>Returns:</p>\n\n<p>200 - a map with <code>:db-before</code>, <code>:db-after</code>, <code>:tx-data</code>, and <code>:tempids</code> keys.</p>\n\n<hr />\n\n<p><strong>GET</strong> /<strong>db</strong>/storage/dbname/<strong>datoms</strong>/index</p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/datoms'>Get raw index data</a>.</p>\n\n<p>index is one of <code>eavt</code>, <code>aevt</code>, <code>avet</code> or <code>vaet</code>.</p>\n\n<p>Optional query params:</p>\n\n<ul>\n<li>e=entity-name or id</li>\n<li>a=attribute-name or id</li>\n<li>v=value</li>\n<li>as-of=t, tx or instant</li>\n<li>since=t, tx or instant</li>\n<li>history=true</li>\n<li>offset=nnn</li>\n<li>limit=nnn</li>\n</ul>\n\n<p>Returns:</p>\n\n<p>200 - a vector of datom maps.</p>\n\n<hr />\n\n<p><strong>GET</strong> /<strong>db</strong>/storage/dbname/<strong>range</strong></p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/index-range'>Get a range of index data</a>.</p>\n\n<p>Mandatory query params:</p>\n\n<ul>\n<li>a=attribute-name or id</li>\n</ul>\n\n<p>Optional query params:</p>\n\n<ul>\n<li>start=value</li>\n<li>end=value</li>\n<li>as-of=t, tx or instant</li>\n<li>since=t, tx or instant</li>\n<li>history=true</li>\n<li>offset=nnn</li>\n<li>limit=nnn</li>\n</ul>\n\n<p>Returns:</p>\n\n<p>200 - a vector of datom maps.</p>\n\n<hr />\n\n<p><strong>GET</strong> /<strong>db</strong>/storage/dbname/<strong>entity</strong>[/eid]</p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/entity'>Get an entity</a>.</p>\n\n<p>Mandatory query params (iff eid not in path):</p>\n\n<ul>\n<li>e=entity-name or id</li>\n</ul>\n\n<p>Optional query params:</p>\n\n<ul>\n<li>as-of=t, tx or instant</li>\n<li>since=t, tx or instant</li>\n</ul>\n\n<p>Returns:</p>\n\n<p>200 - An entity map. Nested entities will be returned for component attributes, recursively.</p>\n\n<hr />\n\n<p><strong>GET</strong> /<strong>api</strong>/<strong>query</strong></p>\n\n<p><a href='http://docs.datomic.com/clojure/index.html#datomic.api/q'>Issue a query</a>.</p>\n\n<p>Mandatory query params:</p>\n\n<ul>\n<li>q=query-form</li>\n</ul>\n\n<p>Optional query params:</p>\n\n<ul>\n<li>args=[query arguments vector]</li>\n<li>offset=nnn</li>\n<li>limit=nnn</li>\n</ul>\n\n<p>Databases can be supplied in <code>args</code> using descriptors, e.g. <code>{:db/alias 'mem/test'}</code></p>\n\n<p>Returns:</p>\n\n<p>200 - a vector of query result data.</p>\n\n<hr />\n\n<h2 id='events'>Events</h2>\n\n<p>The REST service can push <a href='http://docs.datomic.com/clojure/index.html#datomic.api/tx-report-queue'>transaction reports</a> using <a href='http://dev.w3.org/html5/eventsource/'>Server-Sent Events</a></p>\n\n<p><strong>GET</strong> /<strong>events</strong>/storage/dbname</p>\n\n<p>Returns:</p>\n\n<p>503 - db does not already exist</p>\n\n<p>200 - leaves connection open, transmits heartbeat newlines and tx reports.</p>\n\n<p>Each message will consist of a map with <code>:db-before</code>, <code>:db-after</code> and <code>:tx-data</code>.</p>\n\n<p>Remember to send the <code>Accept: text/event-stream</code> header:</p>\n\n<pre><code>curl -v -H 'Accept: text/event-stream' http://localhost:8080/events/mem/test\n</code></pre>\n</html>");
    }
}

