/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.util.ArrayList;
import java.util.HashMap;

public final class InterleavedIndexHopMap {
    private int cap;
    private int[] hopidx;
    private Object[] keys;
    private int count;

    public InterleavedIndexHopMap() {
        this(1024);
    }

    public InterleavedIndexHopMap(int capacity) {
        int cap;
        for (cap = 1; cap < capacity; cap <<= 1) {
        }
        this.cap = cap;
        this.hopidx = new int[this.cap << 2];
        this.keys = new Object[this.cap];
        this.count = 0;
    }

    public void clear() {
        this.count = 0;
        for (int n = 0; n < this.cap; ++n) {
            this.keys[n] = null;
        }
        int cap2 = this.cap << 2;
        for (int n = 0; n < cap2; ++n) {
            this.hopidx[n] = 0;
        }
    }

    public int get(Object k) {
        int mask;
        int hash = InterleavedIndexHopMap.hash(k);
        int bkt = hash & (mask = this.cap - 1);
        int bhash = this.hopidx[bkt << 2];
        if (bhash != 0) {
            Object bkey = this.keys[this.hopidx[(bkt << 2) + 1]];
            if (hash == bhash && k.equals(bkey)) {
                return this.hopidx[(bkt << 2) + 1];
            }
            while ((bhash = this.hopidx[(bkt << 2) + 2]) != 0) {
                bkey = this.keys[this.hopidx[(bkt << 2) + 3]];
                if (hash == bhash && k.equals(bkey)) {
                    return this.hopidx[(bkt << 2) + 3];
                }
                bkt = bkt + 1 & mask;
            }
        }
        return -1;
    }

    public int oldIndex(Object k) {
        int countBefore = this.count;
        int index2 = this.intern(k);
        if (countBefore == this.count) {
            return index2;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int intern(Object k) {
        int slot;
        int mask;
        int hash = InterleavedIndexHopMap.hash(k);
        int bkt = hash & (mask = this.cap - 1);
        int bhash = this.hopidx[bkt << 2];
        if (bhash == 0) {
            slot = bkt << 2;
        } else {
            Object bkey;
            if (hash == bhash && k.equals(bkey = this.keys[this.hopidx[(bkt << 2) + 1]])) {
                return this.hopidx[(bkt << 2) + 1];
            }
            while ((bhash = this.hopidx[(bkt << 2) + 2]) != 0) {
                if (hash == bhash && k.equals(bkey = this.keys[this.hopidx[(bkt << 2) + 3]])) {
                    return this.hopidx[(bkt << 2) + 3];
                }
                bkt = bkt + 1 & mask;
            }
            slot = (bkt << 2) + 2;
        }
        int i = this.count++;
        this.hopidx[slot] = hash;
        this.hopidx[slot + 1] = i;
        this.keys[i] = k;
        if (this.count == this.cap) {
            this.resize();
        }
        return i;
    }

    private void resize() {
        int[] oldhops = this.hopidx;
        this.hopidx = new int[this.hopidx.length * 2];
        this.cap <<= 1;
        Object[] oldkeys = this.keys;
        this.keys = new Object[this.cap];
        System.arraycopy(oldkeys, 0, this.keys, 0, oldkeys.length);
        for (int slot = 0; slot < oldhops.length; slot += 2) {
            int newslot = this.findSlot(oldhops[slot]);
            this.hopidx[newslot] = oldhops[slot];
            this.hopidx[newslot + 1] = oldhops[slot + 1];
        }
    }

    private int findSlot(int hash) {
        int slot;
        int mask = this.cap - 1;
        int bkt = hash & mask;
        int bhash = this.hopidx[bkt << 2];
        if (bhash == 0) {
            slot = bkt << 2;
        } else {
            while (this.hopidx[(bkt << 2) + 2] != 0) {
                bkt = bkt + 1 & mask;
            }
            slot = (bkt << 2) + 2;
        }
        return slot;
    }

    private static final int hash(Object key) {
        int h = key.hashCode();
        if (h == 0) {
            h = 42;
        }
        return h;
    }

    static void report(String label, long ns) {
        double msdiv = 1.0E9;
        System.out.println(String.format(label + ": %2.3f", (double)ns / msdiv));
    }

    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        ArrayList<String> stuff = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            stuff.add(Integer.toString(i));
        }
        long start = System.nanoTime();
        InterleavedIndexHopMap hop = new InterleavedIndexHopMap(1024);
        for (int i = 0; i < n; ++i) {
            hop.intern(stuff.get(i));
        }
        long hopadd = System.nanoTime() - start;
        start = System.nanoTime();
        HashMap ht = new HashMap(1024);
        for (int i = 0; i < n; ++i) {
            ht.put(stuff.get(i), i);
        }
        long htadd = System.nanoTime() - start;
        start = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            ht.put(stuff.get(i), i);
        }
        long htadd2 = System.nanoTime() - start;
        start = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            hop.intern(stuff.get(i));
        }
        long hopadd2 = System.nanoTime() - start;
        start = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            Object s = stuff.get(i);
            if (i == ((Number)ht.get(s)).intValue()) continue;
            System.err.println("ht can't find: " + s);
        }
        long htlookup = System.nanoTime() - start;
        start = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            Object s = stuff.get(i);
            if (i == hop.get(s)) continue;
            System.err.println("hop can't find: " + s);
        }
        if (hop.get("foobar") != -1) {
            System.err.println("bad lookup succeeds!");
        }
        long hoplookup = System.nanoTime() - start;
        InterleavedIndexHopMap.report("htadd", htadd);
        InterleavedIndexHopMap.report("hopadd", hopadd);
        InterleavedIndexHopMap.report("htadd2", htadd2);
        InterleavedIndexHopMap.report("hopadd2", hopadd2);
        InterleavedIndexHopMap.report("htlookup", htlookup);
        InterleavedIndexHopMap.report("hoplookup", hoplookup);
    }
}

