/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.composite;

import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.common.CheckTypes;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.OutputTemplates;
import com.epam.jdi.light.common.PageChecks;
import com.epam.jdi.light.common.VisualCheckPage;
import com.epam.jdi.light.driver.ScreenshotMaker;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.base.DriverBase;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.WindowsManager;
import com.epam.jdi.light.elements.composite.Form;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure1;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure11;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure13;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure15;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure17;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure19;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure21;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure23;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure25;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure27;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure29;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure3;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure31;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure33;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure35;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure37;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure39;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure41;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure43;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure45;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure47;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure49;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure5;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure51;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure53;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure7;
import com.epam.jdi.light.elements.composite.WebPage$AjcClosure9;
import com.epam.jdi.light.elements.init.PageFactory;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.elements.pageobjects.annotations.Title;
import com.epam.jdi.light.elements.pageobjects.annotations.Url;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.light.logger.AllureLogger;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.logger.Strategy;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.JsonUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PathUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.switcher.CaseR;
import com.epam.jdi.tools.switcher.SwitchActions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntry;

public class WebPage
extends DriverBase
implements PageObject {
    public String url = "";
    public String title = "";
    public String checkUrl;
    public CheckTypes checkUrlType = CheckTypes.CONTAINS;
    public CheckTypes checkTitleType = CheckTypes.NONE;
    public static PageChecks CHECK_AFTER_OPEN;
    private static Safe<String> currentPage;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;

    static {
        WebPage.ajc$preClinit();
        CHECK_AFTER_OPEN = PageChecks.NONE;
        currentPage = new Safe((Object)"Undefined Page");
    }

    public <T> Form<T> asForm() {
        return new Form().setPageObject(this).setup(Form.class, (JAction1<JDIBase>)((JAction1)e -> {
            DriverBase driverBase = e.setName(String.valueOf(this.getName()) + " Form").setParent(this);
        }));
    }

    public static String getCurrentPage() {
        return (String)currentPage.get();
    }

    public static void setCurrentPage(WebPage page) {
        String newPage;
        String oldPage = (String)currentPage.get();
        if (!oldPage.equals(newPage = page.getName())) {
            JDISettings.PAGE.beforeNewPage.execute((Object)page);
            currentPage.set((Object)newPage);
        }
    }

    public WebPage() {
        PageFactory.initElements((Object)this);
    }

    public WebPage(String url) {
        this.setUrl(url, url, CheckTypes.CONTAINS);
    }

    public WebPage(String url, String title) {
        this(url);
        this.title = title;
    }

    public static void openUrl(String url, String pageName) {
        WebPage page = new WebPage(url);
        page.setName(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageName) ? pageName : "");
        page.open(new Object[0]);
    }

    public static void openUrl(String url) {
        WebSettings.init();
        if (!WebSettings.hasDomain() && url.contains("://")) {
            JDISettings.DRIVER.domain = url;
        }
        new WebPage(url).open(new Object[0]);
    }

    public static void checkUrl(String url) {
        WebSettings.init();
        new WebPage(url).checkOpened();
    }

    @JDIAction
    public static boolean verifyUrl(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WebPage$AjcClosure1 webPage$AjcClosure1 = new WebPage$AjcClosure1(objectArray);
        return Conversions.booleanValue((Object)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure1.linkClosureAndJoinPoint(65536)));
    }

    @JDIAction
    public static boolean verifyTitle(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WebPage$AjcClosure3 webPage$AjcClosure3 = new WebPage$AjcClosure3(objectArray);
        return Conversions.booleanValue((Object)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure3.linkClosureAndJoinPoint(65536)));
    }

    public static void checkTitle(String title) {
        WebSettings.init();
        new WebPage("", title).checkOpened();
    }

    public static void checkPage(String url, String title) {
        WebSettings.init();
        new WebPage(url, title).checkOpened();
    }

    public static void openSite() {
        WebSettings.init();
        new WebPage(WebSettings.getDomain()).open(new Object[0]);
    }

    public static void openSite(Class<?> site) {
        PageFactory.initSite(site);
        WebPage page = new WebPage(WebSettings.getDomain());
        page.setName(site.getSimpleName());
        page.open(new Object[0]);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String getUrl() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure5 webPage$AjcClosure5 = new WebPage$AjcClosure5(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure5.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String getTitle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure7 webPage$AjcClosure7 = new WebPage$AjcClosure7(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure7.linkClosureAndJoinPoint(65536));
    }

    void setUrl(String uri) {
        this.setUrl(uri, "", CheckTypes.CONTAINS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setUrl(String uri, String template, CheckTypes validate) {
        this.url = uri;
        this.checkUrl = template;
        this.checkUrlType = validate;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template)) {
            if (validate == CheckTypes.MATCH) throw Exceptions.exception("In order to validate MATCH for page '%s', please specify 'template' in @Url", this.getName());
            this.checkUrl = uri;
        } else if (validate == null) {
            this.checkUrlType = CheckTypes.MATCH;
        }
        if (!uri.contains("://")) {
            this.url = WebAnnotationsUtil.getUrlFromUri(uri);
            return;
        } else {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)uri)) return;
            this.url = WebSettings.getDomain();
        }
    }

    public void updatePageData(Url urlAnnotation, Title titleAnnotation) {
        if (urlAnnotation != null) {
            this.setUrl(urlAnnotation.value(), urlAnnotation.template(), urlAnnotation.validate());
        } else {
            this.setUrl(WebSettings.getDomain());
        }
        if (titleAnnotation != null) {
            this.title = titleAnnotation.value();
            this.checkTitleType = titleAnnotation.validate();
        }
    }

    public StringCheckType url() {
        return new StringCheckType(() -> ((WebDriver)this.driver()).getCurrentUrl(), this.checkUrl, "url");
    }

    public StringCheckType title() {
        return new StringCheckType(() -> ((WebDriver)this.driver()).getTitle(), this.title, "title");
    }

    @JDIAction(value="Open '{name}'(url={0})", timeout=0)
    private void open(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebPage$AjcClosure9 webPage$AjcClosure9 = new WebPage$AjcClosure9(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public void open(Object ... params) {
        this.open(this.getUrlWithParams(params));
    }

    private String getUrlWithParams(Object ... params) {
        if (params == null || params.length == 0) {
            return this.url;
        }
        if (this.url.contains("%s")) {
            return String.format(this.url, params);
        }
        return this.url.contains("{0}") ? MessageFormat.format(this.url, params) : String.valueOf(this.url) + "?" + PrintUtils.print((Collection)LinqUtils.map((Object[])params, Object::toString), (String)"&");
    }

    @JDIAction(value="Check that '{name}' is opened (url {checkUrlType} '{checkUrl}'; title {checkTitleType} '{title}') in new window")
    public void checkOpenedInNewWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        WebPage$AjcClosure11 webPage$AjcClosure11 = new WebPage$AjcClosure11(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Check that '{name}' is opened (url {checkUrlType} '{checkUrl}'; title {checkTitleType} '{title}')")
    public void checkOpened() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        WebPage$AjcClosure13 webPage$AjcClosure13 = new WebPage$AjcClosure13(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public boolean isOnPage(String url) {
        switch (this.checkUrlType) {
            case NONE: 
            case EQUALS: {
                return url.equals(this.checkUrl);
            }
            case MATCH: {
                return url.matches(this.checkUrl);
            }
            case CONTAINS: {
                return url.contains(this.checkUrl);
            }
        }
        return false;
    }

    @JDIAction(value="Check that '{name}' is opened (url {checkUrlType} '{checkUrl}'; title {checkTitleType} '{title}')")
    public static void visualWindowCheck() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure15 webPage$AjcClosure15 = new WebPage$AjcClosure15(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure15.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public boolean isOpened() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        WebPage$AjcClosure17 webPage$AjcClosure17 = new WebPage$AjcClosure17(objectArray);
        return Conversions.booleanValue((Object)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure17.linkClosureAndJoinPoint(69648)));
    }

    public void shouldBeOpened() {
        this.openedPage(this.url);
    }

    public void shouldBeOpened(Object ... params) {
        this.openedPage(this.getUrlWithParams(params));
    }

    @JDIAction(value="'{name}'(url={0}) should be opened")
    private void openedPage(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebPage$AjcClosure19 webPage$AjcClosure19 = new WebPage$AjcClosure19(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Reload current page", isAssert=true)
    public static void refresh() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure21 webPage$AjcClosure21 = new WebPage$AjcClosure21(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure21.linkClosureAndJoinPoint(65536));
    }

    public static void reload() {
        WebPage.refresh();
    }

    @JDIAction(value="Go back to previous page")
    public static void back() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure23 webPage$AjcClosure23 = new WebPage$AjcClosure23(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure23.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Go forward to next page")
    public static void forward() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure25 webPage$AjcClosure25 = new WebPage$AjcClosure25(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure25.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static void zoom(double factor) {
        double d = factor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{Conversions.doubleObject((double)d), joinPoint};
        WebPage$AjcClosure27 webPage$AjcClosure27 = new WebPage$AjcClosure27(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure27.linkClosureAndJoinPoint(65536));
    }

    @JDIAction
    public static String getHtml() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure29 webPage$AjcClosure29 = new WebPage$AjcClosure29(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure29.linkClosureAndJoinPoint(65536));
    }

    public static List<LogEntry> getHttpRequests() {
        return WebDriverFactory.getDriver().manage().logs().get("performance").getAll();
    }

    @JDIAction(level=LogLevels.DEBUG)
    private static void scroll(int x, int y) {
        int n = x;
        int n2 = y;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WebPage$AjcClosure31 webPage$AjcClosure31 = new WebPage$AjcClosure31(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure31.linkClosureAndJoinPoint(65536));
    }

    public static boolean isBottomOfThePage() {
        return (Boolean)WebDriverFactory.jsExecute("return ((window.innerHeight + window.scrollY) >= document.body.scrollHeight);", new Object[0]);
    }

    public static boolean isTopOfThePage() {
        return (Boolean)WebDriverFactory.jsExecute("return window.scrollX == window.scrollY;", new Object[0]);
    }

    @JDIAction
    public static void scrollToTop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure33 webPage$AjcClosure33 = new WebPage$AjcClosure33(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure33.linkClosureAndJoinPoint(65536));
    }

    @JDIAction
    public static void scrollToBottom() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure35 webPage$AjcClosure35 = new WebPage$AjcClosure35(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure35.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Scroll screen down on '{0}'")
    public static void scrollDown(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
        WebPage$AjcClosure37 webPage$AjcClosure37 = new WebPage$AjcClosure37(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure37.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Scroll screen up on '{0}'")
    public static void scrollUp(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, null, null, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
        WebPage$AjcClosure39 webPage$AjcClosure39 = new WebPage$AjcClosure39(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure39.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Scroll screen to the right on '{0}'")
    public static void scrollRight(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, null, null, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
        WebPage$AjcClosure41 webPage$AjcClosure41 = new WebPage$AjcClosure41(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure41.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Scroll screen to the left on '{0}'")
    public static void scrollLeft(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, null, null, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
        WebPage$AjcClosure43 webPage$AjcClosure43 = new WebPage$AjcClosure43(objectArray);
        ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure43.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static double zoomLevel() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure45 webPage$AjcClosure45 = new WebPage$AjcClosure45(objectArray);
        return Conversions.doubleValue((Object)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure45.linkClosureAndJoinPoint(65536)));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static long xOffset() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure47 webPage$AjcClosure47 = new WebPage$AjcClosure47(objectArray);
        return Conversions.longValue((Object)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure47.linkClosureAndJoinPoint(65536)));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static long yOffset() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure49 webPage$AjcClosure49 = new WebPage$AjcClosure49(objectArray);
        return Conversions.longValue((Object)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure49.linkClosureAndJoinPoint(65536)));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String windowScreenshot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WebPage$AjcClosure51 webPage$AjcClosure51 = new WebPage$AjcClosure51(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure51.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String windowScreenshot(int x, int y, int w, int h, String name) {
        int n = x;
        int n2 = y;
        int n3 = w;
        int n4 = h;
        String string = name;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3), Conversions.intObject((int)n4), string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, null, null, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3), Conversions.intObject((int)n4), string, joinPoint};
        WebPage$AjcClosure53 webPage$AjcClosure53 = new WebPage$AjcClosure53(objectArray2);
        return (String)ActionProcessor.aspectOf().jdiAround(webPage$AjcClosure53.linkClosureAndJoinPoint(65536));
    }

    public String toString() {
        return (String)SwitchActions.Switch((Object)((Object)JDISettings.LOGS.logLevel)).get(new CaseR[]{SwitchActions.Case(l -> l == LogLevels.STEP, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_PAGE_STEP, (Object)this)), SwitchActions.Case(l -> l == LogLevels.INFO, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_PAGE_INFO, (Object)this)), SwitchActions.Default((Object)StringUtils.msgFormat((String)OutputTemplates.PRINT_PAGE_DEBUG, (Object)this))});
    }

    public static void beforeNewPage(WebPage page) {
        if (WebSettings.VISUAL_PAGE_STRATEGY == VisualCheckPage.CHECK_NEW_PAGE) {
            WebPage.visualWindowCheck();
        }
        if (JDISettings.LOGS.screenStrategy.contains((Object)Strategy.NEW_PAGE)) {
            AllureLogger.createAttachment(page.getName(), false);
        }
        WebSettings.logger.toLog("Page '" + page.getName() + "' opened");
        JDISettings.TIMEOUTS.element.set(JDISettings.TIMEOUTS.page.get());
    }

    public static void beforeEachPage(WebPage page) {
        if (JDISettings.PAGE.checkPageOpen != PageChecks.NONE) {
            page.checkOpened();
        }
    }

    static final /* synthetic */ boolean verifyUrl_aroundBody0(String url, JoinPoint joinPoint) {
        WebSettings.init();
        return WebPage.getUrl().contains(url);
    }

    static final /* synthetic */ boolean verifyTitle_aroundBody2(String title, JoinPoint joinPoint) {
        WebSettings.init();
        return WebPage.getTitle().contains(title);
    }

    static final /* synthetic */ String getUrl_aroundBody4(JoinPoint joinPoint) {
        return WebDriverFactory.getDriver().getCurrentUrl();
    }

    static final /* synthetic */ String getTitle_aroundBody6(JoinPoint joinPoint) {
        return WebDriverFactory.getDriver().getTitle();
    }

    static final /* synthetic */ void open_aroundBody8(WebPage ajc$this, String url, JoinPoint joinPoint) {
        WebSettings.init();
        CacheValue.reset();
        ajc$this.driver().navigate().to(url);
        WindowsManager.getWindows();
        WebPage.setCurrentPage(ajc$this);
    }

    static final /* synthetic */ void checkOpenedInNewWindow_aroundBody10(WebPage ajc$this, JoinPoint joinPoint) {
        WindowsManager.checkNewWindowIsOpened();
        ajc$this.checkOpened();
    }

    static final /* synthetic */ void checkOpened_aroundBody12(WebPage ajc$this, JoinPoint joinPoint) {
        if (WebDriverFactory.noRunDrivers()) {
            throw Exceptions.exception("Page '%s' is not opened: Driver is not run", ajc$this.toString());
        }
        String result = (String)SwitchActions.Switch((Object)((Object)ajc$this.checkUrlType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), (Object)""), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> !this.url().check() ? "Url '%s' doesn't equal to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> !this.url().match() ? "Url '%s' doesn't match to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> !this.url().contains() ? "Url '%s' doesn't contains '%s'" : "")});
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result)) {
            throw Exceptions.exception("Page '%s' is not opened: %s", ajc$this.getName(), String.format(result, ajc$this.driver().getCurrentUrl(), ajc$this.checkUrl));
        }
        result = (String)SwitchActions.Switch((Object)((Object)ajc$this.checkTitleType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), (Object)""), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> !this.title().check() ? "Title '%s' doesn't equal to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> !this.title().match() ? "Title '%s' doesn't match to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> !this.title().contains() ? "Title '%s' doesn't contains '%s'" : "")});
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result)) {
            throw Exceptions.exception("Page '%s' is not opened: %s", ajc$this.getName(), String.format(result, ajc$this.driver().getTitle(), ajc$this.title));
        }
        WebPage.setCurrentPage(ajc$this);
        if (WebSettings.VISUAL_PAGE_STRATEGY == VisualCheckPage.CHECK_PAGE) {
            WebPage.visualWindowCheck();
        }
    }

    static final /* synthetic */ void visualWindowCheck_aroundBody14(JoinPoint joinPoint) {
    }

    static final /* synthetic */ boolean isOpened_aroundBody16(WebPage ajc$this, JoinPoint joinPoint) {
        if (WebDriverFactory.noRunDrivers()) {
            return false;
        }
        boolean result = (Boolean)SwitchActions.Switch((Object)((Object)ajc$this.checkUrlType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), t -> true), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> this.url().check()), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> this.url().match()), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> this.url().contains()), SwitchActions.Else((Object)false)});
        if (!result) {
            return false;
        }
        result = (Boolean)SwitchActions.Switch((Object)((Object)ajc$this.checkTitleType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), t -> true), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> this.title().check()), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> this.title().match()), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> this.title().contains()), SwitchActions.Else((Object)false)});
        if (result) {
            WebPage.setCurrentPage(ajc$this);
        }
        return result;
    }

    static final /* synthetic */ void openedPage_aroundBody18(WebPage ajc$this, String url, JoinPoint joinPoint) {
        if (ajc$this.isOpened()) {
            return;
        }
        ajc$this.open(url);
        ajc$this.checkOpened();
    }

    static final /* synthetic */ void refresh_aroundBody20(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().navigate().refresh();
    }

    static final /* synthetic */ void back_aroundBody22(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().navigate().back();
    }

    static final /* synthetic */ void forward_aroundBody24(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().navigate().forward();
    }

    static final /* synthetic */ void zoom_aroundBody26(double factor, JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("document.body.style.transform = 'scale(' + arguments[0] + ')';document.body.style.transformOrigin = '0 0';", factor);
    }

    static final /* synthetic */ String getHtml_aroundBody28(JoinPoint joinPoint) {
        return WebDriverFactory.getDriver().getPageSource();
    }

    static final /* synthetic */ void scroll_aroundBody30(int x, int y, JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("window.scrollBy(" + x + "," + y + ")", new Object[0]);
    }

    static final /* synthetic */ void scrollToTop_aroundBody32(JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("window.scrollTo(0,0)", new Object[0]);
    }

    static final /* synthetic */ void scrollToBottom_aroundBody34(JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("window.scrollTo(0,document.body.scrollHeight)", new Object[0]);
    }

    static final /* synthetic */ void scrollDown_aroundBody36(int value, JoinPoint joinPoint) {
        WebPage.scroll(0, value);
    }

    static final /* synthetic */ void scrollUp_aroundBody38(int value, JoinPoint joinPoint) {
        WebPage.scroll(0, -value);
    }

    static final /* synthetic */ void scrollRight_aroundBody40(int value, JoinPoint joinPoint) {
        WebPage.scroll(value, 0);
    }

    static final /* synthetic */ void scrollLeft_aroundBody42(int value, JoinPoint joinPoint) {
        WebPage.scroll(-value, 0);
    }

    static final /* synthetic */ double zoomLevel_aroundBody44(JoinPoint joinPoint) {
        return JsonUtils.getDouble(WebDriverFactory.jsExecute("return window.devicePixelRatio;", new Object[0]));
    }

    static final /* synthetic */ long xOffset_aroundBody46(JoinPoint joinPoint) {
        return (Long)WebDriverFactory.jsExecute("return window.pageXOffset;", new Object[0]);
    }

    static final /* synthetic */ long yOffset_aroundBody48(JoinPoint joinPoint) {
        return (Long)WebDriverFactory.jsExecute("return window.pageYOffset;", new Object[0]);
    }

    static final /* synthetic */ String windowScreenshot_aroundBody50(JoinPoint joinPoint) {
        try {
            File screenshot = (File)((TakesScreenshot)WebDriverFactory.getDriver()).getScreenshotAs(OutputType.FILE);
            String path = PathUtils.mergePath((String)ScreenshotMaker.getPath(), (String[])new String[]{String.valueOf(WebPage.getCurrentPage()) + ".png"});
            File imageFile = new File(path);
            FileUtils.copyFile((File)screenshot, (File)imageFile);
            return path;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't take screenshot", new Object[0]);
        }
    }

    static final /* synthetic */ String windowScreenshot_aroundBody52(int x, int y, int w, int h, String name, JoinPoint joinPoint) {
        File imageFile;
        String path;
        File screenshot;
        try {
            screenshot = (File)((TakesScreenshot)WebDriverFactory.getDriver()).getScreenshotAs(OutputType.FILE);
            path = PathUtils.mergePath((String)ScreenshotMaker.getPath(), (String[])new String[]{name});
            imageFile = new File(path);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't take windowScreenshot", new Object[0]);
        }
        try {
            BufferedImage fullImg = ImageIO.read(screenshot);
            BufferedImage crop = fullImg.getSubimage(x, y, w, h);
            ImageIO.write((RenderedImage)crop, "png", screenshot);
            FileUtils.copyFile((File)screenshot, (File)imageFile);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't crop windowScreenshot", new Object[0]);
        }
        return path;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebPage.java", WebPage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "verifyUrl", "com.epam.jdi.light.elements.composite.WebPage", "java.lang.String", "url", "", "boolean"), 109);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "verifyTitle", "com.epam.jdi.light.elements.composite.WebPage", "java.lang.String", "title", "", "boolean"), 114);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "refresh", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 313);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "back", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 322);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "forward", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 330);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "zoom", "com.epam.jdi.light.elements.composite.WebPage", "double", "factor", "", "void"), 339);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getHtml", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "java.lang.String"), 349);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "scroll", "com.epam.jdi.light.elements.composite.WebPage", "int:int", "x:y", "", "void"), 362);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "scrollToTop", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 376);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "scrollToBottom", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 384);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "scrollDown", "com.epam.jdi.light.elements.composite.WebPage", "int", "value", "", "void"), 392);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "scrollUp", "com.epam.jdi.light.elements.composite.WebPage", "int", "value", "", "void"), 401);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getUrl", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "java.lang.String"), 141);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "scrollRight", "com.epam.jdi.light.elements.composite.WebPage", "int", "value", "", "void"), 410);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "scrollLeft", "com.epam.jdi.light.elements.composite.WebPage", "int", "value", "", "void"), 419);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "zoomLevel", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "double"), 424);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "xOffset", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "long"), 428);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "yOffset", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "long"), 432);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "windowScreenshot", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "java.lang.String"), 436);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "windowScreenshot", "com.epam.jdi.light.elements.composite.WebPage", "int:int:int:int:java.lang.String", "x:y:w:h:name", "", "java.lang.String"), 447);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getTitle", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "java.lang.String"), 150);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "open", "com.epam.jdi.light.elements.composite.WebPage", "java.lang.String", "url", "", "void"), 194);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkOpenedInNewWindow", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 215);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkOpened", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 223);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "visualWindowCheck", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "void"), 262);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isOpened", "com.epam.jdi.light.elements.composite.WebPage", "", "", "", "boolean"), 269);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "openedPage", "com.epam.jdi.light.elements.composite.WebPage", "java.lang.String", "url", "", "void"), 304);
    }

    public static class StringCheckType {
        private Supplier<String> actual;
        private String equals;
        private String what;

        StringCheckType(Supplier<String> actual, String equals, String what) {
            this.actual = actual;
            this.equals = equals;
            this.what = what;
        }

        public boolean check() {
            String value = this.actual.get();
            return this.equals == null || this.equals.equals("") || value.equals(this.equals);
        }

        public boolean match() {
            String value = this.actual.get();
            return this.equals == null || this.equals.equals("") || value.matches(this.equals);
        }

        public boolean contains() {
            String value = this.actual.get();
            return this.equals == null || this.equals.equals("") || value.contains(this.equals);
        }
    }
}

