/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.asserts.generic.HasAssert;
import com.epam.jdi.light.asserts.generic.table.BaseTableAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.IHasSize;
import com.epam.jdi.light.elements.complex.ISetup;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure1;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure11;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure13;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure15;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure17;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure19;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure21;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure23;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure25;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure27;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure29;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure3;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure31;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure33;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure35;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure37;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure39;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure41;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure43;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure45;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure47;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure5;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure7;
import com.epam.jdi.light.elements.complex.table.BaseTable$AjcClosure9;
import com.epam.jdi.light.elements.complex.table.CacheAll;
import com.epam.jdi.light.elements.complex.table.Column;
import com.epam.jdi.light.elements.complex.table.Line;
import com.epam.jdi.light.elements.complex.table.TableMatcher;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.HasRefresh;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.common.IsText;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.JTable;
import com.epam.jdi.light.elements.pageobjects.annotations.objects.FillFromAnnotationRules;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class BaseTable<T extends BaseTable<?, ?>, A extends BaseTableAssert<?, ?>>
extends UIBaseElement<A>
implements ISetup,
HasValue,
HasAssert<A>,
IHasSize,
IsText,
HasRefresh {
    protected By rowLocator = By.xpath((String)"//tr[%s]/td");
    protected By columnLocator = By.xpath((String)"//tr/td[%s]");
    protected By cellLocator = By.xpath((String)"//tr[{1}]/td[{0}]");
    protected By allCellsLocator = By.cssSelector((String)"td");
    protected By jsRow = By.cssSelector((String)"tr");
    protected By jsColumn = By.cssSelector((String)"td");
    protected By headerLocator = By.cssSelector((String)"th");
    protected By footer = By.cssSelector((String)"tfoot");
    protected By fromCellToRow = By.xpath((String)"../td");
    protected By filterLocator = By.cssSelector((String)"th input[type=search],th input[type=text]");
    protected int rowHeaderIndex = -1;
    protected int firstColumnIndex = -1;
    protected int firstRowIndex = -1;
    protected int[] columnsMapping = new int[0];
    protected String rowHeaderName = "";
    protected CacheAll<MapArray<String, WebList>> rows = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, WebList>> columns = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, MapArray<String, UIElement>>> cells = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, MapArray<String, String>>> cellsValues = new CacheAll(MapArray::new);
    protected CacheValue<Integer> count = new CacheValue(this::getCount);
    protected CacheValue<List<String>> header = new CacheValue(this::getHeader);
    protected CacheValue<List<String>> rowHeader = new CacheValue(this::getRowHeader);
    protected CacheValue<Integer> size = new CacheValue(this::getTableSize);
    public JFunc1<String, String> SIMPLIFY = JDIBase.STRING_SIMPLIFY;
    protected Boolean headerIsRow = null;
    public static JFunc1<String, String> TRIM_VALUE;
    public static JFunc1<String, String> TRIM_PREVIEW;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;

    static {
        BaseTable.ajc$preClinit();
        TRIM_VALUE = el -> el.trim().replaceAll("\n", "\\\\n").replaceAll(" +", " ");
        TRIM_PREVIEW = el -> el.trim().replaceAll("\n", " ").replaceAll(" +", " ");
    }

    protected int getRowHeaderIndex() {
        if (this.rowHeaderIndex == -1 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.rowHeaderName)) {
            int index = LinqUtils.firstIndex(this.header(), h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)this.rowHeaderName)));
            if (index > -1) {
                this.rowHeaderIndex = index + 1;
            } else {
                throw Exceptions.exception("Can't find rowHeader '%s' in 'header' [%s]. Please correct JTable params", this.rowHeaderName, PrintUtils.print(this.header()));
            }
        }
        return this.rowHeaderIndex;
    }

    public void setHeader(List<String> header) {
        this.header.setFinal(header);
    }

    public WebList headerUI() {
        WebList header = UIFactory.$$(this.headerLocator, (Object)this).setName(String.valueOf(this.getName()) + " header");
        if (header.size() == 0) {
            header = this.getRowByIndex(1);
            if (header.size() > 0) {
                this.header.setRule(() -> this.getRowByIndex(1).values());
                this.size.setRule(() -> this.getRowByIndex(1).size());
            } else {
                throw Exceptions.exception("Can't find header using locator '%s'. Please specify JTable.headers locator or set JTable.header list", new Object[0]);
            }
        }
        return header.setName(String.valueOf(this.getName()) + " header");
    }

    public WebList footerUI() {
        WebList footer = UIFactory.$$(this.footer, (Object)this).setName(String.valueOf(this.getName()) + " footer");
        if (footer.size() == 0 && (footer = this.getRowByIndex(1)).size() == 0) {
            throw Exceptions.exception("Can't find footer using locator '%s'. Please specify JTable.footer locator", new Object[0]);
        }
        return footer.setName(String.valueOf(this.getName()) + " header");
    }

    protected List<String> getHeader() {
        return this.headerUI().values();
    }

    @JDIAction(value="Get {name} header")
    public List<String> header() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure1 baseTable$AjcClosure1 = new BaseTable$AjcClosure1(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<String> getRowHeader() {
        int index = this.getRowHeaderIndex();
        return index != -1 ? this.namedHeader(index) : this.namedHeader(1);
    }

    protected List<String> namedHeader(int index) {
        return this.webColumn(index).values();
    }

    public List<String> rowHeader() {
        return (List)this.rowHeader.get();
    }

    protected int getCount() {
        if (((MapArray)this.columns.get()).any()) {
            return ((WebList)((MapArray)this.columns.get()).get((int)0).value).size();
        }
        int rowsCount = UIFactory.$$(WebDriverByUtils.fillByTemplate(this.columnLocator, this.getRowIndex()), (Object)this).getListFast().size();
        return this.headerSameAsFirstRow() ? rowsCount - 1 : rowsCount;
    }

    @JDIAction(value="Get {name} rows count")
    public int count() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure3 baseTable$AjcClosure3 = new BaseTable$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    protected int getTableSize() {
        if (this.header.hasValue()) {
            return ((List)this.header.get()).size();
        }
        WebList header = this.headerUI().noValidation();
        return header.size();
    }

    @Override
    public int size() {
        return (Integer)this.size.get();
    }

    public WebList webRow(int rowNum) {
        this.validateRowIndex(rowNum);
        if (((MapArray)this.rows.get()).has((Object)String.valueOf(rowNum))) {
            return (WebList)((MapArray)this.rows.get()).get((Object)String.valueOf(rowNum));
        }
        WebList result = this.cells.isGotAll() ? new WebList(LinqUtils.select((Collection)((Collection)this.cells.get()), c -> (WebElement)((MapArray)c.value).get((Object)String.valueOf(rowNum)))) : this.getRow(rowNum);
        ((MapArray)this.rows.get()).update((Object)String.valueOf(rowNum), (Object)result);
        return result;
    }

    protected void validateRowIndex(int rowNum) {
        if (rowNum < 1) {
            throw Exceptions.exception("Rows numeration starts from 1 (but requested index is %s)", rowNum);
        }
        if (rowNum > this.count()) {
            boolean gotAll = this.cells.isGotAll();
            ((BaseTableAssert)this.waitFor()).size((Matcher<Integer>)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(rowNum)));
            if (rowNum > this.count()) {
                throw Exceptions.exception("Table has %s rows (but requested index is %s)", this.count(), rowNum);
            }
            if (gotAll) {
                this.cells.clear();
            }
        }
    }

    public WebList webRow(int columnIndex, String rowName) {
        return this.webColumn(columnIndex).get(this.jsRowIndexByName(rowName)).finds(this.fromCellToRow);
    }

    public WebList webRow(String rowName) {
        return this.webRow(this.getRowIndex(), rowName);
    }

    protected int getRowIndex() {
        int headerIndex = this.getRowHeaderIndex();
        return headerIndex == -1 ? 1 : headerIndex;
    }

    public WebList webRow(Enum rowName) {
        return this.webRow(EnumUtils.getEnumValue((Enum)rowName));
    }

    public WebList webColumn(int colNum) {
        this.validateColumnIndex(colNum);
        if (((MapArray)this.columns.get()).has((Object)String.valueOf(colNum))) {
            return (WebList)((MapArray)this.columns.get()).get((Object)String.valueOf(colNum));
        }
        WebList result = this.cells.isGotAll() ? WebList.newList(((MapArray)((MapArray)this.cells.get()).get((Object)String.valueOf(colNum))).values()) : this.getColumn(colNum);
        ((MapArray)this.columns.get()).update((Object)String.valueOf(colNum), (Object)result);
        return result;
    }

    protected List<String> getJSValues(String locator) {
        List values = (List)this.core().js().executeScript("return Array.from(document.querySelectorAll(\"" + locator + "\")).map(el=>el.innerText)", new Object[0]);
        return LinqUtils.map((Collection)values, String::trim);
    }

    public List<String> jsCells() {
        return this.getJSValues(String.format("%s %s", WebDriverByUtils.getByLocator(this.base().getLocator(new Object[0])), WebDriverByUtils.getByLocator(this.jsColumn)));
    }

    public List<String> jsColumn(int columnIndex) {
        return this.getJSValues(String.format("%s %s:nth-child(%s)", WebDriverByUtils.getByLocator(this.base().getLocator(new Object[0])), WebDriverByUtils.getByLocator(this.jsColumn), this.getColumnIndex(columnIndex)));
    }

    public List<String> jsColumn(String columnName) {
        return this.jsColumn(this.getColIndexByName(columnName));
    }

    public List<String> jsRow(int rowIndex) {
        return this.getJSValues(String.format("%s %s:nth-child(%s) %s", WebDriverByUtils.getByLocator(this.base().getLocator(new Object[0])), WebDriverByUtils.getByLocator(this.jsRow), this.getRowIndex(rowIndex), WebDriverByUtils.getByLocator(this.jsColumn)));
    }

    public List<String> jsRow(String rowName) {
        return this.jsRow(this.jsRowIndexByName(rowName));
    }

    public int jsRowIndexByName(String rowName) {
        List<String> rowHeader;
        int index = this.getRowHeaderIndex();
        if (index == -1) {
            index = 1;
        }
        try {
            rowHeader = this.jsColumn(index);
            if (rowHeader.size() == 0) {
                throw new IllegalStateException();
            }
        }
        catch (Exception exception) {
            rowHeader = this.webColumn(index).values();
        }
        int rowIndex = LinqUtils.firstIndex(rowHeader, h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)rowName)));
        if (rowIndex == -1) {
            throw Exceptions.exception("Can't find row '%s'", rowName);
        }
        return rowIndex + 1;
    }

    protected void validateColumnIndex(int colNum) {
        if (colNum < 1) {
            throw Exceptions.exception("Columns numeration starts from 1 (but requested index is %s)", colNum);
        }
        if (colNum > this.size()) {
            throw Exceptions.exception("Table has %s columns (but requested index is %s)", this.size(), colNum);
        }
    }

    public WebList webColumn(String colName) {
        return this.webColumn(this.getColIndexByName(colName));
    }

    public WebList webColumn(Enum colName) {
        return this.webRow(EnumUtils.getEnumValue((Enum)colName));
    }

    protected int getColIndexByName(String colName) {
        int colIndex = LinqUtils.firstIndex((List)((List)this.header.get()), h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)colName)));
        if (colIndex == -1) {
            throw Exceptions.exception("Can't find column '%s'", colName);
        }
        return colIndex + 1;
    }

    public int getRowIndexByName(String rowName) {
        List<String> rowHeader = this.rowHeader();
        int rowIndex = LinqUtils.firstIndex(rowHeader, h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)rowName)));
        if (rowIndex == -1) {
            throw Exceptions.exception("Can't find row '%s'", rowName);
        }
        return rowIndex + 1;
    }

    public UIElement webCell(int colNum, int rowNum) {
        this.validateColumnIndex(colNum);
        this.validateRowIndex(rowNum);
        if (this.cells.isGotAll()) {
            return (UIElement)((MapArray)((MapArray)this.cells.get()).get((Object)String.valueOf(colNum))).get((Object)String.valueOf(rowNum));
        }
        if (((MapArray)this.rows.get()).has((Object)String.valueOf(rowNum))) {
            return ((WebList)((MapArray)this.rows.get()).get((Object)String.valueOf(rowNum))).get(colNum);
        }
        if (((MapArray)this.columns.get()).has((Object)String.valueOf(colNum))) {
            return ((WebList)((MapArray)this.columns.get()).get((Object)String.valueOf(colNum))).get(rowNum);
        }
        if (((MapArray)this.cells.get()).has((Object)String.valueOf(colNum)) && ((MapArray)((MapArray)this.cells.get()).get((Object)String.valueOf(colNum))).has((Object)String.valueOf(rowNum))) {
            return (UIElement)((MapArray)((MapArray)this.cells.get()).get((Object)String.valueOf(colNum))).get((Object)String.valueOf(rowNum));
        }
        UIElement cell = this.getCell(colNum, rowNum);
        ((MapArray)this.cells.get()).update((Object)String.valueOf(colNum), (Object)new MapArray((Object)String.valueOf(rowNum), (Object)cell));
        return cell;
    }

    protected MapArray<String, WebList> getRows() {
        if (this.rows.isGotAll()) {
            return (MapArray)this.rows.get();
        }
        MapArray result = new MapArray();
        int i = 1;
        while (i <= this.count()) {
            result.add((Object)String.valueOf(i), (Object)this.webRow(i));
            ++i;
        }
        this.rows.gotAll();
        return (MapArray)this.rows.set(result);
    }

    protected WebList getRowByIndex(int rowNum) {
        WebList row = UIFactory.$$(WebDriverByUtils.fillByTemplate(this.rowLocator, rowNum), (Object)this);
        row.searchVisible();
        return row;
    }

    public WebList getRow(int rowNum) {
        WebList row = this.getRowByIndex(this.getRowIndex(rowNum));
        return this.firstColumnIndex > 1 || this.columnsMapping.length > 0 ? this.getMappedRow(row) : row;
    }

    protected WebList getMappedRow(WebList row) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        int i = 1;
        while (i <= this.header().size()) {
            result.add(row.get(this.getColumnIndex(i) - 1));
            ++i;
        }
        return new WebList(result);
    }

    protected MapArray<String, WebList> getColumns() {
        if (this.columns.isGotAll()) {
            return (MapArray)this.columns.get();
        }
        MapArray result = new MapArray();
        int i = 1;
        while (i <= this.size()) {
            result.add((Object)String.valueOf(i), (Object)this.webColumn(i));
            ++i;
        }
        this.columns.gotAll();
        return (MapArray)this.columns.set(result);
    }

    protected int getColumnIndex(int index) {
        if (this.firstColumnIndex > 1) {
            return index + this.firstColumnIndex - 1;
        }
        if (this.columnsMapping.length > 0) {
            return this.columnsMapping[index - 1];
        }
        return index;
    }

    public WebList getColumn(int colNum) {
        return UIFactory.$$(WebDriverByUtils.fillByTemplate(this.columnLocator, this.getColumnIndex(colNum)), (Object)this).noValidation();
    }

    public UIElement getCell(int colNum, int rowNum) {
        return UIFactory.$(WebDriverByUtils.fillByMsgTemplate(this.cellLocator, this.getColumnIndex(colNum), this.getRowIndex(rowNum)), (Object)this);
    }

    protected int getRowIndex(int rowNum) {
        if (this.firstRowIndex > 1) {
            return rowNum + this.firstRowIndex - 1;
        }
        if (this.headerIsRow == null) {
            this.headerIsRow = this.headerIsRow();
        }
        return this.headerIsRow != false ? rowNum + 1 : rowNum;
    }

    protected boolean headerIsRow() {
        List firstRow = new ArrayList();
        try {
            firstRow = (List)this.getRowByIndex(1).noWait(WebList::values, WebList.class);
        }
        catch (Exception exception) {}
        if (!firstRow.isEmpty()) {
            if (!LinqUtils.any(this.header(), firstRow::contains)) {
                return false;
            }
        }
        return true;
    }

    protected boolean headerSameAsFirstRow() {
        List firstRow = new ArrayList();
        try {
            firstRow = (List)this.getRowByIndex(1).noWait(WebList::values, WebList.class);
        }
        catch (Exception exception) {}
        if (!firstRow.isEmpty()) {
            if (LinqUtils.any(this.header(), firstRow::contains)) {
                return true;
            }
        }
        return false;
    }

    public WebList filter() {
        return UIFactory.$$(this.filterLocator).setup((JAction1<JDIBase>)((JAction1)b -> {
            b.setParent(this);
            b.setName(String.valueOf(this.getName()) + " filter");
        }));
    }

    public UIElement filterBy(String filterName) {
        return this.searchBy(filterName);
    }

    @JDIAction(value="Filter {name} by column {0}")
    public UIElement searchBy(String filterName) {
        String string = filterName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        BaseTable$AjcClosure5 baseTable$AjcClosure5 = new BaseTable$AjcClosure5(objectArray);
        return (UIElement)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public Line row(TableMatcher ... matchers) {
        TableMatcher[] tableMatcherArray = matchers;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)tableMatcherArray);
        Object[] objectArray = new Object[]{this, tableMatcherArray, joinPoint};
        BaseTable$AjcClosure7 baseTable$AjcClosure7 = new BaseTable$AjcClosure7(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get all '{name}' table rows that match criteria")
    public List<Line> rows(TableMatcher ... matchers) {
        TableMatcher[] tableMatcherArray = matchers;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)tableMatcherArray);
        Object[] objectArray = new Object[]{this, tableMatcherArray, joinPoint};
        BaseTable$AjcClosure9 baseTable$AjcClosure9 = new BaseTable$AjcClosure9(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    @JDIAction(value="Is '{name}' table empty")
    public boolean isEmpty() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure11 baseTable$AjcClosure11 = new BaseTable$AjcClosure11(objectArray);
        return Conversions.booleanValue((Object)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure11.linkClosureAndJoinPoint(69648)));
    }

    @Override
    @JDIAction(value="Is '{name}' table not empty")
    public boolean isNotEmpty() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure13 baseTable$AjcClosure13 = new BaseTable$AjcClosure13(objectArray);
        return Conversions.booleanValue((Object)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure13.linkClosureAndJoinPoint(69648)));
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public Line row(int rowNum) {
        int n = rowNum;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        BaseTable$AjcClosure15 baseTable$AjcClosure15 = new BaseTable$AjcClosure15(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public Line row(String rowName) {
        String string = rowName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        BaseTable$AjcClosure17 baseTable$AjcClosure17 = new BaseTable$AjcClosure17(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    public Line row(Enum rowName) {
        return this.row(EnumUtils.getEnumValue((Enum)rowName));
    }

    @JDIAction(value="Get all '{name}' rows")
    public List<Line> rows() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure19 baseTable$AjcClosure19 = new BaseTable$AjcClosure19(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get all '{name}' rows")
    public List<Line> rowsImages() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure21 baseTable$AjcClosure21 = new BaseTable$AjcClosure21(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    private Line toLineSaveImages(Pair<String, WebList> row) {
        Line line = new Line(this.header(), (WebList)row.value);
        line.saveCellsImages();
        return line;
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria in column '{1}'")
    public List<Line> filterRows(Matcher<String> matcher, Column column) {
        Matcher<String> matcher2 = matcher;
        Column column2 = column;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, matcher2, (Object)((Object)column2));
        Object[] objectArray = new Object[]{this, matcher2, column2, joinPoint};
        BaseTable$AjcClosure23 baseTable$AjcClosure23 = new BaseTable$AjcClosure23(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure23.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria")
    public List<Line> filterRows(Pair<Matcher<String>, Column> ... matchers) {
        Pair<Matcher<String>, Column>[] pairArray = matchers;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, pairArray);
        Object[] objectArray = new Object[]{this, pairArray, joinPoint};
        BaseTable$AjcClosure25 baseTable$AjcClosure25 = new BaseTable$AjcClosure25(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure25.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get '{name}' table row that match criteria in column '{1}'")
    public Line row(Matcher<String> matcher, Column column) {
        Matcher<String> matcher2 = matcher;
        Column column2 = column;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, matcher2, (Object)((Object)column2));
        Object[] objectArray = new Object[]{this, matcher2, column2, joinPoint};
        BaseTable$AjcClosure27 baseTable$AjcClosure27 = new BaseTable$AjcClosure27(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure27.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get '{name}' table row that match criteria")
    public Line row(Pair<Matcher<String>, Column> ... matchers) {
        Pair<Matcher<String>, Column>[] pairArray = matchers;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, pairArray);
        Object[] objectArray = new Object[]{this, pairArray, joinPoint};
        BaseTable$AjcClosure29 baseTable$AjcClosure29 = new BaseTable$AjcClosure29(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure29.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get column '{0}' of '{name}' table")
    public Line column(int colNum) {
        int n = colNum;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        BaseTable$AjcClosure31 baseTable$AjcClosure31 = new BaseTable$AjcClosure31(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure31.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get column '{0}' of '{name}' table")
    public Line column(String colName) {
        String string = colName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        BaseTable$AjcClosure33 baseTable$AjcClosure33 = new BaseTable$AjcClosure33(objectArray);
        return (Line)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure33.linkClosureAndJoinPoint(69648));
    }

    public Line column(Enum colName) {
        return this.column(EnumUtils.getEnumValue((Enum)colName));
    }

    @JDIAction(value="Get all '{name}' columns")
    public List<Line> columns() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure35 baseTable$AjcClosure35 = new BaseTable$AjcClosure35(objectArray);
        return (List)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure35.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(int colNum, int rowNum) {
        int n = colNum;
        int n2 = rowNum;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        BaseTable$AjcClosure37 baseTable$AjcClosure37 = new BaseTable$AjcClosure37(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure37.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(String colName, int rowNum) {
        String string = colName;
        int n = rowNum;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, string, Conversions.intObject((int)n), joinPoint};
        BaseTable$AjcClosure39 baseTable$AjcClosure39 = new BaseTable$AjcClosure39(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure39.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(int colNum, String rowName) {
        int n = colNum;
        String string = rowName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)string);
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), string, joinPoint};
        BaseTable$AjcClosure41 baseTable$AjcClosure41 = new BaseTable$AjcClosure41(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure41.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(String colName, String rowName) {
        String string = colName;
        String string2 = rowName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        BaseTable$AjcClosure43 baseTable$AjcClosure43 = new BaseTable$AjcClosure43(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure43.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Preview '{name}' table")
    public String preview() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure45 baseTable$AjcClosure45 = new BaseTable$AjcClosure45(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure45.linkClosureAndJoinPoint(69648));
    }

    @Override
    @JDIAction(value="Get '{name}' table value")
    public String getValue() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        BaseTable$AjcClosure47 baseTable$AjcClosure47 = new BaseTable$AjcClosure47(objectArray);
        return (String)ActionProcessor.aspectOf().jdiAround(baseTable$AjcClosure47.linkClosureAndJoinPoint(69648));
    }

    protected MapArray<String, String> getLineMap(Line row) {
        return new MapArray(this.header(), (Collection)row);
    }

    @Override
    public void setup(Field field) {
        if (!FillFromAnnotationRules.fieldHasAnnotation(field, JTable.class, BaseTable.class)) {
            return;
        }
        JTable j = field.getAnnotation(JTable.class);
        String rowHeader = j.rowHeader();
        List<String> header = Arrays.asList(j.header());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)j.root())) {
            this.core().setLocator(WebDriverByUtils.defineLocator(j.root()));
        }
        if (!j.row().equals("//tr[%s]/td") || !WebDriverByUtils.getByLocator(this.rowLocator).equals("//tr[%s]/td")) {
            this.rowLocator = WebDriverByUtils.defineLocator(j.row());
        }
        if (!j.column().equals("//tr/td[%s]") || !WebDriverByUtils.getByLocator(this.columnLocator).equals("//tr/td[%s]")) {
            this.columnLocator = WebDriverByUtils.defineLocator(j.column());
        }
        if (!j.cell().equals("//tr[{1}]/td[{0}]") || !WebDriverByUtils.getByLocator(this.cellLocator).equals("//tr[{1}]/td[{0}]")) {
            this.cellLocator = WebDriverByUtils.defineLocator(j.cell());
        }
        if (!j.allCells().equals("td") || !WebDriverByUtils.getByLocator(this.allCellsLocator).equals("td")) {
            this.allCellsLocator = WebDriverByUtils.defineLocator(j.allCells());
        }
        if (!j.headers().equals("th") || !WebDriverByUtils.getByLocator(this.headerLocator).equals("th")) {
            this.headerLocator = WebDriverByUtils.defineLocator(j.headers());
        }
        if (!j.filter().equals("th input[type=search],th input[type=text]") || !WebDriverByUtils.getByLocator(this.filterLocator).equals("th input[type=search],th input[type=text]")) {
            this.filterLocator = WebDriverByUtils.defineLocator(j.filter());
        }
        if (!j.fromCellToRow().equals("../td") || !WebDriverByUtils.getByLocator(this.fromCellToRow).equals("../td")) {
            this.fromCellToRow = WebDriverByUtils.defineLocator(j.fromCellToRow());
        }
        if (!j.footer().equals("tfoot") || !WebDriverByUtils.getByLocator(this.fromCellToRow).equals("tfoot")) {
            this.footer = WebDriverByUtils.defineLocator(j.footer());
        }
        if (!j.jsRow().equals("tr") || !WebDriverByUtils.getByLocator(this.jsRow).equals("tr")) {
            this.jsRow = WebDriverByUtils.defineLocator(j.jsRow());
        }
        if (!j.jsColumn().equals("td") || !WebDriverByUtils.getByLocator(this.jsColumn).equals("td")) {
            this.jsColumn = WebDriverByUtils.defineLocator(j.jsColumn());
        }
        if (header.size() > 0) {
            this.header.setFinal(header);
        }
        if (j.columnsMapping().length > 0) {
            this.columnsMapping = j.columnsMapping();
        }
        if (j.size() != -1) {
            this.size.setFinal((Object)j.size());
        }
        if (j.count() != -1) {
            this.count.setFinal((Object)j.count());
        }
        if (j.firstColumnIndex() != -1) {
            this.firstColumnIndex = j.firstColumnIndex();
        }
        if (j.firstColumnIndex() != -1) {
            this.firstRowIndex = j.firstColumnIndex();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rowHeader)) {
            this.rowHeaderName = rowHeader;
        }
    }

    public T getTableJs() {
        try {
            List<String> listOfCells = this.jsCells();
            this.cellsValues.set(new MapArray());
            int k = 0;
            int j = 1;
            while (k < listOfCells.size()) {
                MapArray newRow = new MapArray();
                int i = 1;
                while (i <= this.size()) {
                    newRow.add((Object)String.valueOf(i), (Object)listOfCells.get(k++));
                    ++i;
                }
                ((MapArray)this.cellsValues.get()).update((Object)String.valueOf(j), (Object)newRow);
                ++j;
            }
            this.cellsValues.gotAll();
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get all cells", new Object[0]);
        }
        return (T)this;
    }

    protected T getTable() {
        if (!this.cells.isGotAll()) {
            try {
                List<WebElement> listOfCells = UIFactory.$$(this.allCellsLocator, (Object)this).core().noValidation().getAllElements(new Object[0]);
                this.cells.set(new MapArray());
                int k = 0;
                int j = 1;
                int i = 1;
                while (i <= this.size()) {
                    ((MapArray)this.cells.get()).update((Object)String.valueOf(i), (Object)new MapArray());
                    ++i;
                }
                while (k < listOfCells.size()) {
                    i = 1;
                    while (i <= this.size()) {
                        ((MapArray)((MapArray)this.cells.get()).get((Object)String.valueOf(i))).update((Object)String.valueOf(j), (Object)new UIElement(listOfCells.get(k++)));
                        ++i;
                    }
                    ++j;
                }
                this.cells.gotAll();
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't get all cells", new Object[0]);
            }
        }
        return (T)this;
    }

    public void clear() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.rows.clear();
        this.columns.clear();
        this.cells.clear();
        this.count.clear();
        this.size.clear();
        this.header.clear();
        this.rowHeader.clear();
    }

    @Override
    public void offCache() {
        this.rows.useCache(false);
        this.columns.useCache(false);
        this.cells.useCache(false);
        this.count.useCache(false);
        this.size.useCache(false);
        this.header.useCache(false);
        this.rowHeader.useCache(false);
    }

    static final /* synthetic */ List header_aroundBody0(BaseTable ajc$this, JoinPoint joinPoint) {
        return (List)ajc$this.header.get();
    }

    static final /* synthetic */ int count_aroundBody2(BaseTable ajc$this, JoinPoint joinPoint) {
        return (Integer)ajc$this.count.get();
    }

    static final /* synthetic */ UIElement searchBy_aroundBody4(BaseTable ajc$this, String filterName, JoinPoint joinPoint) {
        int index = ajc$this.header().indexOf(filterName);
        return ajc$this.filter().get(index + 1);
    }

    static final /* synthetic */ Line row_aroundBody6(BaseTable ajc$this, TableMatcher[] matchers, JoinPoint joinPoint) {
        WebList lines = (WebList)TableMatcher.TABLE_MATCHER.execute((Object)ajc$this, (Object)matchers);
        if (lines == null || lines.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 1;
        while (i <= ajc$this.header().size()) {
            result.add(lines.get(i).getText());
            ++i;
        }
        return Line.initLine(result, ajc$this.header());
    }

    static final /* synthetic */ List rows_aroundBody8(BaseTable ajc$this, TableMatcher[] matchers, JoinPoint joinPoint) {
        List<String> lines = ((WebList)TableMatcher.TABLE_MATCHER.execute((Object)ajc$this, (Object)matchers)).values();
        if (lines == null || lines.size() < ajc$this.header().size()) {
            return null;
        }
        ArrayList<Line> listOfLines = new ArrayList<Line>();
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line);
            if (result.size() != ajc$this.header().size()) continue;
            listOfLines.add(Line.initLine(result, ajc$this.header()));
            result.clear();
        }
        return listOfLines;
    }

    static final /* synthetic */ boolean isEmpty_aroundBody10(BaseTable ajc$this, JoinPoint joinPoint) {
        try {
            return ajc$this.count() == 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    static final /* synthetic */ boolean isNotEmpty_aroundBody12(BaseTable ajc$this, JoinPoint joinPoint) {
        try {
            return ajc$this.count() != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static final /* synthetic */ Line row_aroundBody14(BaseTable ajc$this, int rowNum, JoinPoint joinPoint) {
        return new Line(ajc$this.header(), ajc$this.webRow(rowNum));
    }

    static final /* synthetic */ Line row_aroundBody16(BaseTable ajc$this, String rowName, JoinPoint joinPoint) {
        return new Line(ajc$this.header(), ajc$this.webRow(rowName));
    }

    static final /* synthetic */ List rows_aroundBody18(BaseTable ajc$this, JoinPoint joinPoint) {
        return LinqUtils.map(ajc$this.getRows(), row -> new Line(this.header(), (WebList)row.value));
    }

    static final /* synthetic */ List rowsImages_aroundBody20(BaseTable ajc$this, JoinPoint joinPoint) {
        MapArray<String, WebList> rows = ajc$this.getRows();
        return LinqUtils.map(rows, ajc$this::toLineSaveImages);
    }

    static final /* synthetic */ List filterRows_aroundBody22(BaseTable ajc$this, Matcher matcher, Column column, JoinPoint joinPoint) {
        return LinqUtils.filter(ajc$this.rows(), line -> matcher.matches(line.get(column.getIndex(this.header()))));
    }

    static final /* synthetic */ List filterRows_aroundBody24(BaseTable ajc$this, Pair[] matchers, JoinPoint joinPoint) {
        return LinqUtils.filter(ajc$this.rows(), line -> LinqUtils.all((Object[])matchers, m -> ((Matcher)m.key).matches(line.get(((Column)((Object)((Object)((Object)m.value)))).getIndex(this.header())))));
    }

    static final /* synthetic */ Line row_aroundBody26(BaseTable ajc$this, Matcher matcher, Column column, JoinPoint joinPoint) {
        return (Line)LinqUtils.first(ajc$this.rows(), line -> matcher.matches(line.get(column.getIndex(this.header()))));
    }

    static final /* synthetic */ Line row_aroundBody28(BaseTable ajc$this, Pair[] matchers, JoinPoint joinPoint) {
        return (Line)LinqUtils.first(ajc$this.rows(), line -> LinqUtils.all((Object[])matchers, m -> ((Matcher)m.key).matches(line.get(((Column)((Object)((Object)((Object)m.value)))).getIndex(this.header())))));
    }

    static final /* synthetic */ Line column_aroundBody30(BaseTable ajc$this, int colNum, JoinPoint joinPoint) {
        return new Line(ajc$this.rowHeader(), ajc$this.webColumn(colNum));
    }

    static final /* synthetic */ Line column_aroundBody32(BaseTable ajc$this, String colName, JoinPoint joinPoint) {
        return new Line(ajc$this.rowHeader(), ajc$this.webColumn(colName));
    }

    static final /* synthetic */ List columns_aroundBody34(BaseTable ajc$this, JoinPoint joinPoint) {
        return LinqUtils.map(ajc$this.getColumns(), row -> new Line(this.rowHeader(), (WebList)row.value));
    }

    static final /* synthetic */ String cell_aroundBody36(BaseTable ajc$this, int colNum, int rowNum, JoinPoint joinPoint) {
        return ajc$this.webCell(colNum, rowNum).getText();
    }

    static final /* synthetic */ String cell_aroundBody38(BaseTable ajc$this, String colName, int rowNum, JoinPoint joinPoint) {
        return ajc$this.cell(ajc$this.getColIndexByName(colName), rowNum);
    }

    static final /* synthetic */ String cell_aroundBody40(BaseTable ajc$this, int colNum, String rowName, JoinPoint joinPoint) {
        ajc$this.validateColumnIndex(colNum);
        return ajc$this.webRow(rowName).get(colNum).getText();
    }

    static final /* synthetic */ String cell_aroundBody42(BaseTable ajc$this, String colName, String rowName, JoinPoint joinPoint) {
        return ajc$this.cell(ajc$this.getColIndexByName(colName), rowName);
    }

    static final /* synthetic */ String preview_aroundBody44(BaseTable ajc$this, JoinPoint joinPoint) {
        return (String)TRIM_PREVIEW.execute((Object)ajc$this.core().getText());
    }

    static final /* synthetic */ String getValue_aroundBody46(BaseTable ajc$this, JoinPoint joinPoint) {
        ajc$this.getTableJs();
        String value = "||X||" + PrintUtils.print((Collection)((Collection)ajc$this.header.get()), (String)"|") + "||" + StringUtils.LINE_BREAK;
        int i = 1;
        while (i <= ajc$this.count()) {
            List row = ((MapArray)((MapArray)ajc$this.cellsValues.get()).get((Object)String.valueOf(i))).values();
            value = String.valueOf(value) + "||" + i + "||" + PrintUtils.print((Collection)LinqUtils.map((Collection)row, arg_0 -> TRIM_VALUE.execute(arg_0)), (String)"|") + "||" + StringUtils.LINE_BREAK;
            ++i;
        }
        return value;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BaseTable.java", BaseTable.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "header", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "java.util.List"), 133);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "count", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "int"), 161);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowsImages", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "java.util.List"), 481);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterRows", "com.epam.jdi.light.elements.complex.table.BaseTable", "org.hamcrest.Matcher:com.epam.jdi.light.elements.complex.table.Column", "matcher:column", "", "java.util.List"), 498);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "filterRows", "com.epam.jdi.light.elements.complex.table.BaseTable", "[Lcom.epam.jdi.tools.pairs.Pair;", "matchers", "", "java.util.List"), 509);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "row", "com.epam.jdi.light.elements.complex.table.BaseTable", "org.hamcrest.Matcher:com.epam.jdi.light.elements.complex.table.Column", "matcher:column", "", "com.epam.jdi.light.elements.complex.table.Line"), 521);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "row", "com.epam.jdi.light.elements.complex.table.BaseTable", "[Lcom.epam.jdi.tools.pairs.Pair;", "matchers", "", "com.epam.jdi.light.elements.complex.table.Line"), 532);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "column", "com.epam.jdi.light.elements.complex.table.BaseTable", "int", "colNum", "", "com.epam.jdi.light.elements.complex.table.Line"), 543);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "column", "com.epam.jdi.light.elements.complex.table.BaseTable", "java.lang.String", "colName", "", "com.epam.jdi.light.elements.complex.table.Line"), 552);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "columns", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "java.util.List"), 564);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cell", "com.epam.jdi.light.elements.complex.table.BaseTable", "int:int", "colNum:rowNum", "", "java.lang.String"), 575);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cell", "com.epam.jdi.light.elements.complex.table.BaseTable", "java.lang.String:int", "colName:rowNum", "", "java.lang.String"), 586);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchBy", "com.epam.jdi.light.elements.complex.table.BaseTable", "java.lang.String", "filterName", "", "com.epam.jdi.light.elements.common.UIElement"), 375);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cell", "com.epam.jdi.light.elements.complex.table.BaseTable", "int:java.lang.String", "colNum:rowName", "", "java.lang.String"), 597);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cell", "com.epam.jdi.light.elements.complex.table.BaseTable", "java.lang.String:java.lang.String", "colName:rowName", "", "java.lang.String"), 609);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preview", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "java.lang.String"), 622);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "java.lang.String"), 631);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "row", "com.epam.jdi.light.elements.complex.table.BaseTable", "[Lcom.epam.jdi.light.elements.complex.table.TableMatcher;", "matchers", "", "com.epam.jdi.light.elements.complex.table.Line"), 386);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "rows", "com.epam.jdi.light.elements.complex.table.BaseTable", "[Lcom.epam.jdi.light.elements.complex.table.TableMatcher;", "matchers", "", "java.util.List"), 402);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEmpty", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "boolean"), 423);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNotEmpty", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "boolean"), 436);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "row", "com.epam.jdi.light.elements.complex.table.BaseTable", "int", "rowNum", "", "com.epam.jdi.light.elements.complex.table.Line"), 451);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "row", "com.epam.jdi.light.elements.complex.table.BaseTable", "java.lang.String", "rowName", "", "com.epam.jdi.light.elements.complex.table.Line"), 461);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rows", "com.epam.jdi.light.elements.complex.table.BaseTable", "", "", "", "java.util.List"), 473);
    }
}

