/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.elements.complex.IHasSize;
import com.epam.jdi.light.elements.interfaces.base.HasRefresh;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc1;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public interface IList<T>
extends IBaseElement,
List<T>,
HasValue,
IHasSize,
HasRefresh {
    public List<T> elements(int var1);

    public T get(String var1);

    default public T get(Enum<?> name) {
        return this.get(EnumUtils.getEnumValue(name));
    }

    default public T last() {
        return (T)LinqUtils.last(this.elements(1));
    }

    default public T first() {
        return this.get(0);
    }

    default public List<T> where(JFunc1<T, Boolean> condition) {
        return LinqUtils.where(this.elements(0), condition);
    }

    default public List<T> filter(JFunc1<T, Boolean> condition) {
        return this.where(condition);
    }

    default public <R> List<R> select(JFunc1<T, R> transform) {
        return LinqUtils.select(this.elements(0), arg_0 -> transform.execute(arg_0));
    }

    default public <R> List<R> map(JFunc1<T, R> transform) {
        return this.select(transform);
    }

    default public T first(JFunc1<T, Boolean> condition) {
        return (T)LinqUtils.first(this.elements(1), condition);
    }

    default public T last(JFunc1<T, Boolean> condition) {
        return (T)LinqUtils.last(this.elements(1), condition);
    }

    default public void ifDo(JFunc1<T, Boolean> condition, JAction1<T> action) {
        LinqUtils.ifDo(this.elements(1), condition, action);
    }

    default public <R> List<R> ifSelect(JFunc1<T, Boolean> condition, JFunc1<T, R> transform) {
        return LinqUtils.ifSelect(this.elements(1), condition, transform);
    }

    default public void foreach(JAction1<T> action) {
        LinqUtils.foreach(this.elements(1), action);
    }

    default public boolean hasAny(JFunc1<T, Boolean> condition) {
        return LinqUtils.any(this.elements(0), condition);
    }

    default public boolean all(JFunc1<T, Boolean> condition) {
        return LinqUtils.all(this.elements(0), condition);
    }

    default public List<T> slice(int from, int to) {
        return LinqUtils.listCopy(this.elements(to), (int)from, (int)to);
    }

    default public List<T> slice(int from) {
        return LinqUtils.listCopy(this.elements(from), (int)from);
    }

    default public List<T> sliceTo(int to) {
        return LinqUtils.listCopyUntil(this.elements(to), (int)to);
    }

    @Override
    default public void refresh() {
        this.clear();
    }

    default public <R> List<R> selectMany(JFunc1<T, List<R>> func) {
        return LinqUtils.selectMany(this.elements(0), func);
    }

    @Override
    default public int size() {
        try {
            return (Integer)this.base().noWait(() -> this.base().getList(0).size());
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Get size failed", new Object[0]);
        }
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean contains(Object o) {
        return this.elements(0).contains(o);
    }

    @Override
    default public Iterator<T> iterator() {
        return this.elements(0).iterator();
    }

    @Override
    default public Object[] toArray() {
        return this.elements(0).toArray();
    }

    @Override
    default public <T1> T1[] toArray(T1[] a) {
        return this.elements(0).toArray(a);
    }

    @Override
    default public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        return this.elements(c.size()).containsAll(c);
    }

    @Override
    default public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public T get(int index) {
        return this.elements(index + 1 - JDISettings.ELEMENT.startIndex).get(index);
    }

    @Override
    default public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public T remove(int index) {
        return this.elements(index + 1 - JDISettings.ELEMENT.startIndex).remove(index);
    }

    @Override
    default public int indexOf(Object o) {
        return this.elements(0).indexOf(o);
    }

    @Override
    default public int lastIndexOf(Object o) {
        return this.elements(0).lastIndexOf(o);
    }

    @Override
    default public ListIterator<T> listIterator() {
        return this.elements(0).listIterator();
    }

    @Override
    default public ListIterator<T> listIterator(int index) {
        return this.elements(0).listIterator(index);
    }

    @Override
    default public List<T> subList(int fromIndex, int toIndex) {
        return this.slice(fromIndex, toIndex);
    }
}

