/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.get.DriverInfo;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.driver.get.DriverVersion;
import com.epam.jdi.light.driver.get.Platform;
import com.epam.jdi.light.settings.WebSettings;
import io.github.bonigarcia.wdm.WebDriverManager;

public class DownloadDriverManager {
    static WebDriverManager wdm;
    public static boolean driverDownloaded;
    public static String downloadedDriverInfo;
    public static String driverPath;

    static {
        driverDownloaded = false;
    }

    private static boolean hasVersion(String version) {
        char c = version.charAt(0);
        return c >= '0' && c <= '9';
    }

    static String downloadDriver(DriverTypes driverType, Platform platform, String version) {
        try {
            String driverName = driverType.toString();
            switch (driverType) {
                case CHROME: {
                    wdm = WebDriverManager.chromedriver();
                    break;
                }
                case FIREFOX: {
                    wdm = WebDriverManager.firefoxdriver();
                    break;
                }
                case IE: {
                    wdm = WebDriverManager.iedriver();
                    break;
                }
                case EDGE: {
                    wdm = WebDriverManager.edgedriver();
                    break;
                }
                case OPERA: {
                    wdm = WebDriverManager.operadriver();
                    break;
                }
                default: {
                    throw Exceptions.exception("%s driver not supported for download", new Object[0]);
                }
            }
            switch (platform) {
                case X32: {
                    wdm = wdm.arch32();
                    break;
                }
                case X64: {
                    wdm = wdm.arch64();
                }
            }
            driverName = String.valueOf(driverName) + " " + (Object)((Object)platform);
            if (DownloadDriverManager.hasVersion(version)) {
                wdm = wdm.browserVersion(version);
                driverName = String.valueOf(driverName) + " " + version;
            }
            if (version.equalsIgnoreCase(DriverVersion.PENULT.value)) {
                wdm.setup();
                wdm.browserVersion(DriverInfo.getBelowVersion());
            }
            wdm.setup();
            WebSettings.logger.info("Download driver: '" + driverName + "' successfully", new Object[0]);
            driverDownloaded = true;
            downloadedDriverInfo = String.format("%s:%s:%s", new Object[]{driverType, platform, version});
            driverPath = wdm.getDownloadedDriverPath();
            return wdm.getDownloadedDriverPath();
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't download latest driver for " + (Object)((Object)driverType), new Object[0]);
        }
    }
}

