/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.Safe;

public class Timeout {
    private int INITIAL;
    private Safe<Integer> DEFAULT;
    public Safe<Integer> current;
    private Safe<Integer> freeze;

    public Timeout(int timeoutSec) {
        this.INITIAL = timeoutSec;
        this.DEFAULT = new Safe((Object)timeoutSec);
        this.current = new Safe((Object)timeoutSec);
        this.freeze = new Safe((Object)0);
    }

    public int get() {
        int result = (Integer)this.current.get();
        this.reset();
        return result;
    }

    public void freeze() {
        this.freeze.update(v -> v + 1);
    }

    public void unfreeze() {
        if ((Integer)this.freeze.get() > 0) {
            this.freeze.update(v -> v - 1);
        }
        this.reset();
    }

    public void setUp(int seconds) {
        this.DEFAULT.set((Object)seconds);
        this.current.set((Object)seconds);
        WebSettings.logger.debug("Setup timeout " + seconds + " seconds", new Object[0]);
    }

    public void set(int seconds) {
        if ((Integer)this.freeze.get() > 0) {
            return;
        }
        if ((Integer)this.freeze.get() < 0) {
            throw Exceptions.exception("Timeout freeze broken", new Object[0]);
        }
        this.current.set((Object)seconds);
        WebSettings.logger.debug("Set timeout " + seconds + " seconds", new Object[0]);
    }

    public void reset() {
        if ((Integer)this.freeze.get() > 0) {
            return;
        }
        if ((Integer)this.freeze.get() < 0) {
            throw Exceptions.exception("Timeout freeze broken", new Object[0]);
        }
        this.current.set((Object)((Integer)this.DEFAULT.get()));
    }

    public void drop() {
        this.freeze.set((Object)0);
        this.current.set((Object)this.INITIAL);
        this.DEFAULT.set((Object)this.INITIAL);
    }
}

