/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.settings;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.common.ElementArea;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.NameToLocator;
import com.epam.jdi.light.common.PageChecks;
import com.epam.jdi.light.common.SearchStrategies;
import com.epam.jdi.light.common.SetTextTypes;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.common.Timeout;
import com.epam.jdi.light.common.UseSmartSearch;
import com.epam.jdi.light.common.VisualCheckAction;
import com.epam.jdi.light.common.VisualCheckPage;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.driver.get.RemoteDriver;
import com.epam.jdi.light.driver.sauce.SauceSettings;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.logger.HighlightStrategy;
import com.epam.jdi.light.logger.ILogger;
import com.epam.jdi.light.logger.JDILogger;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.logger.Strategy;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.LogInfoDetails;
import com.epam.jdi.light.settings.Strategies;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PathUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.PropReader;
import com.epam.jdi.tools.PropertyReader;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.pairs.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebSettings {
    public static ILogger logger = JDILogger.instance("JDI");
    public static VisualCheckAction VISUAL_ACTION_STRATEGY = VisualCheckAction.NONE;
    public static VisualCheckPage VISUAL_PAGE_STRATEGY = VisualCheckPage.NONE;
    public static boolean STRICT_SEARCH = true;
    public static String TEST_GROUP = "";
    public static Safe<String> TEST_NAME = new Safe((Object)null);
    public static JFunc1<IBaseElement, WebElement> SMART_SEARCH = el -> {
        switch (JDISettings.ELEMENT.useSmartSearch) {
            case FALSE: {
                return null;
            }
            case ONLY_UI: {
                if (!el.base().locator.isNull()) break;
                return null;
            }
            case UI_AND_ELEMENTS: {
                if (!el.base().locator.isNull() || !ReflectionUtils.isInterface(el.getClass(), PageObject.class)) break;
                return null;
            }
        }
        String locatorName = (String)((JFunc1)JDISettings.ELEMENT.smartName.value).execute((Object)el.getName());
        return (WebElement)el.base().timer().getResult(() -> {
            String locator = String.format(JDISettings.ELEMENT.smartTemplate, locatorName);
            UIElement ui = (JDISettings.ELEMENT.smartTemplate.equals("#%s") ? UIFactory.$(locator) : UIFactory.$(locator, el.base().parent)).setup((JAction1<JDIBase>)((JAction1)e -> e.setName(el.getName()).noWait()));
            try {
                return ui.getWebElement();
            }
            catch (Exception ignore) {
                throw Exceptions.exception("Element '%s' has no locator and Smart Search failed (%s). Please add locator to element or be sure that element can be found using Smart Search", el.getName(), WebSettings.printSmartLocators(el));
            }
        });
    };
    public static boolean initialized = false;

    public static String getDomain() {
        if (JDISettings.DRIVER.domain != null) {
            return JDISettings.DRIVER.domain;
        }
        WebSettings.init();
        return "No Domain Found. Use test.properties or JDISettings.DRIVER.domain";
    }

    public static void setDomain(String domain) {
        logger.debug("DRIVER.domain = " + domain, new Object[0]);
        JDISettings.DRIVER.domain = domain;
    }

    public static boolean hasDomain() {
        WebSettings.init();
        return JDISettings.DRIVER.domain != null && JDISettings.DRIVER.domain.contains("://");
    }

    public static String useDriver(JFunc<WebDriver> driver) {
        return WebDriverFactory.useDriver(driver);
    }

    public static String useDriver(String driverName) {
        return WebDriverFactory.useDriver(driverName);
    }

    public static String useDriver(DriverTypes driverType) {
        return WebDriverFactory.useDriver(driverType);
    }

    public static String printSmartLocators(IBaseElement el) {
        try {
            return "smart: " + String.format(JDISettings.ELEMENT.smartTemplate, ((JFunc1)JDISettings.ELEMENT.smartName.value).execute((Object)el.getName()));
        }
        catch (Exception ex) {
            return String.format("Can't define smart locator(%s, %s)", JDISettings.ELEMENT.smartTemplate, JDISettings.ELEMENT.smartName.key);
        }
    }

    private static void fillAction(JAction1<String> action, String name) {
        String prop = null;
        try {
            prop = PropertyReader.getProperty((String)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("fillAction(%s=%s)", name, prop == null ? "null" : prop);
        if (StringUtils.isBlank((CharSequence)prop)) {
            return;
        }
        action.execute((Object)prop);
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        logger.debug("init()", new Object[0]);
        try {
            Properties properties = WebSettings.getProperties(JDISettings.COMMON.testPropertiesPath);
            if (properties.isEmpty()) {
                JDISettings.LOGS.writeToAllure = !WebSettings.getProperties("allure.properties").isEmpty();
                JDISettings.COMMON.strategy.action.execute();
                return;
            }
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.COMMON.strategy = WebSettings.getStrategy(p);
            }), "strategy");
            JDISettings.COMMON.strategy.action.execute();
            if (JDISettings.DRIVER.name.equalsIgnoreCase("chrome")) {
                WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                    JDISettings.DRIVER.name = p;
                }), "driver");
            }
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.version = p;
            }), "driver.version");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.path = p;
            }), "drivers.folder");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.path = p;
            }), "drivers.path");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.TIMEOUTS.element = new Timeout(Integer.parseInt(p));
            }), "timeout.wait.element");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.TIMEOUTS.page = new Timeout(Integer.parseInt(p));
            }), "timeout.wait.page");
            WebSettings.fillAction((JAction1<String>)((JAction1)WebSettings::setDomain), "domain");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.SCREEN.path = p;
            }), "screens.folder");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.SCREEN.tool = p;
            }), "screenshot.tool");
            if (JDISettings.SCREEN.tool.equals("robot")) {
                JDISettings.SCREEN.allowRobot = true;
            }
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.SCREEN.allowRobot = Boolean.parseBoolean(p);
            }), "allow.robot");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.startIndex = Integer.parseInt(p);
            }), "list.start.index");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.LOGS.logInfoDetails = WebSettings.getInfoDetailsLevel(p);
            }), "log.info.details");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.LOGS.screenStrategy = WebSettings.getActionStrategy(p);
            }), "screenshot.strategy");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.LOGS.htmlCodeStrategy = WebSettings.getActionStrategy(p);
            }), "html.code.strategy");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.LOGS.requestsStrategy = WebSettings.getActionStrategy(p);
            }), "requests.strategy");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.COMMON.killBrowser = p;
            }), "browser.kill");
            WebSettings.fillAction((JAction1<String>)((JAction1)WebSettings::setSearchStrategy), "element.search.strategy");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> JDISettings.DRIVER.screenSize.read((String)p)), "browser.size");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.pageLoadStrategy = WebSettings.getPageLoadStrategy(p);
            }), "page.load.strategy");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.PAGE.checkPageOpen = PageChecks.parse(p);
            }), "page.check.after.open");
            WebSettings.fillAction((JAction1<String>)((JAction1)SoftAssert::setAssertType), "assert.type");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.clickType = WebSettings.getClickType(p);
            }), "click.type");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.getTextType = WebSettings.getTextType(p);
            }), "text.type");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.setTextType = WebSettings.getSetTextType(p);
            }), "set.text.type");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.remoteUrl = WebSettings.getRemoteUrl(p);
            }), "remote.type");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.remoteUrl = p;
            }), "driver.remote.url");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.DRIVER.remoteRun = Boolean.parseBoolean(p);
            }), "driver.remote.run");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.LOGS.logLevel = LogLevels.parseLogLevel(p);
            }), "log.level");
            logger.setLogLevel(JDISettings.LOGS.logLevel);
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.LOGS.writeToAllure = Boolean.parseBoolean(p);
            }), "allure.steps");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.smartTemplate = p.split(";")[0];
            }), "smart.locator");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.smartName = WebSettings.getSmartSearchFunc(p);
            }), "smart.locator.to.name");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.useSmartSearch = WebSettings.getSmartSearchUse(p);
            }), "smart.search");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                JDISettings.ELEMENT.highlight = WebSettings.getHighlightStrategy(p);
            }), "element.highlight");
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> JDISettings.DRIVER.capabilities.common.put("headless", (String)p)), "headless");
            WebSettings.loadCapabilities("chrome.capabilities.path", "chrome.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.chrome.put(key.toString(), value.toString())))));
            WebSettings.loadCapabilities("ff.capabilities.path", "ff.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.firefox.put(key.toString(), value.toString())))));
            WebSettings.loadCapabilities("ie.capabilities.path", "ie.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.ie.put(key.toString(), value.toString())))));
            WebSettings.loadCapabilities("edge.capabilities.path", "edge.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.ieEdge.put(key.toString(), value.toString())))));
            WebSettings.loadCapabilities("opera.capabilities.path", "opera.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.opera.put(key.toString(), value.toString())))));
            WebSettings.loadCapabilities("safari.capabilities.path", "safari.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.safari.put(key.toString(), value.toString())))));
            WebSettings.loadCapabilities("common.capabilities.path", "common.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> JDISettings.DRIVER.capabilities.common.put(key.toString(), value.toString())))));
            WebDriverFactory.INIT_THREAD_ID = Thread.currentThread().getId();
            initialized = true;
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Failed to init test.properties", new Object[0]);
        }
    }

    private static ElementArea getClickType(String type) {
        ElementArea clickType = (ElementArea)((Object)LinqUtils.first((Collection)EnumUtils.getAllEnumValues(ElementArea.class), t -> t.toString().trim().replaceAll("[^a-z]", "").equalsIgnoreCase(type.trim().replaceAll("[^a-z]", ""))));
        return clickType != null ? clickType : ElementArea.CENTER;
    }

    private static boolean getBoolean(String param) {
        String lowerParams = param.toLowerCase();
        return !lowerParams.equals("off") && !lowerParams.equals("false");
    }

    private static TextTypes getTextType(String type) {
        TextTypes textType = (TextTypes)((Object)LinqUtils.first((Collection)EnumUtils.getAllEnumValues(TextTypes.class), t -> t.toString().trim().replaceAll("[^a-z]", "").equalsIgnoreCase(type.trim().replaceAll("[^a-z]", ""))));
        return textType != null ? textType : TextTypes.SMART_TEXT;
    }

    private static SetTextTypes getSetTextType(String type) {
        SetTextTypes setTextType = (SetTextTypes)((Object)LinqUtils.first((Collection)EnumUtils.getAllEnumValues(SetTextTypes.class), t -> t.toString().trim().replaceAll("[^a-z]", "").equalsIgnoreCase(type.trim().replaceAll("[^a-z]", ""))));
        return setTextType != null ? setTextType : SetTextTypes.CLEAR_SEND_KEYS;
    }

    private static String getRemoteUrl(String prop) {
        String value;
        switch (value = prop.toLowerCase().trim().replaceAll("[^a-z]", "")) {
            case "sauce": 
            case "saucelabs": {
                JDISettings.DRIVER.capabilities.common = SauceSettings.sauceCapabilities();
                return RemoteDriver.sauceLabs();
            }
            case "browserstack": {
                return RemoteDriver.browserstack();
            }
        }
        return RemoteDriver.seleniumLocalhost();
    }

    private static Pair<String, JFunc1<String, String>> getSmartSearchFunc(String name) {
        if (!NameToLocator.SMART_MAP_NAME_TO_LOCATOR.keys().contains(name)) {
            throw Exceptions.exception("Unknown JDISettings.ELEMENT.smartName: '%s'. Please correct value 'smart.locator.to.name' in test.properties.Available names: [%s]", name, PrintUtils.print((Collection)NameToLocator.SMART_MAP_NAME_TO_LOCATOR.keys()));
        }
        return Pair.$((Object)name, (Object)((JFunc1)NameToLocator.SMART_MAP_NAME_TO_LOCATOR.get((Object)name)));
    }

    private static UseSmartSearch getSmartSearchUse(String prop) {
        String value;
        switch (value = prop.toLowerCase().trim().replaceAll("[^a-z]", "")) {
            case "false": 
            case "off": {
                return UseSmartSearch.FALSE;
            }
            case "onlyui": {
                return UseSmartSearch.ONLY_UI;
            }
            case "uiandelements": {
                return UseSmartSearch.UI_AND_ELEMENTS;
            }
            case "always": {
                return UseSmartSearch.ALWAYS;
            }
        }
        return UseSmartSearch.UI_AND_ELEMENTS;
    }

    public static void loadCapabilities(String property, String defaultPath, JAction1<Properties> setCapabilities) {
        Properties properties;
        String path = "";
        try {
            path = System.getProperty(property, PropertyReader.getProperty((String)property));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = defaultPath;
        }
        if ((properties = new PropReader(path).getProperties()).isEmpty()) {
            return;
        }
        try {
            setCapabilities.execute((Object)properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setSearchStrategy(String p) {
        if ((p = p.toLowerCase()).equals("soft")) {
            p = "any, multiple";
        }
        if (p.equals("strict")) {
            p = "visible, single";
        }
        if (p.split(",").length == 2) {
            List<String> params = Arrays.asList(p.split(","));
            if (params.contains("visible") || params.contains("displayed")) {
                SearchStrategies.onlyVisible();
            }
            if (params.contains("any") || params.contains("all")) {
                SearchStrategies.noValidation();
            }
            if (params.contains("enabled")) {
                SearchStrategies.visibleEnabled();
            }
            if (params.contains("inview")) {
                SearchStrategies.inView();
            }
            if (params.contains("single")) {
                STRICT_SEARCH = true;
            }
            if (params.contains("multiple")) {
                STRICT_SEARCH = false;
            }
        }
    }

    private static PageLoadStrategy getPageLoadStrategy(String strategy) {
        switch (strategy.toLowerCase()) {
            case "normal": {
                return PageLoadStrategy.NORMAL;
            }
            case "none": {
                return PageLoadStrategy.NONE;
            }
            case "eager": {
                return PageLoadStrategy.EAGER;
            }
        }
        return PageLoadStrategy.NORMAL;
    }

    private static Properties getProperties(String path) {
        Properties properties;
        File propertyFile = new File(path);
        if (propertyFile.exists()) {
            properties = WebSettings.getCiProperties(path, propertyFile);
        } else {
            Properties pTest = PropertyReader.getProperties((String)PathUtils.mergePath((String)path, (String[])new String[0]));
            Properties pTarget = PropertyReader.getProperties((String)PathUtils.mergePath((String)("/../../target/classes/" + path), (String[])new String[0]));
            if (pTarget.size() > 0) {
                return pTarget;
            }
            String propertiesPath = pTest.size() > 0 ? path : PathUtils.mergePath((String)("/../../target/classes/" + path), (String[])new String[0]);
            properties = PropertyReader.getProperties((String)propertiesPath);
        }
        return properties;
    }

    private static Properties getCiProperties(String path, File propertyFile) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertyFile));
            System.out.println("Property file found: " + propertyFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw Exceptions.exception("Couldn't load properties for CI Server" + path, new Object[0]);
        }
        return properties;
    }

    private static LogInfoDetails getInfoDetailsLevel(String option) {
        switch (option.toLowerCase()) {
            case "none": {
                return LogInfoDetails.NONE;
            }
            case "name": {
                return LogInfoDetails.NAME;
            }
            case "locator": {
                return LogInfoDetails.LOCATOR;
            }
            case "context": {
                return LogInfoDetails.CONTEXT;
            }
            case "element": {
                return LogInfoDetails.ELEMENT;
            }
        }
        return LogInfoDetails.ELEMENT;
    }

    private static List<Strategy> getActionStrategy(String strategy) {
        if (StringUtils.isBlank((CharSequence)strategy)) {
            return Arrays.asList(Strategy.FAIL);
        }
        if (strategy.trim().equalsIgnoreCase("off")) {
            return new ArrayList<Strategy>();
        }
        if (strategy.trim().equalsIgnoreCase("flow")) {
            return LinqUtils.list((Object[])new Strategy[]{Strategy.NEW_PAGE, Strategy.FAIL, Strategy.ASSERT});
        }
        List<Strategy> strategies = new ArrayList<Strategy>();
        try {
            Object[] split = strategy.split("\\|");
            strategies = LinqUtils.map((Object[])split, s -> Strategy.parseStrategy(s.trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strategies;
    }

    private static List<HighlightStrategy> getHighlightStrategy(String strategy) {
        if (StringUtils.isBlank((CharSequence)strategy) || strategy.trim().equalsIgnoreCase("off")) {
            return new ArrayList<HighlightStrategy>();
        }
        if (strategy.trim().equalsIgnoreCase("flow")) {
            return LinqUtils.list((Object[])new HighlightStrategy[]{HighlightStrategy.FAIL, HighlightStrategy.ACTION, HighlightStrategy.ASSERT});
        }
        List<HighlightStrategy> strategies = new ArrayList<HighlightStrategy>();
        try {
            Object[] split = strategy.split("\\|");
            strategies = LinqUtils.map((Object[])split, s -> HighlightStrategy.parseStrategy(s.trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strategies;
    }

    private static Strategies getStrategy(String prop) {
        String strategy;
        switch (strategy = prop.trim().toLowerCase().replaceAll("[^a-z]", "")) {
            case "jdi": {
                return Strategies.JDI;
            }
            case "jdismart": {
                return Strategies.JDI_SMART;
            }
            case "selenium": {
                return Strategies.SELENIUM;
            }
        }
        return Strategies.JDI;
    }
}

